# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import argparse
import logging

import dateutil.parser
import yenv

from travel.library.python.rasp_vault.api import get_secret
from travel.rasp.bus.scripts.sales_monitor import SalesMonitor


if __name__ == '__main__':
    logging.basicConfig(level=logging.INFO)

    parser = argparse.ArgumentParser(description='SalesMonitor CLI')
    parser.add_argument('--suppliers', help='list of suppliers, all if empty')
    parser.add_argument('--token', help='solomon token', default='sec-01cjvsaf2hrdkfdr97c30dv3t4.solomon-token')
    parser.add_argument('--check-datetime', help='custom time to check in UTC', type=dateutil.parser.parse)
    parser.add_argument('--threshold', help='threshold level for partners with normal sales', default=0.35, type=float)
    parser.add_argument('--history-values', help='number of previous weeks for check', default=4, type=int)
    parser.add_argument('--small-sales', help='day sales level for small partners', default=100, type=int)
    parser.add_argument('--sales-estimation', help='days for partners sales estimation', default=30, type=int)
    parser.add_argument('--small-threshold', help='threshold multiplier for small partners ', default=3.0, type=float)
    parser.add_argument('--threshold-sensitivity', help='sensitivity level for no alarm', default=10, type=int)
    parser.add_argument('--dry', help='Dry run, without solomon', default=False, action='store_true')

    options = parser.parse_args()

    token = get_secret(options.token)
    suppliers = [supplier.strip() for supplier in options.suppliers.split(',')] if options.suppliers else []

    if yenv.type not in ('testing', 'production'):
        raise ValueError('unexpected YENV_TYPE value: {}'.format(yenv.type))

    sales_mon = SalesMonitor(
        token,
        suppliers,
        threshold=options.threshold,
        threshold_sensitivity=options.threshold_sensitivity,
        history_values_num=options.history_values,
        small_day_sales=options.small_sales,
        sales_estimation_days=options.sales_estimation,
        small_sales_threshold_ratio=options.small_threshold,
        environment=yenv.type,
        check_time=options.check_datetime,
        dry_run=options.dry)
    sales_mon.run()
