# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import argparse
import logging

from travel.rasp.bus.scripts.sitemap import Sitemap

if __name__ == '__main__':
    logging.basicConfig()
    log = logging.getLogger()
    log.setLevel(logging.INFO)
    parser = argparse.ArgumentParser(description='Sitemap CLI')
    parser.add_argument('--popular-limit', help='limit for popular directions loading', default=15000, type=int)
    parser.add_argument('--threshold', help='minimal number of directions allowed', default=3000, type=int)
    parser.add_argument('--dry', help='dry run. No sitemap uploading to S3.', default=False, action='store_true')

    options = parser.parse_args()

    sitemap = Sitemap(options.popular_limit, options.threshold, dry=options.dry)
    sitemap.run()
