# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import json
from datetime import timedelta
from os import environ

import yenv
from travel.library.python.rasp_vault.api import get_secret


class BaseSettings(object):
    ENVIRONMENT = yenv.type
    SECRET_KEY = environ.get('BUS_SECRET_KEY', 'example')
    LOGGING_LEVEL = 'INFO'

    class Admin(object):
        TVM_CLIENT_ID = None
        TVM_SECRET = None

    class Spark(object):
        HOST = 'webservicefarm.interfax.ru'
        LOGIN = get_secret('bus-common-production.spark-login')
        PASSWORD = get_secret('bus-common-production.spark-password')
        CACHE_DB = '/var/cache/app/spark_cache.db'

    class CarriersCache(object):
        REDIS_HOST = 'localhost'
        REDIS_PORT = 6379
        TIMEOUT = timedelta(minutes=30)

    class Cache(object):
        REDIS_HOST = None
        REDIS_PORT = 6379
        REDIS_SOCKET_TIMEOUT = timedelta(seconds=1)
        REDIS_DB = None
        REDIS_SENTINEL_NAME = None

    class Mail(object):
        HOST = 'outbound-relay.yandex.net'
        FROM_MAIL = 'noreply@yandex-team.ru'

    class RaspAdmin(object):
        URL = None

    class PointMatchingSuggest(object):
        URL = None

    class Meta(object):
        URL = None
        INVALIDATE_CACHE = '/public/invalidate/segments'

    class Trust(object):
        URL = 'https://trust-payments-test.paysys.yandex.net:8028/trust-payments/v2/'

        @staticmethod
        def get_service_tokens():
            return json.loads(get_secret("billing-services-tokens.json-tokens"))

    class LogBroker(object):
        ENABLED = False
        INSTALLATION = 'logbroker'
        ENDPOINT = 'logbroker.yandex.net'
        PORT = 2135
        SOURCE_ID_PREFIX = environ.get('QLOUD_DISCOVERY_INSTANCE', '{}:{}'.format(yenv.type, yenv.name))

    class IDM(object):
        TVM_CHECK_ENABLED = False
        TVM_CLIENT_ID = None

    class Backend(object):
        API_URL = None

    class YavKeys(object):
        YQL_TOKEN = 'sec-01d956rm0wknnrbhhjsyx0rh56.sputnik-yql-token'
        S3_KEY = 'sec-01d956rm0wknnrbhhjsyx0rh56.robot-sputnik-s3-mds-key'
        S3_SECRET = 'sec-01d956rm0wknnrbhhjsyx0rh56.robot-sputnik-s3-mds-secret'

    class S3(object):
        ENDPOINT = 'https://s3.mds.yandex.net'
        PUBLIC_BUCKET = None
