# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from sqlalchemy.engine.url import URL

from travel.rasp.bus.settings.base import BaseSettings
from travel.library.python.rasp_vault.api import get_secret


class Settings(BaseSettings):
    LOGGING_LEVEL = 'INFO'

    SQLALCHEMY_DATABASE_URI = URL(
        'postgresql+psycopg2',
        username='yandex_bus',
        password=get_secret('bus-common-testing.pg-password'),
        database='yandex_busdb_test2',
        query={
            'host': ','.join([
                'man-bnzetetlxbrswgjw.db.yandex.net',
                'sas-k6ru8hqn4lnnpbmk.db.yandex.net',
                'vla-w1e0xhbp8vpuk48e.db.yandex.net'
            ]),
            'port': '6432,6432,6432',
            'sslmode': 'verify-full',
            'sslrootcert': '/usr/share/yandex-internal-root-ca/YandexInternalRootCA.crt',
            'connect_timeout': '3',
            'target_session_attrs': 'read-write'
        }
    )
    SQLALCHEMY_ECHO = True
    SQLALCHEMY_TRACK_MODIFICATIONS = True

    class Spark(BaseSettings.Spark):
        CACHE_DB = 'spark_cache.db'

    class RaspAdmin(BaseSettings.RaspAdmin):
        URL = 'https://service.admin-test.rasp.yandex-team.ru'

    class PointMatchingSuggest(BaseSettings.PointMatchingSuggest):
        URL = 'https://testing.suggests.rasp.common.yandex.net'

    class Meta(BaseSettings.Meta):
        URL = 'https://testing.api.internal.bus.yandex.net'

    class Cache(BaseSettings.Cache):
        REDIS_HOST = '::1'

    class Backend(BaseSettings.Backend):
        API_URL = 'https://testing.backend.internal.bus.yandex.net/api/'

    class S3(BaseSettings.S3):
        PUBLIC_BUCKET = 'travel.buses-public.testing'
