# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from sqlalchemy.engine.url import URL

from travel.rasp.bus.settings.base import BaseSettings
from travel.library.python.rasp_vault.api import get_secret


class Settings(BaseSettings):
    SQLALCHEMY_DATABASE_URI = URL(
        'postgresql+psycopg2',
        username='yandex_bus',
        password=get_secret('bus-common-production.pg-password'),
        database='yandex_busdb',
        query={
            'host': ','.join([
                'yandex-busdb01f.db.yandex.net',
                'yandex-busdb01h.db.yandex.net',
                'yandex-busdb01i.db.yandex.net'
            ]),
            'port': '6432,6432,6432',
            'sslmode': 'verify-full',
            'sslrootcert': '/usr/share/yandex-internal-root-ca/YandexInternalRootCA.crt',
            'connect_timeout': '3',
            'target_session_attrs': 'read-write'
        }
    )

    class Admin(BaseSettings.Admin):
        TVM_CLIENT_ID = 2017103
        TVM_SECRET = get_secret('bus-common-production.admin_tvm_secret')

    class Cache(BaseSettings.Cache):
        REDIS_HOST = None
        REDIS_DB = 1
        REDIS_SENTINEL_NAME = 'bus_redis_production'
        REDIS_SENTINEL_PASSWORD = get_secret('bus-common-production.redis-password')
        REDIS_SENTINEL_NODES = (
            ('vla-h4qi7lm0ypq1j56g.db.yandex.net', 26379),
            ('sas-86tj7pjmte4ieeez.db.yandex.net', 26379),
            ('man-p8sfirb3w6uxl23l.db.yandex.net', 26379),
        )

    class RaspAdmin(BaseSettings.RaspAdmin):
        URL = 'https://service.admin.rasp.yandex-team.ru'

    class PointMatchingSuggest(BaseSettings.PointMatchingSuggest):
        URL = 'https://geo-api.bus.yandex.net/points/matching-suggests/'

    class Meta(BaseSettings.Meta):
        URL = 'https://api.bus.yandex.net'

    class Trust(BaseSettings.Trust):
        URL = 'https://trust-payments.paysys.yandex.net:8028/trust-payments/v2/'

    class LogBroker(BaseSettings.LogBroker):
        ENABLED = True
        TOKEN = get_secret('bus-common-production.robot-sputnik-logbroker-token')
        ADMIN_ACCESS_TOPIC = '/sputnik/production/admin/access.log'

    class IDM(BaseSettings.IDM):
        TVM_CHECK_ENABLED = True
        TVM_CLIENT_ID = 2001600

    class Backend(BaseSettings.Backend):
        API_URL = 'https://backend.internal.bus.yandex.net/api/'

    class S3(BaseSettings.S3):
        PUBLIC_BUCKET = 'travel.buses-public.production'
