## spark-api-cli
Программа для хождения в API спарка.

### Реализованные команды
1. regions
получить список всех регионов РФ
2. ip
получить список ИП по фильтрам
3. company
получить список компаний по фильтрам
4. ip-info
получить подробную информацию по ИП 
5. company-info
получить подробную информацию по компании


### Примеры
```./spark_client regions``` \
Получаем список всех доступных регионов в CSV 

```./spark_client --format model regions``` \
Получаем список всех доступных регионов в человечном формате

```./spark_client company --name "Автобусы"```\
Получаем список всех компаний, у которых имя содержит Автобусы, в CSV 

```./spark_client company --name 'ГОРОДСКОЙ АВТОБУС' --okopf 15200```\
Получаем список всех компаний, у которых имя содержит Автобусы с ОКОПФ кодом 15200, в CSV 

```./spark_client company --name "Автобусы" --region 45 --region 66```\
Получаем список всех компаний, у которых имя содержит Автобусы и регион 45 или 66, в CSV 

```./spark_client ip --name "Анчутин"```\
Получаем список всех ИП, у которых имя содержит Анчутин, в CSV 

```./spark_client ip --name "Анчутин Сергей Сергеевич"```\
Получаем список всех ИП, у которых имя совпадает с Анчутин Сергей Сергеевич, в CSV 

```./spark_client ip --name "Анчутин С.С."```\
Получаем список всех ИП, у которых имя содержит Анчутин, а инициалы C.C., в CSV 

```./spark_client ip-info --inn "668501330908"```\
Получаем подробную ифнормация о ИП c нужным ИНН в CSV 

```./spark_client ip-info --ogrnip "315668500001856"```\
Получаем подробную ифнормация о ИП c нужным ОГРНИП в CSV 

```./spark_client company-info --inn "5249004813"```\
Получаем подробную ифнормация о ИП c нужным ИНН в CSV 

```./spark_client company-info --ogrn "1065249067850"```\
Получаем подробную ифнормация о ИП c нужным ОГРН в CSV 