from io import StringIO

from travel.rasp.bus.spark_api import csv_serializer


class ModelSerializer:
    @classmethod
    def serialize(cls, models, format='model'):
        if not models:
            return 'Can not find any model'
        result = StringIO()
        if format == 'csv':
            csv_serializer.serialize(result, models)
            return result.getvalue()

        for i in range(len(models)):
            result.write('{}) {}\n'.format(i + 1, cls.serialize_item(models[i])))

        return result.getvalue()

    @classmethod
    def serialize_item(cls, model):
        raise NotImplementedError()


class RegionSerializer(ModelSerializer):
    @classmethod
    def serialize_item(cls, model):
        return 'Код: {}; Имя: {}'.format(model.code, model.name)


class CompanySerializer(ModelSerializer):
    @classmethod
    def serialize_item(cls, model):
        return '\n'.join([
            model.full_name,
            'Адрес: {}'.format(model.address),
            'Деятельность: {}'.format(model.industry),
            'Регион: {}'.format(model.region_name),
            'ИНН: {}'.format(model.inn),
            'ОГРН: {}'.format(model.ogrn),
            'Генеральный директор: {}'.format(model.manager),
        ])


class EntrepreneurSerializer(ModelSerializer):
    @classmethod
    def serialize_item(cls, model):
        return '\n'.join([
            model.full_name,
            'ИНН: {}'.format(model.inn),
            'ОГРНИП: {}'.format(model.ogrnip),
        ])


class OkvedSerializer(ModelSerializer):
    @classmethod
    def serialize_item(cls, model):
        return '\n'.join([
            model.full_name,
            'Основной: {}'.format(model.is_main),
            'Код: {}'.format(model.code),
            'Название: {}'.format(model.name),
        ])
