import typing
from dataclasses import dataclass


@dataclass(frozen=True)
class Region:
    code: str
    name: str


@dataclass(frozen=True)
class OkvedItem:
    code: str
    is_main: bool
    name: str


@dataclass(frozen=True)
class CompanyReport:
    legal_address: str
    okveds: typing.Tuple[OkvedItem]
    region: Region
    short_name: str


@dataclass(frozen=True)
class Company:
    id: int
    inn: str
    ogrn: str
    okpo: str
    full_name: str
    address: str
    industry: str
    okopf_name: str
    okopf_code: str
    manager: str
    report: typing.Optional[CompanyReport] = None


@dataclass(frozen=True)
class EntrepreneurReport:
    okveds: typing.Tuple[OkvedItem]
    region: Region


@dataclass(frozen=True)
class Entrepreneur:
    id: int
    inn: str
    ogrnip: str
    okpo: str
    full_name: str
    report: typing.Optional[EntrepreneurReport] = None
