import argparse

import coloredlogs

from travel.rasp.bus.toloka_matching.src import (
    result_applyer, result_fetcher, task_creator
)


def parse_args():
    parser = argparse.ArgumentParser(description='Toloka matching')
    subparsers = parser.add_subparsers(dest='cmd')
    subparsers.required = True
    apply_command_parser = subparsers.add_parser('apply', help='Apply tolokas\' result to matching')
    apply_command_parser.add_argument(
        '--overlap',
        type=int,
        default=1,
        required=False,
    )
    apply_command_parser.add_argument(
        '--threshold',
        type=float,
        default=0.8,
        required=False,
    )

    fetcher_command_parser = subparsers.add_parser('fetch', help='Fetch tolokas\' result')
    fetcher_command_parser.add_argument(
        '--pool-id',
        type=int,
        required=True,
        help="toloka's pool id"
    )

    upload_command_parser = subparsers.add_parser('upload', help='Create tolokas\' tasks')
    upload_command_parser.add_argument(
        '--suppliers',
        default="",
        required=False,
        help="suppliers list (example: som1,some2)"
    )
    upload_command_parser.add_argument(
        '--limit',
        type=int,
        default=1000,
        required=False,
        help='max tolokas\' task'
    )
    upload_command_parser.add_argument(
        '--pool-id',
        type=int,
        required=True,
        help="toloka's pool id"
    )

    return parser.parse_args()


if __name__ == '__main__':
    coloredlogs.install(level='INFO', fmt='%(message)s')
    args = parse_args()

    if args.cmd == 'apply':
        result_applyer.apply_result(
            overlap=args.overlap,
            threshold=args.threshold,
        )
    elif args.cmd == 'fetch':
        result_fetcher.fetch(pool_id=args.pool_id)
    elif args.cmd == 'upload':
        suppliers = None
        if args.suppliers:
            suppliers = [s.strip() for s in args.suppliers.split(',')]
        task_creator.create(suppliers=suppliers, limit=args.limit, pool_id=args.pool_id)
    else:
        raise Exception("Unknown command {}".format(args.cmd))
