import logging

import psycopg2
import psycopg2.extras

from travel.rasp.bus.toloka_matching.src import toloka
from travel.rasp.bus.toloka_matching.src.config import Config
from travel.rasp.bus.toloka_matching.src.utils.date import parse_utc_datetime
from travel.rasp.bus.toloka_matching.src.utils.requests import AuthorizationSession
from travel.rasp.bus.toloka_matching.src.utils.sql import insert_many


def _fetch_submitted_frontier(cursor):
    cursor.execute("SELECT max(submitted) FROM matching.toloka_results")
    return cursor.fetchone()[0]


def fetch(pool_id):
    toloka_client = toloka.Client(AuthorizationSession(
        uri=Config.Toloka.URI,
        auth=Config.Toloka.AUTH,
    ))

    with psycopg2.connect(Config.CONNECTION_STRING)as conn, conn.cursor() as cur:
        frontier = _fetch_submitted_frontier(cur)
    logging.info("Frontier: %s", frontier)

    task_results = tuple(
        {
            'id': item['id'],
            'submitted': parse_utc_datetime(item['submitted']),
            'task_id': task['id'],
            'code': solutions['output_values']['point-code'],
        } for item in toloka_client.get_submitted_assignments(frontier=frontier, pool_id=pool_id)
        for task, solutions in zip(item['tasks'], item['solutions']) if not task.get('known_solutions')
    )
    logging.info("TaskResults: %d", len(task_results))
    with psycopg2.connect(Config.CONNECTION_STRING) as conn, conn.cursor() as cur:
        insert_many(cur, 'matching.toloka_results', task_results)
