import json
from datetime import timezone


class Client:
    def __init__(self, session):
        self._session = session

    def create_pool_tasks(self, pool_id, inputss, open_pool=False):
        return self._create_tasks(
            [{'pool_id': pool_id, 'input_values': inputs, 'overlap': 1} for inputs in inputss], open_pool
        )

    def _create_tasks(self, tasks, open_pool=False):
        if not tasks:
            return ()

        resp = self._session.post(
            'tasks',
            params={
                'open_pool': 'true' if open_pool else 'false',
                'allow_defaults': 'true',
            },
            json=tasks,
        ).json()
        errors = resp.get('validation_errors')
        if errors:
            raise ValueError
        items = resp['items']
        return tuple(items.get(k) for k in sorted(items, key=int))

    def get_submitted_assignments(self, frontier=None, **kwargs):
        return self._iterate(
            frontier, 'submitted',
            lambda **kwargs1: self._get_assignments(status='ACCEPTED', **kwargs, **kwargs1),
        )

    def _get_assignments(self, status, **kwargs):
        return self._session.get(
            'assignments',
            params={**kwargs, 'status': status},
    ).json()

    def _iterate(self, frontier, field, fetch, **kwargs):
        if frontier is not None:
            frontier = frontier.astimezone(timezone.utc).replace(tzinfo=None).isoformat()
        has_more = True
        while has_more:
            if frontier is not None:
                kwargs[f'{field}_gt'] = frontier
            resp = fetch(sort=field, **kwargs)
            has_more, items = (resp[k] for k in ('has_more', 'items'))
            for item in items:
                yield item
            if items:
                frontier = items[-1][field]
