from urllib.parse import urljoin

import requests


class Session(requests.Session):
    def __init__(self, uri):
        super().__init__()
        self._uri = uri

    def request(self, method, path, **kwargs):
        resp = super().request(method, urljoin(self._uri, path), **kwargs)
        resp.raise_for_status()
        return resp


class AuthorizationSession(Session):
    def __init__(self, uri, auth):
        super().__init__(uri)
        self.headers['Authorization'] = auth
