from itertools import islice


def _sql_tuple_values(cursor, keys, tuples):
    fields = ','.join(keys)
    values = ','.join(['%s'] * len(tuples))
    return fields, cursor.mogrify(values, tuples).decode()


def _sql_dict_values(cursor, dicts):
    assert dicts

    if any(x.keys() != y.keys() for x, y in zip(dicts, islice(dicts, 1))):
        raise ValueError
    keys = tuple(dicts[0].keys())
    return _sql_tuple_values(cursor, keys, tuple(tuple(xs[k] for k in keys) for xs in dicts))


def _generate_insert_many(cursor, tablename, data):
    fields, values = _sql_dict_values(cursor, data)
    return cursor.mogrify(
        f"INSERT INTO {tablename} ({fields}) VALUES {values}",
        [tuple(xs.get(f) for f in fields) for xs in data],
    )


def insert_many(cursor, table, data):
    if data:
            cursor.execute(_generate_insert_many(cursor, table, data))
