import argparse

from travel.rasp.bus.scripts.carrier_matcher.manual_matchings_loader import CarrierMatchingLoader


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Automatcher CLI')
    parser.add_argument('--matchings-fn', default='manual_matching.csv')
    parser.add_argument('--output-fn', default='carrier_search_results.csv')
    parser.add_argument('--csv-delimeter', default=';')
    parser.add_argument('--csv-quotechar', default='"')
    parser.add_argument('--dry', help='Dry run', default=False, action='store_true')

    options = parser.parse_args()

    carrier_matching_loader = CarrierMatchingLoader(options.matchings_fn, options.output_fn, options.csv_delimeter,
                                                    options.csv_quotechar, options.dry)
    carrier_matching_loader.run()
