import argparse
import json

import psycopg2
import psycopg2.extras

from travel.rasp.bus_gdpr_api.src.bus_client import get_orders_by_uid
from travel.rasp.bus_gdpr_api.src.config import Config


def parse_args():
    parser = argparse.ArgumentParser(description='The bus order fetcher')
    parser.add_argument(
        '--uid',
        dest='uid',
        help='user uid',
        required=True,
    )

    return parser.parse_args()


if __name__ == '__main__':
    args = parse_args()
    with psycopg2.connect(Config.CONNECTION_STRING) as db_connection:
        orders = get_orders_by_uid(db_connection, args.uid)
        print(json.dumps(orders, indent=4, ensure_ascii=False))
