import psycopg2
import psycopg2.extras

from travel.rasp.bus_gdpr_api.src.schemas import OrderSchema


def get_orders_by_uid(conn, uid):
    return list(_get_orders_by_uid(conn, uid))


def _get_orders_by_uid(conn, uid):
    with conn.cursor(cursor_factory=psycopg2.extras.DictCursor) as cur:
        cur.execute(
            "select\n"
            " *\n"
            "FROM\n"
            "    orders\n"
            "WHERE\n"
            "    uid=%s",
            (uid,)
        )

        rows = cur.fetchall()
        for r in rows:
            yield OrderSchema().dump(r).data
