import os


_format = '%(levelname)s %(asctime)s %(process)d %(name)s %(message)s'


class Config(object):
    CONNECTION_STRING = os.environ.get(
        'BUS_GDPR_CONNECTION_STRING',
        'dbname=yandex_busdb_ro_local user=yandex_bus password=token host=pgaas.mail.yandex.net port=1200',
    )
    LOGGING = {
        'version': 1,
        'handlers': {
            'stream': {
                'class': 'logging.StreamHandler',
                'stream': 'ext://sys.stdout',
                'level': 'DEBUG',
                'formatter': 'verbose',
            },
        },
        'formatters': {
            'verbose': {
                'format': _format,
            },
            'exception': {
                '()': 'ylog.ExceptionFormatter',
                'format': _format,
            },
        },
        'loggers': {
            '': {
                'handlers': ['stream'],
                'level': 'DEBUG',
            },
        },
    }
    TVM_ID = 2010452   # rasp-bus-gdpr-api-production https://abc.yandex-team.ru/services/rasp/resources/?show-resource=5026548
    ALLOWED_CONSUMERS = {
        2001121,       # rasp-developers              https://abc.yandex-team.ru/services/rasp/resources/?show-resource=3260008
        2009785,       # takeout-production           https://abc.yandex-team.ru/services/takeout/resources/?show-resource=4688916
        2009783,       # takeout-testing              https://abc.yandex-team.ru/services/takeout/resources/?show-resource=4688915
        2010664,       # SIS                          SECAUDIT-2824
    }
    DISABLE_TVM = os.environ.get(
        'DISABLE_TVM',
    ) == 'true'
