from marshmallow import fields, pre_dump, Schema


class EnumSchema(Schema):
    name = fields.String()


class RideSchema(Schema):
    arrival = fields.String()
    bus = fields.String()
    carrier = fields.String()
    connector = fields.String()
    currency = fields.String()
    date = fields.String()
    departure = fields.String()
    fee = fields.Float()
    freeSeats = fields.Int()
    fromDescription = fields.String()
    name = fields.String()
    number = fields.String()
    partnerName = fields.String()
    price = fields.Float()
    status = fields.Nested(EnumSchema)
    toDescription = fields.String()


class BookingProductsSchema(Schema):
    fee = fields.String()
    ticket = fields.String()


class TicketDataSchema(Schema):
    barcode = fields.String()
    code = fields.String()
    number = fields.String()
    platform = fields.String()
    series = fields.String()


class TicketPassangerSchema(Schema):
    birthDate = fields.String()
    citizenship = fields.String()
    docNumber = fields.String()
    docType = fields.Nested(EnumSchema)
    firstName = fields.String()
    genderType = fields.Nested(EnumSchema)
    lastName = fields.String()
    middleName = fields.String()
    seats = fields.Int()
    ticketType = fields.Nested(EnumSchema)


class TicketSchema(Schema):
    data = fields.Nested(TicketDataSchema)
    feeVat = fields.String()
    passenger = fields.Nested(TicketPassangerSchema)
    price = fields.Float()
    priceVat = fields.String()
    status = fields.Nested(EnumSchema)
    url = fields.String()


class BookingSchema(Schema):
    expirationDateTime = fields.String()
    partnerName = fields.String()
    price = fields.Float()
    products = fields.Nested(BookingProductsSchema)
    source = fields.String()
    status = fields.Nested(EnumSchema)
    tickets = fields.Nested(TicketSchema, many=True)


class ContactsSchema(Schema):
    email = fields.String()
    phone = fields.String()


class PurchaseOrderSchema(Schema):
    current_qty = fields.String()
    fiscal_nds = fields.String()
    fiscal_title = fields.String()
    order_ts = fields.String()
    order_ts_msec = fields.String()
    orig_amount = fields.String()
    paid_amount = fields.String()
    product_type = fields.String()
    service_product_name = fields.String()


class PurchaseSchema(Schema):
    amount = fields.String()
    currency = fields.String()
    start_ts = fields.String()
    start_ts_msec = fields.String()
    status = fields.String()
    update_ts = fields.String()
    update_ts_msec = fields.String()
    user_email = fields.String()
    orders = fields.Nested(PurchaseOrderSchema)


class RefundSchema(Schema):
    full = fields.Float()
    part = fields.Float()


class RefundApplicationSchema(Schema):
    confirmDate = fields.String()
    date = fields.String()
    status = fields.String()
    sumReturned = fields.Float()
    refund = fields.Nested(RefundSchema)


class OrderSchema(Schema):
    status = fields.String()
    ride = fields.Nested(RideSchema)
    booking = fields.Nested(BookingSchema)
    contacts = fields.Nested(ContactsSchema)
    purchase = fields.Nested(PurchaseSchema)
    creation_ts = fields.String()
    tld = fields.String()
    promocode = fields.String()
    refund_application = fields.Nested(RefundApplicationSchema, many=True)

    @pre_dump
    def flat_refund_application(self, data):
        self._flat_field(data, 'refund_application')
        return data

    def _flat_field(self, data, field):
        refund_application = data.get(field)
        if not isinstance(refund_application, dict):
            data[field] = None
        else:
            data[field] = refund_application.values()
        return data
