# -*- mode: ruby -*-
# vi: set ft=ruby :

Vagrant.configure(2) do |config|
  # The most common configuration options are documented and commented below.
  # For a complete reference, please see the online documentation at
  # https://docs.vagrantup.com.

  config.vm.box = "ubuntu/precise64"

  config.vm.hostname = "dev-node"

  config.vm.network "forwarded_port", guest: 80, host: 8080

  config.vm.network "private_network", ip: "192.168.33.11"

  config.vm.provider "virtualbox" do |vb|
    vb.name = "dev-node"
    vb.cpus = 1
    vb.memory = "2048"
  end

  config.vm.provision "ansible" do |ansible|
    ansible.limit = "dev-node"
    ansible.playbook = "playbooks/dev-node.yml"
    ansible.inventory_path = "inventory"
    ansible.verbose = "vv"
  end

  # share additional folders: first argument - path to folder in a host,
  # second - path to folder on a guest
  # config.vm.synced_folder ".", "/home/ohandy/monolith", create: true
end
