{$F+}
Unit AF_DFile;

Interface

Uses AF_Types;

Type
   TDFileData = packed record
                         c1,c2:char;
                       end;
   TOperationResult = (ORComplete,ORDiskError,ORObjectError);
   TDataFile = object
                 ReadSessionStatus:boolean;
                 WriteSessionStatus:boolean;
                 ReadPosition:integer;
                 ReadCount:integer;
                 WriteStatus:boolean;
                 WriteCounter:integer;
                 _ReadFileSize:longint;
                 _FileName:string;
                 _TempFile:string;
                 _vf,_tf:file of TDFileData;
                 _strs:AF_Types.PStrings;
                 Constructor Init(_fn:string);
                 Destructor Free; virtual;
                 Function FileName:string; virtual;
                 Function Count:integer; virtual;
                 Function AddRecord:TOperationResult; virtual;
                 Function ReadRecord(_n:integer):TOperationResult; virtual;
                 Function DeleteRecord(_n:integer):TOperationResult; virtual;
                 Function EditRecord(_n:integer):TOperationResult; virtual;
                 Function OpenWriteSession:TOperationResult;
                 Function CloseWriteSession:TOperationResult;
                 Function AddNextRecord:TOperationResult; virtual;
                 Function OpenReadSession:TOperationResult;
                 Function CloseReadSession:TOperationResult;
                 Function ReadNextRecord:TOperationResult; virtual;
                 Function ReadNextRecordWithSeek:TOperationResult; virtual;
   end; //tdatafile
   PDataFile = ^TDataFile;



Implementation

Uses AF_Proc;

Procedure __Pr(var _u:longint;_u1:longint);
begin
   _u:=_u1;
end;

Constructor TDataFile.Init;
  var i:integer;
begin
   ReadSessionStatus:=false;
   WriteSessionStatus:=false;
   ReadPosition:=1;
   WriteStatus:=false;
   WriteCounter:=0;
   ReadCount:=0;
   _FileName:=_fn;
   AssignFile(_vf,_fn);
   Randomize;
   _TempFile:='';
   for i:=1 to 8 do _TempFile:=_TempFile+Chr(Random(9)+49);
   _TempFile:=ExtractDirPath(_fn)+'\'+_TempFile+'.TMP';
   AssignFile(_tf,_TempFile);
   _strs:=New(PStrings,Create);
end;

Destructor TDataFile.Free;
begin
   Dispose(_strs,free);
end;

Function TDataFile.FileName;
begin
   FileName:=_FileName;
end;

Function TDataFile.Count;
  var i,l:longint;
  var k:integer;
  var Dt:TDFileData;
begin
   {$I-}
   Reset(_vf);
   k:=0;
   if IOResult=0 then begin
           l:=FileSize(_vf);
             if l>0 then begin
                 for i:=0 to l-1 do begin
                                      Seek(_vf,i);
                                      Read(_vf,Dt);
                                      if (Dt.c1=#6)and(Dt.c2=#1) then inc(k);
                 end;
             end;
   closefile(_vf);
   end;
   Count:=k;
{$I+}
end;

Function TDataFile.AddRecord;
  var k,l:longint;
  var _AddRecord:TOperationResult;
  var df:TDFileData;
  var s:string;
begin
   {$I-}
   _AddRecord:=ORComplete;
   if _strs^.count<>0 then begin
        ReWrite(_tf);
          if IOResult<>0 then _AddRecord:=ORDiskError
                         else begin
                           Reset(_vf);
                             if IOResult<>0 then begin
                                  ReWrite(_vf);
                                   if IOResult<>0 then _AddRecord:=ORDiskError;
                               end;
                              if _AddRecord=ORComplete then begin
                            l:=filesize(_vf);
                              if l>0 then begin
                                for k:=0 to l-1 do begin
                                    while not EOF(_tf) do Read(_tf,df);
                                   Seek(_vf,k);
                                   Read(_vf,df);
                                   Write(_tf,df);
                                end;
                               end;
                             closefile(_vf);
                             erase(_vf);
                               for k:=1 to _strs^.count do begin
                                s:=_strs^.getstring(k);
                                if s='' then s:=#1;  {#255}
                                 if (length(s) mod 2)<>0 then s:=s+#1; {#255}
                                while not eof(_tf) do read(_tf,df);
                                df.c1:=#6;
//                                df.c2:=chr(k);
                                if k=1 then df.c2:=#1
                                            else df.c2:=#2;
                                write(_tf,df);
                                while not eof(_tf) do read(_tf,df);
                                 repeat
                                  while not eof(_tf) do read(_tf,df);
                                  df.c1:=s[1];
                                  df.c2:=s[2];
                                  write(_tf,df);
                                  s:=copy(s,3,length(s)-2);
                                 until s='';
                               end;
                             closefile(_tf);
                             FileCopy(_tempfile,_filename);
                             erase(_tf);
                           end;
                    end;
   end;
   AddRecord:=_AddRecord;
   {$I+}
end;

Function TDataFile.ReadRecord;
  var _ReadRecord:TOperationResult;
  var nk,k,l:longint;
  var r,u:integer;
  var df:TDFileData;
  var s:string;
begin
   {$I-}
   _strs^.beginupdate;
   _strs^.clear;
   _ReadRecord:=ORComplete;
   Reset(_vf);
          if IOResult<>0 then begin
                                ReWrite(_vf);
                                  if IOResult<>0 then _ReadRecord:=ORDiskError;
                              end;
          if _ReadRecord<>ORDiskError then begin
            r:=0;
            l:=filesize(_vf);
             if l>0 then begin
               for k:=0 to l-1 do begin
                 seek(_vf,k);
                 read(_vf,df);
                  if (df.c1=#6)and(df.c2=#1) then inc(r);
                  if r=_n then break;
               end;
                if r=_n then begin
                  r:=0;
                  ___DFixInt(r);
                  u:=0;
                  ___DFixInt(u);
                  s:='';
                  nk:=k;
                  repeat
                    seek(_vf,k);
                    read(_vf,df);
                     if df.c1=#6 then begin
                                   r:=ord(df.c2);
                                    if r<>1 then begin
                                      while s[length(s)]=#1 do begin
                                                                 s:=copy(s,1,length(s)-1); {#255}
                                                                 if s='' then break;
                                                               end;
                                      _strs^.add(s);
                                      inc(u);
                                      ___DFixInt(u);
                                      s:='';
                                    end;
                                  end
                           else begin
                              s:=s+df.c1+df.c2;
                            end;
                      inc(k);
                  until ((k>nk+1)and(df.c1=#6)and(df.c2=#1))or(k=l);
                    if ((k>nk+1)and(df.c1=#6)and(df.c2=#1))or((k=l)and(df.c1<>#6)) then begin
                      while s[length(s)]=#1 do begin
                                                 s:=copy(s,1,length(s)-1);  {#255}
                                                 if s='' then break;
                                               end;
                      _strs^.add(s);
                     end;
               end
                 else _ReadRecord:=ORDiskError;
             end
               else _ReadRecord:=ORDiskError;
            end;
   Closefile(_vf);
   ReadRecord:=_ReadRecord;
   _strs^.endupdate;
   {$I+}
end;

Function TDataFile.DeleteRecord;
  var r:integer;
  var k,l,x:longint;
  var df:TDFileData;
  var _DeleteRecord:TOperationResult;
begin
   {$I-}
    _DeleteREcord:=ORComplete;
    ReWrite(_tf);
            if IOResult<>0 then _DeleteRecord:=ORDiskError
                           else begin
                 Reset(_vf);
                   if IOResult<>0 then begin
                         ReWrite(_vf);
                           if IOResult<>0 then _DeleteRecord:=ORDiskError;
                      end;
                if _DeleteRecord=ORComplete then begin
                    l:=FileSize(_vf);
                    r:=0;
                    x:=0;
                    k:=-1;
              repeat
                inc(k);
                   if k<l then begin
                   Read(_vf,df);
                   end;
                     if (df.c1=#6)and(df.c2=#1) then inc(r);
                        if r=_n then begin
                          df.c1:=#1;
                          while not ((df.c1=#6)and(df.c2=#1)) do begin
                                              Read(_vf,df);
                                              inc(k);
                                                if k=l-1 then break;
                          end;
                           if (df.c1=#6)and(df.c2=#1) then begin
                                           Write(_tf,df);
                                           inc(x);
                                           inc(r);
                           end;
                        end
                          else begin
                            Write(_tf,df);
                            inc(x);
                          end;
                until k=l-1;
                     Closefile(_tf);
                     Closefile(_vf);
                     Erase(_vf);
                         if x=0 then begin
//                         ReWrite(_vf);
//                         Closefile(_vf);
                         end
                           else begin
                             FileCopy(_TempFile,_FileName);
                           end;
                     Erase(_tf);

                 end;
              end;
   DeleteRecord:=_DeleteRecord;
end;

Function TDataFile.EditRecord;
  var r:integer;
  var u,k,l:longint;
  var df:TDFileData;
  var _EditRecord:TOperationResult;
  var s:string;
  var flag:boolean;
begin
   {$I-}
   flag:=true;
   _EditRecord:=ORComplete;
   ReWrite(_tf);
            if IOResult<>0 then _EditRecord:=ORDiskError
                           else begin
                 Reset(_vf);
                   if IOResult<>0 then begin
                         ReWrite(_vf);
                           if IOResult<>0 then _EditRecord:=ORDiskError;
                      end;
                if _EditRecord=ORComplete then begin
                    l:=FileSize(_vf);
                    r:=0;
            k:=-1;
              repeat
                inc(k);
                   if k<l then begin
                   Read(_vf,df);
                   end;
                     if (df.c1=#6)and(df.c2=#1) then inc(r);
                        if r=_n then begin
                          if flag=true then begin
                               for u:=1 to _strs^.count do begin
                                s:=_strs^.getstring(u);
                                if s='' then s:=#1; {#255}
                                 if (length(s) mod 2)<>0 then s:=s+#1;  {#255}
                                df.c1:=#6;
//                                df.c2:=chr(u);
                                if u=1 then df.c2:=#1
                                       else df.c2:=#2;
                                write(_tf,df);
                                 repeat
                                  df.c1:=s[1];
                                  df.c2:=s[2];
                                  write(_tf,df);
                                  s:=copy(s,3,length(s)-2);
                                 until s='';
                               end;
                             flag:=false;
                          end;
                        end
                          else Write(_tf,df);
                    if ((k=l-1)or(k=l)) then break;
                until k=l-1;
                 {$I+}
                     Closefile(_tf);
                     Reset(_tf);
                     l:=FileSize(_tf);
                     Closefile(_tf);
                     Closefile(_vf);
                     Erase(_vf);
                         if l=0 then begin
                         ReWrite(_vf);
                         Closefile(_vf);
                         end
                           else begin
                             FileCopy(_TempFile,_FileName);
                           end;
                     Erase(_tf);
                 end;
              end;
   EditRecord:=_EditRecord;
   {$I+}
end;

Function TDataFile.OpenWriteSession;
begin
   if WriteSessionStatus=true then OpenWriteSession:=ORObjectError
          else begin
             {$I-}
               ReWrite(_tf);
                 if IOResult<>0 then OpenWriteSession:=ORDiskError
                   else begin
                     WriteStatus:=false;
                     WriteSessionStatus:=true;
                     OpenWriteSession:=ORComplete;
                   end;
             {$I+}
          end;
end;

Function TDataFile.CloseWriteSession;
begin
   CloseWriteSession:=ORComplete;
   if WriteSessionStatus=false then CloseWriteSession:=ORObjectError
          else begin
           {$I-}
            if writestatus then begin
             Closefile(_tf);
               if IOResult<>0 then CloseWriteSession:=ORDiskError
                 else begin
                   Erase(_vf);
                    if FileCopy(_tempfile,_filename)=false then CloseWriteSession:=ORDiskError;
                   erase(_tf);
                 end;
             end
              else begin
               Closefile(_tf);
               erase(_tf);
              end;
           {$I+}
          end;
   WriteSessionStatus:=false;
end;

Function TDataFile.AddNextRecord;
  var k,l:longint;
  var _AddRecord:TOperationResult;
  var df:TDFileData;
  var s:string;
begin
   {$I-}
   _AddRecord:=ORComplete;
   if WriteSessionStatus=false then _AddRecord:=ORObjectError
     else begin
       if _strs^.count<>0 then begin
         if WriteStatus=false then begin
           WriteStatus:=true;
                              Reset(_vf);
                                if IOResult<>0 then begin
                                    ReWrite(_vf);
                                      if IOResult<>0 then _AddRecord:=ORDiskError;
                                end;
                              if _AddRecord=ORComplete then begin
                               l:=filesize(_vf);
                                 if l>0 then begin
                                    for k:=0 to l-1 do begin
                                         df.c1:=#0;
                                         Read(_vf,df);
                                         Write(_tf,df);
                                           if (df.c1=#6)and(df.c1=#1) then inc(WriteCounter);
                                    end;
                                  end;
                                Closefile(_vf);
                              end;
         end;
           inc(WriteCounter);
             for k:=1 to _strs^.count do begin
               s:=_strs^.getstring(k);
                 if s='' then s:=#1;  {#255}
                 if (length(s) mod 2)<>0 then s:=s+#1; {#255}
                         df.c1:=#6;
//                         df.c2:=chr(k);
                         if k=1 then df.c2:=#1
                                else df.c2:=#2;
                         write(_tf,df);
                            repeat
                               df.c1:=s[1];
                               df.c2:=s[2];
                               write(_tf,df);
                               s:=copy(s,3,length(s)-2);
                             until s='';
             end;
       end;
     end;
   AddNextRecord:=_AddRecord;
   {$I+}
end;

Function TDataFile.OpenReadSession;
begin
   if ReadSessionStatus=true then OpenReadSession:=ORObjectError
          else begin
             {$I-}
               Reset(_vf);
                 if IOResult<>0 then OpenReadSession:=ORDiskError
                   else begin
                     _ReadFileSize:=FileSize(_vf);
                     ReadCount:=0;
                     ReadSessionStatus:=true;
                     OpenReadSession:=ORComplete;
                   end;
             {$I+}
          end;
end;

Function TDataFile.CloseReadSession;
begin
   CloseReadSession:=ORComplete;
   if ReadSessionStatus=false then CloseReadSession:=ORObjectError
          else begin
           {$I-}
             Closefile(_vf);
               if IOResult<>0 then CloseReadSession:=ORDiskError;
           {$I+}
          end;
   ReadSessionStatus:=false;
end;

Function TDataFile.ReadNextRecord;
  var _ReadRecord:TOperationResult;
  var r,u:integer;
  var df:TDFileData;
  var s:string;
begin
   {$I-}
   _strs^.beginupdate;
   _strs^.clear;
   _ReadRecord:=ORComplete;
   if ReadSessionStatus=false then _ReadRecord:=ORObjectError
          else begin  //1
           if ReadCount=0 then begin //2
                 Seek(_vf,0);
                   repeat
                    read(_vf,df);
                     if IOResult<>0 then _ReadRecord:=ORDiskError;
                    inc(readcount);
                   until ((df.c1=#6)and(df.c2=#1))or(IOResult<>0);
           end;  //2
                  u:=0;
                  s:='';
                  repeat
                    read(_vf,df);
                      if IOResult<>0 then _ReadRecord:=orDiskError;
                     if df.c1=#6 then begin //3
                                   r:=ord(df.c2);
                                    if r<>1 then begin //4
                                      while s[length(s)]=#1 do begin //5
                                                                 s:=copy(s,1,length(s)-1); {#255}
                                                                 if s='' then break;
                                                               end; //5
                                      _strs^.add(s);
                                      inc(u);
                                      ___DFixInt(u);
                                      s:='';
                                    end;  //4
                                  end  //3
                           else begin //6
                              s:=s+df.c1+df.c2;
                            end; //6
                      inc(ReadCount);
                  until ((df.c1=#6)and(df.c2=#1))or(ReadCount=_ReadFileSize)or(_ReAdRecord=orDiskError);
                    if ((df.c1=#6)and(df.c2=#1))or((ReadCount=_ReadFileSize)) then begin //7
                      while (s[length(s)]=#1)or(s[length(s)]=#6) do begin  //8
                                                 s:=copy(s,1,length(s)-1);  {#255}
                                                 if s='' then break;
                                                 if _ReadRecord=ORDiskError then break;
                                               end; //8
                       _strs^.add(s);
                      end; //7
          end;
   if (ReadCount>_ReadFileSize) then _ReadRecord:=ORDiskError;
   ReadNextRecord:=_ReadRecord;
   _strs^.endupdate;
   {$I+}
end;

Function TDataFile.ReadNextRecordWithSeek;
  var _ReadRecord:TOperationResult;
  var r,u:integer;
  var df:TDFileData;
  var s:string;
begin
   {$I-}
   _strs^.beginupdate;
   _strs^.clear;
   _ReadRecord:=ORComplete;
   if ReadSessionStatus=false then _ReadRecord:=ORObjectError
          else begin  //1
           if ReadCount=0 then begin //2
                 Seek(_vf,0);
                   repeat
                    read(_vf,df);
                     if IOResult<>0 then _ReadRecord:=ORDiskError;
                    inc(readcount);
                   until ((df.c1=#6)and(df.c2=#1))or(IOResult<>0);
           end;  //2
                  u:=0;
                  s:='';
                  repeat
                    seek(_vf,ReadCount);
                    read(_vf,df);
                      if IOResult<>0 then _ReadRecord:=orDiskError;
                     if df.c1=#6 then begin //3
                                   r:=ord(df.c2);
                                    if r<>1 then begin //4
                                      while s[length(s)]=#1 do begin //5
                                                                 s:=copy(s,1,length(s)-1); {#255}
                                                                 if s='' then break;
                                                               end; //5
                                      _strs^.add(s);
                                      inc(u);
                                      ___DFixInt(u);
                                      s:='';
                                    end;  //4
                                  end  //3
                           else begin //6
                              s:=s+df.c1+df.c2;
                            end; //6
                      inc(ReadCount);
                  until ((df.c1=#6)and(df.c2=#1))or(ReadCount=_ReadFileSize)or(_ReAdRecord=orDiskError);
                    if ((df.c1=#6)and(df.c2=#1))or((ReadCount=_ReadFileSize)) then begin //7
                      while (s[length(s)]=#1)or(s[length(s)]=#6) do begin  //8
                                                 s:=copy(s,1,length(s)-1);  {#255}
                                                 if s='' then break;
                                                 if _ReadRecord=ORDiskError then break;
                                               end; //8
                       _strs^.add(s);
                      end; //7
          end;
   if (ReadCount>_ReadFileSize) then _ReadRecord:=ORDiskError;
   ReadNextRecordWithSeek:=_ReadRecord;
   _strs^.endupdate;
   {$I+}
end;


end.


