Unit Af_Types;

INTERFACE

Uses Classes,SysUtils;

Type
   PString = ^String;
   PInteger = ^integer;
   TFileShare = (FSRewrite,FSAppend);
   TStrings=object
              tf:textfile;
              filename:string;
              mainfile:textfile;
              share:TFileShare;
              xstrs:Classes.TStrings;
              constructor create;
              destructor free; virtual;
              procedure BeginUpdate;
              procedure EndUpdate;
              function setfile(_f:string):boolean; virtual;
              function getfilename:string; virtual;
              procedure setfileshare(_s:TFileShare); virtual;
              function add(s:string):boolean; virtual;
              function count:integer; virtual;
              procedure delete(i:integer); virtual;
              procedure insert(i:integer; s:string); virtual;
              procedure edit(i:integer; s:string); virtual;
              function getstring(i:integer):string; virtual;
              procedure clear; virtual;
              procedure reindex(i,ir:integer); virtual;
              procedure loadfromfile(f:string); virtual;
              procedure savetofile(f:string); virtual;
              procedure Truncate(len:integer); virtual;
              procedure remain(len:integer); virtual;
              procedure deleteblock(i,len:integer); virtual;
              procedure insertblock(i,len:integer; _ts:TStrings); virtual;
              procedure include(_ts:tstrings); virtual;
              procedure exclude(var _ts:tstrings); virtual;
              procedure TruncateStringsSize(len:integer); virtual;
              procedure SortedAsString; virtual;  {sorted}
              procedure SortedAsNumber; virtual;
              function Text:string; virtual;
              function Text1:string; virtual;
              function SearchString(_s:string):integer; virtual;
              function SearchStrings(_s:string; _p:TStrings):integer; virtual;
              function SearchText(_s:string):integer; virtual;
   end;  //tstrings
   PStrings = ^AF_Types.TStrings;
   TFileReport = object(TStrings)
                   function Add(s:string):boolean; virtual;
                 end; //tfilereport
   PFileReport = ^TFileReport;

function _xCustomSort(List: TStringList; Index1, Index2: Integer): Integer;



IMPLEMENTATION

uses af_proc;

function _xCustomSort;
   var s1,s2:string;
begin
   result:=0;
   s1:=list.strings[index1];
   s2:=list.strings[index2];
   s1:=AnsiUpperCase(s1);
   s2:=AnsiUpperCase(s2);
   if s1<s2 then result:=-1;
   if s1=s2 then result:=0;
   if s1>s2 then result:=1;
end;


constructor TStrings.create;
begin
   xstrs:=TStringList.Create;
end;

Destructor TStrings.Free;
begin
   xstrs.free;
end;

procedure TStrings.BeginUpdate;
begin
   xstrs.BeginUpdate;
end;

procedure TStrings.EndUpdate;
begin
   xstrs.EndUpdate;
end;

function TStrings.SetFile;
   var _result:boolean;
begin
   {$I-}
   _Result:=False;
   filename:=_f;
   assignfile(mainfile,filename);
                case share of
                 FSRewrite : begin
                                Rewrite(mainfile);
                                 IF IOResult<>0 then _Result:=false
                                                else _Result:=true;
                                closefile(mainfile);
                              end;
                 FSAppend : begin
                                Reset(mainfile);
                                 if IOResult<>0 then begin
                                        ReWrite(mainfile);
                                          if IOResult<>0 then _Result:=false
                                                         else _Result:=True;
                                         ___DFixBool(_Result);
                                   end;
                                _Result:=True;
                                Closefile(mainfile);
                            end;
                   end;
                SetFile:=_result;
               {$I+}
end;

function TStrings.GetFileName;
begin
   GetFileName:=FileName;
end;

procedure TStrings.SetFileShare;
begin
   Share:=_S;
end;

function TStrings.Add;
begin
               xstrs.add(s);
               add:=true;
end;

function TStrings.Count;
begin
   count:=xstrs.count;
end;

procedure TStrings.Delete;
begin
   if xstrs.count=0 then exit;
   if i<=xstrs.count then xstrs.Delete(i-1);
end;

procedure TStrings.Insert;
begin
   if xstrs.count=0 then xstrs.add(s)
                    else begin
                     if i<=xstrs.count+1 then begin
                                                xstrs.Insert(i-1,s);
                                              end;
                    end;
end;

Procedure TStrings.Edit;
begin
   if xstrs.count=0 then exit;
   if i<=xstrs.count then begin
                       xstrs.Strings[i-1]:=s;
                     end;
end;

Function TStrings.GetString;
 var s:string;
begin
   s:='';
   if xstrs.count>0 then begin
     if i<=xstrs.count then s:=xstrs.strings[i-1];
   end;
   Result:=s;
end;

Procedure TStrings.Clear;
begin
   xstrs.clear;
end;

Procedure TStrings.Reindex;
  var s:string;
begin
   if xstrs.count=0 then exit;
   if (i<=xstrs.count)and(ir<=xstrs.count)and(i<>ir) then begin
                                     s:=getstring(i);
                                     delete(i);
                                     if i<ir then insert(ir,s);
                                     if i>ir then insert(ir,s);
                                     end;
end;

Procedure TStrings.LoadFromFile;
begin
   if fileexists(f) then xstrs.LoadFromFile(f);
   filename:=f;
end;

Procedure TStrings.SaveToFIle;
begin
   if xstrs.count=0 then exit;
   xstrs.SaveToFile(f);
end;

procedure TStrings.truncate;
  var p:integer;
  var cnt:integer;
begin
   if xstrs.count=0 then exit;
   cnt:=xstrs.count-len;
   if len<=xstrs.count then for p:=xstrs.count downto cnt+1 do delete(p);
end;

procedure TStrings.DeleteBlock;
  var p:integer;
begin
   if xstrs.count=0 then exit;
   if i+len<=xstrs.count then for p:=i to i+len-1 do delete(i);
end;

procedure TStrings.InsertBlock;
  var p:integer;
  var max:integer;
begin
   if len>_ts.count then len:=_ts.count;
   if len<>0 then max:=i+len-1 else max:=i+_ts.count-1;
   if (xstrs.count=0)and(i>1) then exit;
   for p:=i to max do insert(p,_ts.getstring(p-i+1));
end;

procedure TStrings.include;
  var p:integer;
begin
   if _ts.count>0 then begin
    for p:=1 to _ts.count do add(_ts.getstring(p));
   end;
end;

Procedure TStrings.Exclude;
  var p:integer;
begin
   if xstrs.count=0 then exit;
   for p:=1 to xstrs.count do _ts.add(getstring(p));
end;

Function TStrings.Text;
  var p:integer;
  var s,s1:string;
begin
   if xstrs.count=0 then exit;
   s:='';
   for p:=1 to xstrs.count do begin
                                 s1:=getstring(p);
                                 s:=s+s1;
                              end;
   text:=s;
end;

Function TStrings.Text1;
  var p:integer;
  var s,s1:string;
begin
   if xstrs.count=0 then exit;
   s:='';
   for p:=1 to xstrs.count do begin
                                 s1:=getstring(p);
                                 s:=s+s1+' ';
                              end;
   if length(s)>0 then s:=copy(s,1,length(s)-1);
   text1:=s;
end;

Procedure TStrings.Remain;
  var p:integer;
begin
   if xstrs.count=0 then exit;
   if len>xstrs.count then len:=xstrs.count;
   for p:=xstrs.count downto len+1 do delete(p);
end;

Procedure TStrings.TruncateStringsSize;
  var i:integer;
begin
   if xstrs.count=0 then Exit;
   for i:=1 to xstrs.count do
         if length(getstring(i))>len then Edit(i,copy(getstring(i),1,len));
end;

Procedure TStrings.SortedAsString;
   var m:integer;
   var t1:Classes.TStringList;
begin
   if xstrs.count=0 then exit;
   t1:=Classes.TStringList.Create;
   t1.CustomSort(_xCustomSort);
     for m:=1 to self.count do t1.add(self.getstring(m));
   t1.Sort;
   self.clear;
     for m:=1 to t1.count do self.add(t1.Strings[m-1]);
   t1.Free;
  end;

Procedure TStrings.SortedAsNumber;
  var i,m:integer;
  var s,s1:string;
  var flag:boolean;
  var t1:PStrings;
begin
   if xstrs.count=0 then exit;
   t1:=New(AF_Types.PStrings,Create);
   t1^.add(getstring(1));
   if xstrs.count=1 then exit;
      for m:=2 to xstrs.count do begin
       s:=xstrs.strings[m-1];
           flag:=false;
           i:=0;
                repeat
                 inc(i);
                 s1:=t1^.getstring(i);
                 if StrToIntE(s)<=StrToIntE(s1) then begin
                                      t1^.insert(i,s);
                                      flag:=true;
                                      end;
                 if (flag=false)and(i=t1^.count) then begin
                                      t1^.add(s);
                                      flag:=true;
                                      end;
                until flag=true;
      end; //for
   clear;
   include(t1^);
   dispose(t1,free);
end;

Function TStrings.SearchString;
  var i,r,z:integer;
  var k:string;
begin
   r:=0;
   if xstrs.count=0 then begin
                           searchstring:=0;
                           exit;
                         end
    else begin
//      r:=xstrs.IndexOf(_s)+1;
    end;
   z:=length(_s);
   for i:=1 to xstrs.count do begin
   k:=GetString(i);
   if length(k)=z then begin
                if k=_s then begin
                               r:=i;
                               break;
                             end;
   end;
   end;
   SearchString:=r;
end;

Function TStrings.SearchStrings;
  var i,r:integer;
begin
   r:=0;
   _p.clear;
   if xstrs.count=0 then begin
                           searchstrings:=0;
                           exit;
                         end;
   for i:=1 to xstrs.count do
                if GetString(i)=_s then begin
                   _p.add(inttostr(i));
                   inc(r);
                end;
   SearchStrings:=r;
end;

Function TStrings.SearchText;
  var i,r:integer;
  var s:string;
begin
   r:=0;
   if xstrs.count=0 then begin
                 searchtext:=0;
                 exit;
                end;
   for i:=1 to xstrs.count do begin
                 s:=GetString(i);
                 if Pos(_s,s)>0 then begin
                                       r:=i;
                                       break;
                                     end;
   end; //for
   SearchText:=r;
end;




Function TFileReport.Add;
begin
   inherited add(s);
   {$I-}
   append(mainfile);
   if IOResult<>0 then begin
                          ReWrite(mainfile);
                          if IOResult<>0 then Add:=false
                                         else add:=true;
                          end
                            else add:=true;
                          WriteLn(mainfile,s);
                          closefile(mainfile);
                          if IOResult<>0 then Add:=false;
   {$I+}
end;


end.
