unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, AF_Proc, AF_Types, MySQL, MySQLClasses, ComCtrls,
  OleServer, ExcelXP;

type

  TTariffList = packed record
    etrain,reduced,child,handbag,animal,velzh,m1,m1r,m3,m3r,m12,d5,d10,dat5,dat6,dat7,dat8,dat9,dat10,dat11,dat12,dat13,dat14,dat15,dat16,p10,p20,p60,vyhdn,
    mcd, mcd_dal, mcd_1dat, mcd_3dat, mcd_30dat, mcd_90dat, mcd_365dat, mcd_1m_st, mcd_3m_st, mcd_60p :integer;
  end;

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    StatusBar1: TStatusBar;
    Button7: TButton;
    Button8: TButton;
    Button10: TButton;
    Button9: TButton;
    Button11: TButton;
    Button12: TButton;
    XLApp: TExcelApplication;
    OpenDialog1: TOpenDialog;
    Button13: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  cfg_mysql_host, cfg_mysql_port, cfg_mysql_database, cfg_mysql_user, cfg_mysql_password: string;

const workdir:string='C:\AF\\\ \';

implementation

{$R *.dfm}

procedure ClearTariffList(var tl:TTariffList);
begin
  tl.etrain:=0;
  tl.reduced:=0;
  tl.child:=0;
  tl.handbag:=0;
  tl.animal:=0;
  tl.velzh:=0;
  tl.m1:=0;
  tl.m1r:=0;
  tl.m3:=0;
  tl.m3r:=0;
  tl.m12:=0;
  tl.d5:=0;
  tl.d10:=0;
  tl.dat5:=0;
  tl.dat6:=0;
  tl.dat7:=0;
  tl.dat8:=0;
  tl.dat9:=0;
  tl.dat10:=0;
  tl.dat11:=0;
  tl.dat12:=0;
  tl.dat13:=0;
  tl.dat14:=0;
  tl.dat15:=0;
  tl.dat16:=0;
  tl.p10:=0;
  tl.p20:=0;
  tl.p60:=0;
  tl.vyhdn:=0;
end;

function LoadMainIni:boolean;         
  var chg:AF_Types.TStrings;
  var i:integer;
  var s,s1,s2,s3,s4,ip:string;
  var res:boolean;
begin
  chg.create;
  chg.loadfromfile(deleteslasheex(ExtractDirPath(Application.ExeName))+'\main.ini');
  if chg.count>0 then begin
    for i:=1 to chg.count do begin
      s:=trim(chg.getstring(i));
      s:=strreplace(s,#9,#32);
      if length(s)>0 then begin
        if not (s[1]=';') then begin
          if pos(' ',s)>0 then begin
            s1:=trim(copy(s,1,pos(' ',s)-1));
            s2:=trim(copy(s,pos(' ',s)+1,length(s)-pos(' ',s)));
            s1:=ansilowercase(s1);
            if s1='mysql_host' then begin
              if {isIp(s)}true then cfg_mysql_host:=s2;
            end;
            if s1='mysql_port' then begin
              cfg_mysql_port:=s2;
            end;
            if s1='mysql_database' then begin
              cfg_mysql_database:=s2;
            end;
            if s1='mysql_user' then begin
              cfg_mysql_user:=s2;
            end;
            if s1='mysql_password' then begin
              cfg_mysql_password:=s2;
            end;
          end;
        end;
      end;
    end;
  end;
  chg.free;
  res:=true;
  result:=res;
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
//  workdir:=deleteslasheex(ExtractDirPath(Application.ExeName))+'\';
  loadmainini;
end;

function getParam(s1,s:string):string;
  var s2:string;
begin
  s:=trim(s);
  s2:='';
  if pos(s1+'="',s)>0 then begin
    s2:=copy(s,pos(s1+'="',s)+2+length(s1),length(s));
     if pos('"',s2)>0 then s2:=copy(s2,1,pos('"',s2)-1);
  end;
  result:=trim(s2);
end;

procedure TForm1.Button1Click(Sender: TObject);
  var fl,f,fo:AF_Types.Tstrings;
  var ff,i,n,nn:integer;
  var s,s1,s2:string;
  var idx:string;
  var flg:boolean;
begin
   f.create; fl.create; fo.create;
   GetMaskList(workdir+'*.xml',@fl);
   if fl.count>0 then begin
    for ff:=1 to fl.count do begin
      f.loadfromfile(workdir+fl.getstring(ff));
      flg:=false;
      if f.count>0 then begin
        for nn:=1 to f.count do begin
         s:=ansilowercase(trim(f.getstring(nn)));
         if pos('<tarifinfo ',s)>0 then begin
          idx:=getparam('serverid',s);
         end;
         if pos('<subwdocs>',s)>0 then flg:=true;
         if pos('</subwdocs>',s)>0 then flg:=false;
         if pos('<doc ',s)>0 then begin
          if flg then fo.add(idx+';'+getparam('id',s)+';'+getparam('name',s));
         end;
        end;
      end;
    end;
   end;
   fo.savetofile(workdir+'docs000.csv');
   fl.free; f.free; fo.free;
   showmessage('end!');
end;

procedure TForm1.Button2Click(Sender: TObject);
  var fl,f,fo:AF_Types.Tstrings;
  var ff,i,n,nn:integer;
  var s,s1,s2:string;
  var idx:string;
  var flg:boolean;
begin
   f.create; fl.create; fo.create;
   GetMaskList(workdir+'*.xml',@fl);
   if fl.count>0 then begin
    for ff:=1 to fl.count do begin
      f.loadfromfile(workdir+fl.getstring(ff));
      flg:=false;
      if f.count>0 then begin
        for nn:=1 to f.count do begin
         s:=ansilowercase(trim(f.getstring(nn)));
         if pos('<tarifinfo ',s)>0 then begin
          idx:=getparam('serverid',s);
         end;
         if pos('<tplan ',s)>0 then begin
          fo.add(idx+';'+getparam('id',s)+';'+getparam('name',s));
         end;
        end;
      end;
    end;
   end;
   fo.savetofile(workdir+'tplan000.csv');
   fl.free; f.free; fo.free;
   showmessage('end!');
end;

function probearr(i:integer):boolean;
begin
 result:=false;
if i=101 then result:=true;
if i=103 then result:=true;
if i=107 then result:=true;
if i=108 then result:=true;
if i=109 then result:=true;
if i=110 then result:=true;
if i=111 then result:=true;
if i=112 then result:=true;
if i=201 then result:=true;
if i=301 then result:=true;
if i=303 then result:=true;
if i=309 then result:=true;
if i=310 then result:=true;
if i=311 then result:=true;
if i=312 then result:=true;
if i=401 then result:=true;
if i=402 then result:=true;
if i=403 then result:=true;
if i=404 then result:=true;
if i=405 then result:=true;
if i=406 then result:=true;
if i=407 then result:=true;
if i=408 then result:=true;
if i=409 then result:=true;
if i=410 then result:=true;
if i=411 then result:=true;
if i=412 then result:=true;
if i=501 then result:=true;
if i=502 then result:=true;
if i=503 then result:=true;
if i=504 then result:=true;
end;

function probearr1(i:integer):boolean;
begin
 result:=false;
if i=1 then result:=true;
if i=2 then result:=true;
if i=601 then result:=true;
if i=602 then result:=true;
if i=603 then result:=true;
end;

procedure TForm1.Button3Click(Sender: TObject);
  var fl,f,fo:AF_Types.Tstrings;
  var ff,i,n,nn,doc1:integer;
  var s,s1,s2:string;
  var idx,idv,idn:string;
  var flg:boolean;
begin
   f.create; fl.create; fo.create;
   GetMaskList(workdir+'*.xml',@fl);
   if fl.count>0 then begin
    fo.add('TRUNCATE TABLE `cppkt`.`vtlist`;');
    for ff:=1 to fl.count do begin
      f.loadfromfile(workdir+fl.getstring(ff));
      flg:=false;
      if f.count>0 then begin
        for nn:=1 to f.count do begin
         s:=ansilowercase(trim(f.getstring(nn)));
         if pos('<tarifinfo ',s)>0 then idx:=getparam('serverid',s);
         if pos('<tarif ',s)>0 then idv:=getparam('v',s);
         if pos('<vt ',s)>0 then idn:=getparam('n',s);
         if pos('<vtarif>',s)>0 then flg:=true;
         if pos('</vtarif>',s)>0 then flg:=false;
         if pos('<doc ',s)>0 then begin
          if flg then begin
            s1:=getparam('id',s);
            if probearr(strtointe(s1)) then begin
              s2:=getparam('tariff',s);
              fo.add('INSERT INTO `cppkt`.`vtlist` (`f`, `v`, `n`, `d`, `t`) VALUES ('+idx+', '+#39+idv+#39+', '+idn+', '+s1+', '+#39+s2+#39+');');
            end;
          end;
         end;
        end;
      end;
    end;
   end;
   fo.savetofile(workdir+'vt.sql');
   fl.free; f.free; fo.free;
   showmessage('end!');
end;

procedure TForm1.Button4Click(Sender: TObject);
  var fl,f,fo,st1,st2:AF_Types.Tstrings;
  var ff,i,n,nn:integer;
  var s,s1,s2:string;
  var idx:string;
  var flg:boolean;
begin
   f.create; fl.create; fo.create; st1.create; st2.create;
   GetMaskList(workdir+'*.xml',@fl);
   if fl.count>0 then begin
    for ff:=1 to fl.count do begin
      f.loadfromfile(workdir+fl.getstring(ff));
      flg:=false;
      if f.count>0 then begin
        for nn:=1 to f.count do begin
         s:=ansilowercase(trim(f.getstring(nn)));
         if pos('<stations>',s)>0 then flg:=true;
         if pos('</stations>',s)>0 then flg:=false;
         if pos('<station ',s)>0 then begin
          if flg then begin
           s1:=getparam('e',s);
           s2:=getparam('name',s);
           n:=st1.SearchString(s1);
           if n>0 then begin
            if s2<>st2.getstring(n) then fo.add('   '+s1+': '+s2+'  '+st2.getstring(n));
           end
            else begin
             st1.add(s1);
             st2.add(s2);
            end;
          end;
         end;
        end;
      end;
    end;
   end;
   if st1.count>0 then begin
    for i:=1 to st1.count do begin
      fo.add(st1.getstring(i)+';'+st2.getstring(i));
    end;
   end;
   fo.savetofile(workdir+'stations000.csv');
   fl.free; f.free; fo.free;
   showmessage('end!');
end;

procedure ParseCSVStrEx(ts:AF_Types.PStrings; s:widestring; c:char);
 var n:integer;
begin
  ts.clear;
  while pos(c,s)>0 do begin
    n:=pos(c,s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;

procedure TForm1.Button5Click(Sender: TObject);
var st1,st2,st3,st4,fo,u:AF_Types.TStrings;
var i,n,m:integer;
begin
 st1.create; st2.create; st3.create; st4.create; fo.create; u.create;
 fo.loadfromfile(workdir+'stations000.csv');
 if fo.count>0 then begin
  for i:=1 to fo.count do begin
    ParseCSVStrEx(@u,fo.getstring(i),';');
    if u.count>1 then begin
     st1.add(u.getstring(1));
     st2.add(u.getstring(2));
    end;
  end;
 end;
 fo.clear;
 fo.loadfromfile(workdir+'stationcodes.lst');
 if fo.count>0 then begin
  for i:=1 to fo.count do begin
    ParseCSVStrEx(@u,fo.getstring(i),';');
    if u.count>2 then begin
     st3.add(u.getstring(2));
     st4.add(u.getstring(3));
    end;
  end;
 end;
 fo.clear;
 u.clear;
 if st1.count>0 then begin
  for i:=1 to st1.count do begin
    n:=st3.SearchString(st1.getstring(i));
    if n>0 then begin
     fo.add(st1.getstring(i)+';'+st2.getstring(i)+';'+st4.getstring(n));
    end
     else begin
      u.add(st1.getstring(i)+';'+st2.getstring(i)+';'+'  !!!');
     end;
  end;
  if u.count>0 then fo.include(u);
 end;
 fo.savetofile(workdir+'stations_cppk_NEW.csv');
 st1.free; st2.free; st3.free; st4.free; fo.free; u.free;
 showmessage('end!');
end;

procedure ShowMySQLError(MySQL:IMySQL);
begin
  ShowMessage(Format(' #%d - %s', [MySQL.ErrorCode, MySQL.ErrorMessage]));
end;

function getDoc(s:string; doc1,doc2:AF_Types.PStrings):string;
 var n:integer;
begin
 result:='';
 n:=doc1.SearchString(s);
 if n>0 then result:=doc2.getstring(n);
end;

procedure TForm1.Button6Click(Sender: TObject);
  var fl,f,fo,fo2,st1,st2,st3,u,doc1,doc2:AF_Types.Tstrings;
  var ff,i,n,nn,frs,tos:integer;
  var s,s1,s2:string;
  var idx,idt,idd,doc,dstart:string;
  var flg,flg1:boolean;
  var MySQL: IMySQL;
  var query_result: IMySQLQuery;
  var q1:string;
begin
  f.create; fl.create; fo.create; st1.create; st2.create; st3.create; u.create; doc1.create; doc2.create; fo2.create;
  fo2.add('TRUNCATE TABLE `tarlist`;');
  fo.add('<?xml version="1.0" encoding="Windows-1251"?>');
  fo.add('');
  fo.add('<channel>');
  MySQL := TMySQL.Create;
  MySQL.Host := cfg_mysql_host;
  MySQL.Port := strtointe(cfg_mysql_port);
  MySQL.User := cfg_mysql_user;
  MySQL.Password := cfg_mysql_password;
  if not MySQL.Connect then ShowMySQLError(MySQL)
  else begin
   MySQL.Database := cfg_mysql_database;
   MySQL.Query('set character_set_client=''cp1251'';');
   MySQL.Query('set character_set_results=''cp1251'';');
   MySQL.Query('set collation_connection=''cp1251_bin'';');
   fo.loadfromfile(workdir+'stations_cppk.csv');
   if fo.count>0 then begin
    for i:=1 to fo.count do begin
      ParseCSVStrEx(@u,fo.getstring(i),';');
      if u.count>2 then begin
       st1.add(u.getstring(1));
       st2.add(u.getstring(2));
       st3.add(u.getstring(3));
      end;
    end;
   end;
   fo.clear;
   fo.loadfromfile(workdir+'docs.csv');
   if fo.count>0 then begin
    for i:=1 to fo.count do begin
      ParseCSVStrEx(@u,fo.getstring(i),';');
      if u.count>2 then begin
       doc1.add(u.getstring(1));
       doc2.add(u.getstring(3));
      end;
    end;
   end;
   fo.clear;
   GetMaskList(workdir+'*.xml',@fl);
   if fl.count>0 then begin
    for ff:=1 to fl.count do begin
      f.loadfromfile(workdir+fl.getstring(ff));
      flg:=false;
      flg1:=false;
      if f.count>0 then begin
        for nn:=1 to f.count do begin
         s:=ansilowercase(trim(f.getstring(nn)));
         if pos('<tarifinfo ',s)>0 then idx:=getparam('serverid',s);
         if pos('<tplan ',s)>0 then begin
           if getParam('name',s)='' then flg:=true;
           dstart:=getParam('dstart',s);
           frs:=0;
           tos:=0;
           flg1:=false;
         end;
         if pos('</tplan>',s)>0 then begin
           frs:=0;
           tos:=0;
           flg:=false;
           flg1:=false;
         end;
         if pos('<fromstation ',s)>0 then begin
          if flg then begin
           s1:=getparam('e',s);
           idt:=getparam('t',s);
           n:=st1.SearchString(s1);
           if n>0 then frs:=n;
          end;
         end;
         if pos('<tostation ',s)>0 then begin
          if flg then begin
          if frs>0 then begin
           s1:=getparam('e',s);
           idd:=getparam('dist',s);
           n:=st1.SearchString(s1);
           if n>0 then begin
             tos:=n;
             flg1:=true;
           end;
          end;
          end;
         end;
         if pos('</tostation>',s)>0 then begin
           tos:=0;
           flg1:=false;
         end;
         if pos('</fromstation>',s)>0 then begin
           frs:=0;
           tos:=0;
           flg1:=false;
         end;
         if pos('<vt ',s)>0 then begin
           if {fo.count<10000}true then begin
           if flg then begin
           if flg1 then begin
             s1:=getparam('v',s);
             if length(s1)=1 then begin
              if s1[1] in ['a', 'v', 'w', 'd', 'n'] then begin
               s2:=getparam('n',s);
//               fo.add(idx+'  '+st2.getstring(frs)+' - '+st2.getstring(tos)+' dist='+idd+' v='+s1+' n='+s2);
                q1:='SELECT * FROM `vtlist` WHERE f='+idx+' AND v='+#39+s1+#39+' AND n='+s2;
//                inputquery('','',q1);
                query_result:=MySQL.Query(q1);
                 if query_result = nil then ShowMySQLError(MySQL)
                    else begin
                      while query_result.FetchRow do begin
                        statusbar1.SimpleText:=inttostr(fo.count);
                        application.ProcessMessages;
                        doc:=getDoc(query_result.ValueByName['d'],@doc1,@doc2);
                        if doc<>'' then begin
                          fo.add('  <tarif file="'+idx+'" dstart="'+dstart+'" station1="'+st3.getstring(frs)+'" station2="'+st3.getstring(tos)+'" price="'+query_result.ValueByName['t']+'" type="'+doc+'" reverse="0" />');
                          fo2.add('INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES ('+idx+', '+#39+dstart+#39+', '+st1.getstring(frs)+', '+st1.getstring(tos)+', '+#39+query_result.ValueByName['t']+#39+', '+#39+doc+#39+', '+#39+s1+#39+', '+s2+');');
                        end;
//                        ts.add(query_result.ValueByName['stname']+';'+query_result.ValueByName['arrival']+';'+query_result.ValueByName['departure']+';'+query_result.ValueByName['link']+';'+query_result.ValueByName['stcode']+';');
                      end;
                    end;
              end;
             end;
           end;
           end;
           end;
         end;
        end;
      end;
    end;
   end;
   MySQL.Disconnect;
   fo.add('</channel>');
//   fo.savetofile(workdir+'tariff.xml');
   fo2.savetofile(workdir+'tariff.sql');
   fl.free; f.free; fo.free; st1.free; st2.free; st3.free; u.free; doc1.free; doc2.free; fo2.free;
   showmessage('end!');
  end;
end;

procedure TForm1.Button7Click(Sender: TObject);
  var fl,f,fo,fo2,st1,st2,st3,u,doc1,doc2:AF_Types.Tstrings;
  var ff,i,n,nn,frs,tos:integer;
  var s,s1,s2:string;
  var idx,idt,idd,doc,dstart,did:string;
  var flg,flg1:boolean;
  var MySQL: IMySQL;
  var query_result: IMySQLQuery;
  var q1:string;
begin
  f.create; fl.create; fo.create; st1.create; st2.create; st3.create; u.create; doc1.create; doc2.create; fo2.create;
  fo.add('<?xml version="1.0" encoding="Windows-1251"?>');
  fo.add('');
  fo.add('<channel>');
  MySQL := TMySQL.Create;
  MySQL.Host := cfg_mysql_host;
  MySQL.Port := strtointe(cfg_mysql_port);
  MySQL.User := cfg_mysql_user;
  MySQL.Password := cfg_mysql_password;
  if not MySQL.Connect then ShowMySQLError(MySQL)
  else begin
   MySQL.Database := cfg_mysql_database;
   MySQL.Query('set character_set_client=''cp1251'';');
   MySQL.Query('set character_set_results=''cp1251'';');
   MySQL.Query('set collation_connection=''cp1251_bin'';');
   fo.loadfromfile(workdir+'stations_cppk.csv');
   if fo.count>0 then begin
    for i:=1 to fo.count do begin
      ParseCSVStrEx(@u,fo.getstring(i),';');
      if u.count>2 then begin
       st1.add(u.getstring(1));
       st2.add(u.getstring(2));
       st3.add(u.getstring(3));
      end;
    end;
   end;
   fo.clear;
   fo.loadfromfile(workdir+'docs.csv');
   if fo.count>0 then begin
    for i:=1 to fo.count do begin
      ParseCSVStrEx(@u,fo.getstring(i),';');
      if u.count>2 then begin
       doc1.add(u.getstring(1));
       doc2.add(u.getstring(3));
      end;
    end;
   end;
   fo.clear;
   GetMaskList(workdir+'*.xml',@fl);
   if fl.count>0 then begin
    for ff:=1 to fl.count do begin
      f.loadfromfile(workdir+fl.getstring(ff));
      flg:=false;
      flg1:=false;
      if f.count>0 then begin
        for nn:=1 to f.count do begin
         s:=ansilowercase(trim(f.getstring(nn)));
         if pos('<tarifinfo ',s)>0 then idx:=getparam('serverid',s);
         if pos('<tplan ',s)>0 then begin
           if getParam('name',s)='' then flg:=true;
           dstart:=getParam('dstart',s);
           did:=getParam('id',s);
           frs:=0;
           tos:=0;
           flg1:=false;
         end;
         if pos('</tplan>',s)>0 then begin
           frs:=0;
           tos:=0;
           flg:=false;
           flg1:=false;
         end;
         if pos('<fromstation ',s)>0 then begin
          if flg then begin
           s1:=getparam('e',s);
           idt:=getparam('t',s);
           n:=st1.SearchString(s1);
           if n>0 then frs:=n;
          end;
         end;
         if pos('<tostation ',s)>0 then begin
          if flg then begin
          if frs>0 then begin
           s1:=getparam('e',s);
           idd:=getparam('dist',s);
           n:=st1.SearchString(s1);
           if n>0 then begin
             tos:=n;
             flg1:=true;
           end;
          end;
          end;
         end;
         if pos('</tostation>',s)>0 then begin
           tos:=0;
           flg1:=false;
         end;
         if pos('</fromstation>',s)>0 then begin
           frs:=0;
           tos:=0;
           flg1:=false;
         end;
         if pos('<vt ',s)>0 then begin
           if {fo.count<10000}true then begin
           if flg then begin
           if flg1 then begin
             s1:=getparam('v',s);
             if length(s1)=1 then begin
              if ((s1[1]='r')or(s1[1]='k')) then begin
               s2:=getparam('n',s);
//               fo.add(idx+'  '+st2.getstring(frs)+' - '+st2.getstring(tos)+' dist='+idd+' v='+s1+' n='+s2);
                q1:='SELECT * FROM `vtlist` WHERE f='+idx+' AND v='+#39+s1+#39+' AND n='+s2;
//                inputquery('','',q1);
                query_result:=MySQL.Query(q1);
                 if query_result = nil then ShowMySQLError(MySQL)
                    else begin
                      while query_result.FetchRow do begin
                        statusbar1.SimpleText:=inttostr(fo.count);
                        application.ProcessMessages;
                        doc:=getDoc(query_result.ValueByName['d'],@doc1,@doc2);
                        if doc<>'' then begin
                          fo.add('  <tarif file="'+idx+'" dstart="'+dstart+'" station1="'+st3.getstring(frs)+'" station2="'+st3.getstring(tos)+'" price="'+query_result.ValueByName['t']+'" type="'+doc+'" reverse="0" />');
                          fo2.add('INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES ('+idx+', '+#39+dstart+#39+', '+st1.getstring(frs)+', '+st1.getstring(tos)+', '+#39+query_result.ValueByName['t']+#39+', '+#39+doc+#39+', '+#39+s1+#39+', '+s2+');');
                        end;
//                        ts.add(query_result.ValueByName['stname']+';'+query_result.ValueByName['arrival']+';'+query_result.ValueByName['departure']+';'+query_result.ValueByName['link']+';'+query_result.ValueByName['stcode']+';');
                      end;
                    end;
              end;
             end;
           end;
           end;
           end;
         end;
        end;
      end;
    end;
   end;
   MySQL.Disconnect;
   fo.add('</channel>');
//   fo.savetofile(workdir+'tariff1.xml');
   fo2.savetofile(workdir+'tariff1.sql');
   fl.free; f.free; fo.free; st1.free; st2.free; st3.free; u.free; doc1.free; doc2.free; fo2.free;
   showmessage('end!');
  end;
end;


procedure TForm1.Button8Click(Sender: TObject);
  var fl,f,fo:AF_Types.Tstrings;
  var ff,i,n,nn,doc1:integer;
  var s,s1,s2:string;
  var idx,idv,idn:string;
  var flg:boolean;
begin
   f.create; fl.create; fo.create;
   GetMaskList(workdir+'*.xml',@fl);
   if fl.count>0 then begin
    for ff:=1 to fl.count do begin
      f.loadfromfile(workdir+fl.getstring(ff));
      flg:=false;
      if f.count>0 then begin
        for nn:=1 to f.count do begin
         s:=ansilowercase(trim(f.getstring(nn)));
         if pos('<tarifinfo ',s)>0 then idx:=getparam('serverid',s);
         if pos('<tarif ',s)>0 then idv:=getparam('v',s);
         if pos('<vt ',s)>0 then idn:=getparam('n',s);
         if pos('<vtarif>',s)>0 then flg:=true;
         if pos('</vtarif>',s)>0 then flg:=false;
         if pos('<doc ',s)>0 then begin
          if flg then begin
            s1:=getparam('id',s);
            if probearr1(strtointe(s1)) then begin
              s2:=getparam('tariff',s);
              fo.add('INSERT INTO `cppkt`.`vtlist` (`f`, `v`, `n`, `d`, `t`) VALUES ('+idx+', '+#39+idv+#39+', '+idn+', '+s1+', '+#39+s2+#39+');');
            end;
          end;
         end;
        end;
      end;
    end;
   end;
   fo.savetofile(workdir+'vtetrain.sql');
   fl.free; f.free; fo.free;
   showmessage('end!');
end;

procedure TForm1.Button10Click(Sender: TObject);
  var fo,t1,t2,td,tf,mt1,mt2,mt3,u,fo1,tv,tn:AF_Types.TStrings;
  var MySQL: IMySQL;
  var query_result: IMySQLQuery;
  var q1,so,s1,s2,st,sd,sf,sx,mts1,mts2,sv,sn:string;
  var q,n,i,m1,m2:integer;
  var v:int64;
begin
  fo.create; t1.create; t2.create; td.create; tf.create; mt1.create; mt2.create; mt3.create; u.create; fo1.create; tv.create; tn.create;
  fo.loadfromfile(workdir+'stations_cppk.csv');
   if fo.count>0 then begin
    for i:=1 to fo.count do begin
      ParseCSVStrEx(@u,fo.getstring(i),';');
      if u.count>2 then begin
       mt1.add(u.getstring(1));
       mt2.add(u.getstring(2));
       mt3.add(u.getstring(3));
      end;
    end;
   end;
  fo.clear;
  fo1.add('type;st1_name;st1_code;st2_name;st2_code;tariff1;tariff1_file;tariff1_start;tariff1_v,tariff1_n;tariff2;tariff2_file;tariff2_start;tariff2_v;tariff2_n');
  MySQL := TMySQL.Create;
  MySQL.Host := cfg_mysql_host;
  MySQL.Port := strtointe(cfg_mysql_port);
  MySQL.User := cfg_mysql_user;
  MySQL.Password := cfg_mysql_password;
  if not MySQL.Connect then ShowMySQLError(MySQL)
  else begin
   MySQL.Database := cfg_mysql_database;
   MySQL.Query('set character_set_client=''cp1251'';');
   MySQL.Query('set character_set_results=''cp1251'';');
   MySQL.Query('set collation_connection=''cp1251_bin'';');
   n:=0;
   v:=0;
   so:='vdv23r123rsdc';
   t1.clear; t2.clear; td.clear; tf.clear; tv.clear; tn.clear;
   q1:='SELECT * FROM `tarlist` WHERE 1 ORDER BY st1,st2,type';
   query_result:=MySQL.Query(q1);
    if query_result = nil then ShowMySQLError(MySQL)
     else begin
      while query_result.FetchRow do begin
        v:=v+1;
        form1.StatusBar1.SimpleText:=inttostr(v);
        application.ProcessMessages;
        s1:=query_result.ValueByName['st1'];
        s2:=query_result.ValueByName['st2'];
        sx:=query_result.ValueByName['type'];
        st:=query_result.ValueByName['price'];
        sd:=query_result.ValueByName['dstart'];
        sf:=query_result.ValueByName['file'];
        sv:=query_result.ValueByName['v'];
        sn:=query_result.ValueByName['n'];
        if s1<>so then begin
          n:=1;
          t1.clear; t2.clear; td.clear; tf.clear; tv.clear; tn.clear;
          t1.add(s1+';'+s2+';'+sx);
          t2.add(st);
          td.add(sd);
          tf.add(sf);
          tv.add(sv);
          tn.add(sn);
          so:=s1;
        end
         else begin
          q:=t1.SearchString(s1+';'+s2+';'+sx);
          if q>0 then begin
           if t2.getstring(q)<>st then begin
             m1:=mt1.SearchString(s1);
             m2:=mt1.SearchString(s2);
             if m1>0 then mts1:=mt2.getstring(m1) else mts1:='???';
             if m2>0 then mts2:=mt2.getstring(m2) else mts2:='???';
             fo.add('    "'+sx+'": '+mts1+' ('+s1+') - '+mts2+' ('+s2+') = '+t2.getstring(q)+' (  '+tf.getstring(q)+',   '+td.getstring(q)+' v='+tv.getstring(q)+' n='+tn.getstring(q)+')  '+st+' (  '+sf+',   '+sd+' v='+sv+' n='+sn+')');
             fo1.add(sx+';'+mts1+';'+s1+';'+mts2+';'+s2+';'+t2.getstring(q)+';'+tf.getstring(q)+';'+td.getstring(q)+';'+tv.getstring(q)+';'+tn.getstring(q)+';'+st+';'+sf+';'+sd+';'+sv+';'+sn);
           end;
          end
           else begin
            inc(n);
            t1.add(s1+';'+s2+';'+sx);
            t2.add(st);
            td.add(sd);
            tf.add(sf);
            tv.add(sv);
            tn.add(sn);
           end;
         end;
      end; //while
     end;
  end;
  fo.add('end!');
  fo.savetofile(workdir+'tariff.log');
  fo1.savetofile(workdir+'tariff.log.csv');
  fo.free; t1.free; t2.free; td.free; tf.free; mt1.free; mt2.free; mt3.free; u.free; fo1.free; tv.free; tn.free;
  showmessage('end!');
end;

procedure TForm1.Button9Click(Sender: TObject);
  var fo,t1,t2,td,tf,mt1,mt2,mt3,u,fo1,tv,tn:AF_Types.TStrings;
  var MySQL: IMySQL;
  var query_result,query_result2: IMySQLQuery;
  var q1,q2,so,s1,s2,st,sd,sf,sx,mts1,mts2,sv,sn,j1,j2,jx,jt,jd,jf,jn,jv:string;
  var q,n,i,m1,m2:integer;
  var v:int64;
begin
  fo.create; t1.create; t2.create; td.create; tf.create; mt1.create; mt2.create; mt3.create; u.create; fo1.create; tv.create; tn.create;
  fo.loadfromfile(workdir+'stations_cppk.csv');
   if fo.count>0 then begin
    for i:=1 to fo.count do begin
      ParseCSVStrEx(@u,fo.getstring(i),';');
      if u.count>2 then begin
       mt1.add(u.getstring(1));
       mt2.add(u.getstring(2));
       mt3.add(u.getstring(3));
      end;
    end;
   end;
  fo.clear;
  fo1.add('type;st1_name;st1_code;st2_name;st2_code;tariff1;tariff1_file;tariff1_start;tariff1_v,tariff1_n;tariff2;tariff2_file;tariff2_start;tariff2_v;tariff2_n');
  MySQL := TMySQL.Create;
  MySQL.Host := cfg_mysql_host;
  MySQL.Port := strtointe(cfg_mysql_port);
  MySQL.User := cfg_mysql_user;
  MySQL.Password := cfg_mysql_password;
  if not MySQL.Connect then ShowMySQLError(MySQL)
  else begin
   MySQL.Database := cfg_mysql_database;
   MySQL.Query('set character_set_client=''cp1251'';');
   MySQL.Query('set character_set_results=''cp1251'';');
   MySQL.Query('set collation_connection=''cp1251_bin'';');
   n:=0;
   v:=0;
   so:='vdv23r123rsdc';
   t1.clear; t2.clear; td.clear; tf.clear; tv.clear; tn.clear;
   q1:='SELECT * FROM `tarlist` WHERE 1 ORDER BY st1,st2,type';
   query_result:=MySQL.Query(q1);
    if query_result = nil then ShowMySQLError(MySQL)
     else begin
      while query_result.FetchRow do begin
        v:=v+1;
        form1.StatusBar1.SimpleText:=inttostr(v);
        application.ProcessMessages;
        s1:=query_result.ValueByName['st1'];
        s2:=query_result.ValueByName['st2'];
        sx:=query_result.ValueByName['type'];
        st:=query_result.ValueByName['price'];
        sd:=query_result.ValueByName['dstart'];
        sf:=query_result.ValueByName['file'];
        sv:=query_result.ValueByName['v'];
        sn:=query_result.ValueByName['n'];
        if s1<>so then begin
          n:=1;
          t1.clear; t2.clear; td.clear; tf.clear; tv.clear; tn.clear;
          q2:='SELECT * FROM `tarlist` WHERE st2='+s1+' ORDER BY st1,st2,type';
           query_result2:=MySQL.Query(q2);
            if query_result2 = nil then ShowMySQLError(MySQL)
             else begin
              while query_result2.FetchRow do begin
                j1:=query_result2.ValueByName['st1'];
                j2:=query_result2.ValueByName['st2'];
                jx:=query_result2.ValueByName['type'];
                jt:=query_result2.ValueByName['price'];
                jd:=query_result2.ValueByName['dstart'];
                jf:=query_result2.ValueByName['file'];
                jv:=query_result2.ValueByName['v'];
                jn:=query_result2.ValueByName['n'];
                t1.add(j2+';'+j1+';'+jx);
                t2.add(jt);
                td.add(jd);
                tf.add(jf);
                tv.add(jv);
                tn.add(jn);
              end;
             end;
          so:=s1;
        end;
          q:=t1.SearchString(s1+';'+s2+';'+sx);
          if q>0 then begin
           if t2.getstring(q)<>st then begin
             m1:=mt1.SearchString(s1);
             m2:=mt1.SearchString(s2);
             if m1>0 then mts1:=mt2.getstring(m1) else mts1:='???';
             if m2>0 then mts2:=mt2.getstring(m2) else mts2:='???';
             fo.add('    "'+sx+'": '+mts1+' ('+s1+') - '+mts2+' ('+s2+') = '+t2.getstring(q)+' (   '+tf.getstring(q)+',   '+td.getstring(q)+' v='+tv.getstring(q)+' n='+tn.getstring(q)+')  '+st+' (   '+sf+',   '+sd+' v='+sv+' n='+sn+')');
             fo1.add(sx+';'+mts1+';'+s1+';'+mts2+';'+s2+';'+t2.getstring(q)+';'+tf.getstring(q)+';'+td.getstring(q)+';'+tv.getstring(q)+';'+tn.getstring(q)+';'+st+';'+sf+';'+sd+';'+sv+';'+sn);
           end;
          end
           else begin
            inc(n);
           end;
      end; //while
     end;
  end;
  fo.add('end!');
  fo1.add('end!');
  fo.savetofile(workdir+'tariff_reverse.log');
  fo1.savetofile(workdir+'tariff_reverse.log.csv');
  fo.free; t1.free; t2.free; td.free; tf.free; mt1.free; mt2.free; mt3.free; u.free; fo1.free; tv.free; tn.free;
  showmessage('end!');
end;
procedure TForm1.Button11Click(Sender: TObject);
var st1,st2,st3,st4,st5,fo,u:AF_Types.TStrings;
var i,n,m,q:integer;
begin
 st1.create; st2.create; st3.create; st4.create; fo.create; u.create; st5.create;
 fo.loadfromfile(workdir+'stations000.csv');
 if fo.count>0 then begin
  for i:=1 to fo.count do begin
    ParseCSVStrEx(@u,fo.getstring(i),';');
    if u.count>1 then begin
     st1.add(u.getstring(1));
     st2.add(u.getstring(2));
    end;
  end;
 end;
 fo.clear;
 fo.loadfromfile(workdir+'stationcodes.lst');
 if fo.count>0 then begin
  for i:=1 to fo.count do begin
    ParseCSVStrEx(@u,fo.getstring(i),';');
    if u.count>2 then begin
     st3.add(u.getstring(2));
     st4.add(u.getstring(3));
    end;
  end;
 end;
 fo.clear;
 fo.loadfromfile(workdir+'stations_cppk.csv');
 if fo.count>0 then begin
  for i:=1 to fo.count do begin
    ParseCSVStrEx(@u,fo.getstring(i),';');
    if u.count>2 then begin
     st5.add(u.getstring(1));
    end;
  end;
 end;
 fo.clear;
 u.clear;
 if st1.count>0 then begin
  for i:=1 to st1.count do begin
   n:=st3.SearchString(st1.getstring(i));
   q:=st5.SearchString(st1.getstring(i));
   if q<=0 then begin
    if n>0 then begin
     fo.add(st1.getstring(i)+';'+st2.getstring(i)+';'+st4.getstring(n));
    end
     else begin
      u.add(st1.getstring(i)+';'+st2.getstring(i)+';'+'  !!!');
     end;
   end;
  end;
  if u.count>0 then fo.include(u);
 end;
 fo.savetofile(workdir+'stations_cppk_NEW2.csv');
 st1.free; st2.free; st3.free; st4.free; fo.free; u.free; st5.free;
 showmessage('end!');
end;

procedure TForm1.Button12Click(Sender: TObject);
var
tf:TextFile;
tl:TTariffList;
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
X, Y, xx, yy : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf,s,s1,s2,s3,s4:string;
vr:boolean;
begin
with form1 do begin
ClearTariffList(tl);
if opendialog1.Execute then begin
AssignFile(tf,DeleteSlasheEx(ExtractDirPath(OpenDialog1.Filename))+'\cppktariff.sql');
ReWrite(tf);
WriteLn(tf,'TRUNCATE TABLE `tarlist`;');
NomFich := opendialog1.FileName;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
RangeMatrix := XLApp.Range['A1', XLApp.Cells.Item[X, Y]].Value2;

//     mcd, mcd_dal, mcd_1dat, mcd_3dat, mcd_30dat, mcd_90dat, mcd_365dat, mcd_1m_st, mcd_3m_st, mcd_60p :integer;

if ((x>10)and(y>10)) then begin
  for yy:=1 to y do begin
    s:=trim(VarToStrDef(RangeMatrix[3,yy],''));
    if s=' ' then tl.etrain:=yy;
    if s=' ' then tl.child:=yy;
    if s=' ' then tl.handbag:=yy;
    if s='' then tl.animal:=yy;
    if s='' then tl.velzh:=yy;
    if s='  1 ' then tl.m1:=yy;
    if s='   1 ' then tl.m1r:=yy;
    if s='  3 ' then tl.m3:=yy;
    if s='   3 ' then tl.m3r:=yy;
    if s='  12 ' then tl.m12:=yy;
    if s='  10 ' then tl.d10:=yy;
    if s='  5 ' then tl.dat5:=yy;
    if s='  6 ' then tl.dat6:=yy;
    if s='  7 ' then tl.dat7:=yy;
    if s='  8 ' then tl.dat8:=yy;
    if s='  9 ' then tl.dat9:=yy;
    if s='  10 ' then tl.dat10:=yy;
    if s='  11 ' then tl.dat11:=yy;
    if s='  12 ' then tl.dat12:=yy;
    if s='  13 ' then tl.dat13:=yy;
    if s='  14 ' then tl.dat14:=yy;
    if s='  15 ' then tl.dat15:=yy;
    if s='  16 ' then tl.dat16:=yy;
    if s='  10 ' then tl.p10:=yy;
    if s='  20 ' then tl.p20:=yy;
    if s='  60 ' then tl.p60:=yy;
    if s='   1 ' then tl.vyhdn:=yy;

    if s='_' then tl.mcd:=yy;
    if s='  _+ ' then tl.mcd_dal:=yy;
    if s='  1   ' then tl.mcd_1dat:=yy;
    if s='  3   ' then tl.mcd_3dat:=yy;
    if s='  30   ' then tl.mcd_30dat:=yy;
    if s='  90   ' then tl.mcd_90dat:=yy;
    if s='  365   ' then tl.mcd_365dat:=yy;
    if s=' 1    ' then tl.mcd_1m_st:=yy;
    if s=' 3    ' then tl.mcd_3m_st:=yy;
    if s='  60   ' then tl.mcd_60p:=yy;
  end;
  vr:=true;
  if tl.etrain=0 then vr:=false;
  if tl.child=0 then vr:=false;
  if tl.handbag=0 then vr:=false;
  if tl.animal=0 then vr:=false;
  if tl.velzh=0 then vr:=false;
  if tl.m1=0 then vr:=false;
  if tl.m1r=0 then vr:=false;
  if tl.m3=0 then vr:=false;
  if tl.m3r=0 then vr:=false;
  if tl.m12=0 then vr:=false;
  if tl.d10=0 then vr:=false;
  if tl.dat5=0 then vr:=false;
  if tl.dat6=0 then vr:=false;
  if tl.dat7=0 then vr:=false;
  if tl.dat8=0 then vr:=false;
  if tl.dat9=0 then vr:=false;
  if tl.dat10=0 then vr:=false;
  if tl.dat11=0 then vr:=false;
  if tl.dat12=0 then vr:=false;
  if tl.dat13=0 then vr:=false;
  if tl.dat14=0 then vr:=false;
  if tl.dat15=0 then vr:=false;
  if tl.dat16=0 then vr:=false;
  if tl.p10=0 then vr:=false;
  if tl.p20=0 then vr:=false;
  if tl.p60=0 then vr:=false;
  if tl.vyhdn=0 then vr:=false;

  if tl.mcd=0 then vr:=false;
  if tl.mcd_dal=0 then vr:=false;
  if tl.mcd_1dat=0 then vr:=false;
  if tl.mcd_3dat=0 then vr:=false;
  if tl.mcd_30dat=0 then vr:=false;
  if tl.mcd_90dat=0 then vr:=false;
  if tl.mcd_365dat=0 then vr:=false;
  if tl.mcd_1m_st=0 then vr:=false;
  if tl.mcd_3m_st=0 then vr:=false;
  if tl.mcd_60p=0 then vr:=false;


  if vr=false then ShowMessage('      .  !')
   else begin
      for xx:=4 to x do begin
         StatusBar1.SimpleText:=inttostr(xx)+'  '+inttostr(x);
         Application.ProcessMessages;
         s1:=trim(VarToStrDef(RangeMatrix[xx,8],''));
         s2:=trim(VarToStrDef(RangeMatrix[xx,9],''));
         s4:=trim(VarToStrDef(RangeMatrix[xx,5],''));
         if validstr(s1) then begin
         if validstr(s2) then begin
         if s4='1' then begin
           if tl.etrain>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.etrain],'')); if validstr(s3) then begin
                                                                                                 WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                 s3+#39+', '+#39+'etrain'+#39+', '+#39+'a'+#39+', 1);');
                                                                                                 WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                 floattostr(strtofloat(s3)/2)+#39+', '+#39+'reduced'+#39+', '+#39+'a'+#39+', 1);');
                                                                                                end; end;
           if tl.etrain>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.etrain],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'etrain'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.child>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.child],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'child'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.handbag>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.handbag],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'handbag'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.animal>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.animal],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'animal'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.velzh>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.velzh],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'velzh'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.m1>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.m1],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'1m'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.m1r>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.m1r],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'1mr'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.m3>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.m3],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'3m'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.m3r>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.m3r],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'3mr'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.m12>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.m12],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'12m'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.d10>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.d10],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'10d'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.vyhdn>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.vyhdn],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'vyhdn'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat5>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat5],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'5dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat6>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat6],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'6dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat7>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat7],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'7dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat8>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat8],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'8dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat9>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat9],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'9dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat10>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat10],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'10dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat11>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat11],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'11dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat12>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat12],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'12dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat13>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat13],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'13dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat14>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat14],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'14dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat15>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat15],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'15dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat16>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat16],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'16dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.p10>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.p10],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'10p'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.p20>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.p20],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'20p'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.p60>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.p60],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'60p'+#39+', '+#39+'a'+#39+', 1);'); end;
         end;
         if s4='2' then begin
           if tl.mcd>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.mcd],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'mcd'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.mcd_dal>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.mcd_dal],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'mcd_dal'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.mcd_1dat>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.mcd_1dat],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'mcd_1dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.mcd_3dat>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.mcd_3dat],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'mcd_3dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.mcd_30dat>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.mcd_30dat],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'mcd_30dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.mcd_90dat>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.mcd_90dat],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'mcd_90dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.mcd_365dat>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.mcd_365dat],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'mcd_365dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.mcd_1m_st>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.mcd_1m_st],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'mcd_1m_st'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.mcd_3m_st>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.mcd_3m_st],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'mcd_3m_st'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.mcd_60p>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.mcd_60p],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlist` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'mcd_60p'+#39+', '+#39+'a'+#39+', 1);'); end;

         end;

         end;
         end;
      end;
   end;
end;
RangeMatrix := Unassigned;
XLApp.Quit;
XLApp.Disconnect;
CloseFile(tf);
ShowMessage('End!');
end; //opendialog
end;
end;



procedure TForm1.Button13Click(Sender: TObject);
var
tf:TextFile;
tl:TTariffList;
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
X, Y, xx, yy : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf,s,s1,s2,s3,s4:string;
vr:boolean;
begin
with form1 do begin
ClearTariffList(tl);
if opendialog1.Execute then begin
AssignFile(tf,DeleteSlasheEx(ExtractDirPath(OpenDialog1.Filename))+'\cppktariff_express.sql');
ReWrite(tf);
WriteLn(tf,'TRUNCATE TABLE `tarlistexpr`;');
NomFich := opendialog1.FileName;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
RangeMatrix := XLApp.Range['A1', XLApp.Cells.Item[X, Y]].Value2;
if ((x>10)and(y>10)) then begin
  for yy:=1 to y do begin
    s:=trim(VarToStrDef(RangeMatrix[3,yy],''));
    if s=' ' then tl.etrain:=yy;
    if s=' ' then tl.child:=yy;
    if s=' ' then tl.handbag:=yy;
    if s='' then tl.animal:=yy;
    if s='' then tl.velzh:=yy;
    if s='  1 ' then tl.m1:=yy;
    if s='   1 ' then tl.m1r:=yy;
    if s='  3 ' then tl.m3:=yy;
    if s='   3 ' then tl.m3r:=yy;
    if s='  12 ' then tl.m12:=yy;
    if s='  5 ' then tl.d5:=yy;
    if s='  10 ' then tl.d10:=yy;
    if s='  5 ' then tl.dat5:=yy;
    if s='  6 ' then tl.dat6:=yy;
    if s='  7 ' then tl.dat7:=yy;
    if s='  8 ' then tl.dat8:=yy;
    if s='  9 ' then tl.dat9:=yy;
    if s='  10 ' then tl.dat10:=yy;
    if s='  11 ' then tl.dat11:=yy;
    if s='  12 ' then tl.dat12:=yy;
    if s='  13 ' then tl.dat13:=yy;
    if s='  14 ' then tl.dat14:=yy;
    if s='  15 ' then tl.dat15:=yy;
    if s='  16 ' then tl.dat16:=yy;
    if s='  10 ' then tl.p10:=yy;
    if s='  20 ' then tl.p20:=yy;
    if s='  60 ' then tl.p60:=yy;
    if s='   1 ' then tl.vyhdn:=yy;
  end;
  vr:=true;
  if tl.etrain=0 then vr:=false;
  if tl.child=0 then vr:=false;
  if tl.handbag=0 then vr:=false;
  if tl.animal=0 then vr:=false;
  if tl.velzh=0 then vr:=false;
  if tl.m1=0 then vr:=false;
  if tl.m1r=0 then vr:=false;
  if tl.m3=0 then vr:=false;
  if tl.m3r=0 then vr:=false;
  if tl.m12=0 then vr:=false;
  if tl.d5=0 then vr:=false;
  if tl.d10=0 then vr:=false;
  if tl.dat5=0 then vr:=false;
  if tl.dat6=0 then vr:=false;
  if tl.dat7=0 then vr:=false;
  if tl.dat8=0 then vr:=false;
  if tl.dat9=0 then vr:=false;
  if tl.dat10=0 then vr:=false;
  if tl.dat11=0 then vr:=false;
  if tl.dat12=0 then vr:=false;
  if tl.dat13=0 then vr:=false;
  if tl.dat14=0 then vr:=false;
  if tl.dat15=0 then vr:=false;
  if tl.dat16=0 then vr:=false;
  if tl.p10=0 then vr:=false;
  if tl.p20=0 then vr:=false;
  if tl.p60=0 then vr:=false;
  if tl.vyhdn=0 then vr:=false;
  if vr=false then ShowMessage('      .  !')
   else begin
      for xx:=4 to x do begin
         StatusBar1.SimpleText:=inttostr(xx)+'  '+inttostr(x);
         Application.ProcessMessages;
         s1:=trim(VarToStrDef(RangeMatrix[xx,8],''));
         s2:=trim(VarToStrDef(RangeMatrix[xx,9],''));
         s4:=trim(VarToStrDef(RangeMatrix[xx,5],''));
         if validstr(s1) then begin
         if validstr(s2) then begin
         if s4='12' then begin
           if tl.etrain>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.etrain],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'express'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.child>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.child],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'echild'+#39+', '+#39+'a'+#39+', 1);'); end;
//           if tl.handbag>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.handbag],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
//                                                                                                s3+#39+', '+#39+'handbag'+#39+', '+#39+'a'+#39+', 1);'); end;
//           if tl.animal>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.animal],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
//                                                                                                s3+#39+', '+#39+'animal'+#39+', '+#39+'a'+#39+', 1);'); end;
//           if tl.velzh>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.velzh],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
//                                                                                                s3+#39+', '+#39+'velzh'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.m1>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.m1],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e1m'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.m1r>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.m1r],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e1mr'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.m3>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.m3],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e3m'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.m3r>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.m3r],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e3mr'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.m12>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.m12],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e12m'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.d5>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.d5],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e5d'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.d10>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.d10],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e10d'+#39+', '+#39+'a'+#39+', 1);'); end;
//           if tl.vyhdn>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.vyhdn],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
//                                                                                                s3+#39+', '+#39+'vyhdn'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat5>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat5],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e5dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat6>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat6],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e6dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat7>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat7],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e7dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat8>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat8],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e8dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat9>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat9],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e9dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat10>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat10],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e10dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat11>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat11],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e11dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat12>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat12],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e12dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat13>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat13],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e13dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat14>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat14],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e14dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat15>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat15],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e15dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.dat16>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.dat16],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e16dat'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.p10>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.p10],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e10p'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.p20>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.p20],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e20p'+#39+', '+#39+'a'+#39+', 1);'); end;
           if tl.p60>0 then begin s3:=trim(VarToStrDef(RangeMatrix[xx,tl.p60],'')); if validstr(s3) then WriteLn(tf,'INSERT INTO `tarlistexpr` (`file`, `dstart`, `st1`, `st2`, `price`, `type`, `v`, `n`) VALUES (00001, '+#39+'01.01.2018'+#39+', '+s1+', '+s2+', '+#39+
                                                                                                s3+#39+', '+#39+'e60p'+#39+', '+#39+'a'+#39+', 1);'); end;
         end;
         end;
         end;
      end;
   end;
end;
RangeMatrix := Unassigned;
XLApp.Quit;
XLApp.Disconnect;
CloseFile(tf);
ShowMessage('End!');
end; //opendialog
end;
end;

end.
