unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, AF_Proc, AF_Types, StdCtrls, WinInet, uLkJSON, ShellApi,
  ComCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    Button11: TButton;
    Label3: TLabel;
    Button12: TButton;
    Button13: TButton;
    StatusBar1: TStatusBar;
    Button14: TButton;
    OpenDialog1: TOpenDialog;
    Button15: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure Button15Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

const
  _aurora_file:string='C:\AF\\aurora18jan.xml';
  _delete_file:string='C:\AF\\delete15may.txt';
  _crimea_old_file:string='C:\AF\\new49.xml';
  _crimea_new_file:string='C:\AF\\new50.xml';

implementation

uses DateUtils, Unit2;

{$R *.dfm}

function timed0(s:string):string;
begin
  s:=trim(s);
  if length(s)=5 then begin
   if s[1]='0' then s:=copy(s,2,4);
  end;
  result:=s;
end;



Function ReplaceParam(str1,param,value:string;add:boolean):string;
  var s,s1,s2,s3:string;
  var i,n:integer;
begin
  s:=str1;
  s:=StrReplace(s,' =','=');
  s:=StrReplace(s,'= ','=');
    if pos(param+'="',s)>0 then begin
      i:=pos(param+'="',s)+length(param)+2;
      if s[i]<>'"' then begin
       while s[i]<>'"' do begin
         delete(s,i,1);
         if i>=length(s) then break;
       end;
      end;
      insert(value,s,i);
    end
     else begin
      s:=str1;
      if add then begin
        if pos('/>',s)>0 then begin
          insert(' '+param+'="'+value+'" ',s,pos('/>',s));
        end
         else begin
          if pos('>',s)>0 then begin
           insert(' '+param+'="'+value+'" ',s,pos('>',s));
          end
           else s:=str1;
         end;
      end
       else s:=str1;
     end;
  result:=s;
end;

function getParam(s1,s:string):string;
  var s2:string;
begin
  s:=trim(s);
  s2:='';
  if pos(s1+'="',s)>0 then begin
    s2:=copy(s,pos(s1+'="',s)+2+length(s1),length(s));
     if pos('"',s2)>0 then s2:=copy(s2,1,pos('"',s2)-1);
  end;
  result:=trim(s2);
end;


procedure TForm1.Button1Click(Sender: TObject);
  var f,f1,log,log1,log2:AF_Types.TStrings;
  var i,n,nc,nc1:integer;
  var s,s1,s2,s3,s4,s5,snum,ps,pe:string;
  var r:boolean;
  var t:textfile;
begin
 f.create; f1.create;
 log.create;
 log1.create;
 log2.create;
 assignfile(t,'C:\1\\yandex.xml');
 reset(t);
 r:=true;
 nc:=0; nc1:=0;
  while not eof(t) do begin
    readln(t,s);
    if pos('<schedule ',s)>0 then begin
       s1:=trim(getParam('period_start_date',s));
        if pos('T',s1)>1 then begin
          s1:=trim(copy(s1,1,pos('T',s1)-1));
          s:=ReplaceParam(s,'period_start_date',s1,false);
        end;
       ps:=trim(s1);
       s1:=trim(getParam('period_end_date',s));
        if pos('T',s1)>1 then begin
          s1:=trim(copy(s1,1,pos('T',s1)-1));
          s:=ReplaceParam(s,'period_end_date',s1,false);
        end;
       pe:=trim(s1);
       s1:=trim(getParam('days',s));
        if pos('T',s1)>1 then begin
          while pos('T00:00:00',s1)>0 do delete(s1,pos('T00:00:00',s1),9);
          s:=ReplaceParam(s,'days',s1,false);
        end;
       s1:=trim(getParam('times',s));
       if s1='0:0' then begin
          s1:='-';
          showmessage('error - times');
       end;
       if pos(':',s1)>0 then begin
         if pos(':',s1)=length(s1)-1 then insert('0',s1,pos(':',s1)+1);
       end;
       s:=ReplaceParam(s,'times',trim(s1),false);
       inc(nc);
       s1:=trim(getParam('days',s));
       s1:=Utf8ToAnsi(s1);
       if log2.SearchString(s1)<=0 then log2.add(s1);
       if s1<>'' then begin
        if pos('201',s1)<=0 then begin
         if pos('',s1)<=0 then begin
           s1:=StrReplace(s1,'','1');
           s1:=StrReplace(s1,'','2');
           s1:=StrReplace(s1,'','3');
           s1:=StrReplace(s1,'','4');
           s1:=StrReplace(s1,'','5');
           s1:=StrReplace(s1,'','6');
           s1:=StrReplace(s1,'','7');
           while pos(',',s1)>0 do delete(s1,pos(',',s1),1);
           s:=ReplaceParam(s,'days',trim(s1),false);
         end;
        end;
       end
        else inc(nc1);
       n:=log.SearchString(s1);
       if n<1 then log.add(s1);
       if pos('',snum)>0 then begin
         if validstr(ps) then begin
           s:=ReplaceParam(s,'period_end_date',ps,true);
         end
          else begin
           s:=ReplaceParam(s,'times','',false);
           s:=ReplaceParam(s,'days','cancel,',false);
          end;
       end;
       if pos('',snum)>0 then begin
         if validstr(ps) then begin
           s:=ReplaceParam(s,'period_end_date',ps,true);
         end
          else begin
           s:=ReplaceParam(s,'times','',false);
           s:=ReplaceParam(s,'days','cancel,',false);
          end;
       end;
       if pos('',snum)>0 then begin
         if validstr(ps) then begin
           s:=ReplaceParam(s,'period_end_date',ps,true);
         end
          else begin
           s:=ReplaceParam(s,'times','',false);
           s:=ReplaceParam(s,'days','cancel,',false);
          end;
       end;
       if pos('',snum)>0 then begin
         s:=ReplaceParam(s,'times','',false);
         s:=ReplaceParam(s,'days','cancel,',false);
       end;
       if pos('',snum)>0 then begin
         s:=ReplaceParam(s,'times','',false);
         s:=ReplaceParam(s,'days','cancel,',false);
       end;
       if pos('201',snum)=1 then begin
        if pos('-',snum)>1 then begin
         s:=ReplaceParam(s,'times','',false);
         s:=ReplaceParam(s,'days','cancel,',false);
        end;
       end;
    end;
    if pos('<stoppoint ',s)>0 then begin
       s1:=trim(getParam('arrival_time',s));
       if s1='0:0' then s1:='-';
       if pos(':',s1)>0 then begin
         if pos(':',s1)=length(s1)-1 then insert('0',s1,pos(':',s1)+1);
       end;
       s:=ReplaceParam(s,'arrival_time',trim(s1),false);
       s1:=trim(getParam('departure_time',s));
       if s1='0:0' then s1:='-';
       if pos(':',s1)>0 then begin
         if pos(':',s1)=length(s1)-1 then insert('0',s1,pos(':',s1)+1);
       end;
       s:=ReplaceParam(s,'departure_time',trim(s1),false);
       if pos('arrival_time="-"',s)>0 then begin
         s:=StrReplace(s,'arrival_time="-"',' ');
       end;
       if pos('departure_time="-"',s)>0 then begin
         s:=StrReplace(s,'departure_time="-"',' ');
       end;
       s:=ReplaceParam(s,'arrival_shift','1',false);
       s:=StrReplace(s,'arrival_shift="1"',' ');
       s:=ReplaceParam(s,'departure_shift','1',false);
       s:=StrReplace(s,'departure_shift="1"',' ');
       s:=StrReplace(s,'  ',' ');
    end;
    if pos('<thread ',s)>0 then begin
       s:=ReplaceParam(s,'carrier_code','1',false);
       s:=ReplaceParam(s,'carrier_title','1',false);
       s:=ReplaceParam(s,'vehicle_code','1',false);
       s:=ReplaceParam(s,'vehicle_title','1',false);
       s:=ReplaceParam(s,'fare_code','1',false);
       s:=StrReplace(s,'carrier_code="1"',' ');
       s:=StrReplace(s,'carrier_title="1"',' ');
       s:=StrReplace(s,'vehicle_code="1"',' ');
       s:=StrReplace(s,'vehicle_title="1"',' ');
       s:=StrReplace(s,'fare_code="1"',' ');
       s:=StrReplace(s,'  ',' ');
       s1:=getParam('title',s);
       s:=ReplaceParam(s,'title',trim(s1),false);
       s1:=trim(getParam('number',s));
       n:=log1.SearchString(s1);
       if n<1 then log1.add(s1);
       snum:=ansilowercase(Utf8ToAnsi(s1));
    end;
    f.add(s);
  end;
 closefile(t);
 f.savetofile('C:\1\\cremnew4.xml');
 log.savetofile('C:\1\\cremnew4.log');
 log1.savetofile('C:\1\\cremnew4.log1');
 log2.savetofile('C:\1\\cremnew4.log2');
 f.clear;
 f1.clear;
 f.loadfromfile('C:\1\\cremnew4.xml');
 if f.count>0 then begin
  for i:=1 to f.count do begin
   s:=f.getstring(i);
   if pos('<thread ',s)>0 then begin
     s1:=getParam('title',s);
     snum:=getParam('number',s);
   end;
   if pos('<schedule ',s)>0 then begin
     s2:=getParam('times',s);
     s3:=getParam('days',s);
     s4:=getParam('period_start_date',s);
     s5:=getParam('period_end_date',s);
     f1.add(s1+#9+s2+#9+s3+#9+s4+#9+s5+#9+snum);
   end;
   if pos('</thread>',s)>0 then begin
     s1:=''; s2:=''; s3:=''; s4:=''; s5:='';
   end;
  end;
 end;
 f1.savetofile('C:\1\\cremnew4.ts1');


 f.free; f1.free;
 log.free;
 log1.free;
 log2.free;
 showmessage('end! - '+inttostr(nc)+' .');
{ f.create;
 assignfile(t,'C:\1\\cremnew2.xml');
 reset(t);
 r:=true;
  while not eof(t) do begin
    readln(t,s);
    if pos('<carriers>',s)>0 then r:=false;
    if r then f.add(s);
    if pos('</carriers>',s)>0 then r:=true;
  end;
 f.savetofile('C:\1\\cremnew3.xml');
 f.free;
 showmessage('end!'); }
end;

procedure TForm1.Button2Click(Sender: TObject);
  var f,f1:AF_Types.TStrings;
  var i:integer;
  var s,s1,s2,s3,s4,s5,sn:string;
begin
 f.create; f1.create;
 f.loadfromfile('C:\1\\cremnew4.xml');
 if f.count>0 then begin
  for i:=1 to f.count do begin
   s:=f.getstring(i);
   if pos('<thread ',s)>0 then begin
     s1:=getParam('title',s);
     sn:=getParam('number',s);
   end;
   if pos('<schedule ',s)>0 then begin
     s2:=getParam('times',s);
     s3:=getParam('days',s);
     s4:=getParam('period_start_date',s);
     s5:=getParam('period_end_date',s);
     f1.add(sn+#9+s1+#9+s2+#9+s3+#9+s4+#9+s5);
   end;
   if pos('</thread>',s)>0 then begin
     s1:=''; s2:=''; s3:=''; s4:=''; s5:=''; sn:='';
   end;
  end;
 end;
 f1.savetofile('C:\1\\yandex.ts1');
 f.free; f1.free;
 showmessage('end!');
end;

procedure ParseCSVStrEx(ts:AF_Types.PStrings; s:widestring; c:char);
 var n:integer;
begin
  ts.clear;
  while pos(c,s)>0 do begin
    n:=pos(c,s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;

function preptitle(s:string):string;
 var s1:string;
begin
  s1:=s;
  s1:=StrReplace(s1,#32#151#32,' - ');
  s1:=StrReplace(s1,#32#62#32,' - ');
  s1:=StrReplace(s1,#32#63#32,' - ');
  result:=s1;
end;

procedure TForm1.Button3Click(Sender: TObject);
  var f,f1,ts,ts0,ts1,u,v2:AF_Types.TStrings;
  var i,r,r1,z0,z1,n:integer;
  var s,s0,s1,s2,s3,sx:string;
  var flg:boolean;
begin
 f.create; f1.create; ts.create; u.create; v2.create; ts0.create; ts1.create;
 f.loadfromfile('C:\1\\del0710.txt');
 if f.count>0 then begin
  for i:=1 to f.count do begin
    ParseCSVStrEx(@u,f.getstring(i),#9);
    if u.count>3 then begin
     if trim(ansilowercase(u.getstring(1)))='' then ts.add(u.getstring(2)+'|'+preptitle(u.getstring(3))+'|'+u.getstring(4)+'|'+u.getstring(5));
     if trim(ansilowercase(u.getstring(1)))='' then begin
       ts0.add(u.getstring(2)+'|'+preptitle(u.getstring(3))+'|'+u.getstring(4)+'|'+u.getstring(5));
       ts1.add(u.getstring(8));
     end;
    end;
  end;
  z0:=ts.count;
  z1:=ts0.count;
 end;
 f.clear;
 r:=0;
 r1:=0;
 f.loadfromfile('C:\1\\cremnew4.xml');
 if f.count>0 then begin
  for i:=1 to f.count do begin
   s:=f.getstring(i);
   sx:=Utf8ToAnsi(s);
   if pos('<thread ',s)>0 then begin
     s0:=getParam('number',sx);
     s1:=preptitle(getParam('title',sx));
     flg:=false;
   end;
   if pos('<schedule ',s)>0 then begin
     s2:=getParam('times',sx);
     s3:=getParam('days',sx);
     if ts.SearchString(s0+'|'+s1+'|'+s2+'|'+s3)>0 then begin
       s:=ReplaceParam(s,'days',ansitoutf8(',cancel'),false);
       inc(r);
       v2.add(' '+s0+'|'+s1+'|'+s2+'|'+s3);
     end;
   end;
   if pos('</thread>',s)>0 then begin
     s1:=''; s2:=''; s3:='';
     flg:=false;
   end;
   f1.add(s);
  end;
 end;

 if f1.count>0 then begin
  for i:=1 to f1.count do begin
   s:=f1.getstring(i);
   sx:=Utf8ToAnsi(s);
   if pos('<thread ',s)>0 then begin
     s0:=getParam('number',sx);
     s1:=preptitle(getParam('title',sx));
     flg:=false;
   end;
   if pos('<schedule ',s)>0 then begin
     s2:=getParam('times',sx);
     s3:=getParam('days',sx);
     n:=ts0.SearchString(s0+'|'+s1+'|'+s2+'|'+s3);
     if n>0 then begin
       s:=ReplaceParam(s,'days',ansitoutf8(ts1.getstring(n)),false);
       inc(r1);
       v2.add(' '+s0+'|'+s1+'|'+s2+'|'+s3+'  '+ts1.getstring(n));
     end;
   end;
   if pos('</thread>',s)>0 then begin
     s1:=''; s2:=''; s3:='';
     flg:=false;
   end;
   f1.edit(i,s);
  end;
 end;

 f1.savetofile('C:\1\\cremnew5.xml');
 v2.savetofile('C:\1\\cremnew5.log');
 f.free; f1.free; ts.free; u.free; ts0.free; ts1.free;
 showmessage(' '+inttostr(r)+'  '+inttostr(z0)+',  '+inttostr(r1)+'  '+inttostr(z1));
end;

procedure TForm1.Button4Click(Sender: TObject);
 var f,f1,st1,st2:AF_Types.TStrings;
 var i,n:integer;
 var s,s1:string;
begin
 f.create; st1.create; st2.create; f1.create;
 f1.add('');
 f.loadfromfile('C:\1\58\yt_home_extdata_aurora_others_general_gosbus_ru.');
 if f.count>0 then begin
   for i:=1 to f.count do begin
     s:=f.getstring(i);
     if pos('<station code',s)>0 then begin
      st1.add(getParam('code',s));
      st2.add(getParam('title',s));
     end;
     if pos('<stoppoint ',s)>0 then begin
       s1:=getParam('station_code',s);
       n:=st1.SearchString(s1);
       if n>0 then begin
         s:=ReplaceParam(s,'title',st2.getstring(n),true);
         f.edit(i,s);
       end
        else begin
         f1.add('   '+s1);
        end;
     end;
   end;
 end;
 f.savetofile('C:\1\58\1.xml');
 f1.savetofile('C:\1\58\1.log');
 f.free; st1.free; st2.free; f1.free;
 showmessage('end!');
end;

procedure TForm1.Button5Click(Sender: TObject);
  var f,f1,th:AF_Types.TStrings;
  var i,n,m,flg:integer;
  var s:string;
begin
  f.create; f1.create; th.create;
  f.loadfromfile(_crimea_new_file);
  m:=0;
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
       m:=1;
       if th.count>0 then showmessage(' th!');
       th.clear;
       flg:=1;
      end;
      if m=0 then f1.add(s)
       else begin
         th.add(s);
         if pos('</thread>',s)>0 then begin
          if flg>0 then f1.include(th);
          th.clear;
          m:=0;
         end
          else begin
            if ((pos('days=",cancel"',s)>0)or(pos('days="cancel"',s)>0)or(pos('days="cancel,"',s)>0)) then flg:=0;
          end;
       end;
    end;
  end;
  f1.savetofile(_crimea_new_file);
  f.free; f1.free; th.free;
  showmessage('end!');
end;

procedure TForm1.Button6Click(Sender: TObject);
  var f,f1,st1,st2,ns:AF_Types.TStrings;
  var i,n,schc,rs1,rs2:integer;
  var s,s1,s2,tt,tt1,sd,fn:string;
begin
  //  
  fn:=_crimea_old_file;
  f.create; f1.create; st1.create; st2.create; ns.create;
  f.loadfromfile(fn);
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<station ',s)>0 then begin
        st1.add(getParam('code',s));
        st2.add(getParam('title',s));
      end;
    end;
    f1.clear;
    f1.add('code'+#9+'title');
    if st1.count>0 then begin
     for n:=1 to st1.count do f1.add(st1.getstring(n)+#9+st2.getstring(n));
    end;
    f1.savetofile(fn+'.stlist');
    f1.clear;
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
       s1:='!nst!!4';
       s2:='';
       tt:='';
       sd:='';
       tt1:='';
       schc:=0;
      end;
      if pos('<stoppoint ',s)>0 then begin
       if s1='!nst!!4' then begin
         s1:=getParam('station_code',s);
         tt:=getParam('departure_time',s);
       end;
       s2:=getParam('station_code',s);
      end;
      if pos('<schedule ',s)>0 then begin
         sd:=getParam('days',s);
         tt1:=getParam('times',s);
         inc(schc);
      end;
      if pos('</thread>',s)>0 then begin
         rs1:=st1.SearchString(s1);
         rs2:=st1.SearchString(s2);
         if ((rs1<1)or(rs2<1)) then begin
          f1.add(s1+#9+s2+#9+s1+#9+s2+#9+tt+#9+sd);
         end
          else begin
           f1.add(st2.getstring(rs1)+#9+st2.getstring(rs2)+#9+s1+#9+s2+#9+tt+#9+sd);
          end;
         if schc>1 then showmessage('double schedule - '+utf8toansi(st2.getstring(st1.SearchString(s1))+#9+st2.getstring(st1.SearchString(s2))+#9+s1+#9+s2+#9+tt+#9+sd));
         if tt<>tt1 then f1.add(AnsiToUtf8('error -    '+tt+'  '+tt1));
         if ns.SearchString(s1)<1 then ns.add(s1);
         if ns.SearchString(s2)<1 then ns.add(s2);
      end;
    end;
  end;
  f1.savetofile(fn+'.tsv');
    f1.clear;
    f1.add('code'+#9+'title');
    if ns.count>0 then begin
     for n:=1 to ns.count do begin
       rs1:=st1.SearchString(ns.getstring(n));
       if rs1>0 then f1.add(utf8toansi(ns.getstring(n))+#9+utf8toansi(st2.getstring(rs1)))
                else f1.add(utf8toansi(ns.getstring(n))+#9+utf8toansi(ns.getstring(n)));
     end;
    end;
    f1.savetofile(fn+'.nslist1');
    f1.clear;
  f.free; f1.free; st1.free; st2.free; ns.free;
  showmessage('end!');
end;

procedure CreateXMLList(fn:string; f1s:AF_Types.PStrings);
  var f,f1,st1,st2,ns:AF_Types.TStrings;
  var i,n,schc,rs1,rs2,h,m:integer;
  var s,s1,s2,tt,tt1,sd:string;
begin
  f.create; f1.create; st1.create; st2.create; ns.create;
  f1s.clear;
  f.loadfromfile(fn);
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=utf8toansi(f.getstring(i));
      if pos('<station ',s)>0 then begin
        st1.add(getParam('code',s));
        st2.add(getParam('title',s));
      end;
    end;
    f1.clear;
    f1.add('code'+#9+'title');
    if st1.count>0 then begin
     for n:=1 to st1.count do f1.add(st1.getstring(n)+#9+st2.getstring(n));
    end;
//    f1.savetofile(fn+'.stlist');
    f1.clear;
    for i:=1 to f.count do begin
      s:=utf8toansi(f.getstring(i));
      if pos('<thread ',s)>0 then begin
       s1:='!nst!!4';
       s2:='';
       tt:='';
       sd:='';
       tt1:='';
       schc:=0;
      end;
      if pos('<stoppoint ',s)>0 then begin
       if s1='!nst!!4' then begin
         s1:=getParam('station_code',s);
         tohm(getParam('departure_time',s),h,m);
         tt:=fromhm0(h,m);
       end;
       s2:=getParam('station_code',s);
      end;
      if pos('<schedule ',s)>0 then begin
         sd:=getParam('days',s);
         tohm(getParam('times',s),h,m);
         tt1:=fromhm0(h,m);
         inc(schc);
      end;
      if pos('</thread>',s)>0 then begin
         rs1:=st1.SearchString(s1);
         rs2:=st1.SearchString(s2);
         if ((rs1<1)or(rs2<1)) then begin
          f1.add(s1+#9+s2+#9+s1+#9+s2+#9+tt+#9+sd);
         end
          else begin
           f1.add(st2.getstring(rs1)+#9+st2.getstring(rs2)+#9+s1+#9+s2+#9+tt+#9+sd);
           if f1s.SearchString(st2.getstring(rs1))<1 then f1s.add(st2.getstring(rs1));
           if f1s.SearchString(st2.getstring(rs2))<1 then f1s.add(st2.getstring(rs2));
          end;
         if schc>1 then showmessage('double schedule - '+utf8toansi(st2.getstring(st1.SearchString(s1))+#9+st2.getstring(st1.SearchString(s2))+#9+s1+#9+s2+#9+tt+#9+sd));
         if tt<>tt1 then f1.add(AnsiToUtf8('error -    '+tt+'  '+tt1));
         if ns.SearchString(s1)<1 then ns.add(s1);
         if ns.SearchString(s2)<1 then ns.add(s2);
      end;
    end;
  end;
  f1.savetofile(fn+'.tsv');
  f1s.savetofile(fn+'.stlist1');
    f1.clear;
    f1.add('code'+#9+'title');
    if ns.count>0 then begin
     for n:=1 to ns.count do begin
       rs1:=st1.SearchString(ns.getstring(n));
       if rs1>0 then f1.add(utf8toansi(ns.getstring(n))+#9+utf8toansi(st2.getstring(rs1)))
                else f1.add(utf8toansi(ns.getstring(n))+#9+utf8toansi(ns.getstring(n)));
     end;
    end;
   // f1.savetofile(fn+'.nslist1');
    f1.clear;
  f.free; f1.free; st1.free; st2.free; ns.free;
end;


procedure TForm1.Button7Click(Sender: TObject);
  var f,f1,st1,st2,ns:AF_Types.TStrings;
  var i,n:integer;
  var s,s1,s2,tt,sd,fn:string;
begin
  //  42
  fn:=_aurora_file;
  unit2.aufn:=fn;
  f.create; f1.create; st1.create; st2.create; ns.create;
  f.loadfromfile(fn);
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<station ',s)>0 then begin
        st1.add(getParam('code',s));
        st2.add(getParam('title',s));
      end;
    end;
    f1.clear;
    f1.add('code'+#9+'title');
    if st1.count>0 then begin
     for n:=1 to st1.count do f1.add(st1.getstring(n)+#9+st2.getstring(n));
    end;
    f1.savetofile(fn+'.stlist');
    f1.clear;
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
       s1:='!nst!!4';
       s2:='';
       tt:='';
      end;
      if pos('<stoppoint ',s)>0 then begin
       if s1='!nst!!4' then begin
         s1:=getParam('station_code',s);
         tt:=copy(getParam('departure_time',s),1,length(getParam('departure_time',s))-3);
       end;
       s2:=getParam('station_code',s);
      end;
      if pos('<schedule ',s)>0 then begin
         sd:=getParam('days',s);
      end;
      if pos('</thread>',s)>0 then begin
         f1.add(st2.getstring(st1.SearchString(s1))+#9+st2.getstring(st1.SearchString(s2))+#9+s1+#9+s2+#9+tt+#9+sd);
         if ns.SearchString(s1)<1 then ns.add(s1);
         if ns.SearchString(s2)<1 then ns.add(s2);
      end;
    end;
  end;
  f1.savetofile(fn+'.tsv');
    f1.clear;
    f1.add('code'+#9+'title');
    if ns.count>0 then begin
     for n:=1 to ns.count do f1.add(utf8toansi(ns.getstring(n))+#9+utf8toansi(st2.getstring(st1.SearchString(ns.getstring(n)))));
    end;
    f1.savetofile(fn+'.nslist');
    f1.clear;
  f.free; f1.free; st1.free; st2.free; ns.free;
  showmessage('end!');
end;

procedure TForm1.Button8Click(Sender: TObject);
  var f,f1,ts,ts0,ts1,u,v2,st1,st2,ns,ts2:AF_Types.TStrings;
  var i,r,r1,z0,z1,n,nn:integer;
  var s,s0,s1,s2,s3,sx,sr,ms,fn,tt,sd,tt1:string;
  var flg:boolean;
begin
 f.create; f1.create; ts.create; u.create; v2.create; ts0.create; ts1.create; st1.create; st2.create; ns.create; ts2.create;
 fn:=_crimea_old_file;
 f.loadfromfile(_delete_file);
 if f.count>0 then begin
  for i:=1 to f.count do begin
    ParseCSVStrEx(@u,f.getstring(i),#9);
    if u.count>3 then begin
     if ((trim(ansilowercase(u.getstring(5)))='delete')or(trim(ansilowercase(u.getstring(5)))='time')) then ts.add(u.getstring(1)+'|'+u.getstring(2)+'|'+timed0(u.getstring(3))+'|'+u.getstring(4));
     if trim(ansilowercase(u.getstring(5)))='dates' then begin
       ts0.add(u.getstring(1)+'|'+preptitle(u.getstring(2))+'|'+timed0(u.getstring(3))+'|'+u.getstring(4));
       ts1.add(u.getstring(6));
       ts2.add('0');
     end;
    end;
  end;
  z0:=ts.count;
  z1:=ts0.count;
 end;
 f.clear;
 r:=0;
 r1:=0;

  f.clear;
  f.loadfromfile(fn);
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<station ',s)>0 then begin
        st1.add(getParam('code',s));
        st2.add(getParam('title',s));
      end;
    end;
    f1.clear;
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
       s1:='!nst!!4';
       s2:='';
       tt:='';
       sd:='';
       tt1:='';
      end;
      if pos('<stoppoint ',s)>0 then begin
       if s1='!nst!!4' then begin
         s1:=getParam('station_code',s);
         tt:=timed0(getParam('departure_time',s));
       end;
       s2:=getParam('station_code',s);
      end;
      if pos('<schedule ',s)>0 then begin
         sd:=getParam('days',s);
         tt1:=timed0(getParam('times',s));
         sr:=s;
         ms:=utf8toansi(st2.getstring(st1.SearchString(s1)))+'|'+utf8toansi(st2.getstring(st1.SearchString(s2)))+'|'+Utf8ToAnsi(tt1)+'|'+Utf8ToAnsi(sd);
         n:=ts0.SearchString(ms);
           if n>0 then begin
             s:=ReplaceParam(s,'days',ansitoutf8(ts1.getstring(n)),false);
             f.edit(i,s);
             inc(r1);
             v2.add(' '+ms+'  '+ts1.getstring(n));
           end;
           nn:=ts.SearchString(ms);
           if nn>0 then begin
             ts2.edit(nn,'1');
             s:=ReplaceParam(s,'days',ansitoutf8('cancel'),false);
             f.edit(i,s);
             inc(r);
             v2.add(' '+s0+'|'+s1+'|'+s2+'|'+s3);
           end;
      end;
//      if pos('</thread>',s)>0 then begin
//      end;
    end;
  end;

 if ts2.count>0 then begin
   for i:=1 to ts2.count do begin
     if ts2.getstring(i)='0' then v2.add('    '+ts.getstring(i));
   end;
 end;
 f.savetofile(_crimea_new_file);
 v2.savetofile(_crimea_new_file+'.log');
 f.free; f1.free; ts.free; u.free; ts0.free; ts1.free; st1.free; st2.free; ns.free;
 showmessage(' '+inttostr(r)+'  '+inttostr(z0)+',  '+inttostr(r1)+'  '+inttostr(z1));
end;

procedure TForm1.Button9Click(Sender: TObject);
  var f,f1,st1,st2,ns,rti,rtis,rtie,rtit,rtid,rt1,rt2,rt3,rt4,rt5,rt6,rt7:AF_Types.TStrings;
  var i,n,nr:integer;
  var s,s1,s2,tt,sd,fn,rs:string;
  var dt:TDateTime;
begin
  //  42
  fn:=_aurora_file;
  f.create; f1.create; st1.create; st2.create; ns.create;
  rti.create; rtis.create; rtie.create; rtit.create; rtid.create; rt1.create; rt2.create; rt3.create; rt4.create; rt5.create; rt6.create; rt7.create;
  f.loadfromfile(fn);
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<station ',s)>0 then begin
        st1.add(getParam('code',s));
        st2.add(getParam('title',s));
      end;
    end;
    f1.clear;
    f1.add('code'+#9+'title');
    if st1.count>0 then begin
     for n:=1 to st1.count do f1.add(st1.getstring(n)+#9+st2.getstring(n));
    end;
    f1.savetofile(fn+'.stlist');
    f1.clear;
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
       s1:='!nst!!4';
       s2:='';
       tt:='';
      end;
      if pos('<stoppoint ',s)>0 then begin
       if s1='!nst!!4' then begin
         s1:=getParam('station_code',s);
         tt:=copy(getParam('departure_time',s),1,length(getParam('departure_time',s))-3);
       end;
       s2:=getParam('station_code',s);
      end;
      if pos('<schedule ',s)>0 then begin
         sd:=getParam('days',s);
      end;
      if pos('</thread>',s)>0 then begin
         sd:=trim(utf8toansi(sd));
         f1.add(st2.getstring(st1.SearchString(s1))+#9+st2.getstring(st1.SearchString(s2))+#9+s1+#9+s2+#9+tt+#9+sd);
         rs:=utf8toansi(s1)+'|'+utf8toansi(s2)+'|'+tt;
         nr:=rti.searchstring(rs);
          if nr>0 then begin
            dt:=EncodeDate(strtointe(copy(sd,1,4)),strtointe(copy(sd,6,2)),strtointe(copy(sd,9,2)));
            case DayOfTheWeek(dt) of
             1: rt1.edit(nr,'1');
             2: rt2.edit(nr,'1');
             3: rt3.edit(nr,'1');
             4: rt4.edit(nr,'1');
             5: rt5.edit(nr,'1');
             6: rt6.edit(nr,'1');
             7: rt7.edit(nr,'1');
            end;
          end
           else begin
             rti.add(rs);
             rtis.add(utf8toansi(s1));
             rtie.add(utf8toansi(s2));
             rtit.add(utf8toansi(tt));
             rtid.add('');
             dt:=DayOfTheWeek(EncodeDate(strtointe(copy(sd,1,4)),strtointe(copy(sd,6,2)),strtointe(copy(sd,9,2))));
             if dt=1 then rt1.add('1') else rt1.add('0');
             if dt=2 then rt2.add('1') else rt2.add('0');
             if dt=3 then rt3.add('1') else rt3.add('0');
             if dt=4 then rt4.add('1') else rt4.add('0');
             if dt=5 then rt5.add('1') else rt5.add('0');
             if dt=6 then rt6.add('1') else rt6.add('0');
             if dt=7 then rt7.add('1') else rt7.add('0');
           end;
      end;
    end;
  end;
    f1.clear;
    f1.add('code'+#9+'title');
    if rti.count>0 then begin
     for n:=1 to rti.count do begin
       rs:=rt1.getstring(n)+rt2.getstring(n)+rt3.getstring(n)+rt4.getstring(n)+rt5.getstring(n)+rt6.getstring(n)+rt7.getstring(n);
       rtid.edit(n,rs);
       f1.add(st2.getstring(st1.SearchString(rtis.getstring(n)))+#9+st2.getstring(st1.SearchString(rtie.getstring(n)))+#9+rtis.getstring(n)+#9+rtie.getstring(n)+#9+rtit.getstring(n)+#9+rtid.getstring(n));
     end;
    end;
    f1.savetofile(fn+'.rtlist');
    f1.clear;
  rti.free; rtis.free; rtie.free; rtit.free; rtid.free; rt1.free; rt2.free; rt3.free; rt4.free; rt5.free; rt6.free; rt7.free;
  f.free; f1.free; st1.free; st2.free; ns.free;
  showmessage('end!');
end;

procedure TForm1.Button10Click(Sender: TObject);
  var f,f1,st1,st2,ns,rs,rn,rt,rd,rz,ct1,ct2,u,ri,rs1,rn1,wh1,wh2,wh3,f9:AF_Types.TStrings;
  var i,n,schc,nr1,nr2,rr,whr,rs11,rs21:integer;
  var s,s1,s2,tt,tt1,sd,fn,fn1,fn2,fn3,sr,sr1,pe:string;
begin
  //  
  fn:=_crimea_old_file;
  //  
  fn1:=_aurora_file+'.rtlist';
  //   
  fn2:='C:\AF\\code_compare.txt';
  //   
  fn3:='C:\AF\\whitelist.txt';
  f.create; f1.create; st1.create; st2.create; ns.create; rs.create; rn.create; rt.create; rd.create; ct1.create; ct2.create; u.create; ri.create; rz.create; rs1.create; rn1.create; wh1.create; wh2.create; wh3.create; f9.create;
  f.loadfromfile(fn2);
   if f.count>0 then begin
    for i:=1 to f.count do begin
      ParseCSVStrEx(@u,f.getstring(i),#9);
      if u.count>1 then begin
        ct1.add(u.getstring(1));
        ct2.add(u.getstring(2));
      end;
    end;
   end;
  f.clear;
  f.loadfromfile(fn3);
   if f.count>1 then begin
    for i:=2 to f.count do begin
      ParseCSVStrEx(@u,f.getstring(i),#9);
      if u.count>1 then begin
        wh1.add(u.getstring(3));
        wh2.add(u.getstring(4));
        wh3.add(u.getstring(3)+'|'+u.getstring(4));
      end;
    end;
   end;
  f.clear;
  f.loadfromfile(fn1);
   if f.count>0 then begin
    for i:=1 to f.count do begin
      ParseCSVStrEx(@u,f.getstring(i),#9);
      if u.count>5 then begin
        rs1.add(u.getstring(1));
        rn1.add(u.getstring(2));
        rs.add(u.getstring(3));
        rn.add(u.getstring(4));
        rt.add(timed0(u.getstring(5)));
        rd.add(u.getstring(6));
        ri.add(u.getstring(3)+'|'+u.getstring(4)+'|'+timed0(u.getstring(5)));
        rz.add('0');
      end;
    end;
   end;
  f.clear;
  f.loadfromfile(fn);
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<station ',s)>0 then begin
        st1.add(getParam('code',s));
        st2.add(getParam('title',s));
      end;
    end;
    f1.clear;
    f1.add('departure'+#9+'arrival'+#9+'code_departure'+#9+'code_arrival'+#9+'time'+#9+'days'+#9+'status');
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
       s1:='!nst!!4';
       s2:='';
       tt:='';
       sd:='';
       tt1:='';
       schc:=0;
      end;
      if pos('<stoppoint ',s)>0 then begin
       if s1='!nst!!4' then begin
         s1:=getParam('station_code',s);
         tt:=timed0(getParam('departure_time',s));
       end;
       s2:=getParam('station_code',s);
      end;
      if pos('<schedule ',s)>0 then begin
         sd:=getParam('days',s);
         pe:=getParam('period_end_date',s);
         tt1:=timed0(getParam('times',s));
         inc(schc);
      end;
      if pos('</thread>',s)>0 then begin
         if ct1.SearchString(utf8toansi(s1))>0 then begin
          rs11:=ct1.SearchString(utf8toansi(s1));
          rs21:=ct1.SearchString(utf8toansi(s2));
          if ((rs11>0)and(rs21>0)) then sr:=ct2.getstring(rs11)+'|'+ct2.getstring(rs21)+'|'+timed0(utf8toansi(tt))
                   else begin
                     sr:=utf8toansi(s1)+'|'+utf8toansi(s2)+'|'+timed0(utf8toansi(tt));
                     if rs11<1 then f9.add(s1);
                     if rs21<1 then f9.add(s2);
                   end;
          rr:=ri.SearchString(sr);
         end
          else rr:=0;
         if rr>0 then begin
                        sr1:='OK';
                        rz.edit(rr,'1');
                      end
                      else begin
                        whr:=wh3.SearchString(utf8toansi(s1)+'|'+utf8toansi(s2));
                        if whr>0 then sr1:='WHITELIST'
                                 else sr1:='NOT FOUND';
                      end;
         rs11:=st1.SearchString(s1);
         rs21:=st1.SearchString(s2);
                   if ((rs11>0)and(rs21>0)) then f1.add(st2.getstring(st1.SearchString(s1))+#9+st2.getstring(st1.SearchString(s2))+#9+s1+#9+s2+#9+tt+#9+sd+#9+sr1)
                    else begin
                      f1.add(s1+#9+s2+#9+s1+#9+s2+#9+tt+#9+sd+#9+sr1)
                    end;
         if schc>1 then showmessage('double schedule - '+utf8toansi(st2.getstring(st1.SearchString(s1))+#9+st2.getstring(st1.SearchString(s2))+#9+s1+#9+s2+#9+tt+#9+sd));
         if tt<>tt1 then f1.add(AnsiToUtf8('error -    '+tt+'  '+tt1));
      end;
    end;
  end;
  f1.savetofile(fn+'.compare.tsv');
  f1.clear;
  f1.add('departure'+#9+'arrival'+#9+'code_departure'+#9+'code_arrival'+#9+'time'+#9+'days');
  if rz.count>0 then begin
   for i:=1 to rz.count do begin
     if rz.getstring(i)='0' then begin
       f1.add(rs1.getstring(i)+#9+rn1.getstring(i)+#9+rs.getstring(i)+#9+rn.getstring(i)+#9+rt.getstring(i)+#9+rd.getstring(i));
     end;
   end;
  end;
  f1.savetofile(fn+'.notfound.tsv');
  f9.savetofile(fn+'.ERRORS.tsv');
  f.free; f1.free; st1.free; st2.free; ns.free; rs.free; rt.free; rn.free; rd.free; ct1.free; ct2.free; u.free; ri.free; rz.free; rs1.free; rn1.free; wh1.free; wh2.free; wh3.free; f9.free;
  showmessage('end!');
end;

procedure TForm1.Button11Click(Sender: TObject);
begin
  if fileexists('C:\AF\\old.xml'+'.addroutes') then deletefile('C:\AF\\old.xml'+'.addroutes');
  unit2.vfn:='C:\AF\\old.xml';
  unit2.loadflag:=false;
  unit2.sflag:=false;
  unit2.fr.clear;
  unit2.fr.add('');
  form2.Button2.enabled:=false;
  form2.Button4.enabled:=false;
  form2.ShowModal;
  unit2.fr.savetofile('C:\AF\\old.xml'+'.addroutes');
end;

procedure TForm1.Button13Click(Sender: TObject);
  var f,f1:AF_Types.TStrings;
  var i,n:integer;
  var s,s1,s2:string;
begin
  f.create; f1.create;
  f.loadfromfile('C:\1\24\11.1');
  if f.count>0 then begin
   for i:=1 to f.count do begin
    s:=f.getstring(i);
    n:=pos('schedule.html?point',s);
    if n>0 then begin
      s1:=copy(s,n+20,10);
      if pos('"',s1)>1 then s1:=trim(copy(s1,1,pos('"',s1)-1));
      s2:='';
      n:=pos('title=""',s);
      if n>0 then begin
        s2:=copy(s,n+16,100);
        if pos('<',s2)>1 then s2:=trim(copy(s2,1,pos('<',s2)-1));
      end;
      f1.add(s1+#9+s2);
    end;
   end;
  end;
  f1.savetofile('C:\1\24\cat_new.cf');
  showmessage('End!');
  f.free; f1.free;
end;

Function GetInetFileStr (const fileURL: String):widestring;
const BufferSize = 1024;
var
  hSession, hURL: HInternet;
  Buffer: array[1..BufferSize] of Byte;
  BufferLen: DWORD;
  sAppName: String;
  outbuf: WideString;
  l:integer;
begin
  outbuf:='';
  sAppName := 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:61.0) Gecko/20100101 Firefox/61.0';
  hSession :=InternetOpen(PChar(sAppName), INTERNET_OPEN_TYPE_PRECONFIG, nil, nil, 0);
  try
    hURL := InternetOpenURL(hSession, PChar(fileURL), nil, 0, INTERNET_FLAG_RELOAD, 0);
    try
      repeat
      try
        bufferlen:=0;
        InternetReadFile(hURL, @Buffer, SizeOf(Buffer), BufferLen);
      except
      end;
        if bufferlen>0 then begin
          try
           for l:=1 to bufferlen do outbuf:=outbuf+chr(buffer[l]);
          except
          end;
        end;
      until BufferLen = 0;
    finally
      InternetCloseHandle(hURL)
    end
  finally
    InternetCloseHandle(hSession)
  end;
  result:=outbuf;
end;

Function GetInetFileStrCurl (const fileURL: String):widestring;
var s:string;
var ws:widestring;
var i:integer;
var f:AF_Types.TStrings;
var SEInfo: TShellExecuteInfo;
var ExitCode: DWORD;
var ExecuteFile, ParamString, StartInString: string;
begin
  f.create;
  ws:='';
  s:=DeleteSlasheEx(ExtractDirPath(Application.Exename));
  if fileexists(s+'\temp.tmp') then deletefile(s+'\temp.tmp');
   ExecuteFile:='C:\UTILS\curl\curl.exe';
   ParamString:=fileurl+' -o "'+s+'\temp.tmp'+'"';
   FillChar(SEInfo, SizeOf(SEInfo), 0) ;
   SEInfo.cbSize := SizeOf(TShellExecuteInfo) ;
   with SEInfo do begin
     fMask := SEE_MASK_NOCLOSEPROCESS;
     Wnd := Application.Handle;
     lpFile := PChar(ExecuteFile) ;
     lpParameters := PChar(ParamString) ;
     nShow := SW_SHOWMINNOACTIVE;
   end;
   if ShellExecuteEx(@SEInfo) then begin
     repeat
       Application.ProcessMessages;
       GetExitCodeProcess(SEInfo.hProcess, ExitCode) ;
     until (ExitCode <> STILL_ACTIVE) or Application.Terminated;
     f.loadfromfile(s+'\temp.tmp');
     if f.count>0 then begin
       for i:=1 to f.count do begin
         if i=1 then ws:=f.getstring(i)
                else ws:=ws+' '+f.getstring(i);
       end;
     end;
   end
   else ShowMessage('  CURL!') ;
   result:=ws;
   f.free;
end;

function CatTime(s:string):string;
  var s1:string;
  var n:integer;
  var dt:TDateTime;
begin
 if length(s)=13 then s1:=copy(s,1,length(s)-3)
                 else s1:=s;
 n:=strtointe(s1);
 dt:=UnixToDateTime(n);
 result:=FormatDateTime('hh:nn',dt);
end;

procedure TForm1.Button12Click(Sender: TObject);
  var ws:widestring;
  var js:TlkJSONobject;
  var f,f1,u,pl,p2:AF_Types.TStrings;
  var i,n,rc:integer;
  var rid,rst1,rst2,rotpr,rprib,rtitle,rnumber,rstate:string;
begin
  f.create; f1.create; u.create; pl.create; p2.create;
  f.loadfromfile('C:\AF\\cat_new.cf');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      ParseCSVStrEx(@u,f.getstring(i),#9);
      if u.count>1 then begin
        if validstr(u.getstring(1)) then begin
          pl.add(u.getstring(1));
          p2.add(u.getstring(2));
        end;
      end;
    end;
  end;
  f.clear;
  if pl.count>0 then begin
   for i:=1 to pl.count do begin
    statusbar1.SimpleText:=' '+inttostr(i)+'  '+inttostr(pl.count);
    Application.ProcessMessages;
    ws:=GetInetFileStrCurl('http://asu.cravtr.ru:5000/bush-api/ns/trips/'+pl.getstring(i)+'/all?showAll=true');
    js := TlkJSON.ParseText(ws) as TlkJSONobject;
    if assigned(js) then begin
     rc:=js.Field['data'].Count;
     if rc>0 then begin
       for n:=0 to rc-1 do begin
        rid:=''; rst1:=''; rst2:=''; rotpr:=''; rprib:=''; rtitle:=''; rnumber:=''; rstate:='';
        rid:=js.Field['data'].Child[n].Field['id'].Value;
        rst1:=js.Field['data'].Child[n].Field['allSegment'].Field['departure'].Field['point'].Field['name'].Value;
        rst2:=js.Field['data'].Child[n].Field['allSegment'].Field['destination'].Field['point'].Field['name'].Value;
        rotpr:=cattime(js.Field['data'].Child[n].Field['allSegment'].Field['departure'].Field['departure'].Value);
        rprib:=cattime(js.Field['data'].Child[n].Field['allSegment'].Field['destination'].Field['arrival'].Value);
        rtitle:=js.Field['data'].Child[n].Field['schedule'].Field['route'].Field['name'].Value;
        rnumber:=js.Field['data'].Child[n].Field['schedule'].Field['number'].Value;
        rstate:=js.Field['data'].Child[n].Field['state'].Field['state'].Value;
        f1.add(p2.getstring(i)+#9+pl.getstring(i)+#9+rid+#9+rst1+#9+rst2+#9+rotpr+#9+rprib+#9+rtitle+#9+rnumber+#9+rstate);
       end;
     end;
    end;
    f1.savetofile('C:\AF\\cat_new.1');
    sleep(10000);
    application.ProcessMessages;
   end; //for i
  end;
//  showmessage(rid+#13#10+rst1+#13#10+rst2+#13#10+rotpr+#13#10+rprib+#13#10+rtitle+#13#10+rnumber+#13#10+rstate);
  f1.savetofile('C:\AF\\cat_new.1');
  showmessage('end!');
  statusbar1.SimpleText:='';
  f.free; f1.free; u.free; pl.free; p2.free;
end;

procedure TForm1.Button14Click(Sender: TObject);
  var f,f1,f2,u,so1,sp1,to1,tp1,da1,id1,so2,sp2,to2,tp2,da2,id2,fl2,f1s,f2s,f3:AF_Types.TStrings;
  var i,n,h,m:integer;
  var wd,s:string;
begin
 f.create; f1.create; f2.create; u.create; so1.create; sp1.create; to1.create; tp1.create; da1.create; id1.create; so2.create; sp2.create; to2.create; tp2.create; da2.create; id2.create; fl2.create; f1s.create; f2s.create; f3.create;
 if OpenDialog1.Execute then begin
  CreateXMLList(Opendialog1.FileName,@f2s);
  wd:=DeleteSlasheEx(ExtractDirPath(OpenDialog1.FileName));
  f.loadfromfile(wd+'\cat_new.1');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      ParseCSVStrEx(@u,f.getstring(i),#9);
      if u.count>6 then begin
       if u.getstring(10)<>'Skip' then begin
        tohm(u.getstring(6),h,m);
        inchm(h,m,180);
        s:=ansilowercase(trim(u.getstring(4)))+'|'+ansilowercase(trim(u.getstring(5)))+'|'+fromhm0(h,m);
        if f1s.SearchString(u.getstring(4))<1 then f1s.add(u.getstring(4));
        if f1s.SearchString(u.getstring(5))<1 then f1s.add(u.getstring(5));
        n:=id2.SearchString(s);
        if n<=0 then begin
          so2.add(u.getstring(4));
          sp2.add(u.getstring(5));
          tohm(u.getstring(6),h,m);
          inchm(h,m,180);
          to2.add(fromhm0(h,m));
          tohm(u.getstring(7),h,m);
          inchm(h,m,180);
          tp2.add(fromhm0(h,m));
          da2.add('');
          id2.add(s);
          fl2.add('0');
        end;
       end; 
      end;
    end;
  end;
  f.clear;
  f.loadfromfile(OpenDialog1.FileName+'.tsv');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      ParseCSVStrEx(@u,f.getstring(i),#9);
      if u.count>4 then begin
        tohm(u.getstring(5),h,m);
        s:=ansilowercase(trim(u.getstring(1)))+'|'+ansilowercase(trim(u.getstring(2)))+'|'+fromhm0(h,m);
        n:=id1.SearchString(s);
        if n<=0 then begin
          so1.add(u.getstring(1));
          sp1.add(u.getstring(2));
          tohm(u.getstring(5),h,m);
          to1.add(fromhm0(h,m));
          tp1.add('');
          da1.add(u.getstring(6));
          id1.add(s);
        end;
      end;
    end;
  end;
  if ((id1.count>0)and(id2.count>0)) then begin
    for i:=1 to id1.count do begin
      s:=id1.getstring(i);
      n:=id2.SearchString(s);
      if n>0 then begin
         fl2.edit(n,'1');
         f1.add(so1.getstring(i)+#9+sp1.getstring(i)+#9+to1.getstring(i)+#9+da1.getstring(i)+#9+'OK');
      end
       else begin
         f1.add(so1.getstring(i)+#9+sp1.getstring(i)+#9+to1.getstring(i)+#9+da1.getstring(i)+#9+'NOTFOUND');
       end;
    end;
    for i:=1 to id2.count do begin
      if fl2.getstring(i)='0' then begin
         f2.add(so2.getstring(i)+#9+sp2.getstring(i)+#9+to2.getstring(i)+#9+tp2.getstring(i)+#9+da2.getstring(i)+#9+'ADD');
      end;
    end;
    f1.add('');
    f2.add('');
    f1s.add('');
    f1.savetofile(wd+'\compare.tsv');
    f2.savetofile(wd+'\addnew.tsv');
    f1s.savetofile(wd+'\cpstat.tsv');
    f3.add('  ,   XML');
    if f1s.count>0 then begin
      for i:=1 to f1s.count do begin
        if validstr(f1s.getstring(i)) then begin
          if f2s.SearchString(f1s.getstring(i))<1 then f3.add(f1s.getstring(i));
        end;
      end;
    end;
    f3.add('');
    f3.add('  XML,   ');
    if f2s.count>0 then begin
      for i:=1 to f2s.count do begin
        if validstr(f2s.getstring(i)) then begin
          if f1s.SearchString(f2s.getstring(i))<1 then f3.add(f2s.getstring(i));
        end;
      end;
    end;
    f3.savetofile(wd+'\cpcompare.tsv');
    showmessage('end! '+inttostr(id1.count)+' '+inttostr(id2.count));
  end
   else showmessage('    !');

 end;
 f.free; f1.free; f2.free; u.free; so1.free; sp1.free; to1.free; tp1.free; da1.free; id1.free; so2.free; sp2.free; to2.free; tp2.free; da2.free; id2.free; fl2.free; f1s.free; f2s.free; f3.free;
end;

procedure TForm1.Button15Click(Sender: TObject);
  var f,f1:AF_Types.TStrings;
  var i:integer;
  var s:string;
begin
  f.create; f1.create;
  f.loadfromfile('C:\AF\\new50.xml');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('period_end_date=',s)>0 then begin
        s:=ReplaceParam(s,'period_end_date','2019-09-15',false);
      end;
      f1.add(s);
    end;
  end;
  f1.savetofile('C:\AF\\new51.xml');
  f.free; f1.free;
  showmessage('end!');
end;

end.
