unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, AF_Proc, AF_Types, Spin, Grids;

type
  TForm2 = class(TForm)
    Button1: TButton;
    StringGrid1: TStringGrid;
    ComboBox1: TComboBox;
    Button2: TButton;
    SpinEdit1: TSpinEdit;
    Button3: TButton;
    ListBox1: TListBox;
    Edit1: TEdit;
    Button4: TButton;
    Button5: TButton;
    procedure Button1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;
  vfn,aufn:string;
  loadflag,sflag,auflag:boolean;
  fr:AF_Types.TStrings;
  sthr1,ssch1:string;

implementation

{$R *.dfm}

function getParam(s1,s:string):string;
  var s2:string;
begin
  s:=trim(s);
  s2:='';
  if pos(s1+'="',s)>0 then begin
    s2:=copy(s,pos(s1+'="',s)+2+length(s1),length(s));
     if pos('"',s2)>0 then s2:=copy(s2,1,pos('"',s2)-1);
  end;
  result:=trim(s2);
end;

Function ReplaceParam(str1,param,value:string;add:boolean):string;
  var s,s1,s2,s3:string;
  var i,n:integer;
begin
  s:=str1;
  s:=StrReplace(s,' =','=');
  s:=StrReplace(s,'= ','=');
    if pos(param+'="',s)>0 then begin
      i:=pos(param+'="',s)+length(param)+2;
      if s[i]<>'"' then begin
       while s[i]<>'"' do begin
         delete(s,i,1);
         if i>=length(s) then break;
       end;
      end;
      insert(value,s,i);
    end
     else begin
      s:=str1;
      if add then begin
        if pos('/>',s)>0 then begin
          insert(' '+param+'="'+value+'" ',s,pos('/>',s));
        end
         else begin
          if pos('>',s)>0 then begin
           insert(' '+param+'="'+value+'" ',s,pos('>',s));
          end
           else s:=str1;
         end;
      end
       else s:=str1;
     end;
  result:=s;
end;



procedure xhm(var h,m:integer);
  begin
    if m>59 then begin
      inc(h,(m div 60));
      m:=m mod 60;
    end;
    if h>23 then begin
     h:=h-24;
    end;
  end;

procedure inchm(var h,m:integer; t:integer);
  begin
    inc(m,t);
    xhm(h,m);
  end;

procedure tohm(s:string; var h,m:integer);
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    s:=strreplace(s,'-',':');
    if pos(':',s)>0 then begin
      h:=StrToIntE(copy(s,1,pos(':',s)-1));
      m:=StrToIntE(copy(s,pos(':',s)+1,100));
    end;
  end;

function prephm(s:string):string;
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    s:=strreplace(s,'-',':');
    result:=s;
  end;

function fromhm(h,m:integer):string;
  begin
    xhm(h,m);
    if h>9 then begin
             if m>9 then fromhm:=inttostr(h)+':'+inttostr(m)
                    else fromhm:=inttostr(h)+':0'+inttostr(m);
           end
           else begin
             if m>9 then fromhm:='0'+inttostr(h)+':'+inttostr(m)
                    else fromhm:='0'+inttostr(h)+':0'+inttostr(m);
           end;
  end;



procedure TForm2.Button1Click(Sender: TObject);
  var f,f1,st1,st2,ns:AF_Types.TStrings;
  var i,n,schc:integer;
  var s,s1,s2,tt,tt1,sd,fn:string;
begin
  auflag:=false;
  ComboBox1.Items.Clear;
  //  
  fn:='C:\AF\\new17.xml';
  vfn:='C:\AF\\new17.xml';
  f.create; f1.create; st1.create; st2.create; ns.create;
  f.loadfromfile(fn);
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
       s1:=getParam('title',s);
      end;
      if pos('<schedule ',s)>0 then begin
         sd:=getParam('days',s);
         tt1:=getParam('times',s);
      end;
      if pos('</thread>',s)>0 then begin
        f1.add(utf8toansi(s1)+'|'+tt1);
      end;
    end;
  end;
  if f1.Count>0 then begin
    f1.SortedAsString;
    for i:=1 to f1.count do combobox1.Items.Add(f1.getstring(i));
    combobox1.ItemIndex:=0;
    ComboBox1Change(self);
  end;
  f.free; f1.free; st1.free; st2.free; ns.free;
end;

procedure ClearSG(sg:TStringGrid);
var c,r:integer;
begin
  for c:=0 to sg.colcount-1 do
   for r:=0 to sg.RowCount-1 do sg.cells[c,r]:='';
end;


procedure TForm2.ComboBox1Change(Sender: TObject);
  var f,f1,st1,st2,ns:AF_Types.TStrings;
  var i,n,schc,nr:integer;
  var s,s1,s2,s8,s9,s0,tt,tt1,sd,fn,sthr,ssch,sr1,sr2,sr3:string;
begin
 if not auflag then begin
  //  
  sflag:=false;
  clearsg(stringgrid1);
  stringgrid1.RowCount:=5;
  clearsg(stringgrid1);
  s0:=combobox1.Items.strings[combobox1.itemindex];
  s8:=ansitoutf8(copy(s0,1,pos('|',s0)-1));
  s9:=copy(s0,pos('|',s0)+1,10);
  fn:=vfn;
  f.create; f1.create; st1.create; st2.create; ns.create;
  f.loadfromfile(fn);
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
       s1:=getParam('title',s);
       sthr:=s;
       f1.clear;
      end;
      if pos('<stoppoint ',s)>0 then begin
         f1.add(s);
      end;
      if pos('<schedule ',s)>0 then begin
         sd:=getParam('days',s);
         tt1:=getParam('times',s);
         s:=ReplaceParam(s,'period_start_date','2017-01-01',false);
         s:=ReplaceParam(s,'period_end_date','2100-01-01',false);
         ssch:=s;
      end;
      if pos('</thread>',s)>0 then begin
         if s1=s8 then begin
         if tt1=s9 then begin
           if f1.count>1 then begin
             sthr1:=sthr;
             ssch1:=ssch;
             edit1.text:=utf8toansi(sd);
             loadflag:=true;
             stringgrid1.RowCount:=f1.count;
             clearsg(stringgrid1);
             button4.enabled:=true;
             for n:=1 to f1.count do begin
               stringgrid1.Cells[0,n-1]:=utf8toansi(getParam('station_code',f1.getstring(n)));
               stringgrid1.Cells[1,n-1]:=utf8toansi(getParam('station_title',f1.getstring(n)));
               stringgrid1.Cells[2,n-1]:=getParam('arrival_time',f1.getstring(n));
               stringgrid1.Cells[3,n-1]:=getParam('departure_time',f1.getstring(n));
               stringgrid1.Cells[4,n-1]:=getParam('distance',f1.getstring(n));
             end;
           end;
         end;
         end;
         f1.clear;
      end;
    end;
  end;
  f.free; f1.free; st1.free; st2.free; ns.free;
 end //not auflag
 else begin //auflag
  //  
  sflag:=false;
  clearsg(stringgrid1);
  stringgrid1.RowCount:=5;
  clearsg(stringgrid1);
  s0:=combobox1.Items.strings[combobox1.itemindex];
  s8:=copy(s0,1,pos('|',s0)-1);
  s9:=copy(s0,pos('|',s0)+1,10);
  fn:=aufn;
  f.create; f1.create; st1.create; st2.create; ns.create;
  f.loadfromfile(fn);
  if f.count>0 then begin
    for i:=1 to f.count do begin
     s:=utf8toansi(f.getstring(i));
     if pos('<station ',s)>0 then begin
      s1:=getParam('code',s);
      s2:=getParam('title',s);
      st1.add(s1);
      st2.add(s2);
     end;
    end;
    for i:=1 to f.count do begin
     s:=utf8toansi(f.getstring(i));
      if pos('<thread ',s)>0 then begin
       s1:=getParam('title',s);
       sthr:=s;
       f1.clear;
       s2:='';
       tt1:='';
      end;
      if pos('<stoppoint ',s)>0 then begin
         if s2='' then begin
           s2:=getParam('departure_time',s);
           if length(s2)>5 then s2:=copy(s2,1,length(s2)-3);
           tt1:=s2;
         end;
         f1.add(s);
      end;
      if pos('<schedule ',s)>0 then begin
         ssch:='				  <schedule times="'+tt1+'" days="" period_start_date="" period_end_date=""/>';
         sd:='';
      end;
      if pos('</thread>',s)>0 then begin
         if s1=s8 then begin
         if tt1=s9 then begin
           if f1.count>1 then begin
             sd:='';
             sthr1:=ansitoutf8(sthr);
             ssch1:=ssch;
             edit1.text:=sd;
             loadflag:=true;
             stringgrid1.RowCount:=f1.count;
             clearsg(stringgrid1);
             button4.enabled:=true;
             for n:=1 to f1.count do begin
               stringgrid1.Cells[0,n-1]:=getParam('station_code',f1.getstring(n));
               sr1:=stringgrid1.Cells[0,n-1];
               nr:=st1.SearchString(sr1);
               if nr>0 then sr2:=st2.getstring(nr)
                       else sr2:='';
               stringgrid1.Cells[1,n-1]:=sr2;
               sr3:=getParam('arrival_time',f1.getstring(n));
               if length(sr3)>5 then sr3:=copy(sr3,1,length(sr3)-3);
               stringgrid1.Cells[2,n-1]:=sr3;
               sr3:=getParam('departure_time',f1.getstring(n));
               if length(sr3)>5 then sr3:=copy(sr3,1,length(sr3)-3);
               stringgrid1.Cells[3,n-1]:=sr3;
             end;
           end;
         end;
         end;
         f1.clear;
      end;
    end;
  end;
  f.free; f1.free; st1.free; st2.free; ns.free;
 end; //auflag
end;

procedure TForm2.Button3Click(Sender: TObject);
  var i,h,m:integer;
begin
  if loadflag then begin
    sflag:=true;
    button2.enabled:=true;
    for i:=0 to stringgrid1.RowCount-2 do begin
      tohm(StringGrid1.cells[3,i],h,m);
      inchm(h,m,SpinEdit1.Value);
      StringGrid1.cells[3,i]:=fromhm(h,m);
    end;
    for i:=1 to stringgrid1.RowCount-1 do begin
      tohm(StringGrid1.cells[2,i],h,m);
      inchm(h,m,SpinEdit1.Value);
      StringGrid1.cells[2,i]:=fromhm(h,m);
    end;
  end;
end;

procedure TForm2.FormCreate(Sender: TObject);
begin
  fr.create;
end;

procedure TForm2.FormDestroy(Sender: TObject);
begin
  fr.free;
end;

procedure TForm2.Button2Click(Sender: TObject);
 var i:integer;
begin
 if sflag then begin
  sflag:=false;
  ssch1:=ReplaceParam(ssch1,'times',stringgrid1.cells[3,0],false);
  ssch1:=ReplaceParam(ssch1,'days',ansitoutf8(edit1.Text),false);
  fr.add(sthr1);
  fr.add('				<stoppoints>');
  for i:=0 to StringGrid1.RowCount-1 do begin
    fr.add('					<stoppoint station_code="'+ansitoutf8(stringgrid1.cells[0,i])+'" station_title="'+ansitoutf8(stringgrid1.cells[1,i])+'" arrival_time="'+stringgrid1.cells[2,i]+'" departure_time="'+stringgrid1.cells[3,i]+'" distance="'+stringgrid1.cells[4,i]+'"/>');
  end;
  fr.add('				</stoppoints>');
  fr.add('				<schedules>');
  fr.add(ssch1);
  fr.add('				</schedules>');
  fr.add('			</thread>');
  fr.add('');
  listbox1.Items.add(copy(combobox1.Items.strings[combobox1.itemindex],1,pos('|',combobox1.Items.strings[combobox1.itemindex])-1)+' '+stringgrid1.cells[3,0]+' '+edit1.text);
  ListBox1.TopIndex:=ListBox1.Items.Count-1;
  button2.enabled:=false;
 end
  else showmessage('    !');
end;

procedure TForm2.Button4Click(Sender: TObject);
 var i:integer;
begin
  sflag:=false;
  ssch1:=ReplaceParam(ssch1,'times',stringgrid1.cells[3,0],false);
  ssch1:=ReplaceParam(ssch1,'days',ansitoutf8(edit1.Text),false);
  fr.add(sthr1);
  fr.add('				<stoppoints>');
  for i:=0 to StringGrid1.RowCount-1 do begin
    fr.add('					<stoppoint station_code="'+ansitoutf8(stringgrid1.cells[0,i])+'" station_title="'+ansitoutf8(stringgrid1.cells[1,i])+'" arrival_time="'+stringgrid1.cells[2,i]+'" departure_time="'+stringgrid1.cells[3,i]+'" distance="'+stringgrid1.cells[4,i]+'"/>');
  end;
  fr.add('				</stoppoints>');
  fr.add('				<schedules>');
  fr.add(ssch1);
  fr.add('				</schedules>');
  fr.add('			</thread>');
  fr.add('');
  listbox1.Items.add(copy(combobox1.Items.strings[combobox1.itemindex],1,pos('|',combobox1.Items.strings[combobox1.itemindex])-1)+' '+stringgrid1.cells[3,0]+' '+edit1.text);
  ListBox1.TopIndex:=ListBox1.Items.Count-1;
  button4.enabled:=false;
end;

procedure TForm2.Button5Click(Sender: TObject);
  var f,f1,st1,st2,ns:AF_Types.TStrings;
  var i,n,schc:integer;
  var s,s1,s2,tt,tt1,sd,fn:string;
begin
  auflag:=true;
  ComboBox1.Items.Clear;
  //  
  fn:=aufn;
  f.create; f1.create; st1.create; st2.create; ns.create;
  f.loadfromfile(fn);
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=utf8toansi(f.getstring(i));
      if pos('<station ',s)>0 then begin
       s1:=getParam('code',s);
       s2:=getParam('title',s);
       st1.add(s1);
       st2.add(s2);
      end;
    end;
    for i:=1 to f.count do begin
      s:=utf8toansi(f.getstring(i));
      if pos('<thread ',s)>0 then begin
       s1:=getParam('title',s);
       s2:='';
      end;
      sd:='';
      if pos('<stoppoint ',s)>0 then begin
         if s2='' then begin
           s2:=getParam('departure_time',s);
           if length(s2)>5 then s2:=copy(s2,1,length(s2)-3);
         end;
      end;
      if pos('</thread>',s)>0 then begin
        f1.add(s1+'|'+s2);
      end;
    end;
  end;
  if f1.Count>0 then begin
    f1.SortedAsString;
    for i:=1 to f1.count do begin
      if combobox1.Items.IndexOf(f1.getstring(i))<0 then combobox1.Items.Add(f1.getstring(i));
    end;
    combobox1.ItemIndex:=0;
    ComboBox1Change(self);
  end;
  f.free; f1.free; st1.free; st2.free; ns.free;
end;

end.
