unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, AF_proc, AF_types, StdCtrls, ExtCtrls, FileCtrl, ComCtrls;

type
  TMTAPeriod = packed record
    startdate, enddate, days: string[20];
  end;
  TMTAReplaceDesc = packed record
    rnum: string[40];
    baseperiod: TMTAPeriod;
    rtype: string[25];
    param1, param2, param3: TMTAPeriod;
  end;
  TConf = array[1..2048] of TMTAReplaceDesc;
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    Button7: TButton;
    Button11: TButton;
    Button12: TButton;
    Button13: TButton;
    Button14: TButton;
    Button15: TButton;
    Button16: TButton;
    Button17: TButton;
    Button18: TButton;
    Bevel1: TBevel;
    Button20: TButton;
    Button22: TButton;
    OpenDialog1: TOpenDialog;
    Button19: TButton;
    Button23: TButton;
    CheckBox1: TCheckBox;
    Button21: TButton;
    OpenDialog2: TOpenDialog;
    CheckBox2: TCheckBox;
    Button24: TButton;
    Button25: TButton;
    Button26: TButton;
    StatusBar1: TStatusBar;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure Button15Click(Sender: TObject);
    procedure Button16Click(Sender: TObject);
    procedure Button17Click(Sender: TObject);
    procedure Button18Click(Sender: TObject);
    procedure Button22Click(Sender: TObject);
    procedure Button20Click(Sender: TObject);
    procedure Button19Click(Sender: TObject);
    procedure Button23Click(Sender: TObject);
    procedure Button21Click(Sender: TObject);
    procedure Button24Click(Sender: TObject);
    procedure Button25Click(Sender: TObject);
    procedure Button26Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

procedure CleanBlank(fn:string);


implementation

uses Unit2;

{$R *.dfm}

procedure ParseCSVStrEx(ts:AF_Types.PStrings; s:widestring; c:char);
 var n:integer;
begin
  ts.clear;
  while pos(c,s)>0 do begin
    n:=pos(c,s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;


function getParam(s1,s:string):string;
  var s2:string;
begin
  s:=trim(s);
  s2:='';
  if pos(s1+'="',s)>0 then begin
    s2:=copy(s,pos(s1+'="',s)+2+length(s1),length(s));
     if pos('"',s2)>0 then s2:=copy(s2,1,pos('"',s2)-1);
  end;
  result:=trim(s2);
end;

Function ReplaceParam(str1,param,value:string;add:boolean):string;
  var s,s1,s2,s3:string;
  var i,n:integer;
begin
  s:=str1;
  s:=StrReplace(s,' =','=');
  s:=StrReplace(s,'= ','=');
    if pos(param+'="',s)>0 then begin
      i:=pos(param+'="',s)+length(param)+2;
      if s[i]<>'"' then begin
       while s[i]<>'"' do begin
         delete(s,i,1);
         if i>=length(s) then break;
       end;
      end;
      insert(value,s,i);
    end
     else begin
      s:=str1;
      if add then begin
        if pos('/>',s)>0 then begin
          insert(' '+param+'="'+value+'" ',s,pos('/>',s));
        end
         else begin
          if pos('>',s)>0 then begin
           insert(' '+param+'="'+value+'" ',s,pos('>',s));
          end
           else s:=str1;
         end;
      end
       else s:=str1;
     end;
  result:=s;
end;


procedure TForm1.Button1Click(Sender: TObject);
  var tf,fo,fo1,fo2:TextFile;
  var s,s1,s2,rn,rt,ri,ps,pe:string;
  var i,n:integer;
  var dl:AF_Types.TStrings;
begin
  dl.create;
  AssignFile(fo,'C:\1\ 27\mta\log1.txt');
  ReWrite(fo);
  AssignFile(fo1,'C:\1\ 27\mta\log2.txt');
  ReWrite(fo1);
  AssignFile(fo2,'C:\1\ 27\mta\log3.txt');
  ReWrite(fo2);
  AssignFile(tf,'C:\1\ 27\mta\schedule1.xml');
  Reset(tf);
   while not eof(tf) do begin
     ReadLn(tf,s);
     s:=trim(s);
     if pos('<reis ',s)>0 then begin
       ps:='';
       pe:='';
       ps:=getparam('period_start',s);
       pe:=getparam('period_end',s);
       if dl.SearchString(ps+' - '+pe)<=0 then dl.add(ps+' - '+pe);
     end;
     if pos('<route ',s)>0 then begin
      if ri<>getparam('internal_number',s) then begin
         WriteLn(fo,''+rn+' '+rt+'  ('+ri+')');
         if dl.count>0 then begin
          for i:=1 to dl.count do begin
           WriteLn(fo,'    '+dl.getstring(i));
          end;
         end;
         WriteLn(fo,'');
         if dl.SearchText('2013')<=0 then begin
           WriteLn(fo1,''+rn+' '+rt+'  ('+ri+')');
           if dl.count>0 then begin
            for i:=1 to dl.count do begin
             WriteLn(fo1,'    '+dl.getstring(i));
            end;
           end;
           WriteLn(fo1,'');
           WriteLn(fo2,ri);
         end;
       rn:=''; rt:=''; ri:='';
       rn:=getparam('route_number',s);
       rt:=getparam('route_title',s);
       ri:=getparam('internal_number',s);
       dl.clear;
      end;
     end;
   end;

   if ri<>'' then begin
         WriteLn(fo,''+rn+' '+rt+'  ('+ri+')');
         if dl.count>0 then begin
          for i:=1 to dl.count do begin
           WriteLn(fo,'    '+dl.getstring(i));
          end;
         end;
         WriteLn(fo,'');
         if dl.SearchText('2013')<=0 then begin
           WriteLn(fo1,''+rn+' '+rt+'  ('+ri+')');
           if dl.count>0 then begin
            for i:=1 to dl.count do begin
             WriteLn(fo1,'    '+dl.getstring(i));
            end;
           end;
           WriteLn(fo1,'');
           WriteLn(fo2,ri);
         end;
   end;

  closefile(tf);
  closefile(fo);
  closefile(fo1);
  closefile(fo2);
  dl.free;
  ShowMessage('End!');
end;

procedure TForm1.Button2Click(Sender: TObject);
  var tf,fo,fo1,fo2:TextFile;
  var s,s1,s2,rn,rt,ri,ps,pe:string;
  var dl:AF_Types.Tstrings;
  var f:boolean;
begin
  dl.create;
  AssignFile(tf,'C:\1\ 27\mta\schedule.xml');
  Reset(tf);
  AssignFile(fo,'C:\1\ 27\mta\schedule1.xml');
  Rewrite(fo);
  dl.loadfromfile('C:\1\ 27\mta\log3.txt');
    while not eof(tf) do begin
      ReadLn(tf,s);
         if pos('<route ',s)>0 then begin
           f:=false;
           ri:=getparam('internal_number',s);
           if dl.SearchString(ri)>0 then f:=true;
         end;
         if pos('<reis ',s)>0 then begin
          if f then begin
           ps:='';
           pe:='';
           ps:=getparam('period_start',s);
           pe:=getparam('period_end',s);
           if ps<>pe then begin
            if pos('-2012',pe)>0 then begin
              s:=ReplaceParam(s,'period_end','31-12-2013',false);
            end;
           end;
          end;
         end;
      WriteLn(fo,s);
    end;
  closefile(fo);
  closefile(tf);
  dl.free;
  showmessage('end!');
end;

function find2012(ps:AF_Types.PStrings):boolean;
  var res:boolean;
  var n,l:integer;
  var s:string;
begin
  res:=false;
   if ps.count>0 then begin
     res:=true;
     for n:=1 to ps.count do begin
      s:=trim(ps.getstring(n));
      l:=length(s);
      if l>4 then begin
       s:=copy(s,l-3,4);
       if s<>'2012' then res:=false;
      end;
     end;
   end;
  result:=res;
end;

function find2(ps:AF_Types.PStrings):boolean;
  var res:boolean;
  var n,l:integer;
  var s:string;
begin
  res:=false;
   if ps.count>0 then begin
     for n:=1 to ps.count do begin
      s:=trim(ps.getstring(n));
      l:=length(s);
      if l>10 then begin
       s:=copy(s,7,4);
       if ((s<>'2012')and(s<>'2013')) then res:=true;
      end;
     end;
   end;
  result:=res;
end;

procedure TForm1.Button3Click(Sender: TObject);
  var tf,fo,fo1,fo2:TextFile;
  var s,s1,s2,rn,rt,ri,ps,pe:string;
  var i,n:integer;
  var dl:AF_Types.TStrings;
begin
  dl.create;
  AssignFile(fo,'C:\1\ 27\mta\log1.txt');
  ReWrite(fo);
  AssignFile(fo1,'C:\1\ 27\mta\log2.txt');
  ReWrite(fo1);
  AssignFile(fo2,'C:\1\ 27\mta\log3.txt');
  ReWrite(fo2);
  AssignFile(tf,'C:\1\ 27\mta\schedule.xml');
  Reset(tf);
   while not eof(tf) do begin
     ReadLn(tf,s);
     s:=trim(s);
     if pos('<reis ',s)>0 then begin
       ps:='';
       pe:='';
       ps:=getparam('period_start',s);
       pe:=getparam('period_end',s);
       if dl.SearchString(ps+' - '+pe)<=0 then dl.add(ps+' - '+pe);
     end;
     if pos('<route ',s)>0 then begin
      if ri<>getparam('internal_number',s) then begin
         WriteLn(fo,''+rn+' '+rt+'  ('+ri+')');
         if dl.count>0 then begin
          for i:=1 to dl.count do begin
           WriteLn(fo,'    '+dl.getstring(i));
          end;
         end;
         WriteLn(fo,'');
         if find2(@dl) then begin
           WriteLn(fo1,''+rn+' '+rt+'  ('+ri+')');
           if dl.count>0 then begin
            for i:=1 to dl.count do begin
             WriteLn(fo1,'    '+dl.getstring(i));
            end;
           end;
           WriteLn(fo1,'');
           WriteLn(fo2,ri);
         end;
       rn:=''; rt:=''; ri:='';
       rn:=getparam('route_number',s);
       rt:=getparam('route_title',s);
       ri:=getparam('internal_number',s);
       dl.clear;
      end;
     end;
   end;

   if ri<>'' then begin
         WriteLn(fo,''+rn+' '+rt+'  ('+ri+')');
         if dl.count>0 then begin
          for i:=1 to dl.count do begin
           WriteLn(fo,'    '+dl.getstring(i));
          end;
         end;
         WriteLn(fo,'');
         if find2(@dl) then begin
           WriteLn(fo1,''+rn+' '+rt+'  ('+ri+')');
           if dl.count>0 then begin
            for i:=1 to dl.count do begin
             WriteLn(fo1,'    '+dl.getstring(i));
            end;
           end;
           WriteLn(fo1,'');
           WriteLn(fo2,ri);
         end;
   end;

  closefile(tf);
  closefile(fo);
  closefile(fo1);
  closefile(fo2);
  dl.free;
  ShowMessage('End!');
end;

procedure TForm1.Button4Click(Sender: TObject);
  var f,f1,f2,xl,u:AF_Types.TStrings;
  var i,n:integer;
  var s,s1:string;
  var m:boolean;
begin
 f.create; f1.create; f2.create; u.create; xl.create;
 f.clear;
 f.loadfromfile('C:\1\11\new.csv');
 if f.count>0 then begin
  for i:=1 to f.count do begin
    ParseCSVStrEx(@u,f.getstring(i),';');
    if validstr(u.getstring(1)) then xl.add(u.getstring(1));
  end;
  m:=false;
  f.clear;
  f.loadfromfile('C:\1\11\mta30dek.1');
   if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<route ',s)>0 then begin
        s1:=getParam('internal_number',s);
        if validstr(s1) then begin
          if xl.SearchString(s1)<=0 then m:=true;
        end;
      end;
      if m then f1.add(s);
      if pos('</route>',s)>0 then m:=false;
    end;
    m:=false;
    f.clear;
    f.loadfromfile('C:\1\11\mta10fev.1');
     if f.count>0 then begin
      for i:=1 to f.count do begin
        s:=f.getstring(i);
        if pos('<route ',s)>0 then begin
          s1:=getParam('internal_number',s);
          if validstr(s1) then begin
            if xl.SearchString(s1)>0 then m:=true;
          end;
        end;
        if m then f2.add(s);
        if pos('</route>',s)>0 then m:=false;
      end;
      f.clear;
      f.add('<?xml version="1.0" encoding="Windows-1251"?>');
      f.add('<!--  reistype:0 - , 1 -  -->');
      f.add('<!--  rasptype:0 -   , 1 -   -->');
      f.add('<route_list>');
      if f1.count>0 then begin
       for i:=1 to f1.count do f.add(f1.getstring(i));
      end;
      if f2.count>0 then begin
       for i:=1 to f2.count do f.add(f2.getstring(i));
      end;
      f.add('</route_list>');
      f.savetofile('C:\1\11\mta_result.xml');
      showmessage('end!');
     end;
   end;
 end;
 f.free; f1.free; f2.free; u.free; xl.free;
end;

procedure TForm1.Button5Click(Sender: TObject);
  var f,f1,f2,xl,xt,u,bl:AF_Types.TStrings;
  var i,n:integer;
  var s,s1,s2,s3:string;
  var m:boolean;
  const oldfolder:string='C:\AF\MTA\26 \';
  const newfolder:string='C:\AF\MTA\20 \';
begin
 f.create; f1.create; f2.create; u.create; xl.create; xt.create; bl.create;

  f.loadfromfile(newfolder+'mtainternalnumberblacklists.csv');
   if f.count>0 then begin
    for i:=1 to f.count do begin
     ParseCSVStrEx(@u,f.getstring(i),';');
     if u.count>1 then begin
      if strtointe(u.getstring(2))<>0 then bl.add(u.getstring(2));
     end;
    end;
   end
    else begin
      showmessage('   mtainternalnumberblacklists.csv,   !');
    end;
 cleanblank(newfolder+'schedule.xml');   
 f.clear;
  f.loadfromfile(newfolder+'schedule.xml');     //  (  ) 
   if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<route ',s)>0 then begin
        s1:=trim(getParam('internal_number',s));
        if validstr(s1) then begin
          if xl.SearchString(s1)<=0 then begin
            xl.add(s1);  //   internal_number           -   
          end;
        end;
      end;
    end;
  m:=false;
  f.clear;
  f.loadfromfile(oldfolder+'schedule.xml');   //    
   if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<route ',s)>0 then begin
        s1:=getParam('internal_number',s);
        s2:=trim(getParam('route_number',s))+' '+trim(getParam('route_title',s)+'  ('+trim(getParam('internal_number',s))+')');
        if validstr(s1) then begin
          if xl.SearchString(s1)<=0 then begin
           if bl.SearchString(s1)<=0 then begin
            m:=true;
            if xt.SearchString(s2)<=0 then xt.add(s2);  //              -   m      
           end;
          end;
        end;
      end;
      if m then f1.add(s);  //   m  -     
      if pos('</route>',s)>0 then m:=false;
    end;
    m:=false;
    f.clear;
    f.loadfromfile(newfolder+'schedule.xml');  //    
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('</route_list>',s)>0 then f.edit(i,''); //     -  
    end;
    if f1.count>0 then begin
     for i:=1 to f1.count do f.add(f1.getstring(i));  //    
    end;
      f.add('</route_list>');  //   
      f1.savetofile(newfolder+'new_schedule.xml');
      xt.savetofile(newfolder+'add.txt');
      showmessage('end! '+inttostr(xt.count));
   end;
 end;
 f.free; f1.free; f2.free; u.free; xl.free; xt.free; bl.free;
end;

function ts2s(ts:AF_Types.PStrings):string;
 var s:string;
 var i:integer;
begin
 if ts.count>0 then begin
   for i:=1 to ts.count do s:=s+ts.getstring(i)+',';
   delete(s,length(s),1);
 end;
 result:=s;
end;

procedure TForm1.Button6Click(Sender: TObject);
  var f,u,o1,o2,n1,n2,x1,x2,g1,g2,g3:af_types.tstrings;
  var i,n,k:integer;
  var s:string;
begin
  f.create; u.create; o1.create; o2.create; n1.create; n2.create; x1.create; x2.create; g1.create; g2.create; g3.create;
  f.loadfromfile('C:\1\ 17\stations.');
   for i:=1 to f.count do begin
     ParseCSVStrEx(@u,f.getstring(i),';');
     if u.count>0 then begin
       o1.add(trim(u.getstring(1)));
       o2.add(trim(u.getstring(2)));
     end;
   end;
  f.loadfromfile('C:\1\ 17\stations2.');
   for i:=1 to f.count do begin
     ParseCSVStrEx(@u,f.getstring(i),';');
     if u.count>0 then begin
       n1.add(trim(u.getstring(1)));
       n2.add(trim(u.getstring(2)));
     end;
   end;
  f.loadfromfile('C:\1\ 17\comp.');
   for i:=1 to f.count do begin
     ParseCSVStrEx(@u,f.getstring(i),#9);
     if u.count>0 then begin
       x1.add(trim(u.getstring(2)));
       x2.add(trim(u.getstring(1)));
     end;
   end;
  f.loadfromfile('C:\1\ 17\groups.');
   for i:=1 to f.count do begin
     ParseCSVStrEx(@u,f.getstring(i),';');
     if u.count>1 then begin
       g1.add(trim(u.getstring(1)));
       g2.add(trim(u.getstring(2)));
       g3.add(trim(u.getstring(3)));
     end;
   end;
   for i:=1 to g3.count do begin
     ParseCSVStrEx(@u,g3.getstring(i),',');
     for n:=1 to u.count do begin
       s:=u.getstring(n);
       k:=o1.SearchString(s);
       if k>0 then begin
        s:=o2.getstring(k);
           k:=x1.SearchString(s);
           if k>0 then begin
            s:=x2.getstring(k);
               k:=n2.SearchString(s);
               if k>0 then begin
                s:=n1.getstring(k);
               end
                else s:='error3';
           end
            else s:='error2';
       end
        else s:='error1';
       u.edit(n,s);
     end;
     s:=ts2s(@u);
     g3.edit(i,s);
   end;
   f.clear;
   for i:=1 to g1.count do begin
    f.add(g1.getstring(i)+#9+g2.getstring(i)+#9+g3.getstring(i));
   end;
   f.savetofile('C:\1\ 17\groups_new.');
   showmessage('end!');
  f.free; u.free; o1.free; o2.free; n1.free; n2.free; x1.free; x2.free; g1.free; g2.free; g3.free;
end;


procedure TForm1.Button8Click(Sender: TObject);
 var dt:TDateTime;
 var tfs:TFormatSettings;
begin
  tfs.ShortDateFormat:='dd-mm-yyyy';
  tfs.LongDateFormat:='dd-mm-yyyy';
  tfs.DateSeparator:='-';
  form2.showmodal;
 showmessage(floattostr(form2.MonthCalendar1.Date));

end;

procedure TForm1.Button9Click(Sender: TObject);
  var f,f1:TextFile;
  var s,sn,s1,s2,dir, yn1s, yn2s, ny1s, ny2s:string;
  var tf,u,ync,yn1,yn2,nyc,ny1,ny2:AF_Types.TStrings;
  var i,yn,ny:integer;
begin
  dir:='C:\AF\MTA\28 \';
  tf.create; u.create; ync.create; yn1.create; yn2.create; nyc.create; ny1.create; ny2.create;
  if fileexists(dir+'yn.txt') then begin
    tf.clear;
    tf.loadfromfile(dir+'yn.txt');
     if tf.count>0 then begin
      for i:=1 to tf.count do begin
       ParseCSVStrEx(@u,tf.getstring(i),#9);
       if u.count>5 then begin
         ync.add(u.getstring(3));
         yn1.add(u.getstring(5));
         yn2.add(u.getstring(6));
       end;
      end;
     end;
  end;
  if fileexists(dir+'ny.txt') then begin
    tf.clear;
    tf.loadfromfile(dir+'ny.txt');
     if tf.count>0 then begin
      for i:=1 to tf.count do begin
       ParseCSVStrEx(@u,tf.getstring(i),#9);
       if u.count>5 then begin
         nyc.add(u.getstring(3));
         ny1.add(u.getstring(5));
         ny2.add(u.getstring(6));
       end;
      end;
     end;
  end;
  AssignFile(f,dir+'schedule.xml');
  Reset(f);
  AssignFile(f1,dir+'schedule_new.xml');
  ReWrite(f1);
  yn:=0;
  ny:=0;
    while not eof(f) do begin
      ReadLn(f,s);
      if pos('<route ',s)>0 then begin
        yn:=0;
        ny:=0;
        sn:=getParam('internal_number',s);
        yn:=ync.SearchString(sn);
         if yn>0 then begin
           yn1s:=yn1.getstring(yn);
           yn2s:=yn2.getstring(yn);
         end;
        ny:=nyc.SearchString(sn);
         if ny>0 then begin
           ny1s:=ny1.getstring(ny);
           ny2s:=ny2.getstring(ny);
         end;
      end;
      if pos('<reis ',s)>0 then begin
        if yn>0 then begin
          s2:=getParam('period_end',s);
          if s2=yn1s then s:=ReplaceParam(s,'period_end',yn2s,false);
        end;
        if ny>0 then begin
          s2:=getParam('period_start',s);
          if s2=ny1s then s:=ReplaceParam(s,'period_start',ny2s,false);
        end;
      end;
      WriteLn(f1,s);
    end;
  CloseFile(f1);
  CloseFile(f);
  tf.free; u.free; ync.free; yn1.free; yn2.free; nyc.free; ny1.free; ny2.free;
  showmessage('end');
end;


procedure CleanBlank(fn:string);
 var i,n,z,q:integer;
 var flg:boolean;
 var f1,f2:TextFile;
 var b,log,log_n,log_d,log_m,log_dc,log_nc,rlist,rl_rn,rl_ri,rl_rt,log_z:AF_Types.TStrings;
 var s,rn,ri,rt,td:string;
begin
with form1 do begin
  b.create; log.create; log_n.create; log_d.create; log_m.create; rlist.create; log_z.create; log_dc.create; log_nc.create; rl_ri.create; rl_rn.create; rl_rt.create;
  assignfile(f1,fn);
  assignfile(f2,fn+'.tmp');
  reset(f1);
  rewrite(f2);
  flg:=false;
    while not eof(f1) do begin
      ReadLn(f1,s);
      if pos('<reis ',s)>0 then begin
       if flg then ShowMessage('  - .');
       td:=getParam('days_of_week',s);
       b.clear;
       b.add(s);
       flg:=true;
      end
       else begin
         if pos('</reis',s)>0 then begin
          if not flg then ShowMessage('  - .');
          b.add(s);
          if b.count>3 then begin
           if td<>'-------' then begin
            for i:=1 to b.count do WriteLn(f2,b.getstring(i));
           end
            else begin
             z:=log_d.SearchString(ri);
             if z<=0 then begin
               log_d.add(ri);
               log_dc.add('1');
             end
              else begin
                q:=strtointe(log_dc.getstring(z));
                inc(q);
                log_dc.edit(z,inttostr(q));
              end;
             // log.add('       '+rn+' ('+ri+') '+rt);
            end;
          end
           else begin
             z:=log_n.SearchString(ri);
             if z<=0 then begin
               log_n.add(ri);
               log_nc.add('1');
             end
              else begin
                q:=strtointe(log_nc.getstring(z));
                inc(q);
                log_nc.edit(z,inttostr(q));
              end;
//             log.add('     '+rn+' ('+ri+') '+rt);
           end;
          b.clear;
          flg:=false;
         end
          else begin
            if pos('<route ',s)>0 then begin
             rn:=getParam('route_number',s);
             ri:=getParam('internal_number',s);
             rt:=getParam('route_title',s);
             z:=rl_ri.SearchString(ri);
             if z<=0 then begin
               rl_ri.add(ri);
               rl_rn.add(rn);
               rl_rt.add(rt);
             end;
            end;
            if flg then b.add(s)
                   else WriteLn(f2,s);
          end;
       end;
    end;
  closefile(f2);
  closefile(f1);
  deletefile(fn);
  log.add('');
  assignfile(f1,fn+'.tmp');
  assignfile(f2,fn);
  reset(f1);
  rewrite(f2);
  flg:=false;
    while not eof(f1) do begin
      ReadLn(f1,s);
      if pos('<route ',s)>0 then begin
       rn:=getParam('route_number',s);
       ri:=getParam('internal_number',s);
       rt:=getParam('route_title',s);
       if flg then ShowMessage('  - .');
       b.clear;
       b.add(s);
       flg:=true;
      end
       else begin
         if pos('</route>',s)>0 then begin
          if not flg then ShowMessage('  - .');
          b.add(s);
          if b.count>3 then begin
            z:=log_z.SearchString(ri);
            if z<=0 then log_z.add(ri);
            for i:=1 to b.count do WriteLn(f2,b.getstring(i));
          end
           else begin
            z:=log_m.SearchString(ri);
            if z<=0 then log_m.add(ri);
             // log.add('   '+rn+' ('+ri+') '+rt);
           end;
          b.clear;
          flg:=false;
         end
          else begin
            if flg then b.add(s)
                   else WriteLn(f2,s);
          end;
       end;
    end;
  closefile(f2);
  closefile(f1);
  deletefile(fn+'.tmp');
  if log_m.count>0 then begin
    for i:=1 to log_m.count do begin
      q:=rl_ri.SearchString(log_m.getstring(i));
      z:=log_z.SearchString(log_m.getstring(i));
      if z<=0 then log.add('    '+rl_rn.getstring(q)+' ('+rl_ri.getstring(q)+') '+rl_rt.getstring(q));
    end;
    log.add('');
    for i:=1 to log_m.count do begin
      q:=rl_ri.SearchString(log_m.getstring(i));
      z:=log_z.SearchString(log_m.getstring(i));
      if z>0 then log.add('    '+rl_rn.getstring(q)+' ('+rl_ri.getstring(q)+') '+rl_rt.getstring(q));
    end;
  end;
  log.add('');
  if log_n.count>0 then begin
    for i:=1 to log_n.count do begin
      q:=rl_ri.SearchString(log_n.getstring(i));
      z:=log_z.SearchString(log_n.getstring(i));
      if z>0 then log.add(' ('+log_nc.getstring(i)+')     '+rl_rn.getstring(q)+' ('+rl_ri.getstring(q)+') '+rl_rt.getstring(q))
             else log.add('    ('+log_nc.getstring(i)+')  ,  '+rl_rn.getstring(q)+' ('+rl_ri.getstring(q)+') '+rl_rt.getstring(q));
    end;
  end;
  log.add('');
  if log_d.count>0 then begin
    for i:=1 to log_d.count do begin
      q:=rl_ri.SearchString(log_d.getstring(i));
      z:=log_z.SearchString(log_d.getstring(i));
      if z>0 then log.add(' ('+log_dc.getstring(i)+')  c     '+rl_rn.getstring(q)+' ('+rl_ri.getstring(q)+') '+rl_rt.getstring(q))
             else log.add('    ('+log_dc.getstring(i)+')    ,  '+rl_rn.getstring(q)+' ('+rl_ri.getstring(q)+') '+rl_rt.getstring(q));
    end;
  end;

  log.savetofile(DeleteSlasheEx(ExtractDirPath(fn))+'\remove_blank.log');
  b.free; log.free; log_n.free; log_d.free; log_m.free; rlist.free; log_dc.free; log_nc.free; rl_ri.free; rl_rn.free; rl_rt.free; log_z.free;
end;
end;


procedure TForm1.Button10Click(Sender: TObject);
  var f:TextFile;
  var s,s0,s1,s1a,s2,sz,rnum,rmun,rtit,rint,ld:string;
  var i,n,m,x,rcount,rindex,k:integer;
  var f1,p1,p2,ri,rn,rt,rz,log,u,u1,u2,l3,l4,bl:AF_Types.TStrings;
  var tfs:TFormatSettings;
  var dt1,dt2:TDateTime;
begin
 if opendialog2.Execute then begin
 tfs.ShortDateFormat:='dd-mm-yyyy';
 tfs.LongDateFormat:='dd-mm-yyyy';
 tfs.DateSeparator:='-';
 p1.create; p2.create; log.create; ri.create; rn.create; rt.create; rz.create;  u.create; u1.create; u2.create; l3.create; l4.create; bl.create; f1.create;

   f1.loadfromfile(deleteslasheex(extractdirpath(OpenDialog2.FileName))+'\mtainternalnumberblacklists.csv');
   if f1.count>0 then begin
    for i:=1 to f1.count do begin
     ParseCSVStrEx(@u,f1.getstring(i),';');
     if u.count>1 then begin
      if strtointe(u.getstring(2))<>0 then bl.add(u.getstring(2));
     end;
    end;
   end
    else begin
      showmessage('   mtainternalnumberblacklists.csv,   !');
    end;
 f1.clear;
 u.clear;

 if checkbox2.Checked then CleanBlank(opendialog2.FileName);

 AssignFile(f,opendialog2.FileName);
 Reset(f);
  while not eof(f) do begin
    ReadLn(f,s);
    if pos('<route ',s)>0 then begin
      p1.clear;
      p2.clear;
      rtit:=getParam('route_title',s);
      rmun:=getParam('mun_obr',s);
      rnum:=getParam('route_number',s);
      rint:=getParam('internal_number',s);
      rindex:=ri.SearchString(rint);
      if rindex<=0 then rindex:=0
                   else begin
                     ParseCSVStrEx(@u,rz.getstring(rindex),';');
                     for i:=1 to u.count do begin
                       ParseCSVStrEx(@u1,u.getstring(i),'@');
                       p1.add(u1.getstring(1));
                       p2.add(u1.getstring(2));
                     end;
                   end;
    end;
    if pos('<reis ',s)>0 then begin
     if getParam('days_of_week',s)<>'-------' then begin
       s1:=getParam('period_start',s);
       s2:=getParam('period_end',s);
       s0:=s1+'|'+s2+'|'+getParam('days_of_week',s);
       x:=p1.SearchString(s0);
       if x>0 then begin
        m:=strtointe(p2.getstring(x));
        p2.edit(x,inttostr(m+1));
       end
        else begin
          p1.add(s0);
          p2.add('1');
        end;
     end;
    end;
    if pos('</route',s)>0 then begin
      if rindex>0 then begin
        s0:='';
        if p1.count>0 then begin
          for i:=1 to p1.count do begin
            s0:=s0+p1.getstring(i)+'@'+p2.getstring(i)+';';
          end;
          if length(s0)>1 then s0:=copy(s0,1,length(s0)-1);
        end;
        rz.edit(rindex,s0);
      end
       else begin
        s0:='';
        if p1.count>0 then begin
          for i:=1 to p1.count do begin
            s0:=s0+p1.getstring(i)+'@'+p2.getstring(i)+';';
          end;
          if length(s0)>1 then s0:=copy(s0,1,length(s0)-1);
        end;
        ri.add(rint);
        rn.add(rnum);
        rt.add(rtit);
        rz.add(s0);
       end;
    end;

  end;

 CloseFile(f);

 if ri.count>0 then begin
   for i:=1 to ri.count do begin
    if ((not CheckBox1.Checked)or((CheckBox1.Checked) and (not (strtointe(rn.getstring(i)) in [1..19])))) then begin
     s:=rn.getstring(i)+#9+rt.getstring(i)+#9+ri.getstring(i)+#9+#9+#9;
                     ParseCSVStrEx(@u,rz.getstring(i),';');
                     s1:='N';
                     s2:='N';
                     s1a:='+';
                     l3.clear;
                     l4.clear;
                     ld:='0000000';
                     for n:=1 to u.count do begin
                       ParseCSVStrEx(@u1,u.getstring(n),'@');
                       l3.add(#9#9+ri.getstring(i)+#9+u1.getstring(1)+#9+u1.getstring(2));
                       l4.add(u1.getstring(1));
                       ParseCSVStrEx(@u2,u1.getstring(1),'|');
                       dt1:=StrToDate(u2.getstring(1),tfs);
                       dt2:=StrToDate(u2.getstring(2),tfs);
                       if ((dt1<=date)and(dt2>=date)) then s1:='Y';   // 41680 - 10 
                       if ((dt1<=(date+30))and(dt2>=(date+30))) then s2:='Y';   // 41743 - 14 
 //                      if ((dt1>=41640)and(dt2<=41647)) then s1a:='+';
                       if pos('1',u2.getstring(3))>0 then ld[1]:='1';
                       if pos('2',u2.getstring(3))>0 then ld[2]:='1';
                       if pos('3',u2.getstring(3))>0 then ld[3]:='1';
                       if pos('4',u2.getstring(3))>0 then ld[4]:='1';
                       if pos('5',u2.getstring(3))>0 then ld[5]:='1';
                       if pos('6',u2.getstring(3))>0 then ld[6]:='1';
                       if pos('7',u2.getstring(3))>0 then ld[7]:='1';
                     end;
                     if ld<>'1111111' then s1a:='-';
                      if bl.SearchString(ri.getstring(i))<=0 then log.add(s+s1+s2+s1a);
                     if l3.count>0 then begin
                      for k:=1 to l3.count do begin
                       sz:=s1+s2+s1a;
                       if bl.SearchString(ri.getstring(i))<=0 then begin
                        if sz='YY+' then log.add(l3.getstring(k)+#9+s1+s2+s1a)
                                    else log.add(l3.getstring(k)+#9+s1+s2+s1a+#9+'replaceperiod'+#9+l4.getstring(k))
                       end;
                      end;
                     end;
//                     log.include(l3);
    end;
   end;
 end;


 log.savetofile(deleteslasheex(extractdirpath(opendialog2.FileName))+'\log.12');
 p1.free; p2.free; log.free; ri.free; rn.free; rt.free; rz.free; u.free; u1.free; u2.create; l3.free; l4.free; bl.free; f1.free;
 SHOWMESSAGE('END');
 end;
end;

function EncodeMTAP(s:string):TMTAPeriod;
 var t:AF_Types.TStrings;
 var i:integer;
begin
  t.create;
  ParseCSVStrEx(@t,s,'|');
  result.startdate:=t.getstring(1);
  result.enddate:=t.getstring(2);
  result.days:=t.getstring(3);
  t.free;
end;

function StrToMTAP(s:string):TMTAPeriod;
begin
  result.startdate:=getParam('period_start',s);
  result.enddate:=getParam('period_end',s);
  result.days:=getParam('days_of_week',s);
end;

function MTAPtoStr(mtap:TMTAPeriod; s:string):string;
begin
  s:=ReplaceParam(s,'period_start',mtap.startdate,true);
  s:=ReplaceParam(s,'period_end',mtap.enddate,true);
  s:=ReplaceParam(s,'days_of_week',mtap.days,true);
end;

function CompareMTAPs(mtp1,mtp2:TMTAPeriod):boolean;
begin
  result:=true;
  if mtp1.startdate<>mtp2.startdate then result:=false;
  if mtp1.enddate<>mtp2.enddate then result:=false;
  if mtp1.days<>mtp2.days then result:=false;
end;

procedure TForm1.Button7Click(Sender: TObject);
  var conf:TConf;
  var mtp,mtp1,mtp2:TMTAPeriod;
  var thread,copy1,copy2:AF_Types.TStrings;
  var f1,f2:TextFile;
  var dir,s,s1,s2,rnum,vdir:string;
  var i,k,m,n,confcount,ci:integer;
  var cmode,flg:boolean;
begin
 if OpenDialog1.Execute then begin
 vdir:=deleteslasheex(ExtractDirPath(OpenDialog1.FileName))+'\';
 thread.create; copy1.create; copy2.create;
 dir:=vdir;
 thread.loadfromfile(OpenDialog1.FileName);
 confcount:=0;
 if thread.count>0 then begin
  for i:=1 to thread.count do begin
   ParseCSVStrEx(@copy1,thread.getstring(i),#9);
   if copy1.count>6 then begin
     if ((ansilowercase(copy1.getstring(7))='delete')or(ansilowercase(copy1.getstring(7))='replaceperiod')or(ansilowercase(copy1.getstring(7))='copy')or(ansilowercase(copy1.getstring(7))='doublecopy')) then begin
       inc(confcount);
{       if copy1.getstring(3)='104' then begin
        showmessage('104');
       end;
}       conf[confcount].rnum:=copy1.getstring(3);
       conf[confcount].baseperiod:=EncodeMTAP(copy1.getstring(4));
       conf[confcount].rtype:=ansilowercase(copy1.getstring(7));
       conf[confcount].param1:=EncodeMTAP(copy1.getstring(8));
       conf[confcount].param2:=EncodeMTAP(copy1.getstring(9));
     end;
   end;
  end;
 end;
 thread.clear;
 copy1.clear;
 copy2.clear;
 AssignFile(f1,dir+'schedule.xml');
 Reset(f1);
 AssignFile(f2,dir+'schedule_new2.xml');
 ReWrite(f2);
 cmode:=false;
  while not eof(f1) do begin
   ReadLn(f1,s);
   if cmode then begin
     thread.add(s);
     if pos('</reis>',s)>0 then begin
      cmode:=false;
      //
      if thread.count>0 then begin
      if confcount>0 then begin
{        if rnum='104' then begin
          showmessage('104');
        end;
}        mtp:=StrToMTAP(thread.getstring(1));
        flg:=false;
         for i:=1 to confcount do begin
           if rnum=conf[i].rnum then begin
             if CompareMTAPs(mtp,conf[i].baseperiod) then begin
               ci:=i;
               flg:=true;
               break;
             end;
           end;
         end;
        if flg then begin
         if conf[ci].rtype='delete' then begin
           copy1.clear;
           copy2.clear;
           thread.clear;
         end;
         if conf[ci].rtype='replaceperiod' then begin
           copy1.clear;
           copy2.clear;
           s1:=thread.getstring(1);
           s1:=ReplaceParam(s1,'period_start',conf[ci].param1.startdate,true);
           s1:=ReplaceParam(s1,'period_end',conf[ci].param1.enddate,true);
           s1:=ReplaceParam(s1,'days_of_week',conf[ci].param1.days,true);
           thread.edit(1,s1);
         end;
         if conf[ci].rtype='replaceandcopy' then begin
           copy1.clear;
           copy2.clear;
           copy1.include(thread);
           s1:=thread.getstring(1);
           s1:=ReplaceParam(s1,'period_start',conf[ci].param1.startdate,true);
           s1:=ReplaceParam(s1,'period_end',conf[ci].param1.enddate,true);
           s1:=ReplaceParam(s1,'days_of_week',conf[ci].param1.days,true);
           thread.edit(1,s1);
           s1:=copy1.getstring(1);
           s1:=ReplaceParam(s1,'period_start',conf[ci].param2.startdate,true);
           s1:=ReplaceParam(s1,'period_end',conf[ci].param2.enddate,true);
           s1:=ReplaceParam(s1,'days_of_week',conf[ci].param2.days,true);
           copy1.edit(1,s1);
         end;
         if conf[ci].rtype='copy' then begin
           copy1.clear;
           copy2.clear;
           copy1.include(thread);
           s1:=copy1.getstring(1);
           s1:=ReplaceParam(s1,'period_start',conf[ci].param1.startdate,true);
           s1:=ReplaceParam(s1,'period_end',conf[ci].param1.enddate,true);
           s1:=ReplaceParam(s1,'days_of_week',conf[ci].param1.days,true);
           copy1.edit(1,s1);
         end;
         if conf[ci].rtype='doublecopy' then begin
           copy1.clear;
           copy2.clear;
           copy1.include(thread);
           copy2.include(thread);
           s1:=copy1.getstring(1);
           s1:=ReplaceParam(s1,'period_start',conf[ci].param1.startdate,true);
           s1:=ReplaceParam(s1,'period_end',conf[ci].param1.enddate,true);
           s1:=ReplaceParam(s1,'days_of_week',conf[ci].param1.days,true);
           copy1.edit(1,s1);
           s1:=copy2.getstring(1);
           s1:=ReplaceParam(s1,'period_start',conf[ci].param2.startdate,true);
           s1:=ReplaceParam(s1,'period_end',conf[ci].param2.enddate,true);
           s1:=ReplaceParam(s1,'days_of_week',conf[ci].param2.days,true);
           copy2.edit(1,s1);
         end;
        end;
      end;
      end;
      //
      if thread.count>0 then begin
       for i:=1 to thread.count do WriteLn(f2,thread.getstring(i));
      end;
      if copy1.count>0 then begin
       for i:=1 to copy1.count do WriteLn(f2,copy1.getstring(i));
      end;
      if copy2.count>0 then begin
       for i:=1 to copy2.count do WriteLn(f2,copy2.getstring(i));
      end;
     end;
   end
    else begin
      if pos('<reis ',s)>0 then begin
       cmode:=true;
       thread.clear;
       copy1.clear;
       copy2.clear;
       thread.add(s);
      end
       else begin
        WriteLn(f2,s);
        if pos('<route ',s)>0 then rnum:=getParam('internal_number',s);
       end;
    end;
  end;
 CloseFile(f2);
 CloseFile(f1);
 thread.free; copy1.free; copy2.free;
 showmessage('End!');
 end;
end;

procedure TForm1.Button11Click(Sender: TObject);
  var f:TextFile;
  var s,s0,s1,s1a,s2,rnum,rmun,rtit,rint:string;
  var i,n,m,x,rcount,rindex,k:integer;
  var p1,p2,ri,rn,rt,rz,log,u,u1,u2,l3:AF_Types.TStrings;
  var tfs:TFormatSettings;
  var dt1,dt2:TDateTime;
begin
 tfs.ShortDateFormat:='dd-mm-yyyy';
 tfs.LongDateFormat:='dd-mm-yyyy';
 tfs.DateSeparator:='-';
 p1.create; p2.create; log.create; ri.create; rn.create; rt.create; rz.create;  u.create; u1.create; u2.create; l3.create;
 AssignFile(f,'C:\AF\MTA\29 \schedule_new.xml');
 Reset(f);
 p1.clear;
  while not eof(f) do begin
    ReadLn(f,s);
    if pos('<reis ',s)>0 then begin
     if getParam('days_of_week',s)<>'-------' then begin
       s1:=getParam('period_start',s);
       s2:=getParam('period_end',s);
       s0:=s1+'|'+s2+'|'+getParam('days_of_week',s);
       x:=p1.SearchString(s0);
        if x<1 then begin
         dt1:=StrToDate(s1,tfs);
         dt2:=StrToDate(s2,tfs);
         if ((dt1>=41640)and(dt2<=41647)) then p1.add(s0);
        end;
     end;
    end;
  end;
 CloseFile(f);

 p1.savetofile('C:\AF\MTA\29 \cmd.5');
 p1.free; p2.free; log.free; ri.free; rn.free; rt.free; rz.free; u.free; u1.free; u2.create; l3.free;
 SHOWMESSAGE('END');
end;

procedure TForm1.Button12Click(Sender: TObject);
  var f:TextFile;
  var s,s0,s1,s1a,s2,rnum,rmun,rtit,rint:string;
  var i,n,m,x,rcount,rindex,k:integer;
  var p1,p2,ri,rn,rt,rz,log,u,u1,u2,l3:AF_Types.TStrings;
  var tfs:TFormatSettings;
  var dt1,dt2:TDateTime;
begin
 tfs.ShortDateFormat:='dd-mm-yyyy';
 tfs.LongDateFormat:='dd-mm-yyyy';
 tfs.DateSeparator:='-';
 p1.create; p2.create; log.create; ri.create; rn.create; rt.create; rz.create;  u.create; u1.create; u2.create; l3.create;
 AssignFile(f,'C:\AF\MTA\29 \schedule_new.xml');
 Reset(f);
 p1.clear;
  while not eof(f) do begin
    ReadLn(f,s);
    if pos('<reis ',s)>0 then begin
     if getParam('days_of_week',s)<>'-------' then begin
       s1:=getParam('period_start',s);
       s2:=getParam('period_end',s);
       s0:=s1+'|'+s2+'|'+getParam('days_of_week',s);
       x:=p1.SearchString(s0);
        if x<1 then begin
         dt1:=StrToDate(s1,tfs);
         dt2:=StrToDate(s2,tfs);
         if ((dt1>=41640)and(dt2>41647)) then p1.add(s0);
        end;
     end;
    end;
  end;
 CloseFile(f);

 p1.savetofile('C:\AF\MTA\29 \cmd.6');
 p1.free; p2.free; log.free; ri.free; rn.free; rt.free; rz.free; u.free; u1.free; u2.create; l3.free;
 SHOWMESSAGE('END');
end;

procedure TForm1.Button13Click(Sender: TObject);
  var conf:TConf;
  var mtp,mtp1,mtp2:TMTAPeriod;
  var thread,copy1,copy2:AF_Types.TStrings;
  var f1,f2:TextFile;
  var dir,s,s1,s2,rnum:string;
  var i,k,m,n,confcount,ci:integer;
  var cmode,flg:boolean;
begin
 thread.create; copy1.create; copy2.create;
 dir:='C:\AF\MTA\27 \';
 thread.loadfromfile(dir+'conf2016.txt');
 confcount:=0;
 if thread.count>0 then begin
  for i:=1 to thread.count do begin
   ParseCSVStrEx(@copy1,thread.getstring(i),#9);
   if copy1.count>2 then begin
     if ((ansilowercase(copy1.getstring(2))='replaceperiod')or(ansilowercase(copy1.getstring(2))='copy')or(ansilowercase(copy1.getstring(2))='doublecopy')or(ansilowercase(copy1.getstring(2))='replaceandcopy')or(ansilowercase(copy1.getstring(2))='replaceanddoublecopy')) then begin
       inc(confcount);
       conf[confcount].rnum:='';
       conf[confcount].baseperiod:=EncodeMTAP(copy1.getstring(1));
       conf[confcount].rtype:=ansilowercase(copy1.getstring(2));
       conf[confcount].param1:=EncodeMTAP(copy1.getstring(3));
       conf[confcount].param2:=EncodeMTAP(copy1.getstring(4));
       conf[confcount].param3:=EncodeMTAP(copy1.getstring(5));
     end;
   end;
  end;
 end;
 thread.clear;
 copy1.clear;
 copy2.clear;
 AssignFile(f1,dir+'schedule.xml');
 Reset(f1);
 AssignFile(f2,dir+'schedule_new1.xml');
 ReWrite(f2);
 cmode:=false;
  while not eof(f1) do begin
   ReadLn(f1,s);
   if cmode then begin
     thread.add(s);
     if pos('</reis>',s)>0 then begin
      cmode:=false;
      //
      if thread.count>0 then begin
      if confcount>0 then begin
        mtp:=StrToMTAP(thread.getstring(1));
        flg:=false;
         for i:=1 to confcount do begin
             if CompareMTAPs(mtp,conf[i].baseperiod) then begin
               ci:=i;
               flg:=true;
               break;
             end;
         end;
        if flg then begin
         if conf[ci].rtype='replaceperiod' then begin
           copy1.clear;
           copy2.clear;
           s1:=thread.getstring(1);
           s1:=ReplaceParam(s1,'period_start',conf[ci].param1.startdate,true);
           s1:=ReplaceParam(s1,'period_end',conf[ci].param1.enddate,true);
           s1:=ReplaceParam(s1,'days_of_week',conf[ci].param1.days,true);
           thread.edit(1,s1);
         end;
         if conf[ci].rtype='replaceandcopy' then begin
           copy1.clear;
           copy2.clear;
           copy1.include(thread);
           s1:=thread.getstring(1);
           s1:=ReplaceParam(s1,'period_start',conf[ci].param1.startdate,true);
           s1:=ReplaceParam(s1,'period_end',conf[ci].param1.enddate,true);
           s1:=ReplaceParam(s1,'days_of_week',conf[ci].param1.days,true);
           thread.edit(1,s1);
           s1:=copy1.getstring(1);
           s1:=ReplaceParam(s1,'period_start',conf[ci].param2.startdate,true);
           s1:=ReplaceParam(s1,'period_end',conf[ci].param2.enddate,true);
           s1:=ReplaceParam(s1,'days_of_week',conf[ci].param2.days,true);
           copy1.edit(1,s1);
         end;
         if conf[ci].rtype='copy' then begin
           copy1.clear;
           copy2.clear;
           copy1.include(thread);
           s1:=copy1.getstring(1);
           s1:=ReplaceParam(s1,'period_start',conf[ci].param1.startdate,true);
           s1:=ReplaceParam(s1,'period_end',conf[ci].param1.enddate,true);
           s1:=ReplaceParam(s1,'days_of_week',conf[ci].param1.days,true);
           copy1.edit(1,s1);
         end;
         if conf[ci].rtype='doublecopy' then begin
           copy1.clear;
           copy2.clear;
           copy1.include(thread);
           copy2.include(thread);
           s1:=copy1.getstring(1);
           s1:=ReplaceParam(s1,'period_start',conf[ci].param1.startdate,true);
           s1:=ReplaceParam(s1,'period_end',conf[ci].param1.enddate,true);
           s1:=ReplaceParam(s1,'days_of_week',conf[ci].param1.days,true);
           copy1.edit(1,s1);
           s1:=copy2.getstring(1);
           s1:=ReplaceParam(s1,'period_start',conf[ci].param2.startdate,true);
           s1:=ReplaceParam(s1,'period_end',conf[ci].param2.enddate,true);
           s1:=ReplaceParam(s1,'days_of_week',conf[ci].param2.days,true);
           copy2.edit(1,s1);
         end;
         if conf[ci].rtype='replaceanddoublecopy' then begin
           copy1.clear;
           copy2.clear;
           copy1.include(thread);
           copy2.include(thread);
           s1:=thread.getstring(1);
           s1:=ReplaceParam(s1,'period_start',conf[ci].param1.startdate,true);
           s1:=ReplaceParam(s1,'period_end',conf[ci].param1.enddate,true);
           s1:=ReplaceParam(s1,'days_of_week',conf[ci].param1.days,true);
           thread.edit(1,s1);
           s1:=copy1.getstring(1);
           s1:=ReplaceParam(s1,'period_start',conf[ci].param2.startdate,true);
           s1:=ReplaceParam(s1,'period_end',conf[ci].param2.enddate,true);
           s1:=ReplaceParam(s1,'days_of_week',conf[ci].param2.days,true);
           copy1.edit(1,s1);
           s1:=copy2.getstring(1);
           s1:=ReplaceParam(s1,'period_start',conf[ci].param3.startdate,true);
           s1:=ReplaceParam(s1,'period_end',conf[ci].param3.enddate,true);
           s1:=ReplaceParam(s1,'days_of_week',conf[ci].param3.days,true);
           copy2.edit(1,s1);
         end;
        end;
      end;
      end;
      //
      if thread.count>0 then begin
       for i:=1 to thread.count do WriteLn(f2,thread.getstring(i));
      end;
      if copy1.count>0 then begin
       for i:=1 to copy1.count do WriteLn(f2,copy1.getstring(i));
      end;
      if copy2.count>0 then begin
       for i:=1 to copy2.count do WriteLn(f2,copy2.getstring(i));
      end;
     end;
   end
    else begin
      if pos('<reis ',s)>0 then begin
       cmode:=true;
       thread.clear;
       copy1.clear;
       copy2.clear;
       thread.add(s);
      end
       else begin
        WriteLn(f2,s);
        if pos('<route ',s)>0 then rnum:=getParam('internal_number',s);
       end;
    end;
  end;
 CloseFile(f2);
 CloseFile(f1);
 thread.free; copy1.free; copy2.free;
 showmessage('End!');
end;

procedure TForm1.Button14Click(Sender: TObject);
  var f:TextFile;
  var s,s0,s1,s1a,s2,rnum,rmun,rtit,rint:string;
  var i,n,m,x,rcount,rindex,k:integer;
  var p1,p2,ri,rn,rt,rz,log,u,u1,u2,l3:AF_Types.TStrings;
  var tfs:TFormatSettings;
  var dt1,dt2:TDateTime;
begin
 tfs.ShortDateFormat:='dd-mm-yyyy';
 tfs.LongDateFormat:='dd-mm-yyyy';
 tfs.DateSeparator:='-';
 p1.create; p2.create; log.create; ri.create; rn.create; rt.create; rz.create;  u.create; u1.create; u2.create; l3.create;
 AssignFile(f,'C:\AF\MTA\29 \schedule.xml');
 Reset(f);
 p1.clear;
  while not eof(f) do begin
    ReadLn(f,s);
    if pos('<route ',s)>0 then begin
       rint:=getParam('internal_number',s);
    end;
    if pos('<reis ',s)>0 then begin
     if getParam('days_of_week',s)<>'-------' then begin
       s1:=getParam('period_start',s);
       s2:=getParam('period_end',s);
       s0:=rint+'|'+s1+'|'+s2+'|'+getParam('days_of_week',s);
       x:=p1.SearchString(s0);
        if x<1 then begin
         dt1:=StrToDate(s1,tfs);
         dt2:=StrToDate(s2,tfs);
         if ((dt1<=41680)and(dt2>=41686))  then p1.add(s0);
        end;
     end;
    end;
  end;
 CloseFile(f);

 p1.savetofile('C:\AF\MTA\29 \log042014.1');
 p1.free; p2.free; log.free; ri.free; rn.free; rt.free; rz.free; u.free; u1.free; u2.create; l3.free;
 SHOWMESSAGE('END');
end;


procedure TForm1.Button15Click(Sender: TObject);
  var f:TextFile;
  var s,s0,s1,s1a,s2,rnum,rmun,rtit,rint:string;
  var i,n,m,x,rcount,rindex,k:integer;
  var p1,p2,ri,rn,rt,rz,log,u,u1,u2,l3:AF_Types.TStrings;
  var tfs:TFormatSettings;
  var dt1,dt2:TDateTime;
begin
 tfs.ShortDateFormat:='dd-mm-yyyy';
 tfs.LongDateFormat:='dd-mm-yyyy';
 tfs.DateSeparator:='-';
 p1.create; p2.create; log.create; ri.create; rn.create; rt.create; rz.create;  u.create; u1.create; u2.create; l3.create;
 AssignFile(f,'C:\AF\MTA\14 \schedule.xml');
 Reset(f);
 p1.clear;
  while not eof(f) do begin
    ReadLn(f,s);
    if pos('<route ',s)>0 then begin
       rint:=getParam('internal_number',s);
    end;
    if pos('<reis ',s)>0 then begin
     if getParam('days_of_week',s)<>'-------' then begin
       s1:=getParam('period_start',s);
       s2:=getParam('period_end',s);
       s0:=rint+'|'+s1+'|'+s2+'|'+getParam('days_of_week',s);
       x:=p1.SearchString(s0);
        if x<1 then begin
         dt1:=StrToDate(s1,tfs);
         dt2:=StrToDate(s2,tfs);
         if ((dt1<=41743)and(dt2>=41749))  then p1.add(s0);
        end;
     end;
    end;
  end;
 CloseFile(f);

 p1.savetofile('C:\AF\MTA\29 \log042014.2');
 p1.free; p2.free; log.free; ri.free; rn.free; rt.free; rz.free; u.free; u1.free; u2.create; l3.free;
 SHOWMESSAGE('END');
end;

procedure TForm1.Button16Click(Sender: TObject);
  var f,u,fir,fir1:AF_Types.TStrings;
  var i,n:integer;
  var s,s1:string;
begin
  f.create; u.create; fir.create; fir1.create;
  f.loadfromfile('C:\AF\MTA\29 \log042014.1');
  for i:=1 to f.count do begin
    ParseCSVStrEx(@u,f.getstring(i),'|');
    if u.count>3 then begin
      fir.add(u.getstring(1)+'|'+u.getstring(4));
      fir1.add('0');
    end;
  end;
  f.clear;
  f.loadfromfile('C:\AF\MTA\29 \log042014.2');
  for i:=1 to f.count do begin
    ParseCSVStrEx(@u,f.getstring(i),'|');
    if u.count>3 then begin
      s:=u.getstring(1)+'|'+u.getstring(4);
      n:=fir.SearchString(s);
      if n>0 then fir1.edit(n,'1');
    end;
  end;
  f.clear;
  for i:=1 to fir.count do begin
    if fir1.getstring(i)='0' then begin
      f.add(fir.getstring(i));
    end;
  end;
  f.savetofile('C:\AF\MTA\29 \log042014.3');
  f.free; u.free; fir.free; fir1.free;
  showmessage('end!');
end;

procedure TForm1.Button17Click(Sender: TObject);
  var f,u,fir,fir1,fir2,f1,f2:AF_Types.TStrings;
  var i,n:integer;
  var s,s1:string;
begin
  f.create; u.create; fir.create; fir1.create; f1.create; f2.create; fir2.create;
  f.loadfromfile('C:\AF\MTA\29 \log042014.3');
  for i:=1 to f.count do begin
    ParseCSVStrEx(@u,f.getstring(i),'|');
    if u.count>0 then begin
     if fir.SearchString(u.getstring(1))<=0 then begin
      fir.add(u.getstring(1));
      fir1.add(f.getstring(i));
      fir2.add('0');
     end;
    end;
  end;
  f.clear;
  f.loadfromfile('C:\AF\MTA\29 \log042014.2');
  for i:=1 to f.count do begin
    ParseCSVStrEx(@u,f.getstring(i),'|');
    if u.count>0 then begin
      s:=u.getstring(1);
      n:=fir.SearchString(s);
      if n>0 then begin
        f1.add(s+' -> '+u.getstring(2)+'|'+u.getstring(3)+'|'+u.getstring(4));
        fir2.edit(n,'1');
      end
    end;
  end;
  for i:=1 to fir.count do begin
    if fir2.getstring(i)<>'1' then f2.add(fir1.getstring(i)+' -> NF');
  end;
  f1.savetofile('C:\AF\MTA\29 \log042014.4f');
  f2.savetofile('C:\AF\MTA\29 \log042014.4nf');
  f.free; u.free; fir.free; fir1.free; f1.free; f2.free; fir2.free;
  showmessage('end!');
end;


procedure TForm1.Button18Click(Sender: TObject);
  var tf:TextFile;
  var s,s0,s1,s1a,s2,rnum,rmun,rtit,rint:string;
  var i,n,m,x,rcount,rindex,k:integer;
  var f,p1,p2,ri,rn,rt,rz,log,u,u1,u2,l3:AF_Types.TStrings;
  var tfs:TFormatSettings;
  var dt1,dt2:TDateTime;
begin
 tfs.ShortDateFormat:='dd-mm-yyyy';
 tfs.LongDateFormat:='dd-mm-yyyy';
 tfs.DateSeparator:='-';
 p1.create; p2.create; log.create; ri.create; rn.create; rt.create; rz.create;  u.create; u1.create; u2.create; l3.create; f.create;
 AssignFile(tf,'C:\AF\MTA\29 \schedule.xml');
 Reset(tf);
 p1.clear;
 p2.clear;
  while not eof(tf) do begin
    ReadLn(tf,s);
    if pos('<route ',s)>0 then begin
       rint:=getParam('internal_number',s);
       rtit:=getParam('route_title',s);
       rnum:=getParam('route_number',s);
       if p1.SearchString(rint)<=0 then begin
         p1.add(rint);
         p2.add(''+rnum+' '+rtit);
       end;
    end;
  end;
 CloseFile(tf);
 f.loadfromfile('C:\AF\MTA\29 \log042014.4ff');
 for i:=1 to f.count do begin
   ParseCSVStrEx(@u,f.getstring(i),'|');
   if u.count>1 then begin
     n:=p1.SearchString(u.getstring(1));
     if n>=0 then ri.add(p2.getstring(n)+' ( '+u.getstring(1)+') - '+u.getstring(5))
             else ri.add(u.getstring(1)+' - '+u.getstring(5));
   end;
 end;
 f.clear;
 f.loadfromfile('C:\AF\MTA\29 \log042014.4nf');
 for i:=1 to f.count do begin
   ParseCSVStrEx(@u,f.getstring(i),'|');
   if u.count>1 then begin
     n:=p1.SearchString(u.getstring(1));
     if n>=0 then ri.add(p2.getstring(n)+' ( '+u.getstring(1)+') -  ')
             else ri.add(u.getstring(1)+' -  ');
   end;
 end;


 ri.savetofile('C:\AF\MTA\29 \log042014.5');
 p1.free; p2.free; log.free; ri.free; rn.free; rt.free; rz.free; u.free; u1.free; u2.create; l3.free; f.free;
 SHOWMESSAGE('END');
end;

procedure TForm1.Button22Click(Sender: TObject);
  var f,u,n1:AF_Types.TStrings;
  var i,n:integer;
begin
  f.create; u.create; n1.create;
  f.loadfromfile('C:\AF\MTA\4 \mtainternalnumberblacklists.csv');
   for i:=1 to f.count do begin
     ParseCSVStrEx(@u,f.getstring(i),';');
     if u.count>1 then begin
      if strtointe(u.getstring(2))<>0 then n1.add(u.getstring(2));
     end;
   end;
  f.clear;
  f.loadfromfile('C:\AF\MTA\4 \etalon0.txt');
   for i:=1 to f.count do begin
     ParseCSVStrEx(@u,f.getstring(i),#9);
     if u.count>2 then begin
      n:=n1.SearchString(u.getstring(3));
      if n>0 then begin
        f.edit(i,f.getstring(i)+#9+'BLACKLISTED');
      end;
     end;
   end;
  f.savetofile('C:\AF\MTA\4 \etalon1.txt');
  showmessage('end!');
  f.free; u.free; n1.free;
end;

procedure TForm1.Button20Click(Sender: TObject);
  var f:TextFile;
  var s,s0,s1,s1a,s2,rnum,rmun,rtit,rint,vdir:string;
  var i,n,m,x,rcount,rindex,k:integer;
  var p1,p2,ri,rn,rt,rz,log,u,u1,u2,l3,et,er,et1:AF_Types.TStrings;
  var tfs:TFormatSettings;
  var dt1,dt2:TDateTime;
begin
vdir:='C:\AF\MTA';
if selectdirectory(' :','',vdir) then begin
 vdir:=deleteslasheex(vdir)+'\';
 tfs.ShortDateFormat:='dd-mm-yyyy';
 tfs.LongDateFormat:='dd-mm-yyyy';
 tfs.DateSeparator:='-';
 p1.create; p2.create; log.create; ri.create; rn.create; rt.create; rz.create;  u.create; u1.create; u2.create; l3.create; et.create; er.create; et1.create;
 AssignFile(f,vdir+'schedule.xml');
 Reset(f);
  while not eof(f) do begin
    ReadLn(f,s);
    if pos('<route ',s)>0 then begin
      p1.clear;
      p2.clear;
      rtit:=getParam('route_title',s);
      rmun:=getParam('mun_obr',s);
      rnum:=getParam('route_number',s);
      rint:=getParam('internal_number',s);
      if er.SearchString(rint)<=0 then er.add(rint);
      rindex:=ri.SearchString(rint);
      if rindex<=0 then rindex:=0
                   else begin
                     ParseCSVStrEx(@u,rz.getstring(rindex),';');
                     for i:=1 to u.count do begin
                       ParseCSVStrEx(@u1,u.getstring(i),'@');
                       p1.add(u1.getstring(1));
                       p2.add(u1.getstring(2));
                     end;
                   end;
    end;
    if pos('<reis ',s)>0 then begin
     if getParam('days_of_week',s)<>'-------' then begin
       s1:=getParam('period_start',s);
       s2:=getParam('period_end',s);
       s0:=s1+'|'+s2+'|'+getParam('days_of_week',s);
       x:=p1.SearchString(s0);
       if x>0 then begin
        m:=strtointe(p2.getstring(x));
        p2.edit(x,inttostr(m+1));
       end
        else begin
          p1.add(s0);
          p2.add('1');
        end;
     end;
    end;
    if pos('</route',s)>0 then begin
      if rindex>0 then begin
        s0:='';
        if p1.count>0 then begin
          for i:=1 to p1.count do begin
            s0:=s0+p1.getstring(i)+'@'+p2.getstring(i)+';';
          end;
          if length(s0)>1 then s0:=copy(s0,1,length(s0)-1);
        end;
        rz.edit(rindex,s0);
      end
       else begin
        s0:='';
        if p1.count>0 then begin
          for i:=1 to p1.count do begin
            s0:=s0+p1.getstring(i)+'@'+p2.getstring(i)+';';
          end;
          if length(s0)>1 then s0:=copy(s0,1,length(s0)-1);
        end;
        ri.add(rint);
        rn.add(rnum);
        rt.add(rtit);
        rz.add(s0);
       end;
    end;
  end;
 CloseFile(f);

 AssignFile(f,vdir+'etalon.txt');
 Reset(f);
  while not eof(f) do begin
    ReadLn(f,s);
    ParseCSVStrEx(@u,s,#9);
    if u.count>2 then begin
      if strtointe(u.getstring(3))<>0 then begin
        et.add(u.getstring(3));
        et1.add(u.getstring(1)+' '+u.getstring(2));
      end;
    end;
  end;
 CloseFile(f);

 if et.count>0 then begin
   for i:=1 to et.count do begin
    if er.SearchString(et.getstring(i))<=0 then log.add('    '+et.getstring(i)+' ('+et1.getstring(i)+')');
   end;
 end;
{
 if ri.count>0 then begin
   for i:=1 to ri.count do begin
     s:=rn.getstring(i)+#9+rt.getstring(i)+#9+ri.getstring(i)+#9+#9+#9;
                     ParseCSVStrEx(@u,rz.getstring(i),';');
                     s1:='N';
                     s2:='N';
                     s1a:='';
                     l3.clear;
                     for n:=1 to u.count do begin
                       ParseCSVStrEx(@u1,u.getstring(n),'@');
                       l3.add(#9#9+ri.getstring(i)+#9+u1.getstring(1)+#9+u1.getstring(2));
                       ParseCSVStrEx(@u2,u1.getstring(1),'|');
                       dt1:=StrToDate(u2.getstring(1),tfs);
                       dt2:=StrToDate(u2.getstring(2),tfs);
                       if ((dt1<=41815)and(dt2>=41815)) then s1:='Y';   // 41680 - 10 
                       if ((dt1<=41845)and(dt2>=41845)) then s2:='Y';   // 41743 - 14 
                     end;
                     log.add(s+s1+s2+s1a);
                     if l3.count>0 then begin
                      for k:=1 to l3.count do log.add(l3.getstring(k)+#9+s1+s2+s1a);
                     end;
//                     log.include(l3);
   end;
 end;
}

 log.savetofile(vdir+'comparelog.12');
 p1.free; p2.free; log.free; ri.free; rn.free; rt.free; rz.free; u.free; u1.free; u2.create; l3.free; et.free; er.free; et1.free;
 SHOWMESSAGE('END');
end;
end;


procedure TForm1.Button19Click(Sender: TObject);
  var f:TextFile;
  var s,s0,s1,s1a,s2,rnum,rmun,rtit,rint,vdir,yy:string;
  var i,n,m,x,rcount,rindex,k,yyy:integer;
  var p1,p2,ri,rn,rt,rz,log,u,u1,u2,l3,et,er,et1:AF_Types.TStrings;
  var tfs:TFormatSettings;
  var dt1,dt2:TDateTime;
begin
vdir:='C:\AF\MTA';
if selectdirectory(' :','',vdir) then begin
 vdir:=deleteslasheex(vdir)+'\';
 tfs.ShortDateFormat:='dd-mm-yyyy';
 tfs.LongDateFormat:='dd-mm-yyyy';
 tfs.DateSeparator:='-';
 p1.create; p2.create; log.create; ri.create; rn.create; rt.create; rz.create;  u.create; u1.create; u2.create; l3.create; et.create; er.create; et1.create;
 AssignFile(f,vdir+'schedule.xml');
 Reset(f);
  while not eof(f) do begin
    ReadLn(f,s);
    if pos('<route ',s)>0 then begin
      rtit:=getParam('route_title',s);
      rmun:=getParam('mun_obr',s);
      rnum:=getParam('route_number',s);
      rint:=getParam('internal_number',s);
      p2.clear;
    end;
    if pos('<reis ',s)>0 then begin
     if getParam('days_of_week',s)<>'-------' then begin
       s1:=getParam('period_start',s);
       s2:=getParam('period_end',s);
       dt1:=StrToDate(s1,tfs);
       yy:=FormatDateTime('yyyy',dt1);
       yyy:=strtointe(yy);
       if yyy>2014 then begin
        if p2.SearchString(yy)<=0 then begin
          p2.add(yy);
          p1.add(rnum+#9+rtit+#9+rint+#9+s1);
        end;
       end;
     end;
    end;
  end;
 CloseFile(f);

 p1.savetofile(vdir+'log2015.12');
 p1.free; p2.free; log.free; ri.free; rn.free; rt.free; rz.free; u.free; u1.free; u2.create; l3.free; et.free; er.free; et1.free;
 SHOWMESSAGE('END');
end;
end;

procedure TForm1.Button23Click(Sender: TObject);
  var f,f2:TextFile;
  var s,s0,s1,s1a,s2,rnum,rmun,rtit,rint,vdir,yy:string;
  var i,n,m,x,rcount,rindex,k,yyy:integer;
  var p1,p2,ri,rn,rt,rz,log,u,u1,u2,l3,et,er,et1:AF_Types.TStrings;
  var tfs:TFormatSettings;
  var dt1,dt2:TDateTime;
  var rf:boolean;
begin
vdir:='C:\AF\MTA';
if selectdirectory(' :','',vdir) then begin
 vdir:=deleteslasheex(vdir)+'\';
 p1.create; p2.create; log.create; ri.create; rn.create; rt.create; rz.create;  u.create; u1.create; u2.create; l3.create; et.create; er.create; et1.create;
 AssignFile(f,vdir+'schedule.xml');
 Reset(f);
 AssignFile(f2,vdir+'schedule_new3.xml');
 Rewrite(f2);
 rf:=false;
 p1.clear;
  while not eof(f) do begin
    ReadLn(f,s);
    if pos('<route ',s)>0 then begin
      rf:=true;
      p1.clear;
    end;
    if not rf then writeln(f2,s)
              else p1.add(s);
    if pos('</route',s)>0 then begin
      if p1.count>2 then begin
        for i:=1 to p1.count do WriteLn(f2,p1.getstring(i));
      end;
      p1.clear;
      rf:=false;
    end;
  end;
 CloseFile(f);
 CloseFile(f2);
 p1.free; p2.free; log.free; ri.free; rn.free; rt.free; rz.free; u.free; u1.free; u2.create; l3.free; et.free; er.free; et1.free;
 SHOWMESSAGE('END');
end;
end;

procedure TForm1.Button21Click(Sender: TObject);
 var f,f1,xl:AF_Types.TSTrings;
 var s,s1,s2:string;
 var i:integer;
begin
  f.create; f1.create; xl.create;
  if opendialog2.execute then begin
  f.loadfromfile(opendialog2.FileName);   //    
   if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<route ',s)>0 then begin
        s1:=getParam('internal_number',s);
        s2:=trim(getParam('internal_number',s))+#9+trim(getParam('route_number',s)+#9+trim(getParam('route_title',s)));
        if validstr(s1) then begin
          if xl.SearchString(s1)<=0 then begin
            xl.add(s1);
            f1.add(s2);
          end;
        end;
      end;
    end;
   end;
   f1.savetofile(OpenDialog2.FileName+'.tsv');
   showmessage('end!');
  end;
  f.free; f1.free; xl.free;
end;

procedure TForm1.Button24Click(Sender: TObject);
  var f,f1,u:AF_Types.TStrings;
  var i,n:integer;
  var s:string;
begin
  f.create; f1.create; u.create;
  f.loadfromfile('C:\AF\MTA\6 \lost.txt');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('|',s)>0 then begin
        ParseCSVStrEx(@u,s,'|');
        f1.add('<stop stop_name="'+u.getstring(2)+'" stop_code="'+u.getstring(1)+'" stop_city="-" '+u.getstring(3)+' />');
      end;
    end;
  end;
  f1.add('');
  f1.savetofile('C:\AF\MTA\6 \st1.txt');
  f.free; f1.free; u.free;
  showmessage('end!');
end;

procedure TForm1.Button25Click(Sender: TObject);
  var f,f1,f2,xl,xt,u,bl:AF_Types.TStrings;
  var i,n:integer;
  var s,s1,s2,s3:string;
  var m:boolean;
  const folder:string='C:\AF\MTA\19 \';
begin
 f.create; f1.create; f2.create; u.create; xl.create; xt.create; bl.create;
 f.loadfromfile(folder+'\forcopy.txt');
 if f.count>0 then begin
   for i:=1 to f.count do begin
     if ValidStr(f.getstring(i)) then bl.add(f.getstring(i));
   end;
 end;
 cleanblank(folder+'schedule.xml');
  m:=false;
  f.clear;
  f.loadfromfile(folder+'schedule.xml');   //    
   if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<route ',s)>0 then begin
        s1:=getParam('internal_number',s);
        s2:=trim(getParam('route_number',s))+' '+trim(getParam('route_title',s)+'  ('+trim(getParam('internal_number',s))+')');
        if validstr(s1) then begin
           if bl.SearchString(s1)>0 then begin
            m:=true;
            if xt.SearchString(s2)<=0 then xt.add(s2);  //         -   m      
           end;
        end;
      end;
      if m then f1.add(s);  //   m  -     
      if pos('</route>',s)>0 then m:=false;
    end;
    m:=false;
      f1.savetofile(folder+'copy_schedule.xml');
      xt.savetofile(folder+'copylog.txt');
      showmessage('end! '+inttostr(xt.count));
   end;
 f.free; f1.free; f2.free; u.free; xl.free; xt.free; bl.free;
end;

procedure TForm1.Button26Click(Sender: TObject);
//  const folder:string='C:\AF\MTA\31 \';
  var f,f1,stlist:AF_Types.TStrings;
  var s,s1,folder:string;
  var i,n,p2:integer;
  var p1:double;
begin
  if opendialog2.execute then begin
  folder:=deleteslasheex(ExtractDirPath(OpenDialog2.FileName))+'\';
  f.create; f1.create; stlist.create;
  f.loadfromfile(folder+'stops.xml');
  if f.count>0 then begin
    p2:=f.count;
    for i:=1 to f.count do begin
      if (i mod 100) = 0 then begin
        p1:=i/p2;
        StatusBar1.SimpleText:=' 1: '+inttostr(round(p1*100))+'%';
        Application.ProcessMessages;
      end;
      s:=f.getstring(i);
      if pos('<stop ',s)>0 then begin
        s1:=getParam('stop_code',s);
        n:=stlist.SearchString(s1);
        if n<=0 then stlist.add(s1)
                else ShowMessage('   '+s1+'   stops!');
      end;
    end;
  end;
  f.clear;
  f.loadfromfile(folder+'schedule.xml');
  if f.count>0 then begin
    p2:=f.count;
    for i:=1 to f.count do begin
      if (i mod 100) = 0 then begin
        p1:=i/p2;
        StatusBar1.SimpleText:=' 2: '+inttostr(round(p1*100))+'%';
        Application.ProcessMessages;
      end;
      s:=f.getstring(i);
      if pos('<reis_point ',s)>0 then begin
        s1:=getParam('stop_code',s);
        n:=stlist.SearchString(s1);
        if n<=0 then begin
          if f1.SearchString(s1)<=0 then f1.add(s1);
        end;
      end;
    end;
  end;
  f1.add('');
  f1.savetofile(folder+'lost.txt');
  f.free; f1.free; stlist.free;
  showmessage('end!');
  end;
end;

end.
