unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls, AF_Proc, AF_Types, WinInet, MySQL6, MySQLClasses6, DateUtils,
  ComCtrls, ExtCtrls, Spin, uLkJSON, Buttons;

type
  TForm1 = class(TForm)
    Button1: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    StringGrid1: TStringGrid;
    StringGrid2: TStringGrid;
    Label1: TLabel;
    Timer1: TTimer;
    CheckBox1: TCheckBox;
    TabSheet3: TTabSheet;
    StringGrid3: TStringGrid;
    SpinEdit1: TSpinEdit;
    Label2: TLabel;
    CheckBox2: TCheckBox;
    Label3: TLabel;
    SpinEdit2: TSpinEdit;
    TabSheet4: TTabSheet;
    Button2: TButton;
    StringGrid4: TStringGrid;
    Label4: TLabel;
    Button3: TButton;
    SaveDialog1: TSaveDialog;
    SpeedButton1: TSpeedButton;
    SaveDialog2: TSaveDialog;
    CheckBox3: TCheckBox;
    Label5: TLabel;
    procedure FormResize(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure StringGrid1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure StringGrid2MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormDestroy(Sender: TObject);
    procedure StringGrid2DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure StringGrid2DblClick(Sender: TObject);
    procedure StringGrid1DblClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure StringGrid3DblClick(Sender: TObject);
    procedure StringGrid3DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure StringGrid3MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SpinEdit1Change(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure StringGrid4MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure StringGrid4DblClick(Sender: TObject);
    procedure StringGrid4DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure Button3Click(Sender: TObject);
    procedure StringGrid1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure TabSheet1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure PageControl1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SpeedButton1Click(Sender: TObject);
    procedure StringGrid3KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure StringGrid1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure StringGrid2KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure StringGrid4KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ActivateHintNOW(x,y: Integer; hinttxt:string);
  end;

var
  Form1: TForm1;
  workdir,cfg_mysql_host, cfg_mysql_port, cfg_mysql_database, cfg_mysql_user, cfg_mysql_password, cfg_forecast_file, _intrndfn, _oldtt, _ccppkd: string;
  cfg_moscow_tz,SG1C,SG1R,_oldcppk:integer;
  _st1,_st2,_fc1,_fc2,_fc3,_fc4,_fc5:AF_Types.TStrings;
  tid,tdel,tnum,tmar,tst,tstc,tt1,tt2,tt1a,tt2a,tstnc,tstec,ccppk,xlog:AF_Types.TStrings;
  hintwnd:THintWindow;
  maineflg,_parsecppk:boolean;

//procedure ReloadForecastFile;
procedure ReloadForecastFile2;
Function GetInetFileStr (const fileURL: String):widestring;
function getCtrl:boolean;

implementation

uses Unit2, Unit3, Unit4;

var Thread2:TThread2;

{$R *.dfm}

procedure TForm1.ActivateHintNOW(x,y: Integer; hinttxt:string);
var rect:TRect;
begin
  if hintTxt <> '' then
  begin
    rect := hintWnd.CalcHintRect( Screen.Width, hinttxt, nil);
    rect.Left := rect.Left + x;
    rect.Right := rect.Right + x;
    rect.Top := rect.Top + y;
    rect.Bottom := rect.Bottom + y;
    hintWnd.ActivateHint( rect, hinttxt);
  end;
end;


Function GetInetFileStr (const fileURL: String):widestring;
const BufferSize = 1024;
var
  hSession, hURL: HInternet;
  Buffer: array[1..BufferSize] of Byte;
  BufferLen: DWORD;
  sAppName: String;
  outbuf: WideString;
  l:integer;
begin
  outbuf:='';
  sAppName := ExtractFileName(Application.ExeName);
  hSession :=InternetOpen(PChar(sAppName), INTERNET_OPEN_TYPE_PRECONFIG, nil, nil, 0);
  try
    hURL := InternetOpenURL(hSession, PChar(fileURL), nil, 0, INTERNET_FLAG_RELOAD, 0);
    try
      repeat
      try
        bufferlen:=0;
        InternetReadFile(hURL, @Buffer, SizeOf(Buffer), BufferLen);
      except
      end;
        if bufferlen>0 then begin
          try
           for l:=1 to bufferlen do outbuf:=outbuf+chr(buffer[l]);
          except
          end;
        end;
      until BufferLen = 0;
    finally
      InternetCloseHandle(hURL)
    end
  finally
    InternetCloseHandle(hSession)
  end;
  result:=outbuf;
end;

procedure ClearSG1(sg:TStringGrid);
  var i,n:integer;
begin
 for i:=0 to sg.ColCount-1 do
  for n:=0 to sg.RowCount-1 do sg.Cells[i,n]:='';
 sg.RowCount:=2;
 sg.cells[0,0]:='id';
 sg.cells[1,0]:='idv';
 sg.cells[2,0]:='st1c';
 sg.cells[3,0]:='st2c';
 sg.cells[4,0]:='';
 sg.cells[5,0]:='.';
 sg.cells[6,0]:='.';
 sg.cells[7,0]:='st0c';
 sg.cells[8,0]:='';
 sg.cells[9,0]:='  .';
 sg.cells[10,0]:=' .';
 sg.cells[11,0]:='';
 sg.cells[12,0]:='';
 sg.cells[13,0]:='';
 sg.cells[14,0]:='';
 sg.cells[15,0]:='';
 sg.cells[16,0]:='';
end;

procedure ClearSG2(sg:TStringGrid);
  var i,n:integer;
begin
 for i:=0 to sg.ColCount-1 do
  for n:=0 to sg.RowCount-1 do sg.Cells[i,n]:='';
 sg.RowCount:=2;
 sg.cells[0,0]:='id';
 sg.cells[1,0]:='';
 sg.cells[2,0]:='';
 sg.cells[3,0]:='';
 sg.cells[4,0]:=' ';
 sg.cells[5,0]:='';
 sg.cells[6,0]:='';
 sg.cells[7,0]:='';
end;

procedure ClearSG4(sg:TStringGrid);
  var i,n:integer;
begin
 for i:=0 to sg.ColCount-1 do
  for n:=0 to sg.RowCount-1 do sg.Cells[i,n]:='';
 sg.RowCount:=2;
 sg.cells[0,0]:=' ';
 sg.cells[1,0]:='';
 sg.cells[2,0]:='';
 sg.cells[3,0]:='';
 sg.cells[4,0]:='';
 sg.cells[5,0]:='  ';
end;

procedure ClearSG1_f2(sg:TStringGrid);
  var i,n:integer;
begin
 for i:=0 to sg.ColCount-1 do
  for n:=0 to sg.RowCount-1 do sg.Cells[i,n]:='';
 sg.RowCount:=2;
 sg.cells[0,0]:='';
 sg.cells[1,0]:='';
 sg.cells[2,0]:='';
 sg.cells[3,0]:='';
 sg.cells[4,0]:=' ';
 sg.cells[5,0]:=' ';
 sg.cells[6,0]:=' ';
 sg.cells[7,0]:=' ';
end;


function LoadMainIni:boolean;
  var chg:AF_Types.TStrings;
  var i:integer;
  var s,s1,s2,s3,s4:string;
  var res:boolean;
begin
  chg.create;
  chg.loadfromfile(workdir+'main.ini');
  if chg.count>0 then begin
    for i:=1 to chg.count do begin
      s:=trim(chg.getstring(i));
      s:=strreplace(s,#9,#32);
      if length(s)>0 then begin
        if not (s[1]=';') then begin
          if pos(' ',s)>0 then begin
            s1:=trim(copy(s,1,pos(' ',s)-1));
            s2:=trim(copy(s,pos(' ',s)+1,length(s)-pos(' ',s)));
            s1:=ansilowercase(s1);
            if s1='mysql_host' then begin
              cfg_mysql_host:=s2
            end;
            if s1='mysql_port' then begin
              cfg_mysql_port:=s2;
            end;
            if s1='mysql_database' then begin
              cfg_mysql_database:=s2;
            end;
            if s1='mysql_user' then begin
              cfg_mysql_user:=s2;
            end;
            if s1='forecast_file' then begin
              cfg_forecast_file:=s2;
            end;
            if s1='moscow_timezone_offset' then begin
              cfg_moscow_tz:=strtointe(s2);
            end;
            if s1='cppk' then begin
              if s2='1' then _parsecppk:=true
                        else _parsecppk:=false;
            end;
          end;
        end;
      end;
    end;
  end;
  chg.clear;
  chg.loadfromfile(workdir+'main.pwd');
  if chg.count>0 then begin
    for i:=1 to chg.count do begin
      s:=trim(chg.getstring(i));
      s:=strreplace(s,#9,#32);
      if length(s)>0 then begin
        if not (s[1]=';') then begin
          if pos(' ',s)>0 then begin
            s1:=trim(copy(s,1,pos(' ',s)-1));
            s2:=trim(copy(s,pos(' ',s)+1,length(s)-pos(' ',s)));
            s1:=ansilowercase(s1);
            if s1='mysql_password' then begin
              cfg_mysql_password:=s2;
            end;
          end;
        end;
      end;
    end;
  end;
  chg.free;
  res:=true;
  result:=res;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  PageControl1.Width:=form1.ClientWidth-22;
  PageControl1.Height:=form1.ClientHeight-44;
  TabSheet1.Width:=form1.ClientWidth-30;
  TabSheet2.Width:=form1.ClientWidth-30;
  TabSheet3.Width:=form1.ClientWidth-30;
  TabSheet1.Height:=form1.ClientHeight-72;
  TabSheet2.Height:=form1.ClientHeight-72;
  TabSheet3.Height:=form1.ClientHeight-72;
  StringGrid1.Width:=form1.ClientWidth-50;
  StringGrid1.Height:=form1.ClientHeight-88;
  StringGrid2.Width:=form1.ClientWidth-50;
  StringGrid2.Height:=form1.ClientHeight-88;
  StringGrid3.Width:=form1.ClientWidth-50;
  StringGrid3.Height:=form1.ClientHeight-117;
  StringGrid4.Width:=form1.ClientWidth-50;
  StringGrid4.Height:=form1.ClientHeight-117;
  label1.Left:=form1.ClientWidth-13-label1.Width;
  button2.Top:=form1.ClientHeight-101;
  button2.Left:=form1.ClientWidth-211;
  button3.Top:=form1.ClientHeight-101;
  button3.Left:=form1.ClientWidth-211;
end;

procedure ShowMySQLError(MySQL:IMySQL);
begin
 if not maineflg then begin
  maineflg:=true;
  ShowMessage(Format(' #%d - %s', [MySQL.ErrorCode, MySQL.ErrorMessage]));
  maineflg:=false;
 end;
end;

procedure SgSort(aSg : TStringGrid; const aCol : Integer);
var
  SlSort, SlRow : TStringList;
  i, j : Integer;
begin
  SlSort := TStringList.Create;
  for i := aSg.FixedRows to aSg.RowCount - 1 do begin
    SlRow := TStringList.Create;
    SlRow.Assign(aSg.Rows[i]);
    SlSort.AddObject(aSg.Cells[aCol, i], SlRow);
  end;
  SlSort.Sort;
  j := 0;
  for i := aSg.FixedRows to aSg.RowCount - 1 do begin
    SlRow := SlSort.Objects[j] as TStringList;
    aSg.Rows[i].Assign(SlRow);
    SlRow.Free;
    Inc(j);
  end;
  SlSort.Free;
end;

function GetSTN(s:string):string;
 var n:integer;
begin
 s:=trim(s);
 result:='???';
 n:=_st1.SearchString(s);
 if n>0 then result:=_st2.getstring(n);
end;

function GetSTN2(s:string):string;
 var n:integer;
begin
 s:=trim(s);
 result:='???';
 n:=_st1.SearchString(s);
 if n>0 then result:=_st2.getstring(n)
        else result:='??? '+s;
end;

(*
procedure ReloadAll;
  var MySQL: IMySQL;
  var query_result: IMySQLQuery;
  var q1,lz,pr,ot,ss,rs,dts,dts1,dts2,delstr,tmlast:string;
  var i,n,m,delta:integer;
  var dt,dt1,dt2:TDateTime;
  var tfs:TFormatSettings;
begin
with form1 do begin
  tid.clear; tdel.clear; tnum.clear; tmar.clear; tst.clear; tstc.clear; tt1.clear; tt2.clear; tt1a.clear; tt2a.clear; tstnc.clear; tstec.clear;
  clearsg1(StringGrid1);
  clearsg2(StringGrid2);
  tfs.DateSeparator:='-';
  tfs.TimeSeparator:=':';
  tfs.longdateformat:='yyyy-mm-dd';
  tfs.shortdateformat:='yyyy-mm-dd';
  tfs.LongTimeFormat:='hh:nn:ss';
  tfs.shortTimeFormat:='hh:nn:ss';
  dt:=date+time-0.125;
  dts:=FormatDateTime('yyyy-mm-dd hh:nn:ss',dt);
//  showmessage(dts);
  MySQL := TMySQL.Create;
  MySQL.Host := cfg_mysql_host;
  MySQL.Port := strtointe(cfg_mysql_port);
  MySQL.User := cfg_mysql_user;
  MySQL.Password := cfg_mysql_password;
  if not MySQL.Connect then ShowMySQLError(MySQL)
   else begin
    MySQL.Database := cfg_mysql_database;
    MySQL.Query('set character_set_client=''utf8'';');
    MySQL.Query('set character_set_results=''utf8'';');
    MySQL.Query('set collation_connection=''utf8_bin'';');
    q1:='SELECT * from `rzd_buffer_lvgd01_tr2proc_feed_mysql` WHERE TIMEOPER_F>'+#39+dts+#39+' ORDER BY TIMEOPER_F DESC';
    query_result:= MySQL.Query(q1);
     if query_result = nil then ShowMySQLError(MySQL)
                           else begin
                             n:=1;
                             while query_result.FetchRow do begin
                               if n>=stringgrid1.RowCount then stringgrid1.RowCount:=n+1;
                               stringgrid1.Cells[0,n]:=query_result.ValueByName['id'];
                               stringgrid1.Cells[1,n]:=query_result.ValueByName['ID_TRAIN'];
                               stringgrid1.Cells[2,n]:=query_result.ValueByName['STORASP'];
                               stringgrid1.Cells[3,n]:=query_result.ValueByName['STNRASP'];
                               stringgrid1.Cells[4,n]:=utf8toansi(query_result.ValueByName['NOMPEX']);
                               stringgrid1.Cells[5,n]:=utf8toansi(query_result.ValueByName['NAMESTO']);
                               stringgrid1.Cells[6,n]:=utf8toansi(query_result.ValueByName['NAMESTN']);
                               stringgrid1.Cells[7,n]:=query_result.ValueByName['STOPER'];
                               stringgrid1.Cells[8,n]:=utf8toansi(query_result.ValueByName['STNAME']);
                               stringgrid1.Cells[9,n]:=query_result.ValueByName['TIMEOPER_N'];
                               stringgrid1.Cells[10,n]:=query_result.ValueByName['TIMEOPER_F'];
                               dts1:=query_result.ValueByName['TIMEOPER_N'];
                               dts2:=query_result.ValueByName['TIMEOPER_F'];
                               dt1:=StrToDateTime(dts1,tfs);
                               dt2:=StrToDateTime(dts2,tfs)+encodetime(0,0,0,10);
                               delta:=MinutesBetween(dt2,dt1);
                               if dt2>=dt1 then begin
                                                  stringgrid1.Cells[11,n]:=inttostr(delta);
                                                  stringgrid1.Cells[12,n]:='N';
                                                  if delta>9 then stringgrid1.Cells[12,n]:='F';
                                                end
                                           else begin
                                                  stringgrid1.Cells[11,n]:='-'+inttostr(delta);
                                                  stringgrid1.Cells[12,n]:='N';
                                                end;
                               inc(n);
                             end;
                             tmlast:='';
                             for i:=1 to stringgrid1.rowcount-1 do begin
                               if stringgrid1.Cells[10,i]>tmlast then tmlast:=stringgrid1.Cells[10,i];
                               if strtointe(stringgrid1.Cells[11,i])>9 then begin
                                 n:=tid.SearchString(stringgrid1.Cells[1,i]);
                                 if n<=0 then begin
                                   tid.add(stringgrid1.Cells[1,i]);
                                   tdel.add(stringgrid1.Cells[11,i]);
                                   tnum.add(stringgrid1.Cells[4,i]);
                                   tmar.add(GetSTN(stringgrid1.Cells[2,i])+' - '+getstn(stringgrid1.Cells[3,i]));
                                   tstnc.add(stringgrid1.Cells[2,i]);
                                   tstec.add(stringgrid1.Cells[3,i]);
                                   tst.add('');
                                   tstc.add('');
                                   tt1.add('');
                                   tt2.add('');
                                   tt1a.add('');
                                   tt2a.add('');
                                 end;
                               end;
                             end;
                             if tid.count>0 then begin
                              for i:=1 to tid.count do begin
                                for m:=1 to stringgrid1.rowcount-1 do begin
                                  if StringGrid1.Cells[1,m]=tid.getstring(i) then begin
                                    if StringGrid1.Cells[10,m]>tt2.getstring(i) then begin
                                      tst.edit(i,getstn(StringGrid1.Cells[7,m]));
                                      tstc.edit(i,StringGrid1.Cells[7,m]);
                                      tt1.edit(i,StringGrid1.Cells[9,m]);
                                      tt2.edit(i,StringGrid1.Cells[10,m]);
                                      tt1a.edit(i,copy(StringGrid1.Cells[9,m],12,5));
                                      tt2a.edit(i,copy(StringGrid1.Cells[10,m],12,5));
                                    end;
                                  end;
                                end;
                              end;
                              for i:=1 to tid.count do begin
                               dt1:=StrToDateTime(tt1.getstring(i),tfs);
                               dt2:=StrToDateTime(tt2.getstring(i),tfs)+encodetime(0,0,0,10);
                               delta:=MinutesBetween(dt2,dt1);
                               if dt2>=dt1 then delstr:=''
                                           else delstr:='-';
                               if delta=0 then delstr:='';
                               tdel.edit(i,delstr+inttostr(delta));
                              end;

                              n:=1;
                              for i:=1 to tid.count do begin
                                if strtointe(tdel.getstring(i))>9 then begin
                                  if n>=stringgrid2.RowCount then stringgrid2.RowCount:=n+1;
                                  stringgrid2.Cells[0,n]:=tid.getstring(i);
                                  stringgrid2.Cells[1,n]:=tnum.getstring(i);
                                  stringgrid2.Cells[2,n]:=tmar.getstring(i);
                                  stringgrid2.Cells[3,n]:=tst.getstring(i);
                                  stringgrid2.Cells[4,n]:=tt1a.getstring(i);
                                  stringgrid2.Cells[5,n]:=tt2a.getstring(i);
                                  stringgrid2.Cells[6,n]:=tdel.getstring(i);
                                  if tstc.getstring(i)=tstec.getstring(i) then begin
                                    stringgrid2.Cells[7,n]:='FX';
                                  end
                                   else begin
                                    stringgrid2.Cells[7,n]:='F';
                                   end;
                                  inc(n);
                                end;
                              end;
                              SgSort(StringGrid2,5);
                             end;
                           end;
   MySQL.Disconnect;
   end;
  label1.caption:='  '+FormatDateTime('hh:nn',date+time)+',    '+copy(tmlast,12,5);
  label1.Left:=form1.ClientWidth-13-label1.Width;
end;
end;
*)

procedure ReloadAll(start:boolean);
  var MySQL: IMySQL;
  var query_result: IMySQLQuery;
  var q1,lz,pr,ot,ss,rs,dts,dts1,dts2,delstr,tmlast,s9:string;
  var i,n,m,delta,n1,oldtid,vtid,s9i,h8,m8,h9,m9,h4:integer;
  var dt,dt1,dt2:TDateTime;
  var dtd:Extended;
  var tfs:TFormatSettings;
  var ts:AF_Types.TStrings;
begin
with form1 do begin
  ts.create;
  if not start then form1.font.Color:=clWindowText;
  if not start then form1.Enabled:=false;
  if not start then stringgrid1.enabled:=false;
  if not start then stringgrid2.enabled:=false;
  if not start then stringgrid3.enabled:=false;
  if not start then stringgrid1.visible:=false;
  if not start then stringgrid2.visible:=false;
  if not start then stringgrid3.visible:=false;
  if not start then form3.show;
  Application.ProcessMessages;
  tid.clear; tdel.clear; tnum.clear; tmar.clear; tst.clear; tstc.clear; tt1.clear; tt2.clear; tt1a.clear; tt2a.clear; tstnc.clear; tstec.clear;
  clearsg1(StringGrid1);
  clearsg2(StringGrid2);
  clearsg2(StringGrid3);
  tfs.DateSeparator:='-';
  tfs.TimeSeparator:=':';
  tfs.longdateformat:='yyyy-mm-dd';
  tfs.shortdateformat:='yyyy-mm-dd';
  tfs.LongTimeFormat:='hh:nn:ss';
  tfs.shortTimeFormat:='hh:nn:ss';
  dtd:=24/SpinEdit2.Value;
  dtd:=1/dtd;
  dt:=date+time-dtd;
  dts:=FormatDateTime('yyyy-mm-dd hh:nn:ss',dt);
//  showmessage(dts);
  MySQL := TMySQL.Create;
  MySQL.Host := cfg_mysql_host;
  MySQL.Port := strtointe(cfg_mysql_port);
  MySQL.User := cfg_mysql_user;
  MySQL.Password := cfg_mysql_password;
  if not MySQL.Connect then begin
     ShowMySQLError(MySQL);
     Exit;
   end  
   else begin
    MySQL.Database := cfg_mysql_database;
    MySQL.Query('set character_set_client=''utf8'';');
    MySQL.Query('set character_set_results=''utf8'';');
    MySQL.Query('set collation_connection=''utf8_bin'';');
    q1:='SELECT * from `rzd_buffer_lvgd01_tr2proc_feed_mysql` WHERE TIMEOPER_F>'+#39+dts+#39+' ORDER BY ID_TRAIN,NOMRP,KODOP,PRIORITY';
//    InputQuery('','',q1);
//    q1:='SELECT * from `rzd_buffer_lvgd01_tr2proc_feed_mysql` WHERE TIMEOPER_F<'+#39+'2017-06-17 00:00:00'+#39+' AND TIMEOPER_F>'+#39+'2017-06-16 00:00:00'+#39+' ORDER BY ID_TRAIN,NOMRP,KODOP,PRIORITY';
    query_result:= MySQL.Query(q1);
     if query_result = nil then begin
                              ShowMySQLError(MySQL);
                              Exit;
                           end
                           else begin
                             n:=1;
//                             showmessage(inttostr(query_result.RecordCount));
                             while query_result.FetchRow do begin
                               Application.ProcessMessages;
                               if n>=stringgrid1.RowCount then stringgrid1.RowCount:=n+1;
                               stringgrid1.Cells[0,n]:=query_result.ValueByName['id'];
                               stringgrid1.Cells[1,n]:=query_result.ValueByName['ID_TRAIN'];
                               stringgrid1.Cells[2,n]:=query_result.ValueByName['STORASP'];
                               stringgrid1.Cells[3,n]:=query_result.ValueByName['STNRASP'];
                               stringgrid1.Cells[4,n]:=utf8toansi(query_result.ValueByName['NOMPEX']);
                               stringgrid1.Cells[5,n]:=utf8toansi(query_result.ValueByName['NAMESTO']);
                               stringgrid1.Cells[6,n]:=utf8toansi(query_result.ValueByName['NAMESTN']);
                               stringgrid1.Cells[7,n]:=query_result.ValueByName['STOPER'];
                               stringgrid1.Cells[8,n]:=utf8toansi(query_result.ValueByName['STNAME']);
                               stringgrid1.Cells[9,n]:=query_result.ValueByName['TIMEOPER_N'];
                               stringgrid1.Cells[10,n]:=query_result.ValueByName['TIMEOPER_F'];
                               stringgrid1.Cells[13,n]:=query_result.ValueByName['KODOP'];
                               stringgrid1.Cells[14,n]:=query_result.ValueByName['SOURCE'];
                               stringgrid1.Cells[15,n]:=query_result.ValueByName['PRIORITY_RATING'];
                               stringgrid1.Cells[16,n]:=query_result.ValueByName['PRIORITY'];
                               dts1:=query_result.ValueByName['TIMEOPER_N'];
                               dts2:=query_result.ValueByName['TIMEOPER_F'];
                               if dts1<>'' then dt1:=StrToDateTime(dts1,tfs);
                               if dts2<>'' then dt2:=StrToDateTime(dts2,tfs)+encodetime(0,0,0,10);
                               delta:=MinutesBetween(dt2,dt1);
                               if dt2>=dt1 then begin
                                                  stringgrid1.Cells[11,n]:=inttostr(delta);
                                                  stringgrid1.Cells[12,n]:='N';
                                                  if abs(delta)>spinedit1.Value then stringgrid1.Cells[12,n]:='F';
                                                end
                                           else begin
                                                  stringgrid1.Cells[11,n]:='-'+inttostr(delta);
                                                  stringgrid1.Cells[12,n]:='N';
                                                end;
                               inc(n);
                             end;
                             tmlast:='';
                             for i:=1 to stringgrid1.rowcount-1 do begin
                               if stringgrid1.Cells[10,i]>tmlast then tmlast:=stringgrid1.Cells[10,i];
//                               if strtointe(stringgrid1.Cells[11,i])>9 then begin
                                 application.ProcessMessages;
                                 n:=tid.SearchString(stringgrid1.Cells[1,i]);
                                 if n<=0 then begin
                                   tid.add(stringgrid1.Cells[1,i]);
                                   tdel.add(stringgrid1.Cells[11,i]);
                                   tnum.add(stringgrid1.Cells[4,i]);
                                   tmar.add(GetSTN(stringgrid1.Cells[2,i])+' - '+getstn(stringgrid1.Cells[3,i]));
                                   tstnc.add(stringgrid1.Cells[2,i]);
                                   tstec.add(stringgrid1.Cells[3,i]);
                                   tst.add('');
                                   tstc.add('');
                                   tt1.add('');
                                   tt2.add('');
                                   tt1a.add('');
                                   tt2a.add('');
                                 end
                                  else begin
//                                   tdel.edit(n,stringgrid1.Cells[11,i]);
//                                   tnum.edit(n,stringgrid1.Cells[4,i]);
//                                   tmar.edit(n,GetSTN(stringgrid1.Cells[2,i])+' - '+getstn(stringgrid1.Cells[3,i]));
//                                   tstnc.edit(n,stringgrid1.Cells[2,i]);
//                                   tstec.edit(n,stringgrid1.Cells[3,i]);
                                  end;
//                               end;
                             end;
                             if tid.count>0 then begin
                              for i:=1 to tid.count do begin
                                for m:=1 to stringgrid1.rowcount-1 do begin
                                  if StringGrid1.Cells[1,m]=tid.getstring(i) then begin
                                      tst.edit(i,getstn(StringGrid1.Cells[7,m]));
                                      tstc.edit(i,StringGrid1.Cells[7,m]);
                                      tt1.edit(i,StringGrid1.Cells[9,m]);
                                      tt2.edit(i,StringGrid1.Cells[10,m]);
                                      tt1a.edit(i,copy(StringGrid1.Cells[9,m],12,5));
                                      tt2a.edit(i,copy(StringGrid1.Cells[10,m],12,5));
                                  end;
                                end;
                              end;
                              for i:=1 to tid.count do begin
                               if tt1.getstring(i)<>'' then dt1:=StrToDateTime(tt1.getstring(i),tfs);
                               if tt2.getstring(i)<>'' then dt2:=StrToDateTime(tt2.getstring(i),tfs)+encodetime(0,0,0,10);
                               delta:=MinutesBetween(dt2,dt1);
                               if dt2>=dt1 then delstr:=''
                                           else delstr:='-';
                               if delta=0 then delstr:='';
                               tdel.edit(i,delstr+inttostr(delta));
                              end;

                              n:=1;
                              n1:=1;
                              for i:=1 to tid.count do begin
                                application.ProcessMessages;
                                if abs(strtointe(tdel.getstring(i)))>spinedit1.Value then begin
                                  if n>=stringgrid2.RowCount then stringgrid2.RowCount:=n+1;
                                  stringgrid2.Cells[0,n]:=tid.getstring(i);
                                  stringgrid2.Cells[1,n]:=tnum.getstring(i);
                                  stringgrid2.Cells[2,n]:=tmar.getstring(i);
                                  stringgrid2.Cells[3,n]:=tst.getstring(i);
                                  stringgrid2.Cells[4,n]:=tt1a.getstring(i);
                                  stringgrid2.Cells[5,n]:=tt2a.getstring(i);
                                  stringgrid2.Cells[6,n]:=tdel.getstring(i);
                                  if pos('',ansiuppercase(stringgrid2.Cells[1,n]))>0 then begin
                                    s9:=copy(stringgrid2.Cells[1,n],1,4);
                                    s9i:=strtointe(s9);
                                    if s9i>0 then begin
                                     if (s9i mod 2)>0 then stringgrid2.Cells[2,n]:=stringgrid2.Cells[2,n]+' (   )'
                                                      else stringgrid2.Cells[2,n]:=stringgrid2.Cells[2,n]+' (   )'
                                    end;
                                  end;
                                  if tstc.getstring(i)=tstec.getstring(i) then begin
                                    stringgrid2.Cells[7,n]:='FX';
                                  end
                                   else begin
                                    stringgrid2.Cells[7,n]:='F';
                                   end;
                                  inc(n);
                                end;
                                if n1>=stringgrid3.RowCount then stringgrid3.RowCount:=n1+1;
                                stringgrid3.Cells[0,n1]:=tid.getstring(i);
                                stringgrid3.Cells[1,n1]:=tnum.getstring(i);
                                stringgrid3.Cells[2,n1]:=tmar.getstring(i);
                                stringgrid3.Cells[3,n1]:=tst.getstring(i);
                                stringgrid3.Cells[4,n1]:=tt1a.getstring(i);
                                stringgrid3.Cells[5,n1]:=tt2a.getstring(i);
                                stringgrid3.Cells[6,n1]:=tdel.getstring(i);
                                  if pos('',ansiuppercase(stringgrid3.Cells[1,n1]))>0 then begin
                                    s9:=copy(stringgrid3.Cells[1,n1],1,4);
                                    s9i:=strtointe(s9);
                                    if s9i>0 then begin
                                     if (s9i mod 2)>0 then stringgrid3.Cells[2,n1]:=stringgrid3.Cells[2,n1]+' (   )'
                                                      else stringgrid3.Cells[2,n1]:=stringgrid3.Cells[2,n1]+' (   )'
                                    end;
                                  end;
                                if tstc.getstring(i)=tstec.getstring(i) then begin
                                  stringgrid3.Cells[7,n1]:='FX';
                                end
                                 else begin
                                  stringgrid3.Cells[7,n1]:='F';
                                 end;
                                inc(n1);
                              end;
                              SgSort(StringGrid2,5);
                              SgSort(StringGrid3,1);
                             end;
                           end;
   MySQL.Disconnect;
   end;
  reloadforecastfile2;
  tohm(FormatDateTime('hh:nn',date+time),h8,m8);
  tohm(copy(tmlast,12,5),h9,m9);
  for h4:=0 to 1440 do begin
    if h4>0 then inchm(h9,m9,1);
    if ((h9=h8)and(m9=m8)) then break;
  end;
  label1.caption:='  '+FormatDateTime('hh:nn',date+time)+',    '+copy(tmlast,12,5)+',  '+inttostr(h4);
  ts.loadfromfile(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\latelog.log');
  ts.add(FormatDateTime('yyyy-mm-dd hh:nn',date+time)+';'+inttostr(h4));
  ts.savetofile(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\latelog.log'); 
  label1.Left:=form1.ClientWidth-13-label1.Width;
  if not start then form3.close;
  if not start then stringgrid1.enabled:=true;
  if not start then stringgrid2.enabled:=true;
  if not start then stringgrid3.enabled:=true;
  if not start then stringgrid1.visible:=true;
  if not start then stringgrid2.visible:=true;
  if not start then stringgrid3.visible:=true;
  if not start then form1.Enabled:=true;
  if not start then form1.Repaint;
  TabSheet1.Caption:=' >'+inttostr(SpinEdit1.value)+'  ('+inttostr(stringgrid2.RowCount-1)+')';
  TabSheet2.Caption:='  '+inttostr(spinedit2.value)+' . ('+inttostr(stringgrid1.RowCount-1)+')';
  TabSheet3.Caption:='    '+inttostr(spinedit2.value)+' . ('+inttostr(stringgrid3.RowCount-1)+')';
  application.ProcessMessages;
  ts.free;
end;
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
 ReloadAll(false);
end;

procedure ParseCSVStrEx(ts:AF_Types.PStrings; s:widestring; c:char);
 var n:integer;
begin
  ts.clear;
  while pos(c,s)>0 do begin
    n:=pos(c,s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;

procedure TForm1.FormCreate(Sender: TObject);
 var f,u:AF_Types.TStrings;
 var i,r:integer;
begin
  _ccppkd:='0';
  _oldcppk:=0;
  maineflg:=false;
  _parsecppk:=false;
  hintwnd:= THintWindow.create(self);
  Application.ShowHint:=true;
  StringGrid1.ShowHint := True;
  _oldtt:='1312wsxsq';
  Randomize;
  r:=random(1000000);
  _intrndfn:=inttostr(r)+'_'+inttostr(GetWindowThreadProcessId(application.Handle));
  tid.create; tdel.create; tnum.create; tmar.create; tst.create; tstc.create; tt1.create; tt2.create; tt1a.create; tt2a.create; tstnc.create; tstec.create; ccppk.create; xlog.create;
  f.create; u.create;
  _st1.create; _st2.create;
  _fc1.create; _fc2.create; _fc3.create; _fc4.create; _fc5.create;
  cfg_moscow_tz:=3;
  workdir:=deleteslasheex(ExtractDirPath(Application.ExeName))+'\';
  LoadMainIni;
  f.loadfromfile(workdir+'stlist.csv');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      ParseCSVStrEx(@u,f.getstring(i),';');
      if u.count>1 then begin
       _st1.add(u.getstring(1));
       _st2.add(u.getstring(2));
      end;
    end;
  end;
  clearsg1(StringGrid1);
  clearsg2(StringGrid2);
  f.free; u.free;
  reloadall(true);
  Thread2:=TThread2.Create(true);
  Thread2.FreeOnTerminate:=true;
  Thread2.Priority:=tpLower;
  Thread2.Resume;
  if _parsecppk then label5.Caption:='+'
                else label5.Caption:='-'
end;

procedure TForm1.StringGrid1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
  var c,r:integer;
begin
  StringGrid1.MouseToCell(x,y,c,r);
  if r=0 then SgSort(StringGrid1,c);
end;

procedure TForm1.StringGrid2MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
  var c,r:integer;
begin
  StringGrid2.MouseToCell(x,y,c,r);
  if r=0 then SgSort(StringGrid2,c);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  xlog.savetofile(workdir+'cppk.log');
  _st1.free; _st2.free;
  _fc1.free; _fc2.free; _fc3.free; _fc4.free; _fc5.free;
  tid.free; tdel.free; tnum.free; tmar.free; tst.free; tstc.free; tt1.free; tt2.free; tt1a.free; tt2a.free; tstnc.free; tstec.free; ccppk.free; xlog.free;
  hintwnd.ReleaseHandle;
end;

procedure TForm1.StringGrid2DrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
  var clr:TColor;
  var fst:TFontStyles;
begin
      StringGrid2.Canvas.Font.Color := clBlack;
      if stringgrid2.cells[7,ARow]='FX' then StringGrid2.Canvas.Font.color := clSilver;
      StringGrid2.canvas.fillRect(Rect);
      clr:=StringGrid2.Canvas.Font.Color;
      fst:=StringGrid2.Canvas.Font.Style;
      case ACol of
        0: begin
            DrawText(StringGrid2.Canvas.Handle, PChar(StringGrid2.Cells[ACol,ARow]), Length(StringGrid2.Cells[ACol,ARow]), Rect, DT_LEFT);
           end;
        1: begin
            StringGrid2.Canvas.Font.Style:=[fsBold];
            DrawText(StringGrid2.Canvas.Handle, PChar(StringGrid2.Cells[ACol,ARow]), Length(StringGrid2.Cells[ACol,ARow]), Rect, DT_CENTER);
           end;
        2: begin
            DrawText(StringGrid2.Canvas.Handle, PChar(StringGrid2.Cells[ACol,ARow]), Length(StringGrid2.Cells[ACol,ARow]), Rect, DT_LEFT);
           end;
        3: begin
            StringGrid2.Canvas.Font.Style:=[fsBold];
            DrawText(StringGrid2.Canvas.Handle, PChar(StringGrid2.Cells[ACol,ARow]), Length(StringGrid2.Cells[ACol,ARow]), Rect, DT_LEFT);
           end;
        4: begin
            DrawText(StringGrid2.Canvas.Handle, PChar(StringGrid2.Cells[ACol,ARow]), Length(StringGrid2.Cells[ACol,ARow]), Rect, DT_CENTER);
           end;
        5: begin
            DrawText(StringGrid2.Canvas.Handle, PChar(StringGrid2.Cells[ACol,ARow]), Length(StringGrid2.Cells[ACol,ARow]), Rect, DT_CENTER);
           end;
        6: begin
            StringGrid2.Canvas.Font.Style:=[fsBold];
            DrawText(StringGrid2.Canvas.Handle, PChar(StringGrid2.Cells[ACol,ARow]), Length(StringGrid2.Cells[ACol,ARow]), Rect, DT_CENTER);
           end;
        7: begin
            DrawText(StringGrid2.Canvas.Handle, PChar(StringGrid2.Cells[ACol,ARow]), Length(StringGrid2.Cells[ACol,ARow]), Rect, DT_CENTER);
           end;
        else DrawText(StringGrid2.Canvas.Handle, PChar(StringGrid2.Cells[ACol,ARow]), Length(StringGrid2.Cells[ACol,ARow]), Rect, DT_LEFT);
      end;
      StringGrid2.Canvas.Font.Color:=clr;
      StringGrid2.Canvas.Font.Style:=fst;
end;

procedure LoadTrain(tid:string);
  var MySQL: IMySQL;
  var query_result: IMySQLQuery;
  var q1,lz,pr,ot,ss,rs,dts,dts1,dts2,delstr,s9:string;
  var i,n,m,delta:integer;
  var dt,dt1,dt2:TDateTime;
  var tfs:TFormatSettings;
  var nf:boolean;
begin
with form1 do begin
  clearsg1_f2(form2.StringGrid1);
  tfs.DateSeparator:='-';
  tfs.TimeSeparator:=':';
  tfs.longdateformat:='yyyy-mm-dd';
  tfs.shortdateformat:='yyyy-mm-dd';
  tfs.LongTimeFormat:='hh:nn:ss';
  tfs.shortTimeFormat:='hh:nn:ss';
  dt:=date+time-0.125;
  dts:=FormatDateTime('yyyy-mm-dd hh:nn:ss',dt);
//  showmessage(dts);
  MySQL := TMySQL.Create;
  MySQL.Host := cfg_mysql_host;
  MySQL.Port := strtointe(cfg_mysql_port);
  MySQL.User := cfg_mysql_user;
  MySQL.Password := cfg_mysql_password;
  if not MySQL.Connect then ShowMySQLError(MySQL)
   else begin
    MySQL.Database := cfg_mysql_database;
    MySQL.Query('set character_set_client=''utf8'';');
    MySQL.Query('set character_set_results=''utf8'';');
    MySQL.Query('set collation_connection=''utf8_bin'';');
 {
    s9:='';
    q1:='SHOW COLUMNS from `rzd_buffer_lvgd01_tr2proc_feed_mysql`';
    query_result:= MySQL.Query(q1);
     if query_result = nil then ShowMySQLError(MySQL)
                           else begin
                             while query_result.FetchRow do begin
                               s9:=s9+query_result.ValueByName['Field']+',';
                             end;
                             InputQuery('','',s9);
                           end;
  }
    q1:='SELECT * from `rzd_buffer_lvgd01_tr2proc_feed_mysql` WHERE ID_TRAIN='+tid+' ORDER BY NOMRP,KODOP,PRIORITY';
    query_result:= MySQL.Query(q1);
     if query_result = nil then ShowMySQLError(MySQL)
                           else begin
                             n:=1;
                             while query_result.FetchRow do begin
                               nf:=false;
                               m:=n;
                               for i:=1 to form2.stringgrid1.RowCount-1 do begin
                                if form2.stringgrid1.cells[0,i]=query_result.ValueByName['NOMRP'] then begin
                                  nf:=true;
                                  m:=i;
                                  break;
                                end;
                               end;
                               if nf=false then begin
                                if n>=form2.stringgrid1.RowCount then form2.stringgrid1.RowCount:=n+1;
                               end; 
                               dts1:=query_result.ValueByName['TIMEOPER_N'];
                               dts2:=query_result.ValueByName['TIMEOPER_F'];
                               dt1:=StrToDateTime(dts1,tfs);
                               dt2:=StrToDateTime(dts2,tfs)+encodetime(0,0,0,10);
                               delta:=MinutesBetween(dt2,dt1);
                               if dt2>=dt1 then delstr:=''
                                           else delstr:='-';
                               if delta=0 then delstr:='';
                               form2.stringgrid1.Cells[0,m]:=query_result.ValueByName['NOMRP'];
                               form2.stringgrid1.Cells[1,m]:=getstn2(query_result.ValueByName['STOPER']){+' '+copy(query_result.ValueByName['DATE'],12,5)};
                               if query_result.ValueByName['KODOP']='1' then begin
                                   form2.stringgrid1.Cells[2,m]:=copy(query_result.ValueByName['TIMEOPER_N'],12,5);
                                   form2.stringgrid1.Cells[4,m]:=copy(query_result.ValueByName['TIMEOPER_F'],12,5);
                                   form2.stringgrid1.Cells[6,m]:=delstr+inttostr(delta);
                               end
                                else begin
                                   form2.stringgrid1.Cells[3,m]:=copy(query_result.ValueByName['TIMEOPER_N'],12,5);
                                   form2.stringgrid1.Cells[5,m]:=copy(query_result.ValueByName['TIMEOPER_F'],12,5);
                                   form2.stringgrid1.Cells[7,m]:=delstr+inttostr(delta);
                                end;
                               if not nf then inc(n);
                             end;
                           end;
   MySQL.Disconnect;
   end;
end;
end;

procedure LoadTrainN(tid:string);
  var MySQL: IMySQL;
  var query_result: IMySQLQuery;
  var q1,lz,pr,ot,ss,rs,dts,dts1,dts2,delstr:string;
  var i,n,m,delta:integer;
  var dt,dt1,dt2:TDateTime;
  var tfs:TFormatSettings;
  var nf:boolean;
begin
with form1 do begin
  clearsg1_f2(form2.StringGrid1);
  tfs.DateSeparator:='-';
  tfs.TimeSeparator:=':';
  tfs.longdateformat:='yyyy-mm-dd';
  tfs.shortdateformat:='yyyy-mm-dd';
  tfs.LongTimeFormat:='hh:nn:ss';
  tfs.shortTimeFormat:='hh:nn:ss';
  dt:=date+time-0.125;
  dts:=FormatDateTime('yyyy-mm-dd hh:nn:ss',dt);
//  showmessage(dts);
  MySQL := TMySQL.Create;
  MySQL.Host := cfg_mysql_host;
  MySQL.Port := strtointe(cfg_mysql_port);
  MySQL.User := cfg_mysql_user;
  MySQL.Password := cfg_mysql_password;
  if not MySQL.Connect then ShowMySQLError(MySQL)
   else begin
    MySQL.Database := cfg_mysql_database;
    MySQL.Query('set character_set_client=''utf8'';');
    MySQL.Query('set character_set_results=''utf8'';');
    MySQL.Query('set collation_connection=''utf8_bin'';');
    q1:='SELECT * from `rzd_buffer_lvgd01_tr2proc_feed_mysql` WHERE ID_TRAIN='+tid+' ORDER BY NOMRP,KODOP,PRIORITY';
    query_result:= MySQL.Query(q1);
     if query_result = nil then ShowMySQLError(MySQL)
                           else begin
                             n:=1;
                             while query_result.FetchRow do begin
                               m:=n;
                                if n>=form2.stringgrid1.RowCount then form2.stringgrid1.RowCount:=n+1;
                               dts1:=query_result.ValueByName['TIMEOPER_N'];
                               dts2:=query_result.ValueByName['TIMEOPER_F'];
                               dt1:=StrToDateTime(dts1,tfs);
                               dt2:=StrToDateTime(dts2,tfs)+encodetime(0,0,0,10);
                               delta:=MinutesBetween(dt2,dt1);
                               if dt2>=dt1 then delstr:=''
                                           else delstr:='-';
                               if delta=0 then delstr:='';
                               form2.stringgrid1.Cells[0,m]:=query_result.ValueByName['NOMRP'];
                               form2.stringgrid1.Cells[1,m]:=getstn2(query_result.ValueByName['STOPER']);
                               if query_result.ValueByName['SOURCE']='1' then form2.stringgrid1.Cells[1,m]:=form2.stringgrid1.Cells[1,m]+' ( '+query_result.ValueByName['PRIORITY_RATING']+')';
                               if query_result.ValueByName['SOURCE']='2' then form2.stringgrid1.Cells[1,m]:=form2.stringgrid1.Cells[1,m]+' (  '+query_result.ValueByName['PRIORITY_RATING']+')';
                               if query_result.ValueByName['SOURCE']='3' then form2.stringgrid1.Cells[1,m]:=form2.stringgrid1.Cells[1,m]+' ( '+query_result.ValueByName['PRIORITY_RATING']+')';
                               if query_result.ValueByName['SOURCE']='4' then form2.stringgrid1.Cells[1,m]:=form2.stringgrid1.Cells[1,m]+' (  '+query_result.ValueByName['PRIORITY_RATING']+')';
                               if query_result.ValueByName['KODOP']='1' then begin
                                   form2.stringgrid1.Cells[2,m]:=copy(query_result.ValueByName['TIMEOPER_N'],12,5);
                                   form2.stringgrid1.Cells[4,m]:=copy(query_result.ValueByName['TIMEOPER_F'],12,5);
                                   form2.stringgrid1.Cells[6,m]:=delstr+inttostr(delta);
                               end
                                else begin
                                   form2.stringgrid1.Cells[3,m]:=copy(query_result.ValueByName['TIMEOPER_N'],12,5);
                                   form2.stringgrid1.Cells[5,m]:=copy(query_result.ValueByName['TIMEOPER_F'],12,5);
                                   form2.stringgrid1.Cells[7,m]:=delstr+inttostr(delta);
                                end;
                               inc(n);
                             end;
                           end;
   MySQL.Disconnect;
   end;
end;
end;


procedure TForm1.StringGrid2DblClick(Sender: TObject);
  var n:integer;
begin
  if stringgrid2.row>0 then begin
    form2.caption:=stringgrid2.cells[1,stringgrid2.Row]+' '+stringgrid2.cells[2,stringgrid2.Row];
    if checkbox1.Checked then LoadTrainN(stringgrid2.cells[0,stringgrid2.Row])
                         else LoadTrain(stringgrid2.cells[0,stringgrid2.Row]);
//    LoadTrain(stringgrid2.cells[0,stringgrid2.Row]);
    if stringgrid2.cells[7,stringgrid2.Row]<>'FX' then begin
      form2.StringGrid1.RowCount:=form2.StringGrid1.RowCount+2;
      n:=tid.SearchString(stringgrid2.cells[0,stringgrid2.Row]);
      form2.StringGrid1.Cells[1,form2.StringGrid1.RowCount-1]:=getstn2(tstec.getstring(n));
      form2.StringGrid1.cells[1,form2.StringGrid1.RowCount-2]:='...';
      form2.StringGrid1.cells[2,form2.StringGrid1.RowCount-1]:='...';
      form2.StringGrid1.cells[2,form2.StringGrid1.RowCount-2]:='...';
      form2.StringGrid1.cells[3,form2.StringGrid1.RowCount-1]:='...';
      form2.StringGrid1.cells[3,form2.StringGrid1.RowCount-2]:='...';
      form2.StringGrid1.cells[4,form2.StringGrid1.RowCount-1]:='...';
      form2.StringGrid1.cells[4,form2.StringGrid1.RowCount-2]:='...';
      form2.StringGrid1.cells[5,form2.StringGrid1.RowCount-1]:='...';
      form2.StringGrid1.cells[5,form2.StringGrid1.RowCount-2]:='...';
      form2.StringGrid1.cells[6,form2.StringGrid1.RowCount-1]:='...';
      form2.StringGrid1.cells[6,form2.StringGrid1.RowCount-2]:='...';
      form2.StringGrid1.cells[7,form2.StringGrid1.RowCount-1]:='...';
      form2.StringGrid1.cells[7,form2.StringGrid1.RowCount-2]:='...';
      form2.StringGrid1.cells[0,form2.StringGrid1.RowCount-1]:='...';
      form2.StringGrid1.cells[0,form2.StringGrid1.RowCount-2]:='...';
    end;
    form2.ShowModal;
  end;
end;

procedure TForm1.StringGrid1DblClick(Sender: TObject);
  var n:integer;
begin
  if stringgrid1.row>0 then begin
    form2.caption:=stringgrid1.cells[4,stringgrid1.Row]+' '+getstn(stringgrid1.cells[2,stringgrid1.Row])+' - '+getstn(stringgrid1.cells[3,stringgrid1.Row]);
    if checkbox1.Checked then LoadTrainN(stringgrid1.cells[1,stringgrid1.Row])
                         else LoadTrain(stringgrid1.cells[1,stringgrid1.Row]);
    form2.ShowModal;
  end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
 if checkbox2.Checked then ReloadAll(false);
end;

procedure TForm1.StringGrid3DblClick(Sender: TObject);
  var n:integer;
begin
  if stringgrid3.row>0 then begin
    form2.caption:=stringgrid3.cells[1,stringgrid3.Row]+' '+stringgrid3.cells[2,stringgrid3.Row];
    if checkbox1.Checked then LoadTrainN(stringgrid3.cells[0,stringgrid3.Row])
                         else LoadTrain(stringgrid3.cells[0,stringgrid3.Row]);
//    LoadTrain(stringgrid2.cells[0,stringgrid2.Row]);
    if stringgrid3.cells[7,stringgrid2.Row]<>'FX' then begin
      form2.StringGrid1.RowCount:=form2.StringGrid1.RowCount+2;
      n:=tid.SearchString(stringgrid3.cells[0,stringgrid3.Row]);
      form2.StringGrid1.Cells[1,form2.StringGrid1.RowCount-1]:=getstn(tstec.getstring(n));
      form2.StringGrid1.cells[1,form2.StringGrid1.RowCount-2]:='...';
      form2.StringGrid1.cells[2,form2.StringGrid1.RowCount-1]:='...';
      form2.StringGrid1.cells[2,form2.StringGrid1.RowCount-2]:='...';
      form2.StringGrid1.cells[3,form2.StringGrid1.RowCount-1]:='...';
      form2.StringGrid1.cells[3,form2.StringGrid1.RowCount-2]:='...';
      form2.StringGrid1.cells[4,form2.StringGrid1.RowCount-1]:='...';
      form2.StringGrid1.cells[4,form2.StringGrid1.RowCount-2]:='...';
      form2.StringGrid1.cells[5,form2.StringGrid1.RowCount-1]:='...';
      form2.StringGrid1.cells[5,form2.StringGrid1.RowCount-2]:='...';
      form2.StringGrid1.cells[6,form2.StringGrid1.RowCount-1]:='...';
      form2.StringGrid1.cells[6,form2.StringGrid1.RowCount-2]:='...';
      form2.StringGrid1.cells[7,form2.StringGrid1.RowCount-1]:='...';
      form2.StringGrid1.cells[7,form2.StringGrid1.RowCount-2]:='...';
      form2.StringGrid1.cells[0,form2.StringGrid1.RowCount-1]:='...';
      form2.StringGrid1.cells[0,form2.StringGrid1.RowCount-2]:='...';
    end;
    form2.ShowModal;
  end;
end;

procedure TForm1.StringGrid3DrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
  var clr:TColor;
  var fst:TFontStyles;
begin
      Stringgrid3.Canvas.Font.Color := clBlack;
      if stringgrid3.cells[7,ARow]='FX' then Stringgrid3.Canvas.Font.color := clSilver;
      Stringgrid3.canvas.fillRect(Rect);
      clr:=Stringgrid3.Canvas.Font.Color;
      fst:=Stringgrid3.Canvas.Font.Style;
      case ACol of
        0: begin
            DrawText(Stringgrid3.Canvas.Handle, PChar(Stringgrid3.Cells[ACol,ARow]), Length(Stringgrid3.Cells[ACol,ARow]), Rect, DT_LEFT);
           end;
        1: begin
            Stringgrid3.Canvas.Font.Style:=[fsBold];
            DrawText(Stringgrid3.Canvas.Handle, PChar(Stringgrid3.Cells[ACol,ARow]), Length(Stringgrid3.Cells[ACol,ARow]), Rect, DT_CENTER);
           end;
        2: begin
            DrawText(Stringgrid3.Canvas.Handle, PChar(Stringgrid3.Cells[ACol,ARow]), Length(Stringgrid3.Cells[ACol,ARow]), Rect, DT_LEFT);
           end;
        3: begin
            Stringgrid3.Canvas.Font.Style:=[fsBold];
            DrawText(Stringgrid3.Canvas.Handle, PChar(Stringgrid3.Cells[ACol,ARow]), Length(Stringgrid3.Cells[ACol,ARow]), Rect, DT_LEFT);
           end;
        4: begin
            DrawText(Stringgrid3.Canvas.Handle, PChar(Stringgrid3.Cells[ACol,ARow]), Length(Stringgrid3.Cells[ACol,ARow]), Rect, DT_CENTER);
           end;
        5: begin
            DrawText(Stringgrid3.Canvas.Handle, PChar(Stringgrid3.Cells[ACol,ARow]), Length(Stringgrid3.Cells[ACol,ARow]), Rect, DT_CENTER);
           end;
        6: begin
            Stringgrid3.Canvas.Font.Style:=[fsBold];
            DrawText(Stringgrid3.Canvas.Handle, PChar(Stringgrid3.Cells[ACol,ARow]), Length(Stringgrid3.Cells[ACol,ARow]), Rect, DT_CENTER);
           end;
        7: begin
            DrawText(Stringgrid3.Canvas.Handle, PChar(Stringgrid3.Cells[ACol,ARow]), Length(Stringgrid3.Cells[ACol,ARow]), Rect, DT_CENTER);
           end;
        else DrawText(Stringgrid3.Canvas.Handle, PChar(Stringgrid3.Cells[ACol,ARow]), Length(Stringgrid3.Cells[ACol,ARow]), Rect, DT_LEFT);
      end;
      Stringgrid3.Canvas.Font.Color:=clr;
      Stringgrid3.Canvas.Font.Style:=fst;
end;

procedure TForm1.StringGrid3MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
  var c,r:integer;
begin
  StringGrid3.MouseToCell(x,y,c,r);
  if r=0 then SgSort(StringGrid3,c);
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
  button1.font.Color:=clRed;
  button1.Repaint;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  if checkbox2.Checked=false then begin
   if messagedlg(' ?',mtConfirmation,[mbYes,mbNo],0)<>mrYes then begin
     checkbox2.checked:=true;
   end
    else begin
     checkbox3.checked:=false;
    end;
  end;
end;

procedure xhm(var h,m:integer);
  begin
    if m>59 then begin
      inc(h,(m div 60));
      m:=m mod 60;
    end;
    if h>23 then begin
     h:=h-24;
    end;
  end;

procedure inchm(var h,m:integer; t:integer);
  begin
    inc(m,t);
    xhm(h,m);
  end;

procedure tohm(s:string; var h,m:integer);
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    s:=strreplace(s,'-',':');
    if pos(':',s)>0 then begin
      h:=StrToIntE(copy(s,1,pos(':',s)-1));
      m:=StrToIntE(copy(s,pos(':',s)+1,100));
    end;
  end;

function prephm(s:string):string;
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    s:=strreplace(s,'-',':');
    result:=s;
  end;

function fromhm(h,m:integer):string;
  begin
    xhm(h,m);
    if h>9 then begin
             if m>9 then fromhm:=inttostr(h)+'.'+inttostr(m)
                    else fromhm:=inttostr(h)+'.0'+inttostr(m);
           end
           else begin
             if m>9 then fromhm:='0'+inttostr(h)+'.'+inttostr(m)
                    else fromhm:='0'+inttostr(h)+'.0'+inttostr(m);
           end;
  end;


function prepareTime1(s:string):string;
  var h,h1,m,m1:integer;
  var s1:string;
  var d,d1:integer;
begin
  s1:=copy(s,12,5);
  d:=strtointe(copy(s,21,2));
  if pos(':',s1)>0 then begin
   if d>cfg_moscow_tz then begin
    tohm(s1,h,m);
    d1:=d-cfg_moscow_tz;
    d1:=24-d1;
    inchm(h,m,d1*60);
    s1:=fromhm(h,m);
   end;
   if d<cfg_moscow_tz then begin
    tohm(s1,h,m);
    d1:=cfg_moscow_tz-d;
    inchm(h,m,d1*60);
    s1:=fromhm(h,m);
   end;
  end;
  result:=s1;
end;


procedure GetThreadParamYJ(url:string; var dep,arr:string);
 var js:TlkJSONobject;
 var s:widestring;
 var rc:integer;
begin
  dep:='';
  arr:='';
  s:=GetInetFileStr(url);
  js := TlkJSON.ParseText(s) as TlkJSONobject;
  if assigned(js) then begin
   rc:=js.Field['stations'].Count;
   if rc>0 then begin
     dep:=prepareTime1(vartostr(js.Field['stations'].Child[0].Field['departure_local'].Value));
     arr:=prepareTime1(vartostr(js.Field['stations'].Child[rc-1].Field['arrival_local'].Value));
   end;
  end;
end;

function TTpr2(s:string):string;
begin
  result:=copy(s,12,5);
end;
{
procedure ReloadForecastFile;
 var f,log:AF_Types.TStrings;
 var i,n,rc,sc,xfn:integer;
 var s,s1:widestring;
 var dep,arr,xfc,xfc1,dd,tt:string;
 var js:TlkJSONobject;
begin
with form1 do begin
 stringgrid4.Enabled:=false;
 stringgrid4.visible:=false;
 dd:=FormatDateTime('yyyy-mm-dd',date+time);
 tt:=FormatDateTime('hh:nn',date+time);
 if _oldtt<>dd  then begin
   _fc3.clear;
   _fc4.clear;
   _fc5.clear;
 end;
 _oldtt:=dd;
 _fc1.clear;
 _fc2.clear;
 ClearSG4(StringGrid4);
 sc:=0;
 f.create;
 log.create;
// f.loadfromfile('C:\1\13\current_events.json');
// s:=f.getstring(1);
 s:=GetInetFileStr(cfg_forecast_file);
 js := TlkJSON.ParseText(s) as TlkJSONobject;
 if assigned(js) then begin
   label4.caption:='   : '+vartostr(js.Field['last_rzd_event_time'].Value);
   rc:=js.Field['no_data'].Count;
   if rc>0 then begin
     for i:=0 to rc-1 do begin
       inc(sc);
       if sc>=stringgrid4.RowCount then stringgrid4.RowCount:=sc+1;
       s1:=vartostr(js.Field['no_data'].Child[i].Field['thread'].Field['export_url'].Value);
       GetThreadParamYJ(s1,dep,arr);
       StringGrid4.Cells[0,sc]:='   ';
       StringGrid4.Cells[1,sc]:=vartostr(js.Field['no_data'].Child[i].Field['thread'].Field['number'].Value);
       StringGrid4.Cells[2,sc]:=vartostr(js.Field['no_data'].Child[i].Field['thread'].Field['title'].Value);
       StringGrid4.Cells[3,sc]:=dep;
       StringGrid4.Cells[4,sc]:=arr;
       StringGrid4.Cells[5,sc]:='';
       _fc1.add(StringGrid4.Cells[0,sc]+';'+StringGrid4.Cells[1,sc]+';'+StringGrid4.Cells[2,sc]+';'+StringGrid4.Cells[3,sc]+';'+StringGrid4.Cells[4,sc]);
       _fc2.add(s1);
       xfc:=dd+';'+StringGrid4.Cells[0,sc]+';'+StringGrid4.Cells[1,sc]+';'+StringGrid4.Cells[2,sc]+';'+StringGrid4.Cells[3,sc]+';'+StringGrid4.Cells[4,sc]+';'+StringGrid4.Cells[5,sc];
       xfc1:=dd+';'+StringGrid4.Cells[0,sc]+';'+StringGrid4.Cells[1,sc]+';'+StringGrid4.Cells[2,sc];
       xfn:=_fc4.SearchString(xfc1);
       if xfn>0 then begin
                  _fc3.edit(xfn,xfc);
                  _fc5.edit(xfn,_fc5.getstring(xfn)+','+tt);
                end
                else begin
                 _fc3.add(xfc);
                 _fc4.add(xfc1);
                 _fc5.add(tt);
                end;
     end;
   end;
   rc:=js.Field['no_next_data'].Count;
   if rc>0 then begin
     for i:=0 to rc-1 do begin
       inc(sc);
       if sc>=stringgrid4.RowCount then stringgrid4.RowCount:=sc+1;
       s1:=vartostr(js.Field['no_next_data'].Child[i].Field['thread'].Field['export_url'].Value);
       GetThreadParamYJ(s1,dep,arr);
       StringGrid4.Cells[0,sc]:='  ';
       StringGrid4.Cells[1,sc]:=vartostr(js.Field['no_next_data'].Child[i].Field['thread'].Field['number'].Value);
       StringGrid4.Cells[2,sc]:=vartostr(js.Field['no_next_data'].Child[i].Field['thread'].Field['title'].Value);
       StringGrid4.Cells[3,sc]:=dep;
       StringGrid4.Cells[4,sc]:=arr;
       StringGrid4.Cells[5,sc]:=vartostr(js.Field['no_next_data'].Child[i].Field['station'].Field['title'].Value);
       _fc1.add(StringGrid4.Cells[0,sc]+';'+StringGrid4.Cells[1,sc]+';'+StringGrid4.Cells[2,sc]+';'+StringGrid4.Cells[3,sc]+';'+StringGrid4.Cells[4,sc]);
       _fc2.add(s1);
       xfc:=dd+';'+StringGrid4.Cells[0,sc]+';'+StringGrid4.Cells[1,sc]+';'+StringGrid4.Cells[2,sc]+';'+StringGrid4.Cells[3,sc]+';'+StringGrid4.Cells[4,sc]+';'+StringGrid4.Cells[5,sc];
       xfc1:=dd+';'+StringGrid4.Cells[0,sc]+';'+StringGrid4.Cells[1,sc]+';'+StringGrid4.Cells[2,sc];
       xfn:=_fc4.SearchString(xfc1);
       if xfn>0 then begin
                  _fc3.edit(xfn,xfc);
                  _fc5.edit(xfn,_fc5.getstring(xfn)+','+tt);
                end
                else begin
                 _fc3.add(xfc);
                 _fc4.add(xfc1);
                 _fc5.add(tt);
                end;
     end;
   end;
   rc:=js.Field['by_fact'].Count;
   if rc>0 then begin
     for i:=0 to rc-1 do begin
       inc(sc);
       if sc>=stringgrid4.RowCount then stringgrid4.RowCount:=sc+1;
       s1:=vartostr(js.Field['by_fact'].Child[i].Field['thread'].Field['export_url'].Value);
       GetThreadParamYJ(s1,dep,arr);
       StringGrid4.Cells[0,sc]:='';
       StringGrid4.Cells[1,sc]:=vartostr(js.Field['by_fact'].Child[i].Field['thread'].Field['number'].Value);
       StringGrid4.Cells[2,sc]:=vartostr(js.Field['by_fact'].Child[i].Field['thread'].Field['title'].Value);
       StringGrid4.Cells[3,sc]:=dep;
       StringGrid4.Cells[4,sc]:=arr;
       StringGrid4.Cells[5,sc]:=vartostr(js.Field['by_fact'].Child[i].Field['station'].Field['title'].Value);
       _fc1.add(StringGrid4.Cells[0,sc]+';'+StringGrid4.Cells[1,sc]+';'+StringGrid4.Cells[2,sc]+';'+StringGrid4.Cells[3,sc]+';'+StringGrid4.Cells[4,sc]);
       _fc2.add(s1);
     end;
   end;
 end;
 if _fc3.count>0 then begin
  for i:=1 to _fc3.count do begin
    log.add(_fc3.getstring(i)+';'+_fc5.getstring(i));
  end;
 end
  else log.add('');
 log.savetofile(workdir+dd+'_'+_intrndfn+'.log');
 log.free;
 f.free;
 stringgrid4.Enabled:=true;
 stringgrid4.visible:=true;
// showmessage('end!');
end;
end;
}

function extrst2(s:string):string;
 var i,l:integer;
begin
 result:=s;
 l:=length(s);
 if l>2 then begin
  for i:=l downto 1 do begin
   if s[i]=#32 then break;
  end;
  if i>1 then begin
    result:=trim(copy(s,1,i-1));
  end;
 end;
end;

procedure ReloadForecastFile2;
 var f,log,xlog:AF_Types.TStrings;
 var i,n,rc,sc,xfn,j2c,j:integer;
 var s,s1:widestring;
 var dep,arr,xfc,xfc1,dd,tt,jc,jn,jt:string;
 var js,js2:TlkJSONobject;
 var _dt1,_dt2:TDateTime;
begin
with form1 do begin
 stringgrid4.Enabled:=false;
 stringgrid4.visible:=false;
 dd:=FormatDateTime('yyyy-mm-dd',date+time);
 tt:=FormatDateTime('hh:nn',date+time);
 if dd<>_ccppkd then begin
   _ccppkd:=dd;
   ccppk.clear;
   _oldcppk:=0;
 end;
 if _oldtt<>dd  then begin
   _fc3.clear;
   _fc4.clear;
   _fc5.clear;
 end;
 _oldtt:=dd;
 _fc1.clear;
 _fc2.clear;
 ClearSG4(StringGrid4);
 sc:=0;
 f.create;
 log.create;

 if ccppk.count>0 then begin
   for j:=1 to ccppk.count do begin
     ParseCSVStrEx(@f,ccppk.getstring(j),#9);
     inc(sc);
     if sc>=stringgrid4.RowCount then stringgrid4.RowCount:=sc+1;
     StringGrid4.Cells[0,sc]:=' ';
     StringGrid4.Cells[1,sc]:=f.getstring(1);
     StringGrid4.Cells[2,sc]:=f.getstring(2);
   end;
 end;
 f.clear;
 s:='';
 s:=GetInetFileStr(cfg_forecast_file);
 js := TlkJSON.ParseText(s) as TlkJSONobject;
 if assigned(js) then begin
   if assigned(js.Field['last_rzd_event_time']) then label4.caption:='   : '+vartostr(js.Field['last_rzd_event_time'].Value);
   rc:=0;
   if assigned(js.Field['no_data']) then rc:=js.Field['no_data'].Count;
   if rc>0 then begin
     for i:=0 to rc-1 do begin
       inc(sc);
       if sc>=stringgrid4.RowCount then stringgrid4.RowCount:=sc+1;
       s1:=vartostr(js.Field['no_data'].Child[i].Field['thread'].Field['export_url'].Value);
//       GetThreadParamYJ(s1,dep,arr);
       StringGrid4.Cells[0,sc]:='   ';
       StringGrid4.Cells[1,sc]:=vartostr(js.Field['no_data'].Child[i].Field['thread'].Field['number'].Value);
       StringGrid4.Cells[2,sc]:=vartostr(js.Field['no_data'].Child[i].Field['thread'].Field['title'].Value);
       StringGrid4.Cells[3,sc]:=ttpr2(vartostr(js.Field['no_data'].Child[i].Field['thread'].Field['departure_dt'].Value));
       StringGrid4.Cells[4,sc]:=ttpr2(vartostr(js.Field['no_data'].Child[i].Field['thread'].Field['arrival_dt'].Value));
       StringGrid4.Cells[5,sc]:='';
       _fc1.add(StringGrid4.Cells[0,sc]+';'+StringGrid4.Cells[1,sc]+';'+StringGrid4.Cells[2,sc]+';'+StringGrid4.Cells[3,sc]+';'+StringGrid4.Cells[4,sc]);
       _fc2.add(s1);
       xfc:=dd+';'+StringGrid4.Cells[0,sc]+';'+StringGrid4.Cells[1,sc]+';'+StringGrid4.Cells[2,sc]+';'+StringGrid4.Cells[3,sc]+';'+StringGrid4.Cells[4,sc]+';'+StringGrid4.Cells[5,sc];
       xfc1:=dd+';'+StringGrid4.Cells[0,sc]+';'+StringGrid4.Cells[1,sc]+';'+StringGrid4.Cells[2,sc];
       xfn:=_fc4.SearchString(xfc1);
       if xfn>0 then begin
                  _fc3.edit(xfn,xfc);
                  _fc5.edit(xfn,_fc5.getstring(xfn)+','+tt);
                end
                else begin
                 _fc3.add(xfc);
                 _fc4.add(xfc1);
                 _fc5.add(tt);
                end;
     end;
   end;
   rc:=0;
   if assigned(js.Field['train_turnover']) then rc:=js.Field['train_turnover'].Count;
   if rc>0 then begin
     for i:=0 to rc-1 do begin
       inc(sc);
       if sc>=stringgrid4.RowCount then stringgrid4.RowCount:=sc+1;
       s1:=vartostr(js.Field['train_turnover'].Child[i].Field['thread'].Field['export_url'].Value);
//       GetThreadParamYJ(s1,dep,arr);
       StringGrid4.Cells[0,sc]:='   ';
       StringGrid4.Cells[1,sc]:=vartostr(js.Field['train_turnover'].Child[i].Field['thread'].Field['number'].Value);
       StringGrid4.Cells[2,sc]:=vartostr(js.Field['train_turnover'].Child[i].Field['thread'].Field['title'].Value);
       StringGrid4.Cells[3,sc]:=ttpr2(vartostr(js.Field['train_turnover'].Child[i].Field['thread'].Field['departure_dt'].Value));
       StringGrid4.Cells[4,sc]:=ttpr2(vartostr(js.Field['train_turnover'].Child[i].Field['thread'].Field['arrival_dt'].Value));
       StringGrid4.Cells[5,sc]:='';
       _fc1.add(StringGrid4.Cells[0,sc]+';'+StringGrid4.Cells[1,sc]+';'+StringGrid4.Cells[2,sc]+';'+StringGrid4.Cells[3,sc]+';'+StringGrid4.Cells[4,sc]);
       _fc2.add(s1);
       xfc:=dd+';'+StringGrid4.Cells[0,sc]+';'+StringGrid4.Cells[1,sc]+';'+StringGrid4.Cells[2,sc]+';'+StringGrid4.Cells[3,sc]+';'+StringGrid4.Cells[4,sc]+';'+StringGrid4.Cells[5,sc];
       xfc1:=dd+';'+StringGrid4.Cells[0,sc]+';'+StringGrid4.Cells[1,sc]+';'+StringGrid4.Cells[2,sc];
       xfn:=_fc4.SearchString(xfc1);
       if xfn>0 then begin
                  _fc3.edit(xfn,xfc);
                  _fc5.edit(xfn,_fc5.getstring(xfn)+','+tt);
                end
                else begin
                 _fc3.add(xfc);
                 _fc4.add(xfc1);
                 _fc5.add(tt);
                end;
     end;
   end;
   rc:=0;
   if assigned(js.Field['no_next_data']) then rc:=js.Field['no_next_data'].Count;
   if rc>0 then begin
     for i:=0 to rc-1 do begin
       inc(sc);
       if sc>=stringgrid4.RowCount then stringgrid4.RowCount:=sc+1;
       s1:=vartostr(js.Field['no_next_data'].Child[i].Field['thread'].Field['export_url'].Value);
//       GetThreadParamYJ(s1,dep,arr);
       StringGrid4.Cells[0,sc]:='  ';
       StringGrid4.Cells[1,sc]:=vartostr(js.Field['no_next_data'].Child[i].Field['thread'].Field['number'].Value);
       StringGrid4.Cells[2,sc]:=vartostr(js.Field['no_next_data'].Child[i].Field['thread'].Field['title'].Value);
       StringGrid4.Cells[3,sc]:=ttpr2(vartostr(js.Field['no_next_data'].Child[i].Field['thread'].Field['departure_dt'].Value));
       StringGrid4.Cells[4,sc]:=ttpr2(vartostr(js.Field['no_next_data'].Child[i].Field['thread'].Field['arrival_dt'].Value));
       StringGrid4.Cells[5,sc]:=' .'+extrst2(vartostr(js.Field['no_next_data'].Child[i].Field['trigger_station'].Value));
       _fc1.add(StringGrid4.Cells[0,sc]+';'+StringGrid4.Cells[1,sc]+';'+StringGrid4.Cells[2,sc]+';'+StringGrid4.Cells[3,sc]+';'+StringGrid4.Cells[4,sc]);
       _fc2.add(s1);
       xfc:=dd+';'+StringGrid4.Cells[0,sc]+';'+StringGrid4.Cells[1,sc]+';'+StringGrid4.Cells[2,sc]+';'+StringGrid4.Cells[3,sc]+';'+StringGrid4.Cells[4,sc]+';'+StringGrid4.Cells[5,sc];
       xfc1:=dd+';'+StringGrid4.Cells[0,sc]+';'+StringGrid4.Cells[1,sc]+';'+StringGrid4.Cells[2,sc];
       xfn:=_fc4.SearchString(xfc1);
       if xfn>0 then begin
                  _fc3.edit(xfn,xfc);
                  _fc5.edit(xfn,_fc5.getstring(xfn)+','+tt);
                end
                else begin
                 _fc3.add(xfc);
                 _fc4.add(xfc1);
                 _fc5.add(tt);
                end;
     end;
   end;
   rc:=0;
   if assigned(js.Field['by_fact']) then rc:=js.Field['by_fact'].Count;
   if rc>0 then begin
     for i:=0 to rc-1 do begin
       inc(sc);
       if sc>=stringgrid4.RowCount then stringgrid4.RowCount:=sc+1;
       s1:=vartostr(js.Field['by_fact'].Child[i].Field['thread'].Field['export_url'].Value);
//       GetThreadParamYJ(s1,dep,arr);
       StringGrid4.Cells[0,sc]:='';
       StringGrid4.Cells[1,sc]:=vartostr(js.Field['by_fact'].Child[i].Field['thread'].Field['number'].Value);
       StringGrid4.Cells[2,sc]:=vartostr(js.Field['by_fact'].Child[i].Field['thread'].Field['title'].Value);
       StringGrid4.Cells[3,sc]:=ttpr2(vartostr(js.Field['by_fact'].Child[i].Field['thread'].Field['departure_dt'].Value));
       StringGrid4.Cells[4,sc]:=ttpr2(vartostr(js.Field['by_fact'].Child[i].Field['thread'].Field['arrival_dt'].Value));
       StringGrid4.Cells[5,sc]:=extrst2(vartostr(js.Field['by_fact'].Child[i].Field['trigger_station'].Value));
       _fc1.add(StringGrid4.Cells[0,sc]+';'+StringGrid4.Cells[1,sc]+';'+StringGrid4.Cells[2,sc]+';'+StringGrid4.Cells[3,sc]+';'+StringGrid4.Cells[4,sc]);
       _fc2.add(s1);
     end;
   end;
 end;
 if _fc3.count>0 then begin
  for i:=1 to _fc3.count do begin
    log.add(_fc3.getstring(i)+';'+_fc5.getstring(i));
  end;
 end
  else log.add('');
 log.savetofile(workdir+dd+'_'+_intrndfn+'.log');
 log.free;
 f.free;
 stringgrid4.Enabled:=true;
 stringgrid4.visible:=true;
 if ccppk.count>_oldcppk then begin
   FlashWindow(Application.Handle, True);
   Application.ProcessMessages;
 end;
 _oldcppk:=ccppk.count;
// showmessage('end!');
end;
end;



procedure TForm1.Button2Click(Sender: TObject);
begin
  ReloadForecastFile2;
end;

procedure TForm1.StringGrid4MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
  var c,r:integer;
begin
  StringGrid4.MouseToCell(x,y,c,r);
  if r=0 then SgSort(StringGrid4,c);
end;

Function LoadYFCTrain(tr:integer):boolean;
 var i,n:integer;
 var js:TlkJSONobject;
 var s:widestring;
 var rc:integer;
 var mf1,mt1:string;
begin
result:=true;
with form1 do begin
  clearsg1_f2(form2.StringGrid1);
  n:=_fc1.SearchString(StringGrid4.Cells[0,tr]+';'+StringGrid4.Cells[1,tr]+';'+StringGrid4.Cells[2,tr]+';'+StringGrid4.Cells[3,tr]+';'+StringGrid4.Cells[4,tr]);
  if n>0 then begin
    s:=GetInetFileStr(_fc2.getstring(n));
    js := TlkJSON.ParseText(s) as TlkJSONobject;
    if assigned(js) then begin
     rc:=js.Field['stations'].Count;
     if rc>0 then begin
      form2.StringGrid1.RowCount:=rc+1;
      for i:=0 to rc-1 do begin
       form2.StringGrid1.Cells[0,i+1]:=inttostr(i+1);
       if assigned(js.Field['stations'].Child[i].Field['title']) then form2.StringGrid1.Cells[1,i+1]:=vartostr(js.Field['stations'].Child[i].Field['title'].Value);
       if assigned(js.Field['stations'].Child[i].Field['arrival_local']) then form2.StringGrid1.Cells[2,i+1]:=prepareTime1(vartostr(js.Field['stations'].Child[i].Field['arrival_local'].Value))
                                                                         else form2.StringGrid1.Cells[2,i+1]:='-----';
       if assigned(js.Field['stations'].Child[i].Field['departure_local']) then form2.StringGrid1.Cells[3,i+1]:=prepareTime1(vartostr(js.Field['stations'].Child[i].Field['departure_local'].Value))
                                                                           else form2.StringGrid1.Cells[3,i+1]:='-----';
          if assigned(js.Field['stations'].Child[i].Field['state']) then begin
            if assigned(js.Field['stations'].Child[i].Field['state'].Field['departure']) then begin
              if assigned(js.Field['stations'].Child[i].Field['state'].Field['departure'].Field['fact_time']) then begin
                form2.StringGrid1.Cells[5,i+1]:=prepareTime1(vartostr(js.Field['stations'].Child[i].Field['state'].Field['departure'].Field['fact_time'].Value));
              end;
              if assigned(js.Field['stations'].Child[i].Field['state'].Field['departure'].Field['type']) then begin
                if vartostr(js.Field['stations'].Child[i].Field['state'].Field['departure'].Field['type'].Value)='possible_delay' then begin
                                          form2.StringGrid1.Cells[7,i+1]:='PD';
                                          if assigned(js.Field['stations'].Child[i].Field['state'].Field['departure'].Field['minutes_from']) then begin
                                           if assigned(js.Field['stations'].Child[i].Field['state'].Field['departure'].Field['minutes_to']) then begin
                                             mf1:=vartostr(js.Field['stations'].Child[i].Field['state'].Field['departure'].Field['minutes_from'].Value);
                                             mt1:=vartostr(js.Field['stations'].Child[i].Field['state'].Field['departure'].Field['minutes_to'].Value);
                                             if mf1=mt1 then begin
                                                          {if mf1<>'null' then} form2.StringGrid1.Cells[5,i+1]:=mf1
                                                        end
                                                        else form2.StringGrid1.Cells[5,i+1]:=mf1+'..'+mt1;
                                           end;
                                          end;
                end;
                if vartostr(js.Field['stations'].Child[i].Field['state'].Field['departure'].Field['type'].Value)='possible_ok' then form2.StringGrid1.Cells[7,i+1]:='ok';
                if vartostr(js.Field['stations'].Child[i].Field['state'].Field['departure'].Field['type'].Value)='fact_interpolated' then begin
                                          form2.StringGrid1.Cells[7,i+1]:='I';
                                          mf1:=vartostr(js.Field['stations'].Child[i].Field['state'].Field['departure'].Field['minutes_from'].Value);
                                          mt1:=vartostr(js.Field['stations'].Child[i].Field['state'].Field['departure'].Field['minutes_to'].Value);
                                          if mf1=mt1 then form2.StringGrid1.Cells[5,i+1]:=mf1
                                                     else form2.StringGrid1.Cells[5,i+1]:=mf1+'..'+mt1;
                end;
              end;
            end;
            if assigned(js.Field['stations'].Child[i].Field['state'].Field['arrival']) then begin
              if assigned(js.Field['stations'].Child[i].Field['state'].Field['arrival'].Field['fact_time']) then begin
                form2.StringGrid1.Cells[4,i+1]:=prepareTime1(vartostr(js.Field['stations'].Child[i].Field['state'].Field['arrival'].Field['fact_time'].Value));
              end;
              if assigned(js.Field['stations'].Child[i].Field['state'].Field['arrival'].Field['type']) then begin
                if vartostr(js.Field['stations'].Child[i].Field['state'].Field['arrival'].Field['type'].Value)='possible_delay' then begin
                                          form2.StringGrid1.Cells[6,i+1]:='PD';
                                          if assigned(js.Field['stations'].Child[i].Field['state'].Field['arrival'].Field['minutes_from']) then begin
                                           if assigned(js.Field['stations'].Child[i].Field['state'].Field['arrival'].Field['minutes_to']) then begin
                                             mf1:=vartostr(js.Field['stations'].Child[i].Field['state'].Field['arrival'].Field['minutes_from'].Value);
                                             mt1:=vartostr(js.Field['stations'].Child[i].Field['state'].Field['arrival'].Field['minutes_to'].Value);
                                             if mf1=mt1 then begin
                                                          {if mf1<>'null' then} form2.StringGrid1.Cells[4,i+1]:=mf1
                                                        end
                                                        else form2.StringGrid1.Cells[4,i+1]:=mf1+'..'+mt1;
                                           end;
                                          end;
                end;
                if vartostr(js.Field['stations'].Child[i].Field['state'].Field['arrival'].Field['type'].Value)='possible_ok' then form2.StringGrid1.Cells[6,i+1]:='ok';
                if vartostr(js.Field['stations'].Child[i].Field['state'].Field['arrival'].Field['type'].Value)='fact_interpolated' then begin
                                          form2.StringGrid1.Cells[6,i+1]:='I';
                                          mf1:=vartostr(js.Field['stations'].Child[i].Field['state'].Field['arrival'].Field['minutes_from'].Value);
                                          mt1:=vartostr(js.Field['stations'].Child[i].Field['state'].Field['arrival'].Field['minutes_to'].Value);
                                          if mf1=mt1 then form2.StringGrid1.Cells[4,i+1]:=mf1
                                                     else form2.StringGrid1.Cells[4,i+1]:=mf1+'..'+mt1;
                end;
              end;
            end;
          end;
      end;
     end;
  end;

  end
   else begin
     ShowMessage('    !');
     result:=false;
   end;
end;
end;

procedure TForm1.StringGrid4DblClick(Sender: TObject);
begin
  if stringgrid4.row>0 then begin
    form2.caption:=stringgrid4.cells[1,stringgrid4.Row]+' '+stringgrid4.cells[2,stringgrid4.Row];
    if LoadYFCTrain(stringgrid4.Row) then form2.ShowModal;
  end;
end;

procedure TForm1.StringGrid4DrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
begin
StringGrid4.Canvas.Font.Color := clBlack;
if arow>0 then begin
 if stringgrid4.cells[0,ARow]=' ' then StringGrid4.Canvas.Brush.color := RGB(255,36,0);
 if stringgrid4.cells[0,ARow]='   ' then StringGrid4.Canvas.Brush.color := RGB(255,99,71);
 if stringgrid4.cells[0,ARow]='  ' then StringGrid4.Canvas.Brush.color := RGB(219,112,147);
 if stringgrid4.cells[0,ARow]='' then StringGrid4.Canvas.Brush.color := RGB(255,215,0);
 if stringgrid4.cells[0,ARow]='   ' then StringGrid4.Canvas.Brush.color := RGB(66,170,255);
end;
StringGrid4.canvas.fillRect(Rect);
StringGrid4.canvas.TextOut(Rect.Left,Rect.Top,StringGrid4.Cells[ACol,ARow]);
end;

procedure TForm1.Button3Click(Sender: TObject);
  var b3_n,b3_n1:integer;
  var b3_s,b3_s1:string;
  var b3_f:AF_Types.TStrings;
  var MySQL: IMySQL;
  var query_result: IMySQLQuery;
  var q1,lz,pr,ot,ss,rs,dts,dts1,dts2,delstr:string;
  var i,n,m,delta:integer;
  var dt,dt1,dt2:TDateTime;
  var tfs:TFormatSettings;
  var nf:boolean;
begin
  b3_f.create;
  tfs.DateSeparator:='-';
  tfs.TimeSeparator:=':';
  tfs.longdateformat:='yyyy-mm-dd';
  tfs.shortdateformat:='yyyy-mm-dd';
  tfs.LongTimeFormat:='hh:nn:ss';
  tfs.shortTimeFormat:='hh:nn:ss';
  dt:=date+time-0.125;
  dts:=FormatDateTime('yyyy-mm-dd hh:nn:ss',dt);
  MySQL := TMySQL.Create;
  MySQL.Host := cfg_mysql_host;
  MySQL.Port := strtointe(cfg_mysql_port);
  MySQL.User := cfg_mysql_user;
  MySQL.Password := cfg_mysql_password;
  if not MySQL.Connect then ShowMySQLError(MySQL)
  else begin
    MySQL.Database := cfg_mysql_database;
    MySQL.Query('set character_set_client=''utf8'';');
    MySQL.Query('set character_set_results=''utf8'';');
    MySQL.Query('set collation_connection=''utf8_bin'';');

  if SaveDialog1.execute then begin
   if stringgrid3.rowcount>1 then begin
    for b3_n:=1 to StringGrid3.RowCount-1 do begin
      b3_s:=ansilowercase(stringgrid3.cells[1,b3_n]);
      if pos('',b3_s)<=0 then begin
                clearsg1_f2(form2.StringGrid1);
                q1:='SELECT * from `rzd_buffer_lvgd01_tr2proc_feed_mysql` WHERE ID_TRAIN='+stringgrid3.cells[0,b3_n]+' ORDER BY NOMRP,KODOP,PRIORITY';
                query_result:= MySQL.Query(q1);
                 if query_result = nil then ShowMySQLError(MySQL)
                           else begin
                             n:=1;
                             while query_result.FetchRow do begin
                               m:=n;
                                if n>=form2.stringgrid1.RowCount then form2.stringgrid1.RowCount:=n+1;
                               dts1:=query_result.ValueByName['TIMEOPER_N'];
                               dts2:=query_result.ValueByName['TIMEOPER_F'];
                               dt1:=StrToDateTime(dts1,tfs);
                               dt2:=StrToDateTime(dts2,tfs)+encodetime(0,0,0,10);
                               delta:=MinutesBetween(dt2,dt1);
                               if dt2>=dt1 then delstr:=''
                                           else delstr:='-';
                               if delta=0 then delstr:='';
                               form2.stringgrid1.Cells[0,m]:=query_result.ValueByName['NOMRP'];
                               form2.stringgrid1.Cells[1,m]:=getstn2(query_result.ValueByName['STOPER']);
                               if query_result.ValueByName['KODOP']='1' then begin
                                   form2.stringgrid1.Cells[2,m]:=copy(query_result.ValueByName['TIMEOPER_N'],12,5);
                                   form2.stringgrid1.Cells[4,m]:=copy(query_result.ValueByName['TIMEOPER_F'],12,5);
                                   form2.stringgrid1.Cells[6,m]:=delstr+inttostr(delta);
                               end
                                else begin
                                   form2.stringgrid1.Cells[3,m]:=copy(query_result.ValueByName['TIMEOPER_N'],12,5);
                                   form2.stringgrid1.Cells[5,m]:=copy(query_result.ValueByName['TIMEOPER_F'],12,5);
                                   form2.stringgrid1.Cells[7,m]:=delstr+inttostr(delta);
                                end;
                               inc(n);
                             end;
                           end;
        b3_f.add(stringgrid3.cells[1,b3_n]+#9+stringgrid3.cells[2,b3_n]+#9+form2.stringgrid1.cells[0,1]+#9+form2.stringgrid1.cells[1,1]+#9+form2.stringgrid1.cells[3,1]+#9+form2.stringgrid1.cells[5,1]);
      end;
    end;
   end;
   b3_f.savetofile(savedialog1.FileName);
   showmessage('end!');
   MySQL.Disconnect;
  end;
  end;
  b3_f.free;
end;

procedure TForm1.StringGrid1MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
  var c,r:integer;
begin
  StringGrid1.MouseToCell(x,y,c,r);
    if c=0 then begin
      form1.ActivateHintNOW(form1.Left+stringgrid1.Left+x,form1.Top+stringgrid1.top+y,stringgrid1.cells[c,r]);
      stringgrid1.Hint:=StringGrid1.Cells[c,r];
    end
     else begin
       hintwnd.ReleaseHandle;
     end;
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
       hintwnd.ReleaseHandle;

end;

procedure TForm1.TabSheet1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
       hintwnd.ReleaseHandle;

end;

procedure TForm1.PageControl1MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
       hintwnd.ReleaseHandle;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
 var i,n:integer;
 var f:AF_Types.TStrings;
 var s:string;
begin
 if savedialog1.Execute then begin
  f.create;
  case PageControl1.ActivePageIndex of
    0: begin
         for i:=0 to stringgrid2.rowcount-1 do begin
          s:='';
          for n:=0 to stringgrid2.ColCount-1 do begin
            s:=s+stringgrid2.Cells[n,i]+#9;
          end;
          f.add(copy(s,1,length(s)-1));
         end;
       end;
    1: begin
         for i:=0 to stringgrid1.rowcount-1 do begin
          s:='';
          for n:=0 to stringgrid1.ColCount-1 do begin
            s:=s+stringgrid1.Cells[n,i]+#9;
          end;
          f.add(copy(s,1,length(s)-1));
         end;
       end;
    2: begin
         for i:=0 to stringgrid3.rowcount-1 do begin
          s:='';
          for n:=0 to stringgrid3.ColCount-1 do begin
            s:=s+stringgrid3.Cells[n,i]+#9;
          end;
          f.add(copy(s,1,length(s)-1));
         end;
       end;
    3: begin
         for i:=0 to stringgrid4.rowcount-1 do begin
          s:='';
          for n:=0 to stringgrid4.ColCount-1 do begin
            s:=s+stringgrid4.Cells[n,i]+#9;
          end;
          f.add(copy(s,1,length(s)-1));
         end;
       end;
  end;
  f.savetofile(savedialog1.FileName);
  f.free;
 end;
end;

function getCtrl:boolean;
 var KeyState : Word;
begin
  KeyState := GetKeyState(VK_CONTROL);
  if KeyState and $8000 = $8000 then result:=true
                                else result:=false;
end;

procedure TForm1.StringGrid3KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
  var ct:string;
  var flg:boolean;
  var z:integer;
begin
 if key=70 then begin
  if getCtrl then begin
    if InputQuery('   ',':',ct) then begin
     if validstr(ct) then begin
       if stringgrid3.RowCount>1 then begin
         flg:=false;
         ct:=ansiuppercase(ct);
         for z:=1 to stringgrid3.RowCount-1 do begin
           if pos(ct,stringgrid3.cells[1,z])>0 then begin flg:=true; break; end;
         end;
         if z<>stringgrid3.Row then begin
           if flg then stringgrid3.Row:=z;
         end;
       end;
     end;
    end;
  end;
 end;
end;

procedure TForm1.StringGrid1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
  var ct:string;
  var flg:boolean;
  var z:integer;
begin
 if key=70 then begin
  if getCtrl then begin
    if InputQuery('  ',':',ct) then begin
     if validstr(ct) then begin
       if stringgrid1.RowCount>1 then begin
         flg:=false;
         ct:=ansiuppercase(ct);
         for z:=1 to stringgrid1.RowCount-1 do begin
           if pos(ct,stringgrid1.cells[8,z])>0 then begin flg:=true; break; end;
         end;
         if z<>stringgrid1.Row then begin
           if flg then stringgrid1.Row:=z;
         end;
       end;
     end;
    end;
  end;
 end;
end;

procedure TForm1.StringGrid2KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
  var ct:string;
  var flg:boolean;
  var z:integer;
begin
 if key=70 then begin
  if getCtrl then begin
    if InputQuery('   ',':',ct) then begin
     if validstr(ct) then begin
       if stringgrid2.RowCount>1 then begin
         flg:=false;
         ct:=ansiuppercase(ct);
         for z:=1 to stringgrid2.RowCount-1 do begin
           if pos(ct,stringgrid2.cells[1,z])>0 then begin flg:=true; break; end;
         end;
         if z<>stringgrid2.Row then begin
           if flg then stringgrid2.Row:=z;
         end;
       end;
     end;
    end;
  end;
 end;
end;

procedure TForm1.StringGrid4KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
  var ct:string;
  var flg:boolean;
  var z:integer;
begin
 if key=70 then begin
  if getCtrl then begin
    if InputQuery('   ',':',ct) then begin
     if validstr(ct) then begin
       if stringgrid4.RowCount>1 then begin
         flg:=false;
         ct:=ansiuppercase(ct);
         for z:=1 to stringgrid4.RowCount-1 do begin
           if pos(ct,stringgrid4.cells[1,z])>0 then begin flg:=true; break; end;
         end;
         if z<>stringgrid4.Row then begin
           if flg then stringgrid4.Row:=z;
         end;
       end;
     end;
    end;
  end;
 end;
end;

end.
