unit Unit4;

interface

uses
  Classes, AF_Proc, AF_Types, uLkJSON, SysUtils;

type
  TThread2 = class(TThread)
  private
    { Private declarations }
  protected
    procedure Execute; override;
  end;

implementation

Uses Unit1;

{ Important: Methods and properties of objects in visual components can only be
  used in a method called using Synchronize, for example,

      Synchronize(UpdateCaption);

  and UpdateCaption could look like,

    procedure TThread2.UpdateCaption;
    begin
      Form1.Caption := 'Updated in a thread';
    end; }

{ TThread2 }

function _ParseCPPK(st1,st2,date:string):integer;
   var j,j2c,vr:integer;
   var s,jc,jn,jt:string;
   var f:AF_Types.TSTrings;
   var js2:TlkJSONobject;
begin
 vr:=0;
// f.loadfromfile('C:\1\35\date-travel.json');
// s:=f.getstring(1);
// s:=GetInetFileStr('https://api.mobile-kassa.ru/v1.7/train-schedule/date-travel?date=2018-09-26&fromStationId=2000015&toStationId=2000000');
 s:=GetInetFileStr('https://api.mobile-kassa.ru/v1.7/train-schedule/date-travel?date='+date+'&fromStationId='+st1+'&toStationId='+st2);
 f.create;
 js2 := TlkJSON.ParseText('{"data":'+s+'}') as TlkJSONobject;
 if assigned(js2) then begin
   j2c:=js2.Field['data'].Count;
   vr:=j2c;
   if j2c>0 then begin
     for j:=0 to j2c-1 do begin
       jc:=''; jn:=''; jt:='';
       if assigned(js2.Field['data'].Child[j].Field['canceled']) then begin
         if js2.Field['data'].Child[j].Field['canceled'].Value=true then begin
           jn:=js2.Field['data'].Child[j].Field['trainNumber'].Value;
           jt:=js2.Field['data'].Child[j].Field['startStationName'].Value+' - '+js2.Field['data'].Child[j].Field['finishStationName'].Value;
           jc:=jn+#9+jt;
           if ccppk.SearchString(jc)<=0 then ccppk.add(jc);
         end;
       end;
     end;
   end;
 end;
 js2.Free;
 f.free;
 result:=vr;
end;


procedure TThread2.Execute;
  var vdate:string;
  var vr:integer;
  var autodate:boolean;
begin
while true do begin
if unit1._parsecppk then begin
// vdate:='2018-09-26';
// autodate:=false;
 autodate:=true;

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2000015','2000002',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));
 sleep(80000);

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2000002','2000015',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));
 sleep(80000);

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2000001','2001150',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));
 sleep(1000);

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2001150','2000001',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));
 sleep(80000);

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2000003','2001000',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));
 sleep(1000);

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2001000','2000003',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));
 sleep(80000);

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2000005','2001050',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));
 sleep(1000);

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2001050','2000005',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));
 sleep(1000);

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2000225','2000285',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));
 sleep(1000);

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2000285','2000225',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));
 sleep(1000);

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2000007','2000315',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));
 sleep(80000);

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2000315','2000007',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));
 sleep(1000);

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2000006','2000155',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));
 sleep(1000);

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2000155','2000006',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));
 sleep(80000);

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2000075','2000460',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));
 sleep(1000);

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2000460','2000075',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));
 sleep(1000);

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2000009','2000115',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));
 sleep(1000);

 if autodate then vdate:=FormatDateTime('yyyy-mm-dd',date+time);
 if form1.checkbox3.checked then vr:=_ParseCPPK('2000115','2000009',vdate);
 xlog.add(FormatDateTime('yyyy-mm-dd hh:nn:ss',date+time)+';-'+';'+inttostr(vr));

 xlog.savetofile(workdir+'cppk.log');
 sleep(80000);
end;
end;
end;

end.
