unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, Buttons, ExtCtrls, AF_Types, ComCtrls,
  OleServer, ExcelXP, FileCtrl;

const
 pversion:string='12.0';

type
  TPTTMode = (mNormal,mAvia,mLate);
  TTimetable1 = packed record
    t1,t2,st,mfs:string[10];
  end;
  TForm1 = class(TForm)
    LabeledEdit1: TLabeledEdit;
    SpeedButton1: TSpeedButton;
    StringGrid1: TStringGrid;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    XLApp: TExcelApplication;
    ProgressBar1: TProgressBar;
    StatusBar1: TStatusBar;
    CheckBox1: TCheckBox;
    SpeedButton2: TSpeedButton;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  lh,lm,lmfs,_fccount:integer;
  log,ofile,_trnlist,f1list, career_n, career_i, career_t, expr_id,expr_type,expr_sub,expr_career,expr_tariff,_grname, _grps, _grpe, _listuid_u: AF_Types.TStrings;
  mtrain: string;
  _dt11,_dt1,_dt2:TDateTime;
  _errorflag:boolean;
  _stidf:string;
  socrmode:integer;

implementation

uses AF_Proc, unit2, Unit3, DateUtils;

{$R *.dfm}


function Prep0ESR(s:string):string;
begin
  s:=trim(s);
  if length(s)=4 then result:='00'+s
                 else result:=s;
end;



Function StrToIntE1(s:string):integer;
  var i,t:integer;
begin
   val(s,i,t);
   if t<>0 then begin
             StrToIntE1:=0;
             log.add('   '+mtrain+'.    : "'+s+'"');
             _errorflag:=true;
           end
           else StrToIntE1:=i;
end;

procedure xhm(var h,m:integer);
  begin
    if m>59 then begin
      inc(h,(m div 60));
      m:=m mod 60;
    end;
    if h>23 then begin
     h:=h-24;
    end;
  end;

procedure dechm(var h,m:integer; t:integer);
  begin
    if (m-t)<0 then begin
      m:=60+(m-t);
      dec(h);
        if h<0 then h:=23;
    end
      else dec(m,t);
  end;

procedure inchm(var h,m:integer; t:integer);
  begin
    inc(m,t);
    xhm(h,m);
  end;

procedure tohm(s:string; var h,m:integer);
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    if pos(':',s)>0 then begin
      h:=StrToIntE1(copy(s,1,pos(':',s)-1));
      m:=StrToIntE1(copy(s,pos(':',s)+1,100));
    end
     else begin
       log.add('   '+mtrain+'.    : "'+s+'"');
       _errorflag:=true;
     end;
  end;

function prephm(s:string):string;
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    result:=s;
  end;        

function fromhm(h,m:integer):string;
  begin
    xhm(h,m);
    if h>9 then begin
             if m>9 then fromhm:=inttostr(h)+':'+inttostr(m)
                    else fromhm:=inttostr(h)+':0'+inttostr(m);
           end
           else begin
             if m>9 then fromhm:='0'+inttostr(h)+':'+inttostr(m)
                    else fromhm:='0'+inttostr(h)+':0'+inttostr(m);
           end;
  end;


procedure ClearSG;
 var i,n:integer;
begin
 for i:=0 to form1.StringGrid1.ColCount do
  for n:=0 to form1.StringGrid1.RowCount do form1.StringGrid1.Cells[i,n]:='';
end;

procedure ParseCSVStr(ts:AF_Types.PStrings; s:widestring);
 var n:integer;
begin
  ts.clear;
  while pos(';',s)>0 do begin
    n:=pos(';',s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;

procedure ParseCSVStrEx(ts:AF_Types.PStrings; s:widestring; c:char);
 var n:integer;
begin
  ts.clear;
  while pos(c,s)>0 do begin
    n:=pos(c,s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;

procedure LoadCareers;
  var f,u:AF_Types.TStrings;
  var i:integer;
begin
  f.create; u.create;
  career_n.clear;
  career_i.clear;
  career_t.clear;
  if fileexists(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\careers.ini') then begin
    f.loadfromfile(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\careers.ini');
    if f.count>0 then begin
     for i:=1 to f.count do begin
      ParseCSVStrEx(@u,f.getstring(i),';');
      if u.count>2 then begin
       if length(u.getstring(1))>1 then begin
         career_n.add(u.getstring(1));
         career_i.add(u.getstring(2));
         career_t.add(u.getstring(3));
       end;
      end;
     end;
    end;
  end
   else begin
     ShowMessage('   careers.ini ( )!');
     Halt(2);
   end;
  f.free; u.free;
end;

procedure LoadExpress;
  var f,u:AF_Types.TStrings;
  var i:integer;
begin
  f.create; u.create;
  expr_id.clear;
  expr_type.clear;
  expr_sub.clear;
  expr_career.clear;
  expr_tariff.clear;
  if fileexists(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\express.ini') then begin
    f.loadfromfile(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\express.ini');
    if f.count>0 then begin
     for i:=1 to f.count do begin
      ParseCSVStrEx(@u,ansilowercase(f.getstring(i)),';');
      if u.count>1 then begin
       if validstr(u.getstring(1)) then begin
         expr_id.add(u.getstring(1));
         expr_type.add(u.getstring(2));
         expr_sub.add(u.getstring(3));
         expr_career.add(u.getstring(4));
         expr_tariff.add(u.getstring(5));
       end;
      end;
     end;
    end;
  end
   else begin
     ShowMessage('   express.ini (  )!');
     Halt(2);
   end;
  f.free; u.free;
end;



function PrepareTT(s:string;n,n1,n2,mfs:integer; pttm:TPTTMode):TTimetable1;
 var r:boolean;
 var h,m,h1,m1,h2,m2,x:integer;
begin
  if pos('@',s)>0 then s:=copy(s,1,pos('@',s)-1);
  if pos('!',s)>0 then s:=copy(s,1,pos('!',s)-1);
  while pos('^',s)>0 do delete(s,pos('^',s),1);
  while pos('*',s)>0 do delete(s,pos('*',s),1);
  s:=trim(s);
  result.t1:='';
  result.t2:='';
  Result.st:='';
  Result.mfs:='';
  r:=true;
  if n=n1 then begin
    if pos('/',s)>0 then s:=copy(s,pos('/',s)+1,length(s)-pos('/',s));
    tohm(s,h,m);
    lh:=h; lm:=m; lmfs:=0;
    result.t2:=prephm(s);
    result.mfs:='0';
    r:=false;
  end;
  if n=n2 then begin
    if pos('/',s)>0 then s:=copy(s,1,pos('/',s)-1);
    tohm(s,h1,m1);
    result.t1:=prephm(s);
    r:=false;
      for x:=1 to 1439 do begin
        inchm(lh,lm,1);
        inc(lmfs,1);
        if (lh=h1) and (lm=m1) then break;
      end;
      result.mfs:=inttostr(lmfs);
  end;
  if r then
        if pos('-',s)>0 then begin
           Result.st:='-';
           r:=false;
        end;
  if r then begin
    if pos('/',s)>0 then begin
      tohm(copy(s,1,pos('/',s)-1),h,m);
      tohm(copy(s,pos('/',s)+1,length(s)-pos('/',s)),h1,m1);
      h2:=h; m2:=m;
      for x:=1 to 1439 do begin
        inchm(h2,m2,1);
        if (h2=h1) and (m2=m1) then break;
      end;
      result.t1:=fromhm(h,m);
      result.t2:=fromhm(h1,m1);
      result.st:=inttostr(x);
    end
     else begin
       tohm(s,h,m);
       h1:=h; m1:=m;
       dechm(h,m,1);
       result.t1:=fromhm(h,m);
       result.t2:=fromhm(h1,m1);
       Result.st:='1';
     end;
     if ((lh=h) and (lm=m) and (pttm=mAvia)) then lmfs:=lmfs
      else begin
       for x:=1 to 1439 do begin
        inchm(lh,lm,1);
        inc(lmfs,1);
        if (lh=h) and (lm=m) then break;
       end;
      end; 
      result.mfs:=inttostr(lmfs);
  end;
end;

function ValidNumber(s:string):boolean;
  var res:boolean;
  var i,e:integer;
begin
  res:=false;
  s:=trim(s);
  if pos('#',s)>0 then s:=trim(copy(s,1,pos('#',s)-1));
  if length(s)>0 then begin
    e:=0;
    for i:=1 to length(s) do begin
      if not (s[i] in ['0'..'9','/','#','^','a'..'z','A'..'Z']) then inc(e);
    end;
    if e=0 then res:=true;
  end;
  result:=res;
end;

function delquot(s:string):string;
begin
  result:=StrReplace(s,'"',' ');
end;

function delquot1(s:string):string;
begin
  result:=StrReplace(s,'"','&quot;');
  result:=StrReplace(s,#39,'&quot;');
  result:=StrReplace(s,#13,#32);
  result:=StrReplace(s,#10,#32);
end;

function CalcThread(n,o:integer; pttm:TPTTMode): WideString;
 var i,n1,n2,h,m,h1,m1,t:integer;
 var s:WideString;
 var tt:TTimetable1;
 var pl,late,iscombined,s9:string;
 var ondemand:boolean;
begin
  n1:=0;
  n2:=0;
  s:='';
  for i:=4 to 301 do begin
    n1:=i;
    if form1.StringGrid1.Cells[n,i]<>'' then break;
  end;
  for i:=301 downto 4 do begin
    n2:=i;
    if form1.StringGrid1.Cells[n,i]<>'' then break;
  end;
  if n2>n1 then begin
    lh:=0;
    lm:=0;
    lmfs:=0;
    mtrain:=form1.StringGrid1.Cells[n,0];
    for i:=n1 to n2 do begin
    if form1.StringGrid1.Cells[n,i]<>'' then begin
      ondemand:=false;
      if pos('*',form1.StringGrid1.Cells[n,i])>0 then ondemand:=true;
      if pos('^',form1.StringGrid1.Cells[n,i])>0 then iscombined:=' is_combined="1"'
                                                 else iscombined:='';
      tt:=PrepareTT(form1.StringGrid1.Cells[n,i],i,n1,n2,0,pttm);
      pl:='';
      if pos('@',form1.StringGrid1.Cells[n,i])>0 then pl:=' platform="'+trim(copy(form1.StringGrid1.Cells[n,i],pos('@',form1.StringGrid1.Cells[n,i])+1,length(form1.StringGrid1.Cells[n,i])-pos('@',form1.StringGrid1.Cells[n,i])))+'"'
                                                 else begin
                                                    if pos('(*)',ansilowercase(form1.StringGrid1.Cells[1,i]))>0 then ondemand:=true;
                                                    if ondemand then if tt.st<>'-' then pl:=' platform=" "';
                                                 end;
      if pos('!',form1.StringGrid1.Cells[n,i])>0 then begin
                                                   s9:=trim(copy(form1.StringGrid1.Cells[n,i],pos('!',form1.StringGrid1.Cells[n,i])+1,length(form1.StringGrid1.Cells[n,i])-pos('!',form1.StringGrid1.Cells[n,i])));
                                                   if ((ansilowercase(s9)='c')or(ansilowercase(s9)='')) then begin
                                                     late:=' delay_type="cancel"';
                                                   end
                                                    else begin
                                                     if ((ansilowercase(s9)='')or(ansilowercase(s9)='x')) then begin
                                                       late:=' delay_type="cancel" delay_comment_ru="  "';
                                                     end
                                                      else begin
                                                       while pos('+',s9)>0 do delete(s9,pos('+',s9),1);
                                                       late:=' delay_type="delay" delay_arrival="'+s9+'" delay_departure="'+s9+'"';
                                                      end;
                                                    end;
                                                 end
                                                 else late:='';
      if strtointe(tt.st)>150 then begin
        log.add('   '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st);
        if form1.checkbox2.checked=false then _errorflag:=true;
      end;
      if pttm=mLate then begin
         ofile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+late+' />');
      end
       else begin
         ofile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'" '+pl+'/>');
       end;
    end;
    end;
    if StrToIntE(tt.mfs)>660 then begin
      log.add('   '+mtrain+'. : MFS='+tt.mfs);
      if form1.checkbox3.checked=false then _errorflag:=true;
    end;
//    if form1.checkbox1.checked then ofile.add('  </thread>');
  end;
  result:=s;
end;

function PrepareStr1(s:string):string;
 var l,n,m:integer;
begin
  while pos('"',s)>0 do s[pos('"',s)]:='`';
  if s='?' then s:='-';
//  if s='' then s:='';
  l:=length(s);
  n:=pos(',',s);
  if (n=l-1)and(n>0) then s:=s+'0';
  s:=StrReplace(s,',',':');
  s:=StrReplace(s,'.',':');
  l:=length(s);
  n:=pos(':',s);
  if n=2 then s:='0'+s;
  result:=AnsiLowerCase(s);
end;

function a0(s:string):string;
begin
 if length(s)=1 then result:='0'+s
                else result:=s;
end;

function checkdfmt(s:string):boolean;
var i,n:integer;
var res:boolean;
begin
 res:=true;
 if (length(s) in [3..5]) then begin
   n:=pos('.',s);
   if (n in [2..3]) then begin
    if n<length(s) then begin
     for i:=1 to n-1 do begin
       if not (s[i] in ['0'..'9']) then res:=false;
     end;
     for i:=n+1 to length(s) do begin
       if not (s[i] in ['0'..'9']) then res:=false;
     end;
    end
     else res:=false;
   end
    else res:=false;
 end
  else res:=false;
 result:=res;
end;

function vDate(s,_trn:string;noshowolddate,dispfardate:boolean):string;
  var i,d,m,m2,y,y2:integer;
  var d1,m1,s1,d2:string;
  var tds:AF_Types.TStrings;
  var d3,ld:TDateTime;
begin
if s<>'_' then begin
  ld:=0;
  tds.create;
  result:='';
  s:=Trim(s);
  if s='*' then s:=FormatDateTime('dd',Date)+'.'+FormatDateTime('mm',Date);
  m2:=StrToIntE(FormatDateTime('mm',Date));
  y2:=StrToIntE(FormatDateTime('yyyy',Date));
 ParseCSVStrEx(@tds,s,',');
 if tds.count>0 then begin
 for i:=1 to tds.count do begin
  s1:=trim(tds.getstring(i));
  if pos('.',s1)>1 then begin
  if checkdfmt(s1) then begin
    d:=strtointe(copy(s1,1,pos('.',s1)-1));
    m:=strtointe(copy(s1,pos('.',s1)+1,length(s1)-pos('.',s1)));
                       {

    if ((d>0) and (m>0)) then begin
      if ((m<m2)and(m2<11)) then begin y:=y2+1; end
                            else begin
                              if ((m>=11)and(m2<3)) then y:=y2-1
                                                    else y:=y2;
                            end;

                        }

    if ((d>0) and (m>0)) then begin
     if noshowolddate then begin
       if ((m<m2)and((m2-m)>2)) then y:=y2+1
                                else y:=y2;
     end
     else begin
      if ((m<m2)and((m2-m)>2)) then begin y:=y2+1; end
                            else begin
                              if ((m>=11)and(m2<3)) then y:=y2-1
                                                    else y:=y2;
                            end;
     end;

//      ,    - 
//      if m=12 then y:=2012;

      d2:=inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d));
      d3:=EncodeDate(y,m,d);
      if d3<_dt11 then _dt11:=d3;
      if d3>=date then begin
        result:=result+inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d))+';';
        inc(_fccount);
        if d3<_dt1 then _dt1:=d3;
      end
       else begin
         if not noshowolddate then log.add('           '+_trn+'.    ('+inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d))+')!');
       end;
      if d3<(date-3) then begin
        log.add('   '+_trn+'.   -3    ('+inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d))+')!');
        if not Form1.CheckBox1.Checked then _errorflag:=true;
      end;
      if d3>(date+45) then begin
        if dispfardate then log.add('   '+_trn+'.   +45    ('+inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d))+')!');
        if not Form1.CheckBox1.Checked then _errorflag:=true;
      end;
      if d3>_dt2 then _dt2:=d3;
      if d3>ld then ld:=d3;
    end;
  end
   else begin
    log.add('   '+_trn+'.    - '+s1);
    _errorflag:=true;
   end;
  end
   else begin
    log.add('   '+_trn+'.    - '+s1);
    _errorflag:=true;
   end;
 end;
  if length(result)>0 then begin
   if result[length(result)]=';' then result:=copy(result,1,length(result)-1);
  end;
 end;
{     if (form1.CheckBox1.checked)and(length(s)=0) then begin
       result:=formatdatetime('yyyy-mm-dd',form1.DateTimePicker1.DateTime);
     end;
}  tds.free;
  if result='' then result:='N';
end
 else result:='_';
end;



function vDateAvia(s,_trn:string):string;
  var i,d,m,m2,y,y2:integer;
  var d1,m1,s1,d2:string;
  var tds:AF_Types.TStrings;
  var d3,ld:TDateTime;
begin
if s<>'_' then begin
  ld:=0;
  tds.create;
  result:='';
  s:=Trim(s);
  if s='*' then s:=FormatDateTime('dd',Date)+'.'+FormatDateTime('mm',Date);
  m2:=StrToIntE(FormatDateTime('mm',Date));
  y2:=StrToIntE(FormatDateTime('yyyy',Date));
 ParseCSVStrEx(@tds,s,',');
 if tds.count>0 then begin
 for i:=1 to tds.count do begin
  s1:=trim(tds.getstring(i));
  if pos('.',s1)>1 then begin
  if checkdfmt(s1) then begin
    d:=strtointe(copy(s1,1,pos('.',s1)-1));
    m:=strtointe(copy(s1,pos('.',s1)+1,length(s1)-pos('.',s1)));

    if ((d>0) and (m>0)) then begin
      if ((m<m2)and(m2-m>=4)) then begin y:=y2+1; end
                            else begin
                              if ((m>11)and(m2<2)) then y:=y2-1
                                                   else y:=y2;
                            end;
      d2:=inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d));
      d3:=EncodeDate(y,m,d);
      if d3<_dt11 then _dt11:=d3;
        result:=result+inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d))+';';
        inc(_fccount);
        if d3<_dt1 then _dt1:=d3;
      if d3<(date-3) then begin
        log.add('  '+_trn+'.   -3    ('+inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d))+')!');
        if not Form1.CheckBox1.Checked then _errorflag:=true;
      end;
      if d3>_dt2 then _dt2:=d3;
      if d3>ld then ld:=d3;
    end;
  end
   else begin
    log.add('  '+_trn+'.    - '+s1);
    _errorflag:=true;
   end;
  end;
 end;
  if length(result)>0 then begin
   if result[length(result)]=';' then result:=copy(result,1,length(result)-1);
  end;
 end;
  tds.free;
  if result='' then result:='N';
end
 else result:='_';
end;




function PrepareTTime(s:string):string;
   var s1,s2:string;
   function _nn(_s:string):boolean;
     var _n,_i:integer;
   begin
     _n:=0;
     for _i:=1 to length(_s) do begin
       if not (_s[_i] in ['0'..'9']) then inc(_n);
     end;
     if _n=0 then result:=true
             else result:=false;
   end;
   function _nz(_s:string):boolean;
     var _n,_i:integer;
   begin
     _n:=0;
     for _i:=1 to length(_s) do begin
       if not (_s[_i] in ['0'..'9',':']) then inc(_n);
     end;
     if _n=0 then begin
         for _i:=1 to length(_s) do begin
           if _s[_i]=':' then inc(_n);
         end;
       if (_n=1)and(s[length(s)-1]=':') then result:=true
               else result:=false;
     end
             else result:=false;
   end;
   function _nx(_s:string):boolean;
     var _n,_i:integer;
   begin
     _n:=0;
     if length(s)>2 then begin
     for _i:=1 to length(_s) do begin
       if not (_s[_i] in ['0'..'9','.']) then inc(_n);
     end;
     if _n=0 then begin
         for _i:=1 to length(_s) do begin
           if _s[_i]='.' then inc(_n);
         end;
       if (_n=1)and(s[2]='.')and(s[1]='0') then result:=true
               else result:=false;
     end
             else result:=false;
     end
             else result:=false;
   end;
begin
 if length(s)>0 then begin

//   if pos('@',s)>0 then s:=trim(copy(s,1,pos('@',s)-1));

   if (_nz(s))and(length(s)>4) then begin
//     time
   end;
   if length(s)>0 then begin
     s:=StrReplace(s,'  ',' ');
     s:=StrReplace(s,'/ ','/');
     s:=StrReplace(s,' /','/');
     s:=StrReplace(s,'@ ','@');
     s:=StrReplace(s,' @','@');
  s2:='';
  if pos('@',s)>0 then begin
    s1:=copy(s,1,pos('@',s)-1);
    s2:=copy(s,pos('@',s),length(s)-pos('@',s)+1);
  end
   else s1:=s;
   if length(s1)>3 then while pos('-',s1)>0 do s1[pos('-',s1)]:=':';
   s1:=StrReplace(s1,'O','0');
   s1:=StrReplace(s1,'','0');
   s1:=StrReplace(s1,'o','0');
   s1:=StrReplace(s1,'','0');
     while pos(',',s1)>0 do s1[pos(',',s1)]:=':';
     while pos('.',s1)>0 do s1[pos('.',s1)]:=':';
   s:=s1+s2;
   end;
   if _nn(s) then begin
     if length(s)<3 then s:=s+':00';
   end
    else begin
      if _nz(s) then s:=s+'0';
    end;
   if s='?' then s:='-';
   result:=s;
 end
  else result:='';
end;

procedure LoadFromXLS(fn:string);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
IIndex : OleVariant;
NomFich : WideString;
xl_X, xl_Y, xl_xx, xl_yy, xl_x1, xl_y1 : Integer;
xl_nf:string;
xl_tf:double;
xl_f1000:boolean;
begin
with form1 do begin
xl_f1000:=false;
NomFich := fn;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
//for wshs:=1 to WorkBk.WorkSheets.Count do begin
//WorkSheet := WorkBk.Sheets[wshs] as _WorkSheet;
//WorkSheet.Activate(0);
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
xl_X := XLApp.ActiveCell.Row;
xl_Y := XLApp.ActiveCell.Column;
  if xl_x>300 then begin
    xl_f1000:=true;
    xl_x1:=3;
    for xl_xx:=1 to xl_x do begin
      if trim(VarToStrDef(worksheet.cells.item[xl_xx,1],''))<>'' then xl_x1:=xl_xx;
    end;
    if xl_x1>2 then xl_x:=xl_x1
            else xl_x:=3;
  end;
  if xl_y>1000 then begin
    xl_f1000:=true;
    xl_y1:=3;
    for xl_yy:=1 to xl_y do begin
      if trim(VarToStrDef(worksheet.cells.item[1,xl_yy],''))<>'' then xl_y1:=xl_yy;
    end;
    if xl_y1>2 then xl_y:=xl_y1
            else xl_y:=3;
  end;
  if xl_f1000 then Log.add('  !   '+extractfilename(fn)+' >300   >1000 !');
StringGrid1.ColCount := xl_Y;
StringGrid1.RowCount := xl_X;

for xl_xx:=1 to xl_x do begin
  for xl_yy:=1 to xl_y do begin
    xl_nf:=worksheet.cells.item[xl_xx,xl_yy].NumberFormat;
    if (xl_nf=':')or(xl_nf=':')or(xl_nf='h:mm')or(xl_nf='hh:mm;@')or(xl_nf=':;@')or(xl_nf=':;@')or(xl_nf='h:mm;@')or(xl_nf='hh:mm;@') then begin
       xl_tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xl_xx,xl_yy]),70);
       if xl_tf=70 then stringgrid1.Cells[xl_yy-1,xl_xx-1]:=trim(VarToStrDef(worksheet.cells.item[xl_xx,xl_yy],''))
                else stringgrid1.Cells[xl_yy-1,xl_xx-1]:=trim(FormatDateTime('hh:nn',xl_tf));
    end
     else stringgrid1.Cells[xl_yy-1,xl_xx-1]:=trim(VarToStrDef(worksheet.cells.item[xl_xx,xl_yy],''));
  end;
end;


XLApp.Quit;
XLApp.Disconnect;
end;
end;

function numbprep(s:string):string;
begin
 if pos('#',s)>0 then s:=trim(copy(s,1,pos('#',s)-1));
  while pos('^',s)>0 do delete(s,pos('^',s),1);
 result:=trim(s);
end;


function numb2type_obsolete(s:string):string;
  var s1,res:string;
begin
  res:='';
  while pos('^',s)>0 do delete(s,pos('^',s),1);
  s:=trim(AnsiLowerCase(s));
  if pos('#',s)>0 then begin
    s1:=trim(copy(s,pos('#',s)+1,length(s)-pos('#',s)));
    if s1='aero' then res:='express_type="aeroexpress"';
    if s1='aeroexpress' then res:='express_type="aeroexpress"';
    if s1='expr' then res:='express_type="express"';
    if s1='exp' then res:='express_type="express"';
    if s1='ex' then res:='express_type="express"';
    if s1='usk' then res:='express_type="express"';
    if s1='uskor' then res:='express_type="express"';
    if s1='skor' then res:='express_type="express"';
    if s1='express' then res:='express_type="express"';
    if s1='express8' then res:='express_type="express"';
    if s1='express7' then res:='express_type="express"';
  end;
  result:=res;
end;



function gMonth(s:string):string;
  var m:integer;
  var res:string;
begin
  m:=strtointe(s);
    case m of
      1: res:='';
      2: res:='';
      3: res:='';
      4: res:='';
      5: res:='';
      6: res:='';
      7: res:='';
      8: res:='';
      9: res:='';
      10: res:='';
      11: res:='';
      12: res:='';
      else res:='';
    end;
  result:=res;
end;


function CalcDays2(s,day0:string):string;
  var c,t,w,h,nw,chet,nech:char;
  var d,dx,s1,dlist1,dlist2,day1,day2,dsd1,dsd2,ds1,ds2,ds3,ds4,ds5,ds6,thisday,paramday,newstr:string;
  var r:boolean;
  var i,n1,n2:integer;
  var dt0:TDateTime;
  var dd1,dd2:array[0..6] of byte;
  const dd:array[0..6] of string[20] = ('', '', '', '', '', '', '');
begin
  dsd1:='';
  dsd2:='';
  paramday:=day0;
  thisday:=FormatDateTime('yyyy-mm-dd',date);
  if pos('-',day0)>0 then begin
    ds1:=copy(day0,1,pos('-',day0)-1);
    day0:=copy(day0,pos('-',day0)+1,length(day0)-pos('-',day0));
    ds2:=copy(day0,1,pos('-',day0)-1);
    ds3:=trim(copy(day0,pos('-',day0)+1,length(day0)-pos('-',day0)));
    dt0:=EncodeDate(strtointe(ds1),strtointe(ds2),strtointe(ds3))+1;
    DateTimeToString(ds4,'mm-dd',dt0);
    ds5:=copy(ds4,1,pos('-',ds4)-1);
    ds6:=trim(copy(ds4,pos('-',ds4)+1,length(ds4)-pos('-',ds4)));
    if ds3[1]='0' then delete(ds3,1,1);
    if ds6[1]='0' then delete(ds6,1,1);
    if paramday=thisday then begin
     dsd1:='';
     dsd2:='';
    end
     else begin
      dsd1:='  '+ds3+' '+gMonth(ds2);
      dsd2:='  '+ds6+' '+gMonth(ds5);
     end;
  end;

  for i:=0 to 6 do dd1[i]:=0;
  for i:=0 to 6 do dd2[i]:=0;
  r:=true;
  c:='N';
  t:='Y';
  w:='N';
  h:='N';
  nw:='N';
  chet:='N';
  nech:='N';
  d:='';
  dx:='';
  dlist1:='';
  dlist2:='';
  newstr:='';
  if s='' then r:=false;
  if r and (s='') then begin c:='N'; t:='Y'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='Y'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; chet:='Y'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; nech:='Y'; r:=false; end;
  if r and (s='') then begin c:='Y'; t:='N'; r:=false; end;
  if r and (s='') then begin c:='Y'; t:='N'; r:=false; end;
  if r and (s=':') then begin c:='N'; t:='N'; d:='012345'; r:=false; end;
  if r and (s=':') then begin c:='N'; t:='N'; d:='123456'; r:=false; end;
  if r and (s=':') then begin c:='N'; t:='N'; d:='123456'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='123456'; r:=false; end;
  if r and (s=':') then begin c:='N'; t:='N'; d:='012346'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='6'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='0'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='0'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='5'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; w:='Y'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; h:='Y'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; h:='Y'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; nw:='Y'; d:='1234'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='12346'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='5'; h:='Y'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='012346'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='5'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='5'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='56'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='01234'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='123456'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='05'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='6'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='012345'; r:=false; end;
  if r then begin
    form2.Position:=poMainFormCenter;
    form2.Label1.caption:=s;
    form2.ShowModal;
    i:=0;
    t:='N';
    if form2.CheckBox1.Checked then inc(i);
    if form2.CheckBox2.Checked then inc(i);
    if form2.CheckBox3.Checked then inc(i);
    if form2.CheckBox4.Checked then inc(i);
    if form2.CheckBox5.Checked then inc(i);
    if form2.CheckBox6.Checked then inc(i);
    if form2.CheckBox7.Checked then inc(i);
    if i>0 then begin
      if form2.CheckBox1.Checked then d:=d+'1';
      if form2.CheckBox2.Checked then d:=d+'2';
      if form2.CheckBox3.Checked then d:=d+'3';
      if form2.CheckBox4.Checked then d:=d+'4';
      if form2.CheckBox5.Checked then d:=d+'5';
      if form2.CheckBox6.Checked then d:=d+'6';
      if form2.CheckBox7.Checked then d:=d+'0';
    end;
    if form2.CheckBox8.Checked then w:='Y';
    if form2.CheckBox9.Checked then h:='Y';
  end;
  s1:='cancel="'+c+'" daily="'+t+'"';
  if chet='Y' then s1:=s1+' even="Y"';
  if nech='Y' then s1:=s1+' odd="Y"';
  if w='Y' then s1:=s1+' workdays="Y"';
  if h='Y' then s1:=s1+' weekend="Y"';
  if nw='Y' then s1:=s1+' noweekend="Y"';
  if d<>'' then s1:=s1+' days="'+d+'"';
  //
  r:=true;
  if c='Y' then begin dlist1:=''; dlist2:=''; r:=false; newstr:='C'; end;
  if r and (t='Y') then begin dlist1:=''; dlist2:=''; r:=false; newstr:='1234567'; end;
  if r and (t='N') and (chet='Y') then begin dlist1:='  '; dlist2:='  '; r:=false; newstr:='E'; end;
  if r and (t='N') and (nech='Y') then begin dlist1:='  '; dlist2:='  '; r:=false; newstr:='U'; end;
  if r and (w='Y') and (d='') then begin dlist1:=' '; dlist2:=' ,'; r:=false; newstr:='W'; end;
  if r and (h='Y') and (d='') then begin dlist1:=' '; dlist2:=',  .'; r:=false; newstr:='H'; end;
  if r and (h='N') and (d='1234') then begin
                                          if nw='Y' then begin dlist1:='   '; dlist2:='   '; r:=false; newstr:='-5H'; end
                                                    else begin dlist1:=',,,'; dlist2:=',,,'; r:=false; newstr:='1234'; end;
                                       end;
  if r and (h='Y') and (d='5') then begin dlist1:='   '; dlist2:=' .  '; r:=false; newstr:='5H'; end;
  if r and (d<>'') then begin
                     if h='Y' then begin dd2[0]:=1; dd2[1]:=1; end;
                     if pos('0',d)>0 then begin dd1[0]:=1; dd2[1]:=1; end;
                     if pos('1',d)>0 then begin dd1[1]:=1; dd2[2]:=1; end;
                     if pos('2',d)>0 then begin dd1[2]:=1; dd2[3]:=1; end;
                     if pos('3',d)>0 then begin dd1[3]:=1; dd2[4]:=1; end;
                     if pos('4',d)>0 then begin dd1[4]:=1; dd2[5]:=1; end;
                     if pos('5',d)>0 then begin dd1[5]:=1; dd2[6]:=1; end;
                     if pos('6',d)>0 then begin dd1[6]:=1; dd2[0]:=1; end;
                     n1:=0; n2:=0;
                     for i:=0 to 6 do if dd1[i]=1 then inc(n1);
                     for i:=0 to 6 do if dd2[i]=1 then inc(n2);
                     if n1>4 then begin
                       dlist1:=' ';
                       newstr:='-';
                       for i:=1 to 6 do if dd1[i]=0 then begin dlist1:=dlist1+dd[i]+','; newstr:=newstr+inttostr(i); end;
                       if dd1[0]=0 then begin dlist1:=dlist1+dd[0]+','; newstr:=newstr+'7'; end;
                     end
                      else begin
                       newstr:='';
                       for i:=1 to 6 do if dd1[i]=1 then begin dlist1:=dlist1+dd[i]+','; newstr:=newstr+inttostr(i); end;
                       if dd1[0]=1 then begin dlist1:=dlist1+dd[0]+','; newstr:=newstr+'7'; end;
                      end;
                     if n2>4 then begin
                       dlist2:=' ';
                       for i:=1 to 6 do if dd2[i]=0 then dlist2:=dlist2+dd[i]+',';
                       if dd2[0]=0 then dlist2:=dlist2+dd[0]+',';
                     end
                      else begin
                       for i:=1 to 6 do if dd2[i]=1 then dlist2:=dlist2+dd[i]+',';
                       if dd2[0]=1 then dlist2:=dlist2+dd[0]+',';
                      end;
                     dlist1:=copy(dlist1,1,length(dlist1)-1);
                     dlist2:=copy(dlist2,1,length(dlist2)-1);
                     if h='Y' then begin dlist1:=dlist1+'  '; newstr:=newstr+'H'; end;
                   end;


  if form1.checkbox4.checked then s1:=s1+' daystr="" weektemplate="'+newstr+'"'
                             else s1:=s1+' daystr="'+dlist1+dsd1+';'+dlist2+dsd2+'" weektemplate="'+newstr+'"';
  //
  result:=s1;
end;








function prepdstart(s:string):string;
  var thy,thm,s1,s2,res:string;
  var m1,m2,y:integer;
begin
  if pos(';',s)>0 then s:=trim(copy(s,1,pos(';',s)-1));
{  s:=trim(s);
  res:='error';
   if length(s)>2 then begin
   if (pos('.',s) in [2..length(s)-1]) then begin
     thy:=FormatDateTime('yyyy',Date);
     thm:=FormatDateTime('mm',Date);
     s1:=trim(copy(s,1,pos('.',s)-1));
     s2:=trim(copy(s,pos('.',s)+1,10));
     s1:=a0(s1);
     s2:=a0(s2);
     y:=strtointe(thy);
     m1:=strtointe(thm);
     m2:=strtointe(s2);
     if m2<m1 then inc(y);
     thy:=inttostr(y);
     res:=thy+'-'+s2+'-'+s1;
     s:=res;
   end;
   end;}
  result:=s;
end;

function prepwtstart(s:string):string;
  var thy,thm,s1,s2,res:string;
  var m1,m2,y:integer;
  var fs:TFormatSettings;
  var dt1:TDateTime;
begin
  if pos(';',s)>0 then s:=trim(copy(s,1,pos(';',s)-1));
  fs.DateSeparator:='-';
  fs.ShortDateFormat:='yyyy-mm-dd';
  fs.LongDateFormat:='yyyy-mm-dd';
  dt1:=StrToDate(s,fs);
  if dt1<>date then result:='weektemplate_start="'+s+'" '
               else result:='';
end;

function prepavstart(s,trn:string; var date1:TDateTime):string;
  var thy,thm,s1,s2,res:string;
  var m1,m2,y:integer;
  var fs:TFormatSettings;
  var dt1:TDateTime;
begin
  if pos('-',s)>0 then begin
  s:=trim(copy(s,1,pos('-',s)-1));
  s:=vDateAvia(s,trn);
  fs.DateSeparator:='-';
  fs.ShortDateFormat:='yyyy-mm-dd';
  fs.LongDateFormat:='yyyy-mm-dd';
  dt1:=StrToDate(s,fs);
  if dt1<date then dt1:=date;
  result:='period_start="'+s+'" ';
  date1:=dt1;
  end
   else begin
     if not validstr(s) then begin
       result:='period_start="'+formatdatetime('yyyy-mm-dd',date-10)+'" ';
       date1:=date-10;
     end
      else result:='';
   end;
end;

function prepavend(s,trn:string; prevdate:TDateTime):string;
  var thy,thm,s1,s2,res:string;
  var m1,m2,y:integer;
  var y0,m0,d0:word;
  var fs:TFormatSettings;
  var dt1:TDateTime;
begin
  if pos('-',s)>0 then begin
  s:=trim(copy(s,pos('-',s)+1,length(s)-pos('-',s)));
  s:=vDateAvia(s,trn);
  fs.DateSeparator:='-';
  fs.ShortDateFormat:='yyyy-mm-dd';
  fs.LongDateFormat:='yyyy-mm-dd';
  dt1:=StrToDate(s,fs);
  if dt1<prevdate then begin
   DecodeDate(dt1,y0,m0,d0);
   y0:=yearof(prevdate);
   dt1:=EncodeDate(y0,m0,d0);
  end;
  if dt1<date then LOG.add('     - '+s);
  result:='period_end="'+formatdatetime('yyyy-mm-dd',dt1)+'" ';
  end
   else begin
     if not validstr(s) then begin
       result:='period_end="'+formatdatetime('yyyy-mm-dd',date+400)+'" ';
     end
      else result:='';
   end;
end;

function CalcDays2avia(s,day9,_trn:string):string;
  var c,t,w,h,nw,chet,nech:char;
  var d,dx,s1,dlist1,dlist2,day0,day1,day2,dsd1,dsd2,ds1,ds2,ds3,ds4,ds5,ds6,thisday,paramday,newstr:string;
  var r:boolean;
  var i,n1,n2:integer;
  var dt0:TDateTime;
  var dd1,dd2:array[0..6] of byte;
  const dd:array[0..6] of string[20] = ('', '', '', '', '', '', '');
begin
  dsd1:='';
  dsd2:='';
  paramday:=FormatDateTime('yyyy-mm-dd',date);
  day0:=FormatDateTime('yyyy-mm-dd',date);
  thisday:=FormatDateTime('yyyy-mm-dd',date);
 if ((pos('-',day9)>0)or(not validstr(day9))) then begin
  if pos('-',day0)>0 then begin
    ds1:=copy(day0,1,pos('-',day0)-1);
    day0:=copy(day0,pos('-',day0)+1,length(day0)-pos('-',day0));
    ds2:=copy(day0,1,pos('-',day0)-1);
    ds3:=trim(copy(day0,pos('-',day0)+1,length(day0)-pos('-',day0)));
    dt0:=EncodeDate(strtointe(ds1),strtointe(ds2),strtointe(ds3))+1;
    DateTimeToString(ds4,'mm-dd',dt0);
    ds5:=copy(ds4,1,pos('-',ds4)-1);
    ds6:=trim(copy(ds4,pos('-',ds4)+1,length(ds4)-pos('-',ds4)));
    if ds3[1]='0' then delete(ds3,1,1);
    if ds6[1]='0' then delete(ds6,1,1);
    if paramday=thisday then begin
     dsd1:='';
     dsd2:='';
    end
     else begin
      dsd1:='  '+ds3+' '+gMonth(ds2);
      dsd2:='  '+ds6+' '+gMonth(ds5);
     end;
  end;

  for i:=0 to 6 do dd1[i]:=0;
  for i:=0 to 6 do dd2[i]:=0;
  r:=true;
  c:='N';
  t:='Y';
  w:='N';
  h:='N';
  nw:='N';
  chet:='N';
  nech:='N';
  d:='';
  dx:='';
  dlist1:='';
  dlist2:='';
  newstr:='';
  if s='' then r:=false;
  if r and (s='') then begin c:='N'; t:='Y'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='Y'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; chet:='Y'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; nech:='Y'; r:=false; end;
  if r and (s='') then begin c:='Y'; t:='N'; r:=false; end;
  if r and (s='') then begin c:='Y'; t:='N'; r:=false; end;
  if r and (s=':') then begin c:='N'; t:='N'; d:='012345'; r:=false; end;
  if r and (s=':') then begin c:='N'; t:='N'; d:='123456'; r:=false; end;
  if r and (s=':') then begin c:='N'; t:='N'; d:='123456'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='123456'; r:=false; end;
  if r and (s=':') then begin c:='N'; t:='N'; d:='012346'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='6'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='0'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='0'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='5'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; w:='Y'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; h:='Y'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; h:='Y'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; nw:='Y'; d:='1234'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='12346'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='5'; h:='Y'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='012346'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='5'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='5'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='56'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='01234'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='123456'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='05'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='6'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='012345'; r:=false; end;
  if r then begin
    form2.Position:=poMainFormCenter;
    form2.Label1.caption:=s;
    if not ParseKStr then form2.ShowModal;
    i:=0;
    t:='N';
    if form2.CheckBox1.Checked then inc(i);
    if form2.CheckBox2.Checked then inc(i);
    if form2.CheckBox3.Checked then inc(i);
    if form2.CheckBox4.Checked then inc(i);
    if form2.CheckBox5.Checked then inc(i);
    if form2.CheckBox6.Checked then inc(i);
    if form2.CheckBox7.Checked then inc(i);
    if i>0 then begin
      if form2.CheckBox1.Checked then d:=d+'1';
      if form2.CheckBox2.Checked then d:=d+'2';
      if form2.CheckBox3.Checked then d:=d+'3';
      if form2.CheckBox4.Checked then d:=d+'4';
      if form2.CheckBox5.Checked then d:=d+'5';
      if form2.CheckBox6.Checked then d:=d+'6';
      if form2.CheckBox7.Checked then d:=d+'0';
    end;
    if form2.CheckBox8.Checked then w:='Y';
    if form2.CheckBox9.Checked then h:='Y';
  end;
  s1:='cancel="'+c+'" daily="'+t+'"';
  if chet='Y' then s1:=s1+' even="Y"';
  if nech='Y' then s1:=s1+' odd="Y"';
  if w='Y' then s1:=s1+' workdays="Y"';
  if h='Y' then s1:=s1+' weekend="Y"';
  if nw='Y' then s1:=s1+' noweekend="Y"';
  if d<>'' then s1:=s1+' days="'+d+'"';
  //
  r:=true;
  if c='Y' then begin dlist1:=''; dlist2:=''; r:=false; newstr:='C'; end;
  if r and (t='Y') then begin dlist1:=''; dlist2:=''; r:=false; newstr:='1234567'; end;
  if r and (t='N') and (chet='Y') then begin dlist1:='  '; dlist2:='  '; r:=false; newstr:='E'; end;
  if r and (t='N') and (nech='Y') then begin dlist1:='  '; dlist2:='  '; r:=false; newstr:='U'; end;
  if r and (w='Y') and (d='') then begin dlist1:=' '; dlist2:=' ,'; r:=false; newstr:='W'; end;
  if r and (h='Y') and (d='') then begin dlist1:=' '; dlist2:=',  .'; r:=false; newstr:='H'; end;
  if r and (h='N') and (d='1234') then begin
                                          if nw='Y' then begin dlist1:='   '; dlist2:='   '; r:=false; newstr:='-5H'; end
                                                    else begin dlist1:=',,,'; dlist2:=',,,'; r:=false; newstr:='1234'; end;
                                       end;
  if r and (h='Y') and (d='5') then begin dlist1:='   '; dlist2:=' .  '; r:=false; newstr:='5H'; end;
  if r and (d<>'') then begin
                     if h='Y' then begin dd2[0]:=1; dd2[1]:=1; end;
                     if pos('0',d)>0 then begin dd1[0]:=1; dd2[1]:=1; end;
                     if pos('1',d)>0 then begin dd1[1]:=1; dd2[2]:=1; end;
                     if pos('2',d)>0 then begin dd1[2]:=1; dd2[3]:=1; end;
                     if pos('3',d)>0 then begin dd1[3]:=1; dd2[4]:=1; end;
                     if pos('4',d)>0 then begin dd1[4]:=1; dd2[5]:=1; end;
                     if pos('5',d)>0 then begin dd1[5]:=1; dd2[6]:=1; end;
                     if pos('6',d)>0 then begin dd1[6]:=1; dd2[0]:=1; end;
                     n1:=0; n2:=0;
                     for i:=0 to 6 do if dd1[i]=1 then inc(n1);
                     for i:=0 to 6 do if dd2[i]=1 then inc(n2);
                     if n1>4 then begin
                       dlist1:=' ';
                       newstr:='-';
                       for i:=1 to 6 do if dd1[i]=0 then begin dlist1:=dlist1+dd[i]+','; newstr:=newstr+inttostr(i); end;
                       if dd1[0]=0 then begin dlist1:=dlist1+dd[0]+','; newstr:=newstr+'7'; end;
                     end
                      else begin
                       newstr:='';
                       for i:=1 to 6 do if dd1[i]=1 then begin dlist1:=dlist1+dd[i]+','; newstr:=newstr+inttostr(i); end;
                       if dd1[0]=1 then begin dlist1:=dlist1+dd[0]+','; newstr:=newstr+'7'; end;
                      end;
                     if n2>4 then begin
                       dlist2:=' ';
                       for i:=1 to 6 do if dd2[i]=0 then dlist2:=dlist2+dd[i]+',';
                       if dd2[0]=0 then dlist2:=dlist2+dd[0]+',';
                     end
                      else begin
                       for i:=1 to 6 do if dd2[i]=1 then dlist2:=dlist2+dd[i]+',';
                       if dd2[0]=1 then dlist2:=dlist2+dd[0]+',';
                      end;
                     dlist1:=copy(dlist1,1,length(dlist1)-1);
                     dlist2:=copy(dlist2,1,length(dlist2)-1);
                     if h='Y' then begin dlist1:=dlist1+'  '; newstr:=newstr+'H'; end;
                   end;


{  if form1.checkbox4.checked then s1:=s1+' daystr="" weektemplate="'+newstr+'"'
                             else s1:=s1+' daystr="'+dlist1+dsd1+';'+dlist2+dsd2+'" weektemplate="'+newstr+'"';}
  //
  result:=s1;
 end  //day9
  else begin
    result:='cancel="N" daily="N" dates="'+vDateAvia(day9,_trn)+'" ';
  end;
end;


procedure getexpress(s:string; var express:string; var expresssub:string; var career: string; var tariff:string);
  var s1,s2,res:string;
  var n:integer;
begin
  res:='';
  s:=trim(AnsiLowerCase(s));
  if pos('#',s)>0 then begin
    s1:=copy(s,pos('#',s)+1,length(s)-pos('#',s));
    if pos('^',s1)>0 then delete(s1,pos('^',s1),1);
    s1:=trim(s1);
    n:=expr_id.SearchString(s1);
    if n>0 then begin
      if expr_type.getstring(n)<>'*' then express:=expr_type.getstring(n);
      if expr_sub.getstring(n)<>'*' then expresssub:=expr_sub.getstring(n);
      if expr_career.getstring(n)<>'*' then career:=expr_career.getstring(n);
      if expr_tariff.getstring(n)<>'*' then tariff:=expr_tariff.getstring(n);
    end
     else log.add('   #   : '+s1);
  end;
end;

function apifnc(param,str:string):string;
begin
 if validstr(str) then result:=' '+param+'="'+str+'"'
                  else result:='';
end;

function decDate(s:string):string;
 var dt:TDateTime;
 var fs:TFormatSettings;
begin
  fs.DateSeparator:='-';
  fs.shortdateformat:='yyyy-mm-dd';
  fs.longdateformat:='yyyy-mm-dd';
  dt:=StrToDate(s,fs);
  dt:=dt-1;
  result:=FormatDateTime('yyyy-mm-dd',dt);
end;

function comparern(s0,s3:string):boolean;
  var s:string;
  var i:integer;
begin
  s:='';
  if pos('R_', s3)=1  then  s3:= copy(s3, 3, 1000);
 //  log.add(s3);
  if length(s3)>0 then begin
    i:=0;
    repeat
      inc(i);
      if (s3[i] in ['0'..'9','x']) then s:=s+s3[i]
                                   else break;
    until i=length(s3);
    s:=StrReplace(s,'x','/');
    if numbprep(s0)=s then result:=true
                      else result:=false;
  end
   else result:=false;

end;

procedure gr2per(graph:string; var period_start,period_end:string);
 var n:integer;
begin
  n:=_grname.SearchString(ansilowercase(graph));
  if n>0 then begin
     period_start:=_grps.getstring(n);
     period_end:=_grpe.getstring(n);
  end
   else begin
     period_start:='';
     period_end:='';
     log.add('    !!!   '+graph);
     _errorflag:=true;
   end;
end;

function _dcr(s:string):string;
begin
 s:=trim(s);
 if pos('&',s)>0 then begin
  s:=trim(copy(s,pos('&',s)+1,length(s)-pos('&',s)));
 end;
 if validstr(s) then result:=' delay_comment_ru="'+s+'"'
                else result:='';
end;

function _dvl(s:string):string;
begin
 s:=trim(s);
 if pos('&',s)>0 then begin
  s:=trim(copy(s,1,pos('&',s)-1));
 end
  else s:='';
 if validstr(s) then result:=' delay_value="'+s+'"'
                else result:='';
end;


procedure MainProc(filelist:AF_Types.PStrings;ofilename,flags:string;noshowolddate:boolean);
 var ts,notdir,notdate1,notdate2,nottxt,notmobtxt,ndirs,pp:AF_Types.TStrings;
 var t:TextFile;
 var p,s,d,d1,d11,d2,career,rstr,rver,tzone,grph,cgci,iscombined,p_career,p_express,p_expresssubtype,p_tariff,mvdir,s1,s2,s3,s4,nds,avcareer,avmodel,avttype,avt_start,avt_end,_periodstart,_periodend,_ssp:string;
 var i,i1,ff,n,n1,o,z,e,e1:integer;
 var ch:char;
 var kflag:boolean;
 var WorkBk : _WorkBook;
 var WorkSheet : _WorkSheet;
 var IIndex : OleVariant;
 var NomFich : WideString;
 var xl_X, xl_Y, xl_xx, xl_yy, xl_x1, xl_y1, wshs, wshsc, lu : Integer;
 var xl_nf:string;
 var xl_tf:double;
 var xl_f1000:boolean;
 var avt_prevyear:TDateTime;
 var parameters:string;
begin
with form1 do begin
  _fccount:=0;
  _errorflag:=false;
  _trnlist.clear;
  _dt2:=0;
  _dt1:=1000000;
  _dt11:=1000000;
  avcareer:='';
  avmodel:='';
  rstr:='thread';
  rver:='3';
  ts.create;
  notdir.create; notdate1.create; notdate2.create; nottxt.create; notmobtxt.create; ndirs.create; pp.create;

  for ff:=1 to filelist.Count do begin
   StatusBar1.SimpleText:=': '+ExtractFileName(filelist.getstring(ff))+'.'+ExtractFileExtention(filelist.getstring(ff));
   log.add(': '+ExtractFileName(filelist.getstring(ff))+'.'+ExtractFileExtention(filelist.getstring(ff)));
   ////////
   xl_f1000:=false;
   NomFich := filelist.getstring(ff);
   IIndex := 1;
   XLApp.Connect;
   XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,0);
   WorkBk := XLApp.WorkBooks.Item[IIndex];
   if checkbox5.Checked then wshsc:=WorkBk.WorkSheets.Count
                        else wshsc:=1;
   for wshs:=1 to wshsc do begin
    ts.clear;
    mvdir:='';
    ClearSG;
    WorkSheet := WorkBk.Sheets[wshs] as _WorkSheet;
    WorkSheet.Activate(0);
    if wshsc>1 then log.add(' : "'+WorkSheet.Name+'"');
    WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
    xl_X := XLApp.ActiveCell.Row;
    xl_Y := XLApp.ActiveCell.Column;
      if xl_x>300 then begin
        xl_f1000:=true;
        xl_x1:=3;
        for xl_xx:=1 to xl_x do begin
          if trim(VarToStrDef(worksheet.cells.item[xl_xx,1],''))<>'' then xl_x1:=xl_xx;
        end;
        if xl_x1>2 then xl_x:=xl_x1
                else xl_x:=3;
      end;
      if xl_y>1000 then begin
        xl_f1000:=true;
        xl_y1:=3;
        for xl_yy:=1 to xl_y do begin
          if trim(VarToStrDef(worksheet.cells.item[1,xl_yy],''))<>'' then xl_y1:=xl_yy;
        end;
        if xl_y1>2 then xl_y:=xl_y1
                   else xl_y:=3;
      end;
      if xl_f1000 then Log.add('  ! >300   >1000 !');
    StringGrid1.ColCount := xl_Y;
    StringGrid1.RowCount := xl_X;
    for xl_xx:=1 to xl_x do begin
      for xl_yy:=1 to xl_y do begin
        xl_nf:=worksheet.cells.item[xl_xx,xl_yy].NumberFormat;
        if (xl_nf=':')or(xl_nf=':')or(xl_nf='h:mm')or(xl_nf='hh:mm;@')or(xl_nf=':;@')or(xl_nf=':;@')or(xl_nf='h:mm;@')or(xl_nf='hh:mm;@') then begin
           xl_tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xl_xx,xl_yy]),70);
           if xl_tf=70 then stringgrid1.Cells[xl_yy-1,xl_xx-1]:=trim(VarToStrDef(worksheet.cells.item[xl_xx,xl_yy],''))
                       else stringgrid1.Cells[xl_yy-1,xl_xx-1]:=trim(FormatDateTime('hh:nn',xl_tf));
        end
         else stringgrid1.Cells[xl_yy-1,xl_xx-1]:=trim(VarToStrDef(worksheet.cells.item[xl_xx,xl_yy],''));
      end;
    end;
//   LoadFromXLS(filelist.getstring(ff));
    if StringGrid1.RowCount>5 then begin
    socrmode:=0;
    _stidf:='esrcode';
    avttype:='suburban';
    if pos('t_bus',stringgrid1.Cells[0,0])>0 then begin _stidf:='station_id'; avttype:='bus'; end;
    if pos('t_avia',stringgrid1.Cells[0,0])>0 then begin _stidf:='station_id'; avttype:='plane'; end;
    if pos('t_plane',stringgrid1.Cells[0,0])>0 then begin _stidf:='station_id'; avttype:='plane'; end;
    if pos('t_river',stringgrid1.Cells[0,0])>0 then begin _stidf:='station_id'; avttype:='ship'; end;
    if pos('t_sea',stringgrid1.Cells[0,0])>0 then begin _stidf:='station_id'; avttype:='ship'; end;
    tzone:='';
    if validstr(stringgrid1.Cells[1,0]) then tzone:=' time_zone="'+trim(stringgrid1.Cells[1,0])+'"';
    if strtointe(stringgrid1.Cells[1,1])>0 then avcareer:=' career="'+trim(stringgrid1.Cells[1,1])+'"';
    if strtointe(stringgrid1.Cells[1,2])>0 then avmodel:=' t_model="'+trim(stringgrid1.Cells[1,2])+'"';

      for i:=2 to StringGrid1.ColCount do begin
         ch:=#0;
         if length(StringGrid1.Cells[i,1])>0 then ch:=StringGrid1.Cells[i,1][1];
        for i1:=4 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,i1]:=PrepareTTime(StringGrid1.Cells[i,i1]);
        parameters := '';
        if pos('?',StringGrid1.cells[i,3])>0 then
        begin
            parameters :=  trim(copy(StringGrid1.cells[i,3],pos('?',StringGrid1.cells[i,3])+1, 1000));
            StringGrid1.cells[i,3]:=trim(copy(StringGrid1.cells[i,3],1,pos('?',StringGrid1.cells[i,3])-1));
            //     R_ -   canonicalUID,  ,       
            if pos('R_',ansiuppercase(StringGrid1.cells[i,3]))>0 then
            begin
              if pos('departure_from', parameters )>0 then
                parameters := copy(parameters, pos('departure_from', parameters)+15, 10)
              else if pos('departure', parameters )>0 then
                parameters := copy(parameters, pos('departure', parameters)+10, 10)
              else
                 parameters := '' ;
             if pos('&', parameters )>0 then
             begin
                parameters := copy(parameters,  1, pos('&', parameters) - 1 )
             end;
              StringGrid1.cells[i,3000]:=parameters;
             // log.add('  '+StringGrid1.Cells[i,0]+'.   '+parameters);
            end;
        end;
        while pos('/',StringGrid1.cells[i,3])>0 do StringGrid1.cells[i,3]:=copy(StringGrid1.cells[i,3],pos('/',StringGrid1.cells[i,3])+1,length(StringGrid1.cells[i,3])-pos('/',StringGrid1.cells[i,3]));
       //                if pos('R_',ansiuppercase(StringGrid1.cells[i,3]))>0 then begin
       //                  log.add('  '+StringGrid1.Cells[i,0]+'.       -   uid,  R_!');
       //                  _errorflag:=true;
                       //end;
        if ((ch<>'c')and(ch<>'')and(ch<>'')and(ch<>'')and(ch<>'')and(ch<>'a')) then begin
          if ch<>'' then StringGrid1.cells[i,2]:=vDate(StringGrid1.cells[i,2],StringGrid1.cells[i,0],noshowolddate,true)
                     else StringGrid1.cells[i,2]:=vDate(StringGrid1.cells[i,2],StringGrid1.cells[i,0],noshowolddate,false);
        end;
        if strtointe(trim(StringGrid1.cells[i,3]))<=0 then begin
         if ((ch='')or(ch='')or(ch='')or(ch='')) then begin
          for i1:=4 to 301 do begin
            n1:=i1;
            if form1.StringGrid1.Cells[i,i1]<>'' then break;
          end;
          StringGrid1.cells[i,3]:=StringGrid1.cells[0,i1];
         end;
        end;
      end;
 //     if SaveDialog1.Execute then begin
        p:='';
        o:=0;
          for n:=2 to StringGrid1.ColCount do begin
            ch:=#0;
            if length(StringGrid1.Cells[n,1])>0 then ch:=StringGrid1.Cells[n,1][1];
           if ((StringGrid1.Cells[n,0]<>'')and(StringGrid1.Cells[n,2]<>'_')) then begin
           if pos(ch,flags)>0 then begin
           if ((length(StringGrid1.Cells[n,2])>5)or(ch='')or(ch='c')or(ch='')or(ch='')or(ch='x')or(ch='k')or(ch='')or(ch='')or(ch='')or(ch='')or(ch='a')or(ch='')or(ch='')or(ch='')) then begin
             if o>0 then begin
               ofile.add('    </stations>');
               ofile.add('  </thread>');
             end;
                 o:=1;
                  career:='';
                  cgci:=' ';

                  p_career:='';
                  p_express:='';
                  p_expresssubtype:='';
                  p_tariff:='';
                  kflag:=false;
                  if career_n.count>0 then begin
                    for z:=1 to career_n.count do begin
                     if pos(career_n.getstring(z),trim(form1.StringGrid1.Cells[0,0]))=1 then begin
                        career:=' career="'+career_i.getstring(z)+'"';
                        p_career:=career_i.getstring(z);
                        cgci:='calendar_geobase_country_id="'+career_t.getstring(z)+'"';
                        kflag:=true;
                     end;
                    end;
                  end;
                  getexpress(form1.StringGrid1.Cells[n,0],p_express,p_expresssubtype,p_career,p_tariff);
                  if pos(',',form1.StringGrid1.Cells[0,0])>0 then mvdir:=trim(copy(form1.StringGrid1.Cells[0,0],pos(',',form1.StringGrid1.Cells[0,0])+1,length(form1.StringGrid1.Cells[0,0])-pos(',',form1.StringGrid1.Cells[0,0])));
                   if not kflag then begin
                     if ((StringGrid1.Cells[n,1]='')or(StringGrid1.Cells[n,1]='a')) then begin
                       if strtointe(trim(stringgrid1.Cells[1,1]))<1 then begin
                         log.add('  '+StringGrid1.Cells[n,0]+'.   ( B1).');
                         _errorflag:=true;
                       end;
                     end
                      else log.add('   '+StringGrid1.Cells[n,0]+'.   (?).');
                   end;
                 ofile.add('');
                 _trnlist.add(trim(StringGrid1.Cells[n,0]));
                 if validstr(StringGrid1.Cells[0,3]) then begin
                                                       grph:=trim(StringGrid1.Cells[0,3]);
                                                       gr2per(grph,_periodstart,_periodend);
                                                     end
                                                     else begin
                                                       if avttype='suburban' then begin
                                                         log.add('    !!!   4   !');
                                                         _errorflag:=true;
                                                         _periodstart:='ERROR';
                                                         _periodend:='ERROR';
                                                       end;
                                                     end;
                 if pos('^',StringGrid1.Cells[n,0])>0 then iscombined:=' is_combined="1"'
                                                      else iscombined:='';
                 if ch='' then begin
                   ofile.add('  <thread '+career+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'" startstationparent="'+StringGrid1.Cells[n,3]+'" dates="'+StringGrid1.Cells[n,2]+'"'+tzone+' changemode="cancel" sourcefile="'+ExtractFileName(filelist.getstring(ff))+'" />');
                   o:=0;
                 end;
                 if ch='' then begin
                   ofile.add('  <thread '+career+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'" startstationparent="'+StringGrid1.Cells[n,3]+'" dates="'+StringGrid1.Cells[n,2]+'"'+tzone+' changemode="restore" sourcefile="'+ExtractFileName(filelist.getstring(ff))+'" />');
                   o:=0;
                 end;
                 if ((ch='')or(ch='y')) then begin
                   //     canonicalUID
                   if pos('R_',ansiuppercase(StringGrid1.cells[n,3]))>0 then
                     ofile.add('  <thread '+career+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'" canonical="'+StringGrid1.Cells[n,3]+'" threaddate="'+StringGrid1.Cells[n,3000]+'" period_start="'+StringGrid1.Cells[n,2]+'" weektemplate_end="'+DecDate(StringGrid1.Cells[n,2])+'" changemode="delete"'+tzone+' sourcefile="'+ExtractFileName(filelist.getstring(ff))+'" />')
                   else
                     ofile.add('  <thread '+career+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'" thread="'+StringGrid1.Cells[n,3]+'" period_start="'+StringGrid1.Cells[n,2]+'" weektemplate_end="'+DecDate(StringGrid1.Cells[n,2])+'" changemode="delete"'+tzone+' sourcefile="'+ExtractFileName(filelist.getstring(ff))+'" />');
                   o:=0;
                   if not validstr(StringGrid1.Cells[n,3]) then begin
                     log.add('   '+StringGrid1.Cells[n,0]+'.     thread ( ).');
                     _errorflag:=true;
                   end
                    else begin
                       lu:=_listuid_u.SearchString(StringGrid1.Cells[n,3]);
                       if lu=0 then _listuid_u.add(StringGrid1.Cells[n,3])
                        else begin
                         log.add('   '+StringGrid1.Cells[n,0]+'.  :  uid     ""  !');
                         // _errorflag:=true;
                        end;
                    end;
                   if not comparern(StringGrid1.Cells[n,0],StringGrid1.Cells[n,3]) then begin
                     log.add('   '+StringGrid1.Cells[n,0]+'.     .');
                     _errorflag:=true;
                   end;
                 end;
                 if ch='' then begin
                   ofile.add('  <thread '+career+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'" thread="'+StringGrid1.Cells[n,3]+'" period_start="'+StringGrid1.Cells[n,2]+'" period_end="'+_periodend+'" changemode="refill_calendar"'+tzone+' '+cgci+' sourcefile="'+ExtractFileName(filelist.getstring(ff))+'" />');
                   o:=0;
                   if not validstr(StringGrid1.Cells[n,3]) then begin
                     log.add('   '+StringGrid1.Cells[n,0]+'.     thread ( ).');
                     _errorflag:=true;
                   end;
                   if not comparern(StringGrid1.Cells[n,0],StringGrid1.Cells[n,3]) then begin
                     log.add('   '+StringGrid1.Cells[n,0]+'.     .');
                   end;
                 end;
                 if ch='' then begin
                   ofile.add('  <thread '+' t_type="suburban"'+apifnc('express_type',p_express)+apifnc('express_subtype',p_expresssubtype)+apifnc('career',p_career)+apifnc('tariff_type',p_tariff)+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'"'+iscombined+' startstationparent="'+StringGrid1.Cells[n,3]+'" dates="'+StringGrid1.Cells[n,2]+'" changemode="add" sourcefile="'+ExtractFileName(filelist.getstring(ff))+'"'+tzone+' graph="'+grph+'">');
                   ofile.add('    <stations>');
                   CalcThread(n,o,mNormal);
                 end;
                 if ch='' then begin
                   ofile.add('  <thread '+' t_type="suburban"'+apifnc('express_type',p_express)+apifnc('express_subtype',p_expresssubtype)+apifnc('career',p_career)+apifnc('tariff_type',p_tariff)+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'"'+iscombined+' changemode="insert" '+calcdays2(ansilowercase(StringGrid1.Cells[n,3]),prepdstart(StringGrid1.Cells[n,2]))+' '+prepwtstart(StringGrid1.Cells[n,2])+'period_start="'+prepdstart(StringGrid1.Cells[n,2])+'" period_end="'+_periodend+'" '+cgci+' sourcefile="'+ExtractFileName(filelist.getstring(ff))+'"'+tzone+' graph="'+grph+'">');
                   ofile.add('    <stations>');
                   CalcThread(n,o,mNormal);
                 end;
                 if ch='' then begin
                   ofile.add('  <thread '+' t_type="suburban"'+apifnc('express_type',p_express)+apifnc('express_subtype',p_expresssubtype)+apifnc('career',p_career)+apifnc('tariff_type',p_tariff)+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'"'+iscombined+' startstationparent="'+StringGrid1.Cells[n,3]+'" dates="'+StringGrid1.Cells[n,2]+'" changemode="change" graph="'+grph+'" sourcefile="'+ExtractFileName(filelist.getstring(ff))+'"'+tzone+'>');
                   ofile.add('    <stations>');
                   CalcThread(n,o,mNormal);
                 end;
                 if ch='' then begin
                   //     canonicalUID
                   if pos('R_',ansiuppercase(StringGrid1.cells[n,3]))>0 then
                     ofile.add('  <thread '+' t_type="suburban"'+apifnc('express_type',p_express)+apifnc('express_subtype',p_expresssubtype)+apifnc('career',p_career)+apifnc('tariff_type',p_tariff)+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'"'+iscombined+' canonical="'+StringGrid1.Cells[n,3]+'" threaddate="'+StringGrid1.Cells[n,3000]+'" changemode="replace" sourcefile="'+ExtractFileName(filelist.getstring(ff))+'"'+tzone+'>')
                   else
                     ofile.add('  <thread '+' t_type="suburban"'+apifnc('express_type',p_express)+apifnc('express_subtype',p_expresssubtype)+apifnc('career',p_career)+apifnc('tariff_type',p_tariff)+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'"'+iscombined+' thread="'+StringGrid1.Cells[n,3]+'" changemode="replace" sourcefile="'+ExtractFileName(filelist.getstring(ff))+'"'+tzone+'>');

                   ofile.add('    <stations>');
                   if not validstr(StringGrid1.Cells[n,3]) then begin
                     log.add('   '+StringGrid1.Cells[n,0]+'.     thread ( ).');
                     _errorflag:=true;
                   end;
                   if not comparern(StringGrid1.Cells[n,0],StringGrid1.Cells[n,3]) then begin
                     log.add('   '+StringGrid1.Cells[n,0]+'.     .');
                     _errorflag:=true;
                   end;
                   CalcThread(n,o,mNormal);
                 end;
                 if ch='' then begin
                   ofile.add('  <thread '+career+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'" thread="'+StringGrid1.Cells[n,3]+'" changemode="change_schedule_plan" graph="'+StringGrid1.Cells[n,2]+'" sourcefile="'+ExtractFileName(filelist.getstring(ff))+'" />');
                   o:=0;
                   if not validstr(StringGrid1.Cells[n,3]) then begin
                     log.add('   '+StringGrid1.Cells[n,0]+'.     thread ( ).');
                     _errorflag:=true;
                   end;
                   if not comparern(StringGrid1.Cells[n,0],StringGrid1.Cells[n,3]) then begin
                     log.add('   '+StringGrid1.Cells[n,0]+'.     .');
                   end;
                 end;
                 if ch='' then begin
                    for i1:=4 to 301 do begin
                      if form1.StringGrid1.Cells[n,i1]<>'' then break;
                    end;
                    _ssp:=StringGrid1.cells[0,i1];
                   ofile.add('  <thread '+career+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'" startstationparent="'+_ssp+'" changemode="change_facilities" graph="'+grph+'" sourcefile="'+ExtractFileName(filelist.getstring(ff))+'"'+tzone+'>');
                   ofile.add('    <facilities>');
                   ofile.add('      <facility_period dates="'+StringGrid1.Cells[n,2]+'" facilities="'+StringGrid1.Cells[n,3]+'"/>');
                   ofile.add('    </facilities>');
                   ofile.add('  </thread>');
                   o:=0;
                 end;
                 if ch='' then begin
                    for i1:=4 to 301 do begin
                      if form1.StringGrid1.Cells[n,i1]<>'' then break;
                    end;
                    _ssp:=StringGrid1.cells[0,i1];
                   ofile.add('  <thread '+career+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'" startstationparent="'+_ssp+'" dates="'+StringGrid1.Cells[n,2]+'" changemode="delay" delay_type="cancel"'+_dcr(StringGrid1.Cells[n,3])+' graph="'+grph+'" sourcefile="'+ExtractFileName(filelist.getstring(ff))+'"'+tzone+' />');
                   o:=0;
                 end;
                 if ch='' then begin
                    for i1:=4 to 301 do begin
                      if form1.StringGrid1.Cells[n,i1]<>'' then break;
                    end;
                    _ssp:=StringGrid1.cells[0,i1];
                   ofile.add('  <thread '+career+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'" startstationparent="'+_ssp+'" dates="'+StringGrid1.Cells[n,2]+'" changemode="delay" delay_type="delay"'+_dcr(StringGrid1.Cells[n,3])+_dvl(StringGrid1.Cells[n,3])+' graph="'+grph+'" sourcefile="'+ExtractFileName(filelist.getstring(ff))+'"'+tzone+' />');
                   o:=0;
                 end;
                 if ch='' then begin
                    for i1:=4 to 301 do begin
                      if form1.StringGrid1.Cells[n,i1]<>'' then break;
                    end;
                    _ssp:=StringGrid1.cells[0,i1];
                   ofile.add('  <thread '+career+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'" startstationparent="'+_ssp+'" dates="'+StringGrid1.Cells[n,2]+'" changemode="delay" graph="'+grph+'" sourcefile="'+ExtractFileName(filelist.getstring(ff))+'"'+tzone+' >');
                   ofile.add('    <stations>');
                   CalcThread(n,o,mLate);
                 end;
                 if ch='' then begin
                   s1:=''; s2:=''; s3:=''; s4:='';
                   if ((trim(ansilowercase(StringGrid1.Cells[n,0]))<>'')and(length(trim(StringGrid1.Cells[n,0]))>2)) then begin
                     s1:=trim(ansilowercase(StringGrid1.Cells[n,0]));
                     pp.clear;
                     if pos('+',s1)<>0 then begin
                      ndirs.clear;
                      if pos(',',mvdir)>0 then begin
                        ParseCSVStrEx(@ndirs,mvdir,',');
                        if ndirs.count>0 then begin
                          for e:=1 to ndirs.count do pp.add(ndirs.getstring(e));
                        end;
                      end
                       else pp.add(mvdir);
                      if pos(',',s1)>0 then ParseCSVStrEx(@pp,s1,',')
                                       else pp.add(s1);
                      for e:=1 to pp.count do begin
                        s2:=pp.getstring(e);
                        while pos('+',s2)>0 do delete(s2,pos('+',s2),1);
                        s2:=trim(s2);
                        pp.edit(e,s2);
                      end;
                     end
                      else pp.add(s1);
                     nds:='';
                     for e:=1 to pp.count do nds:=nds+pp.getstring(e)+',';
                     if length(nds)>0 then nds:=copy(nds,1,length(nds)-1);
                   end
                    else nds:=mvdir;
                   if pos('-',StringGrid1.Cells[n,2])>0 then begin
                     s1:=trim(copy(StringGrid1.Cells[n,2],1,pos('-',StringGrid1.Cells[n,2])-1));
                     s2:=trim(copy(StringGrid1.Cells[n,2],pos('-',StringGrid1.Cells[n,2])+1,length(StringGrid1.Cells[n,2])-pos('-',StringGrid1.Cells[n,2])));
                     s1:=vDate(s1,'',false,true);
                     s2:=vDate(s2,'',false,true);
                   end
                    else begin
                      s1:=vDate(StringGrid1.Cells[n,2],'',false,true);
                      s2:=s1;
                    end;
                   if pos('|',StringGrid1.Cells[n,3])>0 then begin
                     s3:=trim(copy(StringGrid1.Cells[n,3],1,pos('|',StringGrid1.Cells[n,3])-1));
                     s4:=trim(copy(StringGrid1.Cells[n,3],pos('|',StringGrid1.Cells[n,3])+1,length(StringGrid1.Cells[n,3])-pos('|',StringGrid1.Cells[n,3])));
                   end
                    else begin
                      s3:=StringGrid1.Cells[n,3];
                      s4:=s3;
                    end;
                   notdir.add(nds);
                   notdate1.add(s1);
                   notdate2.add(s2);
                   nottxt.add(s3);
                   notmobtxt.add(s4);
                   o:=0;
                   if not validstr(StringGrid1.Cells[n,2]) then begin
                     log.add('     ""    ( ).');
                     _errorflag:=true;
                   end;
                   if not validstr(StringGrid1.Cells[n,3]) then begin
                     log.add('     ""    ( ).');
                     _errorflag:=true;
                   end;
                 end;
                 if ((ch='')or(ch='c')) then begin
                   ofile.add('  <thread '+career+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'" thread="'+StringGrid1.Cells[n,3]+'" changemode="change_daystr" daystr="'+StringGrid1.Cells[n,2]+'" sourcefile="'+ExtractFileName(filelist.getstring(ff))+'" />');
                   o:=0;
                   if not validstr(StringGrid1.Cells[n,3]) then begin
                     log.add('   '+StringGrid1.Cells[n,0]+'.     thread ( ).');
                     _errorflag:=true;
                   end;
                 end;
                 if ((ch='')or(ch='a')) then begin
                   avt_start:=prepavstart(StringGrid1.Cells[n,2],StringGrid1.Cells[n,0],avt_prevyear);
                   avt_end:=prepavend(StringGrid1.Cells[n,2],StringGrid1.Cells[n,0],avt_prevyear);
                   ofile.add('  <thread t_type="'+avttype+'"'+avcareer+' number="'+trim(StringGrid1.Cells[n,0])+'" changemode="insert"'+avmodel+' '+calcdays2avia(ansilowercase(StringGrid1.Cells[n,3]),ansilowercase(StringGrid1.Cells[n,2]),ansilowercase(StringGrid1.Cells[n,0]))+' '+avt_start+avt_end+tzone+' calendar_geobase_country_id="225" >');
                   ofile.add('    <stations>');
                   CalcThread(n,o,mAvia);
                 end;
                 if ((ch='x')or(ch='')) then begin
                   ofile.add('  <thread '+career+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'" thread="'+StringGrid1.Cells[n,3]+'" changemode="change_weektemplate" weektemplate_end="" weektemplate="C" sourcefile="'+ExtractFileName(filelist.getstring(ff))+'" '+tzone+'/>');
                   o:=0;
                   if not validstr(StringGrid1.Cells[n,3]) then begin
                     log.add('   '+StringGrid1.Cells[n,0]+'.     thread ( ).');
                     _errorflag:=true;
                   end;
                 end;
                 if ((ch='k')or(ch='')) then begin
                   ofile.add('  <thread '+career+' number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'" thread="'+StringGrid1.Cells[n,3]+'" changemode="change_weektemplate" weektemplate_start="" sourcefile="'+ExtractFileName(filelist.getstring(ff))+'" '+tzone+'/>');
                   o:=0;
                   if not validstr(StringGrid1.Cells[n,3]) then begin
                     log.add('   '+StringGrid1.Cells[n,0]+'.     thread ( ).');
                     _errorflag:=true;
                   end;
                 end;
                 p:=StringGrid1.Cells[n,0];
                    if not ValidNumber(StringGrid1.Cells[n,0]) then begin
                     if ((StringGrid1.Cells[n,1]<>'')and(StringGrid1.Cells[n,1]<>'')and(StringGrid1.Cells[n,1]<>'a')) then begin
                      log.add('   '+StringGrid1.Cells[n,0]+'.    .');
                      _errorflag:=true;
                     end;
                    end;
           end
            else begin
              if StringGrid1.Cells[n,2]<>'N' then begin
               log.add('   '+StringGrid1.Cells[n,0]+'.   .');
               _errorflag:=true;
              end
               else begin
                if not noshowolddate then log.add(' !   '+StringGrid1.Cells[n,0]+'  !');
               end;
            end;
           end
            else begin
              if pos(ch,'yc')<=0 then begin
              log.add('   '+StringGrid1.Cells[n,0]+'.     .');
              _errorflag:=true;
              end;
            end;
           end;
          end;
        if o>0 then begin
               ofile.add('    </stations>');
               ofile.add('  </'+rstr+'>');
        end;
    end;
    ///
   Application.ProcessMessages;
   end; //wshs
    ///
  ProgressBar1.Position:=ff;
  Application.ProcessMessages;
  XLApp.Quit;
  XLApp.Disconnect;
  end; //ff.count

  if _dt1=1000000 then _dt1:=_dt11;
  if _dt1=1000000 then _dt1:=date;
  if _dt2=0 then _dt2:=date;
  if notdir.count>0 then begin
   ofile.add('');
   ofile.add('  <notices>');
   for e:=1 to notdir.count do begin
    pp.clear;
    ParseCSVStrEx(@pp,notdir.getstring(e),',');
    if pp.count>0 then begin
    ofile.add('    <notice start_date="'+delquot1(notdate1.getstring(e))+'" end_date="'+delquot1(notdate2.getstring(e))+'" type="change">');
    ofile.add('      <directions>');
    for e1:=1 to pp.count do begin
     ofile.add('        <direction>'+delquot1(pp.getstring(e1))+'</direction>');
    end;
    ofile.add('      </directions>');
    ofile.add('      <title>'+delquot1(nottxt.getstring(e))+'</title>');
    ofile.add('      <text>'+delquot1(nottxt.getstring(e))+'</text>');
    ofile.add('      <mobile_text>'+delquot1(notmobtxt.getstring(e))+'</mobile_text>');
    ofile.add('    </notice>');
    end
     else ShowMessage('         ""!');
   end;
   ofile.add('  </notices>');
  end;
  ofile.add('');
  ofile.add('</channel>');
  ProgressBar1.Position:=0;
  DateTimeToString(d,'yyyy-mm-dd hh:nn:ss',date+time);
  DateTimeToString(d1,'yyyy-mm-dd',_dt1);
  DateTimeToString(d11,'yyyy-mm-dd',_dt11);
  DateTimeToString(d2,'yyyy-mm-dd',_dt2);
  ofile.insert(1,'<channel date="'+d+'" chgcount="'+inttostr(_trnlist.count)+'" fccount="'+inttostr(_fccount)+'" startdate="'+d1+'" enddate="'+d2+'" prog="chg2xml" progver="'+pversion+'" ver="'+rver+'">');
  ofile.insert(1,'');
  ofile.insert(1,'<?xml version="1.0" encoding="Windows-1251"?>');
  if _trnlist.count=0 then _errorflag:=true;
        if _errorflag then begin
          ofile.savetofile(ofilename+'.bad.tmp');
          StatusBar1.SimpleText:='   !';
          form3.listbox1.items.clear;
          for i:=1 to log.count do form3.ListBox1.Items.Add(log.getstring(i));
          form3.ListBox1.Items.add(' '+inttostr(_trnlist.count)+' ,  '+d1+' ('+d11+')  '+d2+'.');
          form3.ShowModal;
          DeleteFile(ofilename+'.bad.tmp');
        end
         else begin
           _trnlist.savetofile(ofilename+'.trnlist.tmp');
           StatusBar1.SimpleText:='  !  '+inttostr(_trnlist.count)+' ';
           showmessage(' !'+#13#10+' '+inttostr(_trnlist.count)+'  ('+inttostr(_fccount)+' ) -  '+d1+' ('+d11+')  '+d2+'.');
           ofile.savetofile(ofilename);
           DeleteFile(ofilename+'.trnlist.tmp');
          form3.listbox1.items.clear;
          for i:=1 to log.count do form3.ListBox1.Items.Add(log.getstring(i));
          form3.ListBox1.Items.add(' '+inttostr(_trnlist.count)+' ,  '+d1+'  '+d2+'.');
          form3.ShowModal;
          exit;
         end;
//  end;
//  end;
//  end;
  notdir.free; notdate1.free; notdate2.free; nottxt.free; notmobtxt.free; ndirs.free; pp.free;
  ts.free;
end;
end;

procedure TForm1.Button1Click(Sender: TObject);
 var i,n:integer;
 var s:string;
begin
{  n:=Memo1.Lines.Count-1;
  for i:=0 to n do begin
      s:=memo1.lines.strings[i];
      s:=CalcDays(s);
      memo1.Lines.add(memo1.Lines.Strings[i]+' => '+s);
  end;}
end;

procedure TForm1.FormCreate(Sender: TObject);
  var ts,u:AF_Types.TStrings;
  var s,s1:string;
  var i:integer;
begin
  form1.Caption:=form1.Caption+' '+pversion;
  career_n.create; career_i.create; career_t.create;
  expr_id.create; expr_type.create; expr_sub.create; expr_career.create; expr_tariff.create;
  _grname.create; _grps.create; _grpe.create;
  log.Create;
  ofile.create;
  _trnlist.create;
  f1list.create;
  _listuid_u.create;
  _stidf:='esrcode';
//  datetimepicker1.DateTime:=Date+Time;
  ts.create;
  u.create;
  ts.loadfromfile(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\graph.ini');
  if ts.count>0 then begin
   for i:=1 to ts.count do begin
     ParseCSVStrEx(@u,ts.getstring(i),';');
     if u.count>2 then begin
      if ((ValidStr(u.getstring(1)))and(ValidStr(u.getstring(2)))and(ValidStr(u.getstring(3)))) then begin
        _grname.add(ansilowercase(u.getstring(1)));
        _grps.add(u.getstring(2));
        _grpe.add(u.getstring(3));
      end;
     end;
   end;
  end;
  if _grname.count<1 then begin
    ShowMessage('  graph.ini    !');
    halt(1);
  end;
  ts.free; u.free;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  log.free;
  ofile.free;
  _trnlist.free;
  f1list.free;
  career_n.free; career_i.free; career_t.free;
  expr_id.free; expr_type.free; expr_sub.free; expr_career.free; expr_tariff.free;
  _grname.free; _grps.free; _grpe.free;
  _listuid_u.free;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
//  DateTimePicker1.Enabled:=checkbox1.checked;
end;

procedure DirProc(Dir: string; IncludeSubDirs: Boolean);
var
 SearchRec: TSearchRec;
 FindResult,n: Integer;
 fn,fe:string;
begin
 Dir:=IncludeTrailingBackslash(Dir);
// form1.listbox1.items.add('D: '+Dir);
 FindResult:=FindFirst(Dir+'*.*', faAnyFile, SearchRec);
 try
  while FindResult = 0 do with SearchRec do begin
   if (Attr and faDirectory) <> 0 then begin
    if IncludeSubDirs and (Name<>'.') and (Name<>'..') then
      DirProc(Dir+Name, IncludeSubDirs);
    end else begin
      fn:=ansilowercase(ExtractFileName(name));
      fe:=ansilowercase(ExtractFileExtention(name));
      if ((fe='xls')or(fe='xlsx')) then begin
       if (fn<>'0') then begin
        f1list.add(dir+name);
       end;
      end;
    end;
    FindResult:=FindNext(SearchRec);
  end;
 finally
  FindClose(SearchRec);
 end;
end;

{procedure oldC;
 var ts:AF_Types.TStrings;
 var t:TextFile;
 var p,s,d,d1,d11,d2,career,rstr,rver:string;
 var i,i1,ff,n,n1,o:integer;
 var sdf:string;
begin
with form1 do begin
  _fccount:=0;
  _errorflag:=false;
  _trnlist.clear;
  _dt2:=0;
  _dt1:=1000000;
  _dt11:=1000000;
 rstr:='thread';
 rver:='2';
  ts.create;
  sdf:='c:\';
  ofile.clear;
  if SelectDirectory(' ','',sdf) then begin
   savedialog1.InitialDir:=ExtractDirPath(sdf);
   f1list.clear;
   DirProc(sdf,true);
   savedialog1.FileName:='cumulative.xml';
  if SaveDialog1.Execute then begin
  if f1list.Count>0 then begin
  ProgressBar1.Max:=f1list.Count;
  log.clear;
  ofile.clear;
//  ofile.add('<?xml version="1.0" encoding="Windows-1251"?>');
//  ofile.add('');
//  DateTimeToString(d,'yyyy-mm-dd hh:nn:ss',date+time);
//  ofile.add('<channel type="change" date="'+d+'" prog="chg2xml" progver="'+pversion+'" ver="'+rver+'">');

  for ff:=1 to f1list.Count do begin
    StatusBar1.SimpleText:=': '+ExtractFileName(f1list.getstring(ff))+'.'+ExtractFileExtention(f1list.getstring(ff));
    log.add(': '+ExtractFileName(f1list.getstring(ff))+'.'+ExtractFileExtention(f1list.getstring(ff)));
    ////////
    ts.clear;
    ClearSG;
    LoadFromXLS(f1list.getstring(ff));
    ///
    if StringGrid1.RowCount>5 then begin
      for i:=2 to StringGrid1.ColCount do begin
        for i1:=4 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,i1]:=PrepareTTime(StringGrid1.Cells[i,i1]);
        while pos('/',StringGrid1.cells[i,3])>0 do StringGrid1.cells[i,3]:=copy(StringGrid1.cells[i,3],pos('/',StringGrid1.cells[i,3])+1,length(StringGrid1.cells[i,3])-pos('/',StringGrid1.cells[i,3]));
        StringGrid1.cells[i,2]:=vDate(StringGrid1.cells[i,2],StringGrid1.cells[i,0]);
        if length(StringGrid1.cells[i,3])<2 then begin
          for i1:=4 to 301 do begin
            n1:=i1;
            if form1.StringGrid1.Cells[i,i1]<>'' then break;
          end;
          StringGrid1.cells[i,3]:=StringGrid1.cells[0,i1];
        end;
      end;
 //     if SaveDialog1.Execute then begin
        p:='';
        o:=0;
          for n:=2 to 301 do begin
           if ((StringGrid1.Cells[n,0]<>'')and(StringGrid1.Cells[n,2]<>'_')) then begin
           if ((StringGrid1.Cells[n,1]='')or(StringGrid1.Cells[n,1]='')or(StringGrid1.Cells[n,1]='')or(StringGrid1.Cells[n,1]='')) then begin
           if (length(StringGrid1.Cells[n,2])>5)or(StringGrid1.Cells[n,1]='') then begin
             if o>0 then begin
               ofile.add('</'+rstr+'>');
             end;
                 o:=1;
//                  if pos('msk',form1.StringGrid1.Cells[0,0])>0 then form1.ComboBox1.ItemIndex:=0;
//                  if pos('spb',form1.StringGrid1.Cells[0,0])>0 then form1.ComboBox1.ItemIndex:=1;
                  career:='';
                  if pos('cppk',form1.StringGrid1.Cells[0,0])>0 then career:=' career="153"';
                  if pos('szppk',form1.StringGrid1.Cells[0,0])>0 then career:=' career="1332"';
                 ofile.add('');
                 _trnlist.add(trim(StringGrid1.Cells[n,0]));
                 if StringGrid1.Cells[n,1]='' then begin
                   ofile.add('<'+rstr+career+' type="etrain" number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'" startstationparent="'+StringGrid1.Cells[n,3]+'" dates="'+StringGrid1.Cells[n,2]+'" changemode="cancel" />');
                   ofile.add('');
                   o:=0;
                 end;
                 if StringGrid1.Cells[n,1]='' then begin
                   ofile.add('<'+rstr+career+' type="etrain" number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'" startstationparent="'+StringGrid1.Cells[n,3]+'" dates="'+StringGrid1.Cells[n,2]+'" changemode="add">');
                   CalcThread(n,o);
                 end;
                 if StringGrid1.Cells[n,1]='' then begin
                   ofile.add('<'+rstr+career+' type="etrain" number="'+trim(numbprep(StringGrid1.Cells[n,0]))+'" startstationparent="'+StringGrid1.Cells[n,3]+'" dates="'+StringGrid1.Cells[n,2]+'" changemode="change">');
                   CalcThread(n,o);
                 end;
                 if StringGrid1.Cells[n,1]='' then begin
//                   ofile.add('<'+rstr+career+' type="etrain" number="'+trim(StringGrid1.Cells[n,0])+'" thread="'+StringGrid1.Cells[n,3]+'" changemode="replace">');
//                   CalcThread(n,o);
                   o:=0;
                 end;
                 p:=StringGrid1.Cells[n,0];
           end
            else begin
              if StringGrid1.Cells[n,2]<>'N' then begin
               log.add('   '+StringGrid1.Cells[n,0]+'.   .');
               _errorflag:=true;
              end
               else log.add(' !   '+StringGrid1.Cells[n,0]+'  !');
            end;
           end
            else begin
              log.add('   '+StringGrid1.Cells[n,0]+'.     .');
              _errorflag:=true;
            end;
           end;
          end;
        if o>0 then begin
               ofile.add('</'+rstr+'>');
        end;
  //    end;
    end;
    ///
  ProgressBar1.Position:=ff+1;
  Application.ProcessMessages;
  end;
  if _dt1=1000000 then _dt1:=_dt11;
  if _dt1=1000000 then _dt1:=date;
  if _dt2=0 then _dt2:=date;
  ofile.add('');
  ofile.add('</channel>');
  ProgressBar1.Position:=0;
  DateTimeToString(d,'yyyy-mm-dd hh:nn:ss',date+time);
  DateTimeToString(d1,'yyyy-mm-dd',_dt1);
  DateTimeToString(d11,'yyyy-mm-dd',_dt11);
  DateTimeToString(d2,'yyyy-mm-dd',_dt2);
  ofile.insert(1,'<channel date="'+d+'" chgcount="'+inttostr(_trnlist.count)+'" fccount="'+inttostr(_fccount)+'" startdate="'+d1+'" enddate="'+d2+'" prog="chg2xml" progver="'+pversion+'" ver="'+rver+'">');
  ofile.insert(1,'');
  ofile.insert(1,'<?xml version="1.0" encoding="Windows-1251"?>');
  if _trnlist.count=0 then _errorflag:=true;
        if _errorflag then begin
          ofile.savetofile(SaveDialog1.FileName+'.bad.tmp');
          StatusBar1.SimpleText:='   !';
          form3.listbox1.items.clear;
          for i:=1 to log.count do form3.ListBox1.Items.Add(log.getstring(i));
          form3.ListBox1.Items.add(' '+inttostr(_trnlist.count)+' ,  '+d1+' ('+d11+')  '+d2+'.');
          form3.ShowModal;
          DeleteFile(SaveDialog1.FileName+'.bad.tmp');
        end
         else begin
           _trnlist.savetofile(SaveDialog1.FileName+'.trnlist.tmp');
           StatusBar1.SimpleText:='  !  '+inttostr(_trnlist.count)+' ';
           showmessage(' !'+#13#10+' '+inttostr(_trnlist.count)+'  ('+inttostr(_fccount)+' ) -  '+d1+' ('+d11+')  '+d2+'.');
           ofile.savetofile(SaveDialog1.FileName);
           DeleteFile(SaveDialog1.FileName+'.trnlist.tmp');
          form3.listbox1.items.clear;
          for i:=1 to log.count do form3.ListBox1.Items.Add(log.getstring(i));
          form3.ListBox1.Items.add(' '+inttostr(_trnlist.count)+' ,  '+d1+'  '+d2+'.');
          form3.ShowModal;
         end;
  end;
  end;
  end;
  ts.free;
end;
end; }


procedure TForm1.SpeedButton1Click(Sender: TObject);
  var filelist:AF_Types.TStrings;
  var i:integer;
begin
  filelist.create;
  LoadCareers;
  LoadExpress;
  _listuid_u.clear;
  if OpenDialog1.Execute then begin
   savedialog1.InitialDir:=ExtractDirPath(opendialog1.FileName);
   savedialog1.FileName:=extractfilename(opendialog1.FileName)+'.xml';
  if SaveDialog1.Execute then begin
  log.clear;
  ofile.clear;
  for i:=0 to opendialog1.Files.Count-1 do filelist.add(opendialog1.Files.Strings[i]);
  ProgressBar1.Max:=filelist.Count;
  MainProc(@filelist,SaveDialog1.FileName,'yxkac',false);

  end;
  end;
//  if SaveDialog1.files.Count>0 then begin
  filelist.free;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
  var sdf:string;
  var i:integer;
  var filelist:AF_Types.TSTrings;
begin
  filelist.create;
  LoadCareers;
  LoadExpress;
  _listuid_u.clear;
  sdf:='c:\';
  if SelectDirectory(' ','',sdf) then begin
   savedialog1.InitialDir:=ExtractDirPath(sdf);
   f1list.clear;
   DirProc(sdf,true);
   savedialog1.FileName:='cumulative.xml';
  if SaveDialog1.Execute then begin
  if f1list.Count>0 then begin
    log.clear;
    ofile.clear;
    for i:=1 to f1list.Count do filelist.add(f1list.getstring(i));
//    filelist.savetofile('c:\1\ 20\1.txt');
    ProgressBar1.Max:=filelist.Count;
    MainProc(@filelist,SaveDialog1.FileName,'',true);
  end;
  end;
 end;
// filelist.savetofile('c:\1.fls');
 filelist.free;
 showmessage('');
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  form1.Caption:='.:  XML-  '+pversion;
end;

end.
