unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, StdCtrls, ExtCtrls, OleServer, ExcelXP, AF_Proc, AF_Types, Grids, FileCtrl;

type
  TForm1 = class(TForm)
    LabeledEdit1: TLabeledEdit;
    SpeedButton1: TSpeedButton;
    OpenDialog1: TOpenDialog;
    XLApp: TExcelApplication;
    StringGrid1: TStringGrid;
    SpeedButton2: TSpeedButton;
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure StringGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure StringGrid1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SpeedButton2Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure StringGrid1DblClick(Sender: TObject);
    procedure StringGrid1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormDestroy(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ActivateHintNOW(x,y: Integer; hinttxt:string);
  end;

var
  Form1: TForm1;
  f1list,typelist,stcodes,sttypes,vetlist,chgcolored:AF_Types.TStrings;
  editflag,kflg:boolean;
  lastd,newd:string;
  hintwnd:THintWindow;
  wshn: integer;

const
  vers: string = '1.14';

procedure ClearSG(sg:TStringGrid);
function GetFirstStation(n:integer):integer;
function GetLastStation(n:integer):integer;
procedure tohm(s:string; var h,m:integer);
function fromhm(h,m:integer):string;
procedure inchm(var h,m:integer; t:integer);
procedure ReloadStations;
function prepDlist(s:string):string;


implementation

uses unit2, Unit6;

{$R *.dfm}

function prepDlist(s:string):string;
 var n:integer;
begin
 repeat
  n:=pos(',0',s);
  if n>0 then insert(' ',s,n+1);
 until n<1;
 repeat
  n:=pos(',1',s);
  if n>0 then insert(' ',s,n+1);
 until n<1;
 repeat
  n:=pos(',2',s);
  if n>0 then insert(' ',s,n+1);
 until n<1;
 repeat
  n:=pos(',3',s);
  if n>0 then insert(' ',s,n+1);
 until n<1;
 repeat
  n:=pos(',4',s);
  if n>0 then insert(' ',s,n+1);
 until n<1;
 repeat
  n:=pos(',5',s);
  if n>0 then insert(' ',s,n+1);
 until n<1;
 repeat
  n:=pos(',6',s);
  if n>0 then insert(' ',s,n+1);
 until n<1;
 repeat
  n:=pos(',7',s);
  if n>0 then insert(' ',s,n+1);
 until n<1;
 repeat
  n:=pos(',8',s);
  if n>0 then insert(' ',s,n+1);
 until n<1;
 repeat
  n:=pos(',9',s);
  if n>0 then insert(' ',s,n+1);
 until n<1;
 result:=s;
end;

procedure TForm1.ActivateHintNOW(x,y: Integer; hinttxt:string);
var rect:TRect;
begin
  if hintTxt <> '' then
  begin
    rect := hintWnd.CalcHintRect( Screen.Width, hinttxt, nil);
    rect.Left := rect.Left + x;
    rect.Right := rect.Right + x;
    rect.Top := rect.Top + y;
    rect.Bottom := rect.Bottom + y;
    hintWnd.ActivateHint( rect, hinttxt);
  end;
end;

function PrepareStr1(s:string):string;
 var l,n,m:integer;
 var f:boolean;
 var s1,s2:string;
begin
  while pos('"',s)>0 do s[pos('"',s)]:='`';
  if s='?' then s:='-';
  if s='--' then s:='-';
  if s='---' then s:='-';
  if s='----' then s:='-';
  if s='-----' then s:='-';
  if s=':' then s:='';
  if s=#133 then s:='';
  if s='.' then s:='';
  if s='..' then s:='';
  if s='...' then s:='';
  if s='....' then s:='';
  if s='.....' then s:='';
  if s='......' then s:='';
  if s='' then s:='';
  l:=length(s);
  s:=trim(s);
  s:=StrReplace(s,'  ',' ');
  s:=StrReplace(s,'/ ','/');
  s:=StrReplace(s,' /','/');
  s:=StrReplace(s,'@ ','@');
  s:=StrReplace(s,' @','@');
  s2:='';
  if pos('@',s)>0 then begin
    s1:=copy(s,1,pos('@',s)-1);
    s2:=copy(s,pos('@',s),length(s)-pos('@',s)+1);
  end
   else s1:=s;
   s1:=StrReplace(s1,'O','0');
   s1:=StrReplace(s1,'','0');
   s1:=StrReplace(s1,'o','0');
   s1:=StrReplace(s1,'','0');
   s:=s1+s2;
  s:=StrReplace(s,',','.');
  s:=StrReplace(s,':','.');
  n:=pos('.',s);
  if (n=l-1)and(n>0) then s:=s+'0';
  if n=0 then begin
    f:=false;
    if s='0' then f:=true;
    if s='00' then f:=true;
    if StrToIntE(trim(s))>0 then f:=true;
    if f then s:=s+'.00';
  end;
  if s<>'-' then s:=StrReplace(s,'-','.');
  l:=length(s);
  n:=pos(':',s);
  if n=2 then s:='0'+s;
  result:=s;
end;

function isNumber(s:string):boolean;
 var i,n:integer;
begin
  n:=0;
  Val(s,i,n);
  if n=0 then result:=true
         else result:=false;
end;

procedure xhm(var h,m:integer);
  begin
    if m>59 then begin
      inc(h,(m div 60));
      m:=m mod 60;
    end;
    if h>23 then begin
     h:=h-24;
    end;
  end;

procedure inchm(var h,m:integer; t:integer);
  begin
    inc(m,t);
    xhm(h,m);
  end;

procedure tohm(s:string; var h,m:integer);
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    s:=strreplace(s,'-',':');
    if pos(':',s)>0 then begin
      h:=StrToIntE(copy(s,1,pos(':',s)-1));
      m:=StrToIntE(copy(s,pos(':',s)+1,100));
    end;
  end;

function prephm(s:string):string;
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    s:=strreplace(s,'-',':');
    result:=s;
  end;

function fromhm(h,m:integer):string;
  begin
    xhm(h,m);
    if h>9 then begin
             if m>9 then fromhm:=inttostr(h)+'.'+inttostr(m)
                    else fromhm:=inttostr(h)+'.0'+inttostr(m);
           end
           else begin
             if m>9 then fromhm:=''+inttostr(h)+'.'+inttostr(m)
                    else fromhm:=''+inttostr(h)+'.0'+inttostr(m);
           end;
  end;


function GetFirstStation(n:integer):integer;
  var i,l:integer;
begin
  for i:=4 to form1.StringGrid1.RowCount-1 do begin
    if ValidStr(form1.StringGrid1.Cells[n,i]) then begin
      l:=i;
      break;
    end;
  end;
  result:=l;
end;

function GetLastStation(n:integer):integer;
  var i,l:integer;
begin
  for i:=form1.StringGrid1.RowCount-1 downto 4 do begin
    if ValidStr(form1.StringGrid1.Cells[n,i]) then begin
      l:=i;
      break;
    end;
  end;
  result:=l;
end;

function plPrep(s:string):string;
begin
  if pos('@',s)>0 then s:=trim(copy(s,1,pos('@',s)-1));
  while pos('^',s)>0 do delete(s,pos('^',s),1);
  while pos('*',s)>0 do delete(s,pos('*',s),1);
  s:=trim(s);
  if pos('#',s)=1 then s:='-';
  result:=s;
end;

procedure LoadXLS(fn:string);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
WorkSheet1 : _WorkSheet;
i,K, R, X, Y, xx, yy, x1, y1 : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf:string;
tf:double;
s:string;
h,m,lh:integer;
f1000:boolean;
begin
with form1 do begin
f1000:=false;
typelist.clear;
vetlist.clear;
NomFich := fn;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
wshn:=1;
form6.combobox1.Items.clear;
if WorkBk.WorkSheets.Count>1 then begin
 for i:=1 to WorkBk.WorkSheets.Count do begin
  WorkSheet1 := WorkBk.WorkSheets.Get_Item(i) as _WorkSheet;
  form6.combobox1.Items.add(WorkSheet1.Name);
 end;
 form6.combobox1.itemindex:=0;
 form6.showmodal;
end;
WorkSheet := WorkBk.Sheets[wshn] as _WorkSheet;
WorkSheet.Activate(0);
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
  if x>300 then begin
    f1000:=true;
    x1:=3;
    for xx:=1 to x do begin
      if trim(VarToStrDef(worksheet.cells.item[xx,1],''))<>'' then x1:=xx;
    end;
    if x1>2 then x:=x1
            else x:=3;
  end;
  if y>1000 then begin
    f1000:=true;
    y1:=3;
    for yy:=1 to y do begin
      if trim(VarToStrDef(worksheet.cells.item[1,yy],''))<>'' then y1:=yy;
    end;
    if y1>2 then y:=y1
            else y:=3;
  end;
  if f1000 then ShowMessage('!   '+extractfilename(fn)+' >300   >1000 !');
if (x>2)and(y>2) then begin
stringgrid1.ColCount:=y;
stringgrid1.RowCount:=x;
chgcolored.clear;
for m:=1 to y do chgcolored.add('0');
for m:=1 to x do typelist.add('1');
for m:=1 to x do vetlist.add('0');
for xx:=1 to x do begin
  for yy:=1 to y do begin
    s:='';
    nf:=worksheet.cells.item[xx,yy].NumberFormat;
    if (nf=':')or(nf=':')or(nf='h:mm')or(nf='hh:mm;@')or(nf=':;@')or(nf=':;@')or(nf='h:mm;@')or(nf='hh:mm;@') then begin
       tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xx,yy]),70);
       s:=trim(VarToStrDef(worksheet.cells.item[xx,yy],''));
       if length(s)>2 then begin
         if pos('/',s)=0 then s:=FormatDateTime('hh:nn',tf);
       end;
    end
     else begin
       if ((xx>4)and(yy>2)) then s:=PrepareStr1(Trim(VarToStrDef(worksheet.cells.item[xx,yy],'')))
                            else s:=Trim(VarToStrDef(worksheet.cells.item[xx,yy],''));
     end;
    StringGrid1.Cells[yy-1,xx-1]:=s;
//       worksheet.cells.item[xx,yy].NumberFormat:='@';
  end;
  m:=stcodes.SearchString(StringGrid1.Cells[0,xx-1]);
  if m>0 then begin
  h:=strtointe(sttypes.getstring(m));
  if not (h in [1..2]) then typelist.edit(xx,'0');
//  showmessage(StringGrid1.Cells[0,xx-1]+' '+inttostr(stcodes.SearchString(StringGrid1.Cells[0,xx-1]))+' '+inttostr(h));
  end;
  Application.ProcessMessages;
end;
end;
//WorkBk.Close(true,EmptyParam,EmptyParam,0);
WorkBk.Close(false,EmptyParam,EmptyParam,0);
XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;

for x:=2 to StringGrid1.ColCount-1 do begin
 xx:=GetFirstStation(x);
 yy:=GetLastStation(x);
 if yy>xx then begin
   for y:=xx to yy do begin
     if trim(stringgrid1.cells[x,y])='' then vetlist.edit(y+1,inttostr(strtointe(vetlist.getstring(y+1))+1));
   end;
 end;
end;

stringgrid1.Repaint;
end;
end;

function PrepT(s:string):string;
 var s1,s2:string;
begin
  s1:=''; s2:='';
  if pos('@',s)>1 then begin
   s1:=copy(s,1,pos('@',s)-1);
   s2:=copy(s,pos('@',s),length(s)-pos('@',s)+1);
  end
   else s1:=s;
  while pos('.',s1)>0 do s1[pos('.',s1)]:=':';
  result:=s1+s2;
end;

procedure SaveXLS(fn:string);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
K, R, X, Y, xx, yy : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf:string;
tf:double;
s:string;
var h,m,lh:integer;
begin
with form1 do begin
typelist.clear;
vetlist.clear;
NomFich := fn;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
WorkSheet := WorkBk.Sheets[wshn] as _WorkSheet;
WorkSheet.Activate(0);
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
//X := XLApp.ActiveCell.Row;
//Y := XLApp.ActiveCell.Column;
for x:=0 to form1.StringGrid1.RowCount-1 do begin
 for y:=0 to form1.StringGrid1.ColCount-1 do begin
   worksheet.cells.item[x+1,y+1].NumberFormat:='@';
    if ((x>3)and(y>1)) then worksheet.cells.item[x+1,y+1]:=prept(trim(form1.StringGrid1.Cells[y,x]))
                       else worksheet.cells.item[x+1,y+1]:=trim(form1.StringGrid1.Cells[y,x])
 end;
end;
for y:=0 to form1.StringGrid1.ColCount-1 do begin
 if chgcolored.getstring(y+1)='1' then begin
  worksheet.cells.item[1,y+1].Interior.Color:=RGB(52,201,36);
 end;
end;

WorkBk.Close(true,EmptyParam,EmptyParam,0);
//WorkBk.Close(false,EmptyParam,EmptyParam,0);
XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;

end;
end;



procedure LoadDirectionsXLS(fn:string);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
K, R, X, Y, xx, yy : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf:string;
tf:double;
s:string;
var h,m,lh:integer;
begin
with form1 do begin
NomFich := fn;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
if (x>2)and(y>2) then begin
for xx:=1 to x do begin
  for yy:=1 to 3 do begin
    if StrToIntE(Trim(VarToStrDef(worksheet.cells.item[xx,1],'')))<>0 then begin
     if stcodes.SearchString(Trim(VarToStrDef(worksheet.cells.item[xx,1],'')))<=0 then begin
//       if not (StrToIntE(Trim(VarToStrDef(worksheet.cells.item[xx,1],''))) in [1..2]) then begin
        stcodes.add(Trim(VarToStrDef(worksheet.cells.item[xx,1],'')));
        sttypes.add(Trim(VarToStrDef(worksheet.cells.item[xx,3],'')))
//       end;
     end;
    end;
  end;
  Application.ProcessMessages;
end;
end;
WorkBk.Close(false,EmptyParam,EmptyParam,0);
XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;
end;
end;


procedure DirProc(Dir: string);
var
 SearchRec: TSearchRec;
 FindResult,n: Integer;
 IncludeSubDirs: Boolean;
 fn,fe:string;
begin
 includesubdirs:=true;
 Dir:=IncludeTrailingBackslash(Dir);
 FindResult:=FindFirst(Dir+'*.*', faAnyFile, SearchRec);
 try
  while FindResult = 0 do with SearchRec do begin
   if (Attr and faDirectory) <> 0 then begin
    if IncludeSubDirs and (Name<>'.') and (Name<>'..') then
      DirProc(Dir+Name);
    end else begin
      fn:=ansilowercase(ExtractFileName(name));
      fe:=ansilowercase(ExtractFileExtention(name));
      if ((fe='xls')or(fe='xlsx')or(fe='xlsx')) then begin
        f1list.add(dir+name);
      end;
    end;
    FindResult:=FindNext(SearchRec);
  end;
 finally
  FindClose(SearchRec);
 end;
end;



procedure TForm1.SpeedButton1Click(Sender: TObject);
 var i:integer;
 var cl:boolean;
begin
  cl:=false;
  if editflag then begin
    case MessageDlg(' ?',mtConfirmation,[mbYes,mbNo],0) of
      mrYes: begin
              SaveXLS(LabeledEdit1.Text);
              cl:=true;
             end;
      mrNo: cl:=true;
    end;
  end
   else cl:=true;

 if cl then begin
  ReloadStations;
  if opendialog1.execute then begin
   ClearSG(stringgrid1);
   LabeledEdit1.Text:=OpenDialog1.FileName;
   LoadXLS(OpenDialog1.FileName);
   editflag:=false;
   showmessage(' !');
   stringgrid1.setfocus;
  end;
 end;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
   LabeledEdit1.Width:=form1.Width-123;
   speedbutton1.Left:=form1.Width-96;
   speedbutton2.Left:=form1.Width-60;
   stringgrid1.Width:=form1.Width-43;
   stringgrid1.Height:=form1.height-103;
end;

procedure LoadDirections;
 var i:integer;
 var t:textfile;
begin
  stcodes.clear;
  sttypes.clear;
  f1list.clear;
  DirProc(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\directions');
   if f1list.count>0 then begin
     for i:=1 to f1list.count do begin
       LoadDirectionsXLS(f1list.getstring(i));
     end;
     assignfile(t,DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\stations.csv');
     rewrite(t);
       if stcodes.count>0 then begin
         for i:=1 to stcodes.count do WriteLn(t,stcodes.getstring(i)+';'+sttypes.getstring(i));
       end;
     closefile(t);
     ShowMessage('  !');
   end
    else begin
      ShowMessage('   !');
      halt(1);
    end;
end;

procedure ReloadStations;
 var t:textfile;
 var s,s1:string;
begin
  stcodes.clear;
  sttypes.clear;
  if fileexists(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\stations.csv') then begin
     assignfile(t,DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\stations.csv');
     reset(t);
      while not eof(t) do begin
        ReadLn(t,s);
        if pos(';',s)>0 then begin
          s1:=copy(s,pos(';',s)+1,length(s)-pos(';',s));
          s:=copy(s,1,pos(';',s)-1);
           if (StrToInte(trim(s))>0) then begin
             stcodes.add(s);
             sttypes.add(s1);
           end;
        end;
      end;
     closefile(t);
  end;
  if stcodes.count=0 then begin
   ShowMessage('      (stations.csv)!');
   halt(1);
//     s:='c:\';
//    if SelectDirectory('  ','',s) then begin
//      LoadDirections;
//    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
//  DecimalSeparator:='.';
  hintwnd:= THintWindow.create(self);
  Application.ShowHint:=true;
  StringGrid1.ShowHint := True;
  editflag:=false;
  lastd:='';
  newd:='';
  kflg:=true;
  form1.Caption:=form1.caption+' '+vers;
  f1list.create;
  stcodes.create;
  sttypes.create;
  typelist.create;
  vetlist.create;
  chgcolored.create;
//  ReloadStations;
end;

procedure Date2TS(s:string;ts:AF_Types.PStrings);
 var s1:string;
begin
  ts.clear;
  s:=trim(s);
    while pos(',',s)>0 do begin
      s1:=trim(copy(s,1,pos(',',s)-1));
      s:=trim(copy(s,pos(',',s)+1,length(s)-pos(',',s)));
      ts.add(s1);
    end;
     if length(trim(s))>0 then ts.add(s);
end;

function Calc3H:integer;
  var s,s1:string;
  var i,n:integer;
  var ts:AF_Types.TStrings;
begin
  ts.create;
  n:=0;
    for i:=2 to form1.stringgrid1.colcount-1 do begin
      Date2TS(form1.StringGrid1.Cells[i,2],@ts);
      if ts.count>n then n:=ts.count;
    end;
  if n=0 then n:=1;
  if n>30 then n:=30;
  result:=n;
  ts.free;
end;


procedure TForm1.StringGrid1DrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);
 const cl1 = TColor($CCCCCC);
 const cl2 = TColor($DA9B45);
 const cl3 = TColor($F0D6B3);
 const cl4 = TColor($0000FF);
 var i,n:integer;
 var ts:AF_Types.TStrings;
begin
StringGrid1.Canvas.Font.Color := clBlack;
if (gdFocused in State) then begin
   StringGrid1.Canvas.Brush.Color := cl4;
    If (ACol > 1) and (ARow>3) then  begin
    StringGrid1.canvas.fillRect(Rect);
    StringGrid1.canvas.TextOut(Rect.Left,Rect.Top,StringGrid1.Cells[ACol,ARow]);
    end;
end
else begin
  if strtointe(vetlist.getstring(arow+1))>2 then begin
      if typelist.getstring(arow+1)='0' then StringGrid1.Canvas.Brush.color := cl2
                                        else StringGrid1.canvas.brush.Color := cl3;
  end
   else begin
      if typelist.getstring(arow+1)='0' then StringGrid1.Canvas.Brush.color := cl1
                                        else StringGrid1.canvas.brush.Color := clWhite;
   end;
    If (ACol > 1) and (ARow>3) then  begin
    StringGrid1.canvas.fillRect(Rect);
    StringGrid1.canvas.TextOut(Rect.Left,Rect.Top,StringGrid1.Cells[ACol,ARow]);
    end;
end;
if ((ARow=2)and(ACol>1)) then begin
  ts.create;
  StringGrid1.canvas.brush.Color := clBtnFace;
  stringgrid1.RowHeights[2]:=(StringGrid1.DefaultRowHeight)*Calc3H;
  stringgrid1.Canvas.FillRect(Rect);
  Date2TS(StringGrid1.cells[ACol,ARow],@ts);
  if ts.count>0 then begin
    for i:=1 to ts.count do begin
      if i=1 then stringgrid1.Canvas.TextOut(Rect.Left, Rect.Top, ts.getstring(i))
             else StringGrid1.Canvas.TextOut(Rect.Left, Rect.Top + StringGrid1.DefaultRowHeight*(i-1), ts.getstring(i));
    end;
  end;
  ts.free;
end;
end;

procedure ClearSG(sg:TStringGrid);
var c,r:integer;
begin
  for c:=0 to sg.colcount-1 do
   for r:=0 to sg.RowCount-1 do sg.cells[c,r]:='';
end;

function getCtrl:boolean;
 var KeyState : Word;
begin
  KeyState := GetKeyState(VK_CONTROL);
  if KeyState and $8000 = $8000 then result:=true
                                else result:=false;
end;

procedure TForm1.StringGrid1KeyUp(Sender: TObject; var Key: Word;  Shift: TShiftState);
  var i,m,n1,n2,z:integer;
  var c:char;
  var s,ct:string;
  var flg:boolean;
begin
 if key=70 then begin
  if getCtrl then begin
    if InputQuery('   ',':',ct) then begin
     if validstr(ct) then begin
       if stringgrid1.ColCount>2 then begin
         flg:=false;
         for z:=2 to stringgrid1.ColCount-1 do begin
           if pos(ct,stringgrid1.cells[z,0])>0 then begin flg:=true; break; end;
         end;
         if z<>stringgrid1.Col then begin
           if flg then stringgrid1.Col:=z;
         end;
       end;
     end;
    end;
  end;
 end;
 if ((key=117)and(kflg)) then begin
   clearsg(form2.StringGrid1);
   form2.StringGrid1.Cells[0,0]:='';
   form2.StringGrid1.Cells[1,0]:='';
   unit2.vmode:=2;
   unit2.typelist2.clear;
   unit2.vetlist2.clear;
   unit2.stclist2.clear;
   unit2.timelist2.clear;
   unit2.pllist2.clear;
   unit2.isclist2.clear;
   unit2.vcol:=stringgrid1.Col;
     if (stringgrid1.col>1)and(stringgrid1.row>3) then begin
       form2.Caption:=' '+stringgrid1.cells[stringgrid1.Col,0];
       form2.labelededit1.Text:=stringgrid1.cells[stringgrid1.Col,0];
       form2.labelededit2.Text:=stringgrid1.cells[stringgrid1.Col,2];
       form2.labelededit3.Text:=stringgrid1.cells[stringgrid1.Col,3];
       form2.combobox1.ItemIndex:=0;
       if length(stringgrid1.cells[stringgrid1.Col,1])>0 then begin
       c:=stringgrid1.cells[stringgrid1.Col,1][1];
         case c of
           '': form2.combobox1.ItemIndex:=0;
           '': form2.combobox1.ItemIndex:=1;
           '': form2.combobox1.ItemIndex:=2;
           '': form2.combobox1.ItemIndex:=3;
         end;
       end;
       n1:=GetFirstStation(stringgrid1.Col);
       n2:=GetLastStation(stringgrid1.Col);
       if n2>n1 then begin
         form2.StringGrid1.RowCount:=500;
         m:=1;
         for i:=4 to stringgrid1.RowCount-1 do begin
             unit2.typelist2.add(typelist.getstring(i+1));
             unit2.vetlist2.add(vetlist.getstring(i+1));
             unit2.stclist2.add(stringgrid1.Cells[0,i]);
             form2.StringGrid1.Cells[1,m]:=plprep(stringgrid1.Cells[stringgrid1.col,i]);
             unit2.timelist2.add(plprep(stringgrid1.Cells[stringgrid1.col,i]));
             form2.StringGrid1.Cells[0,m]:=stringgrid1.Cells[1,i];
             if pos('@',stringgrid1.Cells[stringgrid1.col,i])>0 then unit2.pllist2.add( trim(copy(stringgrid1.Cells[stringgrid1.col,i], pos('@',stringgrid1.Cells[stringgrid1.col,i])+1, length(stringgrid1.Cells[stringgrid1.col,i])-pos('@',stringgrid1.Cells[stringgrid1.col,i]) ) ))
                                                                else unit2.pllist2.add('');
             if pos('^',stringgrid1.Cells[stringgrid1.col,i])>0 then unit2.isclist2.add('^')
                                                                else unit2.isclist2.add('');
             inc(m);
         end;
         form2.StringGrid1.RowCount:=m;
       end;
       if key=115 then form2.StringGrid1.Row:=1
         else begin
           form2.StringGrid1.Row:=stclist2.SearchString(stringgrid1.Cells[0,stringgrid1.row]);
         end;
       form2.StringGrid1.Col:=1;
       form2.ShowModal;
     end; end;
 if (((key=13)or(key=115))and(kflg)) then begin
   clearsg(form2.StringGrid1);
   form2.StringGrid1.Cells[0,0]:='';
   form2.StringGrid1.Cells[1,0]:='';
   unit2.vmode:=1;
   unit2.typelist2.clear;
   unit2.vetlist2.clear;
   unit2.stclist2.clear;
   unit2.timelist2.clear;
   unit2.pllist2.clear;
   unit2.isclist2.clear;
   unit2.vcol:=stringgrid1.Col;
     if (stringgrid1.col>1)and(stringgrid1.row>3) then begin
       form2.Caption:=' '+stringgrid1.cells[stringgrid1.Col,0];
       form2.labelededit1.Text:=stringgrid1.cells[stringgrid1.Col,0];
       form2.labelededit2.Text:=stringgrid1.cells[stringgrid1.Col,2];
       form2.labelededit3.Text:=stringgrid1.cells[stringgrid1.Col,3];
       form2.combobox1.ItemIndex:=0;
       if length(stringgrid1.cells[stringgrid1.Col,1])>0 then begin
       c:=stringgrid1.cells[stringgrid1.Col,1][1];
         case c of
           '': form2.combobox1.ItemIndex:=0;
           '': form2.combobox1.ItemIndex:=1;
           '': form2.combobox1.ItemIndex:=2;
           '': form2.combobox1.ItemIndex:=3;
         end;
       end;
       n1:=GetFirstStation(stringgrid1.Col);
       n2:=GetLastStation(stringgrid1.Col);
       if n2>n1 then begin
         form2.StringGrid1.RowCount:=500;
         m:=1;
         for i:=n1 to n2 do begin
           if trim(stringgrid1.Cells[stringgrid1.col,i])<>'' then begin
             unit2.typelist2.add(typelist.getstring(i+1));
             unit2.vetlist2.add(vetlist.getstring(i+1));
             unit2.stclist2.add(stringgrid1.Cells[0,i]);
             form2.StringGrid1.Cells[1,m]:=plprep(stringgrid1.Cells[stringgrid1.col,i]);
             unit2.timelist2.add(plPrep(stringgrid1.Cells[stringgrid1.col,i]));
             form2.StringGrid1.Cells[0,m]:=stringgrid1.Cells[1,i];
             if pos('@',stringgrid1.Cells[stringgrid1.col,i])>0 then unit2.pllist2.add( trim(copy(stringgrid1.Cells[stringgrid1.col,i], pos('@',stringgrid1.Cells[stringgrid1.col,i])+1, length(stringgrid1.Cells[stringgrid1.col,i])-pos('@',stringgrid1.Cells[stringgrid1.col,i]) ) ))
                                                                else unit2.pllist2.add('');
             if pos('^',stringgrid1.Cells[stringgrid1.col,i])>0 then unit2.isclist2.add('^')
                                                                else unit2.isclist2.add('');
             inc(m);
           end;
         end;
         form2.StringGrid1.RowCount:=m;
       end;
       if key=115 then form2.StringGrid1.Row:=1
         else begin
           form2.StringGrid1.Row:=stclist2.SearchString(stringgrid1.Cells[0,stringgrid1.row]);
         end;
       i:=stclist2.SearchString(stringgrid1.Cells[0,stringgrid1.row]);
       if i>0 then form2.StringGrid1.Row:=i
              else form2.StringGrid1.Row:=1;
       form2.ShowModal;
     end;
 end;
 kflg:=true;
 if CtrlDown then begin
  if key=67 then begin
   if ((StringGrid1.Row>3)and(StringGrid1.col>1)) then begin
    if messagedlg('  '+stringgrid1.Cells[stringgrid1.Col,0]+'?',mtConfirmation,[mbYes,mbNo],0)=mrYes then begin
      stringgrid1.ColCount:=stringgrid1.colcount+1;
       for i:=stringgrid1.ColCount-2 downto StringGrid1.col do begin
         for m:=0 to StringGrid1.RowCount-1 do begin
           StringGrid1.cells[i+1,m]:=StringGrid1.cells[i,m];
         end;
       end;
       stringgrid1.cells[stringgrid1.col+1,1]:='';
       stringgrid1.cells[stringgrid1.col+1,2]:='';
       editflag:=true;
    end;
    //kflg:=false;
   end;
  end;
  if key=65 then begin
   if ((StringGrid1.Row>3)and(StringGrid1.col>1)) then begin
      s:=trim(stringgrid1.Cells[StringGrid1.col,2]);
      newd:=trim(newd);
      if length(newd)>0 then begin
        if length(s)>0 then if s[length(s)]=',' then s:=trim(copy(s,1,length(s)-1));
        if length(trim(newd))>3 then begin
          if not CompareDates(newd,s) then begin
            if length(s)>0 then stringgrid1.Cells[StringGrid1.col,2]:=s+', '+newd
                           else stringgrid1.Cells[StringGrid1.col,2]:=newd;
     //       showmessage('  '+newd+'   '+stringgrid1.Cells[StringGrid1.col,0]+'!');
            //kflg:=false;
          end;
        end;
      end;
   end;
  end;
  if key=78 then begin
    if inputquery(' ',' ',s) then begin
      newd:=s;
      lastd:=s;
    end;  
    key:=0;
    //kflg:=false;
  end;
  if key=74 then begin
   if ((StringGrid1.Row>3)and(StringGrid1.col>1)) then begin
     s:=lastd;
     if validstr(stringgrid1.Cells[StringGrid1.col,2]) then s:=stringgrid1.Cells[StringGrid1.col,2];
     if InputQuery(' ',' :',s) then begin
        s:=prepDlist(s);
        stringgrid1.Cells[StringGrid1.col,1]:='';
        stringgrid1.Cells[StringGrid1.col,2]:=s;
        lastd:=s;
        editflag:=true;
     end;
   end;
  end;
 end;

end;

///

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  if editflag then begin
    SaveXLS(LabeledEdit1.Text);
    editflag:=false;
    showmessage(' !');
  end
   else ShowMessage('  ,   !');
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  canclose:=false;
  if editflag then begin
    case MessageDlg(' ?',mtConfirmation,[mbYes,mbNo],0) of
      mrYes: begin
              SaveXLS(LabeledEdit1.Text);
              CanClose:=true;
             end;
      mrNo: CanClose:=true;
    end;

  end
   else CanClose:=true;
end;

function delAst(s:string):string;
begin
  while pos('*',s)>0 do delete(s,pos('*',s),1);
  result:=trim(s);
end;

procedure TForm1.StringGrid1DblClick(Sender: TObject);
  var i,m,n1,n2,wx,wy:integer;
  var c:char;
  var s:string;
  var p:TPoint;
begin
GetCursorPos(p);
StringGrid1.MouseToCell(p.X-stringgrid1.left-form1.left,p.y-stringgrid1.Top-form1.top,wx,wy);
if ((wy>4)and(wx>1)) then begin
   stringgrid1.Col:=wx;
   clearsg(form2.StringGrid1);
   form2.StringGrid1.Cells[0,0]:='';
   form2.StringGrid1.Cells[1,0]:='';
   unit2.vmode:=1;
   unit2.typelist2.clear;
   unit2.vetlist2.clear;
   unit2.stclist2.clear;
   unit2.timelist2.clear;
   unit2.pllist2.clear;
   unit2.isclist2.clear;
   unit2.vcol:=stringgrid1.Col;
     if (stringgrid1.col>1)and(stringgrid1.row>3) then begin
       form2.Caption:=' '+stringgrid1.cells[stringgrid1.Col,0];
       form2.labelededit1.Text:=stringgrid1.cells[stringgrid1.Col,0];
       form2.labelededit2.Text:=stringgrid1.cells[stringgrid1.Col,2];
       form2.labelededit3.Text:=stringgrid1.cells[stringgrid1.Col,3];
       form2.combobox1.ItemIndex:=0;
       if length(stringgrid1.cells[stringgrid1.Col,1])>0 then begin
       c:=stringgrid1.cells[stringgrid1.Col,1][1];
         case c of
           '': form2.combobox1.ItemIndex:=0;
           '': form2.combobox1.ItemIndex:=1;
           '': form2.combobox1.ItemIndex:=2;
           '': form2.combobox1.ItemIndex:=3;
           '': form2.combobox1.ItemIndex:=4;
         end;
       end;  
       n1:=GetFirstStation(stringgrid1.Col);
       n2:=GetLastStation(stringgrid1.Col);
       if n2>n1 then begin
         form2.StringGrid1.RowCount:=500;
         m:=1;
         for i:=n1 to n2 do begin
           if trim(stringgrid1.Cells[stringgrid1.col,i])<>'' then begin
             unit2.typelist2.add(typelist.getstring(i+1));
             unit2.vetlist2.add(vetlist.getstring(i+1));
             unit2.stclist2.add(stringgrid1.Cells[0,i]);
             form2.StringGrid1.Cells[1,m]:=plPrep(stringgrid1.Cells[stringgrid1.col,i]);
             unit2.timelist2.add(plPrep(stringgrid1.Cells[stringgrid1.col,i]));
             form2.StringGrid1.Cells[0,m]:=stringgrid1.Cells[1,i];
             if pos('@',stringgrid1.Cells[stringgrid1.col,i])>0 then unit2.pllist2.add( trim(copy(stringgrid1.Cells[stringgrid1.col,i], pos('@',stringgrid1.Cells[stringgrid1.col,i])+1, length(stringgrid1.Cells[stringgrid1.col,i])-pos('@',stringgrid1.Cells[stringgrid1.col,i]) ) ))
                                                                else unit2.pllist2.add('');
             if pos('^',stringgrid1.Cells[stringgrid1.col,i])>0 then unit2.isclist2.add('^')
                                                                else unit2.isclist2.add('');
             if pos('*',stringgrid1.Cells[stringgrid1.col,i])>0 then unit2.odslist2.add('*')
                                                                else unit2.odslist2.add('');
             inc(m);
           end;
         end;
         form2.StringGrid1.RowCount:=m;
       end;
       i:=stclist2.SearchString(stringgrid1.Cells[0,stringgrid1.row]);
       if i>0 then form2.StringGrid1.Row:=i
              else form2.StringGrid1.Row:=1;
       form2.StringGrid1.Col:=1;
       form2.ShowModal;
     end;
end;
end;

procedure TForm1.StringGrid1MouseMove(Sender: TObject; Shift: TShiftState;  X, Y: Integer);
  var c,r:integer;
begin
  StringGrid1.MouseToCell(x,y,c,r);
    if ((r=2)and(c>1)) then begin
      form1.ActivateHintNOW(form1.Left+stringgrid1.Left+x,form1.Top+stringgrid1.top+y,stringgrid1.cells[c,r]);
      stringgrid1.Hint:=StringGrid1.Cells[c,r];
    end
     else begin
       hintwnd.ReleaseHandle;
     end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  f1list.free;
  stcodes.free;
  sttypes.free;
  typelist.free;
  vetlist.free;
  chgcolored.free;
  hintwnd.ReleaseHandle;
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
       hintwnd.ReleaseHandle;
end;

end.
