unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, ExtCtrls, AF_Types, AF_Proc, Buttons;

type
  TForm2 = class(TForm)
    LabeledEdit1: TLabeledEdit;
    Label1: TLabel;
    ComboBox1: TComboBox;
    LabeledEdit2: TLabeledEdit;
    LabeledEdit3: TLabeledEdit;
    StringGrid1: TStringGrid;
    Button1: TButton;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    CheckBox1: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure StringGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure Button1Click(Sender: TObject);
    procedure StringGrid1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCanResize(Sender: TObject; var NewWidth,
      NewHeight: Integer; var Resize: Boolean);
    procedure FormResize(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure LabeledEdit1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure LabeledEdit2KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure LabeledEdit3KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure StringGrid1KeyPress(Sender: TObject; var Key: Char);
    procedure StringGrid1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;
  vmode,vcol:integer;
  typelist2,vetlist2,stclist2,timelist2,pllist2,isclist2,odslist2:AF_Types.TStrings;

function CtrlDown : Boolean;
function CompareDates(d,d1:string):boolean;


implementation

uses unit1,unit3, Unit4, Unit5;

{$R *.dfm}

procedure TForm2.FormCreate(Sender: TObject);
begin
  vetlist2.create;
  typelist2.create;
  stclist2.create;
  timelist2.create;
  pllist2.create;
  isclist2.create;
  odslist2.create;
end;

procedure TForm2.FormDestroy(Sender: TObject);
begin
  vetlist2.free;
  typelist2.free;
  stclist2.free;
  timelist2.free;
  pllist2.free;
  isclist2.free;
  odslist2.free;
end;

procedure TForm2.StringGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;    Rect: TRect; State: TGridDrawState);
 const cl1 = TColor($CCCCCC);
 const cl2 = TColor($DA9B45);
 const cl3 = TColor($F0D6B3);
 const cl4 = TColor($0000FF);
begin
StringGrid1.Canvas.Font.Color := clBlack;
if (gdFocused in State) then begin
   StringGrid1.Canvas.Brush.Color := clRed;
end
else begin
   if arow>0 then begin
      if typelist2.getstring(arow)='0' then StringGrid1.Canvas.Brush.color := cl1
                                        else StringGrid1.canvas.brush.Color := clWhite;
    StringGrid1.canvas.fillRect(Rect);
    StringGrid1.canvas.TextOut(Rect.Left,Rect.Top,StringGrid1.Cells[ACol,ARow]);
   end;
end;
end;


function GetNextSt(n:integer):integer;
 var i:integer;
begin
  if n<typelist2.count then begin
    for i:=n+1 to typelist2.count do begin
      if not (strtointe(typelist2.getstring(i)) in [1,2]) then begin
        if trim(form2.StringGrid1.cells[1,i])<>'-' then break;
      end;
    end;
    if i>typelist2.count then i:=typelist2.count;
    result:=i;
  end
   else result:=typelist2.count;
end;

function CalcTimeRaz(s1,s2:string):integer;
 var h,h1,m,m1,n:integer;
begin
   if pos('/',s1)>0 then s1:=trim(copy(s1,pos('/',s1)+1,length(s1)-pos('/',s1)));
   if pos('/',s2)>0 then s2:=trim(copy(s2,1,pos('/',s2)-1));
   tohm(s1,h,m);
   tohm(s2,h1,m1);
   n:=0;
   if not ((h=h1)and(m=m1)) then begin
     repeat
       inc(n);
       inchm(h,m,1);
     until ((h=h1)and(m=m1));
   end;
   result:=n;
end;

function CalcTimeRaz2(s1,s2:string):integer;
 var h,h1,m,m1,n:integer;
begin
   if pos('/',s1)>0 then s1:=trim(copy(s1,pos('/',s1)+1,length(s1)-pos('/',s1)));
   if pos('/',s2)>0 then s2:=trim(copy(s2,pos('/',s2)+1,length(s2)-pos('/',s2)));
   tohm(s1,h,m);
   tohm(s2,h1,m1);
   n:=0;
   if not ((h=h1)and(m=m1)) then begin
     repeat
       inc(n);
       inchm(h,m,1);
     until ((h=h1)and(m=m1));
   end;
   result:=n;
end;

function GetFirstStation2(n:integer):integer;
  var i,l:integer;
begin
  for i:=1 to form1.StringGrid1.RowCount-1 do begin
    if ValidStr(form2.StringGrid1.Cells[n,i]) then begin
      l:=i;
      break;
    end;
  end;
  result:=l;
end;

function GetLastStation2(n:integer):integer;
  var i,l:integer;
begin
  for i:=form1.StringGrid1.RowCount-1 downto 1 do begin
    if ValidStr(form2.StringGrid1.Cells[n,i]) then begin
      l:=i;
      break;
    end;
  end;
  result:=l;
end;

function FindSG1C(s:string;i1:integer):integer;
  var i:integer;
  var r:integer;
begin
  for i:=i1 to form1.StringGrid1.RowCount-1 do begin
    if form1.StringGrid1.Cells[0,i]=s then begin
                                             r:=i;
                                             break;
                                           end;
  end;
  result:=r;
end;

procedure TForm2.Button1Click(Sender: TObject);
  var i,n1,m1,m2:integer;
  var s,s1:string;
begin
if validstr(LabeledEdit1.Text) then begin
if validstr(LabeledEdit2.Text) then begin
  s:=labelededit1.text;
  while pos('^',s)>0 do delete(s,pos('^',s),1);
   if checkbox1.Checked then begin
    if pos('#',s)>0 then insert('^',s,pos('#',s))
                    else s:=s+'^';
   end;
  labelededit1.text:=trim(s);
  if not checkbox1.Checked then begin
   if isclist2.count>0 then begin
    for i:=1 to isclist2.count do isclist2.edit(i,'');
   end;
  end;
  s:=form1.StringGrid1.Cells[vcol,3];
  n1:=GetFirstStation(vcol);
  for i:=0 to form1.StringGrid1.RowCount-1 do form1.StringGrid1.Cells[vcol,i]:='';
  m1:=GetFirstStation2(1);
  m2:=GetLastStation2(1);
  if s<>'' then form1.StringGrid1.Cells[vcol,3]:=s
    else begin
      if stclist2.getstring(m1)<>form1.StringGrid1.Cells[0,n1] then LabeledEdit3.text:=form1.StringGrid1.Cells[0,n1];
    end;
  form1.StringGrid1.Cells[vcol,0]:=trim(LabeledEdit1.text);
  form1.StringGrid1.Cells[vcol,2]:=trim(prepDlist(LabeledEdit2.text));
  lastd:=trim(prepDlist(LabeledEdit2.text));
  if ComboBox1.ItemIndex=2 then LabeledEdit3.text:='';
  if trim(LabeledEdit3.text)<>'' then form1.StringGrid1.Cells[vcol,3]:=trim(LabeledEdit3.text)
                                 else begin
                                   if trim(LabeledEdit3.text)<>trim(form1.StringGrid1.Cells[vcol,3]) then begin
                                     if MessageDlg('   . ?',mtConfirmation,[mbYes,mbNo],0)=mrYes then form1.StringGrid1.Cells[vcol,3]:=trim(LabeledEdit3.text);
                                   end;
                                 end;
   case combobox1.ItemIndex of
     0: form1.StringGrid1.Cells[vcol,1]:='';
     1: form1.StringGrid1.Cells[vcol,1]:='';
     2: form1.StringGrid1.Cells[vcol,1]:='';
     3: form1.StringGrid1.Cells[vcol,1]:='';
     4: form1.StringGrid1.Cells[vcol,1]:='';
   end;
  n1:=4;
  if vmode=1 then begin
   for i:=m1 to m2 do begin
    if trim(form2.stringgrid1.Cells[1,i])<>'' then begin
     n1:=FindSG1C(stclist2.getstring(i),n1);
     s1:=trim(form2.stringgrid1.Cells[1,i]);
     if not checkbox1.checked then begin
      while pos('^',s1)>0 do delete(s1,pos('^',s1),1);
      s1:=trim(s1);
     end
      else begin
       if pos('^',s1)>0 then isclist2.edit(i,'^');
       if pos('^^',s1)>0 then isclist2.edit(i,'');
       while pos('^',s1)>0 do delete(s1,pos('^',s1),1);
      end;
     if odslist2.getstring(i)='*' then begin
      if pos('@',s1)<=0 then begin
        s1:=s1+'*';
      end;
     end;
     if pos('@',s1)>0 then begin
       if pos('@',s1)=length(s1) then begin
          s1:=trim(copy(s1,1,length(s1)-1));
          if odslist2.getstring(i)='*' then s1:=s1+'*';
       end;
     end
      else begin
       if length(pllist2.getstring(i))>0 then s1:=s1+'@'+trim(pllist2.getstring(i));
      end;
     if isclist2.getstring(i)='^' then begin
      if pos('@',s1)>0 then begin
        insert('^',s1,pos('@',s1));
      end
       else s1:=s1+'^';
     end;
     if length(s1)>0 then begin
      if s1[1]='-' then s1:='-';
     end;
     form1.StringGrid1.Cells[vcol,n1]:=s1
    end;
   end;
  end;
  if vmode=2 then begin
   for i:=1 to stclist2.count do begin
     s1:=trim(form2.stringgrid1.Cells[1,i]);
     if not checkbox1.checked then begin
      while pos('^',s1)>0 do delete(s1,pos('^',s1),1);
      s1:=trim(s1);
     end
      else begin
       if pos('^',s1)>0 then isclist2.edit(i,'^');
       if pos('^^',s1)>0 then isclist2.edit(i,'');
       while pos('^',s1)>0 do delete(s1,pos('^',s1),1);
      end;
     if odslist2.getstring(i)='*' then begin
      if pos('@',s1)<=0 then begin
        s1:=s1+'*';
      end;
     end;
     if pos('@',s1)>0 then begin
       if pos('@',s1)=length(s1) then begin
          s1:=trim(copy(s1,1,length(s1)-1));
          if odslist2.getstring(i)='*' then s1:=s1+'*';
       end;
     end
      else begin
       if length(pllist2.getstring(i))>0 then s1:=s1+'@'+trim(pllist2.getstring(i));
      end;
     if isclist2.getstring(i)='^' then begin
      if pos('@',s1)>0 then begin
        insert('^',s1,pos('@',s1));
      end
       else s1:=s1+'^';
     end;
     if length(s1)>0 then begin
      if s1[1]='-' then s1:='-';
     end;
     form1.StringGrid1.Cells[vcol,i+3]:=s1;
   end;
  end;
  unit1.chgcolored.edit(vcol+1,'1');
  form2.Close;
  editflag:=true;
end
 else ShowMessage('  !');
end
 else ShowMessage('  !');
end;

function CtrlDown : Boolean;
var
  State : TKeyboardState;
begin
  GetKeyboardState(State);
  Result := ((State[vk_Control] And 128) <> 0);
end;

function AltDown : Boolean;
var
  State : TKeyboardState;
begin
  GetKeyboardState(State);
  Result := ((State[vk_Menu] and 128) <> 0);
end;

function CompareDates(d,d1:string):boolean;
  var s,s1:string;
  var r:boolean;
  var ts:AF_Types.TStrings;
begin
  r:=false;
  ts.create;
    d:=trim(d);
    d1:=trim(d1);
    while pos(',',d1)>0 do begin
      s:=trim(copy(d1,1,pos(',',d1)-1));
      d1:=trim(copy(d1,pos(',',d1)+1,length(d1)-pos(',',d1)));
      ts.add(s);
    end;
     if length(trim(d1))>0 then ts.add(d1);
  if ts.SearchString(d)>0 then r:=true;   
  ts.free;
  result:=r;
end;

procedure TForm2.StringGrid1KeyDown(Sender: TObject; var Key: Word;  Shift: TShiftState);
  var i,m1,m2,h,m,h0,m0:integer;
  var s:string;
begin
  if stringgrid1.col=0 then stringgrid1.col:=1;
  if CtrlDown then begin
    if key=65 then begin
      s:=trim(prepDlist(LabeledEdit2.Text));
      newd:=trim(newd);
      if length(newd)>0 then begin
        if length(s)>0 then if s[length(s)]=',' then s:=trim(copy(s,1,length(s)-1));
        if length(trim(newd))>3 then begin
          if not CompareDates(newd,s) then begin
            if length(s)>0 then labelededit2.Text:=s+', '+newd
                           else labelededit2.Text:=newd;
          end;
        end;
      end;
    end;
    if key=38 then begin
      if MessageDlg('     '+form2.StringGrid1.cells[0,form2.StringGrid1.Row]+'?',mtConfirmation,[mbYes,mbNo],0)=mrYes then begin
      if form2.StringGrid1.Row>1 then begin
         for i:=1 to form2.StringGrid1.Row-1 do form2.StringGrid1.cells[1,i]:='';
         s:=form2.StringGrid1.Cells[1,form2.StringGrid1.row];
         if pos('/',s)>0 then begin
           s:=copy(s,pos('/',s)+1,length(s)-pos('/',s));
           form2.StringGrid1.Cells[1,form2.StringGrid1.row]:=trim(s);
         end;
      end;
      end;
      key:=0;
    end;
    if key=40 then begin
      if MessageDlg('     '+form2.StringGrid1.cells[0,form2.StringGrid1.Row]+'?',mtConfirmation,[mbYes,mbNo],0)=mrYes then begin
      if form2.StringGrid1.Row<form2.StringGrid1.RowCount-1 then begin
         for i:=form2.StringGrid1.Row+1 to form2.StringGrid1.RowCount-1 do form2.StringGrid1.cells[1,i]:='';
         s:=form2.StringGrid1.Cells[1,form2.StringGrid1.row];
         if pos('/',s)>0 then begin
           s:=trim(copy(s,1,pos('/',s)-1));
         end
          else begin
           tohm(s,h,m);
           inchm(h,m,1439);
           s:=fromhm(h,m);
          end;
         form2.StringGrid1.cells[1,form2.StringGrid1.Row]:=s;
      end;
      end;
      key:=0;
    end;
  end
   else begin
   end;
end;


procedure TForm2.FormCanResize(Sender: TObject; var NewWidth,
  NewHeight: Integer; var Resize: Boolean);
begin
  newwidth:=306;
  resize:=true;
end;

procedure TForm2.FormResize(Sender: TObject);
begin
  stringgrid1.Height:=form2.height-292;
  button1.Top:=form2.height-73;
end;


procedure TForm2.FormKeyUp(Sender: TObject; var Key: Word;  Shift: TShiftState);
  var i,m1,m2,h,m,h0,m0:integer;
  var b:boolean;
begin
  if CtrlDown then begin
    if key=113 then begin Button1Click(self); key:=0; end;
    if key=68 then begin
      if not validstr(LabeledEdit2.text) then LabeledEdit2.text:=lastd; 
    end;
    if key=109 then begin
      m1:=GetFirstStation2(1);
      m2:=GetLastStation2(1);
      form3.ComboBox2.Items.Clear;
      form3.ComboBox3.Items.Clear;
      for i:=1 to form2.StringGrid1.RowCount-1 do begin
        form3.ComboBox2.Items.add(form2.StringGrid1.Cells[0,i]);
        form3.ComboBox3.Items.add(form2.StringGrid1.Cells[0,i]);
      end;
      form3.ComboBox2.ItemIndex:=form2.StringGrid1.row-m1;
      form3.ComboBox3.ItemIndex:=form3.ComboBox3.Items.Count-1;
      form3.ComboBox1.ItemIndex:=1;
      form3.showmodal;
      key:=0;
    end;
    if key=107 then begin
      m1:=GetFirstStation2(1);
      m2:=GetLastStation2(1);
      form3.ComboBox2.Items.Clear;
      form3.ComboBox3.Items.Clear;
      for i:=1 to form2.StringGrid1.RowCount-1 do begin
        form3.ComboBox2.Items.add(form2.StringGrid1.Cells[0,i]);
        form3.ComboBox3.Items.add(form2.StringGrid1.Cells[0,i]);
      end;
      form3.ComboBox2.ItemIndex:=form2.StringGrid1.row-m1;
      form3.ComboBox3.ItemIndex:=form3.ComboBox3.Items.Count-1;
      form3.ComboBox1.ItemIndex:=0;
      form3.showmodal;
      key:=0;
    end;
  end;
end;

procedure TForm2.FormShow(Sender: TObject);
  var s:string;
begin
  s:=labelededit1.text;
  if pos('^',s)>0 then checkbox1.checked:=true
                  else checkbox1.Checked:=false;
  while pos('^',s)>0 do delete(s,pos('^',s),1);
  labelededit1.text:=trim(s);
  form2.StringGrid1.SetFocus;
end;

procedure TForm2.LabeledEdit1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if ((CtrlDown) and (key=13)) then begin
    Button1Click(self);
  end
   else if key=13 then if LabeledEdit1.Focused then ComboBox1.SetFocus;
end;

procedure TForm2.LabeledEdit2KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if key=13 then if LabeledEdit2.Focused then LabeledEdit3.SetFocus;
end;

procedure TForm2.LabeledEdit3KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if key=13 then if LabeledEdit3.Focused then StringGrid1.SetFocus;
end;

procedure TForm2.StringGrid1KeyPress(Sender: TObject; var Key: Char);
begin
  if key=',' then key:='.';
end;

function getPrevHM(row:integer; var ph,pm:integer):boolean;
  var res:boolean;
  var h,m,i:integer;
  var s:string;
begin
  res:=false;
  if row>1 then begin
   for i:=row-1 downto 1 do begin
     s:=trim(form2.StringGrid1.Cells[1,i]);
     if pos('@',s)>0 then delete(s,pos('@',s),length(s)-pos('@',s)+1);
     s:=trim(s);
     if pos('/',s)>0 then s:=copy(s,pos('/',s)+1,length(s)-pos('/',s));
     s:=trim(s);
     if length(s)>2 then begin
       tohm(s,h,m);
       ph:=h; pm:=m;
       res:=true;
       break;
     end;
   end;
  end;
  result:=res;
end;

procedure TForm2.StringGrid1KeyUp(Sender: TObject; var Key: Word;   Shift: TShiftState);
  var i,m1,m2,h,m,h9,m9,h0,m0,h0a,m0a,ph,pm,vl8,vl9:integer;
  var s,s1,sf,sm:string;
  var pf:boolean;
begin
  if not CtrlDown then begin
//    showmessage(inttostr(key));
    if AltDown then begin
     if ((stringgrid1.col=1)and(stringgrid1.row>0)) then begin
       sf:=stringgrid1.Cells[stringgrid1.col,stringgrid1.row];
       if pos('^',sf)>0 then pf:=true
                        else pf:=false;
       if key=192 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@';
        end;
       end;
       if key=49 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@1 ';
        end;
       end;
       if key=50 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@2 ';
        end;
       end;
       if key=51 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@3 ';
        end;
       end;
       if key=52 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@4 ';
        end;
       end;
       if key=53 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@5 ';
        end;
       end;
       if key=89 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@2 . 3 ';
        end;
       end;
       if stringgrid1.Cells[stringgrid1.Col,stringgrid1.row]<>sf then stringgrid1.Cells[stringgrid1.Col,stringgrid1.row]:=sf;
     end;
    end;
     if key=13 then begin
       if (strtointe(typelist2.getstring(form2.StringGrid1.Row)) in [1,2]) then begin
         if form2.StringGrid1.Row<form2.StringGrid1.RowCount-1 then form2.StringGrid1.Row:=form2.StringGrid1.Row+1;
       end
        else begin
          m1:=form2.stringgrid1.row;
          if getPrevHM(m1,ph,pm) then begin
            sm:=form2.StringGrid1.Cells[1,m1];
            if length(sm)=2 then begin
              val(sm,vl8,vl9);
              if vl9<1 then begin
               if (vl8 in [0..59]) then begin
                 if vl8>pm then sm:=inttostr(ph)+'.'+sm
                           else begin
                            if ph=23 then sm:='0.'+sm
                                     else sm:=inttostr(ph+1)+'.'+sm
                           end;
                 form2.StringGrid1.Cells[1,m1]:=sm;
               end;
              end;
            end;
          end;
          m2:=GetNextSt(form2.StringGrid1.Row);
           if m2>m1+1 then begin
             if pos('/',form2.StringGrid1.Cells[1,m1])>0 then begin
                                                            s:=trim(copy(form2.StringGrid1.Cells[1,m1],pos('/',form2.StringGrid1.Cells[1,m1])+1,length(form2.StringGrid1.Cells[1,m1])-pos('/',form2.StringGrid1.Cells[1,m1])));
                                                         end
                                                         else begin
                                                           s:=form2.StringGrid1.Cells[1,m1];
                                                         end;
             tohm(s,h,m);
             for i:=m1+1 to m2-1 do begin
              if (form2.StringGrid1.Cells[1,i]<>'')and(form2.StringGrid1.Cells[1,i]<>'-') then begin
                h0:=h;
                m0:=m;
                h0a:=h;
                m0a:=m;
                inchm(h0,m0,CalcTimeRaz(timelist2.getstring(m1),timelist2.getstring(i)));
                inchm(h0a,m0a,CalcTimeRaz2(timelist2.getstring(m1),timelist2.getstring(i)));
                 if fromhm(h0,m0)=fromhm(h0a,m0a) then begin
                  form2.StringGrid1.Cells[1,i]:=fromhm(h0,m0);
                 end
                  else begin
                   form2.StringGrid1.Cells[1,i]:=fromhm(h0,m0)+'/'+fromhm(h0a,m0a);
                  end;
              end;
             end;
           end;
          form2.stringgrid1.row:=m2;
        end;
     end
  end
   else begin //ctrl
    if AltDown then begin
     if ((stringgrid1.col=1)and(stringgrid1.row>0)) then begin
       sf:=stringgrid1.Cells[stringgrid1.col,stringgrid1.row];
       if pos('^',sf)>0 then pf:=true
                        else pf:=false;
       if key=192 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@';
        end;
       end;
       if key=49 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@1 . 1 ';
        end;
       end;
       if key=50 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@2 . 2 ';
        end;
       end;
       if key=51 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@3 . 3 ';
        end;
       end;
       if key=52 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@3 . 4 ';
        end;
       end;
       if stringgrid1.Cells[stringgrid1.Col,stringgrid1.row]<>sf then stringgrid1.Cells[stringgrid1.Col,stringgrid1.row]:=sf;
     end;
    end
     else begin
     if ((stringgrid1.col=1)and(stringgrid1.row>0)) then begin
       sf:=stringgrid1.Cells[stringgrid1.col,stringgrid1.row];
       if pos('^',sf)>0 then pf:=true
                        else pf:=false;
       if key=192 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@';
        end;
       end;
       if key=49 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@1 ';
        end;
       end;
       if key=50 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@2 ';
        end;
       end;
       if key=51 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@3 ';
        end;
       end;
       if key=52 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@4 ';
        end;
       end;
       if key=53 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@5 ';
        end;
       end;
       if key=89 then begin
        if ((trim(sf)<>'-')and(validstr(sf))) then begin
         if pos('@',sf)>0 then begin
          sf:=copy(sf,1,pos('@',sf)-1);
          while pos('^',sf)>0 do delete(sf,pos('^',sf),1);
         end;
          sf:=trim(sf);
          if pf then sf:=sf+'^';
          sf:=sf+'@2 . 3 ';
        end;
       end;
       if stringgrid1.Cells[stringgrid1.Col,stringgrid1.row]<>sf then stringgrid1.Cells[stringgrid1.Col,stringgrid1.row]:=sf;
     end;
     end;
   end;
end;

procedure TForm2.SpeedButton1Click(Sender: TObject);
begin
  form4.showmodal;

end;

procedure TForm2.SpeedButton2Click(Sender: TObject);
begin
 form5.showmodal;
end;

end.
