unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, AF_Proc, AF_Types, StdCtrls, WinInet;

type
  TForm1 = class(TForm)
    Button1: TButton;
    SaveDialog1: TSaveDialog;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  workdir:string;

const //        API.    @      uid   .
  y_station:string='https://rasp.yandex.ru/export/suburban/station/@stcode@';
  y_change:string='http://export.rasp.yandex.net/export/v2/suburban/thread/@uid@/linked';
  y_thread:string='http://export.rasp.yandex.net/export/v2/suburban/thread/@uid@';

implementation

uses DateUtils;

{$R *.dfm}

// ==============================================================================================================================

//  explode -            ,  
procedure ParseCSVStrEx(ts:AF_Types.PStrings; s:widestring; c:char);
 var n:integer;
begin
  ts.clear;
  while pos(c,s)>0 do begin
    n:=pos(c,s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;

// ==============================================================================================================================

//        ,  
Procedure GetInetFile (const fileURL, FileName: String);
const BufferSize = 1024;
var
  hSession, hURL: HInternet;
  Buffer: array[1..BufferSize] of Byte;
  BufferLen: DWORD;
  f: File;
  sAppName: String;
begin
  sAppName := ExtractFileName(Application.ExeName);
  hSession :=InternetOpen(PChar(sAppName), INTERNET_OPEN_TYPE_PRECONFIG, nil, nil, 0);
  try
    hURL := InternetOpenURL(hSession, PChar(fileURL), nil, 0, 0, 0);
    try
      AssignFile(f, FileName);
      Rewrite(f,1);
      {$I-}
      repeat
      try
        bufferlen:=0;
        InternetReadFile(hURL, @Buffer, SizeOf(Buffer), BufferLen);
      except
      end;
        if bufferlen>0 then begin
          try
           BlockWrite(f, Buffer, BufferLen)
          except
          end;
        end;
      until BufferLen = 0;
      {$I+}
      CloseFile(f);
    finally
      InternetCloseHandle(hURL)
    end
  finally
    InternetCloseHandle(hSession)
  end
end;

// ==============================================================================================================================

//    UTF8  cp1251, ..     ,  
Procedure UTF8FileDecode(fn,fn1:string);
 var t,t1:textfile;
 var s:string;
begin
  assignfile(t,fn);
  reset(t);
  assignfile(t1,fn1);
  rewrite(t1);
   while not eof(t) do begin
     readln(t,s);
     writeln(t1,Utf8ToAnsi(s));
   end;
  closefile(t1);
  closefile(t);
end;

// ==============================================================================================================================

//     XML,  
Procedure XMLFile1(fn,fn1:string);
 var t,t1:textfile;
 var s,s1:string;
 var i:integer;
begin
  assignfile(t,fn);
  reset(t);
  assignfile(t1,fn1);
  rewrite(t1);
   while not eof(t) do begin
     readln(t,s);
     s1:='';
     if length(s)>0 then begin
       for i:=1 to length(s) do begin
         if s[i]='<' then s1:=s1+#13#10+s[i]
                     else s1:=s1+s[i];
       end;
     end;
     writeln(t1,s1);
   end;
  closefile(t1);
  closefile(t);
end;

// ==============================================================================================================================

//    s1   s,  getParam('mode','<schedule mode="7" type="14"');  7.
function getParam(s1,s:string):string;
  var s2:string;
begin
  s:=trim(s);
  s2:='';
  if pos(s1+'="',s)>0 then begin
    s2:=copy(s,pos(s1+'="',s)+2+length(s1),length(s));
     if pos('"',s2)>0 then s2:=copy(s2,1,pos('"',s2)-1);
  end;
  result:=trim(s2);
end;

// ==============================================================================================================================

// true     .       -   API   
function test_athread(s:string):boolean;
begin
  result:=false;
  if length(s)>0 then begin
   if (s[1] in ['0'..'9']) then result:=true;
  end;
end;

// ==============================================================================================================================

//      .    uid ,                  ,         .
//       :
//   esrlist -           
//   stlist -           
//   flaglist -         , T -   , + -   , - -   
//   stf - ,   .          .
//   time1 - ,       
//   time2 - ,       
procedure getThreadInfo(uid:string; esrlist, stlist, flaglist: AF_Types.PStrings; var stf,time1,time2:string);
  var i:integer;
  var f:AF_Types.TStrings;
  var yth,s,s1,s2:string;
begin
 f.create;
 stf:='';
 time1:='';
 time2:='';
 esrlist.clear;
 stlist.clear;
 flaglist.clear;
 if fileexists(workdir+'\temp5.tmp') then deletefile(workdir+'\temp5.tmp');
 if fileexists(workdir+'\temp6.tmp') then deletefile(workdir+'\temp6.tmp');
 yth:=StrReplace(y_thread,'@uid@',uid); //      API,   
 GetInetFile(yth,workdir+'\temp5.tmp'); //   API  
 XMLFile1(workdir+'\temp5.tmp',workdir+'\temp6.tmp'); //    
 UTF8FileDecode(workdir+'\temp6.tmp',workdir+'\temp5.tmp');
 f.loadfromfile(workdir+'\temp5.tmp');
 if f.count>0 then begin
  for i:=1 to f.count do begin
   s:=f.getstring(i);
   if pos('<rtstation ',s)>0 then begin //  .       ,       -     
    if time1='' then time1:=getParam('departure_local',s);
    time2:=getParam('arrival_local',s);
    s1:=getParam('arrival',s);
    s2:=getParam('departure',s);
    esrlist.add(getParam('esr',s));
    stlist.add(getParam(' title',s));
    if s1=s2 then flaglist.add('-')
             else flaglist.add('+')
   end;
  end;
  if flaglist.count>0 then begin //    
    flaglist.edit(1,'T');
    flaglist.edit(flaglist.count,'T');
    for i:=1 to flaglist.count do stf:=stf+flaglist.getstring(i);
  end;
 end;
 if fileexists(workdir+'\temp5.tmp') then deletefile(workdir+'\temp5.tmp');
 if fileexists(workdir+'\temp6.tmp') then deletefile(workdir+'\temp6.tmp');
 f.free;
end;

// ==============================================================================================================================

//             
//     uid    
//        
//   thmode -  , -   
//   thtitle -  () 
//   thuid - uid  
procedure findChgThread(uid:string; date:TDateTime; var thmode,thtitle,thuid:string);
  var ych,s,s1,s2,s3,s4,sd,sm,sy:string;
  var i:integer;
  var f:AF_Types.TStrings;
  var flg:boolean;
begin
  flg:=false;
  thmode:='';
  thtitle:='';
  thuid:='';
  f.create;
  DateTimeToString(sd,'d',date); //       ,   
  DateTimeToString(sm,'m',date);
  DateTimeToString(sy,'yyyy',date);
  if fileexists(workdir+'\temp3.tmp') then deletefile(workdir+'\temp3.tmp');
  if fileexists(workdir+'\temp4.tmp') then deletefile(workdir+'\temp4.tmp');
  ych:=StrReplace(y_change,'@uid@',uid); //      API,   
  GetInetFile(ych,workdir+'\temp3.tmp'); //   API  
  XMLFile1(workdir+'\temp3.tmp',workdir+'\temp4.tmp'); //    
  UTF8FileDecode(workdir+'\temp4.tmp',workdir+'\temp3.tmp');
  f.loadfromfile(workdir+'\temp3.tmp');
  if f.count>0 then begin
    for i:=1 to f.count do begin //  .       ,           -     
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
        s1:=getParam('type',s);
        s2:=getParam('uid',s);
        s4:=getParam('title',s);
      end;
      if pos('<mask ',s)>0 then begin
       if s1<>'basic' then begin
        if getParam('year',s)=sy then begin
         if getParam('month',s)=sm then begin
          s3:=getParam('days',s);
          if s3[strtointe(sd)]='1' then begin
           if flg then begin
            showmessage('  '+uid+'          !');  // !          ,     .      .
            halt(1);
           end
            else begin
             thmode:=s1;
             thtitle:=s4;
             thuid:=s2;
             flg:=true;
            end;
          end;
         end;
        end;
       end;
      end;
    end;
  end;
  if fileexists(workdir+'\temp3.tmp') then deletefile(workdir+'\temp3.tmp');
  if fileexists(workdir+'\temp4.tmp') then deletefile(workdir+'\temp4.tmp');
  f.free;
end;

// ==============================================================================================================================
//  ,      ,    (      )
//          -    ,     
//   stf_b -  : ,   .       .
//   esr_b -  :          
//   title_b -  :          
//   flag_b -  :          , T -   , + -   , - -   
//   stf_1 - -: ,   .       .
//   esr_1 - -:          
//   title_1 - -:          
//   flag_1 - -:          , T -   , + -   , - -   
function calcStops(stf_b:string; esr_b,title_b,flag_b:AF_Types.PStrings; stf_1:string; esr_1,title_1,flag_1:AF_Types.PStrings):string;
 var rs:string;
 var i,n:integer;
 var cs,ns:AF_Types.TStrings;
begin
 cs.create; ns.create;
 rs:='';
 if ((esr_b.count>2)and(esr_1.count>2)) then begin //  -        2    
  for i:=1 to esr_b.count do begin //      
   n:=esr_1.SearchString(esr_b.getstring(i)); //         -
   if n>0 then begin //      
    if ((flag_b.getstring(i)='+')and(flag_1.getstring(n)='-')) then cs.add(title_1.getstring(n)); //         +,    - ( ) -     cs
   end;
  end;
  for i:=1 to esr_1.count do begin //     -
   n:=esr_b.SearchString(esr_1.getstring(i));  //          
   if n>0 then begin //      
    if ((flag_b.getstring(n)='-')and(flag_1.getstring(i)='+')) then ns.add(title_b.getstring(n)); //         -,    + ( ,     ) -     ns
   end;
  end;
 end;
 if cs.count>0 then begin //     ,     
  rs:=' : '; //   ,  
  for i:=1 to cs.count do begin
   rs:=rs+cs.getstring(i)+', ';
  end;
  rs:=copy(rs,1,length(rs)-2); //     
 end;
 if ns.count>0 then begin //     ,      
  if rs<>'' then rs:=rs+'; '; //        ,    .
  rs:=rs+' : '; //   ,  
  for i:=1 to ns.count do begin
   rs:=rs+ns.getstring(i)+', ';
  end;
  rs:=copy(rs,1,length(rs)-2); //     
 end;
 if rs<>'' then rs:=rs+'.'; //  -    ,     -     .
 cs.free; ns.free;
 result:=rs;
end;

// ==============================================================================================================================

//  .   API    ,         
//     - ,      ,          ()
procedure MainProc(stcode,direction:string; date:TDateTime; fout_x:AF_Types.PStrings);
  var yst,s,s1,s2,s3,s4,s5,s6,s7,sd,stf_b,stf_1,time1_b,time2_b,time1_1,time2_1,cmode,cuid,ctitle,stop:string;
  var i,z,cc:integer;
  var trlist_c,trlist_cn,trlist_ct,trlist_a,trlist_an,trlist_at,f,esrlist_b,stlist_b,flaglist_b,esrlist_1,stlist_1,flaglist_1:AF_Types.TStrings;
begin
  f.create; trlist_c.create; trlist_cn.create; trlist_ct.create; trlist_a.create; trlist_an.create; trlist_at.create; esrlist_b.create; stlist_b.create; flaglist_b.create; esrlist_1.create; stlist_1.create; flaglist_1.create;
  cc:=0;
  DateTimeToString(sd,'dd.mm',date); //    dd.mm
  yst:=StrReplace(y_station,'@stcode@',stcode); //        API,   -  
  GetInetFile(yst+'?old_days_format=true',workdir+'\temp1.tmp'); //   API  ,       
  XMLFile1(workdir+'\temp1.tmp',workdir+'\temp2.tmp');
  UTF8FileDecode(workdir+'\temp2.tmp',workdir+'\temp1.tmp');
  f.loadfromfile(workdir+'\temp1.tmp');
   if f.count>0 then begin
     for i:=1 to f.count do begin
       s:=f.getstring(i);
       if pos('<thread ',s)>0 then begin //      API
         s1:=getParam('uid',s);
         s2:=getParam('days',s);
         s3:=getParam('except',s);
         s4:=getParam('update',s);
         s5:=getParam('direction',s);
         s6:=getParam('number',s);
         s7:=getParam('title',s);
         if s4<>'update' then begin //      - -   .    -    .
          if s5=direction then begin  //      
           if test_athread(s2) then begin //   -
             if pos(sd,s2)>0 then begin //          
               trlist_a.add(s1); //     ,  _a uid,  _an    _at .
               trlist_an.add(s6);
               trlist_at.add(s7);
             end;
           end
            else begin //   
             if pos(sd,s3)>0 then begin //      except     (..    -    )
               trlist_c.add(s1); //     ,  _c uid,  _cn    _ct .
               trlist_cn.add(s6);
               trlist_ct.add(s7);
             end;
            end;
          end;
         end;
       end;
     end;
   end;

  if trlist_c.count>0 then begin
    for z:=1 to trlist_c.count do begin //          
      //    .    uid ,                  ,         .
      //       :
      //   esrlist_b -        
      //   stlist_b -        
      //   flaglist_b -      , T -   , + -   , - -   
      //   stf_b - ,   .       .
      //   time1_b - ,       
      //   time2_b - ,       
      getThreadInfo(trlist_c.getstring(z),@esrlist_b,@stlist_b,@flaglist_b,stf_b,time1_b,time2_b);
      //          .    uid   
      //        
      //   cmode -  , -   
      //   ctitle -  () 
      //   cuid - uid  
      findChgThread(trlist_c.getstring(z),date,cmode,ctitle,cuid);
      //        
      if cmode='cancel' then begin //       
           fout_x.add('&bull; <b>.'+trlist_cn.getstring(z)+'</b> '+trlist_ct.getstring(z)+' .'+time1_b+' .'+time2_b+'<br/>');
           fout_x.add('&nbsp;&nbsp;&nbsp;&nbsp;<font color="red">ͨ!</font><br/>');
           fout_x.add('<br/>');
          inc(cc);
       end
        else begin  //       ( -)
          //     -.    uid ,                  ,         .
          //       :
          //   esrlist_1 -        
          //   stlist_1 -        
          //   flaglist_1 -      , T -   , + -   , - -   
          //   stf_1 - ,   .       .
          //   time1_1 - ,       
          //   time2_1 - ,       
          getThreadInfo(cuid,@esrlist_1,@stlist_1,@flaglist_1,stf_1,time1_1,time2_1);
          //       ,           (      ).       ,   getThreadInfo -    ,     
          //   stf_b -  : ,   .       .
          //   esrlist_b -  :          
          //   stlist_b -  :          
          //   flaglist_b -  :          , T -   , + -   , - -   
          //   stf_1 - -: ,   .       .
          //   esrlist_1 - -:          
          //   stlist_1 - -:          
          //   flaglist_1 - -:          , T -   , + -   , - -   
          stop:=calcStops(stf_b,@esrlist_b,@stlist_b,@flaglist_b,stf_1,@esrlist_1,@stlist_1,@flaglist_1);
           fout_x.add('&bull; <b>.'+trlist_cn.getstring(z)+'</b> '+trlist_ct.getstring(z)+' .'+time1_b+' .'+time2_b+'<br/>');
           if trlist_ct.getstring(z)=ctitle then begin //        -
              fout_x.add('&nbsp;&nbsp;&nbsp;&nbsp;   : .'+time1_1+' .'+time2_1+'<br/>'); //      
             if stop<>'' then begin //       
                fout_x.add('&nbsp;&nbsp;&nbsp;&nbsp;'+stop+'<br/>'); //     
             end;
           end
            else begin //       -    ()...
             if length(stf_1)<length(stf_b) then begin //           
                                               fout_x.add('&nbsp;&nbsp;&nbsp;&nbsp;    '+ctitle+': .'+time1_1+' .'+time2_1+'<br/>') //      
                                            end
                                            else begin //      
                                               fout_x.add('&nbsp;&nbsp;&nbsp;&nbsp;    '+ctitle+': .'+time1_1+' .'+time2_1+'<br/>'); //     
                                            end;
             if stop<>'' then begin //         
                fout_x.add('&nbsp;&nbsp;&nbsp;&nbsp;'+stop+'<br/>'); //     
             end;
            end;
          fout_x.add('<br/>');
          inc(cc); //   
        end;
    end;
  end;

  if trlist_a.count>0 then begin //   -  
    for z:=1 to trlist_a.count do begin //     
      //     -.    uid ,                  ,         .
      //       :
      //   esrlist_b -        
      //   stlist_b -        
      //   flaglist_b -      , T -   , + -   , - -   
      //   stf_b - ,   .       .
      //   time1_b - ,       
      //   time2_b - ,       
      getThreadInfo(trlist_a.getstring(z),@esrlist_b,@stlist_b,@flaglist_b,stf_b,time1_b,time2_b);
      //    ,    , ,    .
      fout_x.add('<font color="navy"></font> <b>.'+trlist_an.getstring(z)+'</b> '+trlist_at.getstring(z)+' .'+time1_b+' .'+time2_b+'<br/>');
      fout_x.add('<br/>');
      inc(cc); //   
    end;
  end;

  if cc=0 then begin //    
     fout_x.add('&nbsp;&nbsp;&nbsp;&nbsp;<b><font color="green"> !</b></font><br/>'); //    
  end;

  if fileexists(workdir+'\temp1.tmp') then deletefile(workdir+'\temp1.tmp');
  if fileexists(workdir+'\temp2.tmp') then deletefile(workdir+'\temp2.tmp');
  f.free; trlist_c.free; trlist_cn.free; trlist_ct.free; trlist_a.free; trlist_an.free; trlist_at.free; esrlist_b.free; stlist_b.free; flaglist_b.free; esrlist_1.free; stlist_1.free; flaglist_1.free;
end;

// ==============================================================================================================================

function getNextDate(dd:string):TDateTime; //      ( 1  7),    . .. getNextDate('5')   13    20 .
  var dt:TDateTime;
  var i:integer;
  var d1:word;
begin
 dt:=date;
 for i:=1 to 7 do begin
   dt:=dt+1;
   d1:=DayOfTheWeek(dt);
   if d1=strtointe(dd) then break;
 end;
 result:=dt;
end;

function getNextDate2(dd:string):TDateTime; //   
  var dt:TDateTime;
  var i:integer;
  var d1:word;
begin
 result:=date+1;
end;

// ==============================================================================================================================

function TextDayOfTheWeek(dt:TDateTime):string; //      
 begin
   result:='???';
   case DayOfTheWeek(dt) of
     1: result:='';
     2: result:='';
     3: result:='';
     4: result:='';
     5: result:='';
     6: result:='';
     7: result:='';
   end;
 end;

// ==============================================================================================================================

procedure TForm1.Button1Click(Sender: TObject);
  var f,u,fo_x:AF_Types.TStrings;
  var i,dx:integer;
  var dt:TDateTime;
  var ds:string;
begin
 dt:=0;
 //    -          
 //   :  direction_titie ; stcode1 ; stname1 ; subdir1 ; title1 ; day1 ;  stcode2 ; stname2 ; subdir2 ; title2 ; day2
 // :             ; 191602 ; - ;   ;  ; 5 ; 193735 ;    ;   ;  ; 7
 //   direction_title -  ,     
 //   stcode1 - - ,       " ".   .
 //   stname1 -  ,       " ".    .
 //   subdir1 -    ,       " ".   .
 //   title1 -   " ",     .
 //   day1 -       " ",   .
 //   stcode2 - - ,       " ".   .
 //   stname2 -  ,       " ".    .
 //   subdir2 -    ,       " ".   .
 //   title2 -   " ",     .
 //   day2 -       " ",   .
 //
 //   ,        .     ,          .         .
 //
 //       -     ,        0 ,   0 .          -      .
 //
 //                ,          MainProc -  day1, day1+1, day2, day2+1.          .
 DateTimeToString(ds,'dd_mm_yyyy',date); //   
 SaveDialog1.FileName:='  '+ds+'.txt';
 if SaveDialog1.Execute then begin //     
  f.create; u.create; fo_x.create;
  f.loadfromfile(workdir+'\worklist.txt'); //      ,  TSTringList;
  if f.count>0 then begin
   // fo_x -         HTML

   //    -  " "
   fo_x.add('<html>');
   fo_x.add('<head>');
   fo_x.add('<meta http-equiv="content-type" content="text/html; charset=windows-1251">');
   fo_x.add('</head>');
   fo_x.add('<body>');
   fo_x.add('   <a href="https://rasp.yandex.ru/">"."</a><br/><hr/><br/>');
   for i:=1 to f.count do begin //    
     ParseCSVStrEx(@u,f.getstring(i),#9);
     if u.count>5 then begin
      if u.getstring(2)<>'' then begin
       dt:=getNextDate2(u.getstring(6)); //    
       fo_x.add('<h3>'+u.getstring(1)+': '+u.getstring(5)+'  '+DateToStr(dt)+' ('+TextDayOfTheWeek(dt)+')</h3>'); //    
       fo_x.add('<br/>');
       MainProc(u.getstring(2),u.getstring(4),dt,@fo_x); //  ,    ,   ,         
       fo_x.add('<br/>');
       //   6     .     ,   .
       for dx:=1 to 6 do begin
        fo_x.add('<hr/><br/>');
        fo_x.add('<h3>'+u.getstring(1)+': '+u.getstring(5)+'  '+DateToStr(dt+dx)+' ('+TextDayOfTheWeek(dt+dx)+')</h3>');
        fo_x.add('<br/>');
        MainProc(u.getstring(2),u.getstring(4),dt+dx,@fo_x);
        fo_x.add('<br/>');
       end;
      end;
     end;
   end;
   //       
   fo_x.add('   <a href="https://rasp.yandex.ru/">"."</a>');
   fo_x.add('</body>');
   fo_x.add('</html>');
   fo_x.savetofile(ExtractDirPath(SaveDialog1.FileName)+'\__'+DateToStr(dt)+'__'+DateToStr(dt+6)+'__.htm');
   fo_x.clear;

   //    -  " "
   fo_x.add('<html>');
   fo_x.add('<head>');
   fo_x.add('<meta http-equiv="content-type" content="text/html; charset=windows-1251">');
   fo_x.add('</head>');
   fo_x.add('<body>');
   fo_x.add('   <a href="https://rasp.yandex.ru/">"."</a><br/><hr/><br/>');
   for i:=1 to f.count do begin //    
     ParseCSVStrEx(@u,f.getstring(i),#9);
     if u.count>6 then begin
      if u.getstring(7)<>'' then begin
       dt:=getNextDate2(u.getstring(11)); //    
       fo_x.add('<h3>'+u.getstring(1)+': '+u.getstring(10)+'  '+DateToStr(dt)+' ('+TextDayOfTheWeek(dt)+')</h3>');
       fo_x.add('<br/>');
       MainProc(u.getstring(7),u.getstring(9),dt,@fo_x); //  ,    ,   ,         
       fo_x.add('<br/>');
       //   6     .     ,   .
       for dx:=1 to 6 do begin
        fo_x.add('<hr/><br/>');
        fo_x.add('<h3>'+u.getstring(1)+': '+u.getstring(10)+'  '+DateToStr(dt+dx)+' ('+TextDayOfTheWeek(dt+dx)+')</h3>');
        fo_x.add('<br/>');
        MainProc(u.getstring(7),u.getstring(9),dt+dx,@fo_x);
        fo_x.add('<br/>');
       end;
      end;
     end;
   end;
  end;
   //       
   fo_x.add('   <a href="https://rasp.yandex.ru/">"."</a>');
   fo_x.add('</body>');
   fo_x.add('</html>');
   fo_x.savetofile(ExtractDirPath(SaveDialog1.FileName)+'\_c_'+DateToStr(dt)+'__'+DateToStr(dt+6){+'__'+DateToStr(dt+2)}+'__.htm');

  f.free; u.free; fo_x.free;
  showmessage('!');
 end;
end;

// ==============================================================================================================================

procedure TForm1.FormCreate(Sender: TObject);
begin
  workdir:=DeleteSlasheEx(ExtractDirPath(Application.ExeName));
end;

end.
