unit Unit1;


interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, Buttons, ExtCtrls, AF_Types, ComCtrls,
  OleServer, ExcelXP, FileCtrl, DateUtils, Registry;

const
 PZList:array[0..1] of string[50] = ('','-');
 pversion:string='3.1';
 mntlist:array[1..12] of string[30] = ('', '', '', '', '', '', '', '', '', '', '', '');


type
  gType = (gTime, gTire, gBlank);
  TTimetable1 = packed record
    t1,t2,st,mfs:string[10];
  end;
  TXMLel = packed record
    mode,back,num,stn,sto,time,chtime,txt: string;
  end;
  gNextDate = (ndNone, ndNight, ndNextNight);
  TForm1 = class(TForm)
    LabeledEdit1: TLabeledEdit;
    SpeedButton1: TSpeedButton;
    StringGrid1: TStringGrid;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    XLApp: TExcelApplication;
    StatusBar1: TStatusBar;
    LabeledEdit2: TLabeledEdit;
    SpeedButton2: TSpeedButton;
    OpenDialog2: TOpenDialog;
    StringGrid2: TStringGrid;
    Button1: TButton;
    ListBox1: TListBox;
    StringGrid3: TStringGrid;
    StringGrid4: TStringGrid;
    CheckBox1: TCheckBox;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    CheckBox2: TCheckBox;
    Button2: TButton;
    CheckBox3: TCheckBox;
    procedure SpeedButton1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  lh,lm,lmfs,_fccount:integer;
  xmlexp,log,ofile,_trnlist,f1list,skl,skl1,workdaylist,holidaylist,workdaylist_cppk,holidaylist_cppk: AF_Types.TStrings;
  mtrain: string;
  _dt11,_dt1,_dt2:TDateTime;
  _errorflag:boolean;

implementation

uses AF_Proc, unit2, Unit3;

{$R *.dfm}

Function StrToIntE1(s:string):integer;
  var i,t:integer;
begin
   val(s,i,t);
   if t<>0 then begin
             StrToIntE1:=0;
             log.add('   '+mtrain+'.    : "'+s+'"');
             _errorflag:=true;
           end
           else StrToIntE1:=i;
end;

procedure xhm(var h,m:integer);
  begin
    if m>59 then begin
      inc(h,(m div 60));
      m:=m mod 60;
    end;
    if h>23 then begin
     h:=h-24;
    end;
  end;

procedure dechm(var h,m:integer; t:integer);
  begin
    if (m-t)<0 then begin
      m:=60+(m-t);
      dec(h);
        if h<0 then h:=23;
    end
      else dec(m,t);
  end;

procedure inchm(var h,m:integer; t:integer);
  begin
    inc(m,t);
    xhm(h,m);
  end;

procedure tohm(s:string; var h,m:integer);
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    if pos(':',s)>0 then begin
      h:=StrToIntE1(copy(s,1,pos(':',s)-1));
      m:=StrToIntE1(copy(s,pos(':',s)+1,100));
    end
     else begin
       log.add('   '+mtrain+'.    : "'+s+'"');
       _errorflag:=true;
     end;
  end;

function prephm(s:string):string;
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    result:=s;
  end;        

function fromhm(h,m:integer):string;
  begin
    xhm(h,m);
    if h>9 then begin
             if m>9 then fromhm:=inttostr(h)+':'+inttostr(m)
                    else fromhm:=inttostr(h)+':0'+inttostr(m);
           end
           else begin
             if m>9 then fromhm:='0'+inttostr(h)+':'+inttostr(m)
                    else fromhm:='0'+inttostr(h)+':0'+inttostr(m);
           end;
  end;


procedure ClearSG;
 var i,n:integer;
begin
 for i:=0 to form1.StringGrid1.ColCount do
  for n:=0 to form1.StringGrid1.RowCount do form1.StringGrid1.Cells[i,n]:='';
end;

procedure ClearSG1(sg:TStringGrid);
 var i,n:integer;
begin
 for i:=0 to sg.ColCount do
  for n:=0 to sg.RowCount do sg.Cells[i,n]:='';
end;

procedure ParseCSVStr(ts:AF_Types.PStrings; s:widestring);
 var n:integer;
begin
  ts.clear;
  while pos(';',s)>0 do begin
    n:=pos(';',s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;

procedure ParseCSVStrEx(ts:AF_Types.PStrings; s:widestring; c:char);
 var n:integer;
begin
  ts.clear;
  while pos(c,s)>0 do begin
    n:=pos(c,s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;

function PrepareTT(s:string;n,n1,n2,mfs:integer):TTimetable1;
 var r:boolean;
 var h,m,h1,m1,h2,m2,x:integer;
begin
  result.t1:='';
  result.t2:='';
  Result.st:='';
  Result.mfs:='';
  r:=true;
  if n=n1 then begin
    if pos('/',s)>0 then s:=copy(s,pos('/',s)+1,length(s)-pos('/',s));
    tohm(s,h,m);
    lh:=h; lm:=m; lmfs:=0;
    result.t2:=prephm(s);
    result.mfs:='0';
    r:=false;
  end;
  if n=n2 then begin
    if pos('/',s)>0 then s:=copy(s,1,pos('/',s)-1);
    tohm(s,h1,m1);
    result.t1:=prephm(s);
    r:=false;
      for x:=1 to 1439 do begin
        inchm(lh,lm,1);
        inc(lmfs,1);
        if (lh=h1) and (lm=m1) then break;
      end;
      result.mfs:=inttostr(lmfs);
  end;
  if r then
        if pos('-',s)>0 then begin
           Result.st:='-';
           r:=false;
        end;
  if r then begin
    if pos('/',s)>0 then begin
      tohm(copy(s,1,pos('/',s)-1),h,m);
      tohm(copy(s,pos('/',s)+1,length(s)-pos('/',s)),h1,m1);
      h2:=h; m2:=m;
      for x:=1 to 1439 do begin
        inchm(h2,m2,1);
        if (h2=h1) and (m2=m1) then break;
      end;
      result.t1:=fromhm(h,m);
      result.t2:=fromhm(h1,m1);
      result.st:=inttostr(x);
    end
     else begin
       tohm(s,h,m);
       h1:=h; m1:=m;
       dechm(h,m,1);
       result.t1:=fromhm(h,m);
       result.t2:=fromhm(h1,m1);
       Result.st:='1';
     end;
      for x:=1 to 1439 do begin
        inchm(lh,lm,1);
        inc(lmfs,1);
        if (lh=h) and (lm=m) then break;
      end;
      result.mfs:=inttostr(lmfs);
  end;
end;


function CalcThread(n,o:integer): WideString;
 var i,n1,n2,h,m,h1,m1,t:integer;
 var s:WideString;
 var tt:TTimetable1;
begin
  n1:=0;
  n2:=0;
  s:='';
  for i:=4 to 301 do begin
    n1:=i;
    if form1.StringGrid1.Cells[n,i]<>'' then break;
  end;
  for i:=301 downto 4 do begin
    n2:=i;
    if form1.StringGrid1.Cells[n,i]<>'' then break;
  end;
  if n2>n1 then begin
    lh:=0;
    lm:=0;
    lmfs:=0;
    mtrain:=form1.StringGrid1.Cells[n,0];
//    if form1.checkbox1.checked then ofile.add('  <thread id="1">');
    for i:=n1 to n2 do begin
    if form1.StringGrid1.Cells[n,i]<>'' then begin
      tt:=PrepareTT(form1.StringGrid1.Cells[n,i],i,n1,n2,0);
      if strtointe(tt.st)>150 then begin
        log.add('   '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st);
        _errorflag:=true;
      end;
      ofile.add('    <station esrcode="'+form1.StringGrid1.Cells[0,i]+'" stname="'+form1.StringGrid1.Cells[1,i]+'" arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'" />');
    end;
    end;
    if StrToIntE(tt.mfs)>480 then begin
      log.add('   '+mtrain+'. : MFS='+tt.mfs);
      _errorflag:=true;
    end;
//    if form1.checkbox1.checked then ofile.add('  </thread>');
  end;
  result:=s;
end;

function PrepareStr1(s:string):string;
 var l,n,m:integer;
begin
  while pos('"',s)>0 do s[pos('"',s)]:='`';
  if s='?' then s:='-';
//  if s='' then s:='';
  l:=length(s);
  n:=pos(',',s);
  if (n=l-1)and(n>0) then s:=s+'0';
  s:=StrReplace(s,',',':');
  s:=StrReplace(s,'.',':');
  l:=length(s);
  n:=pos(':',s);
  if n=2 then s:='0'+s;
  result:=AnsiLowerCase(s);
end;

function a0(s:string):string;
begin
 if length(s)=1 then result:='0'+s
                else result:=s;
end;

function vDate(s,_trn:string):string;
  var i,d,m,m2,y,y2:integer;
  var d1,m1,s1,d2:string;
  var tds:AF_Types.TStrings;
  var d3,ld:TDateTime;
begin
if s<>'_' then begin
  ld:=0;
  tds.create;
  result:='';
  s:=Trim(s);
  m2:=StrToIntE(FormatDateTime('mm',Date));
  y2:=StrToIntE(FormatDateTime('yyyy',Date));
 ParseCSVStrEx(@tds,s,',');
 if tds.count>0 then begin
 for i:=1 to tds.count do begin
  s1:=tds.getstring(i);
  if pos('.',s1)>1 then begin
    d:=strtointe(copy(s1,1,pos('.',s1)-1));
    m:=strtointe(copy(s1,pos('.',s1)+1,length(s1)-pos('.',s1)));
    if ((d>0) and (m>0)) then begin
      if ((m<m2)and(m2>=11)) then y:=y2+1
                            else y:=y2;
      d2:=inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d));
      d3:=EncodeDate(y,m,d);
      if d3<_dt11 then _dt11:=d3;
      if d3>=date then begin
        result:=result+inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d))+';';
        inc(_fccount);
        if d3<_dt1 then _dt1:=d3;
      end
       else log.add('           '+_trn+'.    ('+inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d))+')!');
      if d3<(date-3) then begin
        log.add('   '+_trn+'.   -3    ('+inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d))+')!');
//        if not Form1.CheckBox1.Checked then _errorflag:=true;
      end;
      if d3>(date+45) then begin
        log.add('   '+_trn+'.   +45    ('+inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d))+')!');
//        if not Form1.CheckBox1.Checked then _errorflag:=true;
      end;
      if d3>_dt2 then _dt2:=d3;
      if d3>ld then ld:=d3;
    end;
  end;
 end;
  if length(result)>0 then begin
   if result[length(result)]=';' then result:=copy(result,1,length(result)-1);
  end;
 end;
{     if (form1.CheckBox1.checked)and(length(s)=0) then begin
       result:=formatdatetime('yyyy-mm-dd',form1.DateTimePicker1.DateTime);
     end;
}  tds.free;
  if result='' then result:='N';
end
 else result:='_';
end;


function vDateCPPK(s,_trn:string):string;
  var i,d,m,m2,y,y2:integer;
  var d1,m1,s1,d2:string;
  var tds:AF_Types.TStrings;
  var d3,ld:TDateTime;
begin
if s<>'_' then begin
  ld:=0;
  tds.create;
  result:='';
  s:=Trim(s);
  m2:=StrToIntE(FormatDateTime('mm',Date));
  y2:=StrToIntE(FormatDateTime('yyyy',Date));
 ParseCSVStrEx(@tds,s,',');
 if tds.count>0 then begin
 for i:=1 to tds.count do begin
  s1:=tds.getstring(i);
  if pos('.',s1)>1 then begin
    d:=strtointe(copy(s1,1,pos('.',s1)-1));
    m:=strtointe(copy(s1,pos('.',s1)+1,length(s1)-pos('.',s1)));
    if ((d>0) and (m>0)) then begin
      if ((m<m2)and(m2>=11)) then y:=y2+1
                            else y:=y2;
      d2:=inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d));
      d3:=EncodeDate(y,m,d);
      if d3<_dt11 then _dt11:=d3;
      if d3>=date then begin
        result:=result+inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d))+';';
        inc(_fccount);
        if d3<_dt1 then _dt1:=d3;
      end
       else log.add('           '+_trn+'.    ('+inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d))+')!');
      if d3<(date-3) then begin
        log.add('   '+_trn+'.   -3    ('+inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d))+')!');
//        if not Form1.CheckBox1.Checked then _errorflag:=true;
      end;
      if d3>(date+45) then begin
        log.add('   '+_trn+'.   +45    ('+inttostr(y)+'-'+a0(inttostr(m))+'-'+a0(inttostr(d))+')!');
//        if not Form1.CheckBox1.Checked then _errorflag:=true;
      end;
      if d3>_dt2 then _dt2:=d3;
      if d3>ld then ld:=d3;
    end;
  end;
 end;
  if length(result)>0 then begin
   if result[length(result)]=';' then result:=copy(result,1,length(result)-1);
  end;
 end;
{     if (form1.CheckBox1.checked)and(length(s)=0) then begin
       result:=formatdatetime('yyyy-mm-dd',form1.DateTimePicker1.DateTime);
     end;
}  tds.free;
  if result='' then result:='N';
end
 else result:='_';
end;


function PrepareTTime(s:string):string;
   function _nn(_s:string):boolean;
     var _n,_i:integer;
   begin
     _n:=0;
     for _i:=1 to length(_s) do begin
       if not (_s[_i] in ['0'..'9']) then inc(_n);
     end;
     if _n=0 then result:=true
             else result:=false;
   end;
   function _nz(_s:string):boolean;
     var _n,_i:integer;
   begin
     _n:=0;
     for _i:=1 to length(_s) do begin
       if not (_s[_i] in ['0'..'9',':']) then inc(_n);
     end;
     if _n=0 then begin
         for _i:=1 to length(_s) do begin
           if _s[_i]=':' then inc(_n);
         end;
       if (_n=1)and(s[length(s)-1]=':') then result:=true
               else result:=false;
     end
             else result:=false;
   end;
   function _nx(_s:string):boolean;
     var _n,_i:integer;
   begin
     _n:=0;
     if length(s)>2 then begin
     for _i:=1 to length(_s) do begin
       if not (_s[_i] in ['0'..'9','.']) then inc(_n);
     end;
     if _n=0 then begin
         for _i:=1 to length(_s) do begin
           if _s[_i]='.' then inc(_n);
         end;
       if (_n=1)and(s[2]='.')and(s[1]='0') then result:=true
               else result:=false;
     end
             else result:=false;
     end
             else result:=false;
   end;
begin
 if length(s)>0 then begin

   if pos('@',s)>0 then s:=trim(copy(s,1,pos('@',s)-1));

   while pos('/',s)>0 do s:=copy(s,pos('/',s)+1,length(s)-pos('/',s));

   if (_nz(s))and(length(s)>4) then begin
//     time
   end;
   if length(s)>0 then begin
    if length(s)>3 then while pos('-',s)>0 do s[pos('-',s)]:=':';
     while pos(',',s)>0 do s[pos(',',s)]:=':';
     while pos('.',s)>0 do s[pos('.',s)]:=':';
   end;
   if _nn(s) then begin
     if length(s)<3 then s:=s+':00';
   end
    else begin
      if _nz(s) then s:=s+'0';
    end;
   if s='?' then s:='-';

   if length(s)=4 then begin
     if s[1] in ['0'..'9'] then s:='0'+s;
   end;

   result:=s;
 end
  else result:='';
end;

function ExtractPlatf(s:string):string;
begin
  result:='';
  if pos('@',s)>0 then begin
    if pos('@',s)<>length(s) then begin
      result:=trim(copy(s,pos('@',s)+1,length(s)-pos('@',s)));
    end;
  end;
end;

procedure LoadChgFromXLS(sg,sg1:TStringGrid; fn:string);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
K, R, X, Y, xx, yy : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf:string;
tf:double;
begin
with form1 do begin
NomFich := fn;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
sg.ColCount := Y;
sg.RowCount := X;
sg1.ColCount := Y;
sg1.RowCount := X;
clearsg1(sg);
clearsg1(sg1);
{RangeMatrix := XLApp.Range['A1',XLApp.Cells.Item[X,Y]].Value2;
K := 1;
repeat
for R := 1 to Y do StringGrid1.Cells[R-1,K-1] := VarToStrDef(RangeMatrix[K,R],'');
Inc(K);
until K > X;}
for xx:=1 to x do begin
  for yy:=1 to y do begin
    nf:=worksheet.cells.item[xx,yy].NumberFormat;
    if (nf=':')or(nf=':')or(nf='h:mm')or(nf='hh:mm;@')or(nf=':;@')or(nf=':;@')or(nf='h:mm;@')or(nf='hh:mm;@') then begin
       tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xx,yy]),70);
       if tf=70 then begin
                       sg.Cells[yy-1,xx-1]:=VarToStrDef(worksheet.cells.item[xx,yy],'');
                       sg1.Cells[yy-1,xx-1]:=ExtractPlatf(VarToStrDef(worksheet.cells.item[xx,yy],''));
                     end
                     else sg.Cells[yy-1,xx-1]:=FormatDateTime('hh:nn',tf);
    end
     else begin
       sg.Cells[yy-1,xx-1]:=VarToStrDef(worksheet.cells.item[xx,yy],'');
       sg1.Cells[yy-1,xx-1]:=ExtractPlatf(VarToStrDef(worksheet.cells.item[xx,yy],''));
     end;
  end;
end;


XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;
end;
end;

function numbprep(s:string):string;
begin
 if pos('#',s)>0 then s:=trim(copy(s,1,pos('#',s)-1));
 result:=s;
end;


procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then labeledEdit1.Text:=OpenDialog1.filename;
end;

function vDate2(s:string):string;
  var t:AF_Types.TStrings;
  var i1:integer;
  var s1,s2:string;
  var fs:TFormatSettings;
begin
 t.create;
 ParseCSVStr(@t,s);
 fs.DateSeparator:='-';
 fs.ShortDateFormat:='yyyy-mm-dd';
 fs.LongDateFormat:='yyyy-mm-dd';
 s1:='';
    if t.count>0 then begin
      for i1:=1 to t.count do begin
        if length(t.getstring(i1))>3 then begin
        s2:=inttostr(trunc(strtodate(t.getstring(i1),fs)));
        s1:=s1+s2+';';
        end;
      end;
      if length(s1)>0 then
       if s1[length(s1)]=';' then s1:=copy(s1,1,length(s1)-1);
    end;
 t.free;
 result:=s1;
end;

function vDate2cppk(s:string):string;
  var t:AF_Types.TStrings;
  var i1:integer;
  var s1,s2:string;
  var fs:TFormatSettings;
begin
{ t.create;
 ParseCSVStr(@t,s);
 fs.DateSeparator:='-';
 fs.ShortDateFormat:='yyyymmdd';
 fs.LongDateFormat:='yyyymmdd';
 s1:='';
    if t.count>0 then begin
      for i1:=1 to t.count do begin
        if length(t.getstring(i1))>3 then begin
        s2:=inttostr(trunc(strtodate(t.getstring(i1),fs)));
        s1:=s1+s2+';';
        end;
      end;
      if length(s1)>0 then
       if s1[length(s1)]=';' then s1:=copy(s1,1,length(s1)-1);
    end;
 t.free;
 result:=s1; }
 result:=s;
end;

function CalcDate(s:string):string;
  var t:AF_Types.TStrings;
  var i1,i2:integer;
  var s1,s2,s3,dl,dd:string;
  var fs:TFormatSettings;
  var dt:TDateTime;
  var zm:char;
begin
 dt:=date-1;
 s1:='';
 s:=trim(ansilowercase(s));
 if pos('_',s)>0 then s:='';
 if pos('',s)>0 then s:='';
 if pos('',s)>0 then s:='';
 if s<>'' then begin
   dl:='1234567';
   zm:=#0;
   if s='' then begin dl:='67'; zm:=''; end;
   if s='' then begin dl:='12345'; zm:=''; end;
   if s='' then begin dl:='567'; zm:=''; end;
   if s='' then begin dl:='1234'; zm:=''; end;
   if s='' then dl:='6';
   if s='' then dl:='6';
   if s='' then dl:='123457';
   if s='' then dl:='7';
   if s='' then dl:='7';
   if s='' then dl:='123456';
   if s='' then dl:='5';
   if s='' then dl:='5';
   if s='' then dl:='123467';
   if s='' then dl:='56';
   if s=',,' then dl:='567';
   if s='' then dl:='12347';
   for i1:=0 to 75 do begin
     dt:=dt+1;
     dd:=inttostr(DayOfTheWeek(dt));
     if pos(dd,dl)>0 then begin
       case zm of
         '': begin
               s3:=inttostr(trunc(dt));
               if holidaylist.SearchString(s3)<=0 then s1:=s1+s3+';';
               if workdaylist.count>0 then begin
                 for i2:=1 to workdaylist.count do s1:=s1+workdaylist.getstring(i2)+';';
               end;
              end;
         '': begin
               s3:=inttostr(trunc(dt));
               if workdaylist.SearchString(s3)<=0 then s1:=s1+s3+';';
               if holidaylist.count>0 then begin
                 for i2:=1 to holidaylist.count do s1:=s1+holidaylist.getstring(i2)+';';
               end;
              end;
         else begin
               s1:=s1+inttostr(trunc(dt))+';';
              end;
       end;
     end;
   end;
   if s1[length(s1)]=';' then s1:=copy(s1,1,length(s1)-1);
 end;
 result:=s1;
end;

function CalcDateCPPK(s:string):string;
  var t:AF_Types.TStrings;
  var i1,i2:integer;
  var s1,s2,s3,dl,dd:string;
  var fs:TFormatSettings;
  var dt:TDateTime;
  var zm:char;
begin
 dt:=date-1;
 s1:='';
 s:=trim(ansilowercase(s));
 if pos('_',s)>0 then s:='';
 if pos('',s)>0 then s:='';
 if pos('',s)>0 then s:='';
 if s<>'' then begin
   dl:='1234567';
   zm:=#0;
   if s='' then begin dl:='67'; zm:=''; end;
   if s='' then begin dl:='12345'; zm:=''; end;
   if s='' then begin dl:='567'; zm:=''; end;
   if s='' then begin dl:='1234'; zm:=''; end;
   if s='' then dl:='6';
   if s='' then dl:='6';
   if s='' then dl:='123457';
   if s='' then dl:='7';
   if s='' then dl:='7';
   if s='' then dl:='123456';
   if s='' then dl:='5';
   if s='' then dl:='5';
   if s='' then dl:='123467';
   if s='' then dl:='56';
   if s='' then dl:='12347';
   for i1:=0 to 45 do begin
     dt:=dt+1;
     dd:=inttostr(DayOfTheWeek(dt));
     if pos(dd,dl)>0 then begin
       case zm of
         '': begin
               s3:=FormatDateTime('yyyy-mm-dd',dt);
               if holidaylist_cppk.SearchString(s3)<=0 then s1:=s1+s3+';';
              end;
         '': begin
               s3:=FormatDateTime('yyyy-mm-dd',dt);
               if workdaylist_cppk.SearchString(s3)<=0 then s1:=s1+s3+';';
              end;
         else begin
               s1:=s1+FormatDateTime('yyyy-mm-dd',dt)+';';
              end;
       end;
     end;
   end;
               if workdaylist_cppk.count>0 then begin
                 for i2:=1 to workdaylist_cppk.count do s1:=s1+workdaylist_cppk.getstring(i2)+';';
               end;
               if holidaylist_cppk.count>0 then begin
                 for i2:=1 to holidaylist_cppk.count do s1:=s1+holidaylist_cppk.getstring(i2)+';';
               end;

   if s1[length(s1)]=';' then s1:=copy(s1,1,length(s1)-1);
 end;
 result:=s1;
end;


function GetNB(m:integer):string;
 var i,im:integer;
 var sg:TStringGrid;
begin
  sg:=form1.StringGrid2;
  for i:=2 to sg.RowCount-1 do begin
    im:=i;
    if length(sg.cells[m,i])>1 then break;
  end;
  result:=sg.Cells[0,im];
end;

function GetNB1(m:integer):integer;
 var i,im:integer;
 var sg:TStringGrid;
begin
  sg:=form1.StringGrid2;
  for i:=2 to sg.RowCount-1 do begin
    im:=i;
    if length(sg.cells[m,i])>1 then break;
  end;
  result:=im;
end;

function GetNC(m:integer):string;
 var i,im:integer;
 var sg:TStringGrid;
begin
  if strtointe(form1.StringGrid1.cells[m,3])>0 then result:=form1.StringGrid1.cells[m,3]
    else begin
  sg:=form1.StringGrid1;
  for i:=4 to sg.RowCount-1 do begin
    im:=i;
    if length(sg.cells[m,i])>1 then break;
  end;
  result:=sg.Cells[0,im];
    end;
end;

function GetNC1a(m:integer):integer;
 var i,im:integer;
 var sg:TStringGrid;
begin
  sg:=form1.StringGrid1;
  for i:=4 to sg.RowCount-1 do begin
    im:=i;
    if length(sg.cells[m,i])>1 then break;
  end;
  result:=im;
end;

function GetEB(m:integer):string;
 var i,im:integer;
 var sg:TStringGrid;
begin
  sg:=form1.StringGrid2;
  for i:=sg.RowCount-1 downto 2 do begin
    im:=i;
    if length(sg.cells[m,i])>1 then break;
  end;
  result:=sg.Cells[0,im];
end;

function GetEB1(m:integer):integer;
 var i,im:integer;
 var sg:TStringGrid;
begin
  sg:=form1.StringGrid2;
  for i:=sg.RowCount-1 downto 2 do begin
    im:=i;
    if length(sg.cells[m,i])>1 then break;
  end;
  result:=im;
end;

function GetEC(m:integer):string;
 var i,im:integer;
 var sg:TStringGrid;
begin
  sg:=form1.StringGrid1;
  for i:=sg.RowCount-1 downto 4 do begin
    im:=i;
    if length(sg.cells[m,i])>1 then break;
  end;
  result:=sg.Cells[0,im];
end;

function GetEC1(m:integer):integer;
 var i,im:integer;
 var sg:TStringGrid;
begin
  sg:=form1.StringGrid1;
  for i:=sg.RowCount-1 downto 4 do begin
    im:=i;
    if length(sg.cells[m,i])>1 then break;
  end;
  result:=im;
end;

function GetBST(st:string):integer;
  var t:AF_Types.TStrings;
  var i:integer;
begin
  t.create;
  for i:=0 to form1.StringGrid2.RowCount-1 do t.add(form1.stringgrid2.cells[0,i]);
  result:=t.SearchString(st)-1;
   if result<0 then ShowMessage('      '+st);
  t.free;
end;

function GetCST(st:string):integer;
  var t:AF_Types.TStrings;
  var i:integer;
begin
  t.create;
  for i:=0 to form1.StringGrid1.RowCount-1 do t.add(form1.stringgrid1.cells[0,i]);
  result:=t.SearchString(st)-1;
   if result<0 then ShowMessage('     '+st);
  t.free;
end;

function FindBaseTrain(num,nst,dte:string):integer;
  var i,m:integer;
  var t:AF_Types.TStrings;
begin
  t.create;
  m:=0;
  for i:=2 to form1.stringgrid2.colcount-1 do begin
    if form1.StringGrid2.Cells[i,0]=num then begin
    if GetNB(i)=nst then begin
      ParseCSVStr(@t,form1.StringGrid2.Cells[i,1]);
       if t.SearchString(dte)>0 then m:=i;
    end;
    end;
  end;
  t.free;
  if m=0 then begin
     if not form1.CheckBox3.checked then ShowMessage('  "'+num+'"    ! "'+nst+'" "'+dte+'"');
  end;
  result:=m;
end;

function isDate(dt,dtl:string):boolean;
  var r:boolean;
  var t:AF_Types.TStrings;
begin
 r:=false;
 t.create;
 ParseCSVStr(@t,dtl);
  if t.count>0 then begin
    if t.SearchString(dt)>0 then r:=true;
  end;
 t.free;
 result:=r;
end;

procedure l2exp(ts:AF_Types.PStrings);
 var i:integer;
begin
 if ts.count>0 then begin
   for i:=1 to ts.count do form1.ListBox1.items.add(ts.getstring(i));
 end;
end;

function fmdate(s:string):string;
begin
  result:=formatdatetime('d',StrToFloatDef(s,0))+' '+mntlist[strtointe(formatdatetime('m',StrToFloatDef(s,0)))];
end;

function GetType(s:string):gType;
begin
  result:=gBlank;
  if pos('-',s)>0 then result:=gTire;
  if pos(':',s)>0 then result:=gTime;
end;

function CompareOst(n1,n2:integer;st1,ss1:string):string;
  var m1,m2,i,l:integer;
  var s:string;
begin
with form1 do begin
  s:='';
  l:=0;
  m1:=GetCST(st1);
  m2:=GetEC1(n1);
   if m1<m2 then begin
     for i:=m1 to m2 do begin
       if GetType(stringgrid1.cells[n1,i])=gTire then begin
         if GetType(stringgrid2.cells[n2,getbst(stringgrid1.cells[0,i])])=gTime then begin
           s:=s+stringgrid1.cells[1,i]+', ';
           inc(l);
         end;
       end;
     end;
   end;
  if l>0 then begin
    s:=copy(s,1,length(s)-2);
    s:=ss1+s+'.';
  end;
  result:=s;
end;
end;

function CompareOstN(n1,n2:integer;st1,ss1:string):string;
  var m1,m2,i,l:integer;
  var s:string;
begin
with form1 do begin
  s:='';
  l:=0;
  m1:=GetCST(st1);
  m2:=GetEC1(n1);
   if m1<m2 then begin
     for i:=m1 to m2 do begin
       if GetType(stringgrid1.cells[n1,i])=gTime then begin
         if GetType(stringgrid2.cells[n2,getbst(stringgrid1.cells[0,i])])=gTire then begin
           s:=s+stringgrid1.cells[1,i]+', ';
           inc(l);
         end;
       end;
     end;
   end;
  if l>0 then begin
    s:=copy(s,1,length(s)-2);
    s:=ss1+s+'.';
  end;
  result:=s;
end;
end;

function GetOstN(cst,n2:integer;ss1,ss2:string):string;
  var m1,m2,i,l:integer;
  var s:string;
begin
with form1 do begin
  s:='';
  l:=0;
  m1:=cst;
  m2:=GetEC1(n2);
   if m1<m2 then begin
     for i:=m1 to m2 do begin
         if GetType(stringgrid1.cells[n2,i])=gTire then begin
           s:=s+stringgrid1.cells[1,i]+', ';
           inc(l);
         end;
     end;
    if l>0 then begin
      s:=copy(s,1,length(s)-2);
      s:=ss1+s+'.';
    end
     else s:=ss2;
   end;
  result:=s;
end;
end;

function getskl(s:string):string;
  var i:integer;
begin
  i:=skl.SearchString(ansiuppercase(s));
  if i>0 then result:=skl1.getstring(i)
         else result:=s;
end;

function ComparePlatf(s1,s2:string):string;
begin
  result:='';
  if length(trim(s1))>0 then begin
    if trim(s1)<>trim(s2) then begin
      if pos('',s1)>0 then result:=' ( '+trim(copy(s1,1,pos('',s1)-1))+' )';
      if pos('',s1)>0 then result:=' ( '+trim(copy(s1,1,pos('',s1)-1))+' )';
    end;
  end;
end;

function ComparePlatf1(s1,s2:string):string;
begin
  result:='';
  if length(trim(s1))>0 then begin
    if trim(s1)<>trim(s2) then begin
      if pos('',s1)>0 then result:=' '+trim(copy(s1,1,pos('',s1)-1))+' ';
      if pos('',s1)>0 then result:=' '+trim(copy(s1,1,pos('',s1)-1))+' ';
    end;
  end;
end;

function prep_etext(s:string):string;
begin
 result:=s;
  if length(s)>2 then begin
    if s[1]='-' then
      if s[2]=' ' then result:=copy(s,3,length(s)-2);
  end;
end;

function CombineXMLel(x:TXMLel):string;
begin
  result:='e_mode="'+x.mode+'" e_direction="'+x.back+'" e_firststation="'+x.sto+'" e_nstation="'+x.stn+'" e_basetime="'+x.time+'" e_chtime="'+x.chtime+'" e_text="'+prep_etext(x.txt)+'"';
end;

function FindNDateTh(t1,t2:string):gNextDate;
 var r1,r2,h1,m1,h2,m2:integer;
begin
 if pos('/',t1)>0 then t1:=copy(t1,pos('/',t1)+1,100);
 if pos('/',t2)>0 then t2:=copy(t2,1,pos('/',t2)-1);
 if pos('^',t1)>0 then t1:=copy(t1,1,pos('^',t1)-1);
 if pos('^',t2)>0 then t2:=copy(t2,1,pos('^',t2)-1);
 if pos('@',t1)>0 then t1:=copy(t1,1,pos('@',t1)-1);
 if pos('@',t2)>0 then t2:=copy(t2,1,pos('@',t2)-1);
 t1:=trim(t1);
 t2:=trim(t2);
 tohm(t1,h1,m1);
 tohm(t2,h2,m2);
 r1:=h1*60;
 r2:=h2*60;
 r1:=r1+m1;
 r2:=r2+m2;
 result:=ndNone;
 if r1>r2 then result:=ndNextNight
   else begin
    if ((r2<=180)and(r1<=r2)) then result:=ndNight;
   end;
end;

procedure MainProc;
 var i,i1,ff,n,n1,o,st,col,bt,dt,stc,zz:integer;
 var dlist,d1,t,lexp,lxml,lxmlnum,lxmle:AF_Types.TStrings;
 var s,s1,s2,ns1,es1,ns2,es2,dst,ls,cpl,cpl1,nextdate,bcost:string;
 var fs:TFormatSettings;
 var xmle:TXMLel;
begin
 fs.DateSeparator:='.';
 fs.ShortDateFormat:='yyyy-mm-dd';
 fs.LongDateFormat:='yyyy-mm-dd';
dlist.create;
d1.create;
t.create;
lexp.create;
lxml.create;
lxmlnum.create;
lxmle.create;
with form1 do begin
if (fileexists(LabeledEdit1.text) and fileexists(LabeledEdit2.text)) then begin
////////// chg
    LoadChgFromXLS(StringGrid1,StringGrid3,LabeledEdit1.Text);
    if StringGrid1.RowCount>5 then begin
      for i:=2 to StringGrid1.ColCount do begin
        StringGrid1.Cells[i,0]:=numbprep(StringGrid1.Cells[i,0]);
        for i1:=4 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,i1]:=PrepareTTime(StringGrid1.Cells[i,i1]);
        while pos('/',StringGrid1.cells[i,3])>0 do StringGrid1.cells[i,3]:=copy(StringGrid1.cells[i,3],pos('/',StringGrid1.cells[i,3])+1,length(StringGrid1.cells[i,3])-pos('/',StringGrid1.cells[i,3]));
        StringGrid1.cells[i,2]:=vDate(StringGrid1.cells[i,2],StringGrid1.cells[i,0]);
        StringGrid1.cells[i,2]:=vDate2(StringGrid1.cells[i,2]);
        if strtointe(trim(StringGrid1.cells[i,3]))<=0 then begin
        if ((StringGrid1.Cells[i,1]='')or(StringGrid1.Cells[i,1]='')or(StringGrid1.Cells[i,1]='')) then begin
          for i1:=4 to 301 do begin
            n1:=i1;
            if form1.StringGrid1.Cells[i,i1]<>'' then break;
          end;
          StringGrid1.cells[i,3]:=StringGrid1.cells[0,i1];
        end;
        end;
      end;
    end;
////////// main
    LoadChgFromXLS(StringGrid2,StringGrid4,LabeledEdit2.Text);
    if StringGrid2.RowCount>4 then begin
      for i:=2 to StringGrid2.ColCount do begin
        StringGrid2.Cells[i,0]:=numbprep(StringGrid2.Cells[i,0]);
        StringGrid2.Cells[i,0]:=trim(ansilowercase(numbprep(StringGrid2.Cells[i,0])));
        if StringGrid2.Cells[i,1]='' then StringGrid2.Cells[i,1]:='';
        StringGrid2.Cells[i,1]:=CalcDate(StringGrid2.Cells[i,1]);
        for i1:=2 to StringGrid2.RowCount-1 do StringGrid2.Cells[i,i1]:=PrepareTTime(StringGrid2.Cells[i,i1]);
      end;
    end;
///  
for i:=2 to stringgrid1.ColCount-1 do begin
  ParseCSVStr(@t,StringGrid1.Cells[i,2]);
    if t.count>0 then begin
      for i1:=1 to t.count do begin
        s:=t.getstring(i1);
        if dlist.SearchString(s)=0 then dlist.add(s);
      end;
    end;
end;

dlist.SortedAsNumber;

for st:=4 to stringgrid1.RowCount-1 do begin
 stc:=0;
 ListBox1.Items.Add('');
 if checkbox1.checked then ListBox1.Items.Add(stringgrid1.Cells[0,st]+'# '+stringgrid1.Cells[1,st])
                      else ListBox1.Items.Add(stringgrid1.Cells[1,st]);
 if validstr(stringgrid1.Cells[0,st]) then xmlexp.add('  <Station EKCP="'+stringgrid1.Cells[0,st]+'" Name="'+stringgrid1.Cells[1,st]+'">');
 for dt:=1 to dlist.count do begin
  nextdate:='';
  bcost:='';
  lexp.clear;
  lxml.clear;
  lxmlnum.clear;
  lxmle.clear;
  xmle.mode:='';
  xmle.num:='';
  xmle.stn:='';
  xmle.txt:='';
  xmle.back:='0';
  xmle.time:='';
  xmle.sto:='';
  for col:=2 to stringgrid1.ColCount-1 do begin
    if length(stringgrid1.Cells[col,0])>1 then begin
    if isDate(dlist.getstring(dt),stringgrid1.Cells[col,2]) then begin
     case FindNDateTh(stringgrid1.Cells[col,GetNC1a(col)],stringgrid1.Cells[col,st]) of
      ndNight: nextdate:=' (   '+fmdate(inttostr(strtointe(dlist.getstring(dt))))+')';
      ndNextNight: nextdate:=' (   '+fmdate(inttostr(strtointe(dlist.getstring(dt))+1))+')';
      ndNone: nextdate:='';
     end;
     bcost:=GetOstN(st,col,'.   : ','.    .');
    if stringgrid1.Cells[col,1]='' then begin
      s1:=trim(stringgrid1.Cells[col,st]);
      if getType(s1)=gTime then begin
       ns1:=GetNC(col);
       es1:=GetEC(col);
       xmle.mode:='add';
       xmle.num:=stringgrid1.Cells[col,0];
       xmle.txt:='';
       if stringgrid1.Cells[0,st]=es1 then begin s:=' '+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid1.Cells[1,GetNC1a(col)])+',   '+s1+nextdate; stringgrid1.Cells[0,Getcst(es1)]; xmle.time:=s1; xmle.back:='1'; xmle.sto:=stringgrid1.Cells[0,GetNC1a(col)]; end
                                      else begin s:=' '+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid1.Cells[1,Getcst(es1)])+'  '+s1+bcost+nextdate; xmle.stn:=stringgrid1.Cells[0,Getcst(es1)]; xmle.time:=s1; xmle.sto:=stringgrid1.Cells[0,GetNC1a(col)]; end;
       lexp.add('        '+s);
       lxml.add(s);
       lxmle.add(CombineXMLel(xmle));
       lxmlnum.add(stringgrid1.Cells[col,0]);
      end;
    end;
    if stringgrid1.Cells[col,1]='' then begin
       ns1:=GetNC(col);
       es1:=GetEC(col);
       bt:=FindBaseTrain(stringgrid1.Cells[col,0],ns1,dlist.getstring(dt));
       ns2:=GetNB(bt);
       es2:=GetEB(bt);
       s1:=trim(stringgrid1.Cells[col,st]);
       s2:=trim(stringgrid2.Cells[bt,GetBST(stringgrid1.Cells[0,st])]);
      if getType(s2)=gTime then begin
       xmle.mode:='cancel';
       xmle.num:=stringgrid1.Cells[col,0];
       xmle.txt:='';
       if stringgrid1.Cells[0,st]=es1 then begin s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetNB1(bt)])+'   '+s2+nextdate+' - '; xmle.stn:=stringgrid2.Cells[0,Getbst(es2)]; xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)]; xmle.time:=s2; xmle.back:='1'; end
                                      else begin s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,Getbst(es2)])+'   '+s2+nextdate+' - '; xmle.stn:=stringgrid2.Cells[0,Getbst(es2)]; xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)]; xmle.time:=s2; xmle.back:='0'; end;
       lexp.add('        '+s);
       lxml.add(s);
       lxmle.add(CombineXMLel(xmle));
       lxmlnum.add(stringgrid1.Cells[col,0]);
      end;
    end;
    if stringgrid1.Cells[col,1]='' then begin
       ns1:=GetNC(col);
       es1:=GetEC(col);
       bt:=FindBaseTrain(stringgrid1.Cells[col,0],ns1,dlist.getstring(dt));
       ns2:=GetNB(bt);
       es2:=GetEB(bt);
       s1:=trim(stringgrid1.Cells[col,st]);
       s2:=trim(stringgrid2.Cells[bt,GetBST(stringgrid1.Cells[0,st])]);
       cpl:=ComparePlatf(stringgrid3.Cells[col,st],stringgrid4.Cells[bt,GetBST(stringgrid1.Cells[0,st])]);
       cpl1:=ComparePlatf1(stringgrid3.Cells[col,st],stringgrid4.Cells[bt,GetBST(stringgrid1.Cells[0,st])]);
//         listbox1.Items.add('st='+stringgrid1.Cells[1,st]+' date='+dlist.getstring(dt)+' s1='+s1+' s2='+s2);
         if s1<>s2 then begin
          if es1<>es2 then dst:='   '+getskl(stringgrid1.Cells[1,GetEC1(col)])+' ( '+stringgrid1.Cells[col,GetEC1(col)]+')'
                      else dst:='';
          if (gettype(s1)=gTire) and (gettype(s2)=gTime) then begin
               s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+nextdate+' -  (  )';
               xmle.mode:='cancel';
               xmle.num:=stringgrid1.Cells[col,0];
               xmle.stn:=stringgrid2.Cells[0,GetEB1(bt)];
               xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)];
               xmle.time:=s2;
               xmle.txt:=' (  )';
               xmle.back:='0';
               lexp.add('        '+s);
               lxml.add(s);
               lxmle.add(CombineXMLel(xmle));
               lxmlnum.add(stringgrid1.Cells[col,0]);
          end;
          if (gettype(s1)=gBlank) and (gettype(s2)=gTime) then begin
               xmle.mode:='cancel';
               xmle.num:=stringgrid1.Cells[col,0];
               xmle.time:=s2;
               xmle.txt:='';
               if stringgrid1.Cells[0,st]=es2 then begin
                   s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetNB1(bt)])+'   '+s2+nextdate+' - ';
                   xmle.stn:=stringgrid2.Cells[0,GetEB1(bt)];
                   xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)];
                   xmle.back:='1';
                 end
                 else begin
                   s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+nextdate+' - ';
                   xmle.stn:=stringgrid2.Cells[0,GetEB1(bt)];
                   xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)];
                   xmle.back:='0';
                 end;
               lexp.add('        '+s);
               lxml.add(s);
               lxmle.add(CombineXMLel(xmle));
               lxmlnum.add(stringgrid1.Cells[col,0]);
          end;
          if (gettype(s1)=gTime) and (gettype(s2)=gTire) then begin
//               s:=' '+stringgrid1.Cells[col,0]+' '+stringgrid1.Cells[1,getcst(es1)]+'  '+s1+dst;
               xmle.mode:='add';
               xmle.num:=stringgrid1.Cells[col,0];
               xmle.time:=s1;
               xmle.txt:=''+cpl;
               if stringgrid1.Cells[0,st]=es1 then begin s:=' '+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid1.Cells[1,GetNC1a(col)])+',   '+s1+nextdate; xmle.stn:=stringgrid1.Cells[0,Getcst(es1)]; xmle.sto:=stringgrid1.Cells[0,GetNC1a(col)]; xmle.back:='1'; end
                                              else begin s:=' '+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid1.Cells[1,Getcst(es1)])+'  '+s1+nextdate+cpl+bcost; xmle.stn:=stringgrid1.Cells[0,Getcst(es1)]; xmle.sto:=stringgrid1.Cells[0,GetNC1a(col)]; xmle.back:='0'; end;
               lexp.add('        '+s);
               lxml.add(s);
               lxmle.add(CombineXMLel(xmle));
               lxmlnum.add(stringgrid1.Cells[col,0]);
          end;
          if (gettype(s1)=gTime) and (gettype(s2)=gBlank) then begin
//               s:=' '+stringgrid1.Cells[col,0]+' '+stringgrid1.Cells[1,getcst(es1)]+'  '+s1+dst;
               xmle.mode:='add';
               xmle.num:=stringgrid1.Cells[col,0];
               xmle.time:=s1;
               xmle.txt:=''+cpl;
               if stringgrid1.Cells[0,st]=es1 then begin s:=' '+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid1.Cells[1,GetNC1a(col)])+',   '+s1+nextdate; xmle.stn:=stringgrid1.Cells[0,Getcst(es1)]; xmle.sto:=stringgrid1.Cells[0,GetNC1a(col)]; xmle.back:='1'; end
                                              else begin s:=' '+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid1.Cells[1,Getcst(es1)])+'  '+s1+nextdate+cpl+bcost; xmle.stn:=stringgrid1.Cells[0,Getcst(es1)]; xmle.sto:=stringgrid1.Cells[0,GetNC1a(col)]; xmle.back:='0'; end;
               lexp.add('        '+s);
               lxml.add(s);
               lxmle.add(CombineXMLel(xmle));
               lxmlnum.add(stringgrid1.Cells[col,0]);
          end;
          if (gettype(s1)=gTime) and (gettype(s2)=gTime) then begin
//               if stringgrid1.Cells[0,st]=es1 then s:=stringgrid1.Cells[col,0]+' '+stringgrid2.Cells[1,GetEB1(bt)]+' '+s2+' -   '+s1+dst
               xmle.mode:='change';
               xmle.num:=stringgrid1.Cells[col,0];
               xmle.time:=s2;
               if stringgrid1.Cells[0,st]=es1 then begin
                                                if es1=es2 then begin s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetNB1(bt)])+'   '+s2+nextdate+' -   '+s1+dst; xmle.stn:=stringgrid2.Cells[0,GetEB1(bt)]; xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)]; xmle.back:='1'; xmle.txt:='  '+s1+dst; end
                                                           else begin s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+nextdate+' -  (   '+getskl(stringgrid1.Cells[1,st])+', .'+s1+')'; xmle.stn:=stringgrid2.Cells[0,GetEB1(bt)]; xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)]; xmle.back:='0'; xmle.txt:=' (   '+getskl(stringgrid1.Cells[1,st])+', .'+s1+')' end;
                                              end
                                              else begin s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+nextdate+' -   '+s1+cpl+dst+CompareOst(col,bt,stringgrid1.Cells[0,st],'.  : ')+CompareOstN(col,bt,stringgrid1.Cells[0,st],'.  : '); xmle.stn:=stringgrid2.Cells[0,GetEB1(bt)]; xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)]; xmle.back:='0'; xmle.txt:='  '+s1+cpl+dst+CompareOst(col,bt,stringgrid1.Cells[0,st],'.  : ')+CompareOstN(col,bt,stringgrid1.Cells[0,st],'.  : ');  end;
               lexp.add('        '+s);
               lxml.add(s);
               lxmle.add(CombineXMLel(xmle));
               lxmlnum.add(stringgrid1.Cells[col,0]);
          end;
         end
          else begin  //(s1=s2)
          if gettype(s1)=gTime then begin
            if es1<>es2 then begin
              xmle.mode:='change';
              xmle.num:=stringgrid1.Cells[col,0];
              xmle.time:=s2;
              xmle.back:='0';
              xmle.stn:=stringgrid2.Cells[0,GetEB1(bt)];
              xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)];
              if stringgrid1.Cells[0,st]=es1 then begin
                  s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+nextdate+' -  ,    .'+stringgrid1.Cells[1,GetEC1(col)];
                  xmle.txt:=' ,    .'+stringgrid1.Cells[1,GetEC1(col)];
                end
                else begin
                  s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+nextdate+' -   '+getskl(stringgrid1.Cells[1,GetEC1(col)])+' ( '+stringgrid1.Cells[col,GetEC1(col)]+')'+cpl+CompareOst(col,bt,stringgrid1.Cells[0,st],'.  : ')+CompareOstN(col,bt,stringgrid1.Cells[0,st],'.  : ');
                  xmle.txt:='  '+getskl(stringgrid1.Cells[1,GetEC1(col)])+' ( '+stringgrid1.Cells[col,GetEC1(col)]+')'+nextdate+cpl+CompareOst(col,bt,stringgrid1.Cells[0,st],'.  : ')+CompareOstN(col,bt,stringgrid1.Cells[0,st],'.  : ');
                end;
              lexp.add('        '+s);
              lxml.add(s);
              lxmle.add(CombineXMLel(xmle));
              lxmlnum.add(stringgrid1.Cells[col,0]);
            end
             else begin
              xmle.mode:='change';
              xmle.num:=stringgrid1.Cells[col,0];
              xmle.time:=s2;
              xmle.back:='0';
              xmle.stn:=stringgrid2.Cells[0,GetEB1(bt)];
              xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)];
              if stringgrid1.Cells[0,st]=es1 then begin
                  s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+nextdate+' -  ,    .'+stringgrid1.Cells[1,GetEC1(col)];
                  xmle.txt:=' ,    .'+stringgrid1.Cells[1,GetEC1(col)];
              end else begin
               ls:=CompareOst(col,bt,stringgrid1.Cells[0,st],' -  : ')+CompareOstN(col,bt,stringgrid1.Cells[0,st],'.  : ');
               if length(ls)>5 then begin
                s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+nextdate+cpl+ls;
                xmle.txt:=ls;
                lexp.add('        '+s);
                lxml.add(s);
                lxmle.add(CombineXMLel(xmle));
                lxmlnum.add(stringgrid1.Cells[col,0]);
               end
                else begin
                  if length(cpl)>3 then begin
                    s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+nextdate+' - '+cpl1;
                    xmle.txt:=cpl1;
                    lexp.add('        '+s);
                    lxml.add(s);
                    lxmle.add(CombineXMLel(xmle));
                    lxmlnum.add(stringgrid1.Cells[col,0]);
                  end;
                end;
              end;
             end;
          end;
          end;
    end; //o
    end; //isdate
    end;
  end; //col
   if lexp.count>0 then begin
     ListBox1.Items.Add('    '+fmdate(dlist.getstring(dt)));
     l2exp(@lexp);
     inc(stc);
     xmlexp.add('    <Date D="'+FormatDateTime('yyyymmdd',strtointe(dlist.getstring(dt)))+'">');
       for zz:=1 to lxml.count do begin
         xmlexp.add('      <Route NRoute="'+lxmlnum.getstring(zz)+'" Message="'+lxml.getstring(zz)+'" '+lxmle.getstring(zz)+' />');
       end;
     xmlexp.add('    </Date>');
   end;
 end; //dt
   if stc<=0 then begin
     ListBox1.Items.Add('     ');
//     xmlexp.add('<Station EKCP="'+stringgrid1.Cells[0,st]+'" Name="'+stringgrid1.Cells[1,st]+'" Message=" " />');
     if validstr(stringgrid1.Cells[0,st]) then xmlexp.delete(xmlexp.count);
   end
    else begin
      if validstr(stringgrid1.Cells[0,st]) then xmlexp.add('  </Station>');
    end;
end; //st
end
 else ShowMessage('    !');
end;
lxml.free;
lxmlnum.free;
lexp.free;
lxmle.free;
d1.free;
dlist.free;
t.free;
end;    //MainProc




function add3(s:string):string;
begin
  case length(s) of
    0: s:='000';
    1: s:='00'+s;
    2: s:='0'+s;
  end;
  result:=s;
end;




function CPPKDate(s:string):string;
  var u:AF_Types.TStrings;
  var i:integer;
  var d,m,y:string;
begin
  u.create;
  ParseCSVStr(@u,s);
   if u.count>0 then begin
     s:='';
     for i:=1 to u.count do begin
       y:=copy(u.getstring(i),1,4);
       m:=copy(u.getstring(i),5,2);
       d:=copy(u.getstring(i),7,2);
       s:=s+d+'.'+m+'.'+y+';';
     end;
     s:=copy(s,1,length(s)-1);
   end;
  u.free;
  result:=s;
end;



procedure MainProcCPPK;
 var i,i1,ff,n,n1,o,st,col,bt,dt,stc,zz:integer;
 var dlist,d1,t,lexp,lxml,lxmlnum,lxmle:AF_Types.TStrings;
 var s,s1,s2,ns1,es1,ns2,es2,dst,ls,cpl,cpl1:string;
 var fs:TFormatSettings;
 var xmle:TXMLel;
begin
 fs.DateSeparator:='-';
 fs.ShortDateFormat:='yyyymmdd';
 fs.LongDateFormat:='yyyymmdd';
dlist.create;
d1.create;
t.create;
lexp.create;
lxml.create;
lxmlnum.create;
lxmle.create;
with form1 do begin
if (fileexists(LabeledEdit1.text) and fileexists(LabeledEdit2.text)) then begin
////////// chg
    LoadChgFromXLS(StringGrid1,StringGrid3,LabeledEdit1.Text);
    if StringGrid1.RowCount>5 then begin
      for i:=2 to StringGrid1.ColCount do begin
        StringGrid1.Cells[i,0]:=numbprep(StringGrid1.Cells[i,0]);
        for i1:=4 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,i1]:=PrepareTTime(StringGrid1.Cells[i,i1]);
        while pos('/',StringGrid1.cells[i,3])>0 do StringGrid1.cells[i,3]:=copy(StringGrid1.cells[i,3],pos('/',StringGrid1.cells[i,3])+1,length(StringGrid1.cells[i,3])-pos('/',StringGrid1.cells[i,3]));
        StringGrid1.cells[i,2]:=vDateCPPK(StringGrid1.cells[i,2],StringGrid1.cells[i,0]);
//        StringGrid1.cells[i,2]:=vDate2(StringGrid1.cells[i,2]);
        if strtointe(trim(StringGrid1.cells[i,3]))<=0 then begin
        if ((StringGrid1.Cells[i,1]='')or(StringGrid1.Cells[i,1]='')or(StringGrid1.Cells[i,1]='')) then begin
          for i1:=4 to 301 do begin
            n1:=i1;
            if form1.StringGrid1.Cells[i,i1]<>'' then break;
          end;
          StringGrid1.cells[i,3]:=StringGrid1.cells[0,i1];
        end;
        end;
      end;
    end;
////////// main
    LoadChgFromXLS(StringGrid2,StringGrid4,LabeledEdit2.Text);
    if StringGrid2.RowCount>4 then begin
      for i:=2 to StringGrid2.ColCount do begin
        StringGrid2.Cells[i,0]:=numbprep(StringGrid2.Cells[i,0]);
        StringGrid2.Cells[i,0]:=trim(ansilowercase(numbprep(StringGrid2.Cells[i,0])));
        if StringGrid2.Cells[i,1]='' then StringGrid2.Cells[i,1]:='';
        StringGrid2.Cells[i,1]:=CalcDateCPPK(StringGrid2.Cells[i,1]);
        for i1:=2 to StringGrid2.RowCount-1 do StringGrid2.Cells[i,i1]:=PrepareTTime(StringGrid2.Cells[i,i1]);
      end;
    end;


for st:=4 to stringgrid1.RowCount-1 do begin
if validstr(stringgrid1.Cells[0,st]) then begin

 stc:=0;
 ListBox1.Items.Add('');
 if checkbox1.checked then ListBox1.Items.Add(stringgrid1.Cells[0,st]+'# '+stringgrid1.Cells[1,st])
                      else ListBox1.Items.Add(stringgrid1.Cells[1,st]);
 if validstr(stringgrid1.Cells[0,st]) then xmlexp.add('  <Station EKCP="'+stringgrid1.Cells[0,st]+'" Name="'+stringgrid1.Cells[1,st]+'">');
// for dt:=1 to dlist.count do begin
  for col:=2 to stringgrid1.ColCount-1 do begin
  if pos('_',stringgrid1.Cells[col,2])<=0 then begin

 dlist.clear;
///  
  ParseCSVStr(@t,StringGrid1.Cells[col,2]);
    if t.count>0 then begin
      for i1:=1 to t.count do begin
        s:=t.getstring(i1);
        if dlist.SearchString(s)=0 then dlist.add(s);
      end;
    end;
 dlist.SortedAsString;
// dlist.savetofile('c:\61\'+StringGrid1.Cells[col,0]+'.txt');


  lexp.clear;
  lxml.clear;
  lxmlnum.clear;
  lxmle.clear;
  xmle.mode:='';
  xmle.num:='';
  xmle.stn:='';
  xmle.txt:='';
  xmle.back:='0';
  xmle.time:='';
  xmle.chtime:='';
  xmle.sto:='';
    if length(stringgrid1.Cells[col,0])>1 then begin
    if true {isDate(dlist.getstring(dt),stringgrid1.Cells[col,2])} then begin
    if stringgrid1.Cells[col,1]='' then begin
      s1:=trim(stringgrid1.Cells[col,st]);
      if getType(s1)=gTime then begin
       ns1:=GetNC(col);
       es1:=GetEC(col);
       xmle.mode:='add';
       xmle.num:=stringgrid1.Cells[col,0];
       xmle.txt:='';
       if stringgrid1.Cells[0,st]=es1 then begin s:=' '+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid1.Cells[1,GetNC1a(col)])+',   '+s1; xmle.stn:=stringgrid1.Cells[0,Getcst(es1)]; xmle.sto:=stringgrid1.Cells[0,GetNC1a(col)]; xmle.time:=s1; xmle.back:='1'; end
                                      else begin s:=' '+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid1.Cells[1,Getcst(es1)])+'  '+s1; xmle.stn:=stringgrid1.Cells[0,Getcst(es1)]; xmle.sto:=stringgrid1.Cells[0,GetNC1a(col)]; xmle.time:=s1; end;
       lexp.add('        '+s);
       lxml.add(s);
       lxmle.add(CombineXMLel(xmle));
       lxmlnum.add(stringgrid1.Cells[col,0]);
      end;
    end;
    if stringgrid1.Cells[col,1]='' then begin
       ns1:=GetNC(col);
       es1:=GetEC(col);
       bt:=FindBaseTrain(stringgrid1.Cells[col,0],ns1,dlist.getstring(1));
       ns2:=GetNB(bt);
       es2:=GetEB(bt);
       s1:=trim(stringgrid1.Cells[col,st]);
       s2:=trim(stringgrid2.Cells[bt,GetBST(stringgrid1.Cells[0,st])]);
      if getType(s2)=gTime then begin
       xmle.mode:='cancel';
       xmle.num:=stringgrid1.Cells[col,0];
       xmle.txt:='';
       if stringgrid1.Cells[0,st]=es1 then begin s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetNB1(bt)])+'   '+s2+' - '; xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)]; xmle.stn:=stringgrid2.Cells[0,Getbst(es2)]; xmle.time:=s2; xmle.back:='1'; end
                                      else begin s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,Getbst(es2)])+'   '+s2+' - '; xmle.stn:=stringgrid2.Cells[0,Getbst(es2)]; xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)]; xmle.time:=s2; xmle.back:='0'; end;
       lexp.add('        '+s);
       lxml.add(s);
       lxmle.add(CombineXMLel(xmle));
       lxmlnum.add(stringgrid1.Cells[col,0]);
      end;
    end;
    if stringgrid1.Cells[col,1]='' then begin
       ns1:=GetNC(col);
       es1:=GetEC(col);
       bt:=FindBaseTrain(stringgrid1.Cells[col,0],ns1,dlist.getstring(1));
       ns2:=GetNB(bt);
       es2:=GetEB(bt);
       s1:=trim(stringgrid1.Cells[col,st]);
       s2:=trim(stringgrid2.Cells[bt,GetBST(stringgrid1.Cells[0,st])]);
       cpl:=ComparePlatf(stringgrid3.Cells[col,st],stringgrid4.Cells[bt,GetBST(stringgrid1.Cells[0,st])]);
       cpl1:=ComparePlatf1(stringgrid3.Cells[col,st],stringgrid4.Cells[bt,GetBST(stringgrid1.Cells[0,st])]);
//         listbox1.Items.add('st='+stringgrid1.Cells[1,st]+' date='+dlist.getstring(dt)+' s1='+s1+' s2='+s2);
         if s1<>s2 then begin
          if es1<>es2 then dst:='   '+getskl(stringgrid1.Cells[1,GetEC1(col)])+' ( '+stringgrid1.Cells[col,GetEC1(col)]+')'
                      else dst:='';
          if (gettype(s1)=gTire) and (gettype(s2)=gTime) then begin
               s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+' -  (  )';
               xmle.mode:='cancel';
               xmle.num:=stringgrid1.Cells[col,0];
               xmle.stn:=stringgrid2.Cells[0,GetEB1(bt)];
               xmle.stn:=stringgrid2.Cells[0,GetNB1(bt)];
               xmle.time:=s2;
               xmle.txt:=' (  )';
               xmle.back:='0';
               lexp.add('        '+s);
               lxml.add(s);
               lxmle.add(CombineXMLel(xmle));
               lxmlnum.add(stringgrid1.Cells[col,0]);
          end;
          if (gettype(s1)=gBlank) and (gettype(s2)=gTime) then begin
               xmle.mode:='cancel';
               xmle.num:=stringgrid1.Cells[col,0];
               xmle.time:=s2;
               xmle.txt:='';
               if stringgrid1.Cells[0,st]=es2 then begin
                   s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetNB1(bt)])+'   '+s2+' - ';
                   xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)];
                   xmle.stn:=stringgrid2.Cells[0,GetEB1(bt)];
                   xmle.back:='1';
                 end
                 else begin
                   s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+' - ';
                   xmle.stn:=stringgrid2.Cells[0,GetEB1(bt)];
                   xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)];
                   xmle.back:='0';
                 end;
               lexp.add('        '+s);
               lxml.add(s);
               lxmle.add(CombineXMLel(xmle));
               lxmlnum.add(stringgrid1.Cells[col,0]);
          end;
          if (gettype(s1)=gTime) and (gettype(s2)=gTire) then begin
//               s:=' '+stringgrid1.Cells[col,0]+' '+stringgrid1.Cells[1,getcst(es1)]+'  '+s1+dst;
               xmle.mode:='add';
               xmle.num:=stringgrid1.Cells[col,0];
               xmle.time:=s1;
               xmle.txt:=''+cpl;
               if stringgrid1.Cells[0,st]=es1 then begin s:=' '+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid1.Cells[1,GetNC1a(col)])+',   '+s1; xmle.sto:=stringgrid1.Cells[0,GetNC1a(col)]; xmle.stn:=stringgrid1.Cells[0,Getcst(es1)]; xmle.back:='1'; end
                                              else begin s:=' '+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid1.Cells[1,Getcst(es1)])+'  '+s1+cpl; xmle.stn:=stringgrid1.Cells[0,Getcst(es1)]; xmle.sto:=stringgrid1.Cells[0,GetNC1a(col)]; xmle.back:='0'; end;
               lexp.add('        '+s);
               lxml.add(s);
               lxmle.add(CombineXMLel(xmle));
               lxmlnum.add(stringgrid1.Cells[col,0]);
          end;
          if (gettype(s1)=gTime) and (gettype(s2)=gBlank) then begin
//               s:=' '+stringgrid1.Cells[col,0]+' '+stringgrid1.Cells[1,getcst(es1)]+'  '+s1+dst;
               xmle.mode:='add';
               xmle.num:=stringgrid1.Cells[col,0];
               xmle.time:=s1;
               xmle.txt:=''+cpl;
               if stringgrid1.Cells[0,st]=es1 then begin s:=' '+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid1.Cells[1,GetNC1a(col)])+',   '+s1; xmle.stn:=stringgrid1.Cells[0,Getcst(es1)]; xmle.sto:=stringgrid1.Cells[0,GetNC1a(col)]; xmle.back:='1'; end
                                              else begin s:=' '+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid1.Cells[1,Getcst(es1)])+'  '+s1+cpl; xmle.stn:=stringgrid1.Cells[0,Getcst(es1)]; xmle.sto:=stringgrid1.Cells[0,GetNC1a(col)]; xmle.back:='0'; end;
               lexp.add('        '+s);
               lxml.add(s);
               lxmle.add(CombineXMLel(xmle));
               lxmlnum.add(stringgrid1.Cells[col,0]);
          end;
          if (gettype(s1)=gTime) and (gettype(s2)=gTime) then begin
//               if stringgrid1.Cells[0,st]=es1 then s:=stringgrid1.Cells[col,0]+' '+stringgrid2.Cells[1,GetEB1(bt)]+' '+s2+' -   '+s1+dst
               xmle.mode:='change';
               xmle.num:=stringgrid1.Cells[col,0];
               xmle.time:=s2;
               if stringgrid1.Cells[0,st]=es1 then begin
                                                if es1=es2 then begin s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetNB1(bt)])+'   '+s2+' -   '+s1+dst; xmle.stn:=stringgrid2.Cells[0,GetEB1(bt)]; xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)]; xmle.back:='1'; xmle.txt:='  '+s1+dst; xmle.chtime:=s1; end
                                                           else begin s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+' -  (   '+getskl(stringgrid1.Cells[1,st])+', .'+s1+')'; xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)]; xmle.stn:=stringgrid2.Cells[0,GetEB1(bt)]; xmle.back:='0'; xmle.txt:=' (   '+getskl(stringgrid1.Cells[1,st])+', .'+s1+')';  xmle.chtime:=s1; end;
                                              end
                                              else begin s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+' -   '+s1+cpl+dst+CompareOst(col,bt,stringgrid1.Cells[0,st],'.  : ')+CompareOstN(col,bt,stringgrid1.Cells[0,st],'.  : '); xmle.stn:=stringgrid2.Cells[0,GetEB1(bt)]; xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)]; xmle.back:='0'; xmle.txt:='  '+s1+cpl+dst+CompareOst(col,bt,stringgrid1.Cells[0,st],'.  : ')+CompareOstN(col,bt,stringgrid1.Cells[0,st],'.  : ');  xmle.chtime:=s1;  end;
               lexp.add('        '+s);
               lxml.add(s);
               lxmle.add(CombineXMLel(xmle));
               lxmlnum.add(stringgrid1.Cells[col,0]);
          end;
         end
          else begin  //(s1=s2)
          if gettype(s1)=gTime then begin
            if es1<>es2 then begin
              xmle.mode:='change';
              xmle.num:=stringgrid1.Cells[col,0];
              xmle.time:=s2;
              xmle.back:='0';
              xmle.stn:=stringgrid2.Cells[0,GetEB1(bt)];
              xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)];
              if stringgrid1.Cells[0,st]=es1 then begin
                  s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+' -  ,    .'+stringgrid1.Cells[1,GetEC1(col)];
                  xmle.txt:=' ,    .'+stringgrid1.Cells[1,GetEC1(col)];
                end
                else begin
                  s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+' -   '+getskl(stringgrid1.Cells[1,GetEC1(col)])+' ( '+stringgrid1.Cells[col,GetEC1(col)]+')'+cpl+CompareOst(col,bt,stringgrid1.Cells[0,st],'.  : ')+CompareOstN(col,bt,stringgrid1.Cells[0,st],'.  : ');
                  xmle.txt:='  '+getskl(stringgrid1.Cells[1,GetEC1(col)])+' ( '+stringgrid1.Cells[col,GetEC1(col)]+')'+cpl+CompareOst(col,bt,stringgrid1.Cells[0,st],'.  : ')+CompareOstN(col,bt,stringgrid1.Cells[0,st],'.  : ');
                end;
              lexp.add('        '+s);
              lxml.add(s);
              lxmle.add(CombineXMLel(xmle));
              lxmlnum.add(stringgrid1.Cells[col,0]);
            end
             else begin
              xmle.mode:='change';
              xmle.num:=stringgrid1.Cells[col,0];
              xmle.time:=s2;
              xmle.back:='0';
              xmle.stn:=stringgrid2.Cells[0,GetEB1(bt)];
              xmle.sto:=stringgrid2.Cells[0,GetNB1(bt)];
              if stringgrid1.Cells[0,st]=es1 then begin
                  s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+' -  ,    .'+stringgrid1.Cells[1,GetEC1(col)];
                  xmle.txt:=' ,    .'+stringgrid1.Cells[1,GetEC1(col)];
              end else begin
               ls:=CompareOst(col,bt,stringgrid1.Cells[0,st],' -  : ')+CompareOstN(col,bt,stringgrid1.Cells[0,st],'.  : ');
               if length(ls)>5 then begin
                s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+cpl+ls;
                xmle.txt:=ls;
                lexp.add('        '+s);
                lxml.add(s);
                lxmle.add(CombineXMLel(xmle));
                lxmlnum.add(stringgrid1.Cells[col,0]);
               end
                else begin
                  if length(cpl)>3 then begin
                    s:=''+stringgrid1.Cells[col,0]+'  '+getskl(stringgrid2.Cells[1,GetEB1(bt)])+'   '+s2+' - '+cpl1;
                    xmle.txt:=cpl1;
                    lexp.add('        '+s);
                    lxml.add(s);
                    lxmle.add(CombineXMLel(xmle));
                    lxmlnum.add(stringgrid1.Cells[col,0]);
                  end;
                end;
              end;
             end;
          end;
          end;
    end; //o
    end; //isdate
    end;
   if lexp.count>0 then begin
     ListBox1.Items.Add('    '+fmdate(dlist.getstring(1)));
     l2exp(@lexp);
     inc(stc);
//     xmlexp.add('    <Date D="'+FormatDateTime('yyyymmdd',strtointe(dlist.getstring(dt)))+'">');
       for zz:=1 to lxml.count do begin
         s:=stringgrid1.Cells[col,2];
         while pos('-',s)>0 do delete(s,pos('-',s),1);
         xmlexp.add('      <Route NRoute="'+lxmlnum.getstring(zz)+'" valid_data="'+CPPKDate(s)+'" Message="'+lxml.getstring(zz)+'" '+lxmle.getstring(zz)+' />');
       end;
//     xmlexp.add('    </Date>');
   end;
  end; //pos _
  end; //col
// end; //dt
   if stc<=0 then begin
     ListBox1.Items.Add('     ');
//     xmlexp.add('<Station EKCP="'+stringgrid1.Cells[0,st]+'" Name="'+stringgrid1.Cells[1,st]+'" Message=" " />');
     if validstr(stringgrid1.Cells[0,st]) then xmlexp.delete(xmlexp.count);
   end
    else begin
      if validstr(stringgrid1.Cells[0,st]) then xmlexp.add('  </Station>');
    end;
end; //validstr
end; //st
end
 else ShowMessage('    !');
end;
lxml.free;
lxmlnum.free;
lexp.free;
lxmle.free;
d1.free;
dlist.free;
t.free;
end;    //MainProcCPPK











procedure TForm1.Button1Click(Sender: TObject);
  var reg:TRegistry;
begin
  listbox1.Items.clear;
  xmlexp.clear;
  xmlexp.add('<?xml version="1.0" encoding="windows-1251" ?>');

  if checkbox2.checked then MainProcCPPK
                       else MainProc;
  xmlexp.add('</Schedule>');
  if checkbox2.checked then savedialog1.filename:='r_'+add3(inttostr(combobox1.itemindex))+'_'+inttostr(combobox2.itemindex)+'_'+formatdatetime('yyyymmdd',date)+'.xml'
                       else savedialog1.filename:=extractfilename(labelededit1.text);
  savedialog1.InitialDir:=ExtractDirPath(labelededit1.text);
  if SaveDialog1.Execute then begin
     if not checkbox2.checked then listbox1.Items.SaveToFile(savedialog1.FileName);
     xmlexp.insert(2,'<Schedule File="r_'+add3(inttostr(combobox1.itemindex))+'_'+inttostr(combobox2.itemindex)+'_'+formatdatetime('yyyymmdd',date)+'.xml" DCreate="'+formatdatetime('dd.mm.yyyy',date)+'" Direction="'+add3(inttostr(combobox1.itemindex))+'" Subdir="'+inttostr(combobox2.itemindex)+'" Telegramm="'+stringgrid1.cells[1,3]+'" Version="1.0">');
     if checkbox2.checked then if not ValidStr(stringgrid1.cells[1,3]) then ShowMessage('  '+ExtractFileName(OpenDialog1.FileName)+'    !');
     if checkbox2.checked then xmlexp.SaveToFile(savedialog1.FileName);
  end;
REG := TRegistry.Create;
REG.RootKey:=HKEY_CURRENT_USER;
REG.OpenKey('Software\AF\ChgMaker',true);
REG.WriteString('LastBaseDir',ExtractDirPath(labelededit2.text));
REG.WriteString('LastChgDir',ExtractDirPath(labelededit1.text));
REG.CloseKey;
REG.Destroy;
end;

procedure TForm1.FormCreate(Sender: TObject);
  var t,t1:AF_Types.TStrings;
  var i:integer;
  var reg:TRegistry;
  var s:string;
  var fs:TFormatSettings;
begin
  fs.DateSeparator:='-';
  fs.ShortDateFormat:='yyyy-mm-dd';
  fs.LongDateFormat:='yyyy-mm-dd';
  form1.Caption:=form1.Caption+' '+pversion;
  workdaylist.create;
  holidaylist.create;
  workdaylist_cppk.create;
  holidaylist_cppk.create;
  workdaylist.loadfromfile(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\day_work.txt');
  holidaylist.loadfromfile(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\day_holiday.txt');
  workdaylist_cppk.loadfromfile(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\day_work.txt');
  holidaylist_cppk.loadfromfile(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\day_holiday.txt');
  if workdaylist.count>0 then begin
    for i:=1 to workdaylist.count do begin
      s:=workdaylist.getstring(i);
      s:=inttostr(trunc(StrToDate(s,fs)));
      workdaylist.edit(i,s);
    end;
  end;
  if holidaylist.count>0 then begin
    for i:=1 to holidaylist.count do begin
      s:=holidaylist.getstring(i);
      s:=inttostr(trunc(StrToDate(s,fs)));
      holidaylist.edit(i,s);
    end;
  end;
  log.Create;
  ofile.create;
  _trnlist.create;
  f1list.create;
//  datetimepicker1.DateTime:=Date+Time;
  skl.create;
  skl1.create;
  t.create;
  t1.create;
   if fileexists(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\skl.csv') then begin
     t.loadfromfile(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\skl.csv');
      if t.count>0 then begin
        for i:=1 to t.count do begin
          ParseCSVStr(@t1,t.getstring(i));
          if t1.count>=2 then begin
            skl.add(ansiuppercase(t1.getstring(1)));
            skl1.add(t1.getstring(2));
          end;
        end;
      end;
   end;
   t.free;
   t1.free;
REG := TRegistry.Create;
REG.RootKey:=HKEY_CURRENT_USER;
if REG.OpenKey('Software\AF\ChgMaker',false) then begin
if REG.ValueExists('LastBaseDir') then OpenDialog2.InitialDir:=REG.ReadString('LastBaseDir');
if REG.ValueExists('LastChgDir') then OpenDialog1.InitialDir:=REG.ReadString('LastChgDir');
end;
REG.CloseKey;
REG.Destroy;
xmlexp.create;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  log.free;
  ofile.free;
  _trnlist.free;
  f1list.free;
  skl.free;
  skl1.free;
  workdaylist.free;
  holidaylist.free;
  workdaylist_cppk.free;
  holidaylist_cppk.free;
  xmlexp.free;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
//  DateTimePicker1.Enabled:=checkbox1.checked;
end;

procedure DirProc(Dir: string; IncludeSubDirs: Boolean);
var
 SearchRec: TSearchRec;
 FindResult,n: Integer;
 fn,fe:string;
begin
 Dir:=IncludeTrailingBackslash(Dir);
// form1.listbox1.items.add('D: '+Dir);
 FindResult:=FindFirst(Dir+'*.*', faAnyFile, SearchRec);
 try
  while FindResult = 0 do with SearchRec do begin
   if (Attr and faDirectory) <> 0 then begin
    if IncludeSubDirs and (Name<>'.') and (Name<>'..') then
      DirProc(Dir+Name, IncludeSubDirs);
    end else begin
      fn:=ansilowercase(ExtractFileName(name));
      fe:=ansilowercase(ExtractFileExtention(name));
      if ((fe='xls')or(fe='xlsx')) then begin
       if (fn<>'0') then begin
        f1list.add(dir+name);
       end;
      end;
    end;
    FindResult:=FindNext(SearchRec);
  end;
 finally
  FindClose(SearchRec);
 end;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
 var s:string;
begin
  if OpenDialog2.Execute then begin
    labeledEdit2.Text:=OpenDialog2.filename;
    s:=AnsiLowerCase(ExtractFileName(OpenDialog2.FileName));
    if pos('',s)>0 then Combobox1.ItemIndex:=0;
    if pos('',s)>0 then Combobox1.ItemIndex:=1;
    if pos('',s)>0 then Combobox1.ItemIndex:=2;
    if pos('',s)>0 then Combobox1.ItemIndex:=3;
    if pos('',s)>0 then Combobox1.ItemIndex:=4;
    if pos('',s)>0 then Combobox1.ItemIndex:=5;
    if pos('',s)>0 then Combobox1.ItemIndex:=6;
    if pos('',s)>0 then Combobox1.ItemIndex:=7;
    if pos('',s)>0 then Combobox1.ItemIndex:=8;
    if pos('',s)>0 then Combobox1.ItemIndex:=9;
    if pos('',s)>0 then Combobox1.ItemIndex:=9;
    if pos(' ',s)>0 then Combobox2.ItemIndex:=0;
    if pos(' ',s)>0 then Combobox2.ItemIndex:=1;
    if pos(' ',s)>0 then Combobox2.ItemIndex:=1;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
  var i,n,z,h,m,h1,m1,h2,m2,ft,lt,u,k:integer;
  var s:string;
  var log:AF_Types.TStrings;
begin
  log.create;
  if FileExists(LabeledEdit2.Text) then begin
    LoadChgFromXLS(StringGrid2,StringGrid4,LabeledEdit2.Text);
      for i:=2 to stringgrid2.RowCount-1 do begin
        if StrToIntE1(stringgrid2.Cells[0,i])>0 then begin
          ft:=0;
          lt:=0;
          for z:=2 to stringgrid2.ColCount-1 do begin
           s:=trim(stringgrid2.cells[z,i]);
           if length(s)>3 then begin
            if (s[1] in ['0'..'9']) then begin
              ft:=z;
              break;
            end;
           end;
          end;
          for z:=stringgrid2.ColCount-1 downto 2 do begin
           s:=trim(stringgrid2.cells[z,i]);
           if length(s)>3 then begin
            if (s[1] in ['0'..'9']) then begin
              lt:=z;
              break;
            end;
           end;
          end;
          //
          if ft>0 then begin
           if lt>ft then begin
            log.add('');
            log.add(stringgrid2.cells[1,i]+'.  : '+stringgrid2.cells[ft,i]+',  : '+stringgrid2.cells[lt,i]);
             u:=-1;
             h2:=0;
             m2:=0;
              for z:=ft to lt do begin
               s:=trim(stringgrid2.cells[z,i]);
               if pos('/',s)>0 then s:=trim(copy(s,pos('/',s)+1,length(s)-pos('/',s)));
               if length(s)>3 then begin
                if (s[1] in ['0'..'9']) then begin
                  tohm(s,h1,m1);
                  if u>=0 then begin
                    h:=h1;
                    m:=m1;
                    for k:=1 to 1440 do begin
                      dechm(h,m,1);
                      if ((h=h2) and (m=m2)) then begin
                        break;
                      end;
                    end;
                    u:=k;
                    if length(s)=4 then s:='0'+s;
                    log.add(' '+s+', : '+inttostr(u));
                  end
                   else begin
                    if length(s)=4 then s:='0'+s;
                    log.add(' '+s+', : /');
                    u:=0;
                   end;
                  h2:=h1;
                  m2:=m1;
                end;
               end;
              end;
           end
            else begin
            log.add('');
            log.add(stringgrid2.cells[1,i]+'.    (ln<=ft)');
            end;
          end
           else begin
            log.add('');
            log.add(stringgrid2.cells[1,i]+'.  : ,  : ');
           end;
        end; // valid esr
      end;
  log.savetofile(LabeledEdit2.Text+'.txt');
  showmessage('!');    
  end;
  log.free;
end;

end.
