unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ADODB, DB, AF_Proc, AF_Types, FileCtrl, Grids,
  OleServer, ExcelXP, ComCtrls;

type
  TIntData = packed record
    enabled: boolean;
    simpledays,simpleint,simpleint2,simplestart,simpleend:string[20];
  end;
  TFTest = packed record
    t,i,o:integer;
  end;
  TForm1 = class(TForm)
    Button1: TButton;
    ListBox1: TListBox;
    ADOConnection1: TADOConnection;
    ADOTable1: TADOTable;
    ADODataSet1: TADODataSet;
    XLApp: TExcelApplication;
    StringGrid1: TStringGrid;
    Button3: TButton;
    StatusBar1: TStatusBar;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    OpenDialog1: TOpenDialog;
    Button2: TButton;
    Button4: TButton;
    OpenDialog2: TOpenDialog;
    Button5: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  stid,stname,stlat,stlon:AF_Types.TStrings;
  rid,rnum,rsttime,rentime,rint,rmode,rstart,rend,rtype,rdir,rname,rintdays,rint2,xmlfile,xrid,xrsttime,xrentime,xrint,xrintdays,xrint2,blacklist:AF_Types.TStrings;

implementation

{$R *.dfm}

Function StrToIntE1(s,fn:string):integer;
  var i,t:integer;
begin
   val(s,i,t);
   if t<>0 then begin
             StrToIntE1:=0;
             form1.ListBox1.Items.Add(':      '+fn)
           end
           else StrToIntE1:=i;
end;



procedure xhm(var h,m:integer);
  begin
    if m>59 then begin
      inc(h,(m div 60));
      m:=m mod 60;
    end;
    if h>23 then begin
     h:=h-24;
    end;
  end;

procedure dechm(var h,m:integer; t:integer);
  begin
    if (m-t)<0 then begin
      m:=60+(m-t);
      dec(h);
        if h<0 then h:=23;
    end
      else dec(m,t);
  end;

procedure inchm(var h,m:integer; t:integer);
  begin
    inc(m,t);
    xhm(h,m);
  end;

procedure tohm(s:string; var h,m:integer; fn:string);
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    if pos(':',s)>0 then begin
      h:=StrToIntE1(copy(s,1,pos(':',s)-1),fn);
      m:=StrToIntE1(copy(s,pos(':',s)+1,100),fn);
    end
     else begin
       form1.ListBox1.Items.Add(':      () '+fn)
     end;
  end;

function prephm(s:string):string;
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    result:=s;
  end;

function fromhm(h,m:integer):string;
  begin
    xhm(h,m);
    if h>9 then begin
             if m>9 then fromhm:=inttostr(h)+':'+inttostr(m)
                    else fromhm:=inttostr(h)+':0'+inttostr(m);
           end
           else begin
             if m>9 then fromhm:='0'+inttostr(h)+':'+inttostr(m)
                    else fromhm:='0'+inttostr(h)+':0'+inttostr(m);
           end;
  end;



procedure ParseCSVStrEx(ts:AF_Types.PStrings; s:widestring; c:char);
 var n:integer;
begin
  ts.clear;
  while pos(c,s)>0 do begin
    n:=pos(c,s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;

function DelQuot(s:string):string;
begin
{  if length(s)>0 then begin
   if s[1]='"' then delete(s,1,1);
    if length(s)>0 then begin
     if s[length(s)]='"' then delete(s,length(s),1);
     s:=trim(s);
     s:=StrReplace(s,'""','"');
    end;
  end;}
  s:=StrReplace(s,'"','&quot;');
  s:=StrReplace(s,'<','&quot;');
  s:=StrReplace(s,'>','&quot;');
  result:=s;
end;

function DelQuot1(s:string):string;
begin
  if length(s)>0 then begin
   while pos('"',s)>0 do delete(s,pos('"',s),1);
   s:=StrReplace(s,'  ',' ');
  end;
  result:=trim(s);
end;

function DelQuot2(s:string):string;
begin
  s:=StrReplace(s,'"','&quot;');
  s:=StrReplace(s,'<','&quot;');
  s:=StrReplace(s,'>','&quot;');
  s:=StrReplace(s,'&laquo;','&quot;');
  s:=StrReplace(s,'&raquo;','&quot;');
  result:=s;
end;


function OnDemandStop(s:string):string;
begin
 if ansilowercase(s)='' then result:=' '
                                 else result:=s;
end;

procedure TableCodePage(filedbf: string);
VAR
f: file of byte;
b: byte;
begin
b:=$26;
assignfile(f,filedbf);
reset(f);
seek(f,29);
write(f,b);
closeFile(f);
end;

procedure LoadStops(f:string);
 var ff:af_types.tstrings;
 var i:integer;
 var stn4:string;
begin
stn4:='';
stid.clear; stname.clear; stlat.clear; stlon.clear;
with form1 do begin
ff.create;
GetMaskList(DeleteSlasheEx(f)+'\stops*.DBF',@ff);
if ff.count>0 then begin
xmlfile.add('  <stations>');
for i:=1 to ff.count do begin
ADOTable1.Active:=false;
ADOConnection1.Connected:=false;
ADOConnection1.ConnectionString:='Provider=Microsoft.Jet.OLEDB.4.0;Data Source="'+DeleteSlasheEx(f)+'";Extended Properties="DBASE IV;";"';
ADOConnection1.LoginPrompt:=false;
ADOConnection1.Mode:=cmRead;
ADOConnection1.Connected:=true;
ADOConnection1.Connected:=true;
ADOTable1.TableName:=ff.getstring(i);
ADOTable1.Active:=true;
//showmessage(inttostr(ADOTable1.FieldCount));
ADOTable1.First;
while not ADOTable1.Eof do begin
 stid.add(ADOTable1.FieldValues['Id']);
 stname.add(vartostrdef(ADOTable1.FieldValues['Stop_name'],''));
 stn4:=vartostrdef(ADOTable1.FieldValues['Stop_name'],'');
 stlat.add(ADOTable1.FieldValues['Lat']);
 stlon.add(ADOTable1.FieldValues['Ion']);
 xmlfile.add('   <station code="'+stid.getstring(stid.count)+'" title="'+onDemandStop(delquot2(stname.getstring(stname.count)))+'" lat="'+stlat.getstring(stlat.count)+'" lon="'+stlon.getstring(stlon.count)+'" country_code="RU"><legacy_station code="default_vendor_'+stid.getstring(stid.count)+'" type="raw" title="'+onDemandStop(delquot2(stname.getstring(stname.count)))+'"/></station>');
 ADOTable1.Next;
end;
ADOConnection1.Connected:=false;
ADOTable1.Active:=false;
end;
xmlfile.add('  </stations>');
//showmessage(stn4);
end; //ff.count
ff.free;
end; //with
end;

procedure LoadStopsVFP(f:string);
 var ff:af_types.tstrings;
 var i:integer;
 var stn4:string;
begin
stn4:='';
stid.clear; stname.clear; stlat.clear; stlon.clear;
with form1 do begin
ff.create;
GetMaskList(DeleteSlasheEx(f)+'\stops*.DBF',@ff);
if ff.count>0 then begin
xmlfile.add('  <stations>');
for i:=1 to ff.count do begin
ADOTable1.Active:=false;
ADOConnection1.Connected:=false;
ADOConnection1.ConnectionString:='Provider=VFPOLEDB.1;Data Source="'+DeleteSlasheEx(f)+'";"';
ADOConnection1.LoginPrompt:=false;
ADOConnection1.Mode:=cmRead;
ADOConnection1.Connected:=true;
ADOConnection1.Connected:=true;
ADOTable1.TableName:=ff.getstring(i);
ADOTable1.Active:=true;
//showmessage(inttostr(ADOTable1.FieldCount));
ADOTable1.First;
while not ADOTable1.Eof do begin
 stid.add(ADOTable1.FieldValues['Id']);
 stname.add(vartostrdef(ADOTable1.FieldValues['Stop_name'],''));
 stn4:=vartostrdef(ADOTable1.FieldValues['Stop_name'],'');
 stlat.add(ADOTable1.FieldValues['Lat']);
 stlon.add(ADOTable1.FieldValues['Ion']);
 xmlfile.add('   <station code="'+stid.getstring(stid.count)+'" title="'+onDemandStop(delquot2(stname.getstring(stname.count)))+'" lat="'+stlat.getstring(stlat.count)+'" lon="'+stlon.getstring(stlon.count)+'" country_code="RU"><legacy_station code="default_vendor_'+stid.getstring(stid.count)+'" type="raw" title="'+onDemandStop(delquot2(stname.getstring(stname.count)))+'"/></station>');
 ADOTable1.Next;
end;
ADOConnection1.Connected:=false;
ADOTable1.Active:=false;
end;
xmlfile.add('  </stations>');
//showmessage(stn4);
end; //ff.count
ff.free;
end; //with
end;

procedure LoadStopsC29(f:string);
 var ff:af_types.tstrings;
 var i:integer;
 var stn4:string;
begin
stn4:='';
stid.clear; stname.clear; stlat.clear; stlon.clear;
with form1 do begin
ff.create;
GetMaskList(DeleteSlasheEx(f)+'\stops*.DBF',@ff);
if ff.count>0 then begin
xmlfile.add('  <stations>');
for i:=1 to ff.count do begin
TableCodePage(ff.getstring(i));
ADOTable1.Active:=false;
ADOConnection1.Connected:=false;
ADOConnection1.ConnectionString:='Provider=Microsoft.Jet.OLEDB.4.0;Data Source="'+DeleteSlasheEx(f)+'";Extended Properties="DBASE IV;";"';
ADOConnection1.LoginPrompt:=false;
ADOConnection1.Mode:=cmRead;
ADOConnection1.Connected:=true;
ADOConnection1.Connected:=true;
ADOTable1.TableName:=ff.getstring(i);
ADOTable1.Active:=true;
//showmessage(inttostr(ADOTable1.FieldCount));
ADOTable1.First;
while not ADOTable1.Eof do begin
 stid.add(ADOTable1.FieldValues['Id']);
 stname.add(vartostrdef(ADOTable1.FieldValues['Stop_name'],''));
 stn4:=vartostrdef(ADOTable1.FieldValues['Stop_name'],'');
 stlat.add(ADOTable1.FieldValues['Lat']);
 stlon.add(ADOTable1.FieldValues['Ion']);
 xmlfile.add('   <station code="'+stid.getstring(stid.count)+'" title="'+onDemandStop(delquot2(stname.getstring(stname.count)))+'" lat="'+stlat.getstring(stlat.count)+'" lon="'+stlon.getstring(stlon.count)+'" country_code="RU"><legacy_station code="default_vendor_'+stid.getstring(stid.count)+'" type="raw" title="'+onDemandStop(delquot2(stname.getstring(stname.count)))+'"/></station>');
 ADOTable1.Next;
end;
ADOConnection1.Connected:=false;
ADOTable1.Active:=false;
end;
xmlfile.add('  </stations>');
//showmessage(stn4);
end; //ff.count
ff.free;
end; //with
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  stid.create; stname.create; stlat.create; stlon.create; xmlfile.create;
  rid.create; rnum.create; rsttime.create; rentime.create; rint.create; rmode.create; rstart.create; rend.create; rtype.create; rdir.create; rname.create; rintdays.create; rint2.create;
  xrid.create; xrsttime.create; xrentime.create; xrint.create; xrintdays.create; xrint2.create;
  blacklist.create;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  stid.free; stname.free; stlat.free; stlon.free; xmlfile.free;
  rid.free; rnum.free; rsttime.free; rentime.free; rint.free; rmode.free; rstart.free; rend.free; rtype.free; rdir.free; rname.free; rintdays.free; rint2.free;
  xrid.free; xrsttime.free; xrentime.free; xrint.free; xrintdays.free; xrint2.free;
  blacklist.free;
end;

Procedure LoadXLS(fn:string);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
WSHS, K, R, X, Y, xx, yy : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf:string;
tf:double;
s,s1,s2,ts:string;
var h,m,lh:integer;
begin
with form1 do begin
NomFich := fn;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
for wshs:=1 to 1{WorkBk.WorkSheets.Count }do begin
WorkSheet := WorkBk.Sheets[wshs] as _WorkSheet;
WorkSheet.Activate(0);
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
if (x>2)and(y>2) then begin
stringgrid1.ColCount:=y;
stringgrid1.RowCount:=x;
for yy:=1 to y do begin
  for xx:=1 to x do begin
    s:='';
    nf:=worksheet.cells.item[xx,yy].NumberFormat;
    if (nf=':')or(nf=':')or(nf='h:mm')or(nf='hh:mm;@')or(nf=':;@')or(nf=':;@')or(nf='h:mm;@')or(nf='hh:mm;@') then begin
       tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xx,yy]),70);
       if tf=70 then s:=trim(VarToStrDef(worksheet.cells.item[xx,yy],''))
                else s:=trim(FormatDateTime('hh:nn',tf));
    end
     else s:=trim(VarToStrDef(worksheet.cells.item[xx,yy],''));
    stringgrid1.cells[yy-1,xx-1]:=s;
  end;
end;
end;
end;
WorkBk.Close(false,EmptyParam,EmptyParam,0);
XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;
end;
end;

procedure ClearSG;
 var i,n:integer;
begin
 for i:=0 to form1.StringGrid1.ColCount do
  for n:=0 to form1.StringGrid1.RowCount do form1.StringGrid1.Cells[i,n]:='';
end;


Procedure LoadTSV(fn:string);
var f1,u:AF_Types.TSTrings;
var i,n,m:integer;
begin
with form1 do begin
 clearsg;
 f1.create;
 u.create;
 f1.loadfromfile(fn);
 m:=0;
 if f1.count>0 then begin
  for i:=1 to f1.count do begin
    ParseCSVStrEx(@u,f1.getstring(i),#9);
    if u.count>m then m:=u.count;
  end;
  stringgrid1.ColCount:=m;
  stringgrid1.RowCount:=f1.count;
  clearsg;
  for i:=1 to f1.count do begin
    ParseCSVStrEx(@u,f1.getstring(i),#9);
    if u.count>0 then begin
      for n:=1 to u.count do stringgrid1.Cells[n-1,i-1]:=u.getstring(n);
    end;
  end;
 end;
 u.free;
 f1.free;
end;
end;


function delast(s:string):string;
begin
 while pos('*',s)>0 do delete(s,pos('*',s),1);
 result:=trim(s);
end;

function getintdata(z:integer; fname:string):TIntData;
  var intdata:TIntData;
  var mins,maxs:integer;
  var h,m,i,n,n1,n2,p:integer;
  var mr,ms,mv:boolean;
  var nr,ns,nv:integer;
  var s1r,s2r,s1s,s2s,s1v,s2v:integer;
begin
with form1 do begin
  intdata.enabled:=false;
  intdata.simpledays:='';
  intdata.simpleint:='';
  intdata.simpleint2:='';
  intdata.simplestart:='';
  intdata.simpleend:='';
  mins:=1440;
  maxs:=0;
  mr:=false;
  ms:=false;
  mv:=false;
   if ((length(stringgrid1.cells[6,z])>2)and(length(stringgrid1.cells[7,z])>2)) then begin
     tohm(stringgrid1.cells[6,z],h,m,fname);
      inchm(h,m,1260);
      p:=h*60+m;
      if p<mins then mins:=p;
     tohm(stringgrid1.cells[7,z],h,m,fname);
      inchm(h,m,1260);
      p:=h*60+m;
      if p>maxs then maxs:=p;
     n:=0;
     n1:=1440;
     n2:=1;
     p:=12;
     if strtointe(stringgrid1.cells[p,z])>0 then begin
       n:=n+strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])<n1 then n1:=strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])>n2 then n2:=strtointe(stringgrid1.cells[p,z]);
     end;
     p:=13;
     if strtointe(stringgrid1.cells[p,z])>0 then begin
       n:=n+strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])<n1 then n1:=strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])>n2 then n2:=strtointe(stringgrid1.cells[p,z]);
     end;
     p:=14;
     if strtointe(stringgrid1.cells[p,z])>0 then begin
       n:=n+strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])<n1 then n1:=strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])>n2 then n2:=strtointe(stringgrid1.cells[p,z]);
     end;
     p:=15;
     if strtointe(stringgrid1.cells[p,z])>0 then begin
       n:=n+strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])<n1 then n1:=strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])>n2 then n2:=strtointe(stringgrid1.cells[p,z]);
     end;
     n:=n div 4;
     if n>0 then begin
       mr:=true;
       nr:=n;
       s1r:=n1;
       s2r:=n2;
     end
      else ListBox1.Items.Add(':           id='+fname);
   end;
   if ((length(stringgrid1.cells[8,z])>2)and(length(stringgrid1.cells[9,z])>2)) then begin
     tohm(stringgrid1.cells[8,z],h,m,fname);
      inchm(h,m,1260);
      p:=h*60+m;
      if p<mins then mins:=p;
     tohm(stringgrid1.cells[9,z],h,m,fname);
      inchm(h,m,1260);
      p:=h*60+m;
      if p>maxs then maxs:=p;
     n:=0;
     n1:=1440;
     n2:=1;
     p:=16;
     if strtointe(stringgrid1.cells[p,z])>0 then begin
       n:=n+strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])<n1 then n1:=strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])>n2 then n2:=strtointe(stringgrid1.cells[p,z]);
     end;
     p:=17;
     if strtointe(stringgrid1.cells[p,z])>0 then begin
       n:=n+strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])<n1 then n1:=strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])>n2 then n2:=strtointe(stringgrid1.cells[p,z]);
     end;
     p:=18;
     if strtointe(stringgrid1.cells[p,z])>0 then begin
       n:=n+strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])<n1 then n1:=strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])>n2 then n2:=strtointe(stringgrid1.cells[p,z]);
     end;
     p:=19;
     if strtointe(stringgrid1.cells[p,z])>0 then begin
       n:=n+strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])<n1 then n1:=strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])>n2 then n2:=strtointe(stringgrid1.cells[p,z]);
     end;
     n:=n div 4;
     if n>0 then begin
       ms:=true;
       ns:=n;
       s1s:=n1;
       s2s:=n2;
     end
      else ListBox1.Items.Add(':           id='+fname);
   end;
   if ((length(stringgrid1.cells[10,z])>2)and(length(stringgrid1.cells[11,z])>2)) then begin
     tohm(stringgrid1.cells[10,z],h,m,fname);
      inchm(h,m,1260);
      p:=h*60+m;
      if p<mins then mins:=p;
     tohm(stringgrid1.cells[11,z],h,m,fname);
      inchm(h,m,1260);
      p:=h*60+m;
      if p>maxs then maxs:=p;
     n:=0;
     n1:=1440;
     n2:=1;
     p:=20;
     if strtointe(stringgrid1.cells[p,z])>0 then begin
       n:=n+strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])<n1 then n1:=strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])>n2 then n2:=strtointe(stringgrid1.cells[p,z]);
     end;
     p:=21;
     if strtointe(stringgrid1.cells[p,z])>0 then begin
       n:=n+strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])<n1 then n1:=strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])>n2 then n2:=strtointe(stringgrid1.cells[p,z]);
     end;
     p:=22;
     if strtointe(stringgrid1.cells[p,z])>0 then begin
       n:=n+strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])<n1 then n1:=strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])>n2 then n2:=strtointe(stringgrid1.cells[p,z]);
     end;
     p:=23;
     if strtointe(stringgrid1.cells[p,z])>0 then begin
       n:=n+strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])<n1 then n1:=strtointe(stringgrid1.cells[p,z]);
       if strtointe(stringgrid1.cells[p,z])>n2 then n2:=strtointe(stringgrid1.cells[p,z]);
     end;
     n:=n div 4;
     if n>0 then begin
       mv:=true;
       nv:=n;
       s1v:=n1;
       s2v:=n2;
     end
      else ListBox1.Items.Add(':           id='+fname);
   end;

   n:=0;
   p:=0;
   n1:=1440;
   n2:=1;
   if mr then begin
      intdata.simpledays:='12345';
      n:=n+nr;
      inc(p);
      if s1r<n1 then n1:=s1r;
      if s2r>n2 then n2:=s2r;
   end;
   if ms then begin
      intdata.simpledays:=intdata.simpledays+'6';
      n:=n+ns;
      inc(p);
      if s1s<n1 then n1:=s1s;
      if s2s>n2 then n2:=s2s;
   end;
   if ms then begin
      intdata.simpledays:=intdata.simpledays+'7';
      n:=n+nv;
      inc(p);
      if s1v<n1 then n1:=s1v;
      if s2v>n2 then n2:=s2v;
   end;
   if intdata.simpledays<>'' then begin
     intdata.enabled:=true;
     intdata.simpleint:=inttostr(n div p);
     if n1=n2 then intdata.simpleint2:=inttostr(n1)
              else intdata.simpleint2:=inttostr(n1)+'-'+inttostr(n2);
     mins:=mins+180;
     h:=mins div 60;
     m:=mins mod 60;
     intdata.simplestart:=fromhm(h,m);
     maxs:=maxs+180;
     h:=maxs div 60;
     m:=maxs mod 60;
     intdata.simpleend:=fromhm(h,m);
   end;
end;
result:=intdata;
end;

function testDoImport(i:integer):boolean;
begin
  result:=false;
  if ((ansilowercase(form1.stringgrid1.cells[28,i])='y')or(ansilowercase(form1.stringgrid1.cells[28,i])='')) then begin
   if true then begin
    if form1.CheckBox1.Checked then begin
       if ((ansilowercase(form1.stringgrid1.cells[27,i])='')or(ansilowercase(form1.stringgrid1.cells[27,i])='')) then result:=true;
    end
     else begin
       if ansilowercase(form1.stringgrid1.cells[27,i])='' then result:=true;
     end;
   end;
  end;
end;

function LoadIntList(f:string):boolean;
  var i,n:integer;
  var s1,s2,vdays:string;
  var intdata:TIntData;
begin
with form1 do begin
  result:=false;
  rid.clear; rnum.clear; rsttime.clear; rentime.clear; rint.clear; rmode.clear; rstart.clear; rend.clear; rtype.clear; rdir.clear; rname.clear; rintdays.clear; rint2.clear;
//  if fileexists(f+'int.txt') then begin
//    LoadTSV(f+'int.txt');
  if fileexists(f+'int.xls') then begin
    LoadXLS(f+'int.xls');
    if StringGrid1.RowCount>1 then begin
    if StringGrid1.ColCount>27 then begin
      for i:=1 to StringGrid1.RowCount-1 do begin
       if validstr(stringgrid1.cells[1,i]) then begin
//       if ((ansilowercase(stringgrid1.cells[27,i])='')or(ansilowercase(stringgrid1.cells[27,i])='')) then begin
       if testDoImport(i) then begin
        rtype.add(stringgrid1.cells[0,i]);
        rid.add(stringgrid1.cells[1,i]);
        xrid.add(stringgrid1.cells[1,i]+'_'+stringgrid1.cells[2,i]);
        rdir.add(stringgrid1.cells[2,i]);
        rnum.add(delast(stringgrid1.cells[3,i]));
        if i<StringGrid1.RowCount-1 then begin
         if stringgrid1.cells[2,i]='1' then begin
           if stringgrid1.cells[1,i]=stringgrid1.cells[1,i+1] then rname.add(delquot1(stringgrid1.cells[4,i])+' - '+delquot1(stringgrid1.cells[4,i+1]))
                                                              else rname.add(delquot1(stringgrid1.cells[4,i]));
         end
          else begin
           if i>0 then begin
            if stringgrid1.cells[2,i]='2' then begin
              if stringgrid1.cells[1,i]=stringgrid1.cells[1,i-1] then rname.add(delquot1(stringgrid1.cells[4,i])+' - '+delquot1(stringgrid1.cells[4,i-1]))
                                                                 else rname.add(delquot1(stringgrid1.cells[4,i]));
            end
             else rname.add(delquot1(stringgrid1.cells[4,i]));
           end
            else rname.add(delquot1(stringgrid1.cells[4,i]));
          end;
        end
         else rname.add(delquot1(stringgrid1.cells[4,i]));
        vdays:='';
        intdata:=getintdata(i,stringgrid1.cells[1,i]);
         if intdata.enabled then begin
            rsttime.add(intdata.simplestart);
            rentime.add(intdata.simpleend);
            rint.add(intdata.simpleint);
            rint2.add(intdata.simpleint2);
            rintdays.add(intdata.simpledays);
            xrsttime.add(intdata.simplestart);
            xrentime.add(intdata.simpleend);
            xrint.add(intdata.simpleint);
            xrint2.add(intdata.simpleint2);
            xrintdays.add(intdata.simpledays);
         end
          else begin
            rsttime.add('');
            rentime.add('');
            rint.add('');
            rint2.add('');
            rintdays.add('');
            xrsttime.add('');
            xrentime.add('');
            xrint.add('');
            xrint2.add('');
            xrintdays.add('');
          end;
        rmode.add(ansilowercase(stringgrid1.cells[24,i]));
        rstart.add(stringgrid1.cells[25,i]);
        rend.add(stringgrid1.cells[26,i]);
       end;
       end;
      end;
    end;
    end;
    if rid.count>0 then begin
      result:=true;
    end;
  end
   else result:=false;
end;
end;


function LoadDFList(mdir:string; flist,fid,ftype:AF_Types.PStrings):boolean;
  var i:integer;
  var s:string;
begin
  flist.clear;
  fid.clear;
  ftype.clear;
  GetMaskList(mdir+'data\*.xl*',flist);
   if flist.count>0 then begin
    for i:=1 to flist.count do begin
      fid.add('');
      ftype.add('');
      s:=flist.getstring(i);
      if pos('-',s)>1 then begin
        s:=trim(ansilowercase(copy(s,1,pos('-',s)-1)));
        if length(s)>0 then begin
         if s[1]<>'i' then begin
          fid.edit(i,s);
          ftype.edit(i,'t');
         end
          else begin
           delete(s,1,1);
           s:=trim(s);
           if length(s)>0 then begin
            fid.edit(i,s);
            ftype.edit(i,'i');
           end
            else form1.ListBox1.Items.Add(':     '+flist.getstring(i));
          end;
        end
         else form1.ListBox1.Items.Add(':     '+flist.getstring(i));
      end
       else form1.ListBox1.Items.Add(':     '+flist.getstring(i));
    end;
    result:=true;
   end
    else result:=false;
end;

function _ftest(ft:af_Types.PStrings):TFTest;
  var i:integer;
begin
  result.t:=0;
  Result.i:=0;
  Result.o:=0;
  if ft.count>0 then begin
   for i:=1 to ft.count do begin
     if ft.getstring(i)='t' then inc(result.t)
      else begin
        if ft.getstring(i)='i' then inc(result.i)
          else inc(result.o);
      end;
   end;
  end;
end;

function findsr(r:integer; var sr:integer; var rn:string):boolean;
  var i:integer;
  var res:boolean;
  var s:string;
begin
with form1 do begin
  sr:=0;
  rn:='';
  if r<stringgrid1.RowCount-1 then begin
    res:=false;
    for i:=r to stringgrid1.RowCount-1 do begin
      if ((pos(' ',ansilowercase(trim(stringgrid1.Cells[0,i])))=1)and(pos('  ',ansilowercase(trim(stringgrid1.Cells[0,i])))=0)) then begin
        sr:=i;
        s:=stringgrid1.Cells[0,i];
        delete(s,1,8);
        rn:=trim(s);
        res:=true;
        break;
      end;
    end;
    result:=res;
  end
   else result:=false;
end;
end;

function finder(r:integer; var er:integer):boolean;
  var i:integer;
  var res:boolean;
  var s:string;
begin
with form1 do begin
  er:=0;
  if r<stringgrid1.RowCount-1 then begin
    res:=false;
    for i:=r to stringgrid1.RowCount-1 do begin
      if pos(' ',ansilowercase(trim(stringgrid1.Cells[0,i])))=1 then begin
        er:=i;
        res:=true;
        break;
      end;
    end;
    result:=res;
  end
   else result:=false;
end;
end;

function testdk(s:string):boolean;
  var i:integer;
begin
  if length(s)>0 then begin
    result:=true;
    if ansilowercase(s)<>'' then begin
      for i:=1 to length(s) do begin
        if (not (s[i] in ['1'..'7'])) then result:=false;
      end;
    end;
  end
   else result:=false;
end;

function calcdstr(s:string):string;
begin
  result:='';
  if s='1234567' then result:=' ';
  if s='12345' then result:='  ';
  if s='6' then result:='  ';
  if s='7' then result:='  ';
  if s='67' then result:='  ';
  if s='123456' then result:='  ';
  if s='123457' then result:='  ';
end;

procedure CalcSch(out1:AF_Types.PStrings; fstart,ftxt,fid,fname,fdir:string; var inttxt:string);
  var id,i:integer;
begin
with form1 do begin
  inttxt:='';
  out1.clear;
  id:=xrid.SearchString(fid+'_'+fdir);
  if id>0 then begin
   ftxt:=ansilowercase(ftxt);
   if ftxt='' then begin
     if ((rmode.getstring(id)='interval')or(rmode.getstring(id)='complex')) then begin
       if rintdays.getstring(id)<>'' then begin
         out1.add('     <schedule days="'+rintdays.getstring(id)+'" period_int="'+rint.getstring(id)+'" period_start_time="'+rsttime.getstring(id)+'" period_end_time="'+rentime.getstring(id)+'" period_start_date="2014-01-01" period_end_date="2100-12-31"/>');
         inttxt:={calcdstr(rintdays.getstring(id))+}{' '+rsttime.getstring(id)+'  '+rentime.getstring(id)+', }' '+rint2.getstring(id)+' .';
       end
        else ListBox1.Items.Add(':          id='+fid);
     end
      else ListBox1.Items.Add(':             '+fname);
   end
    else begin
     if ((rmode.getstring(id)='timetable')or(rmode.getstring(id)='complex')) then begin
       out1.add('     <schedule  times="'+fstart+'" days="'+ftxt+'" period_start_date="2014-01-01" period_end_date="2100-12-31"/>');
     end
      else ListBox1.Items.Add(':             '+fname);
    end;
  end
   else ListBox1.Items.Add(':  schedules, ..            '+fname+' ('+fid+'_'+fdir+')');
end;
end;

function t60(s:string):string;
begin
  result:=inttostr(strtointe(s)*60);
end;

function t60m(s:string):string;
begin
  result:=inttostr(strtointe(s)*60);
  result:=inttostr(strtointe(result)-60);
  if strtointe(result)<0 then result:='0';
end;

function t60m0(s:string):string;
begin
  result:=inttostr(strtointe(s)*60);
  result:=inttostr(strtointe(result));
  if strtointe(result)<0 then result:='0';
end;

procedure ProcFile(fn:string; outf:AF_Types.PStrings; fid:string);
  var i,n,c,r,sr,er,h0,m0,h1,m1,h2,m2,lm,thc,rc,h0a,m0a:integer;
  var rn,ftxt,fstart,inttxt,fdir:string;
  var ti,td,tt1,tt2,tt1a,tt2a,out1:AF_Types.TStrings;
begin
with form1 do begin
rc:=rid.SearchString(fid);
if rc>0 then begin
 out1.create;
 ti.create;
 td.create;
 tt1.create;
 tt2.create;
 tt1a.create;
 tt2a.create;
 thc:=0;
 LoadXLS(fn);
 if ((stringgrid1.ColCount>=6)and(stringgrid1.ColCount>=8)) then begin
  er:=0;
  sr:=0;
  r:=0;
  repeat
    if findsr(r,sr,rn) then begin
      if finder(sr,er) then begin
       if er>sr+1 then begin
        for n:=7 to StringGrid1.ColCount-1 do begin
         ftxt:='';
         fstart:='';
         if ((validstr(stringgrid1.Cells[n,sr]))and(ansilowercase(stringgrid1.Cells[n,sr])<>'t')and(ansilowercase(stringgrid1.Cells[n,sr])<>'')) then begin
           if testdk(stringgrid1.Cells[n,sr]) then begin
             outf.add('');
             outf.add(' : '+stringgrid1.Cells[n,sr]);
             ftxt:=stringgrid1.Cells[n,sr];
             ti.clear;
             td.clear;
             tt1.clear;
             tt2.clear;
             tt1a.clear;
             tt2a.clear;
             fdir:=stringgrid1.cells[0,sr+1];
             for i:=sr+1 to er-1 do begin
               if validstr(stringgrid1.cells[n,i]) then begin
                 if fstart='' then fstart:=stringgrid1.cells[n,i];
                 outf.add(stringgrid1.cells[n,i]+'  '+stringgrid1.cells[4,i]);
                 if stid.SearchString(stringgrid1.cells[5,i])<=0 then ListBox1.Items.Add(':       "'+stringgrid1.Cells[5,i]+'"   '+extractfilename(fn));
                 ti.add(stringgrid1.Cells[5,i]);
                 td.add(stringgrid1.Cells[6,i]);
                 if pos('/',stringgrid1.Cells[n,i])>0 then begin
                  tt1.add(trim(copy(stringgrid1.Cells[n,i],1,pos('/',stringgrid1.Cells[n,i])-1)));
                  tt2.add(trim(copy(stringgrid1.Cells[n,i],pos('/',stringgrid1.Cells[n,i])+1,100)));
                  tt1a.add('ERR');
                  tt2a.add('ERR');
                 end
                  else begin
                   tt1.add(stringgrid1.Cells[n,i]);
                   tt2.add(stringgrid1.Cells[n,i]);
                   tt1a.add('ERR');
                   tt2a.add('ERR');
                  end;
               end;
             end;
             if ti.count>1 then begin
              inc(thc);
              lm:=0;
              tt1a.edit(1,'');
              tt2a.edit(1,'0');
              for i:=1 to ti.count do begin
                tohm(tt1.getstring(i),h1,m1,extractfilename(fn));
                tohm(tt2.getstring(i),h2,m2,extractfilename(fn));
                if i=1 then begin
                  h0:=h2;
                  m0:=m2;
                end
                 else begin
                   if not ((h1=h2)and(m1=m2)) then begin
                     if not ((h1=h0)and(m1=m0)) then begin
                      repeat
                        inchm(h0,m0,1);
                        inc(lm);
                      until ((h1=h0)and(m1=m0));
                      tt1a.edit(i,inttostr(lm));
                     end
                      else begin
                       tt1a.edit(i,inttostr(lm));
                       tt2a.edit(i,inttostr(lm));
                      end;
                     if not ((h2=h0)and(m2=m0)) then begin
                      repeat
                        inchm(h0,m0,1);
                        inc(lm);
                      until ((h2=h0)and(m2=m0));
                      tt2a.edit(i,inttostr(lm));
                     end
                      else begin
                       tt1a.edit(i,inttostr(lm));
                       tt2a.edit(i,inttostr(lm));
                      end;
                   end
                    else begin
                     if not ((h2=h0)and(m2=m0)) then begin
                      repeat
                        inchm(h0,m0,1);
                        inc(lm);
                      until ((h2=h0)and(m2=m0));
                      tt1a.edit(i,inttostr(lm));
                      tt2a.edit(i,inttostr(lm));
                     end
                      else begin
                       tt1a.edit(i,inttostr(lm));
                       tt2a.edit(i,inttostr(lm));
                      end;
                    end;
                 end;
              end; //for
              tt2a.edit(tt2a.count,'');
               if lm>=1200 then ListBox1.Items.Add(':   (   '+inttostr(lm)+' )   '+extractfilename(fn));
               outf.add('lm='+inttostr(lm));
               if tt1a.count>0 then begin
                if blacklist.SearchString(fid+'_'+fdir)<=0 then begin
                 CalcSch(@out1,fstart,ftxt,fid,extractfilename(fn),fdir,inttxt);
                 if inttxt<>'' then inttxt:=' schedule_density="'+inttxt+'"';
                 xmlfile.add('   <thread title="'+rnum.getstring(rc)+'" t_type="bus" number="'+rnum.getstring(rc)+'" timezone="Europe/Moscow"'+inttxt+' >');
                 xmlfile.add('    <stoppoints>');
                 for i:=1 to tt1a.count do begin
                   outf.add(tt1a.getstring(i)+'/'+tt2a.getstring(i)+'  ');
                   if ((i>1) and (i<tt1a.count)) then begin
                                                        if t60m(tt1a.getstring(i))=t60m(tt2a.getstring(i)) then begin
                                                          xmlfile.add('     <stoppoint station_code="'+ti.getstring(i)+'" arrival_shift="'+t60m(tt1a.getstring(i))+'" departure_shift="'+t60m(tt2a.getstring(i))+'" distance="'+floattostr(strtointe(td.getstring(i))/1000)+'" />')
                                                        end
                                                         else begin
                                                          xmlfile.add('     <stoppoint station_code="'+ti.getstring(i)+'" arrival_shift="'+t60m0(tt1a.getstring(i))+'" departure_shift="'+t60m0(tt2a.getstring(i))+'" distance="'+floattostr(strtointe(td.getstring(i))/1000)+'" />')
                                                         end;
                                                      end
                                                 else xmlfile.add('     <stoppoint station_code="'+ti.getstring(i)+'" arrival_shift="'+t60(tt1a.getstring(i))+'" departure_shift="'+t60(tt2a.getstring(i))+'" distance="'+floattostr(strtointe(td.getstring(i))/1000)+'" />');
                 end;
                 xmlfile.add('    </stoppoints>');
                 xmlfile.add('    <schedules>');
                 if out1.count>0 then xmlfile.include(out1);
                 xmlfile.add('    </schedules>');
                 xmlfile.add('   </thread>');
                 xmlfile.add('');
                end
                 else begin
                  if listbox1.Items.IndexOf('     : '+fid+'_'+fdir)<0 then ListBox1.Items.Add('     : '+fid+'_'+fdir);
                 end;
               end;
             end
              else ListBox1.Items.Add(':   (     )   '+extractfilename(fn));
           end
            else ListBox1.Items.Add(':    "'+stringgrid1.Cells[n,sr]+'"   '+extractfilename(fn));
         end;
        end;
       end
        else ListBox1.Items.Add(':    (    )   '+extractfilename(fn));
        r:=er;
      end
       else ListBox1.Items.Add(':    -    '+extractfilename(fn));
    end
     else break;
    inc(r);
  until r>=stringgrid1.RowCount;
  if thc<1 then ListBox1.Items.Add(':  (   )  '+extractfilename(fn));
 end
  else ListBox1.Items.Add(':    '+extractfilename(fn));
 ti.free;
 td.free;
 tt1.free;
 tt2.free;
 tt1a.free;
 tt2a.free;
 out1.free;
end
 else ListBox1.Items.Add(':       '+extractfilename(fn));
end;
end;

procedure LoadBlacklist;
  var f,u:AF_Types.TStrings;
  var i:integer;
begin
 f.create; u.create;
 blacklist.clear;
 if form1.checkbox2.checked then begin
  f.loadfromfile(deleteslasheex(extractdirpath(application.exename))+'\blacklist.txt');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      ParseCSVStrEx(@u,f.getstring(i),#9);
      if u.count>2 then begin
        if StrToInte(u.getstring(2))>0 then begin
        if StrToInte(u.getstring(3))>0 then begin
          if blacklist.SearchString(u.getstring(2)+'_'+u.getstring(3))<=0 then blacklist.add(u.getstring(2)+'_'+u.getstring(3));
        end;
        end;
      end;
    end;
  end;
 end; 
 f.free; u.free;
end;

procedure TForm1.Button1Click(Sender: TObject);
  var mdir:string;
  var i,n:integer;
  var flist,fid,ftype,lid,flog:AF_Types.TStrings;
  var ftest:TFTest;
begin
  xmlfile.clear;
  flist.create;
  fid.create;
  ftype.create;
  lid.create;
  flog.create;
//  mdir:='C:\AF\';
//  if SelectDirectory('','',mdir) then begin
   if OpenDialog1.Execute then begin
   mdir:=DeleteSlasheEx(ExtractDirPath(OpenDialog1.FileName));
   xmlfile.add('<?xml version="1.0" encoding="windows-1251"?>');
   xmlfile.add('');
   xmlfile.add('<channel version="1.0" t_type="bus" station_code_system="vendor" timezone="local" carrier_code_system="vendor" vehicle_code_system="vendor">');
   xmlfile.add(' <group code="discusmedia" title="- (   )">');
   listbox1.Items.Clear;
   mdir:=deleteslasheex(mdir)+'\';
   if fileexists(mdir+'files.log') then deletefile(mdir+'files.log');
   LoadBlackList;
   ListBox1.Items.Add('   : '+inttostr(blacklist.count)+' .');
   LoadStopsC29(mdir);
   if stid.count>0 then begin
     ListBox1.Items.Add(' : '+inttostr(stid.count)+' .');
     if LoadIntList(mdir) then begin
       ListBox1.Items.Add('  : '+inttostr(rid.count)+' .');
       if LoadDFList(mdir,@flist,@fid,@ftype) then begin
         ListBox1.Items.Add('  : '+inttostr(flist.count)+' .');
         ftest:=_ftest(@ftype);
         ListBox1.Items.Add('      '+inttostr(ftest.t)+',  '+inttostr(ftest.i)+',   '+inttostr(ftest.o)+'.');
         if flist.count>0 then begin
           for i:=1 to flist.count do begin
             if rid.SearchString(fid.getstring(i))<=0 then ListBox1.Items.Add(':            '+flist.getstring(i));
           end;
         end;
         if rid.count>0 then begin
           lid.clear;
           for i:=1 to rid.count do begin
             if fid.SearchString(rid.getstring(i))<=0 then begin
              if lid.SearchString(rid.getstring(i))<=0 then begin
               ListBox1.Items.Add(':          ID='+rid.getstring(i)+' ('+rnum.getstring(i)+' '+rname.getstring(i)+')');
               lid.add(rid.getstring(i));
              end;
             end;
           end;
         end;
         lid.clear;
         if flist.count>0 then begin
           xmlfile.add('  <threads>');
           for i:=1 to flist.count do begin
             Statusbar1.SimpleText:='  '+flist.getstring(i)+' ('+inttostr(i)+'  '+inttostr(flist.count)+')';
             if rid.SearchString(fid.getstring(i))>0 then begin
               flog.add(mdir+'data\'+flist.getstring(i));
               if checkbox3.Checked then flog.savetofile(mdir+'files.log');
               ProcFile(mdir+'data\'+flist.getstring(i),@lid,fid.getstring(i));
             end
              else ListBox1.Items.Add('      '+flist.getstring(i));
           end;
           xmlfile.add('  </threads>');
         end;
       end
        else ListBox1.Items.Add(':      !')
     end
      else ListBox1.Items.Add(':        !')
   end
    else ListBox1.Items.Add(':     !');
    xmlfile.add(' </group>');
    xmlfile.add('</channel>');
    xmlfile.savetofile(mdir+'discusmedia.xml');
    listbox1.Items.savetofile(mdir+'log.txt');
    statusbar1.SimpleText:='';
    showmessage('end!');
  end;
  flist.free;
  fid.free;
  ftype.free;
  lid.free;
  flog.free;
end;

procedure TForm1.Button3Click(Sender: TObject);
  var ofile:AF_Types.TStrings;
  var mdir:string;
begin
  ofile.create;
  listbox1.Items.Clear;
  mdir:='C:\1\\';
  mdir:=deleteslasheex(mdir)+'\';
  LoadStops(mdir);
  procfile('C:\1\\\data\4126-101-.xls',@ofile,'4126');
  ofile.savetofile('C:\1\\\ofile.txt');
  ofile.free;
  showmessage('end!');
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 if OpenDialog2.Execute then begin
   LoadStops(deleteslasheex(ExtractDirPath(OpenDialog2.FileName)));
 end;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
 if OpenDialog2.Execute then begin
   LoadStopsVFP(deleteslasheex(ExtractDirPath(OpenDialog2.FileName)));
 end;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
 if OpenDialog2.Execute then begin
   LoadStopsC29(deleteslasheex(ExtractDirPath(OpenDialog2.FileName)));
 end;
end;

end.
