unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, StdCtrls, ExtCtrls, OleServer, ExcelXP, AF_Proc, AF_Types;

type
  TForm1 = class(TForm)
    LabeledEdit1: TLabeledEdit;
    SpeedButton1: TSpeedButton;
    OpenDialog1: TOpenDialog;
    XLApp: TExcelApplication;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    RadioGroup1: TRadioGroup;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    Button1: TButton;
    CheckBox7: TCheckBox;
    procedure SpeedButton1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

function PrepareStr1(s:string):string;
 var l,n,m,x:integer;
begin
  s:=trim(s);
  while pos('"',s)>0 do s[pos('"',s)]:='`';
  if s='?' then s:='-';
  if s='--' then s:='-';
  if s='---' then s:='-';
  if s='----' then s:='-';
  if s='-----' then s:='-';
  if s=':' then s:='';
  if s=#133 then s:='';
  if s='.' then s:='';
  if s='..' then s:='';
  if s='...' then s:='';
  if s='....' then s:='';
  if s='.....' then s:='';
  if s='......' then s:='';
  if s='' then s:='';
  l:=length(s);
  n:=pos(',',s);
  if (n=l-1)and(n>0) then s:=s+'0';
  s:=StrReplace(s,',','.');
  s:=StrReplace(s,':','.');
   if form1.checkbox1.Checked then begin
     if length(s)>2 then begin
       if s[length(s)]='5' then begin
        if s[length(s)-1]='.' then begin
          s:=trim(copy(s,1,length(s)-2));
        end;
       end;
     end;
   end;
   if form1.checkbox7.Checked then begin
     if length(s)>3 then begin
       if ((s[length(s)]='5')or(s[length(s)]='s')or(s[length(s)]='S')) then begin
        if s[length(s)-3]='.' then begin
          s:=trim(copy(s,1,length(s)-1));
        end;
       end;
     end;
   end;
  if s<>'-' then s:=StrReplace(s,'-','.');
  l:=length(s);
  n:=pos(':',s);
  if n=2 then s:='0'+s;
  result:=trim(s);
end;

function isNumber(s:string):boolean;
 var i,n:integer;
begin
  n:=0;
  Val(s,i,n);
  if n=0 then result:=true
         else result:=false;
end;

procedure xhm(var h,m:integer);
  begin
    if m>59 then begin
      inc(h,(m div 60));
      m:=m mod 60;
    end;
    if h>23 then begin
     h:=h-24;
    end;
  end;

procedure tohm(s:string; var h,m:integer);
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    if pos(':',s)>0 then begin
      h:=StrToIntE(copy(s,1,pos(':',s)-1));
      m:=StrToIntE(copy(s,pos(':',s)+1,100));
    end;
  end;

function prephm(s:string):string;
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    result:=s;
  end;

procedure inchm(var h,m:integer; t:integer);
  begin
    inc(m,t);
    xhm(h,m);
  end;
  
function fromhm(h,m:integer):string;
  begin
    xhm(h,m);
    if h>9 then begin
             if m>9 then fromhm:=inttostr(h)+':'+inttostr(m)
                    else fromhm:=inttostr(h)+':0'+inttostr(m);
           end
           else begin
             if m>9 then fromhm:='0'+inttostr(h)+':'+inttostr(m)
                    else fromhm:='0'+inttostr(h)+':0'+inttostr(m);
           end;
  end;


procedure PrepareXLS(fn:string);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
WSHS, K, R, X, Y, xx, yy, ns, ns1 : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf:string;
tf:double;
s,s1,s2:string;
var h,m,h1,h2,m1,m2,lh:integer;
begin
with form1 do begin
NomFich := fn;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
//WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
for wshs:=1 to WorkBk.WorkSheets.Count do begin
WorkSheet := WorkBk.Sheets[wshs] as _WorkSheet;
WorkSheet.Activate(0);
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
if checkbox3.checked then ns:=5
                     else ns:=3;
if checkbox5.checked then ns1:=2
                     else ns1:=3;
if (x>=ns)and(y>=ns1) then begin
for yy:=ns1 to y do begin
  h:=0; m:=0; lh:=0;
  for xx:=ns to x do begin
    s:='';
    nf:=worksheet.cells.item[xx,yy].NumberFormat;
    if (nf=':')or(nf=':')or(nf='h:mm')or(nf='hh:mm;@')or(nf=':;@')or(nf=':;@')or(nf='h:mm;@')or(nf='hh:mm;@')or(nf=':: AM/PM')or(nf='::')or(nf=':: AM/PM')or(nf='::')or(nf='[$-F400]:: AM/PM') then begin
       tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xx,yy]),70);
       s:=VarToStrDef(worksheet.cells.item[xx,yy],'');
       if s<>'-' then if length(s)>0 then s:=FormatDateTime('hh:nn',tf);
    end
     else s:=PrepareStr1(Trim(VarToStrDef(worksheet.cells.item[xx,yy],'')));
    if length(s) in [1..2] then begin
      if isNumber(s) then begin
       s:=inttostr(lh)+'.'+s;
      end;
       worksheet.cells.item[xx,yy].NumberFormat:='@';
       worksheet.cells.item[xx,yy]:=s;
     end
     else begin
       if pos('/',s)>0 then begin
         s1:=trim(copy(s,1,pos('/',s)-1));
         s2:=trim(copy(s,pos('/',s)+1,length(s)-pos('/',s)));
         tohm(trim(s2),h,m);
         lh:=h;
         s1:=StrReplace(s1,':','.');
         s2:=StrReplace(s2,':','.');
          if length(s1)>0 then begin
           if ((s1[1]='0')and(s1[2] in ['0'..'9'])) then s1:=trim(copy(s1,2,length(s1)-1));
          end;
          if length(s2)>0 then begin
           if ((s2[1]='0')and(s2[2] in ['0'..'9'])) then s2:=trim(copy(s2,2,length(s2)-1));
          end;
          s:=s1+'/'+s2;
          if checkbox6.Checked then begin
            tohm(s1,h1,m1);
            tohm(s2,h2,m2);
            inchm(h1,m1,1);
            if ((h1=h2)and(m1=m2)) then s:=s2;
          end;
       end
        else begin
          tohm(trim(s),h,m);
          lh:=h;
          s:=trim(StrReplace(s,':','.'));
          if length(s)>1 then begin
           if ((s[1]='0')and(s[2] in ['0'..'9'])) then s:=trim(copy(s,2,length(s)-1));
          end;
        end;
       worksheet.cells.item[xx,yy].NumberFormat:='@';
       s:=trim(StrReplace(s,'.',':'));
       worksheet.cells.item[xx,yy]:=s;
     end;
  end;
  Application.ProcessMessages;
end;
end;
end;
WorkBk.Close(true,EmptyParam,EmptyParam,0);
XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;
end;
end;



procedure PrepareXLS_OnlyFmt(fn:string);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
WSHS, K, R, X, Y, xx, yy : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf:string;
tf:double;
s,s1,s2:string;
var h,m,lh:integer;
begin
with form1 do begin
NomFich := fn;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
for wshs:=1 to WorkBk.WorkSheets.Count do begin
WorkSheet := WorkBk.Sheets[wshs] as _WorkSheet;
WorkSheet.Activate(0);
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
if (x>2)and(y>2) then begin
for xx:=1 to x do begin
  for yy:=1 to y do begin
    nf:=worksheet.cells.item[xx,yy].NumberFormat;
    if (nf='h:mm:ss')or(nf='h:mm:ss;@')or(nf='hh:mm:ss')or(nf='hh:mm:ss;@')or(nf='::')or(nf='::;@')or(nf='::cc')or(nf='::cc;@')or(nf=':')or(nf=':')or(nf='h:mm')or(nf='hh:mm;@')or(nf=':;@')or(nf=':;@')or(nf='h:mm;@')or(nf='hh:mm;@') then begin
       tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xx,yy]),70);
       if tf=70 then s:=trim(VarToStrDef(worksheet.cells.item[xx,yy],''))
                else s:=trim(FormatDateTime('hh:nn',tf));
    end
     else s:=preparestr1(trim(VarToStrDef(worksheet.cells.item[xx,yy],'')));
    worksheet.cells.item[xx,yy].NumberFormat:='@';
    if checkbox4.Checked then worksheet.cells.item[xx,yy]:=nf
                         else begin
                           if checkbox1.checked then begin
                            if length(s)=6 then begin
                             if ((s[3]='.')and(s[6]='5')) then s:=copy(s,1,5);
                            end;
                           end;
                            worksheet.cells.item[xx,yy]:=s;
                         end;
  end;
end;

end;
end;
WorkBk.Close(true,EmptyParam,EmptyParam,0);
XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;
end;
end;


procedure PrepareXLSByDot(fn:string);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
WSHS, K, R, X, Y, xx, yy : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf:string;
tf:double;
flag:boolean;
s,s1,s2:string;
var h,m,lh:integer;
begin
with form1 do begin
NomFich := fn;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
for wshs:=1 to WorkBk.WorkSheets.Count do begin
WorkSheet := WorkBk.Sheets[wshs] as _WorkSheet;
WorkSheet.Activate(0);
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
if (x>2)and(y>3) then begin
for xx:=3 to x do begin
  for yy:=2 to y-1 do begin
    nf:=worksheet.cells.item[xx,yy].NumberFormat;
    if (nf=':')or(nf=':')or(nf='h:mm')or(nf='hh:mm;@')or(nf=':;@')or(nf=':;@')or(nf='h:mm;@')or(nf='hh:mm;@') then begin
       tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xx,yy]),70);
       if tf=70 then s:=trim(VarToStrDef(worksheet.cells.item[xx,yy],''))
                else s:=trim(FormatDateTime('hh:nn',tf));
    end
     else s:=trim(VarToStrDef(worksheet.cells.item[xx,yy],''));
    nf:=worksheet.cells.item[xx,yy+1].NumberFormat;
    if (nf=':')or(nf=':')or(nf='h:mm')or(nf='hh:mm;@')or(nf=':;@')or(nf=':;@')or(nf='h:mm;@')or(nf='hh:mm;@') then begin
       tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xx,yy+1]),70);
       if tf=70 then s1:=trim(VarToStrDef(worksheet.cells.item[xx,yy+1],''))
                else s1:=trim(FormatDateTime('hh:nn',tf));
    end
     else s1:=trim(VarToStrDef(worksheet.cells.item[xx,yy+1],''));
    if not validstr(s) then begin
         worksheet.cells.item[xx,yy].Interior.Color:=clYellow;
    end;
    if not validstr(s1) then begin
     flag:=false;
     if length(s)>7 then begin
      if (s[1] in ['0'..'9']) then begin
       if s[5]='.' then begin
        s1:=trim(copy(s,7,length(s)-6));
        s:=trim(copy(s,1,6));
        flag:=true;
       end;
       if s[6]='.' then begin
        s1:=trim(copy(s,8,length(s)-7));
        s:=trim(copy(s,1,7));
        flag:=true;
       end;
       if flag then begin
         worksheet.cells.item[xx,yy].NumberFormat:='@';
         worksheet.cells.item[xx,yy]:=s;
         worksheet.cells.item[xx,yy+1].NumberFormat:='@';
         worksheet.cells.item[xx,yy+1]:=s1;
       end;
      end;
     end;
    end;
  end;
end;

end;
end;
WorkBk.Close(true,EmptyParam,EmptyParam,0);
XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;
end;
end;



procedure PrepareXLS_OnlyFmtPlus(fn:string);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
WSHS, K, R, X, Y, xx, yy : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf:string;
tf:double;
s,s1,s2:string;
var h,m,lh:integer;
begin
with form1 do begin
NomFich := fn;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
for wshs:=1 to WorkBk.WorkSheets.Count do begin
WorkSheet := WorkBk.Sheets[wshs] as _WorkSheet;
WorkSheet.Activate(0);
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
if (x>4)and(y>2) then begin
for xx:=5 to x do begin
  for yy:=3 to y do begin
    nf:=worksheet.cells.item[xx,yy].NumberFormat;
    if (nf=':')or(nf=':')or(nf='h:mm')or(nf='hh:mm;@')or(nf=':;@')or(nf=':;@')or(nf='h:mm;@')or(nf='hh:mm;@') then begin
       tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xx,yy]),70);
       if tf=70 then s:=trim(VarToStrDef(worksheet.cells.item[xx,yy],''))
                else s:=trim(FormatDateTime('hh:nn',tf));
    end
     else s:=trim(VarToStrDef(worksheet.cells.item[xx,yy],''));
    if s<>'' then begin
     if s<>'-' then begin
      if pos('@',s)>0 then begin
       s1:=trim(copy(s,1,pos('@',s)-1));
       s2:=trim(copy(s,pos('@',s)+7,100));
       if s1=s2 then begin
         worksheet.cells.item[xx,yy].NumberFormat:='@';
         worksheet.cells.item[xx,yy]:=s1;
       end;
      end; 
     end;
    end;
  end;
end;

end;
end;
WorkBk.Close(true,EmptyParam,EmptyParam,0);
XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;
end;
end;





procedure PrepareXLS_OnlyFmtGreen(fn:string);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
WSHS, K, R, X, Y, xx, yy : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf:string;
tf:double;
s,s1,s2,ts:string;
var h,m,lh:integer;
begin
with form1 do begin
NomFich := fn;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
for wshs:=1 to WorkBk.WorkSheets.Count do begin
WorkSheet := WorkBk.Sheets[wshs] as _WorkSheet;
WorkSheet.Activate(0);
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
if (x>2)and(y>2) then begin
for yy:=1 to y do begin
  ts:=trim(VarToStrDef(worksheet.cells.item[1,yy],''));
  for xx:=1 to x do begin
    nf:=worksheet.cells.item[xx,yy].NumberFormat;
    if (nf=':')or(nf=':')or(nf='h:mm')or(nf='hh:mm;@')or(nf=':;@')or(nf=':;@')or(nf='h:mm;@')or(nf='hh:mm;@') then begin
       tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xx,yy]),70);
       if tf=70 then s:=trim(VarToStrDef(worksheet.cells.item[xx,yy],''))
                else s:=trim(FormatDateTime('hh:nn',tf));
    end
     else s:=trim(VarToStrDef(worksheet.cells.item[xx,yy],''));
    worksheet.cells.item[xx,yy].NumberFormat:='@';
     if yy>2 then begin
      if validstr(ts) then begin
       if validstr(s) then worksheet.cells.item[xx,yy].Font.Color:=clBlue;
      end;
     end;
    worksheet.cells.item[xx,yy]:=s;
  end;
end;
end;
end;
WorkBk.Close(true,EmptyParam,EmptyParam,0);
XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;
end;
end;


procedure PrepareXLS_DelMSK11(fn:string);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
WSHS, K, R, X, Y, xx, yy : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf:string;
tf:double;
s,s1,s2,ts:string;
var h,m,lh:integer;
begin
with form1 do begin
NomFich := fn;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
for wshs:=1 to WorkBk.WorkSheets.Count do begin
WorkSheet := WorkBk.Sheets[wshs] as _WorkSheet;
WorkSheet.Activate(0);
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
if (x>2)and(y>2) then begin
  ts:=trim(VarToStrDef(worksheet.cells.item[1,1],''));
  if ts='msk' then ts:='';
  if pos('msk,',ts)=1 then begin
    if length(ts)>4 then begin
      ts:=trim(copy(ts,5,length(ts)-4));
    end;
  end;
  worksheet.cells.item[1,1]:=ts;
end;
end;
WorkBk.Close(true,EmptyParam,EmptyParam,0);
XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;
end;
end;



procedure TForm1.SpeedButton1Click(Sender: TObject);
 var i:integer;
begin
 if opendialog1.execute then begin
   for i:=0 to OpenDialog1.Files.Count-1 do begin
    if RadioGroup1.ItemIndex=0 then begin
      if checkbox2.checked then PrepareXLS_OnlyFmt(OpenDialog1.Files.Strings[i])
                           else PrepareXLS(OpenDialog1.Files.Strings[i]);
    end;
    if RadioGroup1.ItemIndex=1 then begin
      PrepareXLSbyDot(OpenDialog1.Files.Strings[i]);
    end;
    if RadioGroup1.ItemIndex=2 then begin
      PrepareXLS_OnlyFmtGreen(OpenDialog1.Files.Strings[i]);
    end;
   end;
   showmessage('!');
 end;
end;

procedure TForm1.Button1Click(Sender: TObject);
 var p:AF_Types.TStrings;
 var i:integer;
begin
  p.create;
  GetTreeMaskList('c:\2\',@p);
  if p.count>0 then begin
   for i:=1 to p.count do begin
    if pos('.xls',ansilowercase(p.getstring(i)))>0 then begin
      PrepareXLS_DelMSK11(p.getstring(i));
    end;
   end;
  end;
  p.free;
  showmessage('end');

end;

end.
