unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OleServer, ExcelXP, StdCtrls, af_pROC, af_tYPES, MySQL6, MySQLClasses6,
  Grids, ComCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    XLApp: TExcelApplication;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    Button11: TButton;
    Button12: TButton;
    Button13: TButton;
    OpenDialog1: TOpenDialog;
    Button14: TButton;
    Button15: TButton;
    StringGrid1: TStringGrid;
    StatusBar1: TStatusBar;
    Button16: TButton;
    Button17: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button15Click(Sender: TObject);
    procedure Button16Click(Sender: TObject);
    procedure Button17Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  workdir,cfg_mysql_host, cfg_mysql_port, cfg_mysql_database, cfg_mysql_user, cfg_mysql_password: string;
  _st1,_st2:AF_Types.TStrings;

implementation

{$R *.dfm}

function GetSTN(s:string):string;
 var n:integer;
begin
 s:=trim(s);
 result:=s;
 n:=_st1.SearchString(s);
 if n>0 then result:=_st2.getstring(n);
end;

function PrepRZRTime(s:string):string;
  var i,n:integer;
  var res:boolean;
begin
  res:=false;
  n:=0;
  if pos(':',s)>0 then begin
    for i:=1 to length(s) do begin
      if s[i]=':' then inc(n);
      if n=2 then begin
        res:=true;
        break;
      end;
    end;
    if res then s:=copy(s,1,i-1);
  end;
  result:=s;
end;

procedure ShowMySQLError(MySQL:IMySQL);
 var f:AF_Types.TStrings;
begin
  f.create;
  if fileexists(workdir+'sqlerror.log') then f.loadfromfile(workdir+'sqlerror.log');
  ShowMessage(Format(' #%d - %s', [MySQL.ErrorCode, MySQL.ErrorMessage]));
  f.add(mysql.Host+' : '+Format(' #%d - %s', [MySQL.ErrorCode, MySQL.ErrorMessage]));
  f.savetofile(workdir+'sqlerror.log');
  f.free;
end;

function LoadMainIni:boolean;
  var chg,u:AF_Types.TStrings;
  var i:integer;
  var s,s1,s2,s3,s4:string;
  var res:boolean;
begin
  chg.create;
  u.create;
  chg.loadfromfile(workdir+'main.ini');
  if chg.count>0 then begin
    for i:=1 to chg.count do begin
      s:=trim(chg.getstring(i));
      s:=strreplace(s,#9,#32);
      if length(s)>0 then begin
        if not (s[1]=';') then begin
          if pos(' ',s)>0 then begin
            s1:=trim(copy(s,1,pos(' ',s)-1));
            s2:=trim(copy(s,pos(' ',s)+1,length(s)-pos(' ',s)));
            s1:=ansilowercase(s1);
            if s1='mysql_host' then begin
              cfg_mysql_host:=s2
            end;
            if s1='mysql_port' then begin
              cfg_mysql_port:=s2;
            end;
            if s1='mysql_database' then begin
              cfg_mysql_database:=s2;
            end;
            if s1='mysql_user' then begin
              cfg_mysql_user:=s2;
            end;
          end;
        end;
      end;
    end;
  end;
  chg.clear;
  chg.loadfromfile(workdir+'main.pwd');
  if chg.count>0 then begin
    for i:=1 to chg.count do begin
      s:=trim(chg.getstring(i));
      s:=strreplace(s,#9,#32);
      if length(s)>0 then begin
        if not (s[1]=';') then begin
          if pos(' ',s)>0 then begin
            s1:=trim(copy(s,1,pos(' ',s)-1));
            s2:=trim(copy(s,pos(' ',s)+1,length(s)-pos(' ',s)));
            s1:=ansilowercase(s1);
            if s1='mysql_password' then begin
              cfg_mysql_password:=s2;
            end;
          end;
        end;
      end;
    end;
  end;
  chg.clear;
  chg.loadfromfile(workdir+'stations1.txt');
  if chg.count>0 then begin
   for i:=1 to chg.count do begin
    ParseCSVStrEx(@u,chg.getstring(i),#9);
    if u.count>1 then begin
      _st1.add(u.getstring(1));
      _st2.add(ansilowercase(u.getstring(2)));
    end;
   end;
  end;
  chg.free;
  u.free;
  res:=true;
  result:=res;
end;


procedure xhm(var h,m:integer);
  begin
    if m>59 then begin
      inc(h,(m div 60));
      m:=m mod 60;
    end;
    if h>23 then begin
     h:=h-24;
    end;
  end;

procedure tohm(s:string; var h,m:integer);
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    if pos(':',s)>0 then begin
      h:=StrToIntE(copy(s,1,pos(':',s)-1));
      m:=StrToIntE(copy(s,pos(':',s)+1,100));
    end;
  end;

function prephm(s:string):string;
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    result:=s;
  end;

procedure inchm(var h,m:integer; t:integer);
  begin
    inc(m,t);
    xhm(h,m);
  end;
  
function fromhm(h,m:integer):string;
  begin
    xhm(h,m);
    if h>9 then begin
             if m>9 then fromhm:=inttostr(h)+':'+inttostr(m)
                    else fromhm:=inttostr(h)+':0'+inttostr(m);
           end
           else begin
             if m>9 then fromhm:=inttostr(h)+':'+inttostr(m)
                    else fromhm:=inttostr(h)+':0'+inttostr(m);
           end;
  end;



procedure TForm1.Button1Click(Sender: TObject);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
WSHS, K, R, X, Y, xx, yy, ns, ns1 : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf,file1:string;
tf:double;
s,s1,s2:string;
h,m,h1,h2,m1,m2,lh:integer;
begin
file1:='C:\1\2\ .xlsx';
NomFich := file1;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
WorkSheet.Activate(0);
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
if (x>=1)and(y>=1) then begin
for xx:=3 to 33 do begin
    nf:=worksheet.cells.item[xx,3].NumberFormat;
    if (nf=':')or(nf=':')or(nf='h:mm')or(nf='hh:mm;@')or(nf=':;@')or(nf=':;@')or(nf='h:mm;@')or(nf='hh:mm;@')or(nf=':: AM/PM')or(nf='::')or(nf=':: AM/PM')or(nf='::')or(nf='[$-F400]:: AM/PM') then begin
       tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xx,3]),70);
       s:=VarToStrDef(worksheet.cells.item[xx,3],'');
    end
     else s:=Trim(VarToStrDef(worksheet.cells.item[xx,3],''));
     tohm(s,h,m);
  for yy:=4 to 23 do begin
    h1:=h; m1:=m;
    inchm(h1,m1,(yy-3)*5);
//    worksheet.cells.item[xx,yy].Interior.Color:=clYellow;
    worksheet.cells.item[xx,yy].NumberFormat:='@';
    worksheet.cells.item[xx,yy]:=fromhm(h1,m1);
  end;
  Application.ProcessMessages;
end;
end;
WorkBk.Close(true,EmptyParam,EmptyParam,0);
XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;
showmessage('end!');
end;

procedure TForm1.Button2Click(Sender: TObject);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
WSHS, K, R, X, Y, xx, yy, ns, ns1 : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf,file1:string;
tf:double;
s,s1,s2:string;
h,m,h1,h2,m1,m2,lh:integer;
begin
file1:='C:\1\2\ .xlsx';
NomFich := file1;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
WorkSheet.Activate(0);
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
if (x>=1)and(y>=1) then begin
for yy:=3 to 20 do begin
  for xx:=34 to 530 do begin
    nf:=worksheet.cells.item[xx-31,yy].NumberFormat;
    s:=Trim(VarToStrDef(worksheet.cells.item[xx-31,yy],''));
    tohm(s,h,m);
    inchm(h,m,90);
    worksheet.cells.item[xx,yy].NumberFormat:='@';
    worksheet.cells.item[xx,yy]:=fromhm(h,m);
  end;
  Application.ProcessMessages;
end;
end;
WorkBk.Close(true,EmptyParam,EmptyParam,0);
XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;
showmessage('end!');
end;

procedure TForm1.Button4Click(Sender: TObject);
  var t:TextFile;
  var s:string;
  var i:integer;
begin
  i:=0;
  assignfile(t,'C:\AF\_  2019\mcc_CCW.xml');
  reset(t);
    while not eof(t) do begin
      ReadLn(t,s);
      if pos('<thread ',s)>0 then inc(i);
    end;
  closefile(t);
  showmessage(inttostr(i));

end;

function getParam(s1,s:string):string;
  var s2:string;
begin
  s:=trim(s);
  s2:='';
  if pos(s1+'="',s)>0 then begin
    s2:=copy(s,pos(s1+'="',s)+2+length(s1),length(s));
     if pos('"',s2)>0 then s2:=copy(s2,1,pos('"',s2)-1);
  end;
  result:=trim(s2);
end;

Function ReplaceParam(str1,param,value:string;add:boolean):string;
  var s,s1,s2,s3:string;
  var i,n:integer;
begin
  s:=str1;
  s:=StrReplace(s,' =','=');
  s:=StrReplace(s,'= ','=');
    if pos(param+'="',s)>0 then begin
      i:=pos(param+'="',s)+length(param)+2;
      if s[i]<>'"' then begin
       while s[i]<>'"' do begin
         delete(s,i,1);
         if i>=length(s) then break;
       end;
      end;
      insert(value,s,i);
    end
     else begin
      s:=str1;
      if add then begin
        if pos('/>',s)>0 then begin
          insert(' '+param+'="'+value+'" ',s,pos('/>',s));
        end
         else begin
          if pos('>',s)>0 then begin
           insert(' '+param+'="'+value+'" ',s,pos('>',s));
          end
           else s:=str1;
         end;
      end
       else s:=str1;
     end;
  result:=s;
end;

procedure ParseCSVStrEx(ts:AF_Types.PStrings; s:widestring; c:char);
 var n:integer;
begin
  ts.clear;
  while pos(c,s)>0 do begin
    n:=pos(c,s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;



procedure TForm1.Button3Click(Sender: TObject);
  var t,t1:TextFile;
  var s,s1,st1,st2,tt1,tt2,wt,s9:string;
  var v:integer;
  var flg,stf:boolean;
begin
  v:=0;
  assignfile(t,'C:\AF\_  2019\mcc_CCW.xml');
  reset(t);
  assignfile(t1,'C:\AF\_  2019\mcc_CCW_list.mccr1');
  rewrite(t1);
  flg:=false;
    while not eof(t) do begin
      ReadLn(t,s);
      if flg then begin
        s9:=s9+s;
        if pos('</thread>',s)>0 then begin
          flg:=false;
          WriteLn(t1,wt+#9+wt+'_'+st1+'_'+st2+'_'+tt1+'_'+tt2+#9+s9);
          inc(v);
          s9:='';
        end;
        if pos('<station ',s)>0 then begin
          s1:=getparam('esrcode',s);
          if stf then begin
            st1:=s1;
            tt1:=getparam('departure_time',s);
            stf:=false;
          end;
          st2:=s1;
          tt2:=getparam('arrival_time',s);
        end;
      end
       else begin
         if pos('<thread ',s)>0 then begin
          flg:=true;
          stf:=true;
          wt:=getparam('weektemplate',s);
          s9:=s;
         end;
       end;
    end;
  closefile(t1);
  closefile(t);
  showmessage('end '+inttostr(v));
end;

procedure TForm1.Button5Click(Sender: TObject);
  var t,t1:TextFile;
  var s,s9:string;
  var i,n,m:integer;
  var u,z1,z2,z3,log:AF_Types.TStrings;
begin
  u.create; z1.create; z2.create; z3.create; log.create;
  assignfile(t,'C:\AF\_  2019\mcc_CCW_list.mccr1');
  reset(t);
  assignfile(t1,'C:\AF\_  2019\mcc_CCW_list.mccr2');
  rewrite(t1);
    while not eof(t) do begin
      ReadLn(t,s);
      ParseCSVStrEx(@u,s,#9);
      if u.count=3 then begin
        z1.add(u.getstring(1));
        z2.add(u.getstring(2));
        z3.add(u.getstring(3));
      end;
    end;
  closefile(t);
  if z1.count>0 then begin
    for i:=1 to z1.count do begin
      if z1.getstring(i)='W' then begin
        s:=z2.getstring(i);
        s[1]:='H';
        n:=z2.SearchString(s);
        if n>0 then begin
          s9:=z3.getstring(n);
          m:=pos('weekend="Y"',s9);
          if m>0 then begin
            delete(s9,m,11);
            s9:=ReplaceParam(s9,'daily','Y',false);
            s9:=ReplaceParam(s9,'weektemplate','1234567',false);
            s9:=ReplaceParam(s9,'daystr',';',false);
            z3.edit(n,s9);
            z1.edit(n,'D');
            z1.edit(i,'*');
            log.add(' '+z2.getstring(i)+'  '+z2.getstring(n));
            z2.edit(n,'replaced');
          end;
        end;
      end; //z1
      if z1.getstring(i)='-17' then begin
        s:=z2.getstring(i);
        delete(s,1,1);
        n:=z2.SearchString(s);
        if n>0 then begin
          s9:=z3.getstring(n);
          m:=pos('days="17"',s9);
          if m>0 then begin
            delete(s9,m,9);
            s9:=ReplaceParam(s9,'daily','Y',false);
            s9:=ReplaceParam(s9,'weektemplate','1234567',false);
//            s9:=ReplaceParam(s9,'daystr','',false);
            s9:=ReplaceParam(s9,'daystr',';',false);
            z3.edit(n,s9);
            z1.edit(n,'D');
            z1.edit(i,'*');
            log.add(' '+z2.getstring(i)+'  '+z2.getstring(n));
            z2.edit(n,'replaced');
          end;
        end;
      end; //z1
    end;
    for i:=1 to z1.count do begin
      writeln(t1,z1.getstring(i)+#9+z2.getstring(i)+#9+z3.getstring(i));
    end;
  end
   else showmessage(' !');
  closefile(t1);
  log.savetofile('C:\AF\_  2019\mcc_CCW_list.log');
  showmessage(inttostr(z1.count));
  u.free; z1.free; z2.free; z3.free; log.free;
end;

procedure TForm1.Button6Click(Sender: TObject);
  var t,t1:TextFile;
  var u:AF_Types.TStrings;
  var x1,x2:integer;
  var s:string;
begin
  u.create;
  x1:=0; x2:=0;
  assignfile(t,'C:\AF\_  2019\mcc_CCW_list.mccr2');
  reset(t);
  assignfile(t1,'C:\AF\_  2019\mcc_CCW_list.mccr3.xml');
  rewrite(t1);
  writeln(t1,'<?xml version="1.0" encoding="Windows-1251"?>');
  writeln(t1,'');
  writeln(t1,'<channel date="2017-05-14 21:23:09" prog="msk2xml" progver="9.0" ver="3">');
  writeln(t1,'');
  while not eof(t) do begin
    readln(t,s);
    ParseCSVStrEx(@u,s,#9);
    if u.count=3 then begin
      inc(x1);
      if u.getstring(1)<>'*' then begin
        WriteLn(t1,u.getstring(3));
        inc(x2);
      end;
    end
     else begin
      if u.count>3 then showmessage(' ');
     end;
  end;
  writeln(t1,'</channel>');
  closefile(t1);
  closefile(t);
  u.free;
  showmessage('end '+inttostr(x1)+' '+inttostr(x2));
end;

procedure TForm1.Button7Click(Sender: TObject);
  var f,u,st1,st2:AF_Types.TStrings;
  var i,n:integer;
begin
 f.create; u.create; st1.create; st2.create;
 f.loadfromfile('C:\1\3\stationcodes.csv');
 for i:=2 to f.count do begin
   ParseCSVStrEx(@u,f.getstring(i),';');
   if u.count>2 then begin
     st1.add(u.getstring(2));
     st2.add(u.getstring(3));
   end;
 end;
 f.clear;
 f.loadfromfile('C:\1\3\stations.csv');
 for i:=2 to f.count do begin
   ParseCSVStrEx(@u,f.getstring(i),';');
   if u.count>1 then begin
     n:=st1.SearchString(u.getstring(1));
     if n>0 then begin
       f.edit(i,f.getstring(i)+';'+st2.getstring(n));
     end;
   end;
 end;
 f.savetofile('C:\1\3\stations_e2.csv');
 f.free; u.free; st1.free; st2.free;
 showmessage('end!');
end;

procedure TForm1.Button8Click(Sender: TObject);
  var f1,f2,f3:AF_Types.TStrings;
  var i,q,n:integer;
  var s,s1,s2,s3,s4,s5,s6:string;
begin
  f1.create; f2.create; f3.create;

  q:=0;
  f1.clear;
  f1.loadfromfile('C:\1\25\out0953a');
  if f1.count>2 then begin
    for i:=2 to f1.count do begin
     s:=f1.getstring(i);
     if length(s)>257 then begin
      s1:=copy(s,37,6);
      s2:=copy(s,253,6);
      s3:=utf8toansi(copy(s,61,12));
      s4:=utf8toansi(copy(s,98,12));
      s5:=copy(s,111,4);
      s6:=s5+' '+s3+'-'+s4;
      if s1=s2 then begin
        inc(q);
        n:=f3.SearchString(s6);
        if n<=0 then begin
          f3.add(s6);
          f2.add('   '+s6);
        end;
      end;
     end;
    end;
  end;
  f2.add(f1.filename+' - '+inttostr(q));

  q:=0;
  f1.clear;
  f1.loadfromfile('C:\1\25\out0953b');
  if f1.count>2 then begin
    for i:=2 to f1.count do begin
     s:=f1.getstring(i);
     if length(s)>257 then begin
      s1:=copy(s,37,6);
      s2:=copy(s,253,6);
      s3:=utf8toansi(copy(s,61,12));
      s4:=utf8toansi(copy(s,98,12));
      s5:=copy(s,111,4);
      s6:=s5+' '+s3+'-'+s4;
      if s1=s2 then begin
        inc(q);
        n:=f3.SearchString(s6);
        if n<=0 then begin
          f3.add(s6);
          f2.add('   '+s6);
        end;
      end;
     end;
    end;
  end;
  f2.add(f1.filename+' - '+inttostr(q));

  q:=0;
  f1.clear;
  f1.loadfromfile('C:\1\25\out0953c');
  if f1.count>2 then begin
    for i:=2 to f1.count do begin
     s:=f1.getstring(i);
     if length(s)>257 then begin
      s1:=copy(s,37,6);
      s2:=copy(s,253,6);
      s3:=utf8toansi(copy(s,61,12));
      s4:=utf8toansi(copy(s,98,12));
      s5:=copy(s,111,4);
      s6:=s5+' '+s3+'-'+s4;
      if s1=s2 then begin
        inc(q);
        n:=f3.SearchString(s6);
        if n<=0 then begin
          f3.add(s6);
          f2.add('   '+s6);
        end;
      end;
     end;
    end;
  end;
  f2.add(f1.filename+' - '+inttostr(q));

  f2.savetofile('C:\1\25\out000.log');
  f1.free; f2.free; f3.free;
  showmessage('end!');
end;

Procedure XMLFile1(fn,fn1:string);
 var t,t1:textfile;
 var s,s1:string;
 var i:integer;
begin
  assignfile(t,fn);
  reset(t);
  assignfile(t1,fn1);
  rewrite(t1);
   while not eof(t) do begin
     readln(t,s);
     s1:='';
     if length(s)>0 then begin
       for i:=1 to length(s) do begin
         if s[i]='<' then s1:=s1+#13#10+s[i]
                     else s1:=s1+s[i];
       end;
     end;
     writeln(t1,s1);
   end;
  closefile(t1);
  closefile(t);
end;


procedure TForm1.Button9Click(Sender: TObject);
  var f1,f2,f3,t:AF_Types.TSTrings;
  var i,n,h,m,a0,a1,a2:integer;
  var s,s1,s2:string;
  var flg:boolean;
begin
  f1.create; f2.create; t.create; f3.create;
  f2.add('<?xml version="1.0" encoding="Windows-1251"?>');
  f2.add('');
  f2.add('<channel date="2016-10-31 11:13:28" prog="msk2xml" progver="9.0" ver="3">');
  f2.add('');
  f3.add('<?xml version="1.0" encoding="Windows-1251"?>');
  f3.add('');
  f3.add('<channel date="2016-10-31 11:13:28" prog="msk2xml" progver="9.0" ver="3">');
  f3.add('');
  f1.loadfromfile('C:\1\\7 \mcc.xml');  //        ,   
  flg:=false;
  a0:=0; a1:=0; a2:=0;
   for i:=1 to f1.count do begin
     s:=f1.getstring(i);
     if pos('<thread ',s)>0 then begin
       flg:=true;
       inc(a0);
     end;
     if flg then t.add(s);
     if pos('</thread>',s)>0 then begin
      flg:=false;
       s1:=t.getstring(3);
       s2:=t.getstring(1);
       tohm(getparam('departure_time',s1),h,m);
         if h in [4..23] then begin
            f2.include(t);
            inc(a1);
         end
          else begin
            f3.include(t);
            inc(a2);
          end;
      t.clear;
     end;
   end;
  f2.add('');
  f2.add('</channel>');
  f2.savetofile('C:\1\\7 \mcc_day.xml');
  f3.add('');
  f3.add('</channel>');
  f3.savetofile('C:\1\\7 \mcc_night.xml');
//  f3.savetofile('C:\AF\_  2017\mcc_r_0-3b.xml');
//  f3.savetofile('C:\AF\_  2017\mcc_r_0-3c.xml');
  f1.free; f2.free; t.free; f3.free;
  showmessage('end!'+inttostr(a0)+' '+inttostr(a1)+' '+inttostr(a2));
end;


procedure TForm1.Button10Click(Sender: TObject);
  var t:TextFile;
  var fn,s,s1:string;
  var i,n:integer;
  var f,f1:AF_Types.TStrings;
begin
 if OpenDialog1.Execute then begin
  f.create; f1.create;
  i:=0;
  fn:=OpenDialog1.FileName;
  assignfile(t,fn);
  reset(t);
    while not eof(t) do begin
      ReadLn(t,s);
      if pos('<thread ',s)>0 then begin
        inc(i);
        s1:=getParam('strnn',s)+#9+getParam('daystr',s)+#9+getParam('weektemplate',s)+#9+getParam('days',s)+#9+getParam('period_start',s)+#9+getParam('period_end',s);
        n:=f.SearchString(s1);
        if n<=0 then begin
                        f.add(s1);
                        f1.add('1');
                     end
                      else begin
                        f1.edit(n,inttostr(strtointe(f1.getstring(n))+1));
                      end;
      end;
    end;
  closefile(t);
  if f.count>0 then begin
   for n:=1 to f.count do begin
     f.edit(n,f1.getstring(n)+#9+f.getstring(n));
   end;
  end;
  f.savetofile(fn+'.list');
  f.free; f1.free;
  showmessage(inttostr(i));
 end;
end;

procedure TForm1.Button11Click(Sender: TObject);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
WSHS, K, R, X, Y, xx, yy, ns, ns1 : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf,file1:string;
tf:double;
s,s1,s2:string;
n,h,m,h1,h2,m1,m2,lh:integer;
f,pl:AF_Types.TSTrings;
begin
f.create; pl.create;
f.loadfromfile('C:\AF\_  2018\11');
if f.count>7 then begin
 s:=f.getstring(5);
 ParseCSVStrEx(@pl,s,',');
end;
s:='';
file1:='C:\AF\_  2018\ -  .xlsx';
NomFich := file1;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
WorkSheet.Activate(0);
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
if (x>=3)and(y>=2) then begin
for yy:=3 to y do begin
  s:=VarToStrDef(worksheet.cells.item[1,yy],'');
    while pos('^',s)>0 do delete(s,pos('^',s),1);
    if pos('#',s)>0 then s:=copy(s,1,pos('#',s)-1);
    s:=trim(s);
    n:=pl.SearchString(s);
    if n>0 then begin
      h:=69; // -3
      s:=VarToStrDef(worksheet.cells.item[h,yy],'');
      if length(s)>2 then begin
       if pos('@',s)<=0 then begin
        worksheet.cells.item[h,yy]:=s+'@2 ';
        worksheet.cells.item[h,yy].Interior.Color:=clYellow;
        worksheet.cells.item[1,yy].Interior.Color:=clYellow;
       end;
      end;
      //---
      h:=68; // 
      s:=VarToStrDef(worksheet.cells.item[h,yy],'');
      if length(s)>2 then begin
       if pos('@',s)<=0 then begin
        worksheet.cells.item[h,yy]:=s+'@3 ';
        worksheet.cells.item[h,yy].Interior.Color:=clYellow;
        worksheet.cells.item[1,yy].Interior.Color:=clYellow;
       end;
      end;
      //---
      h:=67; // 
      s:=VarToStrDef(worksheet.cells.item[h,yy],'');
      if length(s)>2 then begin
       if pos('@',s)<=0 then begin
        worksheet.cells.item[h,yy]:=s+'@2 ';
        worksheet.cells.item[h,yy].Interior.Color:=clYellow;
        worksheet.cells.item[1,yy].Interior.Color:=clYellow;
       end;
      end;
      //---
      h:=66; // 
      s:=VarToStrDef(worksheet.cells.item[h,yy],'');
      if length(s)>2 then begin
       if pos('@',s)<=0 then begin
        worksheet.cells.item[h,yy]:=s+'@3 ';
        worksheet.cells.item[h,yy].Interior.Color:=clYellow;
        worksheet.cells.item[1,yy].Interior.Color:=clYellow;
       end;
      end;
      //---
      h:=65; // 
      s:=VarToStrDef(worksheet.cells.item[h,yy],'');
      if length(s)>2 then begin
       if pos('@',s)<=0 then begin
        worksheet.cells.item[h,yy]:=s+'@3 ';
        worksheet.cells.item[h,yy].Interior.Color:=clYellow;
        worksheet.cells.item[1,yy].Interior.Color:=clYellow;
       end;
      end;
      //---
    end;
  Application.ProcessMessages;
end;
end;
WorkBk.Close(true,EmptyParam,EmptyParam,0);
XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;
f.free; pl.free;
showmessage('end!');
end;

procedure TForm1.Button12Click(Sender: TObject);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
WSHS, K, R, X, Y, xx, yy, ns, ns1 : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf,file1:string;
tf:double;
s,s1,s2:string;
n,h,m,h1,h2,m1,m2,lh:integer;
f,pl:AF_Types.TSTrings;
begin
f.create; pl.create;
s:='';
file1:='C:\AF\_  2018\ -  .xlsx';
NomFich := file1;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
WorkSheet.Activate(0);
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
if (x>=3)and(y>=2) then begin
for yy:=3 to y do begin
  s:=VarToStrDef(worksheet.cells.item[1,yy],'');
   {   h:=4; // -3
      s:=VarToStrDef(worksheet.cells.item[h,yy],'');
      if length(s)>2 then begin
       if pos('@',s)<=0 then begin
        worksheet.cells.item[h,yy]:=s+'@1 ';
        worksheet.cells.item[h,yy].Interior.Color:=clYellow;
        worksheet.cells.item[1,yy].Interior.Color:=clYellow;
       end;
      end;
      //---
      h:=5; // 
      s:=VarToStrDef(worksheet.cells.item[h,yy],'');
      if length(s)>2 then begin
       if pos('@',s)<=0 then begin
        worksheet.cells.item[h,yy]:=s+'@2 ';
        worksheet.cells.item[h,yy].Interior.Color:=clYellow;
        worksheet.cells.item[1,yy].Interior.Color:=clYellow;
       end;
      end;
      //---
      h:=6; // 
      s:=VarToStrDef(worksheet.cells.item[h,yy],'');
      if length(s)>2 then begin
       if pos('@',s)<=0 then begin
        worksheet.cells.item[h,yy]:=s+'@1 ';
        worksheet.cells.item[h,yy].Interior.Color:=clYellow;
        worksheet.cells.item[1,yy].Interior.Color:=clYellow;
       end;
      end;
      //---
      h:=7; // 
      s:=VarToStrDef(worksheet.cells.item[h,yy],'');
      if length(s)>2 then begin
       if pos('@',s)<=0 then begin
        worksheet.cells.item[h,yy]:=s+'@2 ';
        worksheet.cells.item[h,yy].Interior.Color:=clYellow;
        worksheet.cells.item[1,yy].Interior.Color:=clYellow;
       end;
      end;
      //---
      h:=8; // 
      s:=VarToStrDef(worksheet.cells.item[h,yy],'');
      if length(s)>2 then begin
       if pos('@',s)<=0 then begin
        worksheet.cells.item[h,yy]:=s+'@2 ';
        worksheet.cells.item[h,yy].Interior.Color:=clYellow;
        worksheet.cells.item[1,yy].Interior.Color:=clYellow;
       end;
      end;
      //--- }
      h:=64; // 
      s:=VarToStrDef(worksheet.cells.item[h,yy],'');
      if length(s)>2 then begin
       if pos('@',s)<=0 then begin
        worksheet.cells.item[h,yy]:=s+'@1 ';
        worksheet.cells.item[h,yy].Interior.Color:=clYellow;
        worksheet.cells.item[1,yy].Interior.Color:=clYellow;
       end;
      end;
      //---
      h:=63; // 
      s:=VarToStrDef(worksheet.cells.item[h,yy],'');
      if length(s)>2 then begin
       if pos('@',s)<=0 then begin
        worksheet.cells.item[h,yy]:=s+'@1 ';
        worksheet.cells.item[h,yy].Interior.Color:=clYellow;
        worksheet.cells.item[1,yy].Interior.Color:=clYellow;
       end;
      end;
      //---
      h:=62; // 
      s:=VarToStrDef(worksheet.cells.item[h,yy],'');
      if length(s)>2 then begin
       if pos('@',s)<=0 then begin
        worksheet.cells.item[h,yy]:=s+'@1 ';
        worksheet.cells.item[h,yy].Interior.Color:=clYellow;
        worksheet.cells.item[1,yy].Interior.Color:=clYellow;
       end;
      end;
      //---
      h:=61; // 
      s:=VarToStrDef(worksheet.cells.item[h,yy],'');
      if length(s)>2 then begin
       if pos('@',s)<=0 then begin
        worksheet.cells.item[h,yy]:=s+'@4 ';
        worksheet.cells.item[h,yy].Interior.Color:=clYellow;
        worksheet.cells.item[1,yy].Interior.Color:=clYellow;
       end;
      end;
      //---
  Application.ProcessMessages;
end;
end;
WorkBk.Close(true,EmptyParam,EmptyParam,0);
XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;
f.free; pl.free;
showmessage('end!');
end;

procedure TForm1.Button13Click(Sender: TObject);
  var f1,f2,f3,f4,t:AF_Types.TSTrings;
  var i,n,h,m,a0,a1,a2,a3:integer;
  var s,s1,s2,sr1,sr2,sf:string;
  var flg,flg2:boolean;
begin
  f1.create; f2.create; t.create; f3.create; f4.create;
  f2.add('<?xml version="1.0" encoding="Windows-1251"?>');
  f2.add('');
  f2.add('<channel date="2016-10-31 11:13:28" prog="msk2xml" progver="9.0" ver="3">');
  f2.add('');
  f3.add('<?xml version="1.0" encoding="Windows-1251"?>');
  f3.add('');
  f3.add('<channel date="2016-10-31 11:13:28" prog="msk2xml" progver="9.0" ver="3">');
  f3.add('');
  f4.add('<?xml version="1.0" encoding="Windows-1251"?>');
  f4.add('');
  f4.add('<channel date="2016-10-31 11:13:28" prog="msk2xml" progver="9.0" ver="3">');
  f4.add('');
  sf:='C:\1\ 1-9 \\mcc_CW_normal.xml'; // .  -     (1   1 )
  sr1:='-17'; //    #1
  sr2:='17'; //    #2
  f1.loadfromfile(sf);
  flg:=false;
  a0:=0; a1:=0; a2:=0; a3:=0;
   for i:=1 to f1.count do begin
     s:=f1.getstring(i);
     if pos('<thread ',s)>0 then begin
       flg:=true;
       inc(a0);
     end;
     if flg then t.add(s);
     if pos('</thread>',s)>0 then begin
      flg:=false;
      flg2:=false;
       s2:=t.getstring(1);
       if getparam('weektemplate',s2)=sr1 then begin
            f2.include(t);
            inc(a1);
            flg2:=true;
       end;
       if getparam('weektemplate',s2)=sr2 then begin
            f3.include(t);
            inc(a2);
            flg2:=true;
       end;
       if flg2=false then begin
            f4.include(t);
            inc(a3);
       end;
      t.clear;
     end;
   end;
  f2.add('');
  f2.add('</channel>');
  f2.savetofile(deleteslasheex(ExtractDirPath(sf))+'\'+ExtractFileName(sf)+' split '+sr1+'.xml');
  f3.add('');
  f3.add('</channel>');
  f3.savetofile(deleteslasheex(ExtractDirPath(sf))+'\'+ExtractFileName(sf)+' split '+sr2+'.xml');
  f4.add('');
  f4.add('</channel>');
  f4.savetofile(deleteslasheex(ExtractDirPath(sf))+'\'+ExtractFileName(sf)+' split other.xml');
  f1.free; f2.free; t.free; f3.free; f4.free;
  showmessage('End!'+#13#10+inttostr(a0)+' = '+inttostr(a1)+' + '+inttostr(a2)+' + '+inttostr(a3)+' = '+inttostr(a1+a2+a3)+#13#10+'!       (      )!');
end;

procedure TForm1.Button14Click(Sender: TObject);
  var f1,f2,f3,t:AF_Types.TSTrings;
  var i,n,h,m,a0,a1,a2:integer;
  var s,s1,s2:string;
  var flg:boolean;
begin
  f1.create; f2.create; t.create; f3.create;
  f2.add('<?xml version="1.0" encoding="Windows-1251"?>');
  f2.add('');
  f2.add('<channel date="2016-10-31 11:13:28" prog="msk2xml" progver="9.0" ver="3">');
  f2.add('');
  f3.add('<?xml version="1.0" encoding="Windows-1251"?>');
  f3.add('');
  f3.add('<channel date="2016-10-31 11:13:28" prog="msk2xml" progver="9.0" ver="3">');
  f3.add('');
  f1.loadfromfile('C:\AF\ 2019\mcc2019_all.xml');  //        ,   
  flg:=false;
  a0:=0; a1:=0; a2:=0;
   for i:=1 to f1.count do begin
     s:=f1.getstring(i);
     if pos('<thread ',s)>0 then begin
       tohm(getparam('departure_time',s),h,m);
         if h in [4..23] then begin
            f2.add(s);
            inc(a1);
         end
          else begin
            f3.add(s);
            inc(a2);
          end;
     end;
   end;
  f2.add('');
  f2.add('</channel>');
  f2.savetofile('C:\AF\ 2019\mcc2019_day.xml');
  f3.add('');
  f3.add('</channel>');
  f3.savetofile('C:\AF\ 2019\mcc2019_night.xml');
//  f3.savetofile('C:\AF\_  2017\mcc_r_0-3b.xml');
//  f3.savetofile('C:\AF\_  2017\mcc_r_0-3c.xml');
  f1.free; f2.free; t.free; f3.free;
  showmessage('end!'+inttostr(a0)+' '+inttostr(a1)+' '+inttostr(a2));
end;

function Col2(s1,s2:string):string;
  var s,s1a,s2a:string;
  var h1,m1,h2,m2:integer;
begin
 s:='';
 if ((s1='-')and(s2='-')) then begin
   s:='-';
 end
  else begin
     if ((s1='-')or(s2='-')) then begin
       s:=s1+'/'+s2;
     end
      else begin
        if s1=s2 then begin
         s:=s2;
        end
         else begin
           tohm(s1,h1,m1);
           tohm(s2,h2,m2);
           inchm(h1,m1,1);
           s1a:=fromhm(h1,m1);
           s2a:=fromhm(h2,m2);
           if s1a=s2a then s:=s2
                      else s:=s1+'/'+s2;
         end;
      end;
  end;
 result:=s;
end;

function LoadTrainFromMYSQL(code:string; ts:AF_Types.PStrings; MySQL: IMySQL):boolean;
  var query_result: IMySQLQuery;
  var q1,lz,pr,ot,ss,rs:string;
  var t:AF_Types.TStrings;
  var n,m:integer;
  var idrstr:string;
begin
 result:=true;
 if true then rs:=''
         else rs:='AND TEXST=0 ';
 t.create;
 ParseCSVStrEx(@t,code,'_');
 if t.getstring(3)<>'9' then begin
  if true then begin  // strtointe(t.getstring(2))>0 then begin
  idrstr:=t.getstring(2);
  ts.clear;
                      q1:='SELECT IDR,IDRP,SEQ,PRIB,OTPR,TEXST from `rzd_buffer_current_srasprp` WHERE IDR='+idrstr+' '+rs+'ORDER BY SEQ';
                      query_result:= MySQL.Query(q1);
                       if query_result = nil then ShowMySQLError(MySQL)
                        else begin
                          n:=1;
                          while query_result.FetchRow do begin
                            lz:='';
                            if strtointe(query_result.ValueByName['TEXST'])>0 then lz:=' ***';
                            pr:=query_result.ValueByName['PRIB'];
                            ot:=query_result.ValueByName['OTPR'];
                            if pr=ot then begin
                             if n>1 then begin
                              pr:='-';
                              ot:='-';
                             end;
                            end;
                            ts.add(GetSTN(query_result.ValueByName['IDRP'])+';'+PrepRZRTime(pr)+';'+PrepRZRTime(ot)+';'+trim(lz)+';'+Col2(PrepRZRTime(pr),PrepRZRTime(ot)));
                            ss:=GetSTN(query_result.ValueByName['IDRP'])+';'+PrepRZRTime(query_result.ValueByName['PRIB'])+';'+PrepRZRTime(query_result.ValueByName['OTPR'])+';'+trim(lz)+';'+Col2(PrepRZRTime(query_result.ValueByName['PRIB']),PrepRZRTime(query_result.ValueByName['OTPR']));
                            inc(n);
                          end;
                          if ot='-' then begin
                            ts.edit(ts.count,ss);
                          end;
                        end;
  end
   else result:=false;
 end; //t<>9
  t.free;
end;



procedure TForm1.FormCreate(Sender: TObject);
begin
  _st1.create;
  _st2.create;
  workdir:=deleteslasheex(ExtractDirPath(Application.ExeName))+'\';
  LoadMainIni;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  _st1.free;
  _st2.free;
end;

function find1(ts:AF_Types.PStrings; start:integer; st:string):integer;
  var res,i:integer;
begin
  res:=0;
  if start<=ts.count then begin
    for i:=start to ts.count do begin
      if ts.getstring(i)=st then begin
        res:=i;
        break;
      end;
    end;
  end;
  result:=res;
end;

procedure TForm1.Button15Click(Sender: TObject);
  var ts,stx,tr,u,u1,u2,log:AF_Types.TStrings;
  var i,n,vc,m,z:integer;
  var s,s9:string;
  var MySQL: IMySQL;
begin
  MySQL := TMySQL.Create;
  MySQL.Host := cfg_mysql_host;
  MySQL.Port := strtointe(cfg_mysql_port);
  MySQL.User := cfg_mysql_user;
  MySQL.Password := cfg_mysql_password;
 if not MySQL.Connect then ShowMySQLError(MySQL)
 else begin
    MySQL.Database := cfg_mysql_database;
    MySQL.Query('set character_set_client=''utf8'';');
    MySQL.Query('set character_set_results=''utf8'';');
    MySQL.Query('set collation_connection=''utf8_bin'';');
  s9:='_';
  for i:=0 to StringGrid1.ColCount-1 do
   for n:=0 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,n]:='';
  ts.create; stx.create; tr.create; u.create; u1.create; log.create; u2.create;
  stx.loadfromfile('C:\Git\af\mcc1\tmp\.csv');
  if stx.count>0 then begin
    stringgrid1.RowCount:=stx.count+2;
    stringgrid1.ColCount:=2;
    vc:=0;
    for i:=1 to stx.count do begin
      StringGrid1.Cells[0,i+1]:=stx.getstring(i);
    end;
    tr.loadfromfile('C:\Git\af\mcc1\tmp\_.txt');
    if tr.count>0 then begin
      for i:=1 to tr.count do begin
        ParseCSVStrEx(@u,tr.getstring(i),#9);
        if u.count>6 then begin
         if pos('_',u.getstring(9))>0 then begin
          ParseCSVStrEx(@u2,u.getstring(9),'_');
          if u2.count>1 then begin
            inc(vc);
            StatusBar1.SimpleText:=inttostr(vc);
            Application.ProcessMessages;
            if stringgrid1.ColCount>=vc then stringgrid1.ColCount:=vc+1;
            stringgrid1.Cells[vc,0]:=u.getstring(1);
            stringgrid1.Cells[vc,1]:=u.getstring(5);
              LoadTrainFromMYSQL(u.getstring(9),@ts,MySQL);
              if ts.count>1 then begin
                ParseCSVStrEx(@u1,ts.getstring(1),';');
                z:=stx.SearchString(u1.getstring(1));
                if z<=0 then log.add(u.getstring(1)+u.getstring(5)+'    '+u1.getstring(1))
                        else stringgrid1.cells[vc,z+1]:=u1.getstring(5);
                for n:=2 to ts.count do begin
                  ParseCSVStrEx(@u1,ts.getstring(n),';');
                  if u1.count>4 then begin
                    m:=find1(@stx,z+1,u1.getstring(1));
                    if m>0 then begin
                      stringgrid1.cells[vc,m+1]:=u1.getstring(5);
                    end
                     else log.add(u.getstring(1)+u.getstring(5)+'    '+u1.getstring(1));
                  end;
                end;
              end;
          end;
         end;
        end;
//       if vc>20 then break;
      end;
    end;
  end;
  ts.clear;
  for n:=0 to StringGrid1.RowCount-1 do begin
   s:='';
   for i:=0 to StringGrid1.ColCount-1 do begin
     s:=s+StringGrid1.Cells[i,n]+#9;
   end;
   ts.add(s);
  end;
  ts.savetofile('C:\Git\af\mcc1\tmp\'+s9+'.rasp1');
  log.add('');
  log.savetofile('C:\Git\af\mcc1\tmp\'+s9+'.log');
    MySQL.Disconnect;
 end;
  ts.free; stx.free; tr.free; u.free; u1.free; log.free; u2.free;
  showmessage('end!');
end;

procedure TForm1.Button16Click(Sender: TObject);
  var f,f1,u:AF_Types.TStrings;
  var i:integer;
begin
  f.create; f1.create; u.create;
  f.loadfromfile('C:\1\44\stations.csv');
  f1.add('<html>');
  f1.add('');
  f1.add('<head></head>');
  f1.add('<body>');
  if f.count>1 then begin
    for i:=2 to f.count do begin
      ParseCSVStrEx(@u,f.getstring(i),';');
      if u.count>2 then begin
        f1.add('<a href="https://service.admin.rasp.yandex-team.ru/admin/www/station/'+u.getstring(1)+'/change/'+
        '#%D0%9D%D0%B5%20%D1%81%D0%BE%D1%80%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%BD%D1%8B%D0%B5%20%D0%BD%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B8" target="_blank">'+inttostr(i-1)+'. '+u.getstring(2)+'</a><br/>');
        if (i mod 51) = 0 then f1.add('<br/>');
      end;
    end;
  end;
  f1.add('</body>');
  f1.add('</html>');
  f1.savetofile('C:\1\44\stations.html');
  f.free; f1.free; u.free;
  showmessage('end!');
end;

procedure TForm1.Button17Click(Sender: TObject);
  var f1,f2,f3,f4,t:AF_Types.TSTrings;
  var i,n,h,m,a0,a1,a2,a3:integer;
  var s,s1,s2,xf,xd,strnn:string;
  var flg:boolean;
begin
  if opendialog1.execute then begin
  f1.create; f2.create; t.create; f3.create; f4.create;
  f2.add('<?xml version="1.0" encoding="Windows-1251"?>');
  f2.add('');
  f2.add('<channel date="2018-10-30 11:13:28" prog="msk2xml" progver="9.0" ver="3">');
  f2.add('');
  f3.add('<?xml version="1.0" encoding="Windows-1251"?>');
  f3.add('');
  f3.add('<channel date="2018-10-30 11:13:28" prog="msk2xml" progver="9.0" ver="3">');
  f3.add('');
  f4.add('<?xml version="1.0" encoding="Windows-1251"?>');
  f4.add('');
  f4.add('<channel date="2018-10-30 11:13:28" prog="msk2xml" progver="9.0" ver="3">');
  f4.add('');
  f1.loadfromfile(opendialog1.FileName);
  xd:=deleteslasheex(ExtractDirPath(opendialog1.FileName))+'\';
  xf:=ExtractFileName(opendialog1.FileName);
  flg:=false;
  a0:=0; a1:=0; a2:=0; a3:=0;
   for i:=1 to f1.count do begin
     s:=f1.getstring(i);
     if pos('<thread ',s)>0 then begin
       flg:=true;
       inc(a0);
       strnn:='';
     end;
     if flg then t.add(s);
     if pos('</thread>',s)>0 then begin
      flg:=false;
       s1:=t.getstring(3);
       s2:=t.getstring(1);
       strnn:=getparam('strnn',s2);
       tohm(getparam('departure_time',s1),h,m);
        if strnn='0' then begin
         if h in [0..7] then begin
            f3.include(t);
            inc(a2);
         end;
         if h in [8..20] then begin
//            f2.include(t);
//            inc(a1);
         end;
         if h in [21..23] then begin
            f2.include(t);
            inc(a1);
         end;
        end
         else begin
//            f2.include(t);
//            inc(a1);
         end;
      t.clear;
     end;
   end;
  f2.add('');
  f2.add('</channel>');
  f2.savetofile(xd+xf+'_night_21-23.xml');
  f3.add('');
  f3.add('</channel>');
  f3.savetofile(xd+xf+'_night_00-07.xml');
  f1.free; f2.free; t.free; f3.free; f4.free;
  showmessage('end! '+inttostr(a0)+' '+inttostr(a1)+' '+inttostr(a2));
  end;
end;

end.
