unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, Buttons, ExtCtrls, AF_Types, FileCtrl,
  OleServer, ExcelXP, ComCtrls;

const
 pversion:string='9.2';

type
  TTimetable1 = packed record
    t1,t2,st,mfs:string[10];
  end;
  TForm1 = class(TForm)
    LabeledEdit1: TLabeledEdit;
    SpeedButton1: TSpeedButton;
    StringGrid1: TStringGrid;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    XLApp: TExcelApplication;
    StatusBar1: TStatusBar;
    ProgressBar1: TProgressBar;
    ProgressBar2: TProgressBar;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    procedure SpeedButton1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  lh,lm,lmfs,omfs:integer;
  lh9,lm9,lmfs9,omfs9:integer;
  log,edisp,career_n,career_i,career_t,expr_id,expr_type,expr_sub,expr_career,expr_tariff,_stlistlog, _grname, _grps, _grpe: AF_Types.TStrings;
  mtrain, _stidf, _sttt, __dst, __dstnew,__dst0: string;
  socrmode:integer;

function numb2(s:string):string;


implementation

uses AF_Proc, unit2, Unit3;

{$R *.dfm}


procedure gr2per(graph:string; var period_start,period_end:string; sttt:string);
 var n:integer;
begin
  n:=_grname.SearchString(ansilowercase(graph));
  if n>0 then begin
     period_start:=_grps.getstring(n);
     period_end:=_grpe.getstring(n);
  end
   else begin
     period_start:='';
     period_end:='';
     if sttt='etrain' then log.add('    !!!   '+graph);
   end;
end;

function Prep0ESR(s:string):string;
begin
  s:=trim(s);
  if length(s)=4 then result:='00'+s
                 else result:=s;
end;



procedure ParseCSVStrEx(ts:AF_Types.PStrings; s:widestring; c:char);
 var n:integer;
begin
  ts.clear;
  while pos(c,s)>0 do begin
    n:=pos(c,s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;

procedure LoadCareers;
  var f,u:AF_Types.TStrings;
  var i:integer;
begin
  f.create; u.create;
  career_n.clear;
  career_i.clear;
  career_t.clear;
  if fileexists(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\careers.ini') then begin
    f.loadfromfile(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\careers.ini');
    if f.count>0 then begin
     for i:=1 to f.count do begin
      ParseCSVStrEx(@u,f.getstring(i),';');
      if u.count>2 then begin
       if length(u.getstring(1))>1 then begin
         career_n.add(u.getstring(1));
         career_i.add(u.getstring(2));
         career_t.add(u.getstring(3));
       end;
      end;
     end;
    end;
  end
   else begin
     ShowMessage('   careers.ini ( )!');
     Halt(2);
   end;
  f.free; u.free;
end;

function PrepareStr1(s:string):string;
 var l,n,m:integer;
 var s1,s2:string;
begin
  while pos('"',s)>0 do s[pos('"',s)]:='`';
  if pos('#',s)>0 then s:='-';
  if s='?' then s:='-';
  if s='--' then s:='-';
  if s='---' then s:='-';
  if s='----' then s:='-';
  if s='-----' then s:='-';
  if s=':' then s:='';
  if s=#133 then s:='';
  if s='.' then s:='';
  if s='..' then s:='';
  if s='...' then s:='';
  if s='....' then s:='';
  if s='.....' then s:='';
  if s='......' then s:='';
  if s='' then s:='';
  l:=length(s);
  n:=pos(',',s);
  if (n=l-1)and(n>0) then s:=s+'0';
  s:=StrReplace(s,'  ',' ');
  s:=StrReplace(s,'/ ','/');
  s:=StrReplace(s,' /','/');
  s:=StrReplace(s,'@ ','@');
  s:=StrReplace(s,' @','@');
  s2:='';
  if pos('@',s)>0 then begin
    s1:=copy(s,1,pos('@',s)-1);
    s2:=copy(s,pos('@',s),length(s)-pos('@',s)+1);
  end
   else s1:=s;
   s1:=StrReplace(s1,'O','0');
   s1:=StrReplace(s1,'','0');
   s1:=StrReplace(s1,'o','0');
   s1:=StrReplace(s1,'','0');
   s:=s1+s2;
   s:=StrReplace(s,',',':');
   s:=StrReplace(s,'.',':');
  if s<>'-' then s:=StrReplace(s,'-',':');
  l:=length(s);
  n:=pos(':',s);
  if n=2 then s:='0'+s;
  result:=trim(s);
end;

function PrepareStr2(s:string):string;
begin
  while pos('"',s)>0 do s[pos('"',s)]:='`';
  if s=#133 then s:='';
  result:=s;
end;

function PrepareTTime(s:string):string;
   function _nn(_s:string):boolean;
     var _n,_i:integer;
   begin
     _n:=0;
     for _i:=1 to length(_s) do begin
       if not (_s[_i] in ['0'..'9']) then inc(_n);
     end;
     if _n=0 then result:=true
             else result:=false;
   end;
   function _nz(_s:string):boolean;
     var _n,_i:integer;
   begin
     _n:=0;
     for _i:=1 to length(_s) do begin
       if not (_s[_i] in ['0'..'9',':']) then inc(_n);
     end;
     if _n=0 then begin
         for _i:=1 to length(_s) do begin
           if _s[_i]=':' then inc(_n);
         end;
       if (_n=1)and(s[length(s)-1]=':') then result:=true
               else result:=false;
     end
             else result:=false;
   end;
   function _nx(_s:string):boolean;
     var _n,_i:integer;
   begin
     _n:=0;
     if length(s)>2 then begin
     for _i:=1 to length(_s) do begin
       if not (_s[_i] in ['0'..'9','.']) then inc(_n);
     end;
     if _n=0 then begin
         for _i:=1 to length(_s) do begin
           if _s[_i]='.' then inc(_n);
         end;
       if (_n=1)and(s[2]='.')and(s[1]='0') then result:=true
               else result:=false;
     end
             else result:=false;
     end
             else result:=false;
   end;
begin
 if length(s)>0 then begin
   if (_nz(s))and(length(s)>4) then begin
//     time
   end;
   if length(s)<6 then begin
     while pos(',',s)>0 do s[pos(',',s)]:=':';
     while pos('.',s)>0 do s[pos('.',s)]:=':';
   end;
   if _nn(s) then begin
     if length(s)<3 then s:=s+':00';
   end
    else begin
      if _nz(s) then s:=s+'0';
    end;
   if s='?' then s:='-'; 
   result:=s; 
 end
  else result:='';
end;
     {
procedure LoadFromXLS(fn:string);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
X, Y, xx, yy : Integer;
IIndex : OleVariant;
NomFich : WideString;
nf:string;
tf:double;
begin
with form1 do begin
ProgressBar2.Position:=0;
NomFich := fn;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
StringGrid1.ColCount := Y;
StringGrid1.RowCount := X;
ProgressBar2.Max:=X;
for xx:=1 to x do begin
  for yy:=1 to y do begin
    nf:=worksheet.cells.item[xx,yy].NumberFormat;
    if (nf=':')or(nf=':')or(nf='h:mm')or(nf='hh:mm;@')or(nf=':;@')or(nf=':;@')or(nf='h:mm;@')or(nf='hh:mm;@') then begin
       tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xx,yy]),70);
       if tf=70 then stringgrid1.Cells[yy-1,xx-1]:=VarToStrDef(worksheet.cells.item[xx,yy],'')
                else stringgrid1.Cells[yy-1,xx-1]:=FormatDateTime('hh:nn',tf);
    end
     else begin
       if (xx>2)and(yy>2) then stringgrid1.Cells[yy-1,xx-1]:=PrepareStr1(Trim(VarToStrDef(worksheet.cells.item[xx,yy],'')))
                          else stringgrid1.Cells[yy-1,xx-1]:=PrepareStr2(Trim(VarToStrDef(worksheet.cells.item[xx,yy],'')));
     end;
  end;
  ProgressBar2.Position:=xx;
  Application.ProcessMessages;
end;


XLApp.Quit;
XLApp.Disconnect;
ProgressBar2.Position:=0;
end;
end;

}

Function StrToIntE1(s:string):integer;
  var i,t:integer;
begin
   val(s,i,t);
   if t<>0 then begin
             StrToIntE1:=0;
             log.add(' '+mtrain+'.    : "'+s+'"');
           end
           else StrToIntE1:=i;
end;

procedure xhm(var h,m:integer);
  begin
    if m>59 then begin
      inc(h,(m div 60));
      m:=m mod 60;
    end;
    if h>23 then begin
     h:=h-24;
    end;
  end;

procedure dechm(var h,m:integer; t:integer);
  begin
    if (m-t)<0 then begin
      m:=60+(m-t);
      dec(h);
        if h<0 then h:=23;
    end
      else dec(m,t);
  end;

procedure inchm(var h,m:integer; t:integer);
  begin
    inc(m,t);
    xhm(h,m);
  end;

procedure tohm(s:string; var h,m:integer);
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    if pos('@',s)>1 then s:=copy(s,1,pos('@',s)-1);
    if pos(':',s)>0 then begin
      h:=StrToIntE1(copy(s,1,pos(':',s)-1));
      m:=StrToIntE1(copy(s,pos(':',s)+1,100));
    end
     else log.add(' '+mtrain+'.    : "'+s+'"');
//     else log.add(' '+mtrain+'.    : "'+s+'" '+inttostr(ord(s[1])));
  end;

function prephm(s:string):string;
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    result:=s;
  end;

function fromhm(h,m:integer):string;
  begin
    xhm(h,m);
    if h>9 then begin
             if m>9 then fromhm:=inttostr(h)+':'+inttostr(m)
                    else fromhm:=inttostr(h)+':0'+inttostr(m);
           end
           else begin
             if m>9 then fromhm:='0'+inttostr(h)+':'+inttostr(m)
                    else fromhm:='0'+inttostr(h)+':0'+inttostr(m);
           end;
  end;


procedure ClearSG;
 var i,n:integer;
begin
 for i:=0 to form1.StringGrid1.ColCount do
  for n:=0 to form1.StringGrid1.RowCount do form1.StringGrid1.Cells[i,n]:='';
end;

procedure ParseCSVStr(ts:AF_Types.PStrings; s:widestring);
 var n:integer;
begin
  ts.clear;
  while pos(';',s)>0 do begin
    n:=pos(';',s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;

function PrepareTT(s:string;n,n1,n2,mfs:integer):TTimetable1;
 var r:boolean;
 var h,m,h1,m1,h2,m2,x:integer;
begin
  if pos('@',s)>0 then s:=trim(copy(s,1,pos('@',s)-1))
                  else s:=trim(s);
  while pos('^',s)>0 do delete(s,pos('^',s),1);
  while pos('*',s)>0 do delete(s,pos('*',s),1);
  s:=trim(s);
  result.t1:='';
  result.t2:='';
  Result.st:='';
  Result.mfs:='';
  r:=true;
  if n=n1 then begin
    if pos('/',s)>0 then s:=copy(s,pos('/',s)+1,length(s)-pos('/',s));
    tohm(s,h,m);
    lh:=h; lm:=m; lmfs:=0;
    result.t2:=prephm(s);
    result.mfs:='0';
    r:=false;
  end;
  if n=n2 then begin
    if pos('/',s)>0 then s:=copy(s,1,pos('/',s)-1);
    tohm(s,h1,m1);
    result.t1:=prephm(s);
    r:=false;
      for x:=1 to 1439 do begin
        inchm(lh,lm,1);
        inc(lmfs,1);
        if (lh=h1) and (lm=m1) then break;
      end;
      result.mfs:=inttostr(lmfs);
  end;
  if r then
        if pos('-',s)>0 then begin
           Result.st:='-';
           r:=false;
        end;
  if r then begin
    if pos('/',s)>0 then begin
      tohm(copy(s,1,pos('/',s)-1),h,m);
      tohm(copy(s,pos('/',s)+1,length(s)-pos('/',s)),h1,m1);
      h2:=h; m2:=m;
      for x:=1 to 1439 do begin
        inchm(h2,m2,1);
        if (h2=h1) and (m2=m1) then break;
      end;
      result.t1:=fromhm(h,m);
      result.t2:=fromhm(h1,m1);
      result.st:=inttostr(x);
    end
     else begin
       tohm(s,h,m);
       h1:=h; m1:=m;
       dechm(h,m,1);
       result.t1:=fromhm(h,m);
       result.t2:=fromhm(h1,m1);
       Result.st:='1';
     end;
      for x:=1 to 1439 do begin
        inchm(lh,lm,1);
        inc(lmfs,1);
        if (lh=h) and (lm=m) then break;
      end;
      result.mfs:=inttostr(lmfs);
  end;
end;

function PrepareTT1(s:string;n,n1,n2,mfs:integer):TTimetable1;
 var r:boolean;
 var h,m,h1,m1,h2,m2,x:integer;
begin
  if pos('@',s)>0 then s:=trim(copy(s,1,pos('@',s)-1))
                  else s:=trim(s);
  if pos('^',s)>0 then delete(s,pos('^',s),1);
  result.t1:='';
  result.t2:='';
  Result.st:='';
  Result.mfs:='';
  r:=true;
  if n=n1 then begin
    if pos('/',s)>0 then s:=copy(s,pos('/',s)+1,length(s)-pos('/',s));
    tohm(s,h,m);
    lh9:=h; lm9:=m; lmfs9:=0;
    result.t2:=prephm(s);
    result.mfs:='0';
    r:=false;
  end;
  if n=n2 then begin
    if pos('/',s)>0 then s:=copy(s,1,pos('/',s)-1);
    tohm(s,h1,m1);
    result.t1:=prephm(s);
    r:=false;
      for x:=1 to 1439 do begin
        inchm(lh9,lm9,1);
        inc(lmfs9,1);
        if (lh9=h1) and (lm9=m1) then break;
      end;
      result.mfs:=inttostr(lmfs9);
  end;
  if r then
        if pos('-',s)>0 then begin
           Result.st:='-';
           r:=false;
        end;
  if r then begin
    if pos('/',s)>0 then begin
      tohm(copy(s,1,pos('/',s)-1),h,m);
      tohm(copy(s,pos('/',s)+1,length(s)-pos('/',s)),h1,m1);
      h2:=h; m2:=m;
      for x:=1 to 1439 do begin
        inchm(h2,m2,1);
        if (h2=h1) and (m2=m1) then break;
      end;
      result.t1:=fromhm(h,m);
      result.t2:=fromhm(h1,m1);
      result.st:=inttostr(x);
    end
     else begin
       tohm(s,h,m);
       h1:=h; m1:=m;
       dechm(h,m,1);
       result.t1:=fromhm(h,m);
       result.t2:=fromhm(h1,m1);
       Result.st:='1';
     end;
      for x:=1 to 1439 do begin
        inchm(lh9,lm9,1);
        inc(lmfs9,1);
        if (lh9=h) and (lm9=m) then break;
      end;
      result.mfs:=inttostr(lmfs9);
  end;
end;

function kDayStr(s:string):string;
begin
  if form1.checkbox2.checked then result:=''
                             else result:=s;
end;

function CalcDays(s:string):string;
  var c,t,w,h,nw,chet,nech:char;
  var d,dx,s1,dlist1,dlist2,newstr:string;
  var r:boolean;
  var i,n1,n2:integer;
  var dd1,dd2:array[0..6] of byte;
  const dd:array[0..6] of string[20] = ('', '', '', '', '', '', '');
begin
  for i:=0 to 6 do dd1[i]:=0;
  for i:=0 to 6 do dd2[i]:=0;
  r:=true;
  c:='N';
  t:='Y';
  w:='N';
  h:='N';
  nw:='N';
  chet:='N';
  nech:='N';
  d:='';
  dx:='';
  dlist1:='';
  dlist2:='';
  newstr:='';
  if s='' then r:=false;
  if r and (s='') then begin c:='N'; t:='Y'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='Y'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; chet:='Y'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; nech:='Y'; r:=false; end;
  if r and (s='') then begin c:='Y'; t:='N'; r:=false; end;
  if r and (s='') then begin c:='Y'; t:='N'; r:=false; end;
  if r and (s=':') then begin c:='N'; t:='N'; d:='012345'; r:=false; end;
  if r and (s=':') then begin c:='N'; t:='N'; d:='123456'; r:=false; end;
  if r and (s=':') then begin c:='N'; t:='N'; d:='123456'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='123456'; r:=false; end;
  if r and (s=':') then begin c:='N'; t:='N'; d:='012346'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='6'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='0'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='0'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='5'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; w:='Y'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; h:='Y'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; h:='Y'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; nw:='Y'; d:='1234'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='12346'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='5'; h:='Y'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='012346'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='5'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='5'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='56'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='01234'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='123456'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='05'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='6'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='012345'; r:=false; end;
  if r then begin
    form2.Position:=poMainFormCenter;
    form2.Label1.caption:=s;
    if not unit2.ParseKStr then Log.add('     : '+s);
    if form1.CheckBox3.Checked=false then form2.ShowModal;
    i:=0;
    t:='N';
    if form2.CheckBox1.Checked then inc(i);
    if form2.CheckBox2.Checked then inc(i);
    if form2.CheckBox3.Checked then inc(i);
    if form2.CheckBox4.Checked then inc(i);
    if form2.CheckBox5.Checked then inc(i);
    if form2.CheckBox6.Checked then inc(i);
    if form2.CheckBox7.Checked then inc(i);
    if i>0 then begin
      if form2.CheckBox1.Checked then d:=d+'1';
      if form2.CheckBox2.Checked then d:=d+'2';
      if form2.CheckBox3.Checked then d:=d+'3';
      if form2.CheckBox4.Checked then d:=d+'4';
      if form2.CheckBox5.Checked then d:=d+'5';
      if form2.CheckBox6.Checked then d:=d+'6';
      if form2.CheckBox7.Checked then d:=d+'0';
    end;
    if form2.CheckBox8.Checked then w:='Y';
    if form2.CheckBox9.Checked then h:='Y';
  end;
  s1:='cancel="'+c+'" daily="'+t+'"';
  if chet='Y' then s1:=s1+' even="Y"';
  if nech='Y' then s1:=s1+' odd="Y"';
  if w='Y' then s1:=s1+' workdays="Y"';
  if h='Y' then s1:=s1+' weekend="Y"';
  if nw='Y' then s1:=s1+' noweekend="Y"';
  if d<>'' then s1:=s1+' days="'+d+'"';
  //
  r:=true;
  if c='Y' then begin dlist1:=''; dlist2:=''; r:=false; newstr:='C'; end;
  if r and (t='Y') then begin dlist1:=''; dlist2:=''; r:=false; newstr:='1234567'; end;
  if r and (t='N') and (chet='Y') then begin dlist1:='  '; dlist2:='  '; r:=false; newstr:='E'; end;
  if r and (t='N') and (nech='Y') then begin dlist1:='  '; dlist2:='  '; r:=false; newstr:='U'; end;
  if r and (w='Y') and (d='') then begin dlist1:=' '; dlist2:=' ,'; r:=false; newstr:='W'; end;
  if r and (h='Y') and (d='') then begin dlist1:=' '; dlist2:=',  .'; r:=false; newstr:='H'; end;
  if r and (h='N') and (d='1234') then begin
                                          if nw='Y' then begin dlist1:='   '; dlist2:='   '; r:=false; newstr:='-5H'; end
                                                    else begin dlist1:=',,,'; dlist2:=',,,'; r:=false; newstr:='1234'; end;
                                       end;
  if r and (h='Y') and (d='5') then begin dlist1:='   '; dlist2:=' .  '; r:=false; newstr:='5H'; end;
  if r and (d<>'') then begin
                     if h='Y' then begin dd2[0]:=1; dd2[1]:=1; end;
                     if pos('0',d)>0 then begin dd1[0]:=1; dd2[1]:=1; end;
                     if pos('1',d)>0 then begin dd1[1]:=1; dd2[2]:=1; end;
                     if pos('2',d)>0 then begin dd1[2]:=1; dd2[3]:=1; end;
                     if pos('3',d)>0 then begin dd1[3]:=1; dd2[4]:=1; end;
                     if pos('4',d)>0 then begin dd1[4]:=1; dd2[5]:=1; end;
                     if pos('5',d)>0 then begin dd1[5]:=1; dd2[6]:=1; end;
                     if pos('6',d)>0 then begin dd1[6]:=1; dd2[0]:=1; end;
                     n1:=0; n2:=0;
                     for i:=0 to 6 do if dd1[i]=1 then inc(n1);
                     for i:=0 to 6 do if dd2[i]=1 then inc(n2);
                     if n1>4 then begin
                       dlist1:=' ';
                       newstr:='-';
                       for i:=1 to 6 do if dd1[i]=0 then begin dlist1:=dlist1+dd[i]+','; newstr:=newstr+inttostr(i); end;
                       if dd1[0]=0 then begin dlist1:=dlist1+dd[0]+','; newstr:=newstr+'7'; end;
                     end
                      else begin
                       newstr:='';
                       for i:=1 to 6 do if dd1[i]=1 then begin dlist1:=dlist1+dd[i]+','; newstr:=newstr+inttostr(i); end;
                       if dd1[0]=1 then begin dlist1:=dlist1+dd[0]+','; newstr:=newstr+'7'; end;
                      end;
                     if n2>4 then begin
                       dlist2:=' ';
                       for i:=1 to 6 do if dd2[i]=0 then dlist2:=dlist2+dd[i]+',';
                       if dd2[0]=0 then dlist2:=dlist2+dd[0]+',';
                     end
                      else begin
                       for i:=1 to 6 do if dd2[i]=1 then dlist2:=dlist2+dd[i]+',';
                       if dd2[0]=1 then dlist2:=dlist2+dd[0]+',';
                      end;
                     dlist1:=copy(dlist1,1,length(dlist1)-1);
                     dlist2:=copy(dlist2,1,length(dlist2)-1);
                     if h='Y' then begin dlist1:=dlist1+'  '; newstr:=newstr+'H'; end;
                   end;

//  s1:=s1+' daystr1="'+dlist1+'" daystr2="'+dlist2+'"';
  s1:=s1+' daystr="'+kDayStr(dlist1+';'+dlist2)+'" weektemplate="'+newstr+'"';
  __dst:=dlist1;
  __dstnew:=newstr;
  __dst0:='@'+form2.Label1.caption;
  //
  result:=s1;
end;

function CalcDaysMCC(s,sh:string):string;
  var c,t,w,h,nw,chet,nech:char;
  var d,dx,s1,dlist1,dlist2,newstr,mdays,s90,s91:string;
  var r:boolean;
  var i,n1,n2,hh1,mm1,hh1a,mm1a:integer;
  var dd1,dd2:array[0..6] of byte;
  const dd:array[0..6] of string[20] = ('', '', '', '', '', '', '');
begin
  s90:=sh;
//  s91:=sh1;
  if pos('/',s90)>1 then s90:=trim(copy(s90,pos('/',s90)+1,length(s90)-pos('/',s90)));
//  if pos('/',s91)>1 then s91:=trim(copy(s91,pos('/',s91)+1,length(s91)-pos('/',s91)));
  tohm(s90,hh1,mm1);
//  tohm(s91,hh1a,mm1a);
  for i:=0 to 6 do dd1[i]:=0;
  for i:=0 to 6 do dd2[i]:=0;
  r:=true;
  c:='N';
  t:='Y';
  w:='N';
  h:='N';
  nw:='N';
  chet:='N';
  nech:='N';
  d:='';
  dx:='';
  dlist1:='';
  dlist2:='';
  newstr:='';
  if s='' then r:=false;
  if r and (s='') then begin c:='N'; t:='Y'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='Y'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; chet:='Y'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; nech:='Y'; r:=false; end;
  if r and (s='') then begin c:='Y'; t:='N'; r:=false; end;
  if r and (s='') then begin c:='Y'; t:='N'; r:=false; end;
  if r and (s=':') then begin c:='N'; t:='N'; d:='012345'; r:=false; end;
  if r and (s=':') then begin c:='N'; t:='N'; d:='123456'; r:=false; end;
  if r and (s=':') then begin c:='N'; t:='N'; d:='123456'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='123456'; r:=false; end;
  if r and (s=':') then begin c:='N'; t:='N'; d:='012346'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='6'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='0'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='0'; r:=false; end;
  if r and (s='') then begin c:='N'; t:='N'; d:='5'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; w:='Y'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; h:='Y'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; h:='Y'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; nw:='Y'; d:='1234'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='12346'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='5'; h:='Y'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='012346'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='5'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='5'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='56'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='01234'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='123456'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='05'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='6'; r:=false; end;
      if r and (s='') then begin c:='N'; t:='N'; d:='012345'; r:=false; end;
  if r then begin
    form2.Position:=poMainFormCenter;
    form2.Label1.caption:=s;
    if not unit2.ParseKStr then Log.add('     : '+s);
    if form1.CheckBox3.Checked=false then form2.ShowModal;
    i:=0;
    t:='N';
    if form2.CheckBox1.Checked then inc(i);
    if form2.CheckBox2.Checked then inc(i);
    if form2.CheckBox3.Checked then inc(i);
    if form2.CheckBox4.Checked then inc(i);
    if form2.CheckBox5.Checked then inc(i);
    if form2.CheckBox6.Checked then inc(i);
    if form2.CheckBox7.Checked then inc(i);
    if i>0 then begin
      if form2.CheckBox1.Checked then d:=d+'1';
      if form2.CheckBox2.Checked then d:=d+'2';
      if form2.CheckBox3.Checked then d:=d+'3';
      if form2.CheckBox4.Checked then d:=d+'4';
      if form2.CheckBox5.Checked then d:=d+'5';
      if form2.CheckBox6.Checked then d:=d+'6';
      if form2.CheckBox7.Checked then d:=d+'0';
    end;
    if form2.CheckBox8.Checked then w:='Y';
    if form2.CheckBox9.Checked then h:='Y';
  end;
  s1:='cancel="'+c+'" daily="'+t+'"';
  if chet='Y' then s1:=s1+' even="Y"';
  if nech='Y' then s1:=s1+' odd="Y"';
  if w='Y' then s1:=s1+' workdays="Y"';
  if h='Y' then s1:=s1+' weekend="Y"';
  if nw='Y' then s1:=s1+' noweekend="Y"';
  if d<>'' then s1:=s1+' days="'+d+'"';
  //
  r:=true;
  if c='Y' then begin dlist1:=''; dlist2:=''; r:=false; newstr:='C'; end;
  if r and (t='Y') then begin dlist1:=''; dlist2:=''; r:=false; newstr:='1234567'; end;
  if r and (t='N') and (chet='Y') then begin dlist1:='  '; dlist2:='  '; r:=false; newstr:='E'; end;
  if r and (t='N') and (nech='Y') then begin dlist1:='  '; dlist2:='  '; r:=false; newstr:='U'; end;
  if r and (w='Y') and (d='') then begin dlist1:=' '; dlist2:=' ,'; r:=false; newstr:='W'; end;
  if r and (h='Y') and (d='') then begin dlist1:=' '; dlist2:=',  .'; r:=false; newstr:='H'; end;
  if r and (h='N') and (d='1234') then begin
                                          if nw='Y' then begin dlist1:='   '; dlist2:='   '; r:=false; newstr:='-5H'; end
                                                    else begin dlist1:=',,,'; dlist2:=',,,'; r:=false; newstr:='1234'; end;
                                       end;
  if r and (h='Y') and (d='5') then begin dlist1:='   '; dlist2:=' .  '; r:=false; newstr:='5H'; end;
  if r and (d<>'') then begin
                     if h='Y' then begin dd2[0]:=1; dd2[1]:=1; end;
                     if pos('0',d)>0 then begin dd1[0]:=1; dd2[1]:=1; end;
                     if pos('1',d)>0 then begin dd1[1]:=1; dd2[2]:=1; end;
                     if pos('2',d)>0 then begin dd1[2]:=1; dd2[3]:=1; end;
                     if pos('3',d)>0 then begin dd1[3]:=1; dd2[4]:=1; end;
                     if pos('4',d)>0 then begin dd1[4]:=1; dd2[5]:=1; end;
                     if pos('5',d)>0 then begin dd1[5]:=1; dd2[6]:=1; end;
                     if pos('6',d)>0 then begin dd1[6]:=1; dd2[0]:=1; end;
                     n1:=0; n2:=0;
                     for i:=0 to 6 do if dd1[i]=1 then inc(n1);
                     for i:=0 to 6 do if dd2[i]=1 then inc(n2);
                     if n1>4 then begin
                       dlist1:=' ';
                       newstr:='-';
                       for i:=1 to 6 do if dd1[i]=0 then begin dlist1:=dlist1+dd[i]+','; newstr:=newstr+inttostr(i); end;
                       if dd1[0]=0 then begin dlist1:=dlist1+dd[0]+','; newstr:=newstr+'7'; end;
                     end
                      else begin
                       newstr:='';
                       for i:=1 to 6 do if dd1[i]=1 then begin dlist1:=dlist1+dd[i]+','; newstr:=newstr+inttostr(i); end;
                       if dd1[0]=1 then begin dlist1:=dlist1+dd[0]+','; newstr:=newstr+'7'; end;
                      end;
                     if n2>4 then begin
                       dlist2:=' ';
                       for i:=1 to 6 do if dd2[i]=0 then dlist2:=dlist2+dd[i]+',';
                       if dd2[0]=0 then dlist2:=dlist2+dd[0]+',';
                     end
                      else begin
                       for i:=1 to 6 do if dd2[i]=1 then dlist2:=dlist2+dd[i]+',';
                       if dd2[0]=1 then dlist2:=dlist2+dd[0]+',';
                      end;
                     dlist1:=copy(dlist1,1,length(dlist1)-1);
                     dlist2:=copy(dlist2,1,length(dlist2)-1);
                     if h='Y' then begin dlist1:=dlist1+'  '; newstr:=newstr+'H'; end;
                   end;

//  s1:=s1+' daystr1="'+dlist1+'" daystr2="'+dlist2+'"';
  mdays:=' daystr=""';
  if newstr='H' then mdays:=' daystr=" ;  /  /"';
  if newstr='W' then mdays:=' daystr=" ;  /  /"';
  if ((newstr='H')and(hh1 in [0..4])) then begin
    newstr:='17';
    while pos(' weekend="Y"',s1)>0 do delete(s1,pos(' weekend="Y"',s1),12);
    s1:=s1+' days="17"';
    mdays:=' daystr="  /  /;  /  /"';
  end;
  if ((newstr='W')and(hh1 in [0..4])) then begin
    newstr:='-17';
    while pos(' workdays="Y"',s1)>0 do delete(s1,pos(' workdays="Y"',s1),13);
    s1:=s1+' days="23456"';
    mdays:=' daystr="  /  /;  /  /"';
  end;
  s1:=s1+mdays+' weektemplate="'+newstr+'"';
  __dst:=dlist1;
  __dstnew:=newstr;
  __dst0:='@'+form2.Label1.caption;
  //
  result:=s1;
end;


function gettype2(s:string):string;
  var s1,s2,res:string;
begin
  res:='suburban';
  s2:=ansilowercase(trim(_sttt));
  if s2='train' then res:=s2;
  if s2='plane' then res:=s2;
  if s2='bus' then res:=s2;
  if s2='river' then res:=s2;
  result:=res;
end;

procedure getexpress(s:string; var express:string; var expresssub:string; var career: string; var tariff:string);
  var s1,s2,res:string;
  var n:integer;
begin
  res:='';
  s:=trim(AnsiLowerCase(s));
  if pos('#',s)>0 then begin
    s1:=copy(s,pos('#',s)+1,length(s)-pos('#',s));
    if pos('^',s1)>0 then delete(s1,pos('^',s1),1);
    s1:=trim(s1);
    n:=expr_id.SearchString(s1);
    if n>0 then begin
      if expr_type.getstring(n)<>'*' then express:=expr_type.getstring(n);
      if expr_sub.getstring(n)<>'*' then expresssub:=expr_sub.getstring(n);
      if expr_career.getstring(n)<>'*' then career:=expr_career.getstring(n);
      if expr_tariff.getstring(n)<>'*' then tariff:=expr_tariff.getstring(n);
    end
     else log.add('   #   : '+s1);
  end;
  s2:=ansilowercase(trim(_sttt));
  if s2='train' then begin express:=''; expresssub:=''; tariff:=''; end;
  if s2='plane' then begin express:=''; expresssub:=''; tariff:=''; end;
  if s2='bus' then begin express:=''; expresssub:=''; tariff:=''; end;
  if s2='river' then begin express:=''; expresssub:=''; tariff:=''; end;
end;

function ValidNumber(s:string):boolean;
  var res:boolean;
  var i,e:integer;
begin
  res:=false;
  s:=trim(s);
  if pos('#',s)>0 then s:=trim(copy(s,1,pos('#',s)-1));
  while pos('^',s)>0 do delete(s,pos('^',s),1);
  s:=trim(s);
  if length(s)>0 then begin
    e:=0;
    for i:=1 to length(s) do begin
      if not (s[i] in ['0'..'9','/']) then inc(e);
    end;
    if e=0 then res:=true;
  end;
  result:=res;
end;

function t_type(s:string):string;
  var res:string;
begin
 s:=ansilowercase(trim(s));
 res:=' ';
 if s='plane' then res:=' t_type="plane"';
 if s='bus' then res:=' t_type="bus"';
 if s='river' then res:=' t_type="river"';
 result:=res;
end;

function delquot(s:string):string;
begin
  result:=StrReplace(s,'"',' ');
end;

function delplatf(s:string):string;
begin
  if pos('@',s)>0 then s:=copy(s,1,pos('@',s)-1);
  result:=trim(s);
end;

function apifnc(param,str:string):string;
begin
 if validstr(str) then result:=' '+param+'="'+str+'"'
                  else result:='';
end;

function CalcThread(n,o:integer;outfile:AF_Types.PStrings): WideString;
 var i,n1,n2,h,m,h1,m1,t:integer;
 var s:WideString;
 var tt:TTimetable1;
 var platf,career,tmodel,timezone,dcountryid,iscombined,p_career,p_express,p_expresssubtype,p_tariff,periodstart0,periodend0,graph0:string;
 var kflag,ondemand:boolean;
begin
                  p_career:='';
                  p_express:='';
                  p_expresssubtype:='';
                  p_tariff:='';
                  socrmode:=0;
                  career:='';
                  dcountryid:='225';
                  kflag:=false;
                  if career_n.count>0 then begin
                    for i:=1 to career_n.count do begin
                     if pos(career_n.getstring(i),trim(form1.StringGrid1.Cells[0,0]))=1 then begin
                       career:=' career="'+career_i.getstring(i)+'"';
                       p_career:=career_i.getstring(i);
                       dcountryid:=career_t.getstring(i);
                       kflag:=true;
                       break;
                     end;
                    end;
                  end;
                  _stidf:='esrcode';
                  _sttt:='etrain';
                  tmodel:='';
                  timezone:='';
                  if ValidStr(ansilowercase(trim(form1.StringGrid1.Cells[1,0]))) then timezone:=' time_zone="'+trim(form1.StringGrid1.Cells[1,0])+'"';
                  if pos('t_train',form1.StringGrid1.Cells[0,0])>0 then begin _sttt:='train'; {_stidf:='station_id';} end;
                  if pos('t_avia',form1.StringGrid1.Cells[0,0])>0 then begin _sttt:='plane'; _stidf:='station_id'; end;
                  if pos('t_plane',form1.StringGrid1.Cells[0,0])>0 then begin _sttt:='plane'; _stidf:='station_id'; end;
                  if pos('t_bus',form1.StringGrid1.Cells[0,0])>0 then begin _sttt:='bus'; _stidf:='station_id'; end;
                  if pos('t_river',form1.StringGrid1.Cells[0,0])>0 then begin _sttt:='river'; _stidf:='station_id'; end;
                  if _sttt<>'etrain' then begin
                    dcountryid:='';
                    if validstr(trim(form1.StringGrid1.Cells[1,1])) then begin
                      p_career:=trim(form1.StringGrid1.Cells[1,1]);
                      kflag:=true;
                    end;
                  end;
                  if not kflag then log.add(':   !');

  n1:=0;
  n2:=0;
  s:='';
  for i:=2 to form1.stringgrid1.RowCount-1 do begin
    n1:=i;
    if form1.StringGrid1.Cells[n,i]<>'' then break;
  end;
  for i:=form1.stringgrid1.RowCount-1 downto 2 do begin
    n2:=i;
    if form1.StringGrid1.Cells[n,i]<>'' then break;
  end;
  if n2>n1 then begin
    lh:=0;
    lm:=0;
    lmfs:=0;
    omfs:=0;
    mtrain:=form1.StringGrid1.Cells[n,0];
    if not ValidNumber(mtrain) then  log.add(' '+mtrain+'. :    !');
    if pos('^',form1.StringGrid1.Cells[n,0])>0 then iscombined:=' is_combined="1"'
                                               else iscombined:='';
    getexpress(form1.StringGrid1.Cells[n,0],p_express,p_expresssubtype,p_career,p_tariff);

    graph0:=ansilowercase(trim(form1.StringGrid1.Cells[0,1]));
    gr2per(graph0,periodstart0,periodend0,_sttt);
    if periodstart0='' then log.add(' '+mtrain+'. :    !         !');
    outfile.add('  <thread'{tmodel}+' t_type="'+gettype2(form1.StringGrid1.Cells[n,0])+'"'+apifnc('express_type',p_express)+apifnc('express_subtype',p_expresssubtype)+apifnc('career',p_career)+apifnc('tariff_type',p_tariff)+' number="'+ansiuppercase(numb2(form1.StringGrid1.Cells[n,0]))+'"'+iscombined+' changemode="insert" '+CalcDays(form1.StringGrid1.Cells[n,1])+' period_start="'+periodstart0+'" period_end="'+periodend0+'"'+timezone+apifnc('graph',graph0)+apifnc('calendar_geobase_country_id',dcountryid)+' >');
    outfile.add('    <stations>');
    edisp.add(ansiuppercase(numb2(form1.StringGrid1.Cells[n,0]))+';'+trim(form1.StringGrid1.Cells[1,n1])+' - '+trim(form1.StringGrid1.Cells[1,n2])+';'+delplatf(trim(form1.StringGrid1.Cells[n,n1]))+';'+delplatf(trim(form1.StringGrid1.Cells[n,n2]))+';'+__dst+';'+__dstnew+';'+trim(form1.StringGrid1.Cells[0,n1])+';'+trim(form1.StringGrid1.Cells[0,n2])+';'+trim(form1.StringGrid1.Cells[1,n1])+';'+trim(form1.StringGrid1.Cells[1,n2]));
    for i:=n1 to n2 do begin
    if (form1.StringGrid1.Cells[n,i]<>'')and(form1.StringGrid1.Cells[0,i]<>'') then begin
      ondemand:=false;
      if pos('*',form1.StringGrid1.Cells[n,i])>0 then ondemand:=true;
      if pos('^',form1.StringGrid1.Cells[n,i])>0 then iscombined:=' is_combined="1"'
                                                 else iscombined:='';
      tt:=PrepareTT(form1.StringGrid1.Cells[n,i],i,n1,n2,0);
      platf:='';
      if pos('@',form1.StringGrid1.Cells[n,i])>0 then platf:=' platform="'+trim(copy(form1.StringGrid1.Cells[n,i],pos('@',form1.StringGrid1.Cells[n,i])+1,length(form1.StringGrid1.Cells[n,i])-pos('@',form1.StringGrid1.Cells[n,i])))+'"'
                                                 else begin
                                                   if pos('(*)',ansilowercase(form1.StringGrid1.Cells[1,i]))>0 then ondemand:=true;
                                                   if ondemand then if tt.st<>'-' then platf:=' platform=" "'
                                                 end;
      while pos(':',platf)>0 do platf[pos(':',platf)]:='.';
      if (strtointe(tt.mfs)<omfs)and(strtointe(tt.st)>0) then log.add(' '+mtrain+'. :  MFS    '+form1.StringGrid1.Cells[1,i]);
      if strtointe(tt.st)>0 then omfs:=strtointe(tt.mfs)+strtointe(tt.st);
      if strtointe(tt.st)>90 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
        else begin
          if strtointe(tt.st)>45 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
         end;
      outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' />');
      if _stlistlog.SearchString(Prep0ESR(form1.StringGrid1.Cells[0,i]))<=0 then _stlistlog.add(Prep0ESR(form1.StringGrid1.Cells[0,i]));
    end;
    end;
    if StrToIntE(tt.mfs)>450 then begin
     if _sttt='etrain' then begin
       if StrToIntE(tt.mfs)>1000 then log.add(' '+mtrain+'. : MFS='+tt.mfs+' !!!!!!!!!')
                                 else log.add(' '+mtrain+'. : MFS='+tt.mfs);
     end;
    end;
    outfile.add('    </stations>');
    outfile.add('  </thread>');
  end; //n2>n1
  result:=s;
end;


(*
// 
function CalcThreadMKZD(n,o:integer;outfile:AF_Types.PStrings): WideString;
 var i,n1,n2,h,m,h1,m1,t,n3,n4,v3,v4,v5,vn1,vn2:integer;
 var s:WideString;
 var tt,tt1:TTimetable1;
 var platf,career,tmodel,timezone,dcountryid,iscombined,p_career,p_express,p_expresssubtype,p_tariff,periodstart0,periodend0,graph0,vns:string;
 var kflag:boolean;
begin
  p_career:='';
  p_express:='';
  p_expresssubtype:='';
  p_tariff:='';
  socrmode:=0;
  career:='';
  dcountryid:='225';
  kflag:=false;
  if career_n.count>0 then begin
    for i:=1 to career_n.count do begin
     if pos(career_n.getstring(i),trim(form1.StringGrid1.Cells[0,0]))=1 then begin
       career:=' career="'+career_i.getstring(i)+'"';
       p_career:=career_i.getstring(i);
       dcountryid:=career_t.getstring(i);
       kflag:=true;
       break;
     end;
    end;
  end;
  _stidf:='esrcode';
  _sttt:='etrain';
  tmodel:='';
  timezone:='';
  if ValidStr(ansilowercase(trim(form1.StringGrid1.Cells[1,0]))) then timezone:=' time_zone="'+trim(form1.StringGrid1.Cells[1,0])+'"';
  if not kflag then log.add(':   !');
  n1:=0;
  n2:=0;
  s:='';
  for i:=2 to form1.stringgrid1.RowCount-1 do begin
    n1:=i;
    if form1.StringGrid1.Cells[n,i]<>'' then break;
  end;
  for i:=form1.stringgrid1.RowCount-1 downto 2 do begin
    n2:=i;
    if form1.StringGrid1.Cells[n,i]<>'' then break;
  end;
  if n2>n1 then begin
    lh:=0;
    lm:=0;
    lmfs:=0;
    omfs:=0;
    mtrain:=form1.StringGrid1.Cells[n,0];
    if not ValidStr(mtrain) then  log.add(' '+mtrain+'. :   !');
    iscombined:='';
    getexpress(form1.StringGrid1.Cells[n,0],p_express,p_expresssubtype,p_career,p_tariff);
    graph0:=ansilowercase(trim(form1.StringGrid1.Cells[0,1]));
    gr2per(graph0,periodstart0,periodend0,_sttt);
    if periodstart0='' then log.add(' '+mtrain+'. :    !         !');
    outfile.add('  <thread t_type="'+gettype2(form1.StringGrid1.Cells[n,0])+'"'+apifnc('express_type',p_express)+apifnc('express_subtype',p_expresssubtype)+apifnc('career',p_career)+apifnc('tariff_type',p_tariff)+' number="'+ansiuppercase(numb2(form1.StringGrid1.Cells[n,0]))+'"'+iscombined+' changemode="insert" '+CalcDays(form1.StringGrid1.Cells[n,1])+' period_start="'+periodstart0+'" period_end="'+periodend0+'"'+timezone+apifnc('graph',graph0)+apifnc('calendar_geobase_country_id',dcountryid)+' >');
    outfile.add('    <stations>');
    for i:=n1 to n2 do begin
    if (form1.StringGrid1.Cells[n,i]<>'')and(form1.StringGrid1.Cells[0,i]<>'') then begin
      iscombined:='';
      tt:=PrepareTT(form1.StringGrid1.Cells[n,i],i,n1,n2,0);
      if pos('@',form1.StringGrid1.Cells[n,i])>0 then platf:=' platform="'+trim(copy(form1.StringGrid1.Cells[n,i],pos('@',form1.StringGrid1.Cells[n,i])+1,length(form1.StringGrid1.Cells[n,i])-pos('@',form1.StringGrid1.Cells[n,i])))+'"'
                                                 else platf:='';
      while pos(':',platf)>0 do platf[pos(':',platf)]:='.';
      if (strtointe(tt.mfs)<omfs)and(strtointe(tt.st)>0) then log.add(' '+mtrain+'. :  MFS    '+form1.StringGrid1.Cells[1,i]);
      if strtointe(tt.st)>0 then omfs:=strtointe(tt.mfs)+strtointe(tt.st);
      if strtointe(tt.st)>90 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
        else begin
          if strtointe(tt.st)>45 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
         end;
      outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="1" is_searchable_to="0" is_searchable_from="0"/>');
      if _stlistlog.SearchString(Prep0ESR(form1.StringGrid1.Cells[0,i]))<=0 then _stlistlog.add(Prep0ESR(form1.StringGrid1.Cells[0,i]));
    end;
    end;
    if StrToIntE(tt.mfs)>1400 then log.add(' '+mtrain+'. : MFS='+tt.mfs+' !!!!!!!!!');
    outfile.add('    </stations>');
    outfile.add('  </thread>');
    /////////////////////////////////////////
    vn1:=n1;
    vn2:=n2;
    if (vn2-vn1)>1 then begin
     for v3:=vn1 to vn2-1 do begin
      vns:=Form1.StringGrid1.Cells[0,v3];
      lh9:=0;
      lm9:=0;
      lmfs9:=0;
      omfs9:=0;
      for v5:=v3+1 to vn2 do begin
       if Form1.StringGrid1.Cells[0,v5]=vns then break;
      end;
      if Form1.StringGrid1.Cells[0,v5]=vns then v5:=v5-1;
      for v4:=v3 to v5 do begin
        if (form1.StringGrid1.Cells[n,v4]<>'')and(form1.StringGrid1.Cells[0,v4]<>'') then begin
         tt1:=PrepareTT1(form1.StringGrid1.Cells[n,v4],v4,v3,v5,0);
         if v3<>v4 then begin
          if strtointe(tt1.mfs)<50 then begin
//            outfile.add(Form1.StringGrid1.Cells[1,v3]+'-'+Form1.StringGrid1.Cells[1,v4]+' '+Form1.StringGrid1.Cells[n,v3]+'-'+Form1.StringGrid1.Cells[n,v4]+' '+tt1.mfs);
            n1:=v3;
            n2:=v5;
            lh:=0;
            lm:=0;
            lmfs:=0;
            omfs:=0;
            outfile.add('  <thread t_type="'+gettype2(form1.StringGrid1.Cells[n,0])+'"'+apifnc('express_type',p_express)+apifnc('express_subtype',p_expresssubtype)+apifnc('career',p_career)+apifnc('tariff_type',p_tariff)+' number="'+ansiuppercase(numb2(form1.StringGrid1.Cells[n,0]))+'"'+iscombined+' changemode="insert" '+CalcDays(form1.StringGrid1.Cells[n,1])+' period_start="'+periodstart0+'" period_end="'+periodend0+'"'+timezone+apifnc('graph',graph0)+apifnc('calendar_geobase_country_id',dcountryid)+' >');
            outfile.add('    <stations>');
            for i:=n1 to n2 do begin
            if (form1.StringGrid1.Cells[n,i]<>'')and(form1.StringGrid1.Cells[0,i]<>'') then begin
              iscombined:='';
              tt:=PrepareTT(form1.StringGrid1.Cells[n,i],i,n1,n2,0);
              if pos('@',form1.StringGrid1.Cells[n,i])>0 then platf:=' platform="'+trim(copy(form1.StringGrid1.Cells[n,i],pos('@',form1.StringGrid1.Cells[n,i])+1,length(form1.StringGrid1.Cells[n,i])-pos('@',form1.StringGrid1.Cells[n,i])))+'"'
                                                         else platf:='';
              while pos(':',platf)>0 do platf[pos(':',platf)]:='.';
              if (strtointe(tt.mfs)<omfs)and(strtointe(tt.st)>0) then log.add(' '+mtrain+'. :  MFS    '+form1.StringGrid1.Cells[1,i]);
              if strtointe(tt.st)>0 then omfs:=strtointe(tt.mfs)+strtointe(tt.st);
              if strtointe(tt.st)>90 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
                else begin
                  if strtointe(tt.st)>45 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
                 end;
              if i=v3 then outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="0" is_searchable_from="1"/>')
                else begin
                 if i=v4 then outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="1" is_searchable_from="0"/>')
                 else begin
                  if i=n2 then outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="0" is_searchable_from="0"/>')
                    else begin
                      outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="0" is_searchable_from="0"/>')
                    end;
                 end;
                end;
            end;
            end;
            if StrToIntE(tt.mfs)>1400 then log.add(' '+mtrain+'. : MFS='+tt.mfs+' !!!!!!!!!');
            outfile.add('    </stations>');
            outfile.add('  </thread>');
          end;
         end;
        end;
      end;
     end;
    end;
    /////////////////////////////////////////
  end; //n2>n1
  result:=s;
end;




//   -  .
function CalcThreadMKZD_OLD(n,o:integer;outfile:AF_Types.PStrings): WideString;
 var i,n1,n2,h,m,h1,m1,t,n3,n4,v3,v4,v5,vn1,vn2,qqn,h31,m31:integer;
 var s:WideString;
 var tt,tt1:TTimetable1;
 var platf,career,tmodel,timezone,dcountryid,iscombined,p_career,p_express,p_expresssubtype,p_tariff,periodstart0,periodend0,graph0,vns,vtitle,qqs,s90:string;
 var kflag:boolean;
 var strnn:string;
begin
  strnn:='error';
  p_career:='';
  p_express:='';
  p_expresssubtype:='';
  p_tariff:='';
  socrmode:=0;
  career:='';
  vtitle:='';
  dcountryid:='225';
  kflag:=false;
  if career_n.count>0 then begin
    for i:=1 to career_n.count do begin
     if pos(career_n.getstring(i),trim(form1.StringGrid1.Cells[0,0]))=1 then begin
       career:=' career="'+career_i.getstring(i)+'"';
       p_career:=career_i.getstring(i);
       dcountryid:=career_t.getstring(i);
       kflag:=true;
       break;
     end;
    end;
  end;
  _stidf:='esrcode';
  _sttt:='etrain';
  tmodel:='';
  timezone:='';
  if ValidStr(ansilowercase(trim(form1.StringGrid1.Cells[1,0]))) then timezone:=' time_zone="'+trim(form1.StringGrid1.Cells[1,0])+'"';
  if ValidStr(ansilowercase(trim(form1.StringGrid1.Cells[1,1]))) then vtitle:=' is_manual_title="1" title="'+trim(form1.StringGrid1.Cells[1,1])+'" title_short="'+trim(form1.StringGrid1.Cells[1,1])+'"';
  if not kflag then log.add(':   !');
  n1:=0;
  n2:=0;
  s:='';
  for i:=2 to form1.stringgrid1.RowCount-1 do begin
    n1:=i;
    if validstr(form1.StringGrid1.Cells[n,i]) then break;
  end;
  for i:=form1.stringgrid1.RowCount-1 downto 2 do begin
    n2:=i;
    if validstr(form1.StringGrid1.Cells[n,i]) then break;
  end;
  if n2>n1 then begin
    lh:=0;
    lm:=0;
    lmfs:=0;
    omfs:=0;
    mtrain:=form1.StringGrid1.Cells[n,0];
    if not ValidStr(mtrain) then  log.add(' '+mtrain+'. :   !');
    iscombined:='';
    getexpress(form1.StringGrid1.Cells[n,0],p_express,p_expresssubtype,p_career,p_tariff);
    graph0:=ansilowercase(trim(form1.StringGrid1.Cells[0,1]));
    gr2per(graph0,periodstart0,periodend0,_sttt);
    if periodstart0='' then log.add(' '+mtrain+'. :    !         !');
//    outfile.add('  <thread t_type="'+gettype2(form1.StringGrid1.Cells[n,0])+'"'+apifnc('express_type',p_express)+apifnc('express_subtype',p_expresssubtype)+apifnc('career',p_career)+apifnc('tariff_type',p_tariff)+' number="'+ansiuppercase(numb2(form1.StringGrid1.Cells[n,0]))+'"'+iscombined+vtitle+' changemode="insert" '+CalcDays(form1.StringGrid1.Cells[n,1])+' period_start="'+periodstart0+'" period_end="'+periodend0+'"'+timezone+apifnc('graph',graph0)+apifnc('calendar_geobase_country_id',dcountryid)+' >');
//    outfile.add('    <stations>');
    for i:=n1 to n2 do begin
    if (form1.StringGrid1.Cells[n,i]<>'')and(form1.StringGrid1.Cells[0,i]<>'') then begin
      iscombined:='';
      tt:=PrepareTT(form1.StringGrid1.Cells[n,i],i,n1,n2,0);
      if pos('@',form1.StringGrid1.Cells[n,i])>0 then platf:=' platform="'+trim(copy(form1.StringGrid1.Cells[n,i],pos('@',form1.StringGrid1.Cells[n,i])+1,length(form1.StringGrid1.Cells[n,i])-pos('@',form1.StringGrid1.Cells[n,i])))+'"'
                                                 else platf:='';
      while pos(':',platf)>0 do platf[pos(':',platf)]:='.';
      if (strtointe(tt.mfs)<omfs)and(strtointe(tt.st)>0) then log.add(' '+mtrain+'. :  MFS    '+form1.StringGrid1.Cells[1,i]);
      if strtointe(tt.st)>0 then omfs:=strtointe(tt.mfs)+strtointe(tt.st);
      if strtointe(tt.st)>90 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
        else begin
          if strtointe(tt.st)>45 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
         end;
//      outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="1" is_searchable_to="0" is_searchable_from="0"/>');
      if _stlistlog.SearchString(Prep0ESR(form1.StringGrid1.Cells[0,i]))<=0 then _stlistlog.add(Prep0ESR(form1.StringGrid1.Cells[0,i]));
    end;
    end;
    if StrToIntE(tt.mfs)>1400 then log.add(' '+mtrain+'. : MFS='+tt.mfs+' !!!!!!!!!');
//    outfile.add('    </stations>');
//    outfile.add('  </thread>');
    /////////////////////////////////////////
    vn1:=n1;
    vn2:=n2;
    if (vn2-vn1)>1 then begin
     for v3:=vn1 to vn2-1 do begin
      vns:=Form1.StringGrid1.Cells[0,v3];
      for v5:=v3+1 to vn2 do begin
       if Form1.StringGrid1.Cells[0,v5]=vns then break;
      end;
      {if Form1.StringGrid1.Cells[0,v5]=vns then} v5:=v5-1;
        if (form1.StringGrid1.Cells[n,v3]<>'-')and(form1.StringGrid1.Cells[n,v3]<>'')and(form1.StringGrid1.Cells[0,v3]<>'') then begin
//            outfile.add(Form1.StringGrid1.Cells[1,v3]+'-'+Form1.StringGrid1.Cells[1,v5]+' '+Form1.StringGrid1.Cells[n,v5]+'-'+Form1.StringGrid1.Cells[n,v5]+' '+tt1.mfs);
            n1:=v3;
            n2:=v5;
            lh:=0;
            lm:=0;
            lmfs:=0;
            omfs:=0;
//            outfile.add('n1='+inttostr(n1)+' n2='+inttostr(n2));
            qqn:=n2-n1+1;

/// !!!!!!!!!!     !!!         ,   31
            if qqn<31 then begin
              if ValidStr(ansilowercase(trim(form1.StringGrid1.Cells[1,1]))) then begin
                vtitle:=' is_manual_title="1" title="'+trim(form1.StringGrid1.Cells[1,1])+' ( . '+trim(form1.StringGrid1.Cells[1,n2])+')" title_short="'+trim(form1.StringGrid1.Cells[1,1])+' ( . '+trim(form1.StringGrid1.Cells[1,n2])+')"';
              end;
            end;
            s90:=form1.StringGrid1.Cells[n,n1];
            if pos('/',s90)>1 then s90:=trim(copy(s90,pos('/',s90)+1,length(s90)-pos('/',s90)));
            tohm(s90,h31,m31);

            strnn:='9sept';
            if n1>430 then strnn:='10sept';
            if h31=0 then strnn:='night9-10sept';
            if h31=1 then strnn:='night9-10sept';
            if h31=2 then strnn:='night9-10sept';
            if h31=3 then strnn:='night9-10sept';
            if h31=4 then strnn:='night9-10sept';

{            strnn:='1';
            if ((h31=23)and(n1<100)) then strnn:='31';
            if ((h31=0)and(n1<300)) then strnn:='1n';
            if ((h31=1)and(n1<300)) then strnn:='1n';
            if ((h31=2)and(n1<300)) then strnn:='1n';
            if ((h31=3)and(n1<300)) then strnn:='1n';
            if ((h31=4)and(n1<300)) then strnn:='1n';
            if ((h31=0)and(n1>400)) then strnn:='2n';
            if ((h31=1)and(n1>400)) then strnn:='2n';  }

//            outfile.add('  <thread t_type="'+gettype2(form1.StringGrid1.Cells[n,0])+'"'+apifnc('express_type',p_express)+apifnc('express_subtype',p_expresssubtype)+apifnc('career',p_career)+apifnc('tariff_type',p_tariff)+' number="'+ansiuppercase(numb2(form1.StringGrid1.Cells[n,0]))+'"'+iscombined+vtitle+' changemode="insert" strnn="'+strnn+'" '+CalcDaysMCC(form1.StringGrid1.Cells[n,1],form1.StringGrid1.Cells[n,n1])+' period_start="'+periodstart0+'" period_end="'+periodend0+'"'+timezone+apifnc('graph',graph0)+apifnc('calendar_geobase_country_id',dcountryid)+' >');
            outfile.add('  <thread t_type="'+gettype2(form1.StringGrid1.Cells[n,0])+'"'+apifnc('express_type',p_express)+apifnc('express_subtype',p_expresssubtype)+apifnc('career',p_career)+apifnc('tariff_type',p_tariff)+' number="'+ansiuppercase(numb2(form1.StringGrid1.Cells[n,0]))+'"'+iscombined+vtitle+' changemode="insert" '+CalcDaysMCC(form1.StringGrid1.Cells[n,1],form1.StringGrid1.Cells[n,n1])+' period_start="'+periodstart0+'" period_end="'+periodend0+'"'+timezone+apifnc('graph',graph0)+apifnc('calendar_geobase_country_id',dcountryid)+' >');
            outfile.add('    <stations>');
            for i:=n1 to n2 do begin
            if (form1.StringGrid1.Cells[n,i]<>'')and(form1.StringGrid1.Cells[0,i]<>'') then begin
              iscombined:='';
              tt:=PrepareTT(form1.StringGrid1.Cells[n,i],i,n1,n2,0);
              if pos('@',form1.StringGrid1.Cells[n,i])>0 then platf:=' platform="'+trim(copy(form1.StringGrid1.Cells[n,i],pos('@',form1.StringGrid1.Cells[n,i])+1,length(form1.StringGrid1.Cells[n,i])-pos('@',form1.StringGrid1.Cells[n,i])))+'"'
                                                         else platf:='';
              while pos(':',platf)>0 do platf[pos(':',platf)]:='.';
              if (strtointe(tt.mfs)<omfs)and(strtointe(tt.st)>0) then log.add(' '+mtrain+'. :  MFS    '+form1.StringGrid1.Cells[1,i]);
              if strtointe(tt.st)>0 then omfs:=strtointe(tt.mfs)+strtointe(tt.st);
              if strtointe(tt.st)>90 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
                else begin
                  if strtointe(tt.st)>45 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
                 end;
              if i=n1 then outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="" stop_time="" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="1" is_searchable_to="0" is_searchable_from="1"/>')
                else begin
//                  if strtointe(tt.mfs)<52 then outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="1" is_searchable_from="0"/>')
                 if strtointe(tt.mfs)<51 then outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="1" is_searchable_from="0"/>')
                 else begin
                  if i=n2 then outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="" departure_time="" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="0" is_searchable_from="0"/>')
                    else begin
                      outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="0" is_searchable_from="0"/>')
                    end;
                 end;
                end;
            end;
            end;
            if StrToIntE(tt.mfs)>1400 then log.add(' '+mtrain+'. : MFS='+tt.mfs+' !!!!!!!!!');
            outfile.add('    </stations>');
            outfile.add('  </thread>');
        end;
     end;
    end;
    /////////////////////////////////////////
  end; //n2>n1
  result:=s;
end;


//    ,  
function CalcThreadMKZD_v1(n,o:integer;outfile:AF_Types.PStrings): WideString;
 var i,n0a,n0,n1,n2,h,m,h1,m1,t,n3,n4,v3,v4,v5,vn1,vn2,qqn,h31,m31,mfs0,mfs1:integer;
 var s:WideString;
 var tt,tt1:TTimetable1;
 var platf,career,tmodel,timezone,dcountryid,iscombined,p_career,p_express,p_expresssubtype,p_tariff,periodstart0,periodend0,graph0,vns,vtitle,qqs,s90:string;
 var kflag:boolean;
 var strnn:string;
begin
  strnn:='error';
  p_career:='';
  p_express:='';
  p_expresssubtype:='';
  p_tariff:='';
  socrmode:=0;
  career:='';
  vtitle:='';
  dcountryid:='225';
  kflag:=false;
  if career_n.count>0 then begin
    for i:=1 to career_n.count do begin
     if pos(career_n.getstring(i),trim(form1.StringGrid1.Cells[0,0]))=1 then begin
       career:=' career="'+career_i.getstring(i)+'"';
       p_career:=career_i.getstring(i);
       dcountryid:=career_t.getstring(i);
       kflag:=true;
       break;
     end;
    end;
  end;
  _stidf:='esrcode';
  _sttt:='etrain';
  tmodel:='';
  timezone:='';
  if ValidStr(ansilowercase(trim(form1.StringGrid1.Cells[1,0]))) then timezone:=' time_zone="'+trim(form1.StringGrid1.Cells[1,0])+'"';
  if ValidStr(ansilowercase(trim(form1.StringGrid1.Cells[1,1]))) then vtitle:=' is_manual_title="1" title="'+trim(form1.StringGrid1.Cells[1,1])+'" title_short="'+trim(form1.StringGrid1.Cells[1,1])+'"';
  if not kflag then log.add(':   !');
  n1:=0;
  n2:=0;
  s:='';
  for i:=2 to form1.stringgrid1.RowCount-1 do begin
    n1:=i;
    if validstr(form1.StringGrid1.Cells[n,i]) then break;
  end;
  n0a:=n1;
  for i:=form1.stringgrid1.RowCount-1 downto 2 do begin
    n2:=i;
    if validstr(form1.StringGrid1.Cells[n,i]) then break;
  end;
  if n2>n1 then begin
    lh:=0;
    lm:=0;
    lmfs:=0;
    omfs:=0;
    mtrain:=form1.StringGrid1.Cells[n,0];
    if not ValidStr(mtrain) then  log.add(' '+mtrain+'. :   !');
    iscombined:='';
    getexpress(form1.StringGrid1.Cells[n,0],p_express,p_expresssubtype,p_career,p_tariff);
    graph0:=ansilowercase(trim(form1.StringGrid1.Cells[0,1]));
    gr2per(graph0,periodstart0,periodend0,_sttt);
    if periodstart0='' then log.add(' '+mtrain+'. :    !         !');
//    outfile.add('  <thread t_type="'+gettype2(form1.StringGrid1.Cells[n,0])+'"'+apifnc('express_type',p_express)+apifnc('express_subtype',p_expresssubtype)+apifnc('career',p_career)+apifnc('tariff_type',p_tariff)+' number="'+ansiuppercase(numb2(form1.StringGrid1.Cells[n,0]))+'"'+iscombined+vtitle+' changemode="insert" '+CalcDays(form1.StringGrid1.Cells[n,1])+' period_start="'+periodstart0+'" period_end="'+periodend0+'"'+timezone+apifnc('graph',graph0)+apifnc('calendar_geobase_country_id',dcountryid)+' >');
//    outfile.add('    <stations>');
    for i:=n1 to n2 do begin
    if (form1.StringGrid1.Cells[n,i]<>'')and(form1.StringGrid1.Cells[0,i]<>'') then begin
      iscombined:='';
      tt:=PrepareTT(form1.StringGrid1.Cells[n,i],i,n1,n2,0);
      if pos('@',form1.StringGrid1.Cells[n,i])>0 then platf:=' platform="'+trim(copy(form1.StringGrid1.Cells[n,i],pos('@',form1.StringGrid1.Cells[n,i])+1,length(form1.StringGrid1.Cells[n,i])-pos('@',form1.StringGrid1.Cells[n,i])))+'"'
                                                 else platf:='';
      while pos(':',platf)>0 do platf[pos(':',platf)]:='.';
      if (strtointe(tt.mfs)<omfs)and(strtointe(tt.st)>0) then log.add(' '+mtrain+'. :  MFS    '+form1.StringGrid1.Cells[1,i]);
      if strtointe(tt.st)>0 then omfs:=strtointe(tt.mfs)+strtointe(tt.st);
      if strtointe(tt.st)>90 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
        else begin
          if strtointe(tt.st)>45 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
         end;
//      outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="1" is_searchable_to="0" is_searchable_from="0"/>');
      if _stlistlog.SearchString(Prep0ESR(form1.StringGrid1.Cells[0,i]))<=0 then _stlistlog.add(Prep0ESR(form1.StringGrid1.Cells[0,i]));
    end;
    end;
    if StrToIntE(tt.mfs)>1400 then log.add(' '+mtrain+'. : MFS='+tt.mfs+' !!!!!!!!!');
//    outfile.add('    </stations>');
//    outfile.add('  </thread>');
    /////////////////////////////////////////
    vn1:=n1;
    vn2:=n2;
    if (vn2-vn1)>1 then begin
     for v3:=vn1 to vn2-1 do begin
      vns:=Form1.StringGrid1.Cells[0,v3];
      for v5:=v3+1 to vn2 do begin
       if Form1.StringGrid1.Cells[0,v5]=vns then break;
      end;
      {if Form1.StringGrid1.Cells[0,v5]=vns then} v5:=v5-1;
        if (form1.StringGrid1.Cells[n,v3]<>'-')and(form1.StringGrid1.Cells[n,v3]<>'')and(form1.StringGrid1.Cells[0,v3]<>'') then begin
//            outfile.add(Form1.StringGrid1.Cells[1,v3]+'-'+Form1.StringGrid1.Cells[1,v5]+' '+Form1.StringGrid1.Cells[n,v5]+'-'+Form1.StringGrid1.Cells[n,v5]+' '+tt1.mfs);
            n1:=v3;
            n2:=v5;
            n0:=n1-10;  //    ""
            if n0<n0a then n0:=n0a;
            lh:=0;
            lm:=0;
            lmfs:=0;
            omfs:=0;
//            outfile.add('n1='+inttostr(n1)+' n2='+inttostr(n2));
            qqn:=n2-n1+1;

/// !!!!!!!!!!     !!!         ,   31
            if qqn<31 then begin
              if ValidStr(ansilowercase(trim(form1.StringGrid1.Cells[1,1]))) then begin
                vtitle:=' is_manual_title="1" title="'+trim(form1.StringGrid1.Cells[1,1])+' ( . '+trim(form1.StringGrid1.Cells[1,n2])+')" title_short="'+trim(form1.StringGrid1.Cells[1,1])+' ( . '+trim(form1.StringGrid1.Cells[1,n2])+')"';
              end;
            end;
            s90:=form1.StringGrid1.Cells[n,n1];
            if pos('/',s90)>1 then s90:=trim(copy(s90,pos('/',s90)+1,length(s90)-pos('/',s90)));
            tohm(s90,h31,m31);

            strnn:='9sept';
            if n1>430 then strnn:='10sept';
            if h31=0 then strnn:='night9-10sept';
            if h31=1 then strnn:='night9-10sept';
            if h31=2 then strnn:='night9-10sept';
            if h31=3 then strnn:='night9-10sept';
            if h31=4 then strnn:='night9-10sept';

{            strnn:='1';
            if ((h31=23)and(n1<100)) then strnn:='31';
            if ((h31=0)and(n1<300)) then strnn:='1n';
            if ((h31=1)and(n1<300)) then strnn:='1n';
            if ((h31=2)and(n1<300)) then strnn:='1n';
            if ((h31=3)and(n1<300)) then strnn:='1n';
            if ((h31=4)and(n1<300)) then strnn:='1n';
            if ((h31=0)and(n1>400)) then strnn:='2n';
            if ((h31=1)and(n1>400)) then strnn:='2n';  }

//            outfile.add('  <thread t_type="'+gettype2(form1.StringGrid1.Cells[n,0])+'"'+apifnc('express_type',p_express)+apifnc('express_subtype',p_expresssubtype)+apifnc('career',p_career)+apifnc('tariff_type',p_tariff)+' number="'+ansiuppercase(numb2(form1.StringGrid1.Cells[n,0]))+'"'+iscombined+vtitle+' changemode="insert" strnn="'+strnn+'" '+CalcDaysMCC(form1.StringGrid1.Cells[n,1],form1.StringGrid1.Cells[n,n1])+' period_start="'+periodstart0+'" period_end="'+periodend0+'"'+timezone+apifnc('graph',graph0)+apifnc('calendar_geobase_country_id',dcountryid)+' >');
            outfile.add('  <thread t_type="'+gettype2(form1.StringGrid1.Cells[n,0])+'"'+apifnc('express_type',p_express)+apifnc('express_subtype',p_expresssubtype)+apifnc('career',p_career)+apifnc('tariff_type',p_tariff)+' number="'+ansiuppercase(numb2(form1.StringGrid1.Cells[n,0]))+'"'+iscombined+vtitle+' changemode="insert" '+CalcDaysMCC(form1.StringGrid1.Cells[n,1],form1.StringGrid1.Cells[n,n0])+' period_start="'+periodstart0+'" period_end="'+periodend0+'"'+timezone+apifnc('graph',graph0)+apifnc('calendar_geobase_country_id',dcountryid)+' >');
            outfile.add('    <stations>');
            for i:=n0 to n2 do begin
            if (form1.StringGrid1.Cells[n,i]<>'')and(form1.StringGrid1.Cells[0,i]<>'') then begin
              iscombined:='';
              tt:=PrepareTT(form1.StringGrid1.Cells[n,i],i,n0,n2,0);
              if pos('@',form1.StringGrid1.Cells[n,i])>0 then platf:=' platform="'+trim(copy(form1.StringGrid1.Cells[n,i],pos('@',form1.StringGrid1.Cells[n,i])+1,length(form1.StringGrid1.Cells[n,i])-pos('@',form1.StringGrid1.Cells[n,i])))+'"'
                                                         else platf:='';
              while pos(':',platf)>0 do platf[pos(':',platf)]:='.';
              if (strtointe(tt.mfs)<omfs)and(strtointe(tt.st)>0) then log.add(' '+mtrain+'. :  MFS    '+form1.StringGrid1.Cells[1,i]);
              if strtointe(tt.st)>0 then omfs:=strtointe(tt.mfs)+strtointe(tt.st);
              if strtointe(tt.st)>90 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
                else begin
                  if strtointe(tt.st)>45 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
                 end;
              if i<n1 then begin
                if i=n0 then begin
                  outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="" stop_time="" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="0" is_searchable_from="0"/>');
                end
                 else begin
                  outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="0" is_searchable_from="0"/>');
                 end;
              end;
              if i=n1 then begin
                if i=n0 then begin
                  outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="" stop_time="" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="1" is_searchable_to="0" is_searchable_from="1"/>');
                  mfs0:=0;
                end
                 else begin
                  outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="1" is_searchable_to="0" is_searchable_from="1"/>');
                  mfs0:=strtointe(tt.mfs)+strtointe(tt.st);
                 end;
              end;
              if i>n1 then begin
                 mfs1:=strtointe(tt.mfs)-mfs0;
//                  if mfs1<52 then outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="1" is_searchable_from="0"/>')
                 if mfs1<51 then outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="1" is_searchable_from="0"/>')
                 else begin
                  if i=n2 then outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="" departure_time="" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="0" is_searchable_from="0"/>')
                    else begin
                      outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="0" is_searchable_from="0"/>')
                    end;
                 end;
              end;
            end;
            end;
            if StrToIntE(tt.mfs)>1400 then log.add(' '+mtrain+'. : MFS='+tt.mfs+' !!!!!!!!!');
            outfile.add('    </stations>');
            outfile.add('  </thread>');
        end;
     end;
    end;
    /////////////////////////////////////////
  end; //n2>n1
  result:=s;
end;

*)

function gettts(s:string):integer;
 var h,m,r:integer;
begin
 h:=0; m:=0;
 if pos('@',s)>0 then s:=copy(s,1,pos('@',s)-1);
 if pos('/',s)>0 then s:=copy(s,pos('/',s)+1,length(s)-pos('/',s));
 s:=trim(s);
 tohm(s,h,m);
 r:=h*60;
 result:=r+m;
end;


//    ,  
function CalcThreadMKZD_v2(n,o:integer;outfile:AF_Types.PStrings): WideString;
 var i,n0a,n0,n1,n2,h,m,h1,m1,t,n3,n4,v3,v4,v5,vn1,vn2,qqn,h31,m31,mfs0,mfs1,skipn:integer;
 var s:WideString;
 var tt,tt1:TTimetable1;
 var platf,career,tmodel,timezone,dcountryid,iscombined,p_career,p_express,p_expresssubtype,p_tariff,periodstart0,periodend0,graph0,vns,vtitle,qqs,s90:string;
 var kflag:boolean;
 var strnn:string;
begin
  skipn:=-1;
  strnn:='error';
  p_career:='';
  p_express:='';
  p_expresssubtype:='';
  p_tariff:='';
  socrmode:=0;
  career:='';
  vtitle:='';
  dcountryid:='225';
  kflag:=false;
  if career_n.count>0 then begin
    for i:=1 to career_n.count do begin
     if pos(career_n.getstring(i),trim(form1.StringGrid1.Cells[0,0]))=1 then begin
       career:=' career="'+career_i.getstring(i)+'"';
       p_career:=career_i.getstring(i);
       dcountryid:=career_t.getstring(i);
       kflag:=true;
       break;
     end;
    end;
  end;
  _stidf:='esrcode';
  _sttt:='etrain';
  tmodel:='';
  timezone:='';
  if ValidStr(ansilowercase(trim(form1.StringGrid1.Cells[1,0]))) then timezone:=' time_zone="'+trim(form1.StringGrid1.Cells[1,0])+'"';
  if ValidStr(ansilowercase(trim(form1.StringGrid1.Cells[1,1]))) then vtitle:=' is_manual_title="1" title="'+trim(form1.StringGrid1.Cells[1,1])+'" title_short="'+trim(form1.StringGrid1.Cells[1,1])+'"';
  if not kflag then log.add(':   !');
  n1:=0;
  n2:=0;
  s:='';
  for i:=2 to form1.stringgrid1.RowCount-1 do begin
    n1:=i;
    if validstr(form1.StringGrid1.Cells[n,i]) then break;
  end;
  n0a:=n1;
  for i:=form1.stringgrid1.RowCount-1 downto 2 do begin
    n2:=i;
    if validstr(form1.StringGrid1.Cells[n,i]) then break;
  end;
  if n2>n1 then begin
    lh:=0;
    lm:=0;
    lmfs:=0;
    omfs:=0;
    mtrain:=form1.StringGrid1.Cells[n,0];
    if not ValidStr(mtrain) then  log.add(' '+mtrain+'. :   !');
    iscombined:='';
    getexpress(form1.StringGrid1.Cells[n,0],p_express,p_expresssubtype,p_career,p_tariff);
    graph0:=ansilowercase(trim(form1.StringGrid1.Cells[0,1]));
    gr2per(graph0,periodstart0,periodend0,_sttt);
    if periodstart0='' then log.add(' '+mtrain+'. :    !         !');
//    outfile.add('  <thread t_type="'+gettype2(form1.StringGrid1.Cells[n,0])+'"'+apifnc('express_type',p_express)+apifnc('express_subtype',p_expresssubtype)+apifnc('career',p_career)+apifnc('tariff_type',p_tariff)+' number="'+ansiuppercase(numb2(form1.StringGrid1.Cells[n,0]))+'"'+iscombined+vtitle+' changemode="insert" '+CalcDays(form1.StringGrid1.Cells[n,1])+' period_start="'+periodstart0+'" period_end="'+periodend0+'"'+timezone+apifnc('graph',graph0)+apifnc('calendar_geobase_country_id',dcountryid)+' >');
//    outfile.add('    <stations>');
    for i:=n1 to n2 do begin
    if (form1.StringGrid1.Cells[n,i]<>'')and(form1.StringGrid1.Cells[0,i]<>'') then begin
      iscombined:='';
      tt:=PrepareTT(form1.StringGrid1.Cells[n,i],i,n1,n2,0);
      if pos('@',form1.StringGrid1.Cells[n,i])>0 then platf:=' platform="'+trim(copy(form1.StringGrid1.Cells[n,i],pos('@',form1.StringGrid1.Cells[n,i])+1,length(form1.StringGrid1.Cells[n,i])-pos('@',form1.StringGrid1.Cells[n,i])))+'"'
                                                 else platf:='';
      while pos(':',platf)>0 do platf[pos(':',platf)]:='.';
      if (strtointe(tt.mfs)<omfs)and(strtointe(tt.st)>0) then log.add(' '+mtrain+'. :  MFS    '+form1.StringGrid1.Cells[1,i]);
      if strtointe(tt.st)>0 then omfs:=strtointe(tt.mfs)+strtointe(tt.st);
      if strtointe(tt.st)>90 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
        else begin
          if strtointe(tt.st)>45 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
         end;
//      outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="1" is_searchable_to="0" is_searchable_from="0"/>');
      if _stlistlog.SearchString(Prep0ESR(form1.StringGrid1.Cells[0,i]))<=0 then _stlistlog.add(Prep0ESR(form1.StringGrid1.Cells[0,i]));
    end;
    end;
    if StrToIntE(tt.mfs)>1400 then log.add(' '+mtrain+'. : MFS='+tt.mfs+' !!!!!!!!!');
//    outfile.add('    </stations>');
//    outfile.add('  </thread>');
    /////////////////////////////////////////
    vn1:=n1;
    vn2:=n2;
    if (vn2-vn1)>1 then begin
     for v3:=vn1 to vn2-1 do begin
      if v3<>skipn then begin
       skipn:=-1;
       vns:=Form1.StringGrid1.Cells[0,v3];
       for v5:=v3+1 to vn2 do begin
        if Form1.StringGrid1.Cells[0,v5]=vns then break;
       end;
        v5:=v5-1;
        if (form1.StringGrid1.Cells[n,v3]<>'-')and(form1.StringGrid1.Cells[n,v3]<>'')and(form1.StringGrid1.Cells[0,v3]<>'') then begin
            n1:=v3;
            n2:=v5;
            n0:=n1-10;  //    ""
            if n0<n0a then n0:=n0a;
            lh:=0;
            lm:=0;
            lmfs:=0;
            omfs:=0;
            qqn:=n2-n1+1;
            if qqn<31 then begin  /// !!!!!!!!!!     !!!         ,   31
              if ValidStr(ansilowercase(trim(form1.StringGrid1.Cells[1,1]))) then begin
                vtitle:=' is_manual_title="1" title="'+trim(form1.StringGrid1.Cells[1,1])+' ( . '+trim(form1.StringGrid1.Cells[1,n2])+')" title_short="'+trim(form1.StringGrid1.Cells[1,1])+' ( . '+trim(form1.StringGrid1.Cells[1,n2])+')"';
              end;
            end;
            if gettts(form1.StringGrid1.Cells[n,n1])<1430 then begin
             if n1<(n2-1) then begin
              skipn:=n1+1; //    
             end;
            end;
            s90:=form1.StringGrid1.Cells[n,n0];
            if pos('/',s90)>1 then s90:=trim(copy(s90,pos('/',s90)+1,length(s90)-pos('/',s90)));
            tohm(s90,h31,m31);
{
            strnn:='9sept';
            if n1>430 then strnn:='10sept';
            if h31=0 then strnn:='night9-10sept';
            if h31=1 then strnn:='night9-10sept';
            if h31=2 then strnn:='night9-10sept';
            if h31=3 then strnn:='night9-10sept';
            if h31=4 then strnn:='night9-10sept';
            strnn:='1';
            if ((h31=23)and(n1<100)) then strnn:='31';
            if ((h31=0)and(n1<300)) then strnn:='1n';
            if ((h31=1)and(n1<300)) then strnn:='1n';
            if ((h31=2)and(n1<300)) then strnn:='1n';
            if ((h31=3)and(n1<300)) then strnn:='1n';
            if ((h31=4)and(n1<300)) then strnn:='1n';
            if ((h31=0)and(n1>400)) then strnn:='2n';
            if ((h31=1)and(n1>400)) then strnn:='2n';
}
            strnn:='ERROR';
            if n1<200 then strnn:='311'
                           else strnn:='0';
//             else begin
//               if (h31 in [0..7]) then strnn:='01'
//                                  else strnn:='31';
//             end;

//            outfile.add('  <thread t_type="'+gettype2(form1.StringGrid1.Cells[n,0])+'"'+apifnc('express_type',p_express)+apifnc('express_subtype',p_expresssubtype)+apifnc('career',p_career)+apifnc('tariff_type',p_tariff)+' number="'+ansiuppercase(numb2(form1.StringGrid1.Cells[n,0]))+'"'+iscombined+vtitle+' changemode="insert" strnn="'+strnn+'" '+CalcDaysMCC(form1.StringGrid1.Cells[n,1],form1.StringGrid1.Cells[n,n0])+' period_start="'+periodstart0+'" period_end="'+periodend0+'"'+timezone+apifnc('graph',graph0)+apifnc('calendar_geobase_country_id',dcountryid)+' >');
            outfile.add('  <thread t_type="'+gettype2(form1.StringGrid1.Cells[n,0])+'"'+apifnc('express_type',p_express)+apifnc('express_subtype',p_expresssubtype)+apifnc('career',p_career)+apifnc('tariff_type',p_tariff)+' number="'+ansiuppercase(numb2(form1.StringGrid1.Cells[n,0]))+'"'+iscombined+vtitle+' changemode="insert" '+CalcDaysMCC(form1.StringGrid1.Cells[n,1],form1.StringGrid1.Cells[n,n0])+' period_start="'+periodstart0+'" period_end="'+periodend0+'"'+timezone+apifnc('graph',graph0)+apifnc('calendar_geobase_country_id',dcountryid)+' >');
            outfile.add('    <stations>');
            for i:=n0 to n2 do begin
            if (form1.StringGrid1.Cells[n,i]<>'')and(form1.StringGrid1.Cells[0,i]<>'') then begin
              iscombined:='';
              tt:=PrepareTT(form1.StringGrid1.Cells[n,i],i,n0,n2,0);
              if pos('@',form1.StringGrid1.Cells[n,i])>0 then platf:=' platform="'+trim(copy(form1.StringGrid1.Cells[n,i],pos('@',form1.StringGrid1.Cells[n,i])+1,length(form1.StringGrid1.Cells[n,i])-pos('@',form1.StringGrid1.Cells[n,i])))+'"'
                                                         else platf:='';
              while pos(':',platf)>0 do platf[pos(':',platf)]:='.';
              if (strtointe(tt.mfs)<omfs)and(strtointe(tt.st)>0) then log.add(' '+mtrain+'. :  MFS    '+form1.StringGrid1.Cells[1,i]);
              if strtointe(tt.st)>0 then omfs:=strtointe(tt.mfs)+strtointe(tt.st);
              if strtointe(tt.st)>90 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
                else begin
                  if strtointe(tt.st)>45 then log.add(' '+mtrain+'. :   '+form1.StringGrid1.Cells[1,i]+'='+tt.st)
                 end;
              if i<n1 then begin
                if i=n0 then begin
                  outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="" stop_time="" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="0" is_searchable_from="0"/>');
                end
                 else begin
                  outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="0" is_searchable_from="0"/>');
                 end;
              end;
              if i=n1 then begin
                if i=n0 then begin
                  outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="" stop_time="" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="1" is_searchable_to="0" is_searchable_from="1"/>');
                  mfs0:=0;
                end
                 else begin
                  outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="1" is_searchable_to="0" is_searchable_from="1"/>');
                  mfs0:=strtointe(tt.mfs)+strtointe(tt.st);
                 end;
              end;
              if i>n1 then begin
               mfs1:=strtointe(tt.mfs)-mfs0;
               if i<>skipn then begin
//                  if mfs1<51 then outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="1" is_searchable_from="0"/>')
                 if mfs1<51 then outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="1" is_searchable_from="0"/>')
                 else begin
                  if i=n2 then outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="" departure_time="" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="0" is_searchable_from="0"/>')
                    else begin
                      outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="0" is_searchable_to="0" is_searchable_from="0"/>')
                    end;
                 end;
               end //<>skipn
                else begin
                  outfile.add('      <station '+_stidf+'="'+Prep0ESR(form1.StringGrid1.Cells[0,i])+'" stname="'+delquot(form1.StringGrid1.Cells[1,i])+'"'+iscombined+' arrival_time="'+tt.t1+'" stop_time="'+tt.st+'" departure_time="'+tt.t2+'" minutes_from_start="'+tt.mfs+'"'+platf+' in_station_schedule="1" is_searchable_to="1" is_searchable_from="1"/>');
                end;
              end;
            end;
            end;
            if StrToIntE(tt.mfs)>1400 then log.add(' '+mtrain+'. : MFS='+tt.mfs+' !!!!!!!!!');
            outfile.add('    </stations>');
            outfile.add('  </thread>');
        end;
       end //skipn
        else skipn:=-1;
     end; //vn3
    end;
    /////////////////////////////////////////
  end; //n2>n1
  result:=s;
end;







function isMKZD:boolean;
begin
  if pos('mckmkzd',ansilowercase(form1.StringGrid1.Cells[0,0]))>0 then result:=true
                                                                    else result:=false;
end;

function numb2(s:string):string;
begin
  s:=trim(AnsiLowerCase(s));
  if pos('#',s)>0 then begin
    s:=copy(s,1,pos('#',s)-1);
  end;
  if pos('^',s)>0 then delete(s,pos('^',s),1);
  result:=trim(s);
end;

procedure LoadExpress;
  var f,u:AF_Types.TStrings;
  var i:integer;
begin
  f.create; u.create;
  expr_id.clear;
  expr_type.clear;
  expr_sub.clear;
  expr_career.clear;
  expr_tariff.clear;
  if fileexists(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\express.ini') then begin
    f.loadfromfile(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\express.ini');
    if f.count>0 then begin
     for i:=1 to f.count do begin
      ParseCSVStrEx(@u,ansilowercase(f.getstring(i)),';');
      if u.count>1 then begin
       if validstr(u.getstring(1)) then begin
         expr_id.add(u.getstring(1));
         expr_type.add(u.getstring(2));
         expr_sub.add(u.getstring(3));
         expr_career.add(u.getstring(4));
         expr_tariff.add(u.getstring(5));
       end;
      end;
     end;
    end;
  end
   else begin
     ShowMessage('   express.ini (  )!');
     Halt(2);
   end;
  f.free; u.free;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
 var ts,ts1,outfile:AF_Types.TStrings;
 var p,s,d,career,edir:string;
 var i,i1,n,o,ff:integer;
 var WorkBk : _WorkBook;
 var WorkSheet : _WorkSheet;
 var X, Y, xx, yy, wshs : Integer;
 var IIndex : OleVariant;
 var NomFich : WideString;
 var nf,s0:string;
 var tf:double;
 var vr,pflag,mkzdflag:boolean;
begin
  outfile.create;
  _stlistlog.clear;
  LoadCareers;
  LoadExpress;
  ts.create;
  ts1.create;
  log.clear;
  if OpenDialog1.Execute then begin
  edir:=ExtractDirPath(OpenDialog1.Files.Strings[0]);
  edisp.clear;
  ProgressBar1.Max:=OpenDialog1.Files.Count;
  vr:=false;
                        SaveDialog1.InitialDir:=edir;
                        SaveDialog1.FileName:='';
                        if SaveDialog1.Execute then vr:=true;
  if vr then begin
        outfile.clear;
        outfile.add('<?xml version="1.0" encoding="Windows-1251"?>');
        outfile.add('');
        DateTimeToString(d,'yyyy-mm-dd hh:nn:ss',date+time);
        outfile.add('<channel date="'+d+'" prog="msk2xml" progver="'+pversion+'" ver="3">');
  for ff:=0 to OpenDialog1.Files.Count-1 do begin
    log.add(' : '+ExtractFileName(OpenDialog1.Files.Strings[ff]));
    StatusBar1.SimpleText:=': '+ExtractFileName(OpenDialog1.Files.Strings[ff])+'.'+ExtractFileExtention(OpenDialog1.Files.Strings[ff]);
mkzdflag:=false;
ProgressBar2.Position:=0;
NomFich := OpenDialog1.Files.Strings[ff];
IIndex := 1;
pflag:=false;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
//WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
for wshs:=1 to WorkBk.WorkSheets.Count do begin
WorkSheet := WorkBk.Sheets[wshs] as _WorkSheet;
WorkSheet.Activate(0);
log.add('    '+inttostr(wshs)+' ('+WorkSheet.Name+')');
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
ClearSG;
StringGrid1.ColCount := Y;
StringGrid1.RowCount := X;
ProgressBar2.Max:=X;
for xx:=1 to x do begin
  for yy:=1 to y do begin
    nf:=worksheet.cells.item[xx,yy].NumberFormat;
    if (pos('::',nf)>0)or(nf=':')or(nf=':')or(nf='h:mm')or(nf='hh:mm;@')or(nf=':;@')or(nf=':;@')or(nf='h:mm;@')or(nf='hh:mm;@')or(nf='[]:')or(nf='[]:') then begin
//       s0:=VarToStr(worksheet.cells.item[xx,yy]);
//       nf:=s0;
       tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xx,yy]),70);
       if tf=70 then stringgrid1.Cells[yy-1,xx-1]:=VarToStrDef(worksheet.cells.item[xx,yy],'')
                else stringgrid1.Cells[yy-1,xx-1]:=FormatDateTime('hh:nn',tf);
    end
     else begin
       if (xx>2)and(yy>2) then stringgrid1.Cells[yy-1,xx-1]:=PrepareStr1(Trim(VarToStrDef(worksheet.cells.item[xx,yy],'')))
                          else stringgrid1.Cells[yy-1,xx-1]:=PrepareStr2(Trim(VarToStrDef(worksheet.cells.item[xx,yy],'')));
     end;
  end;
  ProgressBar2.Position:=xx;
  Application.ProcessMessages;
end;
    ///
    if length(StringGrid1.Cells[0,0])<1 then log.add('    (0,0)!');
    if length(StringGrid1.Cells[0,1])<1 then log.add('  !');
    if StringGrid1.RowCount>2 then begin
      for i:=2 to StringGrid1.ColCount-1 do begin
        for i1:=2 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,i1]:=PrepareTTime(StringGrid1.Cells[i,i1]);
        StringGrid1.Cells[i,0]:=AnsiLowerCase(StringGrid1.Cells[i,0]);
        StringGrid1.Cells[i,1]:=AnsiLowerCase(StringGrid1.Cells[i,1]);
      end;
        p:='';
        o:=0;
          ts1.clear;
          for n:=2 to 301 do begin
           if ((StringGrid1.Cells[n,0]<>'')and(pos('_',StringGrid1.Cells[n,1])=0)and(AnsiLowerCase(StringGrid1.Cells[n,1])<>'')) then begin
                 outfile.add('');
                 if isMKZD then begin
                             CalcThreadMKZD_v2(n,o,@outfile);
                             mkzdflag:=true;
                           end
                           else CalcThread(n,o,@outfile);
           end;
           if pos('_',StringGrid1.Cells[n,1])>0 then begin
             if not pflag then log.add(':  ,   !');
             pflag:=true;
           end;
          end;
        log.add('  ..... ');
    end;
    ///
end;

if mkzdflag then log.add('  :     -!');

        ProgressBar1.Position:=ff+1;
XLApp.Quit;
XLApp.Disconnect;
ProgressBar2.Position:=0;
    ///
  end;
        outfile.add('');
        outfile.add('</channel>');
        outfile.savetofile(savedialog1.filename);
    edisp.savetofile({edir+}extractfilename(savedialog1.filename)+'.trlist.csv');
  //    _stlistlog.savetofile({edir+}extractfilename(savedialog1.filename)+'.stlist.csv');
        if log.count>0 then begin
          StatusBar1.SimpleText:=' !';
          Application.ProcessMessages;
          form3.listbox1.items.clear;
          for i:=1 to log.count do form3.ListBox1.Items.Add(log.getstring(i));
          form3.ShowModal;
        end
         else StatusBar1.SimpleText:=' !';
  end;
  end;
  ts1.free;
  ts.free;
  ProgressBar1.position:=0;
  ProgressBar2.position:=0;
  outfile.free;
end;

procedure TForm1.Button1Click(Sender: TObject);
 var i,n:integer;
 var s:string;
begin
{  n:=Memo1.Lines.Count-1;
  for i:=0 to n do begin
      s:=memo1.lines.strings[i];
      s:=CalcDays(s);
      memo1.Lines.add(memo1.Lines.Strings[i]+' => '+s);
  end;}
end;

procedure TForm1.FormCreate(Sender: TObject);
 var ts,u:AF_Types.TStrings;
 var i:integer;
 var s,s1:string;
begin
  career_n.create; career_i.create;  career_t.create;
  expr_id.create; expr_type.create; expr_sub.create; expr_career.create; expr_tariff.create;
  _grname.create; _grps.create; _grpe.create;
  _stlistlog.create;
  _stidf:='esrcode';
  _sttt:='etrain';
  ts.create;
  u.create;
  ts.loadfromfile(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\graph.ini');
  if ts.count>0 then begin
   for i:=1 to ts.count do begin
     ParseCSVStrEx(@u,ts.getstring(i),';');
     if u.count>2 then begin
      if ((ValidStr(u.getstring(1)))and(ValidStr(u.getstring(2)))and(ValidStr(u.getstring(3)))) then begin
        _grname.add(ansilowercase(u.getstring(1)));
        _grps.add(u.getstring(2));
        _grpe.add(u.getstring(3));
      end;
     end;
   end;
  end;
  if _grname.count<1 then begin
    ShowMessage('  graph.ini    !');
    halt(1);
  end;
  form1.Caption:=form1.Caption+' '+pversion;
  log.Create;
  edisp.create;
  ts.free;
  u.free;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  log.free;
  edisp.free;
  career_n.free; career_i.free;  career_t.free;
  expr_id.free; expr_type.free; expr_sub.free; expr_career.free; expr_tariff.free;
  _grname.free; _grps.free; _grpe.free;
  _stlistlog.free;
end;

end.
