unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, Grids, Buttons, AF_Proc, AF_Types, FileCtrl, StdCtrls, ShellAPI;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    SaveDialog1: TSaveDialog;
    N5: TMenuItem;
    N6: TMenuItem;
    SaveDialog2: TSaveDialog;
    OpenDialog1: TOpenDialog;
    N7: TMenuItem;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    N8: TMenuItem;
    N9: TMenuItem;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    SpeedButton9: TSpeedButton;
    N10: TMenuItem;
    SpeedButton10: TSpeedButton;
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure StringGrid1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure N4Click(Sender: TObject);
    procedure N3Click(Sender: TObject);
    procedure N2Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure N7Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure N8Click(Sender: TObject);
    procedure N6Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure N9Click(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SpeedButton9Click(Sender: TObject);
    procedure N10Click(Sender: TObject);
    procedure SpeedButton10Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  _esrid,_yid,_stlistx,_stblock,_trnlist:AF_Types.TStrings;
  _infile:string;
  _fccount:integer;
  _editflag:boolean;
  pzn:string;
  _fname:string;

implementation

uses Unit2, Unit3, Unit4;

{$R *.dfm}


function DigitToHex(Digit: Integer): Char;
begin
case Digit of
0..9: Result := Chr(Digit + Ord('0'));
10..15: Result := Chr(Digit - 10 + Ord('A'));
else
Result := '0';
end;
end; // DigitToHex

function URLEncodeUTF8(S: string): string;
  var s1:string;
  var i:integer;
begin
  s:=AnsiToUtf8(s);
  s1:='';
  if length(s)>0 then begin
    for i:=1 to length(s) do s1:=s1+'%'+copy(Dec2Hex(ord(s[i])),3,2);
  end;
  result:=s1;
end;


function URLEncode(S: string): string;
var
i, idx, len: Integer;
begin
len := 0;
for i := 1 to Length(S) do
  if s[i]=' ' then s[i]:='+';
for i := 1 to Length(S) do
if ((S[i] >= '0') and (S[i] <= '9')) or
((S[i] >= 'A') and (S[i] <= 'Z')) or
((S[i] >= 'a') and (S[i] <= 'z')) or (S[i] = ' ') or
(S[i] = '_') or (S[i] = '*') or (S[i] = '-') or (S[i] = '.') or (S[i] = '/') or (S[i] = '=') or (S[i] = '?') or (S[i] = ':') or (S[i] = '%') or (S[i] = '&') or (S[i] = '+')  then
len := len + 1
else
len := len + 3;
SetLength(Result, len);
idx := 1;
for i := 1 to Length(S) do
if S[i] = ' ' then
begin
Result[idx] := '+';
idx := idx + 1;
end
else if ((S[i] >= '0') and (S[i] <= '9')) or
((S[i] >= 'A') and (S[i] <= 'Z')) or
((S[i] >= 'a') and (S[i] <= 'z')) or
(S[i] = '_') or (S[i] = '*') or (S[i] = '-') or (S[i] = '.') or (S[i] = '/') or (S[i] = '=') or (S[i] = '?') or (S[i] = ':') or (S[i] = '%') or (S[i] = '&') or (S[i] = '+')   then
begin
Result[idx] := S[i];
idx := idx + 1;
end
else
begin
Result[idx] := '%';
Result[idx + 1] := DigitToHex(Ord(S[i]) div 16);
Result[idx + 2] := DigitToHex(Ord(S[i]) mod 16);
idx := idx + 3;
end;
end; // URLEncode

function URLDecode(const S: string): string;
var
i, idx, len, n_coded: Integer;
function WebHexToInt(HexChar: Char): Integer;
begin
if HexChar < '0' then
Result := Ord(HexChar) + 256 - Ord('0')
else if HexChar <= Chr(Ord('A') - 1) then
Result := Ord(HexChar) - Ord('0')
else if HexChar <= Chr(Ord('a') - 1) then
Result := Ord(HexChar) - Ord('A') + 10
else
Result := Ord(HexChar) - Ord('a') + 10;
end;
begin
len := 0;
n_coded := 0;
for i := 1 to Length(S) do
if n_coded >= 1 then
begin
n_coded := n_coded + 1;
if n_coded >= 3 then
n_coded := 0;
end
else
begin
len := len + 1;
if S[i] = '%' then
n_coded := 1;
end;
SetLength(Result, len);
idx := 0;
n_coded := 0;
for i := 1 to Length(S) do
if n_coded >= 1 then
begin
n_coded := n_coded + 1;
if n_coded >= 3 then
begin
Result[idx] := Chr((WebHexToInt(S[i - 1]) * 16 +
WebHexToInt(S[i])) mod 256);
n_coded := 0;
end;
end
else
begin
idx := idx + 1;
if S[i] = '%' then
n_coded := 1;
if S[i] = '+' then
Result[idx] := ' '
else
Result[idx] := S[i];
end;
end; // URLDecode



function ESR2Yid(s:string;mode:integer):string;
  var n:integer;
begin
  if length(s)=5 then s:='0'+s;
  n:=_esrid.SearchString(s);
  if n>0 then result:=_yid.getstring(n)
   else begin
     result:='';
     if mode>0 then showmessage('  - '+s);
   end;
end;

procedure ClearSG;
  var i,n:integer;
begin
  for n:=1 to Form1.StringGrid1.RowCount-1 do
   for i:=0 to Form1.StringGrid1.ColCount-1 do
     Form1.StringGrid1.Cells[i,n]:='';
end;

procedure ParseCSVStr(ts:AF_Types.PStrings; s:widestring);
 var n:integer;
begin
  ts.clear;
  while pos(';',s)>0 do begin
    n:=pos(';',s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;



procedure TForm1.FormResize(Sender: TObject);
begin
  StringGrid1.Width:=form1.Width-27;
  StringGrid1.Height:=form1.Height-95;
  SpeedButton4.Left:=form1.Width-48;
  SpeedButton3.Left:=form1.Width-78;
  SpeedButton2.Left:=form1.Width-108;
  SpeedButton6.Left:=form1.Width-138;
  SpeedButton5.Left:=form1.Width-168;
  SpeedButton1.Left:=form1.Width-198;
  SpeedButton8.Left:=form1.Width-228;
  SpeedButton7.Left:=form1.Width-258;
end;

{function LoadESRs:boolean;
  var s,s1,s2:string;
  var t:TextFile;
  var n1,n2:integer;
begin
  _esrid.clear;
  _yid.clear;
  assignfile(t,ExtractDirPath(Application.ExeName)+'\esr_stations.csv');
  reset(t);
   while not eof(t) do begin
     readln(t,s);
     if pos(';',s)>0 then begin
       s1:=copy(s,1,pos(';',s)-1);
       s2:=copy(s,pos(';',s)+1,length(s)-pos(';',s));
       n1:=StrToIntE(s1);
       n2:=StrToIntE(s2);
       if (n1>0) and (n2>0) then begin
         _esrid.add(s1);
         _yid.add(s2);
       end;
     end;
   end;
  closefile(t);
  if _esrid.count>0 then result:=true
                    else result:=false;
end;}

function LoadESRs2:boolean;
  var s,s1,s2:string;
  var t:TextFile;
  var n1,n2:integer;
  var x:AF_Types.TStrings;
begin
  x.create;
  _esrid.clear;
  _yid.clear;
  if fileexists(ExtractDirPath(Application.ExeName)+'\esr_stations.csv') then begin
  assignfile(t,ExtractDirPath(Application.ExeName)+'\esr_stations.csv');
  reset(t);
   while not eof(t) do begin
     readln(t,s);
     ParseCSVStr(@x,s);
     if x.count>3 then begin
       if strtointe(x.getstring(1))>0 then begin
         _esrid.add(x.getstring(2));
         _yid.add(x.getstring(1));
         if strtointe(x.getstring(4))>0 then _stblock.add(x.getstring(1));
       end;
     end;
   end;
  closefile(t);
  end;
  x.free;
  if _esrid.count>0 then result:=true
                    else result:=false;
end;

procedure TForm1.FormCreate(Sender: TObject);
 var i:integer;
begin
 _editflag:=false;
 _fname:='';
 for i:=1 to StringGrid1.ColCount-1 do stringgrid1.cells[i,0]:=inttostr(i);
 StringGrid1.Cells[17,0]:='17 ()';
 StringGrid1.Cells[0,0]:='';
 StringGrid1.Cells[0,1]:='Z';
 _esrid.create;
 _yid.create;
 _stblock.create;
 _stlistx.create;
 _trnlist.create;
// _stblock.loadfromfile(deleteslasheex(extractdirpath(Application.ExeName))+'\block.csv');
 if not LoadESRs2 then begin
   ShowMessage('   - ( esr_stations.csv)!');
   halt(1);
 end;
end;

procedure TForm1.StringGrid1KeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
  var i,n:integer;
  var ts:AF_Types.TStrings;
  var s,s1:string;
begin
  _editflag:=true;
  if key=115 then begin
    if StringGrid1.Row>0 then begin
      form4.labelededit1.Text:='';
      form4.labelededit2.Text:='';
      form4.labelededit3.Text:='';
      form4.labelededit4.Text:='';
      form4.labelededit5.Text:='';
      form4.labelededit6.Text:='';
      s:=trim(stringgrid1.Cells[stringgrid1.Col,stringgrid1.Row]);
      if pos('^',s)>0 then begin
        form4.labelededit1.Text:=trim(copy(s,1,pos('^',s)-1));
        s:=trim(copy(s,pos('^',s)+1,length(s)-pos('^',s)));
      end;
      if pos('$',s)>0 then begin
        form4.labelededit6.Text:=trim(copy(s,pos('$',s)+1,length(s)-pos('$',s)));
        s:=trim(copy(s,1,pos('$',s)-1));
      end;
      if pos('@',s)>0 then begin
        form4.labelededit5.Text:=trim(copy(s,pos('@',s)+1,length(s)-pos('@',s)));
        s:=trim(copy(s,1,pos('@',s)-1));
      end;
      if pos('&',s)>0 then begin
        form4.labelededit4.Text:=trim(copy(s,pos('&',s)+1,length(s)-pos('&',s)));
        s:=trim(copy(s,1,pos('&',s)-1));
      end;
      if pos('#',s)>0 then begin
        form4.labelededit3.Text:=trim(copy(s,pos('#',s)+1,length(s)-pos('#',s)));
        s:=trim(copy(s,1,pos('#',s)-1));
      end;
      form4.labelededit2.Text:=trim(s);
      unit4.reslt:=false;
      form4.showmodal;
      if unit4.reslt then begin
        s:=trim(form4.LabeledEdit2.Text);
        if validstr(form4.LabeledEdit1.Text) then s:=trim(form4.LabeledEdit1.Text)+'^'+s;
        if validstr(form4.LabeledEdit3.Text) then s:=s+'#'+trim(form4.LabeledEdit3.Text);
        if validstr(form4.LabeledEdit4.Text) then s:=s+'&'+trim(form4.LabeledEdit4.Text);
        if validstr(form4.LabeledEdit5.Text) then s:=s+'@'+trim(form4.LabeledEdit5.Text);
        if validstr(form4.LabeledEdit6.Text) then s:=s+'$'+trim(form4.LabeledEdit6.Text);
//        if s<>trim(stringgrid1.Cells[stringgrid1.Col,stringgrid1.Row]) then showmessage('!');
        stringgrid1.Cells[stringgrid1.Col,stringgrid1.Row]:=s;
      end;
    end;
  end;
  if key=114 then begin
  ts.create;
  if StringGrid1.Row>0 then begin
    form2.showmodal;
    if unit2.res then begin
     n:=StringGrid1.Row;
     if form2.CheckBox1.Checked then begin
      for i:=form2.Memo1.Lines.Count-1 downto 0 do begin
        ParseCSVStr(@ts,form2.Memo1.Lines.Strings[i]);
        if ts.count>2 then begin
          if (strtointe(ts.getstring(3)) in [1..2]) then form1.StringGrid1.Cells[StringGrid1.col,n]:=ts.getstring(2)+'&'+ts.getstring(1)
                                       else form1.StringGrid1.Cells[StringGrid1.col,n]:='20^'+ts.getstring(2)+'&'+ts.getstring(1);
          inc(n);
        end;
        if n>=StringGrid1.RowCount then break;
      end;
     end
     else begin
      for i:=0 to form2.Memo1.Lines.Count-1 do begin
        ParseCSVStr(@ts,form2.Memo1.Lines.Strings[i]);
        if ts.count>2 then begin
          if (strtointe(ts.getstring(3)) in [1..2]) then form1.StringGrid1.Cells[StringGrid1.col,n]:=ts.getstring(2)+'&'+ts.getstring(1)
                                       else form1.StringGrid1.Cells[StringGrid1.col,n]:='20^'+ts.getstring(2)+'&'+ts.getstring(1);
//          form1.StringGrid1.Cells[StringGrid1.col,n]:=ts.getstring(2)+'&'+ts.getstring(1);
          inc(n);
        end;
        if n>=StringGrid1.RowCount then break;
      end;
     end;
    end;
  end;
  ts.free;
  end;
end;

function isValidStr(n:integer):boolean;
  var i,k:integer;
begin
  k:=0;
  for i:=0 to form1.StringGrid1.ColCount-1 do
    if length(form1.StringGrid1.Cells[i,n])>0 then inc(k);
  if k>0 then result:=true
         else result:=false;
end;

function toUTF8(s:string; mode:integer):string;
begin
  if mode>0 then result:=AnsiToUtf8(s)
            else result:=s;
end;

Function PrepESR(s:string):string;
begin
//  if length(s)=5 then result:='0'+s
//                 else result:=s;
  result:=s;
end;

Function ExportToHTML(mode:integer; fno:string):boolean;
  var t:TextFile;
  var s,s2,sa,st,si,sm,z3,z4,iurl,outfile,sdir,sdir1,yid2,outt:string;
  var i,k,ss,n1,n2,z1,z2:integer;
  var z,zf,sflag,tout:boolean;
begin
  if mode=0 then iurl:=''
            else iurl:='%(MEDIA_URL)s';
  if (mode=2) or (fno<>'') then begin
    sflag:=true;
    outfile:=fno;
  end
   else begin
     sflag:=form1.savedialog1.Execute;
     outfile:=form1.SaveDialog1.FileName;
   end;
//with form1 do begin
  if sflag then begin
    z1:=0;
    z2:=0;
    for n1:=1 to form1.StringGrid1.RowCount-1 do begin
      if isValidStr(n1) then break;
    end;
    for n2:=form1.StringGrid1.RowCount-1 downto 1 do begin
      if isValidStr(n2) then break;
    end;
    if n2>n1 then begin
     for i:=n1 to n2 do begin
       z1:=i;
       if length(form1.StringGrid1.Cells[0,i])>0 then break;
     end;
     for i:=n2 downto n1 do begin
       z2:=i;
       if length(form1.StringGrid1.Cells[0,i])>0 then break;
     end;
    AssignFile(t,outfile);
    ReWrite(t);
    if mode=0 then begin
    WriteLn(t,'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"');
    WriteLn(t,'        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">');
    WriteLn(t,'<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ru">');
    WriteLn(t,'<head>');
    WriteLn(t,'    <meta http-equiv="Content-Type" content="text/html;charset=Windows-1251"/>');
    WriteLn(t,'    <title>.:  </title>');
    WriteLn(t,'');
    WriteLn(t,'    <!--  MSIE8    MSIE7 -->');
    WriteLn(t,'    <meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7"/>');
    WriteLn(t,'');
    WriteLn(t,'    <!--[if gt IE 7]><!--><link rel="stylesheet" href="css/_rasp.css" type="text/css"/><!--<![endif]-->');
    WriteLn(t,'    <!--[if lt IE 8]><link rel=stylesheet href="css/_rasp.ie.css" type="text/css" /><![endif]-->');
    WriteLn(t,'');
    WriteLn(t,'</head>');
    WriteLn(t,'<body style="padding: 20px;">');
    WriteLn(t,'');
    WriteLn(t,'    <div class="b-scheme">');
    WriteLn(t,'');
    end;
    zf:=false;
    z:=false;
      for i:=n1 to n2 do begin
       if isValidStr(i) then begin
        if length(form1.StringGrid1.Cells[0,i])>0 then begin
          if z then z3:='zone_2'
               else z3:='zone_1';
          z:=not z;
          if i=z1 then begin
           if i=z2 then z4:=' zone_first zone_last'
                   else z4:=' zone_first'
          end
           else begin
            if i=z2 then begin
              z4:=' zone_last';
            end
             else begin
               z4:='';
             end;
           end;
          if zf then WriteLn(t,'        </div>');
          WriteLn(t,'        <div class="'+z3+z4+' g-line">');
          if form1.StringGrid1.Cells[0,i]='X' then WriteLn(t,toUTF8('            <b class="num"><span> </span></b>',mode))
            else begin
              if form1.StringGrid1.Cells[0,i]='Z' then WriteLn(t,toUTF8('            <b class="num"><span></span></b>',mode))
                else WriteLn(t,toUTF8('            <b class="num">'+form1.StringGrid1.Cells[0,i]+' <span></span></b>',mode));
            end;
          zf:=true;
        end;
        WriteLn(t,'            <div class="row g-line">');
          for k:=1 to form1.StringGrid1.ColCount-1 do begin
            outt:='';
            sa:='';
            si:='';
            st:='';
            sm:='';
            case Length(form1.StringGrid1.Cells[k,i]) of
              0: begin
                WriteLn(t,'                <i class="item"></i>');
              end;
              1: begin
                s:=form1.StringGrid1.Cells[k,i];
                case s[1] of
                  '-' : begin
                          WriteLn(t,'                <i class="item"><img src="'+iurl+'i/b-scheme/rl.png" alt="" /></i>');
                        end;
                  '|' : begin
                          WriteLn(t,'                <i class="item"><img src="'+iurl+'i/b-scheme/tb.png" alt="" /></i>');
                        end;
                  '7' : begin
                          WriteLn(t,'                <i class="item"><img src="'+iurl+'i/b-scheme/rb_c.png" alt="" /></i>');
                        end;
                  '9' : begin
                          WriteLn(t,'                <i class="item"><img src="'+iurl+'i/b-scheme/bl_c.png" alt="" /></i>');
                        end;
                  '5' : begin
                          WriteLn(t,'                <i class="item"><img src="'+iurl+'i/b-scheme/trbl.png" alt="" /></i>');
                        end;
                  '1' : begin
                          WriteLn(t,'                <i class="item"><img src="'+iurl+'i/b-scheme/tr_c.png" alt="" /></i>');
                        end;
                  '3' : begin
                          WriteLn(t,'                <i class="item"><img src="'+iurl+'i/b-scheme/tl_c.png" alt="" /></i>');
                        end;
                  '6' : begin
                          WriteLn(t,'                <i class="item"><img src="'+iurl+'i/b-scheme/trb.png" alt="" /></i>');
                        end;
                  '4' : begin
                          WriteLn(t,'                <i class="item"><img src="'+iurl+'i/b-scheme/tbl.png" alt="" /></i>');
                        end;
                  '8' : begin
                          WriteLn(t,'                <i class="item"><img src="'+iurl+'i/b-scheme/rbl.png" alt="" /></i>');
                        end;
                  '2' : begin
                          WriteLn(t,'                <i class="item"><img src="'+iurl+'i/b-scheme/trl.png" alt="" /></i>');
                        end;
                  't' : begin
                          WriteLn(t,'                <i class="item g-png"><img src="'+iurl+'i/b-scheme/b_f.png" alt="" /></i>');
                        end;
                  'b' : begin
                          WriteLn(t,'                <i class="item g-png"><img src="'+iurl+'i/b-scheme/t_f.png" alt="" /></i>');
                        end;
                  'l' : begin
                          WriteLn(t,'                <i class="item g-png"><img src="'+iurl+'i/b-scheme/r_f.png" alt="" /></i>');
                        end;
                  'r' : begin
                          WriteLn(t,'                <i class="item g-png"><img src="'+iurl+'i/b-scheme/l_f.png" alt="" /></i>');
                        end;
                  else begin
                    WriteLn(t,'                <i class="item"></i>');
                  end;
                end;
              end;
              else begin
                tout:=false;
                s:=form1.StringGrid1.Cells[k,i];
                si:='tb_s.png';
                if pos('^',s)>0 then begin
                  s2:=copy(s,1,pos('^',s)-1);
                  ss:=strtointe(s2);
                    case ss of
                      0: si:='tb_s.png';
                      100: begin  si:='rl_s.png'; sm:=' item_r'; end;
                      8: si:='b_s.png';
                      2: si:='t_s.png';
                      108: begin si:='brl_s.png'; sm:=' item_r'; end;
                      102: begin si:='trl_s.png'; sm:=' item_r'; end;
                      4: si:='tbl_s.png';
                      1: si:='tr_s.png';
                      3: si:='tl_s.png';
                      7: si:='rb_s.png';
                      9: si:='bl_s.png';
                      5: begin si:='trbl_s.png'; sm:=' item_r'; end;
                      6: begin si:='trb_s.png'; sm:=' item_r'; end;
                      110: begin si:='rl_s1.png'; sm:=' item_r'; end;
                      10: si:='tb_s1.png';
                      18: si:='b_s1.png';
                      12: si:='t_s1.png';
                      118: begin si:='brl_s1.png'; sm:=' item_r'; end;
                      112: begin si:='trl_s1.png'; sm:=' item_r'; end;
                      14: si:='tbl_s1.png';
                      11: si:='tr_s1.png';
                      13: si:='tl_s1.png';
                      17: si:='rb_s1.png';
                      19: si:='bl_s1.png';
                      15: begin si:='trbl_s1.png'; sm:=' item_r'; end;
                      16: begin si:='trb_s1.png'; sm:=' item_r'; end;
                      120: begin si:='rl_m1.png'; sm:=' item_r'; end;
                      20: si:='tb_m1.png';
                      28: si:='b_m1.png';
                      22: si:='t_m1.png';
                      128: begin si:='brl_m1.png'; sm:=' item_r'; end;
                      122: begin si:='trl_m1.png'; sm:=' item_r'; end;
                      24: si:='tbl_m1.png';
                      21: si:='tr_m1.png';
                      23: si:='tl_m1.png';
                      27: si:='rb_m1.png';
                      29: si:='bl_m1.png';
                      25: begin si:='trbl_m1.png'; sm:=' item_r'; end;
                      26: begin si:='trb_m1.png'; sm:=' item_r'; end;
                      130: begin si:='rl_m.png'; sm:=' item_r'; end;
                      30: si:='tb_m.png';
                      38: si:='b_m.png';
                      32: si:='t_m.png';
                      138: begin si:='brl_m.png'; sm:=' item_r'; end;
                      132: begin si:='trl_m.png'; sm:=' item_r'; end;
                      34: si:='tbl_m.png';
                      31: si:='tr_m.png';
                      33: si:='tl_m.png';
                      37: si:='rb_m.png';
                      39: si:='bl_m.png';
                      35: begin si:='trbl_m.png'; sm:=' item_r'; end;
                      36: begin si:='trb_m.png'; sm:=' item_r'; end;
                      84: begin tout:=true; si:='r_f.png'; sm:=' out out_r'; end;
                      86: begin tout:=true; si:='l_f.png'; sm:=' out out_l'; end;
                      82: begin tout:=true; si:='t_f.png'; sm:=' out'; end;
                      88: begin tout:=true; si:='b_f.png'; sm:=' out'; end;
                      else si:='tb_s.png';
                    end;
                  s:=copy(s,pos('^',s)+1,length(s)-pos('^',s));
                end;
                if pos('&',s)>0 then begin
                  st:=copy(s,1,pos('&',s)-1);
                  sa:=copy(s,pos('&',s)+1,length(s)-pos('&',s));
                end
                 else st:=s;
                if pos('#',st)>0 then begin
                  sdir1:='&subdir='+urlencodeutf8(copy(st,pos('#',st)+1,length(st)-pos('#',st)));
                  st:=copy(st,1,pos('#',st)-1);
                  sdir:=ExtractFileName(_infile);
                end
                 else begin
                   sdir:=ExtractFileName(_infile);
                   sdir1:='';
                 end;

                WriteLn(t,'                <i class="item'+sm+'"> <!-- center -->');
{                if tout then begin
                  if sa='' then WriteLn(t,toUTF8('                        <span class="out '+outt+'">'+st+'</span>',mode))
                           else WriteLn(t,toUTF8('                        <span class="out '+outt+'"><a href="'+URLEncode(sa)+'">'+st+'</a></span>',mode));
                end
                else begin
}//                  WriteLn(t,'                    <a href="/tablo/station/esr/'+PrepESR(sa)+'?span=schedule&direction='+ExtractFileName(form1.OpenDialog1.FileName)+'&type=suburban">');
                if tout then begin
                  if sa='' then begin
                              WriteLn(t,toUTF8('                        <span>'+st+'</span>',mode));
                              WriteLn(t,'                        <i class="g-png "><img src="'+iurl+'i/b-scheme/'+si+'" alt="" /></i>');
                           end
                           else begin
                              WriteLn(t,toUTF8('             <a href="'+URLEncode(sa)+'">',mode));
                              WriteLn(t,toUTF8('                        <span>'+st+'</span>',mode));
                              WriteLn(t,'                        <i class="g-png "><img src="'+iurl+'i/b-scheme/'+si+'" alt="" /></i>');
                              WriteLn(t,'                    </a>');
                           end;
                end
                 else begin
                  yid2:=ESR2Yid(PrepESR(sa),mode);
                  if _stblock.SearchString(yid2)=0 then WriteLn(t,'                    <a href="/tablo/station/'+yid2+'?span=schedule&direction='+sdir+sdir1+'&type=suburban">');
                  WriteLn(t,toUTF8('                        <span>'+st+'</span>',mode));
                  if _stlistx.SearchString(yid2)=0 then _stlistx.add(yid2);
                  WriteLn(t,'                        <img src="'+iurl+'i/b-scheme/'+si+'" alt="" />');
                  if _stblock.SearchString(yid2)=0 then WriteLn(t,'                    </a>');
                 end;
                WriteLn(t,'                </i>');
              end;
            end;
          end;
        WriteLn(t,'            </div>');
       end;
      end;
    WriteLn(t,'');
    if zf then WriteLn(t,'        </div>');
//    WriteLn(t,'        </div>');
    if mode=0 then begin
    WriteLn(t,'    </div>');
    WriteLn(t,'');
    WriteLn(t,'</body>');
    WriteLn(t,'</html>');
    end;
    WriteLn(t,'');
    CloseFile(t);
    end;
  end;
  result:=true;
end;

procedure TForm1.N4Click(Sender: TObject);
  var t:TextFile;
  var s:string;
  var i,n:integer;
begin
  if pzn<>'' then savedialog2.FileName:=pzn+'.csv';
  if SaveDialog2.Execute then begin
    _editflag:=false;
    AssignFile(t,SaveDialog2.FileName);
    Rewrite(t);
    for n:=1 to StringGrid1.RowCount-1 do begin
      s:='';
      for i:=0 to StringGrid1.ColCount-2 do begin
        s:=s+StringGrid1.Cells[i,n]+';';
      end;
      s:=s+StringGrid1.Cells[StringGrid1.ColCount-1,n];
      WriteLn(t,s);
    end;
    CloseFile(t);
  end;
end;

procedure LoadFromCSV(fn:string);
  var t:TextFile;
  var s:widestring;
  var ts:AF_Types.TStrings;
  var i,n:integer;
begin
with form1 do begin
    _editflag:=false;
    _infile:=fn;
    savedialog1.FileName:=ExtractFileName(fn);
    ts.create;
    ClearSG;
    assignfile(t,fn);
    reset(t);
    n:=1;
      while not eof(t) do begin
        readln(t,s);
        ParseCSVStr(@ts,s);
        if ts.count>2 then begin
          for i:=1 to ts.count do begin
            StringGrid1.Cells[i-1,n]:=ts.getstring(i);
            if i=StringGrid1.ColCount then break;
          end;
          inc(n);
        end;
        if n=StringGrid1.RowCount then break;
      end;
    closefile(t);
    ts.free;
end;
end;

procedure TForm1.N3Click(Sender: TObject);
begin
  if _editflag then n10click(sender);
  if OpenDialog1.Execute then begin
    SaveDialog1.FileName:=OpenDialog1.FileName;
    _fname:=OpenDialog1.FileName;
    LoadFromCSV(OpenDialog1.FileName);
    pzn:='';
  end;
end;

procedure TForm1.N2Click(Sender: TObject);
begin
  form1.Close;  
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if _editflag then n10click(sender);
  if MessageDlg('   ?',mtConfirmation,[mbYes,mbNo],0)=mrYes then CanClose:=true
   else CanClose:=false;
end;

procedure TForm1.N7Click(Sender: TObject);
begin
  if _editflag then N10Click(sender);
  if MessageDlg('  ?',mtConfirmation,[mbYes,mbNo],0)=mrYes then begin
   OpenDialog1.FileName:='';
   SaveDialog1.FileName:='';
   _editflag:=false;
   pzn:='';
   _fname:='';
   ClearSG;
   StringGrid1.Cells[0,1]:='Z';
  end;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
  var i,n:integer;
begin
  if (StringGrid1.Row>0)and(StringGrid1.Row<(StringGrid1.RowCount-3)) then begin
    _editflag:=true;
    for n:=StringGrid1.RowCount-2 downto StringGrid1.Row do begin
     for i:=0 to StringGrid1.ColCount-1 do begin
       StringGrid1.Cells[i,n+1]:=StringGrid1.Cells[i,n];
       StringGrid1.Cells[i,n]:='';
     end;
    end;
  end;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
  var i,n:integer;
begin
  if MessageDlg(' ?',mtWarning,[mbYes,mbNo],0)=mrYes then begin
    _editflag:=true;
  if (StringGrid1.Row>0)and(StringGrid1.Row<(StringGrid1.RowCount-2)) then begin
    for n:=StringGrid1.Row to StringGrid1.RowCount-2 do begin
     for i:=0 to StringGrid1.ColCount-1 do begin
       StringGrid1.Cells[i,n]:=StringGrid1.Cells[i,n+1];
       StringGrid1.Cells[i,n+1]:='';
     end;
    end;
  end;
  end;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
  var i,n:integer;
begin
  _editflag:=true;
  for i:=2 to StringGrid1.ColCount-1 do begin
    for n:=1 to StringGrid1.RowCount-1 do begin
      StringGrid1.Cells[i-1,n]:=StringGrid1.Cells[i,n];
      StringGrid1.Cells[i,n]:='';
    end;
  end;
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
  var i,n:integer;
begin
  _editflag:=true;
  for i:=StringGrid1.ColCount-1 downto 2 do begin
    for n:=1 to StringGrid1.RowCount-1 do begin
      StringGrid1.Cells[i,n]:=StringGrid1.Cells[i-1,n];
      StringGrid1.Cells[i-1,n]:='';
    end;
  end;
end;

procedure TForm1.SpeedButton5Click(Sender: TObject);
  var i,n:integer;
begin
  if StringGrid1.Col<(StringGrid1.ColCount-1) then begin
    _editflag:=true;
  for i:=StringGrid1.ColCount-1 downto StringGrid1.Col+1 do begin
    for n:=1 to StringGrid1.RowCount-1 do begin
      StringGrid1.Cells[i,n]:=StringGrid1.Cells[i-1,n];
      StringGrid1.Cells[i-1,n]:='';
    end;
  end;
  end;
end;

procedure TForm1.SpeedButton6Click(Sender: TObject);
  var i,n:integer;
begin
  if MessageDlg(' ?',mtWarning,[mbYes,mbNo],0)=mrYes then begin
    _editflag:=true;
   for i:=StringGrid1.col+1 to StringGrid1.ColCount-1 do begin
    for n:=1 to StringGrid1.RowCount-1 do begin
      StringGrid1.Cells[i-1,n]:=StringGrid1.Cells[i,n];
      StringGrid1.Cells[i,n]:='';
    end;
   end;
  end;
end;

procedure TForm1.N8Click(Sender: TObject);
begin
 ExportToHTML(1,'');
end;

procedure TForm1.N6Click(Sender: TObject);
begin
  ExportToHTML(0,'');
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  _esrid.free;
  _yid.free;
  _stblock.free;
  _stlistx.free;
  _trnlist.free;
end;

procedure TForm1.N9Click(Sender: TObject);
  var dir1,dir2:string;
  var flist:AF_Types.TStrings;
  var i:integer;
begin
  flist.create;
  if SelectDirectory('    !','',dir1) then begin
    dir2:=dir1;
    if SelectDirectory('    !','',dir2) then begin
      dir1:=DeleteSlasheEx(dir1);
      dir2:=DeleteSlasheEx(dir2);
      GetMaskList(dir1+'\*.csv',@flist);
      if flist.count>0 then begin
        for i:=1 to flist.count do begin
          LoadFromCSV(dir1+'\'+flist.getstring(i));
          ExportToHTML(2,dir2+'\'+ExtractFileName(flist.getstring(i))+'.html');
        end;
        _stlistx.savetofile(dir2+'\stlist.csv');
//        _trnlist.savetofile(dir2+'\trnlist.csv');
        ShowMessage(' !');
      end;
    end;
  end;
  flist.free;
end;

procedure TForm1.SpeedButton7Click(Sender: TObject);
 var n:integer;
begin
  if StringGrid1.Row<(StringGrid1.RowCount-1) then begin
    _editflag:=true;
    for n:=StringGrid1.RowCount-1 downto StringGrid1.Row+1 do begin
      StringGrid1.Cells[StringGrid1.Col,n]:=StringGrid1.Cells[StringGrid1.Col,n-1];
      StringGrid1.Cells[StringGrid1.Col,n-1]:='';
    end;
  end;
end;

procedure TForm1.SpeedButton8Click(Sender: TObject);
 var n:integer;
begin
  if StringGrid1.Row<(StringGrid1.RowCount-1) then begin
    _editflag:=true;
    for n:=StringGrid1.Row to StringGrid1.RowCount-2 do begin
      StringGrid1.Cells[StringGrid1.Col,n]:=StringGrid1.Cells[StringGrid1.Col,n+1];
      StringGrid1.Cells[StringGrid1.Col,n+1]:='';
    end;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
// showmessage(URLEncode('http://maps.yandex.ru/?text= '));
  form3.showmodal;
end;

procedure TForm1.SpeedButton9Click(Sender: TObject);
begin
  ExportToHTML(0,DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\temp.html');
  ShellExecute(Application.Handle,'',PAnsiChar(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\temp.html'),'','',0);
end;

procedure TForm1.N10Click(Sender: TObject);
  var t:TextFile;
  var i,n:integer;
  var s:string;
begin
  if _editflag then begin
    if _fname='' then n4click(sender)
                 else begin
    if messageDlg(' ?',mtConfirmation,[mbYes,mbNo],0)=mrYes then begin
    _editflag:=false;
    AssignFile(t,_fname);
    Rewrite(t);
    for n:=1 to StringGrid1.RowCount-1 do begin
      s:='';
      for i:=0 to StringGrid1.ColCount-2 do begin
        s:=s+StringGrid1.Cells[i,n]+';';
      end;
      s:=s+StringGrid1.Cells[StringGrid1.ColCount-1,n];
      WriteLn(t,s);
    end;
    CloseFile(t);
    end;
                 end;
  end
   else ShowMessage('  ,   !');
end;

procedure TForm1.SpeedButton10Click(Sender: TObject);
begin
  ExportToHTML(0,DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\temp.html');
end;

end.
