unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, Grids, OleServer, ExcelXP;

type
  TForm2 = class(TForm)
    Memo1: TMemo;
    Button1: TButton;
    CheckBox1: TCheckBox;
    StringGrid1: TStringGrid;
    SpeedButton1: TSpeedButton;
    OpenDialog1: TOpenDialog;
    XLApp: TExcelApplication;
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;
  res:boolean;

implementation

uses unit1;

{$R *.dfm}

procedure TForm2.FormShow(Sender: TObject);
begin
  CheckBox1.Checked:=false;
  memo1.lines.Clear;
  res:=false;
  memo1.SetFocus;
end;

procedure TForm2.Button1Click(Sender: TObject);
begin
  if memo1.Lines.count>0 then begin
    if unit1.pzn='' then unit1.pzn:=stringgrid1.cells[0,0];
    res:=true;
    form2.close;
  end;
end;

procedure LoadFromXLS(fn:string);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
X, Y, xx, yy : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf:string;
tf:double;
begin
with form2 do begin
NomFich := fn;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
StringGrid1.ColCount := Y;
StringGrid1.RowCount := X;

for xx:=1 to x do begin
  for yy:=1 to y do begin
    nf:=worksheet.cells.item[xx,yy].NumberFormat;
    if (nf=':')or(nf=':')or(nf='h:mm')or(nf='hh:mm;@')or(nf=':;@')or(nf=':;@')or(nf='h:mm;@')or(nf='hh:mm;@') then begin
       tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xx,yy]),70);
       if tf=70 then stringgrid1.Cells[yy-1,xx-1]:=VarToStrDef(worksheet.cells.item[xx,yy],'')
                else stringgrid1.Cells[yy-1,xx-1]:=FormatDateTime('hh:nn',tf);
    end
     else stringgrid1.Cells[yy-1,xx-1]:=VarToStrDef(worksheet.cells.item[xx,yy],'');
  end;
end;


XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;
end;
end;


function Prep0ESR(s:string):string;
begin
  s:=trim(s);
  if length(s)=4 then result:='00'+s
                 else result:=s;
end;



procedure TForm2.SpeedButton1Click(Sender: TObject);
  var i:integer;
begin
  if OpenDialog1.Execute then begin
    LoadFromXLS(opendialog1.filename);
    if (stringgrid1.rowcount>1)and(stringgrid1.colcount>2) then begin
      for i:=1 to stringgrid1.RowCount-1 do begin
        memo1.Lines.Add(Prep0ESR(stringgrid1.cells[0,i])+';'+stringgrid1.cells[1,i]+';'+stringgrid1.cells[2,i]);
      end;
    end;
  end;
end;

end.
