unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, Buttons, ExtCtrls, AF_Types, FileCtrl,
  OleServer, ExcelXP, ComCtrls;

const
 pversion:string='1.0';

type
  TTimetable1 = packed record
    t1,t2,st,mfs:string[10];
  end;
  TForm1 = class(TForm)
    LabeledEdit1: TLabeledEdit;
    SpeedButton1: TSpeedButton;
    StringGrid1: TStringGrid;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    XLApp: TExcelApplication;
    StatusBar1: TStatusBar;
    ProgressBar1: TProgressBar;
    ProgressBar2: TProgressBar;
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  log: AF_Types.TStrings;


implementation

uses AF_Proc, Unit3;

{$R *.dfm}

function Prep0ESR(s:string):string;
begin
  s:=trim(s);
  if length(s)=4 then s:='00'+s;
  if length(s)=5 then s:='0'+s;
  result:=s;
end;


procedure ParseCSVStrEx(ts:AF_Types.PStrings; s:widestring; c:char);
 var n:integer;
begin
  ts.clear;
  while pos(c,s)>0 do begin
    n:=pos(c,s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;

procedure xhm(var h,m:integer);
  begin
    if m>59 then begin
      inc(h,(m div 60));
      m:=m mod 60;
    end;
    if h>23 then begin
     h:=h-24;
    end;
  end;

procedure dechm(var h,m:integer; t:integer);
  begin
    if (m-t)<0 then begin
      m:=60+(m-t);
      dec(h);
        if h<0 then h:=23;
    end
      else dec(m,t);
  end;

procedure inchm(var h,m:integer; t:integer);
  begin
    inc(m,t);
    xhm(h,m);
  end;

procedure tohm(s:string; var h,m:integer);
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    if pos('@',s)>1 then s:=copy(s,1,pos('@',s)-1);
    if pos(':',s)>0 then begin
      h:=StrToIntE(copy(s,1,pos(':',s)-1));
      m:=StrToIntE(copy(s,pos(':',s)+1,100));
    end
     else log.add('   : "'+s+'"');
//     else log.add(' '+mtrain+'.    : "'+s+'" '+inttostr(ord(s[1])));
  end;

function prephm(s:string):string;
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    result:=s;
  end;

function fromhm(h,m:integer):string;
  begin
    xhm(h,m);
    if h>9 then begin
             if m>9 then fromhm:=inttostr(h)+':'+inttostr(m)
                    else fromhm:=inttostr(h)+':0'+inttostr(m);
           end
           else begin
             if m>9 then fromhm:='0'+inttostr(h)+':'+inttostr(m)
                    else fromhm:='0'+inttostr(h)+':0'+inttostr(m);
           end;
  end;


procedure ClearSG;
 var i,n:integer;
begin
 for i:=0 to form1.StringGrid1.ColCount do
  for n:=0 to form1.StringGrid1.RowCount do form1.StringGrid1.Cells[i,n]:='';
end;

procedure ParseCSVStr(ts:AF_Types.PStrings; s:widestring);
 var n:integer;
begin
  ts.clear;
  while pos(';',s)>0 do begin
    n:=pos(';',s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;

function ValidNumber(s:string):boolean;
  var res:boolean;
  var i,e:integer;
begin
  res:=false;
  s:=trim(s);
  if length(s)>0 then begin
    e:=0;
    for i:=1 to length(s) do begin
      if not (s[i] in ['0'..'9','/','#','^','a'..'z','A'..'Z']) then inc(e);
    end;
    if e=0 then res:=true;
  end;
  result:=res;
end;

function delquot(s:string):string;
begin
  result:=StrReplace(s,'"',' ');
end;

function apifnc(param,str:string):string;
begin
 if validstr(str) then result:=' '+param+'="'+str+'"'
                  else result:='';
end;


procedure TForm1.SpeedButton1Click(Sender: TObject);
 var outfile:AF_Types.TStrings;
 var d,edir:string;
 var i,ff,h1,m1,h2,m2,t1,t2:integer;
 var WorkBk : _WorkBook;
 var WorkSheet : _WorkSheet;
 var X, Y, xx, yy, wshs : Integer;
 var IIndex : OleVariant;
 var NomFich : WideString;
 var nf:string;
 var tf:double;
 var vr,pf:boolean;
begin
  outfile.create;
  log.clear;
  if OpenDialog1.Execute then begin
  edir:=ExtractDirPath(OpenDialog1.Files.Strings[0]);
  ProgressBar1.Max:=OpenDialog1.Files.Count;
  vr:=false;
                        SaveDialog1.InitialDir:=edir;
                        SaveDialog1.FileName:='';
                        if SaveDialog1.Execute then vr:=true;
  if vr then begin
        outfile.clear;
        outfile.add('<?xml version="1.0" encoding="Windows-1251"?>');
        outfile.add('');
        DateTimeToString(d,'yyyy-mm-dd hh:nn:ss',date+time);
        outfile.add('<turnovers date="'+d+'" prog="ob2xml" progver="'+pversion+'" ver="1">');
  for ff:=0 to OpenDialog1.Files.Count-1 do begin
    log.add(' : '+ExtractFileName(OpenDialog1.Files.Strings[ff]));
    StatusBar1.SimpleText:=': '+ExtractFileName(OpenDialog1.Files.Strings[ff])+'.'+ExtractFileExtention(OpenDialog1.Files.Strings[ff]);
ProgressBar2.Position:=0;
NomFich := OpenDialog1.Files.Strings[ff];
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
for wshs:=1 to WorkBk.WorkSheets.Count do begin
WorkSheet := WorkBk.Sheets[wshs] as _WorkSheet;
WorkSheet.Activate(0);
log.add('    '+inttostr(wshs)+' ('+WorkSheet.Name+')');
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
ClearSG;
StringGrid1.ColCount := Y;
StringGrid1.RowCount := X;
ProgressBar2.Max:=X;
for xx:=1 to x do begin
  for yy:=1 to y do begin
    nf:=worksheet.cells.item[xx,yy].NumberFormat;
    if (pos('::',nf)>0)or(nf=':')or(nf=':')or(nf='h:mm')or(nf='hh:mm;@')or(nf=':;@')or(nf=':;@')or(nf='h:mm;@')or(nf='hh:mm;@')or(nf='[]:')or(nf='[]:') then begin
       tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xx,yy]),70);
       if tf=70 then stringgrid1.Cells[yy-1,xx-1]:=VarToStrDef(worksheet.cells.item[xx,yy],'')
                else stringgrid1.Cells[yy-1,xx-1]:=FormatDateTime('hh:nn',tf);
    end
     else begin
       stringgrid1.Cells[yy-1,xx-1]:=Trim(VarToStrDef(worksheet.cells.item[xx,yy],''));
     end;
  end;
  ProgressBar2.Position:=xx;
  Application.ProcessMessages;
end;
    ///
    if StringGrid1.RowCount>1 then begin
        for i:=1 to StringGrid1.RowCount do begin
          if validstr(stringgrid1.cells[0,i]) then begin
            pf:=true;
            if not validstr(stringgrid1.cells[20,i]) then pf:=false;
            if not validstr(stringgrid1.cells[7,i]) then pf:=false;
            if not validstr(stringgrid1.cells[0,i]) then pf:=false;
            if not validstr(stringgrid1.cells[9,i]) then pf:=false;
            if not validstr(stringgrid1.cells[5,i]) then pf:=false;
            if not validstr(stringgrid1.cells[18,i]) then pf:=false;
            if not validstr(stringgrid1.cells[19,i]) then pf:=false;
            if pf then begin
              if stringgrid1.cells[5,i]<>stringgrid1.cells[14,i] then log.add('    :   '+stringgrid1.cells[0,i]+' '+stringgrid1.cells[1,i]+' ( '+inttostr(i+1)+')     !');
              if stringgrid1.cells[7,i]<>stringgrid1.cells[15,i] then log.add('    :   '+stringgrid1.cells[0,i]+' '+stringgrid1.cells[1,i]+' ( '+inttostr(i+1)+')     !');
              tohm(stringgrid1.cells[3,i],h1,m1);
              tohm(stringgrid1.cells[11,i],h2,m2);
              if h1=0 then h1:=24;
              if h1=1 then h1:=25;
              if h2=0 then h2:=24;
              if h2=1 then h2:=25;
              t1:=h1*60; t1:=t1+m1+10;
              t2:=h2*60; t2:=t2+m2;
              if t2<t1 then log.add('    :   '+stringgrid1.cells[0,i]+' '+stringgrid1.cells[1,i]+' ( '+inttostr(i+1)+')    !');
              outfile.add('<train_turnover graph_code="'+stringgrid1.cells[20,i]+'" station_esr="'+prep0esr(stringgrid1.cells[7,i])+'" number_before="'+stringgrid1.cells[0,i]+'" number_after="'+stringgrid1.cells[9,i]+'" template_code="'+stringgrid1.cells[5,i]+'" start_date="'+stringgrid1.cells[18,i]+'" end_date="'+stringgrid1.cells[19,i]+'"/>');
            end
             else begin
                log.add('    :  '+stringgrid1.cells[0,i]+' '+stringgrid1.cells[1,i]+' ( '+inttostr(i+1)+')    , !');
             end;
          end;
        end;
        log.add('  ..... ');
    end;
    ///
end;
ProgressBar1.Position:=ff+1;
XLApp.Quit;
XLApp.Disconnect;
ProgressBar2.Position:=0;
    ///
  end;
        outfile.add('</turnovers>');
        outfile.savetofile(savedialog1.filename);
        if log.count>0 then begin
          StatusBar1.SimpleText:=' !';
          Application.ProcessMessages;
          form3.listbox1.items.clear;
          for i:=1 to log.count do form3.ListBox1.Items.Add(log.getstring(i));
          form3.ShowModal;
        end
         else StatusBar1.SimpleText:=' !';
  end;
  end;
  ProgressBar1.position:=0;
  ProgressBar2.position:=0;
  outfile.free;
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
  log.create;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  log.free;
end;

end.
