unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, WinINet, AF_Proc, AF_Types, Grids, Math, ComCtrls,
  Buttons, Spin, MySQL6, MySQLClasses6, ExtCtrls, Winsock, Menus;

type
  TMRKMode = (mrkmg, mrkmc);
  TRTInfo = packed record
    num,title,code,time1,time2,st1,st2:string;
  end;
  TPZList = packed record
    number, title, dep, arr, date1, date2, date1a, date2a, idr:string;
  end;
  PMySQL2 = ^TMySQL;
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    StatusBar1: TStatusBar;
    StringGrid1: TStringGrid;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    CheckBox3: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox1: TCheckBox;
    RadioGroup1: TRadioGroup;
    Label1: TLabel;
    Button1: TButton;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    Label2: TLabel;
    PopupMenu1: TPopupMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    Label3: TLabel;
    Label4: TLabel;
    CheckBox7: TCheckBox;
    StringGrid2: TStringGrid;
    Label5: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure StringGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure StringGrid1DblClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure StringGrid1Click(Sender: TObject);
    procedure FormCanResize(Sender: TObject; var NewWidth,
      NewHeight: Integer; var Resize: Boolean);
    procedure Button1Click(Sender: TObject);
    procedure StringGrid1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure N1Click(Sender: TObject);
    procedure N2Click(Sender: TObject);
    procedure Label2Click(Sender: TObject);
    procedure Label3Click(Sender: TObject);
    procedure Label4Click(Sender: TObject);
    procedure Label5Click(Sender: TObject);
    procedure StringGrid1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  {threaddir,}workdir:string;
  st1,st2,strrep1,strrep2,numrep1,numrep2,numrep3,timer0,timer1,timer2,timer3,timer4,markers,nesr1,nesr2,_strepl1,_strepl2,_sqllog,_maincache,_markc1,_markc2:AF_Types.TStrings;
  rzdchgnum,_stwidth,_stheight:integer;
  rtitle:string;
  rzdurl{,yandexurl}:string;
  rzd_st1,rzd_st2{,yandex_st1,yandex_st2}:string;
//  zmode:boolean;
  cfg_mysql_host, cfg_mysql_port, cfg_mysql_database, cfg_mysql_user, cfg_mysql_password: string;
  cfg_mysql_markers_host, cfg_mysql_markers_port, cfg_mysql_markers_database, cfg_mysql_markers_user, cfg_mysql_markers_password: string;
  romode,_pzmode:boolean;
  _sg1x,_sg1y:integer;
  rgchflag:boolean;
  mrkmode:TMRKMode;

const
  y_change:string='http://export.rasp.yandex.net/export/v2/suburban/thread/@uid@/linked';

function LoadTrainFromMYSQL(code:string; ts:AF_Types.PStrings; replflag:boolean; kstr:string):boolean;
procedure ParseCSVStrEx(ts:AF_Types.PStrings; s:widestring; c:char);
function fromhm(h,m:integer):string;
procedure tohm(s:string; var h,m:integer);
procedure inchm(var h,m:integer; t:integer);
procedure savestrepl;
function testd(s:string;addsc:boolean):string;
function PrepRZRTime(s:string):string;
function GetSTN(s:string):string;


implementation

uses Unit2, Unit3, DateUtils;

{$R *.dfm}

function GetTimeS:string;
begin
  result:=FormatDateTime('hh:mm:ss',time);
end;


function ddiv(s1,s2:string):string;
begin
  s1:=trim(s1);
  s2:=trim(s2);
  if ((validstr(s1)=true)and(validstr(s2)=true)) then begin
    result:=s1+'/'+s2;
  end
   else begin
     result:=s1+s2;
   end;
end;


function del0t(s:string):string;
 var s1:string;
begin
 s1:=s;
 if form1.checkbox7.checked then begin
  if length(s)>1 then begin
   if ((s[1]='0')and((s[2] in ['0'..'9']))) then s1:=copy(s1,2,length(s1)-1);
   if pos('/00',s1)>0 then delete(s1,pos('/00',s1)+1,1);
   if pos('/01',s1)>0 then delete(s1,pos('/01',s1)+1,1);
   if pos('/02',s1)>0 then delete(s1,pos('/02',s1)+1,1);
   if pos('/03',s1)>0 then delete(s1,pos('/03',s1)+1,1);
   if pos('/04',s1)>0 then delete(s1,pos('/04',s1)+1,1);
   if pos('/05',s1)>0 then delete(s1,pos('/05',s1)+1,1);
   if pos('/06',s1)>0 then delete(s1,pos('/06',s1)+1,1);
   if pos('/07',s1)>0 then delete(s1,pos('/07',s1)+1,1);
   if pos('/08',s1)>0 then delete(s1,pos('/08',s1)+1,1);
   if pos('/09',s1)>0 then delete(s1,pos('/09',s1)+1,1);
  end;
 end;
 result:=s1;
end;

function delSc(s:string):string;
begin
 if pos(']',s)>0 then s:=trim(copy(s,pos(']',s)+1,length(s)-pos(']',s)));
 if pos(')',s)>0 then s:=trim(copy(s,pos(')',s)+1,length(s)-pos(')',s)));
 result:=s;
end;

procedure savestrepl;
 var f:AF_Types.Tstrings;
 var i:integer;
begin
 f.create;
 if _strepl1.count>0 then begin
   for i:=1 to _strepl1.count do begin
     f.add(_strepl1.getstring(i)+';'+_strepl2.getstring(i));
   end;
   f.savetofile(deleteslasheex(ExtractDirPath(application.ExeName))+'\streplace.csv');
 end;
 f.free;
end;

function get1st(s:string):string;
begin
 result:=s;
 s:=StrReplace(s,'','-');
 if pos(' - ',s)>1 then result:=trim(copy(s,1,pos(' - ',s)-1));
 if pos(']',result)>0 then result:=trim(copy(result,pos(']',result)+1,length(result)-pos(']',result)));
end;

function get2st(s:string):string;
begin
 result:=s;
 s:=StrReplace(s,'','-');
 if pos(' - ',s)>1 then result:=trim(copy(s,pos(' - ',s)+3,100));
 if pos(']',result)>0 then result:=trim(copy(result,pos(']',result)+1,length(result)-pos(']',result)));
end;


procedure SetL8;
 var i,g,y,r,b:integer;
begin
 g:=0; y:=0; r:=0; b:=0;
 if markers.count>0 then begin
   for i:=1 to markers.count do begin
     if markers.getstring(i)='1' then y:=y+1;
     if markers.getstring(i)='2' then g:=g+1;
     if markers.getstring(i)='6' then r:=r+1;
     if markers.getstring(i)='9' then b:=b+1;
   end;
 end;
 form1.Label1.Caption:=inttostr(markers.Count)+' ,  .. :'+inttostr(g)+', :'+inttostr(y)+', :'+inttostr(r)+', :'+inttostr(b)+'.';
 form1.Repaint;
end;


procedure loadesr;
  var f,u:AF_Types.TStrings;
  var i,cc:integer;
begin
  f.create;
  u.create;
  nesr1.clear;
  nesr2.clear;
  cc:=0;
  if fileexists(deleteslasheex(ExtractDirPath(application.ExeName))+'\esrlist.csv') then begin
    f.loadfromfile(deleteslasheex(ExtractDirPath(application.ExeName))+'\esrlist.csv');
    if f.count>0 then begin
      for i:=1 to f.count do begin
        ParseCSVStrEx(@u,f.getstring(i),';');
        if u.count>1 then begin
          nesr1.add(u.getstring(1));
          nesr2.add(u.getstring(2));
          inc(cc);
        end;
      end;
    end;
  end;
//  showmessage(' '+inttostr(cc)+' .');
  u.free;
  f.free;
end;

procedure loadstrep;
  var f,u:AF_Types.TStrings;
  var i,cc:integer;
begin
  f.create;
  u.create;
  _strepl1.clear;
  _strepl2.clear;
  cc:=0;
  if fileexists(deleteslasheex(ExtractDirPath(application.ExeName))+'\streplace.csv') then begin
    f.loadfromfile(deleteslasheex(ExtractDirPath(application.ExeName))+'\streplace.csv');
    if f.count>0 then begin
      for i:=1 to f.count do begin
        ParseCSVStrEx(@u,f.getstring(i),';');
        if u.count>1 then begin
          _strepl1.add(u.getstring(1));
          _strepl2.add(u.getstring(2));
          inc(cc);
        end;
      end;
    end;
  end;
 // showmessage(' '+inttostr(cc)+' .');
  u.free;
  f.free;
end;


function getCtrl:boolean;
 var KeyState : Word;
begin
  KeyState := GetKeyState(VK_CONTROL);
  if KeyState and $8000 = $8000 then result:=true
                                else result:=false;
end;

function getShift:boolean;
 var KeyState : Word;
begin
  KeyState := GetKeyState(VK_SHIFT);
  if KeyState and $8000 = $8000 then result:=true
                                else result:=false;
end;

function getAlt:boolean;
 var KeyState : Word;
begin
  KeyState := GetKeyState(VK_MENU);
  if KeyState and $8000 = $8000 then result:=true
                                else result:=false;
end;

procedure ParseCSVStrEx(ts:AF_Types.PStrings; s:widestring; c:char);
 var n:integer;
begin
  ts.clear;
  while pos(c,s)>0 do begin
    n:=pos(c,s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;

procedure ShowMySQLError(MySQL:IMySQL);
 var f:AF_Types.TStrings;
begin
  f.create;
  if fileexists(workdir+'sqlerror.log') then f.loadfromfile(workdir+'sqlerror.log');
  ShowMessage(Format(' #%d - %s', [MySQL.ErrorCode, MySQL.ErrorMessage]));
  f.add(mysql.Host+' : '+Format(' #%d - %s', [MySQL.ErrorCode, MySQL.ErrorMessage]));
  f.savetofile(workdir+'sqlerror.log');
  f.free;
end;

function LoadTrainFromMYSQL(code:string; ts:AF_Types.PStrings; replflag:boolean; kstr:string):boolean;
  var MySQL: IMySQL;
  var query_result: IMySQLQuery;
  var q1,lz,pr,ot,ss,rs:string;
  var t:AF_Types.TStrings;
  var n,m:integer;
  var idrstr:string;
begin
 result:=true;
 if form1.checkbox4.Checked then rs:=''
                            else rs:='AND TEXST=0 ';
 t.create;
 ParseCSVStrEx(@t,code,'_');
 if t.getstring(3)<>'9' then begin
  if ((strtointe(t.getstring(2))>0)or(form1.CheckBox5.Checked)) then begin
  if form1.checkbox5.checked then begin
   if strtointe(t.getstring(2))<=0 then begin
    m:=_markc1.SearchString(t.getstring(1));
    if m>0 then idrstr:=_markc2.getstring(m);
   end
    else idrstr:=t.getstring(2);
  end
   else idrstr:=t.getstring(2);
  ts.clear;
  MySQL := TMySQL.Create;
  MySQL.Host := cfg_mysql_host;
  MySQL.Port := strtointe(cfg_mysql_port);
  MySQL.User := cfg_mysql_user;
  MySQL.Password := cfg_mysql_password;
  if not MySQL.Connect then ShowMySQLError(MySQL)
   else begin
    MySQL.Database := cfg_mysql_database;
    MySQL.Query('set character_set_client=''utf8'';');
    MySQL.Query('set character_set_results=''utf8'';');
    MySQL.Query('set collation_connection=''utf8_bin'';');
                      if replflag then q1:='SELECT IDR,IDTR,IDRP,SEQ,PRIB,OTPR,TEXST from `rzd_buffer_change_srasprp_buf` WHERE IDR='+idrstr+' AND ID_XML='+t.getstring(1)+' '+rs+'ORDER BY SEQ'
                                  else q1:='SELECT IDR,IDRP,SEQ,PRIB,OTPR,TEXST from `rzd_buffer_current_srasprp` WHERE IDR='+idrstr+' '+rs+'ORDER BY SEQ';
                      query_result:= MySQL.Query(q1);
                       if query_result = nil then ShowMySQLError(MySQL)
                        else begin
                          n:=1;
                          while query_result.FetchRow do begin
                            lz:='';
                            if strtointe(query_result.ValueByName['TEXST'])>0 then lz:=' ***';
                            pr:=query_result.ValueByName['PRIB'];
                            ot:=query_result.ValueByName['OTPR'];
                            if pr=ot then begin
                             if n>1 then begin
                              pr:='-';
                              ot:='-';
                             end;
                            end;
                            ts.add(GetSTN(query_result.ValueByName['IDRP'])+lz+';'+PrepRZRTime(pr)+';'+PrepRZRTime(ot)+';'+trim(lz));
                            ss:=GetSTN(query_result.ValueByName['IDRP'])+lz+';'+PrepRZRTime(query_result.ValueByName['PRIB'])+';'+PrepRZRTime(query_result.ValueByName['OTPR'])+';'+trim(lz);
                            inc(n);
                          end;
                          if ot='-' then begin
                            ts.edit(ts.count,ss);
                          end;
                        end;
    MySQL.Disconnect;
   end;
  end
   else result:=false;
 end //t<>9
  else begin //t=9
  if (strtointe(t.getstring(2))>0) then begin
  idrstr:=t.getstring(2);
  ts.clear;
  MySQL := TMySQL.Create;
  MySQL.Host := cfg_mysql_markers_host;
  MySQL.Port := strtointe(cfg_mysql_markers_port);
  MySQL.User := cfg_mysql_markers_user;
  MySQL.Password := cfg_mysql_markers_password;
  if not MySQL.Connect then ShowMySQLError(MySQL)
   else begin
    MySQL.Database := 'rzday2';
    MySQL.Query('set character_set_client=''utf8'';');
    MySQL.Query('set character_set_results=''utf8'';');
    MySQL.Query('set collation_connection=''utf8_bin'';');
                      if replflag then q1:='SELECT IDR,IDTR,IDRP,SEQ,PRIB,OTPR,TEXST from `srasprp` WHERE IDR='+idrstr+' AND ID_XML='+t.getstring(1)+' '+rs+'ORDER BY SEQ'
                                  else q1:='SELECT IDR,IDRP,SEQ,PRIB,OTPR,TEXST from `srasprp` WHERE ID_XML='+t.getstring(1)+' AND IDR='+idrstr+' '+rs+'ORDER BY SEQ';
                      query_result:= MySQL.Query(q1);
                       if query_result = nil then ShowMySQLError(MySQL)
                        else begin
                          n:=1;
                          while query_result.FetchRow do begin
                            lz:='';
                            if strtointe(query_result.ValueByName['TEXST'])>0 then lz:=' ***';
                            pr:=StrReplace(query_result.ValueByName['PRIB'],'.',':');
                            ot:=StrReplace(query_result.ValueByName['OTPR'],'.',':');
                            if pr=ot then begin
                             if n>1 then begin
                              pr:='-';
                              ot:='-';
                             end;
                            end;
                            ts.add(GetSTN(query_result.ValueByName['IDRP'])+lz+';'+PrepRZRTime(pr)+';'+PrepRZRTime(ot)+';'+trim(lz));
                            ss:=GetSTN(query_result.ValueByName['IDRP'])+lz+';'+PrepRZRTime(StrReplace(query_result.ValueByName['PRIB'],'.',':'))+';'+PrepRZRTime(StrReplace(query_result.ValueByName['OTPR'],'.',':'))+';'+trim(lz);
                            inc(n);
                          end;
                          if ot='-' then begin
                            ts.edit(ts.count,ss);
                          end;
                        end;
    MySQL.Disconnect;
   end;
  end
   else result:=false;
  end; //t=9
  t.free;
end;


procedure SetStatus(code,status:string);
  var MySQL: IMySQL;
  var query_result: IMySQLQuery;
  var q1:string;
  var u:AF_Types.TStrings;
begin
with form1 do begin
 if pos('_',code)>1 then begin
  u.create;
  ParseCSVStrEx(@u,code,'_');
  MySQL := TMySQL.Create;
  MySQL.Host := cfg_mysql_markers_host;
  MySQL.Port := strtointe(cfg_mysql_markers_port);
  MySQL.User := cfg_mysql_markers_user;
  MySQL.Password := cfg_mysql_markers_password;
  if not MySQL.Connect then ShowMySQLError(MySQL)
   else begin
    MySQL.Database := cfg_mysql_markers_database;
    MySQL.Query('set character_set_client=''cp1251'';');
    MySQL.Query('set character_set_results=''cp1251'';');
    MySQL.Query('set collation_connection=''cp1251_bin'';');
            q1:='SELECT * FROM `markers` WHERE ID_XML='+u.getstring(1)+' AND IDR='+u.getstring(2)+' AND OP='+u.getstring(3);
            query_result := MySQL.Query(q1);
             if query_result = nil then ShowMySQLError(MySQL)
                                   else begin
                                    if query_result.RecordCount>0 then begin
                                       q1:='UPDATE `markers` SET status='+status+' WHERE ID_XML='+u.getstring(1)+' AND IDR='+u.getstring(2)+' AND OP='+u.getstring(3);
                                       query_result := MySQL.Query(q1);
                                    end
                                     else begin
                                       q1:='INSERT INTO `markers` (`id`, `ID_XML`, `IDR`, `OP`, `status`) VALUES (NULL, '+u.getstring(1)+', '+u.getstring(2)+', '+u.getstring(3)+', '+status+')';
                                       query_result := MySQL.Query(q1);
                                     end;
                                   end;
//    inputquery('','',q1);
    MySQL.Disconnect;
   end;
   SetL8;
   u.free;
 end;
end;
end;

function GetFirstZ1:string;
  var MySQL: IMySQL;
  var query_result: IMySQLQuery;
  var q1,z1:string;
begin
with form1 do begin
  z1:='0';
  MySQL := TMySQL.Create;
  MySQL.Host := cfg_mysql_markers_host;
  MySQL.Port := strtointe(cfg_mysql_markers_port);
  MySQL.User := cfg_mysql_markers_user;
  MySQL.Password := cfg_mysql_markers_password;
  if not MySQL.Connect then ShowMySQLError(MySQL)
   else begin
    MySQL.Database := cfg_mysql_markers_database;
    MySQL.Query('set character_set_client=''cp1251'';');
    MySQL.Query('set character_set_results=''cp1251'';');
    MySQL.Query('set collation_connection=''cp1251_bin'';');
            q1:='SELECT MIN(ID_XML) FROM `markers` WHERE STATUS<>2 AND ID_XML>1553570 AND ID_XML<6000000';
            query_result := MySQL.Query(q1);
            _sqllog.add(GetTimeS+' '+q1+';    '+inttostr(query_result.RecordCount));
             if query_result = nil then begin
//                                     ShowMySQLError(MySQL)
                                     z1:='1553570';
                                   end
                                   else begin
                                    if query_result.RecordCount>0 then begin
                                     query_result.FetchRow;
                                     z1:=query_result.Values[0];
                                    end
                                     else z1:='1553570';
                                   end;
    MySQL.Disconnect;
   end;
 result:=z1;
end;
end;


procedure ClearSG(sg:TStringGrid);
  var i,n:integer;
begin
 for i:=0 to sg.ColCount-1 do
  for n:=0 to sg.RowCount-1 do sg.Cells[i,n]:='';
 sg.RowCount:=1;
end;

procedure xhm(var h,m:integer);
  begin
    if m>59 then begin
      inc(h,(m div 60));
      m:=m mod 60;
    end;
    if h>23 then begin
     h:=h-24;
    end;
  end;

procedure inchm(var h,m:integer; t:integer);
  begin
    inc(m,t);
    xhm(h,m);
  end;

procedure tohm(s:string; var h,m:integer);
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    s:=strreplace(s,'-',':');
    if pos(':',s)>0 then begin
      h:=StrToIntE(copy(s,1,pos(':',s)-1));
      m:=StrToIntE(copy(s,pos(':',s)+1,100));
    end;
  end;

function prephm(s:string):string;
  begin
    s:=strreplace(s,'.',':');
    s:=strreplace(s,',',':');
    s:=strreplace(s,'-',':');
    result:=s;
  end;

function fromhm(h,m:integer):string;
  begin
    xhm(h,m);
    if h>9 then begin
             if m>9 then fromhm:=inttostr(h)+'.'+inttostr(m)
                    else fromhm:=inttostr(h)+'.0'+inttostr(m);
           end
           else begin
             if m>9 then fromhm:=''+inttostr(h)+'.'+inttostr(m)
                    else fromhm:=''+inttostr(h)+'.0'+inttostr(m);
           end;
  end;



Procedure GetInetFile (const fileURL, FileName: String);
const BufferSize = 1024;
var
  hSession, hURL: HInternet;
  Buffer: array[1..BufferSize] of Byte;
  BufferLen: DWORD;
  f: File;
  sAppName: String;
begin
  sAppName := ExtractFileName(Application.ExeName);
  hSession :=InternetOpen(PChar('Mozilla/5.0 (Windows NT 6.1; WOW64; rv:26.0) Gecko/201001'), INTERNET_OPEN_TYPE_PRECONFIG, nil, nil, 0);
  try
    hURL := InternetOpenURL(hSession, PChar(fileURL), nil, 0, 0, 0);
    try
      AssignFile(f, FileName);
      Rewrite(f,1);
      {$I-}
      repeat
      try
        bufferlen:=0;
        InternetReadFile(hURL, @Buffer, SizeOf(Buffer), BufferLen);
      except
      end;
        if bufferlen>0 then begin
          try
           BlockWrite(f, Buffer, BufferLen)
          except
          end;
        end;
      until BufferLen = 0;
      {$I+}
      CloseFile(f);
    finally
      InternetCloseHandle(hURL)
    end
  finally
    InternetCloseHandle(hSession)
  end
end;

Procedure UTF8FileDecode(fn,fn1:string);
 var t,t1:textfile;
 var s:string;
begin
  assignfile(t,fn);
  reset(t);
  assignfile(t1,fn1);
  rewrite(t1);
   while not eof(t) do begin
     readln(t,s);
     writeln(t1,Utf8ToAnsi(s));
   end;
  closefile(t1);
  closefile(t);
end;


function LoadMainIni:boolean;
  var chg:AF_Types.TStrings;
  var i:integer;
  var s,s1,s2,s3,s4:string;
  var res:boolean;
begin
  chg.create;
  rzdurl:='';
  romode:=false;
{  yandexurl:=''; }
  strrep1.clear;
  strrep2.clear;
  chg.loadfromfile(workdir+'main.ini');
  if chg.count>0 then begin
    for i:=1 to chg.count do begin
      s:=trim(chg.getstring(i));
      s:=strreplace(s,#9,#32);
      if length(s)>0 then begin
        if not (s[1]=';') then begin
          if pos(' ',s)>0 then begin
            s1:=trim(copy(s,1,pos(' ',s)-1));
            s2:=trim(copy(s,pos(' ',s)+1,length(s)-pos(' ',s)));
            s1:=ansilowercase(s1);
            if s1='rzdnum' then begin
              rzdchgnum:=StrToIntE(s2);
            end;
            if s1='readonly' then begin
              s4:=trim(s2);
              if s2='1' then romode:=true
                        else romode:=false;
            end;
            if s1='mysql_host' then begin
              cfg_mysql_host:=s2
            end;
            if s1='mysql_port' then begin
              cfg_mysql_port:=s2;
            end;
            if s1='mysql_database' then begin
              cfg_mysql_database:=s2;
            end;
            if s1='mysql_user' then begin
              cfg_mysql_user:=s2;
            end;
            if s1='mysql_markers_host' then begin
              cfg_mysql_markers_host:=s2
            end;
            if s1='mysql_markers_port' then begin
              cfg_mysql_markers_port:=s2;
            end;
            if s1='mysql_markers_database' then begin
              cfg_mysql_markers_database:=s2;
            end;
            if s1='mysql_markers_user' then begin
              cfg_mysql_markers_user:=s2;
            end;
            if s1='pzmode' then begin
              if s2='1' then _pzmode:=true
                        else _pzmode:=false;
            end;
            if s1='streplace' then begin
              if pos(';',s2)>0 then begin
                s3:=trim(copy(s2,pos(';',s2)+1,length(s2)-pos(';',s2)));
                s2:=trim(copy(s2,1,pos(';',s2)-1));
                strrep1.add(ansilowercase(s2));
                strrep2.add(ansilowercase(s3));
              end;
            end;
          end;
        end;
      end;
    end;
  end;
  chg.clear;
  chg.loadfromfile(workdir+'main.pwd');
  if chg.count>0 then begin
    for i:=1 to chg.count do begin
      s:=trim(chg.getstring(i));
      s:=strreplace(s,#9,#32);
      if length(s)>0 then begin
        if not (s[1]=';') then begin
          if pos(' ',s)>0 then begin
            s1:=trim(copy(s,1,pos(' ',s)-1));
            s2:=trim(copy(s,pos(' ',s)+1,length(s)-pos(' ',s)));
            s1:=ansilowercase(s1);
            if s1='mysql_password' then begin
              cfg_mysql_password:=s2;
            end;
            if s1='mysql_markers_password' then begin
              cfg_mysql_markers_password:=s2;
            end;
          end;
        end;
      end;
    end;
  end;
  chg.free;
  res:=true;
  result:=res;
end;

function cdl2txt(cdl:AF_Types.PStrings):string;
 var i:integer;
 var s1:string;
 var u:AF_Types.TStrings;
begin
 s1:='';
 u.create;
 if cdl.count>0 then begin
  for i:=1 to cdl.count do begin
   if pos('-',cdl.getstring(i))>0 then begin
    ParseCSVStrEx(@u,cdl.getstring(i),'-');
    s1:=s1+u.getstring(3)+'.'+u.getstring(2)+', ';
   end;
  end;
 end;
 u.free;
 if pos(',',s1)>0 then s1:=copy(s1,1,length(s1)-2);
 if cdl.count>30 then begin
   result:=testd(s1,true)+' '+s1;
 end
  else result:=s1;
end;

function cdl2F(cdl:AF_Types.PStrings):string;
 var s1:string;
 var u:AF_Types.TStrings;
begin
 s1:='';
 u.create;
 if cdl.count>0 then begin
    ParseCSVStrEx(@u,cdl.getstring(1),'-');
    s1:=u.getstring(3)+'.'+u.getstring(2);
 end;
 u.free;
 result:=s1;
end;

function cdl2L(cdl:AF_Types.PStrings):string;
 var i:integer;
 var s1:string;
 var u:AF_Types.TStrings;
begin
 s1:='';
 u.create;
 if cdl.count>0 then begin
  for i:=1 to cdl.count do begin
   if pos('-',cdl.getstring(i))>0 then begin
    ParseCSVStrEx(@u,cdl.getstring(i),'-');
    s1:=u.getstring(3)+'.'+u.getstring(2);
   end;
  end;
 end;
 u.free;
 result:=s1;
end;

function GetSTN(s:string):string;
 var n:integer;
begin
 s:=trim(s);
 result:=s;
 n:=st1.SearchString(s);
 if n>0 then result:=st2.getstring(n);
end;


function PrepRZRTime(s:string):string;
  var i,n:integer;
  var res:boolean;
begin
  res:=false;
  n:=0;
  if pos(':',s)>0 then begin
    for i:=1 to length(s) do begin
      if s[i]=':' then inc(n);
      if n=2 then begin
        res:=true;
        break;
      end;
    end;
    if res then s:=copy(s,1,i-1);
  end;
  result:=s;
end;

function PrepRZRTime2(s:string):string;
  var i,n:integer;
  var res:boolean;
begin
  res:=false;
  n:=0;
  if pos('.',s)>0 then begin
    for i:=1 to length(s) do begin
      if s[i]='.' then inc(n);
      if n=2 then begin
        res:=true;
        break;
      end;
    end;
    if res then s:=copy(s,1,i-1);
  end;
  result:=s;
end;

function gpGraph(s,s1:string):string;
begin
  if strtointe(s1)<10 then s1:='0'+s1;
  if s<>'2021' then result:='['+s+' '+s1+'] '
               else begin
                 if s1='200040' then result:='[] '
                                else result:='';
               end;
end;

function FindPZ(mysql:IMySQL; idxml:string; var pzl:TPZList; var idtrain:string):string;
  type _TThcf=packed record st1,st2,dep,arr,num,idr,newgrph:string; end;
  var idtr1,idr1,cdate1,oper1,q1,q2,q3,q4:string;
  var qr1,qr2,qr3,qr4:IMySQLQuery;
  var qrn1:integer;
  var thcf1,thcf2:_TThcf;
  var cdn,cdc:AF_Types.TSTrings;
procedure _procidtr(_idtr:string; var _thc:_TThcf);
begin
  _thc.st1:=''; _thc.st2:=''; _thc.dep:=''; _thc.arr:=''; _thc.num:=''; _thc.newgrph:='';
  q3:='SELECT * from `strains` WHERE IDTR='+_idtr;    //!
  qr3:= mysql.Query(q3);
   if qr3 = nil then ShowMySQLError(MySQL)
    else begin
      qr3.FetchRow;
      _thc.num:=qr3.ValueByName['NUM'];
      _thc.st1:=getstn(qr3.ValueByName['RP1']);
      _thc.st2:=getstn(qr3.ValueByName['RPK']);
      if qr3.ValueByName['YEAR']<>'2021' then _thc.newgrph:='['+qr3.ValueByName['YEAR']+' '+qr3.ValueByName['CODEOWNER']+'] ';
    end;
end;
function _numtrain(_idtr:string):string;
begin
  result:='';
  q3:='SELECT * from `strains` WHERE IDTR='+_idtr;    //!
  qr3:= mysql.Query(q3);
//  inputquery('','',q3);
   if qr3 = nil then ShowMySQLError(MySQL)
    else begin
      qr3.FetchRow;
      result:=qr3.ValueByName['NUM'];
{      if not validstr(result) then begin
        q3:='SELECT * from `strains` WHERE ID_XML='+idxml;    //!
        inputquery('','',q3);
        qr3:= mysql.Query(q3);
         if qr3 = nil then ShowMySQLError(MySQL)
          else begin
            qr3.FetchRow;
            result:=qr3.ValueByName['NUM'];
          end;
      end;    }
    end;
end;
procedure _proccal;
 var cdate,oper:string;
begin
  cdn.clear;
  cdc.clear;
  q3:='SELECT * from `scalendar` WHERE ID_XML='+idxml+' ORDER BY CDATE';    //!
  qr3:= mysql.Query(q3);
   if qr3 = nil then ShowMySQLError(MySQL)
    else begin
      while qr3.FetchRow do begin
        cdate:=qr3.ValueByName['CDATE'];
        oper:=qr3.ValueByName['OPER'];
        if strtointe(qr3.ValueByName['IDR'])>0 then begin
          if (strtointe(oper) in [0,1,3]) then begin
            if cdn.SearchString(cdate)<=0 then cdn.add(cdate);
          end
           else begin
            if cdc.SearchString(cdate)<=0 then cdc.add(cdate);
           end;
        end
         else begin
            if cdc.SearchString(cdate)<=0 then cdc.add(cdate);
         end;
      end;
    end;
end; // _proccal
procedure _procth(_idr:string; var _thc:_TThcf);
  var otpr,prib,sotpr,sprib:string;
begin
  _thc.st1:=''; _thc.st2:=''; _thc.dep:=''; _thc.arr:=''; _thc.num:=''; _thc.idr:='';
  q3:='SELECT IDR,IDRP,SEQ,PRIB,OTPR,TEXST from `srasprp` WHERE IDR='+_idr+' AND TEXST=0 ORDER BY SEQ';    //!
  qr3:= mysql.Query(q3);
   if qr3 = nil then ShowMySQLError(MySQL)
    else begin
      otpr:=''; prib:='';
      while qr3.FetchRow do begin
       if otpr='' then begin
        otpr:=qr3.ValueByName['OTPR'];
        sotpr:=qr3.ValueByName['IDRP'];
       end;
       prib:=qr3.ValueByName['PRIB'];
       sprib:=qr3.ValueByName['IDRP'];
      end;
      _thc.st1:=getstn(sotpr);
      _thc.st2:=getstn(sprib);
      prib:=StrReplace(prib,'.',':');
      otpr:=StrReplace(otpr,'.',':');
      _thc.dep:=preprzrtime(otpr);
      _thc.arr:=preprzrtime(prib);
    end;
end; //_procth
begin
  cdn.create; cdc.create;
  if idxml='1622416' then begin
   sleep(5);
  end;
  result:='0';
  idtrain:='0';
  pzl.number:='';
  pzl.title:='';
  pzl.dep:='';
  pzl.arr:='';
  pzl.date1:='[ ]';
  pzl.date2:='';
  pzl.date1a:='';
  pzl.date2a:='';
  pzl.idr:='';
{  q1:='SELECT * from `scalendar` WHERE ID_XML='+idxml;
  qr1:=mysql.Query(q1);
  pzl.date1a:=inttostr(qr1.RecordCount);
  q2:='SELECT * from `srasprp` WHERE ID_XML='+idxml;
  qr2:=mysql.Query(q2);
  pzl.date1a:=pzl.date1a+' '+inttostr(qr2.RecordCount);
  q3:='SELECT * from `strains` WHERE ID_XML='+idxml;
  qr3:=mysql.Query(q3);
  pzl.date2a:=inttostr(qr3.RecordCount);
  q4:='SELECT distinct IDR from `strainsvar` WHERE ID_XML='+idxml;
  qr4:=mysql.Query(q4);
  pzl.date2a:=pzl.date2a+' '+inttostr(qr4.RecordCount); }
  q1:='SELECT * from `strainsvar` WHERE ID_XML='+idxml;
  qr1:=mysql.Query(q1);
  if qr1.RecordCount>0 then begin
       qr1.FetchRow;
       idr1:=qr1.ValueByName['IDR'];
       pzl.idr:=idr1;
       idtr1:=qr1.ValueByName['IDTR'];
       _procth(idr1,thcf1);
       _proccal;
       pzl.title:=thcf1.st1+' - '+thcf1.st2;
       pzl.dep:=thcf1.dep;
       pzl.arr:=thcf1.arr;
       pzl.date1:=cdl2txt(@cdn);
       pzl.date2:=cdl2txt(@cdc);
       if cdc.count=0 then begin
        result:=idr1;
        if cdn.count>10 then begin
         pzl.date1a:=cdl2F(@cdn);
         pzl.date2a:=cdl2L(@cdn);
        end;
       end;
       if cdn.count=0 then begin
        if cdc.count>10 then begin
         pzl.date1a:=cdl2F(@cdc);
         pzl.date2a:=cdl2L(@cdc);
        end;
       end;
       pzl.number:=_numtrain(idtr1);
       _procidtr(idtr1,thcf2);
       if validstr(thcf2.newgrph) then pzl.title:=thcf2.newgrph+pzl.title;
  end
   else begin
    q2:='SELECT DISTINCT IDR from `scalendar` WHERE ID_XML='+idxml;
    qr2:=mysql.Query(q2);
    if qr2.RecordCount=1 then begin
      qr2.FetchRow;
      idr1:=qr2.ValueByName['IDR'];
      cdn.clear;
      cdc.clear;
      if strtointe(idr1)>0 then begin
        result:=idr1;
        _procth(idr1,thcf1);
        pzl.title:=thcf1.st1+' - '+thcf1.st2;
        pzl.dep:=thcf1.dep;
        pzl.arr:=thcf1.arr;
        cdc.clear; cdn.clear;
        q4:='SELECT * from `scalendar` WHERE ID_XML='+idxml+' ORDER BY CDATE';
        qr4:=mysql.Query(q4);
        while qr4.FetchRow do begin
          cdate1:=qr4.ValueByName['CDATE'];
          oper1:=qr4.ValueByName['OPER'];
          idtrain:=qr4.ValueByName['IDTR'];
          if (strtointe(oper1) in [0,1,3]) then begin
            if cdn.SearchString(cdate1)<=0 then cdn.add(cdate1);
          end
           else begin
            if cdc.SearchString(cdate1)<=0 then cdc.add(cdate1);
           end;
        end;
      end
       else begin
        cdc.clear; cdn.clear;
        q4:='SELECT * from `scalendar` WHERE ID_XML='+idxml+' ORDER BY CDATE';
        qr4:=mysql.Query(q4);
        while qr4.FetchRow do begin
          if pzl.number='' then begin
            idtrain:=qr4.ValueByName['IDTR'];
            _procidtr(qr4.ValueByName['IDTR'],thcf1);
            pzl.number:=thcf1.num;
            pzl.title:=thcf1.st1+' - '+thcf1.st2;
            if validstr(thcf1.newgrph) then pzl.title:=thcf1.newgrph+pzl.title;
          end;
          cdate1:=qr4.ValueByName['CDATE'];
          if cdc.SearchString(cdate1)<=0 then cdc.add(cdate1);
        end;
       end;
       pzl.date1:=cdl2txt(@cdn);
       pzl.date2:=cdl2txt(@cdc);
       if cdc.count=0 then begin
        if cdn.count>10 then begin
         pzl.date1a:=cdl2F(@cdn);
         pzl.date2a:=cdl2L(@cdn);
        end;
       end;
       if cdn.count=0 then begin
        if cdc.count>10 then begin
         pzl.date1a:=cdl2F(@cdc);
         pzl.date2a:=cdl2L(@cdc);
        end;
       end;
    end
     else begin
       if qr2.RecordCount>1 then begin
        cdc.clear; cdn.clear;
        q3:='SELECT * from `scalendar` WHERE ID_XML='+idxml+' ORDER BY CDATE';    //!
        qr3:= mysql.Query(q3);
         if qr3 = nil then ShowMySQLError(MySQL)
          else begin
            while qr3.FetchRow do begin
              cdate1:=qr3.ValueByName['CDATE'];
              oper1:=qr3.ValueByName['OPER'];
              idtrain:=qr3.ValueByName['IDTR'];
              if strtointe(qr3.ValueByName['IDR'])>0 then begin
                if strtointe(qr3.ValueByName['IDR'])>0 then result:=qr3.ValueByName['IDR'];
                if (strtointe(oper1) in [0,1,3]) then begin
                  if cdn.SearchString(cdate1)<=0 then cdn.add(cdate1);
                end
               else begin
                  if cdc.SearchString(cdate1)<=0 then cdc.add(cdate1);
                 end;
              end
               else begin
                  if cdc.SearchString(cdate1)<=0 then cdc.add(cdate1);
               end;
            end;
          end;
       pzl.date1:=cdl2txt(@cdn);
       pzl.date2:=cdl2txt(@cdc);
       if cdc.count=0 then begin
        if cdn.count>10 then begin
         pzl.date1a:=cdl2F(@cdn);
         pzl.date2a:=cdl2L(@cdn);
        end;
       end;
       if cdn.count=0 then begin
        if cdc.count>10 then begin
         pzl.date1a:=cdl2F(@cdc);
         pzl.date2a:=cdl2L(@cdc);
        end;
       end;
//         ShowMessage(' IDR    -  ID_XML='+idxml);
         _proccal;
       end;
     end;
   end;
//  pzl.title:='sc='+inttostr(qr1.RecordCount)+' '+'st='+inttostr(qr3.RecordCount)+' '+'stv='+inttostr(qr4.RecordCount)+' '+'srrp='+inttostr(qr2.RecordCount);
  if pzl.idr='' then pzl.idr:=result;
  cdn.free; cdc.free;
end;

procedure ReloadAllCache;
  var idtrl,idrl,cdl,opl,u,idr2,cdl2,cdl3:AF_Types.TStrings;
  var i,z,sqs,sccount,x,qqc,qqc1,cdln:integer;
  var idxml,idtr,idr,idtrnum,idtrs1,idtrs2,idrs1,idrs2,cdate,op,q1,q2,q3,q4,q5,q6,qm,vuid,xv,idr1,op1,oldidtr,otpr,prib,idtr_idr,prib0,otpr0,st,vkop,sprib,sotpr,sprib0,sotpr0,idtr2,syear,idow,firstz1,idtr9,idr9,idk,cdate1,oper1,s94:string;
  var MySQL, MySQL_M: IMySQL;
  var MySQL_PZ: IMySQL;
  var query_result1,query_result2,query_result3,query_result4,query_result5,qr6,query_result_m: IMySQLQuery;
  var timest1:TDateTime;
  var pzl:TPZList;
  var s94flg,immsavelog:boolean;
begin
immsavelog:=false;
rgchflag:=true;
markers.clear;
_sqllog.clear;
_markc1.clear; _markc2.clear;
idtrl.create; idrl.create; cdl.create; opl.create; u.create; idr2.create; cdl2.create; cdl3.create;
with form1 do begin
//  Label8.caption:='0 ';
  label1.caption:='...';
  sqs:=0;
  RadioGroup1.ItemIndex:=0;
  ClearSG(stringgrid1);
  stringgrid1.rowcount:=10;
  ClearSG(stringgrid1);
  markers.clear;
  timest1:=now;
  _sqllog.add('');
//  q1:='SELECT * from `rzd_buffer_change_spec_buf` WHERE ID_XML>='+inttostr(rzdchgnum)+' ORDER BY ID_XML';
//  q1:='SELECT * from `rzd_buffer_change_spec_buf` WHERE ID_XML>='+inttostr(rzdchgnum)+' AND ID_XML<6000000 ORDER BY ID_XML';
//  q1:='SELECT * from `rzd_buffer_change_spec_buf` WHERE ID_XML=1624177';
//  q1:='SELECT * from `rzd_buffer_change_spec_buf` WHERE ID_XML>1624100 AND ID_XML<1624174';
  if rzdchgnum>0 then firstz1:=inttostr(rzdchgnum)
                 else firstz1:=GetFirstZ1;
  q1:='SELECT * from `rzd_buffer_change_spec_buf` WHERE ID_XML>='+firstz1+' AND ID_XML<6000000 ORDER BY ID_XML';
  inc(sqs);
  z:=1;
 MySQL_PZ := TMySQL.Create;
 MySQL_PZ.Host := cfg_mysql_markers_host;
 MySQL_PZ.Port := strtointe(cfg_mysql_markers_port);
 MySQL_PZ.User := cfg_mysql_markers_user;
 MySQL_PZ.Password := cfg_mysql_markers_password;
 MySQL_PZ.Database := 'rzday2';
 if not MySQL_PZ.Connect then ShowMySQLError(MySQL_PZ);
 MySQL_M := TMySQL.Create;
 MySQL_M.Host := cfg_mysql_markers_host;
 MySQL_M.Port := strtointe(cfg_mysql_markers_port);
 MySQL_M.User := cfg_mysql_markers_user;
 MySQL_M.Password := cfg_mysql_markers_password;
 if not MySQL_M.Connect then ShowMySQLError(MySQL_M)
 else begin
  MySQL_M.Database := cfg_mysql_markers_database;
  MySQL := TMySQL.Create;
  MySQL.Host := cfg_mysql_host;
  MySQL.Port := strtointe(cfg_mysql_port);
  MySQL.User := cfg_mysql_user;
  MySQL.Password := cfg_mysql_password;
  if not MySQL.Connect then ShowMySQLError(MySQL)
   else begin
    MySQL.Database := cfg_mysql_database;
    MySQL.Query('set character_set_client=''utf8'';');
    MySQL.Query('set character_set_results=''utf8'';');
    MySQL.Query('set collation_connection=''utf8_bin'';');
    query_result1:= MySQL.Query(q1);
//    query_result1:= MySQL_PZ.Query(q1);   // !!!!!!!!!!!!!!!!!   !!!!!!!!!!!!!!!!!!!!!!!!!!!
    _sqllog.add(GetTimeS+' '+q1+';    '+inttostr(query_result1.RecordCount));
    if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
//    inputquery('','',q1);
     if query_result1 = nil then ShowMySQLError(MySQL)
        else begin
          qqc1:=0;
          qqc:=query_result1.RecordCount;
          while query_result1.FetchRow do begin //while1
            inc(qqc1);
//            if qqc1=600 then exit;
            StatusBar1.SimpleText:=inttostr(qqc1)+'  '+inttostr(qqc);
            application.ProcessMessages;
            sccount:=0;
//            showmessage(query_result1.ValueByName['IDTR']);
            idxml:=query_result1.ValueByName['ID_XML'];
            vkop:=query_result1.ValueByName['KOP'];
            q2:='SELECT * from `rzd_buffer_change_scalendar_buf` WHERE ID_XML='+idxml+' ORDER BY IDR, OPER, CDATE';
            inc(sqs);
            query_result2:= MySQL.Query(q2);
            _sqllog.add(GetTimeS+'  '+q2+';    '+inttostr(query_result2.RecordCount));
            if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
            if query_result2 = nil then ShowMySQLError(MySQL)
             else begin
              idtrl.clear; idrl.clear; cdl.clear; opl.clear;
              xv:='';
              oldidtr:='';
              while query_result2.FetchRow do begin //while2
               inc(sccount);
               idtr:=query_result2.ValueByName['IDTR'];
                 if idtr<>oldidtr then begin
                  idtrnum:='';
                  idtrs1:='';
                  idtrs2:='';
                  q3:='SELECT id,IDTR,NUM,RP1,RPK,IDR,CODEOWNER from `rzd_buffer_current_strains` WHERE IDTR='+idtr;
                  inc(sqs);
                  query_result3:= MySQL.Query(q3);
                  _sqllog.add(GetTimeS+'    '+q3+';    '+inttostr(query_result3.RecordCount));
                  if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                   if query_result3 = nil then ShowMySQLError(MySQL)
                    else begin
                      while query_result3.FetchRow do begin
                        idtrnum:=query_result3.ValueByName['NUM'];
                        idtr_idr:=query_result3.ValueByName['IDR'];
                        idtrs1:=query_result3.ValueByName['RP1'];
                        idtrs2:=query_result3.ValueByName['RPK'];
                        idow:=query_result3.ValueByName['CODEOWNER'];
                        sotpr:=idtrs1;
                        sprib:=idtrs2;
                        _markc1.add(idxml);
                        _markc2.add(idtr_idr);
                        q4:='SELECT id,IDR,YEAR from `rzd_buffer_current_strainsvar` WHERE IDR='+query_result3.ValueByName['IDR'];
                        query_result4:= MySQL.Query(q4);
                        _sqllog.add(GetTimeS+'    '+q4+';    '+inttostr(query_result4.RecordCount));
                        if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                        query_result4.FetchRow;
                        syear:=gpGraph(query_result4.ValueByName['YEAR'],idow);
                      end;
                    end;
                 end;
                 oldidtr:=idtr;
               idr:=query_result2.ValueByName['IDR'];
               cdate:=query_result2.ValueByName['CDATE'];
               op:=query_result2.ValueByName['OPER'];
               vuid:=idxml+'_'+idr+'_'+op;
               if vuid<>xv then begin
                if xv<>'' then begin
                if op1<>'-1' then begin
                 if stringgrid1.rowcount<z then stringgrid1.RowCount:=z;
                    st:='1';
                    qm:='SELECT * FROM `markers` WHERE ID_XML='+idxml+' AND IDR='+idr1+' AND OP='+op1;
                    query_result_m := MySQL_M.Query(qm);
                     if query_result_m = nil then ShowMySQLError(MySQL_M)
                                           else begin
                                            if query_result_m.RecordCount>0 then begin
                                             query_result_m.FetchRow;
                                             st:=query_result_m.ValueByName['status'];
                                            end;
                                           end;
                 markers.add(st);
                 StringGrid1.Cells[8,z-1]:=idxml+'_'+idr1+'_'+op1;
                 if vkop<>'2' then StringGrid1.Cells[0,z-1]:=idtrnum+' '+vkop
                              else StringGrid1.Cells[0,z-1]:=idtrnum;
                 if idr1<>'0' then begin
                      q4:='SELECT id,IDR,YEAR from `rzd_buffer_current_strainsvar` WHERE IDR='+idr1;
                      query_result4:= MySQL.Query(q4);
                      _sqllog.add(GetTimeS+'    '+q4+';    '+inttostr(query_result4.RecordCount));
                      if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                      query_result4.FetchRow;
                      q3:='SELECT IDR,IDRP,SEQ,PRIB,OTPR,TEXST from `rzd_buffer_current_srasprp` WHERE IDR='+idr1+' AND TEXST=0 ORDER BY SEQ';    //!
                      inc(sqs);
                      query_result3:= MySQL.Query(q3);
                      _sqllog.add(GetTimeS+'    '+q3+';    '+inttostr(query_result3.RecordCount));
                      if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                       if query_result3 = nil then ShowMySQLError(MySQL)
                        else begin
                          otpr:=''; prib:='';
                          sotpr:=''; sprib:='';
                          while query_result3.FetchRow do begin
                            if otpr='' then begin
                              otpr:=query_result3.ValueByName['OTPR'];
                              sotpr:=query_result3.ValueByName['IDRP'];
                            end;
                            prib:=query_result3.ValueByName['PRIB'];
                            sprib:=query_result3.ValueByName['IDRP'];
                          end;
                          StringGrid1.Cells[1,z-1]:=gpGraph(query_result4.ValueByName['YEAR'],idow)+getstn(sotpr)+' - '+getstn(sprib);
                          StringGrid1.Cells[2,z-1]:=PrepRZRTime(otpr);
                          StringGrid1.Cells[3,z-1]:=PrepRZRTime(prib);
                        end;
                 end;
                 if ((idr1='0')or(op1='1')) then begin
//!                   StringGrid1.Cells[1,z-1]:=getstn(idtrs1)+' - '+getstn(idtrs2);
{}                   StringGrid1.Cells[1,z-1]:=getstn(sotpr)+' - '+getstn(sprib)+syear;
                   StringGrid1.Cells[5,z-1]:=cdl2txt(@cdl);
                   if cdl.count>10 then begin
                     StringGrid1.Cells[6,z-1]:=cdl2F(@cdl);
                     StringGrid1.Cells[7,z-1]:=cdl2L(@cdl);
                   end;
                      q4:='SELECT id,IDR,YEAR from `rzd_buffer_current_strainsvar` WHERE IDR='+idtr_idr;
                      query_result4:= MySQL.Query(q4);
                      _sqllog.add(GetTimeS+'    '+q4+';    '+inttostr(query_result4.RecordCount));
                      if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                      query_result4.FetchRow;
                      q3:='SELECT IDR,IDRP,SEQ,PRIB,OTPR,TEXST from `rzd_buffer_current_srasprp` WHERE IDR='+idtr_idr+' AND TEXST=0 ORDER BY SEQ';
                      inc(sqs);
                      query_result3:= MySQL.Query(q3);
                      _sqllog.add(GetTimeS+'    '+q3+';    '+inttostr(query_result3.RecordCount));
                      if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                       if query_result3 = nil then ShowMySQLError(MySQL)
                        else begin
                          otpr0:=''; prib0:='';
                          sotpr0:=idtrs1;
                          sprib0:=idtrs2;
                          while query_result3.FetchRow do begin
                            if otpr0='' then begin
                              otpr0:=query_result3.ValueByName['OTPR'];
                              sotpr0:=query_result3.ValueByName['IDRP'];
                            end;
                            prib0:=query_result3.ValueByName['PRIB'];
                            sprib0:=query_result3.ValueByName['IDRP'];
                          end;
                          StringGrid1.Cells[1,z-1]:=gpGraph(query_result4.ValueByName['YEAR'],idow)+getstn(sotpr0)+' - '+getstn(sprib0);
                          StringGrid1.Cells[2,z-1]:=PrepRZRTime(otpr0);
                          StringGrid1.Cells[3,z-1]:=PrepRZRTime(prib0);
                        end;
                 end
                  else begin
                      q4:='SELECT id,IDR,YEAR from `rzd_buffer_current_strainsvar` WHERE IDR='+idr1;
                      query_result4:= MySQL.Query(q4);
                      _sqllog.add(GetTimeS+'    '+q4+';    '+inttostr(query_result4.RecordCount));
                      if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                      query_result4.FetchRow;
                      q3:='SELECT id,IDR,RP1,RPK,YEAR from `rzd_buffer_current_strainsvar` WHERE IDR='+idr1;
                      inc(sqs);
                      query_result3:= MySQL.Query(q3);
                      _sqllog.add(GetTimeS+'    '+q3+';    '+inttostr(query_result3.RecordCount));
                      if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                      idrs1:='';
                      idrs2:='';
                       if query_result3 = nil then ShowMySQLError(MySQL)
                        else begin
                          while query_result3.FetchRow do begin
                            idrs1:=query_result3.ValueByName['RP1'];
                            idrs2:=query_result3.ValueByName['RPK'];
                          end;
                        end;
                   StringGrid1.Cells[1,z-1]:=gpGraph(query_result4.ValueByName['YEAR'],idow)+getstn(idrs1)+' - '+getstn(idrs2);
                   StringGrid1.Cells[4,z-1]:=cdl2txt(@cdl);
                   if cdl.count>10 then begin
                     StringGrid1.Cells[6,z-1]:=cdl2F(@cdl);
                     StringGrid1.Cells[7,z-1]:=cdl2L(@cdl);
                   end;
                  end;
                    if ((not validstr(StringGrid1.Cells[2,z-1]))and(not validstr(StringGrid1.Cells[5,z-1]))) then begin
                     StringGrid1.Cells[6,z-1]:='^'+StringGrid1.Cells[6,z-1];
                     StringGrid1.Cells[7,z-1]:='^'+StringGrid1.Cells[7,z-1];
                     s94:=StringGrid1.Cells[8,z-1];
                     if length(s94)>0 then s94[length(s94)]:='9';
                     StringGrid1.Cells[8,z-1]:=s94;
                     s94flg:=true;
                    end
                     else s94flg:=false;
                 inc(z);
                end;
                cdl.clear;
                end;
               end;
               xv:=vuid;
               idr1:=idr;
               op1:=op;
               cdln:=cdl.SearchString(cdate);
               if cdln=0 then cdl.add(cdate);
               if idtrl.SearchString(idtr)<=0 then idtrl.add(idtr);
              end; //while2
               if idtrl.count>1 then ShowMessage('  IDTR  ID_XML: '+idtrl.Text1+'  '+idxml+' !');
                if xv<>'' then begin  //m3
                if op1<>'-1' then begin
                 if stringgrid1.rowcount<z then stringgrid1.RowCount:=z;
                    st:='1';
                    qm:='SELECT * FROM `markers` WHERE ID_XML='+idxml+' AND IDR='+idr1+' AND OP='+op1;
                    query_result_m := MySQL_M.Query(qm);
                     if query_result_m = nil then ShowMySQLError(MySQL_M)
                                           else begin
                                            if query_result_m.RecordCount>0 then begin
                                             query_result_m.FetchRow;
                                             st:=query_result_m.ValueByName['status'];
                                            end;
                                           end;
                    markers.add(st);
                 StringGrid1.Cells[8,z-1]:=idxml+'_'+idr1+'_'+op1;
                  if vkop<>'2' then StringGrid1.Cells[0,z-1]:=idtrnum+' '+vkop
                               else StringGrid1.Cells[0,z-1]:=idtrnum;
                 if idr1<>'0' then begin
                      q4:='SELECT id,IDR,YEAR from `rzd_buffer_current_strainsvar` WHERE IDR='+idr1;
                      query_result4:= MySQL.Query(q4);
                      _sqllog.add(GetTimeS+'    '+q4+';    '+inttostr(query_result4.RecordCount));
                      if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                      query_result4.FetchRow;
                      q3:='SELECT IDR,IDRP,SEQ,PRIB,OTPR,TEXST from `rzd_buffer_current_srasprp` WHERE IDR='+idr1+' AND TEXST=0 ORDER BY SEQ';          //!
                      inc(sqs);
                      query_result3:= MySQL.Query(q3);
                      _sqllog.add(GetTimeS+'    '+q3+';    '+inttostr(query_result3.RecordCount));
                      if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                       if query_result3 = nil then ShowMySQLError(MySQL)
                        else begin
                          otpr:=''; prib:='';
                          sotpr:=''; sprib:='';
                          while query_result3.FetchRow do begin
                            if otpr='' then begin
                              otpr:=query_result3.ValueByName['OTPR'];
                              sotpr:=query_result3.ValueByName['IDRP'];
                            end;
                            prib:=query_result3.ValueByName['PRIB'];
                            sprib:=query_result3.ValueByName['IDRP'];
                          end;
                          StringGrid1.Cells[1,z-1]:=gpGraph(query_result4.ValueByName['YEAR'],idow)+getstn(sotpr)+' - '+getstn(sprib);
                          StringGrid1.Cells[2,z-1]:=PrepRZRTime(otpr);
                          StringGrid1.Cells[3,z-1]:=PrepRZRTime(prib);
                        end;
                 end;
                 if ((idr1='0')or(op1='1')) then begin
{}                   StringGrid1.Cells[1,z-1]:=getstn(idtrs1)+' - '+getstn(idtrs2)+syear;
                   StringGrid1.Cells[5,z-1]:=cdl2txt(@cdl);
                   if cdl.count>10 then begin
                     StringGrid1.Cells[6,z-1]:=cdl2F(@cdl);
                     StringGrid1.Cells[7,z-1]:=cdl2L(@cdl);
                   end;
                      q4:='SELECT id,IDR,YEAR from `rzd_buffer_current_strainsvar` WHERE IDR='+idtr_idr;
                      query_result4:= MySQL.Query(q4);
                      _sqllog.add(GetTimeS+'    '+q4+';    '+inttostr(query_result4.RecordCount));
                      if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                      query_result4.FetchRow;
                      q3:='SELECT IDR,IDRP,SEQ,PRIB,OTPR,TEXST from `rzd_buffer_current_srasprp` WHERE IDR='+idtr_idr+' AND TEXST=0 ORDER BY SEQ';
                      inc(sqs);
                      query_result3:= MySQL.Query(q3);
                      _sqllog.add(GetTimeS+'    '+q3+';    '+inttostr(query_result3.RecordCount));
                      if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                       if query_result3 = nil then ShowMySQLError(MySQL)
                        else begin
                          otpr0:=''; prib0:='';
                          sotpr0:=idtrs1;
                          sprib0:=idtrs2;
                          while query_result3.FetchRow do begin
                            if otpr0='' then begin
                              otpr0:=query_result3.ValueByName['OTPR'];
                              sotpr0:=query_result3.ValueByName['IDRP'];
                            end;
                            prib0:=query_result3.ValueByName['PRIB'];
                            sprib0:=query_result3.ValueByName['IDRP'];
                          end;
                          StringGrid1.Cells[1,z-1]:=gpGraph(query_result4.ValueByName['YEAR'],idow)+getstn(sotpr0)+' - '+getstn(sprib0);
                          StringGrid1.Cells[2,z-1]:=PrepRZRTime(otpr0);
                          StringGrid1.Cells[3,z-1]:=PrepRZRTime(prib0);
                        end;
                 end
                  else begin
                      q3:='SELECT id,IDR,RP1,RPK,YEAR from `rzd_buffer_current_strainsvar` WHERE IDR='+idr1;
                      inc(sqs);
                      query_result3:= MySQL.Query(q3);
                      _sqllog.add(GetTimeS+'    '+q3+';    '+inttostr(query_result3.RecordCount));
                      if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                       if query_result3 = nil then ShowMySQLError(MySQL)
                        else begin
                          while query_result3.FetchRow do begin
                            idrs1:=query_result3.ValueByName['RP1'];
                            idrs2:=query_result3.ValueByName['RPK'];
                          end;
                        end;
//                   StringGrid1.Cells[1,z-1]:=getstn(idrs1)+' - '+getstn(idrs2);
                   StringGrid1.Cells[4,z-1]:=cdl2txt(@cdl);
                   if cdl.count>10 then begin
                     StringGrid1.Cells[6,z-1]:=cdl2F(@cdl);
                     StringGrid1.Cells[7,z-1]:=cdl2L(@cdl);
                   end;
                  end;
                          if ((not validstr(StringGrid1.Cells[2,z-1]))and(not validstr(StringGrid1.Cells[5,z-1]))) then begin
                           if _pzmode then FindPZ(MySQL_PZ,idxml,pzl,idtr9);
                           StringGrid1.Cells[1,z-1]:=pzl.title;
                           StringGrid1.Cells[2,z-1]:=pzl.dep;
                           StringGrid1.Cells[3,z-1]:=pzl.arr;
                           if not(validstr(StringGrid1.Cells[0,z-1])) then StringGrid1.Cells[0,z-1]:=pzl.number;
                           StringGrid1.Cells[6,z-1]:='#'+StringGrid1.Cells[6,z-1];
                           StringGrid1.Cells[7,z-1]:='#'+StringGrid1.Cells[7,z-1];
                           s94:=StringGrid1.Cells[8,z-1];
                           if length(s94)>0 then s94[length(s94)]:='9';
                           StringGrid1.Cells[8,z-1]:=s94;
                           s94flg:=true;
                          end
                           else s94flg:=false;
                 inc(z);
                end;
                cdl.clear;
                end; //m3
                if sccount=0 then begin
                   q3:='SELECT DISTINCT IDR from `rzd_buffer_change_srasprp_buf` WHERE ID_XML='+idxml;
                   inc(sqs);
                   query_result3:= MySQL.Query(q3);
                   _sqllog.add(GetTimeS+'    '+q3+';    '+inttostr(query_result3.RecordCount));
                   if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');

{                   q5:='SELECT * from `rzd_buffer_current_strainsvar` WHERE IDR='+inttostr(strtointe(idxml)-1);
                   inc(sqs);
                   query_result5:= MySQL.Query(q5);
                   _sqllog.add(GetTimeS+'    '+q5+';    '+inttostr(query_result5.RecordCount)); }

                   idr2.clear;
                    if query_result3 = nil then ShowMySQLError(MySQL)
                     else begin
                       while query_result3.FetchRow do begin
                        idr2.add(query_result3.ValueByName['IDR']);
                       end;
                     end;
                   if idr2.count>0 then begin
                    for x:=1 to idr2.count do begin
                      if stringgrid1.rowcount<z then stringgrid1.RowCount:=z;
                      q4:='SELECT id,IDR,YEAR from `rzd_buffer_current_strainsvar` WHERE IDR='+idr2.getstring(x);
                      query_result4:= MySQL.Query(q4);
                      _sqllog.add(GetTimeS+'    '+q4+';    '+inttostr(query_result4.RecordCount));
                      if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                      query_result4.FetchRow;
                      q3:='SELECT IDR,IDTR,IDRP,SEQ,PRIB,OTPR,TEXST from `rzd_buffer_change_srasprp_buf` WHERE IDR='+idr2.getstring(x)+' AND ID_XML='+idxml+' AND TEXST=0 ORDER BY SEQ';
                      inc(sqs);
                      query_result3:= MySQL.Query(q3);
                      _sqllog.add(GetTimeS+'    '+q3+';    '+inttostr(query_result3.RecordCount));
                      if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                       if query_result3 = nil then ShowMySQLError(MySQL)
                        else begin
                          otpr0:=''; prib0:='';
                          sotpr0:='';
                          sprib0:='';
                          idtr2:='';
                          while query_result3.FetchRow do begin
                            if otpr0='' then begin
                              otpr0:=query_result3.ValueByName['OTPR'];
                              sotpr0:=query_result3.ValueByName['IDRP'];
                            end;
                            prib0:=query_result3.ValueByName['PRIB'];
                            sprib0:=query_result3.ValueByName['IDRP'];
                            idtr2:=query_result3.ValueByName['IDTR'];
                          end;
                          StringGrid1.Cells[1,z-1]:=gpGraph(query_result4.ValueByName['YEAR'],idow)+getstn(sotpr0)+' - '+getstn(sprib0);
                          StringGrid1.Cells[2,z-1]:=PrepRZRTime(otpr0);
                          StringGrid1.Cells[3,z-1]:=PrepRZRTime(prib0);
                          StringGrid1.Cells[8,z-1]:=idxml+'_'+idr2.getstring(x)+'_'+vkop;
                          if idtr2<>'' then begin

                            q3:='SELECT IDTR,NUM,CODEOWNER from `rzd_buffer_current_strains` WHERE IDTR='+idtr2;
                            inc(sqs);
                            query_result3:= MySQL.Query(q3);
                            _sqllog.add(GetTimeS+'    '+q3+';    '+inttostr(query_result3.RecordCount));
                            if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                             if query_result3 = nil then ShowMySQLError(MySQL)
                              else begin
                                while query_result3.FetchRow do begin
                                  StringGrid1.Cells[0,z-1]:=query_result3.ValueByName['NUM'];
                                  idow:=query_result3.ValueByName['CODEOWNER'];
                                end;
 {!!!}                          StringGrid1.Cells[1,z-1]:=gpGraph(query_result4.ValueByName['YEAR'],idow)+getstn(sotpr0)+' - '+getstn(sprib0);
                              end;

                            q3:='SELECT * from `rzd_buffer_current_scalendar` WHERE IDR='+idr2.getstring(x){+' AND CDATE>=NOW()'+}+' ORDER BY CDATE';
                            cdl2.clear;
                            inc(sqs);
                            query_result3:= MySQL.Query(q3);
                            _sqllog.add(GetTimeS+'    '+q3+';    '+inttostr(query_result3.RecordCount));
                            if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                             if query_result3 = nil then ShowMySQLError(MySQL)
                              else begin
                                while query_result3.FetchRow do begin
                                  cdln:=cdl2.SearchString(query_result3.ValueByName['CDATE']);
                                  if cdln=0 then cdl2.add(query_result3.ValueByName['CDATE']);
                                end;
                                if cdl2.count>0 then begin
                                   StringGrid1.Cells[4,z-1]:='[] '+cdl2txt(@cdl2);
                                   if cdl2.count>10 then begin
                                     StringGrid1.Cells[6,z-1]:=cdl2F(@cdl2);
                                     StringGrid1.Cells[7,z-1]:=cdl2L(@cdl2);
                                   end;
                                end
                                 else begin
                                    q3:='SELECT * from `rzd_buffer_current_scalendar` WHERE IDR='+idr2.getstring(x)+' ORDER BY CDATE';
                                    cdl2.clear;
                                    inc(sqs);
                                    query_result3:= MySQL.Query(q3);
                                    _sqllog.add(GetTimeS+'    '+q3+';    '+inttostr(query_result3.RecordCount));
                                    if immsavelog then _sqllog.savetofile(workdir+'sqllog.log');
                                     if query_result3 = nil then ShowMySQLError(MySQL)
                                      else begin
                                        while query_result3.FetchRow do begin
                                          cdln:=cdl2.SearchString(query_result3.ValueByName['CDATE']);
                                          if cdln=0 then cdl2.add(query_result3.ValueByName['CDATE']);
                                        end;
                                        if cdl2.count>0 then begin
                                           StringGrid1.Cells[4,z-1]:='[] '+cdl2txt(@cdl2);
                                           if cdl2.count>10 then begin
                                             StringGrid1.Cells[6,z-1]:=cdl2F(@cdl2);
                                             StringGrid1.Cells[7,z-1]:=cdl2L(@cdl2);
                                           end;
                                        end
                                         else StringGrid1.Cells[4,z-1]:='[] ERROR';
                                      end;
                                 end;
                              end;

                          end;
                            st:='1';
                            qm:='SELECT * FROM `markers` WHERE ID_XML='+idxml+' AND IDR='+idr2.getstring(x)+' AND OP='+vkop;
                            query_result_m := MySQL_M.Query(qm);
                             if query_result_m = nil then ShowMySQLError(MySQL_M)
                                                   else begin
                                                    if query_result_m.RecordCount>0 then begin
                                                     query_result_m.FetchRow;
                                                     st:=query_result_m.ValueByName['status'];
                                                    end
                                                     else begin
                                                       qm:='INSERT INTO `markers` (`id`, `ID_XML`, `IDR`, `OP`, `status`) VALUES (NULL, '+idxml+', '+idr2.getstring(x)+', '+vkop+', 1)';
                                                       query_result_m := MySQL_M.Query(qm);
                                                     end;
                                                   end;
                            markers.add(st);
                          if ((not validstr(StringGrid1.Cells[2,z-1]))and(not validstr(StringGrid1.Cells[5,z-1]))) then begin
                           StringGrid1.Cells[6,z-1]:='~'+StringGrid1.Cells[6,z-1];
                           StringGrid1.Cells[7,z-1]:='~'+StringGrid1.Cells[7,z-1];
                           s94:=StringGrid1.Cells[8,z-1];
                           if length(s94)>0 then s94[length(s94)]:='9';
                           StringGrid1.Cells[8,z-1]:=s94;
                           s94flg:=true;
                          end
                           else s94flg:=false;
                          inc(z);
                        end;
                    end;

                   end  //idr.count>0
                    else begin //if9
                     if stringgrid1.rowcount<z then stringgrid1.RowCount:=z;
                     StringGrid1.Cells[4,z-1]:='[ ]'+StringGrid1.Cells[4,z-1];
                     //   
                     idr9:='0'; idk:='0';
                     if _pzmode then begin
                       idr9:=FindPZ(MySQL_PZ,idxml,pzl,idtr9);
                       idk:='9';
                       cdl3.clear;
                       StringGrid1.Cells[0,z-1]:=pzl.number;
                       StringGrid1.Cells[1,z-1]:=pzl.title;
                       StringGrid1.Cells[2,z-1]:=pzl.dep;
                       StringGrid1.Cells[3,z-1]:=pzl.arr;
                       StringGrid1.Cells[4,z-1]:=pzl.date1;
                       StringGrid1.Cells[5,z-1]:=pzl.date2;
                       StringGrid1.Cells[6,z-1]:='*'+pzl.date1a;
                       StringGrid1.Cells[7,z-1]:='*'+pzl.date2a;
                       if pzl.number='' then begin
                            q3:='SELECT IDTR,NUM,CODEOWNER from `rzd_buffer_current_strains` WHERE IDTR='+idtr9;
                            query_result3:= MySQL.Query(q3);
                             if query_result3 = nil then ShowMySQLError(MySQL)
                              else begin
                                while query_result3.FetchRow do begin
                                  StringGrid1.Cells[0,z-1]:=query_result3.ValueByName['NUM'];
                                end;
                              end;
                       end;
                       if ((pzl.title=' - ')or(pzl.title='')) then begin
                        idk:='8';
                        q3:='SELECT IDR,IDRP,SEQ,PRIB,OTPR,TEXST from `rzd_buffer_current_srasprp` WHERE IDR='+idr9+' AND TEXST=0 ORDER BY SEQ';    //!
                        query_result3:= MySQL.Query(q3);
                         if query_result3 = nil then ShowMySQLError(MySQL)
                          else begin
                            otpr:=''; prib:='';
                            sotpr:=''; sprib:='';
                            while query_result3.FetchRow do begin
                              if otpr='' then begin
                                otpr:=query_result3.ValueByName['OTPR'];
                                sotpr:=query_result3.ValueByName['IDRP'];
                              end;
                              prib:=query_result3.ValueByName['PRIB'];
                              sprib:=query_result3.ValueByName['IDRP'];
                            end;
                            StringGrid1.Cells[1,z-1]:=getstn(sotpr)+' - '+getstn(sprib);
                            StringGrid1.Cells[2,z-1]:=PrepRZRTime(otpr);
                            StringGrid1.Cells[3,z-1]:=PrepRZRTime(prib);
                          end;
                       end
                        else begin
                          if validstr(pzl.date1) then if pzl.date1<>'[ ]' then idr9:=pzl.idr;
                        end;
                       if ((pzl.date1='')and(pzl.date2='')) then begin
                        q3:='SELECT * from `rzd_buffer_current_scalendar` WHERE IDR='+idr9+' ORDER BY CDATE';
                        query_result3:=mysql.Query(q3);
                        while query_result3.FetchRow do begin
                          cdate1:=query_result3.ValueByName['CDATE'];
                          oper1:=query_result3.ValueByName['OPER'];
                          if (strtointe(oper1) in [0,1,3]) then begin
                            if cdl3.SearchString(cdate1)<=0 then cdl3.add(cdate1);
                          end
                        end;
                        if cdl3.count>0 then StringGrid1.Cells[4,z-1]:='[] '+cdl2txt(@cdl3)
                                        else StringGrid1.Cells[4,z-1]:='[ ]';
                       end;
                     end; //pzmode
                     StringGrid1.Cells[8,z-1]:=idxml+'_'+idr9+'_'+idk;
                     //
                            st:='1';
                            qm:='SELECT * FROM `markers` WHERE ID_XML='+idxml+' AND IDR='+idr9+' AND OP='+idk;
                            query_result_m := MySQL_M.Query(qm);
                             if query_result_m = nil then ShowMySQLError(MySQL_M)
                                                   else begin
                                                    if query_result_m.RecordCount>0 then begin
                                                     query_result_m.FetchRow;
                                                     st:=query_result_m.ValueByName['status'];
                                                    end
                                                     else begin
                                                       qm:='INSERT INTO `markers` (`id`, `ID_XML`, `IDR`, `OP`, `status`) VALUES (NULL, '+idxml+', '+idr9+', '+idk+', 1)';
                                                       query_result_m := MySQL_M.Query(qm);
                                                     end;
                                                   end;
                            markers.add(st);
                     inc(z);
                     s94flg:=false;
                    end; //if9
                end;
             end;
          end; //while 1
        end;
    MySQL.Disconnect;
   end;
   MySQL_M.Disconnect;
   MySQL_PZ.Disconnect;
  end;
  if stringgrid1.cells[0,stringgrid1.RowCount-1]='' then stringgrid1.RowCount:=stringgrid1.RowCount-1;
  _maincache.clear;
  for i:=0 to stringgrid1.RowCount-1 do begin
    if validstr(stringgrid1.Cells[8,i]) then begin
      _maincache.add(stringgrid1.Cells[0,i]+#9+stringgrid1.Cells[1,i]+#9+stringgrid1.Cells[2,i]+#9+stringgrid1.Cells[3,i]+#9+stringgrid1.Cells[4,i]+#9+stringgrid1.Cells[5,i]+#9+stringgrid1.Cells[6,i]+#9+stringgrid1.Cells[7,i]+#9+stringgrid1.Cells[8,i]+#9+markers.getstring(i+1));
    end;
  end;
end; // with
idtrl.free; idrl.free; cdl.free; opl.free; u.free; idr2.free; cdl2.free; cdl3.free;
_sqllog.add('');
_sqllog.add('  '+inttostr(sqs)+'   '+inttostr(SecondsBetween(now,timest1))+' .');
_sqllog.savetofile(workdir+'sqllog.log');
SetL8;
rgchflag:=false;
end;

procedure TForm1.FormCreate(Sender: TObject);
 var f,u:AF_Types.TStrings;
 var i:integer;
begin
//  zmode:=false;
  _pzmode:=false;
  rgchflag:=false;
  workdir:=deleteslasheex(ExtractDirPath(Application.ExeName))+'\';
//  threaddir:='c:\af\rzd_log\';
  st1.create;
  st2.create;
  f.create;
  u.create;
  f.loadfromfile(workdir+'stations1.txt');
  if f.count>0 then begin
   for i:=1 to f.count do begin
    ParseCSVStrEx(@u,f.getstring(i),#9);
    if u.count>1 then begin
      st1.add(u.getstring(1));
      st2.add(ansilowercase(u.getstring(2)));
    end;
   end;
  end;
  u.free;
  f.free;
  _sqllog.create;
  _strepl1.create;
  _strepl2.create;
  strrep1.create;
  strrep2.create;
  numrep1.create;
  numrep2.create;
  numrep3.create;
  timer0.create;
  timer1.create;
  timer2.create;
  timer3.create;
  timer4.create;
  markers.create;
  nesr1.create;
  nesr2.create;
  _maincache.create;
  _markc1.create;
  _markc2.create;
  _stwidth:=form1.width;
  _stheight:=form1.height;
  loadmainini;
  loadesr;
  loadstrep;
  ReloadAllCache;
end;

function getParam(s1,s:string):string;
  var s2:string;
begin
  s:=trim(s);
  s2:='';
  if pos(s1+'="',s)>0 then begin
    s2:=copy(s,pos(s1+'="',s)+2+length(s1),length(s));
     if pos('"',s2)>0 then s2:=copy(s2,1,pos('"',s2)-1);
  end;
  result:=trim(s2);
end;

function stReplace(s:string):string;
  var i,l,l1:integer;
begin
 s:=trim(s);
 if strrep1.count>0 then begin
  for i:=1 to strrep1.count do begin
    s:=StrReplace(s,'','-');
    if pos(strrep1.getstring(i)+' - ',s)=1 then begin
      l:=length(strrep1.getstring(i)+' - ');
      s:=copy(s,l+1,length(s)-l);
      s:=strrep2.getstring(i)+' - '+s;
//    s:=StrReplace(s,strrep1.getstring(i),strrep2.getstring(i));
    end;
    l:=length(' - '+strrep1.getstring(i));
    l1:=length(s)-l+1;
    if l1>0 then begin
    if pos(' - '+strrep1.getstring(i),s)=l1 then begin
      s:=copy(s,1,pos(' - '+strrep1.getstring(i),s)-1);
      s:=s+' - '+strrep2.getstring(i);
//      s:=StrReplace(s,strrep1.getstring(i),strrep2.getstring(i));
    end;
    end;
  end;
 end;
 result:=s;
end;




function delTZ(s:string):string;
begin
 s:=StrReplace(s,';',' ');
 result:=s;
end;

function delnbsp(s:string):string;
begin
 s:=StrReplace(s,'&nbsp;',' ');
 result:=trim(s);
end;


procedure TForm1.FormDestroy(Sender: TObject);
begin
  strrep1.free;
  strrep2.free;
  numrep1.free;
  numrep2.free;
  numrep3.free;
  timer0.free;
  timer1.free;
  timer2.free;
  timer3.free;
  timer4.free;
  st1.free;
  st2.free;
  markers.free;
  nesr1.free;
  nesr2.free;
  _strepl1.free;
  _strepl2.free;
  _sqllog.free;
  _maincache.free;
  _markc1.free;
  _markc2.free;
end;

procedure SaveToTxt2;
 var fl,u,fo:AF_Types.TStrings;
 var z:integer;
begin
with form1 do begin
   fl.create; u.create; fo.create;
   for z:=0 to stringgrid1.RowCount-1 do begin
   fo.add(stringgrid1.cells[0,z]+#9+stringgrid1.cells[1,z]+#9+stringgrid1.cells[2,z]+#9+stringgrid1.cells[3,z]+#9+stringgrid1.cells[4,z]+#9+stringgrid1.cells[5,z]+#9+stringgrid1.cells[6,z]+#9+stringgrid1.cells[7,z]+#9+stringgrid1.cells[8,z]);
   end;
   fo.savetofile(SaveDialog1.FileName);
   fl.free; u.free; fo.free;
end;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  if SaveDialog1.Execute then begin
//    ListBox1.Items.SaveToFile(SaveDialog1.FileName);
    SaveToTxt2;
  end;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
  var ltr,replflag:boolean;
  var s,rst:string;
  var i,h1,m1,h2,m2,ki:integer;
  var fl,u,ll,thr,ff,ps,uz1,uz2,kr,kr2,kr3,kra,krn:AF_Types.TSTrings;
begin
 if not getCtrl then begin
  ll.create;
  thr.create;
  u.create;
  ff.create;
  ps.create;
  uz1.create;
  uz2.create;
  kr.create;
  kr2.create;
  kr3.create;
  kra.create;
  krn.create;
  fl.create;
  if SaveDialog1.Execute then begin
  for i:=0 to stringgrid1.RowCount-1 do begin
   ParseCSVStrEx(@kr2,stringgrid1.Cells[8,i],'_');
   if strtointe(kr2.getstring(2))>0 then begin
                                          kr.add(stringgrid1.Cells[8,i]);
                                          kra.add(stringgrid1.Cells[4,i]);
                                          krn.add(stringgrid1.Cells[0,i]);
                                         end;
  end;
  if kr.count>0 then begin
   for ki:=1 to kr.count do begin
     form1.StatusBar1.SimpleText:=' '+inttostr(ki)+'  '+inttostr(kr.count);
     application.ProcessMessages;
     form2.Memo1.Lines.Clear;
     fl.clear;
     ltr:=LoadTrainFromMySQL(kr.getstring(ki),@fl,replflag,'');
     if ltr then begin
            kr3.add(#9+krn.getstring(ki));
            kr3.add(#9+'#');
            kr3.add(#9+kra.getstring(ki));
            kr3.add(#9);
      clearsg(Form2.stringgrid1);
      form2.StringGrid1.rowcount:=fl.count;
      clearsg(Form2.stringgrid1);
      form2.StringGrid1.rowcount:=fl.count;
      for i:=1 to fl.count do begin
        ParseCSVStrEx(@u,fl.getstring(i),';');
        rst:=strreplace(ansilowercase(u.getstring(1)),'  ','');
        if ansilowercase(u.getstring(2))='-' then u.edit(2,u.getstring(3));
        if ansilowercase(u.getstring(3))='-' then u.edit(3,u.getstring(2));
        tohm(u.getstring(2),h1,m1);
        tohm(u.getstring(3),h2,m2);
        if (h1=h2) and (m1=m2) then begin
          if ((validstr(trim(u.getstring(2))))or(validstr(trim(u.getstring(3))))) then begin
            form2.StringGrid1.Cells[1,i-1]:=ansilowercase(u.getstring(3));
            form2.Memo1.Lines.add(del0t(ansilowercase(u.getstring(3))));
            kr3.add(rst+#9+ansilowercase(u.getstring(3)));
          end
           else begin
            form2.StringGrid1.Cells[1,i-1]:='-';
            form2.Memo1.Lines.add('-');
            kr3.add(rst+#9+'-');
           end;
        end
         else begin
           inchm(h1,m1,1);
            if (h1=h2) and (m1=m2) then begin
             if ((validstr(trim(u.getstring(2))))or(validstr(trim(u.getstring(3))))) then begin
               form2.StringGrid1.Cells[1,i-1]:=ansilowercase(u.getstring(3));
               form2.Memo1.Lines.add(del0t(ansilowercase(u.getstring(3))));
               kr3.add(rst+#9+ansilowercase(u.getstring(3)));
             end
              else begin
               form2.StringGrid1.Cells[1,i-1]:='-';
               form2.Memo1.Lines.add('-');
               kr3.add(rst+#9+'-');
              end;
            end
             else begin
              if ((validstr(trim(u.getstring(2))))or(validstr(trim(u.getstring(3))))) then begin
               form2.StringGrid1.Cells[1,i-1]:=ddiv(ansilowercase(u.getstring(2)),ansilowercase(u.getstring(3)));
               form2.Memo1.Lines.add(del0t(ansilowercase( ddiv(u.getstring(2),ansilowercase(u.getstring(3))))));
               kr3.add(rst+#9+ansilowercase( ddiv(u.getstring(2),ansilowercase(u.getstring(3)))));
              end
               else begin
                form2.StringGrid1.Cells[1,i-1]:='-';
                form2.Memo1.Lines.add('-');
                kr3.add(rst+#9+'-');
               end;
             end;
         end;
        form2.StringGrid1.Cells[0,i-1]:=strreplace(ansilowercase(u.getstring(1)),'  ','');
      end;
     end;
    kr3.add('');
    kr3.add('');
    kr3.add('');
    kr3.add('');
    kr3.add('');
   end; //ki
  end; //kr.count
    kr3.savetofile(savedialog1.FileName);
  end; //savedialog
  fl.free;
  krn.free;
  kra.free;
  kr3.free;
  kr2.free;
  kr.free;
  ps.free;
  u.free;
  thr.free;
  ll.free;
  ff.free;
  uz1.free;
  uz2.free;
  showmessage('end!');
 end
 else begin //ctrl
  clearsg(stringgrid2);
  ll.create;
  thr.create;
  u.create;
  ff.create;
  ps.create;
  uz1.create;
  uz2.create;
  kr.create;
  kr2.create;
  kr3.create;
  kra.create;
  krn.create;
  fl.create;
  if SaveDialog1.Execute then begin
  for i:=0 to stringgrid1.RowCount-1 do begin
   ParseCSVStrEx(@kr2,stringgrid1.Cells[8,i],'_');
   if strtointe(kr2.getstring(2))>0 then begin
                                          kr.add(stringgrid1.Cells[8,i]);
                                          kra.add(stringgrid1.Cells[4,i]);
                                          krn.add(stringgrid1.Cells[0,i]);
                                         end;
  end;
  if kr.count>0 then begin
    stringgrid2.ColCount:=kr.count;
    clearsg(stringgrid2);
   for ki:=1 to kr.count do begin
     kr3.clear;
     form1.StatusBar1.SimpleText:=' '+inttostr(ki)+'  '+inttostr(kr.count);
     application.ProcessMessages;
     form2.Memo1.Lines.Clear;
     fl.clear;
     ltr:=LoadTrainFromMySQL(kr.getstring(ki),@fl,replflag,'');
     if ltr then begin
            kr3.add(krn.getstring(ki));
            kr3.add('#');
            kr3.add(kra.getstring(ki));
            kr3.add('');
      clearsg(Form2.stringgrid1);
      form2.StringGrid1.rowcount:=fl.count;
      clearsg(Form2.stringgrid1);
      form2.StringGrid1.rowcount:=fl.count;
      for i:=1 to fl.count do begin
        ParseCSVStrEx(@u,fl.getstring(i),';');
        rst:=strreplace(ansilowercase(u.getstring(1)),'  ','');
        if ansilowercase(u.getstring(2))='-' then u.edit(2,u.getstring(3));
        if ansilowercase(u.getstring(3))='-' then u.edit(3,u.getstring(2));
        tohm(u.getstring(2),h1,m1);
        tohm(u.getstring(3),h2,m2);
        if (h1=h2) and (m1=m2) then begin
          if ((validstr(trim(u.getstring(2))))or(validstr(trim(u.getstring(3))))) then begin
            form2.StringGrid1.Cells[1,i-1]:=ansilowercase(u.getstring(3));
            form2.Memo1.Lines.add(del0t(ansilowercase(u.getstring(3))));
            kr3.add(ansilowercase(u.getstring(3)));
          end
           else begin
            form2.StringGrid1.Cells[1,i-1]:='-';
            form2.Memo1.Lines.add('-');
            kr3.add('-');
           end;
        end
         else begin
           inchm(h1,m1,1);
            if (h1=h2) and (m1=m2) then begin
             if ((validstr(trim(u.getstring(2))))or(validstr(trim(u.getstring(3))))) then begin
               form2.StringGrid1.Cells[1,i-1]:=ansilowercase(u.getstring(3));
               form2.Memo1.Lines.add(del0t(ansilowercase(u.getstring(3))));
               kr3.add(ansilowercase(u.getstring(3)));
             end
              else begin
               form2.StringGrid1.Cells[1,i-1]:='-';
               form2.Memo1.Lines.add('-');
               kr3.add('-');
              end;
            end
             else begin
              if ((validstr(trim(u.getstring(2))))or(validstr(trim(u.getstring(3))))) then begin
               form2.StringGrid1.Cells[1,i-1]:=ddiv(ansilowercase(u.getstring(2)),ansilowercase(u.getstring(3)));
               form2.Memo1.Lines.add(del0t(ansilowercase( ddiv(u.getstring(2),ansilowercase(u.getstring(3))))));
               kr3.add(ansilowercase( ddiv(u.getstring(2),ansilowercase(u.getstring(3)))));
              end
               else begin
                form2.StringGrid1.Cells[1,i-1]:='-';
                form2.Memo1.Lines.add('-');
                kr3.add('-');
               end;
             end;
         end;
        form2.StringGrid1.Cells[0,i-1]:=strreplace(ansilowercase(u.getstring(1)),'  ','');
      end;
     end;
     if kr3.count>stringgrid2.rowcount then stringgrid2.rowcount:=kr3.count;
     if kr3.count>0 then begin
      for i:=1 to kr3.count do begin
       stringgrid2.cells[ki-1,i-1]:=kr3.getstring(i);
      end;
     end;
   end; //ki
    kr3.clear;
    for h1:=0 to stringgrid2.rowcount-1 do begin
      s:='';
      for m1:=0 to stringgrid2.ColCount-1 do begin
        s:=s+stringgrid2.cells[m1,h1]+#9;
      end;
      kr3.add(s);
    end;
  end; //kr.count
    kr3.savetofile(savedialog1.FileName);
  end; //savedialog
  fl.free;
  krn.free;
  kra.free;
  kr3.free;
  kr2.free;
  kr.free;
  ps.free;
  u.free;
  thr.free;
  ll.free;
  ff.free;
  uz1.free;
  uz2.free;
  showmessage('end!');
 end;
end;

procedure TForm1.StringGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
  var clr:TColor;
  var fst:TFontStyles;
begin
      StringGrid1.Canvas.Font.Color := clBlack;
      if markers.getstring(ARow+1)='1' then StringGrid1.Canvas.Brush.color := clYellow;
      if markers.getstring(ARow+1)='2' then StringGrid1.Canvas.Brush.color := clGreen;
      if markers.getstring(ARow+1)='6' then StringGrid1.Canvas.Brush.color := TColor($7077ff);
      if markers.getstring(ARow+1)='9' then StringGrid1.Canvas.Brush.color := clAqua;
      StringGrid1.canvas.fillRect(Rect);
//      StringGrid1.canvas.TextRect(Rect,Rect.Left,Rect.Top,StringGrid1.Cells[ACol,ARow]);
      clr:=StringGrid1.Canvas.Font.Color;
      fst:=StringGrid1.Canvas.Font.Style;
      case ACol of
        0: begin
            StringGrid1.Canvas.Font.Style:=[fsBold];
            DrawText(StringGrid1.Canvas.Handle, PChar(StringGrid1.Cells[ACol,ARow]), Length(StringGrid1.Cells[ACol,ARow]), Rect, DT_CENTER);
           end;
        1: DrawText(StringGrid1.Canvas.Handle, PChar(StringGrid1.Cells[ACol,ARow]), Length(StringGrid1.Cells[ACol,ARow]), Rect, DT_LEFT);
        2: begin
            DrawText(StringGrid1.Canvas.Handle, PChar(StringGrid1.Cells[ACol,ARow]), Length(StringGrid1.Cells[ACol,ARow]), Rect, DT_CENTER);
           end;
        3: begin
            DrawText(StringGrid1.Canvas.Handle, PChar(StringGrid1.Cells[ACol,ARow]), Length(StringGrid1.Cells[ACol,ARow]), Rect, DT_CENTER);
           end;
        4: DrawText(StringGrid1.Canvas.Handle, PChar(StringGrid1.Cells[ACol,ARow]), Length(StringGrid1.Cells[ACol,ARow]), Rect, DT_LEFT);
        5: begin
            StringGrid1.Canvas.Font.Color:=clRed;
            DrawText(StringGrid1.Canvas.Handle, PChar(StringGrid1.Cells[ACol,ARow]), Length(StringGrid1.Cells[ACol,ARow]), Rect, DT_LEFT);
           end;
        6: begin
            StringGrid1.Canvas.Font.Color:=clGray;
            DrawText(StringGrid1.Canvas.Handle, PChar(StringGrid1.Cells[ACol,ARow]), Length(StringGrid1.Cells[ACol,ARow]), Rect, DT_CENTER);
           end;
        7: begin
            StringGrid1.Canvas.Font.Color:=clGray;
            DrawText(StringGrid1.Canvas.Handle, PChar(StringGrid1.Cells[ACol,ARow]), Length(StringGrid1.Cells[ACol,ARow]), Rect, DT_CENTER);
           end;
        8: begin
            StringGrid1.Canvas.Font.Color:=clSkyBlue;
            DrawText(StringGrid1.Canvas.Handle, PChar(StringGrid1.Cells[ACol,ARow]), Length(StringGrid1.Cells[ACol,ARow]), Rect, DT_LEFT);
           end;
        else DrawText(StringGrid1.Canvas.Handle, PChar(StringGrid1.Cells[ACol,ARow]), Length(StringGrid1.Cells[ACol,ARow]), Rect, DT_LEFT);
      end;
      StringGrid1.Canvas.Font.Color:=clr;
      StringGrid1.Canvas.Font.Style:=fst;
end;

function name2esr(s:string; var esr:string):boolean;
  var n:integer;
begin
  esr:='';
  n:=nesr2.SearchString(s);
  if n>0 then esr:=nesr1.getstring(n);
  if n>0 then result:=true
         else result:=false;
end;

procedure saveesr(name,esr:string);
  var f:AF_Types.Tstrings;
  var i:integer;
begin
  f.create;
  if nesr1.SearchString(esr)<=0 then begin
    nesr1.add(esr);
    nesr2.add(name);
    for i:=1 to nesr1.count do begin
      f.add(nesr1.getstring(i)+';'+nesr2.getstring(i));
    end;
    f.savetofile(deleteslasheex(ExtractDirPath(application.ExeName))+'\esrlist.csv');
  end;
  f.free;
end;

Procedure XMLFile1(fn,fn1:string);
 var t,t1:textfile;
 var s,s1:string;
 var i:integer;
begin
  assignfile(t,fn);
  reset(t);
  assignfile(t1,fn1);
  rewrite(t1);
   while not eof(t) do begin
     readln(t,s);
     s1:='';
     if length(s)>0 then begin
       for i:=1 to length(s) do begin
         if s[i]='<' then s1:=s1+#13#10+s[i]
                     else s1:=s1+s[i];
       end;
     end;
     writeln(t1,s1);
   end;
  closefile(t1);
  closefile(t);
end;

function add00(s:string):string;
 var n:integer;
begin
 n:=length(s);
 if n=4 then s:='00'+s;
 if n=5 then s:='0'+s;
 result:=s;
end;

function findChgThread(uid:string):string;
  var ych,s,stype,suid,stitle,smonth,s3,s4,s5:string;
  var i,n:integer;
  var f:AF_Types.TStrings;
begin
  f.create;
  s4:='';
  if fileexists(workdir+'temp1.tmp') then deletefile(workdir+'temp1.tmp');
  if fileexists(workdir+'temp2.tmp') then deletefile(workdir+'temp2.tmp');
  ych:=StrReplace(y_change,'@uid@',uid);
  GetInetFile(ych,workdir+'temp1.tmp');
  XMLFile1(workdir+'temp1.tmp',workdir+'temp2.tmp');
  UTF8FileDecode(workdir+'temp2.tmp',workdir+'temp1.tmp');
  f.loadfromfile(workdir+'temp1.tmp');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
        stype:=getParam('type',s);
        suid:=getParam('uid',s);
        stitle:=getParam('title',s);
      end;
      if pos('<mask ',s)>0 then begin
       if stype='cancel' then begin
        smonth:=getParam('month',s);
        if length(smonth)=1 then smonth:='0'+smonth;
         s3:=getParam('days',s);
         if length(s3)>0 then begin
           for n:=1 to length(s3) do begin
            if s3[n]='1' then begin
             s5:=inttostr(n);
             if length(s5)=1 then s5:='0'+s5;
             s4:=s4+s5+'.'+smonth+', ';
            end;
           end;
         end;
       end;
      end;
    end;
  end;
  if fileexists(workdir+'temp1.tmp') then deletefile(workdir+'temp1.tmp');
  if fileexists(workdir+'temp2.tmp') then deletefile(workdir+'temp2.tmp');
  f.free;
  if length(s4)>2 then s4:=copy(s4,1,length(s4)-2);
  result:=s4;
end;


procedure testyapi2(esr1,esr2,time1,time2,number:string; ps,ps1,ps2:AF_Types.PStrings; cancelmode:boolean);
  var workdir,num0,num1,num2:string;
  var f,tl,tln,tlt:AF_Types.TStrings;
  var i:integer;
  var s,s1,s2,s3,se:string;
begin
  ps.clear;
  ps1.clear;
  ps2.clear;
  f.create;
  tl.create; tln.create; tlt.create;
  workdir:=deleteslasheex(ExtractDirPath(application.ExeName))+'\';
  if cancelmode then begin
           if not form1.checkbox1.checked then begin
            s2:='https://export.rasp.yandex.net/export/suburban/trip/'+add00(esr1)+'/'+add00(esr2)+'/?date=&old_days_format=true&timezone=Europe/Moscow';
            GetInetFile(s2,workdir+'station4.xml.tmp');
             if fileexists(workdir+'station4.xml.tmp') then begin
              UTF8FileDecode(workdir+'station4.xml.tmp',workdir+'station5.xml.tmp');
              XMLFile1(workdir+'station5.xml.tmp',workdir+'station6.xml.tmp');
              f.loadfromfile(workdir+'station6.xml.tmp');
              if f.count>0 then begin
                for i:=1 to f.count do begin
                  s:=f.getstring(i);
                  if pos('<segment',s)>0 then begin
                      num0:=getparam('number',s);
                      if pos('/',num0)>0 then num1:=trim(copy(num0,1,pos('/',num0)-1))
                                         else num1:=num0;
                      if pos('/',num0)>0 then num2:=trim(copy(num0,pos('/',num0)+1,100))
                                         else num2:=num0;
                    if ((number=num1)or(number=num2)) then begin
                     if getparam('update',s)<>'update' then begin
                      tl.add(getparam('uid',s));
                      tln.add(getparam('number',s));
                      tlt.add(getparam('title',s));
                     end;
                    end
                  end;
                end;
              end;
             end
              else ShowMessage('          .      ,     !');
             if tl.count>0 then begin
              for i:=1 to tl.count do begin
               s3:=findChgThread(tl.getstring(i));
               if validstr(s3) then begin
                 ps.add(tlt.getstring(i));
                 ps1.add(s3);
                 ps2.add(tln.getstring(i)+#9+tlt.getstring(i)+#9+s3);
               end;
              end;
             end;
            end;
//    ps.add(' ( ) - ');
//    ps1.add('28.01, 29.01');
//    ps2.add('6000'+#9+' ( ) - '+#9+'28.01, 29.01');
  end
   else begin
            s2:='https://export.rasp.yandex.net/export/suburban/trip/'+add00(esr1)+'/'+add00(esr2)+'/?date=&old_days_format=true&timezone=Europe/Moscow';
            GetInetFile(s2,workdir+'station4.xml.tmp');
             if fileexists(workdir+'station4.xml.tmp') then begin
              UTF8FileDecode(workdir+'station4.xml.tmp',workdir+'station5.xml.tmp');
              XMLFile1(workdir+'station5.xml.tmp',workdir+'station6.xml.tmp');
              f.loadfromfile(workdir+'station6.xml.tmp');
              if f.count>0 then begin
                for i:=1 to f.count do begin
                  s:=f.getstring(i);
                  if pos('<segment',s)>0 then begin
                    if ((getparam('departure',s)=time1)and(getparam('arrival',s)=time2)) then begin
                     if true then begin
                      s1:=getparam('days',s);
                      se:=getparam('except',s);
                      if length(s1)>0 then begin
                       if form1.checkbox1.checked then begin
                         if not (s1[1] in ['0'..'9']) then begin
                          ps.add(getparam('title',s)+{' '+getparam('departure',s)+'-'+getparam('arrival',s)+}': '+getparam('days',s));
                          ps1.add(getparam('days',s));
                          if ((form1.checkbox6.Checked)and(length(se)>1)) then ps2.add(getparam('number',s)+#9+getparam('title',s)+#9+getparam('days',s)+'  '+se)
                                                                          else ps2.add(getparam('number',s)+#9+getparam('title',s)+#9+getparam('days',s));
                         end;
                       end
                        else begin
                         if (s1[1] in ['0'..'9']) then begin
                          ps.add(getparam('title',s)+{' '+getparam('departure',s)+'-'+getparam('arrival',s)+}': '+getparam('days',s));
                          ps1.add(getparam('days',s));
                          if ((form1.checkbox6.Checked)and(length(se)>1)) then ps2.add(getparam('number',s)+#9+getparam('title',s)+#9+getparam('days',s)+'  '+se)
                                                                          else ps2.add(getparam('number',s)+#9+getparam('title',s)+#9+getparam('days',s));
                         end;
                        end;
                      end;
                     end;
                    end
                  end;
                end;
              end;
             end
              else ShowMessage('          .      ,     !');
   end;
  tl.free; tln.free; tlt.free;
  f.free;
end;


function testd(s:string;addsc:boolean):string;
  var p,r,tf:AF_Types.TStrings;
  var i,di,mi,yi,cmi,n,vd1,vm1,dv1,dv2,dv3,dv4,dv5,dv6,dv7,dvm:integer;
  var dt:TDateTime;
  var d,m,y,cm,ds:string;
  var xflag:boolean;
begin
  p.create; r.create; tf.create;
  result:='';
  vd1:=0;
  n:=0;
  xflag:=false;
  setroundmode(rmTruncate);
  if pos(',',s)>0 then begin
    ParseCSVStrEx(@p,s,',');
    cm:=FormatDateTime('m',Date+Time);
    cmi:=strtointe(cm);
    y:=FormatDateTime('yyyy',Date+Time);
    vm1:=0;
    for i:=1 to p.count do begin
      if pos('.',p.getstring(i))>0 then begin
       d:=trim(copy(p.getstring(i),1,pos('.',p.getstring(i))-1));
       m:=trim(copy(p.getstring(i),pos('.',p.getstring(i))+1,100));
       di:=strtointe(d);
       mi:=strtointe(m);
       yi:=strtointe(y);
       if vm1=0 then begin
        vd1:=di;
        vm1:=mi;
       end;
       if mi<cmi-1 then inc(yi);
       dt:=0;
       try
//         tf.clear;
//         tf.add(inttostr(yi)+':'+inttostr(mi)+':'+inttostr(di));
//         tf.savetofile('c:\1\35\t.txt');
         if not ((yi=2018)and(mi=2)and(di=29)) then dt:=EncodeDate(yi,mi,di);
       except
        on EConvertError do xflag:=true;
       end;
/// !!!!!!!!!!!!!!!!!!!!!!!!
/// if dt<42368 then
       r.add(inttostr(round(dt)));
      end;
    end;
    ds:='0000000';
    dv1:=0; dv2:=0; dv3:=0; dv4:=0; dv5:=0; dv6:=0; dv7:=0; dvm:=0;
    if r.count>0 then begin
      for i:=1 to r.count do begin
        try
        n:=DayOfTheWeek(strtointe(r.getstring(i)));
        except
         on EConvertError do xflag:=true;
        end;
        if n=1 then inc(dv1);
        if n=2 then inc(dv2);
        if n=3 then inc(dv3);
        if n=4 then inc(dv4);
        if n=5 then inc(dv5);
        if n=6 then inc(dv6);
        if n=7 then inc(dv7);
      end;
      if dv1>dvm then dvm:=dv1;
      if dv2>dvm then dvm:=dv2;
      if dv3>dvm then dvm:=dv3;
      if dv4>dvm then dvm:=dv4;
      if dv5>dvm then dvm:=dv5;
      if dv6>dvm then dvm:=dv6;
      if dv7>dvm then dvm:=dv7;
      if dv1>(dvm div 2) then ds[1]:='1';
      if dv2>(dvm div 2) then ds[2]:='1';
      if dv3>(dvm div 2) then ds[3]:='1';
      if dv4>(dvm div 2) then ds[4]:='1';
      if dv5>(dvm div 2) then ds[5]:='1';
      if dv6>(dvm div 2) then ds[6]:='1';
      if dv7>(dvm div 2) then ds[7]:='1';
      result:=' ';
      if ds='1111111' then result:='';
      if ds='1111100' then result:=' ';
      if ds='0000011' then result:=' ';
      if ds='1000000' then result:='';
      if ds='0100000' then result:='';
      if ds='0010000' then result:='';
      if ds='0001000' then result:='';
      if ds='0000100' then result:='';
      if ds='0000010' then result:='';
      if ds='0000001' then result:='';
      if ds='0101000' then result:=', ';
      if ds='0010001' then result:=', ';
      if ds='0010011' then result:=', , ';
      if ds='1101100' then result:=', , , ';
      if ds='1000010' then result:=', ';
      if ds='0000110' then result:=', ';
      if ds='0000101' then result:=', ';
      if ds='1010100' then result:=', , ';
      if ds='0101010' then result:=', , ';
      if ds='0101001' then result:=', , ';
      if ds='0111111' then result:=' ';
      if ds='1011111' then result:=' ';
      if ds='1101111' then result:=' ';
      if ds='1110111' then result:=' ';
      if ds='1111011' then result:=' ';
      if ds='1111101' then result:=' ';
      if ds='1111110' then result:=' ';
      if ds='1010111' then result:=' , ';
      if ds='1101110' then result:=' , ';
      if ds='0111101' then result:=' , ';
      if ds='1111001' then result:=' , ';
      if ds='1111010' then result:=' , ';
      if ds='0000111' then result:='   ';
      if ds='1111000' then result:='   ';
     if addsc then begin
      result:='('+result+')';
     end
      else begin
      if result<>' ' then begin
        case vm1 of
         1: result:=result+'  '+inttostr(vd1)+' ';
         2: result:=result+'  '+inttostr(vd1)+' ';
         3: result:=result+'  '+inttostr(vd1)+' ';
         4: result:=result+'  '+inttostr(vd1)+' ';
         5: result:=result+'  '+inttostr(vd1)+' ';
         6: result:=result+'  '+inttostr(vd1)+' ';
         7: result:=result+'  '+inttostr(vd1)+' ';
         8: result:=result+'  '+inttostr(vd1)+' ';
         9: result:=result+'  '+inttostr(vd1)+' ';
         10: result:=result+'  '+inttostr(vd1)+' ';
         11: result:=result+'  '+inttostr(vd1)+' ';
         12: result:=result+'  '+inttostr(vd1)+' ';
         else result:=result+'  ???';
        end;
      end;
      end;
    end;
   if xflag then result:='  : '+s+' | '+result; 
  end
   else begin
    if addsc then result:='(  !)'
             else result:='  !'
   end;
  p.free; r.free; tf.free;
end;


function del_po(s:string):string;
begin
 while pos(#160,s)>0 do s[pos(#160,s)]:=#32;
 result:=s;
 if pos(',  ',s)>1 then begin
   delete(s,pos(',  ',s),1);
   result:=s;
 end;
 if pos(',  ',s)>1 then begin
   delete(s,pos(',  ',s),1);
   result:=s;
 end;
end;

function strepl(s:string):string;
 var n:integer;
begin
 n:=_strepl1.SearchString(s);
 if n>0 then result:=_strepl2.getstring(n)
        else result:=s;
end;

function repl1314(s:string):string;
begin
 if s='   9 ' then s:='   10 ';
 result:=s;
end;

Function MDLG2(msgrow:integer;ps:AF_Types.PStrings;zmode:integer;base,cancelmode:boolean;zlist:string):word;
 var i,n,q,qr,vr,m,e,tmode:integer;
 var t,u1,u2:AF_Types.TStrings;
 var s1:string;
 var flg,qf,flg3:boolean;
begin
  result:=mrNo;
  q:=0;
  qf:=true;
  t.create; u1.create; u2.create;
  unit3.res:=mrCancel;
  ClearSG(form3.StringGrid1);
  ClearSG(form3.StringGrid2);
  form3.StringGrid2.RowCount:=1;
  form3.label6.caption:='';
  form3.label6.visible:=false;
  form3.StringGrid1.Cells[0,0]:=form1.StringGrid1.Cells[0,msgrow];
  form3.StringGrid1.Cells[1,0]:=strepl(ansilowercase(get1st(form1.StringGrid1.Cells[1,msgrow])));
  form3.StringGrid1.Cells[2,0]:=strepl(ansilowercase(get2st(form1.StringGrid1.Cells[1,msgrow])));
  if cancelmode then begin
    form3.StringGrid1.Cells[3,0]:=delSc(form1.StringGrid1.Cells[5,msgrow]);
  end
   else begin
    if base then form3.StringGrid1.Cells[3,0]:=testd(delSc(form1.StringGrid1.Cells[4,msgrow]),false)
            else begin
             if form1.checkbox1.checked then form3.StringGrid1.Cells[3,0]:=testd(delSc(form1.StringGrid1.Cells[4,msgrow]),false)
                                        else form3.StringGrid1.Cells[3,0]:=delSc(form1.StringGrid1.Cells[4,msgrow]);
            end;
   end;
  form3.Caption:=form1.StringGrid1.Cells[1,msgrow]+'  '+form1.StringGrid1.Cells[2,msgrow]+'-'+form1.StringGrid1.Cells[3,msgrow];
  if ps.count>0 then begin
    n:=0;
    for i:=1 to ps.count do begin
      ParseCSVStrEx(@t,ps.getstring(i),#9);
      if t.count>2 then begin
       if form1.checkbox3.checked then begin
        if pos(',  ',t.getstring(3))<1 then begin
         inc(n);
         if form3.StringGrid2.RowCount<n then form3.StringGrid2.RowCount:=n;
         form3.StringGrid2.Cells[0,n-1]:=t.getstring(1);
         form3.StringGrid2.Cells[1,n-1]:=strepl(ansilowercase(get1st(t.getstring(2))));
         form3.StringGrid2.Cells[2,n-1]:=strepl(ansilowercase(get2st(t.getstring(2))));
         form3.StringGrid2.Cells[3,n-1]:=repl1314(del_po(t.getstring(3)));
         inc(q);
        end;
       end
        else begin
         inc(n);
         if form3.StringGrid2.RowCount<n then form3.StringGrid2.RowCount:=n;
         form3.StringGrid2.Cells[0,n-1]:=t.getstring(1);
         form3.StringGrid2.Cells[1,n-1]:=strepl(ansilowercase(get1st(t.getstring(2))));
         form3.StringGrid2.Cells[2,n-1]:=strepl(ansilowercase(get2st(t.getstring(2))));
         form3.StringGrid2.Cells[3,n-1]:=repl1314(del_po(t.getstring(3)));
         inc(q);
        end;
      end;
    end;
  end;
  form3.Label1.visible:=false;
  form3.Label2.visible:=false;
  form3.Label3.visible:=false;
  if zmode=1 then begin
    s1:=form3.StringGrid1.Cells[3,0];
    vr:=1;
    if length(s1)>0 then begin
     if (s1[1] in ['0'..'9']) then begin
       ParseCSVStrEx(@u1,s1,',');
       if u1.count>0 then begin
        for m:=1 to u1.count do begin
          flg:=false;
          for e:=0 to form3.StringGrid2.RowCount-1 do begin
            if form3.StringGrid1.Cells[1,0]=form3.StringGrid2.Cells[1,e] then begin
            if form3.StringGrid1.Cells[2,0]=form3.StringGrid2.Cells[2,e] then begin
              ParseCSVStrEx(@u2,form3.StringGrid2.Cells[3,e],',');
              if u2.SearchString(u1.getstring(m))>0 then flg:=true;
            end;
            end;
          end;
          if not flg then vr:=0;
        end;
       end;
     end;
    end;
    if vr=1 then begin
      form3.Label1.Caption:='OK';
      form3.Label1.Font.Color:=clGreen;
      form3.Label1.visible:=true;
      form3.Label2.Caption:='OK';
      form3.Label2.Font.Color:=clGreen;
      form3.Label2.visible:=true;
      form3.Label3.Caption:='OK';
      form3.Label3.Font.Color:=clGreen;
      form3.Label3.visible:=true;
      qf:=false;
     end
     else begin
      form3.Label1.Caption:='OK??? ( )';
      form3.Label1.Font.Color:=RGB(255,128,0);
      form3.Label1.visible:=true;
      form3.Label2.Caption:='OK??? ( )';
      form3.Label2.Font.Color:=RGB(255,128,0);
      form3.Label2.visible:=true;
      form3.Label3.Caption:='OK??? ( )';
      form3.Label3.Font.Color:=RGB(255,128,0);
      form3.Label3.visible:=true;
     end;
  end; //zmode=1
  if zmode=2 then begin
    form3.Label1.Caption:=':   !!!';
    form3.Label1.Font.Color:=clRed;
    form3.Label1.visible:=true;
    form3.Label2.Caption:=':   !!!';
    form3.Label2.Font.Color:=clRed;
    form3.Label2.visible:=true;
    form3.Label3.Caption:=':   !!!';
    form3.Label3.Font.Color:=clRed;
    form3.Label3.visible:=true;
    form3.label6.visible:=true;
    form3.Label6.Caption:='  : '+zlist;
  end;
  unit3.zmode:=zmode;

  if q>0 then begin
   qr:=1;
   if form1.CheckBox2.Checked then begin
     if form3.StringGrid2.RowCount=1 then begin
      if form3.StringGrid1.Cells[1,0]=form3.StringGrid2.Cells[1,0] then begin
       if form3.StringGrid1.Cells[2,0]=form3.StringGrid2.Cells[2,0] then begin
        if form3.StringGrid1.Cells[3,0]=form3.StringGrid2.Cells[3,0] then begin
         qr:=0;
         result:=mrYes;
        end;
       end;
      end;
     end;
   end;
   if not qf then begin
    if form1.checkbox2.checked then begin
     qr:=0;
     result:=mrYes;
    end;
   end;
   if qr=1 then begin
    if cancelmode then begin
      form3.StringGrid1.Cells[3,0]:=': '+form3.StringGrid1.Cells[3,0];
      if form3.StringGrid2.RowCount>0 then begin
       for m:=0 to form3.StringGrid2.RowCount-1 do begin
         if validstr(form3.StringGrid2.cells[3,m]) then form3.StringGrid2.cells[3,m]:=': '+form3.StringGrid2.cells[3,m];
       end;
      end;
    end;
    if ((form1.CheckBox2.Checked)and(zmode=2)) then begin
      result:=mrNo;
    end
     else begin
      flg3:=true;
       if ((form1.checkbox1.checked)and(form1.checkbox2.checked)and(result<>mrYes)) then begin
        flg3:=false;
       end;
      if flg3 then begin
       form3.ShowModal;
       result:=unit3.res;
      end;
     end;
   end;
  end
   else begin // q<=0
     if not form1.checkbox2.checked then begin
       if ((validstr(form1.StringGrid1.Cells[4,msgrow]))and(validstr(form1.StringGrid1.Cells[5,msgrow]))) then tmode:=2
        else tmode:=1;
       if tmode=1 then showmessage('  !')
        else  showmessage('  ,       !');
     end;
     result:=mrNo;
   end;

  t.free; u1.free; u2.free;
end;

Function RowTest2(var mrk:integer; row,type1:integer):integer;
  var i,zmode:integer;
  var s1,s2,esr1,esr2,zs,zp,se1,se2,zlist:string;
  var ps,ps1,ps2,uz1,uz2:AF_Types.TStrings;
  var zr,cancelmode:boolean;
begin
result:=1;
cancelmode:=false;
if validstr(form1.stringgrid1.cells[5,row]) then begin
  cancelmode:=true;
  if ((validstr(form1.stringgrid1.cells[4,row]))and(pos('(',form1.stringgrid1.cells[5,row])=1)) then cancelmode:=false;
end;
if form1.checkbox1.checked then cancelmode:=false;
ps.create; uz1.create; uz2.create; ps1.create; ps2.create;
with form1 do begin
       se1:=StrReplace(stringgrid1.cells[1,row],'','-');
       se2:=stringgrid1.cells[1,row];
       if pos(']',se1)>0 then begin
         se1:=trim(copy(se1,pos(']',se1)+1,length(se1)-pos(']',se1)));
       end;
       if pos(']',se2)>0 then begin
         se2:=trim(copy(se2,pos(']',se2)+1,length(se2)-pos(']',se2)));
       end;
       s1:=ansilowercase(trim(copy(se2,1,pos(' - ',se1)-1)));
       s2:=ansilowercase(trim(copy(se2,pos(' - ',se1)+3,100)));
       while name2esr(s1,esr1)=false do begin
         esr1:='';
         if not validstr(s1) then break;
         InputQuery(' -',s1,esr1);
         if strtointe(esr1)>0 then begin
           saveesr(s1,esr1);
         end;
       end;
       while name2esr(s2,esr2)=false do begin
         esr2:='';
         if not validstr(s2) then break;
         InputQuery(' -',s2,esr2);
         if strtointe(esr2)>0 then begin
           saveesr(s2,esr2);
         end;
       end;
       ps.clear;
       ps1.clear;
       ps2.clear;

       testyapi2(esr1,esr2,stringgrid1.cells[2,row],stringgrid1.cells[3,row],stringgrid1.cells[0,row],@ps,@ps1,@ps2,cancelmode);
       if ps.count>0 then begin
         zs:='';
         uz1.clear;
         uz2.clear;
         if cancelmode then ParseCSVStrEx(@uz1,delSc(stringgrid1.cells[5,Row]),',')
                       else ParseCSVStrEx(@uz1,delSc(stringgrid1.cells[4,Row]),',');
         zp:='';
         for i:=1 to ps.count do begin
          if checkbox3.Checked then begin
           if pos(',  ',ps.getstring(i))<1 then zs:=zs+ps.getstring(i)+#13#10;
          end
           else zs:=zs+ps.getstring(i)+#13#10;
         end;
         if ps1.count>0 then begin
          for i:=1 to ps1.count do begin
           zp:=zp+ps1.getstring(i)+', ';
          end;
         end;
         if length(zp)>2 then zp:=copy(zp,1,length(zp)-2);
         zs:=zs+#13#10;
         zp:=StrReplace(zp,':',',');
         ParseCSVStrEx(@uz2,zp,',');
         zr:=true;
         zmode:=0;
         zlist:='';
         if uz1.count>0 then begin
           for i:=1 to uz1.count do begin
             if uz2.SearchString(uz1.getstring(i))<=0 then begin
               zr:=false;
               zlist:=zlist+uz1.getstring(i)+', ';
             end;
           end;
           if length(zlist)>2 then zlist:=copy(zlist,1,length(zlist)-2);
           if not checkbox1.Checked then begin
            if zr then begin
                    zs:=zs+#13#10+#13#10+'!';
                    zmode:=1;
                  end
                  else begin
                   zs:=zs+#13#10+#13#10+'[]:   !';
                   zmode:=2;
                  end;
           end;
         end;

         if (type1 in [1,3]) then begin
           if type1=1 then begin
             if mdlg2(row,@ps2,zmode,false,cancelmode,zlist)=mrYes then mrk:=2;
           end
            else begin
             case mdlg2(row,@ps2,zmode,false,cancelmode,zlist) of
              mrYes: begin mrk:=2; result:=1; end;
              mrNo: begin result:=1; end;
              mrCancel: begin result:=0; end;
             end;
            end;
         end
          else begin
           case mdlg2(row,@ps2,zmode,true,cancelmode,zlist) of
             mrYes: begin mrk:=2; result:=1; end;
             mrNo: begin result:=1; end;
             mrCancel: begin result:=0; end;
           end;
          end;
       end
        else begin
          if not checkbox2.checked then showmessage('  !');
        end;

end;
ps.free; uz1.free; uz2.free; ps1.free; ps2.free;
end;



procedure TForm1.StringGrid1DblClick(Sender: TObject);
  var ltr,replflag:boolean;
  var so:string;
  var i,h1,m1,h2,m2,mrk,acol,arow:integer;
  var fl,u,ll,thr,ff,ps,uz1,uz2:AF_Types.TSTrings;
begin
  ll.create;
  thr.create;
  u.create;
  ff.create;
  ps.create;
  uz1.create;
  uz2.create;
  stringgrid1.MouseToCell(_sg1x,_sg1y,acol,arow);

  if acol<6 then begin
   if ((not getAlt)and(not getShift)and(not getCtrl)) then begin
    if true then begin
     form2.Memo1.Lines.Clear;
     form2.Label1.caption:=stringgrid1.cells[0,arow];
     fl.create;
     if pos('[]',stringgrid1.cells[4,arow])>0 then begin
                                                       replflag:=true;
                                                       form2.Edit1.Text:=trim(copy(stringgrid1.cells[4,arow],9,length(stringgrid1.cells[4,arow])-8));
                                                    end
                                                     else begin
                                                       replflag:=false;
                                                       form2.Edit1.Text:=stringgrid1.cells[4,arow];
                                                     end;
     if pos(')',form2.Edit1.Text)>0 then form2.Edit1.Text:=trim(copy(form2.Edit1.Text,pos(')',form2.Edit1.Text)+1,length(form2.Edit1.Text)-pos(')',form2.Edit1.Text)));
     ltr:=LoadTrainFromMySQL(stringgrid1.cells[8,arow],@fl,replflag,stringgrid1.cells[6,arow]);
     if ltr then begin
      unit2.oldci:=form2.ComboBox1.ItemIndex;
      case form2.ComboBox1.ItemIndex of
        1: begin
            form2.Memo1.Lines.add(stringgrid1.cells[0,arow]);
            form2.Memo1.Lines.add('');
           end;
        2: begin
            form2.Memo1.Lines.add(stringgrid1.cells[0,arow]);
            form2.Memo1.Lines.add('');
            form2.Memo1.Lines.add(stringgrid1.cells[4,arow]);
            form2.Memo1.Lines.add('');
           end;
        3: begin
            form2.Memo1.Lines.add(stringgrid1.cells[0,arow]);
            form2.Memo1.Lines.add('');
            form2.Memo1.Lines.add(stringgrid1.cells[4,arow]);
            form2.Memo1.Lines.add('');
           end;
      end;
      unit2.thid:=stringgrid1.cells[8,arow];
      form2.StringGrid1.rowcount:=fl.count;
      clearsg(Form2.stringgrid1);
      form2.StringGrid1.rowcount:=fl.count;
      for i:=1 to fl.count do begin
        ParseCSVStrEx(@u,fl.getstring(i),';');
        if ansilowercase(u.getstring(2))='-' then u.edit(2,u.getstring(3));
        if ansilowercase(u.getstring(3))='-' then u.edit(3,u.getstring(2));
        tohm(u.getstring(2),h1,m1);
        tohm(u.getstring(3),h2,m2);
        if (h1=h2) and (m1=m2) then begin
          if ((validstr(trim(u.getstring(2))))or(validstr(trim(u.getstring(3))))) then begin
            form2.StringGrid1.Cells[1,i-1]:=ansilowercase(u.getstring(3));
            form2.Memo1.Lines.add(del0t(ansilowercase(u.getstring(3))));
          end
           else begin
            form2.StringGrid1.Cells[1,i-1]:='-';
            form2.Memo1.Lines.add('-');
           end;
        end
         else begin
           inchm(h1,m1,1);
            if (h1=h2) and (m1=m2) then begin
             if ((validstr(trim(u.getstring(2))))or(validstr(trim(u.getstring(3))))) then begin
               form2.StringGrid1.Cells[1,i-1]:=ansilowercase(u.getstring(3));
               form2.Memo1.Lines.add(del0t(ansilowercase(u.getstring(3))));
             end
              else begin
               form2.StringGrid1.Cells[1,i-1]:='-';
               form2.Memo1.Lines.add('-');
              end;
            end
             else begin
              if ((validstr(trim(u.getstring(2))))or(validstr(trim(u.getstring(3))))) then begin
               form2.StringGrid1.Cells[1,i-1]:=ddiv(ansilowercase(u.getstring(2)),ansilowercase(u.getstring(3)));
               form2.Memo1.Lines.add(del0t(ansilowercase( ddiv(u.getstring(2),ansilowercase(u.getstring(3))))));
              end
               else begin
                form2.StringGrid1.Cells[1,i-1]:='-';
                form2.Memo1.Lines.add('-');
               end;
             end;
         end;
        form2.StringGrid1.Cells[0,i-1]:=strreplace(ansilowercase(u.getstring(1)),'  ','');
      end;
      unit2.mark:=false;
      form2.ShowModal;
      if unit2.mark then begin
        markers.edit(arow+1,'2');
        stringgrid1.Repaint;
        SetStatus(stringgrid1.cells[8,arow],'2');
      end;
     end
      else begin  //-ltr
        so:=stringgrid1.cells[5,arow];
        if InputQuery('  '+stringgrid1.cells[0,arow],'  '+stringgrid1.cells[0,arow],so) then begin
          markers.edit(arow+1,'2');
          stringgrid1.Repaint;
          SetStatus(stringgrid1.cells[8,arow],'2');
        end;
      end;
     fl.free;
    end;
   end  //Alt
    else begin
     if ((getAlt)and(not getShift)and(not getCtrl)) then begin
      mrk:=strtointe(markers.getstring(arow+1));
      RowTest2(mrk,arow,1);
      markers.edit(arow+1,inttostr(mrk));
      stringgrid1.Repaint;
      SetStatus(stringgrid1.cells[8,arow],inttostr(mrk));
     end;
     if ((not getAlt)and(getShift)and(not getCtrl)) then begin
      mrk:=6;
      markers.edit(arow+1,inttostr(mrk));
      stringgrid1.Repaint;
      SetStatus(stringgrid1.cells[8,arow],inttostr(mrk));
     end;
     if ((not getAlt)and(not getShift)and(getCtrl)) then begin
      mrk:=9;
      markers.edit(arow+1,inttostr(mrk));
      stringgrid1.Repaint;
      SetStatus(stringgrid1.cells[8,arow],inttostr(mrk));
     end;
    end;
  end; //0-5

  if (acol>5) then begin
    mrk:=strtointe(markers.getstring(arow+1));
    if not getCtrl then begin
    if not getShift then begin
    if not getAlt then begin
     case mrk of
       0: mrk:=1;
       1: mrk:=2;
       2: mrk:=1;
       6: mrk:=2;
       9: mrk:=2;
       else mrk:=0;
     end;
    end
     else begin
      RowTest2(mrk,arow,1);
     end;
    end
     else mrk:=6;
    end
     else mrk:=9;
    markers.edit(arow+1,inttostr(mrk));
    stringgrid1.Repaint;
    SetStatus(stringgrid1.cells[8,arow],inttostr(mrk));
  end;

  ps.free;
  u.free;
  thr.free;
  ll.free;
  ff.free;
  uz1.free;
  uz2.free;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  StringGrid1.Width:=form1.Width-34;
  StringGrid1.Height:=form1.Height-120;
  CheckBox1.Left:=form1.Width-439;
  CheckBox2.Left:=form1.Width-439;
  RadioGroup1.Left:=form1.Width-231;
  StringGrid1.ColWidths[5]:=round((stringgrid1.Width-670)*0.4);
  StringGrid1.ColWidths[4]:=round((stringgrid1.Width-670)*0.6);
end;


procedure TForm1.RadioGroup1Click(Sender: TObject);
 var i,n:integer;
 var u,q:AF_Types.TStrings;
 var MySQL: IMySQL;
 var query_result: IMySQLQuery;
 var q1,st:string;
begin
 if not rgchflag then begin
  u.create;
  q.create;
  ClearSG(stringgrid1);
  stringgrid1.rowcount:=10;
  ClearSG(stringgrid1);
  markers.clear;
  n:=0;
  if _maincache.count>0 then begin
   MySQL := TMySQL.Create;
   MySQL.Host := cfg_mysql_markers_host;
   MySQL.Port := strtointe(cfg_mysql_markers_port);
   MySQL.User := cfg_mysql_markers_user;
   MySQL.Password := cfg_mysql_markers_password;
   if not MySQL.Connect then ShowMySQLError(MySQL)
    else begin
     MySQL.Database := cfg_mysql_markers_database;
     MySQL.Query('set character_set_client=''cp1251'';');
     MySQL.Query('set character_set_results=''cp1251'';');
     MySQL.Query('set collation_connection=''cp1251_bin'';');
     case RadioGroup1.ItemIndex of
      1:   begin
           for i:=1 to _maincache.count do begin
            ParseCSVStrEx(@u,_maincache.getstring(i),#9);
            ParseCSVStrEx(@q,u.getstring(9),'_');
            st:='1';
            q1:='SELECT * FROM `markers` WHERE ID_XML='+q.getstring(1)+' AND IDR='+q.getstring(2)+' AND OP='+q.getstring(3);
//            inputquery('','',q1);
            query_result := MySQL.Query(q1);
             if query_result = nil then ShowMySQLError(MySQL)
                                   else begin
                                    if query_result.RecordCount>0 then begin
                                     query_result.FetchRow;
                                     st:=query_result.ValueByName['status'];
                                    end;
                                   end;
             if st='1' then begin
             markers.add(st);
             StringGrid1.Cells[0,n]:=u.getstring(1);
             StringGrid1.Cells[1,n]:=u.getstring(2);
             StringGrid1.Cells[2,n]:=u.getstring(3);
             StringGrid1.Cells[3,n]:=u.getstring(4);
             StringGrid1.Cells[4,n]:=u.getstring(5);
             StringGrid1.Cells[5,n]:=u.getstring(6);
             StringGrid1.Cells[6,n]:=u.getstring(7);
             StringGrid1.Cells[7,n]:=u.getstring(8);
             StringGrid1.Cells[8,n]:=u.getstring(9);
             inc(n);
             if n>=stringgrid1.RowCount then stringgrid1.RowCount:=stringgrid1.RowCount+1;
             end;
           end;
          end;
      2:   begin
           for i:=1 to _maincache.count do begin
            ParseCSVStrEx(@u,_maincache.getstring(i),#9);
            ParseCSVStrEx(@q,u.getstring(9),'_');
            st:='1';
            q1:='SELECT * FROM `markers` WHERE ID_XML='+q.getstring(1)+' AND IDR='+q.getstring(2)+' AND OP='+q.getstring(3);
            query_result := MySQL.Query(q1);
             if query_result = nil then ShowMySQLError(MySQL)
                                   else begin
                                    if query_result.RecordCount>0 then begin
                                     query_result.FetchRow;
                                     st:=query_result.ValueByName['status'];
                                    end;
                                   end;
             if st='9' then begin
             markers.add(st);
             StringGrid1.Cells[0,n]:=u.getstring(1);
             StringGrid1.Cells[1,n]:=u.getstring(2);
             StringGrid1.Cells[2,n]:=u.getstring(3);
             StringGrid1.Cells[3,n]:=u.getstring(4);
             StringGrid1.Cells[4,n]:=u.getstring(5);
             StringGrid1.Cells[5,n]:=u.getstring(6);
             StringGrid1.Cells[6,n]:=u.getstring(7);
             StringGrid1.Cells[7,n]:=u.getstring(8);
             StringGrid1.Cells[8,n]:=u.getstring(9);
             inc(n);
             if n>=stringgrid1.RowCount then stringgrid1.RowCount:=stringgrid1.RowCount+1;
             end;
           end;
          end;
      3:   begin
           for i:=1 to _maincache.count do begin
            ParseCSVStrEx(@u,_maincache.getstring(i),#9);
            ParseCSVStrEx(@q,u.getstring(9),'_');
            st:='1';
            q1:='SELECT * FROM `markers` WHERE ID_XML='+q.getstring(1)+' AND IDR='+q.getstring(2)+' AND OP='+q.getstring(3);
            query_result := MySQL.Query(q1);
             if query_result = nil then ShowMySQLError(MySQL)
                                   else begin
                                    if query_result.RecordCount>0 then begin
                                     query_result.FetchRow;
                                     st:=query_result.ValueByName['status'];
                                    end;
                                   end;
             if st='6' then begin
             markers.add(st);
             StringGrid1.Cells[0,n]:=u.getstring(1);
             StringGrid1.Cells[1,n]:=u.getstring(2);
             StringGrid1.Cells[2,n]:=u.getstring(3);
             StringGrid1.Cells[3,n]:=u.getstring(4);
             StringGrid1.Cells[4,n]:=u.getstring(5);
             StringGrid1.Cells[5,n]:=u.getstring(6);
             StringGrid1.Cells[6,n]:=u.getstring(7);
             StringGrid1.Cells[7,n]:=u.getstring(8);
             StringGrid1.Cells[8,n]:=u.getstring(9);
             inc(n);
             if n>=stringgrid1.RowCount then stringgrid1.RowCount:=stringgrid1.RowCount+1;
             end;
           end;
         end;
      else begin
           for i:=1 to _maincache.count do begin
            ParseCSVStrEx(@u,_maincache.getstring(i),#9);
            ParseCSVStrEx(@q,u.getstring(9),'_');
            st:='1';
            q1:='SELECT * FROM `markers` WHERE ID_XML='+q.getstring(1)+' AND IDR='+q.getstring(2)+' AND OP='+q.getstring(3);
            query_result := MySQL.Query(q1);
             if query_result = nil then ShowMySQLError(MySQL)
                                   else begin
                                    if query_result.RecordCount>0 then begin
                                     query_result.FetchRow;
                                     st:=query_result.ValueByName['status'];
                                    end;
                                   end;
             markers.add(st);
             StringGrid1.Cells[0,n]:=u.getstring(1);
             StringGrid1.Cells[1,n]:=u.getstring(2);
             StringGrid1.Cells[2,n]:=u.getstring(3);
             StringGrid1.Cells[3,n]:=u.getstring(4);
             StringGrid1.Cells[4,n]:=u.getstring(5);
             StringGrid1.Cells[5,n]:=u.getstring(6);
             StringGrid1.Cells[6,n]:=u.getstring(7);
             StringGrid1.Cells[7,n]:=u.getstring(8);
             StringGrid1.Cells[8,n]:=u.getstring(9);
             inc(n);
             if n>=stringgrid1.RowCount then stringgrid1.RowCount:=stringgrid1.RowCount+1;
            end;
         end;
     end;
     MySQL.Disconnect;
    end;
  end;
  u.free;
  q.free;
  SetL8;
 end; 
end;

procedure TForm1.StringGrid1Click(Sender: TObject);
  var mrk,type1,row,ttr,acol,arow,mr,mr1:integer;
  var flg:boolean;
  var Msg: TMsg;
begin
  if checkbox2.Checked then begin
    stringgrid1.MouseToCell(_sg1x,_sg1y,acol,arow);
    if ((acol=4)or(acol=5)) then begin
     stringgrid1.Enabled:=false;
     row:=arow;
     mr1:=stringgrid1.rowcount-arow;
     mr:=0;
     repeat
      flg:=false;
      mr:=mr+1;
      mrk:=strtointe(markers.getstring(row+1));
      if checkbox1.checked then ttr:=2
                           else ttr:=3;
      type1:=RowTest2(mrk,row,ttr);
      markers.edit(row+1,inttostr(mrk));
      StatusBar1.SimpleText:=' '+inttostr(mr)+'  '+inttostr(mr1);
      Stringgrid1.Repaint;
      Application.ProcessMessages;
      SetStatus(stringgrid1.cells[8,row],inttostr(mrk));
      if type1=0 then flg:=false
       else begin
         if row<stringgrid1.rowcount-1 then begin
           row:=row+1;
           flg:=true;
         end;
       end;
     until flg=false;
     StatusBar1.SimpleText:='';
     if type1<>0 then begin
       showmessage('  !');
       checkbox2.Checked:=false;
     end;
     while PeekMessage(Msg, 0, WM_KEYFIRST, WM_KEYLAST, PM_REMOVE or PM_NOYIELD) do;
     while PeekMessage(Msg, 0, WM_MOUSEFIRST, WM_MOUSELAST, PM_REMOVE or PM_NOYIELD) do;
     stringgrid1.Enabled:=true;
    end;
  end;   
end;

procedure TForm1.FormCanResize(Sender: TObject; var NewWidth,
  NewHeight: Integer; var Resize: Boolean);
begin
  if ((newwidth>=_stwidth)and(newheight>=_stheight)) then Resize:=true
                                                     else resize:=false;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ReloadAllCache;
end;

procedure TForm1.StringGrid1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  _sg1x:=x;
  _sg1y:=y;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if MessageDlg('   ?',mtConfirmation,[mbYes,mbNo],0)=mrYes then canClose:=true
                                                                       else canClose:=false;
end;

procedure TForm1.N1Click(Sender: TObject);
  var i:integer;
  var s,m,q:string;
begin
if mrkmode=mrkmg then begin
 if radiogroup1.ItemIndex>0 then begin
  if stringgrid1.row>=0 then begin
   for i:=stringgrid1.row to stringgrid1.RowCount-1 do begin
    s:=stringgrid1.cells[1,i];
    m:=markers.getstring(i+1);
    if pos('[2020',s)=1 then begin
      if m<>'2' then begin
        SetStatus(stringgrid1.cells[8,i],'2');
        markers.edit(i+1,'2');
      end;
    end;
   end;
   stringgrid1.repaint;
  showmessage('!');
  end
   else showmessage('       !');
 end
  else showmessage('       !');
end; //mkrmg
if mrkmode=mrkmc then begin
 q:='';
 if radiogroup1.ItemIndex>0 then begin
  if stringgrid1.row>=0 then begin
  if InputQuery('  ',':',q) then begin
   for i:=stringgrid1.row to stringgrid1.RowCount-1 do begin
    s:=stringgrid1.cells[1,i];
    m:=markers.getstring(i+1);
    if ((pos(' '+q+']',s)>0)or(pos('['+q+']',s)>0)) then begin  // 6-, 2-
      if m<>'2' then begin
        SetStatus(stringgrid1.cells[8,i],'2');
        markers.edit(i+1,'2');
      end;
    end;
   end;
   stringgrid1.repaint;
  showmessage('!');
  end;
  end
   else showmessage('       !');
 end
  else showmessage('       !');
end; //mkrmc
end;

procedure TForm1.N2Click(Sender: TObject);
  var i:integer;
  var s,s1,s2,m,r,q:string;
begin
if mrkmode=mrkmg then begin
 if radiogroup1.ItemIndex>0 then begin
  if stringgrid1.row>=0 then begin
   for i:=stringgrid1.row to stringgrid1.RowCount-1 do begin
    s:=stringgrid1.cells[1,i];
    s1:=stringgrid1.cells[4,i];
    s2:=stringgrid1.cells[5,i];
    m:=markers.getstring(i+1);
    if pos('[2020',s)=1 then begin
      if m<>'9' then begin
        r:='9';
        if pos('( ) 15.12, 16.12, 22.12, 23.12, 30.12, 31.12, 01.01, 02.01, 03.01, 04.01, 05.01, 06.01, 07.01, 08.01, 12.01, 13.01, 19.01, 20.01, 26.01, 27.01, 02.02, 03.02, 09.02, 10.02, 16.02, 17.02, 23.02, 24.02',s2)>0 then r:='2';
        if pos('( ) 10.12, 11.12, 12.12, 13.12, 14.12, 17.12, 18.12, 19.12, 20.12, 21.12, 24.12, 25.12, 26.12, 27.12, 28.12, 29.12, 09.01, 10.01, 11.01, 14.01, 15.01, 16.01, 17.01, 18.01, 21.01, 22.01, 23.01, 24.01, 25.01',s2)>0 then r:='2';
//        if pos('( ) 16.12, 17.12, 23.12, 24.12, 30.12, 31.12, 01.01, 02.01, 03.01, 04.01, 05.01, 06.01, 07.01, 08.01, 13.01, 14.01, 20.01, 21.01, 27.01, 28.01, 03.02, 04.02, 10.02, 11.02, 17.02, 18.02, 23.02, 24.02',s2)>0 then r:='2';
//        if pos('( ) 11.12, 12.12, 13.12, 14.12, 15.12, 18.12, 19.12, 20.12, 21.12, 22.12, 25.12, 26.12, 27.12, 28.12, 29.12, 09.01, 10.01, 11.01, 12.01, 15.01, 16.01, 17.01, 18.01, 19.01, 22.01, 23.01, 24.01, 25.01',s2)>0 then r:='2';
        if s1='31.12, 01.01, 02.01, 03.01, 04.01, 07.01, 08.01, 08.03, 01.05, 02.05, 03.05, 09.05, 10.05, 12.06, 04.11' then r:='2';
        if s1='29.12' then r:='2';
        SetStatus(stringgrid1.cells[8,i],r);
        markers.edit(i+1,r);
      end;
    end;
   end;
   stringgrid1.repaint;
  showmessage('!');
  end
   else showmessage('       !');
 end
  else showmessage('       !');
end; //mkrmg
if mrkmode=mrkmc then begin
 q:='';
 if radiogroup1.ItemIndex>0 then begin
  if stringgrid1.row>=0 then begin
  if InputQuery('  ',':',q) then begin
   for i:=stringgrid1.row to stringgrid1.RowCount-1 do begin
    s:=stringgrid1.cells[1,i];
    m:=markers.getstring(i+1);
    if ((pos(' '+q+']',s)>0)or(pos('['+q+']',s)>0)) then begin  // 6-, 2-
      if m<>'9' then begin
        SetStatus(stringgrid1.cells[8,i],'9');
        markers.edit(i+1,'9');
      end;
    end;
   end;
   stringgrid1.repaint;
  showmessage('!');
  end;
  end
   else showmessage('       !');
 end
  else showmessage('       !');
end; //mkrmc
end;

procedure TForm1.Label2Click(Sender: TObject);
begin
  mrkmode:=mrkmg;
  PopupMenu1.Popup(form1.left+label2.Left,form1.Top+label2.top+40);
end;

procedure TForm1.Label3Click(Sender: TObject);
  var i:integer;
  var s,m:string;
begin
// if radiogroup1.ItemIndex>0 then begin
  if stringgrid1.row>=0 then begin
   for i:=stringgrid1.row to stringgrid1.RowCount-1 do begin
    s:=stringgrid1.cells[4,i];
    m:=markers.getstring(i+1);
    if ((s='[ ]')or(s='[] ERROR')) then begin
      if m<>'2' then begin
        SetStatus(stringgrid1.cells[8,i],'2');
        markers.edit(i+1,'2');
      end;
    end;
   end;
   stringgrid1.repaint;
  showmessage('!');
  end
   else showmessage('       !');
// end
//  else showmessage('       !');
end;

procedure TForm1.Label4Click(Sender: TObject);
begin
 mrkmode:=mrkmc;
 PopupMenu1.Popup(form1.left+label4.Left,form1.Top+label4.top+40);
end;

procedure TForm1.Label5Click(Sender: TObject);
  var i:integer;
  var s,m,sd,sm,sy:string;
  var u:AF_Types.TSTrings;
  var dt:TDateTime;
begin
 u.create;
 if radiogroup1.ItemIndex>0 then begin
  if stringgrid1.row>=0 then begin
   if MessageDlg('      .   .     ?',mtConfirmation,[mbYes,mbNo],0)=mrYes then begin
   for i:=stringgrid1.row to stringgrid1.RowCount-1 do begin
    s:=stringgrid1.cells[4,i];
    if not validstr(s) then s:=stringgrid1.cells[5,i];
    if pos(']',s)>0 then delete(s,1,pos(']',s));
    s:=trim(s);
    if pos(',',s)>0 then begin
      ParseCSVStrEx(@u,s,',');
      s:=trim(u.getstring(u.count));
    end;
    if pos('.',s)>0 then begin
      sd:=copy(s,1,pos('.',s)-1);
      sm:=copy(s,pos('.',s)+1,length(s)-pos('.',s));
      sy:=FormatDateTime('yyyy',date+time);
      dt:=EncodeDate(strtointe(sy),strtointe(sm),strtointe(sd));
      m:=markers.getstring(i+1);
      if dt<date then begin
        if m<>'2' then begin
          SetStatus(stringgrid1.cells[8,i],'2');
          markers.edit(i+1,'2');
        end;
      end;
    end;
   end; //for
   stringgrid1.repaint;
  showmessage('!');
  end;
  end
   else showmessage('       !');
 end
  else showmessage('       !');
 u.free;   
end;

procedure TForm1.StringGrid1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
  var ct:string;
  var flg:boolean;
  var z,r:integer;
begin
 if key=70 then begin
  if getCtrl then begin
    if InputQuery('   ',':',ct) then begin
     if validstr(ct) then begin
       if stringgrid1.RowCount>1 then begin
         flg:=false;
         ct:=ansiuppercase(ct);
         if stringgrid1.row>0 then r:=stringgrid1.Row
                              else r:=1;
         for z:=r to stringgrid1.RowCount-1 do begin
           if pos(ct,stringgrid1.cells[0,z])>0 then begin flg:=true; break; end;
         end;
         if z<>stringgrid1.Row then begin
           if flg then stringgrid1.Row:=z;
         end;
       end;
     end;
    end;
  end;
 end;
end;

end.
