unit Unit3;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, Buttons, AF_Proc;

type
  TForm3 = class(TForm)
    StringGrid1: TStringGrid;
    StringGrid2: TStringGrid;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Label1: TLabel;
    SpeedButton1: TSpeedButton;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure StringGrid2DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure StringGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;
  res: word;
  zmode:integer;

implementation

uses Unit4, Unit1;

{$R *.dfm}

procedure TForm3.Button1Click(Sender: TObject);
begin
 if zmode<>2 then begin
  res:=mrYes;
  form3.close;
 end
  else begin
    if MessageDlg('  .  ?',mtConfirmation,[mbYes,mbNo],0)=mrYes then begin
     res:=mrYes;
     form3.close;
    end
     else begin
       res:=mrNo;
       form3.close;
     end;
  end;
end;

procedure TForm3.Button2Click(Sender: TObject);
begin
  res:=mrNo;
  form3.close;
end;

procedure TForm3.Button3Click(Sender: TObject);
begin
  res:=mrCancel;
  form1.checkbox2.checked:=false;
  form3.close;
end;

procedure TForm3.FormShow(Sender: TObject);
begin
   button1.SetFocus;
end;

procedure TForm3.StringGrid2DrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
var
  Buf: array[byte] of char;
begin
  with Stringgrid2 do
  begin
    Canvas.Font := Font;
    Canvas.Font.Color := clWindowText;
    Canvas.Brush.Color := clWindow;

    Canvas.FillRect(Rect);
   if validstr(Cells[ACol, ARow]) then begin
    StrPCopy(Buf, copy(Cells[ACol, ARow],1,100));
    DrawText(Canvas.Handle, Buf, -1, Rect,
      DT_SINGLELINE or DT_VCENTER or DT_NOCLIP or DT_LEFT);
   end;
  end;
end;


procedure TForm3.StringGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
var
  Buf: array[byte] of char;
begin
  with Stringgrid1 do
  begin
    Canvas.Font := Font;
    Canvas.Font.Color := clWindowText;
    Canvas.Brush.Color := clWindow;

    Canvas.FillRect(Rect);
   if validstr(Cells[ACol, ARow]) then begin
    StrPCopy(Buf, copy(Cells[ACol, ARow],1,100));
    DrawText(Canvas.Handle, Buf, -1, Rect,
      DT_SINGLELINE or DT_VCENTER or DT_NOCLIP or DT_LEFT);
   end;
  end;
end;


procedure TForm3.SpeedButton1Click(Sender: TObject);
begin
  form4.Edit1.Text:=stringgrid1.Cells[1,0];
  form4.Edit2.Text:=stringgrid1.Cells[1,0];
  form4.Edit3.Text:=stringgrid1.Cells[2,0];
  form4.Edit4.Text:=stringgrid1.Cells[2,0];
  form4.Edit5.Text:=stringgrid2.Cells[1,0];
  form4.Edit6.Text:=stringgrid2.Cells[1,0];
  form4.Edit7.Text:=stringgrid2.Cells[2,0];
  form4.Edit8.Text:=stringgrid2.Cells[2,0];
  form4.showmodal;
end;

end.
