unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls, ExtCtrls, Buttons, OleServer, ExcelXP, AF_Proc, AF_Types, Math,
  ComCtrls, MySQL, MySQLClasses;

type
  TChildMode = (chNone,chNormal,chNN);
  TTarif = packed record
    price_km:real;
    limit:integer;
    price_limit:real;
    finprice:real;
    finmode:boolean;
  end;
  TTariffsp = packed record
    price_km:real;
    price_km20:real;
    limit:integer;
    price_limit:real;
  end;
  TAbTarifList = packed record
    etrain,reduced,beznal,child,handbag,animal,velzh,m1,m1r,m3,m3r,m12,d5,d10,d15,d20,d25,d10r,d15r,d20r,d25r,dat5,dat6,dat7,dat8,dat9,dat10,dat11,dat12,dat13,dat14,dat15,dat16,p10,p20,p60,p90,vyhdn,last,lastchild,last5d,last10d,last15d,last20d,last25d,last1m,last3m,last12m,last5dr,last10dr,last15dr,last20dr,last25dr,last1mr,last3mr,last12mr,last10p,last20p,last60p,last90p,last5dat,e1m,e1mr,mlg1,mrlg1,vyhdnlg,vyhdnchild,komfort,komfortchild,detsky,detsky_last,
    mcd, mcd_dal, mcd_1dat, mcd_3dat, mcd_30dat, mcd_90dat, mcd_365dat, mcd_1m_st, mcd_3m_st, mcd_60p, uglski, udm_sp, priv_1mr, priv_5den, krskm_sp, krskm_child, krskm_animal:real;
  end;
  TAb200 = array[1..200] of TAbTarifList;
  TZOut = packed record
    price:real;
    legend:string[200];
  end;
  TForm1 = class(TForm)
    SpeedButton1: TSpeedButton;
    LabeledEdit1: TLabeledEdit;
    StringGrid1: TStringGrid;
    XLApp: TExcelApplication;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    StringGrid2: TStringGrid;
    OpenDialog2: TOpenDialog;
    Button1: TButton;
    Edit1: TEdit;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    SpeedButton2: TSpeedButton;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Button2: TButton;
    Edit2: TEdit;
    Button3: TButton;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    CheckBox11: TCheckBox;
    CheckBox12: TCheckBox;
    CheckBox13: TCheckBox;
    Button4: TButton;
    OpenDialog3: TOpenDialog;
    Button5: TButton;
    Button6: TButton;
    OpenDialog4: TOpenDialog;
    CheckBox14: TCheckBox;
    Button7: TButton;
    CheckBox15: TCheckBox;
    CheckBox16: TCheckBox;
    CheckBox17: TCheckBox;
    CheckBox18: TCheckBox;
    CheckBox19: TCheckBox;
    CheckBox20: TCheckBox;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    Button11: TButton;
    OpenDialog5: TOpenDialog;
    Button12: TButton;
    Button13: TButton;
    Button14: TButton;
    Button15: TButton;
    Button16: TButton;
    StatusBar1: TStatusBar;
    StringGrid3: TStringGrid;
    Button17: TButton;
    Button19: TButton;
    Button20: TButton;
    CheckBox21: TCheckBox;
    Button18: TButton;
    Button21: TButton;
    StringGrid4: TStringGrid;
    Button22: TButton;
    Button23: TButton;
    Button24: TButton;
    Button25: TButton;
    Button26: TButton;
    Button27: TButton;
    Button28: TButton;
    OpenDialog6: TOpenDialog;
    Button29: TButton;
    Button30: TButton;
    procedure SpeedButton1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure CheckBox14Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure Button15Click(Sender: TObject);
    procedure Button16Click(Sender: TObject);
    procedure Button17Click(Sender: TObject);
    procedure Button19Click(Sender: TObject);
    procedure Button20Click(Sender: TObject);
    procedure Button18Click(Sender: TObject);
    procedure Button21Click(Sender: TObject);
    procedure Button22Click(Sender: TObject);
    procedure Button23Click(Sender: TObject);
    procedure Button24Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Button25Click(Sender: TObject);
    procedure Button26Click(Sender: TObject);
    procedure Button27Click(Sender: TObject);
    procedure Button28Click(Sender: TObject);
    procedure Button29Click(Sender: TObject);
    procedure Button30Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  tf,tf1:TextFile;
  spblogflag,msklogflag:boolean;
  tlog15,tlog16,msk3500log,cppkst1,cppkst2,cppkst3:AF_Types.Tstrings;
  abtable_spb_lim,abtable_spb_notlim,abtable_lenobl_lim,abtable_lenobl_notlim,abtable_novgorod_lim,abtable_novgorod_notlim:TAB200;
  cfg_mysql_host, cfg_mysql_port, cfg_mysql_database, cfg_mysql_user, cfg_mysql_password: string;
  __wsname0:string;
  olddir0,mainfilename:string;
  MySQL: IMySQL;

//function GetSPB3700Ab(km:real;code:string;lim:boolean;ab:TAbTarifList;add:boolean):TAbTarifList;
function GetTarifInfo(ttype,tmode:string; km:real; var t:TTarif):boolean;
Procedure CompareCPPKTZone1(stat1,stat2,tar1,tar2,cppktt:string; cppktar:TAbTarifList; cppkres:boolean; var res:real; deletezerotariff:boolean);
Function CheckAppDisable(tar1,tar2,cppktt:string):boolean;
Function CheckAppDisableExpress(tar1,tar2,cppktt:string):boolean;
function CompareDirections(d1,d2:string):boolean;
function Prep0ESR(s:string):string;

implementation

{$R *.dfm}

function RoundTo2(const AValue: Extended { Double}; const ADigit: TRoundToRange): Extended; { Double}
var
LFactor: Extended; { Double}
begin
LFactor := IntPower(10, ADigit);
Result := Round(AValue / LFactor) * LFactor;
end;

function RoundToEx(const AValue: Double; const ADigit: TRoundToRange = -2): double;
var
  LFactor: double;
  i: integer;
  s: string;
begin
  LFactor := IntPower(10, ADigit);
  i := Round(AValue / (LFactor / 10));
  s := IntToStr(i);
  Result := (Trunc(i/10) + ord(StrToIntE(s[Length(s)]) >= 5)) * LFactor;
end;



function GetCPPKstnameBYesr(esr:string):string;
 var r:integer;
begin
 result:='???';
 r:=cppkst3.SearchString(esr);
  if r>0 then result:=cppkst2.getstring(r);
end;

procedure ShowMySQLError(MySQL:IMySQL);
begin
  ShowMessage(Format(' #%d - %s', [MySQL.ErrorCode, MySQL.ErrorMessage]));
end;

function LoadMainIni:boolean;
  var chg:AF_Types.TStrings;
  var i:integer;
  var s,s1,s2:string;
  var res:boolean;
begin
  chg.create;
  chg.loadfromfile(deleteslasheex(ExtractDirPath(Application.ExeName))+'\main.ini');
  if chg.count>0 then begin
    for i:=1 to chg.count do begin
      s:=trim(chg.getstring(i));
      s:=strreplace(s,#9,#32);
      if length(s)>0 then begin
        if not (s[1]=';') then begin
          if pos(' ',s)>0 then begin
            s1:=trim(copy(s,1,pos(' ',s)-1));
            s2:=trim(copy(s,pos(' ',s)+1,length(s)-pos(' ',s)));
            s1:=ansilowercase(s1);
            if s1='mysql_host' then begin
              if {isIp(s)}true then cfg_mysql_host:=s2;
            end;
            if s1='mysql_port' then begin
              cfg_mysql_port:=s2;
            end;
            if s1='mysql_database' then begin
              cfg_mysql_database:=s2;
            end;
            if s1='mysql_user' then begin
              cfg_mysql_user:=s2;
            end;
            if s1='mysql_password' then begin
              cfg_mysql_password:=s2;
            end;
          end;
        end;
      end;
    end;
  end;
  chg.free;
  res:=true;
  result:=res;
end;


procedure ClearAbTariffList(var r:TAbTarifList);
begin
 r.etrain:=0; r.child:=0; r.beznal:= 0;  r.reduced:=0; r.handbag:=0; r.animal:=0; r.velzh:=0; r.m1:=0; r.m1r:=0; r.m3:=0; r.m3r:=0; r.m12:=0; r.d5:=0; r.d10:=0; r.d15:=0; r.d20:=0; r.d25:=0; r.d10r:=0; r.d15r:=0; r.d20r:=0; r.d25r:=0; r.dat5:=0; r.dat6:=0; r.dat7:=0; r.dat8:=0; r.dat9:=0; r.dat10:=0; r.dat11:=0; r.dat12:=0; r.dat13:=0; r.dat14:=0; r.dat15:=0; r.dat16:=0; r.p10:=0; r.p20:=0; r.p60:=0; r.p90:=0; r.vyhdn:=0; r.last:=0; r.lastchild:=0; r.last5d:=0; r.last10d:=0; r.last15d:=0; r.last20d:=0; r.last25d:=0; r.last1m:=0; r.last3m:=0;r.last12m:=0;r.last5dr:=0; r.last10dr:=0; r.last15dr:=0; r.last20dr:=0; r.last25dr:=0; r.last1mr:=0; r.last3mr:=0;r.last12mr:=0;r.last5d:=0; r.last10p:=0; r.last20p:=0; r.last60p:=0; r.last90p:=0; r.last5dat:=0; r.e1m:=0; r.e1mr:=0; r.mlg1:=0; r.mrlg1:=0; r.vyhdnlg:=0; r.vyhdnchild:=0; r.komfort:=0; r.komfortchild:=0; r.detsky:=0; r.detsky_last:=0;
 r.uglski:=0;
 r. priv_1mr:=0;  r.priv_5den := 0;
 r.udm_sp := 0;
r.krskm_sp:= 0 ;
r.krskm_child := 0 ;
r.krskm_animal := 0;

end;

procedure IncAbTariffList(var r:TAbTarifList; a:TAbTarifList);
begin
if a.etrain>0 then r.etrain:=r.etrain+a.etrain else r.etrain:=0;
if a.child>0 then r.child:=r.child+a.child else r.child:=0;
if a.beznal>0 then r.beznal:=r.beznal+a.beznal else r.beznal:=0;
if a.reduced>0 then r.reduced:=r.reduced+a.reduced else r.reduced:=0;
if a.handbag>0 then r.handbag:=r.handbag+a.handbag else r.handbag:=0;
if a.animal>0 then r.animal:=r.animal+a.animal else r.animal:=0;
if a.velzh>0 then r.velzh:=r.velzh+a.velzh else r.velzh:=0;
if a.m1>0 then r.m1:=r.m1+a.m1 else r.m1:=0;
if a.m1r>0 then r.m1r:=r.m1r+a.m1r else r.m1r:=0;
if a.m3>0 then r.m3:=r.m3+a.m3 else r.m3:=0;
if a.m3r>0 then r.m3r:=r.m3r+a.m3r else r.m3r:=0;
if a.m12>0 then r.m12:=r.m12+a.m12 else r.m12:=0;
if a.d5>0 then r.d5:=r.d5+a.d5 else r.d5:=0;
if a.d10>0 then r.d10:=r.d10+a.d10 else r.d10:=0;
if a.d15>0 then r.d15:=r.d15+a.d15 else r.d15:=0;
if a.d20>0 then r.d20:=r.d20+a.d20 else r.d20:=0;
if a.d25>0 then r.d25:=r.d25+a.d25 else r.d25:=0;
if a.d10r>0 then r.d10r:=r.d10r+a.d10r else r.d10r:=0;
if a.d15r>0 then r.d15r:=r.d15r+a.d15r else r.d15r:=0;
if a.d20r>0 then r.d20r:=r.d20r+a.d20r else r.d20r:=0;
if a.d25r>0 then r.d25r:=r.d25r+a.d25r else r.d25r:=0;
if a.dat5>0 then r.dat5:=r.dat5+a.dat5 else r.dat5:=0;
if a.dat6>0 then r.dat6:=r.dat6+a.dat6 else r.dat6:=0;
if a.dat7>0 then r.dat7:=r.dat7+a.dat7 else r.dat7:=0;
if a.dat8>0 then r.dat8:=r.dat8+a.dat8 else r.dat8:=0;
if a.dat9>0 then r.dat9:=r.dat9+a.dat9 else r.dat9:=0;
if a.dat10>0 then r.dat10:=r.dat10+a.dat10 else r.dat10:=0;
if a.dat11>0 then r.dat11:=r.dat11+a.dat11 else r.dat11:=0;
if a.dat12>0 then r.dat12:=r.dat12+a.dat12 else r.dat12:=0;
if a.dat13>0 then r.dat13:=r.dat13+a.dat13 else r.dat13:=0;
if a.dat14>0 then r.dat14:=r.dat14+a.dat14 else r.dat14:=0;
if a.dat15>0 then r.dat15:=r.dat15+a.dat15 else r.dat15:=0;
if a.dat16>0 then r.dat16:=r.dat16+a.dat16 else r.dat16:=0;
if a.p10>0 then r.p10:=r.p10+a.p10 else r.p10:=0;
if a.p20>0 then r.p20:=r.p20+a.p20 else r.p20:=0;
if a.p60>0 then r.p60:=r.p60+a.p60 else r.p60:=0;
if a.p90>0 then r.p90:=r.p90+a.p90 else r.p90:=0;
if a.vyhdn>0 then r.vyhdn:=r.vyhdn+a.vyhdn else r.vyhdn:=0;
if a.last>0 then r.last:=r.last+a.last else r.last:=0;
if a.lastchild>0 then r.lastchild:=r.lastchild+a.lastchild else r.lastchild:=0;
if a.last5d>0 then r.last5d:=r.last5d+a.last5d else r.last5d:=0;
if a.last10d>0 then r.last10d:=r.last10d+a.last10d else r.last10d:=0;
if a.last15d>0 then r.last15d:=r.last15d+a.last15d else r.last15d:=0;
if a.last20d>0 then r.last20d:=r.last20d+a.last20d else r.last20d:=0;
if a.last25d>0 then r.last25d:=r.last25d+a.last25d else r.last25d:=0;
if a.last1m>0 then r.last1m:=r.last1m+a.last1m else r.last1m:=0;
if a.last3m>0 then r.last3m:=r.last3m+a.last3m else r.last3m:=0;
if a.last12m>0 then r.last12m:=r.last12m+a.last12m else r.last12m:=0;

if a.last5dr>0 then r.last5dr:=r.last5dr+a.last5dr else r.last5dr:=0;
if a.last10dr>0 then r.last10dr:=r.last10dr+a.last10dr else r.last10dr:=0;
if a.last15dr>0 then r.last15dr:=r.last15dr+a.last15dr else r.last15dr:=0;
if a.last20dr>0 then r.last20dr:=r.last20dr+a.last20dr else r.last20dr:=0;
if a.last25dr>0 then r.last25dr:=r.last25dr+a.last25dr else r.last25dr:=0;
if a.last1mr>0 then r.last1mr:=r.last1mr+a.last1mr else r.last1mr:=0;
if a.last3mr>0 then r.last3mr:=r.last3mr+a.last3mr else r.last3mr:=0;
if a.last12mr>0 then r.last12mr:=r.last12mr+a.last12mr else r.last12mr:=0;

//if a.last5d>0 then r.last5d:=r.last5d+a.last5d else r.last5d:=0;
if a.last10p>0 then r.last10p:=r.last10p+a.last10p else r.last10p:=0;
if a.last20p>0 then r.last20p:=r.last20p+a.last20p else r.last20p:=0;
if a.last60p>0 then r.last60p:=r.last60p+a.last60p else r.last60p:=0;
if a.last90p>0 then r.last90p:=r.last90p+a.last90p else r.last90p:=0;
if a.last5dat>0 then r.last5dat:=r.last5dat+a.last5dat else r.last5dat:=0;
if a.e1m>0 then r.e1m:=r.e1m+a.e1m else r.e1m:=0;
if a.e1mr>0 then r.e1mr:=r.e1mr+a.e1mr else r.e1mr:=0;
if a.mlg1>0 then r.mlg1:=r.mlg1+a.mlg1 else r.mlg1:=0;
if a.mrlg1>0 then r.mrlg1:=r.mrlg1+a.mrlg1 else r.mrlg1:=0;
if a.vyhdnlg>0 then r.vyhdnlg:=r.vyhdnlg+a.vyhdnlg else r.vyhdnlg:=0;
if a.vyhdnchild>0 then r.vyhdnchild:=r.vyhdnchild+a.vyhdnchild else r.vyhdnchild:=0;
if a.komfort>0 then r.komfort:=r.komfort+a.komfort else r.komfort:=0;
if a.komfortchild>0 then r.komfortchild:=r.komfortchild+a.komfortchild else r.komfortchild:=0;
if a.detsky>0 then r.detsky:=r.detsky+a.detsky else r.detsky:=0;
if a.detsky_last>0 then r.detsky_last:=r.detsky_last+a.detsky_last else r.detsky_last:=0;
if a.uglski>0 then r.uglski:=r.uglski+a.uglski else r.uglski:=0;
if a.udm_sp>0 then r.udm_sp:=r.udm_sp+a.udm_sp else r.udm_sp:=0;
if a.priv_1mr>0 then r. priv_1mr:=r. priv_1mr+a. priv_1mr else r. priv_1mr:=0;
if a.priv_5den>0 then r.priv_5den:=r.priv_5den+a.priv_5den else r.priv_5den:=0;
if a.krskm_sp>0 then r.krskm_sp:=r.krskm_sp+a.krskm_sp else r.krskm_sp:=0;
if a.krskm_child>0 then r.krskm_child:=r.krskm_child+a.krskm_child else r.krskm_child:=0;
if a.krskm_animal>0 then r.krskm_animal:=r.krskm_animal+a.krskm_animal else r.krskm_animal:=0;



end;

procedure ParseCSVStrEx(ts:AF_Types.PStrings; s:widestring; c:char);
 var n:integer;
begin
  ts.clear;
  while pos(c,s)>0 do begin
    n:=pos(c,s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;

(*
procedure load_spb_ablist_internal(f:AF_Types.PStrings; var ab200:TAB200);
  var i,n:integer;
  var u,x:AF_Types.TStrings;
  var g:real;
begin
  u.create; x.create;
  for i:=1 to 200 do ClearAbTariffList(ab200[i]);
   ParseCSVStrEx(@u,f.getstring(1),';');
   if u.count>1 then begin
     for i:=1 to u.count do x.add(ansilowercase(u.getstring(i)));
   end;
   for i:=2 to f.count do begin
    ParseCSVStrEx(@u,f.getstring(i),';');
    if u.count>1 then begin
     for n:=2 to u.count do begin
      if validstr(x.getstring(n)) then begin
       g:=StrToFloat(u.getstring(n));
       if g>0 then begin
         if x.getstring(n)='1m' then ab200[strtointe(u.getstring(1))].m1:=g;
         if x.getstring(n)='1mr' then ab200[strtointe(u.getstring(1))].m1r:=g;
         if x.getstring(n)='5d' then ab200[strtointe(u.getstring(1))].d5:=g;
         if x.getstring(n)='10d' then ab200[strtointe(u.getstring(1))].d10:=g;
         if x.getstring(n)='15d' then ab200[strtointe(u.getstring(1))].d15:=g;
         if x.getstring(n)='10dr' then ab200[strtointe(u.getstring(1))].d10r:=g;
         if x.getstring(n)='15dr' then ab200[strtointe(u.getstring(1))].d15r:=g;
         if x.getstring(n)='5dat' then ab200[strtointe(u.getstring(1))].dat5:=g;
         if x.getstring(n)='6dat' then ab200[strtointe(u.getstring(1))].dat6:=g;
         if x.getstring(n)='7dat' then ab200[strtointe(u.getstring(1))].dat7:=g;
         if x.getstring(n)='8dat' then ab200[strtointe(u.getstring(1))].dat8:=g;
         if x.getstring(n)='9dat' then ab200[strtointe(u.getstring(1))].dat9:=g;
         if x.getstring(n)='10dat' then ab200[strtointe(u.getstring(1))].dat10:=g;
         if x.getstring(n)='11dat' then ab200[strtointe(u.getstring(1))].dat11:=g;
         if x.getstring(n)='12dat' then ab200[strtointe(u.getstring(1))].dat12:=g;
         if x.getstring(n)='13dat' then ab200[strtointe(u.getstring(1))].dat13:=g;
         if x.getstring(n)='14dat' then ab200[strtointe(u.getstring(1))].dat14:=g;
         if x.getstring(n)='15dat' then ab200[strtointe(u.getstring(1))].dat15:=g;
         if x.getstring(n)='16dat' then ab200[strtointe(u.getstring(1))].dat16:=g;
       end;
      end;
     end;
    end;
   end;
  u.free; x.free;
end;


procedure load_spb_ablist(dir:string);
  var i,n:integer;
  var f:AF_Types.TStrings;
  var res:boolean;
begin
  res:=true;
  f.create;
  dir:=deleteslasheex(dir);

  f.clear;
  f.loadfromfile(dir+'\spb_lim.csv');
  if f.count>2 then begin
   load_spb_ablist_internal(@f,abtable_spb_lim);
  end
   else res:=false;

  f.clear;
  f.loadfromfile(dir+'\spb_notlim.csv');
  if f.count>2 then begin
   load_spb_ablist_internal(@f,abtable_spb_notlim);
  end
   else res:=false;

  f.clear;
  f.loadfromfile(dir+'\lenobl_lim.csv');
  if f.count>2 then begin
   load_spb_ablist_internal(@f,abtable_lenobl_lim);
  end
   else res:=false;

  f.clear;
  f.loadfromfile(dir+'\lenobl_notlim.csv');
  if f.count>2 then begin
   load_spb_ablist_internal(@f,abtable_lenobl_notlim);
  end
   else res:=false;

  f.clear;
  f.loadfromfile(dir+'\novgorod_lim.csv');
  if f.count>2 then begin
   load_spb_ablist_internal(@f,abtable_novgorod_lim);
  end
   else res:=false;

  f.clear;
  f.loadfromfile(dir+'\novgorod_notlim.csv');
  if f.count>2 then begin
   load_spb_ablist_internal(@f,abtable_novgorod_notlim);
  end
   else res:=false;

  if not res then ShowMessage('      ');
  f.free;
end;




function GetTarifInfofsp(ttype,tmode:string; var t:TTariffsp):boolean;
  var res:boolean;
begin
  res:=false;
  ttype:=AnsiUpperCase(trim(ttype));
  tmode:=AnsiUpperCase(trim(tmode));
  if ((ttype='SPB')or(ttype='SPB1')) then begin
    if tmode='ETRAIN' then begin
      t.limit:=14;
      t.price_km:=2.5;
      t.price_km20:=2.5;
      t.price_limit:=35;
      res:=true;                 // c 01.01.2016
    end;
  end; //SPB
  if ttype='SPB_GOROD' then begin
    if tmode='ETRAIN' then begin
      t.limit:=20;
      t.price_km:=2;
      t.price_km20:=2;            // c 01.01.2016
      t.price_limit:=40;           //       
      res:=true;
    end;
  end; //SPB_GOROD
  if ttype='NOVGOROD' then begin
    if tmode='ETRAIN' then begin
      t.limit:=0;
      t.price_km:=3.5;   //    getZoneTariff
      t.price_limit:=0;  // c 01.01.2016
      res:=true;
    end;
  end; //NOVGOROD
  result:=res;
end;
*)

function GetTariffFromAbList(t:string; km:integer; abl:TAb200):real;
begin
 result:=0;
 if t='m1' then result:=abl[km].m1;
 if t='m1r' then result:=abl[km].m1r;
 if t='d5' then result:=abl[km].d5;
 if t='d10' then result:=abl[km].d10;
 if t='d15' then result:=abl[km].d15;
 if t='d10r' then result:=abl[km].d10r;
 if t='d15r' then result:=abl[km].d15r;
 if t='dat5' then result:=abl[km].dat5;
 if t='dat6' then result:=abl[km].dat6;
 if t='dat7' then result:=abl[km].dat7;
 if t='dat8' then result:=abl[km].dat8;
 if t='dat9' then result:=abl[km].dat9;
 if t='dat10' then result:=abl[km].dat10;
 if t='dat11' then result:=abl[km].dat11;
 if t='dat12' then result:=abl[km].dat12;
 if t='dat13' then result:=abl[km].dat13;
 if t='dat14' then result:=abl[km].dat14;
 if t='dat15' then result:=abl[km].dat15;
 if t='dat16' then result:=abl[km].dat16;
end;

(*
Function vCalcAbTariff_SPB032014(km1:real;type1,tarif:string;lim:boolean;obr:boolean):real;
  var km:integer;
  var res:boolean;
  var r:real;
begin
 result:=0;
 res:=false;
 type1:=ansilowercase(type1);
 tarif:=ansilowercase(tarif);
 SetRoundMode(rmTruncate);
 km:=round(km1);
  if type1='spb_gorod' then begin
    if lim then begin
      r:=GetTariffFromAbList(tarif,km,abtable_spb_lim);
      if r>0 then begin
        result:=r;
        res:=true;
      end;
    end
     else begin
      r:=GetTariffFromAbList(tarif,km,abtable_spb_notlim);
      if r>0 then begin
        result:=r;
        res:=true;
      end;
     end;
  end;
  if type1='spb' then begin
    if lim then begin
      r:=GetTariffFromAbList(tarif,km,abtable_lenobl_lim);
      if r>0 then begin
        result:=r;
        res:=true;
      end;
    end
     else begin
      r:=GetTariffFromAbList(tarif,km,abtable_lenobl_notlim);
      if r>0 then begin
        result:=r;
        res:=true;
      end;
     end;
  end;
  if type1='novgorod' then begin
    if lim then begin
      r:=GetTariffFromAbList(tarif,km,abtable_novgorod_lim);
      if r>0 then begin
        result:=r;
        res:=true;
      end;
    end
     else begin
      r:=GetTariffFromAbList(tarif,km,abtable_novgorod_notlim);
      if r>0 then begin
        result:=r;
        res:=true;
      end;
     end;
  end;
 if not res then showmessage(' vCalcAbTariff_SPB032014: '+inttostr(km)+', '+type1+', '+tarif);
end;


Function vCalcMonoTarif_SPB2013fsp(km1:real;type1,tarif:string;lim:boolean;obr:boolean):real;
  var t1:TTariffsp;
  var res:boolean;
  var s:string;
  var r:real;
begin
 res:=true;
 r:=0;
 if ((AnsiLowerCase(tarif)='intrain')and(AnsiLowerCase(type1)='spb')) then begin
   showmessage('error - intrain!');
   if km1=1 then r:=35;
   if km1=200 then r:=500;
 end
 else begin
  tarif:='ETRAIN';
  if not GetTarifInfofsp(type1,tarif,t1) then res:=false;
  if res then begin
    tarif:=AnsiLowerCase(trim(tarif));
    if lim then begin
     if km1<=t1.limit then begin
      r:=t1.price_limit;
      km1:=km1-t1.limit;
        if km1>0 then begin
              if ((AnsiLowerCase(type1)='spb')or(AnsiLowerCase(type1)='spb_gorod')) then begin  //   1.01.2015   r:=r+(km1*t1.price_km);  
                setroundmode(rmDown);
                r:=r+Round(km1*t1.price_km);
              end
               else begin
                 setroundmode(rmDown);
                 r:=r+round(km1*t1.price_km);
               end;
        end;
     end
      else begin
        if ((AnsiLowerCase(type1)='spb')and(km1>16)and(km1<21)) then begin
             setroundmode(rmDown);
             r:=round(km1*t1.price_km20);
        end
         else begin
          r:=t1.price_limit;
            if km1>0 then begin
              if ((AnsiLowerCase(type1)='spb')or(AnsiLowerCase(type1)='spb_gorod')) then begin  //   1.01.2015   r:=r+(km1*t1.price_km);  
                setroundmode(rmDown);
                r:=round(km1*t1.price_km);
              end
               else begin
                 setroundmode(rmDown);
                 km1:=km1-t1.limit;
                 r:=r+Round(km1*t1.price_km);
               end;
            end;
         end;
      end;
    end //lim
     else begin
      if ((AnsiLowerCase(type1)='spb_gorod')and(km1>t1.limit)) then begin
         if obr then begin
            setroundmode(rmDown);
            r:=round(km1*2);                    //   
         end
          else begin
            r:=t1.price_limit;
            km1:=km1-t1.limit;
             if km1>0 then begin
              if ((AnsiLowerCase(type1)='spb')or(AnsiLowerCase(type1)='spb_gorod')) then begin  //   1.01.2015   r:=r+(km1*t1.price_km);  
                setroundmode(rmDown);
                r:=r+round(km1*t1.price_km);
              end
               else begin
                 setroundmode(rmDown);
                 r:=r+round(km1*t1.price_km);
               end;
             end;
          end;
      end
       else begin
         if ((AnsiLowerCase(type1)='spb_gorod')and(km1<=t1.limit)) then begin
           setroundmode(rmDown);
           r:=round(km1*t1.price_km20);
         end
          else begin
            if ((AnsiLowerCase(type1)='spb')or(AnsiLowerCase(type1)='spb_gorod')) then begin  //     spb
             setroundmode(rmDown);
             r:=round(km1*t1.price_km);
            end
             else begin
               setroundmode(rmDown);
               r:=round(km1*t1.price_km);
             end;
          end;
       end;
     end;
    s:=floattostr(r);
  end;
 end;
 result:=r;
end;

function findNovgorodfsp(ps: AF_Types.PStrings):boolean;
begin
 if ps.searchstring('novgorod')>0 then result:=true
                                  else result:=false;
end;

procedure Calc_SPB2013fsp;
  var i,n,m,x,z,km,kmz,prevkm,nkm,xx,kmm:integer;
  var rt,ro,rt1,ro1,rt9,ro9,rtx,rtin,roin,ab0:real;
  var kmt,kmt0,s,s1,s2:string;
  var lim,procab:boolean;
  var trn,trkm,trn1,trkm1,log:AF_Types.TStrings;
  var ab:TAbTarifList;
begin
spblogflag:=true;
with form1 do begin
  procab:=false;
  if checkbox2.Checked then procab:=true;
  if checkbox3.Checked then procab:=true;
  if checkbox4.Checked then procab:=true;
  if checkbox5.Checked then procab:=true;
  if checkbox6.Checked then procab:=true;
  if checkbox9.Checked then procab:=true;
  if checkbox10.Checked then procab:=true;
  if checkbox13.Checked then procab:=true;
  if procab then load_spb_ablist(DeleteSlasheEx(ExtractDirPath(OpenDialog1.FileName))+'\tables');

  trn.create; trkm.create; trn1.create; trkm1.create; log.create;
  for m:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,m]:=trim(ansilowercase(stringgrid1.Cells[4,m]));
    stringgrid1.Cells[5,m]:=trim(ansilowercase(stringgrid1.Cells[5,m]));
  end;

  for i:=0 to stringgrid3.ColCount-1 do begin
   for m:=0 to stringgrid3.RowCount-1 do begin
     stringgrid3.Cells[i,m]:='';
   end;
  end;

  stringgrid3.RowCount:=stringgrid1.RowCount;
  stringgrid3.ColCount:=stringgrid1.RowCount;

  for i:=0 to stringgrid3.ColCount-1 do begin
   for m:=0 to stringgrid3.RowCount-1 do begin
     stringgrid3.Cells[i,m]:='';
   end;
  end;

  for i:=0 to stringgrid1.RowCount-1 do begin
    stringgrid3.cells[0,i]:=stringgrid1.Cells[0,i];
    stringgrid3.cells[1,i]:=stringgrid1.Cells[1,i];
    stringgrid3.cells[i,0]:=stringgrid1.Cells[0,i];
    stringgrid3.cells[i,1]:=stringgrid1.Cells[1,i];
  end;

  if stringgrid1.colcount<11 then stringgrid1.colcount:=11;

   for i:=1 to stringgrid1.rowcount-1 do begin
    if length(trim(stringgrid1.Cells[10,i]))<1 then stringgrid1.Cells[10,i]:=stringgrid1.Cells[4,i]+trim(stringgrid1.Cells[6,i]);
    if stringgrid1.Cells[10,i]='spb_gorod' then stringgrid1.Cells[10,i]:='spb';
   end;

   for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        kmz:=strtointe(stringgrid1.Cells[3,i]);
        kmt:='###';
        kmt0:='###';
        trn.clear;
        trkm.clear;
        rt:=0;
        ro:=0;
        rtin:=0;
        roin:=0;
        lim:=true;
        for x:=i to n do begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,i]) then begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,n]) then begin
            if stringgrid1.Cells[4,x]<>kmt then begin
              if kmt='###' then begin
                kmt:=stringgrid1.Cells[4,x];
                kmz:=strtointe(stringgrid1.Cells[3,x]);
              end
               else begin
                 km:=strtointe(stringgrid1.Cells[3,x-1])-kmz;
                 if km>0 then begin
                 trn.add(kmt);
                 trkm.add(inttostr(km));
                 end;
                 kmz:=strtointe(stringgrid1.Cells[3,x-1]);
                 kmt0:=kmt;
                 kmt:=stringgrid1.Cells[4,x];
               end;
            end
          end;
          end;
        end;
        if kmt<>'###' then begin
          km:=strtointe(stringgrid1.Cells[3,n])-kmz;
          if km>0 then begin
          trn.add(kmt);
          trkm.add(inttostr(km));
          end;
        end;
        trn1.clear;
        trkm1.clear;
        kmz:=strtointe(stringgrid1.Cells[3,i]);
        kmt:='###';
        kmt0:='###';
        km:=0;
        prevkm:=0;
        nkm:=0;
        lim:=true;
        rt1:=0;
        ro1:=0;
        xx:=0;
        for x:=i to n do begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,i]) then begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,n]) then begin
            inc(xx);
            if stringgrid1.Cells[10,x]<>kmt then begin
              if xx=2 then kmt:=stringgrid1.Cells[10,x];
            end;
            if stringgrid1.Cells[10,x]<>kmt then begin
              if kmt='###' then begin
                kmt:=stringgrid1.Cells[10,x];
                nkm:=strtointe(stringgrid1.Cells[3,x]);
              end
               else begin
                 km:=strtointe(stringgrid1.Cells[3,x])-nkm;
                 if km>0 then begin
                   trn1.add(kmt);
                   trkm1.add(inttostr(km));
                   nkm:=strtointe(stringgrid1.Cells[3,x]);
                 end;
                 kmt0:=kmt;
                 kmt:=stringgrid1.Cells[10,x];
               end;
            end
          end;
          end;
        end;
        if kmt<>'###' then begin
          km:=strtointe(stringgrid1.Cells[3,n])-nkm;
          if km>0 then begin
          trn1.add(kmt);
          trkm1.add(inttostr(km));
          end;
        end;

log.add('');
log.add(stringgrid1.Cells[1,i]+' - '+stringgrid1.Cells[1,n]);
/////   
        if trn.count>0 then begin
          if trn.count=1 then lim:=true
                         else lim:=false;
          rt:=0;
          ro:=0;
          rtin:=0;
          roin:=0;
          rt9:=0;
          s:='';
          s2:='';
          log.add(':');

          for x:=1 to trn.count do begin
            s:=s+trkm.getstring(x)+' ';
            if ((x=1)and(trn.count>1)) then begin
              if ((trn.getstring(1)='spb_gorod')and(trn.getstring(2)='spb')) then begin
               if ((strtointe(trkm.getstring(1))<=20)and(strtointe(trkm.getstring(2))<=20)) then lim:=true;
//                if ((strtointe(trkm.getstring(1))<=20){and(strtointe(trkm.getstring(2))<=20)}) then lim:=true;
              end;
            end;
            kmm:=strtointe(trkm.getstring(x));
            if ((x=2)and(trn.count>1)) then begin
              if ((trn.getstring(1)='spb_gorod')and(trn.getstring(2)='spb')) then begin
               if ((strtointe(trkm.getstring(1))<=20)and(strtointe(trkm.getstring(2))<=20)) then kmm:=kmm-(20-strtointe(trkm.getstring(1)));
//                 if ((strtointe(trkm.getstring(1))<=20)and(strtointe(trkm.getstring(2))<=20)) then kmm:=kmm-(20-strtointe(trkm.getstring(1)));
              end;
            end;

            rtx:=vCalcMonoTarif_SPB2013fsp(kmm,trn.getstring(x),'ETRAIN',lim,false);
            lim:=false;
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmDown);
                rt:=round(rt);
              end;
            rt:=rt+rtx;

{            rtx:=vCalcMonoTarif_SPB2013fsp(kmm,trn.getstring(x),'INTRAIN',lim,false);
            lim:=false;
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                rtin:=round(rtin);
              end;
            rtin:=rtin+rtx;
}
            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
          end; //for

          for x:=trn.count downto 1 do begin
            s2:=s2+trkm.getstring(x)+' ';
            kmm:=strtointe(trkm.getstring(x));
            if ((trn.getstring(x)='novgorod')) then lim:=true;
            rtx:=vCalcMonoTarif_SPB2013fsp(kmm,trn.getstring(x),'ETRAIN',lim,true);
            lim:=false;
            ro:=ro+rtx;
{            rtx:=vCalcMonoTarif_SPB2013fsp(kmm,trn.getstring(x),'INTRAIN',lim,true);
            lim:=false;
            roin:=roin+rtx;}
            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
          end;

        rt9:=rt;
        ro9:=rt;
         if not findNovgorodfsp(@trn) then begin
           SetRoundMode(rmDown);
//           SetRoundMode(rmTruncate);
           rt:=round(rt);
           rtin:=round(rtin);
           ro:=round(ro);
         end
          else begin
           SetRoundMode(rmDown);
           rt:=round(rt);
           rtin:=round(rtin);
           ro:=round(ro);
          end;

        end;
///// -  

if procab then begin
/////  
        if trn.count>0 then begin
          if trn.count=1 then lim:=true
                         else lim:=false;
          log.add(':');
          s:='';
          s2:='';
          ClearAbTariffList(ab);

          for x:=1 to trn.count do begin
            s:=s+trkm.getstring(x)+' ';
            if ((x=1)and(trn.count>1)) then begin
              if ((trn.getstring(1)='spb_gorod')and(trn.getstring(2)='spb')) then begin
               if ((strtointe(trkm.getstring(1))<=20)and(strtointe(trkm.getstring(2))<=20)) then lim:=true;
              end;
            end;
            kmm:=strtointe(trkm.getstring(x));
            if ((x=2)and(trn.count>1)) then begin
              if ((trn.getstring(1)='spb_gorod')and(trn.getstring(2)='spb')) then begin
               if ((strtointe(trkm.getstring(1))<=20)and(strtointe(trkm.getstring(2))<=20)) then kmm:=kmm-(20-strtointe(trkm.getstring(1)));
              end;
            end;

          if kmm>0 then begin
            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'m1',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.m1:=round(ab.m1);
              end;
            ab.m1:=ab.m1+ab0;

            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'m1r',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.m1r:=round(ab.m1r);
              end;
            ab.m1r:=ab.m1r+ab0;

            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'d5',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.d5:=round(ab.d5);
              end;
            ab.d5:=ab.d5+ab0;

            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'d10',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.d10:=round(ab.d10);
              end;
            ab.d10:=ab.d10+ab0;

            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'d15',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.d15:=round(ab.d15);
              end;
            ab.d15:=ab.d15+ab0;

            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'d10r',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.d10r:=round(ab.d10r);
              end;
            ab.d10r:=ab.d10r+ab0;

            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'d15r',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.d15r:=round(ab.d15r);
              end;
            ab.d15r:=ab.d15r+ab0;

//           if not findNovgorodfsp(@trn) then begin
            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'dat5',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.dat5:=round(ab.dat5);
              end;
            ab.dat5:=ab.dat5+ab0;
            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'dat6',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.dat6:=round(ab.dat6);
              end;
            ab.dat6:=ab.dat6+ab0;
            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'dat7',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.dat7:=round(ab.dat7);
              end;
            ab.dat7:=ab.dat7+ab0;
            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'dat8',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.dat8:=round(ab.dat8);
              end;
            ab.dat8:=ab.dat8+ab0;
            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'dat9',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.dat9:=round(ab.dat9);
              end;
            ab.dat9:=ab.dat9+ab0;
            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'dat10',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.dat10:=round(ab.dat10);
              end;
            ab.dat10:=ab.dat10+ab0;
            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'dat11',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.dat11:=round(ab.dat11);
              end;
            ab.dat11:=ab.dat11+ab0;
            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'dat12',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.dat12:=round(ab.dat12);
              end;
            ab.dat12:=ab.dat12+ab0;
            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'dat13',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.dat13:=round(ab.dat13);
              end;
            ab.dat13:=ab.dat13+ab0;
            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'dat14',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.dat14:=round(ab.dat14);
              end;
            ab.dat14:=ab.dat14+ab0;
            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'dat15',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.dat15:=round(ab.dat15);
              end;
            ab.dat15:=ab.dat15+ab0;
            ab0:=vCalcAbTariff_SPB032014(kmm,trn.getstring(x),'dat16',lim,false);
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                ab.dat16:=round(ab.dat16);
              end;
            ab.dat16:=ab.dat16+ab0;
//           end; //findnovgorod  -         ( 2015 - )
          end; //kmm>0
           lim:=false;
           log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
          end; //for

         if not findNovgorodfsp(@trn) then begin
           SetRoundMode(rmNearest);
           ab.m1:=round(ab.m1);
           ab.m1r:=round(ab.m1r);
           ab.d5:=round(ab.d5);
           ab.d10:=round(ab.d10);
           ab.d15:=round(ab.d15);
           ab.d10r:=round(ab.d10r);
           ab.d15r:=round(ab.d15r);
           ab.dat5:=round(ab.dat5);
           ab.dat6:=round(ab.dat6);
           ab.dat7:=round(ab.dat7);
           ab.dat8:=round(ab.dat8);
           ab.dat9:=round(ab.dat9);
           ab.dat10:=round(ab.dat10);
           ab.dat11:=round(ab.dat11);
           ab.dat12:=round(ab.dat12);
           ab.dat13:=round(ab.dat13);
           ab.dat14:=round(ab.dat14);
           ab.dat15:=round(ab.dat15);
           ab.dat16:=round(ab.dat16);
         end
          else begin
           SetRoundMode(rmTruncate);
           ab.m1:=round(ab.m1);
           ab.m1r:=round(ab.m1r);
           ab.d5:=round(ab.d5);
           ab.d10:=round(ab.d10);
           ab.d15:=round(ab.d15);
           ab.d10r:=round(ab.d10r);
           ab.d15r:=round(ab.d15r);
           ab.dat5:=round(ab.dat5);
           ab.dat6:=round(ab.dat6);
           ab.dat7:=round(ab.dat7);
           ab.dat8:=round(ab.dat8);
           ab.dat9:=round(ab.dat9);
           ab.dat10:=round(ab.dat10);
           ab.dat11:=round(ab.dat11);
           ab.dat12:=round(ab.dat12);
           ab.dat13:=round(ab.dat13);
           ab.dat14:=round(ab.dat14);
           ab.dat15:=round(ab.dat15);
           ab.dat16:=round(ab.dat16);
          end;

          log.add('m1:    '+floattostr(ab.m1));
          log.add('m1r:   '+floattostr(ab.m1r));
          log.add('d5:    '+floattostr(ab.d5));
          log.add('d10:   '+floattostr(ab.d10));
          log.add('d15:   '+floattostr(ab.d15));
          log.add('d10r:  '+floattostr(ab.d10r));
          log.add('d15r:  '+floattostr(ab.d15r));
//          if not findNovgorodfsp(@trn) then begin
          log.add('dat5:  '+floattostr(ab.dat5));
          log.add('dat6:  '+floattostr(ab.dat6));
          log.add('dat7:  '+floattostr(ab.dat7));
          log.add('dat8:  '+floattostr(ab.dat8));
          log.add('dat9:  '+floattostr(ab.dat9));
          log.add('dat10: '+floattostr(ab.dat10));
          log.add('dat11: '+floattostr(ab.dat11));
          log.add('dat12: '+floattostr(ab.dat12));
          log.add('dat13: '+floattostr(ab.dat13));
          log.add('dat14: '+floattostr(ab.dat14));
          log.add('dat15: '+floattostr(ab.dat15));
          log.add('dat16: '+floattostr(ab.dat16));
//          end;


        end;
///// - 
////      trn, ..     
end; //procab

        if checkbox1.checked then begin
         if ((stringgrid1.Cells[0,i]<>'0')and(stringgrid1.Cells[0,n]<>'0')) then begin
          if rt>0 then begin
           if trn.count=1 then begin
             if trn.searchstring('spb')>0 then begin
               tlog15.add(trkm.getstring(1)+';'+stringgrid1.Cells[0,i]+';'+stringgrid1.Cells[0,n]+';'+stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]);
             end;
           end;
           if ((rt<=32)and(trn.count>1)) then begin
            s1:='35';
            if trn.searchstring('spb_gorod')>0 then s1:='40';
            WriteLn(tf1,'simple;'+stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+s1+' ('+inttostr(trn.count)+') '+s);
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+s1+'" type="etrain" reverse="1" />');
            log.add(' - '+s1+'   1');
            tlog16.add(stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+s1);
            stringgrid3.Cells[i,n]:=s1;
           end
            else begin
             if ((findNovgorodfsp(@trn))and(trn.count>1)) then begin
               WriteLn(tf1,'tariff;'+stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt)+' ['+floattostr(rt9)+'] ('+inttostr(trn.count)+') '+s+' /   '+floattostr(rtin));
               WriteLn(tf1,'  tariff;'+stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro)+' ['+floattostr(ro9)+'] ('+inttostr(trn.count)+') '+s2+' /   '+floattostr(roin));
               WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt)+'" type="etrain" reverse="0" />');
               WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro)+'" type="etrain" reverse="0" />');
               log.add(' - '+floattostr(rt)+'  / '+floattostr(ro)+'    2');
               tlog16.add(stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt));
               stringgrid3.Cells[i,n]:=floattostr(rt);
             end
              else begin
               WriteLn(tf1,'tariff;'+stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt)+' ['+floattostr(rt9)+'] ('+inttostr(trn.count)+') '+s+' /   '+floattostr(rtin));
               WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt)+'" type="etrain" reverse="1" />');
               log.add(' - '+floattostr(rt)+' /   3');
               tlog16.add(stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt));
               stringgrid3.Cells[i,n]:=floattostr(rt);
              end;
            end;
          end;
         end;
        end; // checkbox1

        if procab then begin
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.m1)+'" type="1m" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.m1r)+'" type="1mr" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.d5)+'" type="5d" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.d10)+'" type="10d" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.d15)+'" type="15d" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.d10r)+'" type="10dr" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.d15r)+'" type="15dr" reverse="1" />');
  //        if findNovgorodfsp(@trn) then begin
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.dat5)+'" type="5dat" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.dat6)+'" type="6dat" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.dat7)+'" type="7dat" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.dat8)+'" type="8dat" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.dat9)+'" type="9dat" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.dat10)+'" type="10dat" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.dat11)+'" type="11dat" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.dat12)+'" type="12dat" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.dat13)+'" type="13dat" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.dat14)+'" type="14dat" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.dat15)+'" type="15dat" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ab.dat16)+'" type="16dat" reverse="1" />');
//          end;
        end;

      end;
    end;
  end;
//  log.savetofile('C:\AF\\\1.1');
  trn.free; trkm.free; trn1.free; trkm1.free; log.free;
end;
end;

*)
















function getParam(s1,s:string):string;
  var s2:string;
begin
  s:=trim(s);
  s2:='';
  if pos(s1+'="',s)>0 then begin
    s2:=copy(s,pos(s1+'="',s)+2+length(s1),length(s));
     if pos('"',s2)>0 then s2:=copy(s2,1,pos('"',s2)-1);
  end;
  result:=trim(s2);
end;


{function okr5(f:real):real;
 var n,p,k:real;
begin
  setroundmode(rmDown);
  n:=round(f/10);
  n:=n*10;
  p:=f-n;
  k:=0;
  if p<2.5 then k:=0;
  if p>=2.5 then k:=5;
  if p>=7.5 then k:=10;
  result:=n+k;
end;
}
procedure ClearSG(sg:TStringGrid);
  var c,r:integer;
begin
  for c:=0 to sg.colcount-1 do
    for r:=0 to sg.RowCount-1 do sg.cells[c,r]:='';
end;

function z2t(s:string):string;
 var n,l:integer;
begin
  l:=length(s);
  if l>0 then begin
    n:=pos(',',s);
    if n>0 then begin
     if n=l-1 then s[n]:='.';
     if n=l-2 then s[n]:='.';
    end;
  end;
  result:=s;
end;

procedure LoadFromXLS(fn:string; sg:TStringGrid);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
X, Y, xx, yy : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf:string;
tf:double;
begin
with form1 do begin
clearsg(sg);
NomFich := fn;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
sg.ColCount := Y;
sg.RowCount := X;
clearsg(sg);

for xx:=1 to x do begin
  for yy:=1 to y do begin
    nf:=worksheet.cells.item[xx,yy].NumberFormat;
    if (nf=':')or(nf=':')or(nf='h:mm')or(nf='hh:mm;@')or(nf=':;@')or(nf=':;@')or(nf='h:mm;@')or(nf='hh:mm;@') then begin
       tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xx,yy]),70);
       if tf=70 then sg.Cells[yy-1,xx-1]:=z2t(trim(VarToStrDef(worksheet.cells.item[xx,yy],'')))
                else sg.Cells[yy-1,xx-1]:=z2t(trim(FormatDateTime('hh:nn',tf)));
    end
     else sg.Cells[yy-1,xx-1]:=z2t(trim(VarToStrDef(worksheet.cells.item[xx,yy],'')));
  end;
end;


XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;
end;
end;


procedure LoadFromXLSRangeMatrix(fn:string; sg:TStringGrid);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
X, Y, xx, yy : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
begin
with form1 do begin
clearsg(sg);
NomFich := fn;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
WorkSheet.Activate(0);
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
sg.ColCount := Y;
sg.RowCount := X;
clearsg(sg);
RangeMatrix := XLApp.Range['A1', XLApp.Cells.Item[X, Y]].Value2;
    if ((y>1)and(x>1)) then begin
      for yy:=1 to y do begin
        for xx:=1 to x do begin
          sg.cells[yy-1,xx-1]:=trim(VarToStrDef(RangeMatrix[xx,yy],''));
        end;
      end;
    end;
XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;
end;
end;


function CompareDirections(d1,d2:string):boolean;
  var res:boolean;
  var i:integer;
begin
  res:=false;
  if length(d1)>0 then begin
    for i:=1 to length(d1) do begin
      if pos(d1[i],d2)>0 then res:=true;
    end;
  end;
  result:=res;
end;


(*
procedure Calc_SPB2010old;
  var tn,tp:AF_Types.TStrings;
  var i,n,m:integer;
  var km,t,km1,km2,r:real;
begin
with form1 do begin
  tn.create;
  tp.create;
    tn.add('spb');
    tn.add('spb_20');
    tn.add('novgorod');
    tn.add('novgorod_20');
    tp.add('1.50');
    tp.add('30');
    tp.add('1.90');
    tp.add('38');
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;

  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        km:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        if km<21 then begin
          t:=strtofloat(trim(tp.getstring(tn.SearchString(trim(stringgrid1.Cells[4,i])+'_20'))));
          stringgrid1.Cells[i+5,n]:='t_'+floattostr(t);
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t)+'" type="etrain" reverse="1" />');
        end
         else begin
           if trim(stringgrid1.Cells[4,i])=trim(stringgrid1.Cells[4,n]) then begin
             t:=strtofloat(trim(tp.getstring(tn.SearchString(trim(stringgrid1.Cells[4,i])))));
             stringgrid1.Cells[i+5,n]:='f_'+floattostr(km*t);
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(km*t)+'" type="etrain" reverse="1" />');
           end
            else begin
              km1:=0;
              for m:=i+1 to n do begin
                if ((stringgrid1.cells[4,m]=stringgrid1.Cells[4,n])and(stringgrid1.cells[4,m-1]=stringgrid1.Cells[4,i])and(CompareDirections(stringgrid1.cells[2,i],stringgrid1.cells[2,m]))) then begin
                   km1:=strtofloat(trim(stringgrid1.cells[3,m]));
                   break;
                end;
              end;
              if km1>0 then begin
               km2:=abs(km1-strtofloat(trim(stringgrid1.Cells[3,i])));
               t:=strtofloat(trim(tp.getstring(tn.SearchString(trim(stringgrid1.Cells[4,i])))));
               r:=km2*t;
               km2:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-km1);
               t:=strtofloat(trim(tp.getstring(tn.SearchString(trim(stringgrid1.Cells[4,n])))));
               r:=r+(km2*t);
               stringgrid1.Cells[i+5,n]:='f_'+floattostr(r);
               WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(r)+'" type="etrain" reverse="1" />');
              end;
            end;
         end;
      end;
    end;
  end;

  tp.free;
  tn.free;
end;
end;
*)

function GetTarifInfo(ttype,tmode:string; km:real; var t:TTarif):boolean;
  var res:boolean;
  var abt:TAbTarifList;
begin
  t.finmode:=false;
  res:=false;
  abt.m1:=0;
  abt.m1r:=0;
  abt.d5:=0;
  abt.d10:=0;
  abt.d15:=0;
  abt.d10r:=0;
  abt.d15r:=0;
  ttype:=AnsiUpperCase(trim(ttype));
  tmode:=AnsiUpperCase(trim(tmode));
      showmessage('  !');
      halt(1);

  result:=res;
end;

function isc1(r:real):boolean;
 var s:string;
begin
  s:=floattostr(r);
  if pos('.0',s)=length(s)-1 then delete(s,pos('.0',s),2);
  if pos(',0',s)=length(s)-1 then delete(s,pos(',0',s),2);
  if ((pos('.',s)>0)or(pos(',',s)>0)) then result:=false
                                         else result:=true;
end;

function roundn1(e:extended):integer;
 var i1:integer;
 var i2:extended;
begin
  i1:=trunc(e);
  i2:=frac(e);
  if i2>=0.5 then inc(i1);
  result:=i1;
end;

function roundn12(e:double):integer;
 var i1:integer;
 var i2:double;
begin
  i1:=trunc(e);
  i2:=frac(e);
  if i2>=0.5 then inc(i1);
  result:=i1;
end;

Function GetZoneTariff(ttype:string; zone:integer):real;
  var res:extended;
//  var res:real;
  var r4:double;
  var res1:real;
  var x,y,z1,z2,r5,r6:integer;
  var vflg:boolean;
begin
  vflg:=false;
  ttype:=trim(ansiuppercase(ttype));
  res:=0;


  if (ttype='NN_GOROD') then begin   // c 15.01.2022
    vflg:=true;
    res:=31;
  end;

  if ttype='NN_ARZ' then begin   //c 01.01.2020           NN_PIZHMA!!!
    vflg:=true;
    case zone of
      0: res:=29;
      1: res:=29;
      2: res:=58;
      3: res:=83;
      4: res:=101;
      5: res:=120;
      6: res:=138;
      7: res:=154;
      8: res:=173;
      9: res:=190;
      10: res:=206;
      11: res:=225;
      12: res:=242;
      13: res:=260;
      14: res:=277;
      15: res:=295;
      16: res:=312;
      17: res:=329;
      18: res:=347;
      19: res:=365;
      20: res:=383;
    end;             //         NN_PIZHMA !!!
  end;

  if ttype='NN_PIZHMA' then begin    // c 01.01.2020
    vflg:=true;
    if zone<=1 then res:=18
               else res:=zone*18;
  end;


  if ttype='ASTRAKHAN' then begin    // c 01.01.2022
    vflg:=true;
    if zone<=1 then res:=21.4
               else res:=zone*21.4;
  end;

  if ttype='VOLGOGRAD_KM' then begin    // c 01.01.2017
    vflg:=true;
    if zone<1 then res:=20
              else begin
                x:=zone div 10;
                y:=zone mod 10;
                if y>0 then x:=x+1;
                res:=x*20;
              end;
  end;

  if ((ttype='VOLGOGRAD')or(ttype='VOLGOGRAD1')or(ttype='VOLGOGRAD2')) then begin    // c 01.01.2017
    vflg:=true;
    if zone<=1 then res:=20
               else res:=zone*20;
  end;

  if (ttype='VOLGOGRAD_GOROD') then begin   // c 01.01.2017
    vflg:=true;
    res:=40;
  end;

  if ((ttype='UDM_VVPPK')or(ttype='UDM_VVPPK1')or(ttype='UDM_VVPPK2')) then begin   // c 01.01.2022
    vflg:=true;
    if zone<11 then res:=30;
    if (zone in [11..15]) then res:=45;
    if (zone in [16..20]) then res:=60;
    if (zone in [21..25]) then res:=75;
    if (zone in [26..30]) then res:=90;
    if (zone in [31..35]) then res:=105;
    if (zone in [36..40]) then res:=120;
    if (zone in [41..45]) then res:=135;
    if (zone in [46..50]) then res:=150;
    if (zone in [51..55]) then res:=165;
    if (zone in [56..60]) then res:=180;
    if (zone in [61..65]) then res:=195;
    if (zone in [66..70]) then res:=210;
    if (zone in [71..75]) then res:=225;
    if (zone in [76..80]) then res:=240;
    if (zone in [81..85]) then res:=255;
    if (zone in [86..90]) then res:=270;
    if (zone in [91..95]) then res:=285;
    if (zone in [96..100]) then res:=300;
    if (zone in [101..105]) then res:=315;
    if (zone in [106..110]) then res:=330;
    if (zone in [111..115]) then res:=345;
    if (zone in [116..120]) then res:=360;
    if (zone in [121..125]) then res:=375;
    if (zone in [126..130]) then res:=390;
    if (zone in [131..135]) then res:=405;
    if (zone in [136..140]) then res:=420;
    if (zone in [141..145]) then res:=435;
    if (zone in [146..150]) then res:=450;
    if (zone in [151..155]) then res:=465;
    if (zone in [156..160]) then res:=480;
    if (zone in [161..165]) then res:=495;
    if (zone in [166..170]) then res:=510;
    if (zone in [171..175]) then res:=525;
    if (zone in [176..180]) then res:=540;
    if (zone in [181..185]) then res:=555;
    if (zone in [186..190]) then res:=570;
    if (zone in [191..195]) then res:=585;
    if (zone in [196..200]) then res:=600;


    if zone>300 then res:=577;
  end;

  if ((ttype='UDMURTSODR')or(ttype='UDMURTSODR1')or(ttype='UDMURTSODR2')) then begin  // c 01.01.2022
    vflg:=true;
    if (zone in [0..10]) then res:=30;
    if (zone in [11..15]) then res:=34;
    if (zone in [16..20]) then res:=46;
    if (zone in [21..25]) then res:=60;
    if (zone in [26..30]) then res:=73;
    if (zone in [31..35]) then res:=85;
    if (zone in [36..40]) then res:=100;
    if (zone in [41..45]) then res:=113;
    if (zone in [46..50]) then res:=127;
    if (zone in [51..55]) then res:=140;
    if (zone in [56..60]) then res:=154;
    if (zone in [61..65]) then res:=170;
    if (zone in [66..70]) then res:=181;
    if (zone in [71..75]) then res:=194;
    if (zone in [76..80]) then res:=210;
    if (zone in [81..85]) then res:=220;
    if (zone in [86..90]) then res:=236;
    if (zone in [91..95]) then res:=250;
    if (zone in [96..100]) then res:=261;
    if (zone in [101..105]) then res:=275;
    if (zone in [106..110]) then res:=288;

    if (zone in [111..115]) then res:=303;
    if (zone in [116..120]) then res:=315;
    if (zone in [121..125]) then res:=330;
    if (zone in [126..130]) then res:=342;
    if (zone in [131..135]) then res:=358;
    if (zone in [136..140]) then res:=370;
    if (zone in [141..145]) then res:=385;
    if (zone in [146..150]) then res:=396;
    if (zone in [151..155]) then res:=411;
    if (zone in [156..160]) then res:=424;
    if (zone in [161..165]) then res:=438;
    if (zone in [166..170]) then res:=450;
    if (zone in [171..175]) then res:=465;
    if (zone in [176..180]) then res:=478;
    if (zone in [181..185]) then res:=492;
    if (zone in [186..190]) then res:=505;
    if (zone in [191..195]) then res:=520;
    if (zone in [196..200]) then res:=531;

    if zone>200 then res:=100000;
  end;

  if ttype='UDMURTPPK' then begin  // c 01.01.2022
    vflg:=true;
    if zone<6 then res:=48;
    if (zone in [6..15]) then res:=67;
    if (zone in [16..25]) then res:=87;
    if (zone in [26..35]) then res:=106;
    if (zone in [36..45]) then res:=125;
    if (zone in [46..55]) then res:=145;
    if (zone in [56..65]) then res:=165;
    if (zone in [66..75]) then res:=184;
    if (zone in [76..85]) then res:=203;   //    
    if (zone in [86..95]) then res:=213;
    if (zone in [96..105]) then res:=231;
    if (zone in [106..115]) then res:=249;
    if (zone in [116..125]) then res:=267;
    if (zone in [126..135]) then res:=285;
    if (zone in [136..145]) then res:=303;
    if (zone in [146..155]) then res:=321;
    if (zone in [156..165]) then res:=339;
    if (zone in [166..175]) then res:=357;
    if (zone in [176..185]) then res:=375;
    if (zone in [186..195]) then res:=393;
    if zone>195 then res:=411;
  end;

  if ((ttype='ORENBURG')or(ttype='ORENBURG1')or(ttype='ORENBURG2')) then begin   // c 10.04.2022
    vflg:=true;
    if zone<=1 then res:=19
               else res:=zone*19;
  end;


  if ((ttype='UFA')or(ttype='UFA1')or(ttype='UFA2')) then begin   // c 01.01.2020
    vflg:=true;
    if zone<=10 then res:=22
                else res:=zone*2.2;
//    res:=roundtoex(res,1);
    r4:=frac(res);
    r5:=0;
    val(floattostr(r4*10),r5,r6);
    if r6<>0 then r5:=0;
    if ((r4>0)and(r4<0.2)) then if r5<>2 then res:=res-r4;
    if ((r4>0.2)and(r4<0.4))  then if r5<>4 then res:=res-r4+0.2;
    if ((r4>0.4)and(r4<0.6))  then if r5<>6 then res:=res-r4+0.4;
    if ((r4>0.6)and(r4<0.8))  then if r5<>8 then res:=res-r4+0.6;
    if ((r4>0.8)and(r4<1))  then res:=res-r4+0.8;
  end;

  if (ttype='UFA_LAST') then begin   // c 01.05.2022
    vflg:=true;
    if zone<=10 then res:=25
                else res:=zone*2.5;
//    res:=roundtoex(res,1);
    r4:=frac(res);
    r5:=0;
    val(floattostr(r4*10),r5,r6);
    if r6<>0 then r5:=0;
    if ((r4>0)and(r4<0.2)) then if r5<>2 then res:=res-r4;
    if ((r4>0.2)and(r4<0.4))  then if r5<>4 then res:=res-r4+0.2;
    if ((r4>0.4)and(r4<0.6))  then if r5<>6 then res:=res-r4+0.4;
    if ((r4>0.6)and(r4<0.8))  then if r5<>8 then res:=res-r4+0.6;
    if ((r4>0.8)and(r4<1))  then res:=res-r4+0.8;
  end;


  if ttype='UFA_YUR' then begin   // c 01.05.2018
    vflg:=true;
    if zone<=10 then res:=21
                else res:=zone*2.1;
  end;

  if ttype='UFA_CITY' then begin  // c 01.01.2020
    vflg:=true;
    res:=22;
  end;

  if ttype='UFA_CITY_LAST' then begin  // c 01.05.2022
    vflg:=true;
    res:=30;
  end;

  if ((ttype='UFASDPPK')or(ttype='UFASDPPK1')or(ttype='UFASDPPK2')) then begin   // c 01.01.2020
    vflg:=true;
    if zone<=10 then res:=22
                else res:=zone*2.2;
  end;

  if ttype='BRYANSK' then begin //  01.01.2019
    vflg:=true;
    if zone<=1 then res:=22.2
               else res:=zone*22.2;
    res:=trunc(res*10)/10;
  end;

  if ttype='KALUGA' then begin //  16.02.2017
    vflg:=true;
    if zone<=1 then res:=25.6
               else res:=zone*25.6;
  end;

  if ttype='KURSK' then begin //  01.01.2021
    vflg:=true;
    if zone<=1 then res:=2.13
               else res:=zone*2.13;
  end;

  if ttype='KURSK_CH' then begin     //c 01.01.2022
    vflg:=true;
    if zone<=1 then res:=2.22
               else res:=zone*2.22;
  end;

  if ttype='OREL' then begin //  01.01.2020
    vflg:=true;
    res:=zone*2.3;
    res:=trunc(res*10)/10;
  end;

  if ttype='SMOLENSK' then begin //  01.01.2020
    vflg:=true;
    if zone<=10 then res:=22.2
               else begin
                 setroundmode(rmNearest);
                 res:=round(zone*22.2)/10;
               end;
  end;

  if ttype='TULA' then begin    //  01.06.2015
    vflg:=true;
    if zone<=1 then res:=28
               else res:=zone*28;
  end;

  if (ttype='NOVGOROD') or (ttype='NOVGOROD1') then begin  //  01.01.2017
    vflg:=true;
    setroundmode(rmDown);
    res:=round(zone*3.5);
  end;

  if ttype='PSKOV_MTPPK' then begin    //  01.01.2022
    vflg:=true;
    if zone<=10 then res:=32
                else begin
                  setroundmode(rmDown);
                  res:=round(zone*32.0/10);
                end;
  end;


  if ((ttype='TVER_KM')or(ttype='TVER_KM1')) then begin    //  01.02.2022
    vflg:=true;
      r4:=zone*2.74;

//    res:=roundn1(res);
    setroundmode(rmNearest);
    r4:=roundn12(r4);
    res:=r4;
  end;

  if ttype='TVERCPPK' then begin    //  01.01.2018
    vflg:=true;
    if zone<=1 then res:=26
               else res:=zone*26;
  end;

  if ttype='TVER_KM_CPPK' then begin    //  01.08.2019
    vflg:=true;
    if zone<=10 then res:=27.0
               else begin
                 setroundmode(rmDown);
                 res:=round(zone*27.0)/10;
               end;
  end;

  if ttype='MSK_GOROD' then begin    //  01.01.2019
    vflg:=true;
    res:=36;
  end;

  if ttype='MSK' then begin    //  01.01.2019
    vflg:=true;
    if zone<=1 then res:=23
               else res:=zone*23;
  end;

  if ttype='MSK_KM' then begin    //  01.01.2022
    vflg:=true;
    if zone<1 then res:=27
              else begin
                x:=zone div 10;
                y:=zone mod 10;
                if y>0 then x:=x+1;
                res:=x*27;
              end;
  end;

  if ttype='VLADIMIR_KM' then begin      //  01.01.2020
    vflg:=true;
    if zone<1 then res:=29      //  <----
              else begin
                x:=zone div 10;
                y:=zone mod 10;
                if y>0 then x:=x+1;
                res:=x*29;      //  <----
              end;
  end;

  if ttype='VLADIMIR_ZONE' then begin      //  01.01.2019
    vflg:=true;
    if zone<=1 then res:=28
               else res:=zone*28;
  end;

  if ttype='VLADIMIR_VVPPK' then begin     //c 01.01.2022
    vflg:=true;
    if zone in [0..4] then res:=17;
    if zone in [5..10] then res:=32;
    if zone in [11..20] then res:=62;
    if zone in [21..30] then res:=90;
    if zone in [31..40] then res:=118;
    if zone in [41..50] then res:=146;
    if zone in [51..60] then res:=174;
    if zone in [61..70] then res:=202;
    if zone in [71..80] then res:=230;
    if zone in [81..90] then res:=258;
    if zone in [91..100] then res:=286;
    if zone in [101..110] then res:=314;
    if zone in [111..120] then res:=342;
    if zone in [121..130] then res:=370;
    if zone in [131..140] then res:=394;
    if zone in [141..150] then res:=409;
    if zone in [151..160] then res:=424;
    if zone in [161..170] then res:=438;
    if zone in [171..200] then res:=452;


  end;

  if ((ttype='VLADIMIR_SPPK')or(ttype='VLADIMIR_SPPK1')or(ttype='VLADIMIR_SPPK2')) then begin      //  01.01.2022
    vflg:=true;
    if zone<1 then res:=32.4      //  <----
              else begin
                x:=zone div 10;
                y:=zone mod 10;
                if y>0 then x:=x+1;
                res:=x*32.4;      //  <----
              end;
  end;

  if ((ttype='KIROV')or(ttype='KIROV1')or(ttype='KIROV2')or(ttype='KIROV3')) then begin     //c 01.01.2022
    vflg:=true;
    if zone<=1 then res:=28;
    if zone=2 then res:=56;
    if zone=3 then res:=83;
    if zone=4 then res:=110;
    if zone=5 then res:=135;
    if zone=6 then res:=160;
    if zone=7 then res:=185;
    if zone=8 then res:=210;
    if zone=9 then res:=234;
    if zone=10 then res:=257;
    if zone=11 then res:=279;
    if zone=12 then res:=301;
    if zone=13 then res:=323;
    if zone=14 then res:=345;
    if zone=15 then res:=367;
    if zone=16 then res:=389;
    if zone=17 then res:=409;
    if zone=18 then res:=429;
    if zone=19 then res:=447;
    if zone=20 then res:=465;
    if zone>20 then showmessage('error - kirov z>20');
  end;

  if ttype='KIROV_GOROD' then begin    //  01.02.2022
    vflg:=true;
    res:=28;
  end;

  if ttype='YAROSLAVL' then begin      //  01.01.2022
    vflg:=true;
    if zone<=1 then res1:=3.56
               else res1:=zone*3.56;
   // SetRoundMode(rmNearest);
   // res:=RoundToEx(res1,0);
   res := res1;
  end;

  if ((ttype='KOSTROMA')or(ttype='KOSTROMA1')or(ttype='KOSTROMA2')) then begin      //  01.01.2022
    vflg:=true;
    if zone<=1 then res1:=3.2
               else res1:=zone*3.2;
    SetRoundMode(rmNearest);
    res:=RoundToEx(res1,0);
  end;

  if ((ttype='IVANOVO')or(ttype='IVANOVO1')or(ttype='IVANOVO2')) then begin      //  01.01.2021
    vflg:=true;
    if zone<=1 then res:=32
               else res:=zone*32;
  end;

  if ttype='IVANOVO_GOROD' then begin    //c 01.07.2021
    vflg:=true;
    res:=25;
  end;

  if ((ttype='VOLOGDA')or(ttype='VOLOGDA1')or(ttype='VOLOGDA2')) then begin      //  01.01.2022
    vflg:=true;
    if zone<=1 then res1:=3.28
               else res1:=zone*3.28;
    r4:=res1*10;
    r4:=trunc(r4)/10;
    res:=r4;
  end;

  if ((ttype='ARKHANGELSK')or(ttype='ARKHANGELSK1')or(ttype='ARKHANGELSK2')or(ttype='ARKHANGELSK3')) then begin     //c 01.01.2021
    vflg:=true;
    if zone<=1 then res:=32;
    if zone=2 then res:=64;
    if zone=3 then res:=96;
    if zone=4 then res:=128;
    if zone=5 then res:=160;
    if zone=6 then res:=185;
    if zone=7 then res:=210;
    if zone=8 then res:=235;
    if zone=9 then res:=260;
    if zone=10 then res:=285;
    if zone=11 then res:=308;
    if zone=12 then res:=331;
    if zone=13 then res:=354;
    if zone=14 then res:=377;
    if zone=15 then res:=400;
    if zone=16 then res:=423;
    if zone=17 then res:=446;
    if zone=18 then res:=469;
    if zone>18 then showmessage('error - arkhangelsk z>18');
  end;

 if (ttype='ARKHANGELSKSEV') then begin     //c 01.01.2021
    vflg:=true;
    res:=zone*23;
  end;



  if ((ttype='KOMI')or(ttype='KOMI1')or(ttype='KOMI2')) then begin   //c 01.01.2022
    vflg:=true;
    if zone<6 then res:=29;
    if (zone in [6..15]) then res:=58;
    if (zone in [16..25]) then res:=87;
    if (zone in [26..35]) then res:=116;
    if (zone in [36..45]) then res:=145;
    if (zone in [46..55]) then res:=174;
    if (zone in [56..65]) then res:=203;
    if (zone in [66..75]) then res:=232;
    if (zone in [76..85]) then res:=261;
    if (zone in [86..95]) then res:=290;
    if (zone in [96..105]) then res:=319;
    if (zone in [106..115]) then res:=348;
    if (zone in [116..125]) then res:=377;
    if (zone in [126..135]) then res:=406;
    if (zone in [136..145]) then res:=435;
    if (zone in [146..155]) then res:=464;
    if (zone in [156..165]) then res:=493;
    if (zone in [166..175]) then res:=522;
    if (zone in [176..185]) then res:=551;
    if (zone in [186..195]) then res:=580;
    if zone>195 then showmessage('error - komi z>185');
  end;

  if ttype='BELARUS_GR' then begin      //  11.04.2022
    vflg:=true;
    res:=1.44;
  end;

  if ((ttype='BELARUS')or(ttype='BELARUS1')or(ttype='BELARUS2')or(ttype='BELARUS3')) then begin   //c 11.04.2022
    vflg:=true;
    if zone<=5 then res:=0.29
               else begin
                 res:=((zone-5)*0.029)+0.29;
               end;
  end;

  if ttype='BELARUS_CITY' then begin      //  11.04.2022
    vflg:=true;
    res:=0;
    if zone<=0 then res:=1.44;
    if zone=1 then res:=1.88;
    if zone=109 then res:=2.85; //-
    if zone=108 then res:=1.65; //-
  end;

  if ((ttype='BELARUS_1K')or(ttype='BELARUS1_1K')or(ttype='BELARUS2_1K')or(ttype='BELARUS3_1K')) then begin   //c 11.04.2022 -   1 
    vflg:=true;
     if zone<=5 then res:=0.29
               else begin
                 res:=((zone-5)*0.029)+0.29;
               end;
     res := res*12;
  end;

  if ((ttype='BELARUS_1M')or(ttype='BELARUS1_1M')or(ttype='BELARUS2_1M')or(ttype='BELARUS3_1M')) then begin   //c 11.04.2022 -   1 
    vflg:=true;
     if zone<=5 then res:=0.24
               else begin
                 res:=((zone-5)*0.024)+0.24;
               end;
     res := res*36;
  end;

  if ((ttype='BELARUS_1MR')or(ttype='BELARUS1_1MR')or(ttype='BELARUS2_1MR')or(ttype='BELARUS3_1MR')) then begin   //c 13.08.2021 -   1   
    vflg:=true;
     if zone<=5 then res:=0.29
               else begin
                 res:=((zone-5)*0.029)+0.29;
               end;
     res := res*30;
  end;

  if ((ttype='BELARUS_VYHDN')or(ttype='BELARUS1_VYHDN')or(ttype='BELARUS2_VYHDN')or(ttype='BELARUS3_VYHDN')) then begin   //c 11.04.2022 -     1 
    vflg:=true;
     if zone<=5 then res:=0.29
               else begin
                 res:=((zone-5)*0.029)+0.29;
               end;
     res := res*16;
  end;

  if ttype='BELARUS_CITY_G1K' then begin      //  11.04.2022 -     1 
    vflg:=true;
    res:=0;
    if zone<=0 then res:=1.44*16;
    if zone=1 then res:=1.88*16;
    if zone=109 then res:=25000*16; //-
    if zone=108 then res:=14600*16; //-
   // res:=res/10000; // 
  end;

  if ttype='BELARUS_CITY_G1M' then begin      //  11.04.2022 -     1 
    vflg:=true;
    res:=0;
    if zone<=0 then res:=1.44*44;
    if zone=1 then res:=1.88*44;
    if zone=109 then res:=1*44; //-
    if zone=108 then res:=1*44; //-
    // res:=res/10000; // 
  end;

  if ttype='BELARUS_CITY_GS3' then begin      //  11.04.2022 -    -  3 
    vflg:=true;
    res:=0;
    if zone<=0 then res:=1.44*7;
    if zone=1 then res:=1.88*7;
    if zone=109 then res:=1*8; //-
    if zone=108 then res:=1*8; //-
   // res:=res/10000; // 
  end;

  if ttype='BELARUS_CITY_GS5' then begin      //  11.04.2022-    -  5 
    vflg:=true;
    res:=0;
    if zone<=0 then res:=1.44*9;
    if zone=1 then res:=1.88*9;
    if zone=109 then res:=1*10; //-
    if zone=108 then res:=1*10; //-
   // res:=res/10000; // 
  end;

  if ttype='BELARUS_CITY_GS10' then begin      //  11.04.2021 -    -  10 
    vflg:=true;
    res:=0;
    if zone<=0 then res:=1.44*15;
    if zone=1 then res:=1.88*15;
    if zone=109 then res:=1*16; //-
    if zone=108 then res:=1*16; //-
//    res:=res/10000; // 
  end;

  if ttype='BELARUS_CITY_GS30' then begin      //  11.04.2021 -    -  30 
    vflg:=true;
    res:=0;
    if zone<=0 then res:=1.44*41;
    if zone=1 then res:=1.88*41;
    if zone=109 then res:=1*44; //-
    if zone=108 then res:=1*44; //-
    // res:=res/10000; // 
  end;

  if ttype='KALININGRAD' then begin   //c 01.01.2022
    vflg:=true;
    SetRoundMode(rmNearest);
    if zone<=10 then r4:=25
               else begin                                //  
                 r4:=roundToEx(((zone-10)*1.89)+25,0);   //      
               end;
    res:=r4;
  end;

  if ttype='KALININGRAD_LAST' then begin   //c 01.01.2022
    vflg:=true;
    SetRoundMode(rmNearest);
    if zone<=10 then r4:=25
               else begin                                 //  
                 r4:=RoundToEx(((zone-10)*2.3)+25,0);     //      
               end;
    res:=r4;
  end;

  if ((ttype='VORONEZH_KM')or(ttype='VORONEZH_KM1')or(ttype='VORONEZH_KM2')or(ttype='VORONEZH_KM3')) then begin   //c 01.01.2022
    vflg:=true;
    if zone<=10 then res:=23.8
               else res:=trunc(zone*2.38);
  end;

  if ttype='VORONEZH_GOROD' then begin  //c 01.01.2022
    vflg:=true;
    res:=23.8;
  end;

  if ttype='BELGOROD_KM' then begin     //c 01.01.2022
    vflg:=true;
    if zone<1 then res:=19.98
              else begin
                x:=zone div 10;
                y:=zone mod 10;
                if y>0 then x:=x+1;
                res:=x*19.98;
              end;
  end;

  if ttype='BELGOROD' then begin
    showmessage(' : ');
  end;

  if ttype='LIPETSK' then begin
    showmessage(' : ');
  end;

  if ttype='LIPETSK_KM' then begin      //c 01.01.2022
    vflg:=true;
    if zone<1 then res:=20.85
              else begin
                x:=zone div 10;
                y:=zone mod 10;
                if y>0 then x:=x+1;
                res:=x*20.85;
              end;
  end;

  if ttype='CHELYABINSK' then begin  //c 01.01.2022
    vflg:=true;
    if zone<=1 then res:=2.91
               else res:=zone*2.91;
  end;

  if ((ttype='KURGAN')or(ttype='KURGAN1')or(ttype='KURGAN2')) then begin  //c 01.04.2022
    vflg:=true;
    if zone<=1 then res:=2.7
               else res:=zone*2.7;
  end;

  if ttype='PENZA' then begin        
    showmessage(' : ');
  end;

  if ttype='PENZA_KM' then begin        //c 01.01.2022
    vflg:=true;
    if zone<=1 then res:=2.46
               else res:=zone*2.46;
    res := SimpleRoundTo(res - 0.01, -1);
 //   r4:=frac(res);
 //   r5:=0;
 //   val(floattostr(r4*10),r5,r6);
 //   if r6<>0 then r5:=0;
 //   if ((r4>0)and(r4<0.2)) then if r5<>2 then res:=res-r4;
 //   if ((r4>0.2)and(r4<0.4))  then if r5<>4 then res:=res-r4+0.2;
  //  if ((r4>0.4)and(r4<0.6))  then if r5<>6 then res:=res-r4+0.4;
//    if ((r4>0.6)and(r4<0.8))  then if r5<>8 then res:=res-r4+0.6;
 //   if ((r4>0.8)and(r4<1))  then res:=res-r4+0.8;
  end;

  if ttype='PENZA_SARPPK' then begin        //c 01.01.2020
    vflg:=true;
    if zone<=1 then res:=2.36
               else res:=zone*2.36;
  end;

  if ttype='MORDOVIA' then begin     //c 01.07.2022
    vflg:=true;
    if zone<=1 then res:=24.6
               else res:=zone*24.6;
  end;

  if ttype='MORDOVIA_CPPK' then begin     //c 01.01.2018   -
    vflg:=true;
    if zone<=1 then res:=9
               else res:=zone*9;
  end;

  if ttype='RYAZAN' then begin
    showmessage('error - ryazan!');
  end;

  if ttype='RYAZAN_KM' then begin       //c 01.01.2019
    vflg:=true;
    if zone<1 then res:=24
              else begin
                x:=zone div 10;
                y:=zone mod 10;
                if y>0 then x:=x+1;
                res:=x*24;
              end;
  end;

  if ((ttype='TAMBOV')or(ttype='TAMBOV1')) then begin
    showmessage('error - tambov!');
  end;

  if ((ttype='TAMBOV_KM')or(ttype='TAMBOV1_KM')or(ttype='TAMBOV_KM1')or(ttype='TAMBOV_KM2')) then begin        //c 01.02.2022
    vflg:=true;
    if zone<=10 then res:=21.07;
    if ((zone>10)and(zone<51)) then begin
      res:=zone*2.107;
      setroundmode(rmNearest);
      res:=roundtoex(res,-1);
    end;
    if zone>50 then begin
       x:=zone div 10;
       y:=zone mod 10;
       if y>0 then x:=x+1;
       res:=x*21.07;
    end;
  end;

 { if ((ttype='TAMBOV_KM')or(ttype='TAMBOV1_KM')) then begin        //c 06.12.2018
    vflg:=true;
    if zone<=10 then res:=18.2;
    if ((zone>10)and(zone<51)) then begin
      res:=zone*1.82;
      setroundmode(rmNearest);
      res:=roundtoex(res,-1);
    end;
    if zone>50 then begin
       x:=zone div 10;
       y:=zone mod 10;
       if y>0 then x:=x+1;
       res:=x*18.2;
    end;
  end; }

  if ttype='SARATOV_GOROD' then begin    //c 01.01.2015
    vflg:=true;
    res:=23;
  end;

  if ((ttype='SARATOV')or(ttype='SARATOV1')) then begin    //c 01.01.2015
    vflg:=true;
    if zone<=1 then res:=19
               else res:=zone*19;
  end;

  if ((ttype='KIEV')or(ttype='KIIV')) then begin  //  01.06.2016
    vflg:=true;
    if zone in [0..5] then res:=8;
    if zone in [6..10] then res:=8;
    if zone in [11..20] then res:=8;
    if zone in [21..30] then res:=8;
    if zone in [31..40] then res:=9;
    if zone in [41..50] then res:=9;
    if zone in [51..60] then res:=9.99;
    if zone in [61..70] then res:=9.99;
    if zone in [71..80] then res:=12;
    if zone in [81..90] then res:=12;
    if zone in [91..100] then res:=12;
    if zone in [101..110] then res:=14;
    if zone in [111..120] then res:=14;
    if zone in [121..130] then res:=14;
    if zone in [131..140] then res:=16;
    if zone in [141..150] then res:=16;
    if zone in [151..160] then res:=18;
    if zone in [161..170] then res:=18;
    if zone in [171..180] then res:=19;
    if zone in [181..190] then res:=19;
    if zone in [191..200] then res:=20;
    if zone in [201..230] then res:=20;
    if zone>230           then res:=20;
  end;

  if ((ttype='ZHITOMIR')or(ttype='ZHITOMYR')) then begin  //  01.06.2016
    ttype:='SWRW2';
  end;

  if ((ttype='VINNYTSA')or(ttype='VINNITSA')) then begin  //  01.06.2016
    ttype:='SWRW2';
  end;

  if ((ttype='SWRW_CHERNIGOV')or(ttype='SWRW_CHERNIGIV')) then begin  //  01.06.2016
    ttype:='SWRW2';
  end;

  if ((ttype='SWRW_SUMY')or(ttype='SWRW_SUMI')) then begin  //  01.06.2016
    ttype:='SWRW2';
  end;

  if ttype='SWRW2' then begin  //  01.06.2016
    vflg:=true;
    if zone in [0..5] then res:=9.99;
    if zone in [6..10] then res:=9.99;
    if zone in [11..20] then res:=9.99;
    if zone in [21..30] then res:=9.99;
    if zone in [31..40] then res:=12;
    if zone in [41..50] then res:=12;
    if zone in [51..60] then res:=14;
    if zone in [61..70] then res:=14;
    if zone in [71..80] then res:=16;
    if zone in [81..90] then res:=16;
    if zone in [91..100] then res:=16;
    if zone in [101..110] then res:=18;
    if zone in [111..120] then res:=18;
    if zone in [121..130] then res:=18;
    if zone in [131..140] then res:=20;
    if zone in [141..150] then res:=20;
    if zone in [151..160] then res:=22;
    if zone in [161..170] then res:=22;
    if zone in [171..180] then res:=25;
    if zone in [181..190] then res:=25;
    if zone in [191..200] then res:=25;
    if zone in [201..230] then res:=25;
    if zone>230           then res:=25;
  end;

  if ttype='UZHN' then begin  //  01.06.2016
    vflg:=true;
    if zone in [0..5] then res:=3.50;
    if zone in [6..10] then res:=4.47;
    if zone in [11..20] then res:=4.95;
    if zone in [21..30] then res:=5.77;
    if zone in [31..40] then res:=6.15;
    if zone in [41..50] then res:=6.48;
    if zone in [51..60] then res:=7.05;
    if zone in [61..70] then res:=7.70;
    if zone in [71..80] then res:=8.45;
    if zone in [81..90] then res:=9.00;
    if zone in [91..100] then res:=9.60;
    if zone in [101..110] then res:=10.25;
    if zone in [111..120] then res:=10.88;
    if zone in [121..130] then res:=11.86;
    if zone in [131..140] then res:=12.50;
    if zone in [141..150] then res:=12.80;
    if zone in [151..160] then res:=13.45;
    if zone in [161..170] then res:=14.10;
    if zone in [171..180] then res:=14.60;
    if zone in [181..190] then res:=15.28;
    if zone in [191..200] then res:=15.70;
    if zone in [201..250] then res:=16.70;
    if ((zone>=251)and(zone<=300)) then res:=17.30;
    if zone>300           then res:=18.45;
  end;

  if ttype='UZHN_SUMCH' then begin  //  26.01.2018
    vflg:=true;
    if zone in [0..5] then res:=5;
    if zone in [6..10] then res:=6;
    if zone in [11..20] then res:=7.10;
    if zone in [21..30] then res:=8.25;
    if zone in [31..40] then res:=8.85;
    if zone in [41..50] then res:=9.25;
    if zone in [51..60] then res:=10.10;
    if zone in [61..70] then res:=11;
    if zone in [71..80] then res:=12.10;
    if zone in [81..90] then res:=12.90;
    if zone in [91..100] then res:=13.70;
    if zone in [101..110] then res:=14.65;
    if zone in [111..120] then res:=15.60;
    if zone in [121..130] then res:=17;
    if zone in [131..140] then res:=17.85;
    if zone in [141..150] then res:=18.30;
    if zone in [151..160] then res:=19.21;
    if zone in [161..170] then res:=20.15;
    if zone in [171..180] then res:=20.85;
    if zone in [181..190] then res:=21.85;
    if zone in [191..200] then res:=22.60;
    if zone in [201..250] then res:=23.85;
    if ((zone>=251)and(zone<=300)) then res:=24.85;
    if zone>300           then res:=26.51;
  end;

  if ttype='KRLIMAN' then begin  //  26.04.2018
    vflg:=true;
    if zone in [0..5] then res:=7.5;
    if zone in [6..10] then res:=7.5;
    if zone in [11..20] then res:=7.5;
    if zone in [21..30] then res:=9;
    if zone in [31..40] then res:=9;
    if zone in [41..50] then res:=12;
    if zone in [51..60] then res:=12;
    if zone in [61..70] then res:=15;
    if zone in [71..80] then res:=15;
    if zone in [81..90] then res:=18;
    if zone in [91..100] then res:=18;
    if zone in [101..110] then res:=18;
    if zone in [111..120] then res:=20;
    if zone in [121..130] then res:=20;
    if zone in [131..140] then res:=30;
    if zone in [141..150] then res:=30;
    if zone in [151..160] then res:=40;
    if zone in [161..170] then res:=40;
    if zone in [171..180] then res:=50;
    if zone in [181..190] then res:=50;
    if zone in [191..200] then res:=50;
    if zone in [201..250] then res:=60;
    if zone>250           then res:=60;
  end;

  if ((ttype='PRIDN')or(ttype='PRIDN1')) then begin  //  04.10.2018
    vflg:=true;
    if zone in [0..5] then res:=8.79;
    if zone in [6..10] then res:=8.79;
    if zone in [11..20] then res:=8.79;
    if zone in [21..30] then res:=8.79;
    if zone in [31..40] then res:=14.66;
    if zone in [41..50] then res:=17.58;
    if zone in [51..60] then res:=19.54;
    if zone in [61..70] then res:=25.40;
    if zone in [71..80] then res:=29.31;
    if zone in [81..90] then res:=32.24;
    if zone in [91..100] then res:=35.17;
    if zone in [101..110] then res:=37.13;
    if zone in [111..120] then res:=40.05;
    if zone in [121..130] then res:=43.97;
    if zone in [131..140] then res:=50.81;
    if zone in [141..150] then res:=54.71;
    if zone in [151..160] then res:=60.57;
    if zone in [161..170] then res:=63.50;
    if zone in [171..180] then res:=64.49;
    if zone in [181..190] then res:=70.34;
    if zone>190        then res:=70.34;
  end;

  if ((ttype='ODZNAMSHEV')or(ttype='ODZNAMSHEV1')) then begin  //  01.07.2017
    vflg:=true;
    if zone in [0..5] then res:=8.60;
    if zone in [6..10] then res:=8.60;
    if zone in [11..20] then res:=9.20;
    if zone in [21..30] then res:=9.20;
    if zone in [31..40] then res:=13.80;
    if zone in [41..50] then res:=16.10;
    if zone in [51..60] then res:=16.10;
    if zone in [61..70] then res:=18.40;
    if zone in [71..80] then res:=18.40;
    if zone in [81..90] then res:=23.00;
    if zone in [91..100] then res:=23.00;
    if zone in [101..110] then res:=25.85;
    if zone in [111..120] then res:=25.85;
    if zone in [121..130] then res:=25.85;
    if zone in [131..140] then res:=29.30;
    if zone in [141..150] then res:=29.30;
    if zone in [151..160] then res:=29.30;
    if zone in [161..170] then res:=34.50;
    if zone in [171..180] then res:=34.50;
    if ((zone>180)and(zone<=260)) then res:=40.20;
    if zone>260        then res:=43.60;
  end;

  if ((ttype='ODKHER')or(ttype='ODKHER1')) then begin  //  01.09.2016
    vflg:=true;
    if zone in [0..5] then res:=8.60;
    if zone in [6..10] then res:=8.60;
    if zone in [11..20] then res:=9.20;
    if zone in [21..30] then res:=9.20;
    if zone in [31..40] then res:=13.80;
    if zone in [41..50] then res:=16.10;
    if zone in [51..60] then res:=16.10;
    if zone in [61..70] then res:=18.40;
    if zone in [71..80] then res:=18.40;
    if zone in [81..90] then res:=23.00;
    if zone in [91..100] then res:=23.00;
    if zone in [101..110] then res:=25.85;
    if zone in [111..120] then res:=25.85;
    if zone in [121..130] then res:=25.85;
    if zone in [131..140] then res:=29.30;
    if zone in [141..150] then res:=29.30;
    if zone in [151..160] then res:=29.30;
    if zone in [161..170] then res:=34.50;
    if zone in [171..180] then res:=34.50;
    if ((zone>180)and(zone<=260)) then res:=40.20;
    if zone>260        then res:=43.60;
  end;

  if ((ttype='ODODZ')or(ttype='ODODZ1')) then begin  //  29.12.2017
    vflg:=true;
    if zone in [0..5] then res:=8.60;
    if zone in [6..10] then res:=8.60;
    if zone in [11..20] then res:=9.20;
    if zone in [21..30] then res:=9.20;
    if zone in [31..40] then res:=13.80;
    if zone in [41..50] then res:=16.10;
    if zone in [51..60] then res:=16.10;
    if zone in [61..70] then res:=18.40;
    if zone in [71..80] then res:=18.40;
    if zone in [81..90] then res:=23.00;
    if zone in [91..100] then res:=23.00;
    if zone in [101..110] then res:=25.85;
    if zone in [111..120] then res:=25.85;
    if zone in [121..130] then res:=25.85;
    if zone in [131..140] then res:=29.30;
    if zone in [141..150] then res:=29.30;
    if zone in [151..160] then res:=29.30;
    if zone in [161..170] then res:=34.50;
    if zone in [171..180] then res:=34.50;
    if ((zone>180)and(zone<=260)) then res:=40.20;
    if zone>260        then res:=43.60;
  end;

  if ((ttype='LVIV')or(ttype='LVIV1')) then begin  //  15.05.2018
    vflg:=true;
    if zone in [0..5] then res:=8.00;
    if zone in [6..10] then res:=8.00;
    if zone in [11..20] then res:=11.00;
    if zone in [21..30] then res:=12.00;
    if zone in [31..40] then res:=16.00;
    if zone in [41..50] then res:=16.00;
    if zone in [51..60] then res:=20.00;
    if zone in [61..70] then res:=20.00;
    if zone in [71..80] then res:=25.00;
    if zone in [81..90] then res:=25.00;
    if zone in [91..100] then res:=25.00;
    if zone in [101..110] then res:=30.50;
    if zone in [111..120] then res:=30.50;
    if zone in [121..130] then res:=30.50;
    if zone in [131..140] then res:=35.50;
    if zone in [141..150] then res:=35.50;
    if zone in [151..160] then res:=35.50;
    if zone in [161..170] then res:=40.00;
    if zone in [171..180] then res:=40.00;
    if zone in [181..190] then res:=40.00;
    if zone in [191..200] then res:=45.00;
    if zone in [201..210] then res:=45.00;
    if zone in [211..220] then res:=45.00;
    if zone>220        then res:=45.00;
  end;

  if ((ttype='ROVNO')or(ttype='ROVNO1')) then begin  //  15.05.2018
    vflg:=true;
    if zone in [0..5] then res:=8.00;
    if zone in [6..10] then res:=8.00;
    if zone in [11..20] then res:=11.00;
    if zone in [21..30] then res:=12.00;
    if zone in [31..40] then res:=16.00;
    if zone in [41..50] then res:=16.00;
    if zone in [51..60] then res:=18.00;
    if zone in [61..70] then res:=18.00;
    if zone in [71..80] then res:=20.00;
    if zone in [81..90] then res:=20.00;
    if zone in [91..100] then res:=20.00;
    if zone in [101..110] then res:=25.00;
    if zone in [111..120] then res:=25.00;
    if zone in [121..130] then res:=25.00;
    if zone in [131..140] then res:=30.50;
    if zone in [141..150] then res:=30.50;
    if zone in [151..160] then res:=30.50;
    if zone in [161..170] then res:=35.50;
    if zone in [171..180] then res:=35.50;
    if zone in [181..190] then res:=35.50;
    if zone in [191..200] then res:=40.00;
    if zone in [201..210] then res:=40.00;
    if zone in [211..220] then res:=40.00;
    if zone>220        then res:=40.00;
  end;

  if ((ttype='NOVOSIBIRSK')or(ttype='NOVOSIBIRSK2')) then begin   //c 01.01.2022
    vflg:=true;
    case zone of
      0: res:=27;
      1: res:=27;
      2: res:=27;
      3: res:=40;
      4: res:=60;
      5: res:=70;
      6: res:=79;
      7: res:=90;
      8: res:=94;
      9: res:=98;
      10: res:=105;
      11: res:=110;
      12: res:=114;
      13: res:=117;
      14: res:=124;
      15: res:=135;
      16: res:=149;
      17: res:=156;
      18: res:=171;
      19: res:=179;
      20: res:=187;
      21: res:=203;
      22: res:=214;
      23: res:=216;
      24: res:=222;
      25: res:=226;
      26: res:=230;
      27: res:=234;
      28: res:=238;
      29: res:=240;
      30: res:=242;
      31: res:=260;


    end;
  end;

  if ttype='NOVOSIBIRSK_GOROD' then begin    //c 01.01.2022
    vflg:=true;
    res:=27;
  end;

  if ((ttype='OMSK')or(ttype='OMSK1')or(ttype='OMSK2')) then begin   //c 11.01.2022
    vflg:=true;
    case zone of
      0: res:=19;
      1: res:=19;
      2: res:=25;
      3: res:=35;
      4: res:=48;
      5: res:=60;
      6: res:=73;
      7: res:=85;
      8: res:=95;
      9: res:=112;
      10: res:=125;
      11: res:=135;
      12: res:=145;
      13: res:=156;
      14: res:=169;
      15: res:=179;
      16: res:=189;
      17: res:=200;
      18: res:=202;
      19: res:=212;
      20: res:=222;
    end;
  end;

  if ttype='OMSK_KM' then begin   //c 11.01.2017 -   
    vflg:=true;
{    if zone in [0..5] then res:=18;
    if zone in [6..15] then res:=24;
    if zone in [16..25] then res:=34;
    if zone in [26..35] then res:=46;
    if zone in [36..45] then res:=58;
    if zone in [46..55] then res:=70;
    if zone in [56..65] then res:=82;
 }  res:=zone;
  end;


  if ((ttype='TATAR')or(ttype='TATAR1')or(ttype='TATAR2')) then begin   // c 01.01.2022
    vflg:=true;
    case zone of
      0: res:=30;
      1: res:=30;
      2: res:=30;
      3: res:=50;
      4: res:=70;
      5: res:=88;
      6: res:=106;
      7: res:=124;
      8: res:=142;
      9: res:=158;
      10: res:=174;
      11: res:=190;
      12: res:=206;
      13: res:=222;
      14: res:=236;
      15: res:=250;
      16: res:=264;
      17: res:=278;
      18: res:=292;
      19: res:=306;
      20: res:=320;
      21: res:=334;

    end; //    
  end;

  if ((ttype='TATAR_KM')) then begin  //  31.12.2015
    vflg:=true;
    if zone in [0..10] then res:=24;
    if zone in [11..20] then res:=24;
    if zone in [21..30] then res:=42;
    if zone in [31..40] then res:=60;
    if zone in [41..50] then res:=76;
    if zone in [51..60] then res:=92;
    if zone in [61..70] then res:=108;
    if zone in [71..80] then res:=124;
    if zone in [81..90] then res:=138;
    if zone in [91..100] then res:=152;
    if zone in [101..110] then res:=166;
    if zone in [111..120] then res:=180;
    if zone in [121..130] then res:=194;
    if zone in [131..140] then res:=206;
    if zone in [141..150] then res:=218;
    if zone in [151..160] then res:=230;
    if zone in [161..170] then res:=242;
    if zone in [171..180] then res:=254;
    if zone in [181..190] then res:=266;
    if zone in [191..200] then res:=278;
  end;  //    


  if ttype='MARII' then begin      // c 01.01.2021
    vflg:=true;
    case zone of
      0: res:=32;
      1: res:=32;
      2: res:=64;
      3: res:=96;
      4: res:=128;
      5: res:=160;
      6: res:=179;
      7: res:=198;
      8: res:=217;
      9: res:=236;
      10: res:=243;
      11: res:=276;
      12: res:=298;
      13: res:=320;
      14: res:=342;
      15: res:=375;
      16: res:=408;
      17: res:=441;
      18: res:=474;
      19: res:=507;
      20: res:=540;
    end;
  end;

  if ttype='KIROVSDPPK' then begin  // c 01.01.2022
    vflg:=true;
    case zone of
      0: res:=28;
      1: res:=28;
      2: res:=56;
      3: res:=83;
      4: res:=110;
      5: res:=137;
      6: res:=164;
      7: res:=191;
      8: res:=218;
      9: res:=245;
      10: res:=272;
    end;
  end;

  if ((ttype='CHUVASH')or(ttype='CHUVASH1')or(ttype='CHUVASH2')) then begin   // c 01.01.2022
    vflg:=true;
    if zone<=1 then res:=3.45
               else res:=zone*3.45;
  end;

  if ((ttype='AMURDVZD')or(ttype='AMURDVZD2')) then begin  //  01.01.2017
    vflg:=true;
    if zone in [0..10] then res:=95;
    if zone in [11..20] then res:=149;
    if zone in [21..30] then res:=210;
    if zone in [31..40] then res:=285;
    if zone in [41..50] then res:=334;
    if zone in [51..60] then res:=380;
    if zone in [61..70] then res:=434;
    if zone in [71..80] then res:=475;
    if zone in [81..90] then res:=529;
    if zone in [91..100] then res:=585;
    if zone in [101..110] then res:=639;
    if zone in [111..120] then res:=692;
    if zone in [121..130] then res:=741;
    if zone in [131..140] then res:=795;
    if zone in [141..150] then res:=841;
    if zone in [151..160] then res:=897;
    if zone in [161..170] then res:=950;
    if zone in [171..180] then res:=999;
    if zone in [181..190] then res:=1264;
    if zone in [191..200] then res:=1294;
  end;

  if ((ttype='AMURZAB')or(ttype='AMURZAB2')) then begin  //  01.01.2017
    vflg:=true;
    if zone in [0..10] then res:=95;
    if zone in [11..20] then res:=149;
    if zone in [21..30] then res:=210;
    if zone in [31..40] then res:=285;
    if zone in [41..50] then res:=334;
    if zone in [51..60] then res:=380;
    if zone in [61..70] then res:=434;
    if zone in [71..80] then res:=475;
    if zone in [81..90] then res:=529;
    if zone in [91..100] then res:=585;
    if zone in [101..110] then res:=639;
    if zone in [111..120] then res:=692;
    if zone in [121..130] then res:=741;
    if zone in [131..140] then res:=795;
    if zone in [141..150] then res:=841;
    if zone in [151..160] then res:=897;
    if zone in [161..170] then res:=950;
    if zone in [171..180] then res:=999;
    if zone in [181..190] then res:=1264;
    if zone in [191..200] then res:=1294;
  end;

  if ((ttype='KHABAROVSK')or(ttype='KHABAROVSK2')) then begin  //  01.01.2022
    vflg:=true;
    if zone in [0..10] then res:=27.5;
    if zone in [11..20] then res:=55;
    if zone in [21..30] then res:=82.5;
    if zone in [31..40] then res:=110;
    if zone in [41..50] then res:=137.5;
    if zone in [51..60] then res:=165;
    if zone in [61..70] then res:=192.5;
    if zone in [71..80] then res:=220;
    if zone in [81..90] then res:=247.5;
    if zone in [91..100] then res:=275;
    if zone in [101..110] then res:=302.5;
    if zone in [111..120] then res:=330;
    if zone in [121..130] then res:=357.5;
  end;

  if ((ttype='EVREYSKAYA')or(ttype='EVREYSKAYA2')) then begin  //  01.01.2022
    vflg:=true;
    if zone in [0..10] then res:=32;
    if zone in [11..20] then res:=65;
    if zone in [21..30] then res:=99;
    if zone in [31..40] then res:=132;
    if zone in [41..50] then res:=165;
    if zone in [51..60] then res:=199;
    if zone in [61..70] then res:=232;
    if zone in [71..80] then res:=266;
    if zone in [81..90] then res:=300;
    if zone in [91..100] then res:=333;
    if zone in [101..110] then res:=366;
    if zone in [111..120] then res:=399;
    if zone in [121..130] then res:=432;
    if zone in [131..140] then res:=466;
    if zone in [141..150] then res:=499;
    if zone in [151..160] then res:=533;
    if zone in [161..170] then res:=566;
    if zone in [171..200] then res:=600;

  end;

  if ((ttype='IRKUTSK')or(ttype='IRKUTSK1')or(ttype='IRKUTSK2')or(ttype='IRKUTSK3')or(ttype='IRKUTSK4')or(ttype='IRKUTSK5')) then begin
  //  01.01.2022
    vflg:=true;
    if zone in [0..10] then res:=39;
    if zone in [11..20] then res:=42;
    if zone in [21..30] then res:=53;
    if zone in [31..40] then res:=70;
    if zone in [41..50] then res:=81;
    if zone in [51..60] then res:=97;
    if zone in [61..70] then res:=115;
    if zone in [71..80] then res:=131;
    if zone in [81..90] then res:=150;
    if zone in [91..100] then res:=170;
    if zone in [101..110] then res:=186;
    if zone in [111..120] then res:=203;
    if zone in [121..130] then res:=222;
    if zone in [131..140] then res:=239;
    if zone in [141..150] then res:=259;
    if zone in [151..160] then res:=275;
    if zone in [161..170] then res:=294;
    if zone in [171..180] then res:=311;
    if zone in [181..190] then res:=331;
    if zone in [191..200] then res:=348;
    if zone in [201..210] then res:=382;
    if zone in [211..220] then res:=396;
    if zone in [221..230] then res:=411;
    if zone in [231..240] then res:=426;
    if zone in [241..250] then res:=434;
    if (zone >= 251) and (zone<=260) then res:=442;
    if (zone >= 261) and (zone<=270) then res:=460;
    if (zone >= 271) and (zone<=280) then res:=479;
    if (zone >= 281) and (zone<=290) then res:=498;
    if (zone >= 291) and (zone<=300) then res:=514;
    if (zone >= 301) and (zone<=310) then res:=531;
    if (zone >= 311) and (zone<=320) then res:=548;
    if (zone >= 321) and (zone<=330) then res:=565;
    if (zone >= 331) and (zone<=340) then res:=583;
    if (zone >= 341) and (zone<=350) then res:=602;
    if (zone >= 351) and (zone<=360) then res:=622;
    if (zone >= 361) and (zone<=370) then res:=641;
    if (zone >= 371) and (zone<=380) then res:=662;
    if (zone >= 381) and (zone<=390) then res:=684;
    if (zone >= 391) and (zone<=400) then res:=706;


  end;

  if ((ttype='IRKUTSKEXPR2')or(ttype='IRKUTSK1EXPR2')or(ttype='IRKUTSK2EXPR2')) then begin
    vflg:=true;
    if zone in [0..10] then res:=68;      // c 01.01.2022
    if zone in [11..20] then res:=72;
    if zone in [21..30] then res:=94;
    if zone in [31..40] then res:=127;
    if zone in [41..50] then res:=148;
    if zone in [51..60] then res:=174;
    if zone in [61..70] then res:=205;
    if zone in [71..80] then res:=237;
    if zone in [81..90] then res:=270;
    if zone in [91..100] then res:=301;
    if zone in [101..110] then res:=334;
    if zone in [111..120] then res:=365;
    if zone in [121..130] then res:=398;
    if zone in [131..140] then res:=431;
    if zone in [141..150] then res:=467;
    if zone in [151..160] then res:=496;
    if zone in [161..170] then res:=531;
    if zone in [171..180] then res:=560;
    if zone in [181..190] then res:=597;
    if zone in [191..200] then res:=628;
    if zone in [201..210] then res:=688;
    if zone in [211..220] then res:=714;
    if zone in [221..230] then res:=741;
    if zone in [231..240] then res:=767;
    if zone in [241..250] then res:=782;
    if (zone >= 251) and (zone<=260) then res:=798;
    if (zone >= 261) and (zone<=270) then res:=829;
    if (zone >= 271) and (zone<=280) then res:=864;
    if (zone >= 281) and (zone<=290) then res:=897;
    if (zone >= 291) and (zone<=300) then res:=927;
    if (zone >= 301) and (zone<=310) then res:=957;
    if (zone >= 311) and (zone<=320) then res:=988;
    if (zone >= 321) and (zone<=330) then res:=1019;
    if (zone >= 331) and (zone<=340) then res:=1051;
    if (zone >= 341) and (zone<=350) then res:=1085;
    if (zone >= 351) and (zone<=360) then res:=1121;
    if (zone >= 361) and (zone<=370) then res:=1157;
    if (zone >= 371) and (zone<=380) then res:=1194;
    if (zone >= 381) and (zone<=390) then res:=1234;
    if (zone >= 391) and (zone<=400) then res:=1274;


  end;

  if ((ttype='BURATIA')or(ttype='BURATIA1')) then begin
  //  01.01.2022
    vflg:=true;
    if zone in [0..10] then res:=43;
    if zone in [11..20] then res:=54;
    if zone in [21..30] then res:=78;
    if zone in [31..40] then res:=100;
    if zone in [41..50] then res:=118;
    if zone in [51..60] then res:=130;
    if zone in [61..70] then res:=151;
    if zone in [71..80] then res:=173;
    if zone in [81..90] then res:=197;
    if zone in [91..100] then res:=225;
    if zone in [101..110] then res:=235;
    if zone in [111..120] then res:=262;
    if zone in [121..130] then res:=286;
    if zone in [131..140] then res:=300;
    if zone in [141..150] then res:=315;
    if zone in [151..160] then res:=324;
    if zone in [161..170] then res:=362;
    if zone in [171..180] then res:=384;
    if zone in [181..190] then res:=4081;
    if zone in [191..200] then res:=432;
    if zone in [201..210] then res:=445;
    if zone in [211..220] then res:=453;
    if zone in [221..230] then res:=497;
    if zone in [231..240] then res:=514;
    if zone in [241..250] then res:=550;
    if zone > 250 then res:=558;



  end;

  if ((ttype='ZABAIKALYE')or(ttype='ZABAIKALYE1')or(ttype='ZABAIKALYE2')) then begin  //  01.01.2022
    vflg:=true;
    if zone in [0..10] then res:=44;
    if zone in [11..20] then res:=64;
    if zone in [21..30] then res:=78;
    if zone in [31..40] then res:=94;
    if zone in [41..50] then res:=118;
    if zone in [51..60] then res:=134;
    if zone in [61..70] then res:=156;
    if zone in [71..80] then res:=180;
    if zone in [81..90] then res:=196;
    if zone in [91..100] then res:=206;
    if zone in [101..110] then res:=234;
    if zone in [111..120] then res:=244;
    if zone in [121..130] then res:=266;
    if zone in [131..140] then res:=278;
    if zone in [141..150] then res:=288;
    if zone in [151..160] then res:=328;
    if zone in [161..170] then res:=346;
    if zone in [171..180] then res:=354;
    if zone in [181..190] then res:=372;
    if zone in [191..200] then res:=396;
    if zone in [201..210] then res:=440;
    if zone in [211..220] then res:=484;
    if zone in [221..230] then res:=528;
    if zone in [231..240] then res:=572;
    if zone in [241..250] then res:=614;
    if (zone >= 251) and (zone<=260) then res:=658;
    if (zone >= 261) and (zone<=270) then res:=702;
    if (zone >= 271) and (zone<=280) then res:=748;
    if (zone >= 281) and (zone<=290) then res:=792;
    if (zone >= 291) and (zone<=300) then res:=834;
    if (zone >= 301) and (zone<=310) then res:=878;
    if (zone >= 311) and (zone<=320) then res:=922;
    if (zone >= 321) and (zone<=330) then res:=966;
    if (zone >= 331) and (zone<=340) then res:=990;
    if (zone >= 341) and (zone<=350) then res:=990;
    if (zone >= 351) and (zone<=360) then res:=990;
    if (zone >= 361) and (zone<=370) then res:=990;
    if (zone >= 371) and (zone<=380) then res:=990;

  end;

  if ((ttype='ZABAIKALYE_ZONE')or(ttype='ZABAIKALYE1_ZONE')or(ttype='ZABAIKALYE2_ZONE')) then begin  //  01.01.2022
    vflg:=true;
    if zone<=1 then res:=44;
    if zone=2 then res:=64;
    if zone=3 then res:=78;
    if zone=4 then res:=94;
    if zone=5 then res:=118;
    if zone=6 then res:=134;
    if zone=7 then res:=156;
    if zone=8 then res:=180;
    if zone=9 then res:=196;
    if zone=10 then res:=206;
    if zone=11 then res:=234;
    if zone=12 then res:=244;
    if zone=13 then res:=266;
    if zone=14 then res:=278;
    if zone=15 then res:=288;
    if zone=16 then res:=328;
    if zone=17 then res:=346;
    if zone=18 then res:=354;
    if zone=19 then res:=372;
    if zone=20 then res:=396;
    if zone>20 then showmessage('error - zabaikalye_zone z>20');      //      
  end;

  if ((ttype='SAKHALIN')or(ttype='SAKHALIN1')or(ttype='SAKHALIN2')) then begin    //c 01.07.2013
    vflg:=true;
    if zone<=1 then res:=1.8
               else res:=zone*1.8;
  end;

  if ((ttype='KUZBASS')or(ttype='KUZBASS1')or(ttype='KUZBASS2')) then begin   //c 01.01.2022
    vflg:=true;
    case zone of
      0: res:=20;
      1: res:=20;
      2: res:=31;
      3: res:=41;
      4: res:=45;
      5: res:=54;
      6: res:=59;
      7: res:=65;
      8: res:=79;
      9: res:=84;
      10: res:=93;
      11: res:=98;
      12: res:=108;
      13: res:=113;
      14: res:=118;
      15: res:=127;
      16: res:=136;
      17: res:=151;
      18: res:=163;
      19: res:=175;
      20: res:=188;
      21: res:=192;
      22: res:=203;


    end;
  end;

  if ttype='KUZBASS_BISK_KM' then begin  // c 01.01.2022
    vflg:=true;
    if zone in [0..5] then res:=20;
    if zone in [6..15] then res:=31;
    if zone in [16..25] then res:=41;
    if zone in [26..35] then res:=45;
    if zone in [36..45] then res:=54;
    if zone in [46..55] then res:=59;
    if zone in [56..65] then res:=65;
    if zone in [66..75] then res:=79;
  end;

  if ttype='TOMSK' then begin    //c 01.01.2022
    vflg:=true;
    case zone of
      0: res:=34;
      1: res:=34;
      2: res:=47;
      3: res:=60;
      4: res:=74;
      5: res:=91;
      6: res:=112;
      7: res:=127;
    end;
  end;

  if ttype='TOMSK_VAG' then begin   //c 01.01.20122
    vflg:=true;
    case zone of
      0: res:=33;
      1: res:=33;
      2: res:=57;
      3: res:=84;
      4: res:=111;
      5: res:=135;
      6: res:=151;
      7: res:=169;
      8: res:=187;
      9: res:=207;
      10: res:=224;
    end;
  end;

  if ttype='KRASNOYARSK_GOROD' then begin  // c 01.02.2022
    vflg:=true;
    res:=28;
  end;

  if ((ttype='KRASNOYARSK')or(ttype='KRASNOYARSK1')or(ttype='KRASNOYARSK2')or(ttype='KRASNOYARSK3')or(ttype='KRASNOYARSK4')) then begin
  // c 01.02.2022
    vflg:=true;
    case zone of
      0: res:=28;
      1: res:=28;
      2: res:=34;
      3: res:=45;
      4: res:=58;
      5: res:=65;
      6: res:=72;
      7: res:=82;
      8: res:=126;
      9: res:=139;
      10: res:=155;
      11: res:=164;
      12: res:=175;
      13: res:=184;
      14: res:=200;
      15: res:=266;
      16: res:=281;
      17: res:=293;
      18: res:=312;
      19: res:=327;
      20: res:=343;
      21: res:=350;
      22: res:=357;
      23: res:=364;
      24: res:=371;
      25: res:=378;
      26: res:=385;
      27: res:=392;
      28: res:=409;
      29: res:=425;
      30: res:=442;
      31: res:=459;
      32: res:=475;
      33: res:=492;
      34: res:=508;
      35: res:=525;
      36: res:=547;
    end;
  end;

  if ((ttype='KRASNOYARSK_KM')or(ttype='KRASNOYARSK_KM1')or(ttype='KRASNOYARSK_KM2')) then begin
  // c 01.02.2022
    vflg:=true;
    if zone in [0..10] then res:=28;
    if zone in [11..20] then res:=34;
    if zone in [21..30] then res:=45;
    if zone in [31..40] then res:=58;
    if zone in [41..50] then res:=65;
    if zone in [51..60] then res:=72;
    if zone in [61..70] then res:=82;
    if zone in [71..80] then res:=126;
    if zone in [81..90] then res:=139;
    if zone in [91..100] then res:=155;
    if zone in [101..110] then res:=164;
    if zone in [111..120] then res:=175;
    if zone in [121..130] then res:=184;
    if zone in [131..140] then res:=200;
    if zone in [141..150] then res:=266;
    if zone in [151..160] then res:=281;
    if zone in [161..170] then res:=293;
    if zone in [171..180] then res:=293;
    if zone in [181..190] then res:=293;
    if zone in [191..200] then res:=293;
  end;

  if ((ttype='KRASNOYARSK_VAG')or(ttype='KRASNOYARSK_VAG1')or(ttype='KRASNOYARSK_VAG2')) then begin
  // c 01.02.2022
    vflg:=true;
    if zone in [0..10] then res:=50;
    if zone in [11..20] then res:=77;
    if zone in [21..30] then res:=92;
    if zone in [31..40] then res:=108;
    if zone in [41..50] then res:=123;
    if zone in [51..60] then res:=139;
    if zone in [61..70] then res:=155;
    if zone in [71..80] then res:=174;
    if zone in [81..90] then res:=184;
    if zone in [91..100] then res:=203;
    if zone in [101..110] then res:=219;
    if zone in [111..120] then res:=235;
    if zone in [121..130] then res:=249;
    if zone in [131..140] then res:=266;
    if zone in [141..150] then res:=281;
    if zone in [151..160] then res:=299;
    if zone in [161..170] then res:=311;
    if zone in [171..180] then res:=327;
    if zone in [181..190] then res:=343;
    if zone in [191..200] then res:=359;
    if zone in [201..210] then res:=375;
    if zone in [211..220] then res:=390;
    if (zone>220) and (zone<=230) then res:=405;
    if (zone>230) and (zone<=240) then res:=421;
    if (zone>240) and (zone<=250) then res:=436;
    if (zone>250) and (zone<=260) then res:=451;
    if (zone>260) and (zone<=270) then res:=467;
    if (zone>270) and (zone<=280) then res:=485;
    if (zone>280) and (zone<=290) then res:=502;
    if (zone>290) and (zone<=300) then res:=520;
    if (zone>300) and (zone<=310) then res:=538;

    if (zone>310) and (zone<=320) then res:=555;
    if (zone>320) and (zone<=330) then res:=573;
    if (zone>330) and (zone<=340) then res:=599;
    if (zone>340) and (zone<=350) then res:=625;
    if (zone>350) and (zone<=360) then res:=651;
    if (zone>360) and (zone<=370) then res:=677;
    if (zone>370) and (zone<=380) then res:=703;
    if (zone>380) and (zone<=390) then res:=729;
    if (zone>390) and (zone<=400) then res:=755;

    if (zone>400) and (zone<=410) then res:=780;
    if (zone>410) and (zone<=420) then res:=805;
    if (zone>420) and (zone<=430) then res:=830;
    if (zone>430) and (zone<=440) then res:=854;
    if (zone>440) and (zone<=450) then res:=879;
    if (zone>450) and (zone<=460) then res:=899;





  end;

  if ttype='KHAKAS_EL' then begin  // c 01.01.2022
    vflg:=true;
    if zone in [0..10] then res:=19;
    if zone in [11..20] then res:=30;
    if zone in [21..30] then res:=37;
    if zone in [31..40] then res:=48;
    if zone in [41..50] then res:=55;
    if zone in [51..60] then res:=57;
    if zone in [61..70] then res:=69;
    if zone in [71..80] then res:=103;
    if zone in [81..90] then res:=117;
    if zone in [91..100] then res:=127;
    if zone in [101..110] then res:=133;
    if zone in [111..120] then res:=142;
    if zone in [121..130] then res:=152;
    if zone in [131..140] then res:=161;
    if zone in [141..150] then res:=217;
    if zone in [151..160] then res:=230;
    if zone in [161..170] then res:=238;
    if zone in [171..180] then res:=257;
    if zone in [181..190] then res:=271;
    if zone in [191..200] then res:=278; //??
  end;

  if ttype='KHAKAS_VAG' then begin   // c 01.01.2021
    vflg:=true;
    if zone in [0..10] then res:=62;
    if zone in [11..20] then res:=82;
    if zone in [21..30] then res:=91;
    if zone in [31..40] then res:=109;
    if zone in [41..50] then res:=127;
    if zone in [51..60] then res:=144;
    if zone in [61..70] then res:=159;
  end;

  if ttype='CRIMEA' then begin  // c 01.01.2021
    vflg:=true;
    res:=zone*1.62;
  end;

  if ttype='SEVASTOPOL' then begin  // c 01.01.2022
    vflg:=true;
    res:=zone*1.68;
  end;


  if ((ttype='ALTAY')or(ttype='ALTAY2')) then begin      // c 01.01.2022
    vflg:=true;
    case zone of
      0: res:=18;
      1: res:=18;
      2: res:=21;
      3: res:=23;
      4: res:=29;
      5: res:=41;
      6: res:=54;
      7: res:=62;
      8: res:=80;
      9: res:=94;
      10: res:=110;
      11: res:=124;
      12: res:=138;
      13: res:=152;
      14: res:=168;
      15: res:=184;
      16: res:=198;
      17: res:=212;
      18: res:=226;
      19: res:=240;
      20: res:=256;
    end;
  end;

  if ((ttype='ULN')or(ttype='ULN2')) then begin       // c 01.01.2022
    vflg:=true;
    case zone of
      0: res:=18.9;
      1: res:=18.9;
      2: res:=36.8;
      3: res:=54.7;
      4: res:=72.6;
      5: res:=90.5;
      6: res:=103.8;
      7: res:=117.1;
      8: res:=130.4;
      9: res:=143.7;
      10: res:=157;
      11: res:=170.3;
      12: res:=183.6;
      13: res:=196.9;
      14: res:=210.2;
      15: res:=223.5;
      16: res:=236.8;
      17: res:=250.1;
      18: res:=263.4;
    end;
  end;

  if ttype='SAMARA' then begin     // 01.06.2022
    vflg:=true;
    if zone<=10 then res:=16.0
                else res:=((zone)*1.52);
    r4:=frac(res);
    r5:=0;
    val(floattostr(r4*10),r5,r6);
    if r6<>0 then r5:=0;
    if ((r4>0)and(r4<0.2)) then if r5<>2 then res:=res-r4;
    if ((r4>0.2)and(r4<0.4))  then if r5<>4 then res:=res-r4+0.2;
    if ((r4>0.4)and(r4<0.6))  then if r5<>6 then res:=res-r4+0.4;
    if ((r4>0.6)and(r4<0.8))  then if r5<>8 then res:=res-r4+0.6;
    if ((r4>0.8)and(r4<1))  then res:=res-r4+0.8;
  end;

  if ttype='SAMARA_GOROD' then begin      // 01.06.2022
    vflg:=true;
    res:=24;
  end;

  if ttype='SAMARA_LAST' then begin      // 01.03.2022
    vflg:=true;
    if zone <= 10 then res := 21
                  else res := 2.1 * zone;
  end;

  if ttype='SAMARA_LAST_GOROD' then begin      // 01.03.2022
    vflg:=true;
    res:=40;
  end;


  if ttype='EKBSODR' then begin   // c 01.01.2022
    vflg:=true;
    if zone in [0..10] then res:=23;
    if zone in [11..20] then res:=44.5;
    if zone in [21..30] then res:=67;
    if zone in [31..40] then res:=91;
    if zone in [41..50] then res:=114;
    if zone in [51..60] then res:=134;
    if zone in [61..70] then res:=156;
    if zone in [71..80] then res:=180;
    if zone in [81..90] then res:=201;
    if zone in [91..100] then res:=225;
    if zone in [101..110] then res:=249;
    if zone in [111..120] then res:=267;
    if zone in [121..130] then res:=292;
    if zone in [131..140] then res:=313.5;
    if zone in [141..150] then res:=335;
    if zone in [151..160] then res:=356.5;
    if zone in [161..170] then res:=378;
    if zone in [171..180] then res:=399.5;
    if zone in [181..190] then res:=421;
    if zone in [191..200] then res:=442.5;
  end;

  if ((ttype='EKATERINBURG')or(ttype='EKATERINBURG1')or(ttype='EKATERINBURG2')) then begin   //c 01.01.2022
    vflg:=true;
    if zone<6 then res:=33;
    if (zone in [6..15]) then res:=49;
    if (zone in [16..25]) then res:=67;
    if (zone in [26..35]) then res:=86;
    if (zone in [36..45]) then res:=102;
    if (zone in [46..55]) then res:=102;
    if (zone in [56..65]) then res:=121;
    if (zone in [66..75]) then res:=121;
    if (zone in [76..85]) then res:=137;
    if (zone in [86..95]) then res:=137;
    if (zone in [96..105]) then res:=173;
    if (zone in [106..115]) then res:=173;
    if (zone in [116..125]) then res:=173;
    if (zone in [126..135]) then res:=189;
    if (zone in [136..150]) then res:=189;
    if (zone in [151..165]) then res:=206;
    if (zone>165) and  (zone <=180)  then res:=221;
    if (zone>=181)  and (zone <=200)  then res:=221;
    if (zone>=201)  and (zone <=220)  then res:=271;
    if (zone>=221)  and (zone <=240)  then res:=292;
    if (zone>=241)  and (zone <=260)  then res:=323;
    if (zone>=261)  and (zone <=280)  then res:=344;
    if (zone>=281)  and (zone <=300)  then res:=344;
    if (zone>=301)  and (zone <=320)  then res:=376;
    if (zone>=321)  and (zone <=340)  then res:=396;
    if (zone>=341)  and (zone <=360)  then res:=417;
    if (zone>=361)  and (zone <=380)  then res:=417;
    if (zone>=381)  and (zone <=400)  then res:=440;


  end;

  if ((ttype='TYMEN')or(ttype='TYMEN1')or(ttype='TYMEN2')) then begin    //c 01.01.2022
    vflg:=true;
    if zone<6 then res:=28;
    if (zone in [6..15]) then res:=32;
    if (zone in [16..25]) then res:=53;
    if (zone in [26..35]) then res:=81;
    if (zone in [36..45]) then res:=83;
    if (zone in [46..55]) then res:=83;
    if (zone in [56..65]) then res:=107;
    if (zone in [66..75]) then res:=144;
    if (zone in [76..85]) then res:=144;
    if (zone in [86..95]) then res:=157;
    if (zone in [96..105]) then res:=157;
    if (zone in [106..115]) then res:=157;
    if (zone in [116..125]) then res:=159;
    if (zone in [126..135]) then res:=159;
    if zone>135 then res:=242;
  end;

  if ttype='TYMEN_GOROD' then begin      // 01.01.2022
    vflg:=true;
    res:=28;
  end;

  if ((ttype='KHANTY')or(ttype='KHANTY1')or(ttype='KHANTY2')) then begin  // c 01.01.2022
    vflg:=true;
    if zone<6 then res:=41;
    if (zone in [6..15]) then res:=59;
    if (zone in [16..25]) then res:=81;
    if (zone in [26..35]) then res:=96;
    if (zone in [36..45]) then res:=113;
    if (zone in [46..55]) then res:=133;
    if (zone in [56..65]) then res:=154;
    if (zone in [66..75]) then res:=165;
    if (zone in [76..85]) then res:=184;
    if (zone in [86..95]) then res:=203;
    if (zone in [96..105]) then res:=222;
    if (zone in [106..115]) then res:=241;
    if (zone in [116..125]) then res:=257;
    if (zone in [126..135]) then res:=276;
    if (zone in [136..150]) then res:=294;
    if (zone in [151..165]) then res:=313;
    if (zone in [166..180]) then res:=319;
    if (zone in [181..200]) then res:=328;
    if zone>200 then res:=344;
  end;

  if ((ttype='PERMSDPPK')or(ttype='PERMSDPPK1')or(ttype='PERMSDPPK2')) then begin    //c 1.01.2021
    vflg:=true;
    case zone of
      0: res:=28;
      1: res:=28;
      2: res:=55;
      3: res:=81;
      4: res:=117;
      5: res:=138;
      6: res:=165;
      7: res:=194;
      8: res:=222;
      9: res:=246;
      10: res:=275;
      11: res:=290;
      12: res:=299;
      13: res:=324;
      14: res:=349;
      15: res:=377;
      16: res:=405;
      17: res:=433;
      18: res:=461;
      19: res:=489;
      20: res:=517;
    end;
  end;

  if ((ttype='PERM')or(ttype='PERM1')or(ttype='PERM2')) then begin    //c 01.01.2022
    vflg:=true;
    if zone<16 then res:=32;
    if (zone in [16..25]) then res:=52;
    if (zone in [26..35]) then res:=88;
    if (zone in [36..45]) then res:=103;
    if (zone in [46..55]) then res:=122;
    if (zone in [56..65]) then res:=139;
    if (zone in [66..75]) then res:=155;
    if (zone in [76..85]) then res:=170;
    if (zone in [86..95]) then res:=192;
    if (zone in [96..105]) then res:=209;
    if (zone in [106..115]) then res:=224;
    if (zone in [116..125]) then res:=241;
    if (zone in [126..135]) then res:=261;
    if (zone in [136..150]) then res:=293;
    if (zone in [151..165]) then res:=312;
    if (zone in [166..180]) then res:=326;
    if zone>180 then res:=346;
  end;

  if ttype='PERM_GOROD' then begin    //c 01.10.2022
    vflg:=true;
    res:=32;
  end;

  if ttype='PERM_EXPRESS' then begin   //c 01.01.2022
    vflg:=true;
    if zone<16 then res:=115;
    if (zone in [16..25]) then res:=134;
    if (zone in [26..35]) then res:=167;
    if (zone in [36..45]) then res:=185;
    if (zone in [46..55]) then res:=201;
    if (zone in [56..65]) then res:=221;
    if (zone in [66..75]) then res:=236;
    if (zone in [76..85]) then res:=256;
    if (zone in [86..95]) then res:=269;
    if (zone in [96..105]) then res:=290;
    if (zone in [106..115]) then res:=305;
    if (zone in [116..125]) then res:=322;
    if (zone in [126..135]) then res:=341;
    if zone>135 then res:=375;
  end;

  if ((ttype='ROSTOV')or(ttype='ROSTOV1')or(ttype='ROSTOV2')) then begin    //c 27.12.2021
    vflg:=true;
    if zone<=1 then res:=18.5
               else res:=zone*18.5;
  end;

  if ttype='ROSTOV_GOROD' then begin    //  11.01.2022
    vflg:=true;
    res:=26;
  end;

  if ((ttype='KRASNODAR')or(ttype='KRASNODAR1')or(ttype='KRASNODAR2')) then begin  // c 1.01.2022
    vflg:=true;
    if zone<=1 then res:=29
               else res:=zone*29;
  end;

  if (ttype='MCD_DAL') then begin  // 
    vflg:=true;
    res:=zone*23;
  end;

  if (ttype='MCD_PRIG') then begin  // 
    vflg:=true;
    res:=45;
  end;

  if ttype='MCD_GOROD' then begin    // 
    vflg:=true;
    res:=38;
  end;


  if (ttype='KRASNODARR') then begin  // c 1.01.2022    - , 
    vflg:=true;
    if zone<=1 then res:=29
               else res:=zone*29;
  end;

  if ttype='ADYGEA' then begin   // c 01.01.2022
    vflg:=true;
    if zone<=1 then res:=20
               else res:=zone*20;
  end;

  if ttype='SOCHI' then begin    // c 1.1.2022
    vflg:=true;
    if zone<=1 then res:=42
               else res:=zone*42;
  end;

  if ttype='SOCHI_DOSS' then begin    // c 1.1.2022
    vflg:=true;
    if zone<=1 then res:=58
               else res:=zone*58;
  end;

  if ttype='STAVROPOL' then begin   // c 01.01.2022
    vflg:=true;
    if zone<=1 then res:=3
               else res:=zone*3;
    //res:=res*10;
    //SetRoundMode(rmNearest);
    //res:=round(res)/10;
  end;

  if ttype='CHERKES' then begin   // c 01.01.2022
    vflg:=true;
    if zone<=1 then res:=17
               else res:=zone*17;
  end;

  if ttype='KABARDA' then begin   // c 01.01.2022
    vflg:=true;
    if zone<=1 then res:=28
               else res:=zone*28;
  end;

  if ttype='OSETIA' then begin   // c 10.02.2017
    vflg:=true;
    if zone<=1 then res:=1.2
               else res:=zone*1.2;
  end;

  if ttype='DAGESTAN' then begin   // c 01.01.2021
    vflg:=true;
    if zone<=1 then res:=1.03
               else res:=zone*1.03;
    res:=res*10;
    SetRoundMode(rmNearest);
    res:=round(res)/10;
  end;

  if ttype='$$TEST$$KM$$' then begin    //  ,  
    vflg:=true;
    res:=zone;
  end;

  result:=res;
  if not vflg then ShowMessage('    - '+ttype);
end;

function CalcMatrixTariffNN(z1,z2:integer):real;
  type tnntariff=array[0..20,0..20] of real;
  const nntariff:tnntariff=
//c 01.01.2022
/// !!!!!      NN_ARZ    !!!!!!
/// !!!!!      NN_PIZHMA  - !!!!!!
(
(31, 31,   63,  90,  110, 129, 149, 167, 187, 205, 223, 243, 262, 282, 299, 319, 338, 356, 375, 395, 414),
(31, 31,   31,  63,  90,  110, 129, 149, 167, 187, 205, 223, 243, 262, 282, 299, 319, 338, 356, 375, 395),
(63, 31,   31,  31,  63,  90,  110, 129, 149, 167, 187, 205, 223, 243, 262, 282, 299, 319, 338, 356, 375),
(90, 63,   31,  31,  31,  63,  90,  110, 129, 149, 167, 187, 205, 223, 243, 262, 282, 299, 319, 338, 356),
(110, 90,  63,  31,  31,  31,  63,  90,  110, 129, 149, 167, 187, 205, 223, 243, 262, 282, 299, 319, 338),
(129, 110, 90,  63,  31,  31,  31,  63,  90,  110, 129, 149, 167, 187, 205, 223, 243, 262, 282, 299, 319),
(149, 129, 110, 90,  63,  31,  31,  31,  63,  90,  110, 129, 149, 167, 187, 205, 223, 243, 262, 282, 299),
(167, 149, 129, 110, 90,  63,  31,  31,  31,  63,  90,  110, 129, 149, 167, 187, 205, 223, 243, 262, 282),
(187, 167, 149, 129, 110, 90,  63,  31,  31,  31,  63,  90,  110, 129, 149, 167, 187, 205, 223, 243, 262),
(205, 187, 167, 149, 129, 110, 90,  63,  31,  31,  31,  63,  90,  110, 129, 149, 167, 187, 205, 223, 243),
(223, 205, 187, 167, 149, 129, 110, 90,  63,  31,  31,  31,  63,  90,  110, 129, 149, 167, 187, 205, 223),
(243, 223, 205, 187, 167, 149, 129, 110, 90,  63,  31,  31,  31,  63,  90,  110, 129, 149, 167, 187, 205),
(262, 243, 223, 205, 187, 167, 149, 129, 110, 90,  63,  31,  31,  31,  63,  90,  110, 129, 149, 167, 187),
(282, 262, 243, 223, 205, 187, 167, 149, 129, 110, 90,  63,  31,  31,  20,  38,  57,  76,  96,  110, 134),
(299, 282, 262, 243, 223, 205, 187, 167, 149, 129, 110, 90,  63,  20,  20,  20,  38,  57,  76,  96,  115),
(319, 299, 282, 262, 243, 223, 205, 187, 167, 149, 129, 110, 90,  38,  20,  20,  20,  38,  57,  76,  96),
(338, 319, 299, 282, 262, 243, 223, 205, 187, 167, 149, 129, 110, 57,  38,  20,  20,  20,  38,  57,  76),
(356, 338, 319, 299, 282, 262, 243, 223, 205, 187, 167, 149, 129, 76,  57,  38,  20,  20,  20,  38,  57),
(375, 356, 338, 319, 299, 282, 262, 243, 223, 205, 187, 167, 149, 96,  76,  57,  38,  20,  20,  20,  38),
(395, 375, 356, 338, 319, 299, 282, 262, 243, 223, 205, 187, 167, 115, 96,  76,  57,  38,  20,  20,  20),
(414, 395, 375, 356, 338, 319, 299, 282, 262, 243, 223, 205, 187, 134, 115, 96,  76,  57,  38,  20,  20));
/// !!!!!      NN_PIZHMA  - !!!!!!
/// !!!!!      NN_ARZ    !!!!!!
begin
  result:=nntariff[z1,z2];
end;


function CalcMatrixTariffKirov(z1,z2:integer):real;
  type tkirovtariff=array[0..20,0..20] of real;
  const kirovtariff:tkirovtariff=
((25,25,50,74,98,121,144,167,190,210,230,250,270,290,310,330,350,368,386,402,418),
(25,25,25,50,74,98,121,144,167,190,210,230,250,270,290,310,330,350,368,386,402),
(50,25,25,25,50,74,98,121,144,167,190,210,230,250,270,290,310,330,350,368,386),
(74,50,25,25,25,50,74,98,121,144,167,190,210,230,250,270,290,310,330,350,368),
(98,74,50,25,25,25,50,74,98,121,144,167,190,210,230,250,270,290,310,330,350),
(121,98,74,50,25,25,25,50,74,98,121,144,167,190,210,230,250,270,290,310,330),
(144,121,98,74,50,25,25,25,50,74,98,121,144,167,190,210,230,250,270,290,310),
(167,144,121,98,74,50,25,25,25,50,74,98,121,144,167,190,210,230,250,270,290),
(190,167,144,121,98,74,50,25,25,25,50,74,98,121,144,167,190,210,230,250,270),
(210,190,167,144,121,98,74,50,25,25,25,50,74,98,121,144,167,190,210,230,250),
(230,210,190,167,144,121,98,74,50,25,25,25,50,74,98,121,144,167,190,210,230),
(250,230,210,190,167,144,121,98,74,50,25,25,25,50,74,98,121,144,167,190,210),
(270,250,230,210,190,167,144,121,98,74,50,25,25,25,50,74,98,121,144,167,190),
(290,270,250,230,210,190,167,144,121,98,74,50,25,25,25,50,74,98,121,144,167),
(310,290,270,250,230,210,190,167,144,121,98,74,50,25,25,25,50,74,98,121,144),
(330,310,290,270,250,230,210,190,167,144,121,98,74,50,25,25,25,50,74,98,121),
(350,330,310,290,270,250,230,210,190,167,144,121,98,74,50,25,25,25,50,74,98),
(368,350,330,310,290,270,250,230,210,190,167,144,121,98,74,50,25,25,25,50,74),
(386,368,350,330,310,290,270,250,230,210,190,167,144,121,98,74,50,25,25,25,50),
(402,386,368,350,330,310,290,270,250,230,210,190,167,144,121,98,74,50,25,25,25),
(418,402,386,368,350,330,310,290,270,250,230,210,190,167,144,121,98,74,50,25,25));
//c 1.02.2019
begin
  showmessage('  - kirovmatrix!');
  result:=kirovtariff[z1,z2];
end;


(*
Function CalcMonoTarif_SPB2010(km1:real;type1,tarif,stat1,stat2:string):string;
  var t1:TTarif;
  var res:boolean;
  var s:string;
  var r:real;
begin
  res:=true;
  s:='';
  if not GetTarifInfo(type1,tarif,km1,t1) then res:=false;
  if res then begin
    tarif:=AnsiLowerCase(trim(tarif));
    r:=t1.price_limit;
    km1:=km1-t1.limit;
    if km1>0 then r:=r+(km1*t1.price_km);
    s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+floattostr(r)+'" type="'+tarif+'" reverse="1" />';
  end;
  result:=s;
end;


Function vCalcMonoTarif_SPB2011(km1:real;type1,tarif:string;lim:boolean):real;
  var t1:TTarif;
  var res:boolean;
  var s:string;
  var r:real;
begin
  res:=true;
  r:=0;
  if not GetTarifInfo(type1,tarif,km1,t1) then res:=false;
  if res then begin
    tarif:=AnsiLowerCase(trim(tarif));
    if lim then begin
    r:=t1.price_limit;
    km1:=km1-t1.limit;
     if km1>0 then r:=r+(km1*t1.price_km);
    end
     else r:=km1*t1.price_km;
    s:=floattostr(r);
  end;
  result:=r;
end;

Function vCalcMonoTarif_SPB092011(km1:real;type1,tarif:string;lim:boolean):real;
  var t1:TTarif;
  var res:boolean;
  var s:string;
  var r:real;
begin
  //   1  2011
  res:=true;
  r:=0;
  if not GetTarifInfo(type1,tarif,km1,t1) then res:=false;
  if res then begin
    if type1='spb' then begin
      r:=30;
      if km1>20 then r:=32;
      if km1>25 then r:=40;
      if km1>30 then r:=48;
      if km1>35 then r:=56;
      if km1>40 then r:=64;
      if km1>45 then r:=72;
      if km1>50 then r:=80;
      if km1>60 then r:=96;
      if km1>70 then r:=110;
      if km1>80 then r:=126;
      if km1>90 then r:=140;
      if km1>100 then r:=150;
      if km1>110 then r:=160;
      if km1>120 then r:=170;
      if km1>130 then r:=180;
      if km1>140 then r:=190;
      if km1>150 then r:=200;
    end
    else begin
    if type1='spb1' then begin
      r:=30;
      if km1>20 then r:=32;
      if km1>25 then r:=40;
      if km1>30 then r:=48;
      if km1>35 then r:=56;
      if km1>40 then r:=64;
      if km1>45 then r:=72;
      if km1>50 then r:=80;
      if km1>60 then r:=96;
      if km1>70 then r:=110;
      if km1>80 then r:=126;
      if km1>90 then r:=140;
      if km1>100 then r:=150;
      if km1>110 then r:=160;
      if km1>120 then r:=170;
      if km1>130 then r:=180;
      if km1>140 then r:=190;
      if km1>150 then r:=200;
    end
    else begin
    if type1='spb2' then begin
      r:=30;
      if km1>20 then r:=32;
      if km1>25 then r:=40;
      if km1>30 then r:=48;
      if km1>35 then r:=56;
      if km1>40 then r:=64;
      if km1>45 then r:=72;
      if km1>50 then r:=80;
      if km1>60 then r:=96;
      if km1>70 then r:=110;
      if km1>80 then r:=126;
      if km1>90 then r:=140;
      if km1>100 then r:=150;
      if km1>110 then r:=160;
      if km1>120 then r:=170;
      if km1>130 then r:=180;
      if km1>140 then r:=190;
      if km1>150 then r:=200;
    end
    else begin
          tarif:=AnsiLowerCase(trim(tarif));
          r:=0;
          if lim then begin
          r:=t1.price_limit;
          km1:=km1-t1.limit;
           if km1>0 then r:=r+(km1*t1.price_km);
          end
           else r:=km1*t1.price_km;
    end;
    end;
    end;
    s:=floattostr(r);
  end;
  result:=r;
end;


Function vCalcMonoTarif_SPB092012(km1:real;type1,tarif:string;lim:boolean):real;
  var t1:TTarif;
  var vr,res:boolean;
  var s:string;
  var r,kmc:real;
begin
  //   1  2012
  res:=true;
  vr:=false;
  r:=0;
if ((type1='spb')or(type1='spb1')or(type1='spb2')or(type1='spb11')or(type1='spb21')) then begin
  if km1<=20 then r:=32
   else begin
    kmc:=km1-20;
    r:=kmc*2;
    r:=r+32;
   end;
//
vr:=true;
end;
if ((type1='intrain#spb')or(type1='intrain#spb1')or(type1='intrain#spb2')or(type1='intrain#spb11')or(type1='intrain#spb21')) then begin
  if km1<=20 then r:=32
   else begin
    kmc:=km1-20;
    r:=kmc*2;
    r:=r+32;
   end;
vr:=true;
end;
if ((type1='km#spb')or(type1='km#spb1')or(type1='km#spb2')or(type1='km#spb11')or(type1='km#spb21')) then begin
  if km1<=20 then r:=32
   else begin
    kmc:=km1-20;
    r:=kmc*2;
    r:=r+32;
   end;
//
vr:=true;
end;
if ((type1='km#intrain#spb')or(type1='km#intrain#spb1')or(type1='km#intrain#spb2')or(type1='km#intrain#spb11')or(type1='km#intrain#spb21')) then begin
  if km1<=20 then r:=32
   else begin
    kmc:=km1-20;
    r:=kmc*2;
    r:=r+32;
   end;
vr:=true;
end;
if ((type1='zm#spb')or(type1='zm#spb1')or(type1='zm#spb2')or(type1='zm#spb11')or(type1='zm#spb21')) then begin
  if km1<=20 then r:=32
   else begin
    kmc:=km1-20;
    r:=kmc*2;
    r:=r+32;
   end;
//
vr:=true;
end;
if ((type1='zm#intrain#spb')or(type1='zm#intrain#spb1')or(type1='zm#intrain#spb2')or(type1='zm#intrain#spb11')or(type1='zm#intrain#spb21')) then begin
  if km1<=20 then r:=32
   else begin
    kmc:=km1-20;
    r:=kmc*2;
    r:=r+32;
   end;
vr:=true;
end;
     if not vr then begin
      if pos('km#',type1)=1 then type1:=copy(type1,4,length(type1)-3);
      if pos('zm#',type1)=1 then type1:=copy(type1,4,length(type1)-3);
      if pos('intrain#',type1)=1 then type1:=copy(type1,9,length(type1)-8);
      if not GetTarifInfo(type1,tarif,km1,t1) then res:=false;
      if res then begin
          tarif:=AnsiLowerCase(trim(tarif));
          r:=0;
          if lim then begin
          r:=t1.price_limit;
          km1:=km1-t1.limit;
           if km1>0 then r:=r+(km1*t1.price_km);
          end //lim
           else r:=km1*t1.price_km;
      end; //res
     end; //else
  s:=floattostr(r);
  result:=r;
end;




{
Function vCalcMonoTarif_SPB012012(km1:real;type1,tarif:string;lim:boolean):real;
  var t1:TTarif;
  var vr,res:boolean;
  var s:string;
  var r:real;
begin
  //   1  2012
  res:=true;
  vr:=false;
  r:=0;
if ((type1='spb')or(type1='spb1')or(type1='spb2')or(type1='spb11')or(type1='spb21')) then begin
if km1<22 then r:=32;
if km1=22 then r:=35;
if km1=23 then r:=35;
if km1=24 then r:=35;
if km1=25 then r:=35;
if km1=26 then r:=40;
if km1=27 then r:=42;
if km1=28 then r:=42;
if km1=29 then r:=44;
if km1=30 then r:=44;
if km1=31 then r:=48;
if km1=32 then r:=48;
if km1=33 then r:=52;
if km1=34 then r:=52;
if km1=35 then r:=52;
if km1=36 then r:=56;
if km1=37 then r:=56;
if km1=38 then r:=60;
if km1=39 then r:=60;
if km1=40 then r:=60;
if km1=41 then r:=60;
if km1=42 then r:=64;
if km1=43 then r:=68;
if km1=44 then r:=68;
if km1=45 then r:=68;
if km1=46 then r:=72;
if km1=47 then r:=72;
if km1=48 then r:=76;
if km1=49 then r:=76;
if km1=50 then r:=76;
if km1=51 then r:=80;
if km1=52 then r:=80;
if km1=53 then r:=84;
if km1=54 then r:=84;
if km1=55 then r:=84;
if km1=56 then r:=86;
if km1=57 then r:=86;
if km1=58 then r:=88;
if km1=59 then r:=88;
if km1=60 then r:=88;
if km1=61 then r:=98;
if km1=62 then r:=98;
if km1=63 then r:=98;
if km1=64 then r:=102;
if km1=65 then r:=102;
if km1=66 then r:=106;
if km1=67 then r:=106;
if km1=68 then r:=106;
if km1=69 then r:=106;
if km1=70 then r:=106;
if km1=71 then r:=115;
if km1=72 then r:=115;
if km1=73 then r:=115;
if km1=74 then r:=115;
if km1=75 then r:=115;
if km1=76 then r:=120;
if km1=77 then r:=120;
if km1=78 then r:=120;
if km1=79 then r:=120;
if km1=80 then r:=120;
if km1=81 then r:=135;
if km1=82 then r:=135;
if km1=83 then r:=135;
if km1=84 then r:=135;
if km1=85 then r:=135;
if km1=86 then r:=135;
if km1=87 then r:=135;
if km1=88 then r:=135;
if km1=89 then r:=135;
if km1=90 then r:=135;
if km1=91 then r:=150;
if km1=92 then r:=150;
if km1=93 then r:=150;
if km1=94 then r:=150;
if km1=95 then r:=150;
if km1=96 then r:=150;
if km1=97 then r:=150;
if km1=98 then r:=150;
if km1=99 then r:=150;
if km1=100 then r:=150;
if km1=101 then r:=160;
if km1=102 then r:=160;
if km1=103 then r:=160;
if km1=104 then r:=160;
if km1=105 then r:=160;
if km1=106 then r:=160;
if km1=107 then r:=160;
if km1=108 then r:=160;
if km1=109 then r:=160;
if km1=110 then r:=160;
if km1=111 then r:=170;
if km1=112 then r:=170;
if km1=113 then r:=170;
if km1=114 then r:=170;
if km1=115 then r:=170;
if km1=116 then r:=170;
if km1=117 then r:=170;
if km1=118 then r:=170;
if km1=119 then r:=170;
if km1=120 then r:=170;
if km1=121 then r:=180;
if km1=122 then r:=180;
if km1=123 then r:=180;
if km1=124 then r:=180;
if km1=125 then r:=180;
if km1=126 then r:=180;
if km1=127 then r:=180;
if km1=128 then r:=180;
if km1=129 then r:=180;
if km1=130 then r:=180;
if km1=131 then r:=190;
if km1=132 then r:=190;
if km1=133 then r:=190;
if km1=134 then r:=190;
if km1=135 then r:=190;
if km1=136 then r:=190;
if km1=137 then r:=190;
if km1=138 then r:=190;
if km1=139 then r:=190;
if km1=140 then r:=190;
if km1=141 then r:=200;
if km1=142 then r:=200;
if km1=143 then r:=200;
if km1=144 then r:=200;
if km1=145 then r:=200;
if km1=146 then r:=200;
if km1=147 then r:=200;
if km1=148 then r:=200;
if km1=149 then r:=200;
if km1=150 then r:=200;
if km1=151 then r:=210;
if km1=152 then r:=210;
if km1=153 then r:=210;
if km1=154 then r:=210;
if km1=155 then r:=210;
if km1=156 then r:=210;
if km1=157 then r:=210;
if km1=158 then r:=210;
if km1=159 then r:=210;
if km1=160 then r:=210;
if km1=161 then r:=220;
if km1=162 then r:=220;
if km1=163 then r:=220;
if km1=164 then r:=220;
if km1=165 then r:=220;
if km1=166 then r:=220;
if km1=167 then r:=220;
if km1=168 then r:=220;
if km1=169 then r:=220;
if km1=170 then r:=220;
if km1=171 then r:=230;
if km1=172 then r:=230;
if km1=173 then r:=230;
if km1=174 then r:=230;
if km1=175 then r:=230;
if km1=176 then r:=230;
if km1=177 then r:=230;
if km1=178 then r:=230;
if km1=179 then r:=230;
if km1=180 then r:=230;
if km1=181 then r:=240;
if km1=182 then r:=240;
if km1=183 then r:=240;
if km1=184 then r:=240;
if km1=185 then r:=240;
if km1=186 then r:=240;
if km1=187 then r:=240;
if km1=188 then r:=240;
if km1=189 then r:=240;
if km1=190 then r:=240;
if km1=191 then r:=250;
if km1=192 then r:=250;
if km1=193 then r:=250;
if km1=194 then r:=250;
if km1=195 then r:=250;
if km1=196 then r:=250;
if km1=197 then r:=250;
if km1=198 then r:=250;
if km1=199 then r:=250;
if km1>=200 then r:=250;
//
vr:=true;
end;
if ((type1='intrain#spb')or(type1='intrain#spb1')or(type1='intrain#spb2')or(type1='intrain#spb11')or(type1='intrain#spb21')) then begin
if km1<21 then r:=32;
if km1=21 then r:=33;
if km1=22 then r:=35;
if km1=23 then r:=36;
if km1=24 then r:=37;
if km1=25 then r:=38;
if km1=26 then r:=41;
if km1=27 then r:=43;
if km1=28 then r:=44;
if km1=29 then r:=46;
if km1=30 then r:=48;
if km1=31 then r:=49;
if km1=32 then r:=51;
if km1=33 then r:=52;
if km1=34 then r:=54;
if km1=35 then r:=56;
if km1=36 then r:=57;
if km1=37 then r:=59;
if km1=38 then r:=60;
if km1=39 then r:=62;
if km1=40 then r:=64;
if km1=41 then r:=65;
if km1=42 then r:=67;
if km1=43 then r:=68;
if km1=44 then r:=70;
if km1=45 then r:=72;
if km1=46 then r:=73;
if km1=47 then r:=75;
if km1=48 then r:=76;
if km1=49 then r:=78;
if km1=50 then r:=80;
if km1=51 then r:=81;
if km1=52 then r:=83;
if km1=53 then r:=84;
if km1=54 then r:=86;
if km1=55 then r:=88;
if km1=56 then r:=89;
if km1=57 then r:=91;
if km1=58 then r:=95;
if km1=59 then r:=99;
if km1=60 then r:=102;
if km1=61 then r:=107;
if km1=62 then r:=109;
if km1=63 then r:=112;
if km1=64 then r:=115;
if km1=65 then r:=118;
if km1=66 then r:=120;
if km1=67 then r:=122;
if km1=68 then r:=124;
if km1=69 then r:=126;
if km1=70 then r:=132;
if km1=71 then r:=133;
if km1=72 then r:=134;
if km1=73 then r:=135;
if km1=74 then r:=136;
if km1=75 then r:=137;
if km1=76 then r:=138;
if km1=77 then r:=139;
if km1=78 then r:=140;
if km1=79 then r:=141;
if km1=80 then r:=142;
if km1=81 then r:=147;
if km1=82 then r:=149;
if km1=83 then r:=152;
if km1=84 then r:=154;
if km1=85 then r:=156;
if km1=86 then r:=160;
if km1=87 then r:=163;
if km1=88 then r:=164;
if km1=89 then r:=166;
if km1=90 then r:=168;
if km1=91 then r:=172;
if km1=92 then r:=174;
if km1=93 then r:=176;
if km1=94 then r:=178;
if km1=95 then r:=180;
if km1=96 then r:=181;
if km1=97 then r:=182;
if km1=98 then r:=183;
if km1=99 then r:=184;
if km1=100 then r:=185;
if km1=101 then r:=186;
if km1=102 then r:=187;
if km1=103 then r:=188;
if km1=104 then r:=189;
if km1=105 then r:=190;
if km1=106 then r:=191;
if km1=107 then r:=193;
if km1=108 then r:=195;
if km1=109 then r:=196;
if km1=110 then r:=198;
if km1=111 then r:=200;
if km1=112 then r:=201;
if km1=113 then r:=202;
if km1=114 then r:=203;
if km1=115 then r:=204;
if km1=116 then r:=205;
if km1=117 then r:=206;
if km1=118 then r:=207;
if km1=119 then r:=208;
if km1=120 then r:=210;
if km1=121 then r:=225;
if km1=122 then r:=225;
if km1=123 then r:=225;
if km1=124 then r:=225;
if km1=125 then r:=225;
if km1=126 then r:=225;
if km1=127 then r:=225;
if km1=128 then r:=225;
if km1=129 then r:=225;
if km1=130 then r:=225;
if km1=131 then r:=240;
if km1=132 then r:=240;
if km1=133 then r:=240;
if km1=134 then r:=240;
if km1=135 then r:=240;
if km1=136 then r:=240;
if km1=137 then r:=240;
if km1=138 then r:=240;
if km1=139 then r:=240;
if km1=140 then r:=240;
if km1=141 then r:=255;
if km1=142 then r:=255;
if km1=143 then r:=255;
if km1=144 then r:=255;
if km1=145 then r:=255;
if km1=146 then r:=255;
if km1=147 then r:=255;
if km1=148 then r:=255;
if km1=149 then r:=255;
if km1=150 then r:=255;
if km1=151 then r:=270;
if km1=152 then r:=270;
if km1=153 then r:=270;
if km1=154 then r:=270;
if km1=155 then r:=270;
if km1=156 then r:=270;
if km1=157 then r:=270;
if km1=158 then r:=270;
if km1=159 then r:=270;
if km1=160 then r:=270;
if km1=161 then r:=285;
if km1=162 then r:=285;
if km1=163 then r:=285;
if km1=164 then r:=285;
if km1=165 then r:=285;
if km1=166 then r:=285;
if km1=167 then r:=285;
if km1=168 then r:=285;
if km1=169 then r:=285;
if km1=170 then r:=285;
if km1>=171 then r:=300;
vr:=true;
end;
if ((type1='km#spb')or(type1='km#spb1')or(type1='km#spb2')or(type1='km#spb11')or(type1='km#spb21')) then begin
if km1<21 then r:=1.6*km1;
if km1=21 then r:=32;
if km1=22 then r:=35;
if km1=23 then r:=35;
if km1=24 then r:=35;
if km1=25 then r:=35;
if km1=26 then r:=40;
if km1=27 then r:=42;
if km1=28 then r:=42;
if km1=29 then r:=44;
if km1=30 then r:=44;
if km1=31 then r:=48;
if km1=32 then r:=48;
if km1=33 then r:=52;
if km1=34 then r:=52;
if km1=35 then r:=52;
if km1=36 then r:=56;
if km1=37 then r:=56;
if km1=38 then r:=60;
if km1=39 then r:=60;
if km1=40 then r:=60;
if km1=41 then r:=60;
if km1=42 then r:=64;
if km1=43 then r:=68;
if km1=44 then r:=68;
if km1=45 then r:=68;
if km1=46 then r:=72;
if km1=47 then r:=72;
if km1=48 then r:=76;
if km1=49 then r:=76;
if km1=50 then r:=76;
if km1=51 then r:=80;
if km1=52 then r:=80;
if km1=53 then r:=84;
if km1=54 then r:=84;
if km1=55 then r:=84;
if km1=56 then r:=86;
if km1=57 then r:=86;
if km1=58 then r:=88;
if km1=59 then r:=88;
if km1=60 then r:=88;
if km1=61 then r:=98;
if km1=62 then r:=98;
if km1=63 then r:=98;
if km1=64 then r:=102;
if km1=65 then r:=102;
if km1=66 then r:=106;
if km1=67 then r:=106;
if km1=68 then r:=106;
if km1=69 then r:=106;
if km1=70 then r:=106;
if km1=71 then r:=115;
if km1=72 then r:=115;
if km1=73 then r:=115;
if km1=74 then r:=115;
if km1=75 then r:=115;
if km1=76 then r:=120;
if km1=77 then r:=120;
if km1=78 then r:=120;
if km1=79 then r:=120;
if km1=80 then r:=120;
if km1=81 then r:=135;
if km1=82 then r:=135;
if km1=83 then r:=135;
if km1=84 then r:=135;
if km1=85 then r:=135;
if km1=86 then r:=135;
if km1=87 then r:=135;
if km1=88 then r:=135;
if km1=89 then r:=135;
if km1=90 then r:=135;
if km1=91 then r:=150;
if km1=92 then r:=150;
if km1=93 then r:=150;
if km1=94 then r:=150;
if km1=95 then r:=150;
if km1=96 then r:=150;
if km1=97 then r:=150;
if km1=98 then r:=150;
if km1=99 then r:=150;
if km1=100 then r:=150;
if km1=101 then r:=160;
if km1=102 then r:=160;
if km1=103 then r:=160;
if km1=104 then r:=160;
if km1=105 then r:=160;
if km1=106 then r:=160;
if km1=107 then r:=160;
if km1=108 then r:=160;
if km1=109 then r:=160;
if km1=110 then r:=160;
if km1=111 then r:=170;
if km1=112 then r:=170;
if km1=113 then r:=170;
if km1=114 then r:=170;
if km1=115 then r:=170;
if km1=116 then r:=170;
if km1=117 then r:=170;
if km1=118 then r:=170;
if km1=119 then r:=170;
if km1=120 then r:=170;
if km1=121 then r:=180;
if km1=122 then r:=180;
if km1=123 then r:=180;
if km1=124 then r:=180;
if km1=125 then r:=180;
if km1=126 then r:=180;
if km1=127 then r:=180;
if km1=128 then r:=180;
if km1=129 then r:=180;
if km1=130 then r:=180;
if km1=131 then r:=190;
if km1=132 then r:=190;
if km1=133 then r:=190;
if km1=134 then r:=190;
if km1=135 then r:=190;
if km1=136 then r:=190;
if km1=137 then r:=190;
if km1=138 then r:=190;
if km1=139 then r:=190;
if km1=140 then r:=190;
if km1=141 then r:=200;
if km1=142 then r:=200;
if km1=143 then r:=200;
if km1=144 then r:=200;
if km1=145 then r:=200;
if km1=146 then r:=200;
if km1=147 then r:=200;
if km1=148 then r:=200;
if km1=149 then r:=200;
if km1=150 then r:=200;
if km1=151 then r:=210;
if km1=152 then r:=210;
if km1=153 then r:=210;
if km1=154 then r:=210;
if km1=155 then r:=210;
if km1=156 then r:=210;
if km1=157 then r:=210;
if km1=158 then r:=210;
if km1=159 then r:=210;
if km1=160 then r:=210;
if km1=161 then r:=220;
if km1=162 then r:=220;
if km1=163 then r:=220;
if km1=164 then r:=220;
if km1=165 then r:=220;
if km1=166 then r:=220;
if km1=167 then r:=220;
if km1=168 then r:=220;
if km1=169 then r:=220;
if km1=170 then r:=220;
if km1=171 then r:=230;
if km1=172 then r:=230;
if km1=173 then r:=230;
if km1=174 then r:=230;
if km1=175 then r:=230;
if km1=176 then r:=230;
if km1=177 then r:=230;
if km1=178 then r:=230;
if km1=179 then r:=230;
if km1=180 then r:=230;
if km1=181 then r:=240;
if km1=182 then r:=240;
if km1=183 then r:=240;
if km1=184 then r:=240;
if km1=185 then r:=240;
if km1=186 then r:=240;
if km1=187 then r:=240;
if km1=188 then r:=240;
if km1=189 then r:=240;
if km1=190 then r:=240;
if km1=191 then r:=250;
if km1=192 then r:=250;
if km1=193 then r:=250;
if km1=194 then r:=250;
if km1=195 then r:=250;
if km1=196 then r:=250;
if km1=197 then r:=250;
if km1=198 then r:=250;
if km1=199 then r:=250;
if km1>=200 then r:=250;
//
vr:=true;
end;
if ((type1='km#intrain#spb')or(type1='km#intrain#spb1')or(type1='km#intrain#spb2')or(type1='km#intrain#spb11')or(type1='km#intrain#spb21')) then begin
if km1<21 then r:=1.6*km1;
if km1=21 then r:=33;
if km1=22 then r:=35;
if km1=23 then r:=36;
if km1=24 then r:=37;
if km1=25 then r:=38;
if km1=26 then r:=41;
if km1=27 then r:=43;
if km1=28 then r:=44;
if km1=29 then r:=46;
if km1=30 then r:=48;
if km1=31 then r:=49;
if km1=32 then r:=51;
if km1=33 then r:=52;
if km1=34 then r:=54;
if km1=35 then r:=56;
if km1=36 then r:=57;
if km1=37 then r:=59;
if km1=38 then r:=60;
if km1=39 then r:=62;
if km1=40 then r:=64;
if km1=41 then r:=65;
if km1=42 then r:=67;
if km1=43 then r:=68;
if km1=44 then r:=70;
if km1=45 then r:=72;
if km1=46 then r:=73;
if km1=47 then r:=75;
if km1=48 then r:=76;
if km1=49 then r:=78;
if km1=50 then r:=80;
if km1=51 then r:=81;
if km1=52 then r:=83;
if km1=53 then r:=84;
if km1=54 then r:=86;
if km1=55 then r:=88;
if km1=56 then r:=89;
if km1=57 then r:=91;
if km1=58 then r:=95;
if km1=59 then r:=99;
if km1=60 then r:=102;
if km1=61 then r:=107;
if km1=62 then r:=109;
if km1=63 then r:=112;
if km1=64 then r:=115;
if km1=65 then r:=118;
if km1=66 then r:=120;
if km1=67 then r:=122;
if km1=68 then r:=124;
if km1=69 then r:=126;
if km1=70 then r:=132;
if km1=71 then r:=133;
if km1=72 then r:=134;
if km1=73 then r:=135;
if km1=74 then r:=136;
if km1=75 then r:=137;
if km1=76 then r:=138;
if km1=77 then r:=139;
if km1=78 then r:=140;
if km1=79 then r:=141;
if km1=80 then r:=142;
if km1=81 then r:=147;
if km1=82 then r:=149;
if km1=83 then r:=152;
if km1=84 then r:=154;
if km1=85 then r:=156;
if km1=86 then r:=160;
if km1=87 then r:=163;
if km1=88 then r:=164;
if km1=89 then r:=166;
if km1=90 then r:=168;
if km1=91 then r:=172;
if km1=92 then r:=174;
if km1=93 then r:=176;
if km1=94 then r:=178;
if km1=95 then r:=180;
if km1=96 then r:=181;
if km1=97 then r:=182;
if km1=98 then r:=183;
if km1=99 then r:=184;
if km1=100 then r:=185;
if km1=101 then r:=186;
if km1=102 then r:=187;
if km1=103 then r:=188;
if km1=104 then r:=189;
if km1=105 then r:=190;
if km1=106 then r:=191;
if km1=107 then r:=193;
if km1=108 then r:=195;
if km1=109 then r:=196;
if km1=110 then r:=198;
if km1=111 then r:=200;
if km1=112 then r:=201;
if km1=113 then r:=202;
if km1=114 then r:=203;
if km1=115 then r:=204;
if km1=116 then r:=205;
if km1=117 then r:=206;
if km1=118 then r:=207;
if km1=119 then r:=208;
if km1=120 then r:=210;
if km1=121 then r:=225;
if km1=122 then r:=225;
if km1=123 then r:=225;
if km1=124 then r:=225;
if km1=125 then r:=225;
if km1=126 then r:=225;
if km1=127 then r:=225;
if km1=128 then r:=225;
if km1=129 then r:=225;
if km1=130 then r:=225;
if km1=131 then r:=240;
if km1=132 then r:=240;
if km1=133 then r:=240;
if km1=134 then r:=240;
if km1=135 then r:=240;
if km1=136 then r:=240;
if km1=137 then r:=240;
if km1=138 then r:=240;
if km1=139 then r:=240;
if km1=140 then r:=240;
if km1=141 then r:=255;
if km1=142 then r:=255;
if km1=143 then r:=255;
if km1=144 then r:=255;
if km1=145 then r:=255;
if km1=146 then r:=255;
if km1=147 then r:=255;
if km1=148 then r:=255;
if km1=149 then r:=255;
if km1=150 then r:=255;
if km1=151 then r:=270;
if km1=152 then r:=270;
if km1=153 then r:=270;
if km1=154 then r:=270;
if km1=155 then r:=270;
if km1=156 then r:=270;
if km1=157 then r:=270;
if km1=158 then r:=270;
if km1=159 then r:=270;
if km1=160 then r:=270;
if km1=161 then r:=285;
if km1=162 then r:=285;
if km1=163 then r:=285;
if km1=164 then r:=285;
if km1=165 then r:=285;
if km1=166 then r:=285;
if km1=167 then r:=285;
if km1=168 then r:=285;
if km1=169 then r:=285;
if km1=170 then r:=285;
if km1>=171 then r:=300;
vr:=true;
end;
if ((type1='zm#spb')or(type1='zm#spb1')or(type1='zm#spb2')or(type1='zm#spb11')or(type1='zm#spb21')) then begin
if km1<20 then r:=32;
if km1<14 then r:=2.36*km1;
if km1=21 then r:=32;
if km1=22 then r:=35;
if km1=23 then r:=35;
if km1=24 then r:=35;
if km1=25 then r:=35;
if km1=26 then r:=40;
if km1=27 then r:=42;
if km1=28 then r:=42;
if km1=29 then r:=44;
if km1=30 then r:=44;
if km1=31 then r:=48;
if km1=32 then r:=48;
if km1=33 then r:=52;
if km1=34 then r:=52;
if km1=35 then r:=52;
if km1=36 then r:=56;
if km1=37 then r:=56;
if km1=38 then r:=60;
if km1=39 then r:=60;
if km1=40 then r:=60;
if km1=41 then r:=60;
if km1=42 then r:=64;
if km1=43 then r:=68;
if km1=44 then r:=68;
if km1=45 then r:=68;
if km1=46 then r:=72;
if km1=47 then r:=72;
if km1=48 then r:=76;
if km1=49 then r:=76;
if km1=50 then r:=76;
if km1=51 then r:=80;
if km1=52 then r:=80;
if km1=53 then r:=84;
if km1=54 then r:=84;
if km1=55 then r:=84;
if km1=56 then r:=86;
if km1=57 then r:=86;
if km1=58 then r:=88;
if km1=59 then r:=88;
if km1=60 then r:=88;
if km1=61 then r:=98;
if km1=62 then r:=98;
if km1=63 then r:=98;
if km1=64 then r:=102;
if km1=65 then r:=102;
if km1=66 then r:=106;
if km1=67 then r:=106;
if km1=68 then r:=106;
if km1=69 then r:=106;
if km1=70 then r:=106;
if km1=71 then r:=115;
if km1=72 then r:=115;
if km1=73 then r:=115;
if km1=74 then r:=115;
if km1=75 then r:=115;
if km1=76 then r:=120;
if km1=77 then r:=120;
if km1=78 then r:=120;
if km1=79 then r:=120;
if km1=80 then r:=120;
if km1=81 then r:=135;
if km1=82 then r:=135;
if km1=83 then r:=135;
if km1=84 then r:=135;
if km1=85 then r:=135;
if km1=86 then r:=135;
if km1=87 then r:=135;
if km1=88 then r:=135;
if km1=89 then r:=135;
if km1=90 then r:=135;
if km1=91 then r:=150;
if km1=92 then r:=150;
if km1=93 then r:=150;
if km1=94 then r:=150;
if km1=95 then r:=150;
if km1=96 then r:=150;
if km1=97 then r:=150;
if km1=98 then r:=150;
if km1=99 then r:=150;
if km1=100 then r:=150;
if km1=101 then r:=160;
if km1=102 then r:=160;
if km1=103 then r:=160;
if km1=104 then r:=160;
if km1=105 then r:=160;
if km1=106 then r:=160;
if km1=107 then r:=160;
if km1=108 then r:=160;
if km1=109 then r:=160;
if km1=110 then r:=160;
if km1=111 then r:=170;
if km1=112 then r:=170;
if km1=113 then r:=170;
if km1=114 then r:=170;
if km1=115 then r:=170;
if km1=116 then r:=170;
if km1=117 then r:=170;
if km1=118 then r:=170;
if km1=119 then r:=170;
if km1=120 then r:=170;
if km1=121 then r:=180;
if km1=122 then r:=180;
if km1=123 then r:=180;
if km1=124 then r:=180;
if km1=125 then r:=180;
if km1=126 then r:=180;
if km1=127 then r:=180;
if km1=128 then r:=180;
if km1=129 then r:=180;
if km1=130 then r:=180;
if km1=131 then r:=190;
if km1=132 then r:=190;
if km1=133 then r:=190;
if km1=134 then r:=190;
if km1=135 then r:=190;
if km1=136 then r:=190;
if km1=137 then r:=190;
if km1=138 then r:=190;
if km1=139 then r:=190;
if km1=140 then r:=190;
if km1=141 then r:=200;
if km1=142 then r:=200;
if km1=143 then r:=200;
if km1=144 then r:=200;
if km1=145 then r:=200;
if km1=146 then r:=200;
if km1=147 then r:=200;
if km1=148 then r:=200;
if km1=149 then r:=200;
if km1=150 then r:=200;
if km1=151 then r:=210;
if km1=152 then r:=210;
if km1=153 then r:=210;
if km1=154 then r:=210;
if km1=155 then r:=210;
if km1=156 then r:=210;
if km1=157 then r:=210;
if km1=158 then r:=210;
if km1=159 then r:=210;
if km1=160 then r:=210;
if km1=161 then r:=220;
if km1=162 then r:=220;
if km1=163 then r:=220;
if km1=164 then r:=220;
if km1=165 then r:=220;
if km1=166 then r:=220;
if km1=167 then r:=220;
if km1=168 then r:=220;
if km1=169 then r:=220;
if km1=170 then r:=220;
if km1=171 then r:=230;
if km1=172 then r:=230;
if km1=173 then r:=230;
if km1=174 then r:=230;
if km1=175 then r:=230;
if km1=176 then r:=230;
if km1=177 then r:=230;
if km1=178 then r:=230;
if km1=179 then r:=230;
if km1=180 then r:=230;
if km1=181 then r:=240;
if km1=182 then r:=240;
if km1=183 then r:=240;
if km1=184 then r:=240;
if km1=185 then r:=240;
if km1=186 then r:=240;
if km1=187 then r:=240;
if km1=188 then r:=240;
if km1=189 then r:=240;
if km1=190 then r:=240;
if km1=191 then r:=250;
if km1=192 then r:=250;
if km1=193 then r:=250;
if km1=194 then r:=250;
if km1=195 then r:=250;
if km1=196 then r:=250;
if km1=197 then r:=250;
if km1=198 then r:=250;
if km1=199 then r:=250;
if km1>=200 then r:=250;
//
vr:=true;
end;
if ((type1='zm#intrain#spb')or(type1='zm#intrain#spb1')or(type1='zm#intrain#spb2')or(type1='zm#intrain#spb11')or(type1='zm#intrain#spb21')) then begin
if km1<20 then r:=32;
if km1<14 then r:=2.36*km1;
if km1=21 then r:=33;
if km1=22 then r:=35;
if km1=23 then r:=36;
if km1=24 then r:=37;
if km1=25 then r:=38;
if km1=26 then r:=41;
if km1=27 then r:=43;
if km1=28 then r:=44;
if km1=29 then r:=46;
if km1=30 then r:=48;
if km1=31 then r:=49;
if km1=32 then r:=51;
if km1=33 then r:=52;
if km1=34 then r:=54;
if km1=35 then r:=56;
if km1=36 then r:=57;
if km1=37 then r:=59;
if km1=38 then r:=60;
if km1=39 then r:=62;
if km1=40 then r:=64;
if km1=41 then r:=65;
if km1=42 then r:=67;
if km1=43 then r:=68;
if km1=44 then r:=70;
if km1=45 then r:=72;
if km1=46 then r:=73;
if km1=47 then r:=75;
if km1=48 then r:=76;
if km1=49 then r:=78;
if km1=50 then r:=80;
if km1=51 then r:=81;
if km1=52 then r:=83;
if km1=53 then r:=84;
if km1=54 then r:=86;
if km1=55 then r:=88;
if km1=56 then r:=89;
if km1=57 then r:=91;
if km1=58 then r:=95;
if km1=59 then r:=99;
if km1=60 then r:=102;
if km1=61 then r:=107;
if km1=62 then r:=109;
if km1=63 then r:=112;
if km1=64 then r:=115;
if km1=65 then r:=118;
if km1=66 then r:=120;
if km1=67 then r:=122;
if km1=68 then r:=124;
if km1=69 then r:=126;
if km1=70 then r:=132;
if km1=71 then r:=133;
if km1=72 then r:=134;
if km1=73 then r:=135;
if km1=74 then r:=136;
if km1=75 then r:=137;
if km1=76 then r:=138;
if km1=77 then r:=139;
if km1=78 then r:=140;
if km1=79 then r:=141;
if km1=80 then r:=142;
if km1=81 then r:=147;
if km1=82 then r:=149;
if km1=83 then r:=152;
if km1=84 then r:=154;
if km1=85 then r:=156;
if km1=86 then r:=160;
if km1=87 then r:=163;
if km1=88 then r:=164;
if km1=89 then r:=166;
if km1=90 then r:=168;
if km1=91 then r:=172;
if km1=92 then r:=174;
if km1=93 then r:=176;
if km1=94 then r:=178;
if km1=95 then r:=180;
if km1=96 then r:=181;
if km1=97 then r:=182;
if km1=98 then r:=183;
if km1=99 then r:=184;
if km1=100 then r:=185;
if km1=101 then r:=186;
if km1=102 then r:=187;
if km1=103 then r:=188;
if km1=104 then r:=189;
if km1=105 then r:=190;
if km1=106 then r:=191;
if km1=107 then r:=193;
if km1=108 then r:=195;
if km1=109 then r:=196;
if km1=110 then r:=198;
if km1=111 then r:=200;
if km1=112 then r:=201;
if km1=113 then r:=202;
if km1=114 then r:=203;
if km1=115 then r:=204;
if km1=116 then r:=205;
if km1=117 then r:=206;
if km1=118 then r:=207;
if km1=119 then r:=208;
if km1=120 then r:=210;
if km1=121 then r:=225;
if km1=122 then r:=225;
if km1=123 then r:=225;
if km1=124 then r:=225;
if km1=125 then r:=225;
if km1=126 then r:=225;
if km1=127 then r:=225;
if km1=128 then r:=225;
if km1=129 then r:=225;
if km1=130 then r:=225;
if km1=131 then r:=240;
if km1=132 then r:=240;
if km1=133 then r:=240;
if km1=134 then r:=240;
if km1=135 then r:=240;
if km1=136 then r:=240;
if km1=137 then r:=240;
if km1=138 then r:=240;
if km1=139 then r:=240;
if km1=140 then r:=240;
if km1=141 then r:=255;
if km1=142 then r:=255;
if km1=143 then r:=255;
if km1=144 then r:=255;
if km1=145 then r:=255;
if km1=146 then r:=255;
if km1=147 then r:=255;
if km1=148 then r:=255;
if km1=149 then r:=255;
if km1=150 then r:=255;
if km1=151 then r:=270;
if km1=152 then r:=270;
if km1=153 then r:=270;
if km1=154 then r:=270;
if km1=155 then r:=270;
if km1=156 then r:=270;
if km1=157 then r:=270;
if km1=158 then r:=270;
if km1=159 then r:=270;
if km1=160 then r:=270;
if km1=161 then r:=285;
if km1=162 then r:=285;
if km1=163 then r:=285;
if km1=164 then r:=285;
if km1=165 then r:=285;
if km1=166 then r:=285;
if km1=167 then r:=285;
if km1=168 then r:=285;
if km1=169 then r:=285;
if km1=170 then r:=285;
if km1>=171 then r:=300;
vr:=true;
end;
     if not vr then begin
      if pos('km#',type1)=1 then type1:=copy(type1,4,length(type1)-3);
      if pos('zm#',type1)=1 then type1:=copy(type1,4,length(type1)-3);
      if pos('intrain#',type1)=1 then type1:=copy(type1,9,length(type1)-8);
      if not GetTarifInfo(type1,tarif,km1,t1) then res:=false;
      if res then begin
          tarif:=AnsiLowerCase(trim(tarif));
          r:=0;
          if lim then begin
          r:=t1.price_limit;
          km1:=km1-t1.limit;
           if km1>0 then r:=r+(km1*t1.price_km);
          end //lim
           else r:=km1*t1.price_km;
      end; //res
     end; //else
  s:=floattostr(r);
  result:=r;
end;


}

(*
Function CalcDualTarif_SPB2010(km1,km2:real;type1,type2,tarif,stat1,stat2:string):string;
  var t1,t2:TTarif;
  var res:boolean;
  var s:string;
  var r:real;
begin
  res:=true;
  s:='';
  if not GetTarifInfo(type1,tarif,km1,t1) then res:=false;
  if not GetTarifInfo(type2,tarif,km2,t2) then res:=false;
  if res then begin
    tarif:=AnsiLowerCase(trim(tarif));
    r:=t1.price_limit+t2.price_limit;
    km1:=km1-t1.limit;
    km2:=km2-t2.limit;
    if km1>0 then r:=r+(km1*t1.price_km);
    if km2>0 then r:=r+(km2*t2.price_km);
    s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+floattostr(r)+'" type="'+tarif+'" reverse="1" />';
  end;
  result:=s;
end;


{
function Calc_MOKT2014_Internal(km1:real;type1,tarif:string):extended;
 type tmokttariff=array[1..120,1..7] of real;
 const mokttariff:tmokttariff=
((175,215,325,435,545,655,35),
(175,215,325,435,545,655,35),
(175,215,325,435,545,655,35),
(175,215,325,435,545,655,35),
(175,215,325,435,545,655,35),
(175,220,330,440,550,665,35),
(175,220,335,445,560,670,35),
(175,225,340,455,565,680,35),
(175,230,345,460,575,690,35),
(175,230,350,465,580,700,35),
(185,255,380,510,640,765,37),
(195,275,415,555,695,835,39),
(205,300,450,600,750,900,41),
(215,320,485,645,810,970,43),
(230,345,520,690,865,1040,46),
(240,370,550,735,920,1105,48),
(250,390,585,780,980,1175,50),
(250,415,620,830,1035,1245,50),
(255,435,655,875,1095,1310,53),
(270,430,700,930,1165,1400,56),
(285,445,725,970,12.1,1455,58),
(295,465,755,1005,1260,1510,61),
(310,485,780,1045,1305,1565,64),
(325,505,810,1080,1350,1625,66),
(335,525,840,1120,1400,1680,70),
(350,540,865,1155,1445,1735,73),
(365,560,895,1195,1495,1790,75),
(380,580,925,1230,1540,1850,78),
(390,600,950,1270,1585,1905,81),
(405,625,1050,1400,1750,2100,83),
(420,645,1080,1440,1800,2160,86),
(430,660,1110,1480,1850,2220,89),
(445,675,1140,1520,1900,2280,92),
(460,695,1170,1560,1950,2340,95),
(475,710,1200,1600,2000,2400,97),
(485,725,1230,1640,2050,2460,100),
(500,745,1260,1680,2100,2520,103),
(515,760,1290,1720,2150,2580,106),
(525,775,1320,1760,2200,2640,109),
(530,825,1400,1865,2330,2800,112),
(535,845,1435,1915,2390,2870,114),
(545,860,1470,1960,2455,2945,117),
(550,880,1510,2010,2515,3015,120),
(560,895,1545,2060,2575,3090,123),
(565,915,1580,2110,2635,3165,126),
(570,935,1615,2155,2700,3240,128),
(575,950,1655,2205,2760,3310,131),
(580,970,1690,2255,2820,3385,134),
(585,985,1725,2305,2880,3455,136),
(595,1025,1750,2330,2915,3500,140),
(595,1045,1790,2385,2980,3580,143),
(610,1065,1830,2440,3050,3660,145),
(620,1085,1870,2490,3115,3740,148),
(635,1105,1910,2545,3180,3820,151),
(645,1125,1950,2600,3250,3900,153),
(655,1150,1990,2650,3315,3980,156),
(670,1170,2030,2705,3380,4060,159),
(680,1190,2070,2760,3450,4140,162),
(690,1210,2110,2810,3515,4220,165),
(705,1220,2100,2800,3500,4200,167),
(715,1245,2135,2845,3560,4275,170),
(725,1265,2175,2900,3625,4350,173),
(740,1285,2210,2950,3685,4425,176),
(750,1310,2250,3000,3750,4500,179),
(760,1330,2285,3050,3815,4575,182),
(775,1355,2325,3100,3875,4650,184),
(785,1375,2360,3150,3940,4725,187),
(795,1400,2400,3200,4000,4800,190),
(810,1420,2440,3250,4065,4875,193),
(815,1420,2450,3265,4080,4900,196),
(830,1440,2480,3310,4135,4965,198),
(840,1460,2515,3350,4190,5030,201),
(850,1480,2545,3395,4245,5095,204),
(865,1500,2580,3440,4300,5165,206),
(875,1525,2615,3485,4355,5230,210),
(885,1545,2645,3530,4410,5295,213),
(900,1565,2680,3575,4465,5360,215),
(910,1585,2715,3615,4520,5430,218),
(920,1605,2745,3660,4575,5495,221),
(935,1615,2800,3730,4665,5600,223),
(945,1635,2830,3770,4715,5660,226),
(955,1655,2860,3815,4770,5725,229),
(970,1675,2890,3855,4820,5785,232),
(980,1690,2925,3895,4875,5850,235),
(990,1710,2955,3940,4925,5910,237),
(1005,1730,2985,3980,4975,5975,240),
(1015,1750,3015,4025,5030,6035,243),
(1025,1765,3050,4065,5080,6100,246),
(1040,1785,3080,4105,5135,6160,249),
(1050,1815,3150,4200,5250,6300,252),
(1060,1830,3180,4240,5305,6365,254),
(1075,1850,3215,4285,5360,6430,257),
(1085,1870,3250,4330,5415,6500,260),
(1095,1890,3280,4375,5470,6565,263),
(1110,1905,3315,4420,5525,6635,266),
(1120,1925,3350,4465,5585,6700,268),
(1130,1940,3380,4510,5640,6765,271),
(1145,1960,3415,4555,5695,6835,274),
(1155,1980,3450,4600,5750,6900,276),
(1165,2015,3500,4665,5830,7000,280),
(1180,2030,3535,4715,5890,7070,283),
(1190,2050,3570,4765,5955,7145,285),
(1200,2070,3610,4810,6015,7220,288),
(1215,2090,3645,4860,6075,7290,291),
(1225,2110,3680,4910,6135,7365,293),
(1235,2130,3720,4960,6200,7440,296),
(1250,2150,3755,5010,6260,7515,299),
(1260,2170,3790,5055,6320,7585,302),
(1270,2190,3830,5105,6380,7660,305),
(1285,2210,3850,5130,6415,7700,307),
(1295,2230,3885,5180,6475,7775,310),
(1305,2250,3925,5230,6540,7850,313),
(1320,2275,3960,5280,6600,7925,316),
(1330,2295,4000,5330,6665,8000,319),
(1340,2315,4035,5380,6730,8075,322),
(1355,2335,4075,5430,6790,8150,324),
(1365,2355,4110,5480,6855,8225,327),
(1375,2375,4150,5530,6915,8300,330),
(1390,2400,4185,5585,6980,8375,333),
(1400,2410,4200,5600,7000,8400,336));
 var flag:boolean;
begin
 flag:=false;
 tarif:=ansilowercase(trim(tarif));
 type1:=ansilowercase(trim(type1));

 if type1='mokt_gorod' then begin
   if tarif='1m' then begin
     result:=1120;
     flag:=true;
   end;
   if tarif='5d' then begin
     result:=250;
     flag:=true;
   end;
   if tarif='10d' then begin
     result:=340;
     flag:=true;
   end;
   if tarif='15d' then begin
     result:=515;
     flag:=true;
   end;
   if tarif='20d' then begin
     result:=645;
     flag:=true;
   end;
   if tarif='25d' then begin
     result:=750;
     flag:=true;
   end;
   if tarif='1mr' then begin
     result:=915;
     flag:=true;
   end;
   if tarif='10dr' then begin
     result:=265;
     flag:=true;
   end;
   if tarif='15dr' then begin
     result:=375;
     flag:=true;
   end;
   if tarif='20dr' then begin
     result:=480;
     flag:=true;
   end;
   if tarif='25dr' then begin
     result:=645;
     flag:=true;
   end;
   if tarif='dates' then begin
     result:=0;
     flag:=true;
   end;
 end; //mokt_gorod

 if type1='mokt' then begin
   if tarif='1m' then begin
     result:=mokttariff[round(km1),6];
     flag:=true;
   end;
   if tarif='5d' then begin
     result:=mokttariff[round(km1),1];
     flag:=true;
   end;
   if tarif='10d' then begin
     result:=mokttariff[round(km1),2];
     flag:=true;
   end;
   if tarif='15d' then begin
     result:=mokttariff[round(km1),3];
     flag:=true;
   end;
   if tarif='20d' then begin
     result:=mokttariff[round(km1),4];
     flag:=true;
   end;
   if tarif='25d' then begin
     result:=mokttariff[round(km1),5];
     flag:=true;
   end;
   if tarif='1mr' then begin
     result:=0;
     flag:=true;
   end;
   if tarif='10dr' then begin
     result:=0;
     flag:=true;
   end;
   if tarif='15dr' then begin
     result:=0;
     flag:=true;
   end;
   if tarif='20dr' then begin
     result:=0;
     flag:=true;
   end;
   if tarif='25dr' then begin
     result:=0;
     flag:=true;
   end;
   if tarif='dates' then begin
     result:=mokttariff[round(km1),7];
     flag:=true;
   end;
 end; //mokt

 end;

Function aCalcMonoTarif_MSK2010(km1:real;type1,tarif,stat1,stat2:string):string;
  var t1:TTarif;
  var res:boolean;
  var tarstr,s:string;
  var r:real;
begin
  tarstr:=ansilowercase(trim(tarif));
  if ansilowercase(trim(tarif))='5d' then setroundmode(rmNearest)
                                     else setroundmode(rmUp);
  if ansilowercase(trim(tarif))='dates' then setroundmode(rmNearest);
  if ansilowercase(trim(tarif))='10dr' then setroundmode(rmNearest);
  if ansilowercase(trim(tarif))='15dr' then setroundmode(rmNearest);
  if ansilowercase(trim(tarif))='20dr' then setroundmode(rmNearest);
  if ansilowercase(trim(tarif))='25dr' then setroundmode(rmNearest);
  res:=true;
  s:='';
  r:=0;
  if not GetTarifInfo(type1,tarif,km1,t1) then res:=false;
  if res then begin
   if ansilowercase(trim(tarif))='5d' then begin
    if ((ansilowercase(trim(type1))='mokt')or(ansilowercase(trim(type1))='mokt_gorod')) then r:=Calc_MOKT2014_internal(km1,type1,tarif)
                                                                                        else r:=Calc5D(km1,type1);
   end
   else begin
    if ((ansilowercase(trim(type1))='mokt')or(ansilowercase(trim(type1))='mokt_gorod')) then begin
      r:=Calc_MOKT2014_internal(km1,type1,tarif);
    end
     else begin
       tarif:=AnsiLowerCase(trim(tarif));
       if km1>t1.limit then r:=(km1*t1.price_km)
                       else r:=t1.price_limit;
     end;
   end;
   if r>0 then begin
    if tarstr='dates' then begin
      s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r)*5)+'" type="5dat" reverse="1" />'+#13#10+
         '  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r)*6)+'" type="6dat" reverse="1" />'+#13#10+
         '  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r)*7)+'" type="7dat" reverse="1" />'+#13#10+
         '  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r)*8)+'" type="8dat" reverse="1" />'+#13#10+
         '  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r)*9)+'" type="9dat" reverse="1" />'+#13#10+
         '  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r)*10)+'" type="10dat" reverse="1" />'+#13#10+
         '  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r)*11)+'" type="11dat" reverse="1" />'+#13#10+
         '  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r)*12)+'" type="12dat" reverse="1" />'+#13#10+
         '  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r)*13)+'" type="13dat" reverse="1" />'+#13#10+
         '  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r)*14)+'" type="14dat" reverse="1" />'+#13#10+
         '  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r)*15)+'" type="15dat" reverse="1" />'+#13#10+
         '  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r)*16)+'" type="16dat" reverse="1" />';
    end
     else s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r))+'" type="'+ansilowercase(trim(tarif))+'" reverse="1" />';
   end;
  end;
  result:=s;
end;
}
(*
Function CalcDualTarif_MSK2010(km1,km2:real;type1,type2,tarif,stat1,stat2:string):string;
  var t1,t2:TTarif;
  var res:boolean;
  var s:string;
  var r:real;
begin
  if tarif='5D' then setroundmode(rmNearest)
                else setroundmode(rmUp);
  res:=true;
  s:='';
  r:=0;
  if not GetTarifInfo(type1,tarif,km1,t1) then res:=false;
  if not GetTarifInfo(type2,tarif,km2,t2) then res:=false;
  if res then begin
    tarif:=AnsiLowerCase(trim(tarif));
    if ansilowercase(trim(tarif))='5d' then begin
     if ((ansilowercase(trim(type1))='mokt')or(ansilowercase(trim(type1))='mokt_gorod')) then begin
      r:=Calc_MOKT2014_internal(km1,type1,tarif);
      r:=r+Calc_MOKT2014_internal(km2,type2,tarif);
     end
     else begin
      r:=Calc5D(km1,type1);
      r:=r+Calc5D(km2,type2);
     end; 
    end
    else begin
     if ((ansilowercase(trim(type1))='mokt')or(ansilowercase(trim(type1))='mokt_gorod')) then begin
      r:=Calc_MOKT2014_internal(km1,type1,tarif);
      r:=r+Calc_MOKT2014_internal(km2,type2,tarif);
     end
      else begin
        if km1>0 then begin
         if km1>t1.limit then r:=(km1*t1.price_km)
                         else r:=t1.price_limit;
        end;
        if km2>0 then begin
         if km2>t2.limit then r:=r+(km2*t2.price_km)
                         else r:=r+t2.price_limit;
        end;
      end;
    end;
    if r>0 then s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r))+'" type="'+ansilowercase(trim(tarif))+'" reverse="1" />'{+#13#10+type1+':'+floattostr(km1)+'  '+type2+':'+floattostr(km2)};
  end;
  result:=s;
end;
*)

function GetCPPKTariffMySQL(st1,st2,ttype:string;var tariff:real):boolean;
  var query_result: IMySQLQuery;
  var vs1,vs2,q1:string;
  var r:integer;
  var res:boolean;
begin
 tariff:=0;
 res:=true;
 st1:=inttostr(strtointe(st1));
 st2:=inttostr(strtointe(st2));
 r:=cppkst3.SearchString(Prep0ESR(st1));
  if r>0 then vs1:=cppkst1.getstring(r)
         else res:=false;
 r:=cppkst3.SearchString(Prep0ESR(st2));
  if r>0 then vs2:=cppkst1.getstring(r)
         else res:=false;
 if res then begin
  if mysql.Connected then begin
   q1:='SELECT * FROM `tarlist` WHERE st1='+vs1+' AND st2='+vs2+' AND type='+#39+ansilowercase(ttype)+#39+' ORDER BY price DESC';
     query_result:=MySQL.Query(q1);
       if query_result = nil then ShowMySQLError(MySQL)
        else begin
         if query_result.FetchRow then tariff:=StrToFloat(query_result.ValueByName['price']);
        end;
  end
   else begin
    ShowMessage('   MySQL!');
    Halt(1);
   end;
 end;
 result:=res;
end;

function GetCPPKTariffMySQLAll(st1,st2:string;var tariff:TAbTarifList):boolean;
  var query_result: IMySQLQuery;
  var vs1,vs2,q1:string;
  var r:integer;
  var res:boolean;
begin
 tariff.etrain:=0; tariff.reduced:=0; tariff.beznal := 0;
 tariff.child:=0; tariff.animal:=0; tariff.velzh:=0; tariff.handbag:=0;
 tariff.m1:=0; tariff.m1r:=0; tariff.m3:=0; tariff.m3r:=0; tariff.m12:=0;
 tariff.d5:=0; tariff.d10:=0; tariff.d15:=0; tariff.d10r:=0; tariff.d15r:=0;
 tariff.dat5:=0; tariff.dat6:=0; tariff.dat7:=0; tariff.dat8:=0; tariff.dat9:=0; tariff.dat10:=0; tariff.dat11:=0; tariff.dat12:=0; tariff.dat13:=0; tariff.dat14:=0; tariff.dat15:=0; tariff.dat16:=0;
 tariff.p10:=0; tariff.p20:=0; tariff.p60:=0; tariff.p90:=0;
 tariff.vyhdn:=0;

 tariff.komfort:=0; tariff.komfortchild:=0;
 tariff.detsky:=0;
 tariff.detsky_last:=0;

 tariff.mcd:=0;
 tariff.mcd_dal:=0;
 tariff.mcd_1dat:=0;
 tariff.mcd_3dat:=0;
 tariff.mcd_30dat:=0;
 tariff.mcd_90dat:=0;
 tariff.mcd_365dat:=0;
 tariff.mcd_1m_st:=0;
 tariff.mcd_3m_st:=0;
 tariff.mcd_60p:=0;
 tariff.uglski:=0;
 tariff.udm_sp:=0;
 tariff.priv_1mr:=0;
 tariff.priv_5den:=0;
 tariff.krskm_sp:=0;
 tariff.krskm_child:=0;
 tariff.krskm_animal:=0;


 res:=true;
 st1:=inttostr(strtointe(st1));
 st2:=inttostr(strtointe(st2));
 r:=cppkst3.SearchString(Prep0ESR(st1));
  if r>0 then vs1:=cppkst1.getstring(r)
         else res:=false;
 r:=cppkst3.SearchString(Prep0ESR(st2));
  if r>0 then vs2:=cppkst1.getstring(r)
         else res:=false;
 if res then begin
  if mysql.Connected then begin
   q1:='SELECT * FROM `tarlist` WHERE st1='+vs1+' AND st2='+vs2+' ORDER BY price';
     query_result:=MySQL.Query(q1);
       if query_result = nil then ShowMySQLError(MySQL)
        else begin
         while query_result.FetchRow do begin
          if query_result.ValueByName['type']='etrain' then tariff.etrain:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='reduced' then tariff.reduced:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='beznal' then tariff.beznal:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='child' then tariff.child:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='animal' then tariff.animal:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='handbag' then tariff.handbag:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='velzh' then tariff.velzh:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='1m' then tariff.m1:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='1mr' then tariff.m1r:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='3m' then tariff.m3:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='3mr' then tariff.m3r:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='12m' then tariff.m12:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='5d' then tariff.d5:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='10d' then tariff.d10:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='15d' then tariff.d15:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='10dr' then tariff.d10r:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='15dr' then tariff.d15r:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='5dat' then tariff.dat5:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='6dat' then tariff.dat6:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='7dat' then tariff.dat7:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='8dat' then tariff.dat8:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='9dat' then tariff.dat9:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='10dat' then tariff.dat10:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='11dat' then tariff.dat11:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='12dat' then tariff.dat12:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='13dat' then tariff.dat13:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='14dat' then tariff.dat14:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='15dat' then tariff.dat15:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='16dat' then tariff.dat16:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='10p' then tariff.p10:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='20p' then tariff.p20:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='60p' then tariff.p60:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='90p' then tariff.p90:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='vyhdn' then tariff.vyhdn:=StrToFloat(query_result.ValueByName['price']);

          if query_result.ValueByName['type']='mcd' then tariff.mcd:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='mcd_dal' then tariff.mcd_dal:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='mcd_1dat' then tariff.mcd_1dat:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='mcd_3dat' then tariff.mcd_3dat:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='mcd_30dat' then tariff.mcd_30dat:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='mcd_90dat' then tariff.mcd_90dat:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='mcd_365dat' then tariff.mcd_365dat:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='mcd_1m_st' then tariff.mcd_1m_st:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='mcd_3m_st' then tariff.mcd_3m_st:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='mcd_60p' then tariff.mcd_60p:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='uglski' then tariff.uglski:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='udm_sp' then tariff.udm_sp:=StrToFloat(query_result.ValueByName['price']);

          if query_result.ValueByName['type']='krskm_sp' then tariff.krskm_sp:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='krskm_child' then tariff.krskm_child:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='krskm_animal' then tariff.krskm_animal:=StrToFloat(query_result.ValueByName['price']);
          

         end;
        end;
  end
   else begin
    ShowMessage('   MySQL!');
    Halt(1);
   end;
 end;
 result:=res;
end;

function GetCPPKTariffMySQLAllExpress(st1,st2:string;var tariff:TAbTarifList):boolean;
  var query_result: IMySQLQuery;
  var vs1,vs2,q1:string;
  var r:integer;
  var res:boolean;
begin
 tariff.etrain:=0;
 tariff.child:=0; tariff.animal:=0;  tariff.beznal:=0; tariff.velzh:=0; tariff.handbag:=0;
 tariff.m1:=0; tariff.m1r:=0; tariff.m3:=0; tariff.m3r:=0; tariff.m12:=0;
 tariff.d5:=0; tariff.d10:=0; tariff.d15:=0; tariff.d10r:=0; tariff.d15r:=0;
 tariff.dat5:=0; tariff.dat6:=0; tariff.dat7:=0; tariff.dat8:=0; tariff.dat9:=0; tariff.dat10:=0; tariff.dat11:=0; tariff.dat12:=0; tariff.dat13:=0; tariff.dat14:=0; tariff.dat15:=0; tariff.dat16:=0;
 tariff.p10:=0; tariff.p20:=0; tariff.p60:=0; tariff.p90:=0;
 tariff.vyhdn:=0;
 tariff.komfort:=0; tariff.komfortchild:=0;
 tariff.detsky:=0; tariff.detsky_last:=0;
 tariff.uglski:=0;
 tariff.udm_sp:=0;
 tariff.priv_1mr:=0;
 tariff.priv_5den:=0;
 tariff.krskm_sp:=0;
 tariff.krskm_child:=0;
 tariff.krskm_animal:=0;

 res:=true;
 st1:=inttostr(strtointe(st1));
 st2:=inttostr(strtointe(st2));
 r:=cppkst3.SearchString(Prep0ESR(st1));
  if r>0 then vs1:=cppkst1.getstring(r)
         else res:=false;
 r:=cppkst3.SearchString(Prep0ESR(st2));
  if r>0 then vs2:=cppkst1.getstring(r)
         else res:=false;
 if res then begin
  if mysql.Connected then begin
   q1:='SELECT * FROM `tarlistexpr` WHERE st1='+vs1+' AND st2='+vs2+' ORDER BY price';
     query_result:=MySQL.Query(q1);
       if query_result = nil then ShowMySQLError(MySQL)
        else begin
         while query_result.FetchRow do begin
          if query_result.ValueByName['type']='express' then tariff.etrain:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='echild' then tariff.child:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e1m' then tariff.m1:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e1mr' then tariff.m1r:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e3m' then tariff.m3:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e3mr' then tariff.m3r:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e12m' then tariff.m12:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e5d' then tariff.d5:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e10d' then tariff.d10:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e5dat' then tariff.dat5:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e6dat' then tariff.dat6:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e7dat' then tariff.dat7:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e8dat' then tariff.dat8:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e9dat' then tariff.dat9:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e10dat' then tariff.dat10:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e11dat' then tariff.dat11:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e12dat' then tariff.dat12:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e13dat' then tariff.dat13:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e14dat' then tariff.dat14:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e15dat' then tariff.dat15:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e16dat' then tariff.dat16:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e10p' then tariff.p10:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e20p' then tariff.p20:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e60p' then tariff.p60:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='e90p' then tariff.p90:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='uglski' then tariff.uglski:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='udm_sp' then tariff.udm_sp:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='krskm_sp' then tariff.krskm_sp:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='krskm_child' then tariff.krskm_child:=StrToFloat(query_result.ValueByName['price']);
          if query_result.ValueByName['type']='krskm_animal' then tariff.krskm_animal:=StrToFloat(query_result.ValueByName['price']);

         end;
        end;
  end
   else begin
    ShowMessage('   MySQL!');
    Halt(1);
   end;
 end;
 result:=res;
end;


Function CalcMonoTarif_MSK072014km(km1:real;type1,tarif,stat1,stat2:string;zon:integer):string;
  var t1:TTarif;
  var res:boolean;
  var tarstr,typestr,s,sgor:string;
  var r,rcppk:real;
begin
 with form1 do begin
  tarstr:=ansilowercase(trim(tarif));
  typestr:=ansilowercase(trim(type1));
  setroundmode(rmUp);
  res:=true;
  s:='';
  r:=0;

  if not GetTarifInfo(type1,tarif,km1,t1) then res:=false;
  if res then begin
   if not t1.finmode then begin
       tarif:=AnsiLowerCase(trim(tarif));
       if km1>t1.limit then r:=(km1*t1.price_km)
                       else r:=t1.price_limit;
   end
    else begin
      r:=t1.finprice;
      if km1<20 then begin  //  , ..     20   
        if ansilowercase(trim(type1))='msk' then begin
         if zon<2 then r:=0;
        end;
      end;
    end;
  end;
  if ansilowercase(type1)='msk_gorod' then sgor:=' citygr="1"'
                                      else sgor:='';
  if CheckBox21.Checked then begin
   if GetCPPKTariffMySQL(stat1,stat2,ansilowercase(trim(tarif)),rcppk) then begin
     if rcppk>0 then begin
       if rcppk<>r then begin
        msk3500log.add(GetCPPKstnameBYesr(stat1)+' ('+stat1+') - '+GetCPPKstnameBYesr(stat2)+' ('+stat2+') - '+ansilowercase(trim(tarif))+' :   - '+FloatToStr(r)+',     - '+FloatToStr(rcppk)+',    ');
        if rcppk>=0 then s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+floattostr(rcppk)+'" type="'+ansilowercase(trim(tarif))+'" reverse="1" km="'+floattostr(km1)+'"'+sgor+' cppkbase="1" />';
       end
        else begin
          if r>=0 then s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r))+'" type="'+ansilowercase(trim(tarif))+'" reverse="1" km="'+floattostr(km1)+'"'+sgor+' />';
        end;
     end
      else begin
        msk3500log.add(GetCPPKstnameBYesr(stat1)+' ('+stat1+') - '+GetCPPKstnameBYesr(stat2)+' ('+stat2+') - '+ansilowercase(trim(tarif))+' :      ,  ');
        if r>=0 then s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="0" type="'+ansilowercase(trim(tarif))+'" reverse="1" km="'+floattostr(km1)+'"'+sgor+' />';
      end;
   end
    else begin
      msk3500log.add(GetCPPKstnameBYesr(stat1)+' ('+stat1+') - '+GetCPPKstnameBYesr(stat2)+' ('+stat2+') - '+ansilowercase(trim(tarif))+' :      ,  ');
      if r>=0 then s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="0" type="'+ansilowercase(trim(tarif))+'" reverse="1" km="'+floattostr(km1)+'"'+sgor+' />';
    end;
  end
   else begin
    if r>=0 then s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r))+'" type="'+ansilowercase(trim(tarif))+'" reverse="1" km="'+floattostr(km1)+'"'+sgor+' />';
   end;
  result:=s;
 end;
end;

Function CalcDualTarif_MSK072014km(km1,km2:real;type1,type2,tarif,stat1,stat2:string;zon:integer):string;
  var t1,t2:TTarif;
  var res:boolean;
  var s:string;
  var r,rcppk:real;
begin
 with form1 do begin
  setroundmode(rmUp);
  res:=true;
  s:='';
  r:=0;
  if not GetTarifInfo(type1,tarif,km1,t1) then res:=false;
  if not GetTarifInfo(type2,tarif,km2,t2) then res:=false;
  if res then begin
    tarif:=AnsiLowerCase(trim(tarif));
        if km1>0 then begin
          if not t1.finmode then begin
           if km1>t1.limit then r:=(km1*t1.price_km)
                           else r:=t1.price_limit;
          end
           else r:=t1.finprice;
        end;
        if km2>0 then begin
          if not t2.finmode then begin
           if km2>t2.limit then r:=r+(km2*t2.price_km)
                           else r:=r+t2.price_limit;
          end
           else r:=r+t2.finprice;
        end;
  end;
      if ((ansilowercase(trim(tarif))='1m')and(r>4300)) then r:=4300;
      if ((ansilowercase(trim(tarif))='3m')and(r>11650)) then r:=11650;
      if ((ansilowercase(trim(tarif))='12m')and(r>43000)) then r:=43000;
      if ((ansilowercase(trim(tarif))='1mr')and(r>4300)) then r:=4300;
      if ((ansilowercase(trim(tarif))='3mr')and(r>11650)) then r:=11650;
      if km1<20 then begin  //  , ..     20   
        if ansilowercase(trim(type1))='msk' then begin
         if zon<2 then r:=0;
        end;
      end;
      if km2<20 then begin  //  , ..     20   
        if ansilowercase(trim(type2))='msk' then begin
         if zon<2 then r:=0;
        end;
      end;
//  if r>=0 then s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r))+'" type="'+ansilowercase(trim(tarif))+'" reverse="1" />'
  if CheckBox21.Checked then begin
   if GetCPPKTariffMySQL(stat1,stat2,ansilowercase(trim(tarif)),rcppk) then begin
     if rcppk>0 then begin
       if rcppk<>r then begin
        msk3500log.add(GetCPPKstnameBYesr(stat1)+' ('+stat1+') - '+GetCPPKstnameBYesr(stat2)+' ('+stat2+') - '+ansilowercase(trim(tarif))+' :   - '+FloatToStr(r)+',     - '+FloatToStr(rcppk)+',    ');
        if rcppk>=0 then s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+floattostr(rcppk)+'" type="'+ansilowercase(trim(tarif))+'" reverse="1" cppkbase="1" />';
       end
        else begin
          if r>=0 then s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r))+'" type="'+ansilowercase(trim(tarif))+'" reverse="1" />';
        end;
     end
      else begin
        msk3500log.add(GetCPPKstnameBYesr(stat1)+' ('+stat1+') - '+GetCPPKstnameBYesr(stat2)+' ('+stat2+') - '+ansilowercase(trim(tarif))+' :      ,  ');
        if r>=0 then s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="0" type="'+ansilowercase(trim(tarif))+'" reverse="1" />';
      end;
   end
    else begin
      msk3500log.add(GetCPPKstnameBYesr(stat1)+' ('+stat1+') - '+GetCPPKstnameBYesr(stat2)+' ('+stat2+') - '+ansilowercase(trim(tarif))+' :      ,  ');
      if r>=0 then s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="0" type="'+ansilowercase(trim(tarif))+'" reverse="1" />';
    end;
  end
   else begin
    if r>=0 then s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r))+'" type="'+ansilowercase(trim(tarif))+'" reverse="1" />';
   end;

  result:=s;
 end;
end;




(*
procedure Calc_SPB2010;
  var i,n,m:integer;
  var km,t,km0,km1,km2,r,qq1,qq2,qq0:real;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        km:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        if km<21 then begin
          if checkbox1.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'ETRAIN',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
        end
         else begin
           if trim(stringgrid1.Cells[4,i])=trim(stringgrid1.Cells[4,n]) then begin
              if checkbox1.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'ETRAIN',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
           end
            else begin
              km0:=0;
              for m:=i+1 to n do begin
                if ((stringgrid1.cells[4,m]=stringgrid1.Cells[4,n])and(stringgrid1.cells[4,m-1]=stringgrid1.Cells[4,i])and(CompareDirections(stringgrid1.cells[2,i],stringgrid1.cells[2,m]))) then begin
                   km0:=strtofloat(trim(stringgrid1.cells[3,m]));
                   break;
                end;
              end;
              if km0>0 then begin
               km1:=abs(km0-strtofloat(trim(stringgrid1.Cells[3,i])));
               km2:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-km0);
               if checkbox1.Checked then WriteLn(tf,CalcDualTarif_SPB2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'ETRAIN',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox2.Checked then WriteLn(tf,CalcDualTarif_SPB2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox3.Checked then WriteLn(tf,CalcDualTarif_SPB2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox4.Checked then WriteLn(tf,CalcDualTarif_SPB2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox5.Checked then WriteLn(tf,CalcDualTarif_SPB2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox6.Checked then WriteLn(tf,CalcDualTarif_SPB2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox7.Checked then WriteLn(tf,CalcDualTarif_SPB2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox8.Checked then WriteLn(tf,CalcDualTarif_SPB2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              end;
            end;
         end;
      end;
    end;
  end;
end;
end;


procedure Calc_SPB2011beta;
  var i:integer;
begin
with form1 do begin
  combobox1.items.clear;
  combobox2.items.clear;
  for i:=0 to stringgrid1.RowCount-1 do begin
    combobox1.Items.Add(stringgrid1.cells[1,i]);
    combobox2.Items.Add(stringgrid1.cells[1,i]);
  end;
end;
end;

procedure Calc_SPB2011;
  var i,n,m,x,z,km,kmz:integer;
  var rt,ro:real;
  var kmt,kmt0:string;
  var lim:boolean;
  var trn,trkm,log:AF_Types.TStrings;
begin
with form1 do begin
  trn.create; trkm.create; log.create;
  for m:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,m]:=trim(ansilowercase(stringgrid1.Cells[4,m]));
    stringgrid1.Cells[5,m]:=trim(ansilowercase(stringgrid1.Cells[5,m]));
  end;
   for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        kmz:=strtointe(stringgrid1.Cells[3,i]);
        kmt:='###';
        kmt0:='###';
        trn.clear;
        trkm.clear;
        rt:=0;
        ro:=0;
        lim:=true;
        for x:=i to n do begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,i]) then begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,n]) then begin
            if stringgrid1.Cells[4,x]<>kmt then begin
              if kmt='###' then begin
                kmt:=stringgrid1.Cells[4,x];
                kmz:=strtointe(stringgrid1.Cells[3,x]);
              end
               else begin
                 km:=strtointe(stringgrid1.Cells[3,x-1])-kmz;
                 trn.add(kmt);
                 trkm.add(inttostr(km));
                 kmz:=strtointe(stringgrid1.Cells[3,x-1]);
                 kmt0:=kmt;
                 kmt:=stringgrid1.Cells[4,x];
               end;
            end
          end;
          end;
        end;
        if kmt<>'###' then begin
          km:=strtointe(stringgrid1.Cells[3,n])-kmz;
          trn.add(kmt);
          trkm.add(inttostr(km));
        end;
        if trn.count>0 then begin
          lim:=true;
          rt:=0;
          ro:=0;
          log.add('');
          log.add(stringgrid1.Cells[1,i]+' - '+stringgrid1.Cells[1,n]);
          for x:=1 to trn.count do begin
            rt:=rt+vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
            lim:=false;
          end;
          lim:=true;
          for x:=trn.count downto 1 do begin
            if ansilowercase(trn.getstring(x))='spb' then
              if x>1 then lim:=false;
            ro:=ro+vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
            lim:=false;
          end;
        end;
        SetRoundMode(rmNearest);
        rt:=round(rt*10) / 10;
        ro:=round(ro*10) / 10;
        if checkbox1.checked then begin
         if ((stringgrid1.Cells[0,i]<>'0')and(stringgrid1.Cells[0,n]<>'0')) then begin
          WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt));
          WriteLn(tf1,stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro));
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt)+'" type="etrain" reverse="0" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro)+'" type="etrain" reverse="0" />');
         end;
        end;
      end;
    end;
  end;
//  log.savetofile('c:\46\1.1');
  trn.free; trkm.free; log.free;
end;
end;


















procedure Calc_SPB092011;
  var i,n,m,x,z,km,kmz,prevkm,nkm,xx:integer;
  var rt,ro,rt1,ro1:real;
  var kmt,kmt0,s:string;
  var lim:boolean;
  var trn,trkm,trn1,trkm1,log:AF_Types.TStrings;
begin
with form1 do begin
  trn.create; trkm.create; trn1.create; trkm1.create; log.create;
  for m:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,m]:=trim(ansilowercase(stringgrid1.Cells[4,m]));
    stringgrid1.Cells[5,m]:=trim(ansilowercase(stringgrid1.Cells[5,m]));
  end;

  if stringgrid1.colcount<11 then stringgrid1.colcount:=11;

   for i:=1 to stringgrid1.rowcount-1 do begin
    if length(trim(stringgrid1.Cells[10,i]))<1 then stringgrid1.Cells[10,i]:=stringgrid1.Cells[4,i]+trim(stringgrid1.Cells[6,i]);
    if stringgrid1.Cells[10,i]='spb_gorod' then stringgrid1.Cells[10,i]:='spb';
   end;

   for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        kmz:=strtointe(stringgrid1.Cells[3,i]);
        kmt:='###';
        kmt0:='###';
        trn.clear;
        trkm.clear;
        rt:=0;
        ro:=0;
        lim:=true;
        for x:=i to n do begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,i]) then begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,n]) then begin
            if stringgrid1.Cells[4,x]<>kmt then begin
              if kmt='###' then begin
                kmt:=stringgrid1.Cells[4,x];
                kmz:=strtointe(stringgrid1.Cells[3,x]);
              end
               else begin
                 km:=strtointe(stringgrid1.Cells[3,x-1])-kmz;
                 if km>0 then begin
                 trn.add(kmt);
                 trkm.add(inttostr(km));
                 end;
                 kmz:=strtointe(stringgrid1.Cells[3,x-1]);
                 kmt0:=kmt;
                 kmt:=stringgrid1.Cells[4,x];
               end;
            end
          end;
          end;
        end;
        if kmt<>'###' then begin
          km:=strtointe(stringgrid1.Cells[3,n])-kmz;
          if km>0 then begin
          trn.add(kmt);
          trkm.add(inttostr(km));
          end;
        end;
        trn1.clear;
        trkm1.clear;
        kmz:=strtointe(stringgrid1.Cells[3,i]);
        kmt:='###';
        kmt0:='###';
        km:=0;
        prevkm:=0;
        nkm:=0;
        lim:=true;
        rt1:=0;
        ro1:=0;
        xx:=0;
        for x:=i to n do begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,i]) then begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,n]) then begin
            inc(xx);
            if stringgrid1.Cells[10,x]<>kmt then begin
              if xx=2 then kmt:=stringgrid1.Cells[10,x];
            end;
            if stringgrid1.Cells[10,x]<>kmt then begin
              if kmt='###' then begin
                kmt:=stringgrid1.Cells[10,x];
                nkm:=strtointe(stringgrid1.Cells[3,x]);
              end
               else begin
                 km:=strtointe(stringgrid1.Cells[3,x])-nkm;
                 if km>0 then begin
                   trn1.add(kmt);
                   trkm1.add(inttostr(km));
                   nkm:=strtointe(stringgrid1.Cells[3,x]);
                 end;
                 kmt0:=kmt;
                 kmt:=stringgrid1.Cells[10,x];
               end;
            end
          end;
          end;
        end;
        if kmt<>'###' then begin
          km:=strtointe(stringgrid1.Cells[3,n])-nkm;
          if km>0 then begin
          trn1.add(kmt);
          trkm1.add(inttostr(km));
          end;
        end;

/////   
        if trn.count>0 then begin
          if trn.count=1 then lim:=true
                         else lim:=false;
          rt:=0;
          ro:=0;
          log.add('');
          log.add(stringgrid1.Cells[1,i]+' - '+stringgrid1.Cells[1,n]);
          s:='';
          for x:=1 to trn.count do begin
            s:=s+trkm.getstring(x)+' ';
            rt:=rt+vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
          end;
          for x:=trn.count downto 1 do begin
            ro:=ro+vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
          end;
        SetRoundMode(rmNearest);
        rt:=round(rt*10) / 10;
        ro:=round(ro*10) / 10;
        end;
///// -  

/////  
        if trn1.count>0 then begin
          lim:=false;
          if ((trn1.count=1) and (trn1.getstring(1)='novgorod')) then lim:=true;
          rt1:=0;
          ro1:=0;
          log.add('');
          log.add(stringgrid1.Cells[1,i]+' - '+stringgrid1.Cells[1,n]);
          s:='';
          for x:=1 to trn1.count do begin
            s:=s+trkm1.getstring(x)+' ';
            rt1:=rt1+vCalcMonoTarif_SPB092011(strtointe(trkm1.getstring(x)),trn1.getstring(x),'ETRAIN',lim);
            log.add(' : '+trn1.getstring(x)+' '+trkm1.getstring(x));
          end;
          for x:=trn1.count downto 1 do begin
            ro1:=ro1+vCalcMonoTarif_SPB092011(strtointe(trkm1.getstring(x)),trn1.getstring(x),'ETRAIN',lim);
            log.add(' : '+trn1.getstring(x)+' '+trkm1.getstring(x));
          end;
        SetRoundMode(rmNearest);
        rt1:=round(rt1*10) / 10;
        ro1:=round(ro1*10) / 10;
        end;
///// - 

        if checkbox1.checked then begin
         if ((stringgrid1.Cells[0,i]<>'0')and(stringgrid1.Cells[0,n]<>'0')) then begin
          if rt>0 then begin
           if rt<=30 then begin
            WriteLn(tf1,'simple;'+stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt)+' ('+inttostr(trn.count)+') '+s);
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt)+'" type="etrain" reverse="0" />');
           end
            else begin
             WriteLn(tf1,'intrain;'+stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt)+' ('+inttostr(trn.count)+') '+s);
             WriteLn(tf1,'sale;'+stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt1)+' ('+inttostr(trn1.count)+') '+s);
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt)+'" type="etrain_intrain" reverse="0" />');
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt1)+'" type="etrain" reverse="0" />');
            end;
          end;
          if ro>0 then begin
           if ro<=30 then begin
             WriteLn(tf1,'simple;'+stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro)+' ('+inttostr(trn.count)+') '+s);
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro)+'" type="etrain" reverse="0" />');
           end
            else begin
             WriteLn(tf1,'intrain;'+stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro)+' ('+inttostr(trn.count)+') '+s);
             WriteLn(tf1,'sale;'+stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro1)+' ('+inttostr(trn1.count)+') '+s);
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro)+'" type="etrain_intrain" reverse="0" />');
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro1)+'" type="etrain" reverse="0" />');
            end;
          end;
         end;
        end;
      end;
    end;
  end;
  log.savetofile('C:\AF\\\1.1');
  trn.free; trkm.free; trn1.free; trkm1.free; log.free;
end;
end;


function rNear(r:real):string;
  var i:integer;
begin
  SetRoundMode(rmNearest);
  i:=Round(r);
  result:=inttostr(i);
end;

procedure Calc_SPB012012;
  var i,n,m,x,z,km,kmz,prevkm,nkm,xx:integer;
  var rt,ro,rt1,ro1,rt2,ro2:real;
  var kmt,kmt0,s,zkm:string;
  var lim:boolean;
  var trn,trkm,trn1,trkm1,log:AF_Types.TStrings;
  var ab,tb:TAbTarifList;
begin
with form1 do begin
  trn.create; trkm.create; trn1.create; trkm1.create; log.create;
  for m:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,m]:=trim(ansilowercase(stringgrid1.Cells[4,m]));
    stringgrid1.Cells[5,m]:=trim(ansilowercase(stringgrid1.Cells[5,m]));
  end;

  if stringgrid1.colcount<11 then stringgrid1.colcount:=11;

   for i:=1 to stringgrid1.rowcount-1 do begin
    if length(trim(stringgrid1.Cells[10,i]))<1 then stringgrid1.Cells[10,i]:=stringgrid1.Cells[4,i]+trim(stringgrid1.Cells[6,i]);
    if stringgrid1.Cells[10,i]='spb_gorod' then stringgrid1.Cells[10,i]:='spb';
   end;

   for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        kmz:=strtointe(stringgrid1.Cells[3,i]);
        kmt:='###';
        kmt0:='###';
        trn.clear;
        trkm.clear;
        rt:=0;
        ro:=0;
        lim:=true;
        for x:=i to n do begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,i]) then begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,n]) then begin
            if stringgrid1.Cells[4,x]<>kmt then begin
              if kmt='###' then begin
                kmt:=stringgrid1.Cells[4,x];
                kmz:=strtointe(stringgrid1.Cells[3,x]);
              end
               else begin
                 km:=strtointe(stringgrid1.Cells[3,x-1])-kmz;
                 if km>0 then begin
                 trn.add(kmt);
                 trkm.add(inttostr(km));
                 end;
                 kmz:=strtointe(stringgrid1.Cells[3,x-1]);
                 kmt0:=kmt;
                 kmt:=stringgrid1.Cells[4,x];
               end;
            end
          end;
          end;
        end;
        if kmt<>'###' then begin
          km:=strtointe(stringgrid1.Cells[3,n])-kmz;
          if km>0 then begin
          trn.add(kmt);
          trkm.add(inttostr(km));
          end;
        end;
        trn1.clear;
        trkm1.clear;
        kmz:=strtointe(stringgrid1.Cells[3,i]);
        kmt:='###';
        kmt0:='###';
        km:=0;
        prevkm:=0;
        nkm:=0;
        lim:=true;
        rt1:=0;
        ro1:=0;
        xx:=0;
        for x:=i to n do begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,i]) then begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,n]) then begin
            inc(xx);
            if stringgrid1.Cells[10,x]<>kmt then begin
              if xx=2 then kmt:=stringgrid1.Cells[10,x];
            end;
            if stringgrid1.Cells[10,x]<>kmt then begin
              if kmt='###' then begin
                kmt:=stringgrid1.Cells[10,x];
                nkm:=strtointe(stringgrid1.Cells[3,x]);
              end
               else begin
                 km:=strtointe(stringgrid1.Cells[3,x])-nkm;
                 if km>0 then begin
                   trn1.add(kmt);
                   trkm1.add(inttostr(km));
                   nkm:=strtointe(stringgrid1.Cells[3,x]);
                 end;
                 kmt0:=kmt;
                 kmt:=stringgrid1.Cells[10,x];
               end;
            end
          end;
          end;
        end;
        if kmt<>'###' then begin
          km:=strtointe(stringgrid1.Cells[3,n])-nkm;
          if km>0 then begin
          trn1.add(kmt);
          trkm1.add(inttostr(km));
          end;
        end;

/////   
        if trn.count>0 then begin
          if trn.count=1 then lim:=true
                         else lim:=false;
          rt:=0;
          ro:=0;
          log.add('');
          log.add(stringgrid1.Cells[1,i]+' - '+stringgrid1.Cells[1,n]);
          s:='';
          for x:=1 to trn.count do begin
            s:=s+trkm.getstring(x)+' ';
            rt:=rt+vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
          end;
          for x:=trn.count downto 1 do begin
            ro:=ro+vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
          end;
        SetRoundMode(rmNearest);
        rt:=round(rt*10) / 10;
        ro:=round(ro*10) / 10;
        end;
///// -  

/////    
        if trn1.count>0 then begin
          rt1:=0;
          ro1:=0;
          log.add('');
          log.add(stringgrid1.Cells[1,i]+' - '+stringgrid1.Cells[1,n]);
          s:='';
          lim:=false;
          zkm:='';
          if ({(trn1.count=1) and} (trn1.getstring(1)='novgorod')) then lim:=true;
          if trn1.count=2 then begin
           if strtointe(trkm1.getstring(1))<21 then begin
             if trn1.getstring(2)='novgorod' then zkm:='zm#';
           end;
          end;
          for x:=1 to trn1.count do begin
            s:=s+trkm1.getstring(x)+' ';
            rt1:=rt1+vCalcMonoTarif_SPB092012(strtointe(trkm1.getstring(x)),zkm+trn1.getstring(x),'ETRAIN',lim);
            log.add(' : '+trn1.getstring(x)+' '+trkm1.getstring(x));
          end;
          lim:=false;
          zkm:='';
          if ({(trn1.count=1) and} (trn1.getstring(trn1.count)='novgorod')) then begin
            lim:=true;
            zkm:='km#';
          end;
          for x:=trn1.count downto 1 do begin
            ro1:=ro1+vCalcMonoTarif_SPB092012(strtointe(trkm1.getstring(x)),zkm+trn1.getstring(x),'ETRAIN',lim);
            log.add(' : '+trn1.getstring(x)+' '+trkm1.getstring(x));
          end;
        SetRoundMode(rmNearest);
        rt1:=round(rt1*10) / 10;
        ro1:=round(ro1*10) / 10;
        end;
///// -   

/////    
        if trn1.count>0 then begin
          lim:=false;
          if ({(trn1.count=1) and} (trn1.getstring(1)='novgorod')) then lim:=true;
          rt2:=0;
          ro2:=0;
          log.add('');
          log.add(stringgrid1.Cells[1,i]+' - '+stringgrid1.Cells[1,n]);
          s:='';
          lim:=false;
          zkm:='';
          if ({(trn1.count=1) and} (trn1.getstring(1)='novgorod')) then lim:=true;
          if trn1.count=2 then begin
           if strtointe(trkm1.getstring(1))<21 then begin
             if trn1.getstring(2)='novgorod' then zkm:='zm#';
           end;
          end;
          for x:=1 to trn1.count do begin
            s:=s+trkm1.getstring(x)+' ';
            rt2:=rt2+vCalcMonoTarif_SPB092012(strtointe(trkm1.getstring(x)),zkm+'intrain#'+trn1.getstring(x),'ETRAIN',lim);
            log.add('   : '+trn1.getstring(x)+' '+trkm1.getstring(x));
          end;
          lim:=false;
          zkm:='';
          if ({(trn1.count=1) and} (trn1.getstring(trn1.count)='novgorod')) then begin
            lim:=true;
            zkm:='km#';
          end;
          for x:=trn1.count downto 1 do begin
            ro2:=ro2+vCalcMonoTarif_SPB092012(strtointe(trkm1.getstring(x)),zkm+'intrain#'+trn1.getstring(x),'ETRAIN',lim);
            log.add('   : '+trn1.getstring(x)+' '+trkm1.getstring(x));
          end;
        SetRoundMode(rmNearest);
        rt2:=round(rt2*10) / 10;
        ro2:=round(ro2*10) / 10;
        end;
///// -   


/////  
        ab.m1:=0;
        ab.m1r:=0;
        ab.d5:=0;
        ab.d10:=0;
        ab.d15:=0;
        ab.d10r:=0;
        ab.d15r:=0;
        if trn1.count>0 then begin
 //         rt2:=0;
 //         ro2:=0;
          log.add('');
//          log.add(stringgrid1.Cells[1,i]+' - '+stringgrid1.Cells[1,n]+' ');
          s:='';
          lim:=true;
          for x:=1 to trn1.count do begin
            if stringgrid1.Cells[1,n]='' then begin
              s:='1234';
            end;
            s:=s+trkm1.getstring(x)+' ';
            ab:=GetSPB3700ab(strtofloat(trkm1.getstring(x)),trn1.getstring(x),lim,ab,true);
            lim:=false;
          end;
        end;
///// - 

//        WriteLn(tf,stringgrid1.Cells[1,i]+' - '+stringgrid1.Cells[1,n]);

        if checkbox1.checked then begin
         if ((stringgrid1.Cells[0,i]<>'0')and(stringgrid1.Cells[0,n]<>'0')) then begin

          if rt>0 then begin
           if rt<=30 then begin
            WriteLn(tf1,'simple;'+stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt)+' ('+inttostr(trn.count)+') '+s);
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt)+'" type="etrain" reverse="0" />');
           end
            else begin
             WriteLn(tf1,'intrain;'+stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt2)+' ('+inttostr(trn.count)+') '+s);
//             WriteLn(tf1,'sale;'+stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt1)+' ('+inttostr(trn1.count)+') '+s);
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt2)+'" type="etrain" reverse="0" />');
//             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt2)+'" type="etrain_intrain" reverse="0" />');
//             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt1)+'" type="etrain" reverse="0" />');
            end;
          end;

          if ro>0 then begin
           if ro<=30 then begin
             WriteLn(tf1,'simple;'+stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro)+' ('+inttostr(trn.count)+') '+s);
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro)+'" type="etrain" reverse="0" />');
           end
            else begin
             WriteLn(tf1,'intrain;'+stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro2)+' ('+inttostr(trn.count)+') '+s);
//             WriteLn(tf1,'sale;'+stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro1)+' ('+inttostr(trn1.count)+') '+s);
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro2)+'" type="etrain" reverse="0" />');
//             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro2)+'" type="etrain_intrain" reverse="0" />');
//             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro1)+'" type="etrain" reverse="0" />');
            end;
          end;

         end;
        end;

        if checkbox2.Checked then if ab.m1>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+rnear(ab.m1)+'" type="1m" reverse="1" />');
        if checkbox3.Checked then if ab.m1r>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+rnear(ab.m1r)+'" type="1mr" reverse="1" />');
        if checkbox4.Checked then if ab.d5>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+rnear(ab.d5)+'" type="5d" reverse="1" />');
        if checkbox5.Checked then if ab.d10>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+rnear(ab.d10)+'" type="10d" reverse="1" />');
        if checkbox6.Checked then if ab.d15>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+rnear(ab.d15)+'" type="15d" reverse="1" />');
        if checkbox9.Checked then if ab.d10r>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+rnear(ab.d10r)+'" type="10dr" reverse="1" />');
        if checkbox10.Checked then if ab.d15r>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+rnear(ab.d15r)+'" type="15dr" reverse="1" />');
        if checkbox7.Checked then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="20d" reverse="1" />');
        if checkbox8.Checked then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="25d" reverse="1" />');

      end;
    end;
  end;
  log.savetofile('C:\AF\\\1.1');
  trn.free; trkm.free; trn1.free; trkm1.free; log.free;
end;
end;



















procedure Calc_SPB2011mart;
  var i,n,m,x,z,km,kmz:integer;
  var rt,ro:real;
  var kmt,kmt0,s:string;
  var lim:boolean;
  var trn,trkm,log:AF_Types.TStrings;
begin
with form1 do begin
  trn.create; trkm.create; log.create;
  for m:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,m]:=trim(ansilowercase(stringgrid1.Cells[4,m]));
    stringgrid1.Cells[5,m]:=trim(ansilowercase(stringgrid1.Cells[5,m]));
  end;
   for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        kmz:=strtointe(stringgrid1.Cells[3,i]);
        kmt:='###';
        kmt0:='###';
        trn.clear;
        trkm.clear;
        rt:=0;
        ro:=0;
        lim:=true;
        for x:=i to n do begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,i]) then begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,n]) then begin
            if stringgrid1.Cells[4,x]<>kmt then begin
              if kmt='###' then begin
                kmt:=stringgrid1.Cells[4,x];
                kmz:=strtointe(stringgrid1.Cells[3,x]);
              end
               else begin
                 km:=strtointe(stringgrid1.Cells[3,x-1])-kmz;
                 if km>0 then begin
                 trn.add(kmt);
                 trkm.add(inttostr(km));
                 end;
                 kmz:=strtointe(stringgrid1.Cells[3,x-1]);
                 kmt0:=kmt;
                 kmt:=stringgrid1.Cells[4,x];
               end;
            end
          end;
          end;
        end;
        if kmt<>'###' then begin
          km:=strtointe(stringgrid1.Cells[3,n])-kmz;
          if km>0 then begin
          trn.add(kmt);
          trkm.add(inttostr(km));
          end;
        end;
        if trn.count>0 then begin
          if trn.count=1 then lim:=true
                         else lim:=false;
          rt:=0;
          ro:=0;
          log.add('');
          log.add(stringgrid1.Cells[1,i]+' - '+stringgrid1.Cells[1,n]);
          s:='';
          for x:=1 to trn.count do begin
            s:=s+trkm.getstring(x)+' ';
            rt:=rt+vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
          end;
          for x:=trn.count downto 1 do begin
            ro:=ro+vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
          end;
        end;
        SetRoundMode(rmNearest);
        rt:=round(rt*10) / 10;
        ro:=round(ro*10) / 10;
        if checkbox1.checked then begin
         if ((stringgrid1.Cells[0,i]<>'0')and(stringgrid1.Cells[0,n]<>'0')) then begin
          WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt)+' ('+inttostr(trn.count)+') '+s);
          WriteLn(tf1,stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro)+' ('+inttostr(trn.count)+') '+s);
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt)+'" type="etrain" reverse="0" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro)+'" type="etrain" reverse="0" />');
         end;
        end;
      end;
    end;
  end;
//  log.savetofile('c:\46\1.1');
  trn.free; trkm.free; log.free;
end;
end;




procedure Calc_SPB2011f;
  var i,n,m,x,z,km,kmz:integer;
  var rt,ro:real;
  var kmt,kmt0:string;
  var lim:boolean;
  var trn,trkm:AF_Types.TStrings;
begin
with form1 do begin
  trn.create; trkm.create;
  for m:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,m]:=trim(ansilowercase(stringgrid1.Cells[4,m]));
    stringgrid1.Cells[5,m]:=trim(ansilowercase(stringgrid1.Cells[5,m]));
  end;
   for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        kmz:=strtointe(stringgrid1.Cells[3,i]);
        kmt:='###';
        kmt0:='###';
        trn.clear;
        trkm.clear;
        rt:=0;
        ro:=0;
        lim:=true;
        for x:=i to n do begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,i]) then begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,n]) then begin
            if stringgrid1.Cells[4,x]<>kmt then begin
              if kmt='###' then begin
                kmt:=stringgrid1.Cells[4,x];
                kmz:=strtointe(stringgrid1.Cells[3,x]);
              end
               else begin
                 km:=strtointe(stringgrid1.Cells[3,x-1])-kmz;
                 trn.add(kmt);
                 trkm.add(inttostr(km));
                 kmz:=strtointe(stringgrid1.Cells[3,x-1]);
                 kmt0:=kmt;
                 kmt:=stringgrid1.Cells[4,x];
               end;
            end
          end;
          end;
        end;
        if kmt<>'###' then begin
          km:=strtointe(stringgrid1.Cells[3,n])-kmz;
          trn.add(kmt);
          trkm.add(inttostr(km));
        end;
        if trn.count>0 then begin
          lim:=true;
          rt:=0;
          ro:=0;
          for x:=1 to trn.count do begin
            rt:=rt+vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            lim:=false;
          end;
          lim:=true;
          for x:=trn.count downto 1 do begin
            if ansilowercase(trn.getstring(x))='spb' then if x>1 then lim:=false;
            if x=1 then begin
             if trn.count>1 then begin
               if strtointe(trkm.getstring(x+1))<14 then
                     if strtointe(trkm.getstring(x))<20 then lim:=true;
             end;
            end;
            ro:=ro+vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            lim:=false;
          end;
        end;
        SetRoundMode(rmNearest);
        rt:=round(rt*10) / 10;
        ro:=round(ro*10) / 10;
        if checkbox1.checked then begin
          WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt));
          WriteLn(tf1,stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro));
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt)+'" type="etrain" reverse="0" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro)+'" type="etrain" reverse="0" />');
        end;
      end;
    end;
  end;
  trn.free; trkm.free;
end;
end;

procedure Calc_MSK2010ab;
  var i,n,m,xt:integer;
  var km,t,km0,km1,km2,r,qq1,qq2,qq0:real;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        km:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        xt:=0;
        if length(trim(stringgrid1.Cells[6,i]))>1 then
         if trim(stringgrid1.Cells[6,i])=trim(stringgrid1.Cells[6,n]) then xt:=1;
        if km<21 then begin
          if xt=1 then begin
            if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          end
           else begin
            if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
           end;
        end
         else begin
           if trim(stringgrid1.Cells[4,i])=trim(stringgrid1.Cells[4,n]) then begin
            if xt=1 then begin

              if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            end
             else begin
              if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
             end;
           end
            else begin
              km0:=0;
              for m:=i+1 to n do begin
                if ((stringgrid1.cells[4,m]=stringgrid1.Cells[4,n])and(stringgrid1.cells[4,m-1]=stringgrid1.Cells[4,i])and(CompareDirections(stringgrid1.cells[2,i],stringgrid1.cells[2,m]))) then begin
                   km0:=strtofloat(trim(stringgrid1.cells[3,m-1]));
                   break;
                end;
              end;
              if km0>0 then begin
               km1:=abs(km0-strtofloat(trim(stringgrid1.Cells[3,i])));
               km2:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-km0);
               if checkbox2.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox3.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox4.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox5.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox6.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox7.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox8.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              end;
            end;
         end;
      end;
    end;
  end;
end;
end;


procedure Calc_MSK2010ab3500_2010;
  var i,n,m,xt:integer;
  var km,t,km0,km1,km2,r,qq1,qq2,qq0:real;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        km:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        xt:=0;
        if length(trim(stringgrid1.Cells[6,i]))>1 then
         if trim(stringgrid1.Cells[6,i])=trim(stringgrid1.Cells[6,n]) then xt:=1;
        if km<21 then begin
          if xt=1 then begin
            if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox9.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'10DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox10.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'15DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox11.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'20DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox12.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'25DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox13.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'DATES',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          end
           else begin
            if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox9.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'10DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox10.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'15DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox11.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'20DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox12.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'25DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox13.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'DATES',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
           end;
        end
         else begin
           if trim(stringgrid1.Cells[4,i])=trim(stringgrid1.Cells[4,n]) then begin
            if xt=1 then begin
             if km>53 then begin
              if checkbox2.Checked then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="3700" type="1m" reverse="1" />');
             end
             else begin
              if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
             end;
              if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox9.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'10DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox10.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'15DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox11.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'20DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox12.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'25DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox13.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'DATES',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            end
             else begin
             if km>53 then begin
              if checkbox2.Checked then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="3700" type="1m" reverse="1" />');
             end
             else begin
              if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
             end;
              if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox9.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'10DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox10.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'15DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox11.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'20DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox12.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'25DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox13.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'DATES',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
             end;
           end
            else begin
              km0:=0;
              for m:=i+1 to n do begin
                if ((stringgrid1.cells[4,m]=stringgrid1.Cells[4,n])and(stringgrid1.cells[4,m-1]=stringgrid1.Cells[4,i])and(CompareDirections(stringgrid1.cells[2,i],stringgrid1.cells[2,m]))) then begin
                   km0:=strtofloat(trim(stringgrid1.cells[3,m-1]));
                   break;
                end;
              end;
              if km0>0 then begin
               km1:=abs(km0-strtofloat(trim(stringgrid1.Cells[3,i])));
               km2:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-km0);
               if km>53 then begin
                if checkbox2.Checked then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="3700" type="1m" reverse="1" />');
               end
               else begin
                if checkbox2.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               end;
               if checkbox3.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox4.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox5.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox6.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox7.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox8.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              end;
            end;
         end;
      end;
    end;
  end;
end;
end;
*)


procedure Calc_MSKab3500_072014;
  var i,n,m,xt,zon:integer;
  var km,km0,km1,km2:real;
begin
msklogflag:=true;
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        km:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        xt:=0;
        zon:=0;
         if ((validstr(stringgrid1.Cells[7,n]))and(validstr(stringgrid1.Cells[7,i]))) then zon:=round(abs(strtofloat(trim(stringgrid1.Cells[7,n]))-strtofloat(trim(stringgrid1.Cells[7,i]))));
        if length(trim(stringgrid1.Cells[6,i]))>1 then
         if trim(stringgrid1.Cells[6,i])=trim(stringgrid1.Cells[6,n]) then xt:=1;
        if km<21 then begin
          if xt=1 then begin
            if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[6,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
            if checkbox15.Checked then WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[6,i],'3M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
            if checkbox16.Checked then WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[6,i],'12M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
            if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[6,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
            if checkbox17.Checked then WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[6,i],'3MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
          end
           else begin
            if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
            if checkbox15.Checked then WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[4,i],'3M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
            if checkbox16.Checked then WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[4,i],'12M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
            if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
            if checkbox17.Checked then WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[4,i],'3MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
           end;
        end
         else begin
           if trim(stringgrid1.Cells[4,i])=trim(stringgrid1.Cells[4,n]) then begin
            if xt=1 then begin
               if checkbox2.Checked then begin
                          WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[6,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
               end;
               if checkbox15.Checked then begin
                          WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[6,i],'3M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
               end;
               if checkbox16.Checked then begin
                          WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[6,i],'12M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
               end;
               if checkbox3.Checked then begin
                          WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[6,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
               end;
               if checkbox17.Checked then begin
                          WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[6,i],'3MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
               end;
            end
             else begin
               if checkbox2.Checked then begin
                          WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
               end;
               if checkbox2.Checked then begin
                          WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[4,i],'3M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
               end;
               if checkbox2.Checked then begin
                          WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[4,i],'12M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
               end;
               if checkbox3.Checked then begin
                          WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
               end;
               if checkbox3.Checked then begin
                          WriteLn(tf,CalcMonoTarif_MSK072014km(km,stringgrid1.Cells[4,i],'3MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
               end;
             end;
           end
            else begin
              km0:=0;
              for m:=i+1 to n do begin
                if ((stringgrid1.cells[4,m]=stringgrid1.Cells[4,n])and(stringgrid1.cells[4,m-1]=stringgrid1.Cells[4,i])and(CompareDirections(stringgrid1.cells[2,i],stringgrid1.cells[2,m]))) then begin
                   km0:=strtofloat(trim(stringgrid1.cells[3,m-1]));
                   break;
                end;
              end;
              if km0>0 then begin
               km1:=abs(km0-strtofloat(trim(stringgrid1.Cells[3,i])));
               km2:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-km0);
               if checkbox2.Checked then begin
                          WriteLn(tf,CalcDualTarif_MSK072014km(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
               end;
               if checkbox2.Checked then begin
                          WriteLn(tf,CalcDualTarif_MSK072014km(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'3M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
               end;
               if checkbox2.Checked then begin
                          WriteLn(tf,CalcDualTarif_MSK072014km(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'12M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
               end;
               if checkbox3.Checked then begin
                          WriteLn(tf,CalcDualTarif_MSK072014km(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
               end;
               if checkbox3.Checked then begin
                          WriteLn(tf,CalcDualTarif_MSK072014km(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'3MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],zon));
               end;
              end;
            end;
         end;
      end;
    end;
  end;
end;
end;




(*
procedure Calc_MOKT2014;
  var i,n,m,xt:integer;
  var km,t,km0,km1,km2,r,qq1,qq2,qq0:real;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
    stringgrid1.Cells[6,i]:=trim(ansilowercase(stringgrid1.Cells[6,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        km:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        xt:=0;
        if length(trim(stringgrid1.Cells[6,i]))>1 then begin
          if trim(stringgrid1.Cells[6,i])=trim(stringgrid1.Cells[6,n]) then xt:=1;
        end;
         if xt=1 then begin
              if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox9.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'10DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox10.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'15DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox11.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'20DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox12.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'25DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox13.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'DATES',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
         end
         else begin
           if trim(stringgrid1.Cells[4,i])=trim(stringgrid1.Cells[4,n]) then begin
              if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox9.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'10DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox10.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'15DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox11.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'20DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox12.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'25DR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox13.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'DATES',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          end
            else begin
              km0:=0;
              for m:=i+1 to n do begin
                if ((stringgrid1.cells[4,m]=stringgrid1.Cells[4,n])and(stringgrid1.cells[4,m-1]=stringgrid1.Cells[4,i])and(CompareDirections(stringgrid1.cells[2,i],stringgrid1.cells[2,m]))) then begin
                   km0:=strtofloat(trim(stringgrid1.cells[3,m-1]));
                   break;
                end;
              end;
              if km0>0 then begin
               km1:=abs(km0-strtofloat(trim(stringgrid1.Cells[3,i])));
               km2:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-km0);
               if checkbox2.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox3.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox4.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox5.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox6.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox7.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox8.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              end;
            end;
         end;
      end;
    end;
  end;
end;
end;


procedure Calc_MSKabskv;
  var i,n,m,xt:integer;
  var km,t,km0,km1,km2,r,qq1,qq2,qq0:real;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if not CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        km:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        xt:=0;
        if length(trim(stringgrid1.Cells[5,i]))>1 then
         if trim(stringgrid1.Cells[5,i])=trim(stringgrid1.Cells[5,n]) then xt:=1;
        if km<21 then begin
          if xt=1 then begin
            if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          end
           else begin
            if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
           end;
        end
         else begin
           if trim(stringgrid1.Cells[4,i])=trim(stringgrid1.Cells[4,n]) then begin
            if xt=1 then begin
              if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            end
             else begin
              if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
             end;
           end;
         end;
      end;
    end;
  end;
end;
end;



procedure Calc_Samara;
  var tn,tp:AF_Types.TStrings;
  var i,n,m,zone1:integer;
  var zone,km,t,km1,km2,r:real;
  var x1,x2:string;
begin
with form1 do begin
  tn.create;
  tp.create;
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;

  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        x1:=trim(ansilowercase(stringgrid1.Cells[4,n]));
        x2:=trim(ansilowercase(stringgrid1.Cells[4,i]));
        zone:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        zone1:=trunc(zone);
        t:=0;
          case zone1 of
            0: t:=10;
            1: t:=10;
            2: t:=10;
            3: t:=17;
            4: t:=23;
            5: t:=29;
            6: t:=35;
            7: t:=41;
            8: t:=48;
            9: t:=58;
            10: t:=67;
            11: t:=75;
            12: t:=83;
            13: t:=97;
            14: t:=106;
            15: t:=112;
            16: t:=120;
            17: t:=128;
            18: t:=136;
            19: t:=144;
            20: t:=152;
            21: t:=160;
            22: t:=168;
            23: t:=176;
            24: t:=184;
            25: t:=192;
          end;

          if (x1='samara_g') and (x2='samara_g') then begin
            t:=10;
          end;

          if (x1='oktabrsk') and (x2='oktabrsk') then begin
            t:=12;
          end;

          if (x1='orenburg') and (x2='orenburg') then begin
            case zone1 of
              0: t:=8;
              1: t:=8;
              2: t:=16;
              3: t:=24;
              4: t:=32;
              5: t:=40;
              6: t:=48;
              7: t:=56;
              8: t:=64;
              9: t:=72;
              10: t:=80;
              11: t:=88;
              12: t:=96;
              13: t:=104;
              14: t:=112;
              15: t:=120;
              16: t:=128;
            end;
         end;

          stringgrid1.Cells[i+5,n]:='f_'+floattostr(t);
          if t>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t)+'" type="etrain" reverse="1" />');
      end;
    end;
  end;
  tp.free;
  tn.free;
end;
end;
*)

{function PosSchCol(s:string):integer;
  var i:integer;
  var res:boolean;
begin
  res:=false;
  for i:=1 to form1.StringGrid2.ColCount-1 do begin
    if form1.StringGrid2.cells[i,0]=s then begin
      res:=true;
      break;
    end;
  end;
  if res then result:=i
         else result:=0;
end;

function PosSchRow(s:string):integer;
  var i:integer;
  var res:boolean;
begin
  res:=false;
  for i:=1 to form1.StringGrid2.RowCount-1 do begin
    if form1.StringGrid2.cells[0,i]=s then begin
      res:=true;
      break;
    end;
  end;
  if res then result:=i
         else result:=0;
end;
}
(*
procedure Calc_SamaraScheme;
  var tn,tp:AF_Types.TStrings;
  var i,n,m,zone1,v1,v2:integer;
  var zone,km,t,km1,km2,r:real;
  var x1,x2,z1,z2:string;
begin
with form1 do begin
if Opendialog2.Execute then begin
  LoadFromXLS(OpenDialog2.FileName,StringGrid2);
  tn.create;
  tp.create;
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;

  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        x1:=trim(ansilowercase(stringgrid1.Cells[4,n]));
        x2:=trim(ansilowercase(stringgrid1.Cells[4,i]));
        z1:=trim(ansilowercase(stringgrid1.Cells[3,i]));
        z2:=trim(ansilowercase(stringgrid1.Cells[3,n]));
        v1:=PosSchCol(z1);
        v2:=PosSchRow(z2);
        t:=0;
        if (v1>0) and (v2>0) then begin
          t:=strtofloat(stringgrid2.Cells[v1,v2]);
          if stringgrid1.Cells[5,i]=stringgrid1.Cells[5,n] then
           if stringgrid1.Cells[5,i]='samara_g' then t:=13;
          stringgrid1.Cells[i+5,n]:='f_'+floattostr(t);
          if t>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t)+'" type="etrain" reverse="1" insearch="1" />');
          end;
      end;
    end;
  end;
  tp.free;
  tn.free;
end;
end;
end;
*)



procedure Calc_MSKSKV;
  var tn,tp:AF_Types.TStrings;
  var i,n:integer;
  var zone,t,r,msk_gorod,rcppk:real;
  var nz,stat1,stat2:string;
begin
msklogflag:=true;
with form1 do begin
  tn.create;
  tp.create;
  zone:=GetZoneTariff('MSK',1);
  msk_gorod:=GetZoneTariff('MSK_GOROD',1);
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[0,i]:=trim(ansilowercase(stringgrid1.Cells[0,i]));
    stringgrid1.Cells[3,i]:=trim(ansilowercase(stringgrid1.Cells[3,i]));
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
  end;

  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    nz:=stringgrid1.Cells[3,i];
    t:=0;
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if nz<>stringgrid1.Cells[3,n] then begin
          t:=t+zone;
          nz:=stringgrid1.Cells[3,n];
      end;
      if not CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
          r:=t;
          if r=0 then r:=zone;
          if ( ( (stringgrid1.Cells[4,n]='msk_gorod') or (stringgrid1.Cells[4,n]='mcd_gorod'))and(stringgrid1.Cells[4,i]='msk_gorod')) then r:=msk_gorod;
          stringgrid1.Cells[i+5,n]:='f_'+floattostr(r);
          if ((length(stringgrid1.Cells[0,n])>0)and(length(stringgrid1.Cells[0,i])>0)) then begin
//                    WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(r)+'" type="etrain" reverse="1" />');
            stat1:=stringgrid1.Cells[0,i];
            stat2:=stringgrid1.Cells[0,n];
            if CheckBox21.Checked then begin
             if GetCPPKTariffMySQL(stat1,stat2,'etrain',rcppk) then begin
               if rcppk>0 then begin
                 if rcppk<>r then begin
                  msk3500log.add(GetCPPKstnameBYesr(stat1)+' ('+stat1+') - '+GetCPPKstnameBYesr(stat2)+' ('+stat2+') - etrain :   - '+FloatToStr(r)+',     - '+FloatToStr(rcppk)+',    ');
                  if rcppk>=0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rcppk)+'" type="etrain" reverse="1" cppkbase="1" />');
                 end
                  else begin
                    if r>=0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(r)+'" type="etrain" reverse="1" />');
                  end;
               end
                else begin
                  msk3500log.add(GetCPPKstnameBYesr(stat1)+' ('+stat1+') - '+GetCPPKstnameBYesr(stat2)+' ('+stat2+') - etrain :      ,  ');
                  if r>=0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="etrain" reverse="1" />');
                end;
             end
              else begin
                msk3500log.add(GetCPPKstnameBYesr(stat1)+' ('+stat1+') - '+GetCPPKstnameBYesr(stat2)+' ('+stat2+') - etrain :      ,  ');
                if r>=0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="etrain" reverse="1" />');
              end;
            end
             else begin
              if r>=0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(r)+'" type="etrain" reverse="1" />');
             end;
          end;
      end;
    end;
  end;
  tp.free;
  tn.free;
end;
end;


procedure Calc_Table(lg:boolean;cppk:boolean;child:TChildMode);
  var i,n,ch1,ch2:integer;
  var x1,ins,tks,tcu:string;
  var tar:real;
  var ch:extended;
  var tarlist:TAbTarifList;
  var tarres:boolean;
  var reverse_str:string;
begin
if cppk then msklogflag:=true;
with form1 do begin
  tks:='';
  tcu:='';
  x1:='qqq';
  reverse_str :=  ' reverse="1" ';
  stringgrid1.Cells[1,1]:=trim(ansilowercase(stringgrid1.Cells[1,1]));
  ins:='1';
  if stringgrid1.Cells[1,1]='etrain' then begin x1:='etrain'; ins:='1'; end;
  if stringgrid1.Cells[1,1]='beznal' then begin x1:='beznal'; ins:='1'; end;
  if stringgrid1.Cells[1,1]='child' then begin x1:='child'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='animal' then begin x1:='animal'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='handbag' then begin x1:='handbag'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='velzh' then begin x1:='velzh'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='express' then begin x1:='express'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last' then begin x1:='last'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last_child' then begin x1:='last_child'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last_reduced' then begin x1:='last_reduced'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='snezhinka' then begin x1:='snezhinka'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='krskles' then begin x1:='krskles'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='aeroexpress' then begin x1:='aeroexpress'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='aerovl' then begin x1:='aero0'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='cityetrain' then begin x1:='cityetrain'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='city' then begin x1:='city'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='nnmet' then begin x1:='nnmet'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='nnprio' then begin x1:='nnprio'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='nnmgor' then begin x1:='nnmgor'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='kievcity' then begin x1:='city'; ins:='0'; tcu:=' currency="UAH"'; end;
  if stringgrid1.Cells[1,1]='kzhit' then begin x1:='etrainkzhit'; ins:='0'; tcu:=' currency="UAH"'; end;
  if stringgrid1.Cells[1,1]='tcdd2s' then begin x1:='tcdd2s'; ins:='1'; tks:='tk'; tcu:=' currency="TRY"'; end;
  if stringgrid1.Cells[1,1]='tcddyht' then begin x1:='tcddyht'; ins:='1'; tks:='tk'; tcu:=' currency="TRY"'; end;
  if pos('express_',stringgrid1.Cells[1,1])=1 then begin x1:=trim(stringgrid1.Cells[1,1]); ins:='0'; end;
  if stringgrid1.Cells[1,1]='bigmsk1m' then begin x1:='bigmsk1m'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='bigmsk1m_velo' then begin x1:='bigmsk1m_velo'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='express1m' then begin x1:='e1m'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last1m' then begin x1:='last1m'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last3m' then begin x1:='last3m'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last12m' then begin x1:='last12m'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='express1m_lobnya' then begin x1:='e1m_lob'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='express1m_dmitrov' then begin x1:='e1m_dm'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='express1mr' then begin x1:='e1mr'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last1mr' then begin x1:='last1mr'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last3mr' then begin x1:='last3mr'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last12mr' then begin x1:='last12mr'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='express1mr_lobnya' then begin x1:='e1mr_lob'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='express1mr_dmitrov' then begin x1:='e1mr_dm'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='express5d' then begin x1:='e5d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last5d' then begin x1:='last5d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last10d' then begin x1:='last10d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last15d' then begin x1:='last15d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last10dr' then begin x1:='last10dr'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last15dr' then begin x1:='last15dr'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last10p' then begin x1:='last10p'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last20p' then begin x1:='last20p'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last60p' then begin x1:='last60p'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last90p' then begin x1:='last90p'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='10p' then begin x1:='10p'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='20p' then begin x1:='20p'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='60p' then begin x1:='60p'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='90p' then begin x1:='90p'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='e10p' then begin x1:='e10p'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='e20p' then begin x1:='e20p'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='e60p' then begin x1:='e60p'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='e90p' then begin x1:='e90p'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1m' then begin x1:='1m'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mr' then begin x1:='1mr'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mrmeln' then begin x1:='1mrmeln'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='5d' then begin x1:='5d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='5dmeln' then begin x1:='5dmeln'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='10d' then begin x1:='10d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='15d' then begin x1:='15d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='20d' then begin x1:='20d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='25d' then begin x1:='25d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='megapolisp' then begin x1:='megapolisp'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='nearcity' then begin x1:='nearcity'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='aeroexpress' then begin x1:='aeroexpress'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='aeroexpress_insearch' then begin x1:='express'; ins:='1'; end;
  if stringgrid1.Cells[1,1]='aeroexpress_i' then begin x1:='aeroexpress_i'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='aeroexpress_b' then begin x1:='aeroexpress_b'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='aeroexpress_s' then begin x1:='aeroexpress_s'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='aeroexpress_twin' then begin x1:='aeroexpress_twin'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='aeroexpress_before' then begin x1:='aeroexpress_before'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='samaero_2class' then begin x1:='samaero_2class'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='samaero_3class' then begin x1:='samaero_3class'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='samaero_2child' then begin x1:='samaero_2child'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='samaero_3child' then begin x1:='samaero_3child'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mpushk' then begin x1:='1mpushk'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mrpushk' then begin x1:='1mrpushk'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1msamson' then begin x1:='1msamson'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mrsamson' then begin x1:='1mrsamson'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mnpp' then begin x1:='1mnpp'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mrnpp' then begin x1:='1mrnpp'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mvygodny' then begin x1:='1mvygodny'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mrvygodny' then begin x1:='1mrvygodny'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mkolpino' then begin x1:='1mkolpino'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mtosno' then begin x1:='1mtosno'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mrkolpino' then begin x1:='1mrkolpino'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mrtosno' then begin x1:='1mrtosno'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mkolpinolast' then begin x1:='1mkolpinolast'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mtosnolast' then begin x1:='1mtosnolast'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='ekb_sp1' then begin x1:='ekb_sp1'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='ekb_sp2' then begin x1:='ekb_sp2'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='ekb_sp3' then begin x1:='ekb_sp3'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='rostov_sp1' then begin x1:='rostov_sp1'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='rostov_sp2' then begin x1:='rostov_sp2'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mcd' then begin x1:='mcd'; ins:='0'; end;
   if stringgrid1.Cells[1,1]='arkhangelsk_sp1' then begin x1:='arkhangelsk_sp1'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='ikt_sp1' then begin x1:='ikt_sp1'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='ikt_sp2' then begin x1:='ikt_sp2'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='ikt_sp3' then begin x1:='ikt_sp3'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='ikt_sp4' then begin x1:='ikt_sp4'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='ikt_sp5' then begin x1:='ikt_sp5'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='sestrcw' then begin x1:='sestrcw'; ins:='0'; reverse_str :=  ' reverse="0" '; end;
  if stringgrid1.Cells[1,1]='sestrccw' then begin x1:='sestrccw'; ins:='0'; reverse_str :=  ' reverse="0" '; end;
  if stringgrid1.Cells[1,1]='sppk_sp' then begin x1:='sppk_sp'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='ufa_g' then begin x1:='ufa_g'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='ekbsh' then begin x1:='ekbsh'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='kazan2' then begin x1:='kazan2'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='kdz' then begin x1:='kdz'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='legural' then begin x1:='legural'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='etrainkhb' then begin x1:='etrainkhb'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last5dat' then begin x1:='last5dat'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last6dat' then begin x1:='last6dat'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last7dat' then begin x1:='last7dat'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last8dat' then begin x1:='last8dat'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last9dat' then begin x1:='last9dat'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last10dat' then begin x1:='last10dat'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last11dat' then begin x1:='last11dat'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last12dat' then begin x1:='last12dat'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last13dat' then begin x1:='last13dat'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last14dat' then begin x1:='last14dat'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last15dat' then begin x1:='last15dat'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='last16dat' then begin x1:='last16dat'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='lastvyhdn' then begin x1:='lastvyhdn'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mmtr' then begin x1:='mmtr'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mm90tr' then begin x1:='mm90tr'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mme2' then begin x1:='mme2'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mme20' then begin x1:='mme20'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mme40' then begin x1:='mme40'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mme60' then begin x1:='mme60'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mmb1' then begin x1:='mmb1'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mmb3' then begin x1:='mmb3'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mmb7' then begin x1:='mmb7'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mmb30' then begin x1:='mmb30'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mmb90' then begin x1:='mmb90'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mmb365' then begin x1:='mmb365'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mm90k1' then begin x1:='mm90k1'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mm90k2' then begin x1:='mm90k2'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mm90k60' then begin x1:='mm90k60'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mmtdom' then begin x1:='mmtdom'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mmtdom1m' then begin x1:='mmtdom1m'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mmtexdom' then begin x1:='mmtexdom'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mmtexdom1m' then begin x1:='mmtexdom1m'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mmtexpush' then begin x1:='mmtexpush'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mmtexpush1m' then begin x1:='mmtexpush1m'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mmtpush' then begin x1:='mmtpush'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mmtpush1m' then begin x1:='mmtpush1m'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='mixdom1m' then begin x1:='mixdom1m'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mvgatch' then begin x1:='1mvgatch'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mvgatchlast' then begin x1:='1mvgatchlast'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='5dnpp' then begin x1:='5dnpp'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='5datnovg' then begin x1:='5datnovg'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='6datnovg' then begin x1:='6datnovg'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='7datnovg' then begin x1:='7datnovg'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='8datnovg' then begin x1:='8datnovg'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='9datnovg' then begin x1:='9datnovg'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='10datnovg' then begin x1:='10datnovg'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='11datnovg' then begin x1:='11datnovg'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='12datnovg' then begin x1:='12datnovg'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='13datnovg' then begin x1:='13datnovg'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='14datnovg' then begin x1:='14datnovg'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='15datnovg' then begin x1:='15datnovg'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='16datnovg' then begin x1:='16datnovg'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='dachny' then begin x1:='dachny'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='dachny_last' then begin x1:='dachny_last'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='5dkurort' then begin x1:='5dkurort'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mrkurort' then begin x1:='1mrkurort'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='shrgsh1' then begin x1:='shrgsh1'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='shrgsh3' then begin x1:='shrgsh3'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='sunvalley' then begin x1:='sunvalley'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='lubogor' then begin x1:='lubogor'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='turbudnovg' then begin x1:='turbudnovg'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='impr' then begin x1:='impr'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='impr1' then begin x1:='impr1'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='uglski' then begin x1:='uglski'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='udm_sp' then begin x1:='udm_sp'; ins:='0'; end;
 if stringgrid1.Cells[1,1]='1mr_priv' then begin x1:='1mr_priv'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='5den_priv' then begin x1:='5den_priv'; ins:='0'; end;

  if stringgrid1.Cells[1,1]='krskm_sp' then begin x1:='krskm_sp'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='krskm_child' then begin x1:='krskm_child'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='krskm_animal' then begin x1:='krskm_animal'; ins:='0'; end;
  

  if x1='qqq' then ShowMessage(',   !');
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[0,i]:=trim(ansilowercase(stringgrid1.Cells[0,i]));
  end;
  for i:=2 to stringgrid1.colcount-1 do begin
    stringgrid1.Cells[i,0]:=trim(ansilowercase(stringgrid1.Cells[i,0]));
    for n:=2 to stringgrid1.rowcount-1 do begin
      if ((length(stringgrid1.Cells[0,n])>0)and(length(stringgrid1.Cells[i,0])>0)and(length(stringgrid1.Cells[i,n])>0)and(x1<>'qqq')) then begin
       if cppk then begin
        if x1='etrain' then begin
           tar:=strtofloat(trim(stringgrid1.Cells[i,n]));
           tarres:=GetCPPKTariffMySQLAll(stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],tarlist);
           comparecppktzone1(stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'etrain',tarlist,tarres,tar,false);
           if tarlist.etrain>0 then tar:=tarlist.etrain;
           WriteLn(tf,'  <tarif station1="'+tks+stringgrid1.Cells[i,0]+'" station2="'+tks+stringgrid1.Cells[0,n]+'" price="'+floattostr(tar)+'" type="'+x1+'" reverse="1" insearch="'+ins+'"'+tcu+'/>');
            if tar>0 then begin

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'reduced') then begin
             {if tarlist.child>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.reduced)+'" type="reduced" reverse="1" />');
         end
          else begin
         //   msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - child :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="reduced" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'child') then begin
             {if tarlist.child>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.child)+'" type="child" reverse="1" />');
         end
          else begin
         //   msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - child :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="child" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'animal') then begin
             {if tarlist.animal>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.animal)+'" type="animal" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - animal :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="animal" reverse="1" />');
          end;
         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'beznal') then begin
             {if tarlist.animal>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.beznal)+'" type="beznal" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - animal :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="beznal" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'handbag') then begin
             {if tarlist.handbag>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.handbag)+'" type="handbag" reverse="1" />');
         end
          else begin
         //   msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - handbag :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="handbag" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'velzh') then begin
             {if tarlist.velzh>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.velzh)+'" type="velzh" reverse="1" />');
         end
          else begin
         //   msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - velzh :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="velzh" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1m') then begin
             {if tarlist.m1>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m1)+'" type="1m" reverse="1" />');
         end
          else begin
           // msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 1m :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="1m" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'3m') then begin
             {if tarlist.m3>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m3)+'" type="3m" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 3m :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="3m" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'12m') then begin
             {if tarlist.m12>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m12)+'" type="12m" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 12m :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="12m" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1mr') then begin
             {if tarlist.m1r>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m1r)+'" type="1mr" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 1mr :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="1mr" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'3mr') then begin
             {if tarlist.m3r>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m3r)+'" type="3mr" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 3mr :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="3mr" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'10d') then begin
             {if tarlist.d10>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.d10)+'" type="10d" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 10d :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="10d" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'5dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat5)+'" type="5dat" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 5dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="5dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'6dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat6)+'" type="6dat" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 6dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="6dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'7dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat7)+'" type="7dat" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 7dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="7dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'8dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat8)+'" type="8dat" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 8dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="8dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'9dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat9)+'" type="9dat" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 9dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="9dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'10dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat10)+'" type="10dat" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 10dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="10dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'11dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat11)+'" type="11dat" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 11dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="11dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'12dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat12)+'" type="12dat" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 12dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="12dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'13dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat13)+'" type="13dat" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 13dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="13dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'14dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat14)+'" type="14dat" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 14dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="14dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'15dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat15)+'" type="15dat" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 15dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="15dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'16dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat16)+'" type="16dat" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 16dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="16dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'vyhdn') then begin
             {if tarlist.vyhdn>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.vyhdn)+'" type="vyhdn" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - vyhdn :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="vyhdn" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'10p') then begin
             {if tarlist.p10>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.p10)+'" type="10p" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 10p :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="10p" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'20p') then begin
             {if tarlist.p20>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.p20)+'" type="20p" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 20p :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="20p" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'60p') then begin
             {if tarlist.p60>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.p60)+'" type="60p" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 60p :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="60p" reverse="1" />');
          end;
         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'uglski') then begin
             {if tarlist.uglski>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.uglski)+'" type="uglski" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 60p :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="uglski" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'krskm_sp') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.krskm_sp)+'" type="krskm_sp" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="krskm_sp" reverse="1" />');
          end;
         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'krskm_child') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.krskm_child)+'" type="krskm_child" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="krskm_child" reverse="1" />');
          end;
          if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'krskm_animal') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.krskm_animal)+'" type="krskm_animal" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="krskm_animal" reverse="1" />');
          end;
          
         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'udm_sp') then begin
             {if tarlist.uglski>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.udm_sp)+'" type="udm_sp" reverse="1" />');
         end
          else begin
          //  msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 60p :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="udm_sp" reverse="1" />');
          end;

          {
             if tarlist.m1>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[i,0]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m1)+'" type="1m" reverse="1" />');
             if tarlist.m3>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[i,0]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m3)+'" type="3m" reverse="1" />');
             if tarlist.m12>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[i,0]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m12)+'" type="12m" reverse="1" />');
             if tarlist.m1r>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[i,0]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m1r)+'" type="1mr" reverse="1" />');
             if tarlist.m3r>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[i,0]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m3r)+'" type="3mr" reverse="1" />');
             if tarlist.d10>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[i,0]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.d10)+'" type="10d" reverse="1" />');
             if tarlist.vyhdn>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[i,0]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.vyhdn)+'" type="vyhdn" reverse="1" />');
             if tarlist.p10>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[i,0]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.p10)+'" type="10p" reverse="1" />');
             if tarlist.p20>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[i,0]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.p20)+'" type="20p" reverse="1" />');
             if tarlist.p60>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[i,0]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.p60)+'" type="60p" reverse="1" />'); }
            end;
         if ((lg)and(x1='etrain')) then begin
            WriteLn(tf,'  <tarif station1="'+tks+stringgrid1.Cells[i,0]+'" station2="'+tks+stringgrid1.Cells[0,n]+'" price="'+floattostr(tar/2)+'" type="reduced" reverse="1" insearch="'+ins+'"/>');
         end;
         if ((child<>chNone)and(x1='etrain')) then begin
           if child=chNormal then begin
            WriteLn(tf,'  <tarif station1="'+tks+stringgrid1.Cells[i,0]+'" station2="'+tks+stringgrid1.Cells[0,n]+'" price="'+floattostr(tar/4)+'" type="child" reverse="1" insearch="'+ins+'"/>');
           end;
           if child=chNN then begin
             ch1:=trunc(tar/4);
             ch2:=trunc(frac(tar/4)*10);
             ch:=0;
             if ch2>0 then begin
               if ch2<=5 then ch:=0.5
                         else ch:=1;
             end;
            WriteLn(tf,'  <tarif station1="'+tks+stringgrid1.Cells[i,0]+'" station2="'+tks+stringgrid1.Cells[0,n]+'" price="'+floattostr(ch+ch1)+'" type="child" reverse="1" insearch="'+ins+'"/>');
           end;
         end;
        end
         else begin
          ShowMessage(' cppktable     etrain!');
          Halt(13);
         end;
       end
        else begin
          WriteLn(tf,'  <tarif station1="'+tks+stringgrid1.Cells[i,0]+'" station2="'+tks+stringgrid1.Cells[0,n]+'" price="'+trim(stringgrid1.Cells[i,n])+'" type="'+x1+'" '+reverse_str+' insearch="'+ins+'"'+tcu+'/>');
          if ((lg)and(x1='etrain')) then begin
            WriteLn(tf,'  <tarif station1="'+tks+stringgrid1.Cells[i,0]+'" station2="'+tks+stringgrid1.Cells[0,n]+'" price="'+floattostr(strtofloat(trim(stringgrid1.Cells[i,n]))/2)+'" type="reduced" reverse="1" insearch="'+ins+'"/>');
          end;
          if ((child<>chNone)and(x1='etrain')) then begin
           if child=chNormal then begin
            WriteLn(tf,'  <tarif station1="'+tks+stringgrid1.Cells[i,0]+'" station2="'+tks+stringgrid1.Cells[0,n]+'" price="'+floattostr(strtofloat(trim(stringgrid1.Cells[i,n]))/4)+'" type="child" reverse="1" insearch="'+ins+'"/>');
           end;
           if child=chNN then begin
             ch1:=trunc(strtofloat(trim(stringgrid1.Cells[i,n]))/4);
             ch2:=trunc(frac(strtofloat(trim(stringgrid1.Cells[i,n]))/4)*10);
             ch:=0;
             if ch2>0 then begin
               if ch2<=5 then ch:=0.5
                         else ch:=1;
             end;
            WriteLn(tf,'  <tarif station1="'+tks+stringgrid1.Cells[i,0]+'" station2="'+tks+stringgrid1.Cells[0,n]+'" price="'+floattostr(ch+ch1)+'" type="child" reverse="1" insearch="'+ins+'"/>');
           end;
         end;
         end;
      end;
    end;
  end;
end;
end;

procedure Calc_Matrix;
  var i,n:integer;
  var x1,ins:string;
begin
with form1 do begin
  x1:='qqq';
  stringgrid1.Cells[1,1]:=trim(ansilowercase(stringgrid1.Cells[1,1]));
  ins:='1';
  if stringgrid1.Cells[1,1]='etrain' then begin x1:='etrain'; ins:='1'; end;
  if stringgrid1.Cells[1,1]='express' then begin x1:='express'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='aeroexpress' then begin x1:='aeroexpress'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='cityetrain' then begin x1:='cityetrain'; ins:='0'; end;
  if pos('express_',stringgrid1.Cells[1,1])=1 then begin x1:=trim(stringgrid1.Cells[1,1]); ins:='0'; end;
  if stringgrid1.Cells[1,1]='bigmsk1m' then begin x1:='bigmsk1m'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='bigmsk1m_velo' then begin x1:='bigmsk1m_velo'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='express1m' then begin x1:='e1m'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='express1mr' then begin x1:='e1mr'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1m' then begin x1:='1m'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mr' then begin x1:='1mr'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='5d' then begin x1:='5d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='10d' then begin x1:='10d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='15d' then begin x1:='15d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='20d' then begin x1:='20d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='25d' then begin x1:='25d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='megapolisp' then begin x1:='megapolisp'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='nearcity' then begin x1:='nearcity'; ins:='0'; end;
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[0,i]:=trim(ansilowercase(stringgrid1.Cells[0,i]));
  end;
  for i:=2 to stringgrid1.colcount-1 do begin
    stringgrid1.Cells[i,0]:=trim(ansilowercase(stringgrid1.Cells[i,0]));
    for n:=2 to stringgrid1.rowcount-1 do begin
      if ((length(stringgrid1.Cells[0,n])>0)and(length(stringgrid1.Cells[i,0])>0)and(length(stringgrid1.Cells[i,n])>0)and(x1<>'qqq')) then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[i,0]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+trim(stringgrid1.Cells[i,n])+'" type="'+x1+'" reverse="0" insearch="'+ins+'"/>');
    end;
  end;

end;
end;


procedure Calc_CPPKExpressTable(lg:boolean;cppk:boolean);
  var i,n:integer;
  var x1,ins,tks,tcu:string;
  var tar:real;
  var tarlist:TAbTarifList;
  var tarres:boolean;
begin
if cppk then msklogflag:=true;
with form1 do begin
  tks:='';
  tcu:='';
  x1:='qqq';
  stringgrid1.Cells[1,1]:=trim(ansilowercase(stringgrid1.Cells[1,1]));
  ins:='1';
  if stringgrid1.Cells[1,1]='express' then begin x1:='express'; ins:='0'; end;
  if x1='qqq' then ShowMessage(',   !');
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[0,i]:=trim(ansilowercase(stringgrid1.Cells[0,i]));
  end;
  for i:=2 to stringgrid1.colcount-1 do begin
    stringgrid1.Cells[i,0]:=trim(ansilowercase(stringgrid1.Cells[i,0]));
    for n:=2 to stringgrid1.rowcount-1 do begin
      if ((length(stringgrid1.Cells[0,n])>0)and(length(stringgrid1.Cells[i,0])>0)and(length(stringgrid1.Cells[i,n])>0)and(x1<>'qqq')) then begin
       if cppk then begin
        if x1='express' then begin
           tar:=strtofloat(trim(stringgrid1.Cells[i,n]));
           tarres:=GetCPPKTariffMySQLAllExpress(stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],tarlist);
           if tarlist.etrain<=0 then tarres:=GetCPPKTariffMySQLAllExpress(stringgrid1.Cells[0,n],stringgrid1.Cells[0,i],tarlist);
           comparecppktzone1(stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'etrain',tarlist,tarres,tar,true);
           if tarlist.etrain>0 then tar:=tarlist.etrain;
           WriteLn(tf,'  <tarif station1="'+tks+stringgrid1.Cells[i,0]+'" station2="'+tks+stringgrid1.Cells[0,n]+'" price="'+floattostr(tar)+'" type="'+x1+'" reverse="1" '+tcu+'/>');
//            if tar>0 then begin

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'child') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.child)+'" type="echild" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="echild" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1m') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m1)+'" type="e1m" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e1m" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'3m') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m3)+'" type="e3m" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e3m" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'12m') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m12)+'" type="e12m" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e12m" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1mr') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m1r)+'" type="e1mr" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e1mr" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'3mr') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m3r)+'" type="e3mr" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e3mr" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'5d') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.d5)+'" type="e5d" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e5d" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'10d') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.d10)+'" type="e10d" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e10d" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'5dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat5)+'" type="e5dat" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e5dat" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'6dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat6)+'" type="e6dat" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e6dat" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'7dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat7)+'" type="e7dat" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e7dat" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'8dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat8)+'" type="e8dat" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e8dat" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'9dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat9)+'" type="e9dat" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e9dat" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'10dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat10)+'" type="e10dat" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e10dat" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'11dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat11)+'" type="e11dat" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e11dat" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'12dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat12)+'" type="e12dat" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e12dat" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'13dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat13)+'" type="e13dat" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e13dat" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'14dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat14)+'" type="e14dat" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e14dat" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'15dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat15)+'" type="e15dat" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e15dat" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'16dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat16)+'" type="e16dat" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e16dat" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'10p') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.p10)+'" type="e10p" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e10p" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'20p') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.p20)+'" type="e20p" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e20p" reverse="1" />');
          end;

         if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'60p') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.p60)+'" type="e60p" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="e60p" reverse="1" />');
          end;

          if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'uglski') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.uglski)+'" type="uglski" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="uglski" reverse="1" />');
          end;

          if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'udm_sp') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.udm_sp)+'" type="udm_sp" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="udm_sp" reverse="1" />');
          end;

          if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'krskm_sp') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.krskm_sp)+'" type="krskm_sp" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="krskm_sp" reverse="1" />');
          end;

              if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'krskm_child') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.krskm_child)+'" type="krskm_child" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="krskm_child" reverse="1" />');
          end;

              if CheckAppDisableExpress(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'krskm_animal') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.krskm_animal)+'" type="krskm_animal" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="krskm_animal" reverse="1" />');
          end;

          //      end;
        end; //if express
       end //if cppk
        else begin
          showmessage('Error express!');
        end;
      end;
    end;
  end;
end;
end;



{
procedure Calc_PKTKTBL;
  var tn,tp:AF_Types.TStrings;
  var i,n,m,zone1:integer;
  var zone,km,t,km1,km2,r,msk_gorod:real;
  var x1,x2,nz,ins:string;
begin
with form1 do begin
 if stringgrid1.colcount>3 then begin
 if stringgrid1.rowcount>3 then begin
 if validstr(stringgrid1.Cells[1,0]) then begin
  for i:=0 to stringgrid1.colcount-1 do begin
   for n:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i,n]:=trim(ansilowercase(stringgrid1.Cells[i,n]));
   end;
  end;
  for i:=3 to stringgrid1.rowcount-1 do begin
    for n:=3 to stringgrid1.colcount-1 do begin
      if ((validstr(stringgrid1.Cells[0,i]))and(validstr(stringgrid1.Cells[n,1]))and(validstr(stringgrid1.Cells[n,i]))) then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[1,0]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+trim(stringgrid1.Cells[n,i])+'" type="'+stringgrid1.Cells[n,1]+'" reverse="1" insearch="0"/>');
    end;
  end;
 end;
 end;
end;
end;
end;
}
{
function Calc_NN_Internal(i,n:integer):real;
  var v,m,z1,z2:integer;
  var z,res:real;
begin
with form1 do begin
res:=0;
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        if StringGrid1.cells[4,i]=StringGrid1.cells[4,n] then begin
          // 1 
          z1:=abs(strtointe(StringGrid1.cells[3,n])-strtointe(StringGrid1.cells[3,i]));
          res:=GetZoneTariff(StringGrid1.cells[4,i],z1);
            if validstr(StringGrid1.cells[5,i]) then begin
              if StringGrid1.cells[5,i]=StringGrid1.cells[5,n] then begin
                res:=GetZoneTariff(StringGrid1.cells[5,i],0);
              end;
            end;
          // -1 
        end
         else begin
           // 2 
           for m:=i to n do begin
             if validstr(StringGrid1.cells[4,m]) then begin
             if StringGrid1.cells[4,m]<>StringGrid1.cells[4,i] then break;
             end;
           end;
           v:=m-1;
           while not CompareDirections(stringgrid1.Cells[2,v],stringgrid1.Cells[2,n]) do dec(v);
           z1:=abs(strtointe(StringGrid1.cells[3,v])-strtointe(StringGrid1.cells[3,i]))+1;
           z2:=abs(strtointe(StringGrid1.cells[3,n])-strtointe(StringGrid1.cells[3,m]));
           if z2>1 then res:=GetZoneTariff(StringGrid1.cells[4,i],z1)+GetZoneTariff(StringGrid1.cells[4,n],z2)
                   else res:=GetZoneTariff(StringGrid1.cells[4,i],z1);
           // -2 
         end;
      end;
result:=res;
end;
end;


procedure Calc_NN;
  var i,n:integer;
  var t:real;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     t:=Calc_NN_Internal(i,n);
     if t>0 then begin
       WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t)+'" type="etrain" reverse="1" />');
       WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t/2)+'" type="reduced" reverse="1" />');
     end;
    end;
  end;
end;
end;

function Calc_599_Internal(i,n:integer):real;
  var v,m,z1,z2:integer;
  var z,res:real;
begin
with form1 do begin
res:=0;
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        if StringGrid1.cells[4,i]=StringGrid1.cells[4,n] then begin
          // 1 
          z1:=abs(strtointe(StringGrid1.cells[3,n])-strtointe(StringGrid1.cells[3,i]));
          if z1<16 then res:=25;
          if z1 in [16..18] then res:=30;
          if z1 in [19..21] then res:=35;
          if z1 in [22..24] then res:=40;
          if z1 in [25..27] then res:=45;
          if z1 in [28..30] then res:=50;
          if z1 in [31..33] then res:=55;
          if z1 in [34..36] then res:=60;
          if z1 in [37..39] then res:=65;
          if z1 in [40..42] then res:=70;
          if z1 in [43..45] then res:=75;
          if z1 in [46..48] then res:=80;
          if z1 in [49..51] then res:=85;
          if z1 in [52..54] then res:=90;
          if z1 in [55..57] then res:=95;
          if z1 in [58..60] then res:=100;
          if z1 in [61..63] then res:=105;
          if z1 in [64..66] then res:=110;
          if z1 in [67..69] then res:=115;
          if z1>69 then res:=120;
          // -1 
        end
      end;
result:=res;
end;
end;
}
procedure Calc_BigMsk;
  var i,n:integer;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        if StringGrid1.cells[4,i]=StringGrid1.cells[4,n] then begin
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="2100" type="bigmsk1m" reverse="1" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="bigmsk1m_velo" reverse="1" />');
        end;
      end;
    end;
  end;
end;
end;
{
procedure Calc_599;
  var i,n:integer;
  var t:real;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     t:=Calc_599_Internal(i,n);
     if t>0 then begin
       WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t)+'" type="tariff599" reverse="1" />');
     end;
    end;
  end;
end;
end;
}

function Calc_Zone_Internal(i,n:integer):real;
  var v,m,z1,z2:integer;
  var res:real;
begin
with form1 do begin
res:=0;
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        if StringGrid1.cells[4,i]=StringGrid1.cells[4,n] then begin
          // 1 
          z1:=abs(strtointe(StringGrid1.cells[3,n])-strtointe(StringGrid1.cells[3,i]));
          res:=GetZoneTariff(StringGrid1.cells[4,i],z1);
            if validstr(StringGrid1.cells[5,i]) then begin
              if StringGrid1.cells[5,i]=StringGrid1.cells[5,n] then begin
                res:=GetZoneTariff(StringGrid1.cells[5,i],0);
              end;
            end;
          // -1 
        end
         else begin
           // 2 
           for m:=i to n do begin
             if validstr(StringGrid1.cells[4,m]) then begin
             if StringGrid1.cells[4,m]<>StringGrid1.cells[4,i] then break;
             end;
           end;
           v:=m-1;
           while not CompareDirections(stringgrid1.Cells[2,v],stringgrid1.Cells[2,n]) do dec(v);
           z1:=abs(strtointe(StringGrid1.cells[3,v])-strtointe(StringGrid1.cells[3,i]));
           z2:=abs(strtointe(StringGrid1.cells[3,n])-strtointe(StringGrid1.cells[3,m]))+1;
//           writeln(tf,'z1='+inttostr(z1)+' z2='+inttostr(z2));
           if z2>0 then res:=GetZoneTariff(StringGrid1.cells[4,i],z1)+GetZoneTariff(StringGrid1.cells[4,n],z2)
                   else res:=GetZoneTariff(StringGrid1.cells[4,i],z1);
           // -2 
         end;
      end;
result:=res;
end;
end;
{
function Calc_Zone_Internal_Seg(i,n:integer):TZOut;
  var z,v,m,x:integer;
  var res:real;
  var tz,tzn,tzc1,tzc2:AF_Types.TStrings;
  var s,lastn,lastz,startz:string;
  var gflag:boolean;
begin
with form1 do begin
tzn.create; tzc1.create; tzc2.create;
lastn:='##599##234';
lastz:='';
startz:='';
res:=0;
  for m:=i to n do begin
   if CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,m]) then begin
     if lastn<>StringGrid1.cells[4,m] then begin
       if lastn='##599##234' then begin
         lastn:='##599##239';
         startz:=StringGrid1.cells[3,m];
       end
        else begin
         if lastn='##599##239' then begin
           lastn:=StringGrid1.cells[4,m];
         end
          else begin
           tzn.add(lastn);
           tzc1.add(startz);
           tzc2.add(lastz);
           lastn:=StringGrid1.cells[4,m];
           startz:=lastz;
          end;
        end;
     end;
     lastz:=StringGrid1.cells[3,m];
   end;
  end;
  if lastn<>'##599##234' then begin
  if lastn<>'##599##239' then begin
    tzn.add(lastn);
    tzc1.add(startz);
    tzc2.add(lastz);
  end;
  end;
  s:='';
  if tzn.count>0 then begin
    gflag:=false;
    if ((validstr(stringgrid1.Cells[5,i]))and(validstr(stringgrid1.Cells[5,n]))) then begin
     if stringgrid1.Cells[5,i]=stringgrid1.Cells[5,n] then gflag:=true;
    end;
    if gflag then begin
     res:=GetZoneTariff(stringgrid1.Cells[5,i],1);
    end
    else begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
      res:=res+GetZoneTariff(tzn.getstring(v),z);
     end;
    end;
  end;
  result.price:=res;
  result.legend:=s;
tzn.free; tzc1.free; tzc2.free;

end;
end;
}

function findkarelia(tn:AF_Types.PStrings):boolean;
  var i:integer;
  var res:boolean;
begin
 res:=false;
 if tn.count>0 then begin
   res:=true;
   for i:=1 to tn.count do begin
    if ((pos('karelia',tn.getstring(i))<=0)and(pos('murmansk',tn.getstring(i))<=0)) then res:=false;
   end;
 end;
 result:=res;
end;

function GetTariffSPB2016(ttype:string; km:integer):TAbTarifList;
  var res:TAbTarifList;
  var i:integer;
  var vr:boolean;
begin
with form1 do begin
  ClearAbTariffList(res);
  vr:=false;
  if ansilowercase(ttype)='karelia1' then ttype:='karelia';
  for i:=0 to stringgrid4.ColCount-1 do begin
    if ansilowercase(trim(stringgrid4.Cells[i,0]))=ansilowercase(trim(ttype)) then begin
      vr:=true;
if stringgrid4.Cells[i,1]='etrain' then res.etrain:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='reduced' then res.reduced:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='child' then res.child:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='animal' then res.animal:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='handbag' then res.handbag:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='last' then res.last:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='lastchild' then res.lastchild:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='last5d' then res.last5d:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='last10d' then res.last10d:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='last15d' then res.last15d:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='last1m' then res.last1m:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='last10dr' then res.last10dr:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='last15dr' then res.last15dr:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='last1mr' then res.last1mr:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='last5dat' then res.last5dat:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='last10p' then res.last10p:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='last20p' then res.last20p:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='last60p' then res.last60p:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='last90p' then res.last90p:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='5d' then res.d5:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='10d' then res.d10:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='15d' then res.d15:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='20d' then res.d20:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='25d' then res.d25:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='1m' then res.m1:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='10dr' then res.d10r:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='15dr' then res.d15r:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='20dr' then res.d20r:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='25dr' then res.d25r:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='1mr' then res.m1r:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='5dat' then res.dat5:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='6dat' then res.dat6:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='7dat' then res.dat7:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='8dat' then res.dat8:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='9dat' then res.dat9:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='10dat' then res.dat10:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='11dat' then res.dat11:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='12dat' then res.dat12:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='13dat' then res.dat13:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='14dat' then res.dat14:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='15dat' then res.dat15:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='16dat' then res.dat16:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='10p' then res.p10:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='20p' then res.p20:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='60p' then res.p60:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='90p' then res.p90:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='e1m' then res.e1m:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='e1mr' then res.e1mr:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='1mlg' then res.mlg1:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='1mrlg' then res.mrlg1:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='vyhdn' then res.vyhdn:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='vyhdnlg' then res.vyhdnlg:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='vyhdnchild' then res.vyhdnchild:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='komfort' then res.komfort:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='komfortchild' then res.komfortchild:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='detsky' then res.detsky:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='detsky_last' then res.detsky_last:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='uglski' then res.uglski:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='1mr_priv' then res.priv_1mr:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='5den_priv' then res.priv_5den:=strtofloatdef(stringgrid4.Cells[i,km+1],0);

if stringgrid4.Cells[i,1]='krskm_sp' then res.krskm_sp:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='krskm_child' then res.krskm_child:=strtofloatdef(stringgrid4.Cells[i,km+1],0);
if stringgrid4.Cells[i,1]='krskm_animal' then res.krskm_animal:=strtofloatdef(stringgrid4.Cells[i,km+1],0);

     end;
  end;

  if not vr then ShowMessage('     '+ttype+'  !');
  result:=res;
end;
end;

function Calc_Zone_Internal_Seg_SPB2016(i,n:integer):TAbTarifList;
  var z,v,m:integer;
  var a:TAbTarifList;
  var tzn,tzc1,tzc2:AF_Types.TStrings;
  var s,lastn,lastz,startz:string;
  var gflag:boolean;
  var tout:TAbTarifList;
begin
with form1 do begin
ClearAbTariffList(tout);
tzn.create; tzc1.create; tzc2.create;
lastn:='##599##234';
lastz:='';
startz:='';
  for m:=i to n do begin
   if ((CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,m]))and(CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,m]))) then begin
     if lastn<>StringGrid1.cells[4,m] then begin
       if lastn='##599##234' then begin
         lastn:='##599##239';
         startz:=StringGrid1.cells[3,m];
       end
        else begin
         if lastn='##599##239' then begin
           lastn:=StringGrid1.cells[4,m];
         end
          else begin
           tzn.add(lastn);
           tzc1.add(startz);
           tzc2.add(lastz);
           lastn:=StringGrid1.cells[4,m];
           startz:=lastz;
          end;
        end;
     end;
     lastz:=StringGrid1.cells[3,m];
   end;
  end;
  if lastn<>'##599##234' then begin
  if lastn<>'##599##239' then begin
    tzn.add(lastn);
    tzc1.add(startz);
    tzc2.add(lastz);
  end;
  end;
  s:='';
  if true {((tzn.count=1)or(findkarelia(@tzn)))} then begin
    gflag:=false;
    if ((validstr(stringgrid1.Cells[5,i]))and(validstr(stringgrid1.Cells[5,n]))) then begin
     if stringgrid1.Cells[5,i]=stringgrid1.Cells[5,n] then gflag:=true;
    end;
    if gflag then begin
     tout:=GetTariffSPB2016(stringgrid1.Cells[5,i],1);
    end
    else begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
      a:=GetTariffSPB2016(tzn.getstring(v),z);
      IncAbTariffList(tout,a);
     end;
    end;
  end;
  result:=tout;
tzn.free; tzc1.free; tzc2.free;

end;
end;


function Calc_Zone_Internal_Seg_V2(i,n:integer;cityflag:boolean):TZOut;
  var z,v,m:integer;
  var res:real;
  var tzn,tzc1,tzc2,tzg1,tzg2:AF_Types.TStrings;
  var s,lastn,lastz,startz,startg,lastg:string;
  var gflag:boolean;
begin
with form1 do begin
tzn.create; tzc1.create; tzc2.create; tzg1.create; tzg2.create;
lastn:='##599##234';
lastz:='';
startz:='';
lastg:='';
startg:='';
res:=0;
  for m:=i to n do begin
   if ((CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,m]))and(CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,m]))) then begin
     if lastn<>StringGrid1.cells[4,m] then begin
       if lastn='##599##234' then begin
         lastn:='##599##239';
         startz:=StringGrid1.cells[3,m];
         startg:=StringGrid1.cells[5,m];
       end
        else begin
         if lastn='##599##239' then begin
           lastn:=StringGrid1.cells[4,m];
         end
          else begin
           tzn.add(lastn);
           tzc1.add(startz);
           tzc2.add(lastz);
           tzg1.add(startg);
           tzg2.add(lastg);
           lastn:=StringGrid1.cells[4,m];
           startz:=lastz;
           startg:=lastg;
          end;
        end;
     end;
     lastz:=StringGrid1.cells[3,m];
     lastg:=StringGrid1.cells[5,m];
   end;
  end;
  if lastn<>'##599##234' then begin
   if lastn<>'##599##239' then begin
    tzn.add(lastn);
    tzc1.add(startz);
    tzc2.add(lastz);
    tzg1.add(startg);
    tzg2.add(lastg);
   end;
  end;
  s:='';
  if tzn.count>0 then begin
    gflag:=false;
    if ((validstr(stringgrid1.Cells[5,i]))and(validstr(stringgrid1.Cells[5,n]))) then begin
     if stringgrid1.Cells[5,i]=stringgrid1.Cells[5,n] then gflag:=true;
    end;
    if gflag then begin
     res:=GetZoneTariff(stringgrid1.Cells[5,i],1);
    end
    else begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
      if cityflag then begin
       if ((validstr(tzg1.getstring(v)))and(validstr(tzg2.getstring(v)))) then begin
        if tzg1.getstring(v)=tzg2.getstring(v) then begin
         res:=res+GetZoneTariff(tzg1.getstring(v),z);
        end
         else res:=res+GetZoneTariff(tzn.getstring(v),z);
       end
        else res:=res+GetZoneTariff(tzn.getstring(v),z);
      end
       else res:=res+GetZoneTariff(tzn.getstring(v),z);
     end;
    end;
  end;
  result.price:=res;
  result.legend:=s;
tzn.free; tzc1.free; tzc2.free;

end;
end;



function Calc_Zone_Internal_Seg_V2_WithAbonement(i,n:integer;abonement:string):TZOut;
  var z,v,m:integer;
  var res:real;
  var tzn,tzc1,tzc2:AF_Types.TStrings;
  var s,lastn,lastz,startz:string;
  var gflag:boolean;
begin
with form1 do begin
tzn.create; tzc1.create; tzc2.create;
lastn:='##599##234';
lastz:='';
startz:='';
abonement:=trim(abonement);
if validstr(abonement) then abonement:='_'+abonement;
res:=0;
  for m:=i to n do begin
   if ((CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,m]))and(CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,m]))) then begin
     if lastn<>StringGrid1.cells[4,m] then begin
       if lastn='##599##234' then begin
         lastn:='##599##239';
         startz:=StringGrid1.cells[3,m];
       end
        else begin
         if lastn='##599##239' then begin
           lastn:=StringGrid1.cells[4,m];
         end
          else begin
           tzn.add(lastn);
           tzc1.add(startz);
           tzc2.add(lastz);
           lastn:=StringGrid1.cells[4,m];
           startz:=lastz;
          end;
        end;
     end;
     lastz:=StringGrid1.cells[3,m];
   end;
  end;
  if lastn<>'##599##234' then begin
  if lastn<>'##599##239' then begin
    tzn.add(lastn);
    tzc1.add(startz);
    tzc2.add(lastz);
  end;
  end;
  s:='';
  if tzn.count>0 then begin
    gflag:=false;
    if ((validstr(stringgrid1.Cells[5,i]))and(validstr(stringgrid1.Cells[5,n]))) then begin
     if stringgrid1.Cells[5,i]=stringgrid1.Cells[5,n] then gflag:=true;
    end;
    if gflag then begin
     res:=GetZoneTariff(stringgrid1.Cells[5,i]+abonement,1);
    end
    else begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
      res:=res+GetZoneTariff(tzn.getstring(v)+abonement,z);
     end;
    end;
  end;
  result.price:=res;
  result.legend:=s;
tzn.free; tzc1.free; tzc2.free;

end;
end;



function Calc_Zone_Internal_Seg_NN2013(i,n:integer):TZOut;
  var z,v,m:integer;
  var res:real;
  var tzn,tzc1,tzc2:AF_Types.TStrings;
  var s,lastn,lastz,startz:string;
  var gflag:boolean;
begin
with form1 do begin
tzn.create; tzc1.create; tzc2.create;
lastn:='##599##234';
lastz:='';
startz:='';
res:=0;
  for m:=i to n do begin
//   if CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,m]) then begin
   if ((CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,m]))and(CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,m]))) then begin
     if lastn<>StringGrid1.cells[4,m] then begin
       if lastn='##599##234' then begin
         lastn:='##599##239';
         startz:=StringGrid1.cells[3,m];
       end
        else begin
         if lastn='##599##239' then begin
           lastn:=StringGrid1.cells[4,m];
         end
          else begin
           tzn.add(lastn);
           tzc1.add(startz);
           tzc2.add(lastz);
           lastn:=StringGrid1.cells[4,m];
           startz:=lastz;
          end;
        end;
     end;
     lastz:=StringGrid1.cells[3,m];
   end;
  end;
  if lastn<>'##599##234' then begin
  if lastn<>'##599##239' then begin
    tzn.add(lastn);
    tzc1.add(startz);
    tzc2.add(lastz);
  end;
  end;
  s:='';
  if tzn.count>0 then begin
    gflag:=false;
    if ((validstr(stringgrid1.Cells[5,i]))and(validstr(stringgrid1.Cells[5,n]))) then begin
     if stringgrid1.Cells[5,i]=stringgrid1.Cells[5,n] then gflag:=true;
    end;
    if gflag then begin
     res:=GetZoneTariff(stringgrid1.Cells[5,i],1);
    end
    else begin
     for v:=1 to tzn.count do begin
     if ((ansilowercase(tzn.getstring(v))='nnmatrix')or(ansilowercase(tzn.getstring(v))='nnmatrix1')or(ansilowercase(tzn.getstring(v))='nnmatrix2')or(ansilowercase(tzn.getstring(v))='kirovmatrix')or(ansilowercase(tzn.getstring(v))='kirovmatrix_luza')or(ansilowercase(tzn.getstring(v))='kirovmatrix_kirs')) then begin
      s:=s+tzn.getstring(v);
      s:=s+'='+tzc1.getstring(v)+'-'+tzc2.getstring(v)+';  ';
      if ansilowercase(tzn.getstring(v))='nnmatrix' then res:=res+CalcMatrixTariffNN(strtointe(tzc1.getstring(v)),strtointe(tzc2.getstring(v)));
      if ansilowercase(tzn.getstring(v))='nnmatrix1' then res:=res+CalcMatrixTariffNN(strtointe(tzc1.getstring(v)),strtointe(tzc2.getstring(v)));
      if ansilowercase(tzn.getstring(v))='nnmatrix2' then res:=res+CalcMatrixTariffNN(strtointe(tzc1.getstring(v)),strtointe(tzc2.getstring(v)));
      if ansilowercase(tzn.getstring(v))='kirovmatrix' then res:=res+CalcMatrixTariffKirov(strtointe(tzc1.getstring(v)),strtointe(tzc2.getstring(v)));
      if ansilowercase(tzn.getstring(v))='kirovmatrix_luza' then res:=res+CalcMatrixTariffKirov(strtointe(tzc1.getstring(v))-19,strtointe(tzc2.getstring(v))-19);
      if ansilowercase(tzn.getstring(v))='kirovmatrix_kirs' then res:=res+CalcMatrixTariffKirov(strtointe(tzc1.getstring(v))-69,strtointe(tzc2.getstring(v))-69);
     end
      else begin
       s:=s+tzn.getstring(v);
       z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
       s:=s+'='+inttostr(z)+';  ';
       res:=res+GetZoneTariff(tzn.getstring(v),z);
      end;
     end;
    end;
  end;
  result.price:=res;
  result.legend:=s;
tzn.free; tzc1.free; tzc2.free;

end;
end;




{procedure Calc_Zone;
  var i,n:integer;
  var t:real;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     t:=Calc_Zone_Internal(i,n);
     if t>0 then begin
       WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t)+'" type="etrain" reverse="1" />');
       WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(t));
     end;
    end;
  end;
end;
end;
}

procedure Calc_Zone_Seg_Ukraine;
  var i,n,v:integer;
  var tariff,tariff1:TZOut;
  var f1:AF_types.TSTrings;
  var s,curr:string;
  var vrev:string;
  var tar1,tar2:extended;
begin
with form1 do begin
  vrev:='1';
  stringgrid1.cells[1,0]:=trim(ansilowercase(stringgrid1.cells[1,0]));
  curr:='';
  if pos('currency=',trim(ansilowercase(stringgrid1.cells[0,0])))>0 then curr:=' '+trim(stringgrid1.cells[0,0]);
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     if CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,n]) then begin
       v:=abs(strtointe(stringgrid1.Cells[3,n])-strtointe(stringgrid1.Cells[3,i]));
       tar1:=GetZoneTariff(ansiuppercase(stringgrid1.Cells[4,i]),v);
       tar2:=GetZoneTariff(ansiuppercase(stringgrid1.Cells[4,n]),v);
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tar1)+'" type="etrain" currency="UAH" reverse="0" insearch="1" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(tar2)+'" type="etrain" currency="UAH" reverse="0" insearch="1" />');
         if tar1=tar2 then stringgrid1.Cells[i+5,n]:=floattostr(tar1)
                      else stringgrid1.Cells[i+5,n]:=floattostr(tar1)+'/'+floattostr(tar2);
     end;
    end;
  end;
  f1.create;
    for i:=0 to stringgrid1.RowCount-1 do begin
      s:='';
      for n:=0 to stringgrid1.ColCount-1 do begin
        s:=s+stringgrid1.cells[n,i]+';';
      end;
      f1.add(s);
    end;
  f1.savetofile(SaveDialog1.FileName+'.angle.csv');
  f1.free;
end;
end;

procedure Calc_Zone_Seg(addReduced,cityflag:boolean;child:TChildMode; skv:boolean);
  var i,n,ch1,ch2:integer;
  var ch:extended;
  var tariff:TZOut;
  var f1:AF_types.TSTrings;
  var s,curr:string;
  var vrev:string;
  var vflag: boolean;
begin
with form1 do begin
  vrev:='1';
  stringgrid1.cells[1,0]:=trim(ansilowercase(stringgrid1.cells[1,0]));
  curr:='';
  if pos('currency=',trim(ansilowercase(stringgrid1.cells[0,0])))>0 then curr:=' '+trim(stringgrid1.cells[0,0]);
  if pos('reverse="0"',trim(ansilowercase(stringgrid1.cells[1,0])))>0 then vrev:='0';
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     vflag := false;
     if  CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,n]) then begin
        vflag := true;
        if skv then begin
          if stringgrid1.Cells[6,i]=stringgrid1.Cells[6,n] then
           vflag:=false;
        end;
     end;
     if vflag  then begin
       tariff:=Calc_Zone_Internal_Seg_V2(i,n,cityflag);
       if strtointe(stringgrid1.Cells[0,i])=0 then tariff.price:=0;
       if strtointe(stringgrid1.Cells[0,n])=0 then tariff.price:=0;
       if tariff.price>0 then begin
        if ((pos('city',stringgrid1.cells[1,0])>0)or(pos('express',stringgrid1.cells[1,0])>0)or(pos('krsev',stringgrid1.cells[1,0])>0)or(pos('ikt_sp',stringgrid1.cells[1,0])>0)or(pos('ekb_sp',stringgrid1.cells[1,0])>0)or(pos('nnmet',stringgrid1.cells[1,0])>0)or(pos('etrainkhb',stringgrid1.cells[1,0])>0)or(pos('kazan2',stringgrid1.cells[1,0])>0)or(pos('kdz',stringgrid1.cells[1,0])>0)or(pos('ufa_g',stringgrid1.cells[1,0])>0)or(pos('ekbsh',stringgrid1.cells[1,0])>0)or(pos('sppk_sp',stringgrid1.cells[1,0])>0)or(pos('krskles',stringgrid1.cells[1,0])>0)or(pos('last',stringgrid1.cells[1,0])>0) or(pos('rostov_sp',stringgrid1.cells[1,0])>0) or(pos('arkhangelsk_sp',stringgrid1.cells[1,0])>0)  or(pos('mcd',stringgrid1.cells[1,0])>0) ) or(pos('udm_sp',stringgrid1.cells[1,0])>0) then begin
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="'+stringgrid1.cells[1,0]+'"'+curr+' reverse="'+vrev+'" insearch="0" />');
        end
         else begin
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="etrain" reverse="'+vrev+'"'+curr+' />');
           if curr='' then begin
            if addReduced then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price/2)+'" type="reduced" reverse="'+vrev+'" />');
            end;
            if child=chNormal then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price/4)+'" type="child" reverse="'+vrev+'" />');
            end;
            if child=chNN then begin
             ch1:=trunc(tariff.price/4);
             ch2:=trunc(frac(tariff.price/4)*10);
             ch:=0;
             if ch2>0 then begin
               if ch2<=5 then ch:=0.5
                         else ch:=1;
             end;
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ch+ch1)+'" type="child" reverse="'+vrev+'" />');
            end;
           end;
         end;
         WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(tariff.price)+';'+tariff.legend);
         stringgrid1.Cells[i+5,n]:=floattostr(tariff.price);
       end;
     end;
    end;
  end;
  f1.create;
    for i:=0 to stringgrid1.RowCount-1 do begin
      s:='';
      for n:=0 to stringgrid1.ColCount-1 do begin
        s:=s+stringgrid1.cells[n,i]+';';
      end;
      f1.add(s);
    end;
  f1.savetofile(SaveDialog1.FileName+'.angle.csv');
  f1.free;
end;
end;

procedure Calc_SPB2016(no0etrain,calcexpress,nochanimal:boolean);
  var i,n:integer;
  var tariff:TAbTarifList;
  var f1:AF_types.TSTrings;
  var s,tpr,ttr,tin:string;
  var vrev:string;
  var vres:boolean;
begin
with form1 do begin
  vrev:='1';
  stringgrid1.cells[1,0]:=trim(ansilowercase(stringgrid1.cells[1,0]));
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     if CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,n]) then begin
       tariff:=Calc_Zone_Internal_Seg_SPB2016(i,n);
       vres:=true;
       if strtointe(stringgrid1.Cells[0,i])=0 then vres:=false;
       if strtointe(stringgrid1.Cells[0,n])=0 then vres:=false;
       if vres then begin
        if calcexpress then begin
          ttr:='e1m';
           tpr:=floattostr(tariff.e1m);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='e1mr';
           tpr:=floattostr(tariff.e1mr);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
         end
         else begin
          ttr:='etrain';
           tpr:=floattostr(tariff.etrain);
           tin:='1';
           if no0etrain then begin
              if tariff.etrain>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
           end
            else begin
              WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
            end;
           stringgrid1.Cells[i+5,n]:=tpr;
          ttr:='reduced';
           if ((stringgrid1.Cells[4,i]='samara')or(stringgrid1.Cells[4,i]='samara_gorod')) then begin
                                                                                                  tpr:=floattostr(tariff.reduced)
                                                                                                end
                                                                                           else tpr:='0';
           tin:='0';
           if no0etrain then begin
//             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
           end
            else begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
            end;
          if nochanimal=false then begin
          //ttr:='child';
          // tpr:=floattostr(tariff.child);
          // tin:='0';
          // WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='animal';
           tpr:=floattostr(tariff.animal);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
////           stringgrid1.Cells[i+5,n]:=tpr;      //!!!
          end;
          ttr:='5d';
           tpr:=floattostr(tariff.d5);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='10d';
           tpr:=floattostr(tariff.d10);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='15d';
           tpr:=floattostr(tariff.d15);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='20d';
           tpr:=floattostr(tariff.d20);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='25d';
           tpr:=floattostr(tariff.d25);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='1m';
           tpr:=floattostr(tariff.m1);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='10dr';
           tpr:=floattostr(tariff.d10r);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='15dr';
           tpr:=floattostr(tariff.d15r);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='20dr';
           tpr:=floattostr(tariff.d20r);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='25dr';
           tpr:=floattostr(tariff.d25r);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='1mr';
           tpr:=floattostr(tariff.m1r);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='5dat';
           tpr:=floattostr(tariff.dat5);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='6dat';
           tpr:=floattostr(tariff.dat6);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='7dat';
           tpr:=floattostr(tariff.dat7);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='8dat';
           tpr:=floattostr(tariff.dat8);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='9dat';
           tpr:=floattostr(tariff.dat9);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='10dat';
           tpr:=floattostr(tariff.dat10);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='11dat';
           tpr:=floattostr(tariff.dat11);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='12dat';
           tpr:=floattostr(tariff.dat12);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='13dat';
           tpr:=floattostr(tariff.dat13);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='14dat';
           tpr:=floattostr(tariff.dat14);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='15dat';
           tpr:=floattostr(tariff.dat15);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          if ((stringgrid1.Cells[4,i]='samara')or(stringgrid1.Cells[4,i]='samara_gorod')) then begin
           ttr:='16dat';
           tpr:=floattostr(tariff.dat16);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          end;
          ttr:='1mlg';
           tpr:=floattostr(tariff.mlg1);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='1mrlg';
           tpr:=floattostr(tariff.mrlg1);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='vyhdn';
           tpr:=floattostr(tariff.vyhdn);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='vyhdnlg';
           tpr:=floattostr(tariff.vyhdnlg);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          //ttr:='vyhdnchild';
          // tpr:=floattostr(tariff.vyhdnchild);
          // tin:='0';
          // WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          //ttr:='detsky';
          // tpr:=floattostr(tariff.detsky);
          // tin:='0';
          // WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
         if ((stringgrid1.Cells[6,i]='1')and(stringgrid1.Cells[6,n]='1')) then begin
          ttr:='10p';
           tpr:=floattostr(tariff.p10);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='20p';
           tpr:=floattostr(tariff.p20);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='60p';
           tpr:=floattostr(tariff.p60);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='90p';
           tpr:=floattostr(tariff.p90);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          end;
         end;
       end;
     end;
    end;
  end;
  f1.create;
    for i:=0 to stringgrid1.RowCount-1 do begin
      s:='';
      for n:=0 to stringgrid1.ColCount-1 do begin
        s:=s+stringgrid1.cells[n,i]+';';
      end;
      f1.add(s);
    end;
  f1.savetofile(mainfilename+'.angle.csv');
  f1.free;
end;
end;

procedure Calc_SPB2016_last;
  var i,n:integer;
  var tariff:TAbTarifList;
  var f1:AF_types.TSTrings;
  var s,tpr,ttr,tin:string;
  var vrev:string;
  var vres:boolean;
begin
with form1 do begin
  vrev:='1';
  stringgrid1.cells[1,0]:=trim(ansilowercase(stringgrid1.cells[1,0]));
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     if CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,n]) then begin
       tariff:=Calc_Zone_Internal_Seg_SPB2016(i,n);
       vres:=true;
       if strtointe(stringgrid1.Cells[0,i])=0 then vres:=false;
       if strtointe(stringgrid1.Cells[0,n])=0 then vres:=false;
       if vres then begin
          ttr:='last';
           tpr:=floattostr(tariff.last);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
           stringgrid1.Cells[i+5,n]:=tpr;
          ttr:='last_child';
           tpr:=floattostr(tariff.lastchild);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='last5d';
           tpr:=floattostr(tariff.last5d);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='last10d';
           tpr:=floattostr(tariff.last10d);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='last15d';
           tpr:=floattostr(tariff.last15d);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='last1m';
           tpr:=floattostr(tariff.last1m);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='last10dr';
           tpr:=floattostr(tariff.last10dr);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='last15dr';
           tpr:=floattostr(tariff.last15dr);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='last1mr';
           tpr:=floattostr(tariff.last1mr);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='last5dat';
           tpr:=floattostr(tariff.last5dat);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='detsky_last';
           tpr:=floattostr(tariff.detsky_last);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');

           ttr:='1mr_priv';
           tpr:=floattostr(tariff.priv_1mr);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');

           ttr:='5den_priv';
           tpr:=floattostr(tariff.priv_5den);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');

         if ((stringgrid1.Cells[6,i]='1')and(stringgrid1.Cells[6,n]='1')) then begin
          ttr:='last10p';
           tpr:=floattostr(tariff.last10p);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='last20p';
           tpr:=floattostr(tariff.last20p);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='last60p';
           tpr:=floattostr(tariff.last60p);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
          ttr:='last90p';
           tpr:=floattostr(tariff.last90p);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
         end;
       end;
     end;
    end;
  end;
  f1.create;
    for i:=0 to stringgrid1.RowCount-1 do begin
      s:='';
      for n:=0 to stringgrid1.ColCount-1 do begin
        s:=s+stringgrid1.cells[n,i]+';';
      end;
      f1.add(s);
    end;
  f1.savetofile(mainfilename+'.angle.csv');
  f1.free;
end;
end;

procedure Calc_SPB2016_komfort;
  var i,n:integer;
  var tariff:TAbTarifList;
  var f1:AF_types.TSTrings;
  var s,tpr,ttr,tin:string;
  var vrev:string;
  var vres:boolean;
begin
with form1 do begin
  vrev:='1';
  stringgrid1.cells[1,0]:=trim(ansilowercase(stringgrid1.cells[1,0]));
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     if CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,n]) then begin
       tariff:=Calc_Zone_Internal_Seg_SPB2016(i,n);
       vres:=true;
       if strtointe(stringgrid1.Cells[0,i])=0 then vres:=false;
       if strtointe(stringgrid1.Cells[0,n])=0 then vres:=false;
       if vres then begin
          ttr:='komfort';
           tpr:=floattostr(tariff.komfort);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
           stringgrid1.Cells[i+5,n]:=tpr;
          ttr:='komfort_child';
           tpr:=floattostr(tariff.komfortchild);
           tin:='0';
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+tpr+'" type="'+ttr+'"'+' reverse="'+vrev+'" insearch="'+tin+'" />');
       end;
     end;
    end;
  end;
  f1.create;
    for i:=0 to stringgrid1.RowCount-1 do begin
      s:='';
      for n:=0 to stringgrid1.ColCount-1 do begin
        s:=s+stringgrid1.cells[n,i]+';';
      end;
      f1.add(s);
    end;
  f1.savetofile(mainfilename+'.angle.csv');
  f1.free;
end;
end;




procedure Calc_Zone_Seg_MCC;
  var i,n:integer;
  var tariff:TZOut;
  var f1:AF_types.TSTrings;
  var s,curr:string;
  var vrev,abstr:string;
  var abflg:boolean;
begin
with form1 do begin
  stringgrid1.cells[1,0]:=trim(ansilowercase(stringgrid1.cells[1,0]));
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     if CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,n]) then begin
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="61" type="etrain" replace_tariff_type="cppk" reverse="1" insearch="1" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="46" type="mmtr" reverse="1" insearch="0" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="69" type="mm90tr" reverse="1" insearch="0" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="122" type="mme2" reverse="1" insearch="0" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="mme20" reverse="1" insearch="0" />');    //  
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="mme40" reverse="1" insearch="0" />');    //  
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="2070" type="mme60" reverse="1" insearch="0" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="265" type="mmb1" reverse="1" insearch="0" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="500" type="mmb3" reverse="1" insearch="0" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="mmb7" reverse="1" insearch="0" />');    //  
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="2360" type="mmb30" reverse="1" insearch="0" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="5710" type="mmb90" reverse="1" insearch="0" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="19500" type="mmb365" reverse="1" insearch="0" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="mm90k1" reverse="1" insearch="0" />'); //  
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="mm90k2" reverse="1" insearch="0" />'); //  
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="mm90k60" reverse="1" insearch="0" />'); //  
     end;
    end;
  end;
end;
end;



procedure Calc_Zone_Seg_Belarus(disable_belarus_gr_in_abonement:boolean);
  var i,n:integer;
  var tariff:TZOut;
  var f1:AF_types.TSTrings;
  var s,curr:string;
  var vrev,abstr:string;
  var abflg:boolean;
begin
with form1 do begin
  vrev:='1';
  stringgrid1.cells[1,0]:=trim(ansilowercase(stringgrid1.cells[1,0]));
  curr:='';
  if pos('currency=',trim(ansilowercase(stringgrid1.cells[0,0])))>0 then curr:=' '+trim(stringgrid1.cells[0,0]);
  if pos('reverse="0"',trim(ansilowercase(stringgrid1.cells[1,0])))>0 then vrev:='0';
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     if CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,n]) then begin
       tariff:=Calc_Zone_Internal_Seg_V2_WithAbonement(i,n,'');
       if strtointe(stringgrid1.Cells[0,i])=0 then tariff.price:=0;
       if strtointe(stringgrid1.Cells[0,n])=0 then tariff.price:=0;
       if tariff.price>0 then begin
        if ((pos('city',stringgrid1.cells[1,0])>0)or(pos('express',stringgrid1.cells[1,0])>0)or(pos('krsev',stringgrid1.cells[1,0])>0)) then begin
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="'+stringgrid1.cells[1,0]+'"'+curr+' reverse="'+vrev+'" insearch="0" />');
        end
         else begin
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="etrain" reverse="'+vrev+'"'+curr+' />');
         end;
         WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(tariff.price)+';'+tariff.legend);
         stringgrid1.Cells[i+5,n]:=floattostr(tariff.price);
       end;

     abflg:=true;
     if disable_belarus_gr_in_abonement then begin
       if ((ansilowercase(stringgrid1.Cells[4,i])='belarus_gr')or(ansilowercase(stringgrid1.Cells[4,n])='belarus_gr')) then abflg:=false;
     end;

     if abflg then begin

       abstr:='1k';
       tariff:=Calc_Zone_Internal_Seg_V2_WithAbonement(i,n,abstr);
       if strtointe(stringgrid1.Cells[0,i])=0 then tariff.price:=0;
       if strtointe(stringgrid1.Cells[0,n])=0 then tariff.price:=0;
       if tariff.price>0 then begin
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="'+abstr+'"'+curr+' reverse="'+vrev+'" insearch="0" />');
         WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(tariff.price)+';'+tariff.legend+';'+abstr);
       end;

       abstr:='1m';
       tariff:=Calc_Zone_Internal_Seg_V2_WithAbonement(i,n,abstr);
       if strtointe(stringgrid1.Cells[0,i])=0 then tariff.price:=0;
       if strtointe(stringgrid1.Cells[0,n])=0 then tariff.price:=0;
       if tariff.price>0 then begin
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="'+abstr+'"'+curr+' reverse="'+vrev+'" insearch="0" />');
         WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(tariff.price)+';'+tariff.legend+';'+abstr);
       end;

       abstr:='1mr';
       tariff:=Calc_Zone_Internal_Seg_V2_WithAbonement(i,n,abstr);
       if strtointe(stringgrid1.Cells[0,i])=0 then tariff.price:=0;
       if strtointe(stringgrid1.Cells[0,n])=0 then tariff.price:=0;
       if tariff.price>0 then begin
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="'+abstr+'"'+curr+' reverse="'+vrev+'" insearch="0" />');
         WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(tariff.price)+';'+tariff.legend+';'+abstr);
       end;

       abstr:='vyhdn';
       tariff:=Calc_Zone_Internal_Seg_V2_WithAbonement(i,n,abstr);
       if strtointe(stringgrid1.Cells[0,i])=0 then tariff.price:=0;
       if strtointe(stringgrid1.Cells[0,n])=0 then tariff.price:=0;
       if tariff.price>0 then begin
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="'+abstr+'"'+curr+' reverse="'+vrev+'" insearch="0" />');
         WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(tariff.price)+';'+tariff.legend+';'+abstr);
       end;

     end;

     end;
    end;
  end;
  f1.create;
    for i:=0 to stringgrid1.RowCount-1 do begin
      s:='';
      for n:=0 to stringgrid1.ColCount-1 do begin
        s:=s+stringgrid1.cells[n,i]+';';
      end;
      f1.add(s);
    end;
  f1.savetofile(SaveDialog1.FileName+'.angle.csv');
  f1.free;
end;
end;

procedure Calc_Zone_Seg_Belarus_City(disable_belarus_gr_in_abonement:boolean);
  var i,n:integer;
  var tariff:TZOut;
  var f1:AF_types.TSTrings;
  var s,curr:string;
  var vrev,abstr:string;
  var abflg:boolean;
begin
with form1 do begin
  vrev:='1';
  stringgrid1.cells[1,0]:=trim(ansilowercase(stringgrid1.cells[1,0]));
  curr:='';
  if pos('currency=',trim(ansilowercase(stringgrid1.cells[0,0])))>0 then curr:=' '+trim(stringgrid1.cells[0,0]);
  if pos('reverse="0"',trim(ansilowercase(stringgrid1.cells[1,0])))>0 then vrev:='0';
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     if CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,n]) then begin
       tariff:=Calc_Zone_Internal_Seg_V2_WithAbonement(i,n,'');
       if strtointe(stringgrid1.Cells[0,i])=0 then tariff.price:=0;
       if strtointe(stringgrid1.Cells[0,n])=0 then tariff.price:=0;
       if tariff.price>0 then begin
        if ((pos('city',stringgrid1.cells[1,0])>0)or(pos('express',stringgrid1.cells[1,0])>0)or(pos('krsev',stringgrid1.cells[1,0])>0)) then begin
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="'+stringgrid1.cells[1,0]+'"'+curr+' reverse="'+vrev+'" insearch="0" />');
        end
         else begin
           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="etrain" reverse="'+vrev+'"'+curr+' />');
         end;
         WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(tariff.price)+';'+tariff.legend);
         stringgrid1.Cells[i+5,n]:=floattostr(tariff.price);
       end;

     abflg:=true;
     if disable_belarus_gr_in_abonement then begin
       if ((ansilowercase(stringgrid1.Cells[4,i])='belarus_gr')or(ansilowercase(stringgrid1.Cells[4,n])='belarus_gr')) then abflg:=false;
     end;

     if abflg then begin

       abstr:='g1k';
       tariff:=Calc_Zone_Internal_Seg_V2_WithAbonement(i,n,abstr);
       if strtointe(stringgrid1.Cells[0,i])=0 then tariff.price:=0;
       if strtointe(stringgrid1.Cells[0,n])=0 then tariff.price:=0;
       if tariff.price>0 then begin
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="'+abstr+'"'+curr+' reverse="'+vrev+'" insearch="0" />');
         WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(tariff.price)+';'+tariff.legend+';'+abstr);
       end;

       abstr:='g1m';
       tariff:=Calc_Zone_Internal_Seg_V2_WithAbonement(i,n,abstr);
       if strtointe(stringgrid1.Cells[0,i])=0 then tariff.price:=0;
       if strtointe(stringgrid1.Cells[0,n])=0 then tariff.price:=0;
       if tariff.price>0 then begin
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="'+abstr+'"'+curr+' reverse="'+vrev+'" insearch="0" />');
         WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(tariff.price)+';'+tariff.legend+';'+abstr);
       end;

       abstr:='gs3';
       tariff:=Calc_Zone_Internal_Seg_V2_WithAbonement(i,n,abstr);
       if strtointe(stringgrid1.Cells[0,i])=0 then tariff.price:=0;
       if strtointe(stringgrid1.Cells[0,n])=0 then tariff.price:=0;
       if tariff.price>0 then begin
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="'+abstr+'"'+curr+' reverse="'+vrev+'" insearch="0" />');
         WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(tariff.price)+';'+tariff.legend+';'+abstr);
       end;

       abstr:='gs5';
       tariff:=Calc_Zone_Internal_Seg_V2_WithAbonement(i,n,abstr);
       if strtointe(stringgrid1.Cells[0,i])=0 then tariff.price:=0;
       if strtointe(stringgrid1.Cells[0,n])=0 then tariff.price:=0;
       if tariff.price>0 then begin
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="'+abstr+'"'+curr+' reverse="'+vrev+'" insearch="0" />');
         WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(tariff.price)+';'+tariff.legend+';'+abstr);
       end;

       abstr:='gs10';
       tariff:=Calc_Zone_Internal_Seg_V2_WithAbonement(i,n,abstr);
       if strtointe(stringgrid1.Cells[0,i])=0 then tariff.price:=0;
       if strtointe(stringgrid1.Cells[0,n])=0 then tariff.price:=0;
       if tariff.price>0 then begin
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="'+abstr+'"'+curr+' reverse="'+vrev+'" insearch="0" />');
         WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(tariff.price)+';'+tariff.legend+';'+abstr);
       end;

       abstr:='gs30';
       tariff:=Calc_Zone_Internal_Seg_V2_WithAbonement(i,n,abstr);
       if strtointe(stringgrid1.Cells[0,i])=0 then tariff.price:=0;
       if strtointe(stringgrid1.Cells[0,n])=0 then tariff.price:=0;
       if tariff.price>0 then begin
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="'+abstr+'"'+curr+' reverse="'+vrev+'" insearch="0" />');
         WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(tariff.price)+';'+tariff.legend+';'+abstr);
       end;

     end;

     end;
    end;
  end;
  f1.create;
    for i:=0 to stringgrid1.RowCount-1 do begin
      s:='';
      for n:=0 to stringgrid1.ColCount-1 do begin
        s:=s+stringgrid1.cells[n,i]+';';
      end;
      f1.add(s);
    end;
  f1.savetofile(SaveDialog1.FileName+'.angle.csv');
  f1.free;
end;
end;


Function CheckAppDisable(tar1,tar2,cppktt:string):boolean;
 var rflg:boolean;
begin
 rflg:=true;
 tar1:=ansilowercase(tar1);
 tar2:=ansilowercase(tar2);
 cppktt:=ansilowercase(cppktt);
   if ((cppktt='5dat')or(cppktt='6dat')or(cppktt='7dat')or(cppktt='8dat')or(cppktt='9dat')or(cppktt='10dat')or(cppktt='11dat')or(cppktt='12dat')or(cppktt='13dat')or(cppktt='14dat')or(cppktt='15dat')or(cppktt='16dat')) then begin
     rflg:=false;
   end;
 {
   if cppktt='vyhdn' then begin
     if ((tar1='kaluga')or(tar2='kaluga')) then begin rflg:=false; end;
     if ((tar1='kursk')or(tar2='kursk')) then begin rflg:=false; end;
     if ((tar1='orel')or(tar2='orel')) then begin rflg:=false; end;
   end;
   if ((cppktt='5dat')or(cppktt='6dat')or(cppktt='7dat')or(cppktt='8dat')or(cppktt='9dat')or(cppktt='10dat')or(cppktt='11dat')or(cppktt='12dat')or(cppktt='13dat')or(cppktt='14dat')or(cppktt='15dat')or(cppktt='16dat')) then begin
     if ((tar1='kaluga')or(tar2='kaluga')) then begin rflg:=false; end;
     if ((tar1='kursk')or(tar2='kursk')) then begin rflg:=false; end;
     if ((tar1='orel')or(tar2='orel')) then begin rflg:=false; end;
   end;
  }
  result:=rflg;
end;


Function CheckAppDisableExpress(tar1,tar2,cppktt:string):boolean;
 var rflg:boolean;
begin
 rflg:=true;
 tar1:=ansilowercase(tar1);
 tar2:=ansilowercase(tar2);
 cppktt:=ansilowercase(cppktt);
   if ((cppktt='5dat')or(cppktt='6dat')or(cppktt='7dat')or(cppktt='8dat')or(cppktt='9dat')or(cppktt='10dat')or(cppktt='11dat')or(cppktt='12dat')or(cppktt='13dat')or(cppktt='14dat')or(cppktt='15dat')or(cppktt='16dat')) then begin
     rflg:=false;
   end;
 {
   if cppktt='vyhdn' then begin
     if ((tar1='kaluga')or(tar2='kaluga')) then begin rflg:=false; end;
     if ((tar1='kursk')or(tar2='kursk')) then begin rflg:=false; end;
     if ((tar1='orel')or(tar2='orel')) then begin rflg:=false; end;
   end;
   if ((cppktt='5dat')or(cppktt='6dat')or(cppktt='7dat')or(cppktt='8dat')or(cppktt='9dat')or(cppktt='10dat')or(cppktt='11dat')or(cppktt='12dat')or(cppktt='13dat')or(cppktt='14dat')or(cppktt='15dat')or(cppktt='16dat')) then begin
     if ((tar1='kaluga')or(tar2='kaluga')) then begin rflg:=false; end;
     if ((tar1='kursk')or(tar2='kursk')) then begin rflg:=false; end;
     if ((tar1='orel')or(tar2='orel')) then begin rflg:=false; end;
   end;
  }
  result:=rflg;
end;


procedure Calc_Zone_Seg_CPPK(skv:boolean);
  var i,n:integer;
  var tariff:TZOut;
  var f1:AF_types.TSTrings;
  var s:string;
  var tarlist:TAbTarifList;
  var tarres:boolean;
  var vflag:boolean;
begin
msklogflag:=true;
with form1 do begin
  stringgrid1.cells[1,0]:=trim(ansilowercase(stringgrid1.cells[1,0]));
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
    stringgrid1.Cells[6,i]:=trim(ansilowercase(stringgrid1.Cells[6,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     vflag:=true;
     if CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,n]) then begin
       if skv then begin
        if stringgrid1.Cells[6,i]=stringgrid1.Cells[6,n] then vflag:=false;
       end;
     if vflag then begin
       tariff:=Calc_Zone_Internal_Seg_V2(i,n,false);
       if checkbox21.Checked then tarres:=GetCPPKTariffMySQLAll(stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],tarlist);
       comparecppktzone1(stringgrid1.Cells[0,i],stringgrid1.Cells[0,n],stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'etrain',tarlist,tarres,tariff.price,false);
       if strtointe(stringgrid1.Cells[0,i])=0 then tariff.price:=0;
       if strtointe(stringgrid1.Cells[0,n])=0 then tariff.price:=0;
       if tariff.price>0 then begin
         if tarlist.etrain>0 then tariff.price:=tarlist.etrain;
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="etrain" reverse="1" />');
//         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="reduced" reverse="1" />');

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'reduced') then begin
             {if tarlist.reduced>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.reduced)+'" type="reduced" reverse="1" />');
         end
          else begin
 //           msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - child :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="reduced" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'child') then begin
             {if tarlist.child>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.child)+'" type="child" reverse="1" />');
         end
          else begin
 //           msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - child :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="child" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'animal') then begin
             {if tarlist.animal>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.animal)+'" type="animal" reverse="1" />');
         end
          else begin
   //         msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - animal :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="animal" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'handbag') then begin
             {if tarlist.handbag>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.handbag)+'" type="handbag" reverse="1" />');
         end
          else begin
     //       msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - handbag :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="handbag" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'velzh') then begin
             {if tarlist.velzh>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.velzh)+'" type="velzh" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - velzh :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="velzh" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1m') then begin
             {if tarlist.m1>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m1)+'" type="1m" reverse="1" />');
         end
          else begin
  //          msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 1m :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="1m" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'3m') then begin
             {if tarlist.m3>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m3)+'" type="3m" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 3m :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="3m" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'12m') then begin
             {if tarlist.m12>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m12)+'" type="12m" reverse="1" />');
         end
          else begin
  //          msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 12m :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="12m" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1mr') then begin
             {if tarlist.m1r>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m1r)+'" type="1mr" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 1mr :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="1mr" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'3mr') then begin
             {if tarlist.m3r>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.m3r)+'" type="3mr" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 3mr :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="3mr" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'10d') then begin
             {if tarlist.d10>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.d10)+'" type="10d" reverse="1" />');
         end
          else begin
  //          msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 10d :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="10d" reverse="1" />');
          end;


         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'5dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat5)+'" type="5dat" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 5dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="5dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'6dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat6)+'" type="6dat" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 6dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="6dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'7dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat7)+'" type="7dat" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 7dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="7dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'8dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat8)+'" type="8dat" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 8dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="8dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'9dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat9)+'" type="9dat" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 9dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="9dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'10dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat10)+'" type="10dat" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 10dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="10dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'11dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat11)+'" type="11dat" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 11dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="11dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'12dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat12)+'" type="12dat" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 12dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="12dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'13dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat13)+'" type="13dat" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 13dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="13dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'14dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat14)+'" type="14dat" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 14dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="14dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'15dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat15)+'" type="15dat" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 15dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="15dat" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'16dat') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.dat16)+'" type="16dat" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 16dat :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="16dat" reverse="1" />');
          end;






         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'vyhdn') then begin
             {if tarlist.vyhdn>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.vyhdn)+'" type="vyhdn" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - vyhdn :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="vyhdn" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'10p') then begin
             {if tarlist.p10>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.p10)+'" type="10p" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 10p :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="10p" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'20p') then begin
             {if tarlist.p20>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.p20)+'" type="20p" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 20p :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="20p" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'60p') then begin
             {if tarlist.p60>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.p60)+'" type="60p" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 60p :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="60p" reverse="1" />');
          end;

        if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'uglski') then begin
             {if tarlist.uglski>0 then} WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.uglski)+'" type="uglski" reverse="1" />');
         end
          else begin
//            msk3500log.add(GetCPPKstnameBYesr(stringgrid1.Cells[0,i])+' ('+stringgrid1.Cells[0,i]+') - '+GetCPPKstnameBYesr(stringgrid1.Cells[0,n])+' ('+stringgrid1.Cells[0,n]+') - 60p :     ,  ');
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="uglski" reverse="1" />');
          end;

        if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'krskm_sp') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.krskm_sp)+'" type="krskm_sp" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="krskm_sp" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'krskm_child') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.krskm_child)+'" type="krskm_child" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="krskm_child" reverse="1" />');
          end;

         if CheckAppDisable(stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'krskm_animal') then begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.krskm_animal)+'" type="krskm_animal" reverse="1" />');
         end
          else begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="krskm_animal" reverse="1" />');
          end;

         

         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.mcd)+'" type="mcd" reverse="1" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.mcd_dal)+'" type="mcd_dal" reverse="1" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.mcd_1dat)+'" type="mcd_1dat" reverse="1" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.mcd_3dat)+'" type="mcd_3dat" reverse="1" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.mcd_30dat)+'" type="mcd_30dat" reverse="1" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.mcd_90dat)+'" type="mcd_90dat" reverse="1" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.mcd_365dat)+'" type="mcd_365dat" reverse="1" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.mcd_1m_st)+'" type="mcd_1m_st" reverse="1" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.mcd_3m_st)+'" type="mcd_3m_st" reverse="1" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tarlist.mcd_60p)+'" type="mcd_60p" reverse="1" />');

         WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(tariff.price)+';'+tariff.legend);
         stringgrid1.Cells[i+5,n]:=floattostr(tariff.price);


       end;
     end;
     end;
    end;
  end;
  f1.create;
    for i:=0 to stringgrid1.RowCount-1 do begin
      s:='';
      for n:=0 to stringgrid1.ColCount-1 do begin
        s:=s+stringgrid1.cells[n,i]+';';
      end;
      f1.add(s);
    end;
//  f1.savetofile(SaveDialog1.FileName+'.angle.csv');
  f1.free;
end;
end;




Procedure CompareCPPKTZone1(stat1,stat2,tar1,tar2,cppktt:string; cppktar:TAbTarifList; cppkres:boolean; var res:real; deletezerotariff:boolean);
 var rcppk:real;
 var rflg:boolean;
begin
   rcppk:=-157286.0221;
   if cppktt='etrain' then rcppk:=cppktar.etrain;
   if cppktt='1m' then rcppk:=cppktar.m1;
   if cppktt='1mr' then rcppk:=cppktar.m1r;
   if cppktt='3m' then rcppk:=cppktar.m3;
   if cppktt='3mr' then rcppk:=cppktar.m3r;
   if cppktt='12m' then rcppk:=cppktar.m12;
   if cppktt='5d' then rcppk:=cppktar.d5;
   if cppktt='10d' then rcppk:=cppktar.d10;
   if cppktt='15d' then rcppk:=cppktar.d15;
   if cppktt='10dr' then rcppk:=cppktar.d10r;
   if cppktt='15dr' then rcppk:=cppktar.d15r;
   if cppktt='5dat' then rcppk:=cppktar.dat5;
   if cppktt='6dat' then rcppk:=cppktar.dat6;
   if cppktt='7dat' then rcppk:=cppktar.dat7;
   if cppktt='8dat' then rcppk:=cppktar.dat8;
   if cppktt='9dat' then rcppk:=cppktar.dat9;
   if cppktt='10dat' then rcppk:=cppktar.dat10;
   if cppktt='11dat' then rcppk:=cppktar.dat11;
   if cppktt='12dat' then rcppk:=cppktar.dat12;
   if cppktt='13dat' then rcppk:=cppktar.dat13;
   if cppktt='14dat' then rcppk:=cppktar.dat14;
   if cppktt='15dat' then rcppk:=cppktar.dat15;
   if cppktt='16dat' then rcppk:=cppktar.dat16;
   if cppktt='10p' then rcppk:=cppktar.p10;
   if cppktt='20p' then rcppk:=cppktar.p20;
   if cppktt='60p' then rcppk:=cppktar.p60;
   if cppktt='90p' then rcppk:=cppktar.p90;
   if cppktt='vyhdn' then rcppk:=cppktar.vyhdn;
   if cppktt='child' then rcppk:=cppktar.child;
   if cppktt='handbag' then rcppk:=cppktar.handbag;
   if cppktt='animal' then rcppk:=cppktar.animal;
   if cppktt='velzh' then rcppk:=cppktar.velzh;
   if cppktt='uglski' then rcppk:=cppktar.uglski;

   if rcppk=-157286.0221 then begin
     showmessage('  CompareCPPKTZone1!');
     halt(11);
   end;
   rflg:=CheckAppDisable(tar1,tar2,cppktt);
   if rflg then begin
    if cppkres then begin
     if rcppk>0 then begin
       if floattostr(rcppk)<>floattostr(res) then begin
         msk3500log.add(GetCPPKstnameBYesr(stat1)+' ('+stat1+') - '+GetCPPKstnameBYesr(stat2)+' ('+stat2+') - '+cppktt+' :   - '+FloatToStr(res)+',     - '+FloatToStr(rcppk)+',    ');
         res:=rcppk;
       end;
     end
      else begin
       if deletezerotariff then begin
        msk3500log.add(GetCPPKstnameBYesr(stat1)+' ('+stat1+') - '+GetCPPKstnameBYesr(stat2)+' ('+stat2+') - '+cppktt+' :      ,  ');
        res:=0;
       end;
      end;
    end
     else begin
       if deletezerotariff then begin
       msk3500log.add(GetCPPKstnameBYesr(stat1)+' ('+stat1+') - '+GetCPPKstnameBYesr(stat2)+' ('+stat2+') - '+cppktt+' :      ,  ');
       res:=0;
       end;
     end;
   end
    else begin
//      msk3500log.add(GetCPPKstnameBYesr(stat1)+' ('+stat1+') - '+GetCPPKstnameBYesr(stat2)+' ('+stat2+') - '+cppktt+' :   (v2)   ,  ');
      res:=0;
    end;
end;

procedure Calc_Zone_AB3700_Internal_072014(i,n:integer);
  var z,v,m:integer;
  var res:real;
  var tzn,tzc1,tzc2:AF_Types.TStrings;
  var s,lastn,lastz,startz,stat1,stat2,tar1,tar2:string;
  var gflag,cppkres:boolean;
  var t1:TTarif;
  var cppktar:TAbTarifList;
begin
msklogflag:=true;
with form1 do begin
stat1:=stringgrid1.Cells[0,i];
stat2:=stringgrid1.Cells[0,n];
tar1:=stringgrid1.Cells[4,i];
tar2:=stringgrid1.Cells[4,n];
cppkres:=GetCPPKTariffMySQLAll(stat1,stat2,cppktar);
tzn.create; tzc1.create; tzc2.create;
lastn:='##599##234';
lastz:='';
startz:='';
res:=0;
  for m:=i to n do begin
   if CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,m]) then begin
     if lastn<>StringGrid1.cells[4,m] then begin
       if lastn='##599##234' then begin
         lastn:='##599##239';
         startz:=StringGrid1.cells[3,m];
       end
        else begin
         if lastn='##599##239' then begin
           lastn:=StringGrid1.cells[4,m];
         end
          else begin
           tzn.add(lastn);
           tzc1.add(startz);
           tzc2.add(lastz);
           lastn:=StringGrid1.cells[4,m];
           startz:=lastz;
          end;
        end;
     end;
     lastz:=StringGrid1.cells[3,m];
   end;
  end;
  if lastn<>'##599##234' then begin
  if lastn<>'##599##239' then begin
    tzn.add(lastn);
    tzc1.add(startz);
    tzc2.add(lastz);
  end;
  end;
  s:='';
  if tzn.count>0 then begin
    gflag:=false;
    if ((validstr(stringgrid1.Cells[6,i]))and(validstr(stringgrid1.Cells[6,n]))) then begin
     if stringgrid1.Cells[6,i]=stringgrid1.Cells[6,n] then gflag:=true;
    end;
    if gflag then begin
//         -      ,  .
       GetTarifInfo(stringgrid1.Cells[6,i],'10D',1,t1);
       if not t1.finmode then begin
        if 1>t1.limit then res:=(1*t1.price_km)
                        else res:=t1.price_limit;
       end
        else res:=t1.finprice;
       if checkbox5.checked then begin
        if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'10d',cppktar,cppkres,res,true);
         writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="10d" reverse="1" />');
       end;
       res:=0;
       GetTarifInfo(stringgrid1.Cells[6,i],'10P',1,t1);
       if not t1.finmode then begin
        if 1>t1.limit then res:=(1*t1.price_km)
                        else res:=t1.price_limit;
       end
        else res:=t1.finprice;
       if checkbox19.checked then begin
        if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'10p',cppktar,cppkres,res,true);
         writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="10p" reverse="1" />');
       end;
       res:=0;
       GetTarifInfo(stringgrid1.Cells[6,i],'20P',1,t1);
       if not t1.finmode then begin
        if 1>t1.limit then res:=(1*t1.price_km)
                        else res:=t1.price_limit;
       end
        else res:=t1.finprice;
       if checkbox19.checked then begin
        if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'20p',cppktar,cppkres,res,true);
         writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="20p" reverse="1" />');
       end;
       res:=0;
       GetTarifInfo(stringgrid1.Cells[6,i],'60P',1,t1);
       if not t1.finmode then begin
        if 1>t1.limit then res:=(1*t1.price_km)
                        else res:=t1.price_limit;
       end
        else res:=t1.finprice;
       if checkbox19.checked then begin
        if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'60p',cppktar,cppkres,res,true);
         writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="60p" reverse="1" />');
       end;
       res:=0;
    end
    else begin
     res:=0;

     if checkbox18.checked then begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
       GetTarifInfo(tzn.getstring(v),'VYHDN',z,t1);
        if not t1.finmode then begin
         if z>t1.limit then res:=res+(z*t1.price_km)
                         else res:=res+t1.price_limit;
        end
         else res:=res+t1.finprice;
       if res=0 then break;
     end;
     if checkbox18.checked then begin
      if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'vyhdn',cppktar,cppkres,res,true);
       writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="vyhdn" reverse="1" />');
     end;
     res:=0;
     end;

     if checkbox5.checked then begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
       GetTarifInfo(tzn.getstring(v),'10D',z,t1);
        if not t1.finmode then begin
         if z>t1.limit then res:=res+(z*t1.price_km)
                         else res:=res+t1.price_limit;
        end
         else res:=res+t1.finprice;
       if res=0 then break;
     end;
     if checkbox5.checked then begin
      if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'10d',cppktar,cppkres,res,true);
       writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="10d" reverse="1" />');
     end;
     res:=0;
     end;

     if checkbox13.checked then begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
       GetTarifInfo(tzn.getstring(v),'5DAT',z,t1);
        if not t1.finmode then begin
         if z>t1.limit then res:=res+(z*t1.price_km)
                         else res:=res+t1.price_limit;
        end
         else res:=res+t1.finprice;
       if res=0 then break;
     end;
     if checkbox13.checked then begin
      showmessage(' " "    !');
      halt(12);
      if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'5dat',cppktar,cppkres,res,true);
       writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="5dat" reverse="1" />');
     end;
     res:=0;
     end;

     if checkbox13.checked then begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
       GetTarifInfo(tzn.getstring(v),'6DAT',z,t1);
        if not t1.finmode then begin
         if z>t1.limit then res:=res+(z*t1.price_km)
                         else res:=res+t1.price_limit;
        end
         else res:=res+t1.finprice;
       if res=0 then break;
     end;
     if checkbox13.checked then begin
      showmessage(' " "    !');
      halt(12);
      if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'6dat',cppktar,cppkres,res,true);
       writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="6dat" reverse="1" />');
     end;
     res:=0;
     end;

     if checkbox13.checked then begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
       GetTarifInfo(tzn.getstring(v),'7DAT',z,t1);
        if not t1.finmode then begin
         if z>t1.limit then res:=res+(z*t1.price_km)
                         else res:=res+t1.price_limit;
        end
         else res:=res+t1.finprice;
       if res=0 then break;
     end;
     if checkbox13.checked then begin
      showmessage(' " "    !');
      halt(12);
      if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'7dat',cppktar,cppkres,res,true);
       writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="7dat" reverse="1" />');
     end;
     res:=0;
     end;

     if checkbox13.checked then begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
       GetTarifInfo(tzn.getstring(v),'8DAT',z,t1);
        if not t1.finmode then begin
         if z>t1.limit then res:=res+(z*t1.price_km)
                         else res:=res+t1.price_limit;
        end
         else res:=res+t1.finprice;
       if res=0 then break;
     end;
     if checkbox13.checked then begin
      showmessage(' " "    !');
      halt(12);
      if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'8dat',cppktar,cppkres,res,true);
       writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="8dat" reverse="1" />');
     end;
     res:=0;
     end;

     if checkbox13.checked then begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
       GetTarifInfo(tzn.getstring(v),'9DAT',z,t1);
        if not t1.finmode then begin
         if z>t1.limit then res:=res+(z*t1.price_km)
                         else res:=res+t1.price_limit;
        end
         else res:=res+t1.finprice;
       if res=0 then break;
     end;
     if checkbox13.checked then begin
      showmessage(' " "    !');
      halt(12);
      if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'9dat',cppktar,cppkres,res,true);
       writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="9dat" reverse="1" />');
     end;
     res:=0;
     end;

     if checkbox13.checked then begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
       GetTarifInfo(tzn.getstring(v),'10DAT',z,t1);
        if not t1.finmode then begin
         if z>t1.limit then res:=res+(z*t1.price_km)
                         else res:=res+t1.price_limit;
        end
         else res:=res+t1.finprice;
       if res=0 then break;
     end;
     if checkbox13.checked then begin
      showmessage(' " "    !');
      halt(12);
      if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'10dat',cppktar,cppkres,res,true);
       writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="10dat" reverse="1" />');
     end;
     res:=0;
     end;

     if checkbox13.checked then begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
       GetTarifInfo(tzn.getstring(v),'11DAT',z,t1);
        if not t1.finmode then begin
         if z>t1.limit then res:=res+(z*t1.price_km)
                         else res:=res+t1.price_limit;
        end
         else res:=res+t1.finprice;
       if res=0 then break;
     end;
     if checkbox13.checked then begin
      showmessage(' " "    !');
      halt(12);
      if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'11dat',cppktar,cppkres,res,true);
       writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="11dat" reverse="1" />');
     end;
     res:=0;
     end;

     if checkbox13.checked then begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
       GetTarifInfo(tzn.getstring(v),'12DAT',z,t1);
        if not t1.finmode then begin
         if z>t1.limit then res:=res+(z*t1.price_km)
                         else res:=res+t1.price_limit;
        end
         else res:=res+t1.finprice;
       if res=0 then break;
     end;
     if checkbox13.checked then begin
      showmessage(' " "    !');
      halt(12);
      if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'12dat',cppktar,cppkres,res,true);
       writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="12dat" reverse="1" />');
     end;
     res:=0;
     end;

     if checkbox13.checked then begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
       GetTarifInfo(tzn.getstring(v),'13DAT',z,t1);
        if not t1.finmode then begin
         if z>t1.limit then res:=res+(z*t1.price_km)
                         else res:=res+t1.price_limit;
        end
         else res:=res+t1.finprice;
       if res=0 then break;
     end;
     if checkbox13.checked then begin
      showmessage(' " "    !');
      halt(12);
      if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'13dat',cppktar,cppkres,res,true);
       writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="13dat" reverse="1" />');
     end;
     res:=0;
     end;

     if checkbox13.checked then begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
       GetTarifInfo(tzn.getstring(v),'14DAT',z,t1);
        if not t1.finmode then begin
         if z>t1.limit then res:=res+(z*t1.price_km)
                         else res:=res+t1.price_limit;
        end
         else res:=res+t1.finprice;
       if res=0 then break;
     end;
     if checkbox13.checked then begin
      showmessage(' " "    !');
      halt(12);
      if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'14dat',cppktar,cppkres,res,true);
       writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="14dat" reverse="1" />');
     end;
     res:=0;
     end;

     if checkbox13.checked then begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
       GetTarifInfo(tzn.getstring(v),'15DAT',z,t1);
        if not t1.finmode then begin
         if z>t1.limit then res:=res+(z*t1.price_km)
                         else res:=res+t1.price_limit;
        end
         else res:=res+t1.finprice;
       if res=0 then break;
     end;
     if checkbox13.checked then begin
      showmessage(' " "    !');
      halt(12);
      if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'15dat',cppktar,cppkres,res,true);
       writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="15dat" reverse="1" />');
     end;
     res:=0;
     end;

     if checkbox13.checked then begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
       GetTarifInfo(tzn.getstring(v),'16DAT',z,t1);
        if not t1.finmode then begin
         if z>t1.limit then res:=res+(z*t1.price_km)
                         else res:=res+t1.price_limit;
        end
         else res:=res+t1.finprice;
       if res=0 then break;
     end;
     if checkbox13.checked then begin
      showmessage(' " "    !');
      halt(12);
      if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'16dat',cppktar,cppkres,res,true);
       writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="16dat" reverse="1" />');
     end;
     res:=0;
     end;

     if checkbox19.checked then begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
       GetTarifInfo(tzn.getstring(v),'10P',z,t1);
        if not t1.finmode then begin
         if z>t1.limit then res:=res+(z*t1.price_km)
                         else res:=res+t1.price_limit;
        end
         else res:=res+t1.finprice;
       if res=0 then break;
     end;
     if checkbox19.checked then begin
      if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'10p',cppktar,cppkres,res,true);
       writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="10p" reverse="1" />');
     end;
     res:=0;
     end;

     if checkbox19.checked then begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
       GetTarifInfo(tzn.getstring(v),'20P',z,t1);
        if not t1.finmode then begin
         if z>t1.limit then res:=res+(z*t1.price_km)
                         else res:=res+t1.price_limit;
        end
         else res:=res+t1.finprice;
       if res=0 then break;
     end;
     if checkbox19.checked then begin
      if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'20p',cppktar,cppkres,res,true);
       writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="20p" reverse="1" />');
     end;
     res:=0;
     end;

     if checkbox19.checked then begin
     for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
       GetTarifInfo(tzn.getstring(v),'60P',z,t1);
        if not t1.finmode then begin
         if z>t1.limit then res:=res+(z*t1.price_km)
                         else res:=res+t1.price_limit;
        end
         else res:=res+t1.finprice;
       if res=0 then break;
     end;
     if checkbox19.checked then begin
      if checkbox21.Checked then CompareCPPKTZone1(stat1,stat2,tar1,tar2,'60p',cppktar,cppkres,res,true);
       writeln(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(res)+'" type="60p" reverse="1" />');
     end;
     res:=0;
     end;

    end;
  end;
tzn.free; tzc1.free; tzc2.free;

end;
end;


procedure Calc_Zone_AB3700_072014;
  var i,n:integer;
begin
msklogflag:=true;
with form1 do begin
  stringgrid1.cells[1,0]:=trim(ansilowercase(stringgrid1.cells[1,0]));
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     if CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,n]) then begin
       Calc_Zone_AB3700_Internal_072014(i,n);
     end;
    end;
  end;
end;
end;




procedure Calc_NN2013;
  var i,n,ch1,ch2:integer;
  var ch:extended;
  var tariff:TZOut;
  var f1:AF_types.TSTrings;
  var s:string;
begin
with form1 do begin
  stringgrid1.cells[1,0]:=trim(ansilowercase(stringgrid1.cells[1,0]));
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     if CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,n]) then begin
       tariff:=Calc_Zone_Internal_Seg_NN2013(i,n);
       if tariff.price>0 then begin
        if pos('express',stringgrid1.cells[1,0])>0 then begin
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="'+stringgrid1.cells[1,0]+'" reverse="1" insearch="0" />');
        end
         else begin
          if pos('nnmet',stringgrid1.cells[1,0])>0 then begin
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="'+stringgrid1.cells[1,0]+'" reverse="1" insearch="0" />');
          end
           else begin
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="etrain" reverse="1" />');
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price/2)+'" type="reduced" reverse="1" />');
             ch1:=trunc(tariff.price/4);     //        4    
            // ch2:=trunc(frac(tariff.price/4)*10);
             ch:=0;
            // if ch2>0 then begin
            //   if ch2<=5 then ch:=0.5
            //             else ch:=1;
            // end;
             if pos('kirov',AnsiLowerCase(tariff.legend))<=0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(ch+ch1)+'" type="child" reverse="1" />');
           end;
         end;
         WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(tariff.price)+';'+tariff.legend);
         stringgrid1.Cells[i+5,n]:=floattostr(tariff.price);
       end;
     end;
    end;
  end;
  f1.create;
    for i:=0 to stringgrid1.RowCount-1 do begin
      s:='';
      for n:=0 to stringgrid1.ColCount-1 do begin
        s:=s+stringgrid1.cells[n,i]+';';
      end;
      f1.add(s);
    end;
  f1.savetofile(SaveDialog1.FileName+'.angle.csv');
  f1.free;
end;
end;
(*
function GetSPB3700Ab(km:real;code:string;lim:boolean;ab:TAbTarifList;add:boolean):TAbTarifList;
  var km1:integer;
  var res:TAbTarifList;
begin
 res.m1:=0;
 res.m1r:=0;
 res.d5:=0;
 res.d10:=0;
 res.d15:=0;
 res.d10r:=0;
 res.d15r:=0;
 res.dat5:=0;
 res.dat6:=0;
 res.dat7:=0;
 res.dat8:=0;
 res.dat9:=0;
 res.dat10:=0;
 res.dat11:=0;
 res.dat12:=0;
 res.dat13:=0;
 res.dat14:=0;
 res.dat15:=0;
 res.dat16:=0;
 SetRoundMode(rmNearest);
 km1:=Round(km);
 code:=AnsiLowerCase(trim(code));
 with res do begin
 if ((code='spb')or(code='spb1')or(code='spb11')or(code='spb2')or(code='spba')or(code='spba1')) then begin
  if km1>0 then begin
  if km1=1 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=2 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=3 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=4 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=5 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=6 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=7 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=8 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=9 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=10 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=11 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=12 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=13 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=14 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=15 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=16 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=17 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=18 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=19 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=20 then begin res.d5:=306; res.d10:=490; res.d15:=734; res.m1:=1439; res.d10r:=428; res.d15r:=612; res.m1r:=1255; res.dat5:=306; res.dat6:=367; res.dat7:=428; res.dat8:=490; res.dat9:=551; res.dat10:=612; res.dat11:=673; res.dat12:=734; res.dat13:=796; res.dat14:=857; res.dat15:=918; res.dat16:=979; end;
  if km1=21 then begin res.d5:=320; res.d10:=513; res.d15:=769; res.m1:=1507; res.d10r:=449; res.d15r:=641; res.m1r:=1314; res.dat5:=320; res.dat6:=384; res.dat7:=448; res.dat8:=512; res.dat9:=576; res.dat10:=640; res.dat11:=704; res.dat12:=768; res.dat13:=832; res.dat14:=896; res.dat15:=960; res.dat16:=1024; end;
  if km1=22 then begin res.d5:=338; res.d10:=541; res.d15:=812; res.m1:=1591; res.d10r:=473; res.d15r:=676; res.m1r:=1387; res.dat5:=338; res.dat6:=406; res.dat7:=473; res.dat8:=541; res.dat9:=608; res.dat10:=676; res.dat11:=744; res.dat12:=811; res.dat13:=879; res.dat14:=946; res.dat15:=1014; res.dat16:=1082; end;
  if km1=23 then begin res.d5:=347; res.d10:=555; res.d15:=833; res.m1:=1633; res.d10r:=486; res.d15r:=694; res.m1r:=1423; res.dat5:=347; res.dat6:=416; res.dat7:=486; res.dat8:=555; res.dat9:=625; res.dat10:=694; res.dat11:=763; res.dat12:=833; res.dat13:=902; res.dat14:=972; res.dat15:=1041; res.dat16:=1110; end;
  if km1=24 then begin res.d5:=365; res.d10:=584; res.d15:=876; res.m1:=1716; res.d10r:=511; res.d15r:=730; res.m1r:=1496; res.dat5:=365; res.dat6:=438; res.dat7:=511; res.dat8:=584; res.dat9:=657; res.dat10:=730; res.dat11:=803; res.dat12:=876; res.dat13:=949; res.dat14:=1022; res.dat15:=1095; res.dat16:=1168; end;
  if km1=25 then begin res.d5:=383; res.d10:=612; res.d15:=918; res.m1:=1800; res.d10r:=536; res.d15r:=765; res.m1r:=1569; res.dat5:=383; res.dat6:=460; res.dat7:=536; res.dat8:=613; res.dat9:=689; res.dat10:=766; res.dat11:=843; res.dat12:=919; res.dat13:=996; res.dat14:=1072; res.dat15:=1149; res.dat16:=1226; end;
  if km1=26 then begin res.d5:=392; res.d10:=627; res.d15:=940; res.m1:=1842; res.d10r:=548; res.d15r:=783; res.m1r:=1606; res.dat5:=392; res.dat6:=470; res.dat7:=549; res.dat8:=627; res.dat9:=706; res.dat10:=784; res.dat11:=862; res.dat12:=941; res.dat13:=1019; res.dat14:=1098; res.dat15:=1176; res.dat16:=1254; end;
  if km1=27 then begin res.d5:=409; res.d10:=655; res.d15:=983; res.m1:=1926; res.d10r:=573; res.d15r:=819; res.m1r:=1679; res.dat5:=409; res.dat6:=491; res.dat7:=573; res.dat8:=654; res.dat9:=736; res.dat10:=818; res.dat11:=900; res.dat12:=982; res.dat13:=1063; res.dat14:=1145; res.dat15:=1227; res.dat16:=1309; end;
  if km1=28 then begin res.d5:=427; res.d10:=684; res.d15:=1025; res.m1:=2010; res.d10r:=598; res.d15r:=854; res.m1r:=1752; res.dat5:=427; res.dat6:=512; res.dat7:=598; res.dat8:=683; res.dat9:=769; res.dat10:=854; res.dat11:=939; res.dat12:=1025; res.dat13:=1110; res.dat14:=1196; res.dat15:=1281; res.dat16:=1366; end;
  if km1=29 then begin res.d5:=445; res.d10:=712; res.d15:=1068; res.m1:=2093; res.d10r:=623; res.d15r:=890; res.m1r:=1825; res.dat5:=445; res.dat6:=534; res.dat7:=623; res.dat8:=712; res.dat9:=801; res.dat10:=890; res.dat11:=979; res.dat12:=1068; res.dat13:=1157; res.dat14:=1246; res.dat15:=1335; res.dat16:=1424; end;
  if km1=30 then begin res.d5:=454; res.d10:=726; res.d15:=1089; res.m1:=2135; res.d10r:=635; res.d15r:=908; res.m1r:=1861; res.dat5:=454; res.dat6:=545; res.dat7:=636; res.dat8:=726; res.dat9:=817; res.dat10:=908; res.dat11:=999; res.dat12:=1090; res.dat13:=1180; res.dat14:=1271; res.dat15:=1362; res.dat16:=1453; end;
  if km1=31 then begin res.d5:=472; res.d10:=755; res.d15:=1132; res.m1:=2219; res.d10r:=660; res.d15r:=943; res.m1r:=1934; res.dat5:=472; res.dat6:=566; res.dat7:=661; res.dat8:=755; res.dat9:=850; res.dat10:=944; res.dat11:=1038; res.dat12:=1133; res.dat13:=1227; res.dat14:=1322; res.dat15:=1416; res.dat16:=1510; end;
  if km1=32 then begin res.d5:=490; res.d10:=783; res.d15:=1175; res.m1:=2303; res.d10r:=685; res.d15r:=979; res.m1r:=2007; res.dat5:=490; res.dat6:=588; res.dat7:=686; res.dat8:=784; res.dat9:=882; res.dat10:=980; res.dat11:=1078; res.dat12:=1176; res.dat13:=1274; res.dat14:=1372; res.dat15:=1470; res.dat16:=1568; end;
  if km1=33 then begin res.d5:=507; res.d10:=812; res.d15:=1218; res.m1:=2386; res.d10r:=710; res.d15r:=1015; res.m1r:=2080; res.dat5:=507; res.dat6:=608; res.dat7:=710; res.dat8:=811; res.dat9:=913; res.dat10:=1014; res.dat11:=1115; res.dat12:=1217; res.dat13:=1318; res.dat14:=1420; res.dat15:=1521; res.dat16:=1622; end;
  if km1=34 then begin res.d5:=516; res.d10:=826; res.d15:=1239; res.m1:=2428; res.d10r:=723; res.d15r:=1032; res.m1r:=2116; res.dat5:=516; res.dat6:=619; res.dat7:=722; res.dat8:=826; res.dat9:=929; res.dat10:=1032; res.dat11:=1135; res.dat12:=1238; res.dat13:=1342; res.dat14:=1445; res.dat15:=1548; res.dat16:=1651; end;
  if km1=35 then begin res.d5:=534; res.d10:=854; res.d15:=1282; res.m1:=2512; res.d10r:=748; res.d15r:=1068; res.m1r:=2189; res.dat5:=534; res.dat6:=641; res.dat7:=748; res.dat8:=854; res.dat9:=961; res.dat10:=1068; res.dat11:=1175; res.dat12:=1282; res.dat13:=1388; res.dat14:=1495; res.dat15:=1602; res.dat16:=1709; end;
  if km1=36 then begin res.d5:=552; res.d10:=883; res.d15:=1324; res.m1:=2596; res.d10r:=773; res.d15r:=1104; res.m1r:=2262; res.dat5:=552; res.dat6:=662; res.dat7:=773; res.dat8:=883; res.dat9:=994; res.dat10:=1104; res.dat11:=1214; res.dat12:=1325; res.dat13:=1435; res.dat14:=1546; res.dat15:=1656; res.dat16:=1766; end;
  if km1=37 then begin res.d5:=570; res.d10:=911; res.d15:=1367; res.m1:=2679; res.d10r:=797; res.d15r:=1139; res.m1r:=2335; res.dat5:=570; res.dat6:=684; res.dat7:=798; res.dat8:=912; res.dat9:=1026; res.dat10:=1140; res.dat11:=1254; res.dat12:=1368; res.dat13:=1482; res.dat14:=1596; res.dat15:=1710; res.dat16:=1824; end;
  if km1=38 then begin res.d5:=579; res.d10:=926; res.d15:=1388; res.m1:=2721; res.d10r:=810; res.d15r:=1157; res.m1r:=2372; res.dat5:=579; res.dat6:=695; res.dat7:=811; res.dat8:=926; res.dat9:=1042; res.dat10:=1158; res.dat11:=1274; res.dat12:=1390; res.dat13:=1505; res.dat14:=1621; res.dat15:=1737; res.dat16:=1853; end;
  if km1=39 then begin res.d5:=596; res.d10:=954; res.d15:=1431; res.m1:=2805; res.d10r:=835; res.d15r:=1193; res.m1r:=2445; res.dat5:=596; res.dat6:=715; res.dat7:=834; res.dat8:=954; res.dat9:=1073; res.dat10:=1192; res.dat11:=1311; res.dat12:=1430; res.dat13:=1550; res.dat14:=1669; res.dat15:=1788; res.dat16:=1907; end;
  if km1=40 then begin res.d5:=614; res.d10:=983; res.d15:=1474; res.m1:=2889; res.d10r:=860; res.d15r:=1228; res.m1r:=2518; res.dat5:=614; res.dat6:=737; res.dat7:=860; res.dat8:=982; res.dat9:=1105; res.dat10:=1228; res.dat11:=1351; res.dat12:=1474; res.dat13:=1596; res.dat14:=1719; res.dat15:=1842; res.dat16:=1965; end;
  if km1=41 then begin res.d5:=623; res.d10:=997; res.d15:=1495; res.m1:=2931; res.d10r:=872; res.d15r:=1246; res.m1r:=2554; res.dat5:=623; res.dat6:=748; res.dat7:=872; res.dat8:=997; res.dat9:=1121; res.dat10:=1246; res.dat11:=1371; res.dat12:=1495; res.dat13:=1620; res.dat14:=1744; res.dat15:=1869; res.dat16:=1994; end;
  if km1=42 then begin res.d5:=641; res.d10:=1025; res.d15:=1538; res.m1:=3014; res.d10r:=897; res.d15r:=1282; res.m1r:=2627; res.dat5:=641; res.dat6:=769; res.dat7:=897; res.dat8:=1026; res.dat9:=1154; res.dat10:=1282; res.dat11:=1410; res.dat12:=1538; res.dat13:=1667; res.dat14:=1795; res.dat15:=1923; res.dat16:=2051; end;
  if km1=43 then begin res.d5:=659; res.d10:=1054; res.d15:=1581; res.m1:=3098; res.d10r:=922; res.d15r:=1317; res.m1r:=2700; res.dat5:=659; res.dat6:=791; res.dat7:=923; res.dat8:=1054; res.dat9:=1186; res.dat10:=1318; res.dat11:=1450; res.dat12:=1582; res.dat13:=1713; res.dat14:=1845; res.dat15:=1977; res.dat16:=2109; end;
  if km1=44 then begin res.d5:=676; res.d10:=1082; res.d15:=1623; res.m1:=3182; res.d10r:=947; res.d15r:=1353; res.m1r:=2773; res.dat5:=676; res.dat6:=811; res.dat7:=946; res.dat8:=1082; res.dat9:=1217; res.dat10:=1352; res.dat11:=1487; res.dat12:=1622; res.dat13:=1758; res.dat14:=1893; res.dat15:=2028; res.dat16:=2163; end;
  if km1=45 then begin res.d5:=685; res.d10:=1096; res.d15:=1645; res.m1:=3224; res.d10r:=959; res.d15r:=1371; res.m1r:=2810; res.dat5:=685; res.dat6:=822; res.dat7:=959; res.dat8:=1096; res.dat9:=1233; res.dat10:=1370; res.dat11:=1507; res.dat12:=1644; res.dat13:=1781; res.dat14:=1918; res.dat15:=2055; res.dat16:=2192; end;
  if km1=46 then begin res.d5:=703; res.d10:=1125; res.d15:=1687; res.m1:=3307; res.d10r:=984; res.d15r:=1406; res.m1r:=2883; res.dat5:=703; res.dat6:=844; res.dat7:=984; res.dat8:=1125; res.dat9:=1265; res.dat10:=1406; res.dat11:=1547; res.dat12:=1687; res.dat13:=1828; res.dat14:=1968; res.dat15:=2109; res.dat16:=2250; end;
  if km1=47 then begin res.d5:=721; res.d10:=1153; res.d15:=1730; res.m1:=3391; res.d10r:=1009; res.d15r:=1442; res.m1r:=2956; res.dat5:=721; res.dat6:=865; res.dat7:=1009; res.dat8:=1154; res.dat9:=1298; res.dat10:=1442; res.dat11:=1586; res.dat12:=1730; res.dat13:=1875; res.dat14:=2019; res.dat15:=2163; res.dat16:=2307; end;
  if km1=48 then begin res.d5:=739; res.d10:=1182; res.d15:=1773; res.m1:=3475; res.d10r:=1034; res.d15r:=1477; res.m1r:=3029; res.dat5:=739; res.dat6:=887; res.dat7:=1035; res.dat8:=1182; res.dat9:=1330; res.dat10:=1478; res.dat11:=1626; res.dat12:=1774; res.dat13:=1921; res.dat14:=2069; res.dat15:=2217; res.dat16:=2365; end;
  if km1=49 then begin res.d5:=748; res.d10:=1196; res.d15:=1794; res.m1:=3517; res.d10r:=1047; res.d15r:=1495; res.m1r:=3065; res.dat5:=748; res.dat6:=898; res.dat7:=1047; res.dat8:=1197; res.dat9:=1346; res.dat10:=1496; res.dat11:=1646; res.dat12:=1795; res.dat13:=1945; res.dat14:=2094; res.dat15:=2244; res.dat16:=2394; end;
  if km1=50 then begin res.d5:=765; res.d10:=1225; res.d15:=1837; res.m1:=3600; res.d10r:=1072; res.d15r:=1531; res.m1r:=3138; res.dat5:=765; res.dat6:=918; res.dat7:=1071; res.dat8:=1224; res.dat9:=1377; res.dat10:=1530; res.dat11:=1683; res.dat12:=1836; res.dat13:=1989; res.dat14:=2142; res.dat15:=2295; res.dat16:=2448; end;
  if km1=51 then begin res.d5:=783; res.d10:=1253; res.d15:=1880; res.m1:=3750; res.d10r:=1096; res.d15r:=1566; res.m1r:=3200; res.dat5:=783; res.dat6:=940; res.dat7:=1096; res.dat8:=1253; res.dat9:=1409; res.dat10:=1566; res.dat11:=1723; res.dat12:=1879; res.dat13:=2036; res.dat14:=2192; res.dat15:=2349; res.dat16:=2506; end;
  if km1=52 then begin res.d5:=792; res.d10:=1267; res.d15:=1901; res.m1:=3750; res.d10r:=1109; res.d15r:=1584; res.m1r:=3200; res.dat5:=792; res.dat6:=950; res.dat7:=1109; res.dat8:=1267; res.dat9:=1426; res.dat10:=1584; res.dat11:=1742; res.dat12:=1901; res.dat13:=2059; res.dat14:=2218; res.dat15:=2376; res.dat16:=2534; end;
  if km1=53 then begin res.d5:=810; res.d10:=1296; res.d15:=1944; res.m1:=3750; res.d10r:=1134; res.d15r:=1620; res.m1r:=3200; res.dat5:=810; res.dat6:=972; res.dat7:=1134; res.dat8:=1296; res.dat9:=1458; res.dat10:=1620; res.dat11:=1782; res.dat12:=1944; res.dat13:=2106; res.dat14:=2268; res.dat15:=2430; res.dat16:=2592; end;
  if km1=54 then begin res.d5:=828; res.d10:=1324; res.d15:=1986; res.m1:=3750; res.d10r:=1159; res.d15r:=1655; res.m1r:=3200; res.dat5:=828; res.dat6:=994; res.dat7:=1159; res.dat8:=1325; res.dat9:=1490; res.dat10:=1656; res.dat11:=1822; res.dat12:=1987; res.dat13:=2153; res.dat14:=2318; res.dat15:=2484; res.dat16:=2650; end;
  if km1=55 then begin res.d5:=846; res.d10:=1353; res.d15:=2029; res.m1:=3750; res.d10r:=1184; res.d15r:=1691; res.m1r:=3200; res.dat5:=846; res.dat6:=1015; res.dat7:=1184; res.dat8:=1354; res.dat9:=1523; res.dat10:=1692; res.dat11:=1861; res.dat12:=2030; res.dat13:=2200; res.dat14:=2369; res.dat15:=2538; res.dat16:=2707; end;
  if km1=56 then begin res.d5:=854; res.d10:=1367; res.d15:=2051; res.m1:=3750; res.d10r:=1196; res.d15r:=1709; res.m1r:=3200; res.dat5:=854; res.dat6:=1025; res.dat7:=1196; res.dat8:=1366; res.dat9:=1537; res.dat10:=1708; res.dat11:=1879; res.dat12:=2050; res.dat13:=2220; res.dat14:=2391; res.dat15:=2562; res.dat16:=2733; end;
  if km1=57 then begin res.d5:=872; res.d10:=1396; res.d15:=2093; res.m1:=3750; res.d10r:=1221; res.d15r:=1744; res.m1r:=3200; res.dat5:=872; res.dat6:=1046; res.dat7:=1221; res.dat8:=1395; res.dat9:=1570; res.dat10:=1744; res.dat11:=1918; res.dat12:=2093; res.dat13:=2267; res.dat14:=2442; res.dat15:=2616; res.dat16:=2790; end;
  if km1=58 then begin res.d5:=890; res.d10:=1424; res.d15:=2136; res.m1:=3750; res.d10r:=1246; res.d15r:=1780; res.m1r:=3200; res.dat5:=890; res.dat6:=1068; res.dat7:=1246; res.dat8:=1424; res.dat9:=1602; res.dat10:=1780; res.dat11:=1958; res.dat12:=2136; res.dat13:=2314; res.dat14:=2492; res.dat15:=2670; res.dat16:=2848; end;
  if km1=59 then begin res.d5:=908; res.d10:=1452; res.d15:=2179; res.m1:=3750; res.d10r:=1271; res.d15r:=1816; res.m1r:=3200; res.dat5:=908; res.dat6:=1090; res.dat7:=1271; res.dat8:=1453; res.dat9:=1634; res.dat10:=1816; res.dat11:=1998; res.dat12:=2179; res.dat13:=2361; res.dat14:=2542; res.dat15:=2724; res.dat16:=2906; end;
  if km1=60 then begin res.d5:=917; res.d10:=1467; res.d15:=2200; res.m1:=3750; res.d10r:=1283; res.d15r:=1833; res.m1r:=3200; res.dat5:=917; res.dat6:=1100; res.dat7:=1284; res.dat8:=1467; res.dat9:=1651; res.dat10:=1834; res.dat11:=2017; res.dat12:=2201; res.dat13:=2384; res.dat14:=2568; res.dat15:=2751; res.dat16:=2934; end;
  if km1=61 then begin res.d5:=935; res.d10:=1495; res.d15:=2243; res.m1:=3750; res.d10r:=1308; res.d15r:=1869; res.m1r:=3200; res.dat5:=935; res.dat6:=1122; res.dat7:=1309; res.dat8:=1496; res.dat9:=1683; res.dat10:=1870; res.dat11:=2057; res.dat12:=2244; res.dat13:=2431; res.dat14:=2618; res.dat15:=2805; res.dat16:=2992; end;
  if km1=62 then begin res.d5:=952; res.d10:=1524; res.d15:=2286; res.m1:=3750; res.d10r:=1333; res.d15r:=1905; res.m1r:=3200; res.dat5:=952; res.dat6:=1142; res.dat7:=1333; res.dat8:=1523; res.dat9:=1714; res.dat10:=1904; res.dat11:=2094; res.dat12:=2285; res.dat13:=2475; res.dat14:=2666; res.dat15:=2856; res.dat16:=3046; end;
  if km1=63 then begin res.d5:=961; res.d10:=1538; res.d15:=2307; res.m1:=3750; res.d10r:=1346; res.d15r:=1922; res.m1r:=3200; res.dat5:=961; res.dat6:=1153; res.dat7:=1345; res.dat8:=1538; res.dat9:=1730; res.dat10:=1922; res.dat11:=2114; res.dat12:=2306; res.dat13:=2499; res.dat14:=2691; res.dat15:=2883; res.dat16:=3075; end;
  if km1=64 then begin res.d5:=979; res.d10:=1566; res.d15:=2350; res.m1:=3750; res.d10r:=1371; res.d15r:=1958; res.m1r:=3200; res.dat5:=979; res.dat6:=1175; res.dat7:=1371; res.dat8:=1566; res.dat9:=1762; res.dat10:=1958; res.dat11:=2154; res.dat12:=2350; res.dat13:=2545; res.dat14:=2741; res.dat15:=2937; res.dat16:=3133; end;
  if km1=65 then begin res.d5:=997; res.d10:=1595; res.d15:=2392; res.m1:=3750; res.d10r:=1396; res.d15r:=1994; res.m1r:=3200; res.dat5:=997; res.dat6:=1196; res.dat7:=1396; res.dat8:=1595; res.dat9:=1795; res.dat10:=1994; res.dat11:=2193; res.dat12:=2393; res.dat13:=2592; res.dat14:=2792; res.dat15:=2991; res.dat16:=3190; end;
  if km1=66 then begin res.d5:=1015; res.d10:=1623; res.d15:=2435; res.m1:=3750; res.d10r:=1420; res.d15r:=2029; res.m1r:=3200; res.dat5:=1015; res.dat6:=1218; res.dat7:=1421; res.dat8:=1624; res.dat9:=1827; res.dat10:=2030; res.dat11:=2233; res.dat12:=2436; res.dat13:=2639; res.dat14:=2842; res.dat15:=3045; res.dat16:=3248; end;
  if km1=67 then begin res.d5:=1024; res.d10:=1638; res.d15:=2456; res.m1:=3750; res.d10r:=1433; res.d15r:=2047; res.m1r:=3200; res.dat5:=1024; res.dat6:=1229; res.dat7:=1434; res.dat8:=1638; res.dat9:=1843; res.dat10:=2048; res.dat11:=2253; res.dat12:=2458; res.dat13:=2662; res.dat14:=2867; res.dat15:=3072; res.dat16:=3277; end;
  if km1=68 then begin res.d5:=1041; res.d10:=1666; res.d15:=2499; res.m1:=3750; res.d10r:=1458; res.d15r:=2083; res.m1r:=3200; res.dat5:=1041; res.dat6:=1249; res.dat7:=1457; res.dat8:=1666; res.dat9:=1874; res.dat10:=2082; res.dat11:=2290; res.dat12:=2498; res.dat13:=2707; res.dat14:=2915; res.dat15:=3123; res.dat16:=3331; end;
  if km1=69 then begin res.d5:=1059; res.d10:=1695; res.d15:=2542; res.m1:=3750; res.d10r:=1483; res.d15r:=2118; res.m1r:=3200; res.dat5:=1059; res.dat6:=1271; res.dat7:=1483; res.dat8:=1694; res.dat9:=1906; res.dat10:=2118; res.dat11:=2330; res.dat12:=2542; res.dat13:=2753; res.dat14:=2965; res.dat15:=3177; res.dat16:=3389; end;
  if km1=70 then begin res.d5:=1077; res.d10:=1723; res.d15:=2585; res.m1:=3750; res.d10r:=1508; res.d15r:=2154; res.m1r:=3200; res.dat5:=1077; res.dat6:=1292; res.dat7:=1508; res.dat8:=1723; res.dat9:=1939; res.dat10:=2154; res.dat11:=2369; res.dat12:=2585; res.dat13:=2800; res.dat14:=3016; res.dat15:=3231; res.dat16:=3446; end;
  if km1=71 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1086; res.dat6:=1303; res.dat7:=1520; res.dat8:=1738; res.dat9:=1955; res.dat10:=2172; res.dat11:=2389; res.dat12:=2606; res.dat13:=2824; res.dat14:=3041; res.dat15:=3258; res.dat16:=3475; end;
  if km1=72 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1104; res.dat6:=1325; res.dat7:=1546; res.dat8:=1766; res.dat9:=1987; res.dat10:=2208; res.dat11:=2429; res.dat12:=2650; res.dat13:=2870; res.dat14:=3091; res.dat15:=3312; res.dat16:=3533; end;
  if km1=73 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1121; res.dat6:=1345; res.dat7:=1569; res.dat8:=1794; res.dat9:=2018; res.dat10:=2242; res.dat11:=2466; res.dat12:=2690; res.dat13:=2915; res.dat14:=3139; res.dat15:=3363; res.dat16:=3587; end;
  if km1=74 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1139; res.dat6:=1367; res.dat7:=1595; res.dat8:=1822; res.dat9:=2050; res.dat10:=2278; res.dat11:=2506; res.dat12:=2734; res.dat13:=2961; res.dat14:=3189; res.dat15:=3417; res.dat16:=3645; end;
  if km1=75 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1148; res.dat6:=1378; res.dat7:=1607; res.dat8:=1837; res.dat9:=2066; res.dat10:=2296; res.dat11:=2526; res.dat12:=2755; res.dat13:=2985; res.dat14:=3214; res.dat15:=3444; res.dat16:=3674; end;
  if km1=76 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1166; res.dat6:=1399; res.dat7:=1632; res.dat8:=1866; res.dat9:=2099; res.dat10:=2332; res.dat11:=2565; res.dat12:=2798; res.dat13:=3032; res.dat14:=3265; res.dat15:=3498; res.dat16:=3731; end;
  if km1=77 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1184; res.dat6:=1421; res.dat7:=1658; res.dat8:=1894; res.dat9:=2131; res.dat10:=2368; res.dat11:=2605; res.dat12:=2842; res.dat13:=3078; res.dat14:=3315; res.dat15:=3552; res.dat16:=3789; end;
  if km1=78 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1193; res.dat6:=1432; res.dat7:=1670; res.dat8:=1909; res.dat9:=2147; res.dat10:=2386; res.dat11:=2625; res.dat12:=2863; res.dat13:=3102; res.dat14:=3340; res.dat15:=3579; res.dat16:=3818; end;
  if km1=79 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1210; res.dat6:=1452; res.dat7:=1694; res.dat8:=1936; res.dat9:=2178; res.dat10:=2420; res.dat11:=2662; res.dat12:=2904; res.dat13:=3146; res.dat14:=3388; res.dat15:=3630; res.dat16:=3872; end;
  if km1=80 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1228; res.dat6:=1474; res.dat7:=1719; res.dat8:=1965; res.dat9:=2210; res.dat10:=2456; res.dat11:=2702; res.dat12:=2947; res.dat13:=3193; res.dat14:=3438; res.dat15:=3684; res.dat16:=3930; end;
  if km1=81 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1246; res.dat6:=1495; res.dat7:=1744; res.dat8:=1994; res.dat9:=2243; res.dat10:=2492; res.dat11:=2741; res.dat12:=2990; res.dat13:=3240; res.dat14:=3489; res.dat15:=3738; res.dat16:=3987; end;
  if km1=82 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1255; res.dat6:=1506; res.dat7:=1757; res.dat8:=2008; res.dat9:=2259; res.dat10:=2510; res.dat11:=2761; res.dat12:=3012; res.dat13:=3263; res.dat14:=3514; res.dat15:=3765; res.dat16:=4016; end;
  if km1=83 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1273; res.dat6:=1528; res.dat7:=1782; res.dat8:=2037; res.dat9:=2291; res.dat10:=2546; res.dat11:=2801; res.dat12:=3055; res.dat13:=3310; res.dat14:=3564; res.dat15:=3819; res.dat16:=4074; end;
  if km1=84 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1291; res.dat6:=1549; res.dat7:=1807; res.dat8:=2066; res.dat9:=2324; res.dat10:=2582; res.dat11:=2840; res.dat12:=3098; res.dat13:=3357; res.dat14:=3615; res.dat15:=3873; res.dat16:=4131; end;
  if km1=85 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1308; res.dat6:=1570; res.dat7:=1831; res.dat8:=2093; res.dat9:=2354; res.dat10:=2616; res.dat11:=2878; res.dat12:=3139; res.dat13:=3401; res.dat14:=3662; res.dat15:=3924; res.dat16:=4186; end;
  if km1=86 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1317; res.dat6:=1580; res.dat7:=1844; res.dat8:=2107; res.dat9:=2371; res.dat10:=2634; res.dat11:=2897; res.dat12:=3161; res.dat13:=3424; res.dat14:=3688; res.dat15:=3951; res.dat16:=4214; end;
  if km1=87 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1335; res.dat6:=1602; res.dat7:=1869; res.dat8:=2136; res.dat9:=2403; res.dat10:=2670; res.dat11:=2937; res.dat12:=3204; res.dat13:=3471; res.dat14:=3738; res.dat15:=4005; res.dat16:=4272; end;
  if km1=88 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1353; res.dat6:=1624; res.dat7:=1894; res.dat8:=2165; res.dat9:=2435; res.dat10:=2706; res.dat11:=2977; res.dat12:=3247; res.dat13:=3518; res.dat14:=3788; res.dat15:=4059; res.dat16:=4330; end;
  if km1=89 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1362; res.dat6:=1634; res.dat7:=1907; res.dat8:=2179; res.dat9:=2452; res.dat10:=2724; res.dat11:=2996; res.dat12:=3269; res.dat13:=3541; res.dat14:=3814; res.dat15:=4086; res.dat16:=4358; end;
  if km1=90 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1380; res.dat6:=1656; res.dat7:=1932; res.dat8:=2208; res.dat9:=2484; res.dat10:=2760; res.dat11:=3036; res.dat12:=3312; res.dat13:=3588; res.dat14:=3864; res.dat15:=4140; res.dat16:=4416; end;
  if km1=91 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1397; res.dat6:=1676; res.dat7:=1956; res.dat8:=2235; res.dat9:=2515; res.dat10:=2794; res.dat11:=3073; res.dat12:=3353; res.dat13:=3632; res.dat14:=3912; res.dat15:=4191; res.dat16:=4470; end;
  if km1=92 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1415; res.dat6:=1698; res.dat7:=1981; res.dat8:=2264; res.dat9:=2547; res.dat10:=2830; res.dat11:=3113; res.dat12:=3396; res.dat13:=3679; res.dat14:=3962; res.dat15:=4245; res.dat16:=4528; end;
  if km1=93 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1424; res.dat6:=1709; res.dat7:=1994; res.dat8:=2278; res.dat9:=2563; res.dat10:=2848; res.dat11:=3133; res.dat12:=3418; res.dat13:=3702; res.dat14:=3987; res.dat15:=4272; res.dat16:=4557; end;
  if km1=94 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1442; res.dat6:=1730; res.dat7:=2019; res.dat8:=2307; res.dat9:=2596; res.dat10:=2884; res.dat11:=3172; res.dat12:=3461; res.dat13:=3749; res.dat14:=4038; res.dat15:=4326; res.dat16:=4614; end;
  if km1=95 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1460; res.dat6:=1752; res.dat7:=2044; res.dat8:=2336; res.dat9:=2628; res.dat10:=2920; res.dat11:=3212; res.dat12:=3504; res.dat13:=3796; res.dat14:=4088; res.dat15:=4380; res.dat16:=4672; end;
  if km1=96 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1477; res.dat6:=1772; res.dat7:=2068; res.dat8:=2363; res.dat9:=2659; res.dat10:=2954; res.dat11:=3249; res.dat12:=3545; res.dat13:=3840; res.dat14:=4136; res.dat15:=4431; res.dat16:=4726; end;
  if km1=97 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1486; res.dat6:=1783; res.dat7:=2080; res.dat8:=2378; res.dat9:=2675; res.dat10:=2972; res.dat11:=3269; res.dat12:=3566; res.dat13:=3864; res.dat14:=4161; res.dat15:=4458; res.dat16:=4755; end;
  if km1=98 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1504; res.dat6:=1805; res.dat7:=2106; res.dat8:=2406; res.dat9:=2707; res.dat10:=3008; res.dat11:=3309; res.dat12:=3610; res.dat13:=3910; res.dat14:=4211; res.dat15:=4512; res.dat16:=4813; end;
  if km1=99 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1522; res.dat6:=1826; res.dat7:=2131; res.dat8:=2435; res.dat9:=2740; res.dat10:=3044; res.dat11:=3348; res.dat12:=3653; res.dat13:=3957; res.dat14:=4262; res.dat15:=4566; res.dat16:=4870; end;
  if km1=100 then begin res.d5:=1090; res.d10:=1750; res.d15:=2620; res.m1:=3750; res.d10r:=1530; res.d15r:=2185; res.m1r:=3200; res.dat5:=1540; res.dat6:=1848; res.dat7:=2156; res.dat8:=2464; res.dat9:=2772; res.dat10:=3080; res.dat11:=3388; res.dat12:=3696; res.dat13:=4004; res.dat14:=4312; res.dat15:=4620; res.dat16:=4928; end;
  if km1=101 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1543; res.dat6:=1852; res.dat7:=2160; res.dat8:=2469; res.dat9:=2777; res.dat10:=3086; res.dat11:=3395; res.dat12:=3703; res.dat13:=4012; res.dat14:=4320; res.dat15:=4629; res.dat16:=4938; end;
  if km1=102 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1546; res.dat6:=1855; res.dat7:=2164; res.dat8:=2474; res.dat9:=2783; res.dat10:=3092; res.dat11:=3401; res.dat12:=3710; res.dat13:=4020; res.dat14:=4329; res.dat15:=4638; res.dat16:=4947; end;
  if km1=103 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1549; res.dat6:=1859; res.dat7:=2169; res.dat8:=2478; res.dat9:=2788; res.dat10:=3098; res.dat11:=3408; res.dat12:=3718; res.dat13:=4027; res.dat14:=4337; res.dat15:=4647; res.dat16:=4957; end;
  if km1=104 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1557; res.dat6:=1868; res.dat7:=2180; res.dat8:=2491; res.dat9:=2803; res.dat10:=3114; res.dat11:=3425; res.dat12:=3737; res.dat13:=4048; res.dat14:=4360; res.dat15:=4671; res.dat16:=4982; end;
  if km1=105 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1575; res.dat6:=1890; res.dat7:=2205; res.dat8:=2520; res.dat9:=2835; res.dat10:=3150; res.dat11:=3465; res.dat12:=3780; res.dat13:=4095; res.dat14:=4410; res.dat15:=4725; res.dat16:=5040; end;
  if km1=106 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1592; res.dat6:=1910; res.dat7:=2229; res.dat8:=2547; res.dat9:=2866; res.dat10:=3184; res.dat11:=3502; res.dat12:=3821; res.dat13:=4139; res.dat14:=4458; res.dat15:=4776; res.dat16:=5094; end;
  if km1=107 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1610; res.dat6:=1932; res.dat7:=2254; res.dat8:=2576; res.dat9:=2898; res.dat10:=3220; res.dat11:=3542; res.dat12:=3864; res.dat13:=4186; res.dat14:=4508; res.dat15:=4830; res.dat16:=5152; end;
  if km1=108 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1618; res.dat6:=1942; res.dat7:=2265; res.dat8:=2589; res.dat9:=2912; res.dat10:=3236; res.dat11:=3560; res.dat12:=3883; res.dat13:=4207; res.dat14:=4530; res.dat15:=4854; res.dat16:=5178; end;
  if km1=109 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1636; res.dat6:=1963; res.dat7:=2290; res.dat8:=2618; res.dat9:=2945; res.dat10:=3272; res.dat11:=3599; res.dat12:=3926; res.dat13:=4254; res.dat14:=4581; res.dat15:=4908; res.dat16:=5235; end;
  if km1=110 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1653; res.dat6:=1984; res.dat7:=2314; res.dat8:=2645; res.dat9:=2975; res.dat10:=3306; res.dat11:=3637; res.dat12:=3967; res.dat13:=4298; res.dat14:=4628; res.dat15:=4959; res.dat16:=5290; end;
  if km1=111 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1670; res.dat6:=2004; res.dat7:=2338; res.dat8:=2672; res.dat9:=3006; res.dat10:=3340; res.dat11:=3674; res.dat12:=4008; res.dat13:=4342; res.dat14:=4676; res.dat15:=5010; res.dat16:=5344; end;
  if km1=112 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1679; res.dat6:=2015; res.dat7:=2351; res.dat8:=2686; res.dat9:=3022; res.dat10:=3358; res.dat11:=3694; res.dat12:=4030; res.dat13:=4365; res.dat14:=4701; res.dat15:=5037; res.dat16:=5373; end;
  if km1=113 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1697; res.dat6:=2036; res.dat7:=2376; res.dat8:=2715; res.dat9:=3055; res.dat10:=3394; res.dat11:=3733; res.dat12:=4073; res.dat13:=4412; res.dat14:=4752; res.dat15:=5091; res.dat16:=5430; end;
  if km1=114 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1714; res.dat6:=2057; res.dat7:=2400; res.dat8:=2742; res.dat9:=3085; res.dat10:=3428; res.dat11:=3771; res.dat12:=4114; res.dat13:=4456; res.dat14:=4799; res.dat15:=5142; res.dat16:=5485; end;
  if km1=115 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1723; res.dat6:=2068; res.dat7:=2412; res.dat8:=2757; res.dat9:=3101; res.dat10:=3446; res.dat11:=3791; res.dat12:=4135; res.dat13:=4480; res.dat14:=4824; res.dat15:=5169; res.dat16:=5514; end;
  if km1=116 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1740; res.dat6:=2088; res.dat7:=2436; res.dat8:=2784; res.dat9:=3132; res.dat10:=3480; res.dat11:=3828; res.dat12:=4176; res.dat13:=4524; res.dat14:=4872; res.dat15:=5220; res.dat16:=5568; end;
  if km1=117 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1757; res.dat6:=2108; res.dat7:=2460; res.dat8:=2811; res.dat9:=3163; res.dat10:=3514; res.dat11:=3865; res.dat12:=4217; res.dat13:=4568; res.dat14:=4920; res.dat15:=5271; res.dat16:=5622; end;
  if km1=118 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1775; res.dat6:=2130; res.dat7:=2485; res.dat8:=2840; res.dat9:=3195; res.dat10:=3550; res.dat11:=3905; res.dat12:=4260; res.dat13:=4615; res.dat14:=4970; res.dat15:=5325; res.dat16:=5680; end;
  if km1=119 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1784; res.dat6:=2141; res.dat7:=2498; res.dat8:=2854; res.dat9:=3211; res.dat10:=3568; res.dat11:=3925; res.dat12:=4282; res.dat13:=4638; res.dat14:=4995; res.dat15:=5352; res.dat16:=5709; end;
  if km1=120 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1801; res.dat6:=2161; res.dat7:=2521; res.dat8:=2882; res.dat9:=3242; res.dat10:=3602; res.dat11:=3962; res.dat12:=4322; res.dat13:=4683; res.dat14:=5043; res.dat15:=5403; res.dat16:=5763; end;
  if km1=121 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1818; res.dat6:=2182; res.dat7:=2545; res.dat8:=2909; res.dat9:=3272; res.dat10:=3636; res.dat11:=4000; res.dat12:=4363; res.dat13:=4727; res.dat14:=5090; res.dat15:=5454; res.dat16:=5818; end;
  if km1=122 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1836; res.dat6:=2203; res.dat7:=2570; res.dat8:=2938; res.dat9:=3305; res.dat10:=3672; res.dat11:=4039; res.dat12:=4406; res.dat13:=4774; res.dat14:=5141; res.dat15:=5508; res.dat16:=5875; end;
  if km1=123 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1844; res.dat6:=2213; res.dat7:=2582; res.dat8:=2950; res.dat9:=3319; res.dat10:=3688; res.dat11:=4057; res.dat12:=4426; res.dat13:=4794; res.dat14:=5163; res.dat15:=5532; res.dat16:=5901; end;
  if km1=124 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1862; res.dat6:=2234; res.dat7:=2607; res.dat8:=2979; res.dat9:=3352; res.dat10:=3724; res.dat11:=4096; res.dat12:=4469; res.dat13:=4841; res.dat14:=5214; res.dat15:=5586; res.dat16:=5958; end;
  if km1=125 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1879; res.dat6:=2255; res.dat7:=2631; res.dat8:=3006; res.dat9:=3382; res.dat10:=3758; res.dat11:=4134; res.dat12:=4510; res.dat13:=4885; res.dat14:=5261; res.dat15:=5637; res.dat16:=6013; end;
  if km1=126 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1888; res.dat6:=2266; res.dat7:=2643; res.dat8:=3021; res.dat9:=3398; res.dat10:=3776; res.dat11:=4154; res.dat12:=4531; res.dat13:=4909; res.dat14:=5286; res.dat15:=5664; res.dat16:=6042; end;
  if km1=127 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1905; res.dat6:=2286; res.dat7:=2667; res.dat8:=3048; res.dat9:=3429; res.dat10:=3810; res.dat11:=4191; res.dat12:=4572; res.dat13:=4953; res.dat14:=5334; res.dat15:=5715; res.dat16:=6096; end;
  if km1=128 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1923; res.dat6:=2308; res.dat7:=2692; res.dat8:=3077; res.dat9:=3461; res.dat10:=3846; res.dat11:=4231; res.dat12:=4615; res.dat13:=5000; res.dat14:=5384; res.dat15:=5769; res.dat16:=6154; end;
  if km1=129 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1940; res.dat6:=2328; res.dat7:=2716; res.dat8:=3104; res.dat9:=3492; res.dat10:=3880; res.dat11:=4268; res.dat12:=4656; res.dat13:=5044; res.dat14:=5432; res.dat15:=5820; res.dat16:=6208; end;
  if km1=130 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1949; res.dat6:=2339; res.dat7:=2729; res.dat8:=3118; res.dat9:=3508; res.dat10:=3898; res.dat11:=4288; res.dat12:=4678; res.dat13:=5067; res.dat14:=5457; res.dat15:=5847; res.dat16:=6237; end;
  if km1=131 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1966; res.dat6:=2359; res.dat7:=2752; res.dat8:=3146; res.dat9:=3539; res.dat10:=3932; res.dat11:=4325; res.dat12:=4718; res.dat13:=5112; res.dat14:=5505; res.dat15:=5898; res.dat16:=6291; end;
  if km1=132 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=1984; res.dat6:=2381; res.dat7:=2778; res.dat8:=3174; res.dat9:=3571; res.dat10:=3968; res.dat11:=4365; res.dat12:=4762; res.dat13:=5158; res.dat14:=5555; res.dat15:=5952; res.dat16:=6349; end;
  if km1=133 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2001; res.dat6:=2401; res.dat7:=2801; res.dat8:=3202; res.dat9:=3602; res.dat10:=4002; res.dat11:=4402; res.dat12:=4802; res.dat13:=5203; res.dat14:=5603; res.dat15:=6003; res.dat16:=6403; end;
  if km1=134 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2010; res.dat6:=2412; res.dat7:=2814; res.dat8:=3216; res.dat9:=3618; res.dat10:=4020; res.dat11:=4422; res.dat12:=4824; res.dat13:=5226; res.dat14:=5628; res.dat15:=6030; res.dat16:=6432; end;
  if km1=135 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2027; res.dat6:=2432; res.dat7:=2838; res.dat8:=3243; res.dat9:=3649; res.dat10:=4054; res.dat11:=4459; res.dat12:=4865; res.dat13:=5270; res.dat14:=5676; res.dat15:=6081; res.dat16:=6486; end;
  if km1=136 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2045; res.dat6:=2454; res.dat7:=2863; res.dat8:=3272; res.dat9:=3681; res.dat10:=4090; res.dat11:=4499; res.dat12:=4908; res.dat13:=5317; res.dat14:=5726; res.dat15:=6135; res.dat16:=6544; end;
  if km1=137 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2062; res.dat6:=2474; res.dat7:=2887; res.dat8:=3299; res.dat9:=3712; res.dat10:=4124; res.dat11:=4536; res.dat12:=4949; res.dat13:=5361; res.dat14:=5774; res.dat15:=6186; res.dat16:=6598; end;
  if km1=138 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2071; res.dat6:=2485; res.dat7:=2899; res.dat8:=3314; res.dat9:=3728; res.dat10:=4142; res.dat11:=4556; res.dat12:=4970; res.dat13:=5385; res.dat14:=5799; res.dat15:=6213; res.dat16:=6627; end;
  if km1=139 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2088; res.dat6:=2506; res.dat7:=2923; res.dat8:=3341; res.dat9:=3758; res.dat10:=4176; res.dat11:=4594; res.dat12:=5011; res.dat13:=5429; res.dat14:=5846; res.dat15:=6264; res.dat16:=6682; end;
  if km1=140 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2105; res.dat6:=2526; res.dat7:=2947; res.dat8:=3368; res.dat9:=3789; res.dat10:=4210; res.dat11:=4631; res.dat12:=5052; res.dat13:=5473; res.dat14:=5894; res.dat15:=6315; res.dat16:=6736; end;
  if km1=141 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2114; res.dat6:=2537; res.dat7:=2960; res.dat8:=3382; res.dat9:=3805; res.dat10:=4228; res.dat11:=4651; res.dat12:=5074; res.dat13:=5496; res.dat14:=5919; res.dat15:=6342; res.dat16:=6765; end;
  if km1=142 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2132; res.dat6:=2558; res.dat7:=2985; res.dat8:=3411; res.dat9:=3838; res.dat10:=4264; res.dat11:=4690; res.dat12:=5117; res.dat13:=5543; res.dat14:=5970; res.dat15:=6396; res.dat16:=6822; end;
  if km1=143 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2149; res.dat6:=2579; res.dat7:=3009; res.dat8:=3438; res.dat9:=3868; res.dat10:=4298; res.dat11:=4728; res.dat12:=5158; res.dat13:=5587; res.dat14:=6017; res.dat15:=6447; res.dat16:=6877; end;
  if km1=144 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2166; res.dat6:=2599; res.dat7:=3032; res.dat8:=3466; res.dat9:=3899; res.dat10:=4332; res.dat11:=4765; res.dat12:=5198; res.dat13:=5632; res.dat14:=6065; res.dat15:=6498; res.dat16:=6931; end;
  if km1=145 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2175; res.dat6:=2610; res.dat7:=3045; res.dat8:=3480; res.dat9:=3915; res.dat10:=4350; res.dat11:=4785; res.dat12:=5220; res.dat13:=5655; res.dat14:=6090; res.dat15:=6525; res.dat16:=6960; end;
  if km1=146 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2192; res.dat6:=2630; res.dat7:=3069; res.dat8:=3507; res.dat9:=3946; res.dat10:=4384; res.dat11:=4822; res.dat12:=5261; res.dat13:=5699; res.dat14:=6138; res.dat15:=6576; res.dat16:=7014; end;
  if km1=147 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2210; res.dat6:=2652; res.dat7:=3094; res.dat8:=3536; res.dat9:=3978; res.dat10:=4420; res.dat11:=4862; res.dat12:=5304; res.dat13:=5746; res.dat14:=6188; res.dat15:=6630; res.dat16:=7072; end;
  if km1=148 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2227; res.dat6:=2672; res.dat7:=3118; res.dat8:=3563; res.dat9:=4009; res.dat10:=4454; res.dat11:=4899; res.dat12:=5345; res.dat13:=5790; res.dat14:=6236; res.dat15:=6681; res.dat16:=7126; end;
  if km1=149 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2236; res.dat6:=2683; res.dat7:=3130; res.dat8:=3578; res.dat9:=4025; res.dat10:=4472; res.dat11:=4919; res.dat12:=5366; res.dat13:=5814; res.dat14:=6261; res.dat15:=6708; res.dat16:=7155; end;
  if km1=150 then begin res.d5:=1300; res.d10:=2080; res.d15:=3120; res.m1:=4500; res.d10r:=1820; res.d15r:=2600; res.m1r:=4000; res.dat5:=2253; res.dat6:=2704; res.dat7:=3154; res.dat8:=3605; res.dat9:=4055; res.dat10:=4506; res.dat11:=4957; res.dat12:=5407; res.dat13:=5858; res.dat14:=6308; res.dat15:=6759; res.dat16:=7210; end;
  if km1=151 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2255; res.dat6:=2706; res.dat7:=3157; res.dat8:=3608; res.dat9:=4059; res.dat10:=4510; res.dat11:=4961; res.dat12:=5412; res.dat13:=5863; res.dat14:=6314; res.dat15:=6765; res.dat16:=7216; end;
  if km1=152 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2257; res.dat6:=2708; res.dat7:=3160; res.dat8:=3611; res.dat9:=4063; res.dat10:=4514; res.dat11:=4965; res.dat12:=5417; res.dat13:=5868; res.dat14:=6320; res.dat15:=6771; res.dat16:=7222; end;
  if km1=153 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2259; res.dat6:=2711; res.dat7:=3163; res.dat8:=3614; res.dat9:=4066; res.dat10:=4518; res.dat11:=4970; res.dat12:=5422; res.dat13:=5873; res.dat14:=6325; res.dat15:=6777; res.dat16:=7229; end;
  if km1=154 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2261; res.dat6:=2713; res.dat7:=3165; res.dat8:=3618; res.dat9:=4070; res.dat10:=4522; res.dat11:=4974; res.dat12:=5426; res.dat13:=5879; res.dat14:=6331; res.dat15:=6783; res.dat16:=7235; end;
  if km1=155 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2278; res.dat6:=2734; res.dat7:=3189; res.dat8:=3645; res.dat9:=4100; res.dat10:=4556; res.dat11:=5012; res.dat12:=5467; res.dat13:=5923; res.dat14:=6378; res.dat15:=6834; res.dat16:=7290; end;
  if km1=156 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2287; res.dat6:=2744; res.dat7:=3202; res.dat8:=3659; res.dat9:=4117; res.dat10:=4574; res.dat11:=5031; res.dat12:=5489; res.dat13:=5946; res.dat14:=6404; res.dat15:=6861; res.dat16:=7318; end;
  if km1=157 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2304; res.dat6:=2765; res.dat7:=3226; res.dat8:=3686; res.dat9:=4147; res.dat10:=4608; res.dat11:=5069; res.dat12:=5530; res.dat13:=5990; res.dat14:=6451; res.dat15:=6912; res.dat16:=7373; end;
  if km1=158 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2321; res.dat6:=2785; res.dat7:=3249; res.dat8:=3714; res.dat9:=4178; res.dat10:=4642; res.dat11:=5106; res.dat12:=5570; res.dat13:=6035; res.dat14:=6499; res.dat15:=6963; res.dat16:=7427; end;
  if km1=159 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2338; res.dat6:=2806; res.dat7:=3273; res.dat8:=3741; res.dat9:=4208; res.dat10:=4676; res.dat11:=5144; res.dat12:=5611; res.dat13:=6079; res.dat14:=6546; res.dat15:=7014; res.dat16:=7482; end;
  if km1=160 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2346; res.dat6:=2815; res.dat7:=3284; res.dat8:=3754; res.dat9:=4223; res.dat10:=4692; res.dat11:=5161; res.dat12:=5630; res.dat13:=6100; res.dat14:=6569; res.dat15:=7038; res.dat16:=7507; end;
  if km1=161 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2363; res.dat6:=2836; res.dat7:=3308; res.dat8:=3781; res.dat9:=4253; res.dat10:=4726; res.dat11:=5199; res.dat12:=5671; res.dat13:=6144; res.dat14:=6616; res.dat15:=7089; res.dat16:=7562; end;
  if km1=162 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2380; res.dat6:=2856; res.dat7:=3332; res.dat8:=3808; res.dat9:=4284; res.dat10:=4760; res.dat11:=5236; res.dat12:=5712; res.dat13:=6188; res.dat14:=6664; res.dat15:=7140; res.dat16:=7616; end;
  if km1=163 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2389; res.dat6:=2867; res.dat7:=3345; res.dat8:=3822; res.dat9:=4300; res.dat10:=4778; res.dat11:=5256; res.dat12:=5734; res.dat13:=6211; res.dat14:=6689; res.dat15:=7167; res.dat16:=7645; end;
  if km1=164 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2406; res.dat6:=2887; res.dat7:=3368; res.dat8:=3850; res.dat9:=4331; res.dat10:=4812; res.dat11:=5293; res.dat12:=5774; res.dat13:=6256; res.dat14:=6737; res.dat15:=7218; res.dat16:=7699; end;
  if km1=165 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2423; res.dat6:=2908; res.dat7:=3392; res.dat8:=3877; res.dat9:=4361; res.dat10:=4846; res.dat11:=5331; res.dat12:=5815; res.dat13:=6300; res.dat14:=6784; res.dat15:=7269; res.dat16:=7754; end;
  if km1=166 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2440; res.dat6:=2928; res.dat7:=3416; res.dat8:=3904; res.dat9:=4392; res.dat10:=4880; res.dat11:=5368; res.dat12:=5856; res.dat13:=6344; res.dat14:=6832; res.dat15:=7320; res.dat16:=7808; end;
  if km1=167 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2448; res.dat6:=2938; res.dat7:=3427; res.dat8:=3917; res.dat9:=4406; res.dat10:=4896; res.dat11:=5386; res.dat12:=5875; res.dat13:=6365; res.dat14:=6854; res.dat15:=7344; res.dat16:=7834; end;
  if km1=168 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2465; res.dat6:=2958; res.dat7:=3451; res.dat8:=3944; res.dat9:=4437; res.dat10:=4930; res.dat11:=5423; res.dat12:=5916; res.dat13:=6409; res.dat14:=6902; res.dat15:=7395; res.dat16:=7888; end;
  if km1=169 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2482; res.dat6:=2978; res.dat7:=3475; res.dat8:=3971; res.dat9:=4468; res.dat10:=4964; res.dat11:=5460; res.dat12:=5957; res.dat13:=6453; res.dat14:=6950; res.dat15:=7446; res.dat16:=7942; end;
  if km1=170 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2499; res.dat6:=2999; res.dat7:=3499; res.dat8:=3998; res.dat9:=4498; res.dat10:=4998; res.dat11:=5498; res.dat12:=5998; res.dat13:=6497; res.dat14:=6997; res.dat15:=7497; res.dat16:=7997; end;
  if km1=171 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2508; res.dat6:=3010; res.dat7:=3511; res.dat8:=4013; res.dat9:=4514; res.dat10:=5016; res.dat11:=5518; res.dat12:=6019; res.dat13:=6521; res.dat14:=7022; res.dat15:=7524; res.dat16:=8026; end;
  if km1=172 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2525; res.dat6:=3030; res.dat7:=3535; res.dat8:=4040; res.dat9:=4545; res.dat10:=5050; res.dat11:=5555; res.dat12:=6060; res.dat13:=6565; res.dat14:=7070; res.dat15:=7575; res.dat16:=8080; end;
  if km1=173 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2542; res.dat6:=3050; res.dat7:=3559; res.dat8:=4067; res.dat9:=4576; res.dat10:=5084; res.dat11:=5592; res.dat12:=6101; res.dat13:=6609; res.dat14:=7118; res.dat15:=7626; res.dat16:=8134; end;
  if km1=174 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2559; res.dat6:=3071; res.dat7:=3583; res.dat8:=4094; res.dat9:=4606; res.dat10:=5118; res.dat11:=5630; res.dat12:=6142; res.dat13:=6653; res.dat14:=7165; res.dat15:=7677; res.dat16:=8189; end;
  if km1=175 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2567; res.dat6:=3080; res.dat7:=3594; res.dat8:=4107; res.dat9:=4621; res.dat10:=5134; res.dat11:=5647; res.dat12:=6161; res.dat13:=6674; res.dat14:=7188; res.dat15:=7701; res.dat16:=8214; end;
  if km1=176 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2584; res.dat6:=3101; res.dat7:=3618; res.dat8:=4134; res.dat9:=4651; res.dat10:=5168; res.dat11:=5685; res.dat12:=6202; res.dat13:=6718; res.dat14:=7235; res.dat15:=7752; res.dat16:=8269; end;
  if km1=177 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2601; res.dat6:=3121; res.dat7:=3641; res.dat8:=4162; res.dat9:=4682; res.dat10:=5202; res.dat11:=5722; res.dat12:=6242; res.dat13:=6763; res.dat14:=7283; res.dat15:=7803; res.dat16:=8323; end;
  if km1=178 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2610; res.dat6:=3132; res.dat7:=3654; res.dat8:=4176; res.dat9:=4698; res.dat10:=5220; res.dat11:=5742; res.dat12:=6264; res.dat13:=6786; res.dat14:=7308; res.dat15:=7830; res.dat16:=8352; end;
  if km1=179 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2627; res.dat6:=3152; res.dat7:=3678; res.dat8:=4203; res.dat9:=4729; res.dat10:=5254; res.dat11:=5779; res.dat12:=6305; res.dat13:=6830; res.dat14:=7356; res.dat15:=7881; res.dat16:=8406; end;
  if km1=180 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2644; res.dat6:=3173; res.dat7:=3702; res.dat8:=4230; res.dat9:=4759; res.dat10:=5288; res.dat11:=5817; res.dat12:=6346; res.dat13:=6874; res.dat14:=7403; res.dat15:=7932; res.dat16:=8461; end;
  if km1=181 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2661; res.dat6:=3193; res.dat7:=3725; res.dat8:=4258; res.dat9:=4790; res.dat10:=5322; res.dat11:=5854; res.dat12:=6386; res.dat13:=6919; res.dat14:=7451; res.dat15:=7983; res.dat16:=8515; end;
  if km1=182 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2669; res.dat6:=3203; res.dat7:=3737; res.dat8:=4270; res.dat9:=4804; res.dat10:=5338; res.dat11:=5872; res.dat12:=6406; res.dat13:=6939; res.dat14:=7473; res.dat15:=8007; res.dat16:=8541; end;
  if km1=183 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2686; res.dat6:=3223; res.dat7:=3760; res.dat8:=4298; res.dat9:=4835; res.dat10:=5372; res.dat11:=5909; res.dat12:=6446; res.dat13:=6984; res.dat14:=7521; res.dat15:=8058; res.dat16:=8595; end;
  if km1=184 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2703; res.dat6:=3244; res.dat7:=3784; res.dat8:=4325; res.dat9:=4865; res.dat10:=5406; res.dat11:=5947; res.dat12:=6487; res.dat13:=7028; res.dat14:=7568; res.dat15:=8109; res.dat16:=8650; end;
  if km1=185 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2720; res.dat6:=3264; res.dat7:=3808; res.dat8:=4352; res.dat9:=4896; res.dat10:=5440; res.dat11:=5984; res.dat12:=6528; res.dat13:=7072; res.dat14:=7616; res.dat15:=8160; res.dat16:=8704; end;
  if km1=186 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2729; res.dat6:=3275; res.dat7:=3821; res.dat8:=4366; res.dat9:=4912; res.dat10:=5458; res.dat11:=6004; res.dat12:=6550; res.dat13:=7095; res.dat14:=7641; res.dat15:=8187; res.dat16:=8733; end;
  if km1=187 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2746; res.dat6:=3295; res.dat7:=3844; res.dat8:=4394; res.dat9:=4943; res.dat10:=5492; res.dat11:=6041; res.dat12:=6590; res.dat13:=7140; res.dat14:=7689; res.dat15:=8238; res.dat16:=8787; end;
  if km1=188 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2763; res.dat6:=3316; res.dat7:=3868; res.dat8:=4421; res.dat9:=4973; res.dat10:=5526; res.dat11:=6079; res.dat12:=6631; res.dat13:=7184; res.dat14:=7736; res.dat15:=8289; res.dat16:=8842; end;
  if km1=189 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2771; res.dat6:=3325; res.dat7:=3879; res.dat8:=4434; res.dat9:=4988; res.dat10:=5542; res.dat11:=6096; res.dat12:=6650; res.dat13:=7205; res.dat14:=7759; res.dat15:=8313; res.dat16:=8867; end;
  if km1=190 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2788; res.dat6:=3346; res.dat7:=3903; res.dat8:=4461; res.dat9:=5018; res.dat10:=5576; res.dat11:=6134; res.dat12:=6691; res.dat13:=7249; res.dat14:=7806; res.dat15:=8364; res.dat16:=8922; end;
  if km1=191 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2805; res.dat6:=3366; res.dat7:=3927; res.dat8:=4488; res.dat9:=5049; res.dat10:=5610; res.dat11:=6171; res.dat12:=6732; res.dat13:=7293; res.dat14:=7854; res.dat15:=8415; res.dat16:=8976; end;
  if km1=192 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2822; res.dat6:=3386; res.dat7:=3951; res.dat8:=4515; res.dat9:=5080; res.dat10:=5644; res.dat11:=6208; res.dat12:=6773; res.dat13:=7337; res.dat14:=7902; res.dat15:=8466; res.dat16:=9030; end;
  if km1=193 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2831; res.dat6:=3397; res.dat7:=3963; res.dat8:=4530; res.dat9:=5096; res.dat10:=5662; res.dat11:=6228; res.dat12:=6794; res.dat13:=7361; res.dat14:=7927; res.dat15:=8493; res.dat16:=9059; end;
  if km1=194 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2848; res.dat6:=3418; res.dat7:=3987; res.dat8:=4557; res.dat9:=5126; res.dat10:=5696; res.dat11:=6266; res.dat12:=6835; res.dat13:=7405; res.dat14:=7974; res.dat15:=8544; res.dat16:=9114; end;
  if km1=195 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2865; res.dat6:=3438; res.dat7:=4011; res.dat8:=4584; res.dat9:=5157; res.dat10:=5730; res.dat11:=6303; res.dat12:=6876; res.dat13:=7449; res.dat14:=8022; res.dat15:=8595; res.dat16:=9168; end;
  if km1=196 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2882; res.dat6:=3458; res.dat7:=4035; res.dat8:=4611; res.dat9:=5188; res.dat10:=5764; res.dat11:=6340; res.dat12:=6917; res.dat13:=7493; res.dat14:=8070; res.dat15:=8646; res.dat16:=9222; end;
  if km1=197 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2890; res.dat6:=3468; res.dat7:=4046; res.dat8:=4624; res.dat9:=5202; res.dat10:=5780; res.dat11:=6358; res.dat12:=6936; res.dat13:=7514; res.dat14:=8092; res.dat15:=8670; res.dat16:=9248; end;
  if km1=198 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2907; res.dat6:=3488; res.dat7:=4070; res.dat8:=4651; res.dat9:=5233; res.dat10:=5814; res.dat11:=6395; res.dat12:=6977; res.dat13:=7558; res.dat14:=8140; res.dat15:=8721; res.dat16:=9302; end;
  if km1=199 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2924; res.dat6:=3509; res.dat7:=4094; res.dat8:=4678; res.dat9:=5263; res.dat10:=5848; res.dat11:=6433; res.dat12:=7018; res.dat13:=7602; res.dat14:=8187; res.dat15:=8772; res.dat16:=9357; end;
  if km1=200 then begin res.d5:=1500; res.d10:=2400; res.d15:=3600; res.m1:=5500; res.d10r:=2100; res.d15r:=3000; res.m1r:=4500; res.dat5:=2941; res.dat6:=3529; res.dat7:=4117; res.dat8:=4706; res.dat9:=5294; res.dat10:=5882; res.dat11:=6470; res.dat12:=7058; res.dat13:=7647; res.dat14:=8235; res.dat15:=8823; res.dat16:=9411; end;
  end;
 end;

 if code='novgorod' then begin
  if ((lim)and(km<=20)) then begin
    d5:=348;
    d10:=552;
    d15:=824;
    d10r:=484;
    d15r:=688;
    m1:=1668;
    m1r:=1436;
  end
  else begin
   if km<20 then begin
     d5:=km*17.4;
     d10:=km*27.6;
     d15:=km*41.2;
     d10r:=km*24.2;
     d15r:=km*34.4;
     m1:=km*83.4;
     m1r:=km*42.9;
   end
    else begin
     d5:=((km-20)*19)+348;
     d10:=((km-20)*30.4)+552;
     d15:=((km-20)*45.6)+824;
     d10r:=((km-20)*26.58)+484;
     d15r:=((km-20)*38)+688;
     m1:=((km-20)*95)+1668;
     m1r:=((km-20)*79.75)+1436;
    end;
  end; //else lim
 end;

 end;

 if add then begin
   res.m1:=res.m1+ab.m1;
   res.m1r:=res.m1r+ab.m1r;
   res.d5:=res.d5+ab.d5;
   res.d10:=res.d10+ab.d10;
   res.d15:=res.d15+ab.d15;
   res.d10r:=res.d10r+ab.d10r;
   res.d15r:=res.d15r+ab.d15r;
 end;

  result:=res;
//  if
end;

procedure Calc_SPB3700;
  var i,n:integer;
  var t,km:real;
  var tariff:TZOut;
  var f1:AF_types.TSTrings;
  var s:string;
  var abt:TAbTarifList;
begin
with form1 do begin
  stringgrid1.cells[1,0]:=trim(ansilowercase(stringgrid1.cells[1,0]));
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     if CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,n]) then begin
     if stringgrid1.Cells[4,i]=stringgrid1.Cells[4,n] then begin
     if stringgrid1.Cells[4,i]='spb' then begin
       km:=abs(StrToFloat(stringgrid1.Cells[3,n])-StrToFloat(stringgrid1.Cells[3,i]));
       abt:=GetSPB3700Ab(km,'spb',false,abt,false);
       if km>0 then begin
           if abt.m1>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.m1)+'" type="1m" reverse="1" />');
           if abt.m1r>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.m1r)+'" type="1mr" reverse="1" />');
           if abt.d5>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.d5)+'" type="5d" reverse="1" />');
           if abt.d10>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.d10)+'" type="10d" reverse="1" />');
           if abt.d15>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.d15)+'" type="15d" reverse="1" />');
           if abt.d10r>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.d10r)+'" type="10dr" reverse="1" />');
           if abt.d15r>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.d15r)+'" type="15dr" reverse="1" />');
           if abt.dat5>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.dat5)+'" type="5dat" reverse="1" />');
           if abt.dat6>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.dat6)+'" type="6dat" reverse="1" />');
           if abt.dat7>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.dat7)+'" type="7dat" reverse="1" />');
           if abt.dat8>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.dat8)+'" type="8dat" reverse="1" />');
           if abt.dat9>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.dat9)+'" type="9dat" reverse="1" />');
           if abt.dat10>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.dat10)+'" type="10dat" reverse="1" />');
           if abt.dat11>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.dat11)+'" type="11dat" reverse="1" />');
           if abt.dat12>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.dat12)+'" type="12dat" reverse="1" />');
           if abt.dat13>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.dat13)+'" type="13dat" reverse="1" />');
           if abt.dat14>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.dat14)+'" type="14dat" reverse="1" />');
           if abt.dat15>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.dat15)+'" type="15dat" reverse="1" />');
           if abt.dat16>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(abt.dat16)+'" type="16dat" reverse="1" />');
       end;
       if km>51 then begin
//           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="3700" type="1m" reverse="1" />');
//           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="3100" type="1mr" reverse="1" />');
       end;
       if km>65 then begin
//           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="1000" type="5d" reverse="1" />');
//           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="1600" type="10d" reverse="1" />');
//           WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="2400" type="15d" reverse="1" />');
       end;


     end;
     end;
     end;
    end;
  end;
end;
end;
*)


procedure TForm1.Button1Click(Sender: TObject);
  var i:integer;
begin
  setroundmode(rmNearest);
  clearsg(stringgrid1);
  StringGrid1.rowcount:=201;
  for i:=1 to 200 do begin
    stringgrid1.cells[0,i]:=inttostr(i);
//    stringgrid1.cells[1,i]:=floattostr(round(Calc5d(i,edit1.text)));
  end;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
  var i:integer;
begin
  if OpenDialog1.Execute then begin
      ClearSG(stringgrid1);
      LoadFromXLS(OpenDialog1.Files.Strings[0],StringGrid1);
      stringgrid1.ColCount:=stringgrid1.RowCount+10;
      combobox1.Items.clear;
      combobox2.Items.clear;
      if StringGrid1.RowCount>2 then begin
      for i:=2 to StringGrid1.RowCount-1 do begin
        combobox1.Items.Add(StringGrid1.cells[1,i]);
        combobox2.Items.Add(StringGrid1.cells[1,i]);
      end;
        combobox1.ItemIndex:=0;
        combobox2.ItemIndex:=0;
      end;
  end;
end;




procedure TForm1.Button2Click(Sender: TObject);
  var f1,f2,u:AF_Types.TSTrings;
  var i:integer;
begin
 f1.create; f2.create; u.create;
 f1.loadfromfile('C:\1\ 29\2\17.csv');
{ for i:=1 to f1.count do begin
   ParseCSVStrEx(@u,f1.getstring(i),';');
   if u.count>2 then begin
     f2.add('if km1='+u.getstring(1)+' then r:='+u.getstring(2)+';');
   end;
 end;
 for i:=1 to f1.count do begin
   ParseCSVStrEx(@u,f1.getstring(i),';');
   if u.count>2 then begin
     f2.add('if km1='+u.getstring(1)+' then r:='+u.getstring(3)+';');
   end;
 end;}

 for i:=1 to f1.count do begin
   ParseCSVStrEx(@u,f1.getstring(i),';');
   if u.count>2 then begin
     f2.add('  <tr>');
     f2.add('    <td>'+u.getstring(1)+'</td>');
     f2.add('    <td class="tdstmw45"><b>'+u.getstring(2)+' .</b></td>');
     f2.add('    <td class="tdstmw45">'+u.getstring(3)+' .</td>');
     f2.add('    <td class="tdstmw45"><font color="red"><b>'+u.getstring(4)+' .</b></font></td>');
     f2.add('    <td class="tdstmw45"><font color="red">'+u.getstring(5)+' .</font></td>');
     f2.add('  </tr>');
   end;
 end;


 f2.savetofile('C:\1\ 29\2\17.1');
 f1.free; f2.free; u.free;
end;

procedure TForm1.Button3Click(Sender: TObject);
  var f,f1,u,stc,stn,cc,cn,cr:AF_Types.TStrings;
  var i,n:integer;
  var s:string;
begin
//  showmessage(floattostr(okr5(strtofloat(edit2.text))));
  f.create; f1.create; u.create; stc.create; stn.create; cc.create; cn.create; cr.create;
{  f.loadfromfile('C:\AF\\\spb_022012_perelom.xml');
  for i:=1 to f.count do begin
    s:=f.getstring(i);
    if pos('type="etrain"',s)<=0 then f1.add(s);
  end;
  f1.savetofile('C:\AF\\\spb_052012.xml');
  showmessage('End!');}
  f.loadfromfile('C:\1\ 4\city50.txt');
   for i:=1 to f.count do begin
     ParseCSVStrEx(@u,f.getstring(i),#9);
     if u.count>1 then begin
       s:=AnsiUpperCase(u.getstring(2));
       while pos('',s)>0 do s[pos('',s)]:='';
       cc.add(u.getstring(1));
       cn.add(s);
       cr.add(u.getstring(3));
     end;
   end;
  f.clear;
  f.loadfromfile('C:\1\ 4\stat50.txt');
   for i:=1 to f.count do begin
     ParseCSVStrEx(@u,f.getstring(i),#9);
     if u.count>1 then begin
     if u.getstring(3)='NULL' then begin
       s:=AnsiUpperCase(u.getstring(2));
       while pos('',s)>0 do s[pos('',s)]:='';
       stc.add(u.getstring(1));
       stn.add(s);
     end;
     end;
   end;

  for i:=1 to stc.count do begin
    u.clear;
    cn.searchstrings(stn.getstring(i),u);
    if u.count>0 then begin
      s:='';
      for n:=1 to u.count do begin
        s:=s+' '+cc.getstring(strtointe(u.getstring(n)))+' '+cr.getstring(strtointe(u.getstring(n)));
      end;
      f1.add(stc.getstring(i)+' '+stn.getstring(i)+' '+s);
    end;
  end;

  f1.savetofile('C:\1\ 4\out.txt');




  f.free; f1.free; u.free; stc.free; stn.free; cc.free; cn.free; cr.free;
end;

Function ReplaceParam(str1,param,value:string;add:boolean):string;
  var s:string;
  var i:integer;
begin
  s:=str1;
  s:=StrReplace(s,' =','=');
  s:=StrReplace(s,'= ','=');
    if pos(param+'="',s)>0 then begin
      i:=pos(param+'="',s)+length(param)+2;
      if s[i]<>'"' then begin
       while s[i]<>'"' do begin
         delete(s,i,1);
         if i>=length(s) then break;
       end;
      end;
      insert(value,s,i);
    end
     else begin
      s:=str1;
      if add then begin
        if pos('/>',s)>0 then begin
          insert(' '+param+'="'+value+'" ',s,pos('/>',s));
        end
         else begin
          if pos('>',s)>0 then begin
           insert(' '+param+'="'+value+'" ',s,pos('>',s));
          end
           else s:=str1;
         end;
      end
       else s:=str1;
     end;
  result:=s;
end;



procedure TForm1.Button4Click(Sender: TObject);
  var f1,f2:AF_types.TStrings;
  var s,s1,s2:string;
  var i:integer;
begin
 if OpenDialog3.Execute then begin
  f1.create; f2.create;
  f1.loadfromfile(OpenDialog3.FileName);
   for i:=1 to f1.count do begin
     s:=f1.getstring(i);
     if pos('price="',s)>0 then begin
       s:=ReplaceParam(s,'price','0',true);
       f2.add(s);
       if checkbox20.Checked then begin
         s1:=getParam('station1',s);
         s2:=getParam('station2',s);
         s:=ReplaceParam(s,'station1',s2,true);
         s:=ReplaceParam(s,'station2',s1,true);
         f2.add(s);
       end;
     end
      else f2.add(s);

   end;
  f2.savetofile(OpenDialog3.FileName);
  f1.free; f2.free;
  showmessage('end!');
 end;
end;

procedure TForm1.Button5Click(Sender: TObject);
  var f,f1,u:AF_Types.TStrings;
  var i:integer;
begin
  f.create; f1.create; u.create;
  f.loadfromfile('C:\AF\\\3700\0301.csv');
  for i:=1 to f.count do begin
    ParseCSVStrEx(@u,f.getstring(i),';');
    if u.count>1 then begin
     if strtointe(u.getstring(1))>0 then begin
       f1.add('  if km1='+u.getstring(1)+' then begin res.d5:='+u.getstring(2)+'; res.d10:='+u.getstring(3)+'; res.d15:='+u.getstring(4)+'; res.m1:='+u.getstring(5)+'; res.d10r:='+u.getstring(6)+'; res.d15r:='+u.getstring(7)+'; res.m1r:='+u.getstring(8)+'; res.dat5:='+u.getstring(9)+'; res.dat6:='+u.getstring(10)+'; res.dat7:='+u.getstring(11)+'; res.dat8:='+u.getstring(12)+'; res.dat9:='+u.getstring(13)+'; res.dat10:='+u.getstring(14)+'; res.dat11:='+u.getstring(15)+'; res.dat12:='+u.getstring(16)+'; res.dat13:='+u.getstring(17)+'; res.dat14:='+u.getstring(18)+'; res.dat15:='+u.getstring(19)+'; res.dat16:='+u.getstring(20)+'; end;');
     end;
    end;
  end;
  f1.savetofile('C:\AF\\\3700\code.');
  f.free; f1.free; u.free;
end;

function PrepFn(s:string):string;
begin
  while pos('.',s)>0 do s[pos('.',s)]:=' ';
  while pos(',',s)>0 do s[pos(',',s)]:=' ';
  while pos(':',s)>0 do s[pos(':',s)]:=' ';
  while pos('/',s)>0 do s[pos('/',s)]:=' ';
  while pos('\',s)>0 do s[pos('\',s)]:=' ';
  result:=s;
end;

function Prep0ESR(s:string):string;
begin
  s:=trim(s);
  if length(s)=4 then s:='00'+s;
  if length(s)=5 then s:='0'+s;
  result:=s;
end;


procedure SaveXLS(fn:string);
  var WorkBk : _WorkBook;
  var WorkSheet : _WorkSheet;
  var IIndex : OleVariant;
  var i,n:integer;
begin
with form1 do begin
    IIndex := 1;
    XLApp.Connect;
    XLApp.WorkBooks.Add(xlWBatWorkSheet,0);
    WorkBk := XLApp.WorkBooks.Item[IIndex];
    WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
    WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
    for i:=0 to stringgrid1.ColCount do begin
     for n:=0 to stringgrid1.RowCount do begin
       worksheet.cells.item[n+1,i+1]:=StringGrid1.Cells[i,n];
       worksheet.cells.item[1,1].NumberFormat:='@';
     end;
    end;
    worksheet.Columns.AutoFit;
    WorkBk.SaveAs(fn,xlWorkbookNormal, EmptyParam, EmptyParam, false, false,
                xlNoChange, xlUserResolution, false, EmptyParam, EmptyParam, EmptyParam, 0);
    WorkBk.Close(true,EmptyParam,EmptyParam,0);
    XLApp.Quit;
    XLApp.Disconnect;
end;
end;

function DelSpace(s:string):string;
  var i:integer;
begin
  result:='';
  if length(s)>0 then begin
    for i:=1 to length(s) do begin
      if s[i]<>' ' then begin
       if s[i]<>#160 then result:=result+s[i];
      end;
    end;
  end;
end;

procedure TForm1.Button6Click(Sender: TObject);
  var tf,tf1:TextFile;
  var s,s1:string;
  var i,z,nc,nr,ec,er,r,c:integer;
  var f:AF_Types.TStrings;
  var md,cf,rf,mf:boolean;
begin
  c:=0; r:=0;
  if OpenDialog4.Execute then begin
   f.create;
   for z:=0 to OpenDialog4.Files.Count-1 do begin
    ClearSG(stringgrid1);
    assignfile(tf,OpenDialog4.Files.Strings[z]);
    reset(tf);
    assignfile(tf1,OpenDialog4.Files.Strings[z]+'.tmp');
    rewrite(tf1);
     while not eof(tf) do begin
       ReadLn(tf,s);
       s1:='';
       if length(s)>0 then begin
        for i:=1 to length(s) do begin
          if s[i]='>' then s1:=s1+s[i]+#13#10
                      else s1:=s1+s[i];
        end;
       end;
       WriteLn(tf1,s1);
     end;
    closefile(tf1);
    closefile(tf);
      stringgrid1.ColCount:=2;
      stringgrid1.RowCount:=3;
      f.loadfromfile(OpenDialog4.Files.Strings[z]+'.tmp');
      if f.count>0 then begin
        for i:=1 to f.count do begin
         s:=Utf8ToAnsi(f.getstring(i));
         if pos('<m1 u',s)>0 then stringgrid1.Cells[0,0]:=getParam('u',s);
        end;
        nc:=1;
        nr:=2;
        ec:=1;
        er:=2;
        md:=false;
        rf:=true;
        cf:=true;
        mf:=false;
        for i:=1 to f.count do begin
         s:=Utf8ToAnsi(f.getstring(i));
         if md then begin
           if pos('<m46',s)>0 then begin
             if ec>=stringgrid1.colcount then stringgrid1.colcount:=ec+2;
             if cf then begin
               cf:=false;
               nc:=ec;
             end;
             stringgrid1.Cells[ec,er]:=getParam('u',s);
             inc(ec);
             if ec>=stringgrid1.colcount then stringgrid1.colcount:=ec+2;
           end;
           if pos('<m56',s)>0 then begin
             if er>=stringgrid1.rowcount then stringgrid1.rowcount:=er+2;
             if rf then begin
               rf:=false;
               nr:=er;
               inc(er);
             end;
             stringgrid1.Cells[0,er]:=getParam('u',s);
             inc(er);
             if er>=stringgrid1.rowcount then stringgrid1.rowcount:=er+2;
           end;
           if pos('<m20',s)>0 then begin
             if mf=false then begin
               mf:=true;
               r:=nr+1;
               c:=nc;
             end;
             Stringgrid1.Cells[c,r]:=DelSpace(getParam('u',s));
             inc(c);
           end;
           if pos('</TfrxNull',s)>0 then begin
            if mf then begin
              inc(r);
              c:=nc;
            end;
           end;
         end;
         if pos('<page0',s)>0 then begin
           md:=true;
           ec:=1;
           nc:=1;
           nr:=er;
           rf:=true;
           cf:=true;
           mf:=false;
         end;
         if pos('</page0',s)>0 then begin
           md:=false;
           er:=er+2;
           mf:=false;
         end;
        end;
      end;
    if not validstr(stringgrid1.Cells[0,0]) then stringgrid1.Cells[0,0]:=ExtractFileName(OpenDialog4.Files.Strings[z]);
    SaveXLS(DeleteSlasheEx(ExtractDirPath(OpenDialog4.Files.Strings[z]))+'\'+PrepFN(stringgrid1.Cells[0,0])+'.xls');
    deletefile(OpenDialog4.Files.Strings[z]+'.tmp');
   end;
   f.free;
   showmessage('End!');
  end;
end;

procedure TForm1.CheckBox14Click(Sender: TObject);
begin
  checkbox2.Checked:=checkbox14.Checked;
  checkbox3.Checked:=checkbox14.Checked;
  checkbox4.Checked:=checkbox14.Checked;
  checkbox5.Checked:=checkbox14.Checked;
  checkbox6.Checked:=checkbox14.Checked;
  checkbox7.Checked:=checkbox14.Checked;
  checkbox8.Checked:=checkbox14.Checked;
  checkbox9.Checked:=checkbox14.Checked;
  checkbox10.Checked:=checkbox14.Checked;
  checkbox11.Checked:=checkbox14.Checked;
  checkbox12.Checked:=checkbox14.Checked;
  checkbox13.Checked:=checkbox14.Checked;
  checkbox15.Checked:=checkbox14.Checked;
  checkbox16.Checked:=checkbox14.Checked;
  checkbox17.Checked:=checkbox14.Checked;
  checkbox18.Checked:=checkbox14.Checked;
  checkbox19.Checked:=checkbox14.Checked;
end;

procedure TForm1.Button7Click(Sender: TObject);
  var f1,f2:AF_types.TStrings;
  var s:string;
  var i,n:integer;
begin
{ if OpenDialog3.Execute then begin
  f1.create; f2.create;
  f1.loadfromfile(OpenDialog3.FileName);
   for i:=1 to f1.count do begin
     s:=f1.getstring(i);
     if pos('price="',s)>0 then begin
       st1:=getParam('station1',s);
       st2:=getParam('station2',s);
       s:=ReplaceParam(s,'price','0',true);
       s:=ReplaceParam(s,'reverse','1',true);
       s1:=s;
       s1:=ReplaceParam(s1,'reverse','0',true);
       f2.add(s1);
       s1:=ReplaceParam(s1,'station1',st2,true);
       s1:=ReplaceParam(s1,'station2',st1,true);
       f2.add(s1);
     end;
     f2.add(s);
   end;
  f2.savetofile(OpenDialog3.FileName);
  f1.free; f2.free;
  showmessage('end!');
 end;
} if OpenDialog3.Execute then begin
  f1.create; f2.create;
  f1.loadfromfile(OpenDialog3.FileName);
  n:=1;
  f2.add('<?xml version="1.0" encoding="Windows-1251"?>');
  f2.add('');
  f2.add('<channel type="tarif" version="1">');
   for i:=1 to f1.count do begin
     s:=f1.getstring(i);
     f2.add(s);
     if f2.count>=20003 then begin
       f2.add('</channel>');
       f2.savetofile(deleteslasheex(ExtractDirPath(OpenDialog3.FileName))+'\'+ExtractFileName(OpenDialog3.FileName)+inttostr(n)+'.xml');
       f2.clear;
       inc(n);
       f2.add('<?xml version="1.0" encoding="Windows-1251"?>');
       f2.add('');
       f2.add('<channel type="tarif" version="1">');
     end;
   end;
  f1.free; f2.free;
  showmessage('end!');
 end;
end;

procedure LoadSpb2016TariffTable(fn:string);
begin
with form1 do begin
  fn:=DeleteSlasheEx(ExtractDirPath(fn))+'\tariff\tariff_spb2017.xlsx';
  if not FileExists(fn) then ShowMessage(':    '+fn)
   else begin
     clearsg(stringgrid4);
     stringgrid4.RowCount:=1;
     LoadFromXLSRangeMatrix(fn,StringGrid4);
     if stringgrid4.RowCount<202 then ShowMessage('  '+fn+'   !');
   end;
end;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
  var i,n,m:integer;
  var s:string;
  var vres:boolean;
  var fo,u:AF_Types.TStrings;
begin
  MySQL := TMySQL.Create;
  MySQL.Host := cfg_mysql_host;
  MySQL.Port := strtointe(cfg_mysql_port);
  MySQL.User := cfg_mysql_user;
  MySQL.Password := cfg_mysql_password;
  if not MySQL.Connect then ShowMySQLError(MySQL)
   else begin
   MySQL.Database := cfg_mysql_database;
   MySQL.Query('set character_set_client=''cp1251'';');
   MySQL.Query('set character_set_results=''cp1251'';');
   MySQL.Query('set collation_connection=''cp1251_bin'';');
   end;
  fo.create; u.create;
  if OpenDialog1.Execute then begin
    if olddir0<>DeleteSlasheEx(ExtractFileName(Opendialog1.FileName)) then begin
      olddir0:=DeleteSlasheEx(ExtractFileName(Opendialog1.FileName));
      savedialog1.FileName:='';
      savedialog1.InitialDir:=DeleteSlasheEx(ExtractFileName(Opendialog1.FileName));
    end;
  if SaveDialog1.Execute then begin
  cppkst1.clear; cppkst2.clear; cppkst3.clear;
  fo.loadfromfile(DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\stations_cppk.csv');
   if fo.count>0 then begin
    for i:=1 to fo.count do begin
      ParseCSVStrEx(@u,fo.getstring(i),';');
      if u.count>2 then begin
       cppkst1.add(u.getstring(1));
       cppkst2.add(u.getstring(2));
       cppkst3.add(u.getstring(3));
      end;
    end;
   end;
  tlog15.clear;
  tlog16.clear;
  msk3500log.clear;
  msklogflag:=false;
  spblogflag:=false;
  AssignFile(tf1,DeleteSlasheEx(ExtractDirPath(SaveDialog1.FileName))+'\'+ExtractFileName(SaveDialog1.FileName)+'.out.csv');
  Rewrite(tf1);
  AssignFile(tf,SaveDialog1.FileName);
  Rewrite(tf);
  WriteLn(tf,'<?xml version="1.0" encoding="Windows-1251"?>');
  WriteLn(tf,'');
  WriteLn(tf,'<channel type="tarif" version="1">');
    for i:=0 to OpenDialog1.Files.Count-1 do begin
      vres:=false;
      ClearSG(stringgrid1);
      LoadFromXLS(OpenDialog1.Files.Strings[i],StringGrid1);
      mainfilename:=OpenDialog1.Files.Strings[i];
      stringgrid1.ColCount:=stringgrid1.RowCount+10;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='msk_skv' then begin Calc_MSKSKV; vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='bigmsk' then  begin Calc_BigMsk; vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='msk3500' then begin Calc_MSKab3500_072014; vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='msk3500zon' then begin Calc_Zone_AB3700_072014; vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='cppkzone' then begin Calc_Zone_Seg_CPPK(false); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='cppkzoneskv' then begin Calc_Zone_Seg_CPPK(true); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='cppktable' then begin Calc_Table(false,true,chNone); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='cppkexpresstable' then begin Calc_CPPKExpressTable(false,true); vres:=true; msklogflag:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='nn2013' then begin Calc_NN2013; vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='spb2016' then begin LoadSpb2016TariffTable(MainFileName); Calc_SPB2016(false,false,false); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='spb2016last' then begin LoadSpb2016TariffTable(MainFileName); Calc_SPB2016_last; vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='spb2016komfort' then begin LoadSpb2016TariffTable(MainFileName); Calc_SPB2016_komfort; vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='perm2016ab' then begin LoadSpb2016TariffTable(MainFileName); Calc_SPB2016(true,false,false); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='perm2016abex' then begin LoadSpb2016TariffTable(MainFileName); Calc_SPB2016(true,true,true); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='nn2016ab' then begin LoadSpb2016TariffTable(MainFileName); Calc_SPB2016(true,false,true); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='krasnoyarsk2011' then begin Calc_Zone_Seg(true,false,chNone, false); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='krasnoyarsk2011_mcd' then begin Calc_Zone_Seg(true,false,chNone, true); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='krasnoyarsk2011nolg' then begin Calc_Zone_Seg(false,false,chNone, false); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='krasnoyarsk2016' then begin Calc_Zone_Seg(true,true,chNone, false); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='krasnoyarsk2011ch' then begin Calc_Zone_Seg(true,false,chNormal, false); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='krasnoyarsk2011chnn' then begin Calc_Zone_Seg(true,false,chNN, false); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='ukraine' then begin Calc_Zone_Seg_Ukraine; vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='belarus2016' then begin Calc_Zone_Seg_Belarus(true); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='belarus2016city' then begin Calc_Zone_Seg_Belarus_City(true); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='moscow_mcc' then begin Calc_Zone_Seg_MCC; vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='table' then begin Calc_Table(false,false,chNone); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='lgtable' then begin Calc_Table(true,false,chNone); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='chlgtable' then begin Calc_Table(true,false,chNormal); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='nntable' then begin Calc_Table(true,false,chNN); vres:=true; end;
      if ansilowercase(trim(StringGrid1.Cells[0,1]))='matrix' then begin Calc_Matrix; vres:=true; end;
     if not vres then ShowMessage('  '+ExtractFileName(OpenDialog1.Files.Strings[i])+'       : '+ansilowercase(trim(StringGrid1.Cells[0,1])));
    end;
  WriteLn(tf,'</channel>');
  CloseFile(tf);
  CloseFile(tf1);
  if spblogflag then begin
    tlog15.add('');
    tlog16.add('');
    tlog15.savetofile(DeleteSlasheEx(ExtractDirPath(SaveDialog1.FileName))+'\'+ExtractFileName(SaveDialog1.FileName)+'.km.csv');
    tlog16.savetofile(DeleteSlasheEx(ExtractDirPath(SaveDialog1.FileName))+'\'+ExtractFileName(SaveDialog1.FileName)+'.list.csv');
    tlog16.clear;
    for n:=0 to StringGrid3.RowCount-1 do begin
     s:='';
     for m:=0 to StringGrid3.ColCount-1 do s:=s+stringgrid3.cells[m,n]+';';
     tlog16.add(s);
    end;
    tlog16.add('');
    tlog16.savetofile(mainfilename+'.angle.csv');
  end;
  if msklogflag then begin
    msk3500log.add('');
    msk3500log.savetofile(DeleteSlasheEx(ExtractDirPath(SaveDialog1.FileName))+'\'+ExtractFileName(SaveDialog1.FileName)+'.cppk.log');
  end;
  ShowMessage(' !');
  end;
  end;
  fo.free; u.free;
  if MySQL.Connected then MySQL.Disconnect;
end;



procedure TForm1.FormCreate(Sender: TObject);
begin
  tlog15.create;
  tlog16.create;
  msk3500log.create;
  cppkst1.create; cppkst2.create; cppkst3.create;
  loadmainini;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  tlog15.free;
  tlog16.free;
  msk3500log.free;
  cppkst1.free; cppkst2.free; cppkst3.free;
end;

procedure TForm1.Button8Click(Sender: TObject);
  var f:AF_Types.Tstrings;
  var i,n:integer;
begin
  clearsg(StringGrid1);
  if opendialog1.Execute then begin
    LoadFromXLS(opendialog1.FileName,stringgrid1);
    if ((stringgrid1.colcount>1)and(stringgrid1.rowcount>1)) then begin
     f.create;
     for i:=1 to StringGrid1.ColCount-1 do begin
      f.add(' '+stringgrid1.cells[i,0]);
      for n:=1 to StringGrid1.RowCount-1 do begin
        if validstr(stringgrid1.Cells[0,n]) then f.add('      if km='+stringgrid1.Cells[0,n]+' then t.finprice:='+stringgrid1.Cells[i,n]+';');
      end;
      f.add('');
      f.add('');
     end;
     f.savetofile(OpenDialog1.FileName+'.1');
     f.free;
    end;
    showmessage('end!');
  end;

end;

procedure TForm1.Button9Click(Sender: TObject);
  var f1,f2:AF_Types.Tstrings;
  var i:integer;
  var s:string;
begin
  f1.create; f2.create;
  f1.loadfromfile('C:\AF\\\_\2.xml');
  for i:=1 to f1.count do begin
    if pos('type="1m"',f1.getstring(i))>0 then begin
      s:=ReplaceParam(f1.getstring(i),'price','0',false);
//      f2.add(s);
{      f2.add(ReplaceParam(s,'type','3m',false));
      f2.add(ReplaceParam(s,'type','12m',false));
      f2.add(ReplaceParam(s,'type','1mr',false));
      f2.add(ReplaceParam(s,'type','3mr',false));
      f2.add(ReplaceParam(s,'type','vyhdn',false));}
      f2.add(ReplaceParam(s,'type','5d',false));
//      f2.add(ReplaceParam(s,'type','10d',false));
      f2.add(ReplaceParam(s,'type','15d',false));
      f2.add(ReplaceParam(s,'type','20d',false));
      f2.add(ReplaceParam(s,'type','25d',false));
    end;
  end;
  f2.savetofile('C:\AF\\\_\msk_oth_012015_clean_al.xml');
  f1.free; f2.free;
end;

function isnumber(s:string):boolean;
 var i,r:integer;
begin
  val(s,i,r);
  if r>0 then result:=false
         else result:=true;
  if i>0 then r:=i;
end;

procedure TForm1.Button10Click(Sender: TObject);
  var f,f1,hh1,hh2,u:AF_Types.Tstrings;
  var i,n,m,z,q,fsc:integer;
  var s:string;
  var hf:boolean;
begin
  f.create; f1.create; hh1.create; hh2.create; u.create;
  clearsg(StringGrid1);
  if opendialog1.Execute then begin
   f.loadfromfile(DeleteSlasheEx(ExtractDirPath(opendialog1.Files.Strings[0]))+'\vhead.txt');
   if f.count>0 then begin
    for i:=1 to f.count do begin
      if pos('|',f.getstring(i))>0 then begin
        ParseCSVStrEx(@u,f.getstring(i),'|');
        hh1.add(u.getstring(1));
        hh2.add(u.getstring(2));
      end;
    end;
   end;
   f.clear;
   if hh1.count<=0 then begin
     showmessage('    vhead.txt!');
     halt(1);
   end;
   for z:=0 to opendialog1.Files.count-1 do begin
    fsc:=0;
    hf:=true;
    f.clear;
    LoadFromXLS(opendialog1.Files.Strings[z],stringgrid1);
    if ((stringgrid1.colcount>1)and(stringgrid1.rowcount>1)) then begin
     clearsg(stringgrid2);
     stringgrid2.ColCount:=stringgrid1.ColCount;
     stringgrid2.RowCount:=stringgrid1.RowCount;
     clearsg(stringgrid2);
     for i:=0 to StringGrid1.RowCount-1 do begin
      m:=0;
      for n:=0 to StringGrid1.ColCount-1 do begin
        if validstr(stringgrid1.Cells[n,i]) then begin
                                                   s:=stringgrid1.Cells[n,i];
                                                    if pos('(',s)>0 then begin
                                                     s:=copy(s,pos('(',s)+1,length(s)-pos('(',s));
                                                     if pos(')',s)>1 then s:=copy(s,1,pos(')',s)-1);
                                                     if strtointe(s)>0 then begin
                                                       s:='$FIRSTSTATION='+s;
                                                       inc(fsc);
                                                     end;
                                                    end;
                                                   stringgrid2.cells[m,i]:=s;
                                                   inc(m);
                                                 end;
      end;
     end;
     for i:=0 to StringGrid2.RowCount-1 do begin
      s:='';
      if ((isnumber(stringgrid2.Cells[0,i])) and (strtointe(stringgrid2.Cells[2,i])>999)) then begin
       if hf then begin
         if f.count>0 then begin
           if f1.SearchString(strreplace(f.getstring(f.count),#9,'@'))<=0 then f1.add(strreplace(f.getstring(f.count),#9,'@'));
//           f1.add(extractfilename(opendialog1.Files.Strings[z])+'@'+strreplace(f.getstring(f.count),#9,'@'));
           q:=hh1.SearchString(strreplace(f.getstring(f.count),#9,'@'));
           if q<=0 then begin
             showmessage(extractfilename(opendialog1.Files.Strings[z])+' -   vhead.txt !');
             halt(2);
           end;
           f.edit(f.count,'$TABLEHEAD'+#9#9#9+strreplace(hh2.getstring(q),'@',#9));
         end;
       end;
       hf:=false;
      end
       else hf:=true;
      for n:=0 to StringGrid2.ColCount-1 do begin
       s:=s+stringgrid2.Cells[n,i]+#9;
      end;
      s:=strreplace(s,#9#9,#9);
      f.add(s);
     end;
     f.savetofile(opendialog1.Files.Strings[z]+'.tsv');
     if fsc>1 then showmessage(opendialog1.Files.Strings[z]+' -    > 0');
    end;
   end;
   f1.savetofile(DeleteSlasheEx(ExtractDirPath(opendialog1.Files.Strings[0]))+'\head.txt');
   showmessage('end!');
  end;
  f.free; f1.free; hh1.free; hh2.free; u.free;
end;

procedure TForm1.Button11Click(Sender: TObject);
  var f,f1,f2,u,st1,st2,th,tl:AF_Types.TStrings;
  var i,n,m,z:integer;
  var fst,dst,s:string;
begin
  f.create; f1.create; f2.create; u.create; st1.create; st2.create; th.create; tl.create;
  f1.add('<?xml version="1.0" encoding="Windows-1251"?>');
  f1.add('');
  f1.add('<channel type="tarif" version="1">');
  tl.add('1m');
  tl.add('3m');
  tl.add('12m');
  tl.add('5d');
  tl.add('10d');
  tl.add('15d');
  tl.add('20d');
  tl.add('25d');
  tl.add('vyhdn');
  tl.add('1mr');
  tl.add('3mr');
  tl.add('10dr');
  tl.add('15dr');
  tl.add('20dr');
  tl.add('25dr');
  tl.add('5dat');
  tl.add('6dat');
  tl.add('7dat');
  tl.add('8dat');
  tl.add('9dat');
  tl.add('10dat');
  tl.add('11dat');
  tl.add('12dat');
  tl.add('13dat');
  tl.add('14dat');
  tl.add('15dat');
  tl.add('16dat');
  tl.add('handbag');
  tl.add('velzh');
  tl.add('10p');
  tl.add('20p');
  tl.add('60p');
  tl.add('90p');
  if opendialog5.Execute then begin
    f.loadfromfile(deleteslasheex(extractdirpath(opendialog5.Files.strings[0]))+'\stationcodes.lst');
    if f.count>0 then begin
      for i:=1 to f.count do begin
       ParseCSVStrEx(@u,f.getstring(i),';');
       if u.count>2 then begin
         st1.add(u.getstring(2));
         st2.add(u.getstring(3));
       end;
      end;
    end;
    for i:=0 to opendialog5.Files.Count-1 do begin
      f.clear;
      fst:='';
      f.loadfromfile(opendialog5.Files.strings[i]);
      f2.add('');
      f2.add('');
      f2.add(SysUtils.ExtractFileName(opendialog5.Files.strings[i]));
      if f.count>0 then begin
        for n:=1 to f.count do begin
          ParseCSVStrEx(@u,f.getstring(n),#9);
          if u.count>0 then begin
            for m:=1 to u.count do begin
              if pos('$FIRSTSTATION',u.getstring(m))>0 then begin
                fst:=copy(u.getstring(m),pos('=',u.getstring(m))+1,length(u.getstring(m))-pos('=',u.getstring(m)));
                z:=st1.SearchString(fst);
                if z>0 then fst:=st2.getstring(z)
                       else f2.add('  -   '+fst);
              end;
            end;
            if u.getstring(1)='$TABLEHEAD' then begin
              if strtointe(fst)<=0 then f2.add(' -    !')
               else ParseCSVStrEx(@th,f.getstring(n),#9);
            end;
            if ((isnumber(u.getstring(1))) and (strtointe(u.getstring(3))>999)) then begin
             if u.count>3 then begin
              dst:=u.getstring(3);
              z:=st1.SearchString(dst);
              if z>0 then dst:=st2.getstring(z)
                     else f2.add('  -  '+dst);
              if u.count<>th.count then begin
                f2.add('     ,  '+u.getstring(3)+'  '+inttostr(th.count-u.count));
                if th.count-u.count=4 then begin
                 s:=u.getstring(u.count);
                 u.edit(u.count,'');
                 u.add('');
                 u.add('');
                 u.add('');
                 u.add(s);
                end;
              end;
              for m:=4 to u.count do begin
               if StrToFloatDef(u.getstring(m),0)>0 then begin
                z:=tl.SearchString(th.getstring(m));
                if z>0 then begin
                 f1.add('  <tarif station1="'+fst+'" station2="'+dst+'" price="'+u.getstring(m)+'" type="'+th.getstring(m)+'" reverse="1" />');
                end;
               end
                else f2.add('    - '+u.getstring(m));
              end;
             end;
            end;
          end;
        end;
      end;
    end;
    f1.add('</channel>');
    f1.savetofile(deleteslasheex(extractdirpath(opendialog5.Files.strings[0]))+'\mtppk.xml');
    f2.savetofile(deleteslasheex(extractdirpath(opendialog5.Files.strings[0]))+'\mtppk.log');
    showmessage('end!');
  end;
  f.free; f1.free; f2.free; u.free; st1.free; st2.free; th.free; tl.free;
end;

procedure TForm1.Button12Click(Sender: TObject);
  var i,n,q,m1,m2:integer;
  var c1,c2,c,l:AF_Types.TStrings;
begin
 c.create; c1.create; c2.create; l.create;
 if opendialog1.Execute then begin
  for q:=0 to OpenDialog1.Files.Count-1 do begin
    l.add(' '+Opendialog1.Files.Strings[q]);
    LoadFromXLS(Opendialog1.Files.Strings[q],StringGrid1);
    for i:=0 to StringGrid1.RowCount-1 do begin
     m1:=strtointe(StringGrid1.Cells[0,i]);
     m2:=strtointe(StringGrid1.Cells[1,i]);
     if ((m1>0)and(m2>0)) then begin
       n:=c1.SearchString(StringGrid1.Cells[0,i]);
       if n>0 then begin
        if c2.getstring(n)<>StringGrid1.Cells[1,i] then begin
          l.add(' '+StringGrid1.Cells[0,i]+'  '+c2.getstring(n)+'  '+StringGrid1.Cells[1,i]+'   '+inttostr(i+1));
        end;
       end
        else begin
          c1.add(StringGrid1.Cells[0,i]);
          c2.add(StringGrid1.Cells[1,i]);
        end;
     end;
    end;
  end;
  if c1.count>0 then begin
   for i:=1 to c1.count do begin
    c.add(trim(c1.getstring(i)+';'+Prep0ESR(trim(c2.getstring(i)))));
   end;
  end;
  c.savetofile(Opendialog1.Files.Strings[0]+'.list');
  l.savetofile(Opendialog1.Files.Strings[0]+'.log');
  showmessage('end!');
 end;
 c.free; c1.free; c2.free; l.free;
end;

procedure TForm1.Button13Click(Sender: TObject);
 var i,n,z,q,n1,n2,n3:integer;
 var l:AF_Types.TStrings;
 var r:Extended;
begin
 l.create;
 if opendialog1.Execute then begin
  for q:=0 to OpenDialog1.Files.Count-1 do begin
    l.add(' '+Opendialog1.Files.Strings[q]);
    LoadFromXLS(Opendialog1.Files.Strings[q],StringGrid1);
    stringgrid1.RowCount:=stringgrid1.RowCount+1;
    stringgrid1.Cells[0,stringgrid1.RowCount-1]:='';
    z:=0; n1:=0; {n2:=0;} n3:=0;
    repeat
        if n1>0 then begin
         if z>n1 then begin
          if StrToIntE(StringGrid1.Cells[0,z])<=0 then begin
           n2:=z-1;
           if n2>n1 then begin
             for i:=0 to stringgrid1.ColCount-1 do begin
               if trim(stringgrid1.Cells[i,n1-1])='' then begin
                n3:=i;
                break;
               end;
             end;
             if n3>0 then begin
              l.add(stringgrid1.cells[0,n1-2]+' '+stringgrid1.cells[1,n1]+' - '+stringgrid1.cells[1,n2]+' n3='+inttostr(n3));
              for n:=0 to n2-n1 do begin
               for i:=n1 to n2 do begin
                 if i>n1+n then begin
                   l.add(stringgrid1.cells[1,n1+n]+' - '+stringgrid1.cells[1,i]+' = '+stringgrid1.Cells[((n*2)+n3+1),i]);
                   r:=StrToFloatDef(stringgrid1.Cells[((n*2)+n3+1),i],0);
                   if r<=0 then l.add('ERROR:  ');
                 end;
               end;
              end;
             end
              else l.add('ERROR: '+inttostr(z)+': n3<1');
           end
            else l.add('ERROR: '+inttostr(z)+': n2<=n1');
           n1:=0;
//           n2:=0;
           n3:=0;
          end;
         end;
        end;
      if pos('MAPPT',StringGrid1.Cells[0,z])>0 then begin
        n1:=z+2;
//        n2:=0;
        n3:=0;
        inc(z);
      end;
      inc(z);
    until z>=stringgrid1.RowCount;
  end;
  l.savetofile(Opendialog1.Files.Strings[0]+'.log');
  showmessage('end!');
 end;
 l.free;
end;

procedure TForm1.Button14Click(Sender: TObject);
 var i,n,m,z,q,n1,n2,n3:integer;
 var l,c,c1,c2,c3,st1,st2:AF_Types.TStrings;
 var r:Extended;
 var s1,s2:string;
begin
 l.create; c.create; c1.create; c2.create; c3.create; st1.create; st2.create;
 if opendialog1.Execute then begin
  c.loadfromfile(deleteslasheex(extractdirpath(Opendialog1.Files.Strings[0]))+'\stcode.lst');
  if c.count>0 then begin
   for i:=1 to c.count do begin
     ParseCSVStrEx(@c1,c.getstring(i),';');
     if ((strtointe(c1.getstring(1))>0)and(strtointe(c1.getstring(2))>0)) then begin
       st1.add(c1.getstring(1));
       st2.add(c1.getstring(2));
     end;
   end;
  end
   else showmessage('      '+deleteslasheex(extractdirpath(Opendialog1.Files.Strings[0]))+'\stcode.lst');
  c1.clear;
  c.clear;
  c.add('<?xml version="1.0" encoding="Windows-1251"?>');
  c.add('');
  c.add('<channel type="tarif" version="1">');
  for q:=0 to OpenDialog1.Files.Count-1 do begin
    l.add(' '+Opendialog1.Files.Strings[q]);
    LoadFromXLS(Opendialog1.Files.Strings[q],StringGrid1);
    stringgrid1.RowCount:=stringgrid1.RowCount+1;
    stringgrid1.Cells[0,stringgrid1.RowCount-1]:='';
    z:=0; n1:=0; {n2:=0;} n3:=0;
    repeat
        if n1>0 then begin
         if z>n1 then begin
          if StrToIntE(StringGrid1.Cells[0,z])<=0 then begin
           n2:=z-1;
           if n2>n1 then begin
             for i:=0 to stringgrid1.ColCount-1 do begin
               if trim(stringgrid1.Cells[i,n1-1])='' then begin
                n3:=i;
                break;
               end;
             end;
             if n3>0 then begin
              l.add(stringgrid1.cells[0,n1-2]+' '+stringgrid1.cells[1,n1]+' - '+stringgrid1.cells[1,n2]+' n3='+inttostr(n3));
              for n:=0 to n2-n1 do begin
               for i:=n1 to n2 do begin
                 if i>n1+n then begin
                   r:=StrToFloatDef(stringgrid1.Cells[((n*2)+n3+1),i],0);
                   if r<=0 then begin
                      l.add(stringgrid1.cells[1,n1+n]+' - '+stringgrid1.cells[1,i]+' = '+stringgrid1.Cells[((n*2)+n3+1),i]);
                      l.add('WARNING:  ')
                    end
                     else begin
                       s1:=''; s2:='';
                       m:=st1.SearchString(trim(stringgrid1.cells[0,n1+n]));
                       if m>0 then s1:=st2.getstring(m);
                       m:=st1.SearchString(trim(stringgrid1.cells[0,i]));
                       if m>0 then s2:=st2.getstring(m);
                       if ((strtointe(s1)>0)and(strtointe(s2)>0)) then begin
                        if pos('',stringgrid1.cells[((n*2)+n3+1),n1-1])>0 then begin
                         c.add('  <tarif station1="'+s1+'" station2="'+s2+'" price="'+stringgrid1.Cells[((n*2)+n3+1),i]+'" type="etrain" reverse="1" />');
                        end
                         else l.add('ERROR:     "": '+stringgrid1.cells[1,n1+n]+' ('+s1+') - '+stringgrid1.cells[1,i]+' ('+s2+') = '+stringgrid1.Cells[((n*2)+n3+1),i]);
                       end
                        else l.add('HINT:     '+stringgrid1.cells[1,n1+n]+' ('+s1+') - '+stringgrid1.cells[1,i]+' ('+s2+') = '+stringgrid1.Cells[((n*2)+n3+1),i]);
                     end;
                 end;
               end;
              end;
             end
              else l.add('ERROR: '+inttostr(z)+': n3<1');
           end
            else l.add('ERROR: '+inttostr(z)+': n2<=n1');
           n1:=0;
//           n2:=0;
           n3:=0;
          end;
         end;
        end;
      if pos('MAPPT',StringGrid1.Cells[0,z])>0 then begin
        n1:=z+2;
//        n2:=0;
        n3:=0;
        inc(z);
      end;
      inc(z);
    until z>=stringgrid1.RowCount;
  end;
  c.add('</channel>');
  c.savetofile(Opendialog1.Files.Strings[0]+'.tariff');
  l.savetofile(Opendialog1.Files.Strings[0]+'.log');
  showmessage('end!');
 end;
 l.free; c.free; c1.free; c2.free; c3.free; st1.free; st2.free;
end;

{function findstcol(sg:TStringGrid; r:integer; s:string):integer;
 var i,z:integer;
begin
 z:=-1;
 for i:=0 to sg.ColCount-1 do begin
   if sg.Cells[i,r]=s then begin
    if sg.cells[i,r+1]='' then begin
      z:=i;
      break;
    end;
   end;
 end;
 result:=z;
end;
}
procedure SZPPK_Parse_SG(c,l,tl,tl1,tl2:AF_Types.PStrings;tt:string;l1,l2,l3:AF_Types.PStrings);
 var i,n,m,z,n1,n2,n3,j:integer;
 var c1,c2,c3,st1,st2:AF_Types.TStrings;
 var r:Extended;
 var s1,s2,sl3:string;
begin
 with form1 do begin
 tl.clear; tl1.clear; tl2.clear;
 c1.create; c2.create; c3.create; st1.create; st2.create;
  c2.loadfromfile(deleteslasheex(extractdirpath(application.ExeName))+'\szppk_stcode.lst');
  if c2.count>0 then begin
   for i:=1 to c2.count do begin
     ParseCSVStrEx(@c1,c2.getstring(i),';');
     if ((strtointe(c1.getstring(1))>0)and(strtointe(c1.getstring(2))>0)) then begin
       st1.add(c1.getstring(1));
       st2.add(c1.getstring(2));
     end;
   end;
  end
   else showmessage('      '+deleteslasheex(extractdirpath(application.ExeName))+'\szppk_stcode.lst');
  c1.clear;
  c2.clear;
    l.add('====  '+tt);
    l1.add('====  '+tt);
    stringgrid1.RowCount:=stringgrid1.RowCount+1;
    stringgrid1.Cells[0,stringgrid1.RowCount-1]:='';
    z:=0; n1:=0; {n2:=0;} n3:=0;
    repeat
        if n1>0 then begin
         if z>n1 then begin
          if StrToIntE(StringGrid1.Cells[0,z])<=0 then begin
           n2:=z-1;
           if n2>n1 then begin
             for i:=0 to stringgrid1.ColCount-1 do begin
               if trim(stringgrid1.Cells[i,n1-1])='' then begin
                n3:=i;
                break;
               end;
             end;
             if n3>0 then begin
              l.add(stringgrid1.cells[1,n1-1]+' '+stringgrid1.cells[1,n1]+' - '+stringgrid1.cells[1,n2]{+' n3='+inttostr(n3)});
              l1.add(stringgrid1.cells[1,n1-1]+' '+stringgrid1.cells[1,n1]+' - '+stringgrid1.cells[1,n2]{+' n3='+inttostr(n3)});
              StatusBar1.SimpleText:=__wsname0+' '+stringgrid1.cells[0,n1-1];
              application.ProcessMessages;
             for n:=0 to n2-n1 do begin
               for i:=n1 to n2 do begin
                 if i>n1+n then begin
                   r:=StrToFloatDef(stringgrid1.Cells[((n*2)+n3+1),i],0);
                   if r<=0 then begin
                      l1.add('      WARNING:   '+tt+' '+stringgrid1.cells[1,n1+n]+' - '+stringgrid1.cells[1,i]+' = '+stringgrid1.Cells[((n*2)+n3+1),i]);
                    end
                     else begin
                       s1:=''; s2:='';
                       m:=st1.SearchString(trim(stringgrid1.cells[0,n1+n]));
                       if m>0 then s1:=st2.getstring(m);
                       m:=st1.SearchString(trim(stringgrid1.cells[0,i]));
                       if m>0 then s2:=st2.getstring(m);
                       if ((strtointe(s1)>0)and(strtointe(s2)>0)) then begin
                        if pos('',stringgrid1.cells[((n*2)+n3+1),n1-1])>0 then begin
                         j:=tl.SearchString(s1+';'+s2+';'+tt);
                         if j<=0 then begin
                           c.add('  <tarif xprout="'+stringgrid1.cells[1,n1-1]+'" station1="'+s1+'" station2="'+s2+'" price="'+trim(stringgrid1.Cells[((n*2)+n3+1),i])+'" type="'+tt+'" reverse="1" />');
//                           c.add('  <tarif station1="'+s1+'" station2="'+s2+'" price="'+trim(stringgrid1.Cells[((n*2)+n3+1),i])+'" type="'+tt+'" reverse="1" />');
                           tl.add(s1+';'+s2+';'+tt);
                           tl1.add(trim(stringgrid1.Cells[((n*2)+n3+1),i]));
                           tl2.add(stringgrid1.cells[1,n1-1]+' '+stringgrid1.cells[1,n1]+' - '+stringgrid1.cells[1,n2]);
                          if stringgrid1.cells[1,n1+n]<>stringgrid1.Cells[((n*2)+n3+1),n1-2] then begin
//                           l.add('  ERROR:    : '+stringgrid1.cells[1,n1+n]+' ('+s1+') - '+stringgrid1.cells[1,i]+' ('+s2+'),     '+stringgrid1.Cells[((n*2)+n3+1),n1-2]);
                          end
                         end
                          else begin
                           if tl1.getstring(j)<>trim(stringgrid1.Cells[((n*2)+n3+1),i]) then l.add('  ERROR:   : '+tt+' '+stringgrid1.cells[1,n1+n]+' ('+s1+') - '+stringgrid1.cells[1,i]+' ('+s2+') = '+stringgrid1.Cells[((n*2)+n3+1),i]+',   '+tl1.getstring(j)+'   '+tl2.getstring(j));
                          end;
                        end
                         else l.add('  ERROR:     "": '+stringgrid1.cells[1,n1+n]+' ('+s1+') - '+stringgrid1.cells[1,i]+' ('+s2+') = '+stringgrid1.Cells[((n*2)+n3+1),i]);
                       end
                        else begin
                          l2.add('  HINT:     '+stringgrid1.cells[1,n1+n]+' ('+s1+') - '+stringgrid1.cells[1,i]+' ('+s2+') = '+stringgrid1.Cells[((n*2)+n3+1),i]);
                          sl3:='';
                          if not validstr(s1) then begin
                            sl3:=stringgrid1.cells[0,n1+n]+'|'+stringgrid1.cells[1,n1+n];
                            if l3.SearchString(sl3)<=0 then l3.add(sl3);
                          end;
                          if not validstr(s2) then begin
                            sl3:=stringgrid1.cells[0,i]+'|'+stringgrid1.cells[1,i];
                            if l3.SearchString(sl3)<=0 then l3.add(sl3);
                          end;
                        end;
                     end;
                 end;
               end;
              end;
             end
              else l.add('  ERROR: '+inttostr(z)+': n3<1');
           end
            else l.add('  ERROR: '+inttostr(z)+': n2<=n1');
           n1:=0;
//           n2:=0;
           n3:=0;
          end;
         end;
        end;
      if pos('MAPPT',StringGrid1.Cells[0,z])>0 then begin
        n1:=z+2;
//        n2:=0;
        n3:=0;
        inc(z);
      end;
      inc(z);
    until z>=stringgrid1.RowCount;
 c1.free; c2.free; c3.free; st1.free; st2.free;
 end;
end;



procedure TForm1.Button15Click(Sender: TObject);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
cf,X, Y, xx, yy, ws : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
tt:string;
sg:TStringGrid;
c,l,tl,tl1,tl2,l1,l2,l3:AF_types.TStrings;
begin
c.create; l.create; tl.create; tl1.create; tl2.create; l1.create; l2.create; l3.create;
c.add('<?xml version="1.0" encoding="Windows-1251"?>');
c.add('');
c.add('<channel type="tarif" version="1">');
if opendialog1.Execute then begin
if SaveDialog1.Execute then begin
XLApp.Connect;
for cf:=0 to opendialog1.Files.Count-1 do begin
sg:=StringGrid1;
NomFich := opendialog1.Files.Strings[cf];
IIndex := 1;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
 for ws:=1 to WorkBk.Worksheets.Count do begin
  clearsg(sg);
  WorkSheet := WorkBk.Sheets[ws] as _WorkSheet;
  WorkSheet.Activate(0);
  WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
  X := XLApp.ActiveCell.Row;
  Y := XLApp.ActiveCell.Column;
  if y>700 then y:=700;
  sg.ColCount := Y;
  sg.RowCount := X;
  RangeMatrix := XLApp.Range['A1', XLApp.Cells.Item[X, Y]].Value2;
  l.add('============');
  l.add(' - '+worksheet.Name+'  //  '+extractfilename(opendialog1.Files.Strings[cf]));
  clearsg(sg);
  for xx:=1 to x do begin
   StatusBar1.SimpleText:=worksheet.Name+' //  '+inttostr(xx);
   application.ProcessMessages;
   for yy:=1 to y do begin
//    if VarType(worksheet.cells.item[xx,yy])<>vardispatch then begin
{      nf:=worksheet.cells.item[xx,yy].NumberFormat;
      if (nf=':')or(nf=':')or(nf='h:mm')or(nf='hh:mm;@')or(nf=':;@')or(nf=':;@')or(nf='h:mm;@')or(nf='hh:mm;@') then begin
         tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xx,yy]),70);
         if tf=70 then sg.Cells[yy-1,xx-1]:=trim(VarToStrDef(worksheet.cells.item[xx,yy],''))
                  else sg.Cells[yy-1,xx-1]:=trim(FormatDateTime('hh:nn',tf));
      end
       else sg.Cells[yy-1,xx-1]:=trim(VarToStrDef(worksheet.cells.item[xx,yy],''));  }
     sg.Cells[yy-1,xx-1]:=trim(VarToStrDef(RangeMatrix[xx,yy],''));

//    end
//     else l.Add('ERROR: varDispatch '+inttostr(xx)+' '+inttostr(yy));

   end;
  end;
  RangeMatrix:=Unassigned;
  if sg.ColCount>4 then begin
   for yy:=0 to sg.RowCount-1 do begin
    for xx:=1 to sg.ColCount-2 do begin
     if sg.cells[xx-1,yy]='' then begin
      if sg.cells[xx+1,yy]='' then begin
       if sg.cells[xx,yy]='76' then begin
        sg.cells[xx,yy]:='';
       end;
      end;
     end;
    end;
   end;
  end;

  tt:='';

  if worksheet.Name=' 5 ' then tt:='5d';
  if worksheet.Name=' 10 ' then tt:='10d';
  if worksheet.Name=' 15 ' then tt:='15d';
  if worksheet.Name=' 1 ' then tt:='1m';
  if worksheet.Name=' 10 ' then tt:='10dr';
  if worksheet.Name=' 10 ' then tt:='10dr';
  if worksheet.Name=' 15 ' then tt:='15dr';
  if worksheet.Name=' 15 ' then tt:='15dr';
  if worksheet.Name=' 1 ' then tt:='1mr';
  if worksheet.Name=' 5 ' then tt:='5dat';
  if worksheet.Name=' 10' then tt:='10p';
  if worksheet.Name=' 20' then tt:='20p';
  if worksheet.Name=' 60' then tt:='60p';
  if worksheet.Name=' 90' then tt:='90p';

  if worksheet.Name='' then tt:='etrain';
  if worksheet.Name='' then tt:='child';
  if worksheet.Name='' then tt:='animal';
  if worksheet.Name='5  ' then tt:='5d';
  if worksheet.Name='10  ' then tt:='10d';
  if worksheet.Name='15  ' then tt:='15d';
  if worksheet.Name='1  ' then tt:='1m';
  if worksheet.Name='10  ' then tt:='10dr';
  if worksheet.Name='15  ' then tt:='15dr';
  if worksheet.Name='1  ' then tt:='1mr';
  if worksheet.Name=' 5 ' then tt:='5dat';
  if worksheet.Name='10 ' then tt:='10p';
  if worksheet.Name='20 ' then tt:='20p';
  if worksheet.Name='60 ' then tt:='60p';
  if worksheet.Name='90 ' then tt:='90p';

  if worksheet.Name=' ' then tt:='etrain';
  if worksheet.Name=' ' then tt:='child';
  if worksheet.Name=' ' then tt:='animal';
  if worksheet.Name=' ' then tt:='etrain';
  if worksheet.Name=' ' then tt:='child';
  if worksheet.Name=' ' then tt:='child';
  if worksheet.Name=' ' then tt:='animal';
  if worksheet.Name='  ()' then tt:='last';
  if worksheet.Name='  ()' then tt:='last_child';
  if worksheet.Name='  ()' then tt:='last_child';
  if worksheet.Name=' 5  ()' then tt:='last5d';
  if worksheet.Name=' 10  ()' then tt:='last10d';
  if worksheet.Name=' 15  ()' then tt:='last15d';
  if worksheet.Name=' 1  ()' then tt:='last1m';
  if worksheet.Name=' 1  ()' then tt:='last1m';
  if worksheet.Name=' 10  ()' then tt:='last10dr';
  if worksheet.Name=' 15  ()' then tt:='last15dr';
  if worksheet.Name=' 1  ()' then tt:='last1mr';
  if worksheet.Name=' 1  ()' then tt:='last1mr';
  if worksheet.Name=' 5  ()' then tt:='last5dat';
  if worksheet.Name=' 10  ()' then tt:='last10p';
  if worksheet.Name=' 20  ()' then tt:='last20p';
  if worksheet.Name=' 60  ()' then tt:='last60p';
  if worksheet.Name=' 90  ()' then tt:='last90p';

  if worksheet.Name=' 1   ()' then tt:='last1mvelo';
  if worksheet.Name=' 1   ()' then tt:='last1mrvelo';

  if worksheet.Name='etrain' then tt:='etrain';
  if worksheet.Name='child' then tt:='child';
  if worksheet.Name='animal' then tt:='animal';
  if worksheet.Name='5d' then tt:='5d';
  if worksheet.Name='10d' then tt:='10d';
  if worksheet.Name='15d' then tt:='15d';
  if worksheet.Name='1m' then tt:='1m';
  if worksheet.Name='10dr' then tt:='10dr';
  if worksheet.Name='15dr' then tt:='15dr';
  if worksheet.Name='1mr' then tt:='1mr';
  if worksheet.Name='5dat' then tt:='5dat';
  if worksheet.Name='10p' then tt:='10p';
  if worksheet.Name='20p' then tt:='20p';
  if worksheet.Name='60p' then tt:='60p';
  if worksheet.Name='90p' then tt:='90p';
  if worksheet.Name='last' then tt:='last';
  if worksheet.Name='last_child' then tt:='last_child';
  if worksheet.Name='last5d' then tt:='last5d';
  if worksheet.Name='last10d' then tt:='last10d';
  if worksheet.Name='last15d' then tt:='last15d';
  if worksheet.Name='last1m' then tt:='last1m';
  if worksheet.Name='last3m' then tt:='last3m';
  if worksheet.Name='last12m' then tt:='last12m';
  if worksheet.Name='last10dr' then tt:='last10dr';
  if worksheet.Name='last15dr' then tt:='last15dr';
  if worksheet.Name='last1mr' then tt:='last1mr';
  if worksheet.Name='last3mr' then tt:='last3mr';
  if worksheet.Name='last12mr' then tt:='last12mr';

  if worksheet.Name='last5dat' then tt:='last5dat';
  if worksheet.Name='last10p' then tt:='last10p';
  if worksheet.Name='last20p' then tt:='last20p';
  if worksheet.Name='last60p' then tt:='last60p';
  if worksheet.Name='last90p' then tt:='last90p';

  if worksheet.Name=' ' then tt:='dachny';
  if worksheet.Name='  ()' then tt:='dachny_last';
  if worksheet.Name='dachny' then tt:='dachny';
  if worksheet.Name='dachny1' then tt:='dachny';
  if worksheet.Name='dachny2' then tt:='dachny';
  if worksheet.Name='1mvygodny' then tt:='1mvygodny';
  if worksheet.Name='1mrvygodny' then tt:='1mrvygodny';

  if worksheet.Name=' ' then tt:='detsky';
  if worksheet.Name='  ()' then tt:='detsky_last';

  if worksheet.Name='  ()' then tt:='komfort';
  if worksheet.Name='  ()' then tt:='komfort_child';

  if tt='' then begin
    l.add('');
    l.add('!!!     : '+worksheet.Name);
    l.add('');
  end
   else begin
     statusbar1.SimpleText:=worksheet.Name;
     __wsname0:=worksheet.Name;
     Application.ProcessMessages;
     SZPPK_Parse_SG(@c,@l,@tl,@tl1,@tl2,tt,@l1,@l2,@l3);
   end;
 end; //ws
 XLApp.Quit;
end; //for cf
XLApp.Disconnect;
c.add('</channel>');
c.savetofile(savedialog1.FileName);
if l3.count>0 then begin
 l.add('');
 l.add('   :');
 l.include(l3);
end;
l.savetofile(deleteslasheex(extractdirpath(savedialog1.FileName))+'\'+ExtractFileName(SaveDialog1.FileName)+'.log');
l1.include(l2);
l1.savetofile(deleteslasheex(extractdirpath(savedialog1.FileName))+'\'+ExtractFileName(SaveDialog1.FileName)+'.log1');
showmessage(' .            .         ,    ,  !');
statusbar1.SimpleText:='';
end; //savedialog
end; //opendialog
c.free; l.free; tl.free; tl1.free; tl2.free; l1.free; l2.free; l3.free;
end;

function getVykhinoFix(s:string):boolean;
  var res:boolean;
begin
  res:=false;
  if s='194013' then res:=true;
  if s='194028' then res:=true;
  if s='194032' then res:=true;
  if s='193913' then res:=true;
  if s='193928' then res:=true;
  if s='193805' then res:=true;
  if s='193810' then res:=true;
  if s='193824' then res:=true;
  if s='193839' then res:=true;
  result:=res;
end;

procedure TForm1.Button16Click(Sender: TObject);
 var f,f1,t1,t2:AF_Types.Tstrings;
 var i,n,z,cnt:integer;
 var st1,st2,tar,gor,ttt,mn:string;
begin
 z:=0;
 f.create; f1.create; t1.create; t2.create;
 f.loadfromfile('C:\AF\\\ \msk_2016_kaz.xml');
 for i:=1 to f.count do begin
   st1:=getParam('station1',f.getstring(i));
   st2:=getParam('station2',f.getstring(i));
   tar:=getParam('price',f.getstring(i));
   gor:=getParam('citygr',f.getstring(i));
   ttt:=getParam('type',f.getstring(i));
   if st1='193839' then begin
    if gor<>'1' then begin
      n:=strtointe(tar);
      if n>0 then begin
        if ttt='1m' then begin
          setroundmode(rmTruncate);
          n:=round(((n+(n div 10)) div 5))*5;
          if n>4300 then n:=4300;
          t1.add(st2+';'+ttt);
          t2.add(inttostr(n));
          z:=n;
          mn:=st1+';'+st2;
        end;
        if ttt='3m' then begin
          setroundmode(rmTruncate);
          n:=round(((n+(n div 10)) div 10))*10;
          if n>11650 then n:=11650;
          t1.add(st2+';'+ttt);
          t2.add(inttostr(n));
        end;
        if ttt='12m' then begin
          if mn=st1+';'+st2 then begin
           n:=z*10;
           if n>43000 then n:=43000;
           t1.add(st2+';'+ttt);
           t2.add(inttostr(n));
          end
           else showmessage('  1m  '+st1+';'+st2);
        end;
        if ttt='1mr' then begin
          setroundmode(rmTruncate);
          n:=round(((n+(n div 10)) div 5))*5;
          if n>4300 then n:=4300;
          t1.add(st2+';'+ttt);
          t2.add(inttostr(n));
        end;
        if ttt='3mr' then begin
          setroundmode(rmTruncate);
          n:=round(((n+(n div 10)) div 10))*10;
          if n>11650 then n:=11650;
          t1.add(st2+';'+ttt);
          t2.add(inttostr(n));
        end;
      end;
    end;
   end;
 end;

 t1.savetofile('C:\AF\\\ \_msk_kaz.log');
 f.clear;
 f.loadfromfile('C:\AF\\\ \msk_2016_kaz.xml');

 f1.add('<?xml version="1.0" encoding="Windows-1251"?>');
 f1.add('');
 f1.add('<channel type="tarif" version="1">');
 cnt:=0;
 for i:=1 to f.count do begin
   st1:=getParam('station1',f.getstring(i));
   st2:=getParam('station2',f.getstring(i));
   tar:=getParam('price',f.getstring(i));
   gor:=getParam('citygr',f.getstring(i));
   ttt:=getParam('type',f.getstring(i));
   if gor<>'1' then begin
     if getVykhinoFix(st1) then begin
      if strtointe(tar)>0 then begin
       z:=t1.SearchString(st2+';'+ttt);
       if z>0 then begin
        f1.add('  <tarif station1="'+st1+'" station2="'+st2+'" price="'+t2.getstring(z)+'" type="'+ttt+'" reverse="1" />');
        inc(cnt);
       end
//        else showmessage('     '+st2+';'+ttt);
      end;
     end;
   end;
 end;
 f1.add('</channel>');
 f1.savetofile('C:\AF\\\ \msk_2016_ab2.xml');
 f.free; f1.free; t1.free; t2.free;
 showmessage('end - '+inttostr(cnt)+' ');
 StatusBar1.SimpleText:='';
end;

procedure TForm1.Button17Click(Sender: TObject);
 var s,s1,s2,tar:string;
 var i,n:integer;
 var f,f1,st0,st1,st2,u:AF_Types.TStrings;
begin
 f.create; f1.create; st0.create; st1.create; st2.create; u.create;
 if OpenDialog3.Execute then begin
  s:=DeleteSlasheEx(ExtractDirPath(OpenDialog3.FileName))+'\szppk_add.xlsx';
  if fileexists(s) then begin
    ClearSG(stringgrid1);
    LoadFromXLS(s,stringgrid1);
    for i:=0 to stringgrid1.RowCount-1 do begin
      stringgrid1.cells[0,i]:=Prep0ESR(trim(stringgrid1.cells[0,i]));
      stringgrid1.cells[3,i]:=Prep0ESR(trim(stringgrid1.cells[3,i]));
      stringgrid1.cells[5,i]:=Prep0ESR(trim(stringgrid1.cells[5,i]));
      if ((strtointe(stringgrid1.cells[0,i])>0)and(strtointe(stringgrid1.cells[3,i])>0)and(strtointe(stringgrid1.cells[5,i])>0)) then begin
        st0.add(stringgrid1.cells[0,i]);
        st1.add(stringgrid1.cells[3,i]);
        st2.add(stringgrid1.cells[5,i]);
      end;
    end;
    if st0.count>0 then begin
      f.loadfromfile(OpenDialog3.FileName);
      if f.count>0 then begin
        f1.add('<?xml version="1.0" encoding="Windows-1251"?>');
        f1.add('');
        f1.add('<channel type="tarif" version="1">');
        for i:=1 to f.count do begin
          s:=f.getstring(i);
          s1:=prep0esr(getParam('station1',s));
          s2:=prep0esr(getParam('station2',s));
          tar:=ansilowercase(getParam('type',s));
          if ((tar='etrain')or(tar='child')or(tar='komfort')or(tar='komfort_child')) then begin
            st1.SearchStrings(s2,u);
            if u.count>0 then begin
             for n:=1 to u.count do begin
               f1.add(ReplaceParam(s,'station2',st0.getstring(strtointe(u.getstring(n))),true));
             end;
            end;
            st2.SearchStrings(s1,u);
            if u.count>0 then begin
             for n:=1 to u.count do begin
               f1.add(ReplaceParam(s,'station1',st0.getstring(strtointe(u.getstring(n))),true));
             end;
            end;
            for n:=1 to st0.count do begin
              if ((s1=st1.getstring(n))and(s2=st2.getstring(n))) then begin
               f1.add('  '+ReplaceParam(s,'station2',st0.getstring(n),true));
               f1.add('  '+ReplaceParam(s,'station1',st0.getstring(n),true));
              end;
            end;
          end;
        end;
        f1.add('</channel>');
        SaveDialog1.InitialDir:=DeleteSlasheEx(ExtractDirPath(OpenDialog3.FileName));
        if SaveDialog1.Execute then begin
          f1.savetofile(SaveDialog1.FileName);
          showmessage(' .         ,    ,  !');
        end;
      end
       else ShowMessage('  !');
    end
     else ShowMessage('  szppk_add.xlsx        !');
  end
   else ShowMessage('     szppk_add.xlsx,   !');
 end;
 f.free; f1.free; st0.free; st1.free; st2.free; u.free;
end;

procedure TForm1.Button19Click(Sender: TObject);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
cf,X, Y, xx, yy, ws, i, n ,m1, m2 : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
tf:Extended;
sg:TStringGrid;
c,l,tl,tl1,tl2,l1,l2:AF_types.TStrings;
begin
c.create; l.create; tl.create; tl1.create; tl2.create; l1.create; l2.create;
c.add('<?xml version="1.0" encoding="Windows-1251"?>');
c.add('');
c.add('<channel type="tarif" version="1">');
if opendialog1.Execute then begin
if SaveDialog1.Execute then begin
XLApp.Connect;
if FileExists(deleteslasheex(ExtractDirPath(OpenDialog1.FileName))+'\mtppk.txt') then begin
 tl.loadfromfile(deleteslasheex(ExtractDirPath(OpenDialog1.FileName))+'\mtppk.txt');
 if tl.count>0 then begin
  for i:=1 to tl.count do begin
   ParseCSVStrEx(@l,tl.getstring(i),#9);
   if l.count>1 then begin
    if strtointe(l.getstring(1))>0 then begin
     l1.add(l.getstring(1));
     l2.add(ansilowercase(trim(l.getstring(2))));
    end;
   end;
  end;
 end;
end;
if l1.count<2 then ShowMessage('     mtppk.txt!');
for cf:=0 to opendialog1.Files.Count-1 do begin
sg:=StringGrid1;
NomFich := opendialog1.Files.Strings[cf];
IIndex := 1;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
 for ws:=1 to WorkBk.Worksheets.Count do begin
  clearsg(sg);
  WorkSheet := WorkBk.Sheets[ws] as _WorkSheet;
  WorkSheet.Activate(0);
  WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
  X := XLApp.ActiveCell.Row;
  Y := XLApp.ActiveCell.Column;
  sg.ColCount := Y;
  sg.RowCount := X;
  RangeMatrix := XLApp.Range['A1', XLApp.Cells.Item[X, Y]].Value2;
  clearsg(sg);
  for xx:=1 to x do begin
   StatusBar1.SimpleText:=worksheet.Name+' //  '+inttostr(xx);
   application.ProcessMessages;
   for yy:=1 to y do begin
     sg.Cells[yy-1,xx-1]:=trim(VarToStrDef(RangeMatrix[xx,yy],''));
   end;
  end;
  RangeMatrix:=Unassigned;
  if sg.RowCount>5 then begin
   for i:=3 to sg.ColCount-1 do begin
    for n:=i+2 to sg.RowCount-1 do begin
      tf:=StrToFloatDef(sg.cells[i,n],0);
//      if tf>0 then c.add(worksheet.Name+' '+sg.cells[i,1]+' - '+sg.cells[0,n]+' = '+sg.cells[i,n]);
      if tf>0 then begin
       m1:=l2.SearchString(ansilowercase(trim(sg.cells[i,1])));
       m2:=l2.SearchString(ansilowercase(trim(sg.cells[0,n])));
       if m1>0 then begin
       if m2>0 then begin
        c.add('  <tarif station1="'+l1.getstring(m1)+'" station2="'+l1.getstring(m2)+'" price="'+sg.cells[i,n]+'" type="'+ansilowercase(worksheet.Name)+'" reverse="1" />');
       end;
       end;
      end;
    end;
   end;
  end;

 end; //ws
 XLApp.Quit;
end; //for cf
XLApp.Disconnect;
c.add('</channel>');
c.savetofile(savedialog1.FileName);
showmessage(' !');
statusbar1.SimpleText:='';
end; //savedialog
end; //opendialog
c.free; l.free; tl.free; tl1.free; tl2.free; l1.free; l2.free;
end;

procedure TForm1.Button20Click(Sender: TObject);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
cf,X, Y, xx, yy, ws, i : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
sg:TStringGrid;
c,l,tl,tl1,tl2,l1,l2:AF_types.TStrings;
begin
c.create; l.create; tl.create; tl1.create; tl2.create; l1.create; l2.create;
if opendialog1.Execute then begin
XLApp.Connect;
for cf:=0 to opendialog1.Files.Count-1 do begin
sg:=StringGrid1;
NomFich := opendialog1.Files.Strings[cf];
IIndex := 1;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
 for ws:=1 to WorkBk.Worksheets.Count do begin
  clearsg(sg);
  WorkSheet := WorkBk.Sheets[ws] as _WorkSheet;
  WorkSheet.Activate(0);
  WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
  X := XLApp.ActiveCell.Row;
  Y := XLApp.ActiveCell.Column;
  sg.ColCount := Y;
  sg.RowCount := X;
  RangeMatrix := XLApp.Range['A1', XLApp.Cells.Item[X, Y]].Value2;
  clearsg(sg);
  c.add('');
  c.add('');
  c.add(worksheet.Name);
  for xx:=1 to x do begin
   StatusBar1.SimpleText:=worksheet.Name+' //  '+inttostr(xx);
   application.ProcessMessages;
   for yy:=1 to y do begin
     sg.Cells[yy-1,xx-1]:=trim(VarToStrDef(RangeMatrix[xx,yy],''));
   end;
  end;
  RangeMatrix:=Unassigned;
  if sg.RowCount>5 then begin
   for i:=0 to sg.RowCount-1 do begin
    if validstr(sg.cells[0,i]) then begin
      c.add('if km='+sg.cells[0,i]+' then t.finprice:='+sg.cells[1,i]+';');
    end;
   end;
  end;

 end; //ws
 XLApp.Quit;
end; //for cf
XLApp.Disconnect;
c.savetofile(opendialog1.FileName+'.pas');
showmessage(' !');
statusbar1.SimpleText:='';
end; //opendialog
c.free; l.free; tl.free; tl1.free; tl2.free; l1.free; l2.free;
end;

procedure TForm1.Button18Click(Sender: TObject);
 var f,f1:AF_Types.TSTrings;
 var i:integer;
 var s:string;
begin
 f.create; f1.create;
 f.loadfromfile('C:\AF\\\ \msk_dates_clean.xml');
 if f.count>0 then begin
  for i:=1 to f.count do begin
    s:=f.getstring(i);
    if pos('<tarif ',s)>0 then begin
      f1.add(ReplaceParam(s,'type','5 dat',false));
      f1.add(ReplaceParam(s,'type','6 dat',false));
      f1.add(ReplaceParam(s,'type','7 dat',false));
      f1.add(ReplaceParam(s,'type','8 dat',false));
      f1.add(ReplaceParam(s,'type','9 dat',false));
      f1.add(ReplaceParam(s,'type','10 dat',false));
      f1.add(ReplaceParam(s,'type','11 dat',false));
      f1.add(ReplaceParam(s,'type','12 dat',false));
      f1.add(ReplaceParam(s,'type','13 dat',false));
      f1.add(ReplaceParam(s,'type','14 dat',false));
      f1.add(ReplaceParam(s,'type','15 dat',false));
      f1.add(ReplaceParam(s,'type','16 dat',false));
    end
     else f1.add(s);
  end;
 end;
 f1.savetofile('C:\AF\\\ \msk_dates_clean1.xml');
 f.free; f1.free;
end;

procedure TForm1.Button21Click(Sender: TObject);
  var f,f1:AF_Types.TStrings;
  var s:string;
  var i:integer;
begin
  f.create; f1.create;
  if OpenDialog3.Execute then begin
    f.loadfromfile(opendialog3.FileName);
    if f.count>0 then begin
     for i:=1 to f.count do begin
       s:=f.getstring(i);
       if pos('<marker ',s)>0 then begin
         f1.add(getParam('esr',s)+';'+getParam('station_title',s)+';'+getParam('zone',s)+';'+getParam('zprice',s)+';'+getParam('zgroup',s));
         s:=ReplaceParam(s,'zone','0',false);
         s:=ReplaceParam(s,'zprice','0',false);
         s:=ReplaceParam(s,'zgroup','0',false);
         s:=StrReplace(s,' zone="0"','');
         s:=StrReplace(s,' zprice="0"','');
         s:=StrReplace(s,' zgroup="0"','');
         f.edit(i,s);
       end;
     end;
    end;
    f.savetofile(OpenDialog3.FileName);
    f1.savetofile(OpenDialog3.FileName+'.txt');
    showmessage('end!');
  end;
  f.free; f1.free;
end;

procedure TForm1.Button22Click(Sender: TObject);
  var f1,f2:AF_types.TStrings;
  var i:integer;
begin
 if OpenDialog3.Execute then begin
  f1.create; f2.create;
  f1.loadfromfile(OpenDialog3.FileName);
  for i:=f1.count downto 1 do begin
    f2.add(f1.getstring(i));
  end;
{   for i:=1 to f1.count do begin
     s:=f1.getstring(i);
     if pos('price="',s)>0 then begin
       s:=ReplaceParam(s,'price','0',true);
       if pos('etrain',s)>0 then f2.add(s);
       if checkbox20.Checked then begin
         s1:=getParam('station1',s);
         s2:=getParam('station2',s);
         s:=ReplaceParam(s,'station1',s2,true);
         s:=ReplaceParam(s,'station2',s1,true);
         if pos('etrain',s)>0 then f2.add(s);
       end;
     end
      else f2.add(s);
   end; }
  f2.savetofile(OpenDialog3.FileName);
  f1.free; f2.free;
  showmessage('end!');
 end;
end;

procedure TForm1.Button23Click(Sender: TObject);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
qq,X, Y, xx, yy, ws : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nc,tt,s:string;
sg:TStringGrid;
c,l,tl,tl1,tl2,l1,l2:AF_types.TStrings;
begin
c.create; l.create; tl.create; tl1.create; tl2.create; l1.create; l2.create;
if opendialog1.Execute then begin
XLApp.Connect;
sg:=StringGrid1;
NomFich := opendialog1.Files.Strings[0];
IIndex := 1;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
clearsg(stringgrid4);
stringgrid4.RowCount:=210;
stringgrid4.colcount:=1;
clearsg(stringgrid4);
qq:=0;
 for ws:=1 to WorkBk.Worksheets.Count do begin
  WorkSheet := WorkBk.Sheets[ws] as _WorkSheet;
  nc:=trim(ansilowercase(worksheet.Name));
  if ((pos('t_',nc)=1)and(length(nc)>2)) then begin
    clearsg(sg);
    WorkSheet.Activate(0);
    WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
    X := XLApp.ActiveCell.Row;
    Y := XLApp.ActiveCell.Column;
    sg.ColCount := Y;
    sg.RowCount := X;
    RangeMatrix := XLApp.Range['A1', XLApp.Cells.Item[X, Y]].Value2;
    clearsg(sg);
    if ((y>1)and(x>6)) then begin
      for yy:=1 to y do begin
       if validstr(trim(VarToStrDef(RangeMatrix[2,yy],''))) then begin
        tt:=ansilowercase(trim(VarToStrDef(RangeMatrix[2,yy],'')));
        if tt=' ' then tt:='spb_gorod';
        if tt=' ' then tt:='spb';
        if tt=' ' then tt:='novgorod';
        if tt=' ' then tt:='pskov';
        if tt=' ' then tt:='karelia';
        if tt=' ' then tt:='vologda';
        if tt=' ' then tt:='murmansk';
            if qq>=stringgrid4.ColCount then stringgrid4.ColCount:=qq+1;
            stringgrid4.cells[qq,0]:=tt;
            stringgrid4.cells[qq,1]:=copy(nc,3,length(nc)-2);
             for xx:=6 to x do begin
               stringgrid4.Cells[qq,xx-4]:=trim({VarToStrDef(RangeMatrix[xx,yy],'')+'|'+}VarToStrDef(RangeMatrix[xx,yy+1],''));
               if xx>210 then break;
             end;
            inc(qq);
       end;
      end;
    end;
    RangeMatrix:=Unassigned;
  end;
 end; //ws
 XLApp.Quit;
 XLApp.Disconnect;
 c.clear;
 for x:=0 to stringgrid4.RowCount-1 do begin
   s:='';
   for y:=0 to stringgrid4.ColCount-1 do begin
     s:=s+stringgrid4.cells[y,x]+';';
   end;
   c.add(s);
 end;
 c.savetofile(NomFich+'.ttable.csv');
 showmessage('end!');
end; //opendialog
c.free; l.free; tl.free; tl1.free; tl2.free; l1.free; l2.free;
end;

procedure TForm1.Button24Click(Sender: TObject);
 var i:integer;
 var e:extended;
 var f,f1,u:AF_Types.TStrings;
begin
{  f.create; f1.create; u.create;
  f.loadfromfile('C:\1\ \ \tariff\11');
  ParseCSVStrEx(@u,f.getstring(1),',');
  if u.count>0 then begin
   for i:=1 to u.count do begin
     f1.add('if a.'+u.getstring(i)+'>0 then r.'+u.getstring(i)+':=r.'+u.getstring(i)+'+a.'+u.getstring(i)+' else r.'+u.getstring(i)+':=0;');
   end;
  end;
  f1.savetofile('C:\1\ \ \tariff\11.1');
  f.free; f1.free; u.free; }
  e:=GetZoneTariff('TVER_KM1',152);
  showmessage(floattostr(e));
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  StringGrid1.Width:=form1.Width-34;
  stringgrid1.Height:=form1.Height-354;
end;

procedure TForm1.Button25Click(Sender: TObject);
  var tf1,tf2:textfile;
  var s:string;
  var x:AF_Types.TSTrings;
  var n:integer;
begin
  x.create;
{  x.add('1011');
  x.add('1013');
  x.add('1014');
  x.add('1015');
  x.add('1016');
  x.add('1018');
  x.add('1039');
  x.add('1041');
  x.add('1130');
  x.add('1150');
  x.add('1272'); }
  x.add('1025');
  if fileexists('C:\AF\\\etrain.xml') then begin
    AssignFile(tf1,'C:\AF\\\etrain.xml');
    AssignFile(tf2,'C:\AF\\\etrain1.xml');
    Reset(tf1);
    Rewrite(tf2);
    while not eof(tf1) do begin
      ReadLn(tf1,s);
      if pos('xprout',s)>0 then begin
        n:=x.SearchString(getParam('xprout',s));
        if n>0 then WriteLn(tf2,s);
      end
       else WriteLn(tf2,s);
    end;
    CloseFile(tf2);
    CloseFile(tf1);
  end;
  x.free;
  showmessage('end!');
end;

procedure TForm1.Button26Click(Sender: TObject);
begin
  showmessage(FloatToStr(GetZoneTariff('SAMARA',110)));
end;

procedure TForm1.Button27Click(Sender: TObject);
  var r:extended;
  var f1,f2:AF_Types.TStrings;
  var i:integer;
  var s:string;
begin
{ r:=170.5;
 setroundmode(rmNearest);
 r:=RoundToEx(r,0);
 showmessage(floattostr(r));}
 f1.create;
 f2.create;
 f1.loadfromfile('C:\AF\ 2019\\spb_022019main.xml');
 if f1.count>0 then begin
   for i:=1 to f1.count do begin
     s:=f1.getstring(i);
     if pos('station1="534"',s)<=0 then begin
      if pos('station2="534"',s)<=0 then begin
        f2.add(s);
      end;
     end;
   end;
 end;
 f2.savetofile('C:\AF\ 2019\\spb_022019main1.xml');
 f2.free;
 f1.free;
 showmessage('end!');
end;

procedure TForm1.Button28Click(Sender: TObject);
  var f,f1,f2:AF_Types.TSTrings;
  var i,n:integer;
  var s,s1:string;
begin
 if opendialog6.Execute then begin
   f.create; f1.create; f2.create;
   f1.add('<?xml version="1.0" encoding="Windows-1251"?>');
   f1.add('');
   f1.add('<channel type="tarif" version="1">');
   f2.add('<?xml version="1.0" encoding="Windows-1251"?>');
   f2.add('');
   f2.add('<channel type="tarif" version="1">');
   for i:=0 to opendialog6.Files.Count-1 do begin
    f.clear;
    f.loadfromfile(opendialog6.Files.Strings[i]);
    if f.count>0 then begin
      for n:=1 to f.count do begin
        s:=f.getstring(n);
        if pos('<tarif ',s)>0 then begin
          f1.add(s);
          s1:=getParam('type',s);
          if s1='etrain' then f2.add(s);
          if s1='express' then f2.add(s);
          if s1='last' then f2.add(s);
          if s1='krskles' then f2.add(s);
          if s1='city' then f2.add(s);
          if s1='ekb_sp1' then f2.add(s);
          if s1='ekb_sp2' then f2.add(s);
          if s1='ekb_sp3' then f2.add(s);
          if s1='udm_sp' then f2.add(s);
          if s1='rostov_sp1' then f2.add(s);
          if s1='rostov_sp2' then f2.add(s);
          if s1='mcd' then f2.add(s);
          if s1='arkhangelsk_sp1' then f2.add(s);
          if s1='ikt_sp1' then f2.add(s);
          if s1='ikt_sp2' then f2.add(s);
          if s1='ikt_sp3' then f2.add(s);
          if s1='ikt_sp4' then f2.add(s);
          if s1='ikt_sp5' then f2.add(s);
          if s1='kazan2' then f2.add(s);
          if s1='nnprio' then f2.add(s);
          if s1='nnmgor' then f2.add(s);
          if s1='ekbsh' then f2.add(s);
          if s1='sppk_sp' then f2.add(s);
        end;
      end;
    end;
   end;
   f1.add('</channel>');
   f2.add('</channel>');
   f1.savetofile(deleteslasheex(extractdirpath(opendialog6.Files.Strings[0]))+'\_all.xml');
   f2.savetofile(deleteslasheex(extractdirpath(opendialog6.Files.Strings[0]))+'\_etrain.xml');
   f.free; f1.free; f2.free;
   showmessage('end!');
 end;
end;

procedure TForm1.Button29Click(Sender: TObject);
  var f,f1:AF_Types.TStrings;
  var i,tt:integer;
  var s,t,p:string;
begin
  f.create; f1.create;
  f.loadfromfile('C:\projects\tariffs\piter_2022\etrain.xml');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<tarif ',s)>0 then begin
        p:=''; t:='';
        p:=getParam('type',s);
        t:=getParam('price',s);
        if ((p='1m')or(p='1mr')or(p='last1m')or(p='last1mr')) then begin
          tt:=strtointe(t);
          // if tt<=0 then showmessage('  :      : '+t);
          // if ((p='1m')or(p='last1m')) then tt:=0;
          // if ((p='1mr')or(p='last1mr')) then tt:=0;
          tt:=0;
          //s:=ReplaceParam(s,'price',inttostr(tt),false);
          s:=ReplaceParam(s,'type',p+'velo',false);
          //s:=ReplaceParam(s,'type','detsky',false);
          f1.add(s);
        end;
      end
       else f1.add(s);
    end;
  end;
  f1.add('');
  f1.savetofile('C:\projects\tariffs\piter_2022\etrain_velo.xml');
  f.free; f1.free;
  showmessage('end!');
end;

procedure TForm1.Button30Click(Sender: TObject);
  var f1,f2:AF_types.TStrings;
  var s,s1,s2:string;
  var i:integer;
begin
 if OpenDialog3.Execute then begin
  f1.create; f2.create;
  f1.loadfromfile(OpenDialog3.FileName);
   for i:=1 to f1.count do begin
     s:=f1.getstring(i);
     if pos('price="',s)>0 then begin
       if pos('type="etrain"',s)>0 then f2.add(s);
     end
      else f2.add(s);
   end;
  f2.savetofile(OpenDialog3.FileName+'.etrain');
  f1.free; f2.free;
  showmessage('end!');
 end;
end;

end.

