unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls, ExtCtrls, Buttons, OleServer, ExcelXP, AF_Proc, AF_Types, Math;

type
  TTarif = packed record
    price_km:real;
    price_km20:real;
    limit:integer;
    price_limit:real;
  end;
  TZOut = packed record
    price:real;
    legend:string[200];
  end;
  TForm1 = class(TForm)
    SpeedButton1: TSpeedButton;
    LabeledEdit1: TLabeledEdit;
    StringGrid1: TStringGrid;
    XLApp: TExcelApplication;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    StringGrid2: TStringGrid;
    OpenDialog2: TOpenDialog;
    Button1: TButton;
    Edit1: TEdit;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    SpeedButton2: TSpeedButton;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Button2: TButton;
    Edit2: TEdit;
    Button3: TButton;
    Button4: TButton;
    procedure SpeedButton1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  tf,tf1:TextFile;

implementation

{$R *.dfm}

function okr5(f:real):real;
 var n,p,k:real;
begin
  setroundmode(rmDown);
  n:=round(f/10);
  n:=n*10;
  p:=f-n;
  k:=0;
  if p<2.5 then k:=0;
  if p>=2.5 then k:=5;
  if p>=7.5 then k:=10;
  result:=n+k;
end;

procedure ClearSG(sg:TStringGrid);
  var c,r:integer;
begin
  for c:=0 to sg.colcount-1 do
    for r:=0 to sg.RowCount-1 do sg.cells[c,r]:='';
end;

procedure LoadFromXLS(fn:string; sg:TStringGrid);
var
WorkBk : _WorkBook;
WorkSheet : _WorkSheet;
X, Y, xx, yy : Integer;
IIndex : OleVariant;
RangeMatrix : Variant;
NomFich : WideString;
nf:string;
tf:double;
begin
with form1 do begin
NomFich := fn;
IIndex := 1;
XLApp.Connect;
XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,EmptyParam,EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,
EmptyParam,EmptyParam,0);
WorkBk := XLApp.WorkBooks.Item[IIndex];
WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
X := XLApp.ActiveCell.Row;
Y := XLApp.ActiveCell.Column;
sg.ColCount := Y;
sg.RowCount := X;

for xx:=1 to x do begin
  for yy:=1 to y do begin
    nf:=worksheet.cells.item[xx,yy].NumberFormat;
    if (nf=':')or(nf=':')or(nf='h:mm')or(nf='hh:mm;@')or(nf=':;@')or(nf=':;@')or(nf='h:mm;@')or(nf='hh:mm;@') then begin
       tf:=StrToFloatDef(VarToStr(worksheet.cells.item[xx,yy]),70);
       if tf=70 then sg.Cells[yy-1,xx-1]:=trim(VarToStrDef(worksheet.cells.item[xx,yy],''))
                else sg.Cells[yy-1,xx-1]:=trim(FormatDateTime('hh:nn',tf));
    end
     else sg.Cells[yy-1,xx-1]:=trim(VarToStrDef(worksheet.cells.item[xx,yy],''));
  end;
end;


XLApp.Quit;
XLApp.Disconnect;
RangeMatrix := Unassigned;
end;
end;

function CompareDirections(d1,d2:string):boolean;
  var res:boolean;
  var i:integer;
begin
  res:=false;
  if length(d1)>0 then begin
    for i:=1 to length(d1) do begin
      if pos(d1[i],d2)>0 then res:=true;
    end;
  end;
  result:=res;
end;


procedure Calc_SPB2010old;
  var tn,tp:AF_Types.TStrings;
  var i,n,m:integer;
  var km,t,km1,km2,r:real;
begin
with form1 do begin
  tn.create;
  tp.create;
    tn.add('spb');
    tn.add('spb_20');
    tn.add('novgorod');
    tn.add('novgorod_20');
    tp.add('1.50');
    tp.add('30');
    tp.add('1.90');
    tp.add('38');
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;

  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        km:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        if km<21 then begin
          t:=strtofloat(trim(tp.getstring(tn.SearchString(trim(stringgrid1.Cells[4,i])+'_20'))));
          stringgrid1.Cells[i+5,n]:='t_'+floattostr(t);
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t)+'" type="etrain" reverse="1" />');
        end
         else begin
           if trim(stringgrid1.Cells[4,i])=trim(stringgrid1.Cells[4,n]) then begin
             t:=strtofloat(trim(tp.getstring(tn.SearchString(trim(stringgrid1.Cells[4,i])))));
             stringgrid1.Cells[i+5,n]:='f_'+floattostr(km*t);
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(km*t)+'" type="etrain" reverse="1" />');
           end
            else begin
              km1:=0;
              for m:=i+1 to n do begin
                if ((stringgrid1.cells[4,m]=stringgrid1.Cells[4,n])and(stringgrid1.cells[4,m-1]=stringgrid1.Cells[4,i])and(CompareDirections(stringgrid1.cells[2,i],stringgrid1.cells[2,m]))) then begin
                   km1:=strtofloat(trim(stringgrid1.cells[3,m]));
                   break;
                end;
              end;
              if km1>0 then begin
               km2:=abs(km1-strtofloat(trim(stringgrid1.Cells[3,i])));
               t:=strtofloat(trim(tp.getstring(tn.SearchString(trim(stringgrid1.Cells[4,i])))));
               r:=km2*t;
               km2:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-km1);
               t:=strtofloat(trim(tp.getstring(tn.SearchString(trim(stringgrid1.Cells[4,n])))));
               r:=r+(km2*t);
               stringgrid1.Cells[i+5,n]:='f_'+floattostr(r);
               WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(r)+'" type="etrain" reverse="1" />');
              end;
            end;
         end;
      end;
    end;
  end;

  tp.free;
  tn.free;
end;
end;

function GetTarifInfofsp(ttype,tmode:string; var t:TTarif):boolean;
  var res:boolean;
begin
  res:=false;
  ttype:=AnsiUpperCase(trim(ttype));
  tmode:=AnsiUpperCase(trim(tmode));
  if ((ttype='SPB')or(ttype='SPB1')) then begin
    if tmode='ETRAIN' then begin
      t.limit:=14;
      t.price_km:=2;
      t.price_km20:=2;
      t.price_limit:=28;
      res:=true;
    end;
    if tmode='INTRAIN' then begin
      t.limit:=14;
      t.price_km:=2;
      t.price_km20:=4;
      t.price_limit:=28;
      res:=true;
    end;
    if tmode='1M' then begin
      t.limit:=20;
      t.price_km:=75;
      t.price_limit:=1268;
      res:=true;
    end;
    if tmode='1MR' then begin
      t.limit:=20;
      t.price_km:=63;
      t.price_limit:=1100;
      res:=true;
    end;
    if tmode='5D' then begin
      t.limit:=20;
      t.price_km:=15;
      t.price_limit:=268;
      res:=true;
    end;
    if tmode='10D' then begin
      t.limit:=20;
      t.price_km:=24;
      t.price_limit:=424;
      res:=true;
    end;
    if tmode='15D' then begin
      t.limit:=20;
      t.price_km:=36;
      t.price_limit:=632;
      res:=true;
    end;
    if tmode='20D' then begin
      t.limit:=20;
      t.price_km:=48;
      t.price_limit:=840;
      res:=true;
    end;
    if tmode='25D' then begin
      t.limit:=20;
      t.price_km:=60;
      t.price_limit:=1048;
      res:=true;
    end;
  end; //SPB

  if ttype='SPB_GOROD' then begin
    if tmode='ETRAIN' then begin
      t.limit:=20;
      t.price_km:=1.735; //1.735
      t.price_km20:=1.7;
      t.price_limit:=34; //34
      res:=true;
    end;
    if tmode='1M' then begin
      t.limit:=20;
      t.price_km:=75;
      t.price_limit:=1268;
      res:=true;
    end;
    if tmode='1MR' then begin
      t.limit:=20;
      t.price_km:=63;
      t.price_limit:=1100;
      res:=true;
    end;
    if tmode='5D' then begin
      t.limit:=20;
      t.price_km:=15;
      t.price_limit:=268;
      res:=true;
    end;
    if tmode='10D' then begin
      t.limit:=20;
      t.price_km:=24;
      t.price_limit:=424;
      res:=true;
    end;
    if tmode='15D' then begin
      t.limit:=20;
      t.price_km:=36;
      t.price_limit:=632;
      res:=true;
    end;
    if tmode='20D' then begin
      t.limit:=20;
      t.price_km:=48;
      t.price_limit:=840;
      res:=true;
    end;
    if tmode='25D' then begin
      t.limit:=20;
      t.price_km:=60;
      t.price_limit:=1048;
      res:=true;
    end;
  end; //SPB_GOROD

  if ttype='NOVGOROD' then begin
    if tmode='ETRAIN' then begin
      t.limit:=20;
      t.price_km:=2.28;
      t.price_limit:=45.6;  // c 1.08.2013
      res:=true;
    end;
    if tmode='1M' then begin
      t.limit:=20;
      t.price_km:=95;
      t.price_limit:=1668;
      res:=true;
    end;
    if tmode='1MR' then begin
      t.limit:=20;
      t.price_km:=79.75;
      t.price_limit:=1436;
      res:=true;
    end;
    if tmode='5D' then begin
      t.limit:=20;
      t.price_km:=19;
      t.price_limit:=348;
      res:=true;
    end;
    if tmode='10D' then begin
      t.limit:=20;
      t.price_km:=30.4;
      t.price_limit:=552;
      res:=true;
    end;
    if tmode='15D' then begin
      t.limit:=20;
      t.price_km:=45.6;
      t.price_limit:=824;
      res:=true;
    end;
    if tmode='20D' then begin
      t.limit:=20;
      t.price_km:=60.8;
      t.price_limit:=1096;
      res:=true;
    end;
    if tmode='25D' then begin
      t.limit:=20;
      t.price_km:=76;
      t.price_limit:=1368;
      res:=true;
    end;
  end; //NOVGOROD

  if ttype='MSK_GOROD' then begin
    if tmode='1M' then begin
      t.limit:=120;
      t.price_km:=0;
      t.price_limit:=1040;
      res:=true;
    end;
    if tmode='1MR' then begin
      t.limit:=120;
      t.price_km:=0;
      t.price_limit:=874;
      res:=true;
    end;
    if tmode='5D' then begin
      t.limit:=120;
      t.price_km:=0;
      t.price_limit:=245;
      res:=true;
    end;
    if tmode='10D' then begin
      t.limit:=120;
      t.price_km:=0;
      t.price_limit:=347;
      res:=true;
    end;
    if tmode='15D' then begin
      t.limit:=120;
      t.price_km:=0;
      t.price_limit:=520;
      res:=true;
    end;
    if tmode='20D' then begin
      t.limit:=120;
      t.price_km:=0;
      t.price_limit:=693;
      res:=true;
    end;
    if tmode='25D' then begin
      t.limit:=120;
      t.price_km:=0;
      t.price_limit:=867;
      res:=true;
    end;
  end; //MSK_GOROD

  if ttype='MSK' then begin
    if tmode='1M' then begin
      t.limit:=20;
      t.price_km:=66;
      t.price_limit:=825;
      res:=true;
    end;
    if tmode='1MR' then begin
      t.limit:=20;
      t.price_km:=55.43;
      t.price_limit:=693;
      res:=true;
    end;
    if tmode='5D' then begin
      t.limit:=20;
      t.price_km:=13.715;
      t.price_limit:=210;
      res:=true;
    end;
    if tmode='10D' then begin
      t.limit:=20;
      t.price_km:=22;
      t.price_limit:=275;
      res:=true;
    end;
    if tmode='15D' then begin
      t.limit:=20;
      t.price_km:=33;
      t.price_limit:=413;
      res:=true;
    end;
    if tmode='20D' then begin
      t.limit:=20;
      t.price_km:=44;
      t.price_limit:=550;
      res:=true;
    end;
    if tmode='25D' then begin
      t.limit:=20;
      t.price_km:=55;
      t.price_limit:=688;
      res:=true;
    end;
  end; //MSK

  if ttype='RYAZAN' then begin
    if tmode='1M' then begin
      t.limit:=20;
      t.price_km:=60;
      t.price_limit:=750;
      res:=true;
    end;
    if tmode='1MR' then begin
      t.limit:=20;
      t.price_km:=50.44;
      t.price_limit:=630;
      res:=true;
    end;
    if tmode='5D' then begin
      t.limit:=20;
      t.price_km:=13;
      t.price_limit:=150;
      res:=true;
    end;
    if tmode='10D' then begin
      t.limit:=20;
      t.price_km:=20;
      t.price_limit:=250;
      res:=true;
    end;
    if tmode='15D' then begin
      t.limit:=20;
      t.price_km:=30;
      t.price_limit:=375;
      res:=true;
    end;
    if tmode='20D' then begin
      t.limit:=20;
      t.price_km:=40;
      t.price_limit:=500;
      res:=true;
    end;
    if tmode='25D' then begin
      t.limit:=20;
      t.price_km:=50;
      t.price_limit:=625;
      res:=true;
    end;
  end; //RYAZAN

  if ((ttype='TULA')or(ttype='VLADIMIR')or(ttype='KALUGA')) then begin
    if tmode='1M' then begin
      t.limit:=20;
      t.price_km:=56;
      t.price_limit:=700;
      res:=true;
    end;
    if tmode='1MR' then begin
      t.limit:=20;
      t.price_km:=47.03;
      t.price_limit:=588;
      res:=true;
    end;
    if tmode='5D' then begin
      t.limit:=20;
      t.price_km:=9.33;
      t.price_limit:=117;
      res:=true;
    end;
    if tmode='10D' then begin
      t.limit:=20;
      t.price_km:=18.66;
      t.price_limit:=233;
      res:=true;
    end;
    if tmode='15D' then begin
      t.limit:=20;
      t.price_km:=28;
      t.price_limit:=350;
      res:=true;
    end;
    if tmode='20D' then begin
      t.limit:=20;
      t.price_km:=37.33;
      t.price_limit:=467;
      res:=true;
    end;
    if tmode='25D' then begin
      t.limit:=20;
      t.price_km:=46.66;
      t.price_limit:=583;
      res:=true;
    end;
  end; //TULA VLADIMIR KALUGA

  if ((ttype='SMOLENSK')or(ttype='OREL')or(ttype='KURSK')) then begin
    if tmode='1M' then begin
      t.limit:=20;
      t.price_km:=60;
      t.price_limit:=750;
      res:=true;
    end;
    if tmode='1MR' then begin
      t.limit:=20;
      t.price_km:=50.394;
      t.price_limit:=630;
      res:=true;
    end;
    if tmode='5D' then begin
      t.limit:=20;
      t.price_km:=10;
      t.price_limit:=125;
      res:=true;
    end;
    if tmode='10D' then begin
      t.limit:=20;
      t.price_km:=20;
      t.price_limit:=250;
      res:=true;
    end;
    if tmode='15D' then begin
      t.limit:=20;
      t.price_km:=30;
      t.price_limit:=375;
      res:=true;
    end;
    if tmode='20D' then begin
      t.limit:=20;
      t.price_km:=40;
      t.price_limit:=500;
      res:=true;
    end;
    if tmode='25D' then begin
      t.limit:=20;
      t.price_km:=50;
      t.price_limit:=625;
      res:=true;
    end;
  end; //SMOLENSK OREL KURSK

  result:=res;
end;

Function GetZoneTariff(ttype:string; zone:integer):real;
  var res:real;
begin
  ttype:=trim(ansiuppercase(ttype));
  res:=0;
  if ttype='NN' then begin
    case zone of
      0: res:=17;
      1: res:=17;
      2: res:=32;
      3: res:=44;
      4: res:=55;
      5: res:=66;
      6: res:=77;
      7: res:=88;
      8: res:=99;
      9: res:=109;
      10: res:=119;
      11: res:=129;
      12: res:=139;
      13: res:=149;
      14: res:=160;
      15: res:=171;
      16: res:=182;
      17: res:=193;
      18: res:=204;
      19: res:=215;
      20: res:=226;
      21: res:=237;
      22: res:=248;
      23: res:=259;
      24: res:=270;
    end;
  end;

  if ttype='VLADIMIR' then begin
    case zone of
      0: res:=30;
      1: res:=30;
      2: res:=32;
      3: res:=46;
      4: res:=60;
      5: res:=74;
      6: res:=88;
      7: res:=102;
      8: res:=116;
      9: res:=130;
      10: res:=144;
      11: res:=158;
      12: res:=170;
      13: res:=182;
      14: res:=194;
      15: res:=206;
      16: res:=216;
      17: res:=226;
      18: res:=236;
    end;
  end;

  if ((ttype='VYATKA')or(ttype='VYATKA1')or(ttype='VYATKA2')) then begin
    case zone of
      0: res:=12;
      1: res:=12;
      2: res:=24;
      3: res:=36;
      4: res:=46;
      5: res:=56;
      6: res:=66;
      7: res:=76;
      8: res:=86;
      9: res:=96;
      10: res:=106;
      11: res:=116;
      12: res:=126;
      13: res:=134;
      14: res:=142;
      15: res:=150;
      16: res:=158;
      17: res:=166;
      18: res:=174;
      19: res:=182;
      20: res:=190;
     end;
  end;

  if ((ttype='UDMURT')or(ttype='UDMURT1')or(ttype='UDMURT2')) then begin
    case zone of
      0: res:=21;
      1: res:=21;
      2: res:=42;
      3: res:=62;
      4: res:=82;
      5: res:=102;
      6: res:=122;
      7: res:=142;
      8: res:=162;
      9: res:=180;
      10: res:=198;
      11: res:=216;
      12: res:=234;
      13: res:=252;
      14: res:=269;
      15: res:=286;
      16: res:=303;
      17: res:=319;
      18: res:=335;
      19: res:=351;
      20: res:=367;
     end;
  end;

  if ttype='VL_GOROD' then begin
    res:=34;
  end;

  if ttype='UFA' then begin
    case zone of
      0: res:=12;
      1: res:=12;
      2: res:=24;
      3: res:=36;
      4: res:=44;
      5: res:=55;
      6: res:=66;
      7: res:=77;
      8: res:=88;
      9: res:=100;
      10: res:=110;
      11: res:=120;
      12: res:=130;
      13: res:=140;
      14: res:=150;
      15: res:=160;
      16: res:=170;
      17: res:=180;
      18: res:=190;
      19: res:=200;
      20: res:=210;
      21: res:=220;
      22: res:=230;
      23: res:=240;
      24: res:=250;
      25: res:=260;
      26: res:=270;
      27: res:=280;
      28: res:=290;
      29: res:=300;
      30: res:=310;
      31: res:=320;
      32: res:=330;
    end;
  end;

  if ttype='ORENBURG2' then begin
    case zone of
      0: res:=16;
      1: res:=16;
      2: res:=25;
      3: res:=34;
      4: res:=46;
      5: res:=57;
      6: res:=68;
      7: res:=80;
      8: res:=90;
      9: res:=100;
      10: res:=110;
      11: res:=120;
      12: res:=130;
      13: res:=140;
      14: res:=150;
      15: res:=160;
      16: res:=170;
      17: res:=180;
      18: res:=190;
      19: res:=200;
      20: res:=210;
      21: res:=220;
      22: res:=230;
      23: res:=240;
      24: res:=250;
      25: res:=260;
      26: res:=270;
      27: res:=280;
      28: res:=290;
      29: res:=300;
      30: res:=310;
      31: res:=320;
      32: res:=330;
    end;
  end;


  if ttype='CHELYABINSK' then begin
    case zone of
      0: res:=14;
      1: res:=14;
      2: res:=28;
      3: res:=42;
      4: res:=56;
      5: res:=70;
      6: res:=84;
      7: res:=98;
      8: res:=112;
      9: res:=126;
      10: res:=140;
    end;
  end;

  if ttype='BRYANSK' then begin
    if zone<=2 then res:=15
               else res:=(zone-1)*15;
  end;

  if ttype='KALUGA' then begin
    if zone<=1 then res:=14
               else res:=zone*14;
  end;

  if ttype='KURSK' then begin
    if zone<=1 then res:=15
               else res:=zone*15;
  end;

  if ttype='OREL' then begin
    if zone<=1 then res:=15
               else res:=zone*15;
  end;

  if ttype='SMOLENSK' then begin
    if zone<=2 then res:=15
               else res:=(zone-1)*15;
  end;

  if ttype='TATAR' then begin
    case zone of
      0: res:=16;
      1: res:=16;
      2: res:=16;
      3: res:=26;
      4: res:=36;
      5: res:=46;
      6: res:=56;
      7: res:=65;
      8: res:=74;
      9: res:=83;
      10: res:=92;
      11: res:=101;
      12: res:=110;
      13: res:=119;
      14: res:=128;
      15: res:=137;
      16: res:=146;
      17: res:=155;
      18: res:=164;
      19: res:=173;
      20: res:=182;
    end;
  end;

  if ttype='MARII' then begin
    case zone of
      0: res:=15.3;
      1: res:=15.3;
    end;
  end;

  if ttype='KIROV2' then begin
    case zone of
      0: res:=12;
      1: res:=12;
      2: res:=24;
      3: res:=36;
      4: res:=46;
    end;
  end;

  if ttype='CHUVASH' then begin
    if zone<=1 then res:=16
               else res:=zone*16;
  end;

  if ((ttype='KRASNOYARSK')or(ttype='KRASNOYARSK1')or(ttype='KRASNOYARSK2')or(ttype='KRASNOYARSK3')or(ttype='KRASNOYARSK4')) then begin
    case zone of
      0: res:=13;
      1: res:=13;
      2: res:=18;
      3: res:=23;
      4: res:=30;
      5: res:=34;
      6: res:=37;
      7: res:=43;
      8: res:=66;
      9: res:=73;
      10: res:=81;
      11: res:=86;
      12: res:=91;
      13: res:=96;
      14: res:=104;
      15: res:=138;
      16: res:=146;
      17: res:=153;
      18: res:=162;
      19: res:=170;
      20: res:=178;
    end;
  end;

  if ttype='EKATERINBURG' then begin
    if zone<6 then res:=20;
    if (zone in [6..15]) then res:=30;
    if (zone in [16..25]) then res:=40;
    if (zone in [26..35]) then res:=50;
    if (zone in [36..45]) then res:=60;
    if (zone in [46..55]) then res:=60;
    if (zone in [56..65]) then res:=70;
    if (zone in [66..75]) then res:=70;
    if (zone in [76..85]) then res:=80;
    if (zone in [86..95]) then res:=80;
    if (zone in [96..105]) then res:=100;
    if (zone in [106..115]) then res:=100;
    if (zone in [116..125]) then res:=100;
    if (zone in [126..135]) then res:=110;
    if (zone in [136..150]) then res:=110;
    if (zone in [151..165]) then res:=120;
    if zone>165 then res:=130;
  end;

  if ((ttype='TYMEN')or(ttype='TYMEN1')or(ttype='TYMEN2')) then begin
    if zone<6 then res:=22;
    if (zone in [6..15]) then res:=22;
    if (zone in [16..25]) then res:=32;
    if (zone in [26..35]) then res:=44;
    if (zone in [36..45]) then res:=44;
    if (zone in [46..55]) then res:=44;
    if (zone in [56..65]) then res:=56;
    if (zone in [66..75]) then res:=66;
    if (zone in [76..85]) then res:=66;
    if (zone in [86..95]) then res:=78;
    if (zone in [96..105]) then res:=78;
    if (zone in [106..115]) then res:=78;
    if (zone in [116..125]) then res:=78;
    if (zone in [126..135]) then res:=88;
    if (zone in [136..150]) then res:=100;
    if (zone in [151..180]) then res:=100;
    if zone>180 then res:=100;
  end;

  if ((ttype='PERM')or(ttype='PERM1')or(ttype='PERM2')) then begin
    if zone<6 then res:=22;
    if (zone in [6..15]) then res:=22;
    if (zone in [16..25]) then res:=30;
    if (zone in [26..35]) then res:=48;
    if (zone in [36..45]) then res:=56;
    if (zone in [46..55]) then res:=66;
    if (zone in [56..65]) then res:=76;
    if (zone in [66..75]) then res:=88;
    if (zone in [76..85]) then res:=96;
    if (zone in [86..95]) then res:=100;
    if (zone in [96..105]) then res:=110;
    if (zone in [106..115]) then res:=120;
    if (zone in [116..125]) then res:=130;
    if (zone in [126..135]) then res:=140;
    if (zone in [136..150]) then res:=150;
    if (zone in [151..165]) then res:=160;
    if (zone in [166..180]) then res:=180;
    if zone>165 then res:=190;
  end;

  result:=res;
end;

Function CalcMonoTarif_SPB2010(km1:real;type1,tarif,stat1,stat2:string):string;
  var t1:TTarif;
  var res:boolean;
  var s:string;
  var r:real;
begin
  res:=true;
  s:='';
  if not GetTarifInfo(type1,tarif,t1) then res:=false;
  if res then begin
    tarif:=AnsiLowerCase(trim(tarif));
    r:=t1.price_limit;
    km1:=km1-t1.limit;
    if km1>0 then r:=r+(km1*t1.price_km);
    s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+floattostr(r)+'" type="'+tarif+'" reverse="1" />';
  end;
  result:=s;
end;

Function vCalcMonoTarif_SPB2011(km1:real;type1,tarif:string;lim:boolean):real;
  var t1:TTarif;
  var res:boolean;
  var s:string;
  var r:real;
begin
  res:=true;
  r:=0;
  if not GetTarifInfo(type1,tarif,t1) then res:=false;
  if res then begin
    tarif:=AnsiLowerCase(trim(tarif));
    if lim then begin
      r:=t1.price_limit;
      km1:=km1-t1.limit;
        if km1>0 then r:=r+(km1*t1.price_km);
    end //lim
     else begin
      //     1.01.2013  .
      if ((AnsiLowerCase(type1)='spb_gorod')and(km1>t1.limit)) then begin
          r:=t1.price_limit;
          km1:=km1-t1.limit;
           if km1>0 then r:=r+(km1*t1.price_km);
      end
       else begin
         if ((AnsiLowerCase(type1)='spb_gorod')and(km1<=t1.limit)) then begin
           r:=km1*t1.price_km20;
         end
          else begin
             r:=km1*t1.price_km;
          end;
       end;
     end;
    s:=floattostr(r);
  end;
  result:=r;
end;



Function vCalcMonoTarif_SPB2013fsp(km1:real;type1,tarif:string;lim:boolean;obr:boolean):real;
  var t1:TTarif;
  var res:boolean;
  var s:string;
  var r:real;
begin
 res:=true;
 r:=0;
 if ((AnsiLowerCase(tarif)='intrain')and(AnsiLowerCase(type1)='spb')) then begin
if km1=1 then r:=33;
if km1=2 then r:=33;
if km1=3 then r:=33;
if km1=4 then r:=33;
if km1=5 then r:=33;
if km1=6 then r:=33;
if km1=7 then r:=33;
if km1=8 then r:=33;
if km1=9 then r:=33;
if km1=10 then r:=33;
if km1=11 then r:=33;
if km1=12 then r:=33;
if km1=13 then r:=33;
if km1=14 then r:=33;
if km1=15 then r:=35;
if km1=16 then r:=37;
if km1=17 then r:=40;
if km1=18 then r:=42;
if km1=19 then r:=44;
if km1=20 then r:=47;
if km1=21 then r:=49;
if km1=22 then r:=51;
if km1=23 then r:=54;
if km1=24 then r:=56;
if km1=25 then r:=59;
if km1=26 then r:=61;
if km1=27 then r:=63;
if km1=28 then r:=66;
if km1=29 then r:=68;
if km1=30 then r:=70;
if km1=31 then r:=73;
if km1=32 then r:=75;
if km1=33 then r:=77;
if km1=34 then r:=80;
if km1=35 then r:=82;
if km1=36 then r:=84;
if km1=37 then r:=87;
if km1=38 then r:=89;
if km1=39 then r:=92;
if km1=40 then r:=94;
if km1=41 then r:=96;
if km1=42 then r:=99;
if km1=43 then r:=101;
if km1=44 then r:=103;
if km1=45 then r:=106;
if km1=46 then r:=108;
if km1=47 then r:=110;
if km1=48 then r:=113;
if km1=49 then r:=115;
if km1=50 then r:=118;
if km1=51 then r:=120;
if km1=52 then r:=122;
if km1=53 then r:=125;
if km1=54 then r:=127;
if km1=55 then r:=129;
if km1=56 then r:=132;
if km1=57 then r:=134;
if km1=58 then r:=136;
if km1=59 then r:=139;
if km1=60 then r:=141;
if km1=61 then r:=143;
if km1=62 then r:=146;
if km1=63 then r:=148;
if km1=64 then r:=151;
if km1=65 then r:=153;
if km1=66 then r:=155;
if km1=67 then r:=158;
if km1=68 then r:=160;
if km1=69 then r:=162;
if km1=70 then r:=165;
if km1=71 then r:=167;
if km1=72 then r:=169;
if km1=73 then r:=172;
if km1=74 then r:=174;
if km1=75 then r:=177;
if km1=76 then r:=179;
if km1=77 then r:=181;
if km1=78 then r:=184;
if km1=79 then r:=186;
if km1=80 then r:=188;
if km1=81 then r:=191;
if km1=82 then r:=193;
if km1=83 then r:=195;
if km1=84 then r:=198;
if km1=85 then r:=200;
if km1=86 then r:=202;
if km1=87 then r:=205;
if km1=88 then r:=207;
if km1=89 then r:=210;
if km1=90 then r:=212;
if km1=91 then r:=214;
if km1=92 then r:=217;
if km1=93 then r:=219;
if km1=94 then r:=221;
if km1=95 then r:=224;
if km1=96 then r:=226;
if km1=97 then r:=228;
if km1=98 then r:=231;
if km1=99 then r:=233;
if km1=100 then r:=236;
if km1=101 then r:=238;
if km1=102 then r:=240;
if km1=103 then r:=243;
if km1=104 then r:=245;
if km1=105 then r:=247;
if km1=106 then r:=250;
if km1=107 then r:=252;
if km1=108 then r:=254;
if km1=109 then r:=257;
if km1=110 then r:=259;
if km1=111 then r:=261;
if km1=112 then r:=264;
if km1=113 then r:=266;
if km1=114 then r:=269;
if km1=115 then r:=271;
if km1=116 then r:=273;
if km1=117 then r:=276;
if km1=118 then r:=278;
if km1=119 then r:=280;
if km1=120 then r:=283;
if km1=121 then r:=285;
if km1=122 then r:=287;
if km1=123 then r:=290;
if km1=124 then r:=292;
if km1=125 then r:=295;
if km1=126 then r:=297;
if km1=127 then r:=299;
if km1=128 then r:=302;
if km1=129 then r:=304;
if km1=130 then r:=306;
if km1=131 then r:=309;
if km1=132 then r:=313;
if km1=133 then r:=313;
if km1=134 then r:=316;
if km1=135 then r:=318;
if km1=136 then r:=320;
if km1=137 then r:=323;
if km1=138 then r:=325;
if km1=139 then r:=328;
if km1=140 then r:=330;
if km1=141 then r:=332;
if km1=142 then r:=335;
if km1=143 then r:=337;
if km1=144 then r:=339;
if km1=145 then r:=342;
if km1=146 then r:=344;
if km1=147 then r:=346;
if km1=148 then r:=349;
if km1=149 then r:=351;
if km1=150 then r:=354;
if km1=151 then r:=356;
if km1=152 then r:=358;
if km1=153 then r:=361;
if km1=154 then r:=363;
if km1=155 then r:=365;
if km1=156 then r:=268;
if km1=157 then r:=370;
if km1=158 then r:=372;
if km1=159 then r:=375;
if km1=160 then r:=377;
if km1=161 then r:=379;
if km1=162 then r:=382;
if km1=163 then r:=384;
if km1=164 then r:=387;
if km1=165 then r:=389;
if km1=166 then r:=391;
if km1=167 then r:=394;
if km1=168 then r:=396;
if km1=169 then r:=398;
if km1=170 then r:=401;
if km1=171 then r:=403;
if km1=172 then r:=405;
if km1=173 then r:=408;
if km1=174 then r:=410;
if km1=175 then r:=413;
if km1=176 then r:=415;
if km1=177 then r:=417;
if km1=178 then r:=420;
if km1=179 then r:=422;
if km1=180 then r:=424;
if km1=181 then r:=427;
if km1=182 then r:=429;
if km1=183 then r:=431;
if km1=184 then r:=434;
if km1=185 then r:=436;
if km1=186 then r:=438;
if km1=187 then r:=441;
if km1=188 then r:=443;
if km1=189 then r:=446;
if km1=190 then r:=448;
if km1=191 then r:=450;
if km1=192 then r:=453;
if km1=193 then r:=455;
if km1=194 then r:=457;
if km1=195 then r:=460;
if km1=196 then r:=462;
if km1=197 then r:=464;
if km1=198 then r:=467;
if km1=199 then r:=469;
if km1=200 then r:=472;
 end
 else begin
  tarif:='ETRAIN';
  if not GetTarifInfo(type1,tarif,t1) then res:=false;
  if res then begin
    tarif:=AnsiLowerCase(trim(tarif));
    if lim then begin
     if km1<=t1.limit then begin
      r:=t1.price_limit;
      km1:=km1-t1.limit;
        if km1>0 then r:=r+(km1*t1.price_km);
     end
      else begin
        if ((AnsiLowerCase(type1)='spb')and(km1>16)and(km1<21)) then begin
             r:=km1*t1.price_km20;
        end
         else begin
          r:=t1.price_limit;
          km1:=km1-t1.limit;
            if km1>0 then r:=r+(km1*t1.price_km);
         end;
      end;
    end //lim
     else begin
      if ((AnsiLowerCase(type1)='spb_gorod')and(km1>t1.limit)) then begin
         if obr then begin
            setroundmode(rmNearest);
            r:=round(km1*1.73);
         end
          else begin
            r:=t1.price_limit;
            km1:=km1-t1.limit;
             if km1>0 then r:=r+(km1*t1.price_km);
          end;
      end
       else begin
         if ((AnsiLowerCase(type1)='spb_gorod')and(km1<=t1.limit)) then begin
           r:=km1*t1.price_km20;
         end
          else begin
            if ((AnsiLowerCase(type1)='spb')and(km1<=20)) then begin
             r:=km1*t1.price_km;
            end
             else r:=km1*t1.price_km;
          end;
       end;
     end;
    s:=floattostr(r);
  end;
 end;
 result:=r;
end;


Function vCalcMonoTarif_SPB092011(km1:real;type1,tarif:string;lim:boolean):real;
  var t1:TTarif;
  var res:boolean;
  var s:string;
  var r:real;
begin
  //   1  2011
  res:=true;
  r:=0;
  if not GetTarifInfo(type1,tarif,t1) then res:=false;
  if res then begin
    if type1='spb' then begin
      r:=30;
      if km1>20 then r:=32;
      if km1>25 then r:=40;
      if km1>30 then r:=48;
      if km1>35 then r:=56;
      if km1>40 then r:=64;
      if km1>45 then r:=72;
      if km1>50 then r:=80;
      if km1>60 then r:=96;
      if km1>70 then r:=110;
      if km1>80 then r:=126;
      if km1>90 then r:=140;
      if km1>100 then r:=150;
      if km1>110 then r:=160;
      if km1>120 then r:=170;
      if km1>130 then r:=180;
      if km1>140 then r:=190;
      if km1>150 then r:=200;
    end
    else begin
    if type1='spb1' then begin
      r:=30;
      if km1>20 then r:=32;
      if km1>25 then r:=40;
      if km1>30 then r:=48;
      if km1>35 then r:=56;
      if km1>40 then r:=64;
      if km1>45 then r:=72;
      if km1>50 then r:=80;
      if km1>60 then r:=96;
      if km1>70 then r:=110;
      if km1>80 then r:=126;
      if km1>90 then r:=140;
      if km1>100 then r:=150;
      if km1>110 then r:=160;
      if km1>120 then r:=170;
      if km1>130 then r:=180;
      if km1>140 then r:=190;
      if km1>150 then r:=200;
    end
    else begin
    if type1='spb2' then begin
      r:=30;
      if km1>20 then r:=32;
      if km1>25 then r:=40;
      if km1>30 then r:=48;
      if km1>35 then r:=56;
      if km1>40 then r:=64;
      if km1>45 then r:=72;
      if km1>50 then r:=80;
      if km1>60 then r:=96;
      if km1>70 then r:=110;
      if km1>80 then r:=126;
      if km1>90 then r:=140;
      if km1>100 then r:=150;
      if km1>110 then r:=160;
      if km1>120 then r:=170;
      if km1>130 then r:=180;
      if km1>140 then r:=190;
      if km1>150 then r:=200;
    end
    else begin
          tarif:=AnsiLowerCase(trim(tarif));
          r:=0;
          if lim then begin
          r:=t1.price_limit;
          km1:=km1-t1.limit;
           if km1>0 then r:=r+(km1*t1.price_km);
          end
           else r:=km1*t1.price_km;
    end;
    end;
    end;
    s:=floattostr(r);
  end;
  result:=r;
end;



Function CalcDualTarif_SPB2010(km1,km2:real;type1,type2,tarif,stat1,stat2:string):string;
  var t1,t2:TTarif;
  var res:boolean;
  var s:string;
  var r:real;
begin
  res:=true;
  s:='';
  if not GetTarifInfo(type1,tarif,t1) then res:=false;
  if not GetTarifInfo(type2,tarif,t2) then res:=false;
  if res then begin
    tarif:=AnsiLowerCase(trim(tarif));
    r:=t1.price_limit+t2.price_limit;
    km1:=km1-t1.limit;
    km2:=km2-t2.limit;
    if km1>0 then r:=r+(km1*t1.price_km);
    if km2>0 then r:=r+(km2*t2.price_km);
    s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+floattostr(r)+'" type="'+tarif+'" reverse="1" />';
  end;
  result:=s;
end;

Function Calc5D(km1:real;type1:string):real;
 var r:real;
begin
 r:=0;
 type1:=ansiuppercase(trim(type1));
 if type1='MSK_GOROD' then r:=245;
 if type1='MSK' then begin
        if km1<21 then r:=210;
        if round(km1) in [21..30] then r:=320+(1.15*(km1-21));
        if round(km1) in [31..40] then r:=480+(1.65*(km1-31));
        if round(km1) in [41..50] then r:=640+(2.24*(km1-41));
        if round(km1) in [51..60] then r:=701+(11*(km1-51));
        if round(km1) in [61..70] then r:=842+(13.1*(km1-61));
        if round(km1) in [71..80] then r:=982+(15.3*(km1-71));
        if round(km1) in [81..88] then r:=1122+(17.6*(km1-81));
        if round(km1) in [89..90] then r:=1250;
        if round(km1) in [91..100] then r:=1262;
        if round(km1) in [101..110] then r:=1403;
        if round(km1) in [111..120] then r:=1543;
        if round(km1) in [121..130] then r:=1683;
        if round(km1) in [131..140] then r:=1823;
        if round(km1) in [141..150] then r:=1964;
        if round(km1) in [151..160] then r:=2104;
        if round(km1) in [161..170] then r:=2244;
        if round(km1) in [171..180] then r:=2384;
        if round(km1) in [181..190] then r:=2525;
        if round(km1) in [191..200] then r:=2665;
        if round(km1) in [201..210] then r:=2805;
        if round(km1) in [211..220] then r:=2945;
        if round(km1) in [221..230] then r:=3085;
        if round(km1) in [231..240] then r:=3225;
        if km1>240  then r:=3365;
 end;
 if type1='RYAZAN' then begin
{        if km1<21 then r:=150
         else r:=km1*12.3;}
        if km1<21 then r:=150;
        if round(km1) in [21..30] then r:=291+(1.1*(km1-21));
        if round(km1) in [31..40] then r:=437+(1.5*(km1-31));
        if round(km1) in [41..50] then r:=582+(2.1*(km1-41));
        if round(km1) in [51..60] then r:=638+(10.1*(km1-51));
        if round(km1) in [61..70] then r:=765+(12.1*(km1-61));
        if round(km1) in [71..80] then r:=893+(14.1*(km1-71));
        if round(km1) in [81..88] then r:=1020+(16.1*(km1-81));
        if round(km1) in [89..90] then r:=1136;
        if round(km1) in [91..100] then r:=1148;
        if round(km1) in [101..110] then r:=1275;
        if round(km1) in [111..120] then r:=1403;
        if round(km1) in [121..130] then r:=1530;
        if round(km1) in [131..140] then r:=1658;
        if round(km1) in [141..150] then r:=1785;
        if round(km1) in [151..160] then r:=1913;
        if round(km1) in [161..170] then r:=2040;
        if round(km1) in [171..180] then r:=2168;
        if round(km1) in [181..190] then r:=2295;
        if round(km1) in [191..200] then r:=2423;
        if round(km1) in [201..210] then r:=2550;
        if round(km1) in [211..220] then r:=2678;
        if round(km1) in [221..230] then r:=2805;
        if round(km1) in [231..240] then r:=2933;
        if km1>240  then r:=3060;
 end;
 if ((type1='TULA')or(type1='VLADIMIR')or(type1='KALUGA')) then begin
{        if km1<21 then r:=140
         else r:=km1*11.8;}
        if km1<21 then r:=140;
        if round(km1) in [21..30] then r:=272+(1*(km1-21));
        if round(km1) in [31..40] then r:=407+(1.6*(km1-31));
        if round(km1) in [41..50] then r:=543+(2*(km1-41));
        if round(km1) in [51..60] then r:=595+(9.38*(km1-51));
        if round(km1) in [61..70] then r:=714+(11.3*(km1-61));
        if round(km1) in [71..80] then r:=833+(13.1*(km1-71));
        if round(km1) in [81..88] then r:=952+(15.1*(km1-81));
        if round(km1) in [89..90] then r:=1060;
        if round(km1) in [91..100] then r:=1071;
        if round(km1) in [101..110] then r:=1190;
        if round(km1) in [111..120] then r:=1309;
        if round(km1) in [121..130] then r:=1428;
        if round(km1) in [131..140] then r:=1547;
        if round(km1) in [141..150] then r:=1666;
        if round(km1) in [151..160] then r:=1785;
        if round(km1) in [161..170] then r:=1904;
        if round(km1) in [171..180] then r:=2023;
        if round(km1) in [181..190] then r:=2142;
        if round(km1) in [191..200] then r:=2261;
        if round(km1) in [201..210] then r:=2380;
        if round(km1) in [211..220] then r:=2499;
        if round(km1) in [221..230] then r:=2618;
        if round(km1) in [231..240] then r:=2737;
        if km1>240  then r:=2856;
 end;
 if ((type1='SMOLENSK')or(type1='OREL')or(type1='KURSK')) then begin
        if km1<21 then r:=140
         else r:=km1*11.8;
 end;
 result:=r;
end;

Function CalcMonoTarif_MSK2010(km1:real;type1,tarif,stat1,stat2:string):string;
  var t1:TTarif;
  var res:boolean;
  var s:string;
  var r:real;
begin
  if ansilowercase(trim(tarif))='5d' then setroundmode(rmNearest)
                                     else setroundmode(rmUp);
  res:=true;
  s:='';
  r:=0;
  if not GetTarifInfo(type1,tarif,t1) then res:=false;
  if res then begin
   if ansilowercase(trim(tarif))='5d' then begin
     r:=Calc5D(km1,type1);
   end
   else begin
    tarif:=AnsiLowerCase(trim(tarif));
    if km1>t1.limit then r:=(km1*t1.price_km)
                    else r:=t1.price_limit;
   end;
   if r>0 then s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r))+'" type="'+tarif+'" reverse="1" />';
  end;
  result:=s;
end;

Function CalcDualTarif_MSK2010(km1,km2:real;type1,type2,tarif,stat1,stat2:string):string;
  var t1,t2:TTarif;
  var res:boolean;
  var s:string;
  var r:real;
begin
  if tarif='5D' then setroundmode(rmNearest)
                else setroundmode(rmUp);
  res:=true;
  s:='';
  r:=0;
  if not GetTarifInfo(type1,tarif,t1) then res:=false;
  if not GetTarifInfo(type2,tarif,t2) then res:=false;
  if res then begin
    tarif:=AnsiLowerCase(trim(tarif));
    if ansilowercase(trim(tarif))='5d' then begin
      r:=Calc5D(km1,type1);
      r:=r+Calc5D(km2,type2);
    end
    else begin
      if km1>t1.limit then r:=(km1*t1.price_km)
                      else r:=t1.price_limit;
      if km2>t2.limit then r:=r+(km2*t2.price_km)
                      else r:=r+t2.price_limit;
    end;
    if r>0 then s:='  <tarif station1="'+stat1+'" station2="'+stat2+'" price="'+inttostr(round(r))+'" type="'+tarif+'" reverse="1" />';
  end;
  result:=s;
end;





procedure Calc_SPB2010;
  var i,n,m:integer;
  var km,t,km0,km1,km2,r,qq1,qq2,qq0:real;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        km:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        if km<21 then begin
          if checkbox1.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'ETRAIN',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
        end
         else begin
           if trim(stringgrid1.Cells[4,i])=trim(stringgrid1.Cells[4,n]) then begin
              if checkbox1.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'ETRAIN',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_SPB2010(km,stringgrid1.Cells[4,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
           end
            else begin
              km0:=0;
              for m:=i+1 to n do begin
                if ((stringgrid1.cells[4,m]=stringgrid1.Cells[4,n])and(stringgrid1.cells[4,m-1]=stringgrid1.Cells[4,i])and(CompareDirections(stringgrid1.cells[2,i],stringgrid1.cells[2,m]))) then begin
                   km0:=strtofloat(trim(stringgrid1.cells[3,m]));
                   break;
                end;
              end;
              if km0>0 then begin
               km1:=abs(km0-strtofloat(trim(stringgrid1.Cells[3,i])));
               km2:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-km0);
               if checkbox1.Checked then WriteLn(tf,CalcDualTarif_SPB2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'ETRAIN',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox2.Checked then WriteLn(tf,CalcDualTarif_SPB2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox3.Checked then WriteLn(tf,CalcDualTarif_SPB2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox4.Checked then WriteLn(tf,CalcDualTarif_SPB2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox5.Checked then WriteLn(tf,CalcDualTarif_SPB2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox6.Checked then WriteLn(tf,CalcDualTarif_SPB2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox7.Checked then WriteLn(tf,CalcDualTarif_SPB2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox8.Checked then WriteLn(tf,CalcDualTarif_SPB2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              end;
            end;
         end;
      end;
    end;
  end;
end;
end;


procedure Calc_SPB2011beta;
  var i:integer;
begin
with form1 do begin
  combobox1.items.clear;
  combobox2.items.clear;
  for i:=0 to stringgrid1.RowCount-1 do begin
    combobox1.Items.Add(stringgrid1.cells[1,i]);
    combobox2.Items.Add(stringgrid1.cells[1,i]);
  end;
end;
end;

procedure Calc_SPB2011;
  var i,n,m,x,z,km,kmz:integer;
  var rt,ro:real;
  var kmt,kmt0:string;
  var lim:boolean;
  var trn,trkm,log:AF_Types.TStrings;
begin
with form1 do begin
  trn.create; trkm.create; log.create;
  for m:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,m]:=trim(ansilowercase(stringgrid1.Cells[4,m]));
    stringgrid1.Cells[5,m]:=trim(ansilowercase(stringgrid1.Cells[5,m]));
  end;
   for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        kmz:=strtointe(stringgrid1.Cells[3,i]);
        kmt:='###';
        kmt0:='###';
        trn.clear;
        trkm.clear;
        rt:=0;
        ro:=0;
        lim:=true;
        for x:=i to n do begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,i]) then begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,n]) then begin
            if stringgrid1.Cells[4,x]<>kmt then begin
              if kmt='###' then begin
                kmt:=stringgrid1.Cells[4,x];
                kmz:=strtointe(stringgrid1.Cells[3,x]);
              end
               else begin
                 km:=strtointe(stringgrid1.Cells[3,x-1])-kmz;
                 trn.add(kmt);
                 trkm.add(inttostr(km));
                 kmz:=strtointe(stringgrid1.Cells[3,x-1]);
                 kmt0:=kmt;
                 kmt:=stringgrid1.Cells[4,x];
               end;
            end
          end;
          end;
        end;
        if kmt<>'###' then begin
          km:=strtointe(stringgrid1.Cells[3,n])-kmz;
          trn.add(kmt);
          trkm.add(inttostr(km));
        end;
        if trn.count>0 then begin
          lim:=true;
          rt:=0;
          ro:=0;
          log.add('');
          log.add(stringgrid1.Cells[1,i]+' - '+stringgrid1.Cells[1,n]);
          for x:=1 to trn.count do begin
            rt:=rt+vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
            lim:=false;
          end;
          lim:=true;
          for x:=trn.count downto 1 do begin
            if ansilowercase(trn.getstring(x))='spb' then
              if x>1 then lim:=false;
            ro:=ro+vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
            lim:=false;
          end;
        end;
        SetRoundMode(rmNearest);
        rt:=round(rt*10) / 10;
        ro:=round(ro*10) / 10;
        if checkbox1.checked then begin
         if ((stringgrid1.Cells[0,i]<>'0')and(stringgrid1.Cells[0,n]<>'0')) then begin
          WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt));
          WriteLn(tf1,stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro));
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt)+'" type="etrain" reverse="0" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro)+'" type="etrain" reverse="0" />');
         end;
        end;
      end;
    end;
  end;
//  log.savetofile('c:\46\1.1');
  trn.free; trkm.free; log.free;
end;
end;















function findNovgorodfsp(ps: AF_Types.PStrings):boolean;
begin
 if ps.searchstring('novgorod')>0 then result:=true
                                  else result:=false;
end;


procedure Calc_SPB092011;
  var i,n,m,x,z,km,kmz,prevkm,nkm,xx:integer;
  var rt,ro,rt1,ro1,rtx:real;
  var kmt,kmt0,s,s1:string;
  var lim:boolean;
  var trn,trkm,trn1,trkm1,log:AF_Types.TStrings;
begin
with form1 do begin
  trn.create; trkm.create; trn1.create; trkm1.create; log.create;
  for m:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,m]:=trim(ansilowercase(stringgrid1.Cells[4,m]));
    stringgrid1.Cells[5,m]:=trim(ansilowercase(stringgrid1.Cells[5,m]));
  end;

  if stringgrid1.colcount<11 then stringgrid1.colcount:=11;

   for i:=1 to stringgrid1.rowcount-1 do begin
    if length(trim(stringgrid1.Cells[10,i]))<1 then stringgrid1.Cells[10,i]:=stringgrid1.Cells[4,i]+trim(stringgrid1.Cells[6,i]);
    if stringgrid1.Cells[10,i]='spb_gorod' then stringgrid1.Cells[10,i]:='spb';
   end;

   for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        kmz:=strtointe(stringgrid1.Cells[3,i]);
        kmt:='###';
        kmt0:='###';
        trn.clear;
        trkm.clear;
        rt:=0;
        ro:=0;
        lim:=true;
        for x:=i to n do begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,i]) then begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,n]) then begin
            if stringgrid1.Cells[4,x]<>kmt then begin
              if kmt='###' then begin
                kmt:=stringgrid1.Cells[4,x];
                kmz:=strtointe(stringgrid1.Cells[3,x]);
              end
               else begin
                 km:=strtointe(stringgrid1.Cells[3,x-1])-kmz;
                 if km>0 then begin
                 trn.add(kmt);
                 trkm.add(inttostr(km));
                 end;
                 kmz:=strtointe(stringgrid1.Cells[3,x-1]);
                 kmt0:=kmt;
                 kmt:=stringgrid1.Cells[4,x];
               end;
            end
          end;
          end;
        end;
        if kmt<>'###' then begin
          km:=strtointe(stringgrid1.Cells[3,n])-kmz;
          if km>0 then begin
          trn.add(kmt);
          trkm.add(inttostr(km));
          end;
        end;
        trn1.clear;
        trkm1.clear;
        kmz:=strtointe(stringgrid1.Cells[3,i]);
        kmt:='###';
        kmt0:='###';
        km:=0;
        prevkm:=0;
        nkm:=0;
        lim:=true;
        rt1:=0;
        ro1:=0;
        xx:=0;
        for x:=i to n do begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,i]) then begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,n]) then begin
            inc(xx);
            if stringgrid1.Cells[10,x]<>kmt then begin
              if xx=2 then kmt:=stringgrid1.Cells[10,x];
            end;
            if stringgrid1.Cells[10,x]<>kmt then begin
              if kmt='###' then begin
                kmt:=stringgrid1.Cells[10,x];
                nkm:=strtointe(stringgrid1.Cells[3,x]);
              end
               else begin
                 km:=strtointe(stringgrid1.Cells[3,x])-nkm;
                 if km>0 then begin
                   trn1.add(kmt);
                   trkm1.add(inttostr(km));
                   nkm:=strtointe(stringgrid1.Cells[3,x]);
                 end;
                 kmt0:=kmt;
                 kmt:=stringgrid1.Cells[10,x];
               end;
            end
          end;
          end;
        end;
        if kmt<>'###' then begin
          km:=strtointe(stringgrid1.Cells[3,n])-nkm;
          if km>0 then begin
          trn1.add(kmt);
          trkm1.add(inttostr(km));
          end;
        end;



/////   
        if trn.count>0 then begin
          if trn.count=1 then lim:=true
                         else lim:=false;
          rt:=0;
          ro:=0;
          log.add('');
          log.add(stringgrid1.Cells[1,i]+' - '+stringgrid1.Cells[1,n]);
          s:='';
          for x:=1 to trn.count do begin
            s:=s+trkm.getstring(x)+' ';
// !!!!! 09.01.2013 ///       if ((trn.count>1)and(trn.getstring(x)='spb_gorod')) then lim:=true;
            rtx:=vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            lim:=false;
              //  01.01.2013
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
                rt:=round(rt*10) / 10;
                SetRoundMode(rmNearest);
                rt:=round(rt);
              end;
            rt:=rt+rtx;
            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
          end;
 {         for x:=trn.count downto 1 do begin
            ro:=ro+vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
          end; }
        SetRoundMode(rmNearest);
        rt:=round(rt*10) / 10;
//        ro:=round(ro*10) / 10;

         if not findNovgorodfsp(@trn) then begin
//           SetRoundMode(rmTruncate);
           SetRoundMode(rmNearest);
           rt:=round(rt);
//           ro:=round(ro);
         end;

        end;
///// -  

{
/////  
        if trn1.count>0 then begin
          lim:=false;
          if ((trn1.count=1) and (trn1.getstring(1)='novgorod')) then lim:=true;
          rt1:=0;
          ro1:=0;
          log.add('');
          log.add(stringgrid1.Cells[1,i]+' - '+stringgrid1.Cells[1,n]);
//          s:='';
          for x:=1 to trn1.count do begin
//            s:=s+trkm1.getstring(x)+' ';
            rt1:=rt1+vCalcMonoTarif_SPB092011(strtointe(trkm1.getstring(x)),trn1.getstring(x),'ETRAIN',lim);
            log.add(' : '+trn1.getstring(x)+' '+trkm1.getstring(x));
          end;
          for x:=trn1.count downto 1 do begin
            ro1:=ro1+vCalcMonoTarif_SPB092011(strtointe(trkm1.getstring(x)),trn1.getstring(x),'ETRAIN',lim);
            log.add(' : '+trn1.getstring(x)+' '+trkm1.getstring(x));
          end;
        SetRoundMode(rmNearest);
        rt1:=round(rt1*10) / 10;
        ro1:=round(ro1*10) / 10;
         if not findNovgorod(@trn) then begin
           SetRoundMode(rmTruncate);
           rt1:=round(rt1);
           ro1:=round(ro1);
         end;
        end;
///// - 
}


        if checkbox1.checked then begin
         if ((stringgrid1.Cells[0,i]<>'0')and(stringgrid1.Cells[0,n]<>'0')) then begin
          if rt>0 then begin
           if ((rt<=32)and(trn.count>1)) then begin
            s1:='32';
            if trn.searchstring('spb_gorod')>0 then s1:='34';
            WriteLn(tf1,'simple;'+stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+s1+' ('+inttostr(trn.count)+') '+s);
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+s1+'" type="etrain" reverse="1" />');
           end
            else begin
             WriteLn(tf1,'tariff;'+stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt)+' ('+inttostr(trn.count)+') '+s);
//             WriteLn(tf1,'sale;'+stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt1)+' ('+inttostr(trn1.count)+') '+s);
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt)+'" type="etrain" reverse="1" />');
//             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt1)+'" type="etrain" reverse="0" />');
            end;
          end;
{
          if ro>0 then begin
           if ((ro<32)and(trn.count>1)) then begin
//            s1:=32;
//            if trn.getstring(i)='spb_gorod' then s1:=34;
//            if trn.getstring(i)='novgorod' then s1:=38;
             WriteLn(tf1,'simple;'+stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(32)+' ('+inttostr(trn.count)+') '+s);
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="32" type="etrain" reverse="0" />');
           end
            else begin
             WriteLn(tf1,'intrain;'+stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro)+' ('+inttostr(trn.count)+') '+s);
//             WriteLn(tf1,'sale;'+stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro1)+' ('+inttostr(trn1.count)+') '+s);
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro)+'" type="etrain" reverse="0" />');
//             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro1)+'" type="etrain" reverse="0" />');
            end;
          end;
}
         end;
        end;



      end;
    end;
  end;







  log.savetofile('C:\AF\\\1.1');
  trn.free; trkm.free; trn1.free; trkm1.free; log.free;
end;
end;














procedure Calc_SPB2013fsp;
  var i,n,m,x,z,km,kmz,prevkm,nkm,xx,kmm:integer;
  var rt,ro,rt1,ro1,rt9,ro9,rtx,rtin,roin:real;
  var kmt,kmt0,s,s1,s2:string;
  var lim:boolean;
  var trn,trkm,trn1,trkm1,log:AF_Types.TStrings;
begin
with form1 do begin
  trn.create; trkm.create; trn1.create; trkm1.create; log.create;
  for m:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,m]:=trim(ansilowercase(stringgrid1.Cells[4,m]));
    stringgrid1.Cells[5,m]:=trim(ansilowercase(stringgrid1.Cells[5,m]));
  end;

  if stringgrid1.colcount<11 then stringgrid1.colcount:=11;

   for i:=1 to stringgrid1.rowcount-1 do begin
    if length(trim(stringgrid1.Cells[10,i]))<1 then stringgrid1.Cells[10,i]:=stringgrid1.Cells[4,i]+trim(stringgrid1.Cells[6,i]);
    if stringgrid1.Cells[10,i]='spb_gorod' then stringgrid1.Cells[10,i]:='spb';
   end;

   for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        kmz:=strtointe(stringgrid1.Cells[3,i]);
        kmt:='###';
        kmt0:='###';
        trn.clear;
        trkm.clear;
        rt:=0;
        ro:=0;
        rtin:=0;
        roin:=0;
        lim:=true;
        for x:=i to n do begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,i]) then begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,n]) then begin
            if stringgrid1.Cells[4,x]<>kmt then begin
              if kmt='###' then begin
                kmt:=stringgrid1.Cells[4,x];
                kmz:=strtointe(stringgrid1.Cells[3,x]);
              end
               else begin
                 km:=strtointe(stringgrid1.Cells[3,x-1])-kmz;
                 if km>0 then begin
                 trn.add(kmt);
                 trkm.add(inttostr(km));
                 end;
                 kmz:=strtointe(stringgrid1.Cells[3,x-1]);
                 kmt0:=kmt;
                 kmt:=stringgrid1.Cells[4,x];
               end;
            end
          end;
          end;
        end;
        if kmt<>'###' then begin
          km:=strtointe(stringgrid1.Cells[3,n])-kmz;
          if km>0 then begin
          trn.add(kmt);
          trkm.add(inttostr(km));
          end;
        end;
        trn1.clear;
        trkm1.clear;
        kmz:=strtointe(stringgrid1.Cells[3,i]);
        kmt:='###';
        kmt0:='###';
        km:=0;
        prevkm:=0;
        nkm:=0;
        lim:=true;
        rt1:=0;
        ro1:=0;
        xx:=0;
        for x:=i to n do begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,i]) then begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,n]) then begin
            inc(xx);
            if stringgrid1.Cells[10,x]<>kmt then begin
              if xx=2 then kmt:=stringgrid1.Cells[10,x];
            end;
            if stringgrid1.Cells[10,x]<>kmt then begin
              if kmt='###' then begin
                kmt:=stringgrid1.Cells[10,x];
                nkm:=strtointe(stringgrid1.Cells[3,x]);
              end
               else begin
                 km:=strtointe(stringgrid1.Cells[3,x])-nkm;
                 if km>0 then begin
                   trn1.add(kmt);
                   trkm1.add(inttostr(km));
                   nkm:=strtointe(stringgrid1.Cells[3,x]);
                 end;
                 kmt0:=kmt;
                 kmt:=stringgrid1.Cells[10,x];
               end;
            end
          end;
          end;
        end;
        if kmt<>'###' then begin
          km:=strtointe(stringgrid1.Cells[3,n])-nkm;
          if km>0 then begin
          trn1.add(kmt);
          trkm1.add(inttostr(km));
          end;
        end;



/////   
        if trn.count>0 then begin
          if trn.count=1 then lim:=true
                         else lim:=false;
          rt:=0;
          ro:=0;
          rtin:=0;
          roin:=0;
          rt9:=0;
          log.add('');
          log.add(stringgrid1.Cells[1,i]+' - '+stringgrid1.Cells[1,n]);
          s:='';
          s2:='';

          for x:=1 to trn.count do begin
            s:=s+trkm.getstring(x)+' ';
            if ((x=1)and(trn.count>1)) then begin
              if ((trn.getstring(1)='spb_gorod')and(trn.getstring(2)='spb')) then begin
               if ((strtointe(trkm.getstring(1))<=20)and(strtointe(trkm.getstring(2))<=20)) then lim:=true;
              end;
            end;
            kmm:=strtointe(trkm.getstring(x));
            if ((x=2)and(trn.count>1)) then begin
              if ((trn.getstring(1)='spb_gorod')and(trn.getstring(2)='spb')) then begin
               if ((strtointe(trkm.getstring(1))<=20)and(strtointe(trkm.getstring(2))<=20)) then kmm:=kmm-(20-strtointe(trkm.getstring(1)));
              end;
            end;

            rtx:=vCalcMonoTarif_SPB2013fsp(kmm,trn.getstring(x),'ETRAIN',lim,false);
            lim:=false;
              //  01.01.2013
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
//                rt:=round(rt*10) / 10;
//                SetRoundMode(rmTruncate);
                rt:=round(rt);
              end;
            rt:=rt+rtx;

            rtx:=vCalcMonoTarif_SPB2013fsp(kmm,trn.getstring(x),'INTRAIN',lim,false);
            lim:=false;
              //  01.01.2013
              if ((x>1)and(trn.getstring(x)='novgorod')) then begin
                SetRoundMode(rmNearest);
//                rtin:=round(rtin*10) / 10;
//                SetRoundMode(rmTruncate);
                rtin:=round(rtin);
              end;
            rtin:=rtin+rtx;

            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
          end; //for

          for x:=trn.count downto 1 do begin
            s2:=s2+trkm.getstring(x)+' ';
            kmm:=strtointe(trkm.getstring(x));
            if ((trn.getstring(x)='novgorod')) then lim:=true;
            rtx:=vCalcMonoTarif_SPB2013fsp(kmm,trn.getstring(x),'ETRAIN',lim,true);
            lim:=false;
            ro:=ro+rtx;
            rtx:=vCalcMonoTarif_SPB2013fsp(kmm,trn.getstring(x),'INTRAIN',lim,true);
            lim:=false;
            roin:=roin+rtx;
            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
          end;

        rt9:=rt;
        ro9:=rt;
{        SetRoundMode(rmTruncate);
        rt:=round(rt);
        if ro>0 then ro:=round(ro);
        rtin:=round(rtin);
        if roin>0 then roin:=round(roin);
}
         if not findNovgorodfsp(@trn) then begin
           SetRoundMode(rmNearest);
           rt:=round(rt);
           rtin:=round(rtin);
           ro:=round(ro);
         end
          else begin
           SetRoundMode(rmTruncate);
           rt:=round(rt);
           rtin:=round(rtin);
           ro:=round(ro);
          end;

        end;
///// -  




        if checkbox1.checked then begin
         if ((stringgrid1.Cells[0,i]<>'0')and(stringgrid1.Cells[0,n]<>'0')) then begin
          if rt>0 then begin
           if ((rt<=32)and(trn.count>1)) then begin
            s1:='32';
            if trn.searchstring('spb_gorod')>0 then s1:='34';
            WriteLn(tf1,'simple;'+stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+s1+' ('+inttostr(trn.count)+') '+s);
            WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+s1+'" type="etrain" reverse="1" />');
           end
            else begin
             if ((findNovgorodfsp(@trn))and(trn.count>1)) then begin
               WriteLn(tf1,'tariff;'+stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt)+' ['+floattostr(rt9)+'] ('+inttostr(trn.count)+') '+s+' /   '+floattostr(rtin));
               WriteLn(tf1,'  tariff;'+stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro)+' ['+floattostr(ro9)+'] ('+inttostr(trn.count)+') '+s2+' /   '+floattostr(roin));
               WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt)+'" type="etrain" reverse="0" />');
               WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro)+'" type="etrain" reverse="0" />');
//intrain               if rtin>rt then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rtin)+'" type="etrain_intrain" reverse="0" />')
//intrain                         else WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="etrain_intrain" reverse="0" />');
//intrain               if roin>ro then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(roin)+'" type="etrain_intrain" reverse="0" />')
//intrain                         else WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="0" type="etrain_intrain" reverse="0" />');
             end
              else begin
               WriteLn(tf1,'tariff;'+stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt)+' ['+floattostr(rt9)+'] ('+inttostr(trn.count)+') '+s+' /   '+floattostr(rtin));
               WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt)+'" type="etrain" reverse="1" />');
//intrain               if rtin>rt then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rtin)+'" type="etrain_intrain" reverse="1" />')
//intrain                         else WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="0" type="etrain_intrain" reverse="1" />');
              end;

//             WriteLn(tf1,'sale;'+stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt1)+' ('+inttostr(trn1.count)+') '+s);
//             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt1)+'" type="etrain" reverse="0" />');
            end;
          end;
{
          if ro>0 then begin
           if ((ro<32)and(trn.count>1)) then begin
//            s1:=32;
//            if trn.getstring(i)='spb_gorod' then s1:=34;
//            if trn.getstring(i)='novgorod' then s1:=38;
             WriteLn(tf1,'simple;'+stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(32)+' ('+inttostr(trn.count)+') '+s);
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="32" type="etrain" reverse="0" />');
           end
            else begin
             WriteLn(tf1,'intrain;'+stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro)+' ('+inttostr(trn.count)+') '+s);
//             WriteLn(tf1,'sale;'+stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro1)+' ('+inttostr(trn1.count)+') '+s);
             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro)+'" type="etrain" reverse="0" />');
//             WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro1)+'" type="etrain" reverse="0" />');
            end;
          end;
}
         end;
        end;



      end;
    end;
  end;







  log.savetofile('C:\AF\\\1.1');
  trn.free; trkm.free; trn1.free; trkm1.free; log.free;
end;
end;




























procedure Calc_SPB2011mart;
  var i,n,m,x,z,km,kmz:integer;
  var rt,ro:real;
  var kmt,kmt0,s:string;
  var lim:boolean;
  var trn,trkm,log:AF_Types.TStrings;
begin
with form1 do begin
  trn.create; trkm.create; log.create;
  for m:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,m]:=trim(ansilowercase(stringgrid1.Cells[4,m]));
    stringgrid1.Cells[5,m]:=trim(ansilowercase(stringgrid1.Cells[5,m]));
  end;
   for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        kmz:=strtointe(stringgrid1.Cells[3,i]);
        kmt:='###';
        kmt0:='###';
        trn.clear;
        trkm.clear;
        rt:=0;
        ro:=0;
        lim:=true;
        for x:=i to n do begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,i]) then begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,n]) then begin
            if stringgrid1.Cells[4,x]<>kmt then begin
              if kmt='###' then begin
                kmt:=stringgrid1.Cells[4,x];
                kmz:=strtointe(stringgrid1.Cells[3,x]);
              end
               else begin
                 km:=strtointe(stringgrid1.Cells[3,x-1])-kmz;
                 if km>0 then begin
                 trn.add(kmt);
                 trkm.add(inttostr(km));
                 end;
                 kmz:=strtointe(stringgrid1.Cells[3,x-1]);
                 kmt0:=kmt;
                 kmt:=stringgrid1.Cells[4,x];
               end;
            end
          end;
          end;
        end;
        if kmt<>'###' then begin
          km:=strtointe(stringgrid1.Cells[3,n])-kmz;
          if km>0 then begin
          trn.add(kmt);
          trkm.add(inttostr(km));
          end;
        end;
        if trn.count>0 then begin
          if trn.count=1 then lim:=true
                         else lim:=false;
          rt:=0;
          ro:=0;
          log.add('');
          log.add(stringgrid1.Cells[1,i]+' - '+stringgrid1.Cells[1,n]);
          s:='';
          for x:=1 to trn.count do begin
            s:=s+trkm.getstring(x)+' ';
            rt:=rt+vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
          end;
          for x:=trn.count downto 1 do begin
            ro:=ro+vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            log.add(': '+trn.getstring(x)+' '+trkm.getstring(x));
          end;
        end;
        SetRoundMode(rmNearest);
        rt:=round(rt*10) / 10;
        ro:=round(ro*10) / 10;
        if checkbox1.checked then begin
         if ((stringgrid1.Cells[0,i]<>'0')and(stringgrid1.Cells[0,n]<>'0')) then begin
          WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt)+' ('+inttostr(trn.count)+') '+s);
          WriteLn(tf1,stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro)+' ('+inttostr(trn.count)+') '+s);
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt)+'" type="etrain" reverse="0" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro)+'" type="etrain" reverse="0" />');
         end;
        end;
      end;
    end;
  end;
//  log.savetofile('c:\46\1.1');
  trn.free; trkm.free; log.free;
end;
end;




procedure Calc_SPB2011f;
  var i,n,m,x,z,km,kmz:integer;
  var rt,ro:real;
  var kmt,kmt0:string;
  var lim:boolean;
  var trn,trkm:AF_Types.TStrings;
begin
with form1 do begin
  trn.create; trkm.create;
  for m:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,m]:=trim(ansilowercase(stringgrid1.Cells[4,m]));
    stringgrid1.Cells[5,m]:=trim(ansilowercase(stringgrid1.Cells[5,m]));
  end;
   for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        kmz:=strtointe(stringgrid1.Cells[3,i]);
        kmt:='###';
        kmt0:='###';
        trn.clear;
        trkm.clear;
        rt:=0;
        ro:=0;
        lim:=true;
        for x:=i to n do begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,i]) then begin
          if CompareDirections(stringgrid1.Cells[2,x],stringgrid1.Cells[2,n]) then begin
            if stringgrid1.Cells[4,x]<>kmt then begin
              if kmt='###' then begin
                kmt:=stringgrid1.Cells[4,x];
                kmz:=strtointe(stringgrid1.Cells[3,x]);
              end
               else begin
                 km:=strtointe(stringgrid1.Cells[3,x-1])-kmz;
                 trn.add(kmt);
                 trkm.add(inttostr(km));
                 kmz:=strtointe(stringgrid1.Cells[3,x-1]);
                 kmt0:=kmt;
                 kmt:=stringgrid1.Cells[4,x];
               end;
            end
          end;
          end;
        end;
        if kmt<>'###' then begin
          km:=strtointe(stringgrid1.Cells[3,n])-kmz;
          trn.add(kmt);
          trkm.add(inttostr(km));
        end;
        if trn.count>0 then begin
          lim:=true;
          rt:=0;
          ro:=0;
          for x:=1 to trn.count do begin
            rt:=rt+vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            lim:=false;
          end;
          lim:=true;
          for x:=trn.count downto 1 do begin
            if ansilowercase(trn.getstring(x))='spb' then if x>1 then lim:=false;
            if x=1 then begin
             if trn.count>1 then begin
               if strtointe(trkm.getstring(x+1))<14 then
                     if strtointe(trkm.getstring(x))<20 then lim:=true;
             end;
            end;
            ro:=ro+vCalcMonoTarif_SPB2011(strtointe(trkm.getstring(x)),trn.getstring(x),'ETRAIN',lim);
            lim:=false;
          end;
        end;
        SetRoundMode(rmNearest);
        rt:=round(rt*10) / 10;
        ro:=round(ro*10) / 10;
        if checkbox1.checked then begin
          WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(rt));
          WriteLn(tf1,stringgrid1.Cells[1,n]+';'+stringgrid1.Cells[1,i]+';'+floattostr(ro));
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(rt)+'" type="etrain" reverse="0" />');
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,n]+'" station2="'+stringgrid1.Cells[0,i]+'" price="'+floattostr(ro)+'" type="etrain" reverse="0" />');
        end;
      end;
    end;
  end;
  trn.free; trkm.free;
end;
end;


procedure Calc_MSK2010ab;
  var i,n,m,xt:integer;
  var km,t,km0,km1,km2,r,qq1,qq2,qq0:real;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        km:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        xt:=0;
        if length(trim(stringgrid1.Cells[6,i]))>1 then
         if trim(stringgrid1.Cells[6,i])=trim(stringgrid1.Cells[6,n]) then xt:=1;
        if km<21 then begin
          if xt=1 then begin
            if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          end
           else begin
            if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
           end;
        end
         else begin
           if trim(stringgrid1.Cells[4,i])=trim(stringgrid1.Cells[4,n]) then begin
            if xt=1 then begin

              if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            end
             else begin
              if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
             end;
           end
            else begin
              km0:=0;
              for m:=i+1 to n do begin
                if ((stringgrid1.cells[4,m]=stringgrid1.Cells[4,n])and(stringgrid1.cells[4,m-1]=stringgrid1.Cells[4,i])and(CompareDirections(stringgrid1.cells[2,i],stringgrid1.cells[2,m]))) then begin
                   km0:=strtofloat(trim(stringgrid1.cells[3,m-1]));
                   break;
                end;
              end;
              if km0>0 then begin
               km1:=abs(km0-strtofloat(trim(stringgrid1.Cells[3,i])));
               km2:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-km0);
               if checkbox2.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox3.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox4.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox5.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox6.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox7.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox8.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              end;
            end;
         end;
      end;
    end;
  end;
end;
end;


procedure Calc_MSK2010ab3500;
  var i,n,m,xt:integer;
  var km,t,km0,km1,km2,r,qq1,qq2,qq0:real;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        km:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        xt:=0;
        if length(trim(stringgrid1.Cells[6,i]))>1 then
         if trim(stringgrid1.Cells[6,i])=trim(stringgrid1.Cells[6,n]) then xt:=1;
        if km<21 then begin
          if xt=1 then begin
            if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          end
           else begin
            if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
           end;
        end
         else begin
           if trim(stringgrid1.Cells[4,i])=trim(stringgrid1.Cells[4,n]) then begin
            if xt=1 then begin
             if km>53 then begin
              if checkbox2.Checked then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="3500" type="1m" reverse="1" />');
             end                                                                                                                                                            
             else begin
              if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
             end;
              if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[6,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            end
             else begin
             if km>53 then begin
              if checkbox2.Checked then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="3500" type="1m" reverse="1" />');
             end
             else begin
              if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
             end;
              if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
             end;
           end
            else begin
              km0:=0;
              for m:=i+1 to n do begin
                if ((stringgrid1.cells[4,m]=stringgrid1.Cells[4,n])and(stringgrid1.cells[4,m-1]=stringgrid1.Cells[4,i])and(CompareDirections(stringgrid1.cells[2,i],stringgrid1.cells[2,m]))) then begin
                   km0:=strtofloat(trim(stringgrid1.cells[3,m-1]));
                   break;
                end;
              end;
              if km0>0 then begin
               km1:=abs(km0-strtofloat(trim(stringgrid1.Cells[3,i])));
               km2:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-km0);
               if km>53 then begin
                if checkbox2.Checked then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="3500" type="1m" reverse="1" />');
               end
               else begin
                if checkbox2.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               end;
               if checkbox3.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox4.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox5.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox6.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox7.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
               if checkbox8.Checked then WriteLn(tf,CalcDualTarif_MSK2010(km1,km2,stringgrid1.Cells[4,i],stringgrid1.Cells[4,n],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              end;
            end;
         end;
      end;
    end;
  end;
end;
end;




procedure Calc_MSKabskv;
  var i,n,m,xt:integer;
  var km,t,km0,km1,km2,r,qq1,qq2,qq0:real;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if not CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        km:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        xt:=0;
        if length(trim(stringgrid1.Cells[5,i]))>1 then
         if trim(stringgrid1.Cells[5,i])=trim(stringgrid1.Cells[5,n]) then xt:=1;
        if km<21 then begin
          if xt=1 then begin
            if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
          end
           else begin
            if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
           end;
        end
         else begin
           if trim(stringgrid1.Cells[4,i])=trim(stringgrid1.Cells[4,n]) then begin
            if xt=1 then begin
              if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[5,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
            end
             else begin
              if checkbox2.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1M',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox3.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'1MR',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox4.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'5D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox5.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'10D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox6.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'15D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox7.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'20D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
              if checkbox8.Checked then WriteLn(tf,CalcMonoTarif_MSK2010(km,stringgrid1.Cells[4,i],'25D',stringgrid1.Cells[0,i],stringgrid1.Cells[0,n]));
             end;
           end;
         end;
      end;
    end;
  end;
end;
end;



procedure Calc_Samara;
  var tn,tp:AF_Types.TStrings;
  var i,n,m,zone1:integer;
  var zone,km,t,km1,km2,r:real;
  var x1,x2:string;
begin
with form1 do begin
  tn.create;
  tp.create;
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;

  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        x1:=trim(ansilowercase(stringgrid1.Cells[4,n]));
        x2:=trim(ansilowercase(stringgrid1.Cells[4,i]));
        zone:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        zone1:=trunc(zone);
        t:=0;
          case zone1 of
            0: t:=10;
            1: t:=10;
            2: t:=10;
            3: t:=17;
            4: t:=23;
            5: t:=29;
            6: t:=35;
            7: t:=41;
            8: t:=48;
            9: t:=58;
            10: t:=67;
            11: t:=75;
            12: t:=83;
            13: t:=97;
            14: t:=106;
            15: t:=112;
            16: t:=120;
            17: t:=128;
            18: t:=136;
            19: t:=144;
            20: t:=152;
            21: t:=160;
            22: t:=168;
            23: t:=176;
            24: t:=184;
            25: t:=192;
          end;

          if (x1='samara_g') and (x2='samara_g') then begin
            t:=10;
          end;

          if (x1='oktabrsk') and (x2='oktabrsk') then begin
            t:=12;
          end;

          if (x1='orenburg') and (x2='orenburg') then begin
            case zone1 of
              0: t:=8;
              1: t:=8;
              2: t:=16;
              3: t:=24;
              4: t:=32;
              5: t:=40;
              6: t:=48;
              7: t:=56;
              8: t:=64;
              9: t:=72;
              10: t:=80;
              11: t:=88;
              12: t:=96;
              13: t:=104;
              14: t:=112;
              15: t:=120;
              16: t:=128;
            end;
         end;

          stringgrid1.Cells[i+5,n]:='f_'+floattostr(t);
          if t>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t)+'" type="etrain" reverse="1" />');
      end;
    end;
  end;
  tp.free;
  tn.free;
end;
end;

function PosSchCol(s:string):integer;
  var i:integer;
  var res:boolean;
begin
  res:=false;
  for i:=1 to form1.StringGrid2.ColCount-1 do begin
    if form1.StringGrid2.cells[i,0]=s then begin
      res:=true;
      break;
    end;
  end;
  if res then result:=i
         else result:=0;
end;

function PosSchRow(s:string):integer;
  var i:integer;
  var res:boolean;
begin
  res:=false;
  for i:=1 to form1.StringGrid2.RowCount-1 do begin
    if form1.StringGrid2.cells[0,i]=s then begin
      res:=true;
      break;
    end;
  end;
  if res then result:=i
         else result:=0;
end;

procedure Calc_SamaraScheme;
  var tn,tp:AF_Types.TStrings;
  var i,n,m,zone1,v1,v2:integer;
  var zone,km,t,km1,km2,r:real;
  var x1,x2,z1,z2:string;
begin
with form1 do begin
if Opendialog2.Execute then begin
  LoadFromXLS(OpenDialog2.FileName,StringGrid2);
  tn.create;
  tp.create;
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;

  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        x1:=trim(ansilowercase(stringgrid1.Cells[4,n]));
        x2:=trim(ansilowercase(stringgrid1.Cells[4,i]));
        z1:=trim(ansilowercase(stringgrid1.Cells[3,i]));
        z2:=trim(ansilowercase(stringgrid1.Cells[3,n]));
        v1:=PosSchCol(z1);
        v2:=PosSchRow(z2);
        t:=0;
        if (v1>0) and (v2>0) then begin
          t:=strtofloat(stringgrid2.Cells[v1,v2]);
          if stringgrid1.Cells[5,i]=stringgrid1.Cells[5,n] then
           if stringgrid1.Cells[5,i]='samara_g' then t:=13;
          stringgrid1.Cells[i+5,n]:='f_'+floattostr(t);
          if t>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t)+'" type="etrain" reverse="1" insearch="1" />');
          end;
      end;
    end;
  end;
  tp.free;
  tn.free;
end;
end;
end;


procedure Calc_Buzuluk;
  var tn,tp:AF_Types.TStrings;
  var i,n,m,zone1:integer;
  var zone,km,t,km1,km2,r:real;
  var x1,x2:string;
begin
with form1 do begin
  tn.create;
  tp.create;
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;

  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        x1:=trim(ansilowercase(stringgrid1.Cells[4,i]));
        x2:=trim(ansilowercase(stringgrid1.Cells[4,n]));
        zone:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        zone1:=trunc(zone);
        t:=zone1*9;
         if (x1='orenburg') and (x2='orenburg') then begin
          stringgrid1.Cells[i+5,n]:='f_'+floattostr(t);
          if t>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t)+'" type="etrain" reverse="1" />');
         end;
         if (x1='samara') and (x2='orenburg') then begin
          t:=t+strtointe(trim(stringgrid1.Cells[5,i]));
          stringgrid1.Cells[i+5,n]:='f_'+floattostr(t);
          if t>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t)+'" type="etrain" reverse="1" />');
         end;

      end;
    end;
  end;
  tp.free;
  tn.free;
end;
end;



procedure Calc_Penza;
  var tn,tp:AF_Types.TStrings;
  var i,n,m,zone1:integer;
  var zone,km,t,km1,km2,r:real;
  var x1,x2:string;
begin
with form1 do begin
  tn.create;
  tp.create;
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;

  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        x1:=trim(ansilowercase(stringgrid1.Cells[4,n]));
        x2:=trim(ansilowercase(stringgrid1.Cells[4,i]));
        zone:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        zone1:=trunc(zone);
        t:=0;
          case zone1 of
            0: t:=8;
            1: t:=8;
            2: t:=14;
            3: t:=20;
            4: t:=28;
            5: t:=32;
            6: t:=42;
            7: t:=48;
            8: t:=54;
            9: t:=58;
            10: t:=62;
            11: t:=66;
            12: t:=68;
            13: t:=76;
            14: t:=80;
            15: t:=86;
            16: t:=90;
          end;
          stringgrid1.Cells[i+5,n]:='f_'+floattostr(t);
          if t>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t)+'" type="etrain" reverse="1" />');
      end;
    end;
  end;
  tp.free;
  tn.free;
end;
end;



procedure Calc_Saransk;
  var tn,tp:AF_Types.TStrings;
  var i,n,m,zone1:integer;
  var zone,km,t,km1,km2,r:real;
  var x1,x2:string;
begin
with form1 do begin
  tn.create;
  tp.create;
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;

  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        x1:=trim(ansilowercase(stringgrid1.Cells[4,n]));
        x2:=trim(ansilowercase(stringgrid1.Cells[4,i]));
        zone:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        zone1:=trunc(zone);
        t:=0;
          case zone1 of
            0: t:=7;
            1: t:=7;
            2: t:=14;
            3: t:=21;
            4: t:=27;
            5: t:=33;
            6: t:=40;
            7: t:=46;
            8: t:=53;
            9: t:=59;
            10: t:=65;
            11: t:=70;
            12: t:=75;
            13: t:=81;
            14: t:=86;
            15: t:=92;
            16: t:=98;
            17: t:=105;
            18: t:=112;
            19: t:=119;
          end;
          stringgrid1.Cells[i+5,n]:='f_'+floattostr(t);
          if t>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t)+'" type="etrain" reverse="1" />');
      end;
    end;
  end;
  tp.free;
  tn.free;
end;
end;


procedure Calc_Ulianovsk;
  var tn,tp:AF_Types.TStrings;
  var i,n,m,zone1:integer;
  var zone,km,t,km1,km2,r:real;
  var x1,x2:string;
begin
with form1 do begin
  tn.create;
  tp.create;
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;

  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        x1:=trim(ansilowercase(stringgrid1.Cells[4,n]));
        x2:=trim(ansilowercase(stringgrid1.Cells[4,i]));
        zone:=abs(strtofloat(trim(stringgrid1.Cells[3,n]))-strtofloat(trim(stringgrid1.Cells[3,i])));
        zone1:=trunc(zone);
        t:=0;
          case zone1 of
            0: t:=12;
            1: t:=12;
            2: t:=19;
            3: t:=26;
            4: t:=33;
            5: t:=40;
            6: t:=47;
            7: t:=54;
            8: t:=61;
            9: t:=68;
            10: t:=75;
            11: t:=82;
            12: t:=89;
            13: t:=96;
            14: t:=103;
            15: t:=110;
            16: t:=117;
            17: t:=124;
          end;

          if (x1='uln_syzr') or (x2='uln_syzr') then begin
            case zone1 of
              10: t:=77;
              11: t:=86;
              12: t:=94;
              13: t:=105;
              14: t:=113;
              15: t:=114;
            end;
         end;

          if (x1='uln_nurl') or (x2='uln_nurl') then begin
            case zone1 of
              15: t:=111;
              16: t:=119;
              17: t:=127;
              18: t:=135;
            end;
         end;


          stringgrid1.Cells[i+5,n]:='f_'+floattostr(t);
          if t>0 then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t)+'" type="etrain" reverse="1" />');
      end;
    end;
  end;
  tp.free;
  tn.free;
end;
end;



procedure Calc_MSKSKV;
  var tn,tp:AF_Types.TStrings;
  var i,n,m,zone1:integer;
  var zone,km,t,km1,km2,r,msk_gorod:real;
  var x1,x2,nz:string;
begin
with form1 do begin
  tn.create;
  tp.create;
  zone:=16.5;
  msk_gorod:=26;
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[0,i]:=trim(ansilowercase(stringgrid1.Cells[0,i]));
    stringgrid1.Cells[3,i]:=trim(ansilowercase(stringgrid1.Cells[3,i]));
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
  end;

  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    nz:=stringgrid1.Cells[3,i];
    t:=0;
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if nz<>stringgrid1.Cells[3,n] then begin
          t:=t+zone;
          nz:=stringgrid1.Cells[3,n];
      end;
      if not CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
          r:=t;
          if r=0 then r:=zone;
          if ((stringgrid1.Cells[4,n]='msk_gorod')and(stringgrid1.Cells[4,i]='msk_gorod')) then r:=msk_gorod;
          stringgrid1.Cells[i+5,n]:='f_'+floattostr(r);
          if ((length(stringgrid1.Cells[0,n])>0)and(length(stringgrid1.Cells[0,i])>0)) then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(r)+'" type="etrain" reverse="1" />');
      end;
    end;
  end;
  tp.free;
  tn.free;
end;
end;


procedure Calc_Table;
  var tn,tp:AF_Types.TStrings;
  var i,n,m,zone1:integer;
  var zone,km,t,km1,km2,r,msk_gorod:real;
  var x1,x2,nz,ins:string;
begin
with form1 do begin
  x1:='qqq';
  stringgrid1.Cells[1,1]:=trim(ansilowercase(stringgrid1.Cells[1,1]));
  ins:='1';
  if stringgrid1.Cells[1,1]='etrain' then begin x1:='etrain'; ins:='1'; end;
  if stringgrid1.Cells[1,1]='express' then begin x1:='express'; ins:='0'; end;
  if pos('express_',stringgrid1.Cells[1,1])=1 then begin x1:=trim(stringgrid1.Cells[1,1]); ins:='0'; end;
  if stringgrid1.Cells[1,1]='express1m' then begin x1:='e1m'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='express1mr' then begin x1:='e1mr'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1m' then begin x1:='1m'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='1mr' then begin x1:='1mr'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='5d' then begin x1:='5d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='10d' then begin x1:='10d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='15d' then begin x1:='15d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='20d' then begin x1:='20d'; ins:='0'; end;
  if stringgrid1.Cells[1,1]='25d' then begin x1:='25d'; ins:='0'; end;
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[0,i]:=trim(ansilowercase(stringgrid1.Cells[0,i]));
  end;
  for i:=2 to stringgrid1.colcount-1 do begin
    stringgrid1.Cells[i,0]:=trim(ansilowercase(stringgrid1.Cells[i,0]));
    for n:=2 to stringgrid1.rowcount-1 do begin
      if ((length(stringgrid1.Cells[0,n])>0)and(length(stringgrid1.Cells[i,0])>0)and(length(stringgrid1.Cells[i,n])>0)and(x1<>'qqq')) then WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[i,0]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+trim(stringgrid1.Cells[i,n])+'" type="'+x1+'" reverse="1" insearch="'+ins+'"/>');
    end;
  end;

end;
end;


function Calc_NN_Internal(i,n:integer):real;
  var v,m,z1,z2:integer;
  var z,res:real;
begin
with form1 do begin
res:=0;
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        if StringGrid1.cells[4,i]=StringGrid1.cells[4,n] then begin
          // 1 
          z1:=abs(strtointe(StringGrid1.cells[3,n])-strtointe(StringGrid1.cells[3,i]));
          res:=GetZoneTariff(StringGrid1.cells[4,i],z1);
            if validstr(StringGrid1.cells[5,i]) then begin
              if StringGrid1.cells[5,i]=StringGrid1.cells[5,n] then begin
                res:=GetZoneTariff(StringGrid1.cells[5,i],0);
              end;
            end;
          // -1 
        end
         else begin
           // 2 
           for m:=i to n do begin
             if validstr(StringGrid1.cells[4,m]) then begin
             if StringGrid1.cells[4,m]<>StringGrid1.cells[4,i] then break;
             end;
           end;
           v:=m-1;
           while not CompareDirections(stringgrid1.Cells[2,v],stringgrid1.Cells[2,n]) do dec(v);
           z1:=abs(strtointe(StringGrid1.cells[3,v])-strtointe(StringGrid1.cells[3,i]))+1;
           z2:=abs(strtointe(StringGrid1.cells[3,n])-strtointe(StringGrid1.cells[3,m]));
           if z2>1 then res:=GetZoneTariff(StringGrid1.cells[4,i],z1)+GetZoneTariff(StringGrid1.cells[4,n],z2)
                   else res:=GetZoneTariff(StringGrid1.cells[4,i],z1);
           // -2 
         end;
      end;
result:=res;
end;
end;

procedure Calc_NN;
  var i,n:integer;
  var t:real;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     t:=Calc_NN_Internal(i,n);
     if t>0 then begin
       WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t)+'" type="etrain" reverse="1" />');
       WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t/2)+'" type="reduced" reverse="1" />');
     end;
    end;
  end;
end;
end;


function Calc_599_Internal(i,n:integer):real;
  var v,m,z1,z2:integer;
  var z,res:real;
begin
with form1 do begin
res:=0;
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        if StringGrid1.cells[4,i]=StringGrid1.cells[4,n] then begin
          // 1 
          z1:=abs(strtointe(StringGrid1.cells[3,n])-strtointe(StringGrid1.cells[3,i]));
          if z1<16 then res:=25;
          if z1 in [16..18] then res:=30;
          if z1 in [19..21] then res:=35;
          if z1 in [22..24] then res:=40;
          if z1 in [25..27] then res:=45;
          if z1 in [28..30] then res:=50;
          if z1 in [31..33] then res:=55;
          if z1 in [34..36] then res:=60;
          if z1 in [37..39] then res:=65;
          if z1 in [40..42] then res:=70;
          if z1 in [43..45] then res:=75;
          if z1 in [46..48] then res:=80;
          if z1 in [49..51] then res:=85;
          if z1 in [52..54] then res:=90;
          if z1 in [55..57] then res:=95;
          if z1 in [58..60] then res:=100;
          if z1 in [61..63] then res:=105;
          if z1 in [64..66] then res:=110;
          if z1 in [67..69] then res:=115;
          if z1>69 then res:=120;
          // -1 
        end
      end;
result:=res;
end;
end;

procedure Calc_BigMsk;
  var i,n:integer;
  var t:real;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        if StringGrid1.cells[4,i]=StringGrid1.cells[4,n] then begin
          WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="1040" type="bigmsk1m" reverse="1" />');
        end;
      end;
    end;
  end;
end;
end;

procedure Calc_599;
  var i,n:integer;
  var t:real;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     t:=Calc_599_Internal(i,n);
     if t>0 then begin
       WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t)+'" type="tariff599" reverse="1" />');
     end;
    end;
  end;
end;
end;


function Calc_Zone_Internal(i,n:integer):real;
  var v,m,z1,z2:integer;
  var z,res:real;
begin
with form1 do begin
res:=0;
      if CompareDirections(stringgrid1.Cells[2,n],stringgrid1.Cells[2,i]) then begin
        if StringGrid1.cells[4,i]=StringGrid1.cells[4,n] then begin
          // 1 
          z1:=abs(strtointe(StringGrid1.cells[3,n])-strtointe(StringGrid1.cells[3,i]));
          res:=GetZoneTariff(StringGrid1.cells[4,i],z1);
            if validstr(StringGrid1.cells[5,i]) then begin
              if StringGrid1.cells[5,i]=StringGrid1.cells[5,n] then begin
                res:=GetZoneTariff(StringGrid1.cells[5,i],0);
              end;
            end;
          // -1 
        end
         else begin
           // 2 
           for m:=i to n do begin
             if validstr(StringGrid1.cells[4,m]) then begin
             if StringGrid1.cells[4,m]<>StringGrid1.cells[4,i] then break;
             end;
           end;
           v:=m-1;
           while not CompareDirections(stringgrid1.Cells[2,v],stringgrid1.Cells[2,n]) do dec(v);
           z1:=abs(strtointe(StringGrid1.cells[3,v])-strtointe(StringGrid1.cells[3,i]));
           z2:=abs(strtointe(StringGrid1.cells[3,n])-strtointe(StringGrid1.cells[3,m]))+1;
//           writeln(tf,'z1='+inttostr(z1)+' z2='+inttostr(z2));
           if z2>0 then res:=GetZoneTariff(StringGrid1.cells[4,i],z1)+GetZoneTariff(StringGrid1.cells[4,n],z2)
                   else res:=GetZoneTariff(StringGrid1.cells[4,i],z1);
           // -2 
         end;
      end;
result:=res;
end;
end;

function Calc_Zone_Internal_Seg(i,n:integer):TZOut;
  var z,v,m,x:integer;
  var res:real;
  var tz,tzn,tzc1,tzc2:AF_Types.TStrings;
  var s,lastn,lastz,startz:string;
begin
with form1 do begin
tzn.create; tzc1.create; tzc2.create;
lastn:='##599##234';
lastz:='';
startz:='';
res:=0;
  for m:=i to n do begin
   if CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,m]) then begin
     if lastn<>StringGrid1.cells[4,m] then begin
       if lastn='##599##234' then begin
         lastn:='##599##239';
         startz:=StringGrid1.cells[3,m];
       end
        else begin
         if lastn='##599##239' then begin
           lastn:=StringGrid1.cells[4,m];
         end
          else begin
           tzn.add(lastn);
           tzc1.add(startz);
           tzc2.add(lastz);
           lastn:=StringGrid1.cells[4,m];
           startz:=lastz;
          end;
        end;
     end;
     lastz:=StringGrid1.cells[3,m];
   end;
  end;
  if lastn<>'##599##234' then begin
  if lastn<>'##599##239' then begin
    tzn.add(lastn);
    tzc1.add(startz);
    tzc2.add(lastz);
  end;
  end;
  s:='';
  if tzn.count>0 then begin
    for v:=1 to tzn.count do begin
      s:=s+tzn.getstring(v);
      z:=abs(strtointe(tzc1.getstring(v))-strtointe(tzc2.getstring(v)));
      s:=s+'='+inttostr(z)+';  ';
      res:=res+GetZoneTariff(tzn.getstring(v),z);
    end;
  end;
  result.price:=res;
  result.legend:=s;
tzn.free; tzc1.free; tzc2.free;

end;
end;

procedure Calc_Zone;
  var i,n:integer;
  var t:real;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     t:=Calc_Zone_Internal(i,n);
     if t>0 then begin
       WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(t)+'" type="etrain" reverse="1" />');
       WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(t));
     end;
    end;
  end;
end;
end;

procedure Calc_Zone_Seg;
  var i,n:integer;
  var t:real;
  var tariff:TZOut;
  var f1:AF_types.TSTrings;
  var s:string;
begin
with form1 do begin
  for i:=0 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[4,i]:=trim(ansilowercase(stringgrid1.Cells[4,i]));
    stringgrid1.Cells[5,i]:=trim(ansilowercase(stringgrid1.Cells[5,i]));
  end;
  for i:=2 to stringgrid1.rowcount-1 do begin
    stringgrid1.Cells[i+5,0]:=stringgrid1.Cells[1,i];
    for n:=i+1 to stringgrid1.rowcount-1 do begin
     if CompareDirections(stringgrid1.Cells[2,i],stringgrid1.Cells[2,n]) then begin
       tariff:=Calc_Zone_Internal_Seg(i,n);
       if tariff.price>0 then begin
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price)+'" type="etrain" reverse="1" />');
         WriteLn(tf,'  <tarif station1="'+stringgrid1.Cells[0,i]+'" station2="'+stringgrid1.Cells[0,n]+'" price="'+floattostr(tariff.price/2)+'" type="reduced" reverse="1" />');
         WriteLn(tf1,stringgrid1.Cells[1,i]+';'+stringgrid1.Cells[1,n]+';'+floattostr(tariff.price)+';'+tariff.legend);
         stringgrid1.Cells[i+5,n]:=floattostr(tariff.price);
       end;
     end;
    end;
  end;
  f1.create;
    for i:=0 to stringgrid1.RowCount-1 do begin
      s:='';
      for n:=0 to stringgrid1.ColCount-1 do begin
        s:=s+stringgrid1.cells[n,i]+';';
      end;
      f1.add(s);
    end;
  f1.savetofile(SaveDialog1.FileName+'.angle.csv');  
  f1.free;
end;
end;



procedure TForm1.SpeedButton1Click(Sender: TObject);
  var i:integer;
begin
  if OpenDialog1.Execute then begin
  if SaveDialog1.Execute then begin
  AssignFile(tf1,SaveDialog1.FileName+'.out.csv');
  Rewrite(tf1);
  AssignFile(tf,SaveDialog1.FileName);
  Rewrite(tf);
  WriteLn(tf,'<?xml version="1.0" encoding="Windows-1251"?>');
  WriteLn(tf,'');
  WriteLn(tf,'<channel type="tarif" version="1">');
    for i:=0 to OpenDialog1.Files.Count-1 do begin
      ClearSG(stringgrid1);
      LoadFromXLS(OpenDialog1.Files.Strings[i],StringGrid1);
      stringgrid1.ColCount:=stringgrid1.RowCount+10;
//      if pos('spb2010',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_SPB2010;
//      if pos('spb2011',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_SPB2011mart;
      if pos('spb092011',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_SPB2013fsp;
//      if pos('spb_fin_2011',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_SPB2011f;
{      if pos('samara',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_Samara;
      if pos('samarscheme',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_SamaraScheme;
      if pos('buzuluk',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_Buzuluk;
      if pos('penza',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_Penza;
      if pos('saransk',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_Saransk;
      if pos('uln',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_Ulianovsk;
      if pos('msk_skv',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_MSKSKV;
      if pos('msk_abskv',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_MSKABSKV;
      if pos('msk2010',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_MSK2010ab;
      if pos('msk3500',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_MSK2010ab3500;
      if pos('table',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_Table;
      if pos('nn_vl',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_NN;
      if pos('ufa2011',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_Zone;
      if pos('zone',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_Zone;
      if pos('krasnoyarsk2011',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_Zone_Seg;
      if pos('tariff599',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_599;
      if pos('bigmsk',ansilowercase(StringGrid1.Cells[0,1]))>0 then Calc_BigMsk;  }
    end;
  WriteLn(tf,'</channel>');
  CloseFile(tf);
  CloseFile(tf1);
  ShowMessage(' !');
  end;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
  var i:integer;
begin
  setroundmode(rmNearest);
  clearsg(stringgrid1);
  StringGrid1.rowcount:=201;
  for i:=1 to 200 do begin
    stringgrid1.cells[0,i]:=inttostr(i);
    stringgrid1.cells[1,i]:=floattostr(round(Calc5d(i,edit1.text)));
  end;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
  var i:integer;
begin
  if OpenDialog1.Execute then begin
      ClearSG(stringgrid1);
      LoadFromXLS(OpenDialog1.Files.Strings[0],StringGrid1);
      stringgrid1.ColCount:=stringgrid1.RowCount+10;
      combobox1.Items.clear;
      combobox2.Items.clear;
      if StringGrid1.RowCount>2 then begin
      for i:=2 to StringGrid1.RowCount-1 do begin
        combobox1.Items.Add(StringGrid1.cells[1,i]);
        combobox2.Items.Add(StringGrid1.cells[1,i]);
      end;
        combobox1.ItemIndex:=0;
        combobox2.ItemIndex:=0;
      end;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
{  if combobox2.itemindex>combobox1.ItemIndex then begin
//    Calc_SPB2011(combobox1.itemindex,combobox2.itemindex);
  end
   else ShowMessage('  !');
}

  SetRoundMode(rmNearest);
  showmessage(floattostr(round(56.5001)));
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  showmessage(floattostr(okr5(strtofloat(edit2.text))));
end;

Function ReplaceParam(str1,param,value:string;add:boolean):string;
  var s,s1,s2,s3:string;
  var i,n:integer;
begin
  s:=str1;
  s:=StrReplace(s,' =','=');
  s:=StrReplace(s,'= ','=');
    if pos(param+'="',s)>0 then begin
      i:=pos(param+'="',s)+length(param)+2;
      if s[i]<>'"' then begin
       while s[i]<>'"' do begin
         delete(s,i,1);
         if i>=length(s) then break;
       end;
      end;
      insert(value,s,i);
    end
     else begin
      s:=str1;
      if add then begin
        if pos('/>',s)>0 then begin
          insert(' '+param+'="'+value+'" ',s,pos('/>',s));
        end
         else begin
          if pos('>',s)>0 then begin
           insert(' '+param+'="'+value+'" ',s,pos('>',s));
          end
           else s:=str1;
         end;
      end
       else s:=str1;
     end;
  result:=s;
end;


procedure TForm1.Button4Click(Sender: TObject);
  var f1,f2:AF_types.TStrings;
  var s:string;
  var i:integer;
begin
  f1.create; f2.create;
  f1.loadfromfile('C:\AF\\\ 2011\spb_012013_perelom3_clean_novgorod.xml');
   for i:=1 to f1.count do begin
     s:=f1.getstring(i);
     if pos('price="',s)>0 then begin
       s:=ReplaceParam(s,'price','0',true);
     end;
     f2.add(s);
   end;


  f2.savetofile('C:\AF\\\ 2011\spb_012013_perelom3_clean_novgorod.xml');
  f1.free; f2.free;
end;

end.
