# coding=utf-8

import numpy as np
from datetime import timedelta
import datetime
from mdsLoader import mds_loader
from emailSender import email_sender


class html_builder(object):

    def __init__(self, access_key_id, secret_access_key, isProdaction, new_g):
        self.f = open('suburban_diff.html', 'w')
        self.access_key_id = access_key_id
        self.secret_access_key = secret_access_key
        self.isProdaction = isProdaction
        self.new_g = new_g

    def addLine(self, line):

        self.f.write(line)

    def addHead(self, title):
        head = '''<!DOCTYPE html>
    <html>
    <head> <title>''' + title + '''</title>
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      <meta http-equiv="Cache-Control" content="no-cache">
    </head>



    <body>
    <h1>''' + title + '''</h1>
    <p> сформировано: ''' + datetime.datetime.today().strftime("%Y-%m-%d %H:%M") + ''' </p>
    '''

        self.f.write(head)

    def appendTable(self, tbl, columns, title, links, rzdData):
        resstr = ''
        resstr = resstr + '<h2>' + title + '</h2>'
        for link in links:
            description = link['description']
            href = link['link']
            resstr = resstr + '<p> <a href="' + href.encode('utf8') + '">' + description.encode('utf8') + '</a></p>'

        for el in rzdData['thread_info']:
            resstr = resstr + '<p>idtr: ' + str(el['idtr']) + ', idr:' + str(el['idr']) + ', number:' + str(
                el['number']) + '</p>'
        resstr = resstr + "<table border = '1'>\n"
        resstr = resstr + "<tr>\n"
        for colname in columns:
            resstr = resstr + "<th>" + colname + "</th>\n"
        resstr = resstr + "</tr>\n"
        for n in range(0, tbl.shape[0]):
            mark = ''
            if not(tbl.ix[n, 'correct']):
                mark = ' bgcolor="red" '
            resstr = resstr + "<tr " + mark + ">\n"
            for el in columns:
                st = tbl.ix[n, el]

                if isinstance(st, timedelta):
                    st = str(st)[7:]
                if isinstance(st, np.bool_):
                    if st:
                        st = u'без остановки'
                    else:
                        st = ''
                if (el == 'arrival_rasp') or (el == 'departure_rasp') or (el == 'arrival_rzd') or (el == 'departure_rzd'):
                    st = st[11:16]
                # print 'aaa:', type(st)
                st = "<td>" + st + "</td>\n"
                # print 'bbb: ', el, st
                st = st.encode('utf8')
                resstr = resstr + st
            resstr = resstr + "</tr>\n"
        resstr = resstr + " </table>"
        self.f.write(resstr)

    def closeFile(self):
        self.f.write("</body></html>")
        self.f.close()

    def pushOnMDS(self, tofile):
        f = open('suburban_diff.html')
        loader = mds_loader(self.access_key_id, self.secret_access_key, self.isProdaction, self.new_g)
        path = loader.upload(f.read(), tofile)
        return path

    def send_to_email(self, ppk_name, recipient_notification_list):

        subject = u'Расхождения по '+ppk_name
        email_sender(self.isProdaction).send_notification(subject, 'suburban_diff.html', recipient_notification_list)
