# coding=utf-8
import logging
from datetime import timedelta
import datetime

from rzdConnector import rzd_connector
from raspConnector import rasp_connector
from staticDiffer import static_differ
from htmlBuilder import html_builder
from processManager import process_manager
import traceback

logger = logging.getLogger()
logger.setLevel(logging.INFO)

strangeStation = [u'534016', u'534105']
list_email_notification_1 = [1, 5, 6, 7, 9, 12, 15, 16, 17, 20, 32, 33]
list_email_notification_2 = [13, 18, 25, 26]
rzd_unknown_threads = [{'number': '6962', 'start_station': '778800'}, {'number': '6961', 'start_station': '778509'}]


class MainModule(object):

    def __init__(self, rzd_username, rzd_password, access_key_id, secret_access_key, isProdaction, new_g):
        # self.matched = {}
        self.rzd_connector = rzd_connector(rzd_username, rzd_password)
        self.rasp_connector = rasp_connector()
        self.access_key_id = access_key_id
        self.secret_access_key = secret_access_key
        self.isProdaction = isProdaction
        self.new_g = new_g
        if isProdaction:
            self.recipient_notification_list_1 = ['rasp-info@yandex-team.ru', 'malianov@inbox.ru']
            self.recipient_notification_list_2 = ['romeodzerzh@yandex-team.ru']
        else:
            self.recipient_notification_list_1 = ['vasbur@yandex-team.ru']
            self.recipient_notification_list_2 = ['vasbur@mail.ru']

    @staticmethod
    def mergeThread(thread1, thread2):
        first = ''
        second = ''
        len1 = thread1.shape[0]
        if (thread1.ix[len1 - 1, 'station_name'] == thread2.ix[0, 'station_name']):
            # print 'case 1'
            first = thread1
            second = thread2
        elif ((thread1.ix[len1 - 1, 'esr'] in strangeStation) and (thread2.ix[0, 'esr']) in strangeStation):
            # print 'case 2'
            first = thread1
            second = thread2
        else:
            # print 'case 3'
            first = thread2
            second = thread1
        len1 = len(first)
        if ((first.ix[len1 - 1, 'esr'] in strangeStation) and (second.ix[0, 'esr']) in strangeStation):
            return first.append(second[0:]).reset_index()
        first.ix[len1 - 1, 'departure'] = second.ix[0, 'departure']
        return first.append(second[1:]).reset_index()[thread1.columns]

    @staticmethod
    def isCombine(thread1, thread2):
        len1 = thread1.shape[0]
        len2 = thread2.shape[0]
        if (thread1.ix[len1 - 1, 'station_name'] == thread2.ix[0, 'station_name']):
            return True
        if (thread1.ix[len1 - 1, 'esr'] in strangeStation) and (thread2.ix[0, 'esr'] in strangeStation):
            return True
        if (thread2.ix[len2 - 1, 'station_name'] == thread1.ix[0, 'station_name']):
            return True
        if (thread2.ix[len2 - 1, 'esr'] in strangeStation) and (thread1.ix[0, 'esr'] in strangeStation):
            return True
        return False

    def mergeThread3(self, thread1, thread2, thread3):
        if self.isCombine(thread1, thread2):
            combine = self.mergeThread(thread1, thread2)
            return self.mergeThread(combine, thread3)
        else:
            combine = self.mergeThread(thread1, thread3)
            return self.mergeThread(combine, thread2)

    def mergeThread4(self, thread1, thread2, thread3, thread4):
        if self.isCombine(thread1, thread2):
            combine_ = self.mergeThread(thread1, thread2)
            return self.mergeThread3(combine_, thread3, thread4)
        if self.isCombine(thread1, thread3):
            combine_ = self.mergeThread(thread1, thread3)
            return self.mergeThread3(combine_, thread2, thread4)
        if self.isCombine(thread1, thread4):
            combine_ = self.mergeThread(thread1, thread4)
            return self.mergeThread3(combine_, thread2, thread3)

    def is_unknown_rdz(self, rasp_thread_name, rasp_thread):
        result = False
        # print rasp_thread
        if len(rasp_thread) == 0:
            return False
        start_esr = rasp_thread.ix[0, 'esr']
        for el in rzd_unknown_threads:
            if (rasp_thread_name.find(el['number']) >= 0) and (start_esr == el['start_station']):
                result = True
        return result

    def trunk_long_threads(self, threads):
        # выкидываем согласованные нитки из данных РЖД, чтобы избежать дублей
        # согласованная нитка имеет тот же номер, что и обычная, но длиннее
        res = []

        best_threads = {}
        for thread in threads:
            if thread['number'] not in best_threads:
                best_threads[thread['number']]=thread
            elif thread['thread'].shape[0]<best_threads[thread['number']]['thread'].shape[0]:
                best_threads[thread['number']]=thread
        for thread in best_threads:
            res.append(best_threads[thread]['thread'])
        return res

    def getDiffPageBypart(self, dates, rzd_codes, esr_codes, codeowner, resfile):
        errors = 0
        dates_mathed = {}
        dates_rasp_threads = {}
        for n in range(0, len(dates)-1):
            dateStr = dates[n]
            nextDate = dates[n+1]
            all_rasp_threads = self.rasp_connector.GetRaspThreadList(dateStr, nextDate, esr_codes)
            dates_mathed[dateStr] = {}
            dates_rasp_threads[dateStr] = all_rasp_threads
        dates_rasp_threads[nextDate] = {}
        dates_mathed[nextDate] = {}
        prev_date = ''
        for nn in range(0, len(dates)):

            dateStr = dates[nn]
            nextDate = dates[nn + 1] if nn + 1 < len(dates) else ''
            print 'dateStr', dateStr
            print 'nextDate', nextDate
            rzdSchedule = self.rzd_connector.getSchedule(dateStr, rzd_codes, codeowner)

            for n in range(0, rzdSchedule.shape[0]):
                idtr, idr, num_ber, stationfrom_esr, stationto_esr = rzdSchedule[['idtr', 'idr', 'number', 'stationfrom_esr', 'stationto_esr']].values[n]
                if idr != 0:
                    print 'number',  idtr, idr
                    # print n
                    rzhd_thread, thread_number, esrStations = self.rzd_connector.getTread(idtr, idr, dateStr)
                    # print 'serach context', dateStr, nextDate , esrStations , thread_number
                    # resultThread, calendar, thread = self.rasp_connector.getRaspScedule(dateStr, nextDate, esrStations, thread_number)
                    rasp_thread_data = self.rasp_connector.getRaspScedule(dateStr, nextDate, esrStations, thread_number)
                    rasp_thread_data_date = dateStr
                    if (len(rasp_thread_data) == 0) and (prev_date != ''):
                        print 'search prev day'
                        rasp_thread_data = self.rasp_connector.getRaspScedule(prev_date, dateStr, esrStations, thread_number)
                        rasp_thread_data_date = prev_date
                    if (len(rasp_thread_data) == 0) and (n + 1 < len(dates)):
                        print 'search next day'
                        rasp_thread_data = self.rasp_connector.getRaspScedule(nextDate, '', esrStations, thread_number)
                        rasp_thread_data_date = nextDate

                    for el in rasp_thread_data:
                        matched = dates_mathed[rasp_thread_data_date]
                        rasp_thread_number = el['thread']
                        calendar = el['calendar']
                        raspThread = el['resultThread']
                        print 'mathed thread', rasp_thread_number, rasp_thread_data_date
                        # print raspThread
                        if rasp_thread_number not in dates_rasp_threads[rasp_thread_data_date]:
                            raspThread = []
                            rasp_thread_number = ''
                        if rasp_thread_number != '':
                            dates_rasp_threads[rasp_thread_data_date][rasp_thread_number] = True

                        mathed_key = rasp_thread_number
                        if mathed_key == '':
                            mathed_key = str(n)
                        if mathed_key not in matched:
                            matched[mathed_key] = {'rzd_threads': [], 'rasp_thread': raspThread,
                                                   'rasp_data': {'calendar': calendar, 'thread': rasp_thread_number},
                                                   'rzd_data': {'thread_info': []}}
                        matched[mathed_key]['rzd_threads'].append({'thread': rzhd_thread, 'number': thread_number})
                        matched[mathed_key]['rzd_data']['thread_info'].append({'idtr': idtr, 'idr': idr, 'number': thread_number})
                    if len(rasp_thread_data) == 0:
                        mathed_key = str(n)
                        matched = dates_mathed[dateStr]
                        matched[mathed_key] = {'rzd_threads': [], 'rasp_thread': [],
                                               'rasp_data': {'calendar': '', 'thread': ''},
                                               'rzd_data': {'thread_info': []}}
                        matched[mathed_key]['rzd_threads'].append({'thread': rzhd_thread, 'number': thread_number})
                        matched[mathed_key]['rzd_data']['thread_info'].append({'idtr': idtr, 'idr': idr, 'number': thread_number})
            prev_date = dateStr

        for n in range(1, len(dates) - 1):
            dateStr = dates[n]
            all_rasp_threads = dates_rasp_threads[dateStr]
            matched = dates_mathed[dateStr]

            resfile.addLine("<h1>Расхождения на " + str(dates[n]) + "</h1>")
            # смотрим к каким нашим ниткам не приматчилось ни одной нитки РЖД
            for key in all_rasp_threads:
                if all_rasp_threads[key] is False:
                    raspThread, calendar = self.rasp_connector.getRaspThread(key, dateStr)
                    matched[key] = {'rzd_threads': [], 'rasp_thread': raspThread, 'rasp_data': {'calendar': calendar, 'thread': key}, 'rzd_data': {'thread_info': []}}
            for key in matched:
                # print 'rasp key', key
                el = matched[key]
                rzd_threads = self.trunk_long_threads(el['rzd_threads'])
                rzd_sum_thread = []
                if len(rzd_threads) == 1:
                    rzd_sum_thread = rzd_threads[0]
                if len(rzd_threads) == 2:
                    rzd_sum_thread = self.mergeThread(rzd_threads[0], rzd_threads[1])
                if len(rzd_threads) == 3:
                    rzd_sum_thread = self.mergeThread3(rzd_threads[0], rzd_threads[1], rzd_threads[2])
                if len(rzd_threads) >= 4:
                    rzd_sum_thread = self.mergeThread4(rzd_threads[0], rzd_threads[1], rzd_threads[2], rzd_threads[3])

                if (len(el['rasp_thread']) > 0) or (len(rzd_threads) > 0):
                    diff = static_differ().getStationDiff(rzd_sum_thread, el['rasp_thread'], el['rasp_data']['calendar'])
                    if (diff[diff['correct'] == False].shape[0] > 0) and (self.is_unknown_rdz(key, el['rasp_thread']) is False):  # noqa
                        tableForHTML, iscorrect = static_differ().getTableForHtml(diff)
                        if not iscorrect:
                            errors = errors + 1
                        # print el['rasp_data']['calendar']
                        links = []
                        if el['rasp_data']['thread'] != '':
                            links.append({'description': el['rasp_data']['calendar'], 'link': 'https://rasp.yandex.ru/thread/' + el['rasp_data']['thread']})
                        resfile.appendTable(tableForHTML,
                                                    ['station_rzd', 'arrival_rzd', 'departure_rzd', 'station_rasp',
                                                     'arrival_rasp', 'departure_rasp'],
                                                    'Электричка ' + str(key) + ' (' + str(dateStr) + ')', links,
                                                    el['rzd_data'])
        return errors

    def generateDiffByPart(self, dates, key, part_info):
        resfile = html_builder(self.access_key_id, self.secret_access_key, self.isProdaction, self.new_g)
        resfile.addHead('Расхождения по ' + key.encode('utf8'))
        totalErrrors = 0
        # logging.info('Анализируем дату '+dates[n])
        # resfile.addLine("<h1>Расхождения на " + str(dates[n]) + "</h1>")
        errors = self.getDiffPageBypart(dates, part_info['rzd_codes'], part_info['esr_codes'], part_info['codeowner'], resfile)
        totalErrrors = totalErrrors + errors

        resfile.closeFile()
        return resfile, totalErrrors

    @staticmethod
    def getDatesRange(cnt, new_g):
        result = []
        lift = 0
        if new_g:
            start_date = datetime.date(2020, 12, 14)
        else:
            start_date = datetime.datetime.today()
        for n in range(lift, lift + cnt + 2):
            a = (start_date + timedelta(days=n)).strftime("%Y-%m-%d")
            result.append(a)
        return result

    def generateMainFile(self, datesDepth, selectedPart):

        dates = self.getDatesRange(datesDepth, self.new_g)
        partlist = self.rzd_connector.getPartList()
        manager = process_manager(self.access_key_id, self.secret_access_key, self.isProdaction, self.new_g)
        if selectedPart is None:
            slice = manager.getNextNumber()
        else:
            slice = str(selectedPart)
        logging.info('slice=' + str(slice))
        n = 0
        for key in sorted(partlist):
            n = n + 1
            print str(n)+', '+key
            if (str(n) == slice):
                logging.info(str(n)+', '+key)
                try:
                    manager.lockPart(key, n)
                    path = manager.generateMainFile()
                    logging.info(path)
                    resfile, errors = self.generateDiffByPart(dates, key, partlist[key])
                    path = resfile.pushOnMDS('suburban'+str(n)+'.html')
                    logging.info(path)
                    if (errors > 0) and (n in list_email_notification_1) and (self.new_g is False):
                        resfile.send_to_email(key, self.recipient_notification_list_1)
                    if (errors > 0) and (n in list_email_notification_2) and (self.new_g is False):
                        resfile.send_to_email(key, self.recipient_notification_list_2)

                    tm = datetime.datetime.today().strftime("%Y-%m-%d %H:%M")
                    manager.updateStatus(key, n, errors, tm)
                    path = manager.generateMainFile()
                    logging.info(path)
                except BaseException as e:
                    logging.info('exeption  in: '+str(n)+', '+key)
                    logging.info(traceback.print_exc())

    def start(self, datesDepth=7, selectedPart=None):
        logging.info('into main prn2')
        cnt = 1
        if selectedPart is None:
            cnt = 35
        for n in range(0, cnt):
            self.generateMainFile(datesDepth, selectedPart)
        logging.info('done')
