# coding=utf-8
import boto3
import requests

BUCKET = 'rasp-outstaff'
mds_url = 'https://s3.mds.yandex.net'


class mds_loader(object):

    def __init__(self, access_key_id, secret_access_key, isProdaction, new_g):
        self.access_key_id = access_key_id
        self.secret_access_key = secret_access_key
        if isProdaction:
            self.directory = 'suburban_diff'
        else:
            self.directory = 'suburban_diff_test'

        if new_g:
            self.directory = self.directory + '_g21'

    def upload(self, data, filename):
        key = self.directory + '/' + filename
        session = boto3.session.Session(
            aws_access_key_id=self.access_key_id,
            aws_secret_access_key=self.secret_access_key,
        )

        client = session.client(
            service_name='s3',
            endpoint_url=mds_url,
        )

        client.put_object(
            Bucket=BUCKET,
            Key=key,
            Body=data
        )

        return mds_url + '/' + BUCKET + '/' + key

    def getFile(self, filename):
        fullName = mds_url + '/' + BUCKET + '/' + self.directory + '/' + filename
        response = requests.get(fullName, timeout=15000, verify=False)

        if response.status_code == 200:
            print response.text.encode('ISO-8859-1')
            return response.text.encode('ISO-8859-1')
        elif response.status_code == 404:
            return ''
        else:
            raise Exception('unexpected result')
