# coding=utf-8

from mdsLoader import mds_loader
from htmlBuilder import html_builder
import datetime

PART_COUNT = 33
TTL_MINUTES = 240


class process_manager(object):

    def __init__(self, access_key_id, secret_access_key, isProdaction, new_g):
        self.access_key_id = access_key_id
        self.secret_access_key = secret_access_key
        self.isProdaction = isProdaction
        self.new_g = new_g

    def updateStatus(self, name, numb, errors, moment):
        f = open('suburban_diff.txt', 'w')
        print name, numb, errors, moment
        f.write(str(numb) + ';' + name.encode('utf8') + ';' + str(errors) + ';' + moment + ';False;')
        f.close()

        f = open('suburban_diff.txt', 'r')
        loader = mds_loader(self.access_key_id, self.secret_access_key, self.isProdaction, self.new_g)
        resfile = loader.upload(f.read(), 'suburban' + str(numb) + '.txt')
        print resfile

    def lockPart(self, name, num):
        f = open('suburban_diff.txt', 'w')
        parts = self.getPartDescription()
        for el in parts:
            if el['num'] == str(num):
                if 'is_work' in el:
                    errors = el['errors']
                    moment = el['moment']
                else:
                    errors = 0
                    moment = ''
                f.write(str(num) + ';' + name.encode('utf8') + ';' + str(errors).encode('utf8') + ';' + moment.encode(
                    'utf8') + ';True;' + datetime.datetime.today().strftime("%Y-%m-%d %H:%M"))
                f.close()
                f = open('suburban_diff.txt', 'r')
                loader = mds_loader(self.access_key_id, self.secret_access_key, self.isProdaction, self.new_g)
                resfile = loader.upload(f.read(), 'suburban' + str(num) + '.txt')
                print 'lock', resfile
                return resfile
        raise Exception('cant find part')

    def getPartDescription(self):
        res = []

        for n in range(1, PART_COUNT + 1):
            dt = mds_loader(self.access_key_id, self.secret_access_key, self.isProdaction, self.new_g).getFile('suburban' + str(n) + '.txt')
            if dt == '':
                res.append({'num': str(n)})
            else:
                parse = dt.split(';')
                res.append({'num': parse[0], 'descr': parse[1], 'errors': parse[2], 'moment': parse[3],
                            'is_work': parse[4], 'moment_work': parse[5]})
        return res

    def getNextNumber(self):

        parts = self.getPartDescription()
        bestNum = 0
        bestNumMoment = '2100-01-01'
        borderTime = (datetime.datetime.today() - datetime.timedelta(minutes=TTL_MINUTES)).strftime("%Y-%m-%d %H:%M")
        for el in parts:
            if 'moment' not in el:
                return el['num']
            isworking = (el['is_work'] == 'True') and (el['moment_work'] > borderTime)
            if not isworking and (el['moment'] < bestNumMoment):
                bestNum = el['num']
                bestNumMoment = el['moment']
        return bestNum

    def generateMainFile(self):

        builder = html_builder(self.access_key_id, self.secret_access_key, self.isProdaction, self.new_g)
        parts = self.getPartDescription()

        builder.addHead('Список расхождений')

        for el in parts:
            if 'descr' in el:
                desc = el['descr']
                builder.addLine('<p> <a href="suburban' + el['num'] + '.html" > ' + desc + ' </a> ')
                builder.addLine('<br>ошибок: ' + el['errors'] + ', обновлено ' + el['moment'] + '')
                if el['is_work'] == 'True':
                    builder.addLine('<br> обновляется с ' + el['moment_work'] + '')
                builder.addLine('</p>')
        builder.closeFile()
        path = builder.pushOnMDS('suburban_diff.html')
        return path
