# coding=utf-8

import pandas as pd
import json
import urllib3
import requests
import dateutil.parser
import pytz

raspHost = 'https://export.rasp.yandex.net'
# raspHost = 'https://testing.export.rasp.yandex.net'
duplicate_thrads_allow = [u'6831x6813x6814_0_9612215_g21_4', u'6831x6813x6814_1_9612215_g21_4']


class rasp_connector(object):

    def __init__(self):
        self.requestDict = {}
        urllib3.disable_warnings()

    def getResponce(self, requestStr):
        # print requestStr
        if requestStr in self.requestDict:
            resp = json.loads(self.requestDict[requestStr])
            if 'error' not in resp or (resp['error']['status_code'] != 500):
                # print 'from cache'
                return resp
        # print requestStr
        tries = 0
        has_response = False
        while (has_response is False) and (tries < 10):
            response = requests.get(requestStr, timeout=15000, verify=False)
            print response.status_code
            if (response.status_code == 500) or (response.status_code == 504):
                tries += 1
            else:
                has_response = True

        res = response.text.encode('utf8')
        result = json.loads(res)
        self.requestDict[requestStr] = res
        return result

    @staticmethod
    def getStringDateInMsk(tm):
        localtime = dateutil.parser.parse(tm)
        est = pytz.timezone('Europe/Moscow')
        msktime = localtime.astimezone(est)
        return (unicode(msktime))

    @staticmethod
    def getDateInMsk(tm):
        localtime = dateutil.parser.parse(tm)
        est = pytz.timezone('Europe/Moscow')
        msktime = localtime.astimezone(est)
        return msktime

    def getPoint2Point(self, date, from_esr, to_esr):
        request_str = raspHost + '/v3/suburban/search_on_date?station_from=' + from_esr + '&station_to=' + to_esr + '&date=' + date
        resp = self.getResponce(request_str)
        return resp

    def getRaspThread(self, uid, dateStr):
        request_str = raspHost + '/v3/suburban/thread_on_date/' + uid + '/?date=' + dateStr
        thread_resp = self.getResponce(request_str)
        result = []
        if ('error' in thread_resp) and (thread_resp['error']['status_code'] == 404):
            print '404'
            return [], ''
        if ('error' in thread_resp) and (thread_resp['error']['status_code'] == 400):
            print '400'
            return [], ''
        for st in thread_resp['stations']:
            arrival = ''
            departure = ''
            no_stop = False
            if 'arrival_local' in st:
                arrival = st['arrival_local']
            if 'departure_local' in st:
                departure = st['departure_local']
            if 'no_stop' in st:
                no_stop = st['no_stop']

            result.append([st['title'], st['esr'], arrival, departure, no_stop])
        result = pd.DataFrame(result)
        result.columns = ['station_name', 'esr', 'arrival', 'departure', 'no_stop']
        calendar = thread_resp['days']
        if 'except' in thread_resp:
            calendar = calendar + u', кроме ' + thread_resp['except']
        return result, calendar

    def getRaspScedule2(self, date, msk_date, from_esr, to_esr, rzd_segment_departure, number):

        search = self.getPoint2Point(date, from_esr, to_esr)
        result_data = []
        if ('error' in search) and (search['error']['status_code'] == 404):
            print '404'
            return []
        if ('error' in search) and (search['error']['status_code'] == 400):
            print '400'
            return []
        if len(search['days']) == 0:
            return []
        if len(number) == 0:
            return []
        for segment in search['days'][0]['segments']:
            segment_departure = segment['departure']['time']
            segment_departure_msk = self.getDateInMsk(segment_departure)
            # print segment_departure_msk, type(segment_departure_msk)
            # print rzd_segment_departure, type(rzd_segment_departure)
            seconds = (segment_departure_msk - rzd_segment_departure).seconds+(segment_departure_msk - rzd_segment_departure).days*24*60*60
            seconds = abs(seconds)
            if (segment['thread']['number'].find(str(number)) >= 0) and (self.getStringDateInMsk(segment['thread']['start_time']).find(msk_date) >= 0) and (seconds < 10*60*60):
                thread = segment['thread']['uid']
                threadStartTime = segment['thread']['start_time'][0:10]
                resultThread, calendar = self.getRaspThread(thread, threadStartTime)
                if (len(result_data) == 0) or (thread in duplicate_thrads_allow):
                    result_data.append({'resultThread': resultThread, 'calendar': calendar, 'thread': thread})
        return result_data

    def getRaspScedule(self, date, nextdate, stationsList, number):
        # ищем запросом по каждой паре станций, пока не найдем
        for step in range(1, 3):
            for n in range(0, len(stationsList) - step):
                result_data = self.getRaspScedule2(date, date, stationsList[n]['esr'], stationsList[n + step]['esr'], stationsList[n]['departure'], number)
                if (len(result_data) == 0) and (nextdate != ''):
                    result_data = self.getRaspScedule2(nextdate, date, stationsList[n]['esr'], stationsList[n + step]['esr'], stationsList[n]['departure'], number)
                if len(result_data) > 0:
                    return result_data
        return []

    def GetRaspThreadListByStation(self, dateStr, dateStart, esr):
        request_st = raspHost + '/v3/suburban/station_schedule_on_date/' + esr + '?date=' + dateStr
        # print request_st
        station_resp = self.getResponce(request_st)
        result = []
        if ('error' in station_resp) and (station_resp['error']['status_code'] == 404):
            print '404'
            return result
        for el in station_resp['threads']:
            if el['uid'].find('_g') > -1:
                if self.getStringDateInMsk(el['start_time']).find(dateStart) >= 0:
                    result.append(el['uid'])
        return result

    def GetRaspThreadList(self, dateStr, nextDate, esrList):
        result = {}
        for el in esrList:
            threads = self.GetRaspThreadListByStation(dateStr, dateStr, el)
            for thread_rasp in threads:
                result[thread_rasp] = False
            threads = self.GetRaspThreadListByStation(nextDate, dateStr, el)
            for thread_rasp in threads:
                result[thread_rasp] = False
        return result
