# coding=utf-8

import pandas as pd
from datetime import datetime
import pytz

banned_rzd_routes = "('2102044', '2102281', '2097673', '2102265')"


class rzd_connector(object):

    def __init__(self, username, password):
        import MySQLdb
        server_name = 'c-mdbcuhkeqi57nh45epdq.rw.db.yandex.net'
        port_name = 3306
        user_name = username
        passw_name = password
        connect = MySQLdb.connect(host=server_name, user=user_name, passwd=passw_name, port=port_name, charset='utf8')
        self.cursor = connect.cursor()

    @staticmethod
    def getTreadQuery(idtr, idr):
        return '''SELECT distinct SEQ, NUMP, NUMO, IDRP, PRIB, OTPR, TEXST , st.name1 , st.esr
        FROM rasp_rzd.rzd_buffer_change_srasprp_buf as thread
        left join  content_tools_data.stations as st
        on thread.IDRP = st.rzd_code
        where IDTR = ''' + str(idtr) + ''' and IDR = ''' + str(idr) + ''' and
        DATE_GVC = ( select max(DATE_GVC) from rasp_rzd.rzd_buffer_change_srasprp_buf as thread
        where IDTR = ''' + str(idtr) + ''' and IDR =  ''' + str(idr) + '''  )
       order by SEQ '''

    @staticmethod
    def get_start_of_date(dateStr):
        h3 = datetime.strptime('03:00', "%H:%M") - datetime.strptime("00:00", "%H:%M")
        start_of_day = datetime.strptime(dateStr, "%Y-%m-%d")
        start_of_day = start_of_day.replace(tzinfo=pytz.timezone('UTC')) - h3
        est = pytz.timezone('Europe/Moscow')
        start_of_day = start_of_day.astimezone(est)
        return start_of_day

    @staticmethod
    def delta_in_seconds(tm1, tm2):
        return (tm1 - tm2).seconds+(tm1 - tm2).days*24*60*60

    def getTread(self, idtr, idr, dateStr):
        number = ''
        curNum = 0
        thread_query = self.getTreadQuery(idtr, idr)
        self.cursor.execute(thread_query)
        res = self.cursor.fetchall()
        arr = []
        esrStations = []
        for el in res:
            arr.append(el)
        frame = pd.DataFrame(arr)
        frame.columns = ['ind', 'nump', 'numo', 'station_code', 'prib', 'otpr', 'no_stop', 'station_name', 'esr']
        frame['arrival'] = ''
        frame['departure'] = ''
        start_of_day = self.get_start_of_date(dateStr)
        day_timedelta = datetime.strptime('2', "%d") - datetime.strptime('1', "%d")
        start_timedelta = None
        for i in range(0, frame.shape[0]):
            if i == 0:
                start_timedelta = frame.ix[i, 'otpr']
            frame.ix[i, 'no_stop'] = (frame.ix[i, 'no_stop'] != 0)
            if (i > 0) and (i < frame.shape[0] - 1) and (frame.ix[i, 'prib'] == frame.ix[i, 'otpr']):
                frame.ix[i, 'no_stop'] = True
            frame.ix[i, 'arrival'] = start_of_day + frame.ix[i, 'prib']
            frame.ix[i, 'departure'] = start_of_day + frame.ix[i, 'otpr']
            # если текущее время отправления СИЛЬНО меньше начального времени отправления - значит мы перешли через полночь и нужно добавить сутки
            if (i > 0) and self.delta_in_seconds(frame.ix[i, 'otpr'], start_timedelta) < - 5*60*60:
                frame.ix[i, 'departure'] = frame.ix[i, 'departure'] + day_timedelta
            if (i > 0) and self.delta_in_seconds(frame.ix[i, 'prib'], start_timedelta) < - 5*60*60:
                frame.ix[i, 'arrival'] = frame.ix[i, 'arrival'] + day_timedelta
            nb = frame.ix[i, 'nump']
            nb2 = frame.ix[i, 'numo']
            if (number == '') and (nb != curNum) and (nb == nb2) and (
                    number.find(str(nb)) < 0):
                number = number + "/" + str(nb)
                curNum = nb
            if not(frame.ix[i, 'no_stop']) and (frame.ix[i, 'esr'] != '') and (frame.ix[i, 'esr'] is not None):
                esrStations.append({'esr': frame.ix[i, 'esr'], 'departure': frame.ix[i, 'departure']})
        frame = frame[['ind', 'nump', 'numo', 'station_code', 'arrival', 'departure', 'no_stop', 'station_name', 'esr']]
        return frame, number[1:], esrStations

    @staticmethod
    def getPartListQuery():
        return '''SELECT distinct rzd_code, name1, esr, part, parition as CODEOWNER  FROM content_tools_data.stations where
                part is not null order by name1'''

    def getPartList(self):
        part_query = self.getPartListQuery()
        self.cursor.execute(part_query)
        partList = self.cursor.fetchall()
        res = {}
        for el in partList:
            if el[3] not in res:
                res[el[3]] = {'rzd_codes': [], 'esr_codes': [], 'codeowner': ''}
            res[el[3]]['rzd_codes'].append(el[0])
            res[el[3]]['esr_codes'].append(el[2])
            # print type(el[4])
            if el[4] is not None:
                # print '!', type(el[4])
                res[el[3]]['codeowner'] = el[4]
        return res

    @staticmethod
    def getScheduleQuery(dateStr, rzd_codes, codeoowner):
        filter_ = ''
        for el in rzd_codes:
            if (filter_ != ''):
                filter_ = filter_ + ' or '
            filter_ = filter_ + 'thread.IDRP = ' + str(el)

        codeowner_filter = ''
        if codeoowner != '':
            codeowner_filter = ' or (base_thread.CODEOWNER = ' + codeoowner + ') '
        return ''' SELECT distinct calendar.IDTR, calendar.IDR, calendar.OPER,
        '' as num, base_thread.CREG, '' as  CODEOWNER,
        variant.RP1, variant.RPK,
        st1.name1 , st1.esr, st2.name1 , st2.esr

        FROM
        (SELECT IDTR, CDATE, max(DATE_GVC)  as last_change FROM rasp_rzd.rzd_buffer_change_scalendar_buf
        where CDATE = "''' + dateStr + '''"
        group by IDTR, CDATE) as lasted
        left join
        rasp_rzd.rzd_buffer_change_scalendar_buf as calendar
        on calendar.IDTR = lasted.IDTR and calendar.CDATE = lasted.CDATE  and calendar.DATE_GVC = lasted.last_change

        left join  rasp_rzd.rzd_buffer_current_srasprp as thread
        on calendar.IDTR = thread.IDTR and calendar.IDR = thread.IDR

        left join rasp_rzd.rzd_buffer_change_strainsvar_buf  as variant
        on calendar.IDR = variant.IDR and  calendar.IDTR = variant.IDTR and variant.DATE_GVC = lasted.last_change
        left join rasp_rzd.rzd_buffer_change_strains_buf as base_thread
        on calendar.IDTR = base_thread.IDTR -- and variant.DATE_GVC = lasted.last_change

        left join  content_tools_data.stations as st1
        on variant.RP1 = st1.rzd_code
        left join  content_tools_data.stations as st2
        on variant.RPK = st2.rzd_code

        where
        calendar.IDR != 0 and base_thread.CODEOWNER != 0 and base_thread.CODEOWNER != 200000 and
        calendar.IDTR not in ''' + banned_rzd_routes + ''' and
          (
        ( ''' + filter_ + ''' ) ''' + codeowner_filter + '''  )
          '''

    def getSchedule(self, dateStr, rzd_codes, codeowner):
        schedule_query = self.getScheduleQuery(dateStr, rzd_codes, codeowner)
        print schedule_query
        self.cursor.execute(schedule_query)
        res = self.cursor.fetchall()
        arr = []
        for el in res:
            arr.append(el)
        frame = pd.DataFrame(arr)
        if frame.shape[0] > 0:
            frame.columns = ['idtr', 'idr', 'type', 'number', 'region_code', 'company_code', 'stationfrom_code',
                             'stationto_code', 'stationfrom_name', 'stationfrom_esr', 'stationto_name', 'stationto_esr']
        return frame
