# coding=utf-8
import dateutil.parser
import pytz
import pandas as pd

SecondsUp = 70
SecondsDown = -250
SecondsDownInChange = -430
kazTimezones = {'15961': 3, '15071': 3}
banStationList = [u'060603', u'060069',
                  # алтай-пригород
                  u'001771', u'001785',  u'001775', u'001886',
                  # Байкальская ППК
                  u'001907', u'001906', u'001916', u'001902', u'001903', u'001904', u'001905', u'933498', u'927618',
                  u'934842', u'900013', u'903134',  u'903153', u'_41456', u'_20345', u'927139', u'930638', u'926850',
                  u'001894', u'001893',
                  # CСЗ ППК
                  u'522', u'003163', u'014361', u'003169', u'020521', u'022349', u'022326', u'503', u'592', u'555',
                  u'_41386', u'_743', u'049040', u'045209', u'550', u'034810', u'072117', u'510', u'049214', u'533',
                  u'546', u'013015', u'014925', u'014959', u'003181', u'044831', u'500', u'517', u'057757', u'057742',
                  u'348', u'041212', u'070094', u'003148', u'003143', u'059019', u'003092', u'003136', u'074023',
                  u'044850', u'570',
                  # волго-вятская
                  u'962', u'963', u'001468', u'950', u'001315', u'263317', u'260003', u'001763', u'001762', u'263317',
                  u'960', u'268414', u'001350', u'987', u'988', u'989', u'001983', u'001984',
                  u'985',  # Окский берег
                  u'981',
                  # омск-пригород
                  u'001270', u'832511',  # остановок нет в баще РЖД
                  u'830056',
                  # Свердловская
                  u'001522', u'001520', u'718', u'768', u'791025', u'783226', u'761', u'710', u'17131',
                  u'773351', u'_17131', u'_17136', u'773417',  # баним выю и 2км , потому что из-за нее не склеивается правильно крюк
                  # Пермская
                  u'001506', u'766112', u'766019', u'765336',
                  # волгоград ТП
                  u'862', u'616959', u'832', u'617416', u'851', u'613538', u'612910',
                  # СевКавППК
                  u'921', u'922', u'540106', u'588158',
                  u'234', u'530732',
                  # Сев ППК
                  u'_41164',  # тех остановка
                  u'314735', u'001788',
                  # Содружество
                  u'001384',
                  # кубань ЭП
                  u'534016', u'534105',
                  u'525407', u'001838', u'_40435', u'514328',  # оп нет в базе РЖД
                  u'_11511', u'529817', u'_11568', u'531484',  # у РЖД перепутаны остановки
                  u'534603', u'900', u'533719',  # ошибки РЖД
                  # краспригород
                  u'886263', u'001619', u'001626', u'001622', u'893036', u'892688', u'892531', u'881823', u'001622', u'893036',
                  u'892688', u'892531', u'881823', u'887641', u'_19550', u'894715', u'894325', u'_19864', u'890536',
                  u'890428', u'894429', u'001611',
                  # кузбасс-пригород
                  u'001250',
                  # Саратовская ППК
                  u'607927', u'607664', u'607630', u'623440', u'874', u'875', u'623756', u'620086',
                  u'_13853',  # ошибки в данных РЖД
                  # Экспресс приморья
                  u'001956', u'001961', u'987549', u'001472',  # нет станции у РЖД
                  # Черноземье
                  u'603945', u'581958', u'601117', u'585094', u'596915', u'591733', u'585126', u'585130',
                  # МТППК
                  u'611', u'060711', u'615', u'614', u'611', u'051214', u'060853', u'611', u'050457', u'050508', u'060711',
                  u'_885', u'674', u'067710', u'918', u'662', u'986', u'672',
                  # киевское
                  u'180909', u'180913',  # крекшино - победа
                  # павелецкое
                  # u'193504', # МОСКВА-ТОВ-ПАВЕЛ
                  # ярославское
                  u'235302',  # фрязино-тов
                  # mcd-2
                  u'346', u'347',
                  u'344', u'191462', u'191617',  # Остафьево, Курьяново, Каланчевская
                  # цппк-регионы
                  u'003003', u'356', u'003039', u'003047', u'003048', u'_41336', u'003040',
                  # БМО
                  u'190721']


class static_differ(object):

    @staticmethod
    def regularStr(str_):
        if str_ is None:
            return ''
        return str_.upper().replace('-', '').replace(' ', '').replace(u'Ё', u'Е').replace(u'ОСТ.ПУНКТ', '').replace(
            u'ОСТПУНКТ', '').replace(u'ПУТЕВОЙПОСТ', '').replace(u'ПОСТ', '').replace(u'ПЛАТФОРМА', '').replace(
            u'ОБГОННЫЙПУНКТ', '').replace(u'ОСТАНОВОЧНЫЙПУНКТ', '').replace(u'РАЗЪЕЗД', '').replace(
            u'БЛОКПОСТ', '').replace(u'.', '').replace(u'N', '').replace(u'№', '').replace(u'*', '')

    @staticmethod
    def getStationPos(stName, esr, frame, cursor_j):
        if len(frame) == 0:
            return -1
        for i in range(cursor_j, frame.shape[0]):
            name_i = frame.ix[i, 'station_name']
            esr_i = frame.ix[i, 'esr']
            # print 'lalala', i , type(esr), type(esr_i)
            # print 'getStationPos', esr , esr_i, type(stName), type(name_i)
            if (esr != ''):
                if (esr == esr_i):
                    return i
            else:
                if (static_differ().regularStr(stName) == static_differ().regularStr(name_i)):
                    return i
        return -1

    @staticmethod
    def getDateInMsk(tm):
        localtime = dateutil.parser.parse(tm)
        est = pytz.timezone('Europe/Moscow')
        msktime = localtime.astimezone(est)
        return msktime
        # mskdelta = msktime - msktime.replace(hour=0, minute=0, second=0, microsecond=0)
        # return mskdelta

    @staticmethod
    def getStringDateInMsk(tm):
        localtime = dateutil.parser.parse(tm)
        est = pytz.timezone('Europe/Moscow')
        msktime = localtime.astimezone(est)
        return (unicode(msktime))

    @staticmethod
    def correctTimeDiff(rzd_time, rzd_code, tm_rasp, calendar):
        day_in_seconds = 60*60*24
        rasp_time = static_differ().getDateInMsk(tm_rasp)
        seconds = (rasp_time - rzd_time).seconds+(rasp_time - rzd_time).days*day_in_seconds
        # print rzd_time, rasp_time, seconds
        # seconds = rasp_timedelta.seconds - rzd_timedelta.seconds
        # print rzd_code, type(rzd_code)
        if rzd_code in kazTimezones:
            # print 'in', kazTimezones[rzd_code], seconds
            seconds = seconds + kazTimezones[rzd_code]*60*60
            # print seconds
        if calendar.find(u'только') >= 0:
            SecondsDown_ = SecondsDownInChange
        else:
            SecondsDown_ = SecondsDown
        if (seconds <= SecondsUp) and (seconds >= SecondsDown_):
            # print 'ok'
            return True
        # if (seconds + day_in_seconds <= SecondsUp) and (seconds + day_in_seconds >= SecondsDown_):
        #    return True
        # if (seconds - day_in_seconds <= SecondsUp) and (seconds - day_in_seconds >= SecondsDown_):
        #    return True
        # print 'uups'
        return False

    @staticmethod
    def getStationDiff(rzhd_thread, raspThread, calendar=''):
        diff = []
        i = 0
        cursor_j = 0
        rzd_len = 0
        if (rzhd_thread is not None) and (len(rzhd_thread) > 0):
            rzd_len = rzhd_thread.shape[0]
        while (i < rzd_len):
            rzhd_station = rzhd_thread.ix[i, 'station_name']
            rzhd_code = rzhd_thread.ix[i, 'station_code']
            rzhd_esr = rzhd_thread.ix[i, 'esr']
            rzhd_arrival = rzhd_thread.ix[i, 'arrival']
            rzhd_departure = rzhd_thread.ix[i, 'departure']
            rzhd_nostop = rzhd_thread.ix[i, 'no_stop']
            # print rzhd_station, rzhd_esr
            raspPos = static_differ().getStationPos(rzhd_station, rzhd_esr, raspThread, cursor_j)

            if (raspPos == -1):
                diff.append(
                    [rzhd_station, rzhd_code, rzhd_esr, rzhd_arrival, rzhd_departure, rzhd_nostop, '', '', '', '',
                     True])
            else:
                while (cursor_j <= raspPos):
                    rasp_station = raspThread.ix[cursor_j, 'station_name']
                    rasp_esr = raspThread.ix[cursor_j, 'esr']
                    rasp_arrival = raspThread.ix[cursor_j, 'arrival']
                    rasp_departure = raspThread.ix[cursor_j, 'departure']
                    rasp_nostop = raspThread.ix[cursor_j, 'no_stop']
                    if (cursor_j < raspPos):
                        diff.append(['', '', '', '', '', True,
                                     rasp_station, rasp_esr, rasp_arrival, rasp_departure, rasp_nostop])
                    else:
                        diff.append([rzhd_station, rzhd_code, rzhd_esr, rzhd_arrival, rzhd_departure, rzhd_nostop,
                                     rasp_station, rasp_esr, rasp_arrival, rasp_departure, rasp_nostop])
                    cursor_j = cursor_j + 1
            i = i + 1
        if len(raspThread) > 0:
            while cursor_j < raspThread.shape[0]:
                rasp_station = raspThread.ix[cursor_j, 'station_name']
                rasp_esr = raspThread.ix[cursor_j, 'esr']
                rasp_arrival = raspThread.ix[cursor_j, 'arrival']
                rasp_departure = raspThread.ix[cursor_j, 'departure']
                rasp_nostop = raspThread.ix[cursor_j, 'no_stop']
                diff.append(['', '', '', '', '', True,
                             rasp_station, rasp_esr, rasp_arrival, rasp_departure, rasp_nostop])
                cursor_j = cursor_j + 1
        tbl = pd.DataFrame(diff)
        tbl.columns = ['station_name_rzd', 'rzd_code', 'station_code_rzd', 'arrival_rzd', 'departure_rzd',
                       'no_stop_rzd',
                       'station_name_rasp', 'station_code_rasp', 'arrival_rasp', 'departure_rasp', 'no_stop_rasp']
        tbl['correct'] = ''
        for n in range(0, tbl.shape[0]):
            tbl.ix[n, 'correct'] = (tbl.ix[n, 'no_stop_rzd'] == tbl.ix[n, 'no_stop_rasp'])
            if not(tbl.ix[n, 'no_stop_rzd']) and not(tbl.ix[n, 'no_stop_rasp']) and (tbl.ix[n, 'departure_rasp'] != ''):
                # сверяем время отправления
                tbl.ix[n, 'correct'] = static_differ().correctTimeDiff(tbl.ix[n, 'departure_rzd'], str(tbl.ix[n, 'rzd_code']), tbl.ix[n, 'departure_rasp'], calendar)
            if tbl.ix[n, 'station_code_rasp'] in banStationList:
                tbl.ix[n, 'correct'] = True
            if tbl.ix[n, 'station_code_rzd'] in banStationList:
                tbl.ix[n, 'correct'] = True

        return tbl

    @staticmethod
    def getTableForHtml(tbl):
        res = []
        totalCorrect = True
        for n in range(0, tbl.shape[0]):
            station_rzd = tbl.ix[n, 'station_name_rzd']
            if station_rzd is None:
                station_rzd = ''
            if tbl.ix[n, 'rzd_code'] != '':
                station_rzd = station_rzd + ' [' + str(tbl.ix[n, 'rzd_code']) + ']'
            if (tbl.ix[n, 'station_code_rzd'] is not None) and (tbl.ix[n, 'station_code_rzd'] != ''):
                station_rzd = station_rzd + ' (' + tbl.ix[n, 'station_code_rzd'] + ')'
            arrival_rzd = str(tbl.ix[n, 'arrival_rzd'])
            departure_rzd = str(tbl.ix[n, 'departure_rzd'])

            if tbl.ix[n, 'no_stop_rzd']:
                arrival_rzd = '--'
                departure_rzd = '--'

            station_rasp = tbl.ix[n, 'station_name_rasp']
            if tbl.ix[n, 'station_code_rasp'] != '':
                station_rasp = station_rasp + ' (' + tbl.ix[n, 'station_code_rasp'] + ')'

            arrival_rasp = tbl.ix[n, 'arrival_rasp']
            departure_rasp = tbl.ix[n, 'departure_rasp']
            if tbl.ix[n, 'no_stop_rasp']:
                arrival_rasp = '--'
                departure_rasp = '--'

            correct = tbl.ix[n, 'correct']
            if not correct:
                totalCorrect = False
            res.append([station_rzd, arrival_rzd, departure_rzd, station_rasp, arrival_rasp, departure_rasp, correct])

        res = pd.DataFrame(res)
        res.columns = ['station_rzd', 'arrival_rzd', 'departure_rzd', 'station_rasp', 'arrival_rasp', 'departure_rasp',
                       'correct']
        return res, totalCorrect
